<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'oublog', language 'eu', version '4.1'.
 *
 * @package     oublog
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Sentitzen dugu: ez duzu orrialde hau ikusteko sarbiderik.';
$string['accordion_closed'] = 'Itxita';
$string['accordion_open'] = 'Irekita';
$string['activeblogs'] = 'Aktiboa';
$string['addcomment'] = 'Gehitu iruzkina';
$string['addlink'] = 'Gehitu esteka';
$string['addpost'] = 'Gehitu blog-sarrera';
$string['advancedoptions'] = 'Aukera aurreratuak';
$string['afterendcomment'] = 'Ezin duzu mezuetan iruzkinik egin une honetan. Iruzkinak egiteko epea amaitu da {$a} egunean.';
$string['afterendcommentcapable'] = 'Ikasleek sarreretan iruzkinak egin ahal izan zituzten {$a} arte.
<br/> Epe hori igaro ondoren iruzkinak egiteko aukera izango duzu.';
$string['afterendpost'] = 'Ezin duzu sarrerarik sortu une honetan. Mezuak sortzeko epeasarrerarik {$a} egunean amaitu zen.';
$string['afterendpostcapable'] = 'Ikasleek bere sarrerak sortu ahal izan zituzten {$a} arte.
<br/> Epe hori igaro ondoren sarrerak sortzeko baimena izango duzu.';
$string['allowcomments'] = 'Baimendu iruzkinak';
$string['allowcomments_help'] = '&lsquo;Bai, users&rsquo sinatu dutenentzat; sarrera eskuragarri duten erabiltzaileen iruzkinak baimentzen ditu.

&lsquo; Bai everybody&rsquo -entzat; erabiltzaileen eta publiko orokorraren iruzkinak onartzen ditu. Saioa hasi ez duten erabiltzaileen iruzkinak onartu edo baztertzeko mezu elektronikoak jasoko dituzu.

&lsquo;No&rsquo; edonori sarrera honetan iruzkinik egitea eragozten dio.';
$string['allowcommentsmax'] = 'Onartu iruzkinak (sarrera honetarako aukeratuta badago)';
$string['allowimport'] = 'Gaitu sarreren inportazioa';
$string['allowimport_help'] = 'Utzi edozein erabiltzaileri sarbidea duten beste blog jardueretatik orrialdeak inportatzen.';
$string['allowimport_invalid'] = 'Jarduera banakako moduan ezarrita dagoenean bakarrik inporta daitezke argitalpenak.sarrerak';
$string['alpha'] = 'Atik Zra';
$string['atom'] = 'Atom';
$string['atomfeed'] = 'Atom jarioa';
$string['attachments'] = 'Eranskinak';
$string['attachments_help'] = 'Aukeran, fitxategi bat edo gehiago erantsi ditzakezu blog-sarrera batean. Irudi bat eransten baduzu, mezuaren ondoren bistaratuko da.';
$string['beforeendcomment'] = '{$a} arte bakarrik egin ditzakezu iruzkinak sarreretan.';
$string['beforeendcommentcapable'] = 'Ikasleek sarreretan iruzkinak egin ditzakete {$a} arte.
<br/> Epe hori igaro ondoren iruzkinak egiteko aukera izango duzu.';
$string['beforeendpost'] = '{$a} arte bakarrik sor ditzakezu sarrerak.';
$string['beforeendpostcapable'] = 'Ikasleek sarrerak sor ditzakete {$a} arte.
<br/> Epe hori igaro ondoren sarrerak sortzeko baimena izango duzu.';
$string['beforestartcomment'] = 'Une honetan ezin duzu iruzkinik egin sarreretan. Iruzkinak egiteko aukera eskuragarri egongo da {$a} -tik aurrera';
$string['beforestartcommentcapable'] = 'Ikasleek ezin dute sarreretan iruzkinik egin {$a} arte.
<br/>Iruzkinak egiteko aukera izango duzu horren aurretik.';
$string['beforestartpost'] = 'Une honetan ezin duzu sarrerarik sortu. Sarrerak sortzeko aukera {$a} -tik dago eskuragarri.';
$string['beforestartpostcapable'] = 'Ikasleek ezin izango dituzte sarrerak sortu {$a} arte.
<br/> Argitalpenak sortzeko baimena duzu hori baino lehen.';
$string['blogfeed'] = '{$a} jarioak';
$string['bloginfo'] = 'blogaren informazioa';
$string['blogname'] = 'Blogaren izena';
$string['blogoptions'] = 'Blogaren aukerak';
$string['blogsummary'] = 'Blogaren laburpena';
$string['cancel'] = 'Ezeztatu';
$string['comment'] = 'Gehitu zure iruzkina';
$string['commentalert'] = 'Eman iruzkinaren berri';
$string['commentdated'] = 'Datatua';
$string['commentfrom'] = 'Iruzkinak data honetarik aurrera bakarrik onartzen dira';
$string['commentonby'] = 'Iruzkina <u>{$a->title}</u> {$a->date} <u>  {$a->author}</u> -rena';
$string['commentonbyusers'] = 'Iruzkina <u>{$a->commenttitle}</u>  <u>{$a->posttitle}</u>sarreran <br> <u>{$a->author}</u> -rena';
$string['commentposts'] = 'Gehien komentatutako sarrerak';
$string['commentposts_info_alltime'] = 'Iruzkin gehien dituzten sarrerak';
$string['commentposts_info_thismonth'] = 'Azken hilabetean iruzkin gehien jaso dituzten sarrerak';
$string['commentposts_info_thisyear'] = 'Azken urtean iruzkin gehien jaso dituzten argitalpenak';
$string['comments'] = 'Iruzkinak';
$string['comments_info_alltime'] = 'Iruzkin gehien dituzten {$a}ak';
$string['comments_info_thismonth'] = 'Azken hilabetean iruzkin gehien jaso dituzten {$a}ak';
$string['comments_info_thisyear'] = 'Azken urtean iruzkin gehien jaso dituzten {$a}ak';
$string['commentsby'] = 'Iruzkinak {$a}-renak';
$string['commentsfeed'] = 'Iruzkinak soilik';
$string['commentsnotallowed'] = 'Ez dira iruzkinak onartzen';
$string['commentuntil'] = 'Iruzkinak egitea baimenduta dago hona arte';
$string['completioncomments'] = 'Erabiltzaileak iruzkinak egin behar ditu blog-sarreretan:';
$string['completioncommentsgroup'] = 'Eskatu iruzkinak';
$string['completioncommentsgroup_help'] = 'Aukera hau gaitzen baduzu, bloga osatu gisara agertuko da ikasleek zehaztutako iruzkin kopurua utzi ondoren.';
$string['completionposts'] = 'Erabiltzaileak blog-sarrerak egin behar ditu:';
$string['completionpostsgroup'] = 'Eskatu sarrerak';
$string['completionpostsgroup_help'] = 'Aukera hau gaitzen baduzu, bloga osatu gisara agertuko da ikasleek zehaztutako sarrera kopurua egin ondoren.';
$string['computingguide'] = 'OU blogen gida';
$string['computingguideurl'] = 'Informatika gidaren URLa';
$string['computingguideurlexplained'] = 'Sartu OU blogen informatika gidaren URLa';
$string['configmaxattachments'] = 'Blog-sarrera bakoitzeko eranskinen gehienezko kopuru lehenetsia.';
$string['configmaxbytes'] = 'Guneko blog eranskin guztien gehienezko tamaina lehenetsia.
(ikastaro-mugen eta beste tokiko ezarpen batzuen menpe)';
$string['configremoteserver'] = 'Argitalpenak inportatzeko erabiliko den urruneko zerbitzariaren erro helbidea (wwwroot).
Zerbitzari honetako blogak tokiko gunekoez gain erakutsiko dira argitalpenak inportatzean.';
$string['configremotetoken'] = 'Oublog web zerbitzuetarako erabiltzaile tokena urruneko inportazio zerbitzarian.';
$string['confirmdeletecomment'] = 'Ziur zaude iruzkin hau ezabatu nahi duzula?';
$string['confirmdeletelink'] = 'Ziur zaude esteka hau ezabatu nahi duzula?';
$string['confirmdeletepost'] = 'Ziur zaude mezu hau ezabatu nahi duzula?';
$string['contribution'] = 'Parte-hartzea';
$string['contribution_all'] = 'Parte-hartzea - Denbora guztian';
$string['contribution_from'] = 'Parte-hartzea - {$a}-tik aurrera';
$string['contribution_fromto'] = 'Parte-hartzea - {$a->start}-tik {$a->end}-ra';
$string['contribution_to'] = 'Parte-hartzea - {$a}-ra';
$string['copytoself'] = 'Bidali kopia bat zeure buruari';
$string['couldnotaddcomment'] = 'Ezin izan da iruzkina gehitu';
$string['couldnotaddlink'] = 'Ezin izan da esteka gehitu';
$string['defaultpersonalblogname'] = '{$a->name}-ren {$a->displayname}';
$string['delete'] = 'Ezabatu';
$string['deletedblogpost'] = 'Izenbururik gabeko sarrera.';
$string['deletedby'] = 'Ezabatzailea: {$a->fullname}, {$a->timedeleted}';
$string['deleteemailpostdescription'] = 'Hautatu mezua ezabatzeko edo ezabatu eta pertsonaliza daitekeen posta elektroniko bidezko jakinarazpen bat bidali.';
$string['deleteglobalblog'] = 'Ezin duzu blog globala ezabatu';
$string['details'] = 'Xehetasunak';
$string['discovery'] = '{$a} erabilera';
$string['displayname'] = 'Jarduera-izen alternatiboa (hutsik utzita lehenetsia erabiltzen da)';
$string['displayname_default'] = 'blog';
$string['displayname_help'] = 'Ezarri jarduera mota alternatibo baten izena interfazean.

Hutsik uzten baduzu, lehenetsitako izena (\'blog\') erabiliko da.

Izen alternatiboak letra minuskulaz hasi behar du, eta behar den lekuan maiuskulaz idatziko da.';
$string['displayperiod'] = 'Parte-hartze hautatzailea Hasiera datatik - Amaiera datara.';
$string['displayperiod_help'] = '<p>Lehenespenez sarrera guztiak hautatzen dira.</p>
<p>\'From\' data bat hauta dezakezu gaur arteko sarrerentzat.</p>
<p>\'From\' data baten eta \'To\' data baten arteko sarrera guztiak hauta ditzakezu.</p>
<p>Edo lehenengo sarreratik \'To\' data bat hauta dezakezu.</p>';
$string['displayversion'] = 'OU blogaren bertsioa: <strong>{$a}</strong>';
$string['downloadas'] = 'Deskargatu datuak honela';
$string['downloadcsv'] = 'Komaz bereizitako balioen testu-fitxategia';
$string['edit'] = 'Editatu';
$string['editlink'] = 'Editatu esteka';
$string['editonsummary'] = 'Editatua {$a->editdate}';
$string['editpost'] = 'Eguneratu sarrera';
$string['editsummary'] = '{$a->editby}-k editatua, {$a->editdate}';
$string['emailcontenthtml'] = 'Jakinarazpen hau {$a->activityname}, xehetasun hauek dituen, zure argitalpena \'{$a->firstname} {$a->lastname}\' egileak ezabatu duela jakinarazteko da:<br />
<br />
Gaia: {$a->subject}<br />
{$a->activityname}: {$a->blog}<br />
Ikastaroa: {$a->course<br />
<br />
<a href={$a->deleteurl} title="ezabatutako argitalpena ikusi">Ezabatutako argitalpena ikusi</a>';
$string['emailerror'] = 'Errore bat gertatu da mezu elektronikoa bidaltzean';
$string['emailmessage'] = 'Mezua';
$string['end'] = 'Hona arte';
$string['error_alreadyapproved'] = 'Dagoeneko onartu edo baztertutako iruzkina';
$string['error_grouppubliccomments'] = 'Ezin dituzu iruzkin publikoak onartu bloga talde moduan dagoenean';
$string['error_moderatednotallowed'] = 'Iruzkin moderatuak ez dira onartzen blog edo blog-sarrera honetan.';
$string['error_noconfirm'] = 'Idatzi goiko testu lodia, zehazki emandako moduan, lauki honetan.';
$string['error_toomanycomments'] = 'Azken orduan blog iruzkin gehiegi egin dituzu internet helbide honetatik. Itxaron pixka bat eta saiatu berriro.';
$string['error_unspecified'] = 'Sistemak ezin du eskaera hau osatu errore bat gertatu delako ({$a})';
$string['error_wrongkey'] = 'Iruzkinen gako okerra';
$string['event:commentapproved'] = 'Iruzkina onartu da';
$string['event:commentcreated'] = 'Iruzkina sortu da';
$string['event:commentdeleted'] = 'Iruzkina ezabatu da';
$string['event:participationviewed'] = 'Parte-hartzea ikusita';
$string['event:postcreated'] = 'Sarrera sortu da';
$string['event:postdeleted'] = 'Sarrera ezabatu da';
$string['event:postimported'] = 'Sarrera inportatu da';
$string['event:postupdated'] = 'Sarrera eguneratu da';
$string['event:postviewed'] = 'Sarrera ikusita';
$string['event:savefailed'] = 'Saioak huts egin du sarrera gorde ondoren';
$string['event:siteentriesviewed'] = 'Guneko sarrerak ikusi dira';
$string['export:description'] = 'Beheko estekak erabiliz zure lineako moduluko edukitik blog-sarrera indibidualak esporta ditzakezu.
Bestela, hautatu hainbat sarrera, esportazio mota eta egin klik \'Esportatu\' aukeran guztiak batera deskargatzeko.';
$string['export:header'] = 'Esportatu';
$string['export:header_author'] = 'Egilea';
$string['export:header_date_posted'] = 'Argitaratu den data';
$string['export:header_tags'] = 'Etiketak';
$string['export:header_title'] = 'Izenburua';
$string['export:title'] = 'Esportatu';
$string['export:type'] = 'Esportazio-mota';
$string['exportedpost'] = 'Esportatutako sarrera';
$string['exportpostscomments'] = 'une honetan ikusgai dauden sarrera guztiak eta haien iruzkinak.';
$string['exportuntitledpost'] = 'Izenbururik gabeko sarrera';
$string['externaldashboardadd'] = 'Gehitu bloga panelean';
$string['externaldashboardremove'] = 'Kendu bloga paneletik';
$string['extra_emails'] = 'Beste hartzaileen helbide elektronikoak';
$string['extra_emails_help'] = 'Sartu helbide elektroniko bat edo gehiago, hutsune edo puntu eta komaz bereizita.';
$string['extranavolderposts'] = 'Mezu zaharragoak: {$a->from}-{$a->to}';
$string['extranavtag'] = 'Iragazkia: {$a}';
$string['feedhelp'] = 'Jarioak';
$string['feedhelp_help'] = 'Jarioak erabiltzen badituzu, Atom edo RSS esteka hauek gehi ditzakezu argitalpenen berri izateko.
Jario irakurgailu gehienek Atom eta RSS onartzen dituzte.

Iruzkinak gaituta badaude, "Iruzkinak soilik" jarioak ere badaude.';
$string['feeds'] = 'Jarioak';
$string['feedsnotenabled'] = 'Jarioak ez daude gaituta';
$string['filter'] = 'Filtroa:';
$string['filter-tooltip'] = 'Egin klik iragazkiaren etiketa kentzeko';
$string['foruser'] = '{$a}-rentzat';
$string['globalblogmissing'] = 'Blog globala falta da';
$string['globalusageexclude'] = 'Utzi erabilera globalen estatistiketatik kanpo';
$string['globalusageexclude_desc'] = 'Komaz bereizitako erabiltzaile-IDen zerrenda erabiltzaileak blog globalerako erabilera-estatistiken zerrenda nagusitik  kanpoan uzteko';
$string['gradesupdated'] = 'Kalifikazioak eguneratu dira';
$string['grading'] = 'Kalifikazioa';
$string['grading_help'] = 'Aukera hau hautatzen baduzu, blog honen kalifikazioa gehituko da ikastaroaren kalifikazio-liburuan eta automatikoki kalkulatuko da.
Utzi hau desaktibatuta ebaluatu gabeko blog batentzat edo eskuz ebaluatu nahi duzun batentzat.';
$string['grading_invalid'] = 'Kalifikazio mota edo balorazio mota ezarrita dagoenean bakarrik kalifikatu daitezke argitalpenak.';
$string['group'] = 'Taldea';
$string['guestblog'] = 'Sisteman kontu bat baduzu, mesedez, <a href=\'{$a}\'>hasi saioa sarbide osoa izateko</a>.';
$string['import'] = 'Inportatu';
$string['import_notallowed'] = 'Sarrerak inportatzea desgaituta dago {$a} -rako.';
$string['import_step0_blog'] = 'Inportatu bloga';
$string['import_step0_inst'] = 'Beheko blogen zerrendatik, blog osoa edo hautatutako sarrerak inporta ditzakezu.';
$string['import_step0_nonefound'] = 'Ez duzu sarbiderik sarrerak inporta daitezkeen jardueretarako.';
$string['import_step0_selected_posts'] = 'Inportatu aukeratutako sarrerak';
$string['import_step1_addtag'] = 'Iragazi etiketaren arabera - {$a}';
$string['import_step1_all'] = 'Aukeratu guztia';
$string['import_step1_from'] = 'Inportatu hemendik:';
$string['import_step1_include_label'] = 'Inportatu sarrera - {$a}';
$string['import_step1_inst'] = 'Aukeratu sarrerak inportatzeko:';
$string['import_step1_none'] = 'Hautatu bat ere ez';
$string['import_step1_removetag'] = 'Kendu etiketa-iragazkia - {$a}';
$string['import_step1_submit'] = 'Inportatu';
$string['import_step1_table_include'] = 'Sartu inportazioan';
$string['import_step1_table_posted'] = 'Argitaratu den data';
$string['import_step1_table_tags'] = 'Etiketak';
$string['import_step1_table_title'] = 'Izenburua';
$string['import_step2_cancel_submit'] = 'Ez inportatu bikoiztutako sarrerak';
$string['import_step2_conflicts'] = '{$a} argitalpen(a) inportatu d(ir)a lehenago. Argitalpenak berriro inportatu nahi badituzu, hautatu \'inportatu argitalpen bikoiztuak\' eta beste kopia bat gehituko zaio zure blogari.';
$string['import_step2_conflicts_submit'] = 'Inportatu bikoiztutako sarrerak';
$string['import_step2_inst'] = 'Sarrerak inportatzen:';
$string['import_step2_none'] = 'Ez da sarrerarik hautatu inportatzeko';
$string['import_step2_prog'] = 'Inportazioa abian da';
$string['import_step2_total'] = '{$a} sarrera(k) arrakastaz inportatu dira';
$string['includepost'] = 'Sartu mezua';
$string['individualblogs'] = 'Norbanakoaren blogak';
$string['individualblogs_help'] = '<p><strong>Ez (bloga elkarrekin edo taldean)</strong>: <em>Banakako blogak ez dira erabiltzen</em>&ndash;
Ez dago banakako blogik ezarrita, denak komunitate handiago baten parte dira
(\'Group mode\' ezarpenaren arabera).</p>
<p><strong>Bereizi norbanakoaren blogak</strong>: <em>Norbanakoaren blogak modu pribatuan erabiltzen dira</em>&ndash;
Norbanakoek beren blogetan bakarrik argitaratu eta ikusi ahal izango dituzte, beste blog batzuk ikusteko baimena ("viewindividual") ez badute behintzat.</p>
<p><strong>Norbanakoen blogak ikusgai</strong>: <em>Norbanakoen blogak publikoki erabiltzen dira</em> &ndash;
norbanakoek bere blogetan bakarrik argitaratu ahal izango dute, baina beste norbanakoen blog argitalpenak ikus ditzakete.</p>';
$string['info'] = 'Hautatutako epeari dagokion parte hartzea.';
$string['introonpost'] = 'Erakutsi sarrera argitaratzean';
$string['invalidblog'] = 'Blogaren ID baliogabea';
$string['invalidblogdetails'] = 'Ezin da {$a} blog-sarreraren xehetasunik aurkitu';
$string['invalidblogtags'] = 'Blog-etiketa baliogabeak';
$string['invalidcomment'] = 'Iruzkinaren ID baliogabea';
$string['invalidedit'] = 'Edizio ID baliogabea';
$string['invalidformat'] = 'Formatua atom edo rss izan behar da';
$string['invalidlink'] = 'Esteka Id baliogabea';
$string['invalidpost'] = 'Sarrera Id baliogabea';
$string['invalidpostid'] = 'Sarrera Id baliogabea';
$string['invalidvisbilitylevel'] = 'Baliogabeko ikusgarritasun maila {$a}';
$string['invalidvisibility'] = 'Ikusgarritasun maila baliogabea';
$string['lastcomment'] = '({$a->fullname}-ren azken iruzkina, {$a->timeposted})';
$string['lastmodified'] = 'Azken sarrera: {$a}';
$string['limits'] = 'Ekarpen-epea';
$string['links'] = 'Erlazionatutako estekak';
$string['logincomments'] = 'Bai, saioa hasi duten erabiltzaileenak';
$string['maxattachments'] = 'Gehienezko eranskin kopurua';
$string['maxattachments_help'] = 'Ezarpen honek blog-sarrera bati erantsi dakizkiokeen gehienezko fitxategi kopurua zehazten du.';
$string['maxattachmentsize'] = 'Gehienezko eranskinaren tamaina';
$string['maxattachmentsize_help'] = 'Ezarpen honek blog-sarrera batean erabil daitekeen irudi/fitxategiaren tamaina handiena zehazten du.';
$string['maxvisibility'] = 'Ikusgarritasun handiena';
$string['maxvisibility_help'] = '<p><em>Blog pertsonal batean:</em> <strong>Blogaren jabearentzat bakarrik ikusgai (pribatua)</strong>&ndash;
inork* ezin du mezu hau ikusi.</p>
<p><em>Ikastaro bateko blog batean:</em> <strong>Ikastaro honetako parte-hartzaileentzat ikusgai</strong> &ndash; mezua ikusteko,
blogerako sarbidea izan behar duzu, normalean hura duen ikastaroan matrikulatuta egonez gero.</p>

<p><strong>Sisteman saioa hasita duen edonork ikusgai</strong> &ndash;
saioa hasita duen edonork ikus dezake mezua,
nahiz eta ikastaro zehatz batean matrikulatuta ez egon.</p>
<p><strong>Edonorentzat ikusgai</strong> &ndash;
Interneteko edozein erabiltzailek ikus dezake mezu hau
blogaren helbidea ematen badiozu.</p>

<p>Aukera hau blog osoan eta banakako mezuetan dago.
Aukera blog osoan ezarrita badago, muga bihurtzen da. Adibidez, blog osoa lehen mailan badago, ezin duzu argitalpen bakoitzaren maila aldatu.</p>';
$string['maybehiddenposts'] = '{$a->name} honek saioa hasi duten erabiltzaileek bakarrik ikus ditzaketen mezuak izan ditzake, edo saioa hasi duten erabiltzaileek bakarrik iruzkindu ditzaketenak. Sisteman kontu bat baduzu, mesedez <a href=\'{$a->link}\'>hasi saioa sarbide osoa izateko</a>.';
$string['message'] = 'Mezua';
$string['moderated_addedcomment'] = 'Eskerrik asko zure iruzkina gehitzeagatik, behar bezala jaso da. Zure iruzkina ez da agertuko mezu honen egileak onartu arte.';
$string['moderated_approve'] = 'Onartu iruzkin hau';
$string['moderated_authorname'] = 'Zure izena';
$string['moderated_awaiting'] = 'Onarpenaren zain dauden iruzkinak';
$string['moderated_awaitingnote'] = 'Iruzkin hauek ez dira beste erabiltzaileentzat ikusgai egongo zuk onartu arte. Kontuan izan sistemak ez duela iruzkingileen nortasuna ezagutzen eta iruzkinek estekak izan ditzaketela, eta hauek jarraituz gero, zure ordenagailua larriki kaltetu dezaketela. Zalantzarik baduzu, mesedez, baztertu iruzkinak estekarik sakatu gabe.';
$string['moderated_confirm'] = 'Berrespena';
$string['moderated_confirminfo'] = 'Mesedez, idatzi <strong>bai</strong> behean pertsona zarela baieztatzeko.';
$string['moderated_confirmvalue'] = 'bai';
$string['moderated_emailhtml'] = '<p>(Hau automatikoki sortutako mezu elektroniko bat da. Mesedez, ez erantzun.)</p>
<p>Norbaitek iruzkin bat gehitu du zure blog argitalpenean: {$a->postlink</p>
<p>Iruzkina <strong>onartu</strong> behar duzu publikoki agertu aurretik.</p>
<p>Sistemak ez daki iruzkingilearen nortasuna eta iruzkinek estekak izan ditzakete, eta hauek jarraituz gero, zure ordenagailuari kalte larria eragin diezaiokete. Zalantzarik baduzu, mesedez, baztertu iruzkina
<strong>estekarik jarraitu gabe</strong>.</p>
<p>Iruzkina onartzen baduzu, argitaratzearen ardura hartzen duzu. Ziurtatu arauen aurkako ezer ez duela.</p>
<hr/>
<p>Emandako izena: {$a->commenter}</p>
<hr/>
<h3>{$a->commenttitle}</h3>
{$a->comment}
<hr/>
<ul class=\'oublog-approvereject\'>
<li><a href=\'{$a->approvelink}\'>{$a->approvetext}</a></li>
<li><a href=\'{$a->rejectlink}\'>{$a->rejecttext}</a></li>
</ul>
<p>
Mezu elektroniko hau ere baztertu dezakezu. Iruzkina automatikoki baztertuko da
30 egun igaro ondoren.
</p>
<p>
Mezu elektroniko horietako gehiegi jasotzen badituzu, komentatzea mugatu nahi izango duzu
saioa hasi duten erabiltzaileentzat soilik.
</p>
<ul class=\'oublog-restrict\'>
<li><a href=\'{$a->restrictpostlink}\'>{$a->restrictposttext}</a></li>
<li><a href=\'{$a->restrictbloglink}\'>{$a->restrictblogtext}</a></li>
</ul>';
$string['moderated_emailsubject'] = 'Iruzkina onarpenaren zain dago hemen: {$a->blog} ({$a->commenter})';
$string['moderated_emailtext'] = 'Automatikoki sortutako mezu elektroniko bat da hau. Mesedez, ez erantzun.

Norbaitek iruzkin bat gehitu du zure blog argitalpenean:
{$a->postlink}

Iruzkina onartu behar duzu publikoki agertu aurretik.

Sistemak ez daki iruzkingilearen nortasuna eta iruzkinek estekak izan ditzakete, eta hauek jarraituz gero, zure ordenagailuari kalte larriak egin diezazkiokete.
Zalantzarik baduzu, mesedez, baztertu iruzkina estekarik jarraitu gabe.

Iruzkina onartzen baduzu, argitaratzearen ardura hartzen duzu. Ziurtatu arauen aurkako ezer ez duela.

-----------------------------------------------------------------------
Emandako izena: {$a->commenter}
------------------------------------------------------------------------
{$a->commenttitle}
{$a->comment}
-----------------------------------------------------------------------

* {$a->approvetext}:
{$a->approvelink}

* {$a->rejecttext}:
{$a->rejectlink}

Mezu elektroniko hau ere baztertu dezakezu. Iruzkina automatikoki baztertuko da
30 egun igaro ondoren.

Mezu elektroniko horietako gehiegi jasotzen badituzu, komentatzea saioa hasi duten erabiltzaileentzat soilik mugatu nahi izango duzu.

* {$a->restrictposttext}:
{$a->restrictpostlink}

* {$a->restrictblogtext}:
{$a->restrictbloglink}';
$string['moderated_info'] = 'Saioa hasi ez duzunez, zure iruzkina onartu ondoren bakarrik agertuko da. Sisteman kontu bat baduzu, <a href=\'{$a}\'>hasi saioa blogerako sarbide osoa izateko</a>.';
$string['moderated_postername'] = '<strong>{$a}</strong> izena erabiliz';
$string['moderated_reject'] = 'Baztertu iruzkin hau';
$string['moderated_rejectedon'] = 'Baztertua {$a}:';
$string['moderated_restrictblog'] = 'Mugatu blog honetako zure argitalpen guztietan iruzkinak egitea';
$string['moderated_restrictblog_info'] = 'Blog honetako zure argitalpen guztietan iruzkinak mugatu nahi dituzu, sisteman saioa hasita duten pertsonek bakarrik egin ditzaten iruzkinak?';
$string['moderated_restrictpage'] = 'Mugatu iruzkinak egitea';
$string['moderated_restrictpost'] = 'Mugatu mezu honetan iruzkinak egitea';
$string['moderated_restrictpost_info'] = 'Mugatu nahi dituzu mezu honetako iruzkinak sisteman saioa hasita duten pertsonek bakarrik egin ditzaten iruzkinak?';
$string['moderated_submitted'] = 'Moderazioaren zain';
$string['moderated_typicaltime'] = 'Iraganean, honek normalean {$a} inguru behar izan du.';
$string['modulename'] = 'OU blog';
$string['modulename_help'] = 'Honi esker, modulu baten barruan blogak sortu daitezke (Moodle blog sistema nagusitik bereizita daudenak). Modulu osoko blogak izan ditzakezu (moduluko guztiek blog berean argitaratzen dute), taldeko blogak edo banakako blogak. Blog jardueraren izena aldatu daiteke bere helburua islatzeko, adibidez, Ikaskuntza Erregistroa.';
$string['modulenameplural'] = 'OU blogak';
$string['mostcomments'] = 'Iruzkin gehienak';
$string['mostposts'] = 'Sarrera gehienak';
$string['mustprovidepost'] = 'Postid-a eman behar da';
$string['myparticipation'] = 'Nire partaidetzaren laburpena';
$string['ncomments'] = '{$a} iruzkin';
$string['newblogposts'] = 'Blog-sarrera berriak';
$string['newcomment'] = 'Iruzkin berria';
$string['newerposts'] = 'Sarrera berriagoak';
$string['newpost'] = '{$a} sarrera berria';
$string['no'] = 'Ez';
$string['no_blogtogetheroringroups'] = 'Ez (elkarrekin edo taldeka bloga idatzi)';
$string['noblogposts'] = 'Ez dago blog-sarrerarik';
$string['nocomments'] = 'Iruzkinak ez dira onartzen';
$string['nograde'] = 'Kalifikaziorik gabe (lehenetsia)';
$string['noposts'] = 'Ez dago sarrerarik ikusgai {$a} honetan.';
$string['nopostsnotags'] = 'Ez dago ikusgai dagoen argitalpenik {$a->blog} honetan, {$a->tag} etiketa honetarako.';
$string['notaddpost'] = 'Ezin izan da sarrera gehitu';
$string['notaddpostnogroup'] = 'Ezin da mezua gehitu talderik gabe';
$string['nousercommentpartsfound'] = 'Ez da iruzkinik gehitu aldi honetan.';
$string['nousercomments'] = 'Ez da iruzkinik egin.';
$string['nousercommentsfound'] = 'Ez da iruzkinik egin aldi honetan.';
$string['nousergrade'] = 'Erabiltzailearen kalifikazioa ez dago eskuragarri.';
$string['nouserpostpartsfound'] = 'Ez da sarrerarik gehitu aldi honetan.';
$string['nouserposts'] = 'Ez da sarrerarik gehitu';
$string['nouserpostsfound'] = 'Ez da sarrerarik gehitu aldi honetan.';
$string['npending'] = '{$a} iruzkin onarpenaren zain';
$string['npendingafter'] = ', {$a} onarpenaren zain';
$string['numbercomments'] = '{$a} iruzkin';
$string['numbercommentsmore'] = 'Gehi beste {$a} iruzkin';
$string['numberofposts'] = 'Sarrera kopurua orrialdeko';
$string['numberofposts_help'] = 'Ezarri blog bateko orrialde bakoitzean bistaratuko den sarrera kopurua.';
$string['numberposts'] = '{$a} sarrera';
$string['numberpostsmore'] = 'Gehi {$a} argitalpen gehiago';
$string['numberviews'] = '{$a} ikustaldi';
$string['numposts'] = '{$a} sarrera';
$string['official'] = 'Ezarri';
$string['olderposts'] = 'Aurreko sarrerak';
$string['onecomment'] = '{$a} iruzkin';
$string['onepending'] = '{$a} iruzkin onarpenaren zain daude';
$string['onependingafter'] = ', {$a} onarpenaren zain';
$string['onlyworkspersonal'] = 'Norbanakoen blogetarako bakarrik balio du';
$string['order'] = 'Eskaera:';
$string['order_help'] = 'Erabiltzen diren etiketen zerrenda bistaratzeko ordena aukera dezakezu,
bai ordena alfabetikoan bai erabilitako argitalpen kopuruaren arabera.
Hautatu bi estekak ordenatzeko metodoen artean aldatzeko,
aukera hau gogoratuko da eta ondorengo ikustaldietan erabiliko da.';
$string['oublog'] = 'OU bloga';
$string['oublog:addinstance'] = 'Gehitu Ou blog berria';
$string['oublog:audit'] = 'Ikusi ezabatutako argitalpenak eta bertsio zaharrak';
$string['oublog:comment'] = 'Iruzkinak sarrera batean';
$string['oublog:contributepersonal'] = 'Sarrerak eta iruzkinak egin norbanakoen blogetan';
$string['oublog:exportownpost'] = 'Esportatu zure sarrera';
$string['oublog:exportpost'] = 'Esportatu sarrera';
$string['oublog:exportposts'] = 'Esportatu sarrerak';
$string['oublog:grade'] = 'Kalifikatu OU blogaren erabiltzaileen parte-hartzea';
$string['oublog:ignorecommentperiod'] = 'Ez egin kasurik iruzkinen denbora-tarteari';
$string['oublog:ignorepostperiod'] = 'Ez egin kasurik sarreren denbora-tarteari';
$string['oublog:managecomments'] = 'Kudeatu iruzkinak';
$string['oublog:managelinks'] = 'Kudeatu estekak';
$string['oublog:manageposts'] = 'Kudeatu sarrerak';
$string['oublog:post'] = 'Sortu sarrera berria';
$string['oublog:rate'] = 'Sarrerak balora daitezke..';
$string['oublog:view'] = 'Ikusi sarrerak';
$string['oublog:viewallratings'] = 'Ikusi norbanakoek emandako balorazio gordin guztiak';
$string['oublog:viewanyrating'] = 'Ikusi edonork jasotako balorazio guztiak';
$string['oublog:viewindividual'] = 'Ikusi norbanakoen blogak';
$string['oublog:viewparticipation'] = 'Ikusi OU Blogeko erabiltzaileen parte-hartzea';
$string['oublog:viewpersonal'] = 'Ikusi blog pertsonaletako argitalpenak';
$string['oublog:viewprivate'] = 'Ikusi blog pertsonaletako argitalpen pribatuak';
$string['oublog:viewrating'] = 'Ikusi jaso duzun balorazioa guztira';
$string['oublog_managealerts'] = 'Kudeatu salatutako argitalpen/iruzkinen alertak';
$string['oublogallpostslogin'] = 'Behartu sarrera guztietan saioa hastera';
$string['oublogallpostslogin_desc'] = 'Behartu saioa hastera blog pertsonalaren guneko sarreren orrialdean.
Gaituta dagoenean, saioa hasi duten erabiltzaileek bakarrik ikusiko dute orrialde honetarako esteka.';
$string['oublogcrontask'] = 'OU blogaren mantentze-lanak';
$string['oublogintro'] = 'Sarrera';
$string['overviewnumentrylog'] = 'sarrerak azken saioa hasi zenetik';
$string['overviewnumentrylog1'] = 'sarrera azken saioa hasi zenetik';
$string['overviewnumentryvw'] = 'sarrerak azkenekoz ikusi zenetik';
$string['overviewnumentryvw1'] = 'sarrera azkenekoz ikusi zenetik';
$string['participation'] = 'Parte-hartzea';
$string['participation_all'] = 'Parte hartzea - Denbora guztian';
$string['participation_from'] = 'Parte-hartzea - {$a}-tik aurrera';
$string['participation_fromto'] = 'Parte-hartzea - {$a->start}-tik {$a->end}-ra';
$string['participation_to'] = 'Parte-hartzea - {$a}-ra';
$string['participationbyuser'] = 'Erabiltzailearen parte-hartzea';
$string['permalink'] = 'Esteka iraunkorra';
$string['personalblognotsetup'] = 'Norbanakoen blogak ez daude konfiguratuta';
$string['personalblogtitle'] = 'Norbanakoren bloga';
$string['pluginadministration'] = 'OU Blogaren administrazioa';
$string['pluginname'] = 'OU Blog';
$string['postalert'] = 'Salatu sarrera';
$string['postauthor'] = 'Sarreraren egilea';
$string['postdate'] = 'Sarreraren data';
$string['postdetail'] = 'Sarreraren xehetasunak';
$string['postedby'] = '{$a}-k idatzia';
$string['postedbymoderated'] = '{$a->commenter}-ek idatzia ({$a->approver}-ek onartua, {$a->approvedate})';
$string['postedbymoderatedaudit'] = '{$a->commenter}-ek idatzia [{$a->ip}] ({$a->approver}-ek onartua, {$a->approvedate})';
$string['postfrom'] = 'Hemengo argitalpenak bakarrik Baimenduta daude';
$string['postmessage'] = 'Sarrera';
$string['posts'] = 'Sarrerak';
$string['posts_info_alltime'] = 'Mezu gehien dituzten {$a}ak';
$string['posts_info_thismonth'] = 'Azken hilabetean mezu gehien izan dituzten {$a}ak';
$string['posts_info_thisyear'] = 'Azken urtean argitalpen gehien izan dituzten {$a}ak';
$string['postsby'] = '{$a}-ren argitalpenak';
$string['posttime'] = 'Sarreraren ordua';
$string['posttitle'] = 'Sarreraren izenburua';
$string['postuntil'] = 'Sarrerak egitea baimenduta dago bakarrik ordura arte';
$string['predefinedtags'] = 'Aurrez zehaztutako etiketak';
$string['predefinedtags_help'] = 'Eman erabiltzaileei etiketak aukeran sarrera batean etiketa bat jartzerakoan.
Etiketak komaz bereizita egon behar dira.';
$string['privacy:metadata:core_rating'] = 'Blog sarreretan gehitutako balorazioak core_rating sistema erabiliz gordetzen dira';
$string['privacy:metadata:oublog_comments'] = 'OU blog-sarrera bati buruzko iruzkinak.';
$string['privacy:metadata:oublog_comments:authorip'] = 'Iruzkin moderatuetarako: egilearen IP helbidea (beharrezkoa).';
$string['privacy:metadata:oublog_comments:authorname'] = 'Iruzkin moderatuetarako: egilearen izena (beharrezkoa).';
$string['privacy:metadata:oublog_comments:message'] = 'Iruzkinaren xehetasuna.';
$string['privacy:metadata:oublog_comments:title'] = 'Iruzkinaren izenburua.';
$string['privacy:metadata:oublog_comments:userid'] = 'Iruzkinaren sortzailearen erabiltzaile IDa.';
$string['privacy:metadata:oublog_comments_moderated'] = 'OU blogeko argitalpenen iruzkinak moderaziorako.';
$string['privacy:metadata:oublog_comments_moderated:authorip'] = 'Egilearen IP helbidea (beharrezkoa).';
$string['privacy:metadata:oublog_comments_moderated:authorname'] = 'Egilearen izena (beharrezkoa).';
$string['privacy:metadata:oublog_comments_moderated:message'] = 'Iruzkinaren xehetasunak.';
$string['privacy:metadata:oublog_comments_moderated:postid'] = 'Iruzkina dagoen argitalpenaren IDa.';
$string['privacy:metadata:oublog_comments_moderated:title'] = 'Iruzkinaren izenburua.';
$string['privacy:metadata:oublog_edits'] = 'OU blogaren edizioak (aurreko OU blog argitalpenen bertsioak gordetzen ditu).';
$string['privacy:metadata:oublog_edits:oldmessage'] = 'OU blog argitalpenaren aurreko edukia.';
$string['privacy:metadata:oublog_edits:oldtitle'] = 'OU blog argitalpenaren aurreko izenburua.';
$string['privacy:metadata:oublog_edits:userid'] = 'OU blog argitalpenen editorearen erabiltzaile IDa.';
$string['privacy:metadata:oublog_instances'] = 'Norbanakoaren OU  blog baten instantziak.';
$string['privacy:metadata:oublog_instances:name'] = 'OU blog instantziaren izena.';
$string['privacy:metadata:oublog_instances:summary'] = 'OU blog instantzien laburpena.';
$string['privacy:metadata:oublog_instances:userid'] = 'OU blog instantziaren jabearen erabiltzaile IDa.';
$string['privacy:metadata:oublog_posts'] = 'OU blog bateko sarrerak.';
$string['privacy:metadata:oublog_posts:deletedby'] = 'Blog-sarrera hau ezabatu duen erabiltzailea (ezabatu bada).';
$string['privacy:metadata:oublog_posts:lasteditedby'] = 'OU blog-sarrera azkenekoz editatu duen erabiltzailea (editatu bada).';
$string['privacy:metadata:oublog_posts:message'] = 'OU blogeko sarreraren testua.';
$string['privacy:metadata:oublog_posts:title'] = 'OU blogeko sarreraren izenburua.';
$string['privacy:metadata:oublog_taginstances'] = 'OU blog etiketen instantziak.';
$string['privacy:metadata:oublog_taginstances:oubloginstancesid'] = 'OU blogeko instantzia etiketa honekin lotuta dago';
$string['privacy:metadata:oublog_taginstances:postid'] = 'OU blogeko sarrera etiketa honekin lotuta dago';
$string['privacy:metadata:oublog_taginstances:tagid'] = 'Benetako etiketaren identifikatzailea.';
$string['privacy:metadata:oublog_tags'] = 'OU blogeko sarrerekin lotutako etiketak.';
$string['privacy:metadata:oublog_tags:tag'] = 'OU blogeko sarreren etiketa.';
$string['privacy:metadata:preference:mod_oublog_commentformfilter'] = 'Iruzkinen estatistikak guztiak/hilabetekoak/urtekoak erakutsi ala ez.';
$string['privacy:metadata:preference:mod_oublog_commentpostformfilter'] = 'Gehien komentatutako argitalpenen estatistikak guztiak/hilabetekoak/urtekoak erakutsi ala ez.';
$string['privacy:metadata:preference:mod_oublog_hidestatsform_comment'] = 'Iruzkinen estatistikak ezkutatu ala ez.';
$string['privacy:metadata:preference:mod_oublog_hidestatsform_commentpost'] = 'Gehien komentatutako argitalpenen estatistikak ezkutatu ala ez.';
$string['privacy:metadata:preference:mod_oublog_hidestatsform_post'] = 'Mezuen estatistikak ezkutatu ala ez.';
$string['privacy:metadata:preference:mod_oublog_hidestatsform_visit'] = 'Bisiten estatistikak ezkutatu ala ez.';
$string['privacy:metadata:preference:mod_oublog_postformfilter'] = 'Mezuen estatistikak guztiak/hilabetekoak/urtekoak erakutsi ala ez.';
$string['privacy:metadata:preference:mod_oublog_visitformfilter'] = 'Bisiten estatistikak guztiak/hilabetekoak/urtekoak erakutsi ala ez.';
$string['privacy:metadata:preference:oublog_accordion_allposts_open'] = 'Zein panel ikusten da estatistiken bistaratzearekin (argitalpen guztiak ikusteko orria).';
$string['privacy:metadata:preference:oublog_accordion_view_open'] = 'Zein panel ikusten da estatistiken bistaratzearekin (blogaren ikuspegi orri normala).';
$string['privacy:metadata:preference:oublog_tagorder'] = 'Etiketak bistaratzeko aukeratu duzun ordena.';
$string['privacy_commentnumber'] = 'Iruzkina {$a}';
$string['privacy_commentplaceholder'] = '(Erabiltzailearen eskariz ezabatutako iruzkina)';
$string['privacy_editnumber'] = 'Editatu {$a}';
$string['privacy_somebodyelse'] = 'Beste norbait';
$string['privacy_you'] = 'Zu';
$string['publiccomments'] = 'Bai, guztiontzat (saioa hasi ez baduzu ere)';
$string['publiccomments_info'] = 'Norbaitek iruzkin bat gehitzen badu saioa hasi gabe, posta elektroniko bidezko jakinarazpena jasoko duzu eta iruzkina bistaratzea onartu edo baztertu ahal izango duzu. Hau beharrezkoa da spama saihesteko.';
$string['recentcomments'] = 'Azken iruzkinak';
$string['recentposts'] = 'Azken sarrerak';
$string['remoteserver'] = 'Inportatu urruneko zerbitzaritik';
$string['remotetoken'] = 'Inportatu urruneko zerbitzariaren tokena';
$string['removeblogs'] = 'Kendu blogeko sarrera guztiak';
$string['reportingemail'] = 'Helbide elektronikoen txostenak';
$string['reportingemail_help'] = 'Ezarpen honek OU Blog-eko sarreren edo iruzkinen arazoak jakinaraziko zaizkien pertsonen helbide elektronikoak zehazten ditu.
Komaz bereizitako zerrenda gisa sartu behar dira.';
$string['restricttags'] = 'Etiketen aukerak';
$string['restricttags_help'] = 'Aukera hau hautatzen baduzu, jarduera-mailan aurrez definituta dauden etiketa-sarrera mugatu dezakezu eta/edo sarrera batean gutxienez etiketa bat sartzea eskatzen dutenetara ekarri.';
$string['restricttagslist'] = '\'Set\' etiketak bakarrik sar ditzakezu: {$a}';
$string['restricttagsvalidation'] = '\'Set\' etiketak bakarrik sar daitezke';
$string['rssfeed'] = 'RSS jarioa';
$string['savefailtitle'] = 'Argitalpena ezin da gorde';
$string['savegrades'] = 'Gorde kalifikazioak';
$string['search:activity'] = 'OU bloga - jardueraren informazioa';
$string['search:comments'] = 'OU bloga - argitalpenen iruzkinak';
$string['search:post'] = 'OU bloga - sarrerak';
$string['searchthisblog'] = 'Bilatu hau {$a}';
$string['sendanddelete'] = 'Bidali eta ezabatu';
$string['separateindividual'] = 'Norbanakoenak bereizi';
$string['separateindividualblogs'] = 'Norbanakoen blogak bereizi';
$string['share'] = 'Partekatu sarrera';
$string['sharedblog'] = 'Partekatutako bloga';
$string['sharedblog_error'] = 'Errorea – ez dago ID hori duen blogik eskuragarri';
$string['sharedblog_existed'] = 'Haur blog baten ID zenbakia da hau.';
$string['sharedblog_help'] = '<p><strong>Bloga partekatua</strong></p>
<p>Aukera honek blog instantziari \'haur\' blog gisa jardutea eta \'guraso\' blog baten edukia bistaratzea ahalbidetzen dio.</p>
<p>Mesedez, sartu blog honek bistaratu nahi duzun edukia duen \'guraso\' blogaren IDNumber eremuaren balioa</p>';
$string['sharedblog_invalid'] = 'Ez dago bat datorren ID zenbakirik';
$string['sharedblog_invalid_morethan1'] = 'Bat datoz ID zenbaki bat baino gehiago';
$string['sharedblog_mastered'] = 'Blog hau dagoeneko guraso-blog bat da';
$string['siteentries'] = 'Ikusi guneko sarrerak';
$string['start'] = 'Hemendik';
$string['statblockon'] = 'Erakutsi blogaren erabileraren estatistika gehigarriak';
$string['statblockon_help'] = 'Gaitu estatistika gehigarriak bistaratzeko Blogaren erabilera \'blokean\'.
Blog pertsonalak (mundukoak), ikusgai dauden norbanakoen blogak eta ikusgai dauden taldeko blogak soilik.';
$string['subscribefeed'] = 'Harpidetu jario batera (software egokia behar du) {$a} hau eguneratzen denean jakinarazpena jasotzeko.';
$string['summary'] = 'Laburpena';
$string['tags'] = 'Etiketak';
$string['tagsfield'] = 'Etiketak (komaz bereizita)';
$string['tagshowless'] = 'Erakutsi gutxiago...';
$string['tagshowmore'] = 'Erakutsi gehiago ...';
$string['tagupdatefailed'] = 'Etiketak eguneratzeak huts egin du';
$string['teachergrading'] = 'Irakasleak ikasleak kalifikatzen ditu';
$string['timefilter_alltime'] = 'Denbora guztian';
$string['timefilter_close'] = 'Ezkutatu aukerak';
$string['timefilter_label'] = 'Denbora tartea';
$string['timefilter_open'] = 'Erakutsi aukerak';
$string['timefilter_submit'] = 'Eguneratu';
$string['timefilter_thismonth'] = 'Azken hilabetea';
$string['timefilter_thisyear'] = 'Azken urtea';
$string['timestartenderror'] = 'Hautapenaren amaiera-data ezin da hasiera-data baino lehenagokoa izan';
$string['title'] = 'Izenburua';
$string['tweet'] = 'Txiokatu';
$string['unsupportedbrowser'] = '<p>Zure arakatzaileak ezin ditu Atom edo RSS jarioak zuzenean bistaratu.</p>
<p>Jarioak oso erabilgarriak dira ordenagailu-programa edo webgune bereizietan. Jario hau programa horretan erabili nahi baduzu, kopiatu eta itsatsi helbidea zure arakatzailearen helbide-barratik.</p>';
$string['untitledcomment'] = 'Izenbururik gabeko iruzkina';
$string['untitledpost'] = 'Izenbururik gabeko sarrera';
$string['url'] = 'Web helbide osoa';
$string['use'] = 'Erabilienak';
$string['usergrade'] = 'Erabiltzailearen kalifikazioa';
$string['userparticipation'] = 'Erabiltzaileen parte-hartzea';
$string['userrating'] = 'Erabili balorazioak';
$string['usersparticipation'] = 'Erabiltzaile guztien parte-hartzea';
$string['viewallparticipation'] = 'Ikusi parte-hartze guztia';
$string['viewallusers'] = 'Ikusi erabiltzaile guztiak';
$string['viewallusersingroup'] = 'Ikusi taldeko erabiltzaile guztiak';
$string['viewblogdetails'] = 'Ikusi blogaren xehetasunak';
$string['viewblogposts'] = 'Itzuli blogera';
$string['viewedit'] = 'Ikusi edizioa';
$string['viewmyparticipation'] = 'Ikusi nire parte hartzea';
$string['views'] = '{$a} -ra egindako bisita kopurua:';
$string['visibility'] = 'Nork irakur dezake hau?';
$string['visibility_help'] = '<p><strong>Ikastaro honetako parte-hartzaileentzat ikusgai</strong> &ndash;  argitalpena ikusteko, jarduerarako sarbidea izan behar duzu, normalean jarduera duen ikastaroan izena emanda.</p>

<p><strong>Sisteman saioa hasita duen edonorrentzat ikusgai</strong> &ndash;  saioa hasita duen edonork ikus dezake argitalpena, ikastaro zehatz batean izena emanda ez egon arren.</p>
<p><strong>Munduko edonorentzat ikusgai</strong> &ndash;  edozein Interneteko erabiltzailek ikus dezake argitalpen hau
helbidea ematen badiozu.</p>';
$string['visibleblogusers'] = 'Blog honetako kideentzat bakarrik ikusgai';
$string['visiblecourseusers'] = 'Ikastaro honetako parte-hartzaileentzat ikusgai';
$string['visibleindividual'] = 'Pertsona ikusgarriak';
$string['visibleindividualblogs'] = 'Norberaren blogak ikusgai';
$string['visibleloggedinusers'] = 'Sisteman saioa hasita duten guztientzat ikusgai';
$string['visiblepublic'] = 'Munduko edonorentzat ikusgai';
$string['visibleyou'] = 'Blogaren jabearentzat bakarrik ikusgai (pribatua)';
$string['visits'] = 'Bisitatuenak';
$string['visits_info_active'] = 'Bisita gehien dituzten {$a} aktiboak (azken hilabetean argitalpen bat dutenak)';
$string['visits_info_alltime'] = 'Bisita gehien dituzten {$a}ak';
$string['yes'] = 'Bai';
