<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'readaloud', language 'eu', version '4.1'.
 *
 * @package     readaloud
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accadjust'] = 'Doitze finkoa.';
$string['accadjust_details'] = 'Hau da WPMko puntuazioak konpentsatzeko irakurketa-akatsen kopurua. WPM doitze "Finkoa" bada, balio hori WPM puntuazioak konpentsatzeko erabiliko da. Makinaren transkripzio-akatsak arintzeko metodo bat da.';
$string['accadjust_help'] = 'Tasa horrek bat etorri behar du, ahalik eta hurbilen, pasarte baterako makina batek kalkulatutako transkripzio-akatsen batez bestekoarekin.';
$string['accadjustmethod'] = 'WPM-a Doitu(AA)';
$string['accadjustmethod_details'] = 'WPM puntuazioa doitu, AAk aurkitutako irakurketa-akats batzuk kontuan hartu gabe edo deskontatuz. Lehenetsitako "Doikuntzarik ez" irakurketa-akats guztiak kentzen ditu amaierako WPM puntuaziotik.';
$string['accadjustmethod_help'] = 'WPM doikuntzarako aukerak: inoiz ez doitu, doitu kopuru finko baten bidez, edo ahaztu erroreak WPM-a kalkulatzeko orduan.';
$string['accmethod_auto'] = 'Doitze automatikoa';
$string['accmethod_fixed'] = 'Doitze finkoaren egokitzapena';
$string['accmethod_noerrors'] = 'Ez ikusia egin errore guztiei';
$string['accmethod_none'] = 'Doikuntzarik ez';
$string['accuracy'] = 'Zehaztasuna';
$string['accuracy_p'] = 'Zehazt.(%)';
$string['actions'] = 'Ekintzak';
$string['activitydate:submissionsdue'] = 'Amaiera-data:';
$string['activitydate:submissionsopen'] = 'Irekitze-data:';
$string['activitydate:submissionsopened'] = 'Ireki zeneko data:';
$string['activityisclosed'] = 'Jarduera hau itxita dago.';
$string['activityisnotopenyet'] = 'Jarduera hau oraindik ez dago zabalik.';
$string['activitylink'] = 'Hurrengo jarduerarako esteka';
$string['activitylink_help'] = 'Aukeratu jarduera goitibeherako zerrendatik, ikastaroan beste jarduera bat egiten saiatu ondoren esteka bat eskuratzeko.';
$string['activitylinkname'] = 'Jarraitu hurrengo jarduerara: {$a}';
$string['activityname'] = 'RA. Izena';
$string['activityopenscloses'] = 'Jardueraren irekiera/itxiera datak';
$string['activitywords'] = 'Pasarteko Hitz Kopurua';
$string['addingitem'] = 'Galdera berria gehitzen';
$string['addnewitem'] = 'Gehitu galdera berria';
$string['addpassage'] = 'Konfiguratu Jarduera';
$string['addtextpromptshortitem'] = 'Gehitu elementua';
$string['adjustedaccuracy_p'] = 'Egokitutako Zehaztasuna(%)';
$string['adjustedgrade_p'] = 'Adj. Kalifikazioa(%)';
$string['adjustedwpm'] = 'Adj. WPM';
$string['admintab'] = 'Administratzailea';
$string['admintabinstructions'] = 'Orri honetan, pasartearen alternatibak edita ditzakezu, okerreko traskripzioen laburpena ikusten duzun bitartean. Gordetzenn duzunean, saio guztiak berrebaluatuko dira eta notak kalifikazio-liburura egokituko dira.';
$string['admintabtitle'] = 'Administratzailea';
$string['advancedheader'] = 'Aurreratua';
$string['aigradenow'] = 'AA Kalifikazioa';
$string['aitextutilshide'] = 'Ezkutatu AAren Testu-Tresnak (Beta)';
$string['aitextutilsshow'] = 'Erakutsi AAren Testu-Tresnak (Beta)';
$string['allowearlyexit'] = 'Lehenago irten daiteke';
$string['allowearlyexit_defaultdetails'] = 'Ezarpen lehenetsia ezartzen du allow_early_exit-entzat. Jarduera mailan gainidatzi daiteke. Egia bada, allow_early_exit-ek esan nahi du ikasleek denbora-muga baino lehen amaitu dezaketela, horretarako amaitzeko botoia sakatuta. WPM-a haien grabazio-denbora erabiliz kalkulatzen da.';
$string['allowearlyexit_details'] = 'Egiaztatutako ikasleek denbora muga baino lehen buka dezakete, amaierako botoia sakatuz. WPMak grabatzeko denbora erabiliz kalkulatzen dira.';
$string['alternatives'] = 'Alternatibak';
$string['alternatives_descr'] = 'Zehaztu pasarte-hitz zehatzeekin bat datozen aukerak. Hitz multzo  bana lerro bakoitzeko.  Ikusi <a href="https://support.poodll.com/support/solutions/articles/19000096937-tuning-your-read-aloud-activity">dokumentuak</a> gehiago lortzeko xehetasunak.';
$string['alternatives_help'] = 'Zehaztu pasarte-hitz zehatzeekin bat datozen aukerak. Hitz multzo  bana lerro bakoitzeko.  Ikusi <a href="https://support.poodll.com/support/solutions/articles/19000096937-tuning-your-read-aloud-activity">dokumentuak</a> gehiago lortzeko xehetasunak.';
$string['answer'] = 'Erantzuna';
$string['apply_activity'] = 'jarduera hau';
$string['apply_course'] = 'ikastaro honetako jarduerak';
$string['apply_site'] = 'gune-jarduerak';
$string['applysettingsrange'] = 'Ezarri ezarpenak honi:';
$string['attemptno'] = '{$a}. Saiakera';
$string['attemptsheading'] = 'Saiakeren txostena';
$string['attemptsperpage'] = 'Erakutsi beharreko saiakerak, orrialdeko:';
$string['attemptsreport'] = 'Saiakeren txostena';
$string['attemptssummary_explanation'] = 'Jarduera honetan erabili ahal izateko IrakurriOzen saiakeren laburpena.';
$string['attemptssummaryheading'] = 'Saiakeren laburpen-txostena';
$string['attemptssummaryreport'] = 'Saiakeren laburpen-txostena';
$string['audiofile'] = 'Audioa';
$string['audioitemfile'] = 'Audio-elementua(MP3)';
$string['audioresponse'] = 'Audio erantzuna';
$string['av_grade_p'] = 'Batezbesteko Kalifikazioa(%)';
$string['av_wpm'] = 'Batezbesteko WPMa';
$string['averages'] = 'Batez bestekoa';
$string['avgcorrect'] = 'Zuzenak, batez beste';
$string['avgtotaltime'] = 'Batezbesteko Iraupena';
$string['awsregion'] = 'AWS Eskualdea';
$string['awsregion_details'] = 'Aukeratu hurbilen duzun eskualdea. Zure datuak eskualde horretan geratuko dira. Capetowneko eskualdeak ingelesa eta alemana bakarrik onartzen ditu.';
$string['backtotop'] = 'Egaiaztatu emaitzak';
$string['basicheading'] = 'Oinarrizko Txostena';
$string['basicreport'] = 'Oinarrizko Txostena';
$string['beginreading'] = 'Hasi Irakurtzen';
$string['cancel'] = 'Utzi';
$string['cannotgradenow'] = '-';
$string['chartexplainer'] = 'Hurrengo grafikoak erakusten du zer aurrerapen izan dituzun pasarte hau irakurtzean.';
$string['checking'] = '... egiaztatzen ...';
$string['close'] = 'Itxi';
$string['confirm_cancel_recording'] = 'Grabazioa bertan behera utzi, eta atera saiakeratik?';
$string['confirmitemdelete'] = 'Ziur zaude <i>DELETE</i> nahi duzula elementua? : {$a}';
$string['confirmitemdeletetitle'] = 'Benetan; Ezabatu elementua?';
$string['corpuspushed'] = 'Corpusaren gidak bultzatuta';
$string['corpusrange'] = 'Corpus-sorta';
$string['corpusrange_course'] = 'Ikastaro hau';
$string['corpusrange_site'] = 'Gune hau';
$string['correct'] = 'Zuzena';
$string['correctanswer'] = 'Erantzun zuzena';
$string['correcttranslationtitle'] = 'Itzulpen Zuzena';
$string['courseattempts_explanation'] = 'Ikastaro honetako IrakurriOzen jardueren saiakerak';
$string['courseattemptsheading'] = 'Ikastaro-saiakeren Txostena';
$string['courseattemptsreport'] = 'Ikastaro-saiakeren Txostena';
$string['createaitem'] = 'Sortu galdera';
$string['currenterrorestimate'] = 'Oraingo erroreen estimazioa: {$a}';
$string['customfont'] = 'Letra pertsonalizatua';
$string['customfont_help'] = 'Pasadizo hau bistaratzen denean gunerako lehenetsitakoa berridatziko duen letra-mota. Berbere izan behar du ortografian eta maiuskuletan. eg Andika or Comic Sans MS';
$string['datatables_aria_sortascending'] = 'aktibatu zutabea gorantza ordenatzeko';
$string['datatables_aria_sortdescending'] = 'aktibatu zutabea beherantza ordenatzeko';
$string['datatables_emptytable'] = 'Ez dago daturik taulan';
$string['datatables_info'] = '_TOTAL_ sarreratik _START_ eta _END_ artekoak erakusten';
$string['datatables_infoempty'] = '0tik 0ra bitarteko sarrerak erakusten';
$string['datatables_infofiltered'] = '(_MAX_ sarrera guztietatik iragazita)';
$string['datatables_lengthmenu'] = 'Erakutsi _MENU_ sarrerak';
$string['datatables_paginate_first'] = 'Lehenengoa';
$string['datatables_paginate_last'] = 'Azkena';
$string['datatables_paginate_next'] = 'Hurrengoa';
$string['datatables_paginate_previous'] = 'Aurrekoa';
$string['datatables_search'] = 'Bilatu:';
$string['datatables_zerorecords'] = 'Ez da bat datorren erregistrorik aurkitu';
$string['defaultfeedback'] = 'Eskerrik asko irakurtzeagatik.';
$string['defaultrecorder'] = 'Grabatzaile lehenetsia';
$string['defaultrecorder_details'] = 'Aukeratu ikasleei erakutsiko zaien grabatzaile lehenetsia.';
$string['defaultwelcome'] = 'Jarduera honetan pasarte bat irakurri beharko zenuke ozen. Beharrezko da mikrofonoa probatzea. Audio-grabatzailea ikusi beharko zenuke azpian. Grabatzen hasi ondoren, irakurketa-pasartea agertuko da. Irakurri pasartea ozen eta  ahalik eta argien.';
$string['deletealluserdata'] = 'Ezabatu erabiltzaile guztien datuak';
$string['deleteattemptconfirm'] = 'Ziur saiakera hau ezabatu nahi duzula?';
$string['deleteitem'] = 'Ezabatu elementua';
$string['developer'] = 'Garatzailea';
$string['disableshadowgrading'] = 'Desgaitu Itzal-moduko Kalifikazioa';
$string['disableshadowgrading_details'] = 'Egiaztatuz gero, itzal moduan egindako saiakerak ebaluatuko dira, baina ez dira kalifikazio-liburuan sartuko.';
$string['displaysubs'] = '{$a->subscriptionname} : iraungitzen da {$a->expiredate}';
$string['doclear'] = 'Garbitu markatzaile guztiak';
$string['done'] = 'Eginda';
$string['edit'] = 'Editatu';
$string['editingitem'] = 'Galdera editatzen';
$string['edititem'] = 'Editatu elementua';
$string['enableai_details'] = 'Irakurri Ozenek ikasle saio baten emaitzak ebaluatu ditzake AA erabiliz. Egiaztatu gaitzeko.';
$string['enablelandr'] = 'Gaitu Praktika-modua (Entzun eta Errepikatu)';
$string['enablelandr_details'] = 'Gaitu entzuteko eta errepikatzeko modua. Lerroz lerro, ikasleak txandaka entzuten eta irakurtzen du.';
$string['enablepreview'] = 'Gaitu Entzuteko-modua';
$string['enablepreview_details'] = 'Entzuteko moduak  irakurketa eta audioa erakusten dizkio ikasleari jarduera hasi aurretik.';
$string['enablesetuptab'] = 'Gaitu konfigurazio-fitxa';
$string['enablesetuptab_details'] = 'Erakutsi fitxa bat, administratu beharreko jarduera-instantziaren konfigurazioarekin. Ez da oso erabilgarria gehienetan.';
$string['enableshadow'] = 'Gautu Praktika-modua (Shadowing)';
$string['enableshadow_details'] = 'Shadowing modua ahalbidetzen du. Honek audio-modeloa erakusten die ikasleei, pasarte osoa ozen irakurtzen zaien modu berean. Ikasleek entzungailuak beharko dituzte.';
$string['enabletts'] = 'Gaitu TTS(esperimentala)';
$string['enabletts_details'] = 'Une honetan TTS ez dago inplementatuta';
$string['entersomething'] = 'Mesedez, idatzi gai bat pasarte bat sortzeko';
$string['errorcount'] = 'Errore kopurua';
$string['errorheader'] = 'Errorea';
$string['eu-es'] = 'Euskara';
$string['evaluatedmessage'] = 'Zure azken saiakera jaso dugu, eta, jarraian, ebaluazioa jasoko duzu.';
$string['evaluationview'] = 'Ebaluazio-pantaila';
$string['evaluationview_details'] = 'Zer erakutsi ikasleei ebaluazioa saiatu eta ebaluazioa jaso ondoren?';
$string['eventreadaloudattemptsubmitted'] = 'IrakurriOzen saiakera bidali da';
$string['exceededallattempts'] = 'Zure saiakera guztiak erabili dituzu.';
$string['exceededattempts'] = 'Gehienezko saiakera-kopurua {$a} osatu duzu';
$string['expiredays'] = 'Fitxategia gordetzeko egunak';
$string['exportexcel'] = 'Esportatu CSVra';
$string['extraslowspeed'] = 'Oso Motela';
$string['feedbacklabel'] = 'Saiakera osteko argibideak';
$string['feedbacklabel_details'] = 'Feedback eremuan Irakurri Ozen jarduera berri bat sortzean erakutsi beharreko testu lehenetsia.';
$string['fullreport'] = 'Ikusi Txosten Osoa';
$string['fullreportnoeval'] = 'Ikusi Pasartea';
$string['generate-text'] = 'Sortu Pasartea';
$string['gotnosound'] = 'Ez dizugu entzuten. Mesedez, egiaztatu mikrofonorako baimenak eta konfigurazioa eta saiatu berriro.';
$string['grade'] = 'Kalifikazioa';
$string['grade_p'] = 'Kalifikazioa(%)';
$string['gradeaverage'] = 'saiakera guztien batez besteko puntuazioa';
$string['gradehighest'] = 'puntuaziorik altueneko saiakera';
$string['gradelatest'] = 'azken saiakeraren puntuazioa';
$string['gradelowest'] = 'puntuaziorik baxueneko saiakera';
$string['gradenone'] = 'Ez dago kalifikaziorik';
$string['gradenow'] = 'Kalifikatu orain';
$string['gradeoptions'] = 'Kalifikazio-aukerak';
$string['gradeoptions_details'] = 'NB Horrek zehazten du kalifikazio-liburuko sarrera. IrakurriOzen orrialdeak ez du eraginik eta azken saiakera erakutsiko du.';
$string['gradeoptions_help'] = 'Erabiltzaile batek irakurketa bat egiteko saiakera asko egiten dituenean, ezarpen honek zehazten du zein saiakera kalifikatuko den';
$string['grader'] = 'Honek kalifikatua';
$string['grader_ai'] = 'AA';
$string['grader_human'] = 'Pertsona';
$string['grader_ungraded'] = 'Kalifikatu gabe';
$string['gradethisattempt'] = 'Kalifikatu saiakera';
$string['grading'] = 'Kalifikatzen';
$string['gradingbutton'] = 'Kalifikazio-modua';
$string['gradingbyuserheading'] = 'Honen: {$a} saiakera guztiak kalifikatzen';
$string['gradingheading'] = 'Erabiltzaile bakoitzaren azken saiakerak kalifikatzen.';
$string['guidedtrans_corpus'] = 'Erabili corpusa (IrakurriOzen pasarte guztiak)';
$string['guidedtrans_passage'] = 'Erabili jarduera-pasarte hau';
$string['guidedtranscriptionadmin'] = 'Transkripzio Gidatuaren Administratzailea';
$string['guidedtransinstructions'] = 'Transkripzio gidatua erabiltzean, transkribatzaileak gidalibururantz bideratuko du transkripzioa, hau da, edo jarduera honetako pasartean dauden hitzak/esaldiak hartuko ditu kontuan, edo IrakurriOzeneko pasarteen corpus osoko hitzak/esaldiak. IrakurriOzenen pasarteen corpus osoa erabiliz, irakurketa-akats gehiago jasoko dira.';
$string['h_accuracy_p'] = 'Gehieneko Zehaztasuna (%)';
$string['h_grade_p'] = 'Gehieneko Kalifikazioa (%)';
$string['h_wpm'] = 'Gehieneko WPM';
$string['hiddenevaluationmessage'] = 'Ongi jaso dugu zure saiakera. Eskerrik asko.';
$string['highest'] = 'Altuena';
$string['humanpostattempt'] = 'Ebaluazio-pantaila (pertsona)';
$string['humanpostattempt_details'] = 'Zer erakutsi ikasleei saiakera bat bidali eta pertsona batek egindako ebaluazioa jasotakoan';
$string['iscorrectlabel'] = 'Zuzen/Oker';
$string['item'] = 'Elementua';
$string['itemcontents'] = 'Galderaren deskripzioa';
$string['itemdetails'] = 'elementuaren Xehetasunak: {$a}';
$string['iteminuse'] = 'Elementu hau erabiltzailearen saiakera-historiaren parte da. Ezin da ezabatu.';
$string['itemname'] = 'Galdera-izena';
$string['itemorder'] = 'Elementuen ordena';
$string['itemsperpage'] = 'Elementuak orrialdeko';
$string['itemsperpage_details'] = 'Honek ezartzen du zenbat ilara erakutsi behar diren txostenetan edo saiakera-zerrendetan.';
$string['itemsummary'] = 'elementuen Laburpena: {$a}';
$string['itemtitle'] = 'Galderaren Izenburua';
$string['itemtype'] = 'Elementu-mota';
$string['landrhelp'] = 'Entzun hizlariari. Errepikatu esaldi bakoitza eta egiaztatu zure ahoskera.';
$string['landrreading'] = 'Praktika';
$string['letsaddpassage'] = 'Oraindik ez dago irakurketa-pasarterik ezarrita jarduera honetarako. Gehitu dezagun bat.';
$string['machinegradehybrid'] = 'Erabili makinaren edo pertsonaren ebaluazioa kalifikaziorako';
$string['machinegrademachineonly'] = 'Erabili beti makinaren ebaluazioa kalifikaziorako';
$string['machinegrademethod'] = 'Pertsonaren/Makinaren Kalifikazioa';
$string['machinegrademethod_details'] = 'Erabili makinaren edo pertsonaren ebaluazioak kalifikazio-liburuan.';
$string['machinegrademethod_help'] = 'Erabili makinaren edo pertsonaren ebaluazioak kalifikazio-liburuan.';
$string['machinegradenone'] = 'Inoiz ez erabili makinaren ebaluazioa kalifikaziorako';
$string['machinegradespushed'] = 'Kalifikazioak behar bezala eraman dira kalifikazio-liburura';
$string['machinegrading'] = 'Makinaren Ebaluazioak';
$string['machinegradingbyuserheading'] = 'Makinak ebaluatu ditu honen saiakerak: {$a}';
$string['machinegradingheading'] = 'Makinak ebaluatu ditu erabiltzaile bakoitzaren azken saiakerak.';
$string['machinepostattempt'] = 'Ebaluazio-pantaila (makina)';
$string['machinepostattempt_details'] = 'Zer erakutsi ikasleei saiakera bidali eta makinaren ebaluazioa jaso eta gero';
$string['machineregradeall'] = 'Gorde eta ebaluatu berriro saiakera guztiak';
$string['machineregraded'] = 'Behar bezala berritu dira saiakera hauen kalifikazioak: {$a->done}. Beste hauenak ez: {$a->skipped}';
$string['managersquestions'] = 'Kudeatu galderak';
$string['manualbreaktiming'] = 'Eskuzko atseden-denbora';
$string['masterinstance'] = 'Instantzia nagusia';
$string['masterinstance_details'] = 'Instantzia nagusiak aukera ematen dio egileari IrakurriOzen baten ezarpen indibidualak jarduera beraren kopietara bultzatzeko. Izen bera izango dute.';
$string['maxattempts'] = 'Gehienezko Saiakerak';
$string['mediumspeed'] = 'Ertaina';
$string['mingrade'] = 'Gutxieneko Kalifikazioa';
$string['missed_count'] = 'Galdutakoen kopurua';
$string['missedwords'] = 'Galdutako Hitzak';
$string['missedwords_explanation'] = 'Hitz akatsdun ohikoenak saiakera berrietan';
$string['missedwordsheading'] = 'Desagertutako Hitzak';
$string['missedwordsreport'] = 'Desagertutako Hitzak';
$string['mistakes'] = 'Akatsak';
$string['mistrans_count'] = 'Zenbaketa';
$string['mistranscriptions'] = 'Gaizki idatziak';
$string['mistranscriptions_summary'] = 'Gaizki idatzitakoen laburpena';
$string['modelaudio'] = 'Audio-eredua';
$string['modelaudio_breaksinstructions'] = 'Sakatu beheko pasarteko hitzak audio-erreprodukzioaren une horretan eten bat gehitzeko aurrebista eta praktika moduetan. Sistemak automatikoki sinkronizatuko ditu audioa eta testua. Egiaztatu <i>eskuzko atseden-denbora</i> sakatutako etenaldiak audioa erreproduzitzeko uneko kokapenean ezartzeko.';
$string['modelaudio_breakstitle'] = 'Mark-up Audio Eredua';
$string['modelaudio_playerinstructions'] = 'Une honetako audio eredua beheko erreproduzitzailea erabiliz erreproduzitu daiteke.';
$string['modelaudio_playertitle'] = 'Abiarazi Audio Eredua';
$string['modelaudio_recordinstructions'] = 'Grabatu audioa audio eredu gisa erabiltzeko. Audioa kargatu dezakezu, horretarako erabili igo audioa botoia. Minutu batzuetako atzerapena egongo da  testuaren eten puntue eta audioa automatikoki sinkronizatzeko.';
$string['modelaudio_recordtitle'] = 'Grabatu Audio Eredua';
$string['modelaudiobreaksclear'] = 'Garbitu audio ereduaren markak';
$string['modelaudiobreaksgenerate'] = 'Sortu Berriro Audio Ereduaren Markak';
$string['modelaudioclear'] = 'Garbitu Audioa';
$string['modelaudiowarning'] = 'Audio eredua ez dago markatuta.';
$string['modulename'] = 'Poodll Irakurri Ozen';
$string['modulename_help'] = 'Irakurri Ozen irakasleei ikasleen irakurgarritasuna ebaluatzen laguntzeko diseinatutako jarduera da. Ikasleek irakasleak ezarritako pasarte bat irakurtzen dute mikrofono bidez. Ondoren, irakasleak okerreko hitzak marka ditzake eta ikaslearen WCPM (Word Correct Per Minute) puntuazioa lortu.';
$string['modulenameplural'] = 'Poodll IrakurriOzen';
$string['moveitemdown'] = 'Behera';
$string['moveitemup'] = 'Gora';
$string['myattemptssummary'] = 'Saiakeren laburpena ({$a} attempts)';
$string['name'] = 'Izena';
$string['ng'] = 'Ez dago ondo';
$string['noattemptsregrade'] = 'Ez dago  berriro kalifikatzeko saiakerarik';
$string['nocourseid'] = 'Moduluaren edo instantziaren IDa zehaztu behar duzu. Zure saioa amaitu egingo da.';
$string['nodataavailable'] = 'Daturik ez dago eskuragarri';
$string['noitems'] = 'Galdetegi honek ez du galderarik';
$string['nomistranscriptions'] = 'Ez dago okerreko transkrizpziorik';
$string['nopassage'] = 'Ez dago Irakurketa-pasarterik';
$string['normalhelp'] = 'Irakurri pasartea ozenki. Hitz egin zuretzat normala den abiaduran.';
$string['notaddedtogradebook'] = 'Hau itzaleko praktika bat zen, ez da kalifikazio-liburuan gehituko.';
$string['notgradedyet'] = 'Zure bidalketa onartua izan da, baina oraindik ez dugu kalifikatu. Minutu batzuk beharko ditugu.';
$string['notimelimit'] = 'Ez dago denbora-mugarik';
$string['notmanuallygradedyet'] = 'Zure bidalketa onartua izan da, baina oraindik ez dugu kalifikatu.';
$string['notmasterinstance'] = 'Ezin dituzu IrakurriOzen jarduera honetako ezarpenak hedatu, jardueraren ezarpenetan instantzia nagusia egiaztatu ezean.';
$string['notok'] = 'Ez dago ondo';
$string['nottsvoice'] = 'Ez dago TTS Ahotsik';
$string['numeric'] = 'Zenbakizkoa izan behar du';
$string['ok'] = 'Ongi';
$string['one_simplest'] = 'bat (errazena)';
$string['onemin'] = 'Minutu 1';
$string['oneminxsecs'] = 'Minutu 1 {$a} segundu';
$string['open'] = 'Ireki:';
$string['oralreadingscore'] = 'Ahozko irakurketaren puntuazioa';
$string['oralreadingscore_p'] = 'Ahozko irakurketaren puntuazioa(%)';
$string['overview'] = 'Ikuspegi orokorra';
$string['overview_help'] = 'Ikuspegi orokorraren laguntza';
$string['overwrite'] = 'Ikuspegi orokorra';
$string['passage'] = 'Irakurritako Pasartea';
$string['passage_descr'] = 'Sartu goian irakurritako pasartea. Ez lituzke 3000 karaktere baino gehiago izan beharko, bederen, harentzat audioa sortzea nahi baduzu.';
$string['passage_help'] = 'Ikasleak irakurri beharko duen pasartea.';
$string['passageindex'] = 'Pasartearen indizea';
$string['passagekey'] = 'Pasartearen giltza';
$string['passagekey_details'] = 'Pasahitza etiketa bat besterik ez da, txosten batzuekin CSVra esportatuko dena txosten horiek errazago prozesatzeko kalkulu-orri batean. Ondo dago hutsik uztea.';
$string['passagekey_help'] = 'Pasahitza etiketa bat besterik ez da, txosten batzuekin CSVra esportatuko dena txosten horiek errazago prozesatzeko kalkulu-orri batean.';
$string['passagelabel'] = 'Irakurritako Pasartea';
$string['passagepicture'] = 'Pasarteko irudia';
$string['passagepicture_descr'] = '*Pasartearen irudia ez da oraindik erabili. Hurrengo funtzio baten parte da*';
$string['passageword'] = 'Pasarte-hitza';
$string['playbutton'] = 'Abiarazi';
$string['pluginadministration'] = 'IrakurriOzen Kudeaketa';
$string['pluginname'] = 'Poodll IrakurriOzen';
$string['postattempt_eval'] = 'Erakutsi pasartea eta ebaluazioa (WPM,Zehaztasuna,Kalifikazioa)';
$string['postattempt_evalerrors'] = 'Erakutsi pasartea, ebaluazioa (WPM,Zehaztasuna,Kalifikazioa) eta erroreak';
$string['postattempt_evalerrorsnograde'] = 'Erakutsi pasartea, ebaluazioa (WPM,Zehaztasuna) eta erroreak';
$string['postattempt_none'] = 'Erakutsi pasartea. Ez erakutsi ebaluazioa edo erroreak.';
$string['postattemptheader'] = 'Saiakera bidali ondorengo aukerak';
$string['preview'] = 'Aurreikusi';
$string['previewhelp'] = 'Entzun hizlari bati pasartea ozenki irakurtzen. Ez duzu ozen irakurri behar.';
$string['previewitem'] = 'Aurreikusi elementua';
$string['previewreading'] = 'Entzun';
$string['privacy:metadata'] = 'Poodll Irakurri Ozen pluginak datu pertsonalak gordetzen ditu.';
$string['privacy:metadata:accuracy'] = 'Saiakeraren zehaztasun-puntuazioa';
$string['privacy:metadata:aitable'] = 'Ozen irakurritako saiakera bati lotutako, eta makinak ebaluatutako, kalifikazioak, zein lotutako erabiltzailearen bestelako datuak, gordetzen ditu.';
$string['privacy:metadata:attemptid'] = 'ID bakarra Irakurri Ozen saiakeraren erabiltzaile guztientzat.';
$string['privacy:metadata:attempttable'] = 'Ozen irakurritako saiakera baten kalifikazioak  eta lotutako erabiltzailearen bestelako datuak gordetzen ditu.';
$string['privacy:metadata:cloudpoodllcom'] = 'IrakurriOzen pluginak AWS S3 ontzietan gordetzen ditu grabazioak cloud.poodll.com bidez.';
$string['privacy:metadata:cloudpoodllcom:userid'] = 'IrakurriOzen pluginak moodle erabiltzailearen IDa sartzen du grabazio eta transkripzioen URLetan..';
$string['privacy:metadata:errorcount'] = 'Irakurketa-erroreak saiakera honetarako';
$string['privacy:metadata:filename'] = 'Bidalitako grabazio-fitxategien URLak.';
$string['privacy:metadata:fulltranscriptpurpose'] = 'Grabazioen transkripzio osoa.';
$string['privacy:metadata:readaloudid'] = 'Irakurri Ozen instantziaren identifikatzaile bakarra.';
$string['privacy:metadata:sessionendword'] = 'Saiakerako azken hitzaren posizioa';
$string['privacy:metadata:sessionerrors'] = 'Saiakera honetako irakurketa-erroreak';
$string['privacy:metadata:sessionscore'] = 'Sesioaren puntuazioa saiakerarako';
$string['privacy:metadata:sessiontime'] = 'Sesioaren denbora(grabazio denbora) saiakerarako';
$string['privacy:metadata:timemodified'] = 'Saiakera honek azken saiakera moldatuko du';
$string['privacy:metadata:transcriptpurpose'] = 'Grabazioaren transkripzio laburrak.';
$string['privacy:metadata:userid'] = 'Erabiltzailearen IDa Irakurri Ozen saiakerarentzat';
$string['privacy:metadata:wpm'] = 'Minutuko Hitzen puntuazioa saiakerarako';
$string['processing'] = 'Prozesatzen';
$string['progresschart'] = 'Aurrerapen-taula';
$string['push'] = 'Hedatu';
$string['pushalltogradebook'] = 'Berriro eraman ebaluazioak kalifikazio-liburura';
$string['pushalternatives'] = 'Hedatu Alternatibak';
$string['pushalternatives_desc'] = 'Hedatu alternatiben eremua klon-instantzia guztietara.';
$string['pushalternatives_done'] = 'Alternatibak ondo hedatu dira';
$string['pushcanexitearly'] = 'Lehenago Irten Daiteke';
$string['pushcanexitearly_desc'] = 'Hedatu "Lehenago Irten Zaitezke" aukera klon instantzia guztietara. Ezarpen horrek aukera ematen die erabiltzaileei jardueratik irteteko denbora-muga iritsi baino lehen.';
$string['pushcanexitearly_done'] = 'Ondo hedatu da Lehenago Irten Zaitezke';
$string['pushcorpus_button'] = 'Eguneratu eta hedatu corpusaren gida';
$string['pushcorpus_details'] = 'Ikastaroaren/gunearen corpusa automatikoki eguneratuko da, baina, behar izanez gero, beheko botoia erabil daiteke corpusa eguneratu eta hedatzeko. Honek corpus-irismeneko gida bat sortuko du, eta gidan sartuko ditu IrakurriOzen jarduera guztiak(transkripzio gidatua erabiltzen dutenak).';
$string['pushgradesettings'] = 'Kalifikazio-ezarpenak';
$string['pushgradesettings_desc'] = 'Hedatu instantzia honetako gradu-konfigurazio batzuk (kalifikazioen kalkulua, pertsonaren/makinaren kalifikazioa, saiakera onena/berriena) eta klonatu instantziak.  Honek kalifikazio-liburuan eragina duten beste ezarpen batzuen gehieneko kalifikazioak eguneratu ohi ditu, baina ez du behartuko dauden saiakerak berriro baloratzera. Hobe da, aukera hau, oraindik saiakerarik ez duten klonekin bakarrik erabiltzea.';
$string['pushgradesettings_done'] = 'Kalifikazio-ezarpenak ongi hedatu dira';
$string['pushmodes'] = 'Moduak';
$string['pushmodes_desc'] = 'Hedatu instantzia honetako hautazko jarduera-moduaren ezarpenak (aurrebista, entzutea, errepikatzea eta itzaltzea) klonatutako instantzietara.';
$string['pushmodes_done'] = 'Moduak ongi hedatu dira';
$string['pushpage'] = 'Hedapen-orria';
$string['pushpage_clonecount'] = 'Jarduera honeak {$a} klon ditu. <br><br>';
$string['pushpage_explanation'] = 'Erabili orri honetako botoiak  IrakurriOzen instantzia honen ezarpenak haren klonazioetara (izen bereko jarduerak) hedatzeko. Kontuz, ez dago atzera bueltarik. Ziurtatu zure asmoak erabili aurretik.';
$string['pushpage_noclones'] = 'Jarduera hau instantzia-nagusia da, baina ez dago izen bereko beste jarduerarik (ie clones). Beraz, ez dago ezarpenak hedatzerik. Egiaztatu hau dela jarduera egokia. Probatzen ari bazarete, bikoiztu jarduera hau eta izendatu modu berean.';
$string['pushpassage'] = 'Hedatu pasartea (eta lotutako ezarpenak)';
$string['pushpassage_desc'] = 'Hedatu klonetara pasarte honi dagozkion zenabit elementu: pasartea, fonetika, segmentuak ...';
$string['pushpassage_done'] = 'Pasartea ongi hedatu da';
$string['pushquestions'] = 'Hedatu galderak';
$string['pushquestions_desc'] = 'Egin hemen ulermenari buruzko galderak. Laster jarriko dira martxan.';
$string['pushquestions_done'] = 'Galderak ongi hedatu dira';
$string['pushtargetwpm'] = 'xede-WPMa';
$string['pushtargetwpm_desc'] = 'Hedatu Xede-WPM ezarpenak klonatutako instantzia guztietara';
$string['pushtargetwpm_done'] = 'Xede-WPMA ongi hedatu da';
$string['pushtimelimit'] = 'Denbora-muga';
$string['pushtimelimit_desc'] = 'Hedatu Denbora-mugaren ezarpenak klonatutako instantzia guztietara';
$string['pushtimelimit_done'] = 'Denbora-muga ondo hedatu da';
$string['pushttsmodelaudio'] = 'Hedatu TTS eta Model Audio';
$string['pushttsmodelaudio_desc'] = 'Bultzatu TTS eta Model Audioarekin lotutako konfigurazioa, honek ez du audiorik igoko/grabatuko. TTSren audio-datuak eta metadatuak bultzatuko ditu, baita audio-etenaldiak ere.';
$string['pushttsmodelaudio_done'] = 'TTS eta Model Audio ondo hedatu dira';
$string['quickgrade'] = 'Kalifikazio Azkarra';
$string['quiz'] = 'Galdetegia';
$string['quizcompletedwarning'] = 'Osatu duzu galdetegia. Sakatu berrikusteko.';
$string['quizhelp'] = 'Irakurri pasartea isilik. Ondoren, erantzun pasarteari buruzko galderei.';
$string['rank'] = 'Sailkapena';
$string['rawaccuracy_p'] = 'Zehaztasuna(%)';
$string['rawgrade_p'] = 'Kalifikazioa(%)';
$string['rawwpm'] = 'WPM';
$string['readaloud:addinstance'] = 'Gehitu Irakurri Ozen berria';
$string['readaloud:itemedit'] = 'Editatu galderak';
$string['readaloud:itemview'] = 'Ikusi galderak';
$string['readaloud:manage'] = 'Irakurri Ozen instantziak kudeatu ditzake';
$string['readaloud:manageattempts'] = 'Irakurri Ozen saiakerak kudeatu ditzake';
$string['readaloud:preview'] = 'Irakurri Ozen jarduerak aurreikusi ditzake';
$string['readaloud:pushtoclones'] = 'Ezarpenak klonetara hedatu ditzake';
$string['readaloud:submit'] = 'Irakurri Ozen saiakerak bidali ditzake';
$string['readaloud:tts'] = 'Testutik Hizketara(TTS) erabili dezake';
$string['readaloud:view'] = 'Aurreikusi Irakurri Ozen';
$string['readaloud:viewreports'] = 'Irakurri Ozeneko kalifikazioak eta txostenak ikus ditzake';
$string['readaloudfieldset'] = 'Eremu-multzo pertsonalizatua';
$string['readaloudname'] = 'Poodll IrakurriOzen';
$string['readaloudname_help'] = 'Hau da readaloudname eremuari lotutako laguntza-tresnen edukia. Markdown sintaxia bermatuta dago.';
$string['readaloudtask'] = 'Irakurri Ozen Ataza';
$string['readingtime'] = 'Irakurketa Denbora (segunduak)';
$string['reallyoverwritepassage'] = 'Pasarte hau beste batekin berridatzi nahi duzu?';
$string['reattempt'] = 'Saiatu Berriro';
$string['rec_once'] = 'Hasi besterik ez';
$string['rec_readaloud'] = 'Mikro-probaren ondoren hasi';
$string['rec_upload'] = 'Igo (garatzaile/administratzaileentzat)';
$string['recorder'] = 'Audio-grabatzaile mota';
$string['recorder_help'] = 'Aukeratu zure ikasleei eta egoerei hobekien egokitzen zaien audio-grabagailua';
$string['recordingaiheader'] = 'Grabazio eta AA aukerak';
$string['refreshtoken'] = 'Eguneratu lizentzia-informazioa';
$string['region'] = 'AWS Eskualdea';
$string['regrade'] = 'Berriro kalifikatu';
$string['reports'] = 'Txostenak';
$string['reportsmenutoptext'] = 'IrakurriOzen jardueren saiakerak berrikusi, segidako txostenak erabiliz.';
$string['returnmenu'] = 'Itzuli Menura';
$string['returntogradinghome'] = 'Itzuli Kalifikazioen Goialdera';
$string['returntomachinegradinghome'] = 'Itzuli Makinaren Ebaluazioen Goialdera';
$string['returntomenu'] = 'Itzuli Menura';
$string['returntoreports'] = 'Itzuli Txostenetara';
$string['review'] = 'Berrikusi';
$string['rsquestions'] = 'Galderak';
$string['saveandnext'] = 'Gorde ... eta hurrengoa';
$string['saveitem'] = 'Gorde elementua';
$string['savemodelaudio'] = 'Gorde grabazioa';
$string['savemodelaudiomarkup'] = 'Gorde model audioren markaketa';
$string['secs_till_check'] = 'Emaitzak egiaztatzen:';
$string['sessionscoremethod'] = 'Kalifikazioaren kalkulua';
$string['sessionscoremethod_details'] = 'Nola kalkulatzen den gradebookaren balioa ( %)?';
$string['sessionscoremethod_help'] = 'Portzentaietan kalkulatzen da kalifikazio-liburuaren balioa(%). Bai WPMa/Xede-WPMa (ohikoa), baita ere, (WPM-Akatsak)/ Xede-WPMa (zorrotza)';
$string['sessionscorenormal'] = 'Ohikoa: Hitz zuzenak minutuko / Xede-WPMa';
$string['sessionscorestrict'] = 'Zorrotza: (Hitz zuzenak guztira - erroreak) minutuko/ Xede-WPMa';
$string['setup'] = 'Konfigurazioa';
$string['shadowhelp'] = 'Irakurri pasartea ozenki, irakaslearekin batera. Entzungailuak erabili beharko zenituzke.';
$string['showingattempt'] = 'Erakutsi honen saiakerak: {$a}';
$string['showingmachinegradedattempt'] = 'Makinak ebaluatutako saiakerak honetarako: {$a}';
$string['shuffleanswers'] = 'Nahastu Erantzunak';
$string['shufflequestions'] = 'Nahastu Galderak';
$string['simplify-text'] = 'Sinplifikatu pasartea';
$string['slowspeed'] = 'Geldo';
$string['spotcheckbutton'] = 'Spot Check modua';
$string['startreading'] = 'Irakurri';
$string['startshadowreading'] = 'Itzaleko pratika';
$string['stdashboardid'] = 'Ikaslearen Arbelaren IDa';
$string['stdashboardid_details'] = 'Ikaslearen arbelaren blokea instalatuta badago, jarri blokearen identifikatzailea hemen.';
$string['stopbutton'] = 'Gelditu';
$string['stricttranscribe'] = 'Pasarte-transkribatzailea';
$string['stricttranscribe_details'] = 'Pasarte osoak irakurtzeko erabiliko den transkribatzailea.';
$string['studentname'] = 'Ikaslearen izena';
$string['submitted'] = 'bidalia';
$string['summaryexplainer'] = 'Beheko taulak jarduera honen batez bestekoa eta puntuaziorik altuenak erakusten ditu.';
$string['targetwpm'] = 'Xede-WPM';
$string['targetwpm_details'] = 'Lehenetsitako xede-WPMa. Ikaslearen nota kalkulatuko da kalifikazio-libururako eta balio hori erabiliko da gehienezko-puntuazio gisa. WPM puntuazioa xede-WPMaren berdina edo handiagoa bada, % 100eko puntuazioa jasoko du. Xede-WPMa jarduera-instantzian ere ezar daiteke.';
$string['targetwpm_help'] = 'Xede-WPMaren puntuazioa. Ikaslearen nota kalkulatuko da kalifikazio-libururako eta balio hori erabiliko da gehienezko-puntuazio gisa. WPM puntuazioa xede-WPMaren berdina edo handiagoa bada, % 100eko puntuazioa jasoko du.';
$string['text-too-long-100'] = 'Zure gaiak ezin du 100 karaktere baino gehiago eduki: deskribatu gaia, ez idatzi esaldi osorik, eta ez eman argibide osagarririk.';
$string['textboxchoice'] = 'Aukeratu Testu-koadroa';
$string['textchoice'] = 'Aukeratu Testu-area';
$string['textgenerator_instructions'] = 'Sartu fikziozkoa ez den gaiaren deskribapen labur bat eta sakatu botoia pasarte bat sortzeko. Askotan ez da oso zehatza izango. Mesedez, kontuz erabili ikasleekin.';
$string['textoverwriteconfirm'] = 'Gainidatzi Berrespena';
$string['textsimplifier_instructions'] = 'Aukeratu sinplifikazio maila eta sakatu botoia pasartea sinplifikatzeko. Pasartea aukeratzen duzun gutxi gorabeherako mailara sinplifikatuko da.';
$string['three'] = 'hiru';
$string['timecreated'] = 'Duela zenbat sortua';
$string['timelimit'] = 'Denbora Muga';
$string['timelimit_help'] = 'Irakurketarako denbora-muga ezartzen du. Irakurketa denbora WPM kalkuluan erabiltzen da. Agian, gaitu beharko zenuke ere Baimendu Lehenago Irtetea';
$string['total_mistranscriptions'] = 'Transkripzio okerrak guztira: {$a}';
$string['totalattempts'] = 'Saiakerak';
$string['totalwords'] = 'Hitzak Guztira';
$string['transcriber'] = 'Lerro-transkribatzailea';
$string['transcriber_details'] = 'Lerroz lerro irakurtzeko erabili behar den transkripzio-motorra.';
$string['transcriber_guided'] = 'Gidatutako STT (Poodll)';
$string['transcriber_none'] = 'Transkripziorik ez';
$string['transcriber_strict'] = 'STT irekia (Zorrotza)';
$string['transcriber_warning'] = 'Berehalako transkripzioa hautatu duzu. Kontuan izan honek <strong>pasartearen hizkuntza eta eskualdea zuzenak badira soilik funtzionatuko duela</strong>.';
$string['transcript'] = 'Transkribatu';
$string['transcriptcheckbutton'] = 'Transkripzioa Egiaztatzeko modua';
$string['ttslanguage'] = 'Pasartearen hizkuntza';
$string['ttslanguage_details'] = 'Balore hau erabiltzen da hizketa-ezagutzarako eta TTSrako';
$string['ttslanguage_help'] = 'Balore hau erabiltzen da hizketa-ezagutzarako eta TTSrako';
$string['ttsspeed'] = 'TTS Abiadura';
$string['ttsspeed_help'] = 'Makinaren irakurketa-ahotsaren abiadura. Motel edo Oso Motel aukerak ikasketentzat onak dira, baina audioa desitxuratu dezakete.';
$string['ttsvoice'] = 'TTS Ahotsa';
$string['ttsvoice_descr'] = 'Pasartea ozen irakurtzeko erabiltzen den makinaren ahotsa. Bere atzetik ikur + bat baldin badator, kalitate handiagoko ahotsa da.  Jarraian ! ikurra badago, eskuz gehitu beharko dituzu hizketa-pausoak xede-audioaren fitxan.';
$string['ttsvoice_help'] = 'Pasartea ozen irakurtzeko erabiltzen den makinaren ahotsa. Ahots bat hautatu, pasartearen hizkuntzarekin bat datorrena. Bere atzetik ikur + bat baldin badator, kalitate handiagoko ahotsa da.  Jarraian ! ikurra badago, eskuz gehitu beharko dituzu hizketa-pausoak xede-audioaren fitxan. Erabili xede-audioaren fitxa audio alternatibo bat grabatzeko edo igotzeko, edo ahozko etenaldiak eskuz ezartzeko.';
$string['two'] = 'bi';
$string['unit_percent'] = 'portzentaia';
$string['unit_words'] = 'hitzak';
$string['unit_wpm'] = 'hitzak/minutu';
$string['unlimited'] = 'mugarik gabe';
$string['until'] = 'Noiz arte:';
$string['uploadconverterror'] = 'Akats bat gertatu da zure artxiboa zerbitzarira igotzean. Zure bidalketa EZ da jaso. Mesedez, berritu orria eta saiatu berriro.';
$string['uploadmodelaudio'] = 'Igo Audio-fitxategia';
$string['usecorpus'] = 'Gidatutako transkripzio-mota';
$string['usecorpuschanged'] = 'Gidatutako transkripzio mota aldatu da';
$string['username'] = 'Erabiltzailea';
$string['view'] = 'Ikusi';
$string['viewadmintab'] = 'Ikusi Kudeatzailearen Fitxa';
$string['viewend'] = 'Itxi jarduera';
$string['viewend_help'] = 'Ezarrita baldin badago, ikasle batek ezin du jarduerara sartu itxiera-data/ordua igaro ondoren.';
$string['viewgrading'] = 'Ikusi kalifikazioak';
$string['viewmachinegrading'] = 'Makinaren Ebaluazioa';
$string['viewmodeltranscript'] = 'Ikusi Ereduaren Transkripzioa';
$string['viewreports'] = 'Ikusi txostenak';
$string['viewstart'] = 'Jarduera zabalik';
$string['viewstart_help'] = 'Ezarrita baldin badago, ikasle batek ezin du jarduerara sartu itxiera-data/ordua igaro ondoren.';
$string['waitforpassage'] = 'Oraindik ez dago irakurketa-pasarterik jarduera honetarako. Ezin izango duzu jarduera egin zure irakasleak bat gehitu arte.';
$string['waiting'] = '-- zain --';
$string['waitingforteacher'] = 'Zure irakasleak laster aztertuko du zure irakurketa.';
$string['welcomelabel'] = 'Saiakeraren aurretiko argibideak';
$string['welcomelabel_details'] = 'Instrukzio lehenetsiak. Irakurri Ozen jarduera berri bat sortzean edita daiteke.';
$string['welcomemenu'] = 'Aukeratu behekoen artean.';
$string['whatdonow'] = 'Zer egin nahi duzu?';
$string['wpm'] = 'WPM';
$string['xmins'] = '{$a} minutu';
$string['xminsecs'] = '{$a->minutes} minutu {$a->seconds} segundo';
$string['xsecs'] = '{$a} segundo';
