<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'user', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   core_user
 * @copyright 2018 Adrian Greeve <adriangreeve.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['countparticipantsfound'] = '{$a} participants found';
$string['moodlenetprofile'] = 'MoodleNet profile ID';
$string['moodlenetprofile_help'] = 'Your MoodleNet profile ID links your MoodleNet profile with this site.';
$string['placeholdertype'] = 'Type...';
$string['privacy:courserequestpath'] = 'Requested courses';
$string['privacy:descriptionpath'] = 'Profile description';
$string['privacy:devicespath'] = 'User devices';
$string['privacy:draftfilespath'] = 'Draft files';
$string['privacy:lastaccesspath'] = 'Last access to courses';
$string['privacy:metadata:address'] = 'The address of the user.';
$string['privacy:metadata:aim'] = 'The AIM identifier of the user';
$string['privacy:metadata:alternatename'] = 'An alternative name for the user.';
$string['privacy:metadata:appid'] = 'The app ID, usually something like com.moodle.moodlemobile';
$string['privacy:metadata:auth'] = 'The authentication plugin used for this user record.';
$string['privacy:metadata:autosubscribe'] = 'A preference as to if the user should be auto-subscribed to forums the user posts in.';
$string['privacy:metadata:calendartype'] = 'A user preference for the type of calendar to use.';
$string['privacy:metadata:category'] = 'The category identifier';
$string['privacy:metadata:city'] = 'The city of the user.';
$string['privacy:metadata:confirmed'] = 'If this is an active user or not.';
$string['privacy:metadata:country'] = 'The country that the user is in.';
$string['privacy:metadata:courseid'] = 'Course ID';
$string['privacy:metadata:currentlogin'] = 'The current login for this user.';
$string['privacy:metadata:data'] = 'Data relating to the custom user field from the user.';
$string['privacy:metadata:deleted'] = 'A flag to show if the user has been deleted or not.';
$string['privacy:metadata:department'] = 'The department that this user can be found in.';
$string['privacy:metadata:description'] = 'General details about this user.';
$string['privacy:metadata:devicename'] = 'The device name, occam or iPhone etc..';
$string['privacy:metadata:devicetablesummary'] = 'This table stores user\'s mobile devices information in order to send PUSH notifications';
$string['privacy:metadata:email'] = 'An email address for contact.';
$string['privacy:metadata:emailstop'] = 'A preference to disable notifications from being sent to the user.';
$string['privacy:metadata:fieldid'] = 'The ID relating to the custom user field.';
$string['privacy:metadata:filelink'] = 'There are multiple different files for the user stored in the files table.';
$string['privacy:metadata:firstaccess'] = 'The time that this user first accessed the site.';
$string['privacy:metadata:firstip'] = 'The first IP address recorded';
$string['privacy:metadata:firstname'] = 'The first name of the user.';
$string['privacy:metadata:firstnamephonetic'] = 'The phonetic details about the user\'s first name.';
$string['privacy:metadata:fullname'] = 'The fullname for this course.';
$string['privacy:metadata:hash'] = 'A hash of a previous password.';
$string['privacy:metadata:icq'] = 'The ICQ number of the user.';
$string['privacy:metadata:id'] = 'The user ID';
$string['privacy:metadata:idnumber'] = 'An identification number given by the institution';
$string['privacy:metadata:imagealt'] = 'Alternative text for the user\'s image.';
$string['privacy:metadata:infotablesummary'] = 'Stores custom user information.';
$string['privacy:metadata:institution'] = 'The institution that this user is a member of.';
$string['privacy:metadata:lang'] = 'A user preference for the language shown.';
$string['privacy:metadata:lastaccess'] = 'The time that the user last accessed the site.';
$string['privacy:metadata:lastaccesstablesummary'] = 'Information about the last time a user accessed a course.';
$string['privacy:metadata:lastip'] = 'The last IP address for the user.';
$string['privacy:metadata:lastlogin'] = 'The last login of this user.';
$string['privacy:metadata:lastname'] = 'The last name of the user.';
$string['privacy:metadata:lastnamephonetic'] = 'The phonetic details of the user\'s last name.';
$string['privacy:metadata:maildigest'] = 'A setting for the mail digest for this user.';
$string['privacy:metadata:maildisplay'] = 'A preference for the user about displaying their email address to other users.';
$string['privacy:metadata:middlename'] = 'The middle name of the user';
$string['privacy:metadata:mnethostid'] = 'An identifier for the MNet host if used';
$string['privacy:metadata:model'] = 'The device name, occam or iPhone etc..';
$string['privacy:metadata:moodlenetprofile'] = 'The MoodleNet profile for the user';
$string['privacy:metadata:msn'] = 'The MSN identifier of the user';
$string['privacy:metadata:my_pages'] = 'User pages - dashboard and profile. This table does not contain personal data and only used to link dashboard blocks to users';
$string['privacy:metadata:my_pages:name'] = 'Page name';
$string['privacy:metadata:my_pages:private'] = 'Whether or not the page is private (dashboard) or public (profile)';
$string['privacy:metadata:my_pages:userid'] = 'The user who owns this page or 0 for system defaults';
$string['privacy:metadata:password'] = 'The password for this user to log into the system.';
$string['privacy:metadata:passwordresettablesummary'] = 'A table tracking password reset confirmation tokens';
$string['privacy:metadata:passwordtablesummary'] = 'A rotating log of hashes of previously used passwords for the user.';
$string['privacy:metadata:phone'] = 'A phone number for the user.';
$string['privacy:metadata:picture'] = 'The picture details associated with this user.';
$string['privacy:metadata:platform'] = 'The device platform, Android or iOS etc';
$string['privacy:metadata:policyagreed'] = 'A flag to determine if the user has agreed to the site policy.';
$string['privacy:metadata:pushid'] = 'The device PUSH token/key/identifier/registration ID';
$string['privacy:metadata:reason'] = 'The reason for requesting this course.';
$string['privacy:metadata:requester'] = 'The ID of the user who requested the course';
$string['privacy:metadata:requestsummary'] = 'Stores information about requests for courses that users make.';
$string['privacy:metadata:suspended'] = 'A flag to show if the user has been suspended on this system.';
$string['privacy:metadata:user_preference:core_user_welcome'] = 'Timestamp logged for when the welcome message was shown to the user for the first time.';
$string['privacy:metadata:user_preferences'] = 'Preferences associated with the given user';
$string['privacy:metadata:user_preferences:name'] = 'Preference name';
$string['privacy:metadata:user_preferences:userid'] = 'The user ID';
$string['privacy:metadata:user_preferences:value'] = 'Preference value';
$string['privacy:metadata:username'] = 'The username for this user.';
$string['privacy:metadata:secret'] = 'Secret.. not sure.';
$string['privacy:metadata:sessdata'] = 'Session content';
$string['privacy:metadata:sessiontablesummary'] = 'Database based session storage';
$string['privacy:metadata:shortname'] = 'A short name for the course.';
$string['privacy:metadata:sid'] = 'The session ID';
$string['privacy:metadata:skype'] = 'The Skype identifier of the user';
$string['privacy:metadata:state'] = '0 means a normal session';
$string['privacy:metadata:summary'] = 'A description of the course.';
$string['privacy:metadata:theme'] = 'A user preference for the theme to display.';
$string['privacy:metadata:timeaccess'] = 'The time for access to the course.';
$string['privacy:metadata:timecreated'] = 'The time this record was created.';
$string['privacy:metadata:timemodified'] = 'The time when the record was modified';
$string['privacy:metadata:timererequested'] = 'The time the user re-requested the password reset.';
$string['privacy:metadata:timerequested'] = 'The time that the user first requested this password reset';
$string['privacy:metadata:timezone'] = 'The timezone of the user';
$string['privacy:metadata:token'] = 'secret set and emailed to user';
$string['privacy:metadata:trackforums'] = 'A preference for forums and tracking them.';
$string['privacy:metadata:trustbitmask'] = 'The trust bit mask';
$string['privacy:metadata:yahoo'] = 'The Yahoo identifier of the user';
$string['privacy:metadata:url'] = 'A URL related to this user.';
$string['privacy:metadata:userid'] = 'The user ID linked to this table.';
$string['privacy:metadata:usertablesummary'] = 'This table stores the main personal data about the user.';
$string['privacy:metadata:uuid'] = 'The device vendor UUID';
$string['privacy:metadata:version'] = 'The device version, 6.1.2, 4.2.2 etc..';
$string['privacy:passwordhistorypath'] = 'Password history';
$string['privacy:passwordresetpath'] = 'Password resets';
$string['privacy:profileimagespath'] = 'Profile images';
$string['privacy:privatefilespath'] = 'Private files';
$string['privacy:sessionpath'] = 'Session data';
$string['filterbykeyword'] = 'Keyword';
$string['supportmessagesent'] = 'Your message has been sent.';
$string['supportmessagesentforloggedoutuser'] = 'Be careful with this message. The sender was not logged in, so their identity has not been confirmed.';
$string['supportmessagenotsent'] = "Unfortunately your message could not be sent.";
$string['supportmessagealternative'] = 'Instead you can email {$a}.';
$string['target:upcomingactivitiesdue'] = 'Upcoming activities due';
$string['target:upcomingactivitiesdue_help'] = 'This target generates reminders for upcoming activities due.';
$string['target:upcomingactivitiesdueinfo'] = 'All upcoming activities due insights are listed here. These students have received these insights directly.';
$string['userprofile'] = 'User profile';

// Deprecated since Moodle 4.1.
$string['addcondition'] = 'Add condition';
$string['adverbfor_and'] = 'and';
$string['adverbfor_andnot'] = 'and';
$string['adverbfor_or'] = 'or';
$string['applyfilters'] = 'Apply filters';
$string['clearfilterrow'] = 'Remove filter row';
$string['clearfilters'] = 'Clear filters';
$string['filtersetmatchdescription'] = 'How multiple filters should be combined';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filtertype'] = 'Filter type';
$string['match'] = 'Match';
$string['matchofthefollowing'] = 'of the following:';
$string['selectfiltertype'] = 'Select';
$string['placeholdertypeorselect'] = 'Type or select...';
$string['clearfilterselection'] = 'Remove "{$a}" from filter';
