<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_capexplorer', language 'sv', version '4.1'.
 *
 * @package     tool_capexplorer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assigned'] = 'Tilldelad';
$string['autoassign'] = 'Automatiskt tilldelad';
$string['autoassignment'] = 'Automatisk tilldelning';
$string['autoassignment_help'] = 'Vissa roller kan automatiskt tilldelas användare i systemkontexten. Rollerna kan anges under <em>Hantera webbplats -> Användare -> Behörigheter -> Användarprinciper</em>';
$string['capability'] = 'Funktion';
$string['capability_help'] = '<p>Välj en funktion att kontrollera.</p><p>Detta fältet använder automatiskt komplettering, så börja skriva namnet på en funktion och välj sedan från de alternativ som visas.</p>';
$string['capabilityplaceholder'] = 'Ange funktion';
$string['capdenied'] = 'Falskt (Nekad)';
$string['capexplorer:view'] = 'Visa funktionsutforskaren';
$string['capexplorerresult'] = 'Översiktligt resultat';
$string['capexplorersummary'] = '<p>Funktionsutforskaren är ett verktyg för att förklara hur Moodles system för funktionsbehörigheter fungerar. Skicka formuläret nedan för att få en förklaring av hur funktionsbehörigheten beräknas.</p>';
$string['capgranted'] = 'Sant (Tillåten)';
$string['change'] = 'Ändra';
$string['combineusingcontextaggregation'] = '<p>Kombinera de enskilda behörigheterna med hjälp av kontextaggregeringsregler {$a} för att få en summering av rollbehörigheterna.</p>';
$string['context'] = 'Kontext';
$string['context_help'] = '<p>Du måste ange en <em>kontext-instans</em> att kontrollera en funktionsbehörighet mot. I trädet visas hierarkin för alla kontextinstanserna på webbplatsen.</p> <p>Expandera noder genom att klicka på pilen för att se mer specifika underordnade sammanhang. Välj en förekomst genom att klicka på namnet.</p> <p>Ikonerna representerar <em>kontextnivån</em> för varje instans:</p> <p> <div class="capexplorer-tree-label capexplorer-tree-system">System (Webbplats) kontext</div> <div class="capexplorer-tree-label capexplorer-tree-user">Användarkontext</div> <div class="capexplorer-tree-label capexplorer-tree-category">Kategori-kontext</div> <div class="capexplorer-tree-label capexplorer-tree-course">Kurskontext</div> <div class="capexplorer-tree-label capexplorer-tree-module">Modul-kontext</div> <div class="capexplorer-tree-label capexplorer-tree-block">Block-kontext</div> </p>';
$string['contextaggrrules'] = 'Sammanställningsregler för kontext';
$string['contextaggrrules_help'] = '<p>För att fastställa summan för en viss roll sammanställer du behörigheterna i varje kontext med hjälp av reglerna nedan:</p> <ol> <li>Om "Förbjud" visas i något sammanhang är rollsumman "Förbjud".</li> <li>Om alla kontexter har behörigheten "Ej inställd" är rollsumman "Ej inställd".</li> <li>Annars är rollsumman densamma som den mest specifika behörigheten som är inställd (dvs. det tillåta eller förhindra som är närmast det sammanhang där funktionsbehörigheten kontrolleras).</li> </ol>';
$string['contextinfo'] = '{$a->contextstring} ({$a->contextlevel} kontext)';
$string['contextlevel'] = 'Kontextnivå';
$string['error:invalidcapability'] = 'Det finns ingen funktion med namnet ”{$a}”';
$string['error:invalidcontext'] = 'Du måste välja en kontextinstans';
$string['error:invalidusername'] = 'Det finns ingen användare med användarnamn ”{$a}”';
$string['error:missingcapability'] = 'Du måste ange en funktion';
$string['error:missingusername'] = 'Du måste ange ett användarnamn';
$string['exploreanother'] = '&laquo; Utforska en annan funktion';
$string['finalresultsummary'] = '<p>Slutligen -  kombinera rollsummorna med hjälp av rollaggregeringsreglerna {$a} för att få det övergripande resultatet.</p>';
$string['guestaccessblocked'] = '<p>OBS! Som en extra säkerhetsåtgärd förhindrar Moodle att oprivivilegierade användare beviljas "riskfyllda" funktioner. "{$a->capability}" anses riskabel eftersom den kan användas för att redigera eller ta bort data, ändra webbplatskonfiguration eller lägga till potentiellt skadliga skript på webbplatssidor. Resultaten nedan visar hur deras behörighet skulle beräknas om funktionen inte ansågs riskabel.</p>';
$string['instancename'] = 'Instansnamn';
$string['manualassign'] = 'Manuellt tilldelad';
$string['manualassignment'] = 'Manuell tilldelning';
$string['manualassignment_help'] = 'Roller tilldelade direkt till en användare, t.ex. via \'Tilldela systemroller\' eller via kursregistreringar.';
$string['none'] = 'Inga';
$string['nopermtoassign'] = 'Ingen behörighet';
$string['nopermtoassign_help'] = '<p>Inte alla användare har behörighet att tilldela roller till andra användare. Möjligheten att tilldela roller är beroende av dina egna roller och kan styras här:</p><p><em>Hantera webbplats &gt; Användare &gt; Behörigheter &gt; Definiera roller &gt; Tillåt rolltilldelningar</em></p><p>Dessutom måste användaren ha funktionsbehörigheten <code>moodle/role:assign</code> i kontexten där rolltilldelningen äger rum.</p> <p>Webbplatsens administratörer kan tilldela alla roller.</p>';
$string['nopermtoautoassign'] = 'Ingen behörighet';
$string['nopermtoautoassign_help'] = 'Inte alla användare har behörighet att ändra automatiskt tilldelade roller. Möjligheten att ändra dessa användarprinciper styrs av funktionsbehörigheten <code>moodle/site:config</code> i systemkontexten.';
$string['nopermtodefinerole'] = 'Ingen behörighet';
$string['nopermtodefinerole_help'] = 'Möjligheten att definiera rollbehörigheter kräver funktionsbehörigheten <code>moodle/role:manage</code> i systemkontexten. Användare med behörighet kan styra rolldefinitioner här:</p><p><em>Hantera webbplats &gt; Användare &gt; Behörigheter &gt; Definiera roller </p><p>Den aktuella användaren har inte den här behörigheten och kan inte ändra rolldefinitioner.</p>';
$string['nopermtooverride'] = 'Ingen behörighet';
$string['nopermtooverride_help'] = 'Inte slla användare har behörighet att åsidosätta roller. Möjligheten att åsidosätta roller är beroende av dina egna roller och kan styras här:</p><p><em>Hantera webbplats &gt; Användare &gt; Behörigheter &gt; Definiera roller &gt; Tillåt rollåsidosättningar</em></p><p>Dessutom måste användaren ha funktionsbehörigheten <code>moodle/role:override</code> eller <code>moodle/role:safeoverride</code> i kontexten där åsidosättningen äger rum.</p> <p>Webbplatsens administratörer kan åsidosätta alla roller.</p>';
$string['notassignable'] = 'Kan ej tilldelas';
$string['notassignable_help'] = '<p>Varje roll definierar kontextnivåerna där rollen kan tilldelas.</p> <p>Detta kan skräddarsys genom att inställningen "Kontexttyper där den här rollen kan tilldelas" i rolldefinitionen:</p><p><em>Hantera webbplats &gt; Användare &gt; Behörigheter &gt; Definiera roller &gt; [Rollnamn] &gt; Redigera</em>.</p>';
$string['notassigned'] = 'Ej tilldelad';
$string['notoverridable'] = 'Ej möjlig att åsidosätta';
$string['notoverridable_help'] = '<p>Varje funktionsbehörighet definierar en kontextnivå som är den lägsta nivån som kontexten kommer att kontrolleras på. Under denna nivå är funktionsbehörighet inte möjlig att åsidosätta eftersom åsidosättningen inte kommer att ha någon effekt.</p> <p>Detta förhindrar att funktioner som uppenbarligen inte är tillämpliga i mer specifika sammanhang kan belamra åsidosättningssidan.</p> <p>I detta fall har den funktionsbehörighet som kontrolleras angett en högre kontextnivå och det är inte möjligt att åsidosätta den på denna nivå.</p>';
$string['overallresult'] = 'Översiktligt resultat';
$string['parentcontexts'] = 'Överordnade kontext';
$string['parentcontexts_help'] = '<p>På grund av behörighetssystemets hierarkiska karaktär kan tilldelningar i valfri överordnad kontext påverka en kontroll av en funktionsbehörighet i en underordnad kontext. Därför är det första steget att bestämma alla sammanhang mellan systemnivå och kontexten som kontrolleras.</p>';
$string['parentcontextssummary'] = '<p>Bestäm alla kontextnivåer mellan systemnivå och den kontext som ska kontrolleras.</p>';
$string['permission'] = 'Behörighet';
$string['permissionallow'] = 'Tillåt';
$string['permissioninherit'] = 'Ärv';
$string['permissionnotset'] = 'Ej angiven';
$string['permissionprevent'] = 'Förhindra';
$string['permissionprohibit'] = 'Förbjud';
$string['permissionunknown'] = 'Okänd';
$string['pluginname'] = 'Utforskare för funktionsbehörigheter';
$string['result'] = 'Resultat';
$string['resultdiffersfromaccesslib'] = '<p>Resultatet som beräknas av det här verktyget stämmer inte överens med resultatet från systemkoden!</p> <p>Du kan prova <a href="{$a->cacheurl}">tömma din cache</a>, men, om det inte hjälper, är detta förmodligen en bugg i Utforskaren för funktionsbehörigheter. Vänligen <a href="{$a->bugurl}">kontakta oss</a> och, om du har möjlighet, inkludera en skärmdump av denna sida för att hjälpa oss att spåra problemet.</p>';
$string['role'] = 'Roll';
$string['roleaggrrules'] = 'Sammanställningsregler för roll';
$string['roleaggrrules_help'] = '<p>För att fastställa det övergripande resultatet aggregerar du behörigheterna från alla roller med hjälp av reglerna nedan:</p> <ol> <li>Om "Förbjud" visas i någon rollsumma blir det övergripande resultatet "Nekad".</li> <li>Annars, om en rolls total är "Tillåt" blir det övergripande resultatet "Beviljad".</li> <li>Om inga av rollsumserna är "Tillåt" blir det övergripande resultatet "Nekad".</li> </ol>';
$string['roleassignmentsforuserx'] = '<p>Nedan är alla roller som har tilldelningar för "{$a}" i någon av de sammanhang som anges ovan:</p>';
$string['roleassignmentsummary'] = '<p>Bestäm vilka roller som tilldelats användaren i någon av de överordnade sammanhangen. Endast roller som har tilldelats i en av de överordnade kontexterna bidrar till slutresultatet.</p>';
$string['rolepermissionsandoverridesforcapx'] = '<p>Alla rollbehörigheter och åsidosättningar för funktionen "{$a}"</p>';
$string['rolepermissionsummary'] = '<p>För varje tilldelad roll listas behörigheten från rolldefinitionen för systemkontexten. Visa även eventuella rollåsidosättningar i någon av de överordnade kontexten.</p>';
$string['roletotal'] = 'Rollsummering';
$string['roletotals'] = 'Rollsummeringar';
$string['step1'] = 'Steg1: Överliggande kontext';
$string['step2'] = 'Steg 2: Rolltilldelningar';
$string['step3'] = 'Steg 3: Rollbehörigheter och åsidosättanden';
$string['step4'] = 'Steg 4: Sammanställ över kontext';
$string['step5'] = 'Steg 5: Sammanställ över roller';
$string['systemcontext'] = 'System (webbplats) kontext';
$string['user'] = 'Användare';
$string['usercontext'] = 'Användarkontext';
$string['userisadmin'] = '<p>OBS! "{$a->user}" är en <a href="{$a->url}">webbplatsadministratör</a> och som sådana beviljas de automatiskt alla funktioner. Resultaten nedan visar hur deras åtkomst skulle beräknas utan behörighet för webbplatsadministratören.</p>';
$string['username'] = 'Användarnamn';
$string['username_help'] = '<p>Välj en användare som ska kontrolleras.</p> <p>Detta fält kompletteras automatiskt, så börja skriva ett användarnamn, e-postadress eller användarens namn och välj bland de alternativ som visas.</p>';
$string['usernameplaceholder'] = 'Ange namn, användarnamn eller e-postadress';
$string['xfrontpage'] = '{$a} (Förstasida)';
