<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'el', version '4.1'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'Το Moodle είναι δωρεάν για να το κατεβάσει κανείς και η καταχώρηση είναι προαιρετική, οπότε δεν έχουμε πλήρη δεδομένα για όλους όσους το χρησιμοποιούν. Πάντως, από τις πληροφορίες που συλλέγουμε, δημιουργούμε αυτόματα κάποιες ενδιαφέρουσες γραφικές παραστάσεις και αριθμούς στην σελίδα στατιστικών μας.';
$string['aboutstatisticsheading'] = 'Στατιστικά Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Στατιστικά Moodle';
$string['activeusers24hours'] = 'Καταχωρημένοι χρήστες που είχαν πρόσβαση στις τελευταίες 24 ώρες:';
$string['activeuserspastmonth'] = 'Καταχωρημένοι χρήστες που είχαν πρόσβαση τον περασμένο μήνα:';
$string['browsegittitle'] = 'Περιηγηθείτε στον πηγαίο κώδικά μας';
$string['cachedef_frontpagecolumn'] = 'Στήλες πρώτης σελίδας';
$string['cachedef_usefulposts'] = 'Χρήσιμες αναρτήσεις';
$string['communities'] = 'Κοινότητες';
$string['communitiesmy'] = 'Οι κοινότητές μου';
$string['community'] = 'Κοινότητα';
$string['communityadministration'] = 'Διαχείριση κοινότητας';
$string['communitycurrent'] = 'Τρέχουσα κοινότητα';
$string['communityenrolme'] = 'Γίνετε μέλος αυτής της κοινότητας';
$string['communityenrolmentoptions'] = 'Ένταξη σε μια κοινότητα';
$string['communityintro'] = 'Το Moodle έχει μια μεγάλη και ποικίλη κοινότητα με πάνω από <a href="http://moodle.org/userpics">{$a->usercount} καταχωρημένους χρήστες</a> σε αυτόν τον ιστότοπο Moodle μόνο, μιλάει πάνω από <a href="http://download.moodle.org/langpack/">{$a->langcount} γλώσσες</a> σε <a href="http://moodle.org/sites">{$a->countrycount} χώρες</a> (έχουμε <a href="http://moodle.org/stats">κι άλλα στατιστικά</a>).';
$string['communityjoinbyyourself'] = 'Ενταχθείτε μόνοι σας';
$string['communityjoinbyyourselfas'] = 'Ενταχθείτε μόνοι σας ως {$a->rolename}';
$string['communitynoguestaccess'] = 'Οι επισκέπτες δεν μπορούν να έχουν πρόσβαση σε αυτή την περιοχή κοινότητας. Παρακαλούμε, προσπαθήστε να συνδεθείτε.';
$string['communitynotenrollable'] = 'Δεν μπορείτε να γίνετε μέλος αυτής της κοινότητας μόνος σας. Παρακαλούμε, επικοινωνήστε με τον συντονιστή της κοινότητάς σας.';
$string['communitysomeallowguest'] = 'Κάποιες κοινότητες ίσως επιτρέπουν πρόσβαση επισκέπτη';
$string['communityunenrolme'] = 'Αποχωρήστε από την κοινότητα {$a}';
$string['conferencecenter'] = 'Κέντρο Διασκέψεων Moodle';
$string['connectedsites'] = 'Κάποιοι ιστότοποι Moodle έχουν συνδεθεί με το moodle.org χρησιμοποιώντας τη λειτουργικότητα δικτύωσης του Moodle, ώστε να μπορείτε να συνδεθείτε απευθείας σε αυτούς, μόλις αυθεντικοποιηθείτε εδώ.';
$string['donations10over'] = 'Άλλες δωρεές ύψους $10 ή παραπάνω';
$string['donationsassociation'] = 'Εγγραφείτε στον <a href="https://moodleassociation.org/">Όμιλο Moodle</a> - Βοηθήστε να αποφασίσουμε πώς θα πρέπει να δαπανώνται τα τέλη συνδρομής για τα στοιχεία του χάρτη πορείας εργασιών μας';
$string['donationsdevelopment'] = 'Ωστόσο, η ανάπτυξη του Moodle και η συντήρηση όλων των ιστοτόπων της κοινότητάς μας κοστίζουν πολλά χρήματα και μπορούμε πάντα να χρησιμοποιήσουμε επιπλέον υποστήριξη. Εάν σας αρέσει το Moodle ή το θεωρείτε χρήσιμο για την επιχείρηση, το σχολείο ή το ίδρυμα σας, παρακαλούμε να κάνετε μια δωρεά. Κάθε κομμάτι βοηθά.';
$string['donationsdonatenow'] = 'Δωρεά τώρα';
$string['donationsensure'] = 'Οι δωρεές διασφαλίζουν ότι τα βασικά γρανάζια της μηχανής Moodle (οι προγραμματιστές μας) συνεχίζουν να δημιουργούν νέα χαρακτηριστικά και να διορθώνουν σφάλματα, καθιστώντας το Moodle καλύτερο για όλους μας.';
$string['donationsmoodle'] = 'Δωρεές προς το Moodle';
$string['donationsopensource'] = 'Το Moodle είναι αληθινά ανοικτού κώδικα και εντελώς δωρεάν για τους χρήστες μας - έτσι πρέπει να είναι το λογισμικό!';
$string['donationsover1000'] = 'Προηγούμενες δωρεές άνω των $1000';
$string['donationsover200'] = 'Άλλες δωρεές άνω των $200';
$string['donationsover500'] = 'Άλλες δωρεές άνω των $500';
$string['donationspartner'] = 'Χρησιμοποιήστε έναν <a href="https://moodle.com/partners/">Πιστοποιημένο Συνεργάτη Moodle</a> για υπηρεσίες - 10% των εσόδων του συνεισφέρεται στο έργο του Moodle.';
$string['donationsshop'] = 'Αγοράστε κάτι από το <a href="http://www.zazzle.com/moodle_hq/">Κατάστημα Moodle</a> και χρησιμοποιήστε το με υπερηφάνεια!';
$string['donationsthankeveryone'] = 'Ευχαριστούμε όλους όσους συνέβαλαν στο έργο Moodle.';
$string['donationsthankyou'] = 'Σας ευχαριστούμε';
$string['donationstitle'] = 'Δωρεές';
$string['donationsways'] = 'Άλλοι τρόποι να συνεισφέρετε οικονομικά στο Moodle:';
$string['download_activities'] = 'Δραστηριότητες';
$string['download_admintools'] = 'Εργαλεία διαχειριστή';
$string['download_appdocumentation'] = 'Τεκμηρίωση εφαρμογής κινητού';
$string['download_appreleasenotes'] = 'Σημειώσεις έκδοσης/διανομής';
$string['download_browseall'] = 'Αναζήτηση όλων';
$string['download_downloadosx'] = 'Λήψη του Moodle για OS X (Περιέχει τα Moodle, Apache, MySQL και PHP για εκτέλεση σε λειτουργικό σύστημα Mac OS)';
$string['download_downloadwindows'] = 'Λήψη του Moodle για Windows (Περιέχει τα Moodle, Apache, MySQL και PHP για εκτέλεση σε λειτουργικό σύστημα Windows)';
$string['download_forandroid'] = 'Για Android';
$string['download_forios'] = 'Για iOS';
$string['download_helpbox_description'] = 'Διαβάστε την τεκμηρίωση για να ξεκινήσετε και επισκεφθείτε τα φόρουμ της κοινότητας ή απλά επικοινωνήστε με έναν συνεργάτη Moodle για φιλοξενία, εγκατάσταση και άλλες υπηρεσίες.';
$string['download_helpbox_installing'] = 'Εγκατάσταση του Moodle';
$string['download_helpbox_partners'] = 'Συνεργάτες Moodle';
$string['download_helpbox_support'] = 'Φόρουμ υποστήριξης';
$string['download_helpbox_title'] = 'Χρειάζεστε βοήθεια;';
$string['download_helpbox_upgrading'] = 'Αναβάθμιση του Moodle';
$string['download_hero_description'] = 'Είναι υπό την <a class="link" href="http://docs.moodle.org/dev/License">Άδεια GPL</a>, που σημαίνει ότι ο καθένας είναι ελεύθερα εξουσιοδοτημένος να χρησιμοποιεί και να απολαμβάνει τα οφέλη του λογισμικού μας.<br><br>Δείτε την τελευταία έκδοση του Moodle.';
$string['download_hero_headline'] = 'Το Moodle είναι λογισμικό ανοικτού κώδικα.';
$string['download_langpackinfo'] = 'Τα πακέτα γλώσσας δημιουργούνται αυτόματα από την εργασία των μεταφραστών στον <a href="http://lang.moodle.org/">Ιστότοπο μετάφρασης</a>. Για περισσότερες λεπτομέρειες, ανατρέξτε στην <a href="https://docs.moodle.org/dev/Translation">Τεκμηρίωση μετάφρασης</a>.';
$string['download_langpackinstallinfo'] = 'Πρόσθετα πακέτα γλώσσας μπορούν να εγκατασταθούν στον Moodle ιστότοπό σας μέσω της επιλογής <em>Διαχείριση> Διαχείριση ιστοτόπου> Γλώσσα> Πακέτα γλώσσας</em> του μενού, ή χειροκίνητα. Για περισσότερες λεπτομέρειες, ανατρέξτε στην <a href="https://docs.moodle.org/en/Language_packs">Τεκμηρίωση πακέτων γλώσσας</a>.';
$string['download_langpackinstalltitle'] = 'Εγκατάσταση γλωσσικού πακέτου';
$string['download_langpacktitle'] = 'Πακέτα γλώσσας για το Moodle {$a}';
$string['download_mobileapp'] = 'Εφαρμογή κινητού';
$string['download_themes'] = 'Αισθητικά θέματα';
$string['download_viewallbuilds'] = 'Προβολή όλων των εσωτερικών εκδόσεων (Απαιτεί να εκτελούνται, ένας εξυπηρετητής ιστού, PHP και βάση δεδομένων)';
$string['downloadcore'] = 'Η κύρια μέθοδος διανομής μας είναι μέσω αυτών των βασικών πακέτων πυρήνα. Περιέχουν έναν αριθμό αρθρωμάτων που διατηρούνται από έναν πυρήνα βασικών προγραμματιστών και είναι κατάλληλα για εγκατάσταση σε σχεδόν οποιαδήποτε πλατφόρμα όπου έχετε ήδη εγκαταστήσει την PHP και μια βάση δεδομένων.';
$string['downloadcoretitle'] = 'Τυπικά πακέτα του Moodle';
$string['downloadintro'] = 'Το Moodle είναι ανοικτού κώδικα υπό την <a href="http://docs.moodle.org/dev/License">άδεια GPL</a>. Όλα όσα παράγουμε είναι διαθέσιμα για να μπορείτε να τα κατεβάζετε και να τα χρησιμοποιείτε δωρεάν.';
$string['downloadlang'] = 'Στις τρέχουσες εκδόσεις του Moodle, η προσθήκη υποστήριξης για νέες γλώσσες έχει αυτοματοποιηθεί από το μενού διαχείρισης μέσα στον ιστότοπό σας. Ωστόσο, για μερικές παλαιότερες εκδόσεις του Moodle, τα νέα πακέτα γλώσσας πρέπει να ληφθούν χειροκίνητα.';
$string['downloadlangtitle'] = 'Πακέτα γλώσσας';
$string['downloadmac'] = 'Αν δεν έχετε ήδη δημιουργήσει έναν εξυπηρετητή ιστού, αυτά τα όλα-σε-ένα πακέτα καθιστούν πολύ εύκολη την εγκατάσταση του Moodle σε οποιονδήποτε υπολογιστή της Apple με Mac OS X.';
$string['downloadmactitle'] = 'Moodle για Mac OS X';
$string['downloadmodules'] = 'Περιηγηθείτε στην περιεκτική μας βάση δεδομένων για ακόμη περισσότερα αρθρώματα και πρόσθετα/επεκτάσεις που μπορούν να προστεθούν στον ιστότοπο Moodle για να του δώσουν επιπλέον λειτουργικότητες πέρα από τα βασικά πακέτα.';
$string['downloadmodulestitle'] = 'Πρόσθετα';
$string['downloadthemes'] = 'Η εμφάνιση ενός ιστοτόπου Moodle μπορεί να αλλάξει δραματικά χρησιμοποιώντας ένα διαφορετικό αισθητικό θέμα. Διατηρούμε μια βάση δεδομένων με θέματα που έχουν δημιουργήσει και διαμοιράζονται οι χρήστες του Moodle.';
$string['downloadthemestitle'] = 'Αισθητικά θέματα';
$string['downloadviagitcvs'] = 'Άλλοι τρόποι για να κατεβάσετε το Moodle συμπεριλαμβάνουν <a href="http://docs.moodle.org/en/Git_for_Administrators">λήψεις μέσω Git</a> ή <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">λήψη μέσω CVS</a>.';
$string['downloadwin'] = 'Αν δεν έχετε ήδη δημιουργήσει έναν εξυπηρετητή ιστού, αυτά τα πακέτα όλα-σε-ένα καθιστούν πολύ εύκολη την εγκατάσταση του Moodle σε οποιονδήποτε υπολογιστή που χρησιμοποιεί Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle για Windows';
$string['erroradminonly'] = 'Μόνο οι διαχειριστές μπορούν να έχουν πρόσβαση σε αυτήν τη διεπαφή.';
$string['erroralreadyvoted'] = 'Έχετε ήδη ψηφίσει για {$a}';
$string['errormaxmessages'] = 'Λυπούμαστε, αλλά δεν μπορείτε να αποστείλετε περισσότερα από 3 μηνύματα.';
$string['errornomainnews'] = 'Αδυναμία εύρεσης ή δημιουργίας ενός κύριου φόρουμ ανακοινώσεων για τον ιστότοπο';
$string['errorsendingmail'] = 'Παρουσιάστηκε σφάλμα κατά την αποστολή του μηνύματος. Παρακαλούμε, προσπαθήστε ξανά αργότερα, ή επικοινωνήστε με τον διαχειριστή του ιστοτόπου.';
$string['eventdonation_created'] = 'Η αναφορά δωρεάς δημιουργήθηκε';
$string['eventdonation_submitted'] = 'Η δωρεά υποβλήθηκε';
$string['events'] = 'Παρόλο που ειδικευόμαστε στην ηλεκτρονική μάθηση, είναι ακόμα ωραίο να συγκεντρωθούμε σε μια αίθουσα! Δείτε αυτούς τους συνδέσμους για περισσότερες πληροφορίες σχετικά με τα συνέδρια μας (τα ονομάζουμε MoodleMoots) και άλλα γεγονότα.';
$string['eventstitle'] = 'Γεγονότα';
$string['feed_events'] = 'Γεγονότα';
$string['feed_events_more'] = 'Περισσότερες καταχωρήσεις ημερολογίου';
$string['feed_news'] = 'Ανακοινώσεις';
$string['feed_news_more'] = 'Δείτε όλες τις ανακοινώσεις';
$string['feed_resources'] = 'Πόροι';
$string['feed_useful'] = 'Χρήσιμες αναρτήσεις';
$string['feed_useful_more'] = 'Περισσότερες αναρτήσεις';
$string['focusbox_community'] = 'Φόρουμ υποστήριξης και κοινότητας';
$string['focusbox_community_text'] = 'Λάβετε υποστήριξη και μοιραστείτε ιδέες, στην δική σας γλώσσα.';
$string['focusbox_community_viewall'] = 'Όλες οι κοινότητες';
$string['focusbox_future'] = 'Βοηθήστε να διαμορφωθεί το μέλλον του Moodle';
$string['focusbox_future_crowdfund'] = 'Πληθοχρηματοδοτούμενα έργα';
$string['focusbox_future_gdf'] = 'Συζητήσεις προγραμματιστών';
$string['focusbox_future_research'] = 'Έρευνα Moodle';
$string['focusbox_future_roadmap'] = 'Χάρτης πορείας εργασίας';
$string['focusbox_future_text'] = 'Βρείτε τι έρχεται και βοηθήστε να κάνουμε τη διαφορά.';
$string['focusbox_settingup'] = 'Εγκατάσταση';
$string['focusbox_settingup_community'] = 'Υποστήριξη κοινότητας';
$string['focusbox_settingup_download'] = 'Δωρεάν λήψη';
$string['focusbox_settingup_hosting'] = 'Φιλοξενία';
$string['focusbox_settingup_install'] = 'Εγκατάσταση';
$string['focusbox_settingup_own'] = 'Μόνος σας';
$string['focusbox_settingup_partner'] = 'Μέσω ενός Συνεργάτη Moodle';
$string['focusbox_settingup_plugins'] = 'Πρόσθετα';
$string['focusbox_settingup_support'] = 'Εμπορική υποστήριξη';
$string['focusbox_teaching'] = 'Διδασκαλία με το Moodle';
$string['focusbox_teaching_books'] = 'Βιβλία';
$string['focusbox_teaching_courses'] = 'Μαθήματα και περιεχόμενο';
$string['focusbox_teaching_docs'] = 'Τεκμηρίωση';
$string['focusbox_teaching_text'] = 'Εξερευνήστε την μεγάλη ποικιλία χαρακτηριστικών και διαθέσιμων πόρων του Moodle.';
$string['focusbox_theproject'] = 'Το έργο Moodle';
$string['focusbox_theproject_about'] = 'Σχετικά με το Moodle';
$string['focusbox_theproject_devs'] = 'Προγραμματιστές';
$string['focusbox_theproject_hq'] = 'Επιτελείο Moodle HQ';
$string['focusbox_theproject_partners'] = 'Συνεργάτες Moodle';
$string['focusbox_theproject_stats'] = 'Στατιστικά';
$string['focusbox_theproject_text'] = 'Μάθετε περισσότερα για το έργο Moodle και τις ανοικτές συνεργασίες μας.';
$string['focusbox_uptodate'] = 'Ενημερωθείτε';
$string['focusbox_uptodate_buzz'] = 'Moodle φήμες';
$string['focusbox_uptodate_news'] = 'Ανακοινώσεις';
$string['focusbox_uptodate_planet'] = 'Πλανήτης Moodle';
$string['focusbox_uptodate_security'] = 'Ανακοινώσεις ασφάλειας';
$string['focusbox_uptodate_social'] = 'Κοινωνικά μέσα';
$string['focusbox_uptodate_text'] = 'Τελευταία νέα, ενημερώσεις και γενική εικόνα του Moodle ανά τον κόσμο.';
$string['generaldeveloperforum'] = 'Γενικό φόρουμ προγραμματιστών';
$string['graphpopulation'] = 'Γραφική παράσταση πληθυσμού Moodle';
$string['graphregistrationmap'] = 'Χάρτης καταχωρήσεων Moodle';
$string['graphregistrationmapdesc'] = 'Λίστα με τους 10 κορυφαίους καταχωρημένους ιστοτόπους σε {$a} χώρες';
$string['graphusersites'] = 'Σύγκριση χρηστών ανά ιστότοπο Moodle';
$string['heroslide_community_description'] = 'Καλώς ορίσατε στην κοινότητα του Moodle! Ανακαλύψτε την αξία μιας ανοικτής, συνεργατικής προσπάθειας μιας από τις μεγαλύτερες ομάδες ανοικτού λογισμικού στον κόσμο.';
$string['heroslide_community_headline'] = 'Καθοδηγείται από την κοινότητα· υποστηρίζεται από όλους.';
$string['heroslide_community_slidecontrol'] = 'Υποστηρίζεται από μια παγκόσμια κοινότητα';
$string['heroslide_donate_headline'] = 'Βοηθήστε μας να κάνουμε τη διαφορά με την ανοιχτή και ποιοτική εκπαίδευση για όλους';
$string['heroslide_getstarted_description'] = 'Το Moodle είναι το πιο δημοφιλές σύστημα διαχείρισης μάθησης στον κόσμο. Ξεκινήστε να δημιουργείτε τον ιστότοπό σας για εκπαίδευση εντός σύνδεσης μέσα σε λίγα λεπτά!';
$string['heroslide_getstarted_headline'] = 'Το ξεκίνημα είναι εύκολο';
$string['heroslide_getstarted_slidecontrol'] = 'Ξεκινήστε σήμερα';
$string['heroslide_global_description'] = 'Διαθέσιμο σε πάνω από 100 γλώσσες, το Moodle το εμπιστεύονται οργανισμοί και ιδρύματα, μεγάλα και μικρά, με εκατομμύρια χρήστες σε όλο τον κόσμο.';
$string['heroslide_global_headline'] = 'Παρέχει μαθησιακά περιβάλλοντα σε όλο τον κόσμο';
$string['heroslide_global_slidecontrol'] = 'Παρέχει μαθησιακά περιβάλλοντα σε όλο τον κόσμο';
$string['heroslide_link_demo'] = 'Δοκιμαστικό';
$string['heroslide_link_donate'] = 'Δωρίστε';
$string['heroslide_link_features'] = 'Χαρακτηριστικά';
$string['heroslide_link_forums'] = 'Τα φόρουμ κοινότητας';
$string['heroslide_link_getstarted'] = 'Ξεκινήστε σήμερα';
$string['heroslide_link_sites'] = 'Καταχωρημένοι ιστότοποι';
$string['heroslide_link_stats'] = 'Στατιστικά';
$string['heroslide_link_stories'] = 'Διαβάστε περισσότερα';
$string['heroslide_power_description'] = 'Η παγκόσμια ελεύθερη μαθησιακή πλατφόρμα που σας βοηθά να δημιουργήσετε διδακτικές και μαθησιακές εμπειρίες εντός σύνδεσης σε ένα συνεργατικό, ιδιωτικό περιβάλλον.';
$string['heroslide_power_headline'] = 'Δυνατότητες. Ασφάλεια. Ανοικτός κώδικας.';
$string['heroslide_power_slidecontrol'] = 'Ισχυρή μαθησιακή πλατφόρμα ανοικτού κώδικα';
$string['heroslide_story1_description'] = '«Η πρωτοπορία στην μάθηση με αξιοποίηση των δυνατοτήτων της τεχνολογίας μας δίνει τη δυνατότητα να διευκολύνουμε την ανακάλυψη, τη δημιουργικότητα και τις ευκαιρίες των μαθητών» καθηγητής Darrell Evans, αντιπρύτανης του Πανεπιστημίου Monash (Αυστραλία)';
$string['heroslide_story1_headline'] = 'Βελτίωση της διδασκαλίας και της μάθησης παντού';
$string['heroslide_story2_description'] = 'Η GAC, παγκόσμια εταιρεία ναυτιλίας, εφοδιαστικής και πάροχος θαλάσσιων υπηρεσιών, προσφέρει πρωτοβουλίες μάθησης και ανάπτυξης σε 10.000  εργαζόμενους σε 70  χώρες με την εταιρική της ακαδημία.';
$string['heroslide_story2_headline'] = 'Επίτευξη αριστείας στην εταιρική μάθηση';
$string['heroslide_story3_description'] = 'Το Forth Valley College είναι ένα από τα μεγαλύτερα κολέγια της Σκωτίας, παρέχοντας περισσότερα από 750 προγράμματα σπουδών με περισσότερους από 20.000 ενεργούς χρήστες στους χώρους τους.';
$string['heroslide_story3_headline'] = 'Παροχή ολοκληρωμένης ευέλικτης εκπαίδευσης';
$string['heroslide_story4_description'] = 'Η VSO (εθελοντική υπηρεσία στο εξωτερικό) παρέχει διαδραστική μάθηση και υποστήριξη για εθελοντές σε διεθνές επίπεδο ώστε να επιτρέπει παγκόσμιες εκπαιδευτικές προσεγγίσεις.';
$string['heroslide_story4_headline'] = 'Βοηθώντας εθελοντές να υλοποιούν προγράμματα για την καταπολέμηση της φτώχειας';
$string['heroslide_story5_description'] = '';
$string['heroslide_story5_headline'] = '';
$string['heroslide_story_slidecontrol'] = 'Ιστορίες σχετικά με το Moodle από όλο τον κόσμο';
$string['jobs'] = 'Επισκεφτείτε την βάση δεδομένων μας ευκαιριών εργασίας για πληροφορίες σε σχετικές με το Moodle θέσεις σε όλο τον κόσμο.';
$string['logoinfo'] = 'Το όνομα Moodle™ είναι σήμα κατατεθέν του Moodle Trust (καταπίστευμα ή εμπίστευμα). Αν σκοπεύετε να χρησιμοποιήσετε το όνομα ή/και το λογότυπο για να διαφημίσετε γενικές υπηρεσίες Moodle (π.χ. φιλοξενία Moodle, υποστήριξη Moodle, πιστοποίηση Moodle, εκπαίδευση Moodle, συμβουλευτικές υπηρεσίες Moodle, προσαρμογή Moodle, ανάπτυξη μαθημάτων Moodle, σχεδίαση αισθητικών θεμάτων Moodle, ενσωματώσεις Moodle, εγκαταστάσεις Moodle κλπ.) ή ως όνομα ενός πακέτου λογισμικού, τότε πρέπει να ζητήσετε και να λάβετε άμεση άδεια γραπτώς από το Moodle Trust μέσω του helpdesk [moodle.com] (http://moodle.com/helpdesk/), σύμφωνα με τους συνήθεις περιορισμούς των εμπορικών σημάτων. Δεν υπάρχουν περιορισμοί σχετικά με τον τρόπο χρήσης του ονόματος σε άλλα περιβάλλοντα (για παράδειγμα, αν χρησιμοποιείτε Moodle μόνο για να παρέχετε μαθήματα τότε μπορείτε χρησιμοποιήστε το όνομα ελεύθερα για να το αναφέρετε.) Αν δεν είστε σίγουροι για μια συγκεκριμένη περίπτωση, παρακαλούμε να μας ρωτήσετε μέσω της [υπηρεσίας υποστήριξης moodle.com] (http://moodle.com/helpdesk/). Θα είμαστε στην ευχάριστη θέση είτε να σας παρέχουμε επίσημη άδεια γραπτώς είτε να σας βοηθήσουμε να διορθώσετε τη διατύπωσή σας.';
$string['logotitle'] = 'Λογότυπο Moodle';
$string['manageads'] = 'Διαχείριση διαφημίσεων συνεργατών';
$string['managedonations'] = 'Διαχείριση δωρεών';
$string['moodleorg:manageads'] = 'Διαχείριση διαφημίσεων συνεργατών';
$string['moodleorg:managedonations'] = 'Διαχείριση του μητρώου δωρεών';
$string['moodlepartner_corporate'] = 'Εταιρική κατάρτιση';
$string['moodlepartner_other'] = 'Άλλοι τομείς';
$string['moodlepartner_school'] = 'Σχολείο';
$string['moodlepartner_university'] = 'Πανεπιστήμιο';
$string['networkinfo'] = 'Οι ακόλουθοι ιστότοποι Moodle έχουν συνδεθεί στο moodle.org με χρήση τεχνολογίας δικτύωσης Moodle κι έτσι μπορείτε να συνδεθείτε κατευθείαν από εδώ.';
$string['networktitle'] = 'Συνδεδεμένοι ιστότοποι';
$string['newregistrations'] = 'Νέες καταχωρήσεις';
$string['newstitle'] = 'Ανακοινώσεις';
$string['noenrolledcoursesyet'] = 'Δεν έχετε εγγραφεί ακόμη σε κανένα μάθημα σε αυτόν τον ιστότοπο';
$string['partnerslogan'] = 'Το έργο Moodle υποστηρίζεται από πάνω από 90 πιστοποιημένους <a href="https://moodle.com/partners/">Συνεργάτες Moodle</a> σε όλο τον κόσμο.';
$string['permalink'] = 'Μόνιμος σύνδεσμος';
$string['pluginname'] = 'Ιστότοπος Moodle.org';
$string['popularissues'] = 'Πιο δημοφιλή ζητήματα';
$string['privacy:metadata:db:registerdonations'] = 'Διατήρηση αρχείου δωρεών Moodle';
$string['privacy:metadata:db:registerdonations:amount'] = 'Δωρηθέν ποσό';
$string['privacy:metadata:db:registerdonations:name'] = 'Όνομα δωρητή';
$string['privacy:metadata:db:registerdonations:org'] = 'Οργανισμός δωρητή';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Χρονοσήμανση της δωρεάς';
$string['privacy:metadata:db:registerdonations:url'] = 'Διεύθυνση URL δωρητή';
$string['recentlyratedposts'] = 'Πρόσφατα αξιολογημένες αναρτήσεις';
$string['recentpart'] = 'Αυτή η σελίδα εμφανίζει μερικούς από τους ανθρώπους που χρησιμοποιούν το moodle.org σήμερα.';
$string['registeredsites'] = 'Τα ιδρύματα δεν απαιτείται να ενημερώσουν κανέναν όταν χρησιμοποιούν το Moodle, διότι το Moodle είναι ανοικτού κώδικα. Πάντως, κάποιοι ιστότοποι Moodle έχουν επιλέξει να καταχωρηθούν σε μας και διατηρούμε μια λίστα με αυτούς.';
$string['registeredsitestitle'] = 'Καταχωρημένοι ιστότοποι';
$string['registereduserslastday'] = 'Νέοι χρήστες τις τελευταίες 24 ώρες:';
$string['registereduserstotal'] = 'Σύνολο καταχωρημένων χρηστών:';
$string['registrationgraphalt'] = 'Όλες οι καταχωρήσεις Moodle οποτεδήποτε';
$string['registrationgraphdesc'] = 'Εκτελούμε <a href="http://docs.moodle.org/en/Usage">τακτικούς μαζικούς ελέγχους ιστοτόπων</a> για να βεβαιωθούμε ότι υπάρχουν ακόμη, οπότε περιστασιακά μπορεί να δείτε μείωση στο πλήθος τους.';
$string['registrationslast6months'] = 'Καταχωρήσεις τους τελευταίους 6 μήνες';
$string['registrationslastmonths'] = 'Καταχωρήσεις στους τελευταίους {$a} μήνες';
$string['registrationstotal'] = 'Όλες οι τρέχουσες καταχωρήσεις';
$string['resources_buzz'] = 'Φήμες';
$string['resources_courses'] = 'Μαθήματα';
$string['resources_jobs'] = 'Εργασίες';
$string['resources_plugins'] = 'Πρόσθετα';
$string['roadmap'] = 'Χάρτης πορείας εργασίας Moodle';
$string['rssdescription'] = 'Πρόσφατες ή αξιολογημένες ως χρήσιμες αναρτήσεις σε φόρουμ από το moodle.org';
$string['rssmoodlecommore'] = 'Δείτε όλα τα τελευταία νέα';
$string['rssmoodlecomtitle'] = 'Τελευταία νέα';
$string['rsstitle'] = 'Αναρτήσεις φόρουμ στο moodle.org';
$string['searchmoodleorg'] = 'Αναζήτηση στο moodle.org';
$string['securitytitle'] = 'Ανακοινώσεις ασφάλειας';
$string['shop'] = 'Ψάχνετε κάποιο τρόπο να δείξετε ότι είστε μέλος της κοινότητάς μας; Δείτε το κατάστημα μας για πουκάμισα, κούπες και πολλά άλλα πράγματα.';
$string['social-facebook-moodle'] = 'Επίσημη σελίδα του Moodle στο Facebook';
$string['social-googleplus-community'] = 'Επίσημη σελίδα της κοινότητας του Moodle στο Google+';
$string['social-googleplus-moodle'] = 'Επίσημη σελίδα του Moodle στο Google+';
$string['social-linkedin-moodle'] = 'Επίσημη σελίδα του Moodle στο LinkedIn';
$string['social-twitter-moodle'] = 'Επίσημες ανακοινώσεις Moodle, συγκεντρωμένα νέα για το Moodle από τον Πλανήτη Moodle και τις Φήμες Moodle, και χρήσιμες αναρτήσεις φόρουμ';
$string['social-twitter-moodledev'] = 'Νέα και ενημερώσεις ανάπτυξης του Moodle';
$string['social-twitter-moodlehq'] = 'Τιτιβίσματα (Tweets) από το επιτελείο του Moodle';
$string['social-twitter-moodlejobs'] = 'Προσφορά εργασίας σχετικής με Moodle';
$string['social-twitter-moodlenet'] = 'Κοινόχρηστα μαθήματα και περιεχόμενο Moodle';
$string['social-twitter-moodleplugins'] = 'Πρόσφατες κυκλοφορίες πρόσθετων Moodle';
$string['social-twitter-moodleresearch'] = 'Νέα και ενημερώσεις σχετικά με το ετήσιο Συνέδριο Έρευνας Moodle και την γενικότερη έρευνα σχετικά με το Moodle';
$string['social-twitter-moodlesecurity'] = 'Ανακοινώσεις ασφάλειας Moodle';
$string['social-twitter-moodlesites'] = 'Ενημερώσεις κατάστασης για το δίκτυο ιστοτόπων και υπηρεσιών του επιτελείου Moodle HQ';
$string['social-twitter-moodlethemes'] = 'Πρόσφατες κυκλοφορίες αισθητικών θεμάτων Moodle';
$string['social-youtube-moodle'] = 'Επίσημο κανάλι Moodle στο YouTube';
$string['socialinfo'] = 'Βρισκόμαστε σε διάφορους ιστοτόπους κοινωνικών μέσων ενημέρωσης για να βοηθήσουμε στην ευαισθητοποίηση σχετικά με το έργο του Moodle και να μοιραστούμε τα τελευταία νέα και γεγονότα στον κόσμο του Moodle. Ακολουθήστε μας για να είστε ενημερωμένοι και να συναντήσετε άλλους στην κοινότητα!';
$string['socialtitle'] = 'Κοινωνικά μέσα';
$string['statscountries'] = 'Χώρες';
$string['statscourses'] = 'Μαθήματα';
$string['statsenrolments'] = 'Εγγραφές';
$string['statsposts'] = 'Αναρτήσεις φόρουμ';
$string['statsquestions'] = 'Ερωτήσεις κουίζ';
$string['statsresources'] = 'Πόροι';
$string['statsteachers'] = 'Διδάσκοντες';
$string['statsusers'] = 'Χρήστες';
$string['supportbooks'] = 'Διατηρούμε μια λίστα πολλών βιβλίων για το Moodle που είναι διαθέσιμα για αγορά.';
$string['supportcommercial'] = 'Οι Συνεργάτες Moodle είναι Πάροχοι Υπηρεσιών Moodle σε όλο τον κόσμο, που μπορούν να σας βοηθήσουν με την Moodle υλοποίηση σας.';
$string['supportdocs1'] = 'Το Moodle Docs είναι ένα πολύ καλό μέρος για να ξεκινήσετε· ειδικά οι σελίδες μας με συχνές ερωτήσεις (FAQ).';
$string['supportdocs2'] = 'Ένας καλός τρόπος για να αποκτήσετε πρόσβαση σε σχετική τεκμηρίωση είναι να χρησιμοποιήσετε το σύνδεσμο «Αρχεία βοήθειας του Moodle για αυτή τη σελίδα» στο κάτω μέρος κάθε σελίδας στον δικό σας ιστότοπο Moodle.';
$string['supportdocsfaq'] = 'Συχνές ερωτήσεις (FAQ)';
$string['supportdocslang'] = 'Τα Moodle Docs σε άλλες γλώσσες';
$string['supportforums'] = 'Η κοινότητα των χρηστών μας επικοινωνεί ως επί το πλείστον μέσω των φόρουμ μέσα σε «μαθήματα» σε αυτόν τον ιστότοπο με βάση το Moodle. Πρέπει να «εγγραφείτε» στο μάθημα για να αναρτήσετε σε φόρουμ (η εγγραφή είναι εντελώς δωρεάν).';
$string['supportforumsenglish'] = 'Η κύρια υποστήριξη και οι συζητήσεις προγραμματιστών μεταξύ χρηστών και προγραμματιστών βρίσκονται εδώ στα αγγλικά:';
$string['supportforumsenglishname'] = 'Χρήση Moodle';
$string['supportforumslang'] = 'Το κύριο φόρουμ στα αγγλικά για κοινωνικές σχέσεις μεταξύ χρηστών Moodle είναι εδώ:';
$string['supportforumslangname'] = 'Moodle Lounge (σαλόνι)';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Έχουμε πολλά άλλα φόρουμ επίσης, σε πολλές γλώσσες:';
$string['supportforumslistname'] = 'Λίστα με όλα τα μαθήματα';
$string['supportintro'] = 'Δεν είστε μόνος σας! Υπάρχουν πολλοί και διάφοροι τρόποι να βρείτε βοήθεια για το Moodle αν χρειαστεί.';
$string['syncregistrationstask'] = 'Ενημερώσεις καταχώρησης ιστοτόπου στο moodle.net μέσω Sync 1.9';
$string['top10countriesbyregistration'] = 'Οι 10 κορυφαίες χώρες σε καταχωρήσεις';
$string['top10sitesbycourses'] = 'Οι 10 κορυφαίοι ιστότοποι σε μαθήματα';
$string['top10sitesbyusers'] = 'Οι 10 κορυφαίοι ιστότοποι σε χρήστες';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Χρησιμοποιούμενες εκδόσεις';
