<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'sr_lt', version '4.1'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Prihvati';
$string['accept_grades'] = 'Prihvati ocene alata';
$string['accept_grades_admin'] = 'Prihvati ocene alata';
$string['accept_grades_admin_help'] = 'Navedite da li provajder alata može da dodaje, ažurira. čita i briše ocene povezane sa instancama ovog alata.

Neki provajderi podržavaju mogućnost slanja ocena nazad u Moodle na osnovu akcija koje su preduzete u okviru alata, stvarajući na taj način doživljaj veće integrisanosti Moodlea i eksternog alata.';
$string['accept_grades_help'] = 'Navedite da li provajder alata može da dodaje, ažurira, čita i briše ocene povezane sa instancama ovog tipa alata.

Neki provajderi podržavaju mogućnost slanja ocena nazad u Moodle na osnovu akcija koje su preduzete u okviru alata, stvarajući na taj način doživljaj veće integrisanosti Moodlea i eksternog alata.

Imajte u vidu da se ova podešavanja mogu izmeniti u konfiguraciji alata.';
$string['accepted'] = 'Prihvaćeno';
$string['action'] = 'Akcija';
$string['activate'] = 'Aktiviraj';
$string['activatetoadddescription'] = 'Moraćete da aktivirate ovaj alat da biste mogli da dodate opis.';
$string['active'] = 'Aktivan';
$string['activity'] = 'Aktivnost';
$string['add_ltiadv'] = 'Dodaj LTI Advantage';
$string['add_ltilegacy'] = 'Dodaj Legacy LTI';
$string['addnewapp'] = 'Omogući eksternu aplikaciju';
$string['addserver'] = 'Dodaj novi pouzdani server';
$string['addtype'] = 'Dodaj prekonfigurisan alat';
$string['allow'] = 'Dozvoli';
$string['allowsetting'] = 'Dozvoli da alat unutar Moodlea  sačuva 8K podešavanja';
$string['always'] = 'Uvek';
$string['autoaddtype'] = 'Dodaj alat';
$string['automatic'] = 'Automatski, na osnovu URL adrese alata';
$string['baseurl'] = 'Osnovna URL adresa/naziv alata za prijavu';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth osnovni string';
$string['basiclti_endpoint'] = 'Krajnja tačka pokretanja LTI alata';
$string['basiclti_in_new_window'] = 'Vaša aktivnost je otvorena u novom prozoru';
$string['basiclti_in_new_window_open'] = 'Otvori u novom prozoru';
$string['basiclti_parameters'] = 'Parametri pokretanja LTI alata';
$string['basicltiactivities'] = 'LTI aktivnosti';
$string['basicltifieldset'] = 'Prilagođeni primer skupa polja';
$string['basicltiintro'] = 'Opis aktivnosti';
$string['basicltiname'] = 'Naziv aktivnosti';
$string['basicltisettings'] = 'Osnovna LTI podešavanja';
$string['cachedef_keyset'] = 'Kešira informacije o skupu ključeva alata';
$string['cancel'] = 'Otkaži';
$string['cancelled'] = 'Otkazano';
$string['cannot_delete'] = 'Ne možete da obrišete ovu konfiguraciju alata';
$string['cannot_edit'] = 'Ne možete da uredite ovu konfiguraciju alata';
$string['capabilities'] = 'Mogućnosti';
$string['capabilities_help'] = 'Izaberite one mogućnosti koje želite da ponudite dobavljaču alata. Može se izabrati više od jedne mogućnosti.';
$string['capabilitiesrequired'] = 'Ovaj alat zahteva pristup sledećim podacima kako bi bio aktiviran:';
$string['cleanaccesstokens'] = 'Uklanjanje isteklih tokena za pristup eksternom alatu';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Klikni za nastavak</a>';
$string['clientidadmin'] = 'ID oznaka klijenta';
$string['clientidadmin_help'] = 'ID oznaka klijenta je jedinstvena vrednost koja se koristi za identifikaciju alata. Kreira se automatski za svaki alat koji koristi JWT sigurnosni profil uveden u LTI verziji 1.3. ID oznaka treba da bude deo detaljnih informacija koje se prosleđuje provajderu alata kako bi on mogao da konfiguriše vezu na svom kraju.';
$string['comment'] = 'Komentar';
$string['configpassword'] = 'Podrazumevana lozinka udaljenog alata';
$string['configpreferheight'] = 'Standardna preferirana visina';
$string['configpreferwidget'] = 'Postavi dodatak za podrazumevano pokretanje';
$string['configpreferwidth'] = 'Standardna preferirana širina';
$string['configresourceurl'] = 'Podrazumevana URL adresa resursa';
$string['configtoolurl'] = 'Podrazumevana URL adresa udaljenog alata';
$string['configtypes'] = 'Omogući LTI  aplikacije';
$string['configured'] = 'Konfigurisano';
$string['confirmtoolactivation'] = 'Da li ste sigurni da želite da aktivirate ovaj alat?';
$string['contentitem'] = 'Poruka Stavke-Sadržaja';
$string['contentitem_deeplinking'] = 'Podržava Dubinsko Povezivanje (Poruka sadržaja)';
$string['contentitem_deeplinking_help'] = 'Ako je označeno, prilikom dodavanja eksternog alata biće dostupna opcija \'Izaberi sadržaj\'.';
$string['contentitem_help'] = 'Ako je označeno, prilikom dodavanja eksternog alata biće dostupna opcija \'Izaberi sadržaj\'.';
$string['contentitem_multiple_description'] = 'Sledeće stavke će biti dodati vašem kursu:';
$string['contentitem_multiple_graded'] = 'Ocenjena aktivnost (maksimalna ocena: {$a})';
$string['course_tool_types'] = 'Alati kursa';
$string['courseactivitiesorresources'] = 'Aktivnosti i resursi kursa';
$string['courseid'] = 'ID broj kursa';
$string['courseinformation'] = 'Informacije o kursu';
$string['courselink'] = 'Idi na kurs';
$string['coursemisconf'] = 'Kurs je pogrešno konfigurisan';
$string['createdon'] = 'Kreirano dana';
$string['curllibrarymissing'] = 'PHP Curl ekstenzija je neophodna za Eksterni alat.';
$string['custom'] = 'Prilagođeni parametri';
$string['custom_config'] = 'Korišćenje prilagođene konfiguracije alata';
$string['custom_help'] = 'Namenski prilagođeni parametri su podešavanja koje koristi provajder alata. Na primer, prilagođeni parametri se mogu koristiti za prikaz određenih resursa od strane provajdera. Svaki parametar treba uneti u zaseban red koristeći sledeći format: "name=value"; for example, "chapter=3".
 
Najsigurnije je ne menjati ovo polje, osim ako to ne učini sam provajder alata.';
$string['custominstr'] = 'Prilagođeni parametri';
$string['debuglaunch'] = 'Opcija za otklanjanje grešaka';
$string['debuglaunchoff'] = 'Normalno pokretanje';
$string['debuglaunchon'] = 'Pokretanje sa otklanjanjem grešaka';
$string['default'] = 'Podrazumevano';
$string['default_launch_container'] = 'Podrazumevani inicijalni kontejner';
$string['default_launch_container_help'] = 'Inicijalni kontejner utiče na prikaz alata prilikom njegovog pokretanja unutar kursa. Neki kontejneri pružaju veći broj mogućnosti, dok drugi obezbeđuju veći stepen integracije sa Moodleom.

* **Podrazumevano** - koristi inicijalni kontejner naveden u konfiguracije alata.
* **Umetnuto** - alat se prikazuje unutar postojećeg prozora Moodlea, na način sličan većini drugih tipova aktivnosti.
* **Umetnuto, bez blokova** - alat se prikazuje unutar postojećeg prozora Moodlea, ali samo sa navigacionom trakom na vrhu stranice.
* **Novi prozor** - Alat se otvara u novom prozoru, zauzimajući sav njegov rapoloživ prostor.
      Zavisno od veb čitača, alat će se otvoriti u novoj kartici čitača ili u iskačućem prozoru.
      Postoji mogućnost da veb čitač neće dozvoliti otvaranje novog prozora.';
$string['delegate'] = 'Delegiraj predavaču';
$string['delegate_tool'] = 'Kao što je navedeno u definiciji Dubinskog Povezivanja ili Delegirajte predavaču.';
$string['delete'] = 'Obriši';
$string['delete_confirmation'] = 'Da li ste sigurni da želite da obrišete ovaj prekonfigurisani alat?';
$string['deletetype'] = 'Obriši prekonfigurisani alat';
$string['display_description'] = 'Prikaži opis aktivnosti prilikom njenog pokretanja';
$string['display_description_help'] = 'Ako je izabrana ova opcija, opis aktivnosti (gore naveden) biće prikazan iznad sadržaja eksternog alata.

Opis se može koristiti kako bi se pružile dodatne instrukcije onima koji pokreću alat, ali nije neophodan.

Opis se nikada ne prikazuje kada se eksterni alat pokreće u novom prozoru.';
$string['display_name'] = 'Prikaži naziv aktivnosti kada se pokrene';
$string['display_name_help'] = 'Ako je izabrana ova opcija, naziv aktivnosti (gore naveden) biće prikazan iznad sadržaja eksternog alata.

Moguće je da provajder alata, takođe, može da prikaže naslov. Ova opcija sprečava da naslov aktivnosti bude prikazan dvaput.

Naslov se nikada ne prikazuje ako se inicijalni kontejner alata pokreće u novom prozoru.';
$string['domain_mismatch'] = 'Domen URL adrese alata se ne poklapa sa konfiguracijom alata.';
$string['donot'] = 'Nemoj slati';
$string['donotaccept'] = 'Nemoj prihvatiti';
$string['donotallow'] = 'Nemoj dozvoliti';
$string['duplicateregurl'] = 'Ova URL adresa za prijavu se već koristi';
$string['dynreg_update_btn_new'] = 'Registruj kao novi eksterni alat';
$string['dynreg_update_btn_update'] = 'Ažuriraj';
$string['dynreg_update_name'] = 'Naziv alata';
$string['dynreg_update_notools'] = 'Nema alata u kontekstu.';
$string['dynreg_update_text'] = 'Postoje postojeći alati povezani sa domenom registracije. Da li želite da ažurirate već instalirani eksterni alat ili da kreirati novi eksterni alat?';
$string['dynreg_update_url'] = 'Osnovna URL adresa';
$string['dynreg_update_version'] = 'LTI verzija';
$string['dynreg_update_warn_dupdomain'] = 'Ne preporučuje se više eksternih alata pod istim domenom.';
$string['editdescription'] = 'Kliknite ovde kako biste opisali ovaj alat';
$string['edittype'] = 'Uredi prekonfigurisani alat';
$string['embed'] = 'Ugradi';
$string['embed_no_blocks'] = 'Ugradi, bez blokova';
$string['enableemailnotification'] = 'Pošalji obaveštenja e-poštom';
$string['enableemailnotification_help'] = 'Ako je omogućena ova opcija, polaznici će e-poštom dobiti obaveštenje kada bude ocenjena njihova aktivnost u okviru eksternog alata..';
$string['enterkeyandsecret'] = 'Unesite svoj korisnički ključ i deljeni tajni ključ';
$string['enterkeyandsecret_help'] = 'Ako ste dobili korisnički ključ i/ili deljeni tajni ključ unesite ih ovde';
$string['errorbadurl'] = 'URL adresa nije ispravna URL adresa alata odnosno kertridža';
$string['errorincorrectconsumerkey'] = 'Korisnički ključ je netačan.';
$string['errorinvaliddata'] = 'Neispravni podaci: {$a}';
$string['errorinvalidmediatype'] = 'Neispravni tip medija: {$a}';
$string['errorinvalidresponseformat'] = 'Neispravan format odgovora Stavke-Sadržaja';
$string['errormisconfig'] = 'Pogrešno  konfigurisan alat. Zamolite svog Moodle administratora da popravi konfiguraciju alata.';
$string['errortooltypenotfound'] = 'Nije pronađen tip LTI alata';
$string['existing_window'] = 'Postojeći prozor';
$string['extensions'] = 'Servisi LTI proširenja';
$string['external_tool_type'] = 'Prekonfigurisani alat';
$string['external_tool_type_help'] = '* ** Automatski, na osnovu URL adrese alata** - Najbolja konfiguracija alata se bira automatski. Ako URL adresa alata nije prepoznata, možda će biti potrebno da ručno unesete podatke o konfiguraciji alata.
* **Specifičan prekonfigurisani alat** - Prilikom komunikacije sa provajderom eksternog alata koristiće se konfiguracija za navedeni alat. Ako se ispostavi da URL adresa alata ne pripada provajderu, biće prikazano upozorenje. Nije uvek neophodno da  unesete URL adresa alata.
* **Prilagođena konfiguracija** - Korisnički ključ kao i deljeni tajni kôd moraju se uneti ručno. Oba ključa se mogu dobiti od provajdera. Međutim, ne zahtevaju svi alati korisnički ključ i deljeni tajni kôd. U tom slučaju ova polja možete ostaviti prazna.

### Uređivanje prekonfigurisanog alata

U padajućem menija za \'Prekonfigurisani alat\' dostupne su tri ikonice:

* **Dodaj** - kreirajte konfiguraciju alata na nivou kursa. Sve instance eksternog alata na ovom kursu moći će da koriste konfiguraciju alata.
* **Uredi** - izaberite alat na nivou kursa iz padajućeg menija, a zatim kliknite na ovu ikonicu. Mogu se uređivati detalji konfiguracije alata.
* **Obriši** - uklonite izabrani alat na nivou kursa.';
$string['external_tool_types'] = 'Prekonfigurisani alati';
$string['failedtoconnect'] = 'Moodle nije mogao da uspostavi komunikaciju sa"{$a}" sistemom';
$string['failedtocreatetooltype'] = 'Kreiranje novog alata nije uspelo. Molimo, proverite URL adresu i pokušajte ponovo.';
$string['failedtodeletetoolproxy'] = 'Pokušaj da se obriše prijava za alata nije uspeo. Možda ćete morati da posetite "Upravljanje prijavama za eksterne alate" i ručno je obrišete.';
$string['filter_basiclti_configlink'] = 'Конфигуришите своје префериране сајтове и њихове лозинке';
$string['filter_basiclti_password'] = 'Lozinka je obavezna';
$string['filterconfig'] = 'LTI administracija';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Iskoristite postojeću konfiguraciju za pogrešno konfigurisanu instancu';
$string['fixnew'] = 'Nova konfiguracija';
$string['fixnewconf'] = 'Definiši novu konfiguraciju za pogrešno konfigurisanu instancu';
$string['fixold'] = 'Koristi postojeću';
$string['force_ssl'] = 'Obavezan SSL';
$string['force_ssl_help'] = 'Izborom ove opcije, svako pokretanje alata ovog provajdera će obavezno koristiti SSL protokol.

Osim toga, i svi zahtevi veb servisa provajdera alata će koristiti SSL protokol.

Ako se koristi ova opcija, proverite da li ovaj Moodle sajt i provajder alata podržavaju SSL protokol.';
$string['forced_help'] = 'Ovo podešavanje je postavljeno kao obavezno u konfiguraciji alata na nivou kursa ili sajta. Ne možete da ga menjate u ovom interfejsu.';
$string['generaltool'] = 'Opšti alat';
$string['global_tool_types'] = 'Prethodno konfigurisani alati';
$string['grading'] = 'Usmeravanje ocena';
$string['icon_url'] = 'URL adresa ikonice';
$string['icon_url_help'] = 'Ikonica URL adrese, omogućava da se izmeni ikonica koja se pojavljuje na spisku kurseva za ova aktivnost. Umesto da koristite podrazumevanu LTI ikonicu, može se definisati ikonica koja odražava tip aktivnosti.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'LTI - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'LTI\'.';
$string['indicator:cognitivedepthdef'] = 'LTI - kognitivni aspekt';
$string['indicator:cognitivedepthdef_help'] = 'Učesnik je postigao ovaj procenat kognitivnog angažmana koji nude aktivnosti LTI tokom ovog intervala analize (Nivoi = Bez pregleda, Pregled, Predaja odgovora, Pregled povratnih informacija)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'LTI - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'LTI\'.';
$string['indicator:socialbreadthdef'] = 'LTI - socijalni aspekt';
$string['indicator:socialbreadthdef_help'] = 'Učesnik je postigao ovaj procenat socijalnog angažmana koji nude aktivnosti LTI tokom ovog intervala analize (Nivoi = Bez učešća, Učesnik sâm, Učesnik sa drugima)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'URL adresa za pokretanje prijave';
$string['initiatelogin_help'] = 'URL adresa alata kojoj će biti poslat zahtev za pokretanje prijave. Ova URL adresa je neophodna kako bi poruka mogla da bude uspešno poslata alatu.';
$string['invalidid'] = 'LTI ID je pogrešan';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Tip javnog ključa';
$string['keytype_help'] = 'Metod za proveru identiteta koji se koristi za potvrdu alata.';
$string['keytype_keyset'] = 'URL adresa skupa ključeva';
$string['keytype_rsa'] = 'RSA ključ';
$string['launch_in_moodle'] = 'Pokreni alat unutar Moodlea';
$string['launch_in_popup'] = 'Pokreni alat u iskačućem prozoru';
$string['launch_url'] = 'URL adresa alata';
$string['launch_url_help'] = 'URL adresa alata označava veb adresu eksternog alata, i može da sadrži dodatne informacije, kao što je resurs koji će biti prikazan.
Ako niste sigurni šta da upišete kao URL adresu, molimo vas potražite više informacije kod provajdera alata.

Takođe, možete uneti URL adresu kertridža ako je imate, i ostatak obrasca će se automatski popuniti.

Ako ste izabrali prekonfigurisani alat, možda nećete morati da upišete URL adresu alata. To će najverovatnije biti slučaj, ako se link alata koristi samo za ulazak na sistem provajdera, a ne za odlazak na neki određeni resurs.';
$string['launchinpopup'] = 'Inicijalni kontejner';
$string['launchinpopup_help'] = 'Inicijalni kontejner utiče na prikaz alata prilikom njegovog pokretanja unutar kursa. Neki kontejneri pružaju veći broj mogućnosti, dok drugi obezbeđuju veći stepen integracije sa Moodleom.

* **Podrazumevano** - koristi kontejner pokretanja naveden u konfiguraciji alata.
* **Umetnuto** - alat se prikazuje unutar postojećeg prozora Moodlea, na način sličan većini drugih tipova aktivnosti.
* **Umetnuto, bez blokova** - alat se prikazuje unutar postojećeg prozora Moodlea, ali samo sa navigacionom trakom na vrhu stranice.
* **Novi prozor** - Alat se otvara u novom prozoru, zauzimajući sav njegov rapoloživ prostor.
      Zavisno od veb čitača, alat će se otvoriti u novoj kartici čitača ili u iskačućem prozoru.
      Postoji mogućnost da veb čitač neće dozvoliti otvaranje novog prozora.';
$string['launchoptions'] = 'Opcije za pokretanje';
$string['leaveblank'] = 'Ostavite prazno ako vam nisu potrebni';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Dodaj za kurs specifična podešavanja alata';
$string['lti:addinstance'] = 'Dodavanje novog eksternog alata';
$string['lti:addmanualinstance'] = 'Dodaj ručno konfigurisani alat';
$string['lti:addpreconfiguredinstance'] = 'Dodaj unapred konfigurisani alat';
$string['lti:admin'] = 'Budite administrator kada se alat pokrene';
$string['lti:grade'] = 'Pogledaj ocene dobijene od eksternog alata';
$string['lti:manage'] = 'Budi instruktor kad se pokrene alat';
$string['lti:requesttooladd'] = 'Zahtevaj da se alat podesi na nivou sajta';
$string['lti:view'] = 'Pokreni aktivnosti eksternog alata';
$string['lti_administration'] = 'Uredi prekonfigurisani alat';
$string['lti_errormsg'] = 'Alat je vratio sledeću poruku o grešci: "{$a}"';
$string['lti_launch_error'] = 'Došlo je do greške prilikom pokretanja eksternog alata:';
$string['lti_launch_error_tool_request'] = '<p> Da biste poslali zahtev administratoru da završi konfigurisanje alata, kliknite<a href="{$a->admin_request_url}" target="_top">ovde</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>Ova greška može biti rezultat nedostatka korisničkog ključa i deljenog tajnog ključa za provajdera alata.</p>
<p> Ako imate korisnički ključ i deljeni tajni ključ, možete ih uneti prilikom uređivanja instance eksternog alata (proverite da li su vidljive napredne opcije).</p>
</p>Alternativno, možete da <a href="{$a->course_tool_editor}"> kreirate konfiguraciju alata na nivou kursa </a>.</p>';
$string['lti_tool_request_added'] = 'Zahtev za konfigurisanje alata je uspešno poslat. Možda ćete morati da se obratite administratoru da biste dovršili konfigurisanje.';
$string['lti_tool_request_existing'] = 'Konfiguracija alata za domen alata je već poslata.';
$string['ltisettings'] = 'LTI podešavanja';
$string['ltiunknownserviceapicall'] = 'API poziv LTI nepoznatog servisa.';
$string['ltiversion'] = 'LTI verzija';
$string['ltiversion_help'] = 'Verzija LTI koja se koristi za potpisivanje poruka i zahteva za uslugama: LTI 1.0/1.1 i LTI 2.0 koriste OAuth 1.0A sigurnosno profil; LTI 1.3.0 koristi JWTs.';
$string['main_admin'] = 'Opšta pomoć';
$string['main_admin_help'] = 'Eksterni alati dozvoljavaju korisnicima Moodlea da neprimetno stupaju u interakciju sa resursima koji se nalaze na udaljenim sajtovima.
Koristeći specijalne protokole udaljeni alat će imati pristup opštim informacijama o korisniku koji je pokrenuo alat. Na primer, naziv institucije, ID oznak kursa, ID oznaka korisnika, i druge informacije, kao što su ime korisnika ili njegova e-adresa.

Alati prikazani na ovoj stranici su podeljeni u tri kategorije:

* **Aktivni** - ove provajdere alata je administrator odobrio i konfigurisao. Oni mogu da se koriste unutar bilo kog kursa na ovom sajtu. Ako su uneti korisnički ključ i deljeni tajni ključ, uspostavljena je pouzdana veza između ovog sajta i udaljenog alata, što obezbeđuje bezbedan kanal komunikacije.
* **Na čekanju** - ovi provajderi alata su uvezeni, ali ih administrator još uvek nije konfigurisao. Predavači i dalje mogu da koriste alate ovih provajdera ako imaju korisnički ključ i deljeni tajni ključ, ili ako oni nisu potrebni.
* **Odbijeni** - ovi provajderi alata su označeni kao oni koje administrator ne namerava da učini dostupnim na ovom sajtu. Predavači i dalje mogu da koriste alate ovih provajdera ako imaju korisnički ključ i deljeni tajni ključ, ili ako oni nisu potrebni.';
$string['manage_external_tools'] = 'Upravljanje alatima';
$string['manage_tool_proxies'] = 'Upravljanje prijavama za eksterne alate';
$string['manage_tools'] = 'Upravljanje prekonfigurisanim alatima';
$string['manuallyaddtype'] = 'Alternativno, možete <a href="{$a}">ručno da konfigurišete alat</a>';
$string['miscellaneous'] = 'Razno';
$string['misconfiguredtools'] = 'Otkrivene su pogrešno konfigurisane instance alata';
$string['missingparameterserror'] = 'Stranica je pogrešno konfigurisana: "{$a}"';
$string['module_class_type'] = 'Tip Moodle modula';
$string['modulename'] = 'Eksterni alat';
$string['modulename_help'] = 'Aktivnost \'Eksterni alat\' dozvoljava polaznicima da stupaju u interakciju sa resursima i aktivnostima za učenje na drugim veb sajtovima. Na primer, eksterni alat može da obezbedi pristup novom tipu aktivnosti ili obrazovnim materijalima koje nude izdavači.

Da biste kreirali aktivnost \'Eksterni alat\', neophodan provajder alata koji podržava LTI (Learning Tools Interoperability) standard. Predavač može da kreira aktivnost \'Eksterni alat\' ili da koristi alat koji je konfigurisao administrator sajta.

Eksterni alati se razlikuju od resursa \'URL adresa\' na nekoliko načina:

* Eksterni alati su svesni koneksta tj. imaju pristupa informacijama o korisniku koji je pokrenuo alat, kao što je naziv institucije i kursa, kao i ime korisnika
* Eksterni alati podržavaju čitanje, ažuriranje i brisanje ocena koje su povezane sa instancom aktivnosti
* Konfiguracije eksternih alata stvaraju odnos poverenja između vašeg veb sajta i provajdera alata, omogućavajući sigurnu komunikaciju između njih';
$string['modulename_link'] = 'mod/lti/view';
$string['modulename_shortcut_link'] = 'mod/lti/view/custom';
$string['modulenameplural'] = 'Eksterni alati';
$string['modulenamepluralformatted'] = 'Eksterni alati';
$string['name'] = 'Naziv';
$string['never'] = 'Nikada';
$string['new_window'] = 'Novi prozor';
$string['no_lti_configured'] = 'Ne postoje aktivni eksterni alati koji su konfigurisani.';
$string['no_lti_pending'] = 'Nema eksternih alata na čekanju.';
$string['no_lti_rejected'] = 'Nema odbijenih eksternih alata.';
$string['no_lti_tools'] = 'Ne postoje konfigurisani eksterni alati';
$string['no_tp_accepted'] = 'Ne postoje prihvaćene prijave za eksterne alate.';
$string['no_tp_cancelled'] = 'Ne postoje otkazane prijave za eksterne alate.';
$string['no_tp_configured'] = 'Ne postoje neregistrovane prijave za eksterne alate, koje su konfigurisane.';
$string['no_tp_pending'] = 'Ne postoje prijave za eksterne alate na čekanju.';
$string['no_tp_rejected'] = 'Ne postoje odbijene  prijave za eksterne alate.';
$string['noattempts'] = 'Još nije bilo pokušaja u okviru ove instance alata';
$string['noltis'] = 'Ne postoje instance eksternih alata';
$string['noprofileservice'] = 'Nije pronađen servis profila';
$string['noservers'] = 'Nisu pronađeni serveri';
$string['notypes'] = 'Trenutno ne postoje podešavanja LTI alata u Moodleu. Kliknite na gornji link za instalaciju kako biste ih dodali.';
$string['noviewusers'] = 'Nisu pronađeni korisnici koji imaju ovlašćenja da koriste ovaj alat';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 zahteva da ispravna openssl.cnf  datoteka bude konfigurisana i dostupna vašem veb serveru. Obratite se administratoru sajta da konfiguriše i omogući openssl za ovaj sajt.';
$string['optionalsettings'] = 'Opciona podešavanja';
$string['organization'] = 'Informacije o organizaciji';
$string['organizationdescr'] = 'Opis organizacije';
$string['organizationid_default'] = 'Podrazumevana ID oznaka organizacije';
$string['organizationid_default_help'] = 'Podrazumevana vrednost za ID oznaku organizacije. ID oznaka sajta identifikuje ovu instalaciju Moodlea.';
$string['organizationidguid'] = 'ID oznaka organizacije';
$string['organizationidguid_help'] = 'Jedinstveni identifikator za ovu Moodle instancu prosleđen je alatu kao Platform Instance GUID.

Ako ovo polje ostane prazno, koristiće se podrazumevana vrednost.';
$string['organizationurl'] = 'URL adresa organizacije';
$string['organizationurl_help'] = 'Osnovna URL adresa ove instance Moodlea';
$string['pagesize'] = 'Broj završenih aktivnosti na eksternom alatu prikazanih po stranici';
$string['parameter'] = 'Parametri alata';
$string['parameter_help'] = 'Parametri alata su podešavanja zahtevana za prenos od strane pružaoca alata u prihvaćenom posredniku alata.';
$string['password'] = 'Deljeni tajni ključ';
$string['password_admin'] = 'Deljeni tajni ključ';
$string['password_admin_help'] = 'Deljeni tajni ključ može da se posmatra kao lozinka koja se koristi za proveru identiteta prilikom pristupa alatu. Njega treba da obezbedi provajder alata zajedno sa korisničkim ključem.

Alati koji ne traže bezbednu komunikaciju sa Moodeom i ne pružaju dodatne servise (kao što je izveštaj o ocenama), ne moraju da zahtevaju deljeni tajni ključ.';
$string['password_help'] = 'Za prethodno konfigurisane alate, nije neophodno da se ovde unese deljeni tajni ključ, pošto će on već biti obezbeđen kao deo procesa konfiguracije.

Ovo polje treba popuniti ako se kreira veza ka provajderu alata koji nije prethodno konfigurisan. Ako provajder alata treba da se koristi više puta na ovom kursu, dodavanje konfiguracije alata je dobra ideja.

Deljeni tajni ključ može da se posmatra kao lozinka koja se koristi za proveru identiteta prilikom pristupa alatu. Kôd treba da obezbedi provajder alata zajedno sa korisničkim ključem.

Alati koji ne traže bezbednu komunikaciju sa Moodeom i ne pružaju dodatne servise (kao što je izveštaj o ocenama), ne moraju da zahtevaju deljeni tajni ključ.';
$string['pending'] = 'Ne čekanju';
$string['pluginadministration'] = 'Administracija eksternih alata';
$string['pluginname'] = 'Eksterni alat';
$string['preferheight'] = 'Preferirana visina';
$string['preferwidget'] = 'Preferirano pokretanje dodatka';
$string['preferwidth'] = 'Preferirana širina';
$string['press_to_submit'] = 'Pritisnite da bisti pokrenuli ovu aktivnost';
$string['privacy'] = 'Privatnost';
$string['privacy:metadata:coursefullname'] = 'Pun naziv kursa iz kojeg korisnik pristupa LTI Consumeru';
$string['privacy:metadata:courseid'] = 'ID oznaka kursa iz kojeg korisnik pristupa LTI Consumeru';
$string['privacy:metadata:courseidnumber'] = 'ID broj kursa iz kojeg korisnik pristupa LTI Consumeru';
$string['privacy:metadata:courseshortname'] = 'Kratak naziv kursa iz kojeg korisnik pristupa LTI Consumeru';
$string['privacy:metadata:createdby'] = 'Korisnik koji je kreirao zapis';
$string['privacy:metadata:email'] = 'Adresa e-pošte korisnika koji pristupa LTI Consumeru';
$string['privacy:metadata:externalpurpose'] = 'LTI Consumer pruža informacije o korisniku i kontekst LTI Tool Provideru.';
$string['privacy:metadata:firstname'] = 'Ime korisnika koji pristupa LTI Consumeru';
$string['privacy:metadata:fullname'] = 'Ime i prezime korisnika koji pristupa LTI Consumeru';
$string['privacy:metadata:lastname'] = 'Prezime korisnika korisnika koji pristupa LTI Consumeru';
$string['privacy:metadata:lti_submission'] = 'Završena aktivnosti na eksternom LTI alatu';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Vremenska oznaka koja pokazuje kada je završena aktivnost na eksternom alatu';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Vremenska oznaka koja pokazuje kada je izmenjena aktivnost na eksternom alatu';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Ocena za korisnika kao procenat';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Originalna ocena za korisnika';
$string['privacy:metadata:lti_submission:userid'] = 'ID oznaka korisnika koji završio LTI aktivnost';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI proksiji';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Naziv LTI proksija';
$string['privacy:metadata:lti_types'] = 'LTI tipovi';
$string['privacy:metadata:lti_types:name'] = 'Naziv LTI tipa';
$string['privacy:metadata:role'] = 'Uloga na kursu za korisnika koji pristupa LTI Consumeru';
$string['privacy:metadata:timecreated'] = 'Vreme kada je zapis kreiran';
$string['privacy:metadata:timemodified'] = 'Vreme kada je zapis izmenjen';
$string['privacy:metadata:userid'] = 'ID oznaka korisnika koji pristupa LTI Consumeru';
$string['privacy:metadata:useridnumber'] = 'ID broj korisnika koji pristupa LTI Consumeru';
$string['privacy:metadata:username'] = 'Korisničko ime korisnika koji pristupa LTI Consumeru';
$string['publickey'] = 'Javni ključ';
$string['publickey_help'] = 'Javni ključ  (u PEM formatu) koji obezbeđuje alat kako bi se omogućila provera potpisa dolaznih poruka i zahteva za uslugama.';
$string['publickeyset'] = 'Skup javnih ključeva';
$string['publickeyset_help'] = 'Javni skup ključeva odakle će ovaj sajt preuzeti javni ključ alata kako bi se omogućila verifikacija potpisa dolaznih poruka i zahteva za uslugom.';
$string['quickgrade'] = 'Dozvoli brzo ocenjivanje';
$string['quickgrade_help'] = 'Ako je omogućena ova opcija, više alata može da se ocenjuje na jednoj stranici. Dodajte ocene i komentare a zatim kliknite na dugme "Sačuvaj sve moje povratne informacije" kako biste sačuvali sve promene na toj stranici.';
$string['redirect'] = 'Bićete preusmereni za nekoliko sekundi. Ako se to ne dogodi pritisnite dugme.';
$string['redirectionuris'] = 'Jedinstveni indentifikator(i) resursa (URI) za preusmeravanje';
$string['redirectionuris_help'] = 'Spisak jedinstvenih indentifikatora resursa (po jedan u svakom redu) koje alat koristi prilikom kreiranja zahteva za autorizaciju. Najmanje jedan URI mora biti registrovan kako bi poruka mogla da bude uspešno poslata alatu.';
$string['register'] = 'Prijavi se';
$string['register_warning'] = 'Izgleda da je stranici za prijavu potrebno vreme kako bi se otvorila. Ako se stranica ne pojavi, proverite da li ste uneli ispravnu URL adresu u konfiguracionim podešavanjima. Ako Moodle koristi https protokol, proverite da alat koji konfigurišete podržava https protokol, kao i da li u URL adresi koristite https.';
$string['registertype'] = 'Konfigurišite prijavu za novi eksterni alat';
$string['registration_options'] = 'Opcije za prijavu';
$string['registrationname'] = 'Naziv provajdera alata';
$string['registrationname_help'] = 'Unesite naziv provajdera alata  za koji se prijavljujete.';
$string['registrationurl'] = 'URL adresa za prijavu';
$string['registrationurl_help'] = 'URL adresa za prijavu treba da bude dostupna od strane provajdera alata kao adresa na koju treba da se pošalje zahtev za prijavu.';
$string['reject'] = 'Odbij';
$string['rejected'] = 'Odbijeno';
$string['resource'] = 'Resurs';
$string['resourcekey'] = 'Korisnički ključ';
$string['resourcekey_admin'] = 'Korisnički ključ';
$string['resourcekey_admin_help'] = 'Korisnički ključ može da se posmatra kao korisničko ime koje se koristi za proveru identiteta prilikom pristupa alatu. 
Provajder alata može koristiti ključ kako bi obezbedio jedinstvenu identifikaciju Moodle sajta sa kojeg korisnici pokreću alat.

Korisnički ključ mora da obezbedi provajder alata. Način dobijanja ključa se razlikuje među provajderima. To može biti automatizovani proces ili može zahtevati dijalog sa provajderom alata.

Alati koji ne traže bezbednu komunikaciju sa Moodeom i ne pružaju dodatne servise (kao što je izveštaj o ocenama), ne moraju da zahtevaju korisnički ključ.';
$string['resourcekey_help'] = 'Za prethodno konfigurisane alate, nije neophodno da se ovde unese ključ resursa, pošto će on već biti obezbeđen kao deo procesa konfiguracije.

Ovo polje treba popuniti ako se kreira veza ka provajderu alata koji nije prethodno konfigurisan. Ako provajder alata treba da se koristi više puta na ovom kursu, dodavanje konfiguracije alata je dobra ideja.

Korisnički ključ može da se posmatra kao korisničko ime koje se koristi za proveru identiteta prilikom pristupa alatu. 
Provajder alata može koristiti ključ kako bi obezbedio jedinstvenu identifikaciju Moodle sajta sa kojeg korisnici pokreću alat.

Korisnički ključ mora da obezbedi provajder alata. Način dobijanja ključa se razlikuje među provajderima. To može biti automatizovani proces ili može zahtevati dijalog sa provajderom alata.

Alati koji ne traže bezbednu komunikaciju sa Moodeom i ne pružaju dodatne servise (kao što je izveštaj o ocenama), ne moraju da zahtevaju korisnički ključ.';
$string['resourceurl'] = 'URL adresa resursa';
$string['return_to_course'] = 'Klikni na <a href="{$a->link}" target="_top">here</a> za povratak na kurs';
$string['saveallfeedback'] = 'Sačuvaj sve moje povratne informacije';
$string['search:activity'] = 'Eksterni alat - informacije o aktivnosti';
$string['secure_icon_url'] = 'Bezbedni URL ikonice';
$string['secure_icon_url_help'] = 'Slično ikonici URL adrese, ali se koristi ako se sajtu pristupa putem SSL protokola. Glavna namena ovog polja je da spreči veb čitač da šalje upozorenja o nebezbednoj slici.';
$string['secure_launch_url'] = 'Bezbedna URL adresa alata';
$string['secure_launch_url_help'] = 'Iako slična običnoj, bezbedna URL adresa alata se koristi ako je neophodan viši nivo bezbednosti. Moodle će koristiti bezbednu URL adresu alata ukoliko se Moodle sajtu pristupa preko SSL protokola, ili ako je konfiguracija alata podešena tako da se on uvek pokreće putem SSL-a.

URL adresa alata se može, takođe, podesiti kao https adresa, kako bi se eksterni alat primorao na pokretanje putem SSL protokola. U tom slučaju ovo polje može ostati prazno.';
$string['selectcontent'] = 'Izaberi sadržaj';
$string['send'] = 'Pošalji';
$string['services'] = 'Servisi';
$string['services_help'] = 'Izaberite one servise koje želite da ponudite provajderu alata. Može se izabrati više od jednog servisa.';
$string['setupoptions'] = 'Opcije za podešavanje';
$string['share_email'] = 'Podeli e-adresu korisnika sa provajderom alata';
$string['share_email_admin'] = 'Podeli e-adresu korisnika sa provajderom alata';
$string['share_email_admin_help'] = 'Navedite da li e-adresu korisnika koji pokreće alat treba deliti sa provajderom..
Provajder može da traži e-adrese korisnika koji su pokrenuli alat kako bi razlikovao korisnike sa istim imenom ili kako bi korisnicima slao e-poštu zavisno od akcija unutar alata.';
$string['share_email_help'] = 'Navedite da li e-adresu korisnika koji pokreće alat treba deliti sa provajderom.

Provajder može da traži e-adrese korisnika koji su pokrenuli alat kako bi razlikovao korisnike sa istim imenom ili kako bi korisnicima slao e-poštu zavisno od akcija unutar alata.

Imajte u vidu da se ovo podešavanje može izmeniti u konfiguraciji alata.';
$string['share_name'] = 'Podeli ime korisnika sa provajderom alata';
$string['share_name_admin'] = 'Podeli ime korisnika sa provajderom alata';
$string['share_name_admin_help'] = 'Navedite da li treba da se deli puno ime korisnika, koji pokreće alat, sa provajderom alata.
Provajder može da traži ime korisnika koji je pokrenuo alat, kako bi prikazao smislene informacije unutar alata.';
$string['share_name_help'] = 'Navedite da li treba da se deli puno ime korisnika koji pokreće alat sa provajderom alata.

Provajder može da traži ime korisnika koji je pokrenuo alat, kako bi prikazao smislene informacije unutar alata.

Imajte u vidu da se ovo podešavanje može izmeniti u konfiguraciji alata.';
$string['share_roster'] = 'Dozvoli alatu pristup spisku učesnika kursa';
$string['share_roster_admin'] = 'Alat može da pristupi spisku učesnika kursa';
$string['share_roster_admin_help'] = 'Navedite da li alat može da pristupi spisku učesnika upisanih na kurseve u okviru kojih je ovaj alat pokrenut.';
$string['share_roster_help'] = 'Navedite da li alat može da pristupi spisku korisnika upisanih na ovaj kurs.

Imajte u vidu da se ovo podešavanje može izmeniti u konfiguraciji alata.';
$string['show_in_course_activity_chooser'] = 'Prikaži u biraču aktivnosti i kao prekonfigurisani alat';
$string['show_in_course_lti1'] = 'Korišćenje podešavanja alata';
$string['show_in_course_lti1_help'] = 'Ovaj alat može biti prikazan u biraču aktivnosti, kako bi predavač mogao da ga izabere i doda na kurs. Alternativno, alat može biti prikazan u padajućem meniju prekonfigurisanog alata prilikom dodavanja eksternog alata na kurs. Osim toga, moguće je da se konfiguracija alata koristi samo ako se unese tačna URL adresa alata, prilikom dodavanja eksternog alata na kurs.';
$string['show_in_course_lti2'] = 'Korišćenje podešavanja alata';
$string['show_in_course_lti2_help'] = 'Ovaj alat može biti prikazan u biraču aktivnosti, kako bi predavač mogao da ga izabere i doda na kurs ili u padajućem meniju prekonfigurisanog alata prilikom dodavanja eksternog alata na kurs.';
$string['show_in_course_no'] = 'Ne prikazuj; koristi samo kada je uneta odgovarajuću URL adresa';
$string['show_in_course_preconfigured'] = 'Prikaži kao prekonfigurisani alat prilikom dodavanja eksternog alata';
$string['sitehost'] = 'Naziv računara sajta';
$string['siteid'] = 'ID oznaka sajta';
$string['size'] = 'Parametri veličine';
$string['submission'] = 'Završna aktivnost na eksternom alatu';
$string['submissions'] = 'Završene aktivnosti na eksternom alatu';
$string['submissionsfor'] = 'Završene aktivnosti na eksternom alatu za {$a}';
$string['subplugintype_ltiresource'] = 'Resurs LTI servisa';
$string['subplugintype_ltiresource_plural'] = 'Resursi LTI servisa';
$string['subplugintype_ltiservice'] = 'LTI servis';
$string['subplugintype_ltiservice_plural'] = 'LTI servisi';
$string['subplugintype_ltisource'] = 'LTI izvor';
$string['subplugintype_ltisource_plural'] = 'LTI izvori';
$string['successfullycreatedtooltype'] = 'Novi alat uspešno kreiran!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Uspešno preuzeta konfiguracija alata od strane izabranog sadržaja.';
$string['toggle_debug_data'] = 'Uključi/isključi podatke o otklanjanju grešaka';
$string['tool_config_not_found'] = 'Za ovu URL adresu nije pronađena konfiguracija alata.';
$string['tool_settings'] = 'Podešavanja alata';
$string['tooldescription'] = 'Opis alata';
$string['tooldescription_help'] = 'Opis alata koji će biti prikazan predavačima na spisku aktivnosti.

On treba da opiše čemu služi alat, šta radi kao i da pruži sve dodatne informacije koje predavač treba da zna.';
$string['tooldetailsaccesstokenurl'] = 'URL adresa tokena za pristup';
$string['tooldetailsauthrequesturl'] = 'URL adresa zahteva za proveru identiteta';
$string['tooldetailsclientid'] = 'ID oznaka klijenta';
$string['tooldetailsdeploymentid'] = 'ID oznaka pokretanja alata';
$string['tooldetailsmailtosubject'] = 'Konfiguracija LTI alata';
$string['tooldetailsmodalemail'] = 'Adresa e-pošte';
$string['tooldetailsmodallink'] = 'Pogledajte detalje o konfiguraciji';
$string['tooldetailsmodaltitle'] = 'Detalji o konfiguraciji alata';
$string['tooldetailsplatformid'] = 'ID oznaka platforme';
$string['tooldetailspublickeyseturl'] = 'URL adresa skupa javnih ključeva';
$string['toolisbeingused'] = 'Ovaj alat je iskorišćen {$a} put/a';
$string['toolisnotbeingused'] = 'Ovaj alat još nije korišćen';
$string['toolproxy'] = 'Prijave za eksterne alate';
$string['toolproxy_help'] = 'Prijava za eksterni alat omogućava administratoru Moodle sajta da konfiguriše eksterne alate iz proksija alata dobijenog od provajdera alata koji podržava LTI 2.0 standard. URL adresa za prijavu koju obezbeđuje provajder alata je sve što je neophodno kako bi se započeo proces prijavljivanja. Svojstva i servisi koji se nude provajderu alata su izabrani kada se konfiguriše nova prijava.

Prijave za alate koji su prikazani na ovoj stranici su razvrstane u četiri kategorije:

* **Konfigurisano** - Ove prijave za alate su podešene ali proces prijave još uvek nije započet.
* **Na čekanju** - Proces prijave za ove alatke je započeo ali nije završen. Otvorite i sačuvajte  podešavanja kako biste prijavu vratili nazad u kategoriju \'Konfigurisano\'.
* **Prihvaćeno** - Ove prijave za alate su odobrene; resursi navedeni u proksiju alata će se pojaviti stranici sa prekonfigurisanim alatima sa početnim statusom \'Na čekanju\'.
* **Odbijeno** - Ove prijave za alate su one koje su odbijene tokom procesa prijavljivanja. Otvorite i sačuvajte  podešavanja kako biste prijavu vratili nazad u kategoriju \'Konfigurisano\', tako da proces prijave da počne ispočetka.';
$string['toolproxyregistration'] = 'Prijava za eksterni alat';
$string['toolregistration'] = 'Prijava za eksterni alat';
$string['toolsetup'] = 'Konfiguracija eksternog alata';
$string['tooltypeadded'] = 'Prekonfigurisani alat dodat';
$string['tooltypedeleted'] = 'Prekonfigurisani alat obrisan';
$string['tooltypenotdeleted'] = 'Nije moguće obrisati prekonfigurisani alat';
$string['tooltypes'] = 'Alati';
$string['tooltypeupdated'] = 'Prekonfigurisani alat ažuriran';
$string['toolurl'] = 'URL adresa alata';
$string['toolurl_contentitemselectionrequest'] = 'URL adresa za Izbor sadržaja';
$string['toolurl_contentitemselectionrequest_help'] = 'URL adresa za Izbor sadržaja će se koristiti za pokretanje stranice za izbor sadržaja od provajdera alata. Ako je prazno, koristiće se URL adresa alata';
$string['toolurl_help'] = 'URL adresa alata se koristi kako bi se URL adresa uparila sa ispravnom konfiguracijom alata. Upotreba prefiksa http(s), na početku adresu, nije obavezna.

Osim toga, osnovna URL adresa se koristi kao URL adresa alata ako ova nije navedena u instanci eksternog alata.

Na primer, osnovna URL adresa za *tool.com* treba da odgovara nekoj od sledećih adresa:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Osnovna URL adresa za *www.tool.com/quizzes* treba da odgovara nekoj od sledećih adresa:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Osnovna URL adresa za *quiz.tool.com* treba da odgovara nekoj od sledećih adresa:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Ukoliko postoje dve različite konfiguracije alata za isti domen, koristiće se ona sa najpreciznijom adresom.

Možete, takođe, da umetnete URL adresu kertridža ako je imate, i detaljne informacije o alatu će se automatski popuniti.';
$string['toolurlplaceholder'] = 'URL adresa alata…';
$string['typename'] = 'Naziv alata';
$string['typename_help'] = 'Naziv alata se koristi za identifikaciju provajdera alata unutar Moodlea. Naziv koji se unese biće vidljiv predavačima kada dodaju eksterne alate unutar kursa.';
$string['types'] = 'Tipovi';
$string['unabletocreatetooltype'] = 'Nije moguće kreirati alat';
$string['unabletofindtooltype'] = 'Nije moguće pronaći alat za {$a→id}';
$string['unknownstate'] = 'Nepoznati status';
$string['update'] = 'Ažuriraj';
$string['useraccountinformation'] = 'Informacije o korisničkom nalogu';
$string['userpersonalinformation'] = 'Lične informacije o korisniku';
$string['using_tool_cartridge'] = 'Korišćenje kertridža alata';
$string['using_tool_configuration'] = 'Korišćenje konfiguracije alata';
$string['validurl'] = 'Ispravna URL adresa mora početi sa http(s)://';
$string['viewsubmissions'] = 'Prikaz završenih aktivnosti i ekran za ocenjivanje';
