<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'sr_lt', version '4.1'.
 *
 * @package     mnet
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (self-signed)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (signed)';
$string['RPC_HTTP_PLAINTEXT'] = 'HTTP unencrypted';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP (self-signed)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP (signed)';
$string['aboutyourhost'] = 'O Vašem serveru';
$string['accesslevel'] = 'Nivo pristupa';
$string['addhost'] = 'Dodaj računar';
$string['addnewhost'] = 'Dodaj novi računar';
$string['addtoacl'] = 'Dodaj u kontrolu pristupa';
$string['allhosts'] = 'Svi domaćini';
$string['allhosts_no_options'] = 'Nema dostupnih opcija prilikom pregledavanje više host računara';
$string['allow'] = 'Dozvoli';
$string['applicationtype'] = 'Tip aplikacije';
$string['authfail_nosessionexists'] = 'Neuspešna autorizacija: mnet sesija ne postoji.';
$string['authfail_sessiontimedout'] = 'Neuspešna autorizacija: mnet sesija je istekla.';
$string['authfail_usermismatch'] = 'Neuspešna autorizacija: korisnik se ne podudara.';
$string['authmnetdisabled'] = 'MNet dodatak za proveru identiteta je <strong>onemogućen</strong>.';
$string['badcert'] = 'Sertifikat nije ispravan.';
$string['certdetails'] = 'Detalji sertifikata';
$string['configmnet'] = 'MNet  (Moodle umrežavanje) dozvoljava komunikaciju ovog servera sa drugim serverima ili servisima.';
$string['couldnotgetcert'] = 'Nije nađen sertifikat na <br />{$a}. <br />Računar je možda isključen ili neispravno podešen.';
$string['couldnotmatchcert'] = 'Ovo se ne podudara sa sertifikatom koji trenutno izdaje web server.';
$string['courses'] = 'kursevi';
$string['courseson'] = 'kursevi na';
$string['current_transport'] = 'Trenutni transport';
$string['currentkey'] = 'Trenutni javni ključ';
$string['databaseerror'] = 'Upisivanje detalja u bazu podataka nije bilo moguće.';
$string['deleteaserver'] = 'Brisanje servera';
$string['deletedhostinfo'] = 'Ovaj host računar je obrisan. Ako želite da poništite brisanje, prebacite status brisanja na \'Ne\'';
$string['deletedhosts'] = 'Obrisani host računari: {$a}';
$string['deletehost'] = 'Obriši računar';
$string['deletekeycheck'] = 'Da li ste potpuno sigurni da želite da obrišete ovaj ključ?';
$string['deleteoutoftime'] = 'Istekao je period od 60 sekundi koji ste imali da obrišete ovaj ključ. Počnite ponovo.';
$string['deleteuserrecord'] = 'SSO ACL: obriši zapis za korisnika \'{$a->user}\' sa {$a->host}.';
$string['deletewrongkeyvalue'] = 'Došlo je do greška. Ako niste pokušali da obrišete SSL ključ svog servera, moguće je da ste bili žrtva napada. Nijedna akcija nije bila izvršena.';
$string['deny'] = 'Odbij';
$string['description'] = 'Opis';
$string['duplicate_usernames'] = 'Kreiranje kolona "mnethostid" i "username" u Vašoj tabeli korisnika nije bilo moguće.<br />Ovo se može desiti kada imate  <a href="{$a}" target="_blank">duplikate korisničkih imena u Vašoj tabeli korisnika</a>.<br /> Vaša nadogradnja bi, ipak, trebalo da bude uspešno završena. Kliknite na gornji link i upustva za rešenje problema će se pojaviti u novom prozoru. To možete obaviti na kraju procesa nadogradnje.<br />';
$string['enabled_for_all'] = '(Ova usluga je omogućena za sve računare).';
$string['enterausername'] = 'Molimo Vas da unesete korisničko ime, ili spisak korisničkih imena odvojenih zarezima.';
$string['error7020'] = 'Ova greška se obično javlja kada je udaljeni sajt kreirao zapis za vas sa pogrešnom adresom tj. wwwroot (na primer, https://vassajt.com umesto https://www.vassajt.com). Obratite se adminstratoru udaljenog sajta i zamolite ga da ažurira zapis za vaš sajt i unese ispravnu adresu tj. wwwroot (onako kako je to navedeno u vašoj config.php datoteci)';
$string['error7022'] = 'Poruka koju ste poslali udaljenom sajtu je ispravno šifrovana ali nije potpisana. Ovo je neočekivana greška - ukoliko se pojavi potrebno je da je prijavite, sa što je moguće više informacija o verziji Moodlea o kojoj je reč itd.';
$string['error7023'] = 'Udaljeni sajt je pokušao da dešifruje vašu poruku, sa svim ključevima koje ima u zapisu za vaš sajt, ali bez uspeha. Možda biste mogli da rešite ovaj problem tako što ćete ručno uneti novi ključ na udaljenom sajtu. Malo je verovatno da se ovo dogodi, osim ako sa udaljenim sajtom niste komunicirali više meseci.';
$string['error7024'] = 'Poslali ste nešifrovanu poruku udaljenom sajtu, ali on ne prihvata nešifrovanu komunikaciju sa vašim sajtom. Ovo je neočekivana greška; ako se to dogodi verovatno bi trebalo da prijavite grešku  (sa što je moguće više informacija o verzijama aplikacija o kojima je reč, itd.).';
$string['error7026'] = 'Ključ kojim je vaša poruka bila potpisana je različit od ključa koji udaljeni računar u datoteci za vaš server. Osim toga, udaljeni računar je pokušao da dobavi vaš trenutni kluč ali nije uspeo. Molimo vas da ručno podesite ključ sa udaljenim računarom i pokušate ponovo.';
$string['error709'] = 'Udaljeni sajt nije uspeo da dobije SSL ključ od vas.';
$string['eventaccesscontrolcreated'] = 'Kontrola pristupa kreirana';
$string['eventaccesscontrolupdated'] = 'Kontrola pristupa ažurirana';
$string['expired'] = 'Ovaj ključ je istekao';
$string['expires'] = 'Važi do';
$string['expireyourkey'] = 'Obriši ovaj ključ';
$string['expireyourkeyexplain'] = 'Moodle automatski rotira vaše ključeve svakih 28 dana (standardno), ali imate opciju da bilo kada <em>ručno</em> poništite ovaj ključ. Ovo će biti korisno jedino ako verujete da je ovaj ključ kompromitovan. Novi ključ će odmah biti automatski generisan.<br /> Brisanje ovog ključa će onemogućiti ostale aplikacije da komuniciraju sa vama, dok sami ne kontaktirate svakog administratora i date mu svoj novi ključ.';
$string['exportfields'] = 'Polja za izvoz';
$string['failedaclwrite'] = 'Upisivanje u MNet listu kontrole pristupa za korisnika \'{$a}\' nije bilo moguće.';
$string['findlogin'] = 'Pronađi pristup';
$string['forbidden-function'] = 'Ta fukcija nije omogućena za RPC.';
$string['forbidden-transport'] = 'Metoda transporta koju pokušavate da koristite nije dozvoljena.';
$string['forcesavechanges'] = 'Prinudno snimanje promena';
$string['helpnetworksettings'] = 'Podesi MNet komunikaciju';
$string['hidelocal'] = 'Sakrij lokalne korisnike';
$string['hideremote'] = 'Sakrij udaljene korisnike';
$string['host'] = 'računar';
$string['hostcoursenotfound'] = 'Računar ili kurs nije nađen';
$string['hostdeleted'] = 'Računar je obrisan';
$string['hostexists'] = 'Već postoji zapis za računar sa identičnim nazivom (moguće je da je obrisan). <a href="{$a}">Uredite zapis</a>.';
$string['hostlist'] = 'Spisak umreženih računara';
$string['hostname'] = 'Naziv računara';
$string['hostnamehelp'] = 'Puno ime domena za udaljeni računar, npr. www.primer.com';
$string['hostnotconfiguredforsso'] = 'Ovaj server nije podešen za udaljeno prijavljivanje.';
$string['hostsettings'] = 'Podešavanja računara domaćina';
$string['http_self_signed_help'] = 'Dozvoli konekcije koje koriste samo-potpisani DIY SSL sertifikat na udaljenom računaru.';
$string['http_verified_help'] = 'Dozvoli konekcije koje koriste verifikovani SSL sertifikat u PHP-u na udaljenom računaru, ali preko http, a ne https protokola.';
$string['https_self_signed_help'] = 'Dozvoli konekcije kore koriste samo-potpisani DIY SSL sertifikat u PHP-u na udaljenom računaru preko http-a.';
$string['https_verified_help'] = 'Dozvoli konekcije koje koriste verifikovani SSL sertifikat na udaljenom računaru.';
$string['id'] = 'ID';
$string['idhelp'] = 'Ova vrednost se automatski dodeljuje i ne može se izmeniti.';
$string['importfields'] = 'Polja za uvoz';
$string['inspect'] = 'Pregledaj';
$string['installnosuchfunction'] = 'Programska greška! Nešto pokušava da instalira mnet xmlrpc funkciju ({$a->method}) iz datoteke ({$a->file}), ali funkciju nije moguće pronaći!';
$string['installnosuchmethod'] = 'Programska greška! Nešto pokušava da instalira mnet xmlrpc metodu ({$a->method}) u klasi ({$a->class}), ali metod nije moguće pronaći!';
$string['installreflectionclasserror'] = 'Programska greška! MNet introspekcija nije uspela za metod ({$a->method}) u klasi \'{$a->class}\'. Tekst poruke o izvornoj grešci glasi: \'{$a->error}\'';
$string['installreflectionfunctionerror'] = 'Programska greška! MNet introspekcija nije uspela za funkciju ({$a->method}) u datoteci \'{$a->file}\'. Tekst poruke o izvornoj grešci glasi: \'{$a->error}\'';
$string['invalidaccessparam'] = 'Neispravan parametar pristupa.';
$string['invalidactionparam'] = 'Neispravan parametar akcije.';
$string['invalidhost'] = 'Morate dati ispravan identifikator računara';
$string['invalidpubkey'] = 'Ovaj ključ nije ispravan SSL ključ. ({$a})';
$string['invalidurl'] = 'Neispravan URL parametar.';
$string['ipaddress'] = 'IP adresa';
$string['is_in_range'] = 'IP adresa  <code>{$a}</code> predstavlja ispravan pouzdan računar.';
$string['ispublished'] = '{$a} je omogućio ovu uslugu za vas.';
$string['issubscribed'] = '{$a} se pretplaćuje se na ovu uslugu na vašem računaru.';
$string['keydeleted'] = 'Vaš ključ je uspešno obrisan i zamenjen.';
$string['keydeletedcancelled'] = 'Nema promena na ključu.';
$string['keymismatch'] = 'Javni ključ koji imate za svoj računar se razlikuje od javnog ključa koji on trenutno objavljuje. Trenutno objavljen ključ je:';
$string['last_connect_time'] = 'Vreme poslednje konekcije';
$string['last_connect_time_help'] = 'Vreme kada ste se posednji put povezali na ovaj računar.';
$string['last_transport_help'] = 'Transport koji ste koristili za poslednju konekciju sa ovim računarom.';
$string['leavedefault'] = 'Koristi podrazumevana podešavanja, umesto toga';
$string['listservices'] = 'Spisak servis';
$string['loginlinkmnetuser'] = '<br />Ako ste udaljeni korisnik Moodle mreže (MNet) i ako imate mogućnost da <a href="{$a}">potvrdite svoju adresu ovde</a>, možete biti preusmereni na svoju stranicu za prijavljivanje.';
$string['logs'] = 'zapisi';
$string['managemnetpeers'] = 'Upravljanje ravnopravnim serverima';
$string['method'] = 'Metod';
$string['methodhelp'] = 'Pomoć za metod {$a}';
$string['methodsavailableonhost'] = 'Metode dostupne na {$a}';
$string['methodsavailableonhostinservice'] = 'Metode dostupne za {$a->service} na {$a->host}';
$string['methodsignature'] = 'Metod potpisa za {$}';
$string['mnet'] = 'MNet (Moodle umrežavanje)';
$string['mnet_concatenate_strings'] = 'Spoji (do) 3 znakovna niza i vrati rezultate';
$string['mnet_session_prohibited'] = 'Korisnicima na Vašem serveru trenutno nije dozvoljeno da lutaju do {$a}.';
$string['mnetdisabled'] = 'MNet  je <strong>onemogućen</strong>.';
$string['mnetidprovider'] = 'ID oznaka MNet provajdera';
$string['mnetidproviderdesc'] = 'Možete da upotrebite ovu proceduru kako biste ponovo preuzeli link za prijavu, pod uslovom da možete da obezbedite ispravnu adresu e-pošte koja odgovara korisničkom imenu sa kojim ste prethodno pokušali da se prijavite.';
$string['mnetidprovidermsg'] = 'Trebalo bi da imate mogućnost da se prijavite kod svog provajdera  {$a}';
$string['mnetidprovidernotfound'] = 'Nažalost, nije moguće pronaći više informacija.';
$string['mnetpeers'] = 'Ravnopravni uređaji';
$string['mnetservices'] = 'Usluge';
$string['mnetsettings'] = 'MNet podešavanja';
$string['moodle_home_help'] = 'Putanja do početne stranice MNet aplikacije tj. Moodlea na udaljenom računaru, npr. /moodle/.';
$string['name'] = 'Naziv';
$string['net'] = 'Umrežavanje';
$string['networksettings'] = 'Mrežna podešavanja';
$string['never'] = 'Nikad';
$string['noaclentries'] = 'Nema unosa u listi kontrole pristupa SSO.';
$string['noaddressforhost'] = 'Oprоstite, ali naziv servera ({$a}) nije bilo moguće razrešiti.';
$string['nocurl'] = 'PHP cURL biblioteka nije instalirana';
$string['nolocaluser'] = 'Za udaljenog korisnika ne postoji lokalni zapis, niti on može biti kreiran budući da ovaj server ne kreira nove korisnike automatski. Kontaktirajte svog admimnistratora!';
$string['nomodifyacl'] = 'Nije vam dozvoljeno da menjate MNet listu za kontrolu pristupa.';
$string['nonmatchingcert'] = 'Predmet sertifikata: <br /><em>{$a->subject}</em><br />se ne podudara sa računarom sa kojeg je dolazi: <br /><em>{$a->host}</em>.';
$string['nopubkey'] = 'Bilo je problema sa preuzimanjem javnog ključa.<br />Možda računar ne dozvoljava Moodle umrežavanje (MNet), ili je ključ neispravan.';
$string['nosite'] = 'Nije pronađen kurs na nivou sajta';
$string['nosuchfile'] = 'Datoteka/fukcija {$a} ne postoji.';
$string['nosuchfunction'] = 'Fukcija nije pronađena, ili je zabranjena za RPC.';
$string['nosuchmodule'] = 'Funkcija je neispravno adresirana i ne može biti locirana. Molimo vas da koristite format mod/modulename/lib/functionname.';
$string['nosuchpublickey'] = 'Nije pronađen javni ključ za verifikaciju potpisa.';
$string['nosuchservice'] = 'RPC usluga nije uključena na ovom računaru.';
$string['nosuchtransport'] = 'Ne postoji transport koji ima taj ID';
$string['notBASE64'] = 'Ovaj znakovni niz nije u base64 kodiranom formatu. Ne može biti ispravan ključ.';
$string['notPEM'] = 'Ovaj ključ nije u PEM formatu. Neće raditi.';
$string['not_in_range'] = 'IP adresa  <code>{$a}</code>  ne predstavlja ispravan pouzdan računar.';
$string['notenoughidpinfo'] = 'Provajder vašeg identiteta nam ne daje dovoljno informacija za kreiranje ili ažuriranje Vašeg lokalnog naloga.';
$string['notinxmlrpcserver'] = 'Pokušaj pristupa MNet udaljenom klijentu, izvan prerioda kada server izvršava XMLRPC';
$string['notmoodleapplication'] = 'UPOZORENJE: Ovo nije Moodle aplikacija, tako da neke od metoda inspekcije možda neće ispravno raditi.';
$string['notpermittedtojump'] = 'Nemate ovlašćenje da počnete udaljenu sesiju sa ovog Moodle servera.';
$string['notpermittedtojumpas'] = 'Ne možete da započnete udaljenu sesiju dok ste prijavljeni pod drugim korisničkim imenom.';
$string['notpermittedtoland'] = 'Nemate dozvolu da počnete udaljenu sesiju.';
$string['off'] = 'Isključeno';
$string['on'] = 'Uključeno';
$string['options'] = 'Opcije';
$string['peerprofilefielddesc'] = 'Ovde možete promeniti globalna podešavanja o tome koja polja korisničkog profila se šalju ili uvoze pri kreiranju novih korisničkih naloga';
$string['permittedtransports'] = 'Dozvoljeni transporti';
$string['phperror'] = 'Unutrašnja PHP greška je sprečila ispunjenje vašeg zahteva.';
$string['position'] = 'Pozicija';
$string['postrequired'] = 'Funkcija brisanja zahteva POST zahtev.';
$string['privacy:metadata'] = 'MNet dodatak ne čuva nikakve lične podatke.';
$string['profileexportfields'] = 'Polja za slanje';
$string['profilefielddesc'] = 'Ovde možete podesiti spisak polja korisničkog profila koja se šalju i primaju preko MNet mreže kada se kreiraju novi ili ažuriraju postojeći korisnički nalozi. Možete, takođe, da promeniti ovaj spisak polja za svaki MNet server pojedinačno. Uzmite u obzir da se sledeća polja UVEK šalju i da nisu opciona: {$a}';
$string['profilefields'] = 'Polja profila';
$string['profileimportfields'] = 'Polja za uvoz';
$string['promiscuous'] = 'Promiskuitetni';
$string['publickey'] = 'Javni ključ';
$string['publickey_help'] = 'Javni ključ se automatski preuzima sa udaljenog servera.';
$string['publickeyrequired'] = 'Morate da obezbedite javni ključ';
$string['publish'] = 'Objavi';
$string['reallydeleteserver'] = 'Da li ste sigurni da želite da obrišete server?';
$string['receivedwarnings'] = 'Primljena su sledeća upozorenja';
$string['recordnoexists'] = 'Zapis ne postoji.';
$string['reenableserver'] = 'Ne - izaberite ovu opciju da ponovo aktivirate ovaj server.';
$string['registerallhosts'] = 'Registruj sve host računare (neselektivni režim rada)';
$string['registerallhostsexplain'] = 'Možete izabrati da automatski registrujete sve računare koji pokušavaju automatski da se povežu sa vama.
Ovo znači da će se pojaviti zapis u vašoj listi host računara za bilo koji MNet sajt koji se sa vama povezuje i traži vaš javni ključ.<br />U nastavku imate opciju da podesite servise za \'Sve računare\'. Aktiviranjem nekih od servisa  bićete u mogućnosti da ih obezbedite bilo kom udaljenom serveru, bez izuzetka.';
$string['registerhostsoff'] = 'Registruj sve host računare koji su trenutno <b>isključeni</b>';
$string['registerhostson'] = 'Registruj sve host računare koji su  trenutno <b>uključeni</b>';
$string['remotecourses'] = 'Udaljeni kursevi';
$string['remotehost'] = 'Udaljeni server';
$string['remotehosts'] = 'Udaljeni računari';
$string['remoteuser'] = 'Udaljeni {$a->remotetype} korisnik';
$string['remoteuserinfo'] = 'Profil je preuzet sa <a href="{$a->remoteurl}">{$a->remotename}</a>';
$string['requiresopenssl'] = 'Umrežavanje zahteva OpenSSL ekstenziju';
$string['restore'] = 'Restauriraj';
$string['returnvalue'] = 'Povratna vrednost';
$string['reviewhostdetails'] = 'Pregledaj detalje servera';
$string['reviewhostservices'] = 'Pregledaj usluge servera';
$string['selectaccesslevel'] = 'Molimo Vas da izaberete nivo pristupa sa liste';
$string['selectahost'] = 'Molimo izaberite udaljeni Moodle računar.';
$string['service'] = 'Naziv servisa';
$string['serviceid'] = 'ID servisa';
$string['servicesavailableonhost'] = 'Servisi dostupni na {$a}';
$string['serviceswepublish'] = 'Usluge koje objavljujemo za {$a}.';
$string['serviceswesubscribeto'] = 'Usluge na {$a} koje pratimo.';
$string['settings'] = 'Podešavanja';
$string['showlocal'] = 'Pokaži lokalne korisnike';
$string['showremote'] = 'Pokaži udaljene korisnike';
$string['ssl_acl_allow'] = 'SSO ACL: Dozvoli pristup korisniku \'{$a->user}\' sa računara \'{$a->host}\'';
$string['ssl_acl_deny'] = 'SSO ACL: Zabrani pristup korisniku \'{$a->user}\' sa računara \'{$a->host}\'';
$string['sslverification'] = 'SSL verifikacija';
$string['sslverification_help'] = 'Ova opcija vam dozvoljava da podesite nivo bezbednosti kada se povezujete na drugi ravnopravan uređaj korišćenjem HTTPS-a.

* Bez: nema nivoa bezbednosti
* Potvrdi samo domaćina: potvrđuje domen SSL sertifikata
* Potvrdi domaćina i ravnopravan uređaj (preporučeno): potvrđuje domen i izdavača SSL sertifikata';
$string['ssoaccesscontrol'] = 'SSO kontrola pristupa';
$string['ssoacldescr'] = 'Koristite ovu stranu da dozvolite/odbijete pristup određenom korisniku sa udaljenog MNet računara. Ovo je korisno ako udaljenim korisnicima pružate SSO servis. Kako biste kontrolisali mogućnost vaših <em>lokalnih</em> korisnika da se prijavljuju na druge MNet host računare, upotrebite sistem uloga da biste im odobrili <em>mnetlogintoremote</em> sposobnost.';
$string['ssoaclneeds'] = 'Da bi ova opcija mogla da radi, morate da uključite Moodle umrežavanje, kao i MNet dodatak za proveru identiteta.';
$string['strict'] = 'Strogo';
$string['subscribe'] = 'Prati';
$string['system'] = 'Sistem';
$string['testclient'] = 'MNet test klijent';
$string['testtrustedhosts'] = 'Testiraj adresu';
$string['testtrustedhostsexplain'] = 'Unesite IP adresu da vidite da li je to siguran računar.';
$string['theypublish'] = 'Oni objavljuju';
$string['theysubscribe'] = 'Oni su pretplaćeni';
$string['transport_help'] = 'Ove opcije su recipročne, tako da možete naterati udaljeni računar da koristi potpisani SSL sertifikat ako Vaš server takođe poseduje potpisan SSL sertifikat.';
$string['trustedhosts'] = 'XML-RPC računari';
$string['trustedhostsexplain'] = '<p>Mehanizam pouzdanih računara dozvoljava određenim mašinama da izvršavaju pozive preko XML-RPC bilo kom delu Moodle API-a. Ova opcija je dostupna kako bi skripte kontrolisale ponašanje Moodlea, i može biti veoma opasna. Ako niste sigurni, ostavite je isključenu.</p>
<p><strong>Opcija nije neophodna za bilo koju standardnu MNet funkciju!</strong>. Uključite je samo ukoliko tačno znate šta radite.</p>
<p>Da biste je omogućili, unesite spisak IP adresa ili mreža, po jednu u svaki red.
Neki primeri:</p>Vaš lokalni računar:<br />127.0.0.1<br />Vaš lokalni računar (sa mrežnim blokom):<br />127.0.0.1/32<br />Samo računar sa IP adresom 192.168.0.7:<br />192.168.0.7/32<br />Bilo koji host računar sa IP adresom između 192.168.0.1 i 192.168.0.255:<br />192.168.0.0/24<br />Bilo koji host računar:<br />192.168.0.0/0<br />Naravno, poslednji primer se <strong>ne preporučuje</strong>.';
$string['turnitoff'] = 'Isključi';
$string['turniton'] = 'Uključi';
$string['type'] = 'Tip';
$string['unknown'] = 'Nepoznato';
$string['unknownerror'] = 'Nepoznata greška se dogodila tokom pregovaranja.';
$string['usercannotchangepassword'] = 'Ovde ne možete promeniti lozinku pošto ste udaljeni korisnik.';
$string['userchangepasswordlink'] = '<br />Možda ćete moći da promenite svoju lozinku kod svog <a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a> dobavljača.';
$string['usernotfullysetup'] = 'Vaš korisnički nalog nije potpun. Morate da da se vratite na <a href="{$a}">svoj izvorni Moodle sajt</a> i proverite da li su uneti svi podaci u Vaš profil. Možda ćete morati da se odjaviti i ponovo prijaviti kako bi te izmene mogle da se ažuriraju i na ovom sajtu.';
$string['usersareonline'] = 'Upozorenje: broj korisnika sa tog servera koji su trenutno prijavljeni na Vaš sajt je {$a}.';
$string['validated_by'] = 'Ispravnost proverava mreža: <code>{$a}</code>';
$string['verifyhostandpeer'] = 'Potvrdi domaćina i ravnopravan uređaj';
$string['verifyhostonly'] = 'Potvrdi samo domaćina';
$string['verifysignature-error'] = 'Neuspešna provera ispravnosti potpisa: javila se greška.';
$string['verifysignature-invalid'] = 'Neuspešna provera ispravnosti potpisa. Izgeda da ove korisničke podatke niste potpisali Vi.';
$string['version'] = 'Verzija';
$string['warning'] = 'Upozorenje';
$string['wrong-ip'] = 'Vaša IP adresa se ne podudara sa adresom koju imamo u zapisu.';
$string['xmlrpc-missing'] = 'XML-RPC mora biti instaliran na Vašoj verziji PHP-a kako biste mogli da koristite ovu funkciju.';
$string['yourhost'] = 'Vaš računar';
$string['yourpeers'] = 'Vaši ravnopravni uređaji';
