<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_pioneer', language 'sr_lt', version '4.1'.
 *
 * @package     theme_pioneer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitybackground'] = 'Boja pozadine aktivnosti na kursu';
$string['activitybackground_desc'] = 'Ovo je boja pozadine polja kada se prikazuju aktivnosti kao što su lekcija, zadatak itd.';
$string['allclasses'] = 'Svi časovi';
$string['allcourses'] = 'Svi kursevi';
$string['allmodules'] = 'Svi moduli';
$string['allunits'] = 'Sve jedinice';
$string['alwaysdisplay'] = 'Uvek prikaži';
$string['analyticscleanurl'] = 'Čista URL adresa';
$string['analyticscleanurldesc'] = 'Generiše čistu URL adresu za napredno praćenje';
$string['analyticsenabled'] = 'Omogućeno';
$string['analyticsenableddesc'] = 'Omogućava analitiku za Moodle';
$string['analyticsheading'] = 'Google Analytics';
$string['analyticssiteid'] = 'ID oznaka sajta';
$string['analyticssiteiddesc'] = 'Unesite ID oznaku vašeg sajta';
$string['analyticstrackadmin'] = 'Praćenje administratora';
$string['analyticstrackadmindesc'] = 'Omogućava praćenje aktivnosti administratora (ne preporučuje se)';
$string['analyticstrackingid'] = 'ID oznaka sajta';
$string['analyticstrackingiddesc'] = 'Unesite vašu ID oznaku praćenja sa Googlea';
$string['backgroundfixed'] = 'Fiksirana pozadina';
$string['backgroundfixed_desc'] = 'Upotrebite ovo podešavanje kako biste fiksirali pozadinsku sliku za stranicu.';
$string['backgroundimage'] = 'Pozadinska slika';
$string['backgroundimage_desc'] = 'Slika koja se prikazuje u pozadini sajta.';
$string['backgroundimageinfo'] = 'Pozadinska slika';
$string['backgroundimageinfodesc'] = 'Pošto se glavni sadržaj rasprostire čitavom širinom ekrana videćete samo mali deo boje pozadine na samom dnu stranice. Možete da postavite sliku ako želite.';
$string['backgroundposition'] = 'Položaj pozadine';
$string['backgroundposition_desc'] = 'Položaj pozadinske slike.';
$string['backgroundpositioncenterbottom'] = 'Centar dno';
$string['backgroundpositioncentercenter'] = 'Centar sredina';
$string['backgroundpositioncentertop'] = 'Centar vrh';
$string['backgroundpositionleftbottom'] = 'Levo dno';
$string['backgroundpositionleftcenter'] = 'Levo sredina';
$string['backgroundpositionlefttop'] = 'Levo vrh';
$string['backgroundpositionrightbottom'] = 'Desno dno';
$string['backgroundpositionrightcenter'] = 'Desno sredina';
$string['backgroundpositionrighttop'] = 'Desno vrh';
$string['backgroundrepeat'] = 'Ponavljanje pozadine';
$string['backgroundrepeat_desc'] = 'Definiše način na koji će se pozadinska slika ponavljati.';
$string['backgroundrepeatnorepeat'] = 'Bez ponavljanja';
$string['backgroundrepeatrepeat'] = 'Ponovi';
$string['backgroundrepeatrepeatx'] = 'Ponovi horizontalno';
$string['backgroundrepeatrepeaty'] = 'Ponovi vertikalno';
$string['blockbordercolor'] = 'Boja ivice bloka';
$string['blockbordercolor_desc'] = 'Ovo je boja ivice bloka unutar kursa. To je i boja pozadine naslova bloka.';
$string['blockcolor'] = 'Boja bloka';
$string['blockcolor_desc'] = 'Ovo je boja pozadine bloka unutar kursa';
$string['blockheadercolor'] = 'Boja zaglavlja bloka';
$string['blockheadercolor_desc'] = 'Ovo je boja pozadine zaglavlja u svakom bloku. Koristite ove podešavanje ako želite jednu boju pozadine zaglavlja za sve blokove.';
$string['blockposition'] = 'Poravnaj blokove';
$string['blockposition_desc'] = 'Postavite blokove levo ili desno od sadržaja.';
$string['blocksdesc'] = 'Poravnajte blokove uz levu ili desnu ivicu stranice.';
$string['blocksinfo'] = 'Pozicija blokova';
$string['blocksleft'] = 'Poravnaj blokove nalevo';
$string['blocksright'] = 'Poravnaj blokove nadesno';
$string['blocktitlecolor'] = 'Boja teksta naslova bloka';
$string['blocktitlecolor_desc'] = 'Ovo je boja teksta naslova bloka.';
$string['bodybackground'] = 'Boja pozadine';
$string['bodybackground_desc'] = 'Glavna boja koja će se koristiti za pozadinu.';
$string['bodyfont'] = 'Osnovni font';
$string['bodyfontdesc'] = 'OSNOVNI FONT - KORAK 2: Kopirajte kôd Google fonta koji počinje sa porodicom fontova (integrišite fontove u vaš CSS)';
$string['bodysize'] = 'Veličina osnovnog teksta';
$string['bodysizedesc'] = 'Koristite broj, npr. 14 piksela';
$string['bodyweight'] = 'Debljina osnovnog fonta';
$string['bodyweightdesc'] = 'Tipično, Google fontovi imaće broj kao što je 100, 200, 300, itd. Upišite taj broj ovde.';
$string['bothpositions'] = 'Obe pozicije';
$string['breadcrumbcolor'] = 'Boja navigacione putanje';
$string['breadcrumbcolor_desc'] = 'Izaberite boju pozadine trake sa navigacionom putanjom. Traka je smeštena odmah ispod slike glavnog zaglavlja stranice.';
$string['breadcrumbcolorhover'] = 'Lebdeća boja navigacione putanje';
$string['breadcrumbcolorhover_desc'] = 'Izaberite boju pozadine za traku navigacione putanje kada se mišem prelazi preko njenih stavki. Traka je smeštena odmah ispod slike glavnog zaglavlja stranice.';
$string['breadcrumbtext'] = 'Boja teksta navigacione putanje';
$string['breadcrumbtext_desc'] = 'Izaberite boju za tekst navigacione putanje.';
$string['choosereadme'] = '<p>Pioneer je lepa grafička tema, prilagodljivog dizajna sa velikim brojem funkcija počev od namenski prilagođenih kartica i klizača za knjigu ocena do mogućnosti da predavač postavi zasebnu sliku zaglavlja među datoteke rezimea kursa! Svaki od glavnih elemenata teme može biti prilagođen prema potrebama, na stranici za podešavanje teme. Pioneer je tema koja napravljena za potrebe  Dearborn Public Schools, Michigan.</p>';
$string['colorheading'] = 'Boje';
$string['configtitle'] = 'Pioneer';
$string['contentbackground'] = 'Boja pozadine glavnog sadržaja';
$string['contentbackground_desc'] = 'Boja pozadine glavnog sadržaja na sajtu. Ostavite prazno ako želite da glavni sadržaj nema boju pozadine.';
$string['contentbackgroundcolor'] = 'Boja pozadine sadržaja';
$string['contentbackgroundcolor_desc'] = 'Ovo je boja pozadine glavnog sadržaja kursa. Ako boju ovde obrišete, kao boja pozadine biće iskorišćena osnovna boja pozadina, dole navedena, kao i podešavanja pozadinske slike.';
$string['copyrighttext'] = 'Obaveštenje o autorskim pravima';
$string['copyrighttext_desc'] = 'Dodajte obaveštenje o autorskim pravima. Ono će se pojaviti u podnožju stranice.';
$string['coursecomplete'] = 'Kružni indikator završetka aktivnosti';
$string['coursecomplete_desc'] = 'Ako kurs koristi opciju za praćenje završetka aktivnosti i ako je ova opcija uključena, onda će polaznici, u gornjem levom uglu stranice, videti indikator svojih postignuća u obliku kruga, zajedno sa procentom aktivnosti koje su uspešno završili.';
$string['coursegradebutton'] = 'Ocene na kursu';
$string['coursegradeinfo'] = 'Region zaglavlja kursa (Kartice naslovne stranice i Ocene na kursu)';
$string['coursegradeinfodesc'] = 'Ova podešavanja kontrolišu dugme klizača na na naslovnoj stranici i glavnoj stranici kursa. Klizač ”Ocene na kursu” prikazuje spisak svih aktivnosti na kursu koje se ocenjuju kao i ocene studenta za svaku od njih. Kartice na naslovnoj stranici zahtevaju da prethodno dodate sadržaj za njih na stranici za uređivanje ”Kartice naslovne stranice”. Da bi se ocene na kursu uopšte pojavile potrebno je da, u delu stranici za podešavanje kursa ”Izgled”, podesite opciju ”Prikaži ocene polaznicima” na DA.';
$string['coursegradestext'] = 'Tekst dugmeta ”Ocene na kursu”';
$string['coursegradestextdesc'] = 'Unesite tekst koji želite da se pojavi na dugmetu prekidača.';
$string['coursegradetoggle'] = 'Prikaži/sakrij klizač za ocene na kursu';
$string['coursegradetoggle_desc'] = 'Ovo će omogućiti polaznicima da brzo vide spisak svih aktivnosti i svoje ocene u zaglavlju na vrhu stranice, odmah iznad navigacione putanje a ispod naziva kursa.';
$string['coursetitlebkg'] = 'Boja pozadine naslova kursa';
$string['coursetitlebkg_desc'] = 'Ovo je boja polja koje se pojavljuje iza naslova kursa. Kako bi tema izgledala konzistento, ova boja se, takođe, koristi kao boja pozadine za slajd-šou kurseva i naslove dostupnih kurseva.';
$string['coursetitletxt'] = 'Boja teksta naslova kursa';
$string['coursetitletxt_desc'] = 'Ovo je boja naslova kursa.';
$string['createusertoggle'] = 'Link za kreiranje novog naloga';
$string['createusertoggle_desc'] = 'Prikazuje/skriva link za kreiranje novog korisničkog naloga na prilagođenom obrascu za prijavu na naslovnoj stranici.';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcssdesc'] = 'CSS pravila koja dodate u ovo polje za tekst odraziće se na izgled svih stranica, što olakšava prilagođavanje ove teme.';
$string['customlogindesc'] = 'Opcije za prilagođenu prijavu';
$string['customlogininfo'] = 'Prilagođena prijava';
$string['custommenudesc'] = 'Ova podešavanja daju vam mogućnost da prilagođenom meniju dodate dopunsku funkcionalnost (poznatu i kao padajući meni)';
$string['custommenuheadingsub'] = 'Dodajte dopunsku funkcionalnost svom prilagođenom meniju.';
$string['displayafterlogin'] = 'Prikaži samo nakon prijave na sistem';
$string['displaybeforelogin'] = 'Prikaži samo pre prijave na sistem';
$string['displaymycourses'] = 'Prikaži upisane kurseve';
$string['displaymycoursesdesc'] = 'Prikazuje korisnicima u prilagođenom meniju kurseve koje su upisali';
$string['displaymydashboard'] = 'Prikaži kontrolni panel';
$string['displaymydashboarddesc'] = 'Prikazuje link za kontrolni panel u prilagođenom meniju korisnika';
$string['dontdisplay'] = 'Nikad ne prikazuj';
$string['editoff'] = 'Isključi uređivanje';
$string['editon'] = 'Uključi uređivanje';
$string['enablethiscourse'] = 'Meni aktivnosti na kursu';
$string['enablethiscoursedesc'] = 'Prikazuje padajući meni sa aktivnostima na kursu.';
$string['footertext1'] = 'Tekstualno polje podnožja jedan';
$string['footertext2'] = 'Tekstualno polje podnožja dva';
$string['footertext3'] = 'Tekstualno polje podnožja tri';
$string['footertext4'] = 'Tekstualno polje podnožja četiri';
$string['footertext_desc'] = 'Unesite HTML tekst i on će se pojaviti na dnu svake stranice. Na raspolaganju su vam četiri polja (stupca) koja koriste  Bootstrap.';
$string['footertextboxes'] = 'Prilagođeno podnožje stranice';
$string['forgotpasstoggle'] = 'Link za zaboravljenu lozinku';
$string['forgotpasstoggle_desc'] = 'Prikazuje/skriva link za zaboravljenu lozinku na prilagođenom obrascu za prijavu na naslovnoj stranici.';
$string['fpcreatortextbox'] = 'Tekstualno polje na naslovnoj stranici za kreatore kurseva';
$string['fpcreatortextbox_desc'] = 'Dodajte sadržaj koji mogu da vide samo korisnici sa ulogom kreatora kursa.';
$string['fpdashboard'] = 'Kontrolni panel naslovne stranice';
$string['fpheaderimagepadding'] = 'Veličina slike zaglavlja na naslovnoj stranici';
$string['fpheaderimagepadding_desc'] = 'Ovo podešavanje kontroliše visinu slike zaglavlja na naslovnoj stranici (odnosno udaljenost obrasca za prijavu od gornje ivice slike), kada korisnik nije prijavljen na sistem.';
$string['fpsearch'] = 'Pretraži kurseve';
$string['fpsearchboxmain'] = 'Prikaži polje za pretragu kurseva u regionu glavnog sadržaja';
$string['fpsearchboxmain_desc'] = 'Prikazuje polje za pretragu kurseva u tekstualnom polju naslovne stranice. Ova opcija zavisi od podešavanja ikonica za navigaciju, tj. polje za pretragu biće prikazano samo ako je podešeno da ikonice za navigaciju budu prikazane u delu stranice sa glavnim sadržajem.';
$string['fpsearchboxtop'] = 'Prikaži polje za pretragu kurseva u navigacionoj traci na vrhu stranice';
$string['fpsearchboxtop_desc'] = 'Prikazuje polje za pretragu kurseva u navigacionoj traci na vrhu naslovne stranice. Polje za pretragu će se pojaviti desno od ikonica za navigaciju na vrhu stranice, i biće prikazano čak i ako su ikonice za navigaciju sakrivene. Ovo polje za pretragu ne zavisi od podešavanja ikonica za navigaciju.';
$string['fpsearchbutton'] = 'Pretraži';
$string['fptextbox'] = 'Tekstualno polje naslovne stranice';
$string['fptextboxdesc'] = 'Ovo tekstualno polje se pojavljuje na naslovnoj stranici i idealno je za postavljanje poruke dobrodošlice.';
$string['fptextboxinfo'] = 'Polje za dobrodošlicu na naslovnoj stranici';
$string['fptextboxinfodesc'] = 'Dodajte poruku dobrodošlice korisnicima.';
$string['fptoppromotedpadding'] = 'Visina slajd-šou prezentacije';
$string['fptoppromotedpadding_desc'] = 'Ovo podešavanje kontroliše visinu slajd-šou prezentacije.';
$string['frontpagecoursesettings'] = 'Kursevi na naslovnoj stranici';
$string['frontpagedesc'] = 'Konfigurišite način na koji će polja kurseva biti prikazana na naslovnoj stranici.';
$string['frontpageheading'] = 'Opcije naslovne stranice';
$string['frontpagerenderer'] = 'Polja kurseva na naslovnoj stranici';
$string['frontpagerendererdefaultimage'] = 'Podrazumevana slika kursa';
$string['frontpagerendererdefaultimagedesc'] = 'Podrazumevana slika kursa koja će se koristiti kada ne postoji slika kursa (primenjivo samo za opciju ”Pločice sa prekrivačem”)';
$string['frontpagerendererdesc'] = 'Ovo podešavanje kontroliše na koji način će biti prikazana polja kurseva na naslovnoj stranici.';
$string['frontpagerendereroption1'] = 'Pločice';
$string['frontpagerendereroption2'] = 'Pločice sa prekrivačem';
$string['frontpagesettingsheading'] = 'Vizualizacija naslovne stranice';
$string['fullfootertext'] = 'Tekstualno polje čitavom širinom podnožja stranice';
$string['fullfootertext_desc'] = 'Ovo je tekstualno polje koje se pruža čitavom širinom podnožja stranice, iznad 4 stupca sa tekstualnim poljima. Ovo polje je idealno ako ne želite da koristite ova 4 stupca.';
$string['gbodyimporturl'] = 'URL adresa za uvoz osnovnog fonta';
$string['gbodyimporturldesc'] = 'OSNOVNI FONT - KORAK 1: pronađite font na google.com/fonts. Pronađite korak koji kaže ”Dodajte ovaj kôd na vaš sajt”.  Prekopirajte taj kôd ovde. Budite sigurni da ste završili KORAK 2.  <a href="https://www.google.com/fonts"> Pronađite Google Font</a>';
$string['geneicsettings'] = 'Opšta podešavanja';
$string['generalalert'] = 'Opšta važna obaveštenja';
$string['generalalertdesc'] = 'Sadržaj koji dodate u ovo polje za tekst biće prikazan u polju ”Opšta važna obaveštenja” na naslovnoj stranici.';
$string['gheadingimporturl'] = 'URL adresa za uvoz fonta naslova';
$string['gheadingimporturldesc'] = 'FONT NASLOVA - KORAK 1: pronađite font na google.com/fonts. Pronađite korak koji kaže ”Dodajte ovaj kôd na vaš sajt”.  Prekopirajte taj kôd ovde. Budite sigurni da ste završili KORAK 2.  <a href="https://www.google.com/fonts"> Pronađite Google Font</a>';
$string['googleheading'] = 'Google fontovi';
$string['gradecomplete'] = 'Kružni indikator ukupne ocene na kursu';
$string['gradecomplete_desc'] = 'Ako je kurs tako podešen da prikazuje ocene polaznicima i ako je ova opcija uključena, onda će oni u gornjem levom uglu stranice, videti indikator svojih postignuća u obliku kruga, zajedno sa procentom ukupne ocene na kursu.';
$string['grades'] = 'Moje ocene';
$string['headerbackgroundimage'] = 'Podrazumevana slika zaglavlja';
$string['headerbackgroundimage_desc'] = 'Ovo je podrazumevana slika zaglavlja.';
$string['headerbackgroundtoggle'] = 'Dozvoli predavačima da postave sliku zaglavlja';
$string['headerbackgroundtoggle_desc'] = 'Ako je opcija uključena predavač može da postavi sliku u <a href="https://docs.moodle.org/29/en/Course_settings#Course_summary_files" target="_new">Datoteke rezimea kursa</a>. Ova slika bi trebalo da bude optimizovana kako bi se skratilo vreme učitavanja. Preporučuje se da slika bude široka 1024 piksela i manja od 500kb. U suprotnom, svi kursevi će koristiti fotografiju koju dole postavite kao sliku zaglavlja.';
$string['headerimageinfo'] = 'Visina slike zaglavlja';
$string['headerimageinfodesc'] = 'Ova podešavanja kontrolišu visinu slike zaglavlja na stranicama sajta, kao i na stranicama aktivnosti unutar kurseva.';
$string['headerimagepadding'] = 'Veličina slike zaglavlja';
$string['headerimagepadding_desc'] = 'Ovo podešavanje kontroliše visinu slike u zaglavlju naslovne stranice kursa. Ukoliko se koriste kružni indikatori za završetak aktivnosti i ukupnu ocenu, onda slika mora biti najmanje 120 piksela visine.';
$string['headerimagepage'] = 'Podešavanje slike zaglavlja';
$string['headerincourseimagepadding'] = 'Veličina slike zaglavlja unutar aktivnosti na kursevima';
$string['headerincourseimagepadding_desc'] = 'Ovo podešavanje kontroliše veličine slike zaglavlja na svim stranicama, osim na naslovnoj stranici  kursa. Što je veličina zaglavlja manja, biće prikazano više sadržaja.';
$string['headingfont'] = 'Porodica fontova naslova';
$string['headingfontdesc'] = 'FONT NASLOVA - KORAK 2: Kopirajte ovde informaciju o porodici Google fonta.';
$string['iconnavbackgroundcolor'] = 'Pozadina ikonica za navigaciju i polja za pretragu na glavnom delu stranice';
$string['iconnavbackgroundcolor_desc'] = 'Ovo je boja pozadine za ikonice za navigaciju i polje za pretragu, koji se nalaze na delu stranice sa glavnim sadržajem.';
$string['iconnavbackgroundcolortop'] = 'Pozadina ikonica za navigaciju i polja za pretragu na vrhu stranice';
$string['iconnavbackgroundcolortop_desc'] = 'Ovo je boja pozadine za ikonice za navigaciju i polje za pretragu, koji se nalaze se nalaze na samom vrhu stranice.';
$string['iconnavheading'] = 'Ikonice za navigaciju';
$string['inmaincontent'] = 'Samo glavni sadržaj';
$string['intopnav'] = 'Samo navigaciona traka na vrhu';
$string['invert'] = 'Invertuj navigacionu traku';
$string['invertdesc'] = 'Ova opcija menja boju teksta i pozadine navigacione trake na vrhu stranice između crne i bele.';
$string['lginforgot'] = 'zaboravili ste lozinku?';
$string['lginlogin'] = 'Prijava';
$string['lginpass'] = 'lozinka';
$string['lginuser'] = 'korisničko ime';
$string['linkcolor'] = 'Boja linkova';
$string['linkcolor_desc'] = 'Boja linkova.';
$string['loginbuttoncolor'] = 'Boja dugmeta za prijavu';
$string['loginbuttoncolor_desc'] = 'Ovo je boja dugmeta na prilagođenom obrascu za prijavu na sistem.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Logo treba da bude veličine 140 sa 140 piksela. Logo se prikazaju u gornjem levom i donjem desnom uglu teme.';
$string['marketboxbuttoncolor'] = 'Boja dugmeta promotivnog bloka';
$string['marketboxbuttoncolor_desc'] = 'Boja pozadine dugmeta promotivnog bloka.';
$string['marketboxcolor'] = 'Boja pozadine promotivnog bloka';
$string['marketboxcolor_desc'] = 'Boja pozadine promotivnog bloka.';
$string['marketboxcontentcolor'] = 'Boja pozadine sadržaja promotivnog bloka';
$string['marketboxcontentcolor_desc'] = 'Boja pozadine sadržaja promotivnog bloka. Ovo se odnosi na onaj deo promotivnog bloka u kojem se pojavljuje tekst i može biti različita od pozadinske boje samog bloka da bi se pažnja skrenula na tekst.';
$string['marketing1'] = 'Promotivni blok jedan';
$string['marketing2'] = 'Promotivni blok dva';
$string['marketing3'] = 'Promotivni blok tri';
$string['marketing4'] = 'Promotivni blok četiri';
$string['marketing5'] = 'Promotivni blok pet';
$string['marketing6'] = 'Promotivni blok šest';
$string['marketingbuttontext'] = 'Tekst linka';
$string['marketingbuttontextdesc'] = 'Tekst koji se pojavljuje na dugmetu';
$string['marketingbuttonurl'] = 'URL adresa linka';
$string['marketingbuttonurldesc'] = 'URL adresa sa kojom je dugme povezano.';
$string['marketingcontent'] = 'Sadržaj';
$string['marketingcontentdesc'] = 'Tekst koji se prikazuje u promotivnom bloku. Treba da bude kratak i zanimljiv.';
$string['marketingdesc'] = 'Ova tema pruža opciju da na naslovnoj stranici postavite tri promotivna bloka ili oglasa, odmah ispod slajd-šou prezentacije. Ovo vam omogućava da svojim korisnicima lako naznačite najbitnije informacije i obezbedite odgovarajuće direktne linkove.';
$string['marketingheading'] = 'Donji promotivni blokovi';
$string['marketingheadingsub'] = 'Tri mesta na naslovnoj stranici sajta za dodatne informacije i linkove';
$string['marketingheadingtextbox'] = 'Gornji okvir za tekst promotivnih blokova';
$string['marketingheadingtop'] = 'Gornji promotivni blokovi';
$string['marketingheight'] = 'Visina slike u promotivnom bloku';
$string['marketingheightdesc'] = 'Ukoliko želite da prikažete slike u promotivnim blokovima ovde možete da navedete njihovu visinu.';
$string['marketingicon'] = 'Ikonica linka';
$string['marketingicondesc'] = 'Naziv ikonice koju želite da koristite za URL dugme u promotivnom bloku. Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza  "fa-",", npr.  "star".';
$string['marketingimage'] = 'Slika';
$string['marketingimage_desc'] = 'Ovo daje mogućnost da se u promotivnom bloku prikaže slika';
$string['marketinginfodesc'] = 'Unesite podešavanja za vaš promotivni blok.';
$string['marketingtitle'] = 'Naslov';
$string['marketingtitledesc'] = 'Naslov koji će biti prikazan u ovom promotivnom bloku';
$string['marketingurltarget'] = 'Odredište linka';
$string['marketingurltargetdesc'] = 'Izaberite kako link treba da bude otvoren';
$string['marketingurltargetnew'] = 'Nova stranica';
$string['marketingurltargetparent'] = 'Nadređeni okvir';
$string['marketingurltargetself'] = 'Tekuća stranica';
$string['mybkg'] = 'Pozadina klizača ”Moji kursevi”';
$string['mybkg_desc'] = 'Izaberite boju za pozadinu klizača  ”Moji kursevi”';
$string['myclasses'] = 'Moji časovi';
$string['mycorusesinfo'] = 'Opcije navigacionog menija';
$string['mycorusesinfodesc'] = 'Ova podešavanja kontrolišu navigacionu traku na vrhu stranice. Ovo uključuje padajuće menije ”Moji kursevi” i ”Ovaj kurs”.';
$string['mycourses'] = 'Moji kursevi';
$string['mycoursesheading'] = 'Klizač ”Moji kursevi”';
$string['mycoursesheadingdesc'] = 'Ovo će prikazati kurseve na koje korisnik upisan kao polaznik odnosno predavač. Kursevi se prikazuju u lepo dizajniranom, prilagodljivom klizaču. Najpogodnije je za prikaz na stonim računarima.';
$string['mycoursesinfo'] = 'Dinamički spisak upisanih kurseva';
$string['mycoursesinfodesc'] = 'Prikazuje korisniku dinamički spisak kurseva koje je upisao.';
$string['mycoursetitle'] = 'Terminologija';
$string['mycoursetitledesc'] = 'Promenite termin za link "Moji kursevi" u padajućem meniju';
$string['mydashboardinfo'] = 'Prilagođeni kontrolni panel korisnika';
$string['mydashboardinfodesc'] = 'Prikazuje spisak zajedničkih funkcija koje koriste korisnici.';
$string['mymodules'] = 'Moji moduli';
$string['myunits'] = 'Moje jedinice';
$string['navbkgcolor'] = 'Pozadina glavne navigacije';
$string['navbkgcolor_desc'] = 'Ovo je boja pozadine za glavnu navigacionu traku';
$string['navcolor'] = 'Boja padajućeg menija navigacione trake';
$string['navcolor_desc'] = 'Boja padajućeg menija u navigacionoj traci';
$string['navcolorhover'] = 'Lebdeća boja padajućeg menija navigacione trake';
$string['navcolorhover_desc'] = 'Boja padajućeg menija u navigacionoj traci kada se mišem pređe preko njega';
$string['navicon'] = 'Ikonica';
$string['navicon1'] = 'Prilagođena ikonica naslovne stranice jedan';
$string['navicon2'] = 'Prilagođena ikonica naslovne stranice dva';
$string['navicon3'] = 'Prilagođena ikonica naslovne stranice tri';
$string['navicon4'] = 'Prilagođena ikonica naslovne stranice četiri';
$string['navicon5'] = 'Prilagođena ikonica naslovne stranice pet';
$string['navicon6'] = 'Prilagođena ikonica naslovne stranice šest';
$string['navicon7'] = 'Prilagođena ikonica naslovne stranice sedam';
$string['navicon8'] = 'Prilagođena ikonica naslovne stranice osam';
$string['naviconbuttontext'] = 'Kratak opis ikonice';
$string['naviconbuttontextdesc'] = 'Tekst koji se pojavljuje u kratkom opisu ikonice kada se mišem pređe preko nje.';
$string['naviconbuttonurl'] = 'URL adresa linka';
$string['naviconbuttonurldesc'] = 'URL adresa sa kojom je dugme povezano. Dugme možete da povežete sa bilo koji veb sajtom, samo unesite ispravnu URL adresu. Ako je vaš Moodle sajt smešten u poddirektorijumu podrazumevana URL adresa neće funkcionisati. Podesite URL adresu tako da ona ukazuje na poddirektorijum. Na primer, ako je naziv vašeg poddirektorijuma "moodle" onda URL adresu treba promeniti u /moodle/my/';
$string['navicondesc'] = 'Naziv ikonice koju želite da koristite. Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza  "fa-",", npr.  "star".';
$string['naviconoff'] = 'Isključi prilagođene navigacione ikonice';
$string['naviconon'] = 'Uključi prilagođene navigacione ikonice';
$string['navigation'] = 'Opcije navigacije';
$string['noenrolments'] = 'Trenutno niste upisani ni na jedan kurs';
$string['pcourseenable'] = 'Omogući istaknute kurseve';
$string['pcourses'] = 'Donji istaknuti kursevi';
$string['pcoursesdesc'] = 'Navedite ID oznake istaknutih kurseva, razdvojene zarezom.';
$string['people'] = 'Kolege';
$string['pluginname'] = 'Pioneer';
$string['promotedcoursesheading'] = 'Donji klizač ”Istaknuti kursevi”';
$string['promotedlink'] = '”Istaknuti kursevi” - URL adresa za link ”Prikaži još kurseva”';
$string['promotedlink_desc'] = 'Unesite URL adresu za jednu od vaših kategorija. Ovo će se prikazati odmah pored naslova ”Istaknuti kursevi”.';
$string['promotedlinktext'] = '”Istaknuti kursevi” - tekst za ”Prikaži još kurseva”';
$string['promotedlinktext_desc'] = 'Ovo pruža mogućnost za povezivanje sa kategorijom kursa kako bi u donjem klizaču ”Istaknuti kursevi” bilo prikazano još kurseva. Unesite URL adresu u donje polje.';
$string['promotedmylink'] = 'Klizač ”Moji kursevi” - URL adresa za link ”Prikaži još kurseva”';
$string['promotedmylink_desc'] = 'Unesite URL adresu za jednu od vaših kategorija. Ovo će se prikazati odmah pored naslova klizača ”Moji kursevi”.';
$string['promotedmylinktext'] = 'Klizač ”Moji kursevi” - tekst za ”Prikaži još kurseva”';
$string['promotedmylinktext_desc'] = 'Ovo pruža mogućnost za povezivanje sa kategorijom kursa kako bi bilo prikazano još kurseva. Unesite URL adresu u donje polje.';
$string['promotedmytextbox'] = 'Tekstualno polje (sa opisom) klizača ”Moji kursevi”';
$string['promotedmytextbox_desc'] = 'Tekstualno polje koje se pojavljuje sa blokom klizača ”Moji kursevi”';
$string['promotedmytitle'] = 'Naslov klizača  ”Moji kursevi”';
$string['promotedmytitledesc'] = 'Molimo, dajte naslov bloku klizača ”Moji kursevi”';
$string['promotedtaglink'] = '”Preporučeni kursevi” - URL adresa za link ”Prikaži još kurseva”';
$string['promotedtaglink_desc'] = 'Unesite URL adresu za jednu od vaših kategorija. Ovo će se prikazati odmah pored naslova ”Istaknuti kursevi”.';
$string['promotedtaglinktext'] = '”Preporučeni kursevi” - tekst za ”Prikaži još kurseva”';
$string['promotedtaglinktext_desc'] = 'Ovo pruža mogućnost za povezivanje sa kategorijom kursa kako bi bilo prikazano još kurseva. Unesite URL adresu u donje polje.';
$string['promotedtagtextbox'] = 'Tekstualno polje (sa opisom) klizača ”Personalizovani kursevi”';
$string['promotedtagtextbox_desc'] = 'Iskoristite ovo polje kako biste korisnicima objasnili kako da dodaju oznake (interesovanja) u svoj profil, kao i kako se dodaju oznake kursa, tako da preporučeni kursevi mogu da se prikažu korisniku.';
$string['promotedtagtitle'] = 'Naslov klizača  ”Personalizovani preporučeni kursevi”';
$string['promotedtagtitledesc'] = 'Molimo, dajte naslov bloku klizača ”Personalizovani preporučeni kursevi”';
$string['promotedtitledefault'] = 'Istaknuti kursevi';
$string['promotedtitledesc'] = 'Molimo vas, dajte naziv bloka ”Preporučeni kursevi”.';
$string['radialboxbackground'] = 'Pozadina kružnih indikatora završetka kursa za završetak aktivnosti i ukupnu ocenu';
$string['radialboxbackground_desc'] = 'Ovo je boja pozadine polja koje sadrži kružne indikatore za završetak aktivnosti i ukupnu ocenu u gornjem levom uglu stranica kursa.';
$string['radialcolor'] = 'Boja kruga indikatora';
$string['radialcolor_desc'] = 'Podesite boju kruga indikatora';
$string['recommendedbkg'] = 'Boja pozadine više klizača';
$string['recommendedbkg_desc'] = 'Ova boja biće primenjena za klizače ”Istaknuti kursevi”, ”Personalizovani preporučeni kursevi” i ”Moji kursevi”. Oni se nalaze na naslovnoj stranici.';
$string['recommendedcoursesheading'] = 'Klizač ”Personalizovani preporučeni kursevi”';
$string['recommendedcoursesheadingdesc'] = 'Klizač ”Personalizovani preporučeni kursevi” sparuje oznake (interesovanja) korisnika iz njihovih profila sa oznakama kurseva. Kada se poklapanja pronađu, rezultujući spisak kurseva biće prikazana u lepo dizajniranom, prilagodljivom klizaču na naslovnoj stranici. Ovo podešavanje je automatsko i nije potrebna nikakva interakcija, osim unošenja oznaka za kurseve i oznaka (interesovanja) u profilima korisnika.';
$string['region-side-post'] = 'Desno';
$string['region-side-pre'] = 'Levo';
$string['rendereroverlaycolor'] = 'Boja prekrivača';
$string['rendereroverlaycolordesc'] = 'Boja prekrivača, kada je izabrana opcija prikaza ”Pločice sa prekrivačem”.';
$string['rendereroverlayfontcolor'] = 'Boja fonta prekrivača';
$string['rendereroverlayfontcolordesc'] = 'Boja fonta kada se mišem pređe preko polja kursa (u situaciji kada je omogućena opcija prikaza ”Pločice sa prekrivačem”).';
$string['secondarybackground'] = 'Sekundarna boja pozadine';
$string['secondarybackground_desc'] = 'Boja pozadine bilo kog sekundarnog sadržaja, kao što su npr. blokovi.';
$string['sectionheadericon'] = 'Ikonica naslova sekcije';
$string['sectionheadericondesc'] = 'Ova ikonica se pojavljuje pre naslova svake teme unutar sedmičnog i tematskog formata kursa. Koristite unicode podešavanja sa Font Awesome sajta. Spisak ikonica možete naći <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_new">ovde</a>. Standardna, f02d ikonica je knjiga.';
$string['settingfeaturedmyslider'] = 'Kursevi na koje sam upisan';
$string['settingfeaturedslider'] = 'Istaknuti kursevi';
$string['settingfeaturedtagslider'] = 'Personalizovani preporučeni kursevi';
$string['settinggradebutton'] = 'Prikaži ocene na kursu';
$string['settingpromotedlink'] = 'http://mymoodlesite/course/';
$string['settingpromotedlinktext'] = '”Istaknuti kursevi” - Prikaži još kurseva';
$string['settingpromotedmylink'] = 'http://mymoodlesite/course/';
$string['settingpromotedmylinktext'] = 'Klizač ”Moji kursevi” - Prikaži još kurseva';
$string['settingpromotedtaglink'] = 'http://mymoodlesite/course/';
$string['settingpromotedtaglinktext'] = '”Preporučeni kursevi” - Prikaži još kurseva';
$string['settingshowtagline'] = 'Upišite se sada';
$string['settingtabbutton'] = 'Početni koraci u Moodleu';
$string['showlogintoggle'] = 'Prikaži obrazac za prijavu';
$string['showlogintoggle_desc'] = 'Prikazuje odnosno sakriva prilagođeni obrazac za prijavi na naslovnoj stranici.';
$string['showmycourses'] = 'Prikaži/sakrij klizač ”Moji kursevi”';
$string['showmycourses_desc'] = 'Isključite ovu opciju ako ne želite da se prikazuje klizač ”Moji kursevi”.';
$string['showrecommendedcourses'] = 'Prikaži/Sakrij personalizovane preporučene kurseve';
$string['showrecommendedcourses_desc'] = 'Isključite ovu opciju ako ne želite da se prikazuju personalizovani preporučeni kursevi.';
$string['signuplogin'] = 'Kreiraj novi nalog';
$string['socialicon1'] = 'Facebook URL adresa';
$string['socialicon2'] = 'Twitter URL adresa';
$string['socialicon3'] = 'Pinterest URL adresa';
$string['socialicon4'] = 'Flickr URL adresa';
$string['socialicon5'] = 'LinkedIn URL adresa';
$string['socialicon6'] = 'YouTube URL adresa';
$string['socialicon7'] = 'Vimeo URL adresa';
$string['socialicon8'] = 'Google Plus URL adresa';
$string['socialiconheading'] = 'Društvene mreže';
$string['socialwallheaddesc'] = 'Format kursa "Društveni zid" je skup dodataka za format kursa za Moodle koji omogućava predavačima da kurs organizuju na takav način da on liči na Facebook. Format kursa "Društveni zid"  možete preuzeti sa sajt Moodle.org <a href="https://moodle.org/plugins/browse.php?list=set&id=74">https://moodle.org/plugins/browse.php?list=set&id=74</a>. Donja podešavanja vam omogućavaju da namenski prilagodite boje društvenog zida.';
$string['socialwallheading'] = 'Opcije za format kursa "Društveni zid"';
$string['stylinginfo'] = 'Formatiranje i važna obaveštenja';
$string['stylinginfodesc'] = 'Dodatne opcije za prilagođavanje teme i podešavanja važnih obaveštenja.';
$string['swaddpost'] = 'Format kursa ”Društveni zid” - pozadina polja ”Dodaj post”';
$string['swaddpost_desc'] = 'Ako koristite format kursa ”Društveni zid” ovo podešavanje će promeniti boju pozadine u delu zida za dodavanje postova.';
$string['swattach'] = 'Format kursa ”Društveni zid” - pozadina polja ”Prilog”';
$string['swattach_desc'] = 'Ako koristite format kursa ”Društveni zid” ovo podešavanje će promeniti boju pozadine u delu zida sa prilozima.';
$string['swcomment'] = 'Format kursa ”Društveni zid” - pozadina polja ”Komentar”';
$string['swcomment_desc'] = 'Ako koristite format kursa ”Društveni zid” ovo podešavanje će promeniti boju pozadine u delu zida sa komentarima.';
$string['swicontext'] = 'Format kursa ”Društveni zid” - boja ikonica i teksta';
$string['swicontext_desc'] = 'Ako koristite format kursa ”Društveni zid” ovo podešavanje će promeniti boje ikonica i reči Prilozi, Postovi, Poruke i Komentari.';
$string['swlabelattachment'] = 'Prilog - CSS oznaka';
$string['swlabelattachment_desc'] = 'Kada postoje prilozi sa postom ova oznaka će označiti priloge.';
$string['swlabelcomment'] = 'Komentar - CSS oznaka';
$string['swlabelcomment_desc'] = 'Ova oznaka označava odeljak sa komentarom za svaki post na vremenskoj liniji.';
$string['swlabelmessage'] = 'Poruka - CSS oznaka';
$string['swlabelmessage_desc'] = 'Ovo oznaka poruke se pojavljuje na vremenskoj liniji, iznad sadržaja posta.';
$string['swlabelpost'] = 'Post - CSS oznaka';
$string['swlabelpost_desc'] = 'Ovo je oznaka koja se pojavljuje na vremenskoj liniji, iznad svakog posta.';
$string['swmessage'] = 'Format kursa ”Društveni zid” - pozadina polja ”Poruka”';
$string['swmessage_desc'] = 'Ako koristite format kursa ”Društveni zid” ovo podešavanje će promeniti boju pozadine u delu zida sa porukama.';
$string['swmultilangcss'] = 'Prevedite oznake na ”Društvenom zidu”';
$string['swmultilangcss_desc'] = 'Ukoliko održavate višejezički sajt, možete da upotrebite ovaj primer kako biste oznake na ”Društvenom zidu” lokalizovali na jezike koje podržavate.';
$string['swpost'] = 'Format kursa ”Društveni zid” - pozadina polja ”Post”';
$string['swpost_desc'] = 'Ako koristite format kursa ”Društveni zid” ovo podešavanje će promeniti boju pozadine u delu zida sa postovima.';
$string['tab1'] = 'Kartica jedan';
$string['tab2'] = 'Kartica dva';
$string['tab3'] = 'Kartica tri';
$string['tab4'] = 'Kartica četiri';
$string['tab5'] = 'Kartica pet';
$string['tab6'] = 'Kartica šest';
$string['tabbutton'] = 'Početak';
$string['tabbuttoncolor'] = 'Boja dugmeta za prikaz kartica';
$string['tabbuttoncolor_desc'] = 'Boja dugmeta koje se koristi kao prekidač za kartice na naslovnoj stranici i kao prekidač za klizač za ocene na kursu. Kada je dugme aktivirano ono se pojavljuje odmah ispod naslova stranice.';
$string['tabbuttonhovercolor'] = 'Boja efekta prelaza preko dugmeta za prikaz kartica';
$string['tabbuttonhovercolor_desc'] = 'Boja prilikom prelaska mišem preko dugmeta koje se koristi kao prekidač za kartice na naslovnoj stranici, i kao prekidač za klizač ocena na kursu. Kada je dugme aktivirano ono se pojavljuje odmah ispod naslova stranice.';
$string['tabbuttontext'] = 'Tekst dugmeta za prikaz kartica';
$string['tabbuttontextdesc'] = 'Ovaj tekst se koristi u dugmetu za prikaz kartica.';
$string['tabcontent'] = 'Sadržaj kartice';
$string['tabcontentdesc'] = 'Tekst i HTML koji ovde unesete biće prikazan kao sadržaj kartice.';
$string['tabheading'] = 'Kartice naslovne stranice';
$string['tabinfodesc'] = 'Dodajte naslov i opis (sadržaj) kartice. Oni će se pojaviti na naslovnoj stranici tek kada je aktiviran klizač. Dugme za aktiviranje klizača se nalazi u zaglavlju vrha stranice.';
$string['tabtitle'] = 'Naslov kartice';
$string['tabtitledesc'] = 'Ovo je naslov kartice koji se pojavljuje na vrhu sadržaja kartice.';
$string['tabtoggle'] = 'Prekidač za prikaz kartica';
$string['tabtoggle_desc'] = 'Prikaži ili sakrij kartice na naslovnoj stranici.';
$string['textcolor'] = 'Boja teksta';
$string['textcolor_desc'] = 'Boja teksta';
$string['themecolorsettings'] = 'Boja teme';
$string['thiscourse'] = 'Ovaj kurs';
$string['title'] = 'Naslov';
$string['togglefptextbox'] = 'Prikaži/sakrij tekstualno polje na naslovnoj stranici';
$string['togglefptextboxdesc'] = 'Izaberite da li želite da sakrijete ili prikažete tekstualno polje na naslovnoj stranici, za odjavljene korisnike.';
$string['toggleiconnav'] = 'Pozicija ikonica za navigaciju';
$string['toggleiconnav_desc'] = 'Odrediti gde želite da se pojave ikonice i polje za pretragu kurseva.';
$string['togglemarketing'] = 'Prekidač za prikaz promotivnih blokova';
$string['togglemarketingdesc'] = 'Izaberite da li želite da sakrijete ili prikažete tri promotivna bloka.';
$string['togglenavicons'] = 'Uključi prilagođene ikonice';
$string['togglenaviconsdesc'] = 'Izaberite ukoliko želite da koristite prilagođene ikonice za navigaciju bazirana na Font-Awesome ikonicama.';
$string['toolsmenu'] = 'Meni alata';
$string['toolsmenudesc'] = 'Možete da konfigurišete linkove u okviru menija Alati. Svaki red se sastoji od teksta stavke u meniju, odgovarajuće URL adrese linka (opciono), kratkog opisa stavke (opciono), kao i oznake jezika ili liste oznaka jezika, odvojenih zarezima, (opciono, za prikaz tog reda isključivo korisnicima navedenog jezika) koji su međusobno odvojeni vertikalnom crtom |. Možete da odredite i strukturu menija koristeći crtice. Na primer:
<pre>
Moodle zajednica|https://moodle.org
-Moodle besplatna podrška|https://moodle.org/support
-Moodle razvoj|https://moodle.org/development
--Moodle dokumentacija|https://docs.moodle.org|Moodle dokumentacija
--Moodle dokumentacija na nemačkom|http://docs.moodle.org/de|Dokumentacija na nemačkom
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenulabel'] = 'Alati';
$string['topclosefeatured'] = 'Link ”Zatvori spisak istaknutih kurseva”';
$string['topclosefeatureddesc'] = 'Ovaj tekst se pojavljuje iznad spiska istaknutih kurseva. Preporučuje se da tekst glasi ”Zatvori spisak kurseva”.';
$string['topclosefeaturedtext'] = 'Zatvori spisak kurseva';
$string['topichighlight'] = 'Boja za isticanje teme';
$string['topichighlight_desc'] = 'Boja koja se koristi za isticanje teme odnosno sedmice unutar kursa.';
$string['topicweekcolor'] = 'Pozadina sekcije u tematskom i sedmičnom formatu kursa';
$string['topicweekcolor_desc'] = 'U tematskom i sedmičnom formatu kursa ovo je boja pozadine za svaku temu, odnosno nedelju, unutar kursa.';
$string['toppcourseenable'] = 'Omogući slajd-šou istaknutih kurseva';
$string['toppcourses'] = 'Slajd-šou istaknutih kurseva';
$string['toppcoursesdesc'] = 'OGRANIČENJE=10 Ne možete uneti više od 10 ID oznaka kurseva. Navedite ID oznake istaknutih kurseva, razdvojene zarezom.';
$string['toppromotedcoursesheading'] = 'Slajd-šou istaknutih kurseva';
$string['toppromotedtitledefault'] = 'Istaknuti kursevi';
$string['toppromotedtitledesc'] = 'Ovaj tekst se pojavljuje ispod naslova kursa u klizaču. ”Upišite se sada” je idealan slogan.';
$string['topsearch'] = 'Pretraži kurseve';
$string['topsearchbutton'] = 'Pronađi';
$string['topshowfeatured'] = 'Link ”Prikaži spisak svih kurseva”';
$string['topshowfeatureddesc'] = 'Ovaj tekst se pojavljuje u slajd-šou prezentaciji i prikazuje spisak svih istaknutih kurseva. Preporučuje se da tekst glasi ”Prikaži sve kurseve”.';
$string['topshowfeaturedtext'] = 'Prikaži sve istaknute kurseve';
$string['toptitle'] = 'Slogan';
