<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'sr_lt', version '4.1'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Pristupačnost';
$string['accessibilitydisabled'] = 'Brickfield komplet alata za pristupačnost nije omogućen na ovom sajtu. Obratite se administratoru sajta da ga omogući.';
$string['accessibilityreport'] = 'Komplet alata za pristupačnost';
$string['accessibilitytool'] = 'Brickfield alat za pristupačnost';
$string['accessibilitytools'] = 'Brickfield alati za pristupačnost';
$string['activate'] = 'Aktiviraj';
$string['activated'] = 'Dodatak je aktiviran i spreman za upotrebu.';
$string['activationform'] = 'Brickfield registracija';
$string['activationheader'] = 'Brickfield aktivacija';
$string['activationinfo'] = '<p>Kako biste koristili ovaj dodatak, morate u ovaj obrazac uneti važeće ključeve za ovaj sajt.</p><p>Molimo vas <a href="{$a}" data-action="send_info" target="_blank">da se registrujete na Brickfield portalu (otvara se u novom prozoru)</a> kako biste dobili te ključeve, ukoliko ih već nemate.</p><p>Kada se aktiviraju, vaši ključevi će biti provereni putem planiranih kron zadataka.</p>';
$string['activityresults:pluginname'] = 'Izveštaj alata za pristupačnost o greškama u aktivnostima';
$string['activityresults:toolname'] = 'Rezime grešaka u aktivnostima';
$string['activityresults:toolshortname'] = 'Greške u aktivnostima';
$string['advanced:pluginname'] = 'Izveštaj naprednog alata za pristupačnost';
$string['advanced:toolname'] = 'Napredni rezime';
$string['advanced:toolshortname'] = 'Napredni';
$string['allcourses'] = 'Svi pregledani kursevi ({$a})';
$string['allcoursescat'] = 'Svi pregledani kursevi za kategoriju {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Po zahtevu';
$string['analysis:disabled'] = 'Onemogućeno';
$string['analysistype'] = 'Omogući zahteve za analizu';
$string['analysistype_desc'] = 'Dozvolite da se može zatražiti analiza pristupačnosti sadržaja';
$string['analysistypedisabled'] = 'Analiza sadržaja je onemogućena';
$string['bannercontentone'] = 'Enterprise Accessibility Toolkit poseduje čitav set funkcija koje mogu pomoći vašoj organizaciji da unapredi pristupačnost vaših kurseva. <a href="{$a}">Kontaktirajte Brickfield Education Labs</a> kako biste rezervisali besplatnu demonstraciju naprednih funkcija.';
$string['bannercontenttwo'] = 'Podignite efikasnu i inkluzivnu platformu za podučavanje i učenje tako što ćete pronaći sadržaj koji nije u skladu sa preporukama, rešiti probleme i pripremiti sadržaj svog Moodle kursa za budućnost pomoću pristupačnih datoteka, editora i poboljšljnih funkcija.';
$string['bannerheadingone'] = 'Nadogradnja na Enterprise Accessibility Toolkit';
$string['batch'] = 'Ograničenje paketa';
$string['brickfield'] = 'Brickfield komplet alata';
$string['brickfield:viewcoursetools'] = 'Pogledajte izveštaje po kursevima';
$string['brickfield:viewsystemtools'] = 'Pogledajte izveštaje za sve kurseve';
$string['bulkprocesscaches'] = 'Obrada masovnog keširanje';
$string['bulkprocesscourses'] = 'Obrada masovnih paketa za proveru pristupačnosti';
$string['buttonone'] = 'Nabavite besplatnu demo verziju';
$string['cachepending'] = 'U toku je kompajliranje zbirnih podataka';
$string['checkdesc:alinksdontopennewwindow'] = 'Linkovi koji se otvaraju u novom prozoru trebalo bi unapred da upozore korisnike.';
$string['checkdesc:amustcontaintext'] = 'Link mora da sadrži tekst da bi bio uočljiv.';
$string['checkdesc:areadontopennewwindow'] = 'Oblasti, koje se koriste u mapama slika, i koje se otvaraju u novom prozoru trebalo bi unapred da upozore korisnike.';
$string['checkdesc:areahasaltvalue'] = 'Oblastima, koje se koriste u mapama slika, ne bi trebalo da nedostaje alt (alternativni) tekst, slično slikama.';
$string['checkdesc:asuspiciouslinktext'] = 'Tekst linka treba da bude deskriptivan i da pruži kontekst o svom odredištu.';
$string['checkdesc:basefontisnotused'] = 'HTML elementi za osnovni font (tj. tag <basefont>), koji se tradicionalno koriste za formatiranje, nisu pristupačni i ne bi trebalo da se koriste.';
$string['checkdesc:blinkisnotused'] = 'Trepćući elementi, koji se pale i gase, nisu pristupačni i ne bi trebalo da se koriste.';
$string['checkdesc:boldisnotused'] = 'HTML elementi za boldovanje (tag <b>) ne bi trebalo da se koriste; umesto toga treba koristiti tag "strong"';
$string['checkdesc:contenttoolong'] = 'Ukupna dužina sadržaja stranice ne bi trebalo da prelazi 500 reči.';
$string['checkdesc:csstexthascontrast'] = 'Kontrast boja između teksta i pozadine je nedovoljan.';
$string['checkdesc:embedhasassociatednoembed'] = 'HTML elementima ugradnje (za ugrađivanje multimedije) (tag <embed>) ne bi trebalo da nedostaju njihovi odgovarajući "noembed" elementi.';
$string['checkdesc:headerh3'] = 'Naslovi koji slede posle naslova sa HTML tagom H3  (opcija velikog naslova u editoru teksta) ne bi trebalo da naruše hijerarhiju naslova stranice.';
$string['checkdesc:headershavetext'] = 'Zaglavlje mora da sadrži tekst da bi bilo uočljivo.';
$string['checkdesc:iisnotused'] = 'HTML elementi za kurziv (tag <i>) ne bi trebalo da se koriste; umesto toga treba koristiti tag ”em”.';
$string['checkdesc:imgaltisdifferent'] = 'Alternativni tekst slike (atribut alt) ne bi trebalo da bude naziv datoteke.';
$string['checkdesc:imgaltistoolong'] = 'Alternativni tekst slike (atribut alt) ne bi trebalo da bude duži od maksimalno dozvoljenih (125) znakova.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Alternativni tekst slike (atribut alt) ne bi trebalo da bude prazan, posebno ako slika ima link koja vodi negde drugde.';
$string['checkdesc:imgaltnotplaceholder'] = 'Alternativni tekst slike (atribut alt) ne bi trebalo da bude jednostavan tekst, poput npr. "slika".';
$string['checkdesc:imghasalt'] = 'Alternativni tekst slike (atribut alt) ne bi trebalo izostaviti osim ako je slika čisto dekorativna bez ikakvog značenja.';
$string['checkdesc:imgwithmaphasusemap'] = 'Mape slika sa oblastima na koje se može kliknuti treba da imaju odgovarajuće elemente "usemap"i "map".';
$string['checkdesc:legendtextnotempty'] = 'HTML elementi za legende (tag <legend>), koji se koriste za označavanje elemenata skupa polja, treba da sadrže tekst.';
$string['checkdesc:marqueeisnotused'] = 'HTML elementi za klizeće tekstove (tag <marquee>), koji se automatski pomeraju, nisu pristupačni i ne bi trebalo da se koriste.';
$string['checkdesc:noheadings'] = 'Bez naslova sadržaj je manje strukturisan i teži za čitanje.';
$string['checkdesc:objectmusthaveembed'] = 'HTML elementi za objekte, za ugrađivanje eksternih resursa (tag <object>), ne bi trebalo da nedostaju njihovi odgovrajući elementi "embed".';
$string['checkdesc:objectmusthavetitle'] = 'HTML elementima za objekte, za ugrađivanje eksternih resursa (tag <object>), ne bi trebalo da nedostaju njihovi odgovarajući opisi atributa "title" .';
$string['checkdesc:objectmusthavevalidtitle'] = 'HTML elementi za objekte, za ugrađivanje eksternih resursa (tag <object>), trebalo bi da imaju odgovarajući atribut "title" sa tekstom.';
$string['checkdesc:strikeisnotused'] = 'HTML elementi za precrtani tekst (tag <s>) ne bi trebalo da se koriste; umesto toga treba koristiti tag "del"';
$string['checkdesc:tabledatashouldhaveth'] = 'U tabelama, idealno, ne bi trebalo da nedostaju zaglavlja.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Rezimei i naslovi tabela ne bi trebalo da budu identični.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Tabele, idealno, ne bi trebalo da imaju spojene ćelije.';
$string['checkdesc:tablethshouldhavescope'] = 'Opsezi redova ili kolona u tabelama (koji se koriste za mapiranje redova i kolona za svaku ćeliju) trebalo bi da budu navedeni.';
$string['checkidvalidation'] = 'Provera da li postoje neispravne ID oznaka provera';
$string['checkscompleted'] = 'Završene provere: {$a}';
$string['checktype'] = 'Proverite grupu';
$string['checktype:form'] = 'Obrazac';
$string['checktype:image'] = 'Slika';
$string['checktype:layout'] = 'Izgled';
$string['checktype:link'] = 'Link';
$string['checktype:media'] = 'Medij';
$string['checktype:table'] = 'Tabela';
$string['checktype:text'] = 'Tekst';
$string['checktyperesults:pluginname'] = 'Izveštaj alata za pristupačnost o tipovima sadržaja';
$string['checktyperesults:toolname'] = 'Rezime tipova sadržaja';
$string['checktyperesults:toolshortname'] = 'Tipovi sadržaja';
$string['cmpercent'] = 'Sveukupni procenat aktivnosti';
$string['cmpercenterrors'] = 'Sveukupni procenat grešaka';
$string['cmpercenttitle'] = 'Ukupna % grešaka u aktivnostima u odnosu na greške';
$string['confirmationmessage'] = 'Za ovaj kurs je zakazana analiza. Analiza će biti završena najranije
za {$a}. Proverite ponovo posle toga.';
$string['contactadmin'] = 'Molimo vas da kontaktirate administratora kako biste dovršili registraciju.';
$string['contactus'] = 'Kontaktirajte nas';
$string['contentfive'] = 'Automatski popravite zastarele HTML oznake.';
$string['contentfour'] = 'Identifikujte koje aktivnosti imaju najviše problema sa pristupačnošću kako biste odredili prioritete.';
$string['contentone'] = 'Automatski evaluirajte sadržaj svog kursa i procene za probleme pristupačnosti.';
$string['contentsix'] = 'Dajte predavačima na vreme savete za kreiranje boljeg sadržaja.';
$string['contentthree'] = 'Obezbedite svojim polaznicima sadržaj u pristupačnim formatima uključujući audio (Audio), elektronsku publikaciju (ePub) i elektronsko Brajevo pismo (Electronic Braille).';
$string['contenttwo'] = 'Masovno ažuriranje je nejasno ili nedostaje tekst za veb linkove, opise slika i titlove video klipova.';
$string['contenttypeerrors'] = 'Ukupni rezultati testova sadržaja aktivnosti po kursu i po tipu sadržaja.';
$string['contentyperesults'] = 'Ukupan broj uspešnih/neuspešnih testova za oblasti sadržaja po kursu.';
$string['contextid'] = 'ID oznaka konteksta';
$string['core_course'] = 'Kurs';
$string['core_question'] = 'Banke pitanja';
$string['count'] = 'Brojanje';
$string['country'] = 'Država';
$string['country_help'] = 'Država sajta';
$string['coursecount'] = 'Broj kurseva';
$string['deletehistoricaldata'] = 'Izbrišite istoriju rezultata provera';
$string['dependency'] = 'Zavisi od';
$string['emptycategory'] = 'Nije pronađen nijedan kurs za kategoriju {$a}';
$string['emptytagcourses'] = 'Nisu pronađeni rezultati za kurseve sa konfigurisanim oznakama';
$string['enableaccessibilitytools'] = 'Omogućite alate za pristupačnost';
$string['enableaccessibilitytools_desc'] = 'Komplet alata za pristupačnost pomaže u identifikovanju problema u vezi sa pristupačnošću na kursevima.';
$string['error:nocoursespecified'] = 'Za skraćeni izveštaj je potreban ispravan ID oznaka kursa. Pristupite kompletu alata za pristupačnost unutar kursa.';
$string['errorlink'] = 'Uredi instancu greške za {$a}';
$string['errors'] = 'Greške: {$a}';
$string['errors:pluginname'] = 'Spisak grešaka alata za pristupačnost';
$string['errors:toolname'] = 'Rezime spiska grešaka';
$string['errors:toolshortname'] = 'Spisak grešaka';
$string['eventanalysis_requested'] = 'Zatražena analiza sadržaja';
$string['eventanalysis_requesteddesc'] = 'Zatražena je analiza sadržaja za kurs {$a}.';
$string['eventreport_downloaded'] = 'Rezime izveštaja o pristupačnosti preuzet';
$string['eventreport_downloadeddesc'] = 'Preuzet je rezime izveštaja o pristupačnosti je preuzet za ID oznaku kursa {$a}.';
$string['eventreport_viewed'] = 'Izveštaj o pristupačnosti prikazan';
$string['eventreport_vieweddesc'] = 'Izveštaj o pristupačnosti je prikazan za kurs sa ID oznakom {$a->course}, kategoriju sa ID oznakom {$a->category}, karticu {$a->tab}.';
$string['failed'] = 'Neuspešno';
$string['failedcount'] = 'Neuspešno: {$a}';
$string['footerheading'] = 'Sekcija podnožja';
$string['fullcachedone'] = 'Onemogućite kako biste ponovo pokrenuli keširanje';
$string['hashcorrect'] = 'Uneti kôd je tačan.';
$string['hashincorrect'] = 'Uneti kôd je netačan.';
$string['headingfive'] = 'HTML ispravke';
$string['headingfour'] = 'Fokusirajte napor - Aktivnosti sa najviše grešaka';
$string['headingone'] = 'Procenite sadržaj';
$string['headingsix'] = 'Podrška za performanse';
$string['headingthree'] = 'Pristupačni formati datoteka';
$string['headingtwo'] = 'Popravka grešaka';
$string['hideshow'] = 'Sakrij/prikaži';
$string['icon:analytics-custom'] = 'Ikonica analitike';
$string['icon:file-edit-custom'] = 'Uredi ikonicu datoteke';
$string['icon:hands-helping-custom'] = 'Ikonica ruku za pomoć';
$string['icon:search-plus-custom'] = 'Ikonica za pretragu';
$string['icon:tools-custom'] = 'Ikonica alata';
$string['icon:wand-magic-custom'] = 'Ikonica čarobnog štapića';
$string['inactive'] = 'Dodatak je neaktivan i ne može se koristiti. Unesite ispravne registracione ključeve i pritisnite "Aktiviraj".';
$string['innercontextid'] = 'ID oznaka unutrašnje konteksta';
$string['installed'] = 'Dodatak je instaliran';
$string['installedcli'] = 'Dodatak je instaliran preko komandne linije';
$string['installeddescription'] = 'Dodatak je instaliran, idite na obrazac za aktivaciju.';
$string['invalidaccessibilitytool'] = 'Zatražen je neispravan poddodatak za pristupačnost.';
$string['invalidcategoryid'] = 'Neispravna kategorija, proverite svoj unos';
$string['invalidcourseid'] = 'Neispravan kurs, proverite svoj unos';
$string['invalidlinkphrases'] = 'click|click here|here|more|more here|info|info here|information|information here|read more|read more here|further information|further information here|further details|further details here';
$string['language'] = 'Jezik';
$string['language_help'] = 'Jezik sajta';
$string['messageprovider:warningcheckid'] = 'Upozorenje o neispravnim ID oznaka provera';
$string['mobileservice'] = 'Omogućeni mobilni servisi ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Naziv';
$string['moreinfo'] = 'Više informacija';
$string['newwindowphrases'] = 'novi prozor | novi-prozor | novi_prozor';
$string['noerrorsfound'] = 'Nisu pronađene uobičajene greške u pristupačnosti za vaše parametre pretrage. Čestitamo!';
$string['norecords'] = 'Nisu pronađeni relevantni zapisi za vaše parametre pretrage.';
$string['notregistered'] = 'Vaš komplet alata za pristupačnost mora biti registrovan.';
$string['notvalidated'] = 'Vaš komplet alata za pristupačnost je funkcionalan dok se proverava njegova ispravnost.';
$string['numcourses'] = 'Broj kurseva ({$a})';
$string['numfactivities'] = 'Broj aktivnosti ({$a})';
$string['numfiles'] = 'Broj datoteka ({$a})';
$string['numinstances'] = 'Broj instanci';
$string['numusers'] = 'Broj korisnika ({$a})';
$string['pagedesc:checktype'] = '<p>Kako bi se sumirali i analizirali rezultate sprovedenih provera, rezultati ovih provera se grupišu u različite tipove sadržaja. Dakle, svi rezultati provere pristupačnosti u vezi sa slikama nalaze se u grupi tipa sadržaja "Slike", svi rezultati provere pristupačnosti u vezi sa izgledom stranice nalaze se u grupi tipa sadržaja "Izgled" i tako dalje.</p><p>Aktivnosti koje su uključene u proveru obuhvataju aktivnosti, resurse ili oblasti sa sadržajem koje se odnose na same kurseve.</p><p>Stranici sa grafikonom tipova sadržaja prikazuje  analizu grešaka po grupama tipova sadržaja: Slike, Izgled, Link, Multimedijalni sadržaj, Tabela i Tekst.</p>';
$string['pagedesc:pertarget'] = '<p>Kako bi se sumirali i analizirali rezultate provere po aktivnosti, rezultati ovih provera se grupišu u različite otkrivene aktivnosti.</p><p>Aktivnosti koje su uključene u proveru obuhvataju aktivnosti, resurse ili druge oblasti sa sadržajem koje se odnose na same kurseve. Svaka aktivnost kod koje nisu otkrivene greške se računa da je prošla proveru (uspešne aktivnosti), dok svaka aktivnost sa jednom ili više otkrivenih grešaka se računa kao da nije prošla proveru (neuspešne aktivnosti). Zatim se prikazuje odnos između aktivnosti bez i aktivnosti sa greškom.</p><p>Stranica sa grafikonom grešaka u aktivnostima prikazuje ukupan odnos uspešnih i neuspešnih instanci, po aktivnosti, kao što su Zadatak, Kurs, Natpis, Lekcija, Test itd.</p>';
$string['pagedesctitle:checktype'] = 'Objašnjeni tipovi sadržaja';
$string['pagedesctitle:pertarget'] = 'Objašnjena grešaka otkrivenih u aktivnostima';
$string['passed'] = 'Prošla proveru';
$string['passedcount'] = 'Prošla proveru: {$a}';
$string['passrate'] = 'Prolaznost: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Broj specifičnih testova i grešaka po proveri po kursu.';
$string['perpage'] = 'Broj stavki za prikaz po stranici';
$string['pluginname'] = 'Komplet alata za pristupačnost';
$string['printable:downloadpdf'] = 'Preuzmi PDF';
$string['printable:pluginname'] = 'Skraćeni izveštaj alata za pristupačnost';
$string['printable:printreport'] = 'Izveštaj za štampanje';
$string['printable:toolname'] = 'Skraćeni izveštaj';
$string['printable:toolshortname'] = 'Skraćeni izveštaj';
$string['privacy:metadata'] = 'Dodatak Izveštaj o proveri pristupačnosti ne čuva nikakve lične podatke.';
$string['processanalysisrequests'] = 'Obrada zahteve za analizu sadržaja';
$string['registernow'] = 'Molimo vas da se registrujete sada.';
$string['registration'] = 'Obrazac za registraciju';
$string['registrationinfo'] = '<p>Ovaj proces registracije vam omogućava da koristite početnu (starter) verziju Brickfield kompleta alata za pristupačnost za svoj registrovani Moodle sajt.</p><p>Ova upotreba podleže <a href="{$a}" target="_blank">Brickfield Education Labs pravilima i uslovima korišćenja (otvara u novom prozoru)</a> sa kojima se slažete samim korišćenjem ovog proizvoda.</p>';
$string['release'] = 'Moodle izdanje ({$a})';
$string['remaining'] = '(preostalo grešaka: {$a})';
$string['response:0'] = 'Ova URL adresa ne vodi nigde';
$string['response:404'] = 'Ova URL stranica nije pronađena';
$string['schedule:blocknotscheduled'] = '<p>Još uvek nije zakazanan analiza ovog kurs, kako bi se pronašli uobičajeni problemi vezani za pristupačnost.</p>';
$string['schedule:notscheduled'] = '<p>Još nije zakazana analiza ovog kursa, kako bi se pronašli uobičajeni problemi vezani za pristupačnost.</p><p>Klikom na dugme "Pošalji na analizu" potvrđujete da želite da sav relevantni HTML sadržaj kursa, kao što su opisi sekcija kursa, opisi aktivnosti, pitanja, stranice, i još mnogo toga, bude poslat na analizu.</p><p>Ova analiza će sprovesti višestruke uobičajene provere pristupačnosti HTML sadržaja vašeg kursa, a rezultati tih provera biće zatim prikazani na ovim stranicama izveštaja alata za pristupačnost. Analiza će biti obrađena u pozadini, prema zakazanim zadacima, tako da će brzina njenog završetka zavisiti od tajminga zadataka i rasporeda njihovog izvršavanja.</p>';
$string['schedule:requestanalysis'] = 'Pošalji na analizu';
$string['schedule:scheduled'] = 'Za ovaj kurs je zakazana analiza.';
$string['schedule:sitenotscheduled'] = '<p>Još nije zakazana analiza globalnog sadržaja (nezavisnog od kursa) kako bi se pronašla uobičajeni problemi vezani za pristupačnost.</p><p>Klikom na dugme "Pošalji na analizu" potvrđujete da želite svoj relevantni globalni sadržaj (nezavisan od kursa) bude poslat na analizu.</p><p>Ova analiza će sprovesti višestruke uobičajene provere pristupačnosti ovog sadržaja, a rezultati tih provera biće zatim prikazani na ovim stranicama izveštaja alata za pristupačnost. Analiza će biti obrađena u pozadini, prema zakazanim zadacima, tako da će brzina njenog završetka zavisiti od tajminga zadataka i rasporeda njihovog izvršavanja.</p>';
$string['schedule:sitescheduled'] = 'Za globalni (nezavisan od kursa) sadržaj zakazana je analiza.';
$string['secretkey'] = 'API ključ';
$string['secretkey_help'] = 'Ovaj kôd se dobija elektronskom poštom nakon registracije.';
$string['sendfollowinginfo'] = '<p>Sledeće informacije će se povremeno slati samo da bi doprinele ukupnoj statistici. Neće biti javno objavljen ni na jednom centralnom spisku.</p> {$a}';
$string['settings'] = 'Podešavanja kompleta alata za pristupačnost';
$string['sitehash'] = 'Tajni ključ';
$string['sitehash_help'] = 'Ovaj kôd se dobija elektronskom poštom nakon registracije.';
$string['taberrors'] = 'Proverite greške';
$string['targetavetitle'] = 'Prosečan broj grešaka po aktivnosti';
$string['targetpercentage'] = 'Procenat uspešnih/neuspešnih instanci po aktivnosti';
$string['targetratio'] = 'Odnos uspešnosti aktivnosti';
$string['tblcheck'] = 'Provera';
$string['tblcheckexample'] = 'Primer';
$string['tblcheckfailed'] = 'Neuspešne provere';
$string['tblchecksummary'] = 'Rezime';
$string['tbledit'] = 'Uredi';
$string['tblerrorcount'] = 'Greške';
$string['tblhtmlcode'] = 'Postojeći HTML kôd';
$string['tblinstance'] = 'Instanca';
$string['tblline'] = 'Red';
$string['tbloverallpercentage'] = 'Sveukupan % grešaka';
$string['tblpercentage'] = 'Procenat';
$string['tblpreview'] = 'Pregled';
$string['tbltarget'] = 'Aktivnost';
$string['tblupdateto'] = 'Ažurirajte na';
$string['titleactivityresultsall'] = 'Rezultati po aktivnosti: svi pregledani kursevi ({$a->count} courses)';
$string['titleactivityresultspartial'] = 'Rezultati po aktivnosti: kurs {$a->name}';
$string['titleall'] = 'Podaci o greškama: svi pregledani kursevi ({$a->count} courses)';
$string['titlechecktyperesultsall'] = 'Rezultati po tipu sadržaja: svi pregledani kursevi ({$a->count} courses)';
$string['titlechecktyperesultspartial'] = 'Rezultati po tipu sadržaja: kurs {$a->name}';
$string['titleerrorsall'] = 'Podaci o greškama: svi pregledani kursevi ({$a->count} courses)';
$string['titleerrorscount'] = 'Podaci o greškama:  (prikazuje se prvih {$a} grešaka)';
$string['titleerrorspartial'] = 'Podaci o greškama: kurs {$a->name}';
$string['titlepartial'] = 'Podaci o greškama: kurs {$a->name}';
$string['titleprintableall'] = 'Kurs {$a->name}';
$string['titleprintablepartial'] = 'Kurs {$a->name}';
$string['tools'] = 'Izveštaji';
$string['toperrors'] = 'Najčešće greške';
$string['toptargets'] = 'Neuspele aktivnosti';
$string['totalactivities'] = 'Ukupno aktivnosti';
$string['totalactivitiescount'] = 'Ukupno aktivnosti: {$a}';
$string['totalareas'] = 'Ukupno oblasti sa sadržajem';
$string['totalerrors'] = 'Ukupno grešaka';
$string['totalgrouperrors'] = 'Ukupno grešaka po tipu aktivnosti';
$string['updatesummarydata'] = 'Ažuriranje rezimea sajta';
$string['usersmobileregistered'] = 'Broj korisnika sa registrovanim mobilnim uređajima ({$a})';
$string['validationerror'] = 'Provera ispravnosti registracionog ključa nije uspela. Proverite da li su URL adresa i ključevi vašeg registrovanog sajta ispravan.';
$string['warningcheckidbody'] = 'Postoji problem sa Brickfield proverom koja je aktivna, ali nije navedena u bazi podataka. Molimo vas da ispitate o čemu se radi.';
$string['warningcheckidsubject'] = 'Brickfield Toolkit checkID upozorenje';
