<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'de', version '4.1'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Alle Kurse durchsuchen';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Sie sind bisher in keinem Kurs eingeschrieben.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Alle verfügbaren Kurse durchsuchen und mit dem Lernen beginnen.';
$string['addon.block_myoverview.noresult'] = 'Ihre Suche passt zu keinem Kurs.';
$string['addon.block_myoverview.noresultdescription'] = 'Versuchen Sie, Ihre Filter einzustellen, oder durchsuchen Sie alle Kurse.';
$string['addon.blog.errorloadentries'] = 'Fehler beim Laden der Blogbeiträge';
$string['addon.blog.showonlyyourentries'] = 'Nur Ihre Beiträge anzeigen';
$string['addon.calendar.calendarevent'] = 'Kalendereintrag';
$string['addon.calendar.calendarevents'] = 'Kalender';
$string['addon.calendar.calendarreminders'] = 'Kalendererinnerungen';
$string['addon.calendar.currentmonth'] = 'Aktueller Monat';
$string['addon.calendar.defaultnotificationtime'] = 'Benachrichtigungszeit';
$string['addon.calendar.errorloadevent'] = 'Fehler beim Laden des Kalendereintrags';
$string['addon.calendar.errorloadevents'] = 'Fehler beim Laden der Kalendereinträge';
$string['addon.calendar.monthlyview'] = 'Monatliche Anzeige';
$string['addon.calendar.noevents'] = 'Keine Kalendereinträge';
$string['addon.calendar.reminders'] = 'Erinnerungen';
$string['addon.calendar.setnewreminder'] = 'Neue Erinnerung erstellen';
$string['addon.competency.errornocompetenciesfound'] = 'Keine Kompetenzen gefunden';
$string['addon.competency.nocompetencies'] = 'Keine Kompetenzen';
$string['addon.coursecompletion.complete'] = 'Abschließen';
$string['addon.coursecompletion.couldnotloadreport'] = 'Fehler beim Laden des Abschlussberichts. Versuchen Sie es später noch einmal.';
$string['addon.enrol_self.confirmselfenrol'] = 'Möchten Sie sich wirklich in diesem Kurs anmelden?';
$string['addon.enrol_self.errorselfenrol'] = 'Fehler bei der Selbsteinschreibung';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Geräte konfigurieren';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Nutzer/innen dieser Website erhalten keine Benachrichtigungen auf ihre mobilen Geräte. Aktivieren Sie die mobilen Benachrichtigungen in den Einstellungen für die Systemnachrichten.';
$string['addon.messages.contactlistempty'] = 'Die Kontaktliste ist leer.';
$string['addon.messages.contactname'] = 'Name';
$string['addon.messages.deletemessage'] = 'Mitteilung löschen';
$string['addon.messages.deletemessageconfirmation'] = 'Möchten Sie die Mitteilung wirklich löschen? Die Mitteilung wird nur in Ihrem Verlauf gelöscht, aber nicht bei der Person, die die Mitteilung gesendet oder empfangen hat.';
$string['addon.messages.errordeletemessage'] = 'Fehler beim Löschen der Mitteilung';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Fehler beim Abrufen der Kontakte vom Server';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Fehler beim Abrufen der Themen vom Server';
$string['addon.messages.errorwhileretrievingmessages'] = 'Fehler beim Abrufen der Mitteilungen vom Server';
$string['addon.messages.errorwhileretrievingusers'] = 'Fehler beim Abrufen der Personen vom Server';
$string['addon.messages.messagenotsent'] = 'Die Mitteilung wurde nicht gesendet. Versuchen Sie es später noch einmal.';
$string['addon.messages.newmessages'] = 'Neue Mitteilungen';
$string['addon.messages.nousersfound'] = 'Keine Personen gefunden';
$string['addon.messages.showdeletemessages'] = 'Mitteilungen löschen anzeigen';
$string['addon.messages.type_blocked'] = 'Gesperrt';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Suchergebnisse';
$string['addon.messages.type_strangers'] = 'Weitere Personen';
$string['addon.messages.useentertosenddescdesktop'] = 'Falls die Option deaktiviert ist, wird eine Mitteilung mit Ctrl+Enter gesendet.';
$string['addon.messages.useentertosenddescmac'] = 'Falls die Option deaktiviert ist, wird eine Mitteilung mit Cmd+Enter gesendet.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Mitteilung zum Thema {{conversation}} konnte nicht gesendet werden. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Mitteilung an {{user}} konnte nicht gesendet werden. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Bestätigen Sie die Erklärung zur Eigenständigkeit.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Die Aufgabendetails und das Abgabeformular sind unter <strong>{{$a}}</strong> verfügbar.';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Für diese Aufgabe werden Abgaben von <strong>{{$a}}</strong> akzeptiert';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Sie können in der App keine Abgabe hinzufügen oder bearbeiten, weil die Erklärung zur Eigenständigkeit nicht von der Website abgerufen werden konnte.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Einige Bewertungsmethoden werden von der App bisher nicht unterstützt und können nicht verändert werden.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Sie können in der App keine Abgabe machen, weil die Erklärung zur Eigenständigkeit nicht von der Website abgerufen werden konnte.';
$string['addon.mod_assign.duedateno'] = 'Kein Fälligkeitsdatum';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Sie können in der App keine Abgabe hinzufügen oder bearbeiten, weil einige Plugins bisher keine Bearbeitung erlauben:';
$string['addon.mod_assign.errorshowinginformation'] = 'Die Abgabeinfos können nicht angezeigt werden.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Dieses Feedback wird von der App nicht unterstützt, so dass Infos fehlen könnten.';
$string['addon.mod_assign.gradenotsynced'] = 'Bewertung nicht synchronisiert';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Teilnehmer/innen, die nichts abgegeben haben, werden nicht angezeigt.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Entwürfe: {{count}}';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Teilnehmer/innen: {{count}}';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Abgaben zur Bewertung: {{count}}';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Abgegebene Aufgaben: {{count}}';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Teams: {{count}}';
$string['addon.mod_assign.submissionnotsupported'] = 'Diese Abgabe wird von der App nicht unterstützt, so dass Infos fehlen könnten.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'Bewertung';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Die Abgabebewertung wurde auf der Website geändert.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Die Abgabe wurde auf der Website geändert.';
$string['addon.mod_chat.confirmloss'] = 'Sind Sie sicher? Der Chat-Verlauf könnte verloren gehen.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Fehler beim Verbinden zum Chat';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Fehler beim Abrufen des Chats';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Fehler beim Anzeigen von Personen im Chat';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Fehler beim Abrufen der Mitteilungen vom Server';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Fehler beim Senden der Mitteilung';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Sie müssen online sein, um Mitteilungen senden zu können.';
$string['addon.mod_chat.nosessionsfound'] = 'Keine Sessions';
$string['addon.mod_chat.showincompletesessions'] = 'Unvollständige Sessions anzeigen';
$string['addon.mod_choice.errorgetchoice'] = 'Fehler beim Laden der Abstimmung';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% haben die Option gewählt: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Ihre letzte Antwort ist in den Ergebnissen noch nicht enthalten. Synchronisieren Sie die Daten.';
$string['addon.mod_data.edittagsnotsupported'] = 'Das Bearbeitung von Tags wird in der App nicht unterstützt.';
$string['addon.mod_data.errorapproving'] = 'Fehler beim Freigeben bzw. Ablehnen des Eintrags';
$string['addon.mod_data.errordeleting'] = 'Fehler beim Löschen des Eintrags';
$string['addon.mod_data.gettinglocation'] = 'Standort bestimmen ...';
$string['addon.mod_data.locationnotenabled'] = 'Standort ist nicht aktiviert';
$string['addon.mod_data.locationpermissiondenied'] = 'Die Berechtigung zum Standortzugriff wurde verweigert.';
$string['addon.mod_data.mylocation'] = 'Mein Standort';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Die Suche nach Tags wird in der App nicht unterstützt.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Ein Feedback mit Captcha kann offline nicht beendet werden. Captcha funktioniert nur, wenn der Server antworten kann.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Abgegebene Antworten: {{count}}';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Das Feedback wurde gespeichert, um es später zu übertragen.';
$string['addon.mod_feedback.questionscountdescription'] = 'Fragen: {{count}}';
$string['addon.mod_folder.emptyfilelist'] = 'Keine Dateien';
$string['addon.mod_forum.errorgetforum'] = 'Fehler beim Laden der Forendaten';
$string['addon.mod_forum.errorgetgroups'] = 'Fehler beim Laden der Gruppeneinstellungen';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum bei dieser Sortierreihenfolge nicht verfügbar';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Ändern Sie die Sortierreihenfolge oder gehen Sie online, um Zugang zu diesem Forum zu erhalten.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Das neue Thema konnte nicht in allen Gruppen angelegt werden.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Keine Themen im Forum';
$string['addon.mod_forum.group'] = 'Gruppe';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} Themen';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} Antworten';
$string['addon.mod_forum.postingroup'] = 'Senden an Gruppe "{{groupname}}"';
$string['addon.mod_forum.refreshposts'] = 'Forenbeiträge aktualisieren';
$string['addon.mod_glossary.browsemode'] = 'Einträge durchblättern';
$string['addon.mod_glossary.byalphabet'] = 'Alphabetisch';
$string['addon.mod_glossary.byauthor'] = 'Nach Autor/in';
$string['addon.mod_glossary.bycategory'] = 'Nach Kategorie';
$string['addon.mod_glossary.bynewestfirst'] = 'Neu zuerst';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Kürzlich aktualisiert';
$string['addon.mod_glossary.bysearch'] = 'Suchen';
$string['addon.mod_glossary.cannoteditentry'] = 'Eintrag nicht bearbeitbar';
$string['addon.mod_glossary.entriestobesynced'] = 'Einträge zum Synchronisieren';
$string['addon.mod_glossary.entrypendingapproval'] = 'Dieser Eintrag wartet auf eine Freigabe.';
$string['addon.mod_glossary.errordeleting'] = 'Fehler beim Löschen des Eintrags';
$string['addon.mod_glossary.errorloadingentries'] = 'Fehler beim Laden der Einträge';
$string['addon.mod_glossary.errorloadingentry'] = 'Fehler beim Laden des Eintrags';
$string['addon.mod_glossary.errorloadingglossary'] = 'Fehler beim Laden des Glossars';
$string['addon.mod_glossary.noentriesfound'] = 'Keine Einträge';
$string['addon.mod_glossary.searchquery'] = 'Suchanfrage';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'H5P-Datei herunterladen';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Fehler beim Laden der H5P-Aktivitätsdaten';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Das H5P-Paket ist nicht heruntergeladen. Sie müssen es zuerst herunterladen, um es nutzen zu können.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Das H5P-Paket wurde seit dem Herunterladen verändert. Du musst es zuerst neu herunterladen, um es nutzen zu können.';
$string['addon.mod_h5pactivity.numberofattempts'] = '{{$a}} Versuche';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Sie müssen online sein, um das H5P-Paket anzeigen zu können.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Versuch {{$a}} anzeigen';
$string['addon.mod_imscp.showmoduledescription'] = 'Beschreibung anzeigen';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Diese Lektion enthält einen Sprung zu einer zufälligen Seite. Die Lektion kann in der App nicht versucht werden, ohne im Webbrowser begonnen worden zu sein.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Dieser Versuch kann nicht mehr angesehen werden, weil ein weiterer Versuch beendet wurde.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Dieser Versuch wurde offline beendet.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Ein Offline-Versuch wurde synchronisiert. Möchten Sie ihn prüfen?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Der Versuch wurde auf der Website beendet.';
$string['addon.mod_lti.errorgetlti'] = 'Fehler beim Laden der Moduldaten';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Die Launch-URL ist ungültig.';
$string['addon.mod_lti.launchactivity'] = 'Aktivität starten';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Fehler beim Laden des Seiteninhalts';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Sie können einen Testversuch in der App beginnen, aber Sie müssen ihn aus folgenden Gründen im Webbrowser abgeben:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Der Test kann aus folgenden Gründen nicht abgegeben werden:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Dieser Versuch wurde seit {{$a}} nicht synchronisiert. Falls Sie inzwischen mit einem anderen Gerät weiter gearbeitet haben, könnten Daten verloren gehen.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Fehler beim Speichern der Antworten. Möchten Sie den Test wirklich verlassen?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Der Test kann nicht in der App durchgeführt werden, weil das Frageverhalten nicht unterstützt wird:';
$string['addon.mod_quiz.errordownloading'] = 'Fehler beim Laden notwendiger Daten';
$string['addon.mod_quiz.errorgetattempt'] = 'Fehler beim Laden der Versuche';
$string['addon.mod_quiz.errorgetquestions'] = 'Fehler beim Laden der Fragen';
$string['addon.mod_quiz.errorgetquiz'] = 'Fehler beim Laden der Testdaten';
$string['addon.mod_quiz.errorparsequestions'] = 'Fehler beim Darstellen der Fragen. Versuchen Sie, diesen Test im Browser zu öffnen.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Dieser Test wird in der App nicht ausgeführt, weil er von der App nicht unterstützte Fragen enthält:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Dieser Test wird in der App nicht ausgeführt, weil er von der App nicht unterstützte Zugriffsregeln enthält:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Fehler beim Speichern des Versuchs';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Ihr Versuch wurde angegeben und gespeichert. Er wird an die Website gesendet, wenn Sie wieder online sind.';
$string['addon.mod_quiz.finishnotsynced'] = 'Fertig, aber nicht synchronisiert';
$string['addon.mod_quiz.opentoc'] = 'Navigationsfeld öffnen';
$string['addon.mod_quiz.warningattemptfinished'] = 'Der Offline-Versuch wurde verworfen, weil er auf der Website beendet wurde oder nicht mehr existiert.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Einige Offline-Antworten wurde verworfen, weil die Fragen online verändert worden sind.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Der Versuch wurde nicht beendet, weil Offline-Antworten verworfen wurden. Überprüfen Sie Ihre Antworten und übermitteln Sie den Versuch noch einmal.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Dieser Test enthält Fragen, die nicht von der App unterstützt werden:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Fehler beim Laden des Inhalts';
$string['addon.mod_resource.openthefile'] = 'Öffnen';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Diese Datei hat sich geändert, seit sie zuletzt geöffnet wurde.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Es gibt eine neuere Version dieser Datei. Verbinden Sie bitte Ihr Gerät mit dem Internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Die Bewertung konnte nicht berechnet werden.';
$string['addon.mod_scorm.dataattemptshown'] = 'Diese Daten gehören zu Versuch {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Fehler beim Hinzufügen eines Offline-Versuchs. Versuchen Sie es noch einmal.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Fehler beim Laden des Lernpakets \'{{name}}\'.';
$string['addon.mod_scorm.errorgetscorm'] = 'Fehler beim Laden von Lernpaketdaten';
$string['addon.mod_scorm.errorinvalidversion'] = 'Die App unterstützt nur Lernpakete mit SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Ihre Schule oder Ihr Lernanbieter haben das Herunterladen von Lernpaketen deaktiviert.';
$string['addon.mod_scorm.errornovalidsco'] = 'Dieses Lernpaket hat kein sichtbares SCO zum Laden.';
$string['addon.mod_scorm.errorpackagefile'] = 'Die App unterstützt ausschließlich ZIP-Pakete.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Fehler beim Synchronisieren. Versuchen Sie es noch einmal.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Dieser Versuch enthält Daten, die noch nicht synchronisiert wurden.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Dieser Versuch kann nicht gesendet werden, weil Sie die maximale Anzahl von Versuchen überschritten haben.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Dieses Lernpaket ist noch nicht heruntergeladen. Es wird automatisch geladen, wenn Sie es öffnen.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Dieses Lernpaket wurde seit dem Herunterladen verändert. Es wird automatisch geladen, wenn Sie es öffnen.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Einige Offline-Daten von Versuch {{number}} wurden gelöscht, weil sie nicht als neuer Versuch gezählt werden können.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Einige Versuche konnten nicht synchronisiert werden, weil der letzte Online-Versuch nicht beendet wurde. Beenden Sie zuerst den Online-Versuch.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Fehler beim Übertragen der Umfragedaten. Versuchen Sie es noch einmal.';
$string['addon.mod_survey.errorgetsurvey'] = 'Fehler beim Laden der Umfragedaten';
$string['addon.mod_survey.results'] = 'Ergebnisse';
$string['addon.mod_url.accessurl'] = 'URL öffnen';
$string['addon.mod_url.pointingtourl'] = 'Verlinkte URL';
$string['addon.mod_wiki.errorloadingpage'] = 'Fehler beim Laden der Seite';
$string['addon.mod_wiki.errornowikiavailable'] = 'Dieses Wiki hat noch keinen Inhalt.';
$string['addon.mod_wiki.gowikihome'] = 'Zur Wiki-Startseite';
$string['addon.mod_wiki.subwiki'] = 'Teilwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Der Titel darf nicht leer sein.';
$string['addon.mod_wiki.viewpage'] = 'Seite anzeigen';
$string['addon.mod_wiki.wikipage'] = 'Wiki-Seite';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Die Beurteilungsstrategie {{$a}} wird nicht unterstützt.';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Sie müssen einen Titel eingeben.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Die Abgabe wurde auf der Website geändert.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Die Beurteilung wurde auf der Website geändert.';
$string['addon.notes.warningnotenotsent'] = 'Die Anmerkungen konnten nicht hinzugefügt oder gelöscht werden. {{error}}';
$string['addon.notifications.allownotifications'] = 'Systemnachichten erlauben';
$string['addon.notifications.errorgetnotifications'] = 'Fehler beim Empfangen von Systemnachrichten';
$string['addon.notifications.notifications'] = 'Systemnachrichten';
$string['addon.notifications.playsound'] = 'Signalton abspielen';
$string['addon.notifications.therearentnotificationsyet'] = 'Keine Systemnachrichten';
$string['addon.notifications.typeofnotification'] = 'Typ der Systemnachricht';
$string['addon.privatefiles.couldnotloadfiles'] = 'Die Dateiliste kann nicht geladen werden.';
$string['addon.privatefiles.emptyfilelist'] = 'Keine Dateien zum Anzeigen';
$string['addon.privatefiles.erroruploadnotworking'] = 'Leider ist es im Moment nicht möglich, Dateien auf Ihre Website hochzuladen.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Alle von der Website heruntergeladenen Daten löschen?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Heruntergeladenen Daten aus allen Kursen löschen?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Alle heruntergeladenen Daten von \'{{name}}\' löschen?';
$string['addon.storagemanager.coursedownloads'] = 'Kursdownloads';
$string['addon.storagemanager.courseinfo'] = 'Laden Sie Kursinhalte herunter, um offline zu arbeiten. Ihre Aktivität wird automatisch synchronisiert, wenn Ihr Gerät wieder online ist.';
$string['addon.storagemanager.deleteallsitedata'] = 'Alle von der Website heruntergeladenen Daten löschen?';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Alle heruntergeladenen Daten von "{{name}}" werden gelöscht, einschließlich aller heruntergeladenen Kurse und Daten, mit denen Sie offline arbeiten können.';
$string['addon.storagemanager.deletecourses'] = 'Heruntergeladenen Daten aus allen Kursen löschen';
$string['addon.storagemanager.deletedata'] = 'Heruntergeladenen Daten löschen';
$string['addon.storagemanager.deletedatafrom'] = 'Alle heruntergeladenen Daten von \'{{name}}\' löschen?';
$string['addon.storagemanager.downloaddatafrom'] = '{{name}} herunterladen';
$string['addon.storagemanager.downloadedcourses'] = 'Heruntergeladene Kurse';
$string['addon.storagemanager.downloads'] = 'Downloads';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Fehler beim Löschen heruntergeladener Daten.';
$string['addon.storagemanager.managedownloads'] = 'Downloads verwalten';
$string['addon.storagemanager.totaldownloads'] = 'Alle Downloads';
$string['addon.storagemanager.totalspaceusage'] = 'Gesamter Speicherverbrauch';
$string['addon.tinymce.enabletinymceeditor'] = 'Texteditor TinyMCE verwenden';
$string['addon.tinymce.enabletinymceeditordescription'] = 'Ein erweiterter Texteditor mit zusätzlichen Formatierungsmöglichkeiten.';
$string['addon.tinymce.license'] = 'Moodle Pty Ltd wurde eine kommerzielle TinyMCE-Lizenz erteilt, die mit der Apache-Lizenz 2.0 kompatibel ist.';
$string['appstoredescription'] = 'Die Moodle App funktioniert mit allen Moodle-Plattformen, die für den mobilen Zugriff freigegeben sind. Wenden Sie sich bei Problemen an die Administrator/innen für Ihr Moodle.

Mit der mobilen App können Sie:
- mit Moodle lernen und arbeiten, egal wo Sie möchten
- einfach auf Kursinhalte zugreifen, auch offline
- Kontakt mit anderen im Moodle aufnehmen
- Mitteilungen zu Terminen und Nachrichten empfangen
- Bilder, Audio, Videos und andere Dateien mit dem mobilen Endgerät hochladen
- persönliche Fortschritte verfolgen, Leistungen und Badges anzeigen
- und noch viel mehr!

Alle Möglichkeiten finden Sie unter https://docs.moodle.org/de/Moodle_App

Über gute Bewertungen und Anregungen zur App würden wir uns sehr freuen.

Die App erfordert folgende Systemrechte:
- Zugriff auf Fotoalbum, Kamera und Audio
- Zugriff auf das Netzwerk, um sich mit Moodle zu verbinden
- Zugriff auf die SD-Karte (Lesen und Schreiben), um Inhalte zu speichern und offline zu nutzen
- Beim Start ausführen, um Systemnachrichten zu empfangen, auch wenn die App im Hintergrund läuft
- Ruhezustand verhindern, um Systemnachrichten jederzeit empfangen zu können';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple-Keynote-Präsentation';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple-Numbers-Tabelle';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple-Pages-Dokument';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive Audio';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive Datei';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive Verzeichnis';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive Video';
$string['core.ajaxendpointnotfound'] = 'AJAX-Endpunkt nicht gefunden. Dies kann passieren, wenn die Moodle-Website zu alt ist oder den Zugriff auf diesen Endpunkt blockiert. Die Moodle-App unterstützt nur Moodle-Systeme ab {{$a}}.';
$string['core.browser'] = 'Browser';
$string['core.calculating'] = 'Berechnen';
$string['core.cannotconnect'] = 'Keine Verbindung zur Website';
$string['core.cannotdownloadfiles'] = 'Ihre Schule oder Ihr Lernanbieter haben das Herunterladen von Dateien deaktiviert.';
$string['core.cannotinstallapk'] = 'Dateien mit der Endung .apk können nicht installiert werden.';
$string['core.cannotinstallapkinfo'] = 'Aus Sicherheitsgründen können Sie mit dieser App keine unbekannten Apps auf Ihrem Endgerät installieren. Wenn Sie trotzdem mit der Installation fortfahren möchten, müssen Sie die Installation in einem Browser öffnen.';
$string['core.cannotlogoutpageblocks'] = 'Speichern oder verwerfen Sie Ihre Änderungen, bevor Sie fortfahren.';
$string['core.cannotopeninapp'] = 'Diese Datei funktioniert auf diesem Gerät möglicherweise nicht. Möchten Sie sie trotzdem öffnen?';
$string['core.cannotopeninappdownload'] = 'Diese Datei funktioniert auf diesem Gerät möglicherweise nicht. Möchten Sie sie trotzdem herunterladen?';
$string['core.captureaudio'] = 'Audio aufnehmen';
$string['core.capturedimage'] = 'Foto aufgenommen';
$string['core.captureimage'] = 'Foto aufnehmen';
$string['core.capturevideo'] = 'Video aufnehmen';
$string['core.certificaterror'] = 'Ihre Endgerät kann dem Zertifikat dieser Website nicht vertrauen: {{details}}';
$string['core.clearsearch'] = 'Suche löschen';
$string['core.clearstoreddata'] = 'Speicher löschen {{$a}}';
$string['core.clicktoseefull'] = 'Tippen, um alle Inhalte anzuzeigen';
$string['core.comments.commentsnotworking'] = 'Kommentare können nicht geladen werden';
$string['core.comments.warningcommentsnotsent'] = 'Kommentare konnten nicht synchronisiert werden. {{error}}';
$string['core.confirmcanceledit'] = 'Möchten Sie diese Seite wirklich verlassen? Alle Änderungen gehen verloren!';
$string['core.confirmleavepagedescription'] = 'Nicht gespeicherte Änderungen gehen verloren.';
$string['core.confirmleavepagetitle'] = 'Seite verlassen?';
$string['core.confirmleaveunknownchanges'] = 'Möchten Sie diese Seite wirklich verlassen? Ungesicherte Änderungen gehen verloren.';
$string['core.confirmloss'] = 'Möchten Sie wirklich alle Änderungen verlieren?';
$string['core.confirmopeninbrowser'] = 'Möchten Sie dies im Webbrowser öffnen?';
$string['core.confirmremoveselectedfile'] = '"{{filename}}" wird dauerhaft gelöscht. Sie können den Vorgang nicht rückgängig machen.';
$string['core.confirmremoveselectedfiles'] = 'Ausgewählte Dateien werden dauerhaft gelöscht. Sie können den Vorgang nicht rückgängig machen.';
$string['core.connectandtryagain'] = 'Verbinden Sie sich mit dem Internet und versuchen Sie es nochmal.';
$string['core.connectionlost'] = 'Verbindung zur Website verloren';
$string['core.contactsupport'] = 'Kontakt zum Support';
$string['core.contactverb'] = 'Kontakt';
$string['core.contenteditingsynced'] = 'Der Inhalt, den Sie gerade bearbeiten, wurde synchronisiert.';
$string['core.contentlinks.chooseaccount'] = 'Nutzerkonto wählen';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Nutzerkonto wählen, mit dem der Link geöffnet werden soll.';
$string['core.contentlinks.confirmurlothersite'] = 'Dieser Link gehört zu einer anderen Website. Möchten Sie den Link öffnen?';
$string['core.contentlinks.errornoactions'] = 'Keine Aktion zu diesem Link gefunden';
$string['core.contentlinks.errornosites'] = 'Keine Website zu diesem Link gefunden';
$string['core.contentlinks.errorredirectothersite'] = 'Die URL-Weiterleitung darf nicht auf eine andere Website zeigen.';
$string['core.copiedtoclipboard'] = 'Text in die Zwischenablage kopiert';
$string['core.copytoclipboard'] = 'In die Zwischenablage kopieren';
$string['core.course.activitydisabled'] = 'Für Ihre Website ist diese Aktivität in der mobilen App deaktiviert.';
$string['core.course.activitynotavailableoffline'] = 'Diese Aktivität ist offline nicht verfügbar';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Für Ihre Website ist ein Plugin installiert, das bisher nicht in der mobilen App unterstützt wird.';
$string['core.course.activityrequiresconnection'] = 'Diese Aktivität ist nur mit einer Internetverbindung verfügbar. Wenn Ihr Endgerät offline ist, können Sie nicht darauf zugreifen.';
$string['core.course.allsections'] = 'Alle Abschnitte';
$string['core.course.aria:sectionprogress'] = 'Abschnittsfortschritt:';
$string['core.course.availablespace'] = 'Sie haben im Moment etwa {{available}} freien Speicher.';
$string['core.course.cannotdeletewhiledownloading'] = 'Dateien können nicht gelöscht werden, während die Aktivität heruntergeladen wird. Warten Sie, bis das Herunterladen beendet ist.';
$string['core.course.changesofflinemaybelost'] = 'Jede Änderung, die Sie in dieser Aktivität vornehmen, während Sie offline sind, kann nicht gespeichert werden.<br><br>Verbinden Sie Ihr Endgerät mit dem Internet, um Ihre Fortschritte nicht zu verlieren.';
$string['core.course.confirmdownload'] = 'Möchten Sie wirklich {{size}} herunterladen? {{availableSpace}}';
$string['core.course.confirmdownloadunknownsize'] = 'Die Datenmenge kann nicht berechnet werden. Möchten Sie wirklich die Daten herunterladen? {{availableSpace}}';
$string['core.course.confirmdownloadzerosize'] = 'Möchten Sie wirklich die Daten herunterladen? {{availableSpace}}';
$string['core.course.confirmlimiteddownload'] = 'Sie sind im Moment nicht über WLAN verbunden.';
$string['core.course.confirmpartialdownloadsize'] = 'Sie sind dabei, <strong>mindestens</strong> {{size}} herunterzuladen. {{availableSpace}} Möchten Sie wirklich weitermachen?';
$string['core.course.couldnotloadsectioncontent'] = 'Die Abschnittsinhalte konnten nicht geladen werden. Versuchen Sie es später noch einmal.';
$string['core.course.couldnotloadsections'] = 'Die Abschnitte konnten nicht geladen werden. Versuchen Sie es später noch einmal.';
$string['core.course.downloadcoursesprogressdescription'] = 'Kurse herunterladen: {{count}} von {{total}}';
$string['core.course.downloadsectionprogressdescription'] = 'Abschnitt herunterladen: {{count}} von {{total}}';
$string['core.course.errordownloadingcourse'] = 'Fehler beim Herunterladen des Kurses';
$string['core.course.errordownloadingsection'] = 'Fehler beim Herunterladen des Abschnitts';
$string['core.course.errorgetmodule'] = 'Fehler beim Laden von Aktivitätsdaten';
$string['core.course.insufficientavailablequota'] = 'Ihr Gerät konnte für das Herunterladen keinen Speicherplatz zuweisen. Möglicherweise ist Speicherplatz für anstehende App- oder Systemupdates reserviert. Sorgen Sie zuerst für ausreichend freien Speicher.';
$string['core.course.insufficientavailablespace'] = 'Sie versuchen, {{size}} herunterzuladen. Ihr Gerät hat danach möglicherweise nicht genügend Platz, um normal zu funktionieren. Sorgen Sie zuerst für ausreichend freien Speicher.';
$string['core.course.lastaccessedactivity'] = 'Zuletzt aufgerufene Aktivität';
$string['core.course.manualcompletionnotsynced'] = 'Manueller Abschluss wurde nicht synchronisiert';
$string['core.course.modulenotfound'] = 'Ressource oder Aktivität nicht gefunden. Stellen Sie sicher, dass Sie online sind und der Inhalt noch verfügbar ist.';
$string['core.course.nextactivity'] = 'Nächste Aktivität';
$string['core.course.nextactivitynotfound'] = 'Nächste Aktivität nicht gefunden. Möglicherweise ist sie verborgen oder gelöscht.';
$string['core.course.nocontentavailable'] = 'Momentan sind keine Inhalte verfügbar';
$string['core.course.previousactivity'] = 'Vorherige Aktivität';
$string['core.course.previousactivitynotfound'] = 'Vorherige Aktivität nicht gefunden. Möglicherweise ist sie verborgen oder gelöscht.';
$string['core.course.refreshcourse'] = 'Kurs aktualisieren';
$string['core.course.useactivityonbrowser'] = 'Sie können dies im Webbrowser verwenden.';
$string['core.course.warningmanualcompletionmodified'] = 'Manueller Abschluss einer Aktivität wurde auf der Website geändert.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Manueller Offline-Abschluss des Kurses \'{{name}}\' wurde gelöscht. {{error}}';
$string['core.coursenogroups'] = 'Sie sind nicht Mitglied einer Gruppe in diesem Kurs.';
$string['core.courses.browserenrolinstructions'] = 'Sie werden zum Browser Ihres Geräts weitergeleitet. Sobald Sie Ihre Registrierung abgeschlossen haben, kehren Sie bitte zur App zurück.';
$string['core.courses.cannotretrievemorecategories'] = 'Kursbereiche tiefer als Level {{$a}} können nicht abgerufen werden.';
$string['core.courses.completeenrolmentbrowser'] = 'Registrierung im Browser abschließen';
$string['core.courses.downloadcourses'] = 'Alle Kurse herunterladen';
$string['core.courses.enrolme'] = 'Selbst einschreiben';
$string['core.courses.errorloadcategories'] = 'Fehler beim Laden von Kursbereichen';
$string['core.courses.errorloadcourses'] = 'Fehler beim Laden von Kursen';
$string['core.courses.errorloadplugins'] = 'Für diesen Kurs notwendige Plugins wurden nicht richtig geladen. Starten Sie die App neu und versuchen Sie es noch einmal.';
$string['core.courses.errorsearching'] = 'Fehler beim Suchen';
$string['core.courses.filtermycourses'] = 'Meine Kurse filtern';
$string['core.courses.notenrollable'] = 'Sie können sich nicht selbst in diesen Kurs einschreiben.';
$string['core.courses.otherenrolments'] = 'Andere Einschreibungen';
$string['core.courses.password'] = 'Einschreibeschlüssel';
$string['core.courses.refreshcourses'] = 'Kurse aktualisieren';
$string['core.courses.searchcoursesadvice'] = 'Sie können Kurse suchen, um als Gast teilzunehmen oder sich selbst einzuschreiben, falls dies erlaubt ist.';
$string['core.courses.showonlyenrolled'] = 'Nur meine Kurse anzeigen';
$string['core.courses.totalcoursesearchresults'] = 'Alle Kurse: {{$a}}';
$string['core.currentdevice'] = 'Aktuelles Gerät';
$string['core.datastoredoffline'] = 'Die Daten sind lokal auf dem Gerät gespeichert, weil sie nicht gesendet werden konnten. Sie werden automatisch später gesendet.';
$string['core.deletedoffline'] = 'Offline gelöscht';
$string['core.deleting'] = 'Löschen ...';
$string['core.desktop'] = 'Schreibtisch';
$string['core.dfdaymonthyear'] = 'DD.MM.YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D. MMM';
$string['core.dffulldate'] = 'dddd, D. MMMM YYYY, HH[:]mm';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'HH[:]mm';
$string['core.discard'] = 'Verwerfen';
$string['core.dismiss'] = 'Abbrechen';
$string['core.dontshowagain'] = 'Nicht nochmal anzeigen';
$string['core.downloaded'] = 'Heruntergeladen';
$string['core.downloading'] = 'Herunterladen ...';
$string['core.editor.hidetoolbar'] = 'Leiste verbergen';
$string['core.editor.toggle'] = 'Editor umschalten';
$string['core.emptysplit'] = 'Das Seitenmenü ist leer oder wird noch geladen ...';
$string['core.endingtime'] = 'Endzeit: {{$a}}';
$string['core.errorchangecompletion'] = 'Fehler beim Ändern des Abschlussstatus. Versuchen Sie es noch einmal.';
$string['core.errorcode'] = 'Fehlercode: {{errorCode}}';
$string['core.errordeletefile'] = 'Fehler beim Löschen der Datei. Versuchen Sie es noch einmal.';
$string['core.errordetailshide'] = 'Fehlerdetails verbergen';
$string['core.errordetailsshow'] = 'Fehlerdetails anzeigen';
$string['core.errordownloading'] = 'Fehler beim Laden der Datei';
$string['core.errordownloadingsomefiles'] = 'Fehler beim Laden der Dateien. Einige Dateien könnten fehlen.';
$string['core.errorfileexistssamename'] = 'Eine Datei mit diesem Namen gibt es bereits.';
$string['core.errorinvalidform'] = 'Prüfen Sie bitte, ob alle erforderlichen Felder ausgefüllt sind und die von Ihnen eingegebenen Daten das richtige Format haben.';
$string['core.errorinvalidresponse'] = 'Ungültige Antwort für den Webservice {{method}}.';
$string['core.errorloadingcontent'] = 'Fehler beim Laden des Inhalts';
$string['core.errorofflinedisabled'] = 'Der Offline-Zugriff ist auf Ihrer Website deaktiviert. Sie müssen online sein, um die App verwenden zu können.';
$string['core.erroropenfiledownloading'] = 'Fehler beim Öffnen der Datei. Warten Sie, bis das Herunterladen abgeschlossen ist.';
$string['core.erroropenfilenoapp'] = 'Fehler: Keine App zum Öffnen dieses Dateityps gefunden.';
$string['core.erroropenfilenoextension'] = 'Fehler beim Öffnen: Die Datei hat keine Endung.';
$string['core.erroropenpopup'] = 'Die Aktivität versucht, ein Popup zu öffnen. Popups werden in der App aber nicht unterstützt.';
$string['core.errorrenamefile'] = 'Fehler beim Ändern des Dateinamens. Versuchen Sie es noch einmal.';
$string['core.errorsitesupport'] = 'Wenn das Problem weiterhin auftritt, wenden Sie sich an den Website-Support.';
$string['core.errorsomedatanotdownloaded'] = 'Beim Herunterladen dieser Aktivität wurden einige Daten aus Gründen der Leistung und Datennutzung nicht geladen.';
$string['core.errorsomethingwrong'] = 'Etwas ist schiefgegangen. Versuchen Sie es noch einmal.';
$string['core.errorsync'] = 'Fehler beim Synchronisieren. Versuchen Sie es noch einmal.';
$string['core.errorsyncblocked'] = '{{$a}} kann wegen eines anderen Vorgangs nicht synchronisiert werden. Versuchen Sie es später noch einmal. Falls das Problem weiterhin besteht, starten Sie die App neu.';
$string['core.errorurlschemeinvalidscheme'] = 'Diese URL soll in einer anderen App verwendet werden: {{$a}}';
$string['core.errorurlschemeinvalidsite'] = 'Diese URL kann in der App nicht geöffnet werden.';
$string['core.exactalarmsturnedoff'] = 'Echtzeitbenachrichtigungen sind deaktiviert.';
$string['core.exactalarmsturnedoffmessage'] = 'Um sicherzustellen, dass Sie keine wichtigen Benachrichtigungen verpassen, aktivieren Sie "Warnungen und Erinnerungen" in den Einstellungen Ihres Endgeräts.';
$string['core.filedeletedsuccessfully'] = 'Sie haben \'{{filename}}\' erfolgreich gelöscht';
$string['core.filenameexist'] = 'Der Dateiname existiert bereits: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Möchten Sie wirklich {{size}} hochladen?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Die Datenmenge kann nicht berechnet werden. Möchten Sie wirklich hochladen?';
$string['core.fileuploader.discardrecording'] = 'Aufnahme verwerfen';
$string['core.fileuploader.errorcapturingaudio'] = 'Fehler bei der Audioaufnahme';
$string['core.fileuploader.errorcapturingimage'] = 'Fehler beim Fotografieren';
$string['core.fileuploader.errorcapturingvideo'] = 'Fehler bei der Videoaufnahme';
$string['core.fileuploader.errorgettingimagealbum'] = 'Fehler beim Laden aus dem Fotoalbum';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Dateien können nur online hochgeladen werden.';
$string['core.fileuploader.errornoapp'] = 'Keine App zum Ausführen dieser Aktion gefunden';
$string['core.fileuploader.errorreadingfile'] = 'Fehler beim Lesen der Datei';
$string['core.fileuploader.errorwhileuploading'] = 'Fehler beim Hochladen der Datei';
$string['core.fileuploader.file'] = 'Datei';
$string['core.fileuploader.fileuploaded'] = 'Datei erfolgreich hochgeladen';
$string['core.fileuploader.maxbytesfile'] = 'Die Datei {{$a.file}} ist zu groß. Die maximale Größe zum Hochladen ist {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Der Zugriff auf das Mikrofon wurde verweigert.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Der Zugriff auf das Mikrofon ist eingeschränkt.';
$string['core.fileuploader.pauserecording'] = 'Aufnahme anhalten';
$string['core.fileuploader.photoalbums'] = 'Fotoalbum';
$string['core.fileuploader.readingfile'] = 'Datei lesen';
$string['core.fileuploader.readingfileperc'] = 'Datei lesen: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Aufnahme fortsetzen';
$string['core.fileuploader.selectafile'] = 'Datei wählen';
$string['core.fileuploader.startrecordinginstructions'] = 'Tippen, um die Aufnahme zu starten';
$string['core.fileuploader.uploadafile'] = 'Datei hochladen';
$string['core.fileuploader.uploading'] = 'Hochladen ...';
$string['core.fileuploader.uploadingperc'] = 'Hochladen: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Zu {{$a}}';
$string['core.h5p.errorgetemail'] = 'Fehler beim Abrufen der E-Mail-Adresse. Überprüfen Sie bitte Ihre Verbindung und versuchen Sie es erneut.';
$string['core.h5p.offlinedisabled'] = 'Die Website erlaubt nicht das Herunterladen von H5P-Paketen.';
$string['core.h5p.play'] = 'H5P abspielen';
$string['core.hasdatatosync'] = 'Die Offline-Daten von {{$a}} müssen synchronisiert werden.';
$string['core.howtoobtaincoordinates'] = 'Sie können Ihre Koordinaten mithilfe einer GPS-App oder einer <a href="{{url}}">Karten-App</a> ermitteln.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Funktioniert dieser Inhalt nicht?';
$string['core.image'] = 'Bild';
$string['core.imageviewer'] = 'Bildanzeige';
$string['core.ioscookieshelp'] = 'Eingebettete Inhalte benötigen möglicherweise Cookies, um zu funktionieren. Aktivieren Sie für diese App die iOS-Einstellung "Cross-Website-Tracking zulassen" und versuchen Sie es noch einmal.';
$string['core.lastdownloaded'] = 'Zuletzt heruntergeladen';
$string['core.lastsync'] = 'Zuletzt synchronisiert';
$string['core.leave'] = 'Verlassen';
$string['core.loadmore'] = 'Mehr laden';
$string['core.locationnolongeravailable'] = 'Die Standortermittlung ist nicht mehr möglich. {{howToObtain}}';
$string['core.login.authenticating'] = 'Authentifizieren ...';
$string['core.login.changepasswordbutton'] = 'Kennwort ändern';
$string['core.login.changepasswordhelp'] = 'Wenn Sie Probleme beim Ändern Ihres Kennworts haben, versuchen Sie es später noch einmal oder wenden Sie sich an Ihre Schule oder Ihren Lernanbieter.';
$string['core.login.changepasswordreconnectinstructions'] = 'Wenn Sie das Kennwort nicht richtig ändern, werden Sie erneut dazu aufgefordert.';
$string['core.login.changepasswordsupportsubject'] = 'Benötige Hilfe zum Ändern meines Kennwort';
$string['core.login.confirmdeletesite'] = 'Möchten Sie das Nutzerkonto für {{sitename}} wirklich aus der Liste entfernen?';
$string['core.login.connect'] = 'Verbinden!';
$string['core.login.connecttomoodle'] = 'Zu Moodle verbinden';
$string['core.login.connecttomoodleapp'] = 'Sie versuchen, sich mit einer Moodle-Website zu verbinden. Verwenden Sie bitte die offizielle Moodle-App.';
$string['core.login.connecttoworkplaceapp'] = 'Sie versuchen, sich mit einer Moodle-Workplace-Website zu verbinden. Verwenden Sie bitte die Moodle-Workplace-App.';
$string['core.login.credentialsdescription'] = 'Geben Sie Ihren Anmeldenamen und das Kennwort ein.';
$string['core.login.credentialshelp'] = 'Wenn Sie Probleme bei der Anmeldung haben, versuchen Sie es später noch einmal oder wenden Sie sich an Ihre Schule oder Ihren Lernanbieter.';
$string['core.login.credentialssupportsubject'] = 'Benötige Hilfe beim Anmelden';
$string['core.login.emailconfirmsentnoemail'] = '<p>Eine E-Mail sollte an Ihre Adresse gesendet worden sein.</p><p>Sie enthält einfache Anweisungen zum Abschließen Ihrer Registrierung.</p>';
$string['core.login.emailnotmatch'] = 'Die E-Mail-Adressen stimmen nicht überein.';
$string['core.login.erroraccesscontrolalloworigin'] = 'Der Cross-Origin-Aufruf wurde zurückgewiesen. weitere Infos: https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'Fehler beim Löschen dieses Nutzerkontos aus der Liste. Versuchen Sie es noch einmal.';
$string['core.login.errorexampleurl'] = 'Die URL https://campus.example.edu ist nur eine Beispiel-URL. <strong>Verwenden Sie die URL für die Website Ihrer Schule oder Ihrer Organisation.</strong>';
$string['core.login.errorqrnoscheme'] = 'Diese URL ist keine gültige URL zum Login.';
$string['core.login.errorupdatesite'] = 'Fehler bei der Authentifizierung';
$string['core.login.exceededloginattempts'] = 'Benötigen Sie Hilfe beim Anmelden? Probieren Sie {{recoverPassword}} oder wenden Sie sich an den Support Ihrer Website.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'Ihr Kennwort wird wiederhergestellt';
$string['core.login.exceededloginattemptssupportsubject'] = 'Ich kann mich nicht anmelden';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Benötigen Sie Hilfe beim Anmelden? Wenden Sie sich an den Support Ihrer Website.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Benötigen Sie Hilfe beim Anmelden? Versuchen Sie {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Anscheinend haben Sie Probleme beim Zugriff auf Ihr Nutzerkonto. Sie können sich an Ihre Schule oder Ihren Lernanbieter wenden oder es später noch einmal versuchen.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Ich kann mein Kennwort nicht zurücksetzen';
$string['core.login.faqcannotfindmysiteanswer'] = 'Wenn Sie Ihre Website über die URL-Adresse suchen und weiterhin nicht finden können, wenden Sie sich bitte an die Person, die sich in Ihrer Schule oder Lernorganisation um Moodle kümmert.';
$string['core.login.faqcannotfindmysitequestion'] = 'Ich kann meine Website nicht über die URL-Adresse finden.';
$string['core.login.faqcantloginanswer'] = '<p>Sobald Sie eine Verbindung zu Ihrem Moodle hergestellt haben, sollten Sie sich mit Ihrem Anmeldenamen und Kennwort anmelden können.</p><br><p>Wenn Sie Ihren Anmeldenamen oder Ihr Kennwort vergessen haben, wählen Sie die Option <strong >Kennwort vergessen?</strong>. Sollten Sie weiterhin Probleme beim Anmelden haben oder keine Optionen zum Abrufen Ihrer Anmeldedaten finden, wenden Sie sich bitte an die Person, die sich in Ihrer Schule oder Lernorganisation um Moodle kümmert.</p>';
$string['core.login.faqcantloginquestion'] = 'Ich kann mich nicht anmelden.';
$string['core.login.faqmore'] = 'Weitere Antworten finden Sie <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank"> in unseren FAQ</a>.';
$string['core.login.faqsetupsiteanswer'] = 'Besuchen Sie {{$link}}, um die verschiedenen Optionen zum Erstellen Ihrer eigenen Moodle-Website zu prüfen.';
$string['core.login.faqsetupsitelinktitle'] = 'Los geht‘s!';
$string['core.login.faqsetupsitequestion'] = 'Ich möchte meine eigene Moodle-Website einrichten';
$string['core.login.faqtestappanswer'] = 'Um die App mit einer Demo-Website zu testen, geben Sie im Feld  <strong>Ihre Website </strong> entweder "teacher" oder "student" ein und tippen Sie auf <strong>Verbinden</strong>.';
$string['core.login.faqtestappquestion'] = 'Kann ich die App mit einer Demo-Website ausprobieren?';
$string['core.login.faqwhatisurlanswer'] = '<p>Wenn Sie Ihre Website nicht über den Namen finden können, versuchen Sie stattdessen die URL-Adresse (oder Webadresse) Ihrer Website zu finden.</p><p>So finden Sie Ihre Website-Adresse:</p><ol>< li>Öffnen Sie einen Webbrowser und rufen Sie die Anmeldeseite Ihrer Website auf.</li><li>Oben im Browser sehen Sie in der Adressleiste die URL-Adresse Ihrer Website, z.B. „campus.example.edu“.<br>{{$image}}</li><li>Kopieren Sie die URL (ohne /login oder was danach kommt), fügen Sie sie bei <strong>Ihre Website</strong> in der App ein und tippen Sie dann auf <strong>Verbinden</strong></li><li>Jetzt können Sie sich mit Ihrem Anmeldenamen und Kennwort bei Ihrer Website anmelden.</li></ol>< p>Wenn Sie versucht haben, nach der URL-Adresse zu suchen und Ihre Website weiterhin nicht finden können, wenden Sie sich bitte an die Person, die sich in Ihrer Schule oder Lernorganisation um Moodle kümmert.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Wie kann ich meiner Website finden?';
$string['core.login.faqwhereisqrcode'] = 'Wo kann ich den QR-Code finden?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Wenn Ihre Schule oder Ihr Lernanbieter dies aktiviert hat, finden Sie den QR-Code auf der Seite mit Ihrem Nutzerprofil.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Website suchen';
$string['core.login.invalidaccount'] = 'Prüfen Sie Ihre Anmeldedaten und versuchen Sie es noch einmal.';
$string['core.login.invalidmoodleversion'] = 'Die Moodle-Version ist zu alt. Die Moodle-App funktioniert nur mit Websites ab {{$a}}.';
$string['core.login.invalidsite'] = 'Die URL der Website ist nicht gültig.';
$string['core.login.invalidtime'] = 'Die Zeit ist nicht gültig.';
$string['core.login.invalidvaluemax'] = 'Der Maximalwert ist {{$a}}.';
$string['core.login.invalidvaluemin'] = 'Der Minimalwert ist {{$a}}.';
$string['core.login.loginbutton'] = 'Anmelden';
$string['core.login.mobileservicesnotenabled'] = 'Die mobilen Webservices sind auf der Website nicht aktiviert.';
$string['core.login.morewaystologin'] = 'Weitere Möglichkeiten zur Anmeldung';
$string['core.login.notloggedin'] = 'Sie müssen angemeldet sein.';
$string['core.login.onboardingcreatemanagecourses'] = 'Ihre Kurse anlegen und verwalten';
$string['core.login.onboardingenrolmanagestudents'] = 'Ihre Teilnehmer/innen einschreiben und verwalten';
$string['core.login.onboardinggetstarted'] = 'Beginnen Sie mit Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Ich habe bereits eine Moodle-Website.';
$string['core.login.onboardingimalearner'] = 'Ich bin ein Lernender.';
$string['core.login.onboardingimaneducator'] = 'Ich bin eine Lehrkraft.';
$string['core.login.onboardingineedasite'] = 'Ich brauche eine Moodle-Website.';
$string['core.login.onboardingprovidefeedback'] = 'Zeitnahes Feedback geben';
$string['core.login.onboardingtoconnect'] = 'Um eine Verbindung zur Moodle-App herzustellen, benötigen Sie eine Moodle-Website';
$string['core.login.onboardingwelcome'] = 'Willkommen in der Moodle-App!';
$string['core.login.or'] = 'Oder';
$string['core.login.passwordrequired'] = 'Kennwort fehlt';
$string['core.login.policyacceptmandatory'] = 'Ich verstehe und stimme den notwendigen Website-Richtlinien zu.';
$string['core.login.recaptchachallengeimage'] = 'reCaptcha Challenge-Bild';
$string['core.login.recaptchaexpired'] = 'Überprüfung abgelaufen. Beantworten Sie die Sicherheitsfrage noch einmal.';
$string['core.login.recaptchaincorrect'] = 'Die Antwort auf die Sicherheitsfrage ist falsch.';
$string['core.login.reconnect'] = 'Neu verbinden';
$string['core.login.reconnecthelp'] = 'Wenn Sie Probleme haben, die Verbindung wiederherzustellen, versuchen Sie es später noch einmal oder wenden Sie sich an Ihre Schule oder Ihren Lernanbieter.';
$string['core.login.reconnectsupportsubject'] = 'Benötigen Sie Hilfe beim Wiederverbinden';
$string['core.login.reconnecttosite'] = 'Neu verbinden zur Website';
$string['core.login.removeaccount'] = 'Nutzerkonto aus der Liste entfernen';
$string['core.login.searchby'] = 'Suche nach:';
$string['core.login.selectsite'] = 'Wählen Sie Ihr Nutzerkonto';
$string['core.login.signupplugindisabled'] = '{{$a}} ist nicht aktiviert.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Das Registrierungsformular enthält ein notwendiges nutzerdefiniertes Feld, das in der App nicht unterstützt wird. Erstellen Sie Ihr Konto bitte im Webbrowser.';
$string['core.login.siteaddress'] = 'Ihre Website';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Ungelesene Benachrichtigungen: {{count}}';
$string['core.login.sitehasredirect'] = 'Ihre Website enthält mindestens eine HTTP-Weiterleitung. Die App kann keine Weiterleitungen verarbeiten und die Verbindung wird nicht aufgebaut.';
$string['core.login.siteinmaintenance'] = 'Diese Website ist im Wartungsmodus.';
$string['core.login.sitenotallowed'] = 'Diese Website ist nicht mehr verfügbar.';
$string['core.login.sitepolicynotagreederror'] = 'Die Zustimmungserklärung wurde nicht bestätigt.';
$string['core.login.siteurl'] = 'URL der Website';
$string['core.login.siteurlrequired'] = 'Die URL der Website ist notwendig, z.B. <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Können Sie sich immer noch nicht verbinden?';
$string['core.login.toggleremove'] = 'Liste der Nutzerkonten bearbeiten';
$string['core.login.unsupportedsite'] = 'Die Website ist über die App nicht zugänglich.';
$string['core.login.unsupportedsitemessage'] = 'Auf {{site}} kann mit dieser App nicht zugegriffen werden. <br><br> Sie können aber weiterhin einen Webbrowser verwenden.';
$string['core.login.usernamerequired'] = 'Anmeldename fehlt';
$string['core.login.visitchangepassword'] = 'Möchten Sie die Website aufrufen, um das Kennwort zu ändern?';
$string['core.login.webservicesnotenabled'] = 'Webservices sind für diese Website nicht aktiviert.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Sie können weiterhin zur Website verbinden, indem Sie Ihren Anmeldenamen und das Kennwort eingeben.';
$string['core.login.yourenteredsite'] = 'Zu Ihrer Website verbinden';
$string['core.lostconnection'] = 'Die Zeit ist abgelaufen. Sie müssen sich neu anmelden.';
$string['core.mainmenu.switchaccount'] = 'Nutzerkonto wechseln';
$string['core.mainmenu.usermenutourdescription'] = 'Der Ort, an dem Sie Ihre Bewertungen anzeigen, Ihre Einstellungen ändern oder das Konto wechseln können.';
$string['core.mainmenu.usermenutourtitle'] = 'Ihren persönlichen Bereich erkunden';
$string['core.needhelp'] = 'Brauchen Sie Hilfe?';
$string['core.needinternettoaccessit'] = 'Sie müssen mit dem Internet verbunden sein, um darauf zugreifen zu können.';
$string['core.networkerroriframemsg'] = 'Dieser Inhalt ist offline nicht verfügbar. Sie müssen online sein und es dann noch einmal versuchen.';
$string['core.networkerrormsg'] = 'Problem mit der Verbindung. Prüfen Sie die Verbindung und versuchen Sie es noch einmal.';
$string['core.nooptionavailable'] = 'Keine Option verfügbar';
$string['core.nopasswordchangeforced'] = 'Sie können nicht weitermachen, ohne Ihr Kennwort zu ändern.';
$string['core.nopermissionerror'] = 'Sie haben aktuell kein Recht, um dies zu tun.';
$string['core.notapplicable'] = 'n/a';
$string['core.notavailablecontentinapp'] = 'Dieser Inhalt ist in der App nicht verfügbar, Sie können ihn jedoch über die folgende Taste in einem Webbrowser öffnen.';
$string['core.notavailableoffline'] = 'Dieser Inhalt ist offline nicht verfügbar. Stellen Sie bitte eine Internetverbindung her und versuchen Sie es nachmal.';
$string['core.notdownloadable'] = 'Nicht herunterladbar';
$string['core.notnow'] = 'Nicht jetzt';
$string['core.notsent'] = 'Nicht gesendet';
$string['core.nummore'] = '{{$a}} mehr';
$string['core.openfile'] = 'Datei öffnen';
$string['core.openfilewithextension'] = 'Datei {{extension}} öffnen';
$string['core.openfullimage'] = 'Tippen, um das Bild zu vergrößern';
$string['core.openinbrowser'] = 'Im Browser öffnen';
$string['core.openinbrowserdescription'] = 'Sie werden weitergeleitet zu einem Webbrowser';
$string['core.openmodinbrowser'] = '{{$a}} im Browser öffnen';
$string['core.opensecurityquestion'] = 'Sicherheitsfrage öffnen';
$string['core.opensettings'] = 'Einstellungen öffnen';
$string['core.openwith'] = 'Öffnen mit ...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Abspielen';
$string['core.policy.havereadandagreepolicy'] = 'Ich habe die Richtlinie "{{policyname}}" gelesen und stimme zu.';
$string['core.policy.nopoliciesyet'] = 'Noch keine Richtlinien und Vereinbarungen.';
$string['core.policy.policyacceptmandatory'] = 'Ich verstehe die verbindlichen Website-Richtlinien und stimme zu.';
$string['core.policy.sitepolicynotagreederror'] = 'Der Website-Richtlinie wurde nicht zugestimmt.';
$string['core.policy.viewpolicy'] = 'Richtlinie {{policyname}} anzeigen.';
$string['core.pulltorefresh'] = 'Zum Aktualisieren runterziehen';
$string['core.qrscanner'] = 'QR-Scanner';
$string['core.question.cannotdeterminestatus'] = 'Status kann nicht festgestellt werden';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Ihre Website unterstützt keine Dateianhänge bei Antworten.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Ihre Website unterstützt nicht das Bearbeiten eingebetteter Dateien.';
$string['core.question.errorquestionnotsupported'] = 'Die App unterstützt nicht diesen Fragetyp: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tippen Sie zum Auswählen und tippen Sie noch einmal zum Ablegen.';
$string['core.question.questionmessage'] = 'Frage {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Sie werden zur Website weitergeleitet.';
$string['core.reminders.atthetime'] = 'Zum Terminzeitpunkt';
$string['core.reminders.custom'] = 'Nutzerdefiniert ...';
$string['core.reminders.customreminder'] = 'Nutzerdefinierte Erinnerung';
$string['core.reminders.delete'] = 'Erinnerung löschen';
$string['core.reminders.reminderset'] = 'Erinnerung gesetzt für {{$a}}';
$string['core.reminders.reminderunset'] = 'Erinnerung gelöscht';
$string['core.reminders.setareminder'] = 'Erinnerung setzen';
$string['core.reminders.setareminderfor'] = 'Erinnerung setzen für "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Erinnerung setzen';
$string['core.reminders.timebefore'] = '{{value}} {{units}} vorher';
$string['core.reminders.value'] = 'Wert';
$string['core.removedownloadeddata'] = 'Heruntergeladene Daten löschen';
$string['core.removefiles'] = 'Dateien entfernen {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Auf diese Ansicht könnten Filter angewendet sein. Um die Filter zu bearbeiten oder die Sortierreihenfolge zu ändern, <a href="{{$a}}">öffnen Sie diesen Bericht im Browser.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Spalten verbergen';
$string['core.reportbuilder.showcolumns'] = 'Spalten anzeigen';
$string['core.requireduserdatamissing'] = 'Im Nutzerprofil fehlen notwendige Einträge. Füllen Sie die Daten in der Website aus und versuchen Sie es noch einmal.<br>{{$a}}';
$string['core.resume'] = 'Zusammenfassung';
$string['core.retry'] = 'Neu versuchen';
$string['core.scanqr'] = 'QR-Code scannen';
$string['core.scrollbackward'] = 'Zurück scrollen';
$string['core.scrollforward'] = 'Vorwärts scrollen';
$string['core.search.allcategories'] = 'Alle Kategorien';
$string['core.search.empty'] = 'Nach was suchen Sie?';
$string['core.search.filtercategories'] = 'Filterergebnisse nach';
$string['core.search.filtercourses'] = 'Suchen in';
$string['core.search.noresults'] = 'Keine Ergebnisse für "{{$a}}"';
$string['core.search.noresultshelp'] = 'Prüfen Sie die Schreibweise oder versuchen Sie andere Schlüsselwörter';
$string['core.search.resultby'] = 'Nach {{$a}}';
$string['core.searching'] = 'Suchen';
$string['core.serverconnection'] = 'Fehler beim Verbinden zum Server: {{details}}';
$string['core.settings.about'] = 'Über die App';
$string['core.settings.appsettings'] = 'Einstellungen der App';
$string['core.settings.appversion'] = 'Version';
$string['core.settings.cannotsyncloggedout'] = 'Die Website kann nicht synchronisiert werden. Versuchen Sie es noch einmal, wenn Sie eingeloggt sind.';
$string['core.settings.cannotsyncoffline'] = 'Synchronisieren der Website ist fehlgeschlagen, weil Ihr Gerät nicht mit dem Internet verbunden ist.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Ihr Gerät ist nicht mit WLAN verbunden. Verbinden Sie ein WLAN oder schalten Sie die Datensparsamkeit in den App-Einstellungen aus.';
$string['core.settings.changelanguage'] = 'Zu {{$a}} wechseln';
$string['core.settings.changelanguagealert'] = 'Eine Sprachänderung startet die App neu.';
$string['core.settings.colorscheme'] = 'Farbschema';
$string['core.settings.colorscheme-dark'] = 'Dunkel';
$string['core.settings.colorscheme-light'] = 'Hell';
$string['core.settings.colorscheme-system'] = 'Systemvoreinstellung';
$string['core.settings.colorscheme-system-notice'] = 'Der Modus "Systemvoreinstellung" ist von den Optionen Ihres Endgeräts abhängig.';
$string['core.settings.compilationinfo'] = 'Compilation';
$string['core.settings.connecttosync'] = 'Ihr Gerät ist offline. Verbinden Sie es mit dem Internet, um Websites zu synchronisieren.';
$string['core.settings.connectwifitosync'] = 'Verbinden Sie ein WLAN oder schalten Sie die Datensparsamkeit aus, um Websites zu synchronisieren.';
$string['core.settings.copyinfo'] = 'Device-Info in die Zwischenablage kopieren';
$string['core.settings.cordovadevicemodel'] = 'Cordova Device Model';
$string['core.settings.cordovadeviceosversion'] = 'Cordova Device OS Version';
$string['core.settings.cordovadeviceplatform'] = 'Cordova Device Platform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova Device UUID';
$string['core.settings.cordovaversion'] = 'Cordova Version';
$string['core.settings.debugdisplaydescription'] = 'Wenn diese Option aktiviert ist, werden zusätzliche Fehlerdaten angezeigt.';
$string['core.settings.developeroptions'] = 'Entwickleroptionen';
$string['core.settings.deviceinfo'] = 'Geräteinformationen';
$string['core.settings.deviceos'] = 'Geräte-OS';
$string['core.settings.displayformat'] = 'Bildschirm';
$string['core.settings.enableanalytics'] = 'Analytics aktivieren';
$string['core.settings.enableanalyticsdescription'] = 'Wenn diese Option aktiviert ist, sammelt die App anonyme Daten.';
$string['core.settings.enabledownloadsection'] = 'Abschnitte herunterladen';
$string['core.settings.enablepinchtozoom'] = 'Pinch-to-Zoom aktivieren';
$string['core.settings.enablerichtexteditor'] = 'Texteditor aktivieren';
$string['core.settings.enablerichtexteditordescription'] = 'Der Texteditor ist verfügbar, wenn Texte eingegeben werden sollen.';
$string['core.settings.encryptedpushsupported'] = 'Verschlüsselte Push-Nachrichten werden unterstützt';
$string['core.settings.entriesincache'] = '{{$a}} Einträge im Cache';
$string['core.settings.estimatedfreespace'] = 'Verfügbarer Speicher';
$string['core.settings.filesystemroot'] = 'Dateisystembasis';
$string['core.settings.fontsize'] = 'Schriftgröße';
$string['core.settings.forcedsetting'] = 'Diese Einstellung wird durch die Website-Konfiguration erzwungen.';
$string['core.settings.helpusimprove'] = 'Helfen Sie uns, diese App zu verbessern.';
$string['core.settings.ioscookies'] = 'Cross-Website-Tracking';
$string['core.settings.ioscookiesdescription'] = 'Eingebettete Inhalte dieser Website erfordern möglicherweise Cross-Website-Cookies. Aktivieren Sie bitte für diese App die iOS-Einstellung "Cross-Website-Tracking zulassen" und versuchen Sie es noch einmal.';
$string['core.settings.legaldisclaimer'] = 'Rechtlicher Hinweis';
$string['core.settings.localnotifavailable'] = 'Lokale Systemnachrichten verfügbar';
$string['core.settings.locationhref'] = 'Webview URL';
$string['core.settings.logintosync'] = 'Melden Sie sich zum Synchronisieren an';
$string['core.settings.navigatorlanguage'] = 'Browsersprache';
$string['core.settings.navigatoruseragent'] = 'Browserkennung (userAgent)';
$string['core.settings.networkstatus'] = 'Internetverbindung';
$string['core.settings.opensourcelicenses'] = 'Open Source Lizenzen';
$string['core.settings.privacypolicy'] = 'Datenschutzerklärung';
$string['core.settings.publisher'] = 'Herausgeber/in';
$string['core.settings.pushid'] = 'ID für Push-Nachrichten';
$string['core.settings.reportinbackground'] = 'Fehler automatisch senden';
$string['core.settings.screen'] = 'Bildschirmgröße';
$string['core.settings.showdownloadoptions'] = 'Optionen zum Herunterladen anzeigen';
$string['core.settings.siteinfo'] = 'Website';
$string['core.settings.sitesynccompleted'] = 'Website-Synchronisierung abgeschlossen.';
$string['core.settings.sitesyncfailed'] = 'Synchronisieren der Website fehlgeschlagen';
$string['core.settings.spaceusage'] = 'Speichernutzung';
$string['core.settings.syncdatasaver'] = 'Datensparsamkeit - Synchronisieren nur im WLAN';
$string['core.settings.synchronization'] = 'Synchronisieren';
$string['core.settings.synchronizenow'] = 'Synchronisieren';
$string['core.settings.synchronizenowhelp'] = 'Beim Synchronisieren werden ausstehende Änderungen und alle im Gerät speicherten Offline-Aktivitäten mit der Website ausgetauscht. Mitteilungen und Systemnachrichten werden übertragen.';
$string['core.settings.syncsettings'] = 'Synchronisieren';
$string['core.settings.wificonnection'] = 'WLAN-Verbindung';
$string['core.settings.youradev'] = 'Sie sind jetzt ein Entwickler';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Wählen Sie ein Nutzerkonto, um die Datei dort zu speichern.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Eine Datei mit gleichem Namen existiert bereits. Möchten Sie die vorhandene Datei ersetzen oder umbenennen in \'{{$a}}\'?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Keine gespeicherten Websites. Fügen Sie zuerst eine Website hinzu, bevor Sie eine Datei mit der App teilen.';
$string['core.sharedfiles.nosharedfiles'] = 'Keine geteilten Dateien für diese Website';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Sie haben hier keine Dateien zum Hochladen. Wenn Sie eine Datei aus einer anderen App hochladen möchten, suchen Sie diese Datei und tippen Sie auf die Taste \'Öffnen in\'.';
$string['core.sharedfiles.rename'] = 'Umbenennen';
$string['core.sharedfiles.replace'] = 'Ersetzen';
$string['core.sharedfiles.sharedfiles'] = 'Geteilte Dateien';
$string['core.sharedfiles.successstorefile'] = 'Die Datei wurde erfolgreich gespeichert. Sie können die Datei in \'Meine Dateien\' hochladen oder in einer Aktivität verwenden.';
$string['core.sitenotfoundhelp'] = 'Die eingegebene Website kann nicht gefunden werden. Prüfen Sie die Tippfehler oder versuchen Sie es später erneut. Wenn Sie diese Meldung weiterhin sehen, wenden Sie sich an Ihre Schule oder Ihren Lernanbieter.';
$string['core.siteunavailablehelp'] = 'Die Website "{{site}}" ist derzeit nicht verfügbar. Versuchen Sie es später noch einmal oder wenden Sie sich an Ihre Schule oder Ihren Lernanbieter.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Sorry ...';
$string['core.start'] = 'Start';
$string['core.startingtime'] = 'Startzeit: {{$a}}';
$string['core.storingfiles'] = 'Dateien speichern';
$string['core.submittedoffline'] = 'Abgegeben (Offline)';
$string['core.swipenavigationtourdescription'] = 'Zum Navigieren nach links und rechts wischen';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Dieser Tag-Bereich wird von der App nicht unterstützt.';
$string['core.tag.tagareabadgedescription'] = 'Elemente: {{count}}';
$string['core.tag.warningareasnotsupported'] = 'Einige der Tag-Bereiche werden nicht angezeigt, weil sie von der App nicht unterstützt werden.';
$string['core.thereisdatatosync'] = 'Die Offline-Daten {{$a}} müssen synchronisiert werden.';
$string['core.toggledelete'] = 'Löschtasten umschalten';
$string['core.tryagain'] = 'Versuchen Sie es noch einmal.';
$string['core.turnon'] = 'Einschalten';
$string['core.turnonexactalarms'] = 'Echtzeitwarnungen aktivieren';
$string['core.turnonnotifications'] = 'Benachrichtigungen einschalten';
$string['core.turnonnotificationsmessage'] = 'Möchten Sie Benachrichtigungen zu Aktivitäten und Aufgaben erhalten?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh oh!';
$string['core.unexpectederror'] = 'Unerwarteter Fehler! Sie müssen die App neu starten und es dann noch einmal versuchen.';
$string['core.unicodenotsupported'] = 'Manche Emojis können auf dieser Website nicht verwendet werden. Die betreffenden Zeichen werden beim Senden der Mitteilung gelöscht.';
$string['core.unicodenotsupportedcleanerror'] = 'Der Text ist leer, nachdem die Unicode-Zeichen gelöscht wurden.';
$string['core.unknown'] = 'Unbekannt';
$string['core.unzipping'] = 'Entpacken ...';
$string['core.updaterequired'] = 'Aktualisierung der App notwendig';
$string['core.updaterequireddesc'] = 'Aktualisieren Sie Ihre App auf die Version {{$a}}';
$string['core.user.completeprofile'] = 'Profil vervollständigen';
$string['core.user.completeprofilehelp'] = 'Wenn Sie Probleme beim Ausfüllen Ihres Profils haben, versuchen Sie es später erneut oder wenden Sie sich an Ihre Schule oder Ihren Lernanbieter.';
$string['core.user.completeprofilenotice'] = 'Bevor Sie weitermachen, müssen Sie alle notwendigen Felder in Ihrem Nutzerprofil ausfüllen.';
$string['core.user.completeprofilereconnectinstructions'] = 'Wenn Sie Ihr Nutzerprofil nicht vollständig ausfüllen, werden Sie weiterhin dazu aufgefordert.';
$string['core.user.completeprofilesupportsubject'] = 'Benötige Hilfe beim Vervollständigen meines Profils';
$string['core.user.completeyourprofile'] = 'Ihr Profil vervollständigen';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Die Nutzerdetails zu dieser Person sind für Sie nicht verfügbar.';
$string['core.user.errorloaduser'] = 'Fehler beim Laden der Nutzerdetails';
$string['core.user.sendemail'] = 'E-Mail';
$string['core.user.support'] = 'Kontakt zum Support der Website';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Nutzer/in {{id}}';
$string['core.usernologin'] = 'Für dieses Nutzerkonto wurde die Authentifizierung widerrufen.';
$string['core.viewcode'] = 'Code zeigen';
$string['core.vieweditor'] = 'Editor zeigen';
$string['core.viewembeddedcontent'] = 'Eingebettete Inhalte anzeigen';
$string['core.viewer.decreasetextsize'] = 'Textgröße verringern';
$string['core.viewer.enterreadingmode'] = 'In den Lesemodus wechseln';
$string['core.viewer.exitreadingmode'] = 'Den Lesemodus verlassen';
$string['core.viewer.increasetextsize'] = 'Textgröße vergrößern';
$string['core.viewer.openreadingmodesettings'] = 'Einstellungen für Lesemodus öffnen';
$string['core.viewer.readingthemeauto'] = 'App anpassen';
$string['core.viewer.readingthemedark'] = 'Dunkel';
$string['core.viewer.readingthemehcm'] = 'Hoher Kontrast';
$string['core.viewer.readingthemelight'] = 'Hell';
$string['core.viewer.readingthemesepia'] = 'Sepia';
$string['core.wanttochangesite'] = 'Möchten Sie die Website wechseln oder sich abmelden?';
$string['core.warningofflinedatadeleted'] = 'Die Offline-Änderungen an {{component}} \'{{name}}\' wurden verworfen. {{Fehler}}';
$string['core.warningofflinedatadeletedreason'] = 'Neuere Änderungen an dieser Aktivität wurden von einem anderen Gerät aus vorgenommen.';
$string['core.warnopeninbrowser'] = '<p>Sie verlassen die App, wenn Sie die folgende URL im Browser Ihres Geräts öffnen. Möchten Sie fortfahren?</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'Warum passiert das?';
$string['core.wsfunctionnotavailable'] = 'Die Webservice-Funktion ist nicht verfügbar.';
$string['core.youreoffline'] = 'Das Gerät ist offline.';
$string['core.youreonline'] = 'Das Gerät ist wieder online.';
$string['core.zoomin'] = 'Hineinzoomen';
$string['core.zoomout'] = 'Herauszoomen';
$string['freemium.biometriclogin'] = 'Biometrisches Anmelden';
$string['freemium.biometriclogindescription'] = 'Legen Sie Ihren Finger auf den Fingerabdruckleser.';
$string['freemium.biometricloginenablefaceid'] = 'FaceID aktivieren';
$string['freemium.biometricloginenablefingerprint'] = 'Fingerabdruck aktivieren';
$string['freemium.biometricloginenabletouchid'] = 'TouchID aktivieren';
$string['freemium.biometricloginloginwithfaceid'] = 'Anmelden per FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Anmelden per Fingerabdruck';
$string['freemium.biometricloginloginwithtouchid'] = 'Anmelden per TouchID';
$string['freemium.biometricloginskip'] = 'Jetzt überspringen';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} aktiviert';
$string['freemium.biometricloginturnoff'] = 'Sie können diese Funktion jederzeit in den Einstellungen ein- und ausschalten.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Fingerabdruck';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Nutzen Sie die biometrische Anmeldung mit Ihrem Fingerabdruck oder Ihrem Gesicht.';
$string['freemium.change'] = 'Wechseln';
$string['freemium.coursesbatchdownloaddisabled'] = 'Herunterladen von Kursen im Stapel ist für diese Website nicht aktiviert.';
$string['freemium.coursesdownloadlimitreached'] = 'Das Limit zum Herunterladen von Kursen wurde erreicht! Sie können nur {{limit}} Kurse herunterladen. Wenden Sie sich an Ihre Administrator/innen, um dieses Limit zu erhöhen. Alternativ müssen Sie andere heruntergeladene Kurse von Ihrem Gerät entfernen.';
$string['freemium.downloadmainapplicationrequired'] = 'Mit dieser Website können Sie sich nur über eine spezielle App verbinden.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Die Website, mit der Sie sich verbinden möchten, verwendet eine spezielle App, die Sie dann verwenden sollten.';
$string['freemium.feature_biometriclogin'] = 'Biometrisches Anmelden';
$string['freemium.feature_coursesdownload'] = 'Heruntergeladene Kurse';
$string['freemium.feature_multimediapushnotifications'] = 'Multimedia-Push-Nachrichten';
$string['freemium.feature_pushnotificationsdevices'] = 'Geräte mit Push-Nachrichten';
$string['freemium.feature_qrlogin'] = 'Mit QR-Code authentifizieren';
$string['freemium.feature_remotethemes'] = 'Nachgeladenes Design';
$string['freemium.feature_sitelogo'] = 'Website-Logo';
$string['freemium.notallowed'] = 'Nicht erlaubt';
$string['freemium.nottoday'] = 'Nicht heute';
$string['freemium.qrlogindisabled'] = 'Die Authentifizierung mit einem QR-Code ist für die Website nicht aktiviert:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'Der QR-Code ist abgelaufen. Aktualisieren Sie bitte die Seite mit dem QR-Code und scannen Sie ihn erneut.';
$string['freemium.qrloginipmismatch'] = 'Das Gerät, mit dem Sie gerade die Verbindung herstellen, scheint in einem anderen Netzwerk zu sein als das Gerät, das den QR-Code anzeigt. Stellen Sie bitte sicher, dass beide Geräte mit gleichen Netzwerk sind (z.B. im gleichen WLAN).<br><br>Wenn der Fehler weiterhin besteht, wenden Sie sich bitte an die Administrator/innen.';
$string['freemium.ratetheapp'] = 'Gefällt Ihnen unsere App?';
$string['freemium.ratetheapp_feedbackko'] = 'Schreiben Sie uns, was falsch läuft';
$string['freemium.ratetheapp_feedbackmessage'] = 'Ihr Feedback ist anonym.';
$string['freemium.ratetheapp_feedbackok'] = 'Feedback senden';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Schreiben Sie hier etwas';
$string['freemium.ratetheapp_feedbacksent'] = 'Danke. Ihr Feedback wurde erfolgreich gesendet.';
$string['freemium.ratetheapp_sendtostore'] = 'Nehmen Sie sich bitte einen Moment Zeit, um unsere App zu bewerten? Sie helfen uns, die App zu verbessern.';
$string['freemium.remindmelater'] = 'Erinnern Sie mich später';
$string['freemium.settingsoptionsfacial'] = 'Anmelden per Gesicht aktivieren';
$string['freemium.settingsoptionsfingerprint'] = 'Anmelden per Fingerabdruck aktivieren';
$string['freemium.subscription'] = 'Website-Abonnement';
$string['freemium.subscriptiondetails'] = 'Abonnementdetails';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{overflowCount}} nutzerdefinierte Texte werden ignoriert.';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{overflowCount}} nutzerdefinierte Menüelemente werden ignoriert.';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{overflowCount}} konfigurierte deaktivierte Funktionen sind weiterhin aktiviert.';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Ihr angepasstes Design wird nicht verwendet.';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Ihr Website-Logo wird nicht verwendet.';
$string['freemium.subscriptionfeature_limited'] = 'Begrenzt bis {{limit}}';
$string['freemium.subscriptionfeature_unlimited'] = 'Unbegrenzt';
$string['freemium.subscriptionplan'] = 'Abonnementplan';
$string['freemium.subscriptionplan_expired'] = 'abgelaufen';
$string['freemium.subscriptionplan_free'] = 'Free';
$string['freemium.subscriptionplan_upgrade'] = 'Erweitern Sie Ihren Plan';
$string['freemium.subscriptionplan_validuntil'] = 'gültig bis {{date}}';
$string['freemium.subscriptionplandescription'] = 'Die Abonnementpläne zeigen, welche Einschränkungen für diese Website bestehen.';
$string['freemium.subscriptionplanlearnmore'] = 'Zur Übersicht';
$string['freemium.upsell_renewexpired'] = 'Ihr Abonnement ist abgelaufen.';
$string['freemium.upsell_renewexpiring'] = 'Ihr Abonnement läuft in {{days}} Tagen ab.';
$string['freemium.upsell_renewtitle'] = 'Erneuern Sie Ihr Abonnement.';
$string['freemium.upsell_upgradefreeaccept'] = 'Erweitern';
$string['freemium.upsell_upgradefreemessage'] = 'Sie nutzen aktuell den Plan "Free". Erweitern Sie den Plan, um mehr Möglichkeiten freizuschalten.';
$string['freemium.upsell_upgradefreepostpone'] = 'Später';
$string['freemium.upsell_upgradefreetitle'] = 'Erweitern Sie Ihren Plan';
$string['pluginname'] = 'Sprachpaket für die Moodle App';
$string['privacy_metadata'] = 'Dieses Plugin speichert keine personenbezogenen Daten.';
$string['workplace.teams.isoverdue'] = 'Enthält überfällige oder abgelaufene Elemente';
