<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'uk', version '4.1'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Про мене';
$string['actingasrole'] = 'Ви зараз дієте від іншої ролі';
$string['activatetemplateoverride'] = 'Активувати заміну шаблону для \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'Якщо встановити галочку, тоді значення у налаштуваннях \'{$a->setting}\' буде використовуватися як шаблон \'{$a->template}\' , якщо воно містить текст.';
$string['activebreadcrumb'] = 'Колір тла активного пункту навігаційного меню';
$string['activebreadcrumbdesc'] = 'Встановлює колір тла активного пункту навігаційного меню та решти.';
$string['activitiesheading'] = 'Діяльності';
$string['alertaccess'] = 'Видимість оповіщення';
$string['alertaccessadmins'] = 'Видиме для адміністраторів';
$string['alertaccessdesc'] = 'Встановіть тип обмеження доступу для видимості вікна сповіщення. Заувага: якщо використовується "Додати обмеження на спеціальні поля профілю", вам потрібно додати значення поля профілю в наступне поле.';
$string['alertaccessglobal'] = 'Видиме для всіх';
$string['alertaccessprofile'] = 'Додати обмеження на спеціальні поля профілю';
$string['alertaccessusers'] = 'Видиме для авторизованих користувачів';
$string['alertannounce'] = 'Оголошення';
$string['alertannouncedesc'] = 'Показує оголошення у блоці сповіщення.';
$string['alertbackgroundcolorinfo'] = 'Колір тла Інформації';
$string['alertbackgroundcolorinfodesc'] = 'Колір тла блоків сповіщення типу "Інформація"';
$string['alertbackgroundcolorsuccess'] = 'Колір тла Оголошення';
$string['alertbackgroundcolorsuccessdesc'] = 'Колір тла блоків сповіщення типу "Оголошення"';
$string['alertbackgroundcolorwarning'] = 'Колір тла Попередження';
$string['alertbackgroundcolorwarningdesc'] = 'Колір тла блоків сповіщення типу "Попередження"';
$string['alertbordercolorinfo'] = 'Колір рамки Інформації';
$string['alertbordercolorinfodesc'] = 'Колір рамки блоків сповіщення типу "Інформація"';
$string['alertbordercolorsuccess'] = 'Колір рамки оголошення';
$string['alertbordercolorsuccessdesc'] = 'Колір рамки блоків сповіщення типу "Оголошення"';
$string['alertbordercolorwarning'] = 'Колір рамки Попередження';
$string['alertbordercolorwarningdesc'] = 'Колір рамки блоків сповіщення типу "Попередження"';
$string['alertcolorinfo'] = 'Колір значка Інформації';
$string['alertcolorinfodesc'] = 'Колір піктограм в блоках сповіщення типу "Інформація"';
$string['alertcolorsheading'] = 'Налаштування верхніх блоків сповіщення';
$string['alertcolorsuccess'] = 'Колір значка Оголошення';
$string['alertcolorsuccessdesc'] = 'Колір піктограм в блоках сповіщення типу "Оголошення"';
$string['alertcolorwarning'] = 'Колір значка Попередження';
$string['alertcolorwarningdesc'] = 'Колір піктограм в блоках сповіщення типу "Попередження"';
$string['alertcount'] = 'Кількість оповіщень';
$string['alertcountdesc'] = 'Кількість блоків оповіщень, які буде подано для оформлення нижче.';
$string['alertdesc'] = 'Введіть та налаштуйте текст, який буде показуватися у верхній частині сайту як сповіщення. Можна встановити більше одного сповіщення для охоплення на різних типів користувачів. Також у вас є можливість показувати сповіщення по всьому сайту або лише на інформаційній панелі.<br /><br /><strong>Заувага:</strong> тепер можна також показувати сповіщення на сторінках курсів, щоб попередити викладачів, що їхні курси приховані.';
$string['alertdisabled'] = 'Вимкнено';
$string['alertdisabledesc'] = 'Відключити це сповіщення';
$string['alerthiddencourse'] = 'Приховати попередження в курсі';
$string['alerthiddencoursedesc'] = 'Показує сповіщення на сторінці курсу, якщо цей курс прихований';
$string['alerticoninfo'] = 'Значок Інформації';
$string['alerticoninfodesc'] = 'Встановлює піктограму з <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>  в блоках сповіщення типу "Інформація". Вкажіть назву символу без префікса <b>fa-</b>.';
$string['alerticonsuccess'] = 'Значок Оголошення';
$string['alerticonsuccessdesc'] = 'Встановлює піктограму з <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>  в блоках сповіщення типу "Оголошення". Вкажіть назву символу без префікса <b>fa-</b>.';
$string['alerticonwarning'] = 'Значок Попередження';
$string['alerticonwarningdesc'] = 'Встановлює піктограму з <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>  в блоках сповіщення типу "Попередження". Вкажіть назву символу без префікса <b>fa-</b>.';
$string['alertinfo'] = 'Інформація';
$string['alertinfodesc'] = 'Показує інформацію в блоці сповіщення.';
$string['alertkeyvalue'] = 'Ключ сповіщення';
$string['alertkeyvalue_details'] = 'Ключ, який ідентифікує це сповіщення. Якщо ви його зміните, то всі користувачі, які його вже бачили і відключили, побачать його знову. Якщо ви зміните сповіщення, то певно захочете, щоб всі його побачили.';
$string['alertprofilefield'] = 'Назва спеціального поля профілю = Значення (додатково)';
$string['alertprofilefielddesc'] = 'Додає правило доступу використовуючи спеціальне поле профілю. Наприклад, usertype=student';
$string['alertsettings'] = 'Блок сповіщення {$a}';
$string['alertsettingscourse'] = 'Налаштування сповіщення курсу';
$string['alertsettingsgeneral'] = 'Налаштування сповіщення сайту';
$string['alertsettingsheading'] = 'Налаштовує верхній блок сповіщення (top Alert Box). Для розуміння перегляньте <a href="./../theme/adaptable/pix/layout.png" target="_blank">схему розташування</a> елементів теми.';
$string['alerttext'] = 'Текст сповіщення';
$string['alerttextdesc'] = 'Введіть текст, який буде показуватися в блоці сповіщення';
$string['alerttype'] = 'Тип блоку сповіщення';
$string['alerttypedesc'] = 'Виберіть тип сповіщення: Інформація (блакитний), Попередження (жовтий), Оголошення (зелений)';
$string['alertwarning'] = 'Попередження';
$string['alertwarningdesc'] = 'Показує попередження в блоці сповіщення.';
$string['analyticscount'] = 'Кількість аналітики';
$string['analyticscountdesc'] = 'Кількість полів аналітики для показу та редагування далі на сторінці.';
$string['analyticsprofilefield'] = 'Назва спеціального поля профілю = Значення (додатково)';
$string['analyticsprofilefielddesc'] = 'Додає правило доступу використовуючи спеціальне поле профілю. Наприклад, usertype=student';
$string['analyticssettings'] = 'Аналітика';
$string['analyticssettingsdesc'] = 'Ви можете встановити кілька кодів Google Analytics для використання їх з різними полями профілю користувача. Або ви можете використати Matomo - відкриту (open source) аналітику.';
$string['analyticssettingsheading'] = 'Налаштування Google Analytics та/або Matomo';
$string['analyticstextdesc'] = 'Вкажіть Google Analytics ID';
$string['anonymizega'] = 'Анонімізувати ІР користувача';
$string['anonymizegadesc'] = 'Анонімізує ІР користувача надсилаючи дані до Google Analytics';
$string['backcolor'] = 'Колір тла';
$string['backcolordesc'] = 'Встановлює колір тла.';
$string['bcustyle'] = 'Стиль BCU';
$string['blockbackgroundcolor'] = 'Колір тла блоку';
$string['blockbackgroundcolordesc'] = 'Встановлює колір тла для всіх блоків.';
$string['blockbordercolor'] = 'Колір обрамлення блоку';
$string['blockbordercolordesc'] = 'Встановлює колір обрамлення для всіх блоків.';
$string['blockheaderbackgroundcolor'] = 'Колір тла заголовка блоку';
$string['blockheaderbackgroundcolordesc'] = 'Встановлює колір тла заголовка для всіх блоків.';
$string['blockheaderborderbottom'] = 'Товщина нижньої межі заголовка блоку';
$string['blockheaderborderbottomdesc'] = 'Встановлює товщину нижньої межі заголовка блоків';
$string['blockheaderborderleft'] = 'Товщина лівої межі заголовка блоку';
$string['blockheaderborderleftdesc'] = 'Встановлює товщину лівої межі заголовка блоків';
$string['blockheaderborderright'] = 'Товщина правої межі заголовка блоку';
$string['blockheaderborderrightdesc'] = 'Встановлює товщину правої межі заголовка блоків';
$string['blockheaderbordertop'] = 'Товщина верхньої межі заголовка блоку';
$string['blockheaderbordertopdesc'] = 'Встановлює товщину верхньої межі заголовка блоків';
$string['blockheaderbordertopstyle'] = 'Стиль обрамлення заголовка блоку';
$string['blockheaderbordertopstyledesc'] = 'Встановлює стиль лінії обрамлення заголовка блоку';
$string['blockheaderbottomradius'] = 'Нижній радіус заголовка блоку';
$string['blockheaderbottomradiusdesc'] = 'Встановіть нижній радіус заголовка блоку  для досягнення викривленого / округлого ефекту';
$string['blockheadercolor'] = 'Колір шрифта заголовка блоку';
$string['blockheadercolordesc'] = 'Встановлює колір шрифта заголовка блоку';
$string['blockheadertopradius'] = 'Верхній радіус заголовка блоку';
$string['blockheadertopradiusdesc'] = 'Встановлює радіус заголовка верхнього блоку для досягнення викривленого / округлого ефекту';
$string['blockicons'] = 'Значки блоку';
$string['blockiconsdesc'] = 'Встановлює чи показувати значки в заголовку блока.';
$string['blockiconsheadersize'] = 'Розмір значка в заголовку блока';
$string['blockiconsheadersizedesc'] = 'Встановлює розмір шрифта для значка заголовка блоку. Виберіть значення зі списку.';
$string['blocklayoutbuilder'] = 'Регіони блоків Головної сторінки';
$string['blocklayoutbuilderdesc'] = 'Нижче ви можете створити власну розкладку для регіонів блоків на першій сторінці. Щоб додати вміст цих регіонів, потрібно <strong> перемикнути на режим редагування Головної сторінки Moodle </strong>. Потім ви можете перетягувати блоки в регіони, які ви створили!';
$string['blocklayoutlayoutcheck'] = 'Перевірте макет';
$string['blocklayoutlayoutcheckdesc'] = 'Скористайтеся наведеним нижче інструментом, щоб перевірити кількість регіонів для блоків і побачити формат нового макета.';
$string['blocklayoutlayoutcount1'] = 'Ви можете встановити максимум';
$string['blocklayoutlayoutcount2'] = 'регіона для блоків. Наразі ви використали:';
$string['blocklayoutlayoutrow'] = 'Рядок регіона блоку';
$string['blocklayoutlayoutrowdesc'] = 'Додати / встановити макет для рядка регіонів блоків на першій сторінці.';
$string['blockmainborderbottom'] = 'Товщина нижньої межі блоку';
$string['blockmainborderbottomdesc'] = 'Встановлює товщину нижньої межі основних блоків';
$string['blockmainborderleft'] = 'Товщина лівої межі основних блоків';
$string['blockmainborderleftdesc'] = 'Встановлює товщину лівої межі основних блоків';
$string['blockmainborderright'] = 'Товщина правої межі основних блоків';
$string['blockmainborderrightdesc'] = 'Встановлює товщину правої межі основних блоків';
$string['blockmainbordertop'] = 'Товщина верхньої межі основних блоків';
$string['blockmainbordertopdesc'] = 'Встановлює товщину верхньої межі основних блоків';
$string['blockmainbordertopstyle'] = 'Стиль межі основних блоків';
$string['blockmainbordertopstyledesc'] = 'Встановлює стиль лінії межі основних блоків';
$string['blockmainbottomradius'] = 'Нижній радіус основних блоків';
$string['blockmainbottomradiusdesc'] = 'Встановлює нижній радіус основних блоків для досягнення викривленого / округлого ефекту';
$string['blockmaintopradius'] = 'Верхній радіус основних блоків';
$string['blockmaintopradiusdesc'] = 'Встановлює верхній радіус основних блоків для досягнення викривленого / округлого ефекту';
$string['blockregionbackground'] = 'Колір тла регіону блоків';
$string['blockregionbackgrounddesc'] = 'Колір тла контейнера, що містить власні блоки на Головній сторінці';
$string['blockside'] = 'Розташування блоків';
$string['blocksidedesc'] = 'Визначає, де будуть з\'являтися блоки на сторінці - праворуч або ліворуч від основного вмісту';
$string['breadcrumb'] = 'Колір тла навігаційного меню';
$string['breadcrumbbackgroundcolor'] = 'Колір тла навігаційного меню';
$string['breadcrumbbackgroundcolordesc'] = 'Встановлює колір тла навігаційного меню (відомого також як Хлібні крихти)';
$string['breadcrumbdisplay'] = 'Показ навігаційного меню';
$string['breadcrumbdisplaydesc'] = 'Встановлює, що повинно показуватися в навігаційному меню (відомого також як Хлібні крихти) на сторінці курсу.';
$string['breadcrumbhome'] = 'Посилання на Головну сторінку';
$string['breadcrumbhomedesc'] = 'Визначає, чи показувати кнопку Головна в навігаційному меню як значок або як текст';
$string['breadcrumbhomeicon'] = 'Значок';
$string['breadcrumbhometext'] = 'Текст';
$string['breadcrumbseparator'] = 'Роздільник';
$string['breadcrumbseparatordesc'] = 'Визначте, який значок з <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome Icon</a> буде використовуватися в якості роздільника в навігаційному меню. Вказуйте назву значка без префікса fa-';
$string['breadcrumbtextcolor'] = 'Колір тексту';
$string['breadcrumbtextcolordesc'] = 'Визначає колір тексту в навігаційному меню';
$string['breadcrumbtitle'] = 'Назва курсу';
$string['breadcrumbtitledesc'] = 'Визначає тип показу назви курсу в навігаційному меню';
$string['bs4all'] = 'Супер Малий - Супер Великий';
$string['bs4extralarge'] = 'Лише Супер Великий';
$string['bs4large'] = 'Великий - Супер Великий';
$string['bs4medium'] = 'Середній - Супер Великий';
$string['bs4none'] = 'Відсутнє';
$string['bs4small'] = 'Малий - Супер Великий';
$string['buttoncolor'] = 'Колір кнопки';
$string['buttoncolorcancel'] = 'Колір кнопки скасування';
$string['buttoncolordesc'] = 'Колір основних кнопок, що використовуються на всьому сайті.';
$string['buttoncolordesccancel'] = 'Колір тла для кнопки Скасувати. <br /> Введіть прозорий у полі для прозорості.';
$string['buttoncolordescscnd'] = 'Колір вторинних кнопок, що використовуються на всьому сайті.';
$string['buttoncolorscnd'] = 'Колір вторинної кнопки';
$string['buttondesc'] = 'Змініть вигляд кнопок, що використовуються в цій темі.';
$string['buttondropshadow'] = 'Тінь внизу кнопки';
$string['buttondropshadowdesc'] = 'Показувати тінь (затінення) внизу кнопки.';
$string['buttonhovercolor'] = 'Колір кнопки (при наведенні)';
$string['buttonhovercolorcancel'] = 'Колір кнопки скасування (при наведенні)';
$string['buttonhovercolordesc'] = 'Колір, на який змінюється кнопка, при наведенні на неї миші.';
$string['buttonhovercolordesccancel'] = 'Колір, на який змінюється кнопка скасування при наведенні на кнопку показника миші. <br /> Введіть прозорий у полі для прозорості.';
$string['buttonhovercolordescscnd'] = 'Колір, на який змінюється вторинна кнопка при наведенні на кнопку показника миші.';
$string['buttonhovercolorscnd'] = 'Колір вторинної кнопки (при наведенні)';
$string['buttonlogincolor'] = 'Колір кнопки входу';
$string['buttonlogincolordesc'] = 'Колір кнопки входу в систему';
$string['buttonloginheight'] = 'Висота для кнопки входу';
$string['buttonloginheightdesc'] = 'Діє тільки, якщо у верхньому заголовку використовується форма для входу';
$string['buttonloginhovercolor'] = 'Колір кнопки входу при наведенні';
$string['buttonloginhovercolordesc'] = 'Колір кнопки входу при наведенні на неї мишки';
$string['buttonloginmargintop'] = 'Верхній відступ кнопки входу';
$string['buttonloginmargintopdesc'] = 'Дозволяє змінити відступ / положення кнопки входу';
$string['buttonloginpadding'] = 'Встановлює внутрішній відступ на кнопці "Вхід"';
$string['buttonloginpaddingdesc'] = 'Більше число = більша кнопка';
$string['buttonlogintextcolor'] = 'Колір тексту кнопки входу';
$string['buttonlogintextcolordesc'] = 'Колір тексту, який використовується на кнопці входу';
$string['buttonradius'] = 'Радіус кнопки';
$string['buttonradiusdesc'] = 'Більший радіус = округліші кнопки, менший радіус = квадратні кнопки';
$string['buttonsettings'] = 'Кнопки';
$string['buttonsettingsheading'] = 'Налаштовує кнопки в цій темі.';
$string['buttontextcolor'] = 'Колір тексту кнопки';
$string['buttontextcolorcancel'] = 'Колір тексту для кнопки скасування';
$string['buttontextcolordesc'] = 'Колір тексту, який буде використовуватися на кнопках';
$string['buttontextcolordesccancel'] = 'Колір тексту, що використовується на кнопках скасування.';
$string['buttontextcolordescscnd'] = 'Колір тексту, що використовується на вторинних кнопках.';
$string['buttontextcolorscnd'] = 'Колір тексту вторинної кнопки';
$string['categoryhavecustomheader'] = 'Спеціальний заголовок категорії';
$string['categoryhavecustomheaderdesc'] = 'Виберіть категорії верхнього рівня, які матимуть власні заголовки. Щоб вибрати більше однієї або скасувати вибір категорії, використовуйте клавішу "Ctrl". Збережіть та оновіть сторінку для оновлення. Примітка: Підкатегорії вибраних успадковуватимуть значення налаштувань.';
$string['categoryheaderbgimage'] = 'Картинка тла для категорії \'{$a->name}\' з кодом \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'Встановлює картинку тла в заголовку для категорії верхнього рівня \'{$a->name}\' з кодом \'{$a->id}\'. Мінімальний розмір - 1600x180px (рекомендується 1900x180px). Зображення буде охоплювати повний заголовок.';
$string['categoryheaderbgimagedescchildren'] = 'Встановлює картинку тла в заголовку для категорії верхнього рівня \'{$a->name}\' з кодом \'{$a->id}\' та її дочірньої категорії \'{$a->children}\'. Мінімальний розмір - 1600x180px (рекомендується 1900x180px). Зображення буде охоплювати повний заголовок.';
$string['categoryheadercustomcss'] = 'Спеціальний CSS для категорії \'{$a->name}\' з кодом \'{$a->id}\'';
$string['categoryheadercustomcssdesc'] = 'Встановлює спееціальний CSS для категорії верхнього рівня \'{$a->name}\' з кодом \'{$a->id}\'. Це створить CSS для селектору теми з префіксом \'.category-{$a->id}\'. Якщо CSS не застосовується, перевірте файл журналу PHP.';
$string['categoryheadercustomcssdescchildren'] = 'Встановлює спееціальний CSS для категорії верхнього рівня \'{$a->name}\' з кодом \'{$a->id}\' та її дочірньої категорії \'{$a->children}\'. Це створить CSS для селектору теми з префіксом \'.category-{$a->id}\'. Якщо CSS не застосовується, перевірте файл журналу PHP.';
$string['categoryheadercustomtitle'] = 'Спеціальний заголовок для категорії \'{$a->name}\' з кодом \'{$a->id}\'';
$string['categoryheadercustomtitledesc'] = 'Встановлює спеціальний заголовок для категорії верхнього рівня \'{$a->name}\' з кодом \'{$a->id}\'.  Якщо порожнє, то вам буде показано те, що було налаштовано за допомогою параметрів \'sitetitle\' та \'sitetitletext\' на сторінках поза курсами або на сторінках курсу, коли \'enableheading\' відключено. Якщо розміщується на сторінках, що не пов\'язані з курсом, це замінить назву сайту. Якщо розміщується на сторінках курсу, тоді з\'явиться над заголовком, який встановлено параметром "enableheading". Але на мобільних пристроях будь-який \'заголовок\' буде з\'являтися лише відповідно до налаштування \'hidcoursetitlemobile\'.';
$string['categoryheadercustomtitledescchildren'] = 'Встановлює спеціальний заголовок для категорії верхнього рівня \'{$a->name}\' з кодом \'{$a->id}\' та її дочірньої категорії \'{$a->children}\'.  Якщо порожнє, то вам буде показано те, що було налаштовано за допомогою параметрів \'sitetitle\' та \'sitetitletext\' на сторінках поза курсами або на сторінках курсу, коли \'enableheading\' відключено. Якщо розміщується на сторінках, що не пов\'язані з курсом, це замінить назву сайту. Якщо розміщується на сторінках курсу, тоді з\'явиться над заголовком, який встановлено параметром "enableheading". Але на мобільних пристроях будь-який \'заголовок\' буде з\'являтися лише відповідно до налаштування \'hidcoursetitlemobile\'.';
$string['categoryheaderheader'] = 'Налаштування для категорії верхнього рівня \'{$a->name}\' з ідентифікатором \'{$a->name}\'.';
$string['categoryheaderheaderdesc'] = 'Встановлює налаштування для категорії верхнього рівня \'{$a->name}\' з ідентифікатором \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Встановлює налаштування для категорії верхнього рівня \'{$a->name}\' з ідентифікатором \'{$a->id}\' та її дочірніх елементів \'{$a->children}\'.';
$string['categoryheaderlogo'] = 'Логотип дл якатегорії \'{$a->name}\' з ідентифікатором \'{$a->id}\'';
$string['categoryheaderlogodesc'] = 'Встановлює логотип в шапці для категорії верхнього рівня  \'{$a->name}\' з ідентифікатором \'{$a->id}\'. Рекомендований розмір - 200px на 80px.';
$string['categoryheaderlogodescchildren'] = 'Встановлює логотип в шапці для категорії верхнього рівня  \'{$a->name}\' з ідентифікатором \'{$a->id}\' та її дочірніх елементів \'{$a->children}\'. Рекомендований розмір - 200px на 80px.';
$string['categoryheaderssettings'] = 'Заголовки категорій';
$string['categoryheaderssettingsdesc'] = 'Встановлює налаштування заголовків у межах категорії.';
$string['categoryheaderssettingsheading'] = 'Змініть заголовок для однієї чи більше категорій верхнього рівня та підлеглих';
$string['cdefaulticon'] = 'Типовий значок для моїх курсів';
$string['cdefaulticondesc'] = 'Значок Font Awesome 4 без префікса "fa-" буде використана для курсів, коли вони ще не мають власного значка. Якщо порожнє, то буде використано типове значення.';
$string['cfrozenicon'] = 'Значок для заморожених курсів';
$string['cfrozenicondesc'] = 'Значок Font Awesome 4 без префікса "fa-" буде використана для заморожених курсів. Якщо порожнє, то буде використано типове значення.';
$string['chiddenicon'] = 'Значок для прихованих курсів';
$string['chiddenicondesc'] = 'Значок Font Awesome 4 без префікса "fa-" буде використана для прихованих курсів. Якщо порожнє, то буде використано типове значення.';
$string['cneveraccessedicon'] = 'Значок для ні разу не відвіданих курсів';
$string['cneveraccessedicondesc'] = 'Значок Font Awesome 4 без префікса "fa-" буде використана для курсів, де користувач зарахований але ні разу не заходив. Якщо порожнє, то буде використано типове значення.';
$string['collapsedtopicscoloursenabled'] = 'Згорнуті теми перемикають параметри кольорів тла та переднього плану';
$string['collapsedtopicscoloursenableddesc'] = 'Використовує параметри кольорів тла та переднього плану згорнутих тем замість налаштувань «sectionheadingcolor» та «coursesectionheaderbg».';
$string['colordesc'] = 'Можна вибрати кольори, які ви хотіли б використовувати по всій темі. Використовуйте Hex або будь-які інші стандартні позначення. Як альтернативний варіант ви можете використовувати прозоре та успадковане значення';
$string['colorsettings'] = 'Кольори';
$string['colorsettingsheading'] = 'Змінює основні кольори, які використовуються в темі.';
$string['configtabtitle'] = 'Налаштування';
$string['course'] = 'Курс';
$string['coursepageactivitybottomblockregionheading'] = 'Спеціальна область блоків курсу';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Спеціальний регіон для блоків  внизу сторінки курсу після всіх діяльностей.';
$string['coursepageblockactivitybottomenabled'] = 'Включити спеціальну область блоків курсу внизу сторінки';
$string['coursepageblockactivitybottomenableddesc'] = 'Включити цей регіон на всіх сторінках курсу';
$string['coursepageblocklayoutbuilder'] = 'Регіон блоків курсу';
$string['coursepageblocklayoutbuilderdesc'] = 'Нижче ви можете створити власну розкладку для регіонів блоків  на сторінці курсу. Щоб додати вміст цих регіонів, потрібно <strong> включити режим редагування на сторінці курсу</strong>. Потім ви можете почати перетягувати блоки в регіони, які ви створили!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Рядок регіонів блоків внизу сторінки курсу';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Додати / встановити макет для рядка регіону блоків внизу на сторінці курсу.';
$string['coursepageblocklayoutlayouttoprow'] = 'Рядок регіонів блоків згори сторінки курсу';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Додати / встановити макет для рядка регіону блоків вгорі на сторінці курсу.';
$string['coursepageblockregionsettings'] = 'Майстер Регіонів блоків сторінки курсу';
$string['coursepageblocksenabled'] = 'Увімкнути спеціальні регіони для блоків на сторінці курсу';
$string['coursepageblocksenableddesc'] = 'Можна вмикати / вимикати спеціальні регіони для блоків (згори та знизу) на сторінці курсу. Потім можна перетягнути блоки в створені вами регіони';
$string['coursepageblocksliderenabled'] = 'Увімкнути спеціальний регіон для слайдера на сторінці курсу';
$string['coursepageblocksliderenableddesc'] = 'Увімкнути цей регіон на всіх сторінках курсу';
$string['coursepageheaderhidesitetitle'] = 'Приховати заголовок сайту на сторінках курсу';
$string['coursepageheaderhidesitetitledesc'] = 'Приховати назву сайту, логотип та панель пошуку на сторінках курсів. Використовуйте це разом з налаштуванням висоти заголовка сторінки, щоб показати менший заголовок на сторінках, пов\'язаних з курсом.';
$string['coursepagenewssliderblockregionheading'] = 'Спеціальний регіон для слайдера новин';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Спеціальна область блоків, призначена для використання з повзунком новин, який є частиною адаптивного інтерфейсу користувача. Цей регіон з\'являється над курсом на сторінці курсу. Щоб додати слайдер новин, спочатку установіть <strong> <a href="https://moodle.org/plugins/block_news_slider"> Adaptable UI слайдера новин</a> </strong>  і налаштуйте його, щоб він з\'являвся в регіоні "слайдер сторінки курсів" на всіх сторінках курсу.';
$string['coursepagesidebarinfooterenabled'] = 'Перемістити бічну панель в нижній колонтитул на сторінці курсу';
$string['coursepagesidebarinfooterenableddesc'] = 'При широкому макеті сторінки курсів бічну панель переміщується в нижній колонтитул.';
$string['coursepagesidebarinfooterenabledsection'] = 'Загальні налаштування';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Загальні налаштування для більшості форматів курсу.';
$string['courses'] = 'Курси';
$string['coursesectionactivityassignbgcolor'] = 'Колір тла Завдання';
$string['coursesectionactivityassignbgcolordesc'] = 'Встановлює колір тла Завдання';
$string['coursesectionactivityassignleftbordercolor'] = 'Колір лівої межі Завдання';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Встановлює колір лівої межі';
$string['coursesectionactivitybordercolor'] = 'Колір нижньої межі діяльності в курсі';
$string['coursesectionactivitybordercolordesc'] = 'Встановлює колір лінії нижньої межі діяльності в секції курсу.';
$string['coursesectionactivityborderstyle'] = 'Стиль нижньої межі діяльності в курсі';
$string['coursesectionactivityborderstyledesc'] = 'Встановлює стиль лінії нижньої межі діяльності в секції курсу.';
$string['coursesectionactivityborderwidth'] = 'Товщина нижньої межі діяльності в курсі';
$string['coursesectionactivityborderwidthdesc'] = 'Встановлює товщину нижньої межі діяльності в секції курсу';
$string['coursesectionactivitycolors'] = 'Опції діяльностей секції курсу';
$string['coursesectionactivityforumbgcolor'] = 'Колір тла Форуму';
$string['coursesectionactivityforumbgcolordesc'] = 'Встановлює колір тла діяльності Форум';
$string['coursesectionactivityforumleftbordercolor'] = 'Колір лівої межі Форуму';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Встановлює колір лінії лівої межі діяльності Форум';
$string['coursesectionactivityheadingcolour'] = 'Колір заголовку діяльності в секції курсу';
$string['coursesectionactivityheadingcolourdesc'] = 'Колір для дій, які можна натиснути, відображається на домашній сторінці курсу.';
$string['coursesectionactivityiconsize'] = 'Розмір значка діяльності в курсі';
$string['coursesectionactivityiconsizedesc'] = 'Встановлює розмір значка для діяльності / ресурсу (наприклад, значення 16px буде визначати його висоту та ширину як 16px x 16px).';
$string['coursesectionactivityleftborderwidth'] = 'Товщина лівої межі діяльності в курсі';
$string['coursesectionactivityleftborderwidthdesc'] = 'Встановлює товщину межі, яка з\'являється зліва від діяльності в секції курсу.';
$string['coursesectionactivitymarginbottom'] = 'Відступ знизу діяльності';
$string['coursesectionactivitymarginbottomdesc'] = 'Відступ між діяльностями, який відступається знизу.';
$string['coursesectionactivitymargintop'] = 'Відступ зверху діяльності';
$string['coursesectionactivitymargintopdesc'] = 'Відступ між діяльностями, який відступається зверху.';
$string['coursesectionactivityquizbgcolor'] = 'Колір тла Тесту';
$string['coursesectionactivityquizbgcolordesc'] = 'Встановлює колір тла діяльності Тест.';
$string['coursesectionactivityquizleftbordercolor'] = 'Колір лівої межі Тесту';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Встановлює колір лінії лівої межі діяльності Тест.';
$string['coursesectionbgcolor'] = 'Тло секції курсу';
$string['coursesectionbgcolordesc'] = 'Встановлює колір тла секції курсу';
$string['coursesectionbordercolor'] = 'Колір межі секції курсу';
$string['coursesectionbordercolordesc'] = 'Встановлює колір лінії межі секції курсу';
$string['coursesectionborderradius'] = 'Радіус межі секції курсу';
$string['coursesectionborderradiusdesc'] = 'Встановлює радіус межі в секції курсу (закруглені кути)';
$string['coursesectionborderstyle'] = 'Стиль межі секції курсу';
$string['coursesectionborderstyledesc'] = 'Встановлює стиль лінії межі в секції курсу';
$string['coursesectionborderwidth'] = 'Товщина межі секції курсу';
$string['coursesectionborderwidthdesc'] = 'Встановлює товщину лінії межі секції курсу';
$string['coursesectionheaderbg'] = 'Тло заголовку секції курсу';
$string['coursesectionheaderbgdesc'] = 'Встановлює колір тла заголовку секції курсу';
$string['coursesectionheaderbordercolor'] = 'Колір межі заголовку секції курсу';
$string['coursesectionheaderbordercolordesc'] = 'Встановлює колір лінії межі заголовку секції курсу (використовується тільки нижня межа, оскільки   зовнішній контейнер вже має межу)';
$string['coursesectionheaderborderradiusbottom'] = 'Радіус нижньої межі заголовку секції курсу';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Встановлює радіус нижньої межі заголовку секції курсу (закруглені кути)';
$string['coursesectionheaderborderradiustop'] = 'Радіус верхньої межі заголовку секції курсу';
$string['coursesectionheaderborderradiustopdesc'] = 'Встановлює радіус верхньої межі заголовку секції курсу (закруглені кути)';
$string['coursesectionheaderborderstyle'] = 'Стиль межі заголовку секції курсу';
$string['coursesectionheaderborderstyledesc'] = 'Встановлює стиль лінії межі заголовку секції курсу (використовується тільки нижня межа, оскільки зовнішній контейнер вже має межу)';
$string['coursesectionheaderborderwidth'] = 'Товщина межі заголовку секції курсу';
$string['coursesectionheaderborderwidthdesc'] = 'Встановлює товщину лінії межі заголовку секції курсу (використовується тільки нижня межа, оскільки зовнішній контейнер вже має межу)';
$string['coursesections'] = 'Секції курсу';
$string['coursesettings'] = 'Формати курсу';
$string['coursesettingsdesc'] = 'Налаштуйте деякі з найбільш використовуваних форматів курсів Moodle, щоб вони відповідали основному дизайну проекту.';
$string['coursesettingsheading'] = 'Налаштування форматів курсу';
$string['coursetitlefullname'] = 'Повна назва курсу';
$string['coursetitlemaxwidth'] = 'Максимальна довжина назви курсу';
$string['coursetitlemaxwidthdesc'] = 'Встановлює максимальну кількість символів видимих в області назви курсу';
$string['coursetitleshortname'] = 'Коротка назва курсу/Код';
$string['covbkcolor'] = 'Колір тла області заголовку плитки Ковентрі';
$string['covbkcolordesc'] = 'Встановлює колір тла області заголовку в Плитках Ковентрі. якщо вибраний такий стиль.';
$string['coventrystyle'] = 'Стиль Ковентрі';
$string['covfontcolor'] = 'Колір тексту заголовку плитки Ковентрі';
$string['covfontcolordesc'] = 'Встановлює колір тексту заголовку в Плитках Ковентрі. якщо вибраний такий стиль.';
$string['covhidebutton'] = 'Кнопка курсу плитки Ковентрі';
$string['covhidebuttondesc'] = 'Встановлює кнопку приховування курсу в Плитках Ковентрі. якщо вибраний такий стиль.';
$string['currentcolor'] = 'Колір виділення поточної секції курсу';
$string['currentcolordesc'] = 'Встановлює колір виділення поточної секції курсу';
$string['customcoursesubtitle'] = 'Спеціальна назва курсу';
$string['customcoursesubtitledesc'] = 'Назва спеціального поля профілю користувача для назви курсу.';
$string['customcoursetitle'] = 'Спеціальна назва курсу';
$string['customcoursetitledesc'] = 'Назва спеціального поля профілю користувача для назви курсу.';
$string['customcss'] = 'Спеціальний CSS';
$string['customcssdesc'] = 'Правила CSS, які ви додасте до цього текстового поля, вбудовуватимуться в кожну сторінку, що полегшує налаштування цієї теми.';
$string['dangericoncolor'] = 'Колір значка попередження';
$string['dangericoncolordesc'] = 'Встановлює колір значка попередження/небезпеки, який використовується в основному в обов\'язкових полях.';
$string['dashblocklayoutbuilder'] = 'Регіони блоків інформаційної панелі';
$string['dashblocklayoutbuilderdesc'] = 'Нижче ви можете створити власну розкладку для областей блоків на сторінці інформаційної панелі. Щоб додати вміст цих регіонів, потрібно <strong> включити режим редагування на сторінці інформаційної панелі Moodle </strong>. Потім ви можете почати перетягувати блоки в регіони, які ви створили!';
$string['dashblocklayoutlayoutrow'] = 'Рядок регіону блоків інформаційної панелі';
$string['dashblocklayoutlayoutrowdesc'] = 'Додати / встановити макет для рядка регіонів блоків на сторінці інформаційної панелі.';
$string['dashblocksabovecontent'] = 'Показати вище основного вмісту';
$string['dashblocksbelowcontent'] = 'Показати нижче основного вмісту';
$string['dashblocksenabled'] = 'Увімкнути користувацьку область блоків на сторінці інформаційної панелі';
$string['dashblocksenableddesc'] = 'Ви можете увімкнути або вимкнути спеціальні регіони блоків на сторінці "Інформаційна панель". Потім можна перетягнути блоки в створені вами регіони.';
$string['dashblocksposition'] = 'Спеціальна позиція області блоків';
$string['dashblockspositiondesc'] = 'Коли для сторінки інформаційної панелі ввімкнено спеціальні регіони блоків, виберіть їхню позицію.';
$string['dashboardblockregionsettings'] = 'Регіони інформаційної панелі';
$string['defaultzoom'] = 'Типова ширина';
$string['defaultzoomdesc'] = 'Типовий розмір ширини сайту, коли вимкнено розширення або користувач не вказав уподобання. Вибирайте між повноекранною та фіксованою шириною.';
$string['disablecustommenu'] = 'Відключити спеціальне меню Moodle';
$string['disablecustommenudesc'] = 'Вимикає користувацькі меню Moodle на навігаційній панелі (все одно показуватиметься в інших темах, які ви, можливо, встановили)';
$string['disabled'] = 'Відключено';
$string['disablemenuscoursepages'] = 'Відключити меню на сторінках курсу';
$string['disablemenuscoursepagesdesc'] = 'Увімкнення цієї опції обмежить показ головних меню сторінками сайту, домашньої сторінки та інформаційної панелі і т.д., не буде показуватися на сторінках курсу.';
$string['discardbuttontext'] = 'Скасувати';
$string['displayeditingbuttontext'] = 'Текст кнопки редагування';
$string['displayeditingbuttontextdesc'] = 'Показати або приховати текст на кнопці редагування. Примітка: стосується лише кнопки редагування курсу.';
$string['displaygrades'] = 'Показати оцінки';
$string['displaygradesdesc'] = 'Показує елемент Оцінки в меню';
$string['displaylogin'] = 'Показати форму входу';
$string['displayloginbox'] = 'Блок входу';
$string['displayloginbutton'] = 'Кнопка';
$string['displaylogindesc'] = 'Виберіть як показувати вхід на головному екрані (якщо включено вище).';
$string['displayloginno'] = 'Не показувати';
$string['displayparticipants'] = 'Показувати учасників';
$string['displayparticipantsdesc'] = 'Показує пункт Учасники в меню Цей курс';
$string['dividingline'] = 'Роздільна лінія в заголовку';
$string['dividingline2'] = 'Роздільна лінія в підвалинах';
$string['dividingline2desc'] = 'Колір лінії поділу, розташованої в підвалинах';
$string['dividinglinedesc'] = 'Колір лінії поділу, розташованої в заголовку';
$string['editcognocourseupdate'] = 'Показати шестерню для нередакторів курсу';
$string['editcognocourseupdatedesc'] = 'Показати зубчасту шестерню для користувачів, які не мають права \'moodle/course:update\' ,  наприклад вчитель без права редагування (асистент).';
$string['editfont'] = 'Колір шрифта кнопки Редагувати цю сторінку';
$string['editfontdesc'] = 'Встановлює колір шрифта для кнопки "Редагувати цю сторінку"';
$string['edithorizontalpadding'] = 'Горизонтальні відступи в кнопках редагування';
$string['editoffbk'] = 'Тло кнопки Вимкнути налаштування цієї сторінки';
$string['editoffbkdesc'] = 'Встановлює колір тла для кнопки "Вимкнути налаштування цієї сторінки"';
$string['editonbk'] = 'Тло кнопки Редагувати цю сторінку';
$string['editonbkdesc'] = 'Встановлює колір тла для кнопки "Редагувати цю сторінку"';
$string['editsettingsbutton'] = 'Редагування налаштувань та відображення кнопок';
$string['editsettingsbuttondesc'] = 'Налаштуйте тут те, що повинно з’явитися в Navbar для редагування налаштувань. Зауважте, що ці параметри не застосовуються до сторінок, для яких немає відповідних налаштувань, наприклад, на сторінці інформаційної панелі.';
$string['editsettingsbuttonshowbutton'] = 'Показати лише кнопку редагування. Наприклад, кнопка "Редагувати" на сторінці курсу.';
$string['editsettingsbuttonshowcog'] = 'Показати лише значок редагування налаштувань (значок шестірні).';
$string['editsettingsbuttonshowcogandbutton'] = 'Показати піктограму редагування налаштувань та шестерню. Зауважте, що це займає більше місця в навігації.';
$string['emoticonsize'] = 'Розміри емоційок';
$string['emoticonsizedesc'] = 'Встановлює висоту та ширину емоційок moodle.';
$string['enableaccesstool'] = 'Інструмент доступності';
$string['enableaccesstooldesc'] = 'Показати посилання на сторінку налаштувань "Інструмент доступності" - Примітка. Для цього потрібен \'<a href="https://github.com/sharpchi/moodle-local_accessibilitytool" target="blank"> Плагін інструменту доступності </ a > \'.';
$string['enablealert'] = 'Увімкнути вікно сповіщення {$a}';
$string['enablealertdesc'] = 'Вмикає вікно сповіщення {$a}';
$string['enablealerts'] = 'Увімкнути / вимкнути сповіщення';
$string['enablealertsdesc'] = 'Вмикає / вимикає сповіщення на вашому сайті';
$string['enablealertstriptags'] = 'Автоматично вилучати html-теги зі сповіщень';
$string['enablealertstriptagsdesc'] = 'Якщо увімкнуто, то буде автоматично очищати повідомлення сповіщення від всіх HTML-тегів. Якщо вимкнуто, то дозволить вам використовувати HTML / посилання в повідомленнях, але вам доведеться вручну очистити в HTML-перегляді';
$string['enableanalytics'] = 'Включити Google Analytics';
$string['enableanalyticsdesc'] = 'Дозволяє налаштувати Google Analytics на вашому сайті';
$string['enableavailablecourses'] = 'Показувати "Доступні курси"';
$string['enableavailablecoursesdesc'] = 'Показує текст "Доступні курси" на Головній сторінці';
$string['enablebadges'] = 'Відзнаки';
$string['enablebadgesdesc'] = 'Показує посилання до відзнак користувача';
$string['enableblog'] = 'Мої блоги';
$string['enableblogdesc'] = 'Показує посилання до сторінки блогів користувача';
$string['enablecalendar'] = 'Календар користувача';
$string['enablecalendardesc'] = 'Показує посилання до календаря користувача';
$string['enablecompetencieslink'] = 'Компетентності';
$string['enablecompetencieslinkdesc'] = 'Показує посилання компетентностей у меню "Цей курс". Примітка: потрібно позначити "core_competency|enabled".';
$string['enablecoursesectionsdesc'] = 'Показати підменю в меню "Цей курс", що містить посилання на кожен показаний розділ.';
$string['enabledtabbedprofileeditprofilelink'] = 'Редагувати профайл';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Показує посилання на вкладку для редагування профілю. Примітка: якщо функція включена, показуватиметься лише в тому випадку, якщо користувач, який переглядає, має дозвіл на редагування профілю.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Уподобання';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Показує посилання на вкладку уподобань в профілі користувача.';
$string['enableeditprofile'] = 'Редагувати профайл';
$string['enableeditprofiledesc'] = 'Показує посилання до сторінки редагування профілю користувача';
$string['enableeventsdesc'] = 'Показує посилання до календаря';
$string['enablefeed'] = 'Мої відгуки';
$string['enablefeeddesc'] = 'Показує посилання на сторінку "Мої відгуки" для користувачів. Примітка: для цього потрібно мати <a href="https://moodle.org/plugins/report_myfeedback" target="blank"> модуль Мої відгуки</a>';
$string['enablegrades'] = 'Оцінки';
$string['enablegradesdesc'] = 'Показує посилання до оцінок користувача';
$string['enableheading'] = 'Заголовок з назвою курсу';
$string['enableheadingdesc'] = 'Встановлює режим показу назви курсу у заголовку сторінки, якщо увімкнено назву сайту Moodle.';
$string['enablehelp'] = 'Довідка \'{$a->number}\'';
$string['enablehelpdesc'] = 'Додає посилання довідки "{$ a-> number}" на панелі навігації.';
$string['enablehomedesc'] = 'Показує посилання до головної сторінки';
$string['enablehomeredirect'] = 'Включити Home redirect=0';
$string['enablehomeredirectdesc'] = 'Встановлює redirect=0 до Головної сторінки сайту. Це призначено для використання на сайтах, де "Головна сторінка сайту" є домашньою сторінкою за умовчанням.';
$string['enablemenus'] = 'Показувати меню';
$string['enablemenusdesc'] = 'Рекомендується вимкнути цю функцію, якщо меню не використовується з причин попередніх причин';
$string['enablemy'] = 'Інформаційна панель';
$string['enablemydesc'] = 'Показує посилання до Інформаційної панелі';
$string['enablemysitesdesc'] = 'Показує випадаюче меню з курсами користувача';
$string['enablemysitesrestriction'] = 'Обмежте спадний перелік курсів користувача до спеціального поля профілю';
$string['enablemysitesrestrictiondesc'] = 'Обмежує спадний перелік курсів користувача відповідно до спеціального поля профілю. Наприклад, usertype=staff';
$string['enablenavbarwhenloggedout'] = 'Показувати навігаційну панель без аутентифікації';
$string['enablenavbarwhenloggedoutdesc'] = 'Показує навігаційну панель навіть коли користувача вийшов. Обмежено лише меню Довідка та Інструменти.';
$string['enablenote'] = 'Мої сповіщення';
$string['enablenotedesc'] = 'Показує посилання на сторінку зі сповіщеннями користувача';
$string['enableposts'] = 'Мої повідомлення';
$string['enablepostsdesc'] = 'Показує посилання до сторінки обговорень у форумах';
$string['enablepref'] = 'Налаштування';
$string['enableprefdesc'] = 'Показує посилання до сторінки налаштувань користувача';
$string['enableprivatefiles'] = 'Особисті файли';
$string['enableprivatefilesdesc'] = 'Показує посилання до сторінки сховища особистих файлів користувача';
$string['enableprofile'] = 'Профіль користувача';
$string['enableprofiledesc'] = 'Показує посилання до сторінки профілю користувача';
$string['enablesavecanceloverlay'] = 'Увімкнути функцію "Зберегти / Скасувати" на сторінках налаштувань';
$string['enablesavecanceloverlaydesc'] = 'Показує спливаючі кнопки "Зберегти / Скасувати" вгорі сторінки налаштувань, щоб полегшити збереження налаштувань.';
$string['enableshowhideblocks'] = 'Включити Показати/Приховати блоки';
$string['enableshowhideblocksdesc'] = 'Дозволяє користувачам показувати /приховувати всі блоки';
$string['enableshowhideblockstext'] = 'Показувати текст для кнопки Показати/Приховати блоки';
$string['enableshowhideblockstextdesc'] = 'Показує текст збоку кнопки  Показати/Приховати блоки';
$string['enabletabbedprofile'] = 'Увімкнути вкладки профайлу';
$string['enabletabbedprofiledesc'] = 'Вмикає функціональність вкладок на сторінці профайлу користувача.';
$string['enablethiscoursedesc'] = 'Показує випадаюче меню з діяльностями поточного курсу';
$string['enableticker'] = 'Увімкнути рядок новин на Головній сторінці?';
$string['enabletickerc'] = 'Увімкнути рядок новин на внутрішніх сторінках?';
$string['enabletickercdesc'] = 'Вмикає рядок з текстовими новинами на внутрішніх сторінках.';
$string['enabletickerdesc'] = 'Вмикає рядок з текстовими новинами на Головній сторінці.';
$string['enabletickermy'] = 'Увімкнути рядок новин на Інформаційній панелі?';
$string['enabletickermydesc'] = 'Вмикає рядок з текстовими новинами на Інформаційній панелі';
$string['enabletoolsmenus'] = 'Увімкнути меню Інструменти';
$string['enabletoolsmenusdesc'] = 'Рекомендується вимкнути цю функцію, якщо меню не використовується з попередніх причин';
$string['enablezoom'] = 'Увімкнути збільшення';
$string['enablezoomdesc'] = 'Дозволяє користувачам перемикатися між повним екраном та фіксованою шириною.';
$string['enablezoomshowtext'] = 'Показувати текст для кнопки Масштабування';
$string['enablezoomshowtextdesc'] = 'Показує текст збоку кнопки Масштабування';
$string['events'] = 'Події';
$string['expandable'] = 'Розширюється';
$string['favicon'] = 'Значок сайту';
$string['favicondesc'] = 'Завантажте значок сайту (фавікон) для використання на вашому сайті';
$string['fontblockheadercolor'] = 'Колір шрифта заголовку блоків';
$string['fontblockheadercolordesc'] = 'Встановлює колір шрифта заголовка в блоках, використовуйте html hex код. Зауважте, що це також впливає на колір значка.';
$string['fontblockheadersize'] = 'Розмір шрифта заголовку блоків';
$string['fontblockheadersizedesc'] = 'Встановлює розмір шрифта заголовка в блоках. Виберіть значення зі списку.';
$string['fontblockheaderweight'] = 'Товщина шрифта заголовку блоків';
$string['fontblockheaderweightdesc'] = 'Встановлює товщину шрифта заголовка в блоках. Виберіть значення від 100 до 900 залежно від вибраного шрифту.';
$string['fontcolor'] = 'Головний колір шрифта';
$string['fontcolordesc'] = 'Встановлює колір шрифту в темі, використовуйте html hex код.';
$string['fontdesc'] = 'Можна вибрати <a href="https://www.google.com/fonts" target="_blank">Шрифти Google</a>, які ви хотіли б використовувати на всій темі.  Виберіть потрібну підмножину специфікацій шрифтів (latin завжди включена) і введіть потрібну товщину шрифту або шрифт не буде показуватися.';
$string['fontheadercolor'] = 'Колір шрифта заголовків';
$string['fontheadercolordesc'] = 'Встановлює колір шрифта заголовків в темі, використовуйте html hex код.';
$string['fontheadername'] = 'Шрифт заголовків';
$string['fontheadernamedesc'] = 'Виберіть типовий шрифт або <a href="https://www.google.com/fonts" target="_blank">Шрифт Google</a>, який ви хотіли б використовувати в заголовках блоків.';
$string['fontheaderweight'] = 'Товщина шрифту заголовків';
$string['fontheaderweightdesc'] = 'Товщина шрифту заголовків на сайті. Виберіть значення від 100 до 900 залежно від вибраного шрифту.';
$string['fontname'] = 'Основний шрифт';
$string['fontnamedesc'] = 'Виберіть типовий шрифт або <a href="https://www.google.com/fonts" target="_blank">Шрифт Google</a>, який ви хотіли б використовувати на всьому сайті.';
$string['fontsettings'] = 'Шрифти';
$string['fontsettingsheading'] = 'Налаштуйте шрифти, які використовуються в темі.';
$string['fontsize'] = 'Розмір основного шрифта';
$string['fontsizedesc'] = 'Вкажіть типовий розмір шрифту (у відсотках), який буде використовуватися на всьому сайті.';
$string['fontsubset'] = 'Множини шрифтів Google';
$string['fontsubsetdesc'] = 'Виберіть іншу підмножину символів, ніж латинська, яка буде застосована до всіх шрифтів. Латинська (latin) підмножина вже стандартно включена.';
$string['fonttitlecolor'] = 'Колір шрифту назви Курсу / Сайту';
$string['fonttitlecolorcourse'] = 'Колір шрифту назви Курсу';
$string['fonttitlecolorcoursedesc'] = 'Встановлює колір назви курсу в заголовку сторінки, використовуйте html hex код.';
$string['fonttitlecolordesc'] = 'Встановлює колір назви сайту та назви курсу в заголовку сторінки, використовуйте html hex код.';
$string['fonttitlename'] = 'Шрифт назви Сайту / Курсу';
$string['fonttitlenamedesc'] = 'Виберіть типовий шрифт або <a href="https://www.google.com/fonts" target="_blank">Шрифт Google</a>, який ви хотіли б використовувати в назві сайту та курсу.';
$string['fonttitlesize'] = 'Розмір шрифту назви Сайту / Курсу';
$string['fonttitlesizedesc'] = 'Встановлює розмір шрифту назви сайту та назви курсу в заголовку сторінки. Виберіть значення зі списку.';
$string['fonttitleweight'] = 'Товщина шрифту назви Сайту / Курсу';
$string['fonttitleweightdesc'] = 'Встановлює товщину шрифту назви сайту та назви курсу в заголовку сторінки. Виберіть значення від 100 до 900 залежно від вибраного шрифту.';
$string['fontweight'] = 'Товщина основного шрифту';
$string['fontweightdesc'] = 'Встановлює товщину основного шрифту сайту. Виберіть значення від 100 до 900 залежно від вибраного шрифту.';
$string['footerbkcolor'] = 'Колір тла підвалин';
$string['footerbkcolordesc'] = 'Встановлює колір тла підвалин';
$string['footerblocksplacement'] = 'Розміщення Блоків у підвалинах';
$string['footerblocksplacement1'] = 'По всьому сайту';
$string['footerblocksplacement2'] = 'Лише головна сторінка';
$string['footerblocksplacement3'] = 'Не використовувати';
$string['footerblocksplacementdesc'] = 'Керуйте, де показуватимуться блоки підвалин. Типовою - По всьому сайту.';
$string['footercontent'] = 'Секція контенту підвалин';
$string['footercontentdesc'] = 'Додає секцію з довільним контентом у підвалини';
$string['footerdesc'] = 'Додає заголовок до секції підвалин';
$string['footerheader'] = 'Заголовок секції підвалин';
$string['footerlayoutrow'] = 'Підвалини';
$string['footerlayoutrowdesc'] = 'Створюйте макет для областей блоків у підвалинах.';
$string['footerlinkcolor'] = 'Колір посилань в підвалинах';
$string['footerlinkcolordesc'] = 'Колір посилань в блоках в підвалинах.';
$string['footersettings'] = 'Підвалини';
$string['footersettingsheading'] = 'Встановлює вміст, який повинен з\'явитися у підвалинах. Перегляньте макет теми <a href="./../theme/adaptable/pix/layout.png" target="_blank"> тут</a>';
$string['footertextcolor'] = 'Колір тексту підвалин';
$string['footertextcolor2'] = 'Колір тексту підвалин';
$string['footertextcolor2desc'] = 'Колір тексту підвалин';
$string['footertextcolordesc'] = 'Колір тексту підвалин, використовуйте html hex код.';
$string['footnote'] = 'Примітка';
$string['footnotedesc'] = 'Додає текст до підвалин';
$string['forumbodybackgroundcolor'] = 'Тло тіла повідомлення форуму';
$string['forumbodybackgroundcolordesc'] = 'Встановлює колір тла тіла повідомлення форуму';
$string['forumheaderbackgroundcolor'] = 'Тло заголовку повідомлення форуму';
$string['forumheaderbackgroundcolordesc'] = 'Колір тла для повідомлень форуму';
$string['frnt-footer'] = 'Блоки в цій області будуть видимі лише адміністраторам';
$string['frontpageblocksenabled'] = 'Вмикає спеціальні регіони з блоками на Головній сторінці';
$string['frontpageblocksenableddesc'] = 'Ви можете увімкнути / вимкнути спеціальні регіони для блоків на головній сторінці. Потім можна перетягнути блоки в створені вами регіони';
$string['frontpageblocksettings'] = 'Маркетингові блоки';
$string['frontpagecoursesettings'] = 'Список курсів на Головній сторінці';
$string['frontpagedesc'] = 'Налаштовує спосіб показу інформації про курси на головній сторінці.';
$string['frontpagemarketenabled'] = 'Включити маркетингові блоки';
$string['frontpagemarketenableddesc'] = 'Встановлює маркетингові блоки на Головній сторінці.';
$string['frontpagemarketoption'] = 'Виберіть стиль для маркетингових блоків';
$string['frontpagemarketoptiondesc'] = 'До маркетингових блоків можна застосовувати різні стилі. Примітка: Стиль BCU призначений для роботи з зображеннями у верхній частині блоку.';
$string['frontpagenumbertiles'] = 'Кількість плиток курсів на рядок';
$string['frontpagenumbertilesdesc'] = 'Кількість плиток курсів на рядок, що показуватимуться у списку курсів на першій сторінці.';
$string['frontpagerenderer'] = 'Курси на Головній сторінці';
$string['frontpagerendererdefaultimage'] = 'Типова картинка курсу';
$string['frontpagerendererdefaultimagedesc'] = 'Типова картинка буде використовуватися, якщо в курсі не визначено картинку (застосовується лише до плитки з накладанням)';
$string['frontpagerendererdesc'] = 'Керує тим, як буде показуватися інформація про курси на Головній сторінці.';
$string['frontpagerendereroption1'] = 'Плитки';
$string['frontpagerendereroption2'] = 'Плитки з накладкою';
$string['frontpagerendereroption3'] = 'Типове в Moodle';
$string['frontpagerendereroption4'] = 'Плитки Кавентрі';
$string['frontpagesettingsheading'] = 'Представлення Головної сторінки';
$string['frontpageslidersettings'] = 'Слайдер Головної сторінки';
$string['frontpagetiles1'] = '1 плитка';
$string['frontpagetiles2'] = '2 плитки';
$string['frontpagetiles3'] = '3 плитки';
$string['frontpagetiles4'] = '4 плитки';
$string['frontpagetiles6'] = '6 плиток';
$string['fullscreen'] = 'Повний екран';
$string['fullscreenwidth'] = 'Ширина повного екрану.';
$string['fullscreenwidthdesc'] = 'Встановлює максимальну ширину теми, коли вона знаходиться в повноекранному режимі.';
$string['future'] = 'Майбутнє';
$string['gdprbutton'] = 'Кнопка підсумку збереження даних';
$string['gdprbuttondesc'] = 'Показувати у підвалинах підсумок збереження даних.';
$string['googleanalyticssettingsdesc'] = 'Можна встановити декілька кодів для Google Analytics і призначити їх для полів профілю користувача.';
$string['googleanalyticssettingsheading'] = 'Встановіть Google Analytics для свого сайту';
$string['headerbgimage'] = 'Картинка тла';
$string['headerbgimagedesc'] = 'Встановлює картинку тла в заголовку. Максимальний розмір 1600x180px (рекомендується 1900x180px). Зображення повністю заповнює заголовок. Ви можете додати колір у "Колір тла верхнього заголовка" або використати <i> прозорість </i>, щоб показати зображення тла. У цьому випадку змініть колір тексту, щоб він правильно показувався на зображенні.';
$string['headerbkcolor'] = 'Колір тла верхнього заголовка';
$string['headerbkcolor2'] = 'Колір тла нижнього заголовка';
$string['headerbkcolor2desc'] = 'Встановлює колір тла нижнього заголовка';
$string['headerbkcolordesc'] = 'Встановлює колір тла верхнього заголовка';
$string['headerdesc'] = 'Завантажте ваш фавікон (favicon), логотип, встановіть форму входу в заголовку, налаштуйте назви у заголовку. <br />  Ви можете встановити розмір шрифтів та стиль назв на сторінці налаштування <a href="./../admin/settings.php?section=theme_adaptable_font">шрифтів</a>.';
$string['headernavbarhelpheading'] = 'Посилання допомоги та Опції';
$string['headernavbarhelpheadingdesc'] = 'Опції для посилань для допомоги';
$string['headernavbarmycoursesheading'] = 'Меню Мої курси';
$string['headernavbarmycoursesheadingdesc'] = 'Усі опції для пункту меню "Мої курси", що показує список поточних курсів користувача';
$string['headernavbarthiscourseheading'] = 'Меню Цей курс';
$string['headernavbarthiscourseheadingdesc'] = 'У цьому меню студент може отримати доступ безпосередньо до всіх курсових заходів і до списку учасників та своїх оцінок.';
$string['headersettings'] = 'Заголовок';
$string['headersettingsheading'] = 'Налаштування заголовку цієї теми. Перегляньте шаблон розташування елементів  <a href="./../theme/adaptable/pix/layout.png" target="_blank"> тут</a>';
$string['headerstyle'] = 'Стиль Заголовку';
$string['headerstyle1'] = 'Заголовок 1 (оригінальні 3 рядки)';
$string['headerstyle2'] = 'Заголовок 2 (2 рядки)';
$string['headerstyledesc'] = 'Виберіть стиль заголовка. Заголовок 1 відноситься до оригінального 3-рядкового адаптивного заголовка. Заголовок 2 - це мінімальний заголовок із 2 рядків. Зверніть увагу, що при використанні Заголовка 2 для параметра "Використовувати вікно пошуку або соціальні значки", воно завжди використовуватиме вікно пошуку.';
$string['headerstyleheading'] = 'Налаштування стилю Заголовка';
$string['headerstyleheadingdesc'] = 'Adaptable підтримує два стилі заголовків, оригінальний трирядний заголовок та новий спрощений дворядковий заголовок.<br/>Майте на увазі, що якщо ви перейдете на новий дворядковий заголовок, ви <strong> НЕ</strong> зможете:<br /><ol><li>Показати соціальні значки в заголовку.</li><li>Показувати логотип сайту на мобільних пристроях.</li></ol>';
$string['headertextcolor'] = 'Колір посилань та тексту блоків у верхньому заголовку';
$string['headertextcolor2'] = 'Колір посилань та тексту блоків у нижньому заголовку';
$string['headertextcolor2desc'] = 'Встановлює колір посилань та тексту блоків у нижньому заголовку.';
$string['headertextcolordesc'] = 'Встановлює колір посилань та тексту блоків у верхньому заголовку.';
$string['help'] = 'Допомога';
$string['helplinkscount'] = 'Кількість посилань довідки';
$string['helplinkscountdesc'] = 'Встановіть кількість посилань довідки, які ви хочете додати на головну панель навігації.';
$string['helplinktitle'] = 'Назва посилання \'{$a->number}\' довідки';
$string['helplinktitledesc'] = 'Назва посилання \'{$a->number}\' довідки на панелі навігації. Якщо порожнє, то типово встановлено значення "Довідка {$a->number}".';
$string['helpprofilefield'] = 'Спеціальне поле профілю';
$string['helpprofilefielddesc'] = 'Додає правило доступу через використання спеціального поля профілю користувача, наприклад, usertype=student';
$string['helptarget'] = 'Як відкривати';
$string['helptargetdesc'] = 'Чи потрібно відкривати посилання допомоги у новому вікні?';
$string['helptitle'] = 'Допомога';
$string['hiddencourses'] = 'Сховані курси';
$string['hiddenfromview'] = 'Сховано від перегляду';
$string['hide'] = 'Приховати';
$string['hidefootersocial'] = 'Показати значки соц.мереж';
$string['hidefootersocialdesc'] = 'Показує значки соціальних мереж у підвалинах сайту під регіоном блоків.';
$string['hideinforum'] = 'Приховати Допомогу та Інструменти у Форумах';
$string['hideinforumdesc'] = 'При використанні фіксованої ширини і всіх опцій меню вікно пошуку форуму перескакує на рядок нижче. Увімкнення цієї опції призведе до приховування інструментів і пунктів меню довідки на форумах, що дозволять йому правильно показуватися.';
$string['home'] = 'Головна';
$string['homebk'] = 'Картинка тла Головної сторінки';
$string['homebkdesc'] = 'Завантажте картинку, яка буде тлом на Головній сторінці';
$string['infobox'] = 'Інформаційний блок Головної сторінки';
$string['infobox2'] = '2-й Інформаційний блок Головної сторінки';
$string['infobox2desc'] = '2-й Інформаційний блок Головної сторінки (див. <a href="./../theme/adaptable/README.txt" target="_blank">README</a> файл для додаткової інформації та підказок).<br><br><strong>Зауваження: </strong> Цей елемент використовується тільки для сумісності з BCU і буде видалено в найближчих версіях.</i>';
$string['infoboxdesc'] = 'Інформаційний блок Головної сторінки (див. <a href="./../theme/adaptable/README.txt" target="_blank">README</a> файл для додаткової інформації та підказок).<br><br><strong>Зауваження: </strong> Цей елемент використовується тільки для сумісності з BCU і буде видалено в найближчих версіях.</i>';
$string['infoboxfullscreen'] = 'Розширити інформаційний блок на повний екран';
$string['infoboxfullscreendesc'] = 'Включення цієї опції розширить інформаційний блок на всю ширину сторінки.';
$string['infoiconcolor'] = 'Колір значків довідки';
$string['infoiconcolordesc'] = 'Встановлює колір значка інформації / довідки, для підказок.';
$string['informationsettingsdesc'] = 'Інформація про тему Adaptable.';
$string['inprogress'] = 'В процесі';
$string['introboxbackgroundcolor'] = 'Колір тла вступного вікна';
$string['introboxbackgroundcolordesc'] = 'Колір тла для вступного вікна (виділяє опис діяльності), який використовується на форумах та інших діяльностях';
$string['jssection'] = 'Секція Javascript';
$string['jssectiondesc'] = 'Можна додати код Javascript на свій сайт.';
$string['jssectionrestricted'] = 'Умовний Javascript';
$string['jssectionrestricteddashboardonly'] = 'Включити Javascript лише на Інформаційній панелі';
$string['jssectionrestricteddashboardonlydesc'] = 'Показує javascript лише на сторінці інформаційної панелі. Інакше спрацьовуватиме по всьому сайту.';
$string['jssectionrestricteddesc'] = 'Додає код javascript за певної умови, базуючись на спеціальному полі профайлу. Такий javascript з\'явиться лише за умови виконання цієї умови.';
$string['jssectionrestrictedprofilefield'] = 'Спеціальне поле профайлу для javascript';
$string['jssectionrestrictedprofilefielddesc'] = 'Включає код javascript на сторінку лише, якщо спеціальне поле профайлу  користувача відповідає значенню, наприклад, faculty=fbl.';
$string['jumpto'] = 'Перейти до...';
$string['landscape'] = 'Альбомний';
$string['layoutaddcontent'] = 'Задоволені вашим макетом? Тепер додайте контент у ваші блоки:';
$string['layoutaddcontentdesc1'] = 'Ви налаштували';
$string['layoutaddcontentdesc2'] = 'маркетингові блоки. Якщо ви задоволені цим розкладом, додайте вміст до блоків нижче. Якщо ви не задоволені, скористайтеся вищезгаданим майстром компонування<br />';
$string['layoutcheck'] = 'Перевірте ваш макет';
$string['layoutcheckdesc'] = 'Скористайтеся наведеним нижче інструментом, щоб перевірити кількість використовуваних блоків і побачити подання нового макета.';
$string['layoutcount1'] = 'Можна встановити максимум&nbsp;';
$string['layoutcount2'] = '&nbsp;регіонів для блоків. Наразі ви використовуєте:&nbsp;';
$string['layoutdesc'] = 'Встановлює типовий макет, який користувачі бачать.';
$string['layoutsettings'] = 'Макет';
$string['layoutsettingsheading'] = 'Контрольні аспекти для макету сайту';
$string['leftblocks'] = 'Ліворуч';
$string['linkcolor'] = 'Колір посилань';
$string['linkcolordesc'] = 'Встановлює колір посилань в темі, використовуйте html hex код.';
$string['linkhover'] = 'Колір посилань при наведенні';
$string['linkhoverdesc'] = 'Встановлює колір посилань (при наведенні мишею) в темі, використовуйте html hex код.';
$string['linksmenu'] = '<span class="fa fa-bars" style="font-size: 150%;"></span>';
$string['loadingcolor'] = 'Колір завантаження';
$string['loadingcolordesc'] = 'Визначає колір лінії завантаження сторінки на горі сайту';
$string['loginbgimage'] = 'Картинка тла';
$string['loginbgimagedesc'] = 'Додати зображення тла на повний розмір сторінки.';
$string['loginbgopacity'] = 'Заголовки сторінки навігації, панель навігації, поле входу та непрозорість тла нижнього колонтитула, коли є зображення тла';
$string['loginbgopacitydesc'] = 'Непрозорість тла сторінки входу для заголовка, панелі навігації, поля входу та нижнього колонтитула, коли є зображення тла.';
$string['loginbgstyle'] = 'Стиль тла для сторінки входу';
$string['loginbgstyledesc'] = 'Виберіть стиль завантаженого зображення.';
$string['logindesc'] = 'Налаштовує сторінку входу, додаючи зображення тла та тексти над і під вікном входу.';
$string['loginfooter'] = 'Нижній колонтитул сторінки входу';
$string['loginfooterdesc'] = 'Показувати нижній колонтитул сторінки входу.';
$string['loginheader'] = 'Заголовок сторінки входу';
$string['loginheaderdesc'] = 'Показувати заголовок сторінки входу.';
$string['loginplaceholder'] = 'Псевдо';
$string['loginsettings'] = 'Сторінка входу';
$string['loginsettingsheading'] = 'Налаштування сторінки входу.';
$string['logintextboxbottom'] = 'Нижнє текстове поле';
$string['logintextboxbottomdesc'] = 'Додає власний текст під полем для входу.';
$string['logintextboxtop'] = 'Верхнє текстове поле';
$string['logintextboxtopdesc'] = 'Додає власний текст над полем для входу.';
$string['logintextbutton'] = 'Вхід';
$string['logo'] = 'Логотип';
$string['logodesc'] = 'Завантажте логотип вашого сайту. Рекомендується розмі 200px x 80pxр';
$string['maincolor'] = 'Головний колір';
$string['maincolordesc'] = 'Головний колір для блоків та підвалин.';
$string['maincoursepage'] = 'Головна сторінка курсу';
$string['market'] = 'Маркетинговий блок';
$string['marketblockbordercolor'] = 'Колір межі маркетингового блоку';
$string['marketblockbordercolordesc'] = 'Встановлює колір лінії межі маркетингового блоку';
$string['marketblocksbackgroundcolor'] = 'Колір тла регіону маркетингових блоків';
$string['marketblocksbackgroundcolordesc'] = 'Встановлює колір тла для регіону маркетингових блоків';
$string['marketdesc'] = 'Додайте html для маркетингового блоку (див. <a href="./../theme/adaptable/README.txt" target="_blank">README</a> файл з додатковою інформацією та підказками).';
$string['marketingbuilderdesc'] = 'Використайте інструмент нижче, щоб налаштувати маркетингові блоки. Після того, як їх параметри визначено,  блоки з\'являться на сторінці.';
$string['marketingbuilderheading'] = 'Майстер макету маркетингових блоків';
$string['marketingdesc'] = 'Можна використовувати дві інформаційні панелі повної ширини з різними стилями. На додаток до цього є майстер макетів, який дозволяє вирішити, скільки блоків вам потрібно, і визначити власну розкладку, див. <a href="./../theme/adaptable/README.txt" target="_blank">README</a> файл з додатковою інформацією та підказками.';
$string['marketingsettings'] = 'Маркетингові блоки';
$string['marketingsettingsheading'] = 'Налаштуйте маркетингові блоки, які з\'являються на Головній сторінці. Дивіться доступний макет розташування <a href="./../theme/adaptable/pix/layout.png" target="_blank"> тут</a>';
$string['marketlayoutrow'] = 'Рядок маркетингових блоків';
$string['marketlayoutrowdesc'] = 'Додає / налаштовує макет маркетингового блоку на Головній сторінці';
$string['menubkcolor'] = 'Колір тла головного меню';
$string['menubkcolordesc'] = 'Встановлює колір тла головного меню';
$string['menubordercolor'] = 'Колір нижньої межі головного меню';
$string['menubordercolordesc'] = 'Встановлює колір нижньої межі головного меню';
$string['menufontcolor'] = 'Колір шрифта головного меню';
$string['menufontcolordesc'] = 'Встановлює колір шрифта головного меню';
$string['menufontpadding'] = 'Відступ в навігаційних елементах';
$string['menufontpaddingdesc'] = 'Встановлює внутрішній відступ в елементах головної навігаційної панелі.';
$string['menufontsize'] = 'Розмір шрифта в навігаційній панелі';
$string['menufontsizedesc'] = 'Встановлює розмір шрифта, який буде використовуватися в навігаційній панелі.';
$string['menuoverrideprofilefield'] = 'Назва поля профілю користувача';
$string['menuoverrideprofilefielddesc'] = 'Назва спеціального поля "списку" профілю, який використовується для перевизначення користувача';
$string['menusession'] = 'Зберігати деталі доступу в сесії';
$string['menusessiondesc'] = 'З міркувань ефективності пропонується це увімкнути. Ви можете вимкнути під час тестування';
$string['menusessionttl'] = 'Хвилини для зберігання правил доступу в сесії';
$string['menusessionttldesc'] = 'Кількість хвилин, після чого правила доступу до меню оновлюються у сеансі користувача.';
$string['menusettings'] = 'Меню заголовка';
$string['menusettingsheading'] = 'Налаштуйте меню у верхній частині заголовку цієї теми.';
$string['menusheading'] = 'Налаштуйте навігацію за посиланнями в Меню у верхньому заголовку';
$string['menusheadingvisibility'] = 'Загальні параметри для видимості верхнього меню';
$string['menusheadingvisibilitydesc'] = 'Наведені нижче параметри дозволяють керувати показом меню і, за бажанням, дозволяти користувачам налаштовувати їхні параметри';
$string['menuslinkicon'] = 'Значок меню Посилання';
$string['menuslinkicondesc'] = 'Виберіть спеціальний значок від Font Awesome';
$string['menuslinkright'] = 'Показувати посилання меню в правому куті';
$string['menuslinkrightdesc'] = 'Якщо позначено, показує посилання на меню вгорі праворуч від меню повідомлень';
$string['menustitledesc'] = 'Меню інструментів (в навігаційній панелі) та Верхнє меню (у верхньому заголовку) може бути обмежено на основі спеціальних полів профілю (необов\'язково). Щоб додати обмеження, введіть ім\'я поля профілю та очікуване значення. Структура меню відповідає загальному формату Moodle: <pre> Moodle community|https://moodle.org -Moodle free support|https://moodle.org/support -Moodle development|https://moodle.org/development --Moodle Docs|http://docs.moodle.org|Moodle Docs --German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de Moodle.com|http://moodle.com/ </pre>';
$string['menuuseroverride'] = 'Дозволити користувачам перевизначати';
$string['menuuseroverridedesc'] = 'Ці параметри можна використовувати, щоб дати користувачам можливість керувати місцем показу меню за допомогою спеціального поля профілю. Щоб скористатися цим параметром, потрібно створити спеціальне поле профілю у форматі "список" зі значеннями у відповідному порядку: <pre>1. Весь сайт (першим пунктом у списку буде видимість меню по всьому сайту) 2. Лише Домашня сторінка (другий елемент у списку буде встановлювати видимість лише для сайту / домашньої сторінки) 3. Приховано (третє значення списку буде встановлювати повне приховання) </pre> Ви не повинні використовувати параметр "Вимкнути меню на сторінках курсів" у відповідності до налаштувань поля профілю, а замість цього скористайтеся встановленим типовим значенням  для запису "Лише домашні сторінки" під час налаштування списку полів профілю. Примітка. Користувачам доведеться вийти з Moodle і повернутися знову, щоб це зміна набуло чинності. Можливо, вам слід додати нотатку, яка пояснює це в полі власного профілю.';
$string['messagepopupbackground'] = 'Колір тла виринаючих повідомлень.';
$string['messagepopupbackgrounddesc'] = 'Встановлює колір тла заголовку виринаючих повідомлень.';
$string['messagepopupcolor'] = 'Колір тексту виринаючих повідомлень';
$string['messagepopupcolordesc'] = 'Встановлює колір тексту заголовку виринаючих повідомлень.';
$string['messagingbackgroundcolor'] = 'Колір тла головного вікна повідомлень';
$string['messagingbackgroundcolordesc'] = 'Встановлює колір тла головного чат вікна повідомлень.';
$string['mobilemenubkcolor'] = 'Колір тла мобільного меню';
$string['mobilemenubkcolordesc'] = 'Встановлює колір тла Головного Меню на мобільних пристроях';
$string['moodledocs'] = 'Посилання на Документацію Moodle';
$string['moodledocsdesc'] = 'Показувати посилання "Документація Moodle" у підвалинах.';
$string['more'] = 'Докладніше';
$string['myblogs'] = 'Мої блоги';
$string['mycoursesmenulimit'] = 'Обмеження меню "Мої курси"';
$string['mycoursesmenulimitdesc'] = 'Налаштуйте максимальну кількість курсів, які показуватимуться у випадаючому списку Мої курси. 0 покаже всі курси.';
$string['mysites'] = 'Мої курси';
$string['mysitesdisabled'] = 'Вимкнути';
$string['mysitesexclude'] = 'Виключити приховані курси';
$string['mysitesinclude'] = 'Включити приховані курси';
$string['mysitesmaxlength'] = 'Максимальна довжина Моїх курсів';
$string['mysitesmaxlengthdesc'] = 'Налаштуйте максимальну довжину назв курсів у спадному списку "Мої курси", щоб оптимізувати шрифт.';
$string['mysitesmenudisplay'] = 'Показувати меню "Мої курси"';
$string['mysitesmenudisplaydesc'] = 'Виберіть, який текст показуватиметься для пункту меню та при наведенні.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Показати повну назву курсу та повну назву при наведенні.';
$string['mysitesmenudisplayfullnamenohover'] = 'Показувати повну назву курсу та без тексту при наведенні.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Показувати короткий код і повну назву курсу при наведенні.';
$string['mysitesmenudisplayshortcodenohover'] = 'Показувати короткий код та без тексту при наведенні.';
$string['mysitessortoverride'] = 'Увімкнути власне сортування Моїх курсів';
$string['mysitessortoverridedesc'] = 'Використовуйте спеціальні поля профілю або загальні рядки (рік абощо), щоб згорнути минулі курси в підменю';
$string['mysitessortoverridefield'] = 'Спеціальні поля профайлу або Рядки для Моїх курсів';
$string['mysitessortoverridefielddesc'] = 'Розділений комами список полів або рядків профілю для перевірки в короткому коді курсу';
$string['mysitessortoverridelast'] = 'Час останнього доступу або час початку реєстрації, якщо ніколи не отримували доступу';
$string['mysitessortoverridemyoverview'] = 'Використовувати список із мого огляду';
$string['mysitessortoverrideoff'] = 'Показати всі курси, де зарахований, в одному списку';
$string['mysitessortoverrideprofilefields'] = 'Показати курси, знайдені в полях профілю в першому списку, інші - у підменю';
$string['mysitessortoverrideprofilefieldscohort'] = 'Показати курси, знайдені в полях профілю + гурти в першому списку, інші - в підменю';
$string['mysitessortoverridestrings'] = 'Показати курси, де зарахований в першому списку, інші в підменю';
$string['navbarcachetime'] = 'Час кешу навігаційної панелі';
$string['navbarcachetimedesc'] = 'Кількість хвилин для кешування навігаційної панелі.';
$string['navbardesc'] = 'Дозволяє керувати всіма елементами, які показуються на навігаційній панелі.';
$string['navbardisplayicons'] = 'Показати значки';
$string['navbardisplayiconsdesc'] = 'Показує значки поруч із заголовками головного меню';
$string['navbardropdownborderradius'] = 'Радіус межі спадного меню';
$string['navbardropdownborderradiusdesc'] = 'Контролює радіус межі спадного меню (наприклад, закруглені кути).';
$string['navbardropdownhovercolor'] = 'Колір при наведенні на спадне меню';
$string['navbardropdownhovercolordesc'] = 'Колір спадного меню при наведенні на його пункти миші.';
$string['navbardropdowntextcolor'] = 'Колір тексту випадаючого меню';
$string['navbardropdowntextcolordesc'] = 'Колір тексту пункту випадаючого меню.';
$string['navbardropdowntexthovercolor'] = 'Колір тексту випадаючого меню при наведенні';
$string['navbardropdowntexthovercolordesc'] = 'Колір тексту випадаючого меню під час наведення курсора на елементи меню.';
$string['navbardropdowntransitiontime'] = 'Час переходу по навігаційному меню';
$string['navbardropdowntransitiontimedesc'] = 'Час переходу навігаційної панелі в секундах. Забезпечує ефект анімації затухання, коли ви наводите курсор на меню з підменю.';
$string['navbarlinksettingsdesc'] = 'Дозволяє керувати посиланнями, які показуються на панелі навігації.';
$string['navbarlinksettingsheading'] = 'Налаштуйте посилання на панелі навігації';
$string['navbarlinkssettings'] = 'Посилання навігаційної панелі';
$string['navbarsettings'] = 'Верхня панель навігації';
$string['navbarsettingsheading'] = 'Налаштуйте панель навігації';
$string['navbarstyles'] = 'Стилі навігаційної панелі';
$string['navbarstylesdesc'] = 'Дозволяє керувати стилями елементів, що відображаються на панелі навігації.';
$string['navbarstylesheading'] = 'Налаштуйте стилі навігаційної панелі';
$string['newmenu'] = 'Верхнє спадне меню';
$string['newmenudesc'] = 'Налаштовує посилання для показу в меню верхнього заголовка.';
$string['newmenufield'] = 'Назва спеціального поля профілю = Значення (додатково)';
$string['newmenufielddesc'] = 'Додає правило доступу, використовуючи спеціальне поле профілю користувача. Наприклад, usertype=student';
$string['newmenuheading'] = 'Верхнє меню';
$string['newmenurequirelogin'] = 'Потрібен вхід';
$string['newmenurequirelogindesc'] = 'Якщо ввімкнено, це меню буде видимим лише для користувачів, що увійшли під своїм ім\'ям';
$string['newmenutitle'] = 'Назва верхнього меню';
$string['newmenutitledefault'] = 'Меню';
$string['newmenutitledesc'] = 'Назва спадного списку, який з\'явиться в заголовку вашого сайту';
$string['newstickercount'] = 'Кількість секцій текстових новин';
$string['newstickercountdesc'] = 'Визначте декілька секцій текстових новин з правилами доступу для націлювання на різні аудиторії';
$string['nextactivity'] = 'Наступне';
$string['nextsection'] = 'Наступна секція';
$string['noenrolments'] = 'Не зареєстровано на жодному курсі';
$string['none'] = 'Відсутнє';
$string['normal'] = 'Фіксована ширина';
$string['nostyle'] = 'Без стилю';
$string['originaltemplatepreview'] = 'Попередній перегляд оригінального / зміненого файлу теми';
$string['originaltemplatesource'] = 'Оригінальний / змінений файл теми';
$string['overriddentemplate'] = 'Замінений шаблон: {$a}';
$string['overriddentemplatedesc'] = 'Якщо встановлено, тоді текст тут буде використовуватися як шаблон \'{$a}\'. Щоб перегляд працював, повинен бути стандартний приклад контексту у форматі JSON.';
$string['overriddentemplatenopreview'] = 'Немає попереднього перегляду через відсутність прикладу JSON';
$string['overriddentemplatepreview'] = 'Налаштування заміненого попереднього перегляду';
$string['overridetemplate'] = 'Замінити шаблон: {$a}';
$string['pageheaderalternative'] = 'Альтернатива';
$string['pageheaderheight'] = 'Висота заголовка сторінки';
$string['pageheaderheightdesc'] = 'Встановлює висоту області головного заголовка (містить логотип та назви)';
$string['pageheaderlayout'] = 'Макет заголовка сторінки';
$string['pageheaderlayoutdesc'] = 'Макет заголовка сторінки. Впливає лише на стиль заголовка. Стиль заголовка два незмінний. Примітка: "Альтернатива" може бути змінена без попередження і все ще знаходиться в розробці.';
$string['pageheaderoriginal'] = 'Оригінал';
$string['passwordplaceholder'] = 'Пароль';
$string['past'] = 'Минуле';
$string['pastcourses'] = 'Минулі курси';
$string['people'] = 'Учасники';
$string['piwikenabled'] = 'Увімкнуто';
$string['piwikenableddesc'] = 'Вмикає відстеження Matomo для Moodle.';
$string['piwikimagetrack'] = 'Відстеження зображень';
$string['piwikimagetrackdesc'] = 'Увімкніть функцію відстеження зображень для Moodle для веб-переглядачів із відключеним JavaScript.';
$string['piwiksettingsdesc'] = 'Створити чисту URL-адресу для розширеного відстеження.';
$string['piwiksettingsheading'] = 'Налаштування Matomo';
$string['piwiksiteid'] = 'Код Сайту';
$string['piwiksiteiddesc'] = 'Вкажіть Код вашого сайту';
$string['piwiksiteurldesc'] = 'Введіть URL-адресу Matomo Analytics без http(s) та кінцевого слешу';
$string['piwiktrackadmin'] = 'Відстеження Адмінів';
$string['piwiktrackadmindesc'] = 'Вмикає відстеження користувачів адміністраторів (не рекомендується)';
$string['portrait'] = 'Книжний';
$string['previousactivity'] = 'Попереднє';
$string['previoussection'] = 'Попередня секція';
$string['printbodyfontsize'] = 'Розмір шрифта тексту';
$string['printbodyfontsizedesc'] = 'Встановлює розмір основного шрифту.';
$string['printlineheight'] = 'Висота рядка';
$string['printlineheightdesc'] = 'Встановлює висоту рядка.';
$string['printmargin'] = 'Зовнішній відступ';
$string['printmargindesc'] = 'Встановлює зовнішній відступ (margin).';
$string['printpageorientation'] = 'Орієнтація сторінки';
$string['printpageorientationdesc'] = 'Встановлює орієнтацію сторінки \'Книжна\' або \'Альбомна\'.';
$string['printsettings'] = 'Друк';
$string['printsettingsdesc'] = 'Встановлює параметри друку.';
$string['printsettingsheading'] = 'Налаштування друку';
$string['properties'] = 'Експорт / Імпорт налаштувань';
$string['propertiesdesc'] = 'В цій секції ви можете здійснити Експорт / Імпорт поточних налаштувань теми Adaptable у форматі JSON. Ви також можете переглянути всі поточні налаштування цієї установки Moodle.';
$string['propertiesexport'] = 'Експортувати властивості як рядок JSON';
$string['propertiesproperty'] = 'Властивість';
$string['propertiesreturn'] = 'Повернути';
$string['propertiessub'] = 'Поточні налаштування теми';
$string['propertiesvalue'] = 'Значення';
$string['putpropertiesadded'] = 'Додано:';
$string['putpropertieschanged'] = 'Змінено:';
$string['putpropertiesdesc'] = 'Вставте рядок JSON і натисніть "Зберегти зміни". Увага! Не перевіряє значення налаштувань і виконує "Очищення всієї кеш-пам\'яті".';
$string['putpropertiesfrom'] = 'з';
$string['putpropertiesheading'] = 'Імпортувати налаштування теми';
$string['putpropertiesignorecti'] = 'Ігнорувати всі налаштування зображення назви курсу.';
$string['putpropertiesignored'] = 'Пропущено:';
$string['putpropertiesname'] = 'Імпортувати властивості';
$string['putpropertiesreportfiles'] = 'Не забувайте завантажувати в налаштування такі файли:';
$string['putpropertiessettingsreport'] = 'Звіт налаштування:';
$string['putpropertiesunchanged'] = 'Незмінно:';
$string['putpropertyour'] = 'Наш';
$string['putpropertyproperties'] = 'Параметри';
$string['putpropertyreport'] = 'Звіт:';
$string['putpropertyversion'] = 'версія:';
$string['region-course-bottom-a'] = 'Нижній регіон сторінки курсу 5';
$string['region-course-bottom-b'] = 'Нижній регіон сторінки курсу 6';
$string['region-course-bottom-c'] = 'Нижній регіон сторінки курсу 7';
$string['region-course-bottom-d'] = 'Нижній регіон сторінки курсу 8';
$string['region-course-section-a'] = 'Діяльності сторінки курсу та нижній регіон';
$string['region-course-tab-one-a'] = 'Регіон 1 вкладки сторінки курсу';
$string['region-course-tab-two-a'] = 'Регіон 2 вкладки сторінки курсу';
$string['region-course-top-a'] = 'Верхній регіон 1 сторінки курсу';
$string['region-course-top-b'] = 'Верхній регіон 2 сторінки курсу';
$string['region-course-top-c'] = 'Верхній регіон 3 сторінки курсу';
$string['region-course-top-d'] = 'Верхній регіон 4 сторінки курсу';
$string['region-frnt-footer'] = 'Підвалини';
$string['region-frnt-market-a'] = 'Регіон 1';
$string['region-frnt-market-b'] = 'Регіон 2';
$string['region-frnt-market-c'] = 'Регіон 3';
$string['region-frnt-market-d'] = 'Регіон 4';
$string['region-frnt-market-e'] = 'Регіон 5';
$string['region-frnt-market-f'] = 'Регіон 6';
$string['region-frnt-market-g'] = 'Регіон 7';
$string['region-frnt-market-h'] = 'Регіон 8';
$string['region-frnt-market-i'] = 'Регіон 9';
$string['region-frnt-market-j'] = 'Регіон 10';
$string['region-frnt-market-k'] = 'Регіон 11';
$string['region-frnt-market-l'] = 'Регіон 12';
$string['region-frnt-market-m'] = 'Регіон 13';
$string['region-frnt-market-n'] = 'Регіон 14';
$string['region-frnt-market-o'] = 'Регіон 15';
$string['region-frnt-market-p'] = 'Регіон 16';
$string['region-frnt-market-q'] = 'Регіон 17';
$string['region-frnt-market-r'] = 'Регіон 18';
$string['region-frnt-market-s'] = 'Регіон 19';
$string['region-frnt-market-t'] = 'Регіон 20';
$string['region-my-tab-one-a'] = 'Регіон 1 вкладки інформаційної панелі';
$string['region-my-tab-two-a'] = 'Регіон 2 вкладки інформаційної панелі';
$string['region-news-slider-a'] = 'Регіон слайдера сторінки курсу';
$string['region-side-post'] = 'Праворуч';
$string['region-side-pre'] = 'Ліворуч';
$string['regionmaincolor'] = 'Колір основного регіону';
$string['regionmaincolordesc'] = 'Встановлює колір тла для головної області контенту.';
$string['rendereroverlaycolor'] = 'Колір накладки';
$string['rendereroverlaycolordesc'] = 'Колір накладки, коли вибрано "Плитки з/ накладкою"';
$string['rendereroverlayfontcolor'] = 'Колір шрифта  накладки';
$string['rendereroverlayfontcolordesc'] = 'Колір шрифта, коли вибрано "Плитки з/ накладкою" і при наведенні на плитку миші.';
$string['responsivebreadcrumb'] = 'Навігаційне меню';
$string['responsivebreadcrumbdesc'] = 'На яких розмірах екранів ви хотіли б показувати навігаційне меню?';
$string['responsivecoursetitle'] = 'Назва курсу / сайту';
$string['responsivecoursetitledesc'] = 'На яких розмірах екранів ви хотіли б показувати назву курсу / сайту?';
$string['responsiveheader'] = 'Головний заголовок';
$string['responsiveheaderdesc'] = 'На яких розмірах екранів ви хотіли б показувати головний заголовок?<br/>Цей параметр застосовується лише в тому випадку, якщо ви використовуєте за замовчуванням / оригінальний 3-рядковий заголовок.<br/>Видалення заголовка повністю також призведе до видалення елементів, що містяться в ньому:<br/><ul><li>Значки соціальних мереж</li><li>Логотип</li><li>Назва курсу / сайту</li></ul>';
$string['responsivelogo'] = 'Логотип';
$string['responsivelogodesc'] = 'На яких розмірах екранів ви хотіли б показувати логотип?';
$string['responsivepagefooter'] = 'Підвалини';
$string['responsivepagefooterdesc'] = 'На яких розмірах екранів ви хотіли б показувати підвалини?';
$string['responsivesectionnav'] = 'Навігація діяльність / секція';
$string['responsivesectionnavdesc'] = 'Показати / приховати <strong>текст</strong> навігації "попереднє" / "наступне" для діяльності / секції на малих екранах. Типово ми приховуємо цей текст на малих екранах залишаючи лише значки посилань <prev> <next>, а не повна назва секції / діяльності.';
$string['responsivesettings'] = 'Чуйний макет';
$string['responsivesettingsdesc'] = 'Тут ви можете контролювати адаптивну поведінку вашого сайту (які елементи показуються на екранах різного розміру).<br/>Типово більшість несуттєвих предметів приховано на мобільних пристроях, тому їх показ відбувається лише на великих екранах.<br/>Ви можете вибрати елементи, які повинні показуватися на менших екранах, вибравши їх показ на "Дуже малому" або "Маленькому екрані".<br/>Щоб краще зрозуміти, як працюють ці налаштування, зверніться до документації Bootstrap 4::<br/><br/>https://getbootstrap.com/docs/4.5/utilities/display/<br/><br/>';
$string['responsivesettingsheading'] = 'Контролює поведінку вашого сайту при різних розмірах екрану';
$string['responsiveslider'] = 'Слайдер першої сторінки';
$string['responsivesliderdesc'] = 'На яких розмірах екранів ви б хотіли показувати слайдер першої сторінки?';
$string['responsivesocial'] = 'Значки соціальних мереж';
$string['responsivesocialdesc'] = 'На яких розмірах екранів ви б хотіли показувати значки соціальних мереж?';
$string['responsivesocialsize'] = 'Встановіть розмір шрифту значків соціальних мереж на мобільному пристрої';
$string['responsivesocialsizedesc'] = 'Для кращого огляду розмір повинен бути на 5 пікселів більшим, ніж бажаний фактичний розмір.';
$string['responsiveticker'] = 'Повідомлення новин';
$string['responsivetickerdesc'] = 'На яких розмірах екранів ви б хотіли показувати повідомлення новин?';
$string['rightblocks'] = 'Праворуч';
$string['savebuttontext'] = 'Зберегти зміни';
$string['searchboxpadding'] = 'Відступи пошукового блоку';
$string['searchboxpaddingdesc'] = 'Встановлює відступ зверху пошукового поля (якщо використовується замість значків соціальних мереж)<br /> Наприклад, 5px 10px 5px 10px (згори, праворуч, знизу, ліворуч).<br> Ви можете встановити значки соціальних мереж на сторінці налаштувань <a href="./../admin/settings.php?section=theme_adaptable_social">Соц.мережі заголовку</a>';
$string['sectionheadingcolor'] = 'Колір тексту секції заголовку';
$string['sectionheadingcolordesc'] = 'Встановлює колір тексту секції заголовку';
$string['sections'] = 'Секції';
$string['selectionbackground'] = 'Колір тла вибору';
$string['selectionbackgrounddesc'] = 'Встановлює колір тла під час вибору тексту на екрані.';
$string['selectiontext'] = 'Колір тексту вибору';
$string['selectiontextdesc'] = 'Встановлює колір тексту під час вибору тексту на екрані.';
$string['settingsalertbox'] = 'Повідомлення';
$string['settingsanalytics'] = 'Аналітика';
$string['settingsblockicons'] = 'Значки';
$string['settingsborders'] = 'Межі';
$string['settingsbreadcrumbcolors'] = 'Кольори навігаційного меню';
$string['settingscolors'] = 'Кольори';
$string['settingscourses'] = 'Курси';
$string['settingsfonts'] = 'Шрифти';
$string['settingsfootercolors'] = 'Кольори підвалин';
$string['settingsforumheading'] = 'Форум';
$string['settingsheadercolors'] = 'Кольори заголовку';
$string['settingsinfoboxcolors'] = 'Кольори інформаційного блоку';
$string['settingsinformation'] = 'Інформація';
$string['settingsmaincolors'] = 'Основні кольори';
$string['settingsmarketingcolors'] = 'Кольори маркетингового блоку';
$string['settingsmessagescolors'] = 'Кольори виринаючих повідомлень';
$string['settingsmobilecolors'] = 'Кольори на мобільних';
$string['settingsnavbarcolors'] = 'Кольори Навігаційної панелі';
$string['settingsoverlaycolors'] = 'Кольори накладки плиток';
$string['settingssecondinfoboxcolors'] = 'Кольори другого інформаційного блоку';
$string['settingstopicsweeks'] = 'Теми / Тижні';
$string['show'] = 'Показати';
$string['showfooterblocks'] = 'Показати блоки підвалин';
$string['showfooterblocksdesc'] = 'Показує / приховує чотири блоки в підвалинах';
$string['shownavigationblockoncoursepagedesc'] = 'Відмітьте це для показу блоку навігації на сторінці курсу.';
$string['showusername'] = 'Показувати псевдо';
$string['showusernamedesc'] = 'Показує псевдоім’я користувача в меню користувача на панелі навігації.';
$string['side-post1'] = 'блоки в підвалини';
$string['sidebaricon'] = 'Показати / приховати бічну панель';
$string['sitelinkslabel'] = 'Посилання сайту';
$string['sitetitle'] = 'Показати назву сайту';
$string['sitetitlecoursesdisabled'] = 'Вимкнено - показувати лише назви курсів на сторінках курсів';
$string['sitetitlecoursesenabled'] = 'Увімкнено - показувати назву сайту та назви курсів на сторінках курсів';
$string['sitetitlecustom'] = 'Використовувати власну назву сайту (введіть у текстове поле нижче)';
$string['sitetitledefault'] = 'Використовувати назву сайту Moodle (назву сайту)';
$string['sitetitledesc'] = 'Показує типову назву сайту з <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Налаштувань Головної сторінки</a> або введіть власну назву сайту в текстове поле нижче. Якщо ви додаєте зображення логотипу, то назва не показується.';
$string['sitetitleoff'] = 'Відключити назву сайту';
$string['sitetitletext'] = 'Назва сайту';
$string['sitetitletextdesc'] = 'Назва сайту показується в заголовку. Ви можете використовувати будь-який тег HTML і застосовувати вбудовані стилі. Рекомендується використовувати тег <b>h1</b>  навколо назви, а не тег <b>p</b>, який додається як типовий, коли ви вводите щось у цьому полі.';
$string['slider2h3bgcolor'] = 'Слайдер 2: колір тла H3';
$string['slider2h3bgcolordesc'] = 'Змінює колір тла для тега H3 в Слайдері 2';
$string['slider2h3color'] = 'Слайдер 2: колір тексту H3';
$string['slider2h3colordesc'] = 'Змінює колір тексту для тега H3 в Слайдері 2';
$string['slider2h4bgcolor'] = 'Слайдер 2: колір тла H4';
$string['slider2h4bgcolordesc'] = 'Змінює колір тла для тега H4 в Слайдері 2';
$string['slider2h4color'] = 'Слайдер 2: колір тексту H4';
$string['slider2h4colordesc'] = 'Змінює колір тексту для тега H4 в Слайдері 2';
$string['slidercaption'] = 'Підпис слайду';
$string['slidercaptiondesc'] = 'Додає підпис до слайду';
$string['slidercount'] = 'Кількість слайдів';
$string['slidercountdesc'] = 'Виберіть скільки слайдів потрібно додати <strong>, а потім натисніть "ЗБЕРЕГТИ" </strong>, щоб завантажити поля введення';
$string['sliderenabled'] = 'Увімкнути слайдер';
$string['sliderenableddesc'] = 'Вмикає слайдер на головній сторінці сайту';
$string['sliderfullscreen'] = 'Повноекранний слайдер';
$string['sliderfullscreendesc'] = 'Відмітьте це, щоб слайдер розширився на весь екран (100% ширини)';
$string['sliderh3color'] = 'Слайдер 1: колір H3';
$string['sliderh3colordesc'] = 'Змінює колір для тега H3 в Слайдері 1';
$string['sliderh4color'] = 'Слайдер 1: колір H4';
$string['sliderh4colordesc'] = 'Змінює колір для тега H4 в Слайдері 1';
$string['sliderimage'] = 'Картинка слайду';
$string['sliderimagedesc'] = 'Додає картинку до слайду. Рекомендується розмір 1600px x 400px або більше.';
$string['slidermarginbottom'] = 'Відступ під слайдером';
$string['slidermarginbottomdesc'] = 'Встановлює розмір відступу під слайдером.';
$string['slidermargintop'] = 'Відступ над слайдером';
$string['slidermargintopdesc'] = 'Встановлює розмір відступу над слайдером.';
$string['slideroption2'] = 'Виберіть тип слайдера';
$string['slideroption2a'] = 'Слайдер 2: колір тла стрілки';
$string['slideroption2adesc'] = 'Встановлює колір тла стрілки в слайдері типу 2';
$string['slideroption2color'] = 'Слайдер 2: тло Submit';
$string['slideroption2colordesc'] = 'Встановлює колір тла для тексту кнопки з  класом submit в стилі слайдера';
$string['slideroption2desc'] = 'Виберіть тип слайдера, а потім натисніть ЗБЕРЕГТИ, щоб переглянути налаштування кольору для вибраного типу слайдеру';
$string['slideroption2submitcolor'] = 'Слайдер 2: текст Submit';
$string['slideroption2submitcolordesc'] = 'Встановлює колір тла для тексту кнопки з  класом submit в стилі слайдера типу 2';
$string['sliderstyle1'] = 'Слайдер типу 1';
$string['sliderstyle2'] = 'Слайдер типу 2';
$string['slidersubmitbgcolor'] = 'Слайдер 1: тло Submit';
$string['slidersubmitbgcolordesc'] = 'Встановлює колір тла для тексту кнопки з  класом submit в стилі слайдера типу 1';
$string['slidersubmitcolor'] = 'Слайдер 1: текст Submit';
$string['slidersubmitcolordesc'] = 'Встановлює колір тексту для тексту кнопки з  класом submit в стилі слайдера типу 1';
$string['sliderurl'] = 'URL посилання слайду';
$string['sliderurldesc'] = 'Додає URL-адресу , на яку посилається слайд, коли на нього натискаєте.';
$string['slideshowdesc'] = 'Завантажте зображення, додайте посилання та опис слайдера на першій сторінці.';
$string['slideshowsettings'] = 'Слайдшоу';
$string['slideshowsettingsheading'] = 'Налаштуйте слайдшоу на першій сторінці. Див. шаблон <a href="./../theme/adaptable/pix/layout.png" target="_blank"> тут</a>';
$string['socialheading'] = 'Налаштування соціальних значків';
$string['socialicondesc'] = 'Встановіть значки з Font Awesome, наприклад, fa-facebook';
$string['socialiconlist'] = 'Список соціальних значків';
$string['socialiconlistdesc'] = 'Введіть список із роздільниками, щоб налаштувати потрібні соціальні значки / посилання, використовуючи формат: url|title|icon';
$string['socialpaddingside'] = 'Відрегулюйте внутрішній відступ значків соціальних мереж';
$string['socialpaddingsidedesc'] = 'Це буде простір між значком та іншим елементом або проміжок між двома значками. тобто відступ від значка матиме значення, поділене на два. Типове значення відповідає вимогам щодо брендингу Instagram.';
$string['socialpaddingtop'] = 'Налаштуйте внутрішній відступ над значками соціальних мереж (змінює вертикальну позицію)';
$string['socialpaddingtopdesc'] = 'Це буде мінімум 15 пікселів (встановлюється з використанням поля) плюс це значення.';
$string['socialsearchicon'] = 'Пошук Moodle';
$string['socialsearchicondesc'] = 'Вмикає можливість розміщувати посилання для пошуку поряд із соціальними піктограмами';
$string['socialsettings'] = 'Соц.мережі заголовку';
$string['socialsize'] = 'Встановіть розмір шрифта соціальних значків';
$string['socialsizedesc'] = 'Для кращого огляду розмір повинен бути на 5 пікселів більшим, ніж бажаний фактичний розмір.';
$string['socialtarget'] = 'Як відкривати соціальні посилання';
$string['socialtargetdesc'] = 'Як би ви хотіли відкривати соціальні посилання (одне або нове вікно)';
$string['socialtitledesc'] = 'Ви можете вимкнути поле пошуку та включити значки соціальних мереж на цьому місці. Щоб налаштувати піктограми, введіть список посилань на сайти  соціальних мереж у поле "Список соціальних значків" нижче. Це має бути у форматі: url|title|icon. Наприклад: <pre> https://example.com/course/search.php|Search Moodle|fa-search https://facebook.com/|Facebook|fa-facebook-square https://twitter.com/|Twitter|fa-twitter-square https://instagram.com|Instagram|fa-instagram https://example.com|My Web|fa-globe </pre> Для довідки ви можете ознайомитися з повним переліком <a href="https://fortawesome.github.io/Font-Awesome/icons/">Значків Font Awesome</a>';
$string['standard'] = 'Стандартний';
$string['standardscreenwidth'] = 'Стандартна ширина екрану.';
$string['standardscreenwidthdesc'] = 'Встановіть ширину екрана при перемиканні на "стандартний" вигляд (також див. Відповідні налаштування enablezoom та defaultzoom).';
$string['standardview'] = 'Стандартний вид';
$string['static'] = 'Статичний';
$string['stickynavbar'] = 'Закріпити навігаційну панель';
$string['stickynavbardesc'] = 'Закріплює навігаційну панель нагорі екрану, коли прокручуємо сторінку донизу.';
$string['stylecover'] = 'Обкладинка';
$string['stylestretch'] = 'Резиновий';
$string['tabbedlayoutcoursepage'] = 'Макет вкладок сторінки курсу';
$string['tabbedlayoutcoursepagedesc'] = 'Використовує макет із вкладками для сторінки курсу. Це показує весь вміст на вкладках, з вмістом курсу на одній вкладці та дозволяє адаптувати вміст на інших вкладках. Використовуйте цей параметр для налаштування порядку вкладок.';
$string['tabbedlayoutcoursepagelink'] = 'Посилання на курс з вкладок';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Надайте посилання назад на вкладку головної сторінки курсу з інших вкладок курсу.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Колір вибраної вкладки для сторінки курсу';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Виберіть колір для вибраної вкладки.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Колір не вибраної вкладки для сторінки курсу';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Виберіть колір для не вибраної вкладки.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Час збереження вкладки головної сторінки курсу';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'Вкладка головної сторінки курсу зберігається на вибраній вкладці під час оновлення протягом періоду бездіяльності. Встановіть тут період бездіяльності. Наприклад, встановіть значення 30 так, щоб перша вкладка була обрана після 30 хвилин бездіяльності.';
$string['tabbedlayoutdashboard'] = 'Макет вкладок інформаційної панелі';
$string['tabbedlayoutdashboarddesc'] = 'Використовуйте макет із вкладками для сторінки інформаційної панелі. Це показує весь вміст на вкладках, з вмістом курсу на одній вкладці та дозволяє адаптувати вміст на інших вкладках. Використовуйте цей параметр для налаштування порядку вкладок.';
$string['tabbedlayoutdashboardtab1condition'] = 'Вкладка 1 Обмеження за спеціальним полем користувача (додатково)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Додайте правило доступу для показу Вкладки 1 за допомогою спеціального поля профілю, наприклад: showtab1 = true.';
$string['tabbedlayoutdashboardtab2condition'] = 'Вкладка 2 Обмеження за спеціальним полем користувача (додатково)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Додайте правило доступу для показу Вкладки 2 за допомогою спеціального поля профілю, наприклад: showtab2 = true.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Колір вибраної вкладки Інформаційної панелі';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Виберіть колір для вибраної вкладки.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Колір не вибраної вкладки Інформаційної панелі';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Виберіть колір для не вибраної вкладки.';
$string['tabbedlayoutheading'] = 'Адаптивний макет із вкладками';
$string['tabbedlayouttablabelcourse'] = 'Вміст курсу';
$string['tabbedlayouttablabelcourse1'] = 'Вкладка 1';
$string['tabbedlayouttablabelcourse2'] = 'Вкладка 2';
$string['tabbedlayouttablabeldashboard'] = 'Вміст інформаційної панелі';
$string['tabbedlayouttablabeldashboard1'] = 'Вкладка 1';
$string['tabbedlayouttablabeldashboard2'] = 'Вкладка 2';
$string['targetnewwindow'] = 'Нове вікно';
$string['targetsamewindow'] = 'Це ж вікно';
$string['templatesheading'] = 'Налаштування шаблонів';
$string['templatesheadingdesc'] = 'Замінити шаблони.';
$string['templatessel'] = 'Шаблони для заміни';
$string['templatesseldesc'] = 'Виберіть шаблони, які потрібно замінити, і кожен з них буде показано на своїй сторінці. Якщо тут не обрано, шаблон не буде замінено, навіть якщо він увімкнений. Щоб не вибрати жодного, використовуйте клавішу "Ctrl".';
$string['templatessettings'] = 'Шаблони';
$string['themechanges'] = 'Зміни';
$string['thiscourse'] = 'Цей курс';
$string['ticker'] = 'Оголошення';
$string['tickerdefault'] = 'Немає повідомлень для показу';
$string['tickerdesc'] = 'Тут ви можете встановити інформаційну стрічку, яка буде показана на Головній сторінці вашого сайту Moodle. Вона призначена як менш нав\'язлива альтернатива слайдеру, як така, що займає дуже мало місця. Щоб налаштувати вашу стрічку, просто введіть список абзаців і вкажіть будь-які гіперпосилання, які потрібно в цьому тексті. <strong>Зауваження:</strong> Якщо ваша стрічка не завантажується належним чином, перейдіть до перегляду HTML і переконайтеся, що ви використовуєте лише теги p: <pre> &lt;p&gt;Якась новина один.....&lt;/p&gt; &lt;p&gt;Якась новина два.....&lt;/p&gt; </pre>';
$string['tickerfullscreen'] = 'Ширина Повного екрану';
$string['tickersettings'] = 'Текстові новини';
$string['tickersettingsheading'] = 'Встановлює текстові новини на Головній сторінці. Див. варіант макету <a href="./../theme/adaptable/pix/layout.png" target="_blank"> тут</a>';
$string['tickertext'] = 'Текст новин';
$string['tickertextdesc'] = 'Додає текст новин у форматі списку. Див. readme для додаткової інформації.';
$string['tickertextprofilefield'] = 'Назва спеціального поля профілю = Значення (необов\'язково)';
$string['tickertextprofilefielddesc'] = 'Додайте правило доступу, використовуючи спеціальне поле профілю користувача. Наприклад, usertype=student';
$string['tickerwidth'] = 'Фіксована ширина';
$string['tickerwidthdesc'] = 'Це налаштування можна використовувати для визначення блоку новин на 100% ширини.';
$string['tilesbordercolor'] = 'Колір тла плитки курсу';
$string['tilesbordercolordesc'] = 'Встановлює колір тла плитки курсу в списку курсів';
$string['tilescontactstitle'] = 'Показати контакти курсу';
$string['tilescontactstitledesc'] = 'Показати / приховати роль з курсу для контакту . Якщо не показується, перед кожним з контактів буде зображення';
$string['tilesshowallcontacts'] = 'Показати всі контакти курсу';
$string['tilesshowallcontactsdesc'] = 'Показує всі контакти курсу або лише один';
$string['tilesshowcontacts'] = 'Показати контакти курсу';
$string['tilesshowcontactsdesc'] = 'Показати / приховати контакти курсів';
$string['togglenavigation'] = 'Перемикнути навігацію';
$string['toolsmenu'] = 'Спадне меню інструментів';
$string['toolsmenudesc'] = 'Додає спадне меню до головної навігаційної панелі';
$string['toolsmenufield'] = 'Назва поля профілю користувача = Значення (необов\'язково)';
$string['toolsmenufielddesc'] = 'Додайте правило доступу, використовуючи спеціальне поле профілю користувача. Наприклад, usertype=student';
$string['toolsmenuheading'] = 'Меню інструментів';
$string['toolsmenuheadingdesc'] = 'Можна налаштувати посилання для показу в меню інструментів (на головній навігаційній панелі). Формат для цього аналогічний формату, який використовується для користувацьких меню Moodle, але дозволяє додавати значки fa до елементів меню: <pre> &lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen &lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock &lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock </pre><br />';
$string['toolsmenuscount'] = 'Кількість меню інструментів';
$string['toolsmenuscountdesc'] = 'Встановлює кількість меню інструментів, які потрібно додати до головної навігаційної панелі';
$string['toolsmenutitle'] = 'Назва меню інструментів';
$string['toolsmenutitledefault'] = 'Інструменти';
$string['toolsmenutitledesc'] = 'Додайте назву меню, яке ви хотіли б показати на головній навігаційній панелі';
$string['topicsweeks'] = 'Тематичний / Тижневий формат курсу';
$string['topicsweeksdesc'] = 'Встановлює стилі для Тематичного / Тижневого формату курсів';
$string['topmenufontsize'] = 'Розмір шрифта верхнього меню';
$string['topmenufontsizedesc'] = 'Відрегулюйте розмір шрифту верхнього меню';
$string['topmenuscount'] = 'Кількість верхній меню';
$string['topmenuscountdesc'] = 'Встановлює кількість меню, які потрібно додати до заголовка теми';
$string['turngradereditingoff'] = 'Вимкнути редагування оцінювача';
$string['turngradereditingon'] = 'Увімкнути редагування оцінювача';
$string['usermenu'] = 'Меню користувача';
$string['usernameposition'] = 'Позиція імені користувача';
$string['usernamepositiondesc'] = 'Встановлює позицію імені користувача, "ліворуч" або "праворуч".';
$string['usernav'] = 'Заголовок користувача';
$string['usernavdesc'] = 'Дозволяє керувати всіма елементами, які показуються у спадному списку навігації користувача.';
$string['usernavheading'] = 'Налаштуйте спадне меню навігації користувача';
$string['usernodescription'] = 'Користувач ще не заповнив це поле';
$string['usernointerests'] = 'Користувач ще не оновив свої інтереси.';
$string['usersettings'] = 'Профайл користувача';
$string['usersettingsdesc'] = 'Встановлює налаштування для профайлу користувача.';
$string['usersettingsheading'] = 'Керування аспектами профайлу користувача';
$string['versioninfo'] = 'Випуск {$a->release}, версія {$a->version} для Moodle {$a->moodle}';
$string['wide'] = 'Повноекранний';
