<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_db', language 'sr_cr', version '4.1'.
 *
 * @package     auth_db
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_dbcannotconnect'] = 'Није могуће повезати се са екстерном базом података.';
$string['auth_dbcannotreadtable'] = 'Није могуће прочитати екстерну табелу.';
$string['auth_dbcantconnect'] = 'Није било могуће поветати се наведеном базом података за проверу идентитета...';
$string['auth_dbchangepasswordurl_key'] = 'URL за промену лозинке';
$string['auth_dbcolumnlist'] = 'Екстерна табела садржи следеће колоне:<br />{$a}';
$string['auth_dbdebugauthdb'] = 'Отклоните ADOdb грешку';
$string['auth_dbdebugauthdbhelp'] = 'Отклоните грешку у ADOdb конекцији са екстерном базом података - употребите у ситуацији када током пријаве на систем добијате празну страницу. Није погодно за сајтове на којима има активних курсева.';
$string['auth_dbdeleteuser'] = 'Обрисани корисник {$a->name} id {$a->id}';
$string['auth_dbdeleteusererror'] = 'Грешка приликом брисања корисника {$a}';
$string['auth_dbdescription'] = 'Овај метод користи екстерне табеле базе података за проверу да ли су дато корисничко име и лозинка исправни. Уколико је налог нов, онда информација из других поља могу бити прекопиране у Moodle.';
$string['auth_dbextencoding'] = 'Кодни распоред екстерне базе података';
$string['auth_dbextencodinghelp'] = 'Кодни распоред коришћен у екстерној бази података';
$string['auth_dbextrafields'] = 'Ова поља су опциона. Можете да изаберете да претходно попуните нека Moodle корисничка поља са информацијам из <b>поља екстерне база података</b> која овде наведете.<p>Уколико ова поља оставите празна, биће коришћене подразумеване вредности.</p><p>У сваком случају корисни ће моћи да уређују сва ова поња након што се пријаве на систем.</p>';
$string['auth_dbfieldpass'] = 'Име поља које садржи лозинке';
$string['auth_dbfieldpass_key'] = 'Поље за лозинку';
$string['auth_dbfielduser'] = 'Назив поља које садржи корисничка имена. Ово поље мора бити varchar тип података';
$string['auth_dbfielduser_key'] = 'Поље корисничког имена';
$string['auth_dbhost'] = 'Овај рачунар је домаћин сервера базе података. Употребите системски DSN унос ако користите ODBC. Употребите PDO DSN унос ако користите PDO.';
$string['auth_dbhost_key'] = 'Рачунар домаћин';
$string['auth_dbinsertuser'] = 'Уметнути корисник {$a->name} id {$a->id}';
$string['auth_dbinsertuserduplicate'] = 'Грешка приликом убацивања корисника  {$a->username} - корисник са овим корисничким именом већ је креиран помоћу додатка за проверу идентитета \'{$a->auth}\' .';
$string['auth_dbinsertusererror'] = 'Грешка приликом убацивања корисника {$a}';
$string['auth_dbname'] = 'Назив саме базе података. Оставите празно ако користите ODBC DSN. Оставите празно ако ваш PDO DSN већ садржи назив базе података.';
$string['auth_dbname_key'] = 'Назив базе података';
$string['auth_dbnoexttable'] = 'Екстерна табела није наведена.';
$string['auth_dbnouserfield'] = 'Поље екстерног корисника није наведено.';
$string['auth_dbpass'] = 'Лозинка се поклапа са горњим корисничким именом';
$string['auth_dbpass_key'] = 'Лозинка';
$string['auth_dbpasstype'] = '<p>Одредите формат које користи поље за лозинку..</p> <p>Употребите "интерно" уколико желите да спољна база података управља корисничким именима и електронским адресама, а Moodle лозинкама. Ако користите формат "интерно", <i>морате</i> да обезбедите поља попуњена електронским адресама у екстерној бази података. Такође, морате да омогућите планирани задатак  \\auth_db\\task\\sync_users. Moodle ће новим корисницима послати е-поруку са привременом лозинком.</p>';
$string['auth_dbpasstype_key'] = 'Формат лозинке';
$string['auth_dbreviveduser'] = 'Поново активирани корисник {$a->name} id {$a->id}';
$string['auth_dbrevivedusererror'] = 'Грешка у поновном активирању корисника {$a}';
$string['auth_dbsaltedcrypt'] = 'Криптуј једносмерно хешовање стринга';
$string['auth_dbsetupsql'] = 'SQL команда поставаљања';
$string['auth_dbsetupsqlhelp'] = 'SQL команда за посебно подешавање базе података, често коришћена за подешавање кодног распоред - на пример за MySQL и PostgreSQL: <em>SET NAMES \'utf8\'</em>';
$string['auth_dbsuspenduser'] = 'Суспендовани корисник {$a->name} id {$a->id}';
$string['auth_dbsuspendusererror'] = 'Грешка приликом суспендовања корисника {$a}';
$string['auth_dbsybasequoting'] = 'Користи наводнике Sybase базе података';
$string['auth_dbsybasequotinghelp'] = 'Sybase стил излаза једноструким наводницима - потребно за Oracle, MS SQL и неке друге базе података. Не користити за  MySQL!';
$string['auth_dbsyncuserstask'] = 'Синхронизација корисника';
$string['auth_dbtable'] = 'Име табеле у бази података';
$string['auth_dbtable_key'] = 'Табела';
$string['auth_dbtableempty'] = 'Екстерна табела је празна.';
$string['auth_dbtype'] = 'Тип базе података (за више информација погледајте документацију <a href="http://adodb.org/dokuwiki/doku.php" target="_blank">ADOdb - Database Abstraction Layer for PHP</a>)';
$string['auth_dbtype_key'] = 'База података';
$string['auth_dbupdateerror'] = 'Грешка при ажурирању спољне базе података.';
$string['auth_dbupdateusers'] = 'Ажурирај кориснике';
$string['auth_dbupdateusers_description'] = 'Осим што убацује нове, ажурира и постојеће кориснике';
$string['auth_dbupdatinguser'] = 'Ажурирање корисника {$a->name} id {$a->id}';
$string['auth_dbuser'] = 'Корисничко име са правом читања базе података';
$string['auth_dbuser_key'] = 'Корисник базе података';
$string['auth_dbuserstoadd'] = 'Корисничких уноса за додавање: {$a}';
$string['auth_dbuserstoremove'] = 'Корисничких уноса за уклањање: {$a}';
$string['pluginname'] = 'Екстерна база података';
$string['privacy:metadata'] = 'Додатак за проверу идентитета Екстерна база не чува никакве личне податке.';
