<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'sr_cr', version '4.1'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Брисање активност у току...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" није исправна вредност за године.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" има више или мање од једног зареза (граничника)';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" није исправна вредност за земљу (државу)';
$string['agedigitalconsentmapinvaliddefault'] = 'Подразумевана вредност (*) недостаје.';
$string['agelocationverificationdisabled'] = 'Потврда узраста и места онемогућена';
$string['alreadyloggedin'] = 'Већ сте пријављени као {$a}. Потребно је да се одјавите пре него што се пријавите под другим корисничким именом.';
$string['authnotexisting'] = 'Додатак за проверу идентитета не постоји';
$string['backupcontainexternal'] = 'Ова датотека резервне копије садржи спољашње Moodle мрежне сервере који нису локално подешени';
$string['backuptablefail'] = 'Табеле резервнре копије нису могле бити успешно подешене!';
$string['blockcannotconfig'] = 'Овај блок не подржава глобалну конфигурацију';
$string['blockcannotinistantiate'] = 'Проблем приликом креирања инстанце објекта блока';
$string['blockcannotread'] = 'Није било могуће прочитати податке за blockid= {$a}';
$string['blockdoesnotexist'] = 'Овај блок не постоји';
$string['blockdoesnotexistonpage'] = 'Овај блок (id={$a->instanceid}) не постоји на овој страници ({$a->url}).';
$string['blocknameconflict'] = 'Конфликт у називу: блок {$a->name} има исти наслов као и постојећи блок: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Функција "Повратни коментар" (Comment callback) је одбила овај коментар';
$string['cannotaddcoursemodule'] = 'Није било могуће додати нови модул';
$string['cannotaddcoursemoduletosection'] = 'Није било могуће додати нови модул у ову секцију';
$string['cannotaddmodule'] = '{$a} модул није могао бити додат листи модула!';
$string['cannotaddnewmodule'] = 'Није било могуће додати нови модул {$a}';
$string['cannotaddrss'] = 'Немате дозволу да додајете РСС изворе вести';
$string['cannotaddthisblocktype'] = 'Не можете да додате блок {$a} на ову страницу.';
$string['cannotassignrole'] = 'Није могуће доделити улогу на нивоу курса';
$string['cannotassignrolehere'] = 'Није Вам дозвољено да додељујете ову улогу (id = {$a->roleid}) у овом контексту ({$a->context})';
$string['cannotassignselfasparent'] = 'Није могуће себи доделити надређену улогу';
$string['cannotcallscript'] = 'Не можете да позовете овај скрипт на тај начин';
$string['cannotcallusgetselecteduser'] = 'Не можете да позовете user_selector::get_selected_user уколико је опција multiselect укључена';
$string['cannotcreatebackupdir'] = 'Није било могуће креирати директоријум за резервну копију података. Администратор сајта мора да реши тај проблем';
$string['cannotcreatecategory'] = 'Категорија није убачена';
$string['cannotcreatedboninstall'] = '<p>Није могуће креирати базу података.</p> <p>Наведена база не постоји, а дати корисник нема овлашћења да креира базу података.</p> <p>Администратор сајта треба да провери конфигурацију базе података.</p>';
$string['cannotcreategroup'] = 'Грешка приликом креирања групе';
$string['cannotcreatelangbase'] = 'Грешка: Није било могуће креирати основни директоријум језика';
$string['cannotcreatelangdir'] = 'Није могуће креирати директоријум језика';
$string['cannotcreateorfindstructs'] = 'Грешка у проналажењу или креирању стурктуре секција за овај курс';
$string['cannotcreatepopupwin'] = 'Недефинисани елемент - није могуће креирати искачући прозор';
$string['cannotcreatesitedir'] = 'Није могуће креирати директоријум сајта. Администратор сајта мора да реши тај проблем';
$string['cannotcreatetempdir'] = 'Није могуће креирати привремени директоријум';
$string['cannotcreateuploaddir'] = 'Није могуће креирати директоријум за постављање датотека. Администратор сајта мора да реши тај проблем';
$string['cannotcustomisefiltersblockuser'] = 'Не можете да прилагодите подешавања филтера у контексту корисника односно у контексту блока.';
$string['cannotdeletebackupids'] = 'Није било могуће обрисати ид ознаке претходних резервних копија';
$string['cannotdeletecategorycourse'] = 'Није успело брисање курса \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'Није било могуће обрисати питања из категорије  \'{$a}\'';
$string['cannotdeletecourse'] = 'Немате дозволу да обришете овај курс';
$string['cannotdeletecustomfield'] = 'Грешка при брисању прилагођеног поља података';
$string['cannotdeletedir'] = 'Није могуће обрисати ({$a})';
$string['cannotdeletefile'] = 'Није могуће обрисати ову датотеку';
$string['cannotdeleterole'] = 'Не  може бити обрисано због {$a}';
$string['cannotdeleterolewithid'] = 'Није могуће обрисати улогу са ИД {$a}';
$string['cannotdeletethisrole'] = 'Не можете да обришете ову улогу зато што је користи систем или је то последња улога са администраторским нивоом приступа.';
$string['cannotdisableformat'] = 'Подразумевани формат не може бити онемогућен.';
$string['cannotdownloadcomponents'] = 'Није могуће преузети компоненте.';
$string['cannotdownloadlanguageupdatelist'] = 'Није могуће преузети списак ажурираних језика са download.moodle.org';
$string['cannotdownloadzipfile'] = 'Није могуће преузети архиву';
$string['cannoteditcomment'] = 'Овај коментар није ваш и не можете да га уређујете!';
$string['cannoteditcommentexpired'] = 'Не можете ово да уређујете. Време је истекло!';
$string['cannoteditpostorblog'] = 'Не можете да постујете или уређујете блог';
$string['cannoteditsiteform'] = 'Не можете уредити курс сајта користећи овај образац';
$string['cannotedituserpreferences'] = 'Не могу се мењати преференције овог корисника';
$string['cannotedityourprofile'] = 'Опростите, али не можете да уређујете свој профил';
$string['cannotexecduringupgrade'] = 'Не може се извршити у току надоградње';
$string['cannotfindcategory'] = 'Није могуће пронаћи запис у бази о категорији чији је идентификатор {$a}';
$string['cannotfindcomponent'] = 'Није могуће пронаћи компоненту.';
$string['cannotfindcontext'] = 'Није могуће пронаћи контекст.';
$string['cannotfindcourse'] = 'Није могуће пронаћи курс';
$string['cannotfinddocs'] = 'Није могуће пронаћи датотеке документације за "{$a}" језик';
$string['cannotfindgradeitem'] = 'Није могуће наћи grade_item';
$string['cannotfindgroup'] = 'Није могуће наћи групу';
$string['cannotfindhelp'] = 'Није могуће пронаћи датотеке помоћи за "{$a}" језик.';
$string['cannotfindinfo'] = 'Није могуће наћи информације за: "{$a}"';
$string['cannotfindlang'] = 'Није могуће пронаћи "{$a}" језички пакет!';
$string['cannotfindteacher'] = 'Није могуће пронаћи предавача';
$string['cannotfinduser'] = 'Није могуће пронаћи корисника по имену "{$a}"';
$string['cannotgeoplugin'] = 'Није могуће успоставити везу са geoPlugin сервером на https://www.geoplugin.com. Молимо, проверите подешавања прокси сервера или инсталирајте датотеку за MaxMind GeoLite City.';
$string['cannotgetblock'] = 'Није могуће приступити блоковима у бази података';
$string['cannotgetcats'] = 'Није могуће добити запис категорије';
$string['cannotgetdata'] = 'Није могуће добити податак';
$string['cannotgradeuser'] = 'Није могуће оценити овог корисника';
$string['cannothaveparentcate'] = 'Категорија курса не може имати надређену категорију!';
$string['cannotimport'] = 'Грешка приликом увоза';
$string['cannotimportformat'] = 'Опростите, али увоз овог формата још увек није имплементиран';
$string['cannotimportgrade'] = 'Грешка у увозу оцена';
$string['cannotinsertgrade'] = 'Није могуће убацити ставку оцене без ID ознаке курса!';
$string['cannotinsertrate'] = 'Није било могуће убацити ново оцењивање ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Није могућ унос ID за нови запис: {$a}';
$string['cannotmailconfirm'] = 'Грешка у слању е-поруке за потврду промене лозинке';
$string['cannotmanualctrack'] = 'Није подржано ручно праћење завршетка ове активности';
$string['cannotmapfield'] = 'Откривена је колизија приликом мапирања - два поља мапирају исту ставку оцене {$a}';
$string['cannotmarktopic'] = 'Није било могуће означити ту тему за овај курс';
$string['cannotmigratedatacomments'] = 'Није могуће мигрирати коментаре модула података';
$string['cannotmodulename'] = 'Није могуће добити назив модула приликом креирања навигације';
$string['cannotmoduletype'] = 'Није могуће добити тип модула приликом креирања навигације';
$string['cannotmovecategory'] = 'Категорија се не може преместити';
$string['cannotmovecourses'] = 'Није могуће преместити курсеве из категорије у којој се налазе у другу категорију.';
$string['cannotmoverolewithid'] = 'Није могуће преместити улогу са ID {$a}';
$string['cannotopencsv'] = 'Није могуће отвориту CSV датотеку';
$string['cannotopenfile'] = 'Није могуће отворити датотеку ({$a})';
$string['cannotopenforwrit'] = 'Није могуће отворити за упсисивање: {$a}';
$string['cannotopentemplate'] = 'Није могуће отворити датотеку шаблона ({$a})';
$string['cannotopenzip'] = 'Није могуће отворити zip архиву, вероватно због грешке са zip екстензијом на 64-битном оперативном систему.';
$string['cannotoverridebaserole'] = 'Није могуће мењати основне могућности улоге';
$string['cannotoverriderolehere'] = 'Није Вам дозвљено да мењате ову улогу (id = {$a->roleid}) у овом контексту ({$a->context})';
$string['cannotreadfile'] = 'Није могуће прочитати датотеку ({$a})';
$string['cannotreadtmpfile'] = 'Грешка приликом читања привремене датотеке';
$string['cannotreaduploadfile'] = 'Није било могуће прочитати постављену датотеку';
$string['cannotremovefrommeta'] = 'Ннје било могуће уклонити изабрани курс из овог метакурса!';
$string['cannotreprocessgrades'] = 'Није могуће поново обрадити оцене за активност {$a}';
$string['cannotresetguestpwd'] = 'Не можете да ресетујете лозинку госта';
$string['cannotresetmail'] = 'Грешка приликом ресетовања лозинке и њеног слања на Вашу електронску адресу';
$string['cannotresetthisrole'] = 'Није могуће ресетовати ову улогу';
$string['cannotrestore'] = 'Појавила се грешка те пороцес рестаурације не може бити завршен!';
$string['cannotrestoreadminorcreator'] = 'Морате да буде креатор курса или администратор како би рестаурацију резервне копије у нови курс';
$string['cannotrestoreadminoredit'] = 'Морате да буде предавач или администратор како би рестаурацију резервне копије у изабрани курс';
$string['cannotsaveagreement'] = 'Није било могуће сачувати Ваш споразум';
$string['cannotsaveblock'] = 'Грешка приликом покушаја да се сачува конфигурација блока';
$string['cannotsavecomment'] = 'Није могуће сачувати коментар';
$string['cannotsavedata'] = 'Није могуће сачувати податке';
$string['cannotsavefile'] = 'Није могуће сачувати датотеку "{$a}"!';
$string['cannotsavemd5file'] = 'Није могуће сачувати md5 датотеку.';
$string['cannotsavezipfile'] = 'Није могуће сачувти ZIP архиву.';
$string['cannotservefile'] = 'Није могуће приказати датотеку због проблема са конфигурацијом сервера.';
$string['cannotsetparentforcatoritem'] = 'Није могуће поставити надређену категорију или курс';
$string['cannotsetpassword'] = 'Није могуће подесити корисничку лозинку!';
$string['cannotsetprefgrade'] = 'Није могуће поставити параметар aggregationview на {$a} за ову категорију оцена.';
$string['cannotsettheme'] = 'Није могуће подесити шемзу изгледа';
$string['cannotsetupblock'] = 'НИЈЕ било могуће успешно подесити табеле блокова !';
$string['cannotsetupcapformod'] = 'Није било могуће подесити могућности за  {$a}';
$string['cannotsetupcapforplugin'] = 'Није било могуће подесити могућности за  {$a}';
$string['cannotshowhidecoursesincategory'] = 'Није могуће приказати/сакрити курсеве у категорији {$a}';
$string['cannotsignup'] = 'Не можете креирати нови налог јер сте већ улоговани као {$a}.';
$string['cannotswitcheditmodeon'] = 'Није могуће укључити режим уређивања';
$string['cannotunassigncap'] = 'Није могуће уклонити застарелу способност {$a->cap} из улоге {$a->role}';
$string['cannotunassignrolefrom'] = 'Није могуће овом кориснику уклонити id улогe: {$}';
$string['cannotunzipfile'] = 'Није могуће распаковати ZIP датотеку.';
$string['cannotupdatemod'] = 'Није било могуће ажурирати {$a}';
$string['cannotupdatepasswordonextauth'] = 'Ажурирање лозинке на екстерном систему за проверу идентитета: {$a} није успело. За више информација погледајте записе на серверу.';
$string['cannotupdateprofile'] = 'Грешка приликом ажурирања корисничког записа';
$string['cannotupdaterecord'] = 'Није могуће ажурирати запис са ID {$a}';
$string['cannotupdaterss'] = 'Није могуће ажурирати RSS извор вести';
$string['cannotupdatesubcourse'] = 'Није могуће ажурирати подређени курс';
$string['cannotupdateusermsgpref'] = 'Није могуће ажурирање корисникових пoдешавања приватних порука';
$string['cannotupdateuseronexauth'] = 'Ажурирање корисничких података на екстерном систему за проверу идентитета: {$a} није успело. За више информација погледајте записе на серверу.';
$string['cannotuploadfile'] = 'Грешка у обради датотеке за постављање';
$string['cannotuseadmin'] = 'Морате да будете администратор да бисте користили ову страницу';
$string['cannotuseadminadminorteacher'] = 'Морате да будете предавач или администратор да бисте користили ову страницу';
$string['cannotusepage'] = 'Само предавачи и админстратори могу да користе ову страницу';
$string['cannotusepage2'] = 'Опростите, не может да користите ову страницу';
$string['cannotviewcategory'] = 'Немате дозволу да видите овај списак курсева.';
$string['cannotviewprofile'] = 'Не можете видети профил овог корисника';
$string['cannotviewreport'] = 'Не можете видети овај извештај';
$string['cannotwritefile'] = 'Није могуће уписивање у ову датотеку ({$a})';
$string['categoryerror'] = 'Грешка категорије';
$string['categoryidnumbertaken'] = 'ID број се већ користи за другу категорију';
$string['categorynamerequired'] = 'Неопходан је назив категорије';
$string['categorytoolong'] = 'Назив категорије је предуг';
$string['commentmisconf'] = 'ИД коментара је погрешно конфигурисан';
$string['componentisuptodate'] = 'Компонента је доступна у својој најновијој верзији';
$string['confirmationnotenabled'] = 'Потврда корисника није омогућена на овом сајту';
$string['confirmsesskeybad'] = 'Нажалост, али кључ ваше сесије не може бити потврђен како би се извршила ова акција. Ова сигурносна опција спречава случајно или злонамерно извршавање важних функција у ваше име. Проверите да ли сте стварно хтели да извршите ову функцију.';
$string['contenttypenotfound'] = 'Тип банке садржаја \'{$a}\' не постоји или није препознат.';
$string['contentvisibilitynotfound'] = 'Видљивост садржаја са вредношћу \'{$a}\'  не постоји или није препознат.';
$string['couldnotassignrole'] = 'Дошло је до озбиљне, али неодређене грешке приликом покушаја доделе Ваше нове улоге';
$string['couldnotupdatenoexistinguser'] = 'Није могуће ажурирати корисника - корисник не постоји';
$string['couldnotverifyagedigitalconsent'] = 'Дошло је до грешке при покушају провере сагласности о дигиталном узрасту.<br />Молимо контактирајте администратора.';
$string['countriesphpempty'] = 'Грешка: Датотека countries.php у језичком пакету {$a} је празна или недостаје.';
$string['coursedoesnotbelongtocategory'] = 'Курс не припада овој категорији';
$string['courseformatnotfound'] = 'Формат курса \'{$a}\' не постоји или није препознат';
$string['coursegroupunknown'] = 'Одговарајући курс за групу {$a} није задат';
$string['courseidnotfound'] = 'ID ознака курса не постоји';
$string['courseidnumbertaken'] = 'ID број се већ користи за други курс ({$a})';
$string['coursemisconf'] = 'Курс је погрешно конфигурисан';
$string['courserequestdisabled'] = 'Опростите, али администратор је онемогућио слање захтева за покретање нових курсева.';
$string['csvcolumnduplicates'] = 'Откривене су дупликати колона';
$string['csvemptyfile'] = 'CSV датотека је празна';
$string['csvfewcolumns'] = 'Нема довољно колона, молимо проверите подешавање знака за раздвајање';
$string['csvfileerror'] = 'Нешто није у реду са форматом CSV датотеке. Молимо вас да проверите да ли се број заглавља и колона поклапа, као и да ли су знак за раздвајање и кодни распоред датотеке исправни. {$a}';
$string['csvinvalidcols'] = '<b>Неисправна CSV датотека:</b> Прва линија мора да садржи "Header Fields" а датотеека мора да буде типа <br />"Expanded Fields/Comma Separated"<br />или<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Неисправна CSV датотека - свака линија мора да има 49 или 70 поља';
$string['csvloaderror'] = 'Дошло је до грешке приликом учитавања CSV датотеке: {$a}';
$string['csvnodata'] = 'Неисправна CSV датотека - CSV датотека има заглавља, али не садржи никакве податке.';
$string['csvweirdcolumns'] = 'Неисправан формат CSV датотеке - број колона није свуда исти!';
$string['dbconnectionfailed'] = '<p>Грешка: Конекција са базом података није успела</p>
<p>Могуће је да је база података преоптерећена или да на други начин не функионише како треба.</p>
<p>Администратор сајта, такође, треба да провери да ли су сви подаци везани за базу података исправно наведени у config.php датотеци</p>';
$string['dbdriverproblem'] = '<p>Грешка: уочен је проблем са драјвером базе података</p>
<p>Администратор сајта би требало да провери конфигурацију сервера</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Уочен је озбиљан проблем са сесијом базе података.<br /><br />Молимо, обавестите администратора сервера.';
$string['dbsessionhandlerproblem'] = 'Подешавање сессије базе података није успелео. Молимо обавестите администратора сервера.';
$string['dbsessionmysqlpacketsize'] = 'Откривене је озбиљна грешка сесије базе података. Молимо, обавестите администратора. Овај проблем је највероватније изазван малом вредношћу у MySQL подешавању max_allowed_packet';
$string['dbupdatefailed'] = 'Ажурирање базе података није успело';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" није могуће мењати. Отркивена је зависност од  {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = '"DDL sql execution" грешка';
$string['ddlfieldalreadyexists'] = 'Поље "{$a}" већ постоји';
$string['ddlfieldnotexist'] = 'Поље "{$a->fieldname}" не постоји у табели "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Табела "{$a}" већ постоји';
$string['ddltablenotexist'] = 'Табела "{$a}" не постоји';
$string['ddlunknownerror'] = 'Непозната DDL грешка';
$string['ddlxmlfileerror'] = 'Пронађена је грешка у датотеци XML базе података';
$string['ddsequenceerror'] = 'Дефиниција табеле "{$a}" је нетачна; може постојати само једна ауто-колона, и она мора бити дефинисана као кључ.';
$string['destinationcmnotexit'] = 'Одредишни курс не постоји';
$string['detectedbrokenplugin'] = 'Додатак "{$a}" је неисправан или застарео. Опростите, али није могуће наставити.';
$string['dmlexceptiononinstall'] = 'p>Дошло је до грешке у бази података [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Грешка приликом парсирања SQL упита';
$string['dmlreadexception'] = 'Грешка приликом читања из базе података';
$string['dmltransactionexception'] = 'Трансакциона грешка базе података';
$string['dmlwriteexception'] = 'Грешка приликом уписвања у базу података';
$string['downgradedcore'] = 'ГРЕШКА! Кôд који користите је СТАРИЈИ од верзије која је креирала ове базе!';
$string['downloadedfilecheckfailed'] = 'Није успела провера преузете датотеке';
$string['duplicatefieldname'] = 'Откривен је дупликат назива поља "{$a}"';
$string['duplicatenosupport'] = 'Активност \'{$a->modname}\' не може да буде дуплирана зато што тип модула {$a->modtype} не подржава креирање и рестаурисање резервне копије.';
$string['duplicateparaminsql'] = 'ГРЕШКА: дупли назив параметра у упиту';
$string['duplicaterolename'] = 'Већ постоји улога са овим именом!';
$string['duplicateroleshortname'] = 'Већ постоји улога са овим скраћеним називом!';
$string['duplicateusername'] = 'Дупликат корисничког имена - запис се прескаче';
$string['emailfail'] = 'Слање е-поште није успело';
$string['encryption_decryptfailed'] = 'Дешифровање није успело';
$string['encryption_encryptfailed'] = 'Шифровање није успело';
$string['encryption_invalidkey'] = 'Неисправан кључ';
$string['encryption_keyalreadyexists'] = 'Кључ већ постоји';
$string['encryption_nokey'] = 'Кључ није пронађен';
$string['encryption_wrongmethod'] = 'Подаци се не подударају са подржаним начином шифровања';
$string['enddatebeforestartdate'] = 'Датум завршетка курса мора да буде након датума почетка курса.';
$string['error'] = 'Дошло је до грешке';
$string['error_question_answers_missing_in_db'] = 'Није пронађен одговор који се поклапа са "{$a->answer}" у табели question_answers у бази података. До тога је дошло приликом рестаурирања питања са идентификатором {$a->filequestionid} из датотеке резервне копије, које је упарено са постојећим питањем са идентификатором {$a->dbquestionid} у бази података.';
$string['errorcleaningdirectory'] = 'Грешка при чишћењу директоријума "{$a}"';
$string['errorcopyingfiles'] = 'Грешка при копирању датотека';
$string['errorcreatingdirectory'] = 'Грешка при креирању директоријума "{$a}"';
$string['errorcreatingfile'] = 'Грешка при креирању датотеке "{$a}"';
$string['errorcreatingrole'] = 'Грешка у креирању улоге';
$string['errorfetchingrssfeed'] = 'Грешка приликом преузимања RSS извора вести.';
$string['erroronline'] = 'Грешка у линији {$a}';
$string['erroroutput'] = 'Испис грешке, стога је онемогућено аутоматско преусмеравање.';
$string['errorparsingxml'] = 'Грешка при парсирању XML-а: {$a->errorstring} у реду {$a->errorline}, на знаку {$a->errorchar}';
$string['errorprocessingarchive'] = 'Грешка у обради архиве';
$string['errorreadingfile'] = 'Грешка приликом читања датотеке "{$a}"';
$string['errorsavingrequest'] = 'Дошло је до грешке приликом покушаја да сачувате свој захтев.';
$string['errorsettinguserpref'] = 'Грешка у подешавању корисникових преференци';
$string['errorunzippingfiles'] = 'Грешка при распакивању датотека';
$string['expiredkey'] = 'Кључ је истекао';
$string['externalauthpassworderror'] = 'Лозинка за спољну проверу идентитета није празан низ';
$string['externalfilenolocation'] = 'Спољашња датотека нема путању';
$string['failtoloadblocks'] = 'Један или више блокова је регистровано у баззи података, али нису успели да се учитају!';
$string['fieldrequired'] = '"{$a}" је обавезно поље';
$string['fileexists'] = 'Датотека већ постоји';
$string['filemismatch'] = 'Неслагање назива датотеке (која није кључна).  Датотека "{$a->current}" треба да буде {$a->file}';
$string['filenotfound'] = 'Нажалост тражени документ није било могуће пронаћи';
$string['filenotreadable'] = 'Датотека није читљива';
$string['filterdoesnothavelocalconfig'] = 'Филтер {$a} не допушта локалну конфигурацију.';
$string['filternotactive'] = 'Филтер {$a} тренутно није активан';
$string['filternotenabled'] = 'Филтер није омогућен!';
$string['filternotinstalled'] = 'Филтер {$a} тренутно није инсталиран';
$string['forumblockingtoomanyposts'] = 'Прекорачили сте ограничење за број послатих порука на овом форуму';
$string['functionalityremoved'] = 'Покушавате да приступите функционалности која је уклоњена.';
$string['generalexceptionmessage'] = 'Изузетак (грешка) - {$a}';
$string['gradecantregrade'] = 'Дошло је до грешке приликом израчунавања оцене: {$a}';
$string['gradepubdisable'] = 'Објављивање оцена је онемогућено';
$string['gradesneedregrading'] = 'Неопходно је поново израчунати оцене курса';
$string['groupalready'] = 'Корисник већ припада групи {$a}';
$string['groupexistforcourse'] = 'Група "{$a}" већ постоји у овом курсу';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Група "{$a->name}" са id бројем "{$a->idnumber}" већ постоји на овом курсу.';
$string['grouphasidnumber'] = 'Grupa "{$a}" ima id broj i možda je automatski kreirana od strane eksternog sistema. Nemate ovlašćenje da uklonite ovu grupu..';
$string['groupinghasidnumber'] = 'Груписање "{$a}" има id број и можда је аутоматски креирано од стране екстерног система. Немате овлашћење да уклоните ово груписање..';
$string['groupingnotaddederror'] = 'Груписање "{$a}" није додато';
$string['groupnotaddederror'] = 'Група "{$a}" није додата';
$string['groupnotaddedtogroupingerror'] = 'Груписање "{$a}" није додато';
$string['groupunknown'] = 'Група {$a} не припада датом курсу';
$string['groupusernotmember'] = 'Корисник није члан ове групе';
$string['guestcantaccessprofiles'] = 'Гости не могу да приступе корисничким профилима. Улогујте се са правим корисничким налогом да бисте наставили рад.';
$string['guestnocomment'] = 'Гостима није дозвољено да постују коментаре';
$string['guestnoeditprofile'] = 'Гост не може да уређује свој профил';
$string['guestnoeditprofileother'] = 'Кориснички профил госта се не може уређивати';
$string['guestnorate'] = 'Гостима није дозвољено да оцењују појмове';
$string['guestsarenotallowed'] = 'Кориснику са налогом госта није дозвољено да уради';
$string['hackdetected'] = 'Откривен је хакерски напад!';
$string['hashpoolproblem'] = 'Неисправан садржај скупа датотеке $a}.';
$string['headersent'] = 'Заглавља су већ послата';
$string['idnumbertaken'] = 'Овај ID број се већ користи';
$string['idnumbertoolong'] = 'ID број је предугачак';
$string['importformatnotimplement'] = 'Опростите, али увоз овог формата још није имплементиран!';
$string['incorrectext'] = 'Датотека има неисправну екстензију';
$string['inplaceeditableerror'] = 'Грешка при позиву процесора ажурирања';
$string['installproblem'] = 'Обично није могуће исправити грешке које настану током инсталације. Можда ћете морати да креирате нову базу података, или да употребите неки други префикс базе података ако желите да поновите инсталацију.';
$string['internalauthpassworderror'] = 'Лозинка недостаје или су неисправна правила за креирање лозинке за интерну проверу идентитета';
$string['invalidaccess'] = 'Неисправан приступ овој страници';
$string['invalidaccessparameter'] = 'Неисправан параметер приступа';
$string['invalidaction'] = 'Неисправан параметер акције';
$string['invalidactivityid'] = 'Неисправан ID aктивности';
$string['invalidadminsettingname'] = 'Неисправно админ подешавање ({$a})';
$string['invalidargorconf'] = 'Нису прослеђени исправни аргументи или је конфигурација сервера неисправна';
$string['invalidarguments'] = 'Нису прослеђени исправни аргументи';
$string['invalidblockinstance'] = 'Неисправна инстанца блока за {$a}';
$string['invalidbulkenrolop'] = 'Затражена је неисправна операција за масовни упис';
$string['invalidcategory'] = 'Погрешна категорија';
$string['invalidcategoryid'] = 'Неисправна ID ознака категорије!';
$string['invalidcomment'] = 'Коментар је неисправан';
$string['invalidcommentarea'] = 'Неисправнo подручје за коментар';
$string['invalidcommentid'] = 'Неисправна ID ознака коментара';
$string['invalidcommentitemid'] = 'Неисправна ID ознака ставке коментара';
$string['invalidcommentparam'] = 'Неисправни параметри коментара';
$string['invalidcomponent'] = 'Неисправан назив компоненте';
$string['invalidconfirmdata'] = 'Неисправни подаци за потврду';
$string['invalidcontentid'] = 'Неисправна ID ознака садржаја';
$string['invalidcontext'] = 'Неисправан контекст';
$string['invalidcountrycode'] = 'Неисправан кôд државе: {$a}';
$string['invalidcourse'] = 'Неисправан курс';
$string['invalidcourseformat'] = 'Формат курса није валидан';
$string['invalidcourseid'] = 'Покушавате да користите неисправан ID курса';
$string['invalidcourselevel'] = 'Погрешан ниво контекста';
$string['invalidcoursemodule'] = 'Неисправан ID модула курса';
$string['invalidcoursemoduleid'] = 'Неисправна ID ознака модула курса: {$a}';
$string['invalidcoursenameshort'] = 'Неисправан кратак назив курса';
$string['invaliddata'] = 'Прослеђени подаци су неисправни';
$string['invaliddatarootpermissions'] = 'Откривена су неисправна овлашћења при покушају креирања директоријума. Укључите мод за откривање грешака за више детаља.';
$string['invaliddevicetype'] = 'Неисправан тип уређаја';
$string['invalidelementid'] = 'Неисправна ID ознака елемента';
$string['invalidentry'] = 'Ово није исправан унос';
$string['invalidevent'] = 'Неисправан догађај';
$string['invalidfieldname'] = '"{$a}" није исправно име поља';
$string['invalidfiletype'] = '"{$a}" није исправан тип датотеке';
$string['invalidformatpara'] = 'Погрешан формат за параметар избора';
$string['invalidformdata'] = 'Неисправни подаци у обрасцу';
$string['invalidfunction'] = 'Неисправна функција';
$string['invalidgradeitemid'] = 'Неисправна ID ознака ставке оцене';
$string['invalidgroupid'] = 'Наведена је неисправна ID ознака групе';
$string['invalidipformat'] = 'Неисправан формат IP адресе';
$string['invaliditemid'] = 'Неисправна ID ознака ставке';
$string['invalidkey'] = 'Неисправан кључ';
$string['invalidlanguagecode'] = 'Неисправан језички кôд: {$a}';
$string['invalidlegacy'] = 'Неисправна дефиниција наслеђене улоге за тип: {$a}';
$string['invalidmd5'] = 'Неисправна md5 датотека';
$string['invalidmode'] = 'Неисправан мод ({$a})';
$string['invalidmodule'] = 'Неисправан модул';
$string['invalidmoduleid'] = 'Неисправна ID ознака модула: {$a}';
$string['invalidmodulename'] = 'Неисправан назив модула: {$a}';
$string['invalidnum'] = 'Неисправна нумеричка вредност';
$string['invalidnumkey'] = 'Поље $conditions не може да садржи нумеричке кључеве. Поправите кôд!';
$string['invalidoutcome'] = 'Неисправна ID ознака исхода';
$string['invalidpagesize'] = 'Неисправна величина странице';
$string['invalidpasswordpolicy'] = 'Неисправна правила за креирање лозинке';
$string['invalidpaymentmethod'] = 'Неисправан начин плаћања {$a}';
$string['invalidpersistenterror'] = 'Грешка: {$a}';
$string['invalidqueryparam'] = 'ГРЕШКА: Погрешан број параметара упита. Очекивано {$a->expected}, а добијено {$a->actual}.';
$string['invalidratingarea'] = 'Неисправнo подручје за оцењивање';
$string['invalidrecord'] = 'Није могуће пронаћи податке у табели базе {$a}.';
$string['invalidrecordunknown'] = 'Није могуће пронаћи податке у бази података';
$string['invalidrequest'] = 'Неисправан захтев';
$string['invalidrole'] = 'Неисправна улога';
$string['invalidroleid'] = 'Неисправан ИД улоге';
$string['invalidscaleid'] = 'Неисправна ID ознака скале';
$string['invalidsection'] = 'Запис модула курса садржи неисправну секцију';
$string['invalidsesskey'] = 'Ваша сесија је највероватније истекла. Пријавите се поново.';
$string['invalidshortname'] = 'Неисправан скраћени назив курса';
$string['invalidsourcefield'] = 'Поље извора радне верзије датотеке је неисправно';
$string['invalidstatedetected'] = 'Нешто је кренуло наопако: {$a}. Нормално, ово не би требало да се догађа.';
$string['invalidurl'] = 'Неисправан url';
$string['invaliduser'] = 'Неисправан корисник';
$string['invaliduserdata'] = 'Неисправни кориснички подаци: {$a}';
$string['invaliduserfield'] = 'Неисправно корисничко поље: {$a}';
$string['invaliduserid'] = 'Неисправна ID ознака корисника';
$string['invalidusername'] = 'Дато корисничко име садржи неисправне знакове';
$string['invalidusernameblank'] = 'Поље за корисничко име не може бити празно';
$string['invalidxmlfile'] = '"{$a}" није исправна XML датотека';
$string['iplookupfailed'] = 'Није могуће пронаћи географске податке о овој IP адреси {$a}.';
$string['iplookupprivate'] = 'Није могуће приказати претрагу приватне IP адресе';
$string['ipmismatch'] = 'Клијентска IP адреса се не поклапа';
$string['listcantmovedown'] = 'Померање ставке надоле није успело, поштo је то последња ставка у низу.';
$string['listcantmoveleft'] = 'Померање ставке улево није успело, пошто она нема надређену ставку';
$string['listcantmoveright'] = 'Померање ставке удесно није успело, пошто нема ставке која би јој била надређена. Померите је испод друге ставке, и онда је можете померити удесно.';
$string['listcantmoveup'] = 'Померање ставке нагоре није успело, пошто је то прва ставка у низу.';
$string['listnochildren'] = 'Нема подређених ставки';
$string['listnoitem'] = 'Ставка није пронађена';
$string['listnopeers'] = 'Нису пронађене сродне ставке';
$string['listupdatefail'] = 'Oперација над базом није успела при уређивању хијерархије листе';
$string['logfilenotavailable'] = 'Записи нису доступни';
$string['loginasnoenrol'] = 'Не можете се уписивати или исписивати са курса док траје сесија "Пријави се као"';
$string['loginasonecourse'] = 'Не можете да приступите овом курсу.<br /> Морате прво да завршите сесију "Пријави се као". пре уласка на било који други курс.';
$string['maxareabytes'] = 'Немате довољно простора да бисте сачували ову датотеку.';
$string['maxbytesfile'] = 'Датотека {$a->file} је превелика. Максимална величина датотеке коју можете поставити је {$a->size}.';
$string['maxdraftitemids'] = 'Постављање ваших датотека је привремено ограничено након што се поставили велики број датотека. Молимо сачекајте, па покушајте поново.';
$string['messageundeliveredbynotificationsettings'] = 'Порука није могла да се пошаље јер је администратор сајта онемогућио личне поруке између корисника (у \'Подешавања за слање обавештења\').';
$string['messagingdisable'] = 'Слање порука на овом сајту није омогућено';
$string['mimetexisnotexist'] = 'Ваш систем није конфигурисан како би могао да покрене mimeTeX. Морате да прибавите C изворни кôд са <a href="https://www.forkosh.com/mimetex.zip">http://www.forkosh.com/mimetex.zip</a>,  да га компајлирате и поставите извршну датотеку у ваш moodle/filter/tex/ директоријум.';
$string['mimetexnotexecutable'] = 'Прилагођени mimetex није могуће покренути!';
$string['missing_moodle_backup_xml_file'] = 'Резервној копији података недостаје XML датотека: {$a}';
$string['missingcategoryrole'] = 'Није могуће доделити улогу кориснику: недостаје улога за категорију.';
$string['missingfield'] = 'Поље "{$a}" недостаје';
$string['missingkeyinsql'] = 'Грешка: недостаје параметар "{$a}" у упиту';
$string['missingparam'] = 'Недостаје неопходни параметар ({$a})';
$string['missingparameter'] = 'Недостаје параметар';
$string['missingrequiredfield'] = 'Недостаје неко обавезно поље';
$string['missinguseranditemid'] = 'Недостаје userid и itemid';
$string['missingvarname'] = 'Недостаје име неопходне варијабле';
$string['mixedtypesqlparam'] = 'ГРЕШКА: Измешани типови sql параметара упита!!!';
$string['mnetdisable'] = 'MNET је искључен';
$string['mnetlocal'] = 'Удаљени MNET корисници не могу да се пријаве локално';
$string['moduledisable'] = 'Овај модул ({$a}) је онемогућен за овај конкретан курс';
$string['moduledoesnotexist'] = 'Овај модул не постоји';
$string['moduleinstancedoesnotexist'] = 'Инстанца овог модула не постоји';
$string['modulemissingcode'] = 'Модулу {$a} недостаје кôд потребан за извођење ове функције';
$string['movecatcontentstoroot'] = 'Премештање садржаја категорије у основни директоријум није дозвољено. Морате да преместите садржаје у постојећу категорију!';
$string['movecatcontentstoselected'] = 'Неки од садржаја категорије не могу се преместити у изабрану категорију.';
$string['movecategorynotpossible'] = 'Не можете да преместите категорију  \'{$a}\' у изабрану категорију.';
$string['movecategoryownparent'] = 'Не можете поставити да категорија  \'{$a}\' буде сама себи надређена';
$string['movecategoryparentconflict'] = 'Не можете поставити да категорија \'{$a}\' буде поткатегорија једне од њених поткатегорија.';
$string['mssqlrcsmodemissing'] = 'База не користи очекивани READ_COMMITTED_SNAPSHOT режим рада услед чега може доћи до погрешних резултата, посебно при сценаријима са високом паралелизацијом. Молимо омогућите наведени режим да би се база коректно понашала. Више информација о овоме можете наћи у оквиру <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">документације</a>.';
$string['multiplerecordsfound'] = 'Пронађени су вишеструки записи, а очекиван је само један запис.';
$string['multiplerestorenotallow'] = 'Није дозвољено истовремено покретање више процедура рестаурације података!';
$string['mustbeloggedin'] = 'Морате бити пријављени на систем како бисте ово урадили';
$string['mustbeteacher'] = 'Морате бити предавач да бисте видели ову страницу';
$string['myisamproblem'] = 'Табеле у бази података користе MyISAM систем, Препоручује се употреба ACID компатибилног система са пуном подршком за трансакције, попут InnoDB.';
$string['needcopy'] = 'Прво морате нешто да копирате!';
$string['needcoursecategroyid'] = 'Mora бити наведен или идентификатор курса или категорија';
$string['needphpext'] = 'Потребно је да додате {$a} подршку вашој PHP инсталацији';
$string['noadmins'] = 'Нема администратора!';
$string['noblocks'] = 'Ниједан блок није пронађен!';
$string['nocapabilitytousethisservice'] = 'Корисник нема потребне способности за коришћење овог сервиса';
$string['nocategorydelete'] = 'Категорија \'{$a}\' се не може обрисати!';
$string['nocontext'] = 'Жао нам је, али тај курс није валидан контекст';
$string['nodata'] = 'Нема података';
$string['noexistingcategory'] = 'Нема категорије';
$string['nofile'] = 'Датотека није наведена';
$string['nofiltersenabled'] = 'Ниједан филтер није омогућен';
$string['nofolder'] = 'Тражени директоријум не постоји';
$string['noformdesc'] = 'За ову активност није пронађена formslib датотека са описом обрасца.';
$string['noguest'] = 'Овде нема гостију!';
$string['noinstances'] = 'Нема инстанци {$a} у овом курсу!';
$string['nologinas'] = 'Није вам дозвољено да се пријавите као тај корисник';
$string['nonmeaningfulcontent'] = 'Бесмислен садржај';
$string['noparticipants'] = 'Није пронађен ни један учесник на овом курсу';
$string['noparticipatorycms'] = 'Нажалост, немате модуле курса са учесницима за које би се могао креирати извештај';
$string['nopermissions'] = 'Жао нам је, али тренутно немате овлашћења да то радите ({$a}).';
$string['nopermissiontoaccesspage'] = 'Немате дозволу да приступите овој страници.';
$string['nopermissiontocomment'] = 'Не можете да додате коментар у овај речник!';
$string['nopermissiontodelentry'] = 'Не можете да обришете овај коментар!';
$string['nopermissiontoeditcomment'] = 'Не можете да уређујете коментаре других корисника!';
$string['nopermissiontohide'] = 'Немате овлашћења за сакривање!';
$string['nopermissiontoimportact'] = 'Немате неопходна овлашћења да бисте увезли активности у овај курс';
$string['nopermissiontolock'] = 'Немате овлашћења за закључавање!';
$string['nopermissiontomanagegroup'] = 'Немате неопходна овлашћења да бисте управљали групама';
$string['nopermissiontorate'] = 'Оцењивање ставки није дозвољено';
$string['nopermissiontoshow'] = 'Немате овлашћења да видите ово!';
$string['nopermissiontounlock'] = 'Немате овлашћења за откључавање!';
$string['nopermissiontoupdatecalendar'] = 'Жао нам је, али немате овлашћења да ажурирате догађаје у календару.';
$string['nopermissiontoviewcalendar'] = 'Жао нам је, али немате дозволу да видите догађај у календару.';
$string['nopermissiontoviewgrades'] = 'Не могу да виде оцене';
$string['nopermissiontoviewletergrade'] = 'Недостаје овлашћење да би се виделе словне оцене';
$string['nopermissiontoviewpage'] = 'Није Вам дозвољено да гледате ову страницу';
$string['nosite'] = 'Није могуће пронаћи курс највишег нивоа!';
$string['nositeid'] = 'Не постоји ИД сајта';
$string['nostartdatenoenddate'] = 'Датум завршетка курса се може одрадити само уколико је унет и датум почетка курса.';
$string['nostatstodisplay'] = 'Извините, нема расположивих података за приказ';
$string['notallowedtoupdateprefremotely'] = 'Немате дозволу да ажурирате преференце овог корисника удаљено';
$string['notavailable'] = 'Тренутно није на располагању.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Нисте члан ове групе';
$string['notownerofkey'] = 'Нисте власник овг кључа';
$string['nousers'] = 'Не постоји такав корисник';
$string['oauth1accesstoken'] = 'OAuth 1.0 грешка: нисмо добили токен за приступ.';
$string['oauth1requesttoken'] = 'OAuth 1.0 грешка: нисмо добили токен за захтев - могуће је да је давалац услуга привремено недоступан.';
$string['oauth2refreshtokenerror'] = 'Није могуће освежити  OAuth 2 токен. HTTP статус за удаљену крајњу тачку: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Није могуће освежити OAuth 2 токен за једног или више даваоца идентитета. Погледајте излазне податке задатка за више информација.';
$string['oauth2upgradetokenerror'] = 'Није могуће освежити  OAuth 2 токен. HTTP статус за удаљену крајњу тачку: {$a}';
$string['onlyadmins'] = 'Само администратори могу то да раде';
$string['onlyeditingteachers'] = 'Само предавачи са уређивачким привилегијама могу то да раде';
$string['onlyeditown'] = 'Можете мењати само личне податке';
$string['opensslsealerror'] = 'OpenSSL не може да запечати податке';
$string['opensslsignerror'] = 'OpenSSL не може да потпише податке';
$string['orderidnotfound'] = 'Идентификатор наруџбе {$a} није пронађен';
$string['pagenotexist'] = '<p>Дошло је до неуобичајене грешке приликом покушаја приступа страници која не постоји:</p>{$a}';
$string['pagenotexisttitle'] = '404 Грешка: датотека није пронађена';
$string['pathdoesnotstartslash'] = 'Нису прослеђени исправни аргументи; путања не почиње са косом цртом (/)!';
$string['pleasereport'] = 'Ако имате времена, обавестите нас шта сте покушали да урадите када је дошло до грешке:';
$string['pluginrequirementsnotmet'] = 'Додатак "{$a->pluginname}" ({$a->pluginversion}) није могао бити инсталиран. Он захтева новију верзију Moodle система (Ви тренутно користите {$a->currentmoodle}, а потребна Вам је верзија {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Додатак "{$a->pluginname}" {$a->pluginversion} не подржава ову верзију Moodlea {$a->moodleversion}. Потражите информације о додатку како бисте пронашли верзије које су подржане.';
$string['prefixcannotbeempty'] = '<p>Грешка: префикс табела базе података не може бити празан ({$a})</p>
<p>Администратор сајта мора да реши овај проблем.</p>';
$string['prefixtoolong'] = '<p>Грешка: префикс табеле базе података је предуг ({$a->dbfamily})</p>
<p>Администратор сајта мора да реши овај проблем. Максимална дужина префикса табела у {$a->dbfamily} је {$a->maxlength} знак(ов)а.</p>';
$string['privatefilesupload'] = 'Постављање датотека у кориснички приватни простор за датотеке више није подржано. Поставите датотеку у простор за радне верзије датотека а затим их преместите са core_user::add_user_private_files';
$string['processingstops'] = 'Обрада се овде зауставља. Преостали записи биће игнорисани.';
$string['protected_cc_not_supported'] = 'Заштићени кертриџи нису подржани.';
$string['querystringcannotbeempty'] = 'Стринг упита не може бити празан';
$string['redirecterrordetected'] = 'Откривено је преусмеравање које није подржано, па је извршење скрипте окончано.';
$string['refoundto'] = 'Може бити рефундирано на износ од {$a}';
$string['refoundtoorigi'] = 'Рефундирано на оригинала износ од: {$a}';
$string['registrationdisabled'] = 'Регистрација је онемогућена на овом сајту';
$string['remotedownloaderror'] = '<p>Преузимање ове компоненте на ваш сервер није успело. Проверите подешавања прокси сервера. PHP cURL екстензија се препоручује.</p>
<p>Морате да преузмете <a href="{$a->url}">{$a->url}</a> датотеку ручно, копирате је у директоријум "{$a->dest}" на свом серверу и тамо је распакујете.</p>';
$string['remotedownloadnotallowed'] = 'Није дозвољено преузимање компоненти на Ваш сервер (опција allow_url_fopen је онемогућена).<br /><br />Морате ручно преузети датотеку <a href="{$a->url}">{$a->url}</a>, копирати је у "{$a->dest}" на свом серверу и тамо је распаковати.';
$string['reportnotavailable'] = 'Ова врста извештај је једино доступна за сајт.';
$string['requirecorrectaccess'] = 'Неисправна url адреса или порт';
$string['requireloginerror'] = 'Курс или активност нису доступни.';
$string['restore_path_element_missingmethod'] = 'Недостаје метод за рестаурацију {$a}. Метод мора бити дефинисан од стране програмера.';
$string['restore_path_element_noobject'] = 'Објекат за рестаурацију {$a} није објекат.';
$string['restorechecksumfailed'] = 'Догодио се проблем са подацима за рестаурацију који су смештени у Вашој сесији. Молимо проверите Ваша ограничења PHP меморије/величине DB пакета. Процес рестурације је заустављен.';
$string['restrictedcontextexception'] = 'Нажалост, извршење спољашње функције крши рестрикцију контекста.';
$string['restricteduser'] = 'Жао нам је, али ваш текући налог "{$a}" је ограничен и не можете урадити ову акцију';
$string['reverseproxyabused'] = 'Укључен је реверзни прокси тако да није могуће директно приступити серверу. <br />Контактирајте сервер администратора.';
$string['rpcerror'] = 'Упс! Ваша MNET комуникација није успела! Овде је порука о грешци коју треба проследити администратору: {$a}';
$string['scheduledbackupsdisabled'] = 'Администратор сервера је онемогућио креирање планираних резервних копија';
$string['secretalreadyused'] = 'Линк за потврду промене лозинке је већ искоришћен. Лозинка није промењена';
$string['sectionnotexist'] = 'Ова секција не постоји';
$string['sendmessage'] = 'Пошаљи поруку';
$string['sendmessagesent'] = 'Хвала на повратним информацијама о:<br>{$a}';
$string['serverconnection'] = 'Грешка у повезивању са сервером';
$string['servicedonotexist'] = 'Услуга не постоји';
$string['sessioncannotobtainlock'] = '<p>Није могуће добити закључавање за сесију са ID ознаком {$a->id} унутар {$a->acquiretimeout}.</p>
<p>Вероватно је друга страница ({$a->whohaslock}) још увек активна у другој картици веб читача, или није дошло до откључавање услед грешке.</p>
<p>Можете сачекати да истекне време закључавања сесије ({$a->lockexpire}) или можете да поново покренете сесију вашег веб читача. Ако се ова грешка понавља, молимо вас да обавестите администратора сервера.</p>';
$string['sessioncookiesdisable'] = 'Неправилна употреба require_key_login() - колачићи сесије морају бити онемогућени!';
$string['sessiondiskfull'] = 'Партиција за чување сесија је пуна. Пријава на систем тренутно није могућа. Молимо вас да обавестите администратора сервера.';
$string['sessionerroruser'] = 'Ваша сесија је истекла. Молимо вас да се пријавите поново.';
$string['sessionerroruser2'] = 'Дошло је до грешке која утиче на вашу текућу сесију. Молимо вас да пријавите се на систем поново или поново покрените свој веб читач.';
$string['sessionexpired'] = 'Сесија је истекла';
$string['sessionhandlerproblem'] = 'Процедура за обраду сесије је погрешно подешена';
$string['sessionipnomatch'] = 'Нажалост, али изгледа да се Ваш IP број променио од када сте се пријавили на систем. Ова сигурносна опција спречава кракере да украду Ваш индентитет док сте пријављени на овај сајт. Нормални корисници не би требало да виде ову поруку - молимо Вас да тражите помоћ од администратора сајта.';
$string['sessionipnomatch2'] = '<p>Опростите, али изгледа да се, од тренутка када сте се први пут пријавили на систем, променила ваша IP адреса. Ова безбедносна функција спречава злонамерне кориснике од крађе вашег идентитета док сте пријављени на овом сајту. Ову грешку можете видети уколико користите бежични приступ интернету. Молимо вас да контактирате администратора за помоћ.</p>
<p>Уколико желите да наставите молимо вас притисните тастер F5 како бисте освежили ову страницу.</p>';
$string['sessionwaiterr'] = 'Време је истекло док сте чекали закључавање сесије.<br /> Сачекајте да се ваши тренутни захтеви заврше и покушајте поново касније.';
$string['shortnametaken'] = 'Скраћени назив се већ користи за други курс ({$a})';
$string['sitepolicynotagreed'] = 'Нисте се сагласили са правилником о коришћењу сајта: <a href="{$a}">Кликните овде да бисте отворили правилник.</a>';
$string['socksnotsupported'] = 'SOCKS5 прокси није подржан у PHP4';
$string['spellcheckernotconf'] = 'Провера правописа није конфигурисана';
$string['sslonlyaccess'] = 'Из разлога безбедности дозвољене су само https конекције.';
$string['statscatchupmode'] = 'Статистика је тренутно у режиму надокнађивања заосталих, још необрађених података. До сада је обрађено {$a->daysdone} дан/a, а још {$a->dayspending} дан/а чека на обраду. Вратите се нешто касније!';
$string['statsdisable'] = 'Статистика није омогућена';
$string['statsnodata'] = 'Нема доступних података за ту комбинацију курса и временског периода.';
$string['storedfilecannotcreatefile'] = 'Није могуће креирати датотеку локалног скупа датотека. Молимо проверите овлашћења за директоријум са подацима и расположив простор на диску.';
$string['storedfilecannotcreatefiledirs'] = 'Није могуће креирати директоријуме локалног скупа датотека. Молимо проверите овлашћења за директоријум са подацима.';
$string['storedfilecannotread'] = 'Није могуће прочитати датотеку. Или датотека не постоји или постоји проблем са овлашћењима.';
$string['storedfilecannotreadfile'] = 'Није могуће учитати датотеку \'{$a}\'. Датотека или не постоји или постоји проблем са овлашћењем за приступ датотеци.';
$string['storedfilenotcreated'] = 'Није могуће креирати датотеку  {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Непознати изузетак (грешка) у вези са локалним датотекама ({$a})';
$string['tagdisabled'] = 'Ознаке су онемогућене';
$string['tagnotfound'] = 'Наведена ознака (таг) није пронађена у бази података';
$string['targetdatabasenotempty'] = 'Одредишна база података није празна. Трансфер је поништен из разлога безбедности';
$string['textconditionsnotallowed'] = 'Поређења услова за текстуалне колоне нису дозвољена. Молимо да у упиту користите sql_compare_text().';
$string['themenotinstall'] = 'Ова шема изгледа није инсталирана';
$string['tokengenerationfailed'] = 'Није могуће генерисати нови токен.';
$string['transactionvoid'] = 'Трансакција се не може поништити, пошто је већ поништена.';
$string['unenrolerror'] = 'Дошло је до грешке приликом покушаја исписивања те особе';
$string['unicodeupgradeerror'] = 'Жао нам је, али Ваша база података није у Unicode формату, а ова везија Moodleа не може да је пребаци у Unicode базу података. Молимо прво урадите надоградњу система до Moodle 1.7.x верзије и урадите Unicode миграцију са администраторске странице. Након што то урадите моћи ћете да пређете на Moodle {$a}';
$string['unknowaction'] = 'Непозната акција!';
$string['unknowcategory'] = 'Категорија није позната!';
$string['unknowcontext'] = 'Ово је непознати контекст({$a}) у get_child_contexts!';
$string['unknowformat'] = 'Формат није познат ({$a})';
$string['unknownbackupexporterror'] = 'Непозната грешка у току припреме података за увоз';
$string['unknownblockregion'] = 'Подручје блока \'{$a}\' није препознато на овој страници.';
$string['unknowncategory'] = 'Непозната категорија са ID бројем категорије "{$a}"';
$string['unknowncontext'] = 'Ово је непознат контекст';
$string['unknowncourse'] = 'Не постоји курс под називом "{$a}"';
$string['unknowncourseidnumber'] = 'Непознати ID курса  "{$a}"';
$string['unknowncourserequest'] = 'Непознат захтев за покретање новог курса';
$string['unknowncoursesection'] = 'Непозната секција на курсу "{$a}"';
$string['unknownevent'] = 'Непознати догађај';
$string['unknownfiletype'] = 'Грешка! Непознати тип филтера';
$string['unknowngroup'] = 'Непозната група "{$a}"';
$string['unknownhelp'] = 'Непозната тема помоћи {$a}';
$string['unknownjsinrequirejs'] = 'Није могуће наћи JavaScript библиотеку {$a}';
$string['unknownmodulename'] = 'Непознати назив модула за образац';
$string['unknownrole'] = 'Непозната улога "{$a}"';
$string['unknownsortcolumn'] = 'Непозната колумна за сортирање {$a}';
$string['unknownuseraction'] = 'Жао нам је, али систем није разумео ову акцију корисника';
$string['unknownuserselector'] = 'Непозната опција за избор корисника';
$string['unknoworder'] = 'Непознати редослед';
$string['unknowparamtype'] = 'Непознати тип параметра {$a}';
$string['unknowquestiontype'] = 'Неподржани тип питања {$a}';
$string['unknowuploadaction'] = 'Грешка: непозната акција за постављање датотеке на сервер ({$a})';
$string['unspecifycourseid'] = 'Морате навести ID ознаку курса, скраћени назив или ID број';
$string['unsupportedevent'] = 'Неподржани тип догађаја';
$string['unsupportedstate'] = 'Неподржани статус завршености';
$string['unsupportedwebserver'] = 'Опростите, софтвер за веб сервер ({$a}) није подржан';
$string['upgraderequires19'] = 'Грешка: Нова верзија Moodlea је инсталирана на сервер, На жалост,  ажурирање са претходне верзије није подржано.<br />МОлимо Вас да прво ажурирате Moodle на последњу 1.9.x верзију. На претходну верзију се, такође, можете братити тако што ћете поново инсталирати оригиналне датоеке.';
$string['upgraderunning'] = 'Сајт се ажурира, молимо покушајте касније';
$string['urlnotdefinerss'] = 'Није дефисана URL адреса за RSS извор вести';
$string['useradmineditadmin'] = 'Само је администраторима дозвољено да мењају друге администраторске налоге';
$string['useradminodelete'] = 'Администраторски налози не могу бити обрисани.';
$string['userautherror'] = 'Непознат додатак за проверу идентитета';
$string['userauthunsupported'] = 'Додатак за проверу идентитета овде није подржан';
$string['useremailduplicate'] = 'Дупликат адресе';
$string['userisfilteredout'] = 'Овај корисник не одговара филтерима и подешавањима табеле!';
$string['usermustbemnet'] = 'Корисници на MNET контролној листи приступа мора бити удаљени MNET корисник';
$string['usernamelowercase'] = 'Корисничко име мора бити малим словима';
$string['usernotaddederror'] = 'Корисник није додат - грешка';
$string['usernotaddedregistered'] = 'Корисник није додат - већ је регистрован';
$string['usernotavailable'] = 'Детаљније информације о овом кориснику вам нису доступне';
$string['usernotdeletedadmin'] = 'Корисник није обрисан пошто није могуће обрисати администраторске налоге';
$string['usernotdeleteddeleted'] = 'Овај корисник је већ обрисан.';
$string['usernotdeletederror'] = 'Корисник није oбрисан - грешка';
$string['usernotdeletedmissing'] = 'Корисник није oбрисан - корисничко име није пронађено';
$string['usernotdeletedoff'] = 'Корисник није обрисан - брисање није дозвољено.';
$string['usernotfullysetup'] = 'Корисник није у потпуности подешен';
$string['usernotincourse'] = 'Овај корсиник није на овом курсу';
$string['usernotrenamedadmin'] = 'Не могу се преименовати администраторски налози.';
$string['usernotrenamedexists'] = 'Корисник није преименован - ново корисничко име је већ заузето';
$string['usernotrenamedmissing'] = 'Корисник није преименован - није пронађено старо корисничко име';
$string['usernotrenamedoff'] = 'Корисник није преименован - преименовање није дозвољено.';
$string['usernotupdatedadmin'] = 'Не могу се изменити администраторски налози.';
$string['usernotupdatederror'] = 'Корисник није ажуриран - грешка';
$string['usernotupdatednotexists'] = 'Нису измењени подаци о кориснику - не постоје подаци.';
$string['userquotalimit'] = 'Достигли сте меморијски лимит за своје датотеке';
$string['userselectortoomany'] = 'user_selector је добио више од једног изабраног корисника, иако опција за вишеструки избор није укључена.';
$string['verifyagedigitalconsentnotpossible'] = 'Жао нам је, потврда сагласности о дигиталном узрасту није тренутно могућа.';
$string['wrongcall'] = 'Овај скрипт је позван погрешно';
$string['wrongcontextid'] = 'ID контекста је неисораван (није га могуће наћи)';
$string['wrongdestpath'] = 'Погрешна одредишна путања';
$string['wrongroleid'] = 'Неисправан ID улоге';
$string['wrongsourcebase'] = 'Погрешна база изворног URL-a';
$string['wrongusernamepassword'] = 'Погрешно корисничко име/лозинка';
$string['wrongzipfilename'] = 'Погрешан назив архиве';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Није било могуће креирати курс - Нема овлашћења';
$string['wwwrootmismatch'] = 'Откривен је неисправан приступ. Овом серверу се једино може приступити преко адресе "{$a}". Молимо вас да обавестите администратора.';
$string['wwwrootslash'] = 'У config.php датотеци неисправно је подешена линија $CFG->wwwroot. Она на крају не сме да има косу црту  /<br />Молимо вас да о томе обавестите администратора.';
$string['xmldberror'] = 'XMLDB грешка!';
$string['youcannotdeletecategory'] = 'Не можете да обришете категорију \'{$a}\' зато што не можете да обришете садржаје или да их преместите негде друго.';
