<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grouptool', language 'sr_cr', version '4.1'.
 *
 * @package     grouptool
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activated_group'] = 'Активирана група';
$string['activated_groups'] = 'Активиране групе!';
$string['active'] = 'Активна група';
$string['activegroups'] = 'Активне групе';
$string['add_member'] = 'Додај корисника <strong>{$a->username}</strong> у групу <strong>{$a->groupname}</strong>';
$string['added_member'] = 'Корисник <strong>{$a->username}</strong> је додат у групу <strong>{$a->groupname}</strong>';
$string['administration'] = 'Администрација';
$string['administration_alt'] = 'Креирање групе(а) и подешавања за активне групе ове инстанце';
$string['agroups'] = 'Активне групе';
$string['ajax_edit_size_help'] = 'Сачувајте нову величину помоћу тастера &lt;Enter&gt, употребите тастер &lt;ESC&gt ако желите да одустанете, оставите празно како бисте обрисали индивидуалну величину';
$string['all_groups_full'] = 'Није могуће пријавити корисника <strong>{$a}</strong> ни у једну групу јер су све попуњене!';
$string['allow_multiple'] = 'Вишеструке пријаве';
$string['allow_multiple_help'] = 'Омогућите полазницима да се пријаве у више од 1 групе истовремено. Морате да наведете колико група морају да изаберу најмање (= minimum groups to choose) и колико група им је дозвољено да изаберу максимално (= maximum groups to choose).';
$string['allow_reg'] = 'Омогућите самосталну пријаву';
$string['allow_reg_help'] = 'Омогућите самосталну пријаву за полазнике како би они могли самостално да се пријаве у активне, доле изабране, групе.';
$string['allow_unreg'] = 'Дозволи одјаву из групе';
$string['allow_unreg_help'] = 'Омогућите полазницима да се одјаве из групе или да пређу у неке друге групе, пре (опционо) дефинисаног крајњег рока.';
$string['allowed'] = 'Дозвољено';
$string['already_marked'] = 'Ова група је већ означена за пријављивање!';
$string['already_member'] = 'Корисник <strong>{$a->username}</strong> је већ члан групе <strong>{$a->groupname}</strong>';
$string['already_occupied'] = 'Место у групи <strong>{$a->grpname}</strong> је заузето пошто се други корисник раније већ пријавио у ову групу. Потражите другу групу!';
$string['already_queued'] = 'Корисник<strong>{$a->username}</strong> је већ на листи чекање за упис у групу <strong>{$a->groupname}</strong>!';
$string['already_registered'] = 'Корисник <strong>{$a->username}</strong> се већ пријавио у групу <strong>{$a->groupname}</strong>!';
$string['alwaysshowdescription'] = 'Увек прикажи опис';
$string['asterisk_marks_moodle_registrations'] = 'Корисници са звездицом (*) као префиксом су се већ пријавили у одговарајућу Moodle групу';
$string['availabledate'] = 'Почетак пријављивања';
$string['availabledate_help'] = 'Почетак периода пријављивања у групе. Након овог датума полазници могу да се пријаве у одабране групе (ако је то омогућено).';
$string['availabledateno'] = 'Увек доступно';
$string['calendaravailable'] = 'Отвара се пријава {$a}';
$string['calendardue'] = 'Рок за пријаву у групе је {$a}';
$string['cant_enrol'] = 'Није могуће аутоматски уписати корисника на курс.';
$string['cfg_addinstanceset_head'] = 'Додатна подешавања инстанце';
$string['cfg_addinstanceset_head_info'] = 'Додатна подешавања алата за групу.';
$string['cfg_admin_head'] = 'Подразумевана подешавања за картицу Администрација';
$string['cfg_admin_head_info'] = 'Стандардне подешавања за картицу администрације у приказу алата за групе.';
$string['cfg_allow_multiple'] = 'Вишеструке пријаве';
$string['cfg_allow_multiple_desc'] = 'Омогућите, стандардно, полазницима да се пријаве у више од 1 групе истовремено.';
$string['cfg_allow_reg'] = 'Дозволите самосталну пријаву';
$string['cfg_allow_reg_desc'] = 'Омогућите, стандардно, полазницима да се сами пријаве';
$string['cfg_allow_unreg'] = 'Дозволите одјаву из групе';
$string['cfg_allow_unreg_desc'] = 'Да ли корисници могу да се  сами одјаве и промене групе?';
$string['cfg_choose_max'] = 'Изаберите максималан број група';
$string['cfg_choose_max_desc'] = 'У колико група би, стандардно, корисници могли да се пријаве истовремено?';
$string['cfg_choose_min'] = 'Изаберите минималан број група';
$string['cfg_choose_min_desc'] = 'Колико минимално група, стандардно, корисници могу да изаберу?';
$string['cfg_force_dereg'] = 'Обавезно одјављивање у алату за групу';
$string['cfg_force_dereg_desc'] = 'Обавезно одјављивање не само из алата за групе већ и из Moodle-групе.';
$string['cfg_force_importreg'] = 'Обавезно пријављивање у алату за групу';
$string['cfg_force_importreg_desc'] = 'Помоћу алата за групе приморајте кориснике  (увезене путем Moodle-група) да се обавезно пријаве и у тој инстанци алата за групе.';
$string['cfg_groups_queues_limit'] = 'Број места на листи чекање по групи';
$string['cfg_groups_queues_limit_desc'] = 'Одређује, стандардно, колико различитих полазника може бити стављено на листу чекање за упис у групу истовремено.';
$string['cfg_grpsize'] = 'Глобална стандардна величина групе';
$string['cfg_grpsize_desc'] = 'Стандардна величина групе која се користи свуда у алату за групу';
$string['cfg_ifgroupdeleted'] = 'Ако се групе oбришу';
$string['cfg_ifgroupdeleted_desc'] = 'Да ли обрисане групе треба поново да буду креиране за инстанцу алата за групе или референце у алату за групу (укључујући податке о групи, пријавама и редоследу) треба обрисати? Напомена: Ако изаберете опцију ”поново креирај групу“, онда ће групе аутоматски поново бити креиране, након брисања под ”Администрација курса / Учесници / Групе”.';
$string['cfg_ifmemberadded'] = 'Ако су чланови групе додати';
$string['cfg_ifmemberadded_desc'] = 'Да ли нови чланови групе, додати преко Moodle група, такође треба да буду пријављени у  алату за групе или треба да буду игнорисани?';
$string['cfg_ifmemberremoved'] = 'Ако су чланови групе уклоњени';
$string['cfg_ifmemberremoved_desc'] = 'Да ли би пријаве помоћу алата за групе требало да буду обрисане ако су корисници обрисани из одговарајуће Moodle-групе?';
$string['cfg_immediate_reg'] = 'Непосредна пријава';
$string['cfg_immediate_reg_desc'] = 'Да ли свака пријава треба да се проследи Moodle-групама?';
$string['cfg_importfields'] = 'Упоредите поља за увоз/одјаву';
$string['cfg_importfields_desc'] = 'Дефинише која поља у табели корисника треба да се упореде са подацима приликом увоза/одјаве корисника. Поља се претражују једно по једно док се не пронађе јединствено подударање. Могуће/корисне вредности су на пример: корисничко име, ID број, е-адреса. ПАЖЊА: тачни називи поља се не проверавају. Дозвољени знакови: а-з, А-З и \',\'';
$string['cfg_instance_head'] = 'Подразумевана подешавања инстанце';
$string['cfg_instance_head_info'] = 'Подразумевана подешавања за нове инстанце алата за групе.';
$string['cfg_max_queues'] = 'Максималан број истовремених места на листама чекања, по учеснику';
$string['cfg_max_queues_desc'] = 'Одређује у колико различитих група се корисник, стандардно, може наћи на листи чекања.';
$string['cfg_moodlesync_head'] = 'Понашање приликом синхронизације';
$string['cfg_moodlesync_head_info'] = 'Како би алати за групе требало да се понашају ако се чланови Moodle групе додају/oбришу  или ако се обришу појединачне групе';
$string['cfg_name_scheme'] = 'Стандардни називи схема';
$string['cfg_name_scheme_desc'] = 'Стандардни називи схема који се користе за креирање групе';
$string['cfg_show_add_info'] = 'Прикажите додатне информације о групи приликом самосталног пријављивања';
$string['cfg_show_add_info_desc'] = 'Прикажите додатне информације о Moodle групи као што су описи или слике на картици за пријаву';
$string['cfg_show_members'] = 'Прикажи чланове групе';
$string['cfg_show_members_desc'] = 'Одређује да ли чланови групе треба, стандардно, да буду видљиви';
$string['cfg_use_individual'] = 'Користите индивидуалну величину';
$string['cfg_use_individual_desc'] = 'Да ли, стандардно, треба користити величину индивидуалне групе за сваку групу';
$string['cfg_use_queue'] = 'Користите листе чекања';
$string['cfg_use_queue_desc'] = 'Да ли, стандардно, треба користити листе чекања за упис у групе које су попуњене';
$string['cfg_use_size'] = 'Користите величину групе';
$string['cfg_use_size_desc'] = 'Да ли величина групе треба, стандардно, да буде ограничена';
$string['cfg_users_queues_limit'] = 'Број места на листи чекање по кориснику';
$string['cfg_users_queues_limit_desc'] = 'Одређује у колико различитих група се корисник, стандардно, може наћи на листи чекања.';
$string['change_group'] = 'Промени групу';
$string['change_group_to'] = 'Да ли желите ли да наставите са променом групе у <strong>{$a->groupname}</strong>?';
$string['change_group_to_success'] = 'Промена групе је успела! Корисник <strong>{$a->username}</strong> сада је пребачен у групу <strong>{$a->groupname}</strong>!';
$string['changes_saved'] = 'Промене су сачуване';
$string['checkbox_control_header'] = 'Поништите избор/изаберите групе и груписања';
$string['checkbox_control_header_help'] = '<p>Коришћењем ове функције можете активирати/деактивирати групе једног или више груписања унутар вашег алата за групе:
    <ol>
        <li>У пољу за вишеструки избор можете изабрати "Све" (све доступне групе биће активиране/деактивиране), једно груписање или више груписања (преласком на избор бише ставки тако што ћете употребити иконицу поред и комбинацију тастера Ctrl + Click).</li>
        <li>Користите једну од следећих опција "Изаберите/ Поништите избор/ Инвертујте избор":
            <ul>
                <li><b>Изаберите:</b> Групе унутар изабраних груписања биће активиране.</li>
                <li><b>Поништите избор:</b> Групе унутар изабраних груписања биће деактивиране.</li>
                <li><b>Инвертујте избор:</b> Све групе унутар неизабраних груписања биће активиране. </li>
            </ul>
        </li>
        <li>Потврдите свој избор кликом на дугме "Настави".</li>
    </ol>
</p>';
$string['choose'] = 'Изаберите...';
$string['choose_group'] = 'Морате изабрати циљну групу!';
$string['choose_max'] = 'Максималан број група које можете да бирате';
$string['choose_max_text'] = 'Број група који можете да бирате: {$a}</strong>!';
$string['choose_min'] = 'Минималан број група које можете да бирате';
$string['choose_min_max_text'] = 'Морате да изаберете између <strong>{$a->min}</strong> и <strong>{$a->max}</strong> групе/а!';
$string['choose_min_text'] = 'Минималан број група који морате да изаберете: <strong>{$a}</strong>';
$string['choose_minmax_title'] = 'Групе које треба изабрати';
$string['choose_targetgroup_import'] = 'Увезите у групу(е)';
$string['choose_targetgroup_unregister'] = 'Одјави се из групе(а)';
$string['chooseactivity'] = 'Морате да изаберете активност пре него што подаци буду приказани!';
$string['completiondetail:register'] = 'Пријавите се у групе: {$a}';
$string['completionregister'] = 'Полазник мора бити пријављен у групе:';
$string['condition_prevent_access'] = 'Тренутни услови вас спречавају да приступите инстанци алата за групе!';
$string['confirm_delete'] = 'Управо ћете потпуно обрисати групу. Ово ће неповратно уклонити све чланове из ове групе. Да ли сте СИГУРНИ да желите да наставите?';
$string['confirm_delete_title'] = 'Да ли заиста желите да обришете овај елемент?';
$string['copied_grade_feedback'] = 'Групно оцењивање<br />
+Предао: полазник <strong>{$a->student}</strong><br />
+Оценио: предавач <strong>{$a->teacher}</strong><br />
+Датум/време: <strong>{$a->date}</strong><br />
+Повратне информације: <strong>{$a->feedback}</strong>';
$string['copy'] = 'Копирај';
$string['copy_chosen'] = 'Копирај изабрано';
$string['copy_grade_confirm'] = 'Наставити са копирањем ове оцене?';
$string['copy_grade_overwrite_confirm'] = 'Наставити са копирањем ове оцене? Постојеће претходне оцене ће бити замењене!';
$string['copy_grades_confirm'] = 'Наставити са копирањем ових оцена?';
$string['copy_grades_errors'] = 'Дошло је до најмање 1 грешке приликом копирања оцена:';
$string['copy_grades_overwrite_confirm'] = 'Наставити са копирањем ових оцена? Постојеће претходне оцене ће бити замењене!';
$string['copy_grades_success'] = 'Следеће оцене су успешно ажуриране:';
$string['copy_refgrades_feedback'] = 'Копирајте референтне оцене и повратне информације за изабране групе других чланова групе';
$string['copygrade'] = 'Копирај оцену';
$string['could_not_add'] = 'Није могуће додати корисника <strong>{$a->username}</strong> у групу <strong>{$a->groupname}</strong>';
$string['couldnt_move_down'] = 'Није могуће померити групу надоле!';
$string['couldnt_move_up'] = 'Није могуће померити групу нагоре!';
$string['createGroups'] = 'Креирајте групе';
$string['create_1_person_groups'] = 'Креирајте групе са 1 особом';
$string['create_1_person_groups_help'] = 'Креирајте групе једном особом - овде се креира група за сваког изабраног корисника. Поред ознака # и @ можете користити следеће ознаке које ће бити замењене корисничким подацима:
<ul>
<li>[username] - корисничко име корисника</li>
<li>[firstname] - име корисника</li>
<li>[lastname] - презиме корисника</li>
<li>[idnumber] - ID број корисника</li>
</ul>
Ако неки подаци недостају, ознака ће бити замењена са tagnameXX где XX представља број групе.';
$string['create_assign_groupings'] = 'Креирајте/доделите груписање';
$string['create_fromto_groups'] = 'Креирајте групе са бројевима из интервала (тј. од 34 до 89), <strong>без аутоматске расподеле</strong> чланова групе';
$string['create_fromto_groups_help'] = 'Креирајте групе са бројевима из интервала (тј. од 34 до 89) - користите овај режим за креирање (недостајућих) група (тј. Група 4, Група 5, Група 6). Само унесите ограничења и колико цифара желите да користите, барем за називе група (тј. 1, 01, 001, 0001...). Могуће је дефинисати одређену величину групе помоћу опције ”Број чланова групе M”. Неће бити <strong>аутоматске расподеле</strong> чланова групе.';
$string['create_groupings_confirm'] = 'Желите ли да наставите да креирате груписање као што је претходно приказано?';
$string['create_groupings_confirm_problem'] = 'Дошло је до најмање 1 грешке (погледајте горе приказан преглед)!';
$string['create_groups_confirm'] = 'Желите ли да наставите да креирате групе као што је претходно приказано?';
$string['create_groups_confirm_problem'] = 'Приликом покушаја креирања нових група на основу схеме датог називе дошло је до конфликта - погледајте преглед - Moodle групе морају имати јединствене називе. Конфликт може бити због постојећих група са истим називом или грешке у синтакси у шеми за давање назива групама (... нпр. празно, недостаје симбол #).';
$string['create_n_m_groups'] = 'Креирајте N група за M чланова, <strong>без аутоматског додељивања</strong> чланова групе';
$string['create_n_m_groups_help'] = 'Креирајте N група за M чланова - креирајте помоћу овог метода одређени број група (N група) са одређеном величином групе (M чланова), нпр. седам група са по три члана у свакој. Неће бити <strong>аутоматске расподеле</strong> чланова групе.';
$string['createinsertgrouping'] = 'Додај у груписање';
$string['deactivated_group'] = 'Деактивирана група';
$string['deactivated_groups'] = 'Деактивиране групе!';
$string['define_amount_groups'] = 'Дефинишите број група N';
$string['define_amount_groups_help'] = 'Дефинишите број група N - бирате кориснике, са одговарајућом улогом, које желите да користите за креирање групе и уносите жељени број група у текстуално поље Број група N. У поље \'Схема назива\' можете унети схему назива за групе користећи симболе:
<ul>
<li># (биће замењен бројем групе) i</li>
<li>@ (биће замењен словним приказом броја групе)</li>
</ul>
Затим се изабрани корисници распоређују у жељени број група.';
$string['define_amount_members'] = 'Дефинишите број чланова групе  M';
$string['define_amount_members_help'] = 'Дефинишите број чланова групе M - Овде алату за групе дајете информацију колико чланова би свака група, идеално, требало да има. Потребан број група ће аутоматски бити израчунат. Уколико означите да желите  да спречите да последњу група буде са премало корисника, онда ће корисници из ове групи бити прераспоређени на остале групе, уколико њена попуњеност испод 70%.';
$string['delete_reference'] = 'Oбриши из алата за групе';
$string['description'] = 'Опис';
$string['deselect'] = 'Поништите избор';
$string['determinismerror'] = 'Датум завршетка пријављивања не може бити пре датума почетка пријављивања у групе, или датум који је прошао.';
$string['digits'] = 'Минималан број цифара';
$string['disabled'] = 'Онемогућено';
$string['drag'] = 'Премести';
$string['due'] = 'Алат за групе - крајњи рок';
$string['duedate'] = 'Завршетак привљивања';
$string['duedate_help'] = 'Завршетак периода пријављивања у групе. Након овог датума полазници нису више у могућности да се пријаве у групе и предавач добија приступ функцији разрешавања листа чекања за упис у групе.';
$string['duedateno'] = 'Без крајњег рока';
$string['error_activating_group'] = 'Грешка приликом активирања групе <strong>{$a->groupid}</strong> у алату за групе <strong>{$a->grouptoolid}</strong>!';
$string['error_at'] = 'Грешка у';
$string['error_deactivating_group'] = 'Грешка приликом деактивирања групе <strong>{$a->groupid}</strong> у алату за групе <strong>{$a->grouptoolid}</strong>!';
$string['error_getting_data'] = 'Грешка при преузимању података о групи! Податке није послала ниједна група или су добијени подаци за више група!';
$string['error_saving_new_order'] = 'Грешка приликом покушаја да се сачува нови редослед за групе: <strong>{$a}</strong>';
$string['eventagrpcreated'] = 'Активна група је креирана';
$string['eventagrpdeleted'] = 'Активна група је озбрисана';
$string['eventagrpsupdated'] = 'Активне групе су ажуриране';
$string['eventdequeuingstarted'] = 'Почело је уклањање полазника са листе чекања';
$string['eventgroupcreationstarted'] = 'Креирање групе је започето';
$string['eventgroupgraded'] = 'Група је оцењена';
$string['eventgroupingscreated'] = 'Креирана су груписања';
$string['eventgrouprecreated'] = 'Група је изнова креирана';
$string['eventoverviewexported'] = 'Преглед извезеног списка корисника';
$string['eventqueueentrycreated'] = 'Запис на листи чекања је креиран';
$string['eventqueueentrydeleted'] = 'Запис на листи чекања је обрисан';
$string['eventregistrationcreated'] = 'Пријава је креирана';
$string['eventregistrationdeleted'] = 'Пријава је обрисана';
$string['eventregistrationpushstarted'] = 'Почела је пријава';
$string['eventuserimported'] = 'Корисник је увезен';
$string['eventuserlistexported'] = 'Извезен списак корисника';
$string['eventusermoved'] = 'Корисник је премештен';
$string['exceedgroupqueuelimit'] = 'Прекорачење дозвољеног броја места на листи чекања за упис у групу';
$string['exceedgroupsize'] = 'Прекорачење величине групе!';
$string['exceeduserqueuelimit'] = 'Прекорачење броја корисника на листи чекања';
$string['exceeduserreglimit'] = 'Прекорачење броја корисника пријављених за групу';
$string['feedbackplural'] = 'Повратне информације';
$string['filters_legend'] = 'Филтрирајте податке';
$string['filterunoccupied'] = 'Прикажи само групе са слободним местима';
$string['followchanges'] = 'Пратите промене';
$string['forceregistration'] = 'Обавезна пријава помоћу алата за групе';
$string['forceregistration_help'] = 'Имајте на уму да се групе унутар алата за групе фундаментално разликују од стандардних група на Moodle курсу. Означите поље за потврду ако желите да увезете кориснике у групу алата за групе као и у стандардну Moodle групу.';
$string['found_multiple'] = 'Није могуће идентификовати јединственог корисника, пронађено је више корисника:';
$string['free'] = 'Слободних места';
$string['fromgttoerror'] = 'Вредност \'до\' мора бити већа или једнака вредности \'од\'';
$string['fullgroup'] = 'Група је пуна';
$string['general_information'] = 'Опште информације';
$string['general_registration_exception'] = 'Приликом пријаве у групу дошло је до општег изузетка и није могуће аутоматски утврдити због чега!';
$string['global_userstats'] = '<strong>{$a->reg_users}</strong> од укупно <strong>{$a->users}</strong> корисника је пријављено у групе. Без пријаве је још увек <strong>{$a->notreg_users}</strong> корисник/а.';
$string['grading'] = 'Оцењивање';
$string['grading_activity_title'] = 'Активност';
$string['grading_alt'] = 'Алати за копирање оцена једног члана групе на све остале у групи, било за једну групу или за скуп група.';
$string['grading_filter_select_title'] = 'Група или групе';
$string['grading_filter_select_title_help'] = 'Изаберите коју групу односно групе желите да користите:<ul><li>Без конфликата - све групе, у којима је само 1 члан групе добио оцену за за изабрану активност</li><li>Све - све групе</li><li>"Назив групе" - само посебно одабрана група</li></ul>';
$string['grading_grouping_select_title'] = 'Филтрирање груписања';
$string['group_administration'] = 'Администрација група';
$string['group_administration_alt'] = 'Администрација (активних) група и груписања';
$string['group_assign_error'] = 'Није могуће доделити групу!';
$string['group_assign_error_prev'] = 'Није могуће доделити групу!';
$string['group_creation'] = 'Креирајте групе';
$string['group_creation_alt'] = 'Креирајте групе';
$string['group_creation_failed'] = 'Креирање група није успело!';
$string['group_creation_success'] = 'Успешно креиране групе!';
$string['group_not_found'] = 'Група <strong>{$a->groupid}</strong> није пронађена у алату за групе <strong>{$a->grouptoolid}</strong>!';
$string['group_not_in_grouping'] = 'Изабрана група није члан одабраног груписања!';
$string['group_or_member_count'] = 'Број група/чланова';
$string['group_places'] = 'Број места у групи';
$string['group_places_help'] = 'Поље \'број места у групи\' даје информације (раздвојено обрнутом косом цртом) прво о укупном броју места у групи, затим о броју слободних места и треће о броју места у групи која су већ заузета.';
$string['groupchange_from_non_unique_reg'] = 'Није могуће променити групу јер претходна група није јединствена!';
$string['groupcreation'] = 'Креирање групе';
$string['groupcreationmode'] = 'Режим';
$string['groupfromtodigits'] = 'Од, до &amp; цифре у називима група:';
$string['groupinfo'] = 'Информације о групи';
$string['grouping_assign_error'] = 'Није могуће успешно доделити груписање:';
$string['grouping_assign_error_prev'] = 'Не може успешно бити додељено груписању:';
$string['grouping_assign_success'] = 'Успешно су додељени груписању:';
$string['grouping_assign_success_prev'] = 'Може се успешно доделити:';
$string['grouping_creation_error'] = 'Није могуће креирати груписање!';
$string['grouping_creation_error_prev'] = 'Није могуће креирати груписање!';
$string['grouping_creation_only_success'] = 'Груписање је успешно креирано!';
$string['grouping_creation_only_success_prev'] = 'Груписање се може успешно креирати!';
$string['grouping_creation_success'] = 'Успешно је креирано груписање и њему додељена група <strong>{$a}</strong>';
$string['grouping_creation_success_prev'] = 'Може успешно да се креира груписање и њему додели група <strong>{$a}</strong>';
$string['grouping_exists_error'] = 'Није било могуће креирати груписање јер већ постоји груписање са овим називом!';
$string['grouping_exists_error_prev'] = 'Није могуће креирати груписање јер већ постоји груписање са овим називом!';
$string['groupings_created_and_groups_added'] = 'Груписање је креиранo и/или групе додате!';
$string['groupingscreation'] = 'Креирајте и доделите груписања';
$string['groupingselect'] = 'Груписања за изабране групе';
$string['groupingselect_help'] = 'Креирајте груписање за изабране групе:<ul>
<li>Креирајте ЈЕДНО груписање за све изабране групе. Назив груписања се може слободно бирати.</li>
<li>Креирајте груписање за СВАКУ изабрану групу. Груписање ће бити названо према одговарајућој групи.</li>
<li>Додајте изабране групе у постојеће груписање</li></ul>';
$string['groupoverview'] = 'Преглед групе';
$string['groups_created'] = 'Групе су успешно креиране!';
$string['groups_queues_limit'] = 'Број места на листи чекање по групи';
$string['groups_queues_limit_help'] = 'Ограничава број доступних места на листи чекања по групи, ако је група активирана';
$string['groupselection'] = 'Избор групе';
$string['groupselection_help'] = 'Изаберите групе/особе за које желите да копирате изабрану референтну оцену и повратну информацију тако што ћете активирати одговарајућа поља за потврду. Ако је приказана само 1 група, бирате извор за копирање изабране оцене користећи одговарајуће дугме десно од уноса.';
$string['groupsize'] = 'Величина групе';
$string['groupsize_gets_enabled'] = 'Ако наставите, величина групе биће аутоматски омогућена. Спречите ово понашање коришћењем 0 као <strong>{$a->field}</strong>';
$string['groupsize_individual_gets_enabled'] = 'Ако наставите, индивидуална величина група биће аутоматски омогућена. Спречите ово понашање коришћењем 0 као <strong>{$a->field}</strong> како не бисте уопште користили величину групе или употребите <strong>{$a->globalsize}</strong> како бисте омогућили само глобалну величину група!';
$string['groupstatus'] = 'Статус';
$string['groupstatus_help'] = 'Тренутни статус групе је визуелизован бојом:<ul><li>Зелено - активна група. Група је додељена овом алату за групе. Ако је самостална пријава активна, полазници могу да се пријаве у ову групу.</li><li>Сиво - неактивна група. Група није доступна у овом алату за групе.</li></ul>Кликом на симбол статуса, исти се може променити.';
$string['grouptool'] = 'Алат за групе';
$string['grouptool:addinstance'] = 'Додавање инстанце Алата за групе на курс';
$string['grouptool:administrate_groups'] = 'Администрација (активних) група и груписања';
$string['grouptool:create_groupings'] = 'Креирање груписања помоћу алата за групе.';
$string['grouptool:create_groups'] = 'Креирање група помоћу алата за групе.';
$string['grouptool:export'] = 'Извезите податке о групама и пријавама у различите формате';
$string['grouptool:grade'] = 'Копирајте оцене члана групе осталим члановима групе';
$string['grouptool:grade_own_group'] = 'Копирајте оцене члана групе осталим члановима групе ако сам ја дао оригиналну оцену';
$string['grouptool:move_students'] = 'Премести полазнике у друге групе.';
$string['grouptool:register'] = 'Пријавите се у активу групу помоћу алата за групу';
$string['grouptool:register_students'] = 'Пријавите полазнике у активну групу користећи алат за групу. (Такође се користи за решавање листа чекања)';
$string['grouptool:unregister_students'] = 'Одјављивање полазника из група помоћу алата за групе.';
$string['grouptool:view_description'] = 'Приказ описа алата за групе';
$string['grouptool:view_groups'] = 'Приказ активних група';
$string['grouptool:view_own_registration'] = 'Приказ сопствених пријава';
$string['grouptool:view_registrations'] = 'Погледајте ко је пријављен / на листи чекања,  и у којој активној групи, помоћу алат за групе';
$string['grouptool:view_regs_course_overview'] = 'Приказ списка корисника која садржи имена оних који су  пријављени / на листи чекања, и у којој активној групи, помоћу алата за групе.';
$string['grouptool:view_regs_course_view'] = 'Приказ списка корисника која садржи имена оних који су  пријављени / на листи чекања, и у којој активној групи, помоћу алата за групе.';
$string['grouptool:view_regs_group_overview'] = 'Приказ груписаног списка која садржи имена оних који су  пријављени / на листи чекања, и у којој активној групи, помоћу алата за групе.';
$string['grouptool:view_regs_group_view'] = 'Приказ груписаног списка која садржи имена оних који су  пријављени / на листи чекања, и у којој активној групи, помоћу алата за групе.';
$string['grouptoolfieldset'] = 'Подешавања инстанце';
$string['grouptoolname'] = 'Назив алата за групе';
$string['grouptoolname_help'] = 'Назив инстанце алата за групе';
$string['groupuser_import'] = 'Увезите кориснике групе';
$string['groupuser_unregister'] = 'Одјавите кориснике групе';
$string['grp_marked'] = 'Означено за пријављивање';
$string['grpsizezeroerror'] = 'Величина групе мора бити већа или једнака 1. Слова или други знаци нису дозвољени.';
$string['ifgroupdeleted'] = 'Ако се групе oбришу';
$string['ifgroupdeleted_help'] = 'Да ли обрисане групе треба поново да се креирају за инстанцу алата за групе, односно да ли треба да се обришу референце у алату за групу (додатни подаци о групи, пријаве и листа чекања)? Напомена: Ако изаберете "креирај групу поново“, групе ће аутоматски бити поново креиране након брисања под "Администрација курса / Корисници / Групе".';
$string['ifmemberadded'] = 'Ако се чланови групе буду додати';
$string['ifmemberadded_help'] = 'Да ли нови чланови групе који су додати преко Moodlea, такође треба да буду пријављени у алату за групе или их треба игнорисати?';
$string['ifmemberremoved'] = 'Ако чланови групе буду уклоњени';
$string['ifmemberremoved_help'] = 'Да ли би пријаве помоћу алата за групе требало да буду обрисане ако су корисници обрисани из одговарајуће Moodle групе';
$string['ignorechanges'] = 'Игноришите промене';
$string['ignored_not_found_users'] = 'Није могуће додати најмање једног корисника у групу!';
$string['ignored_not_found_users_unregister'] = 'Најмање један корисник није пронађен!';
$string['ignoring_not_found_users'] = 'Најмање један корисник није пронађен у бази података. Сви такви корисници ће бити игнорисани!';
$string['immediate_reg'] = 'Непосредна пријава';
$string['immediate_reg_help'] = 'Ако је омогућено, пријаве/одјаве ће бити прослеђене Moodle-систему. Ако није омогућено, пријаве се кеширају у алату за групе и предавач их може проследити Moodle систему.';
$string['import'] = 'Увоз';
$string['import_conflict_user_queued'] = 'Корисник <strong>{$a->fullname}</strong> се већ налази на листи чекања за упис у групу <strong>{$a->groupname}</strong>!';
$string['import_desc'] = 'Увезите кориснике у одговрајуће групе помоћу списка ID бројева';
$string['import_in_inactive_group_rejected'] = 'Пријава за групу <strong>{$a}</strong> помоћу алата за групе је одбијена услед њене неактивности. Активирајте групу у овом алату за групу како бисте омогућили пријаву.';
$string['import_in_inactive_group_warning'] = 'Напомена: група <strong>{$a}</strong> је тренутно неактивна у контексту алатa за групе и стога неће бити приказана.';
$string['import_progress_completed'] = 'Увоз је завршен';
$string['import_progress_import'] = 'Увези корисника';
$string['import_progress_preview_completed'] = 'Преглед увоза је завршен';
$string['import_progress_search'] = 'Претражите корисника';
$string['import_progress_start'] = 'Започните увоз';
$string['import_skipped'] = 'Прескочен корисник <strong>{$a->fullname}</strong> за групу <strong>{$a->groupname}</strong>!';
$string['import_user'] = 'Увоз корисника <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) у групу <strong>{$a->groupname}</strong> је успео.';
$string['import_user_prev'] = 'Увоз корисника <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) у групу <strong>{$a->groupname}</strong>.';
$string['import_user_problem'] = 'Проблем током увоза корисника <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong> - <strong>{$a->id}</strong>) у групу <strong>{$a->groupname}</strong>.';
$string['importbutton'] = 'Увезите кориснике';
$string['inactive'] = 'Неактивна група';
$string['inactivegroups'] = 'Неактивне групе';
$string['inactivegroups_hide'] = 'Сакриј неактивне групе';
$string['inactivegroups_show'] = 'Прикажи неактивне групе';
$string['includedeleted'] = 'Укључи обрисане кориснике';
$string['includedeleted_help'] = 'Ако је означено, обрисани корисници неће бити филтрирани на списку. Обрисани налози тј. корисници не могу бити уписани на курс током увоза.';
$string['includeonlyactiveenrol'] = 'Укључи само активне полазнике';
$string['includeonlyactiveenrol_help'] = 'Ако је ова опција омогућена, суспендовани корисници неће бити укључени у групе.';
$string['incomplete_only_label'] = 'Прикажите само групе којима недостају оцене';
$string['incorrect_tab'] = 'Погрешна картица, ова картица није доступна!';
$string['individual_size_info'] = 'Величина групе у подешавањима алата за групе';
$string['intro'] = 'Опис';
$string['invert'] = 'Инвертујте избор';
$string['landscape'] = 'Хоризонталнo';
$string['limit'] = 'лимит';
$string['loading'] = 'учитавање...';
$string['max_queues_reached'] = 'Достигнут је максимални број места на листи чекања!';
$string['max_regs_reached'] = 'Достигнут максималан број пријављених!';
$string['maxmembers'] = 'Глобална величина групе';
$string['messageprovider:grouptool_moveupreg'] = 'Пријава корисника са листе чекања за упис у групу';
$string['missing_source_selection'] = 'Није изабран извор!';
$string['modulename'] = 'Алат за групе';
$string['modulename_help'] = 'Модул ”Алат за групе” служи за различите задатке који су везани за групе:<ul><li>модул омогућава креирање група у различитим режимима (број група/чланова групе, групе са једном особом, интервал група), као и груписања за сваку групу;</li><li>штавише, може се користити како би се полазницима пружила могућност да се пријаве у одређене групе током дефинисаног временског периода;</li><li>модул, такође, има могућност групног оцењивања - тј. копирања оцена активности са једног на остале чланове групе;</li><li>увоз корисника у групе путем списка ID бројева;</li><li>преглед свих група на курсу укључујући све пријаве, чланове, листе чекања за упис итд., као и  могућност извоза ових података у датотеке у различитим форматима (PDF/XLSX/ODS/TXT);</li><li>списак свих корисника на курсу (који се може експортовати), укључујући њихове пријаве, листе чекања за упис итд.</li></ul><p>(!) Имајте на уму да се групе унутар алата за групе фундаментално разликују од стандардних група на Moodle курсу. Како бисте осигурали конзистентност између различитих типова група, подесите параметре у секцији "Понашање приликом промена у Moodleu" на ”пратити промене”.</p>';
$string['modulenameplural'] = 'Алати за групе';
$string['moodlesync'] = 'Понашање приликом промена у Moodleu';
$string['moodlesync_help'] = 'Како би алати за групе требало да се понашају ако се чланови Moodle група додају/обришу или ако се обришу појединачне групе';
$string['moreregsthanpossible'] = 'Број пријава који је потребан за завршетак активности, не може бити већи од максимално дозвољеног броја пријава';
$string['move_user'] = 'Преместите корисника са листе чекања у групу';
$string['movedown'] = 'Помери 1 место надоле';
$string['moveup'] = 'Помери 1 место нагоре';
$string['multiple'] = 'Управљање корисницима групе';
$string['multiple_desc'] = 'Вишеструке пријаве/одјаве';
$string['must_specify_groupingname'] = 'Морате да наведете назив за груписање!';
$string['mustbegt0'] = 'Минималан број група које можете да бирате мора бити већи или једнак 1. Слова или други знаци нису дозвољени.';
$string['mustbegtoeqmin'] = 'Мора бити већи или једнак минимуму';
$string['mustbeposint'] = 'Максималан број група које можете да бирате мора бити већи или једнак 1. Слова или други знаци нису дозвољени.';
$string['mygroups_only_label'] = 'Прикажи само изворе које сам оценио';
$string['myoverview_registrations_missing'] = 'Недостају пријаве';
$string['name_scheme_tags'] = '<span class="tag firstname">[firstname]</span>
<span class="tag lastname">[lastname]</span>
<span class="tag idnumber">[idnumber]</span>
<span class="tag username">[username]</span>
<span class="tag alpha">@</span>
<span class="tag number">#</span>';
$string['nameschemenotunique'] = 'Називи група из ове шеме назива нису јединствени (<strong>{$a}</strong>). Изаберите други назив или користите знак # (нумерички индекс) односно @ (азбучни индекс) како бисте креирали јединственe називе група.';
$string['namingscheme'] = 'Схема назива групе';
$string['namingscheme_help'] = '<p>Схема назива група дефиниеш како ће групе бити назване аутоматски када се додају нове групе.</p>
<p>Молимо вас, имајте на уму следеће:<br />
<ol><li>Назив групе мора да буде јединствен унутар вашег курса. </li>
<li>Уколико желите да креирате више група одједном, морате да користите ознаке како бисте креирали јединствена имена. </li></ol></p>
<p>Свака од ових ознака биће замењена у коначним називима група. Ознаке у угластим заградама ( [ ] ) тичу се података о кориснику, док ће симболи # и @ бити замењени серијским бројем групе. Ако је JavaScript омогућен можете једноставно да кликнете на ознаке како бисте их додали схеми назива. Имајте на уму да називи група морају бити јединствени на сваком курсу и стога ћете можда морати да мењате схему назива све док не буде подесили схему са јединственим називима.</p>';
$string['no_conflictfree_to_display'] = 'Нема група са јединственим називом које могу да буду приказане. Уместо тога покушавамо да прикажемо све групе!';
$string['no_data_to_display'] = 'Нема података о групи/ама за приказ!';
$string['no_grades_present'] = 'Нема оцена за приказ';
$string['no_groupmembers_to_display'] = 'Нема чланова групе за приказ. Зато покушавамо да уместо тога прикажемо све групе!';
$string['no_groups_to_display'] = 'Нема група за приказ!';
$string['no_queues_to_resolve'] = 'Нема листе чекања коју треба разрешити!';
$string['no_registrations'] = 'Без пријава';
$string['no_target_selected'] = 'Не постоји одредиште за изабрану операцију копирања. Морате да изаберете најмање 1 одредиште!';
$string['no_users_to_display'] = 'Нема корисника за приказ!';
$string['noaccess'] = 'Немате приступ овом модулу (можда не припадате правој групи?)!';
$string['nobody_queued'] = 'Нико није био на листи чекања';
$string['nodeletion'] = 'Брисање ове групе је онемогућено, јер је бар једна инстанца алата за групе на овом курсу подешена тако да поново креира групу након брисања!';
$string['nogroupingselected'] = 'Није изабрано ниједно груписање!';
$string['nogroups'] = 'Нема група на овом курсу.';
$string['nogroupsactive'] = 'Нема активних група у овом алату за групе.';
$string['nogroupschoose'] = 'Изаберите групе';
$string['nogroupscreate'] = 'Креирајте групе';
$string['nogroupsinactive'] = 'Нема неактивних група у овом алату за групе.';
$string['nogrouptools'] = 'Нема алата за групе!';
$string['nonconflicting'] = 'Без конфликта';
$string['noregistrationdue'] = 'неограничено';
$string['nosmallgroups'] = 'Спречите мале групе';
$string['nosmallgroups_help'] = 'Ако је ова опција омогућена, онда ће барем 70% сваке група бити попуњено! Ако би нека (тачније, последња) група била попуњена мање од 70% корисници ове групе биће распоређени у друге групе, што ће за последицу имати да те групе имају више чланова него што је наведено!';
$string['not_allowed_to_show_members'] = 'Немате дозволу да видите ове информације!';
$string['not_graded_by_me'] = 'Оценио други корисник';
$string['not_in_queue_or_registered'] = 'Корисник <strong>{$a->username}</strong> није пријављен/а нити се налази на листи чекања за упис у групу <strong>{$a->groupname}</strong>';
$string['not_permitted'] = 'Није дозвољено';
$string['not_registered'] = 'Још нисте пријављени!';
$string['not_synced_reg_present'] = 'нису присутне синхронизоване пријаве';
$string['notenoughregs'] = 'Кориснику је потребно више пријава!';
$string['nothing_to_push'] = 'Ништа за прослеђивање!';
$string['notification:group_recreated'] = 'Група <a href="{$a->groupurl}" title="{$a->groupname}">{$a->groupname}</a> је поново креирана јер је алат за групе <a href="{$a->grouptoolurl}" title="{$a->grouptoolname}">{$a->grouptoolname}</a> подешен тако да поново креира обрисане групе.';
$string['notification:registrations_recreated'] = 'Чланови групе <a href="{$a->groupurl}" title="{$a->groupname}">{$a->groupname}</a> су поново додати јер је алат за групе <a href="{$a->grouptoolurl}" title="{$a->grouptoolname}">$a->grouptoolname}</a> подешен тако да поново креира обрисане групе. Сама група је поново креирана од стране друге инстанце алата за групе.';
$string['nowhere_queued'] = 'Није на листи чекања';
$string['number_of_groups'] = 'Број група N';
$string['number_of_members'] = 'Број чланова групе M';
$string['number_of_students'] = 'Број полазника';
$string['occupied'] = 'Заузето';
$string['onenewgrouping'] = 'У ЈЕДНО ново груписање';
$string['onenewgroupingpergroup'] = 'Једно груписање ПО групи';
$string['open_group_message'] = 'Отворите групне поруке';
$string['orientation'] = 'PDF-оријентација';
$string['outdated'] = 'застарело';
$string['overflowwarning'] = 'Ако наставите са увозом, величина групе у инстанци <strong>{$a->instancename}</strong> биће премашена!';
$string['overview'] = 'Преглед';
$string['overview_alt'] = 'Преглед група и чланова група';
$string['overview_tab'] = 'Групе';
$string['overview_tab_alt'] = 'Отворите картицу за групе';
$string['overwrite_label'] = 'Замените постојеће оцене';
$string['place_allocated_in_group_success'] = 'Група <strong>{$a->groupname}</strong> је успешно обележена за пријављивање';
$string['pluginadministration'] = 'Администрација алата за групе';
$string['pluginname'] = 'Алат за групе';
$string['portrait'] = 'Вертикално';
$string['preview'] = 'Преглед';
$string['privacy:metadata:agrpid'] = 'Идентификатор репрезентације Moodle групе у алату за групе.';
$string['privacy:metadata:enrolexplanation'] = 'Алат за групе уписује кориснике који већ нису уписани на курс током увоза како би могао да их дода у групу(е).';
$string['privacy:metadata:gradesexplanation'] = 'Алат за групе може да копира оцене једног корисника другим члановима исте групе';
$string['privacy:metadata:groupexplanation'] = 'Алат за групе управља члановима Moodle група.';
$string['privacy:metadata:messageexplanation'] = 'Алат за групе шаље поруке корисницима који се са листе чекања на упис пребацују међу пријављене кориснике.';
$string['privacy:metadata:mod_grouptool_group_filter'] = 'За коју групу филтрирати?';
$string['privacy:metadata:mod_grouptool_mygroups_only'] = 'Треба ли узети у обзир/приказати само сопствене групе.';
$string['privacy:metadata:modified_by'] = 'Идентификатор корисника ако га је неко други изменио.';
$string['privacy:metadata:queued'] = 'Садржи све кориснике на листи чекања.';
$string['privacy:metadata:registered'] = 'Садржи кориснике пријављене у групу и кориснике означене за пријаву.';
$string['privacy:metadata:timestamp'] = 'Датум и време када је запис последњи пут измењен.';
$string['privacy:metadata:userid'] = 'Идентификатор корисника.';
$string['queue'] = 'Листа чекања';
$string['queue_and_multiple_reg_title'] = 'Листе чекања и вишеструке пријаве';
$string['queue_in_group'] = 'Да ли желите да наставите са стављањем корисника <strong>{$a->username}</strong> на листу чекања за упис у групу <strong>{$a->groupname}</strong>?';
$string['queue_in_group_success'] = 'Корисник <strong>{$a->username}</strong> је успешно стављен/а на листу чекања за упис у групу <strong>{$a->groupname}</strong>!';
$string['queue_you_in_group'] = 'Да ли желите да будете стављени на листу чекања за упис у групу <strong>{$a->groupname}</strong>?';
$string['queue_you_in_group_success'] = 'Успешно сте додати на листу чекања за упис у групу <strong>{$a->groupname}</strong>!';
$string['queued'] = 'На листи чекања';
$string['queued_in_group_info'] = 'Корисник {$a->username}</strong> је успешно стављен на листу чекања за упис у групу <strong>{$a->groupname}</strong>';
$string['queued_on_rank'] = 'На листи чекања на месту #{$a}';
$string['queueing_is'] = 'На листи чекања је';
$string['queues'] = 'Листе чекања';
$string['queues_max'] = 'Максималан број истовремених места на листама чекања, по учеснику';
$string['queuesgrp'] = 'Листа чекања и максималан број места на листи';
$string['queuesgrp_help'] = 'Ако су листе чекања омогућене, полазници који покушавају да се пријаве у групу која је попуњена, остају да чекају док се неко не одјави из те групе. Након истека рока предавач има могућност да полазнике премести у друге групе, ако се они и даље налазе на листи чекања, где се групе попуњавају према тренутној позицији полазника на листи. Требало би да дефинишете максималан број група у којима се корисник може наћи на листи чекања.<br />Ово подешавање ограничава максималан број истовремених уписа на листе чекања за сваку особу у овом алату за групу.';
$string['queuesizeerror'] = 'Број места на листи чекања мора бити целобројна вредност већа или једнака 0. Слова или други знаци нису дозвољени.';
$string['queuespresent'] = 'Листе чекања већ постоје! Ако наставите ове листе ће бити oбрисано. За наставак притисните поново дугме \'Сачувај\'!';
$string['queuespresenterror'] = 'Постоје корисници на листама чекања. Не можете деактивирати листе чекања док видите шта ћете са тим корисницима.';
$string['rank'] = 'Ранг';
$string['recreate_group'] = 'Поново креирајте групу';
$string['reference_grade_feedback'] = 'Референтна оцена / Повратне информације';
$string['refresh_table_button'] = 'Освежи преглед';
$string['reg_in_full_group'] = 'Пријава корисника <strong>{$a->username}</strong> у групу <strong>{$a->groupname}</strong> није могућа јер су сва места у групи попуњена!';
$string['reg_not_open'] = 'Пријава тренутно није могућа. Можда је рок за пријаву истекао или уопште није дозвољено пријављивање.';
$string['reg_you_in_full_group'] = 'Пријава у групу <strong>{$a->groupname}</strong> није могућа јер су сва места у групи попуњена!';
$string['register'] = 'Пријавите се';
$string['register_in_group'] = 'Да ли сте сигурни да желите да се пријавите корисника <strong>{$a->username}</strong> у групу <strong>{$a->groupname}</strong>?';
$string['register_in_group_success'] = 'Корисник <strong>{$a->username}</strong> се успешно пријавио/ла у групу <strong>{$a->groupname}</strong>!';
$string['register_you_in_group'] = 'Да ли сте сигурни да желите да се пријавитр у групу <strong>{$a->groupname}</strong>?';
$string['register_you_in_group_success'] = 'Успешно сте се пријавили у групу <strong>{$a->groupname}</strong>!';
$string['register_you_in_group_successmail'] = 'Успешно сте се пријавили у групу <strong>{$a->groupname}</strong>!';
$string['register_you_in_group_successmailhtml'] = 'Успешно сте се пријавили у групу <strong>{$a->groupname}</strong>!';
$string['registered'] = 'Регистрован';
$string['registered_in_group_info'] = 'Корисник {$a->username} је пријављен у групу <strong>{$a->groupname}</strong>';
$string['registered_on_rank'] = 'Пријављен/a за групу на месту #{$a}';
$string['registration_missing'] = 'Недостаје 1 пријава';
$string['registration_period_end'] = 'Крај пријаве за';
$string['registration_period_start'] = 'Почетак пријаве за';
$string['registrationdue'] = 'Завршетак привљивања';
$string['registrationnotification'] = '{$a->course->shortname} -> {$a->modulenameplural} -> {$a->grouptoolname}
----------------------------------------------------------
{$a->message}
----------------------------------------------------------';
$string['registrations'] = 'Група-пријаве';
$string['registrations_missing'] = 'Број пријава које недостају: {$a}';
$string['regpresent'] = 'Корисник је већ {$a}';
$string['rename_failed'] = 'Преименовање није успело!';
$string['renamed_group'] = 'Преименована група!';
$string['require_registration'] = 'Захтевај пријаве';
$string['require_registration_help'] = 'Минимални број група у које полазници треба да се пријаве како би ову активност означили као завршену. Места на листама чекања за упис у групе се,  по правилу, не узимају у обзир. Ако је број већи од 1, потребно је активирати опцију ”Вишеструке пријаве”, а опција ”Максималан број група које можете да бирате“ треба да буде већи или једнак овој вредности';
$string['reset_agrps'] = 'Ресетујте активне групе';
$string['reset_agrps_help'] = 'Ресетује све групе на курсу тј. проглашава их неактивним за алат за групе. Ово ће такође обрисати све пријаве за упис у групе као и листе чекања за упис у групе на овомг курсу!';
$string['reset_queues'] = 'Ресетујте листе чекања';
$string['reset_queues_help'] = 'Листе чекања се аутоматски бришу ако се активне групе ресетују.';
$string['reset_registrations'] = 'Ресетујте пријавe';
$string['reset_registrations_help'] = 'Пријаве се аутоматски бришу ако се активне групе ресетују.';
$string['reset_transparent_unreg'] = 'Одјавите све одбачене чланове групе';
$string['reset_transparent_unreg_help'] = 'Уклоните све кориснике из оних група које је алат за групе приказао активним';
$string['resize'] = 'Промените величину групе';
$string['resized_group'] = 'Промењена величина групе!';
$string['resolve_queue'] = 'Разрешите листе чекања';
$string['resolve_queue_legend'] = 'Разрешите листе чекања';
$string['resolve_queue_title'] = 'Разрешите листе чекања';
$string['search:activity'] = 'Алат за групе – информације о активности';
$string['select'] = 'Изаберите';
$string['selected'] = 'Изабрано';
$string['selectfromcohort'] = 'Изаберите чланове из кохорте';
$string['selectfromgroup'] = 'Изаберите чланове из групе';
$string['selectfromgroup_help'] = 'Расподелите само чланове дате групе у новокреиране групе';
$string['selectfromgrouping'] = 'Изаберите чланове из груписања';
$string['selectfromgrouping_help'] = 'Расподелите само чланове датог груписања у новокреиране групе';
$string['selectmultiple'] = 'изаберите више';
$string['selectsingle'] = 'изаберите једну';
$string['selfregistration'] = 'Пријављивање';
$string['selfregistration_alt'] = 'Региструјте се у једну или више група (у зависности од подешавања)';
$string['setactive'] = 'Активирај';
$string['setinactive'] = 'Деактивирај';
$string['settingspage'] = 'Уредите подешавања групе';
$string['show_members'] = 'Прикажи чланове групе';
$string['show_members_help'] = 'Омогућава полазницима да (под одређеним околностима) виде ко је већ пријављен у групу.<br />
<ul>
    <li><strong>Не:</strong> уопште не приказује чланове групе</li>
    <li><strong>Све групе - после рока:</strong> приказује чланове свих група након рока за пријаву</li>
    <li><strong>Сопствене групе - после рока:</strong> приказује само чланове оних група у којима је корисник члан, након истека рока за пријаву</li>
    <li><strong>Сопствене групе - након пријаве:</strong> приказује чланове оних група у којима је корисник члан, након што се он/она пријавио/ла односно, након што га/ју је неко други пријавио</li>
    <li><strong>Да:</strong> приказује све чланове</li>
</ul>';
$string['showafterdue'] = 'Све групе - после рока';
$string['showownafterdue'] = 'Сопствене групе - после рока';
$string['showownafterreg'] = 'Сопствене групе - након пријаве';
$string['size'] = 'Величина групе';
$string['size_grp'] = 'Подешавања величине групе';
$string['size_grp_help'] = 'Ако је активирана величина групе, максимални број чланова за сваку групу се ограничава (подешава се за целу инстанцу преко текстуалног поља). Ако је додатно активирана опција "индивидуална величина", величина за сваку групу може се дефинисати на следећем списку.';
$string['skipped'] = 'Прескочено';
$string['sortlist_no_data'] = 'У овом тренутку нема група!';
$string['source'] = 'Извор';
$string['source_missing'] = 'Нема извора за копирање!';
$string['sources_missing'] = 'Постоји најмање 1 група без изабраног извора из којег треба копирати!';
$string['start'] = 'Започни';
$string['status'] = 'Статус';
$string['status_help'] = '<ul>
<li><strong>✔</strong> регистрован у Moodle-групи и алату за групе</li>
<li><strong>?</strong> регистрован у Moodle-групи али не и у алату за групе</li>
<li><strong>+</strong> регистрован у алату за групе али не и у Moodle-групи</li>
<li><strong>1, 2, 3...</strong> на лисити чекања у алату за групе</li>
</ul>';
$string['successfully_deleted_groups'] = 'Групе су успешно обрисане!';
$string['switched_to_all_groups'] = 'Промењен групни филтер на све групе!';
$string['target'] = 'Одредиште';
$string['too_many_queue_places'] = 'Није могуће додати корисника <strong>{$a->username}</strong> на листу чекања за упис у групу <strong>{$a->groupname}</strong> зато што је већ на листама чекања за превише група!';
$string['too_many_regs'] = 'Корисник је већ пријављен/на листи чекања у превише група!';
$string['toolessregspresent'] = 'Најмање 1 корисник је пријављен у премало група, стога минимални број група који се може бирати мора бити највише {$a}.';
$string['toomanyregs'] = 'Пажња: У најмање једној групи има више чланова него што је наведено у подешавањима за величину групе.<br />Смањите број чланова у групама пре него што промените величину групе.';
$string['toomanyregspresent'] = 'Најмање 1 корисник је пријављен у превише група, стога максималан број група који се може бирати мора бити најмање {$a}.';
$string['total'] = 'Укупно';
$string['unqueue'] = 'Уклоните са листе чекања';
$string['unqueue_from_group'] = 'Да ли желите да наставите са уклањањем корисника <strong>{$a->username}</strong> са листе чекања на упис у групу <strong>{$a->groupname}</strong>?';
$string['unqueue_from_group_success'] = 'Корисник <strong>{$a->username}</strong> је успешно уклоњен/а са листе чекања ѕа упис у групу <strong>{$a->groupname}</strong>!';
$string['unqueue_you_from_group'] = 'Наставите уклањање корисника са листе чекања за групу <strong>{$a->groupname}</strong>?';
$string['unqueue_you_from_group_success'] = 'Успешно сте уклоњени са листе чекања за упис у групу <strong>{$a->groupname}</strong>!';
$string['unreg'] = 'Одјава';
$string['unreg_from_group'] = 'Наставите са одјавом корисника <strong>{$a->username}</strong> из групе <strong>{$a->groupname}</strong>?';
$string['unreg_from_group_success'] = 'Корисник <strong>{$a->username}</strong> је успешно одјaвљен/а из групе <strong>{$a->groupname}</strong>!';
$string['unreg_is'] = 'Одјава';
$string['unreg_not_allowed'] = 'Одјава није дозвољена!';
$string['unreg_you_from_group'] = 'Наставите са одјављивањем из групе <strong>{$a->groupname}</strong>?';
$string['unreg_you_from_group_success'] = 'Успешно сте одјављени из групе <strong>{$a->groupname}</strong>!';
$string['unregfrommgroups'] = 'Обавезна одјава из алата за групе';
$string['unregfrommgroups_help'] = 'Одјавите кориснике не само из алата за групе, већ и из Мoodle групе.';
$string['unregister'] = 'Одјава';
$string['unregister_conflict_user_not_in_group'] = 'Корисник <strong>{$a->fullname}</strong> није у групи <strong>{$a->groupname}</strong>!';
$string['unregister_desc'] = 'Одјавите више корисника';
$string['unregister_from_inactive_group_warning'] = 'Напомена: група <strong>{$a}</strong> је тренутно неактивна у контексту алатa за групе и стога неће бити приказана.';
$string['unregister_in_inactive_group_warning'] = 'Напомена: група <strong>{$a}</strong> је тренутно неактивна у контексту алатa за групе и стога неће бити приказана.';
$string['unregister_progress_completed'] = 'Одјава је завршена';
$string['unregister_progress_preview_completed'] = 'Преглед одјаве је завршен';
$string['unregister_progress_start'] = 'Започните одјаву';
$string['unregister_progress_unregister'] = 'Одјавите корисника';
$string['unregister_skipped'] = 'Прескочен је корисник <strong>{$a->fullname}</strong> за групу <strong>{$a->groupname}</strong>!';
$string['unregister_user'] = 'Одјава корисника <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) из групе <strong>{$a->groupname}</strong> је успела.';
$string['unregister_user_from_moodle_group'] = 'Одјава корисника <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) из Moodle групе <strong>{$a->groupname}</strong> је успела.';
$string['unregister_user_not_in_group'] = 'Корисник <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) није у Moodle групи <strong>{$a->groupname}</strong>!';
$string['unregister_user_only_in_moodle_group'] = 'Корисник <strong>{$a->fullname}</strong> је само у Moodle групи <strong>{$a->groupname}</strong> али не и у групи алата за групе!';
$string['unregister_user_prev'] = 'Одјава корисника <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) из групе <strong>{$a->groupname}</strong>.';
$string['unregisterbutton'] = 'Одјавите кориснике';
$string['update_grouplist_success'] = 'Успешно ажуриране активне групе!';
$string['updatemdlgrps'] = 'Пријавите се у Moodle групе';
$string['uptodate'] = 'ажурно';
$string['use_all_or_chosen'] = 'Користите све или изабране';
$string['use_all_or_chosen_help'] = 'Изаберите "Све" како бисте креирали груписање за сваку групу на курсу. Користите "Изабране" како бисте креирали груписања само за означене групе.';
$string['use_individual'] = 'Користите индивидуалну величину по групи';
$string['use_individual_help'] = 'Замени глобалну величину групе индивидуалном вредношћу за сваку групу. Ово се подешава путем списка са групама који се може сортирати на дну.';
$string['use_queue'] = 'Користите листе чекања';
$string['use_queue_help'] = 'Полазници могу да се пријаве на листу чекања за групе које су већ попуњене. Ово подешавање се може користити само ако је омогућена самостална пријава полазника и подешено ограничење величине групе.';
$string['use_size'] = 'Активирај';
$string['user'] = 'Корисник';
$string['user_has_too_less_regs'] = 'Одјављивање/уклањање са листе чекања није могуће јер је корисник <strong>{$a->username}</strong> пријављен/а, односно на листи чекања у премало група!';
$string['user_is_deleted'] = 'Пронађени кориснички налог (са ID ознаком <strong>{$a->id}</strong>, и под именом <strong>{$a->fullname}</strong>) је већ обрисан. Стога упис на овај курс није могућ.';
$string['user_move_prev'] = 'Корисник <strong>{$a->user}</strong> биће пребачен/а са листе чекања за упис у групу <strong>{$a->from_group}</strong> у групу <strong>{$a->to_group}</strong>!';
$string['user_moved'] = 'Корисник <strong>{$a->user}</strong> је премештен/а са листе чекања за упис у групу <strong>{$a->from_group}</strong> у групу <strong>{$a->to_group}</strong>!';
$string['user_not_found'] = 'Корисник <strong>{$a}</strong> није пронађен!';
$string['userlist'] = 'Списак корисника';
$string['userlist_alt'] = 'Погледајте списак корисника и њихове пријаве. Извезите податке о корисницима и њиховим групама у различитим форматима (PDF, обичан текст, Excel, итд.).';
$string['userlist_help'] = 'Списак ID бројева одвојених помоћу једног или више следећих знакова<ul><li>[,] зарез</li><li>[;] тачка и зарез</li><li>[ ] размак</li><li>[\\n] нови ред</li><li>[\\r] знак за почетак реда</li><li>[\\t] табулатор</li></ul>';
$string['userlist_tab'] = 'Курсеви';
$string['userlist_tab_alt'] = 'Отворите картицу за курсеве';
$string['users_queues_limit'] = 'Број места на листи чекање по кориснику';
$string['users_queues_limit_help'] = 'Ограничава број доступних места на листи чекања по кориснику ако су листе активиране';
$string['users_tab'] = 'Учесници';
$string['users_tab_alt'] = 'Прикажи учеснике';
$string['view_registrations'] = 'Приказ пријава';
$string['viewmoodlegroups'] = 'Moodle групе';
$string['with_selection'] = 'Са изабраним...';
$string['you_are_already_marked'] = 'Већ сте означили групу <strong>{$a->groupname}</strong> за пријаву!';
$string['you_are_already_queued'] = 'Већ сте на листи чекања за упис у групу <strong>{$a->groupname}</strong>!';
$string['you_are_already_registered'] = 'Већ сте пријављени у групу <strong>{$a->groupname}</strong>!';
$string['you_are_not_in_queue_or_registered'] = 'Нисте пријављени нити на листи чекања за упис у групу <strong>{$a->groupname}</strong>';
$string['you_change_group_to_success'] = 'Промена групе је успела! Сада сте пријављени у групу <strong>{$a->groupname}</strong>!';
$string['you_have_too_less_regs'] = 'Одјављивање/уклањање са листе чекања није могуће јер сте пријављени/на листи чекања у премало група!';
$string['you_have_too_many_queue_places'] = 'Није могуће додати вас на листу чекања за упис у групу <strong>{$a->groupname}</strong> зато што сте већ на листама чекања за превише група!';
$string['your_place_allocated_in_group_success'] = 'Успешно сте означили групу <strong>{$a->groupname}</strong>> за пријављивање';
