<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'sr_cr', version '4.1'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Контрола приступа';
$string['actionaftercorrectanswer'] = 'Акција након тачног одговора';
$string['actionaftercorrectanswer_help'] = 'Након што се тачно одговори на питање, постоје 3 опције за прелазак на следећу страницу:

* Нормално - прати се путања лекције
* Прикажи неприказану страницу - странице се приказују насумично, с тим да се ниједна страница не понавља тј. не приказује се двапут
* Прикажи страницу са неодговореним питањем - странице се приказују насумично, с тим да се понаваљају странице са питањима на које полазник још није дао тачан одговор';
$string['actions'] = 'Акције';
$string['activitylink'] = 'Линк до следеће активности';
$string['activitylink_help'] = 'Уколико желите да на крају лекције прикажете линк ка другој активности на курсу, изаберите активност из падајуће менија.';
$string['activitylinkname'] = 'Иди на {$a}';
$string['activityoverview'] = 'Приближава се рок за завршетак лекција';
$string['addabranchtable'] = 'Додај страницу са садржајем';
$string['addanendofbranch'] = 'Додај крај гране';
$string['addanewpage'] = 'Додај нову страницу';
$string['addaquestionpage'] = 'Додај страницу са питањем';
$string['addaquestionpagehere'] = 'Додај овде страницу са питањем';
$string['addbranchtable'] = 'Додај страницу са садржајем';
$string['addcluster'] = 'Додај групу питања';
$string['addedabranchtable'] = 'Додата је страница са садржајем';
$string['addedanendofbranch'] = 'Додат је крај гране';
$string['addedaquestionpage'] = 'Додата је страница са питањем';
$string['addedcluster'] = 'Додата је група питања';
$string['addedendofcluster'] = 'Додат је крај групе питања';
$string['addendofbranch'] = 'Додај крај гране';
$string['addendofcluster'] = 'Додај крај групе питања';
$string['addessay'] = 'Креирај страницу са есејским питањем';
$string['addmatching'] = 'Креирај страницу са питањем спаривања';
$string['addmultichoice'] = 'Креирај страницу са питањем вишеструког избора';
$string['addnewgroupoverride'] = 'Додај измену за групу';
$string['addnewuseroverride'] = 'Додај измену подешавања за корисника';
$string['addnumerical'] = 'Креирај страницу са нумеричким питањем';
$string['addpage'] = 'Додај страницу';
$string['addshortanswer'] = 'Креирај страницу са питањем кратак одговор';
$string['addtruefalse'] = 'Креирај страницу са питањем тачно/нетачно';
$string['allotheranswers'] = 'Сви други одговори';
$string['allotheranswersjump'] = 'Прелаз свих других одговора';
$string['allotheranswersscore'] = 'Резултат свих других одговора';
$string['allowofflineattempts'] = 'Дозволи офлајн приступ лекцији помоћу мобилне апликација';
$string['allowofflineattempts_help'] = 'Ако је омогућена ова опција, корисник мобилне апликације може да преузме лекцију и приступи јој у офлајн режиму.
Сви могући одговори, као и тачни одговори биће, такође преузети.
Напомена: није могуће приступити лекцији у офлајн режиму ако она има временско ограничење.';
$string['anchortitle'] = 'Почетак главног садржаја';
$string['and'] = 'и';
$string['answer'] = 'Одговор';
$string['answeredcorrectly'] = 'је тачно одговорило';
$string['answersfornumerical'] = 'Одговори за нумеричка питања треба да буду уклопљени парови минималних и максималних вредности';
$string['arrangebuttonshorizontally'] = 'Да ли да дугмад на страници са садржајем буду постављена хоризонтално?';
$string['attempt'] = 'Покушај: {$a}';
$string['attemptheader'] = 'Покушај';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Покушаји';
$string['attemptsdeleted'] = 'Обрисани покушаји';
$string['attemptsremaining'] = 'Број покушаја који вам је преостао: {$a}';
$string['available'] = 'Датум од ког ће бити доступно:';
$string['averagescore'] = 'Просечан број бодова';
$string['averagetime'] = 'Просечно време';
$string['branch'] = 'Садржај';
$string['branchtable'] = 'Садржај';
$string['cachedef_overrides'] = 'Информације о изменама подешавања за кориснике и групе';
$string['cancel'] = 'Откажи';
$string['cannotfindanswer'] = 'Грешка: није могуће наћи одговор';
$string['cannotfindattempt'] = 'Грешка: није могуће наћи покушај';
$string['cannotfindessay'] = 'Грешка: није могуће наћи есеј';
$string['cannotfindfirstgrade'] = 'Грешка: није могуће наћи оцене';
$string['cannotfindfirstpage'] = 'Није могуће наћи прву страну';
$string['cannotfindgrade'] = 'Није могуће наћи оцене';
$string['cannotfindnewestgrade'] = 'Грешка: није могуће наћи најновију оцену';
$string['cannotfindnextpage'] = 'Резервна копија лекције: Следећа страна није пронађена!';
$string['cannotfindpagerecord'] = 'Додај крај гране: запис о страни није пронађен';
$string['cannotfindpages'] = 'Није могуће наћи странице лекције';
$string['cannotfindpagetitle'] = 'Потврда брисања: наслов странице није пронађен';
$string['cannotfindpreattempt'] = 'Запис о претходном покушају није пронађен!';
$string['cannotfindrecords'] = 'Грешка: није могуће записе лекција';
$string['cannotfindtimer'] = 'Грешка: није могуће наћи записе из табеле lesson_timer';
$string['cannotfinduser'] = 'Грешка: није могуће наћи кориснике';
$string['canretake'] = '{$a} може поново да погледа лекцију';
$string['casesensitive'] = 'Користи регуларне изразе';
$string['casesensitive_help'] = 'Означите поље за потврду ако желите да користите регуларне изразе за анализу одговора';
$string['checkbranchtable'] = 'Провери страницу са садржајем';
$string['checkedthisone'] = 'је изабрало овај одговор.';
$string['checknavigation'] = 'Провери навигацију';
$string['checkquestion'] = 'Провери питање';
$string['classstats'] = 'Статистички преглед резултата свих учесника курса';
$string['clicktodownload'] = 'Кликните на следећи линк да бисте преузели датотеку.';
$string['closebeforeopen'] = 'Није могуће ажурирати лекцију. Поставили сте да је датум затварања лекције пре датума њеног отварања.';
$string['cluster'] = 'Група питања';
$string['clusterjump'] = 'Још неприказано питање из групе питања';
$string['clustertitle'] = 'Група питања';
$string['collapsed'] = 'Скупљено';
$string['comments'] = 'Ваши коментари';
$string['completed'] = 'Завршено';
$string['completederror'] = 'Завршите лекцију';
$string['completethefollowingconditions'] = 'Морате да испуните следеће услове у лекцији <b>{$a}</b> да бисте могли да наставите.';
$string['completiondetail:reachend'] = 'Прођите кроз активност до краја';
$string['completiondetail:timespent'] = 'Потрошите на ову активност најмање {$a}';
$string['completionendreached'] = 'Захтевај завршетак лекције';
$string['completionendreached_desc'] = 'Полазник мора да стигне до странице ”Крај лекције” да би завршио ову активност';
$string['completiontimespent'] = 'Полазник мора на овој активности да проведе најмање';
$string['completiontimespentdesc'] = 'Полазник мора на овој активности да проведе најмање {$a}';
$string['completiontimespentgroup'] = 'Захтевај време проведено на лекцији';
$string['conditionsfordependency'] = 'Услови зависности';
$string['configintro'] = 'Вредности овде подешене дефинишу подразумеване вредности које се користе у обрасцу за подешавања када се креира нова лекција. Подешавања означена као напредна  приказују се само када се кликне на линк \'Прикажи више...\'.';
$string['configmaxanswers'] = 'Подразумевани максималан број одговора по страни';
$string['configmediaclose'] = 'Приказује дугме за затварање на искачућем прозору који садржи линк ка мултимедијалној датотеци';
$string['configmediaheight'] = 'Одређује висину искачућег прозора који приказује линк ка мултимедијалној датотеци';
$string['configmediawidth'] = 'Одређује ширину искачућег прозора који приказује линк ка мултимедијалној датотеци';
$string['configpassword_desc'] = 'Да ли је лозинка неопходна да би се приступило лекцији.';
$string['configslideshowbgcolor'] = 'Боја позадине за слајд-шоу уколико је омогућен';
$string['configslideshowheight'] = 'Одређује висину за слајд-шоу уколико је омогућен';
$string['configslideshowwidth'] = 'Одређује ширину за слајд-шоу уколико је омогућен';
$string['configtimelimit_desc'] = 'Ако је постављено временско ограничење приказује се упозорење на почетку лекције и током читања лекције присутна је штоперица која приказује преостало време. Ако је ово подешавање постављено на нулу нема временског ограничења.';
$string['confirmdelete'] = 'Обриши страницу';
$string['confirmdeletionofthispage'] = 'Потврди брисање ове странице';
$string['congratulations'] = 'Честитамо - стигли сте до краја лекције';
$string['continue'] = 'Настави';
$string['continuetoanswer'] = 'Наставите да бисте променили одговоре.';
$string['continuetonextpage'] = 'Идите на следећу страницу';
$string['correctanswerjump'] = 'Тачан одговор води до';
$string['correctanswerscore'] = 'Број бодова који се добија за тачан одговор';
$string['correctresponse'] = 'Повратне информације за тачан одговор';
$string['createaquestionpage'] = 'Креирај страницу са питањем';
$string['credit'] = 'Бодови';
$string['customscoring'] = 'Прилагођено бодовање';
$string['customscoring_help'] = 'Ако је ова опција омогућена. онда се сваком одговору може доделити нумеричка вредност (позитивна или негативна)';
$string['deadline'] = 'Крајњи рок';
$string['defaultessayresponse'] = 'Предавач ће оценити ваш есеј.';
$string['deleteallattempts'] = 'Обриши све покушаје проласка кроз лекцију';
$string['deletedefaults'] = 'Обрисано {$a} x подразумевано за лекцију';
$string['deletedpage'] = 'Страница је обрисана';
$string['deletepagenamed'] = 'Обриши страницу: {$a}';
$string['deleting'] = 'Брисање';
$string['deletingpage'] = 'Брисање странице: {$a}';
$string['dependencyon'] = 'Зависно од';
$string['dependencyon_help'] = 'Ово подешавање допушта да приступ овој лекцији зависи од резултата полазника у другој лекцији истог курса. Може се користити било која комбинација следећих услова: утрошеног времена (време које је полазник потрошио да би урадио лекцију), завршености (да ли је полазник завршио наведену лекцију) и добијене оцене (да ли је полазник добио оцену већу од наведене).';
$string['description'] = 'Опис';
$string['deselectallattempts'] = 'Поништи одабир свих покушаја';
$string['detailedstats'] = 'Детаљна статистика';
$string['didnotanswerquestion'] = 'Нисте одговорили на ово питање.';
$string['didnotreceivecredit'] = 'Нисте добили бодове';
$string['disabled'] = 'Онемогућено';
$string['displaydefaultfeedback'] = 'Користи подразумеване повратне информације';
$string['displaydefaultfeedback_help'] = 'Ако је ова опција омогућена, онда ће, у ситуацији када за неко питање не постоји повратна информација, бити приказана подразумевана повратна информација: "Тачан одговор" односно "Погрешан одговор"';
$string['displayinleftmenu'] = 'Прикажи у менију?';
$string['displayleftif'] = 'Минимална оцена за приказ менија';
$string['displayleftif_help'] = 'Ово подешавање одређује да ли полазник мора да добије одређену оцену како би видео мени лекције. Ово подешавање тера полазника да прође кроз целу лекцију приликом првог покушаја. Тек након што полазник добије потребну оцену може да користи мени са леве стране за преглед лекције.';
$string['displayleftmenu'] = 'Прикажи мени';
$string['displayleftmenu_help'] = 'Ако је ова опција омогућена, биће приказан мени који корисницима даје могућност да се крећу кроз странице лекције.';
$string['displaymode'] = 'Режим приказа';
$string['displayofgrade'] = 'Приказ оцена (само за полазнике)';
$string['displayreview'] = 'Обезбедите могућност за поновни покушај';
$string['displayreview_help'] = 'Ако је ова опција омогућена, у ситуацији када полазник погрешно одговори на питање, биће му понуђено да покуша поново да одговори (без могућности да добије поен) или да настави са лекцијом. Ако студент изабере да настави даље са следећим питањем, онда ће бити праћен изабрани (погрешан) одговор. Стандардно, прелази за погрешне одговоре су подешени на "ова страница" и имају резултат 0, па се препоручује да прелаз за погрешан одговор подесите на неку другу страницу, како бисте избегли забуну код својих полазника.';
$string['displayscorewithessays'] = '<p>Освојили сте {$a->score} од максималних {$a->tempmaxgrade} бодова за питања која се аутоматски оцењују.</p>
<p>Ваш {$a->essayquestions} одговор на питања  у форми есеја биће ускоро прегледан и оцењен, а оцена ће касније бити додата<br />у ваш финални резултат.</p>
<p>Ваша тренутна оцена без есеја је {$a->score} од {$a->grade}</p>';
$string['displayscorewithoutessays'] = 'Ваш резултат је {$a->score} (од могућих {$a->grade}).';
$string['duplicatepagenamed'] = 'Дупликат странице: {$a}';
$string['edit'] = 'Уреди';
$string['editbranchtable'] = 'Уређивање странице са садржајем';
$string['editcluster'] = 'Уређивање групе питања';
$string['editendofbranch'] = 'Уређивање странице крај гране';
$string['editendofcluster'] = 'Уређивање странице крај групе питања';
$string['editessay'] = 'Уређивање странице са есејским питањем';
$string['editinglesson'] = 'Уређивање лекције';
$string['editingquestionpage'] = 'Уређивање странице са питањем типа: {$a}';
$string['editlesson'] = 'Уреди лекцију';
$string['editlessonsettings'] = 'Уреди подешавања лекције';
$string['editmatching'] = 'Уређивање странице са питањем спаривања';
$string['editmultichoice'] = 'Уређивање странице са питањем вишеструког  избора';
$string['editnumerical'] = 'Уређивање странице са нумеричким питањем';
$string['editoverride'] = 'Уреди измену';
$string['editpage'] = 'Уреди садржај странице';
$string['editpagecontent'] = 'Уреди садржај странице';
$string['editquestion'] = 'Уређивање странице са питањем';
$string['editshortanswer'] = 'Уређивање странице са питањем кратак одговор';
$string['edittruefalse'] = 'Уређивање странице са питањем тачно/нетачно';
$string['email'] = 'Е-пошта';
$string['emailallgradedessays'] = 'Пошаљи обавештења о оцењеним есејима';
$string['emailgradedessays'] = 'Пошаљи обавештења о оцењеним есејима';
$string['emailsuccess'] = 'Обавештења су успешно послата';
$string['emptypassword'] = 'Поље за лозинку не може бити празно';
$string['enabled'] = 'Омогућено';
$string['endofbranch'] = 'Крај гране';
$string['endofcluster'] = 'Крај групе питања';
$string['endofclustertitle'] = 'Крај групе питања';
$string['endoflesson'] = 'Крај лекције';
$string['enteredthis'] = 'је одабрало/унело овај одговор';
$string['enterpassword'] = 'Молимо унесите лозинку:';
$string['eolstudentoutoftime'] = 'Упозорење! Истекло вам је време за ову лекцију. Ваш последњи одговор можда није урачунат ако је дат након што је време истекло.';
$string['eolstudentoutoftimenoanswers'] = 'Нисте одговорили ни на једно питање. Ваша оцена за ову лекцију је 0.';
$string['essay'] = 'Есеј';
$string['essayemailmessage2'] = '<p>Есеј:<blockquote>{$a->question}</p><p>Ваш одговор:<em>{$a->response}</em></p><p>Коментар оцењивача:<em>{$a->comment}</em></p><p>Добили сте {$a->earned} од максималних {$a->outof} за овај есеј.</p><p>Ваша оцена за лекцију  {$a->lesson} је промењена на {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Освојили сте {$a->earned} од {$a->outof} поена за ово есејско питање.</p><p>Ваша оцена за лекцију {$a->lesson} је промењена и сада је {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Оцена доступна за питање лекције';
$string['essaynotgradedyet'] = 'Овај есеј још није оцењен';
$string['essayresponses'] = 'Есејски одговори';
$string['essays'] = 'Есеји';
$string['essayscore'] = 'Резултат есеја';
$string['eventcontentpageviewed'] = 'Страница са садржајем приказана';
$string['eventessayassessed'] = 'Есеј оцењен';
$string['eventessayattemptviewed'] = 'Есеј приказан';
$string['eventhighscoreadded'] = 'Најбољи резултат лекције додат';
$string['eventhighscoresviewed'] = 'Листа најбољих резултата лекције приказана';
$string['eventlessonended'] = 'Лекција завршена';
$string['eventlessonrestarted'] = 'Лекција поново започета';
$string['eventlessonresumed'] = 'Лекција настављена';
$string['eventlessonstarted'] = 'Лекција започета';
$string['eventoverridecreated'] = 'Измена подешавања лекције креирана';
$string['eventoverridedeleted'] = 'Измена подешавања лекције обрисана';
$string['eventoverrideupdated'] = 'Измена подешавања лекције ажурирана';
$string['eventpagecreated'] = 'Страница креирана';
$string['eventpagedeleted'] = 'Страница обрисана';
$string['eventpagemoved'] = 'Страница премештена';
$string['eventpageupdated'] = 'Страница ажурирана';
$string['eventquestionanswered'] = 'Одговорено на питање';
$string['eventquestionviewed'] = 'Питање приказано';
$string['false'] = 'Погрешно';
$string['fileformat'] = 'Формат датотеке';
$string['finalwrong'] = 'Не баш.';
$string['finish'] = 'Заврши';
$string['firstanswershould'] = 'Први одговор би требало до води на страницу "Тачно"';
$string['firstwrong'] = 'Погрешно сте одговорили на питање. Да ли желите да покушате поново? (ако сада тачно одговорите на питање, то се неће рачунати у ваш коначан резултат.)';
$string['flowcontrol'] = 'Контрола тока лекције';
$string['fractionsaddwrong'] = 'Позитивне оцене које сте одабрали у збиру не дају 100%<br />Наиме њихов збир је {$a}%<br />Да ли желите да се вратите назад и исправите питање?';
$string['fractionsnomax'] = 'Један од одговора треба да носи 100% оцене, тако да је <br />могуће добити максималну оцену за ово питање.<br />Да ли желите да се вратите назад и исправите ово питање?';
$string['full'] = 'Проширено';
$string['general'] = 'Општа подешавања';
$string['gotoendoflesson'] = 'Иди на крај лекције';
$string['grade'] = 'Оцена';
$string['gradebetterthan'] = 'Оцена виша од (%)';
$string['gradebetterthanerror'] = 'Освојите оцену већу од {$a} процената';
$string['graded'] = 'Оцењено';
$string['gradeessay'] = 'Оцени одговоре на есејски тип питања({$a->notgradedcount} још није оцењено, а {$a->notsentcount} није послато)';
$string['gradeis'] = 'Оцена је {$a}';
$string['gradeoptions'] = 'Опције за оцењивање';
$string['groupoverrides'] = 'Измене подешавања за групе';
$string['groupoverridesdeleted'] = 'Измене подешавања за групе обрисане';
$string['groupsnone'] = 'Не постоје групе којима можете приступити.';
$string['handlingofretakes'] = 'Третман поновних покушаја';
$string['handlingofretakes_help'] = 'Ако су поновни покушаји дозвољени, ово подешавање одређује да ли је оцена за лекцију једнака просечној оцени свих покушаја или највећој оцени.';
$string['havenotgradedyet'] = 'Још није оцењено.';
$string['here'] = 'овде';
$string['highscore'] = 'Најбољи резултат';
$string['hightime'] = 'Најдуже време';
$string['importcount'] = 'Увози се {$a} питања';
$string['importquestions'] = 'Увези питања';
$string['importquestions_help'] = 'Ово својство омогућава да питања у различитим форматима, буду увезена путем текстуалне датотеке.';
$string['inactiveoverridehelp'] = '* Ова измена је неактивна, јер је приступ корисника активности ограничен. То може бити због групе или улоге који су кориснима додељени, због  других ограничења приступа или због тога што је активност скривена.';
$string['indicator:cognitivedepth'] = 'Лекција - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'Лекција\'.';
$string['indicator:cognitivedepthdef'] = 'Лекција - когнитивни аспект';
$string['indicator:cognitivedepthdef_help'] = 'Учесник је постигао овај проценат когнитивног ангажмана који нуде активности Лекција током овог интервала анализе (Нивои = Без прегледа, Преглед, Предаја одговора, Преглед повратних информација, Коментар на повратне информације, Поновна предаја одговора након прегледа повратних информација)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Лекција - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'Лекција\'.';
$string['indicator:socialbreadthdef'] = 'Лекција - социјални аспект';
$string['indicator:socialbreadthdef_help'] = 'Учесник је постигао овај проценат социјалног ангажмана који нуде активности Лекција током овог интервала анализе (Нивои = Без учешћа, Учесник сâм, Учесник са другима)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Страница је уметнута';
$string['invalidfile'] = 'Неисправна датотека';
$string['invalidid'] = 'Није прослеђен ID модула или лекције';
$string['invalidlessonid'] = 'ID лекције није био тачан';
$string['invalidoverrideid'] = 'Неисправна ID ознака измене';
$string['invalidpageid'] = 'Неисправан ID странице';
$string['jump'] = 'Прелаз';
$string['jumps'] = 'Прелази';
$string['jumps_help'] = 'Сваки одговор (за страницу са питањем) или опис (за страницу са садржајем) има одговарајући прелаз. Прелаз може бити релативан, као на пример "текућа страница" или "следећа страница", или апсолутан тј. прелаз на било коју страницу у лекцији.';
$string['jumpsto'] = 'Прелази на <em>{$a}</em>';
$string['leftduringtimed'] = 'Напустили сте лекцију која је временски ограничена.<br />Притисните дугме \'Настави\' како бисте погледали лекцију од почетка.';
$string['leftduringtimednoretake'] = 'Напустили сте лекцију која је временски ограничена и није Вам <br /> дозвољено да наставите или почнете лекцију из почетка.';
$string['leftduringtimedsession'] = 'Изашли сте током лекције која има временско ограничење.';
$string['lesson:addinstance'] = 'Додавање нове лекције';
$string['lesson:edit'] = 'Уреди лекцију';
$string['lesson:grade'] = 'Оцени есејска питања у лекцији';
$string['lesson:manage'] = 'Управљање лекцијом';
$string['lesson:manageoverrides'] = 'Управљање изменама подешавања лекције';
$string['lesson:view'] = 'Прегледај активност лекције';
$string['lesson:viewreports'] = 'Прикажи извештаје о лекцији';
$string['lessonbeingpreviewed'] = 'Лекција се тренутно прегледа.';
$string['lessonclosed'] = 'Ова лекција је затворена дана {$a}.';
$string['lessoncloses'] = 'Лекција се затвара';
$string['lessoneventcloses'] = '{$a} се затвара';
$string['lessoneventopens'] = '{$a} се отвара';
$string['lessonformating'] = 'Форматирање лекције';
$string['lessonmenu'] = 'Мени лекције';
$string['lessonnotready'] = 'Ова лекција још није спремна за коришћење. Молимо контактирајте свог {$a}.';
$string['lessonnotready2'] = 'Ова лекција још није спремна за коришћење';
$string['lessonopen'] = 'Ова лекција ће бити доступна од {$a}.';
$string['lessonopens'] = 'Лекција се отвара';
$string['lessonpagelinkingbroken'] = 'Није пронађена прва страница. Мора да је дошло до прекида линкова између страница лекције. Молимо контактирајте администратора.';
$string['lessonstats'] = 'Статистика лекције';
$string['linkedmedia'] = 'Повезани медији';
$string['loginfail'] = 'Погрешна пријава, молимо покушајте поново...';
$string['lowscore'] = 'Наслабији резултат';
$string['lowtime'] = 'Најкраће време';
$string['manageoverrides'] = 'Управљање изменама';
$string['manualgrading'] = 'Оцени есеје';
$string['matchesanswer'] = 'Поклапа се са одговором';
$string['matching'] = 'Спаривање';
$string['matchingpair'] = 'Спаривање пара {$a}';
$string['maxgrade'] = 'Максимална оцена';
$string['maxgrade_help'] = 'Ово подешавање одређује највећу оцену за лекцију. Уколико је вредност подешена на 0 лекција се неће појавити на страници са оценама.';
$string['maximumnumberofanswersbranches'] = 'Максималан број одговора';
$string['maximumnumberofanswersbranches_help'] = 'Ова вредност одређује максимални број одговора који се могу користити у лекцији. Ако се користе само ТАЧНО/НЕТАЧНО питања тада је разумно поставити ову вредност на 2. Подешавање се може променити било када, пошто утиче само на начин приказа података наставнику, не и на саме податке.';
$string['maximumnumberofattempts'] = 'Максималан број покушаја по питању';
$string['maximumnumberofattempts_help'] = 'Ово подешавање одређује максималан број дозвољених покушаја за свако питање. Уколико се нетачни одговори понављају, када се достигне максималан број покушаја биће приказана следећа страница лекције.';
$string['maximumnumberofattemptsreached'] = 'Достигнут је максималан број покушаја - прелази се на следећу страницу';
$string['mediaclose'] = 'Прикажи дугме за затварање';
$string['mediafile'] = 'Повезана мултимедија';
$string['mediafile_help'] = 'Мултимедијална датотека се може поставити ради коришћења у оквиру лекције. Линк "Кликните овде за приказ" ће се тада приказивати у блоку под насловом "Повезана мултимедија" на свакој страници лекције.';
$string['mediafilepopup'] = 'Кликните овде за приказ';
$string['mediaheight'] = 'Висина искачућег прозора';
$string['mediawidth'] = 'Ширина искачућег прозора';
$string['messageprovider:graded_essay'] = 'Обавештење о оцењеном есеју';
$string['minimumnumberofquestions'] = 'Минималан број питања';
$string['minimumnumberofquestions_help'] = 'Ова подешавање одређује најмањи број питања који ће се користити за израчунавање оцене за активност.';
$string['missingname'] = 'Молимо унесите надимак';
$string['modattempts'] = 'Дозволите полазницима преглед';
$string['modattempts_help'] = 'Ако је ова опција омогућена, полазници ће моћи поново да погледају лекцију од почетка.';
$string['modattemptsnoteacher'] = 'Полазнички преглед функционише само за полазнике.';
$string['modulename'] = 'Лекција';
$string['modulename_help'] = 'Модул \'Лекција\' омогућава предавачу да  презентује садржај и/или практичне активности на интересантан и флексибилан начин. Предавач може да користи лекцију како би креирао линеарни низ страница са садржајем или инструкције које нуде различите путање или опције за корисника. У оба случај предавачи могу да повећају ангажман полазника и да обезбедe разумевање градива, тако што ће на крају странице додати различите типове питања, укључујући вишеструки избор, спаривање, кратак одговор и др. Зависно од изабраног одговора, као и од тога како је предавач организовао лекцију, полазници могу да напредују на следећу страницу, буду враћени на претходну или преусмерени на неку другу страницу лекције.

Лекције могу да се оцењују, а оцене уписују у књигу оцена.

Лекција може да се користи:

* за самостално учење нових садржаја
* за сценарија или симулације/вежбе доношење одлука
* за исправку наученог градива, са различитим сетовима питања у зависности од одговора датих на почетна питања';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Лекције';
$string['move'] = 'Премести страницу';
$string['movedpage'] = 'Страница је премештена';
$string['movepagehere'] = 'Овде премести страницу';
$string['movepagenamed'] = 'Премести страницу: {$a}';
$string['moving'] = 'Премештање странице: {$a}';
$string['multianswer'] = 'Вишеструки одговор';
$string['multianswer_help'] = 'Означите уколико постоји више тачних одговора.';
$string['multichoice'] = 'Вишеструки избор';
$string['multipleanswer'] = 'Вишеструки одговор';
$string['nameapproved'] = 'Назив је одобрен';
$string['namereject'] = 'Нажалост, Ваше име је одбијено.<br />Молимо покушајте са другим именом.';
$string['new'] = 'ново';
$string['nextpage'] = 'Следећа страница';
$string['noanswer'] = 'На једно или више питања није дат одговор. Молимо вратите се назад и дајте свој одговор.';
$string['noattemptrecordsfound'] = 'Нема забележених покушаја: није дата ниједна оцена';
$string['nobranchtablefound'] = 'Није пронађена ниједна страница са садржајем';
$string['noclose'] = 'Нема датума затварања лекције';
$string['nocommentyet'] = 'Још нема коментара.';
$string['nocoursemods'] = 'Није пронађена ниједна активност';
$string['nocredit'] = 'Без бодова';
$string['nodeadline'] = 'Без рока';
$string['noessayquestionsfound'] = 'У овој лекцији нису пронађена питања која захтевају одговор у форми есеја.';
$string['nohighscores'] = 'Нема најбољих резултата';
$string['nolessonattempts'] = 'Није било покушаја да се прође кроз ову лекцију.';
$string['nolessonattemptsgroup'] = 'Није било покушаја да се прође кроз ову лекцију од стране чланова групе {$a}.';
$string['none'] = 'Ниједна';
$string['nooneansweredcorrectly'] = 'Нико није тачно одговорио.';
$string['nooneansweredthisquestion'] = 'Нико није одговорио на ово питање.';
$string['noonecheckedthis'] = 'Нико није изабрао овај одговор.';
$string['nooneenteredthis'] = 'Нико није ово покушао.';
$string['noonehasanswered'] = 'Нико још није одговорио на есејско питање.';
$string['noonehasansweredgroup'] = 'Нико у групи {$a} још није одговорио на есејско питање';
$string['noopen'] = 'Нема датума отварања лекције';
$string['nooverridecreated'] = 'Није направљена ниједна измена';
$string['nooverridedata'] = 'Морате да измените барем једно од подешавања лекција.';
$string['noretake'] = 'Није Вам дозвољено да поново покушате ову лекцију.';
$string['normal'] = 'Нормално - пратите путању лекције';
$string['notcompleted'] = 'Није завршено';
$string['notcompletedwithdate'] = 'Није завршено ({$a})';
$string['notdefined'] = 'Није дефинисано';
$string['notenoughsubquestions'] = 'Није дефинисано довољно потпитања!<br />Да ли желите да се вратите назад и исправите питање?';
$string['notenoughtimespent'] = 'Завршили сте ову лекцију за {$a->timespent}, што је мање од {$a->timerequired}, времена које је потребно да се ова лекција проучи на адекватан начин. Мораћете поново да урадите лекцију.';
$string['notgraded'] = 'Није оцењено';
$string['notitle'] = 'Нема наслова';
$string['notyetcompleted'] = 'Лекција је започета али није завршена';
$string['numberofcorrectanswers'] = 'Број тачних одговора: {$a}';
$string['numberofcorrectanswersheader'] = 'Број тачних одговора';
$string['numberofcorrectmatches'] = 'Број тачних подударања: {$a}';
$string['numberofpagestoshow'] = 'Број страница које треба приказати';
$string['numberofpagestoshow_help'] = 'Ово подешавање одређује број страница приказаних у лекцији. Подешавање је примењиво само за лекције код којих се странице приказују насумичним редоследом (када је подешавање "Акција након тачног одговора" постављено на "Прикажи неприказану страницу" или "Прикажи страницу са неодговореним питањем"). Ако је вредност подешена на 0, онда се приказују све странице.';
$string['numberofpagesviewed'] = 'Број прегледаних страница: {$a}';
$string['numberofpagesviewedheader'] = 'Број питања на које је дат одговор';
$string['numberofpagesviewednotice'] = 'Број питања на које је дат одговор: {$a->nquestions} (Требало би их бити бар {$a->minquestions})';
$string['numerical'] = 'Бројчани';
$string['numericanswer'] = 'Бројчани одговор';
$string['numericanswer_help'] = 'Користећи двотачку можете одредити један број или опсег бројева. На пример 2:5 значи да је сваки одговор између 2 и 5, укључујући 2 и 5, тачан.';
$string['offlinedatamessage'] = 'Овој лекцији сте приступили користећи мобилни уређај. Подаци на овом сајту последњи пут су сачувани пре {$a}. Проверите да немате неки несачувани покушај приступа лекцији.';
$string['ongoing'] = 'Приказ тренутног резултата';
$string['ongoing_help'] = 'Ако је ова опција омогућена, на свакој страница ће бити приказан тренутни број поена од укупног броја које је полазник до тада могао да постигне.';
$string['ongoingcustom'] = 'До сада сте освојили {$a->score} од максимално {$a->currenthigh} бодова.';
$string['ongoingnormal'] = 'Тачно сте одговорили на {$a->correct} од {$a->viewed} питања која сте видели.';
$string['onpostperpage'] = 'Само једна порука по оцени';
$string['openafterclose'] = 'Навели сте датум отварања након датума затварања';
$string['options'] = 'Опције';
$string['or'] = 'ИЛИ';
$string['ordered'] = 'Поређано';
$string['other'] = 'Остало';
$string['outof'] = 'Од {$a}';
$string['override'] = 'Измена';
$string['overridedeletegroupsure'] = 'Да ли сте сигурни да желите да обришете измену подешавања за групу {$a}?';
$string['overridedeleteusersure'] = 'Да ли сте сигурни да желите да обришете измену подешавања за корисника {$a}?';
$string['overridegroup'] = 'Измени подешавања за групу';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Измене';
$string['overrideuser'] = 'Измени подешавања за корисника';
$string['overrideusereventname'] = '{$a->lesson} - Измена';
$string['overview'] = 'Преглед';
$string['overview_help'] = 'Лекција се састоји од одређеног броја страница и, опционо, страница са садржајем (табелом гранања). Страница садржи  произвољну количину текста и одговарајућих илустрација, и обично се завршава питањем. Уз сваки одговор на питање везан је тзв. прелаз. Прелази могу бити релативни, као на пример “текућа страница” или “следећа страница”, или апсолутни када се тачно наводи нека од страница унутар лекцији. Страница са садржајем (табела гранања) је страница која садржи низ линкова ка другим страницама лекције, као на пример "Табела садржаја".';
$string['page'] = 'Страница: {$a}';
$string['page-mod-lesson-edit'] = 'Страница за уређивање лекције';
$string['page-mod-lesson-view'] = 'Прикажи или прегледај страницу лекције';
$string['page-mod-lesson-x'] = 'Било која страница лекције';
$string['pageanswers'] = 'Страница са питањима';
$string['pagecontents'] = 'Садржај странице';
$string['pageresponses'] = 'Страница са одговорима';
$string['pages'] = 'Странице';
$string['pagetitle'] = 'Наслов странице';
$string['password'] = 'Лозинка';
$string['passwordprotectedlesson'] = '{$a} је лекција заштићена лозинком.';
$string['pleasecheckoneanswer'] = 'Изаберите један одговор';
$string['pleasecheckoneormoreanswers'] = 'Изаберите један или више одговора';
$string['pleaseenteryouranswerinthebox'] = 'Молимо унесите свој одговор у поље за унос текста';
$string['pleasematchtheabovepairs'] = 'Спојите парове';
$string['pluginadministration'] = 'Администрација лекције';
$string['pluginname'] = 'Лекција';
$string['pointsearned'] = 'Освојени поени';
$string['postprocesserror'] = 'Дошло је до грешке током накнадне обраде!';
$string['postsuccess'] = 'Успешно послато';
$string['practice'] = 'Лекција за вежбање';
$string['practice_help'] = 'Лекција за вежбање се не приказује у дневнику оцена.';
$string['preprocesserror'] = 'Дошло је до грешке у току претходне обраде!';
$string['prerequisiteisobsolete'] = 'Опција за лекцију предуслов је уклоњена. Молимо вас да уместо тога користите опције за ограничење приступа.';
$string['prerequisitelesson'] = 'Лекција предуслов';
$string['preview'] = 'Преглед';
$string['previewlesson'] = 'Преглед {$a}';
$string['previewpagenamed'] = 'Погледајте страницу: {$a}';
$string['previouspage'] = 'Претходна страница';
$string['privacy:metadata:attempts'] = 'Запис о покушају прегледа странице';
$string['privacy:metadata:attempts:answerid'] = 'Идентификатор одговора';
$string['privacy:metadata:attempts:correct'] = 'Да ли је покушај био исправан';
$string['privacy:metadata:attempts:pageid'] = 'Идентификатор странице';
$string['privacy:metadata:attempts:retry'] = 'Број покушаја';
$string['privacy:metadata:attempts:timeseen'] = 'Време када је направљен покушај';
$string['privacy:metadata:attempts:useranswer'] = 'Детаљније информације о корисниковом одговору';
$string['privacy:metadata:attempts:userid'] = 'Идентификатор корисника';
$string['privacy:metadata:branch'] = 'Запис о прегледаним страницама';
$string['privacy:metadata:branch:flag'] = 'Да ли је следећа страница насумично срачуната';
$string['privacy:metadata:branch:nextpageid'] = 'Идентификатор следеће странице';
$string['privacy:metadata:branch:pageid'] = 'Идентификатор странице';
$string['privacy:metadata:branch:retry'] = 'Број покушаја';
$string['privacy:metadata:branch:timeseen'] = 'Време када је страница прегледана';
$string['privacy:metadata:branch:userid'] = 'Идентификатор корисника';
$string['privacy:metadata:grades'] = 'Запис о оценама за сваку лекцију';
$string['privacy:metadata:grades:completed'] = 'Датум када је оцена дата';
$string['privacy:metadata:grades:grade'] = 'Дата оцена';
$string['privacy:metadata:grades:userid'] = 'ID ознака корисника';
$string['privacy:metadata:overrides'] = 'Запис измена по лекцији';
$string['privacy:metadata:overrides:available'] = 'Време када се лекција може покушати';
$string['privacy:metadata:overrides:deadline'] = 'Рок за завршетак лекције.';
$string['privacy:metadata:overrides:maxattempts'] = 'Максималан број покушаја';
$string['privacy:metadata:overrides:password'] = 'Лозинка за приступ лекцији';
$string['privacy:metadata:overrides:retake'] = 'Да ли је дозвољено поново покушати лекцију';
$string['privacy:metadata:overrides:review'] = 'Да ли је дозвољено поново покушати одговорити на питање';
$string['privacy:metadata:overrides:timelimit'] = 'Временско ограничење за завршетак лекције, у секундама.';
$string['privacy:metadata:overrides:userid'] = 'ID ознака корисника';
$string['privacy:metadata:timer'] = 'Запис о покушају проласка кроз лекцију';
$string['privacy:metadata:timer:completed'] = 'Да ли је покушај завршен';
$string['privacy:metadata:timer:lessontime'] = 'Последњи тренутак када смо забележили активност';
$string['privacy:metadata:timer:starttime'] = 'Датум почетка покушаја';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Последњи тренутак када смо забележили активност из мобилне апликације';
$string['privacy:metadata:timer:userid'] = 'ID ознака корисника';
$string['privacy:metadata:userpref:lessonview'] = 'Жељени режим приказа приликом уређивања лекција';
$string['privacy:path:essayanswers'] = 'Есејски одговори';
$string['privacy:path:essayresponses'] = 'Есејски одговори';
$string['privacy:path:pages'] = 'Странице';
$string['processerror'] = 'Дошло је до грешке у току обраде!';
$string['progressbar'] = 'Трака напредовања кроз лекцију';
$string['progressbar_help'] = 'Ако је ова опција омогућена, на дну странице биће приказана трака која приказује приближан проценат завршености лекције (напредовање полазника кроз лекцију).';
$string['progressbarteacherwarning'] = 'Трака напредовања кроз лекцију се не приказује за {$a}';
$string['progressbarteacherwarning2'] = 'Нећете видети траку напредовања зато што можете да уређујете ову лекцију';
$string['progresscompleted'] = 'Завршили сте {$a}% лекције';
$string['qtype'] = 'Врста странице';
$string['question'] = 'Питање';
$string['questionoption'] = 'Питање';
$string['questiontype'] = 'Тип питања';
$string['randombranch'] = 'Насумично одабрана страница са садржајем';
$string['randompageinbranch'] = 'Насумично одабрано питање унутар странице са садржајем';
$string['rank'] = 'Ранг';
$string['rawgrade'] = 'Необрађена оцена';
$string['receivedcredit'] = 'Добијени бодови';
$string['redisplaypage'] = 'Освежавање приказа странице';
$string['removeallgroupoverrides'] = 'Обриши све измена подешавања за групе';
$string['removealluseroverrides'] = 'Обриши све измене подешавања за кориснике';
$string['report'] = 'Извештај';
$string['reports'] = 'Извештаји';
$string['response'] = 'Повратне информације';
$string['retakesallowed'] = 'Поновни преглед лекције је дозвољен';
$string['retakesallowed_help'] = 'Ако је ова опција омогућена, полазник може више пута да погледа лекцију.';
$string['returnto'] = 'Врати се на {$a}';
$string['returntocourse'] = 'Врати се на курс';
$string['reverttodefaults'] = 'Врати лекцију на стандардна подешавања';
$string['review'] = 'Преглед';
$string['reviewlesson'] = 'Преглед лекције';
$string['reviewquestionback'] = 'Да, волео/ла бих да поново покушам';
$string['reviewquestioncontinue'] = 'Не, желим да пређем на следеће питање';
$string['sanitycheckfailed'] = 'Провера није успела. Покушај је обрисан.';
$string['save'] = 'Сачувај';
$string['savechanges'] = 'Сачувај промене';
$string['savechangesandeol'] = 'Сачувај све промене и иди на крај лекције.';
$string['saveoverrideandstay'] = 'Сачувај и унеси другу измену';
$string['savepage'] = 'Сачувај страницу';
$string['score'] = 'Резултат';
$string['score_help'] = 'Резултат се користи само када је прилагођено бодовање омогућено. Сваком одговору затим може бити дата нумеричка вредност (позитивна или негативна).';
$string['scores'] = 'Резултати';
$string['search:activity'] = 'Лекција - информације о активности';
$string['secondpluswrong'] = 'Није баш. Да ли желите да покушате поново?';
$string['selectallattempts'] = 'Одабери све покушаје';
$string['selectaqtype'] = 'Одаберите тип питања';
$string['selectreport'] = 'Изабери извештај';
$string['sent'] = 'Послато';
$string['shortanswer'] = 'Кратак одговор';
$string['showanunansweredpage'] = 'Прикажи страницу са неодговореним питањем';
$string['showanunseenpage'] = 'Прикажи неприказану страницу';
$string['singleanswer'] = 'Један одговор';
$string['skip'] = 'Прескочи навигацију';
$string['slideshow'] = 'Слајд-шоу';
$string['slideshow_help'] = 'Ако је ово подешавање омогућено, лекција се приказује као слајд-шоу, са фиксном ширином и висином.';
$string['slideshowbgcolor'] = 'Боја позадине за слајд-шоу';
$string['slideshowheight'] = 'Слајд-шоу - висина';
$string['slideshowwidth'] = 'Слајд-шоу - ширина';
$string['startlesson'] = 'Почните лекцију';
$string['studentattemptlesson'] = '{$a->attempt} покушај корисника {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} Име';
$string['studentoneminwarning'] = 'Упозорење: имате мање од једног минута да завршите лекцију.';
$string['studentoutoftimeforreview'] = 'Пажња: ваше време за преглед ове лекције је истекло';
$string['studentresponse'] = 'Одговор полазника {$a}';
$string['submit'] = 'Пошаљи';
$string['submitname'] = 'Пошаљи име';
$string['teacherjumpwarning'] = 'У овој лекцији се користи {$a->cluster} или {$a->unseen} прелази између страница. Уместо ових користиће се прелаз "Следећа страница". За тестирање ових прелаза пријавите се на систем у улози полазника.';
$string['teacherongoingwarning'] = 'Тренутни резултат током прегледа лекције се приказује само полазницима. Пријавите се као полазник како бисте тестирали ову могућност.';
$string['teachertimerwarning'] = 'Мерач времена могу да виде само полазници. Како бисте тестирали мерач времена пријавите се на систем у улози полазника.';
$string['thatsthecorrectanswer'] = 'Тачан одговор';
$string['thatsthewronganswer'] = 'Погрешан одговор';
$string['thefollowingpagesjumptothispage'] = 'Следеће странице воде до ове странице';
$string['thispage'] = 'Ова страница';
$string['timeisup'] = 'Vreme je isteklo';
$string['timelimit'] = 'Временско ограничење';
$string['timelimit_help'] = 'Ако је ова опција омогућена, на почетку лекције биће приказано упозорење о временском ограничењу и тајмер. Одговори дати након истека времена се неће оцењивати.';
$string['timelimitwarning'] = 'Имате на располагању {$a} за завршетак лекције';
$string['timeremaining'] = 'Преостало време';
$string['timespenterror'] = 'Проведите бар {$a} минута прегледајући садржај лекције';
$string['timespentminutes'] = 'Потрошено време (у минутима)';
$string['timetaken'] = 'Потрошено време';
$string['totalpagesviewedheader'] = 'Број прегледаних страница';
$string['true'] = 'Тачно';
$string['truefalse'] = 'Тачно/нетачно';
$string['unabledtosavefile'] = 'Није могуће сачувати датотеку коју сте послали.';
$string['unknownqtypesnotimported'] = 'Број питања, са неподржаним типом питања, која нису увезена: {$a}';
$string['unseenpageinbranch'] = 'Још неприказано питање унутар странице са садржајем';
$string['unsupportedqtype'] = 'Тип питања који није подржан {$a}!';
$string['updatedpage'] = 'Страница је ажурирана';
$string['updatefailed'] = 'Ажурирање није успело';
$string['updatepagenamed'] = 'Ажурирај страницу: {$a}';
$string['usemaximum'] = 'Користи максималну вредност';
$string['usemean'] = 'Користи просечну вредност';
$string['usepassword'] = 'Лекција заштићена лозинком';
$string['usepassword_help'] = 'Уколико је укључено, за приступ лекцији неопходна је лозинка.';
$string['useroverrides'] = 'Измене подешавања за кориснике';
$string['useroverridesdeleted'] = 'Измене подешавања за кориснике обрисане';
$string['usersnone'] = 'Ниједан полазник нема приступ овој лекцији';
$string['viewessayanswers'] = 'Погледај есејске одговоре';
$string['viewgrades'] = 'Погледај оцене';
$string['viewreports'] = 'Приказ {$a->attempts} комплетних покушаја полазника {$a->student}';
$string['viewreports2'] = 'Погледај {$a} завршених покушаја';
$string['warning'] = 'Упозорење';
$string['welldone'] = 'Браво!';
$string['whatdofirst'] = 'Шта желите прво да урадите?';
$string['withselectedattempts'] = 'Са изабраним покушајима...';
$string['wronganswerjump'] = 'Страница која ће се приказати након погрешног одговора';
$string['wronganswerscore'] = 'Број бодова који носи погрешан одговор';
$string['wrongresponse'] = 'Повратне информације за погрешан одговор';
$string['youhaveseen'] = 'Већ сте видели више од једне странице ове лекције.<br /> Желите ли почети од последње странице коју сте видели?';
$string['youranswer'] = 'Ваш одговор';
$string['yourcurrentgradeis'] = 'Ваша тренутна оцена је {$a}';
$string['yourcurrentgradeisoutof'] = 'Ваша тренутна оцена је {$a->grade} од могућих {$a->total}';
$string['youshouldview'] = 'Требало би да одговорите на барем: {$a}';
