<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_almondb', language 'sr_cr', version '4.1'.
 *
 * @package     theme_almondb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Напредна подешавања';
$string['almondbpage'] = 'Инфор странице';
$string['almondbpagecaption'] = 'Натпис странице';
$string['almondbpagecaptiondesc'] = 'Додајте натпис за своју страницу';
$string['almondbpagecaptionsimple'] = 'Натпис странице';
$string['almondbpagecaptionsimpledesc'] = 'Додајте натпис за своју страницу';
$string['almondbpagecount'] = 'Број страница';
$string['almondbpagecountdesc'] = 'Изаберите колико страница желите да додате <strong>затим кликните на дугме САЧУВАЈ</strong> како бисте учитали поља за унос подешавања.';
$string['almondbpagecountsimple'] = 'Број страница';
$string['almondbpagecountsimpledesc'] = 'Изаберите колико страница желите да додате <strong>затим кликните на дугме САЧУВАЈ</strong> како бисте учитали поља за унос подешавања.';
$string['almondbpagecss'] = 'CSS стилови странице';
$string['almondbpagecssdesc'] = 'Додајте CSS за своју страницу';
$string['almondbpagecsslink'] = 'Линк CSS стиловa странице';
$string['almondbpagecsslinkdesc'] = 'Додајте линк CSS стилова за вашу страницу,
            Example : "https://www.example.com/abc.css"';
$string['almondbpagedesign'] = 'Дизајн странице';
$string['almondbpagedesigndesc'] = 'Изаберите дизајн странице који желите да додате. Можете брзо да креирате своје странице користећи једноставан дизајн.
                                Код једноставног дизајна користите само слику и део поднаслова.';
$string['almondbpageenabled'] = 'Омогући almondbpage';
$string['almondbpageenableddesc'] = 'Омогућите almondbpage на врху ваше почетне странице';
$string['almondbpageenabledsimple'] = 'Омогући almondbpage';
$string['almondbpageenabledsimpledesc'] = 'Омогућите almondbpage на врху ваше почетне странице';
$string['almondbpageenddesc'] = '--*/*--';
$string['almondbpagefooter'] = 'Подножје странице';
$string['almondbpagefooterdesc'] = 'Додајте подножје на инфо страницу';
$string['almondbpagefootersimple'] = 'Подножје странице';
$string['almondbpagefootersimpledesc'] = 'Додајте подножје на инфо страницу';
$string['almondbpageheader'] = 'Заглавље странице';
$string['almondbpageheaderdesc'] = 'Додајте заглавље на инфо страницу';
$string['almondbpageheadersimple'] = 'Заглавље странице';
$string['almondbpageheadersimpledesc'] = 'Додајте заглавље на инфо страницу';
$string['almondbpageheading'] = ': Напредна Подешавања Странице';
$string['almondbpageheadingdesc'] = 'Ово креира до шест инфо страница за промоцију важних елемената вашег сајта.';
$string['almondbpageheadingsimple'] = '! Једноставна Подешавања Странице';
$string['almondbpageheadingsimpledesc'] = 'Ово креира до шест инфо страница за промоцију важних елемената вашег сајта.';
$string['almondbpageimage'] = 'Слика странице';
$string['almondbpageimagedesc'] = 'Додајте слику за своју страницу.';
$string['almondbpageimagesimple'] = 'Слика странице';
$string['almondbpageimagesimpledesc'] = 'Додајте слику за своју страницу.';
$string['almondbpageimglink'] = 'Линк ка директоријуму са сликама';
$string['almondbpageimglinkdesc'] = 'Додајте линк ка директоријуму са сликама за своју страницу и копирајте слике које користите у HTML кôду у овaј директоријум.
        Ако попуните поље за директоријум са сликама, немојте у HTML странице уносити путању слике.
            само напишите нешто попут demo-1.png (илиr jpg).
            Пример: http://www.exaple.com/img/, (img src= demo-1.jpg).';
$string['almondbpageimgpositionsimple'] = 'Позиција слике странице';
$string['almondbpageimgpositionsimpledesc'] = 'Где ће се постављена слика налазити на страници.';
$string['almondbpagenavbar'] = 'Навигациона трака странице';
$string['almondbpagenavbardesc'] = 'Додајте навигациону траку на инфо страницу';
$string['almondbpageno'] = '! Страница-{$a->almondbpage}';
$string['almondbpagenodesc'] = 'Унесите подешавања за страницу {$a->almondbpage}. <b><i>ЛИНК СТРАНИЦЕ: www.yoursite/local/almondbpage/?id=a{$a->almondbpage}</i></b>';
$string['almondbpagenosimple'] = '! Страница-{$a->almondbpage}';
$string['almondbpagenosimpledesc'] = 'Унесите подешавања за страницу {$a->almondbpage}. <b><i>ЛИНК СТРАНИЦЕ: www.yoursite/local/almondbpage/?id=s{$a->almondbpage}</i></b>';
$string['almondbpagenotfound'] = 'Страница није пронађена, проверите URL адресу';
$string['almondbpagestart'] = 'Подешавања инфо странице';
$string['almondbpagestartdesc'] = '--*/*--';
$string['almondbpagetitle'] = 'Наслов странице';
$string['almondbpagetitledesc'] = 'Додајте наслов странице.';
$string['almondbpagetitlesimple'] = 'Наслов странице';
$string['almondbpagetitlesimpledesc'] = 'Додајте наслов странице.';
$string['backcolor'] = 'Боја позадине';
$string['backcolor_desc'] = 'Боја позадине';
$string['backgroundimage'] = 'Позадинска слика';
$string['backgroundimage_desc'] = 'Слика која ће бити приказана као позадина сајта. Позадинска слика коју овде поставите замениће слику у вашим датотекама са предефинисаним подешавањима теме.';
$string['block01button'] = 'Дугме блока 1';
$string['block01buttondesc'] = 'Додајте дугме за свој блок 1';
$string['block01buttonlink'] = 'URL адреса блока 1';
$string['block01buttonlinkdesc'] = 'Додајте URL адресу за свој блок 1';
$string['block01caption'] = 'Натпис блока 1';
$string['block01captiondefault'] = '<h2 class="white">Изабране Премиjум Теме</h2><br>
<p class="white">Теме су дизајниране тако да не ремете стандардни изглед Moodlea, па ће вам олакшати рад. Погледајте неке од главних карактеристика тема.</p>';
$string['block01captiondesc'] = 'Додајте натпис за свој блок 1';
$string['block01color'] = 'Боја позадине блока 1';
$string['block01colordesc'] = 'Додајте боју позадине за блок 1';
$string['block01enabled'] = 'Омогућите блок 1';
$string['block01enableddesc'] = 'Омогућите или онемогућите блок 1 на вашој почетној страници';
$string['block01info'] = ': Block-1 TITLE BOX';
$string['block01infodesc'] = 'НАСЛОВНИ БЛОК - Унесите подешавања за блок 1';
$string['block02button'] = 'Дугме блока {$a->block}';
$string['block02buttondesc'] = 'Додајте дугме за свој блок';
$string['block02buttonlink'] = 'URL адреса блока {$a->block}';
$string['block02buttonlinkdesc'] = 'Додајте URL адресу за свој блок';
$string['block02caption'] = 'Натпис блока {$a->block}';
$string['block02captiondefault'] = 'Уживајте у нашим бесплатним онлајн курсевима,
где год да сте и кад год желите. Приступите садржају курса на мобилном уређају, таблету или десктопу рачунару.';
$string['block02captiondesc'] = 'Додајте натпис за свој блок';
$string['block02count'] = 'Блок-2 Број';
$string['block02countdesc'] = 'Изаберите број блокова и притисните дугме \'Сачувај промене\'';
$string['block02enabled'] = 'Омогућите блок 2';
$string['block02enableddesc'] = 'Омогућите или онемогућите блок 2 на вашој почетној страници';
$string['block02icon'] = 'Иконица блока {$a->block}';
$string['block02icondefault'] = '--*/*--';
$string['block02icondefault1'] = 'core:i/report';
$string['block02icondefault2'] = 'core:i/settings';
$string['block02icondefault3'] = 'core:i/stats';
$string['block02icondefault4'] = 'core:i/notifications';
$string['block02icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Кликните да бисте видели иконице</a>';
$string['block02imgdesc'] = 'Додајте слику за свој блок';
$string['block02info'] = '! Блок-2 БЛОК ИКОНИЦА';
$string['block02infodesc'] = 'БЛОК ИКОНИЦА - Унесите подешавања за блок 2';
$string['block02title'] = 'Наслов блока {$a->block}';
$string['block02titledefault'] = 'Најбољи инвестициони саветници';
$string['block02titledesc'] = 'Додајте наслов за свој блок';
$string['block03caption'] = 'Натпис блока 3 {$a->block}';
$string['block03captiondefault'] = 'Vestibulum non diam quis nisl dignissim posuere a vulputate urna nunc velit';
$string['block03captiondesc'] = 'Додајте натпис за свој блок 3';
$string['block03design'] = 'Дизајн блока 3';
$string['block03designdesc'] = 'Изаберите дизајн блока 3 који желите да додате';
$string['block03enabled'] = 'Омогућите блок 3';
$string['block03enableddesc'] = 'Омогућите или онемогућите блок 3 на вашој почетној страници';
$string['block03header'] = 'Заглавље блока 3';
$string['block03headerdefault'] = 'Ми смо THEMES ALMOND';
$string['block03headerdesc'] = 'Заглавље блока 3';
$string['block03icon'] = 'Иконица блока 3';
$string['block03icondefault'] = 'core:i/categoryevent';
$string['block03icondefault1'] = 'core:t/download';
$string['block03icondefault2'] = 'core:a/setting';
$string['block03icondefault3'] = 'core:docs';
$string['block03icondefault4'] = 'core:i/duration';
$string['block03icondefault5'] = 'core:i/checked';
$string['block03icondefault6'] = 'core:e/visual_aid';
$string['block03icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Кликните да бисте видели иконице</a>';
$string['block03info'] = '! Блок-3 ФУНКЦИЈЕ';
$string['block03infodesc'] = 'ФУНКЦИЈЕ - Унесите подешавања за блок 3';
$string['block03link'] = 'URL адреса блока 3 {$a->block}';
$string['block03linkdesc'] = 'Додајте URL адресу за свој блок 3';
$string['block03title'] = 'Наслов блока 3 {$a->block}';
$string['block03titledefault'] = 'Прилагодљиви дизајн';
$string['block03titledesc'] = 'Додајте наслов за свој блок 3';
$string['block04button'] = 'Текст дугмета блока 4';
$string['block04buttondefault'] = 'Прикажи све курсеве';
$string['block04buttondesc'] = 'Текст дугмета блока 4';
$string['block04buttonlink'] = 'Линк дугмета блока 4';
$string['block04buttonlinkdefault'] = 'course/index.php';
$string['block04buttonlinkdesc'] = 'Линк дугмета блока 4';
$string['block04caption'] = 'Натпис блока 4 {$a->block}';
$string['block04captiondesc'] = 'Додајте натпис за свој блок 4';
$string['block04design'] = 'Дизајн блока 4';
$string['block04designdesc'] = 'Изаберите дизајн блока 4 који желите да додате';
$string['block04enabled'] = 'Омогућите блок 4';
$string['block04enableddesc'] = 'Омогућите или онемогућите блок 4 на вашој почетној страници';
$string['block04header'] = 'Заглавље блока 4';
$string['block04headerdefault'] = 'НАЈНОВИЈИ ПРОЈЕКТИ';
$string['block04headerdesc'] = 'Заглавље блока 4';
$string['block04imgdesc'] = 'Додајте слику за свој блок';
$string['block04info'] = '! Блок-4 НАЈНОВИЈЕ';
$string['block04infodesc'] = 'НАЈНОВИЈЕ - Унесите подешавања за блок 4';
$string['block04link'] = 'URL адреса блока 4 {$a->block}';
$string['block04linkdesc'] = 'Додајте URL адресу за свој блок 4';
$string['block04title'] = 'Наслов блока 4 {$a->block}';
$string['block04titledesc'] = 'Додајте наслов за свој блок 4';
$string['block05caption'] = 'Натпис блока 5 {$a->block}';
$string['block05captiondesc'] = 'Додајте натпис за свој блок 5';
$string['block05design'] = 'Дизајн блока 5';
$string['block05designdesc'] = 'Изаберите дизајн блока 5 који желите да додате';
$string['block05enabled'] = 'Омогућите блок 5';
$string['block05enableddesc'] = 'Омогућите или онемогућите блок 5 на вашој почетној страници';
$string['block05header'] = 'Заглавље блока 5';
$string['block05headerdefault'] = 'ЗАШТО ИЗАБРАТИ НАС';
$string['block05headerdesc'] = 'Заглавље блока 5';
$string['block05icon'] = 'Иконица блока 5 {$a->block}';
$string['block05icondefault'] = 'core:i/categoryevent';
$string['block05icondefault1'] = 'core:i/settings';
$string['block05icondefault2'] = 'core:i/hide';
$string['block05icondefault3'] = 'core:i/bullhorn';
$string['block05icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Кликните да бисте видели иконице</a>';
$string['block05imgdesc'] = 'Додајте слику за свој блок';
$string['block05info'] = '! Блок-5 ЗАШТО МИ';
$string['block05infodesc'] = 'ЗАШТО МИ - Унесите подешавања за блок 5';
$string['block05link'] = 'URL адреса блока 5 {$a->block}';
$string['block05linkdesc'] = 'Додајте URL адресу за свој блок 5';
$string['block05title'] = 'Наслов блока 5 {$a->block}';
$string['block05titledesc'] = 'Додајте наслов за свој блок 5';
$string['block06button'] = 'URL адреса блока 6';
$string['block06buttondesc'] = 'Додајте URL адресу за свој блок 6';
$string['block06buttonlink'] = 'URL адреса блока 6';
$string['block06buttonlinkdesc'] = 'Додајте URL адресу за свој блок 6';
$string['block06caption'] = 'Натпис блока 6';
$string['block06captiondefault'] = 'Додајте подразумевани натпис за свој блок 6';
$string['block06captiondesc'] = 'Додајте натпис за свој блок 6';
$string['block06color'] = 'Боја позадине блока 6';
$string['block06colordesc'] = 'Додајте боју позадине за блок 6';
$string['block06design'] = 'Дизајн блока 6';
$string['block06designdesc'] = 'Изаберите дизајн блока 6 који желите да додате';
$string['block06enabled'] = 'Омогућите блок 6';
$string['block06enableddesc'] = 'Омогућите или онемогућите блок 6 на вашој почетној страници';
$string['block06header'] = 'Заглавље блока 6';
$string['block06headerdefault'] = 'РАД СА НАМА';
$string['block06headerdesc'] = 'Заглавље блока 6';
$string['block06imgdesc'] = 'Додајте слику за свој блок';
$string['block06info'] = '! Блок-6 РАД СА НАМА';
$string['block06infodesc'] = 'РАД СА НАМА - Унесите подешавања за блок 6';
$string['block07button'] = 'URL адреса блока 7';
$string['block07buttondesc'] = 'Додајте URL адресу за свој блок 7';
$string['block07buttonlink'] = 'URL адреса блока 7';
$string['block07buttonlinkdesc'] = 'Додајте URL адресу за свој блок 7';
$string['block07count'] = 'Блок 7 број';
$string['block07countdefault'] = '8';
$string['block07countdesc'] = 'Број курсева за приказ';
$string['block07design'] = 'Дизајн блока 7';
$string['block07designdesc'] = 'Изаберите дизајн блока 7 који желите да додате';
$string['block07enabled'] = 'Омогућите блок 7';
$string['block07enableddesc'] = 'Омогућите или онемогућите блок 7 на вашој почетној страници';
$string['block07enrol'] = 'Бесплатно';
$string['block07header'] = 'Заглавље блока 7';
$string['block07headerdefault'] = 'ДОСТУПНИ КУРСОВИ';
$string['block07headerdesc'] = 'Заглавље блока 7';
$string['block07info'] = '! Блок-7 ДОСТУПНИ КУРСОВИ';
$string['block07infodesc'] = 'ДОСТУПНИ КУРСОВИ - Унесите подешавања за блок 7';
$string['block07priceshow'] = 'Прикажи цену уписа курса';
$string['block07priceshowdesc'] = 'Омогући/онемогући цену уписа на курс';
$string['block07studentrole'] = 'Блок 7 улога полазника';
$string['block07studentroledesc'] = 'Изаберите улогу полазника';
$string['block07teacherenabled'] = 'БЛОК 7 Ангажовани предавачи';
$string['block07teacherenableddesc'] = 'Прикажите предаваче?';
$string['block07teacherrole'] = 'Блок 7 улога предавача';
$string['block07teacherroledesc'] = 'Изаберите улогу предавача';
$string['block07title'] = 'Наслов блока 7';
$string['block07titledefault'] = 'краткиназив';
$string['block07titledesc'] = 'Тип наслова курса';
$string['block07tooltipcategory'] = 'Категорија';
$string['block07tooltipenrolled'] = 'Уписани студенти';
$string['block07tooltiplastdate'] = 'Датум последње измене';
$string['block08caption'] = 'Натпис блока 8';
$string['block08captiondefault'] = 'Настављамо да служимо са нашим предавачким особљем. Упознајте наше предаваче.';
$string['block08captiondesc'] = 'Натпис блока 8';
$string['block08count'] = 'Блок 8 број';
$string['block08countdefault'] = '8';
$string['block08countdesc'] = 'Број предавача за приказ';
$string['block08description'] = 'Опис блока 8';
$string['block08descriptiondesc'] = 'Прикажи опис корисника на страници.';
$string['block08design'] = 'Дизајн блока 8';
$string['block08designdesc'] = 'Изаберите дизајн блока 8 који желите да додате';
$string['block08enabled'] = 'Омогућите блок 8';
$string['block08enableddesc'] = 'Омогућите или онемогућите блок 8 на вашој почетној страници';
$string['block08header'] = 'Заглавље блока 8';
$string['block08headerdefault'] = 'ПРЕДАВАЧИ';
$string['block08headerdesc'] = 'Заглавље блока 8';
$string['block08info'] = '! Блок-8 ПРЕДАВАЧ';
$string['block08infodesc'] = 'ПРЕДАВАЧИ – Унесите подешавања за блок 8';
$string['block08showrole'] = 'Блок 8 Приказ улога';
$string['block08showroledesc'] = 'Улоге корисника које се приказују у блоку 8';
$string['block08studentrole'] = 'Блок 8 Улога полазника';
$string['block08studentroledesc'] = 'Улога полазника';
$string['block08tooltipcourse'] = 'Укупан број курсева предавача';
$string['block08tooltipstudents'] = 'Укупан број полазника предавача';
$string['block08total'] = 'Блок 8 Укупно';
$string['block08totaldesc'] = 'Прикажи укупан број курсева и студената';
$string['block09background'] = 'Позадина блока 9';
$string['block09backgrounddesc'] = 'Изаберите боју позадине или позадинску слику блока 9';
$string['block09boxshadow'] = 'Блок 9 Сенка оквира';
$string['block09boxshadowdesc'] = 'Изаберите да ли омогућити сенку око оквира категорија у блоку 9';
$string['block09caption'] = 'Натпис блока 9';
$string['block09captiondefault'] = 'Списак регистрованих категорија';
$string['block09captiondesc'] = 'Натписи блока 9';
$string['block09count'] = 'Блок 9 број';
$string['block09countdefault'] = '8';
$string['block09countdesc'] = 'Број категорија за приказ';
$string['block09ctgid'] = 'Блок 9 - ID ознака категорије';
$string['block09ctgiddesc'] = 'Блок 9 - изабране ID ознаке категорија (нпр: ID = 1  или ID = 2 или ID = 3): ако је поље празно биће приказане све категорија';
$string['block09design'] = 'Дизајн блока 9';
$string['block09designdesc'] = 'Изаберите дизајн блока 9 који желите да додате';
$string['block09enabled'] = 'Омогућите блок 9';
$string['block09enableddesc'] = 'Омогућите или онемогућите блок 9 на вашој почетној страници';
$string['block09header'] = 'Заглавље блока 9';
$string['block09headerdefault'] = 'Доступне категорије';
$string['block09headerdesc'] = 'Опис заглавља блока 9';
$string['block09info'] = '! Блок-9 КАТЕГОРИЈЕ';
$string['block09infodesc'] = 'КАТЕГОРИЈЕ - унесите подешавања за блок 9';
$string['block10caption'] = 'Натпис блока {$a->block}';
$string['block10captiondesc'] = 'Додајте натпис за свој блок';
$string['block10count'] = 'Блок-10 Број';
$string['block10countdesc'] = 'Изаберите број блокова и притисните дугме \'Сачувај промене\'';
$string['block10design'] = 'Дизајн блока 10';
$string['block10designdesc'] = 'Изаберите дизајн блока 10 који желите да додате';
$string['block10enabled'] = 'Омогућите блок 10';
$string['block10enableddesc'] = 'Омогућите или онемогућите блок 10 на вашој почетној страници';
$string['block10header'] = 'Заглавље блока 10';
$string['block10headerdefault'] = 'СВЕДОЧАНСТВА';
$string['block10headerdesc'] = 'Заглавље блока 10';
$string['block10imgdesc'] = 'Додајте слику за свој блок';
$string['block10info'] = '! Блок-10 СВЕДОЧАНСТВА';
$string['block10infodesc'] = 'СВЕДОЧАНСТВА - Унесите подешавања за блок 10';
$string['block10job'] = 'Блок 10 - посао {$a->block}';
$string['block10jobdesc'] = 'Блок 10 - посао';
$string['block10link'] = 'Блок URL адреса {$a->block}';
$string['block10linkdesc'] = 'Додајте URL адресу за свој блок';
$string['block10name'] = 'Блок 10  - назив {$a->block}';
$string['block10namedesc'] = 'Блок 10  - назив';
$string['block11caption'] = 'Натпис блока 11';
$string['block11captiondefault'] = 'Добродошли на Almondb блог чланке.';
$string['block11captiondesc'] = 'Натпис блока 11';
$string['block11count'] = 'Блок-11 Број';
$string['block11countdesc'] = 'Изаберите број блогова који ће бити приказан';
$string['block11design'] = 'Дизајн блока 11';
$string['block11designdesc'] = 'Изаберите дизајн блока 11 који желите да додате';
$string['block11enabled'] = 'Омогућите блок 11';
$string['block11enableddesc'] = 'Омогућите или онемогућите блок 11 на вашој почетној страници';
$string['block11header'] = 'Заглавље блока 11';
$string['block11headerdefault'] = 'ALMOND БЛОГ';
$string['block11headerdesc'] = 'Заглавље блока 11';
$string['block11info'] = '! Блок-11 БЛОГ ЧЛАНАК';
$string['block11infodesc'] = 'БЛОГ ЧЛАНАК - Унесите подешавања за блок 11';
$string['block12info'] = '! Блок-12 Празан';
$string['block13info'] = '! Блок-13 Празан';
$string['block14info'] = '! Блок-14 Празан';
$string['block15info'] = '! Блок-15 Празан';
$string['block16info'] = '! Блок-16 Празан';
$string['block17info'] = '! Блок-17 Празан';
$string['block18caption'] = 'Натпис блока 18';
$string['block18captiondesc'] = 'Натпис блока 18';
$string['block18css'] = 'Block 18 CSS';
$string['block18cssdesc'] = 'Блок 18 - додајте CSS за свој блок';
$string['block18csslink'] = 'Блок 18 - линк за CSS';
$string['block18csslinkdesc'] = 'Блок 18 - додајте линк за CSS за свој блок';
$string['block18enabled'] = 'Омогућите блок 18';
$string['block18enableddesc'] = 'Омогућите или онемогућите блок 18 на вашој почетној страници';
$string['block18info'] = '! Блок-18 HTML БЛОК';
$string['block18infodesc'] = 'HTML БЛОК - Унесите подешавања за блок 18';
$string['block18title'] = 'Наслов блока 18';
$string['block18titledesc'] = 'Изаберите дизајн блока 18 који желите да додате';
$string['block19caption'] = 'Натпис блока 19';
$string['block19captiondefault'] = 'Давно је утврђена чињеница да ће читалац бити ометен читљивим садржајем странице када погледа њен изглед.';
$string['block19captiondesc'] = 'Натпис блока 19';
$string['block19design'] = 'Дизајн блока 19';
$string['block19designdesc'] = 'Изаберите дизајн блока 19 који желите да додате';
$string['block19enabled'] = 'Омогућите блок 19';
$string['block19enableddesc'] = 'Омогућите или онемогућите блок 19 на вашој почетној страници';
$string['block19header'] = 'Заглавље блока 19';
$string['block19headerdefault'] = 'НАШИ ПАРТНЕРИ';
$string['block19headerdesc'] = 'Заглавље блока 19';
$string['block19headerenabled'] = 'Омогућите заглавље блока 19';
$string['block19headerenableddesc'] = 'Омогућите/онемогућите заглавље блока 19';
$string['block19imgdesc'] = 'Додајте слику за свој блок';
$string['block19info'] = '! Блок-19 БРЕНДОВИ';
$string['block19infodesc'] = 'БРЕНДОВИ - Унесите подешавања за блок 19';
$string['block19link'] = 'URL адреса слике блока 19 {$a->block}';
$string['block19linkdesc'] = 'Додајте URL адресу слике за свој блок 19';
$string['block20col1caption'] = 'Натпис колоне 1 у блоку 20';
$string['block20col1captiondefault'] = 'Давно је утврђена чињеница да ће читалац бити ометен читљивим садржајем странице када погледа њен изглед.';
$string['block20col1captiondesc'] = 'Натпис колоне 1 у блоку 20';
$string['block20col1header'] = 'Заглавље колоне 1 у блоку 20';
$string['block20col1headerdesc'] = 'Заглавље колоне 1 у блоку 20';
$string['block20col2header'] = 'Заглавље колоне 2 у блоку 20';
$string['block20col2headerdesc'] = 'Унесите заглавље колоне 2 у блоку 20';
$string['block20col2link'] = 'Линк колоне 2 у блоку 20';
$string['block20col2linkdefault'] = 'О нама|https://themesalmond.com
                                    Наша прича|https://moodle.org/support
                                    Правила и услови|https://moodle.org/
Развој
                                    Правила о приватности|http://docs.moodle.org|Moodle Docs
                                    Мапа сајта|http://docs.moodle.org/en|Документација на енглеском|en
                                    Moodle.com|http://moodle.com/';
$string['block20col2linkdesc'] = 'Регион линкова колоне 2 у блоку 20';
$string['block20col3header'] = 'Заглавље колоне 3 у блоку 20';
$string['block20col3headerdesc'] = 'Унесите заглавље колоне 3 у блоку 20';
$string['block20col3link'] = 'Линкови колоне 3 у блоку 20';
$string['block20col3linkdefault'] = 'О нама|https://themesalmond.com
                                    Наша прича|https://moodle.org/support
                                    Правила и услови|https://moodle.org/
Развој
                                    Правила о приватности|http://docs.moodle.org|Moodle Docs
                                    Мапа сајта|http://docs.moodle.org/en|Документација на енглеском|en
                                    Moodle.com|http://moodle.com/';
$string['block20col3linkdesc'] = 'Регион линкова колоне 3 у блоку 20';
$string['block20col4caption'] = 'Натпис колоне 4 у блоку 20';
$string['block20col4captiondesc'] = 'Унесите натпис колоне 4 у блоку 20';
$string['block20col4header'] = 'Заглавље колоне 4 у блоку 20';
$string['block20col4headerdesc'] = 'Унесите заглавље колоне 4 у блоку20';
$string['block20copyright'] = 'Блок 20 Ауторска права';
$string['block20copyrightdefault'] = 'Copyright © 2022 Designed by
    <a href="https://www.themealmond.com">themesalmond.com</a>.  All rights reserved.';
$string['block20copyrightdesc'] = 'Блок 20 Ауторска права';
$string['block20enabled'] = 'Омогућите блок 20';
$string['block20enableddesc'] = 'Омогућите или онемогућите блок 20 на вашој почетној страници';
$string['block20info'] = '! Блок-20 ПОДНОЖЈЕ';
$string['block20infodesc'] = 'ПОДНОЖЈЕ - Унесите подешавања за блок 20';
$string['block20logo'] = 'Изаберите логотип блока 20';
$string['block20logodesc'] = 'Избор логотипа блока 20';
$string['block20moodle'] = 'Омогућите дугме на насловној страници';
$string['block20moodledesc'] = 'Омогућите или онемогућите блок 20 на Moodle оригиналнј насловној страници';
$string['block20social'] = 'Блок 20 линкови друштвених мрежа';
$string['block20socialdefault'] = '<ul>
<li><a href="#" target="_blank"><i class="fa fa-facebook-f"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-twitter"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-pinterest"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-linkedin"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-instagram"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-youtube-play"></i></a></li>
</ul>';
$string['block20socialdesc'] = 'Блок 20 линкови друштвених мрежа';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'Bootswatch представља скуп Bootstrap променљивих и CSS стилова за додатну промену изгледа Bootstrap теме';
$string['brandcolor'] = 'Бренд боја';
$string['brandcolor_desc'] = 'Боја позадине';
$string['button'] = 'Дугме';
$string['buttonlink'] = 'https://themesalmond.com/';
$string['choosereadme'] = 'Almondb је модерна веома прилагодљива тема';
$string['configtitle'] = 'Almondb';
$string['coursesection'] = 'Секције курса';
$string['coursesummary'] = 'Резиме курса';
$string['currentinparentheses'] = '(тренутно)';
$string['dashboardnavchoice'] = 'Навигација на контролном панелу';
$string['dashboardnavchoicedesc'] = 'Изаберите навигацију на контролном панелу која ће бити приказана';
$string['div'] = '</div>';
$string['divdiv'] = '</div></div></div>';
$string['footerbackgroundcolor'] = 'Боја позадине подножја';
$string['footerbackgroundcolordesc'] = 'Можете променити боју позадине подножја';
$string['footerselect'] = 'Контролни панел подножја';
$string['footerselectdesc'] = 'Изаберите стил обрасца контролног панела у подножју';
$string['frontpagealmondb'] = 'Наловна страница';
$string['frontpagechoice'] = 'Изаберите насловну страницу';
$string['frontpagechoicedesc'] = 'Изаберите насловну страницу која ће бити приказана';
$string['frontpagecolor'] = 'Изаберите подразумевану боју насловне странице';
$string['frontpagecolordesc'] = '<div class="row pb-3">
                                    <div class="col p-1 text-center" style="background-color:#4272d7;"> 1-#4272d7</div>
                                    <div class="col p-1 text-center" style="background-color:#f98012;"> 2-#f98012</div>
                                    <div class="col p-1 text-center" style="background-color:#fa4251;"> 3-#fa4251</div>
                                    <div class="col p-1 text-center" style="background-color:#c45e28;"> 4-#c45e28</div>
                                    <div class="col p-1 text-center" style="background-color:#63c76a;"> 5-#63c76a</div>
                                    <div class="col p-1 text-center" style="background-color:#024E64;"> 6-#024E64</div>
                                </div>';
$string['frontpagedesc'] = 'Изаберите насловну страницу која ће бити приказана';
$string['frontpageenddesc'] = '--*/*--';
$string['frontpageheading'] = '! Избор насловне странице';
$string['frontpageheading1'] = '! Насловна страница СЕКЦИЈЕ';
$string['frontpagenav'] = 'Избор заглавља насловне странице';
$string['frontpagenavchoice'] = 'Навигација на насловној страници';
$string['frontpagenavchoicedesc'] = 'Изаберите навигацију на насловној страници која ће бити приказана';
$string['frontpagenavdesc'] = 'Изаберите заглавље насловне странице које ће бити приказано';
$string['frontpagenavlightdark'] = 'Контраст навигационе траке на насловној страници';
$string['frontpagenavlightdarkdesc'] = 'Ако сте изнад изабрали тамну боју, изаберите "navbar-dark".';
$string['frontpagenavlink'] = 'Линкови у навигацији на насловној страници';
$string['frontpagenavlinkdesc'] = 'Унесите линкове за навигациону траку на насловној страници';
$string['frontpagesection1_1'] = 'Секција 1';
$string['frontpagesection1_10'] = 'Секција 10';
$string['frontpagesection1_2'] = 'Секција 2';
$string['frontpagesection1_3'] = 'Секција 3';
$string['frontpagesection1_4'] = 'Секција 4';
$string['frontpagesection1_5'] = 'Секција 5';
$string['frontpagesection1_6'] = 'Секција 6';
$string['frontpagesection1_7'] = 'Секција 7';
$string['frontpagesection1_8'] = 'Секција 8';
$string['frontpagesection1_9'] = 'Секција 9';
$string['frontpagesectiondesc1_1'] = 'Секција насловне странице 1';
$string['frontpagesectiondesc1_10'] = 'Секција насловне странице 10';
$string['frontpagesectiondesc1_2'] = 'Секција насловне странице 2';
$string['frontpagesectiondesc1_3'] = 'Секција насловне странице 3';
$string['frontpagesectiondesc1_4'] = 'Секција насловне странице 4';
$string['frontpagesectiondesc1_5'] = 'Секција насловне странице 5';
$string['frontpagesectiondesc1_6'] = 'Секција насловне странице 6';
$string['frontpagesectiondesc1_7'] = 'Секција насловне странице 7';
$string['frontpagesectiondesc1_8'] = 'Секција насловне странице 8';
$string['frontpagesectiondesc1_9'] = 'Секција насловне странице 9';
$string['generalsettings'] = 'Општа подешавања';
$string['header3phone'] = 'Број телефона';
$string['header3phonedesc'] = 'Контакт телефон који се приказује на траци за навигацију.';
$string['headerlogo'] = 'Изаберите логотип навигационе траке';
$string['headerlogodesc'] = 'Изаберите приказ логотипа навигационе траке на насловној страници';
$string['imgloginbackground'] = 'Позадинска слике странице за пријаву на систем';
$string['imgloginbackground_desc'] = 'Позадинска слике странице за пријаву на систем';
$string['loggedinnot'] = 'пријава.';
$string['loginbackgroundimage'] = 'Позадинска слика странице за пријаву';
$string['loginbackgroundimage_desc'] = 'Слика која ће бити приказана као позадина странице за пријаву на систем.';
$string['loginposition'] = 'Позиција обрасца за пријаву';
$string['loginpositiondesc'] = 'Изаберите позицију обрасца за пријаву на екрану';
$string['navbarcolor'] = 'Боја позадине навигационе траке';
$string['navbarcolor_desc'] = 'Боја позадине навигационе траке';
$string['navbarcontainer'] = 'Контејнер навигацијске траке';
$string['navbarcontainerdesc'] = 'Можете убацити траку за навигацију унутар контејнера';
$string['pluginname'] = 'Almondb';
$string['preset'] = 'Предефинисана подешавања теме';
$string['preset_desc'] = 'Изаберите скуп предефинисаних подешавања како бисте свеобухватно променили изглед теме.';
$string['presetfiles'] = 'Додатне датотеке са предефинисаним подешавањима теме.';
$string['presetfiles_desc'] = 'Датотеке са предефинисаним подешавањима могу у великој мери да измене изглед теме. За више информације о томе како да креирате своје предефинисане датотеке и поделите их са другима погледајте <a href="https://docs.moodle.org/dev/almondb_Presets">Almondb  предефинисане датотеке</a>. Погледајте, такође, <a href="https://archive.moodle.net/almondb">Репозиторијум предефинисаних датотека</a> за подешавања које су други корисници поделили.';
$string['privacy:drawerblockclosed'] = 'Тренутни параметар за фиоку са блоковима је: затворено';
$string['privacy:drawerblockopen'] = 'Тренутни параметар за фиоку са блоковима је: отворено';
$string['privacy:drawerindexclosed'] = 'Тренутни параметар за фиоку са индексом курса је: затворено';
$string['privacy:drawerindexopen'] = 'Тренутни параметар за фиоку са индексом курса је: отворено';
$string['privacy:drawernavclosed'] = 'Тренутни параметар за навигациону фиоку је: затворено';
$string['privacy:drawernavopen'] = 'Тренутни параметар за навигациону фиоку је: отворено';
$string['privacy:metadata'] = 'Тема Almondb не чува никакве личне податке о било ком кориснику.';
$string['privacy:metadata:preference:draweropenblock'] = 'Кориснички параметар за сакривање или приказивање фиоке са блоковима.';
$string['privacy:metadata:preference:draweropenindex'] = 'Кориснички параметар за сакривање или приказивање фиоке са индексом курса.';
$string['privacy:metadata:preference:draweropennav'] = 'Кориснички параметар за скривање или приказивање навигационе фиоке са менијем';
$string['rawscss'] = 'Необрађен SCSS';
$string['rawscss_desc'] = 'Употребите ово поље како бисте додали SCSS или CSS кôд који ће бити додат на крај скупа стилова.';
$string['rawscsspre'] = 'Необрађен иницијални SCSS';
$string['rawscsspre_desc'] = 'У ово поље можете да унесете иницијални SCSS кôд, који ће бити додата на почетак, пре било чега другог. Најчешће ћете користити ово подешавање за дефинисање променљивих.';
$string['region-side-pre'] = 'Десно';
$string['sitecolor'] = 'Изаберите боју насловне странице';
$string['sitecolor-1'] = '#4272d7';
$string['sitecolor-2'] = '#f98012';
$string['sitecolor-3'] = '#fa4251';
$string['sitecolor-4'] = '#c45e28';
$string['sitecolor-5'] = '#63c76a';
$string['sitecolor-6'] = '#024E64';
$string['sitecolor_desc'] = 'Можете одабрати боју коју желите, осим подразумеване';
$string['slideno'] = '! Слајд-{$a->slide}';
$string['slidenodesc'] = 'Унесите подешавања за слајд {$a->slide}.';
$string['sliderbutton'] = 'Дугме на слајду';
$string['sliderbuttondesc'] = 'Унесите линк текста дугмета на слајду, користећи било језички кључ или текст. Нпр:  lang:display или Display';
$string['sliderbuttonurl'] = 'Линк дугмета на слајду';
$string['sliderbuttonurldesc'] = 'Унесите одредиште линка дугмета на слајду';
$string['slidercaption'] = 'Натпис слајда';
$string['slidercaptiondesc'] = 'Додајте натпис за свој слајд';
$string['slidercount'] = 'Слајд-шоу - број';
$string['slidercountdesc'] = 'Изаберите колико слајдова желите да додате <strong>затим кликните на дугме САЧУВАЈ</strong> како би се учитала поља за унос подешавања.';
$string['sliderdesign'] = 'Слајд-шоу дизајн';
$string['sliderdesigndesc'] = 'Изаберите дизајн слајдова које желите да додате';
$string['sliderenabled'] = 'Омогућите слајд-шоу';
$string['sliderenableddesc'] = 'Омогућите слајд-шоу на врху почетне странице';
$string['sliderimage'] = 'Слика слајда';
$string['sliderimageblock02img'] = 'Слика блока {$a->block}';
$string['sliderimageblock04img'] = 'Слика блока {$a->block}';
$string['sliderimageblock05img'] = 'Слика блока';
$string['sliderimageblock06img'] = 'Слика блока';
$string['sliderimageblock10img'] = 'Слика блока {$a->block}';
$string['sliderimageblock19img'] = 'Слика блока 19 {$a->block}';
$string['sliderimagedesc'] = 'Додајте слику за свој слајд. Препоручена величина је 1500 к 540 пиксела или већа.';
$string['slideropacity'] = 'Слајд-шоу - непрозирност';
$string['slideropacitydesc'] = 'Непрозирност боје на насловној страници за слајд-шоу';
$string['slidershowheight'] = 'Висина слајд-шоу презентације';
$string['slidershowheight_desc'] = 'Подесите висину слајд-шоу презентације на почетној страници сајта.';
$string['slidertitle'] = 'Наслов слајда';
$string['slidertitledesc'] = 'Додајте наслов слајда.';
$string['slideshow'] = 'Слајд.шоу';
$string['slideshowenddesc'] = '--*/*--';
$string['slideshowheading'] = ': Слајд-шоу на почетној страници';
$string['slideshowheadingdesc'] = 'Ово креира слајд-шоу од максимално шест слајдова за промовисање важних елеменат вашег сајта. Слајд-шоу је прилагодљивог дизајна, што значи да се висина слике прилагођава величини екрана. Ако ниједна слика није изабрана за слајд, користе се подразумеване слике у директоријуму pix.';
$string['slideshowstart'] = 'Подешавања за слајд-шоу на почетној страници';
$string['slideshowstartdesc'] = '--*/*--';
$string['theme_almondb_frontpageblock'] = 'Блок';
$string['theme_almondb_frontpageblockdesc'] = 'Подешавање HTML блокова на почетној страници';
$string['theme_almondb_frontpageblockenddesc'] = '--*/*--';
$string['theme_almondb_frontpageblockheading'] = 'Блокови насловне странице';
$string['themesettings'] = 'Подешавање темe';
$string['totop'] = 'Иди на врх';
$string['unaddableblocks'] = 'Непотребни блокови';
$string['unaddableblocks_desc'] = 'Наведени блокови нису потребни када користите ову тему и неће бити наведени у менију \'Додај блок\'.';
$string['underline'] = '<div style="margin-bottom: 10px; border-bottom:3px solid blue;width:100%;"></div><br>';
