<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'id', version '4.1'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Menambahkan peran baru';
$string['addrole'] = 'Tambahkan peran baru';
$string['advancedoverride'] = 'Penyampingan peran lanjutan';
$string['allow'] = 'Izinkan';
$string['allowassign'] = 'Izinkan penugasan peran';
$string['allowed'] = 'Diizinkan';
$string['allowoverride'] = 'Izinkan penyampingan peran';
$string['allowroletoassign'] = 'Izinkan pengguna dengan peran {$a->fromrole} untuk menerapkan peran {$a->targetrole}';
$string['allowroletooverride'] = 'Izinkan pengguna dengan peran {$a->fromrole} menyampingkan peran {$a->targetrole}';
$string['allowroletoswitch'] = 'Izinkan pengguna dengan peran {$a->fromrole} beralih menjadi peran {$a->targetrole}';
$string['allowroletoview'] = 'Izinkan pengguna dengan peran {$a->fromrole} untuk melihat peran {$a->targetrole}';
$string['allowswitch'] = 'Izinkan peralihan peran';
$string['allowview'] = 'Izinkan peran untuk dilihat';
$string['allsiteusers'] = 'Seluruh pengguna situs';
$string['analytics:listinsights'] = 'Daftar wawasan';
$string['analytics:listowninsights'] = 'Daftar wawasan sendiri';
$string['analytics:managemodels'] = 'Kelola model';
$string['archetype'] = 'Pola dasar peran';
$string['archetype_help'] = 'Pola dasar peran menentukan izin ketika peran diatur ulang ke setelan bawaan. Ia juga menentukan segala perizinan baru untuk peran tersebut ketika situs ditingkatkan.';
$string['archetypecoursecreator'] = 'POLA DASAR: Pembuat kursus';
$string['archetypeeditingteacher'] = 'POLA DASAR: Pengajar (penyunting)';
$string['archetypefrontpage'] = 'POLA DASAR: Pengguna terauntentifikasi pada beranda situs';
$string['archetypeguest'] = 'POLA DASAR: Tamu';
$string['archetypemanager'] = 'POLA DASAR: Manajer';
$string['archetypestudent'] = 'POLA DASAR: Siswa';
$string['archetypeteacher'] = 'POLA DASAR: Pengajar (bukan penyunting)';
$string['archetypeuser'] = 'POLA DASAR: Pengguna terauntentifikasi';
$string['assignanotherrole'] = 'Terapkan peran lain';
$string['assignedroles'] = 'Peran diterapkan';
$string['assignerror'] = 'Terjadi galat ketika menerapkan peran {$a->role} ke pengguna {$a->user}.';
$string['assignglobalroles'] = 'Terapkan peran sistem';
$string['assignmentcontext'] = 'Konteks penugasan';
$string['assignmentoptions'] = 'Opsi penugasan';
$string['assignrole'] = 'Terapkan peran';
$string['assignrolenameincontext'] = 'Terapkan peran \'{$a->role}\' pada {$a->context}';
$string['assignroles'] = 'Terapkan peran';
$string['assignroles_help'] = 'Dengan menetapkan peran ke pengguna dalam konteks, Anda memberi mereka izin yang terdapat dalam peran itu, untuk konteks saat ini dan semua konteks yang lebih rendah. Misalnya, jika pengguna diberi peran sebagai siswa dalam suatu kursus, mereka juga akan memiliki peran sebagai siswa untuk semua aktivitas dan blok dalam kursus tersebut.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Terapkan peran pada {$a}';
$string['assignrolesrelativetothisuser'] = 'Terapkan peran relatif pada pengguna ini';
$string['backtoallroles'] = 'Kembali ke daftar peran';
$string['backup:anonymise'] = 'Anonimiasi data pengguna pada cadangan';
$string['backup:backupactivity'] = 'Cadangkan aktifitas';
$string['backup:backupcourse'] = 'Cadangkan kursus';
$string['backup:backupsection'] = 'Cadangkan seksi';
$string['backup:backuptargetimport'] = 'Cadangkan untuk impor';
$string['backup:configure'] = 'Atur opsi pencadangan';
$string['backup:downloadfile'] = 'Unduh berkas dari area cadangan';
$string['backup:userinfo'] = 'Cadangkan data pengguna';
$string['badges:awardbadge'] = 'Berikan lencana pada pengguna';
$string['badges:configurecriteria'] = 'Atur/edit kriteria peraihan lencana';
$string['badges:configuredetails'] = 'Setel/edit detail lencana';
$string['badges:configuremessages'] = 'Atur pesan lencana';
$string['badges:createbadge'] = 'Buat/gandakan lencana';
$string['badges:deletebadge'] = 'Hapus lencana';
$string['badges:earnbadge'] = 'Dapatkan lencana';
$string['badges:manageglobalsettings'] = 'Kelola lencana setelan global';
$string['badges:manageownbadges'] = 'Lihat dan atur lencana yang diraih';
$string['badges:revokebadge'] = 'Cabut lencana dari pengguna';
$string['badges:viewawarded'] = 'Lihat pengguna yang mendapatkan lencana yang spesifik tanpa memiliki kemampuan memberi lencana';
$string['badges:viewbadges'] = 'Lihat lencana tersedia tanpa mendapatkannya';
$string['badges:viewotherbadges'] = 'Lihat lencana umum pada profil pengguna lain';
$string['block:edit'] = 'Edit setelan blok';
$string['block:view'] = 'Lihat blok';
$string['blog:create'] = 'Buat entri blog baru';
$string['blog:manageentries'] = 'Edit dan atur entri';
$string['blog:manageexternal'] = 'Edit dan atur blog eksternal';
$string['blog:search'] = 'Cari masukan blog';
$string['blog:view'] = 'Lihat masukan blog';
$string['blog:viewdrafts'] = 'Lihat draf entri blog';
$string['calendar:manageentries'] = 'Atur masukan kalender apapun';
$string['calendar:managegroupentries'] = 'Atur masukan kalender grup';
$string['calendar:manageownentries'] = 'Atur masukan kalender sendiri';
$string['capabilities'] = 'Kemampuan-kemampuan';
$string['capability'] = 'Kemampuan';
$string['category:create'] = 'Buat kategori';
$string['category:delete'] = 'Hapus kategori';
$string['category:manage'] = 'Atur kategori';
$string['category:update'] = 'Perbarui kategori';
$string['category:viewcourselist'] = 'Lihat daftar kursus yang Anda tidak terdaftar di dalamnya';
$string['category:viewhiddencategories'] = 'Lihat kategori yang disembunyikan';
$string['category:visibility'] = 'Lihat kategori yang disembunyikan';
$string['checkglobalpermissions'] = 'Periksa perizinan sistem';
$string['checkpermissions'] = 'Periksa perizinan';
$string['checkpermissionsin'] = 'Periksa perizinan pada {$a}';
$string['checksystempermissionsfor'] = 'Periksa perizinan sistem untuk {$a->fullname}';
$string['checkuserspermissionshere'] = 'Periksa perizinan untuk {$a->fullname} dimiliki pada {$a->contextlevel}';
$string['chooseroletoassign'] = 'Silakan pilih peran untuk diterapkan';
$string['cohort:assign'] = 'Tambahkan dan hapus anggota kohor';
$string['cohort:manage'] = 'Buat, hapus dan pindahkan kohor';
$string['cohort:view'] = 'Lihat kohor seluruh situs';
$string['comment:delete'] = 'Hapus komentar';
$string['comment:post'] = 'Kirim komentar';
$string['comment:view'] = 'Lihat komentar';
$string['competency:competencygrade'] = 'Atur tingkatan kompetensi';
$string['competency:competencymanage'] = 'Atur kerangka kerja kompetensi';
$string['competency:competencyview'] = 'Lihat kerangka kerja kompetensi';
$string['competency:coursecompetencyconfigure'] = 'Atur setelan kompetensi kursus';
$string['competency:coursecompetencygradable'] = 'Menerima tanda kompetensi';
$string['competency:coursecompetencymanage'] = 'Atur kompetensi kursus';
$string['competency:coursecompetencyview'] = 'Lihat kompetensi kursus';
$string['competency:evidencedelete'] = 'Hapus bukti';
$string['competency:plancomment'] = 'Komentar pada rencana belajar';
$string['competency:plancommentown'] = 'Komentar pada rencana belajar sendiri';
$string['competency:planmanage'] = 'Atur rencana belajar';
$string['competency:planmanagedraft'] = 'Atur draft rencana belajar';
$string['competency:planmanageown'] = 'Atur rencana belajar sendiri';
$string['competency:planmanageowndraft'] = 'Atur draft rencana belajar sendiri';
$string['competency:planrequestreview'] = 'Minta tinjauan ulang rencana belajar';
$string['competency:planrequestreviewown'] = 'Minta tinjauan ulang rencana belajar sendiri';
$string['competency:planreview'] = 'Tinjau ulang rencana belajar';
$string['competency:planview'] = 'Lihat semua rencana belajar';
$string['competency:planviewdraft'] = 'Lihat draf rencana belajar';
$string['competency:planviewown'] = 'Lihat rencana belajar sendiri';
$string['competency:planviewowndraft'] = 'Lihat draft rencana belajar sendiri';
$string['competency:templatemanage'] = 'Atur template rencana belajar';
$string['competency:templateview'] = 'Lihat template rencana belajar';
$string['competency:usercompetencycomment'] = 'Komentar pada kompetensi pengguna';
$string['competency:usercompetencycommentown'] = 'Komentar pada kompetensi pengguna sendiri';
$string['competency:usercompetencyrequestreview'] = 'Minta tinjauan ulang kompetensi pengguna';
$string['competency:usercompetencyrequestreviewown'] = 'Minta tinjauan ulang kompetensi pengguna sendiri';
$string['competency:usercompetencyreview'] = 'Tinjau ulang kompetensi pengguna';
$string['competency:usercompetencyview'] = 'Lihat kompetensi pengguna';
$string['competency:userevidencemanage'] = 'Atur bukti dari pembelajaran sebelumnya';
$string['competency:userevidencemanageown'] = 'Atur bukti dari pembelajaran sebelumnya sendiri';
$string['competency:userevidenceview'] = 'Lihat bukti dari pembelajaran pengguna sebelumnya';
$string['confirmaddadmin'] = 'Apakah anda yakin untuk menambahkan pengguna {$a} sebagai administrator situs yang baru?';
$string['confirmdeladmin'] = 'Apakah anda yakin untuk mengeluarkan pengguna {$a} dari daftar administrator situs?';
$string['confirmroleprevent'] = 'Apakah anda yakin untuk menghapus "{$a->role}" dari daftar peran yang diizinkan untuk kemampuan "{$a->cap}" pada konteks "{$a->context}"?';
$string['confirmroleunprohibit'] = 'Apakah anda yakin untuk menghapus "{$a->role}" dari daftar peran yang dilarang untuk kemampuan "{$a->cap}" pada konteks "{$a->context}"?';
$string['confirmunassign'] = 'Apakah anda yakin untuk menghapus peran ini dari pengguna ini?';
$string['confirmunassignno'] = 'Batalkan';
$string['confirmunassigntitle'] = 'Konfirmasi perubahan peran';
$string['confirmunassignyes'] = 'Hapus';
$string['contentbank:access'] = 'Akses ke bank konten';
$string['contentbank:deleteanycontent'] = 'Hapus konten apa pun dari bank konten';
$string['contentbank:deleteowncontent'] = 'Hapus konten dari bank konten sendiri';
$string['contentbank:downloadcontent'] = 'Unduh konten dari bank konten';
$string['contentbank:manageanycontent'] = 'Kelola konten apa pun dari bank konten';
$string['contentbank:manageowncontent'] = 'Kelola konten dari bank konten sendiri';
$string['contentbank:upload'] = 'Unggah konten baru ke bank konten';
$string['contentbank:useeditor'] = 'Buat atau ubah konten menggunakan editor tipe konten';
$string['contentbank:viewunlistedcontent'] = 'Lihat konten yang tidak terdaftar dari bank konten';
$string['context'] = 'Konteks';
$string['contextrolenotallowed'] = 'Peran <b>{$a}</b> tidak diizinkan dalam konteks ini.';
$string['course:activityvisibility'] = 'Sembunyikan/tampilkan aktivitas';
$string['course:bulkmessaging'] = 'Kirim pesan ke banyak orang';
$string['course:changecategory'] = 'Ubah kategori kursus';
$string['course:changefullname'] = 'Ubah nama lengkap kursus';
$string['course:changeidnumber'] = 'Ubah nomor ID kursus';
$string['course:changelockedcustomfields'] = 'Ubah kolom kustom yang dikunci';
$string['course:changeshortname'] = 'Ubah nama singkat kursus';
$string['course:changesummary'] = 'Ubah ringkasan kursus';
$string['course:configurecustomfields'] = 'Konfigurasikan kolom kustom kursus';
$string['course:configuredownloadcontent'] = 'Konfigurasikan unduhan konten kursus';
$string['course:create'] = 'Buat kursus';
$string['course:creategroupconversations'] = 'Buat percakapan grup';
$string['course:delete'] = 'Hapus kursus';
$string['course:downloadcoursecontent'] = 'Unduh konten kursus';
$string['course:enrolconfig'] = 'Konfigurasikan mendaftarkan model dalam kursus';
$string['course:enrolreview'] = 'Tinjau ulang pendaftaran kursus';
$string['course:ignoreavailabilityrestrictions'] = 'Abaikan batasan ketersediaan';
$string['course:ignorefilesizelimits'] = 'Gunakan berkas yang lebih besar dari semua pembatasan ukuran berkas';
$string['course:isincompletionreports'] = 'Akan ditunjukkan pada laporan penyelesaian';
$string['course:manageactivities'] = 'Atur aktivitas';
$string['course:managefiles'] = 'Atur berkas';
$string['course:managegrades'] = 'Atur nilai';
$string['course:managegroups'] = 'Kelola grup';
$string['course:managescales'] = 'Atur skala';
$string['course:markcomplete'] = 'Tandai pengguna sebagai "selesai" pada penyelesaian kursus';
$string['course:movesections'] = 'Pindahkan seksi';
$string['course:overridecompletion'] = 'Ganti status penyelesaian aktivitas';
$string['course:recommendactivity'] = 'Rekomendasikan aktivitas di pemilih aktivitas';
$string['course:renameroles'] = 'Ganti nama peran';
$string['course:request'] = 'Meminta kursus baru';
$string['course:reset'] = 'Atur ulang kursus';
$string['course:reviewotherusers'] = 'Tinjau ulang pengguna lain';
$string['course:sectionvisibility'] = 'Atur kepandangan seksi';
$string['course:setcurrentsection'] = 'Atur seksi saat ini';
$string['course:setforcedlanguage'] = 'Paksa kursus atau bahasa aktivitas';
$string['course:tag'] = 'Ubah tag kursus';
$string['course:togglecompletion'] = 'Tandai aktivitas secara manual sebagai selesai';
$string['course:update'] = 'Perbarui setelan kursus';
$string['course:useremail'] = 'Aktifkan/nonaktifkan alamat surel';
$string['course:view'] = 'Lihat kursus tanpa berpartisipasi';
$string['course:viewcoursegrades'] = 'Lihat nilai kursus';
$string['course:viewhiddenactivities'] = 'Lihat aktivitas tersembunyi';
$string['course:viewhiddencourses'] = 'Lihat kursus tersembunyi';
$string['course:viewhiddensections'] = 'Lihat seksi tersembunyi';
$string['course:viewhiddenuserfields'] = 'Lihat ruas pengguna tersembunyi';
$string['course:viewparticipants'] = 'Lihat peserta';
$string['course:viewscales'] = 'Lihat skala';
$string['course:viewsuspendedusers'] = 'Lihat pengguna yang ditangguhkan';
$string['course:visibility'] = 'Sembunyikan/tampilkan kursus';
$string['createrolebycopying'] = 'Buat peran baru dengan menyalin {$a}';
$string['createthisrole'] = 'Buat peran ini';
$string['currentcontext'] = 'Konteks saat ini';
$string['currentrole'] = 'Peran saat ini';
$string['customroledescription'] = 'Deskripsi yang disesuaikan';
$string['customroledescription_help'] = 'Deskripsi peran standar terlokalisasi secara otomatis apabila deskripsi yang disesuaikan dikosongkan.';
$string['customrolename'] = 'Nama lengkap yang disesuaikan';
$string['customrolename_help'] = 'Nama peran standar terlokalisasi secara otomatis apabila nama yang disesuaikan kosong. Anda harus memasukkan nama lengkap untuk setiap peran yang disesuaikan.';
$string['defaultrole'] = 'Peran bawaan';
$string['defaultx'] = 'Bawaan: {$a}';
$string['defineroles'] = 'Definisikan peran';
$string['definitionofrolex'] = 'Definisi peran \'{$a}\'';
$string['deletecourseoverrides'] = 'Hapus semua timpaan dalam kursus';
$string['deletelocalroles'] = 'Hapus semua penugasan peran lokal';
$string['deleterolesure'] = 'Apakah anda yakin untuk menghapus peran "{$a->name} ({$a->shortname})"?

Saat ini peran ini diterapkan kepada {$a->count} pengguna.';
$string['deletexrole'] = 'Hapus peran {$a}';
$string['duplicaterole'] = 'Gandakan peran';
$string['duplicaterolesure'] = 'Apakah anda yakin untuk menggandakan peran "{$a->name} ({$a->shortname})"?';
$string['editingrolex'] = 'Menyunting peran \'{$a}\'';
$string['editrole'] = 'Edit peran';
$string['editxrole'] = 'Edit peran {$a}';
$string['errorbadrolename'] = 'Nama peran tidak benar';
$string['errorbadroleshortname'] = 'Nama singkat peran tidak benar';
$string['errorexistsrolename'] = 'Nama peran sudah ada';
$string['errorexistsroleshortname'] = 'Nama peran sudah ada';
$string['errorroleshortnametoolong'] = 'Nama singkat tidak boleh lebih dari 100 karakter';
$string['eventcapabilityassigned'] = 'Kapabilitas diterapkan';
$string['eventcapabilityunassigned'] = 'Kapabilitas dibatalkan';
$string['eventroleallowassignupdated'] = 'Izinkan penugasan peran';
$string['eventroleallowoverrideupdated'] = 'Izinkan penyampingan peran';
$string['eventroleallowswitchupdated'] = 'Izinkan peralihan peran';
$string['eventroleallowviewupdated'] = 'Izinkan melihat peran';
$string['eventroleassigned'] = 'Peran diterapkan';
$string['eventrolecapabilitiesupdated'] = 'Kemampuan peran diperbarui';
$string['eventroledeleted'] = 'Peran dihapus';
$string['eventroleunassigned'] = 'Peran tidak lagi diterapkan';
$string['eventroleupdated'] = 'Peran diperbarui';
$string['existingadmins'] = 'Administrator situs saat ini';
$string['existingusers'] = '{$a} pengguna hadir';
$string['explanation'] = 'Penjelasan';
$string['export'] = 'Ekspor';
$string['extusers'] = 'Pengguna hadir';
$string['extusersmatching'] = 'Pengguna hadir yang cocok dengan \'{$a}';
$string['filter:manage'] = 'Atur setelan saringan lokal';
$string['frontpageuser'] = 'Pengguna yang terautentikasi di beranda situs';
$string['frontpageuserdescription'] = 'Semua pengguna yang masuk pada kursus beranda situs.';
$string['globalrole'] = 'Peran sistem';
$string['globalroleswarning'] = 'PERINGATAN! Peranan yang anda terapkan dari halaman ini akan diberikan kepada pengguna yang diterapkan di seluruh sistem, termasuk beranda situs dan seluruh kursus.';
$string['gotoassignroles'] = 'Menuju Terapkan peran  untuk {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Menuju Terapkan peran sistem';
$string['grade:edit'] = 'Edit nilai';
$string['grade:export'] = 'Ekspor nilai';
$string['grade:hide'] = 'Sembunyikan/kembalikan nilai atau item';
$string['grade:import'] = 'Impor nilai';
$string['grade:lock'] = 'Kunci nilai atau item';
$string['grade:manage'] = 'Atur item nilai';
$string['grade:managegradingforms'] = 'Atur metode penilaian lanjutan';
$string['grade:manageletters'] = 'Atur nilai huruf';
$string['grade:manageoutcomes'] = 'Kelola penilaian capaian';
$string['grade:managesharedforms'] = 'Atur template form penilaian lanjutan';
$string['grade:override'] = 'Timpa nilai';
$string['grade:sharegradingforms'] = 'Bagikan form penilaian lanjutan sebagai template';
$string['grade:unlock'] = 'Buka nilai atau item';
$string['grade:view'] = 'Lihat nilai sendiri';
$string['grade:viewall'] = 'Lihat nilai pengguna lain';
$string['grade:viewhidden'] = 'Lihat nilai disembunyikan untuk pemilik';
$string['h5p:deploy'] = 'Terapkan konten H5P';
$string['h5p:setdisplayoptions'] = 'Setel opsi tampilan H5P';
$string['h5p:updatelibraries'] = 'Kelola jenis konten H5P';
$string['highlightedcellsshowdefault'] = 'Izin yang disorot dalam tabel di bawah ini adalah bawaan untuk arketipe peran yang saat ini dipilih di atas.';
$string['highlightedcellsshowinherit'] = 'Sel yang disoroti pada tabel di bawah menunjukkan perizinan (apabila ada) yang akan diturunkan. Anda harus membiarkan semua diatur sebagai "diturunkan" diluar seseorang yang perizinannya memang ingin anda ubah.';
$string['inactiveformorethan'] = 'tidak aktif lebih dari {$a->timeperiod}';
$string['ingroup'] = 'pada grup "{$a->group}"';
$string['inherit'] = 'Turunkan';
$string['invalidpresetfile'] = 'Berkas definisi peran tidak valid';
$string['legacy:admin'] = 'PERAN TURUNAN: Administrator';
$string['legacy:coursecreator'] = 'PERAN TURUNAN: Pembuat kursus';
$string['legacy:editingteacher'] = 'PERAN TURUNAN: Pengajar (menyunting)';
$string['legacy:guest'] = 'PERAN TURUNAN: Tamu';
$string['legacy:student'] = 'PERAN TURUNAN: Siswa';
$string['legacy:teacher'] = 'PERAN TURUNAN: Pengajar (bukan penyunting)';
$string['legacy:user'] = 'PERAN TURUNAN: Pengguna Terautentikasi';
$string['legacytype'] = 'Tipe peran turunan';
$string['listallroles'] = 'Daftar semua peran';
$string['localroles'] = 'Peran diterapkan secara lokal';
$string['mainadmin'] = 'Administrator utama';
$string['mainadminset'] = 'Atur administrator utama';
$string['manageadmins'] = 'Atur administrator situs';
$string['manager'] = 'Manajer';
$string['managerdescription'] = 'Manajer dapat mengakses kursus dan memodifikasinya, tetapi biasanya tidak berpartisipasi di dalamnya.';
$string['manageroles'] = 'Kelola peran';
$string['maybeassignedin'] = 'Tipe konteks dimana peran ini dapat diterapkan';
$string['morethan'] = 'Lebih dari {$a}';
$string['multipleroles'] = 'Peran jamak';
$string['my:configsyspages'] = 'Atur template sistem untuk halaman dasbor';
$string['my:manageblocks'] = 'Atur blok halaman dasbor';
$string['neededroles'] = 'Peran dengan perizinan';
$string['nocapabilitiesincontext'] = 'Tidak ada kemampuan tersedia untuk konteks ini';
$string['noneinthisx'] = 'Tidak ada pada {$a}';
$string['noneinthisxmatching'] = 'Tidak ada pengguna cocok dengan \'{$a->search}\' pada {$a->contexttype}';
$string['norole'] = 'Tidak ada peran';
$string['noroleassignments'] = 'Pengguna ini tidak memiliki tugas peran apa pun di situs ini.';
$string['noroles'] = 'Tidak ada peran';
$string['notabletoassignroleshere'] = 'Penerapan peran pada konteks ini tidak dimungkinkan oleh administrator.';
$string['notabletooverrideroleshere'] = 'Anda tidak dapat menyampingkan perizinan pada peran apapun di sini';
$string['notes:manage'] = 'Atur catatan';
$string['notes:view'] = 'Lihat catatan';
$string['notset'] = 'Tidak diatur';
$string['novisibleroles'] = 'Tanpa peran';
$string['overrideanotherrole'] = 'Penyampingan peran lain';
$string['overridecontext'] = 'Timpa konteks';
$string['overridepermissions'] = 'Timpa perizinan';
$string['overridepermissions_help'] = 'Penimpaan perizinan memungkinkan kemampuan-kemampuan yang dipilih untuk diizinkan atau dilarang dapam konteks yang spesifik.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Penyampingan perizinan untuk peran \'{$a->role}\' pada {$a->context}';
$string['overridepermissionsin'] = 'Timpa perizinan pada {$a}';
$string['overrideroles'] = 'Penyampingan peran';
$string['overriderolesin'] = 'Timpa peran pada {$a}';
$string['overrides'] = 'Timpaan-timpaan';
$string['overridesbycontext'] = 'Timpaan-timpaan (dengan konteks)';
$string['payment:manageaccounts'] = 'Kelola akun';
$string['payment:viewpayments'] = 'Lihat pembayaran';
$string['permission'] = 'Perizinan';
$string['permission_help'] = 'Perizinan adalah setelan kemampuan. Ada 4 opsi:
* Tidak diatur
* Izinkan - Perizinan disetujui untuk kemampuan tersebut
* Cegah - Perizinan dihilangkan untuk kemampuan tersebut, meskipun diizinkan pada konteks yang lebih tinggi
* Larang - Perizinan ditolak seluruhnya dan tidak dapat ditimpa pada konteks yang lebih rendah (lebih spesifik)';
$string['permissions'] = 'Perizinan';
$string['permissionsforuser'] = 'Perizinan untuk pengguna {$a}';
$string['permissionsincontext'] = 'Perizinan pada {$a}';
$string['portfolio:export'] = 'Ekspor portofolio';
$string['potentialusers'] = '{$a} pengguna potensial';
$string['potusers'] = 'Pengguna potensial';
$string['potusersmatching'] = 'Pengguna potensial cocok dengan \'{$a}';
$string['prevent'] = 'Cegah';
$string['privacy:metadata:preference:showadvanced'] = 'Tangani tombol sakelar mode lanjutan.';
$string['privacy:metadata:role_assignments'] = 'Penetapan peran';
$string['privacy:metadata:role_assignments:component'] = 'Pengaya yang bertanggung jawab atas penetapan peran, kosong saat ditetapkan secara manual.';
$string['privacy:metadata:role_assignments:itemid'] = 'ID model pendaftaran/autentikasi yang bertanggung jawab atas penetapan peran ini';
$string['privacy:metadata:role_assignments:modifierid'] = 'ID pengguna yang membuat atau memodifikasi penetapan peran';
$string['privacy:metadata:role_assignments:roleid'] = 'ID peran';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Tabel ini menyimpan peran yang ditetapkan dalam setiap konteks.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Tanggal saat penetapan peran dibuat atau diubah.';
$string['privacy:metadata:role_assignments:userid'] = 'ID pengguna';
$string['privacy:metadata:role_capabilities'] = 'Kapabilitas peran';
$string['privacy:metadata:role_capabilities:capability'] = 'Nama kapabilitas';
$string['privacy:metadata:role_capabilities:modifierid'] = 'ID pengguna yang membuat atau memodifikasi kapabilitas';
$string['privacy:metadata:role_capabilities:permission'] = 'Izin untuk suatu kemampuan: mewarisi, mengizinkan, mencegah, atau melarang.';
$string['privacy:metadata:role_capabilities:roleid'] = 'ID peran';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Kemampuan dan mengesampingkan kemampuan untuk peran tertentu dalam konteks tertentu';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Tanggal saat kapabilitas dibuat atau diubah.';
$string['privacy:metadata:role_cohortroles'] = 'Peran ke kohor';
$string['prohibit'] = 'Larang';
$string['prohibitedroles'] = 'Dilarang';
$string['question:add'] = 'Tambahkan soal baru';
$string['question:commentall'] = 'Komentari semua pertanyaan';
$string['question:commentmine'] = 'Komentari pertanyaan Anda sendiri';
$string['question:config'] = 'Atur tipe soal';
$string['question:editall'] = 'Edit semua soal';
$string['question:editmine'] = 'Edit soal sendiri';
$string['question:flag'] = 'Tandai soal ketika mencoba';
$string['question:managecategory'] = 'Edit kategori soal';
$string['question:moveall'] = 'Pindahkan semua soal';
$string['question:movemine'] = 'Pindahkan soal sendiri';
$string['question:tagall'] = 'Tag semua pertanyaan';
$string['question:tagmine'] = 'Tag pertanyaan sendiri';
$string['question:useall'] = 'Gunakan semua soal';
$string['question:usemine'] = 'Gunakan soal sendiri';
$string['question:viewall'] = 'Lihat semua soal';
$string['question:viewmine'] = 'Lihat soal sendiri';
$string['rating:rate'] = 'Tambahkan peringkat pada item';
$string['rating:view'] = 'Lihat total penilaian yang anda dapatkan';
$string['rating:viewall'] = 'Lihat semua penilaian mentah yang diberikan oleh individual';
$string['rating:viewany'] = 'Lihat total penilaian yang siapapun dapatkan';
$string['reportbuilder:edit'] = 'Edit laporan kustom Anda sendiri';
$string['reportbuilder:editall'] = 'Edit semua laporan kustom';
$string['reportbuilder:scheduleviewas'] = 'Jadwalkan laporan untuk dilihat sebagai pengguna lain';
$string['reportbuilder:view'] = 'Lihat laporan kustom';
$string['resetrole'] = 'Atur ulang';
$string['resettingrole'] = 'Reset peran \'{$a}\'';
$string['restore:configure'] = 'Atur opsi kembalikan';
$string['restore:createuser'] = 'Buat pengguna pada pengembalian';
$string['restore:restoreactivity'] = 'Pulihkan aktivitas';
$string['restore:restorecourse'] = 'Pulihkan kursus';
$string['restore:restoresection'] = 'Kembalikan seksi';
$string['restore:restoretargetimport'] = 'Kembalikan dari berkas yang ditargetkan sebagai impor';
$string['restore:rolldates'] = 'Izinkan untuk mengembalikan tanggal setelan aktivitas ketika pemulihan data';
$string['restore:uploadfile'] = 'Unggah berkas ke area cadangan';
$string['restore:userinfo'] = 'Kembalikan data pengguna';
$string['restore:viewautomatedfilearea'] = 'Pulihkan kursus dari cadangan otomatis';
$string['risks'] = 'Risiko';
$string['role:assign'] = 'Terapkan peran pada pengguna';
$string['role:manage'] = 'Buat dan kelola peran';
$string['role:override'] = 'Timpakan perizinan untuk yang lain';
$string['role:review'] = 'Tinjau ulang perizinan untuk yang lain';
$string['role:safeoverride'] = 'Timpa perizinan aman untuk yang lainnya';
$string['role:switchroles'] = 'Beralih ke peran lain';
$string['roleallowheader'] = 'Izinkan peran:';
$string['roleallowinfo'] = 'Pilih peran untuk ditambahkan ke daftar peran yang diizinkan pada konteks "{$a->context}", kemampuan "{$a->cap}":';
$string['roleassignments'] = 'Penetapan peran';
$string['roledefinitions'] = 'Pendefinisian peran';
$string['rolefullname'] = 'Nama peran';
$string['roleincontext'] = '{$a->role} pada {$a->context}';
$string['roleprohibitheader'] = 'Larang peran';
$string['roleprohibitinfo'] = 'Tambahkan peran untuk ditambahkan pada daftar peran yang dilarang pada konteks "{$a->context}", kemampuan "{$a->cap}":';
$string['rolerepreset'] = 'Gunakan preset peran';
$string['roleresetdefaults'] = 'Bawaan';
$string['roleresetrole'] = 'Gunakan peran atau pola dasar';
$string['rolerisks'] = 'Risiko peran';
$string['roles'] = 'Peran';
$string['roles_help'] = 'Peran adalah kumpulan dari perizinan yang didefinisikan untuk seluruh sistem yang dapat anda terapkan kepada pengguna tertentu pada konteks tertentu.';
$string['roles_link'] = 'Peranan';
$string['roleselect'] = 'Pilih peran';
$string['rolesforuser'] = 'Peran untuk pengguna {$a}';
$string['roleshortname'] = 'Nama singkat';
$string['roleshortname_help'] = 'Nama pendek peran adalah pengidentifikasi peran tingkat rendah di mana hanya karakter alfanumerik ASCII yang diizinkan.';
$string['roletoassign'] = 'Peran untuk diterapkan';
$string['roletooverride'] = 'Peran yang disampingkan';
$string['safeoverridenotice'] = 'Catatan: Kemampuan dengan risiko lebih tinggi dikunci karena Anda hanya diizinkan untuk mengesampingkan kemampuan aman.';
$string['search:query'] = 'Lakukan pencarian seluruh situs';
$string['selectanotheruser'] = 'Pilih pengguna lain';
$string['selectauser'] = 'Pilih pengguna';
$string['selectrole'] = 'Pilih peran';
$string['showallroles'] = 'Tunjukkan semua peran';
$string['showthisuserspermissions'] = 'Tunjukkan perizinan pengguna ini';
$string['site:accessallgroups'] = 'Akses semua grup';
$string['site:approvecourse'] = 'Izinkan pembuatan kursus';
$string['site:backup'] = 'Cadangkan kursus';
$string['site:config'] = 'Ganti setelan situs';
$string['site:configview'] = 'Lihat pohon administrasi situs (tetapi tidak semua halaman di dalamnya)';
$string['site:deleteanymessage'] = 'Hapus pesan apapun pada situs';
$string['site:deleteownmessage'] = 'Hapus pesan yang dikirimkan oleh dan kepada pengguna';
$string['site:doanything'] = 'Diizinkan untuk melakukan apapun';
$string['site:doclinks'] = 'Tunjukkan tautan pada dokumen diluar situs';
$string['site:forcelanguage'] = 'Timpa bahasa kursus';
$string['site:import'] = 'Impor kursus lain pada sebuah kursus';
$string['site:maintenanceaccess'] = 'Akses situs ketika moda perawatan';
$string['site:manageallmessaging'] = 'Tambah, hapus, blok dan un-blok kontak untuk beberapa pengguna';
$string['site:manageblocks'] = 'Atur blok pada halaman';
$string['site:managecontextlocks'] = 'Kelola pembekuan konteks';
$string['site:messageanyuser'] = 'Lewati preferensi privasi pengguna untuk mengirim pesan ke pengguna mana pun';
$string['site:mnetloginfromremote'] = 'Masuk dari aplikasi remot melalui Mnet';
$string['site:mnetlogintoremote'] = 'Roam ke aplikasi remot melalui Mnet';
$string['site:readallmessages'] = 'Baca semua pesan pada situs';
$string['site:restore'] = 'Pulihkan kursus';
$string['site:senderrormessage'] = 'Kirim pesan ke pengguna dukungan dari halaman kesalahan';
$string['site:sendmessage'] = 'Kirim pesan ke pengguna manapun';
$string['site:trustcontent'] = 'Percayakan konten yang dikirim';
$string['site:uploadusers'] = 'Unggah pengguna baru dari berkas';
$string['site:viewanonymousevents'] = 'Lihat acara anonim di laporan';
$string['site:viewfullnames'] = 'Selalu lihat nama lengkap pengguna';
$string['site:viewparticipants'] = 'Lihat peserta';
$string['site:viewreports'] = 'Lihat laporan';
$string['site:viewuseridentity'] = 'Lihat seluruh identitas pengguna dalam daftar';
$string['siteadministrators'] = 'Administrator situs';
$string['tag:edit'] = 'Edit tag yang ada';
$string['tag:editblocks'] = 'Sunting blok pada halaman tag';
$string['tag:flag'] = 'Tandai tag sebagai tidak pantas';
$string['tag:manage'] = 'Atur semua tag';
$string['thisnewrole'] = 'Peran baru ini';
$string['thisusersroles'] = 'Penetapan peran pengguna';
$string['unassignarole'] = 'Jangan lagi terapkan peran {$a}';
$string['unassignconfirm'] = 'Anda yakin untuk tidak lagi menerapkan peran "{$a->role}" dari pengguna "{$a->user}"?';
$string['unassignerror'] = 'Terjadi galat ketika tidak lagi menerapkan {$a->role} dari pengguna {$a->user}.';
$string['user:changeownpassword'] = 'Ubah kata kunci sendiri';
$string['user:create'] = 'Buat pengguna';
$string['user:delete'] = 'Hapus pengguna';
$string['user:editmessageprofile'] = 'Edit profil pesan pengguna';
$string['user:editownmessageprofile'] = 'Edit profil pesan pengguna sendiri';
$string['user:editownprofile'] = 'Edit profil pengguna sendiri';
$string['user:editprofile'] = 'Edit profil pengguna';
$string['user:ignoreuserquota'] = 'Abaikan batasan kuota pengguna';
$string['user:loginas'] = 'Masuk sebagai pengguna lain';
$string['user:manageblocks'] = 'Atur blok pada profil pengguna dari pengguna lain';
$string['user:manageownblocks'] = 'Atur blok pada profil pengguna publik sendiri';
$string['user:manageownfiles'] = 'Atur berkas pada area berkas pribadi sendiri';
$string['user:managesyspages'] = 'Atur tata letak halaman bawaan untuk profil pengguna publik';
$string['user:readuserblogs'] = 'Lihat semua blog pengguna';
$string['user:readuserposts'] = 'Lihat semua postingan forum pengguna';
$string['user:update'] = 'Perbarui profil pengguna';
$string['user:viewalldetails'] = 'Lihat seluruh informasi pengguna';
$string['user:viewdetails'] = 'Lihat profil pengguna';
$string['user:viewhiddendetails'] = 'Lihat detail pengguna yang disembunyikan';
$string['user:viewlastip'] = 'Lihat alamat Protokol Internet terakhir pengguna';
$string['user:viewuseractivitiesreport'] = 'Lihat laporan aktivitas pengguna';
$string['user:viewusergrades'] = 'Lihat nilai pengguna';
$string['usersfrom'] = 'Pengguna dari {$a}';
$string['usersfrommatching'] = 'Pengguna dari {$a->contextname} cocok dengan \'{$a->search}';
$string['usersinthisx'] = 'Pengguna pada {$a}';
$string['usersinthisxmatching'] = 'Pengguna pada {$a->contexttype} cocok dengan \'{$a->search}';
$string['userswithrole'] = 'Semua pengguna dengan peran';
$string['userswiththisrole'] = 'Pengguna dengan peran';
$string['useshowadvancedtochange'] = 'Gunakan \'Tunjukkan lanjutan\' untuk mengubah';
$string['viewingdefinitionofrolex'] = 'Melihat definisi peran \'{$a}';
$string['viewrole'] = 'LIhat detail peran';
$string['webservice:createmobiletoken'] = 'Buat  token layanan web untuk akses perangkat bergerak';
$string['webservice:createtoken'] = 'Buat token layanan web';
$string['webservice:managealltokens'] = 'Kelola seluruh token layanan web pengguna';
$string['whydoesuserhavecap'] = 'Mengapa {$a->fullname} memiliki kemampuan {$a->capability} pada konteks {$a->context}?';
$string['whydoesusernothavecap'] = 'Mengapa {$a->fullname} tidak memiliki kemampuan {$a->capability} pada konteks {$a->context}?';
$string['xroleassignments'] = 'Penetapan peran {$a}';
$string['xuserswiththerole'] = 'Pengguna dengan peran "{$a->role}"';
