<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certification', language 'it', version '4.1'.
 *
 * @package     tool_certification
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Azione';
$string['actions'] = 'Azioni';
$string['active'] = 'Attive';
$string['activecertifications'] = 'Certificazioni attive';
$string['afteractualcertcompletion'] = 'Dopo il completamento della certificazione attuale';
$string['afteractualcertcompletionwithrelativedate'] = '{$a} dopo il completamento della certificazione attuale';
$string['afterallocationdate'] = 'Dopo la data di assegnazione';
$string['afterallocationdatewithrelativedate'] = '{$a} dopo la data di assegnazione';
$string['aftercompletion'] = 'Dopo il completamento';
$string['aftercompletionwithrelativedate'] = '{$a} dopo il completamento';
$string['afterduedate'] = 'Dopo la data limite';
$string['afterduedatewithrelativedate'] = '{$a} dopo la data limite';
$string['afterlatest'] = 'Dopo l\'ultimo completamento o scadenza';
$string['afterlatestwithrelativedate'] = '{$a} dopo l\'ultimo completamento o scadenza';
$string['afterpreviouscertexpdate'] = 'Dopo la data di scadenza della certificazione precedente';
$string['afterpreviouscertexpdatewithrelativedate'] = '{$a dopo la data di scadenza della certificazione precedente';
$string['afterstartdate'] = 'Dopo la data di inizio';
$string['afterstartdatewithrelativedate'] = '{$a} dopo la data di inizio';
$string['allocatetocertification'] = 'Assegna';
$string['allocateusers'] = 'Assegna utenti';
$string['allocationdate'] = 'Data di assegnazione';
$string['allocationdateisonorafter'] = 'Data di assegnazione il o dopo il';
$string['allocationenddate'] = 'Data di fine assegnazione';
$string['allocationfor'] = 'Assegnazione di \'{$a}\'';
$string['allocationsource'] = 'Fonte dell\'assegnazione';
$string['allocationstartdate'] = 'Data di inizio dell\'assegnazione';
$string['allocationwindowenddate'] = 'Data di fine';
$string['allocationwindowenddate_help'] = 'Data di fine della finestra di assegnazione';
$string['allocationwindowendedon'] = 'La finestra di assegnazione di questa certificazione è finita il {$a}.';
$string['allocationwindowstartdate'] = 'Data di inizio';
$string['allocationwindowstartdate_help'] = 'Data di inizio della finestra di assegnazione';
$string['allocationwindowstartson'] = 'La finestra di assegnazione di questa certificazione inizia il {$a}.';
$string['archive'] = 'Archivio';
$string['archived'] = 'Archiviate';
$string['archivedcertifications'] = 'Certificazioni archiviate';
$string['archivedconfirmation'] = 'Sei sicuro di archiviare la certificazione  \'{$a}\'?  le certificazioni archiviate non saranno più disponibili ai manager e ai corsisti  e possono essere visualizzati solamente nel report storici.';
$string['archivedon'] = 'Archiviata il';
$string['autocreategroups'] = 'Aggiungi ai gruppi del corso';
$string['autocreategroups_help'] = 'E\' possibile assegnare automaticamente gli utenti allo stesso gruppo al momento dell\'iscrizione al corso. Se viene selezionato "per questa certificazione", sarà utilizzato un gruppo separato per questa certificazione, diverso da quelli di altre certificazioni.';
$string['autocreategroupsasinprogram'] = 'Come impostato nel programma';
$string['autocreategroupscertification'] = 'Crea gruppi per questa certificazione';
$string['basic'] = 'Essenziali';
$string['basicdetails'] = 'Dettagli essenziali';
$string['becamecertified'] = 'Diventa certificato ({$a})';
$string['beforepreviouscertexpdate'] = 'prima della precedente data di scadenza della certifiazione';
$string['calendarduedate'] = 'Data limite della certificazione {$a}';
$string['calendarexpirydate'] = 'Data di scadenza della certificazione {$a}';
$string['certification'] = 'Certificazione';
$string['certification:allocateuser'] = 'Assegnare utenti';
$string['certification:configurecustomfields'] = 'Configurazione campi personalizzati della certificazione';
$string['certification:edit'] = 'Modificare certificazione';
$string['certificationfullname'] = 'Nome della certificazione';
$string['certificationfullname_help'] = 'Nome della certificazione';
$string['certificationidnumber'] = 'Codice identificativo della certificazione';
$string['certificationidnumber_help'] = 'Il codice identificativo di una certificazione verrà utilizzato solamente per corrispondenza con dati di sistemi esterni e non sarà visualizzato all\'interno del  sito. E\' possibile utilizzare il codice identificativo ufficiale, in mancanza può essere lasciato vuoto.';
$string['certificationname'] = 'Nome della certificazione';
$string['certificationnamewitheditlink'] = 'Nome della certificazione con link di modifica';
$string['certificationnamewithlink'] = 'Nome della certificazione con link';
$string['certificationprogress'] = 'Avanzamento della certificazione';
$string['certificationprogressexport'] = 'Avanzamento certificazione {$a}';
$string['certificationrules'] = 'Regole della certificazione';
$string['certifications'] = 'Certificazioni';
$string['certificationscustomfield'] = 'Campi personalizzati della certificazione';
$string['certificationstatus'] = 'Stato della certificazione';
$string['certificationstatus_help'] = 'Stato della certificazione corrente';
$string['certificationtags'] = 'Tag della certificazione';
$string['certificationtags_help'] = 'Taq di questa certificazione';
$string['certificationtenant'] = 'Tenant della certificazione';
$string['certificationuserlog'] = '{$a} log delle attività';
$string['certificationuserlogempty'] = 'Non ci sono log di questa certificazione dell\'utente';
$string['certificationuserlogfilename'] = 'Log delle attività della {$a->certification} di {$a->user}';
$string['certified'] = 'Certificato';
$string['certifiedby'] = 'Certificato da';
$string['certifiedcertificationslink'] = '<a href="{$a->href}">Certificazioni verificate: {$a->count}</a>';
$string['certifieddate'] = 'Data di certificazione';
$string['certifieddateisonorafter'] = 'Data di certificazione il o dopo il';
$string['certifiednotification'] = 'Utente certificato correttamento';
$string['certifiedtype'] = 'Tipo di certificazione';
$string['certify'] = 'Certifica';
$string['certifyexpirydate'] = 'Data di scadenza';
$string['certifyexpirydate_help'] = 'Selezionare una data di scadenza della certificazione dell\'utente: \'Default\' (la configurazione corrente della certificazione=), \'Mai\' oppure una data personalizzata.';
$string['certifyuser'] = 'Verifica utente';
$string['completedtheprogram'] = 'Ha completato il programma {$a}';
$string['conditioncertificationcertified'] = 'Certificazione verificata';
$string['conditioncertificationcertifieddescription'] = 'Utenti certificati nella certificazione \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionall'] = 'Utenti certificati in tutte le seguenti certificazioni: \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionallwithdate'] = 'Utenti certificati in tutte le seguenti certificazioni: \'{$a->fullname}\'<br />
Data della certificazione il o dopo il \'{$a->conditiondate}\'';
$string['conditioncertificationcertifieddescriptionany'] = 'Utenti certificati in almeno una delle seguenti certificazioni: \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionanywithdate'] = 'Utenti certificati in almeno una delle seguenti certificazioni: \'{$a->fullname}\'<br />
Data della certificazione il o dopo il \'{$a->conditiondate}\'';
$string['conditioncertificationcertifieddescriptiononrecert'] = 'Esegui per ciascun rinnovo della certificazione';
$string['conditioncertificationcertifieddescriptionstatusonly'] = 'Esegui solo al cambiamento di stato';
$string['conditioncertificationcertifieddescriptionwithdate'] = 'Utenti certificati nella certificazione \'{$a->fullname}\'<br />
Data di certificazione il o dopo il \'{$a->conditiondate}\'';
$string['conditioncertificationcertifiedonrecert'] = 'Esegui sempre le azioni su tutti i rinnovi delle certificazioni';
$string['conditioncertificationcertifiedonrecert_help'] = 'Consente di cambiare la condizione in <b>"L\'utente è certificato e il periodo di rinnovo della certificazione non è aperto"</b>. Questo assicurerà che l\'utente venga contrassegnato come "senza corrispondenza" all\'apertura del rinnovo della certificazione e che le azioni vengano eseguite nuovamente su di lui al completamento del programma, anche se continua a essere certificato per tutto il tempo.';
$string['conditioncertificationcertifiedstatusonly'] = 'Esegui le azioni solo quando lo stato dell\'utente cambia da "non certificato" a "certificato"';
$string['conditioncertificationcertifiedstatusonly_help'] = 'In questo caso le azioni possono  essere eseguite o meno al rinnovo della certificazione, a seconda che la precedente certificazione sia scaduta o meno. Per assicurarsi che le azioni non vengano <b>mai</b> eseguite durante il rinnovo della certificazione, prendere in considerazione l\'impostazione del "Limite azioni della regola" nelle impostazioni della regola.';
$string['conditioncertificationexpired'] = 'Certificazione scaduta';
$string['conditioncertificationexpireddescription'] = 'Utenti che hanno la certificazione \'{$a}\' scaduta';
$string['conditioncertificationexpireddescriptionwithdate'] = 'Utenti che hanno lo stato Scaduta nella certificazione \'{$a->fullname}\'<br />
Data di scadenza il o dopo il \'{$a->conditiondate}\'';
$string['conditioncertificationnotcertified'] = 'Certificazione non verificata';
$string['conditioncertificationnotcertifieddescription'] = 'Utenti che non hanno ottenuto la certificazione \'{$a}\'';
$string['conditioncertificationoverdue'] = 'Certificazione in ritardo';
$string['conditioncertificationoverduedescription'] = 'Utenti che sono in ritardo con la certificazione \'{$a}\'';
$string['conditioncertificationoverduedescriptionwithdate'] = 'Utenti che hanno lo stato In ritardo nella certificazione \'{$a->fullname}\'<br />
Data limite il o dopo il \'{$a->conditiondate}\'';
$string['conditioncertificationsuspended'] = 'Certificazione sospesa';
$string['conditioncertificationsuspendeddescription'] = 'Utenti che sono sospesi nella certificazione \'{$a}\'';
$string['conditioncertificationsuspendeddescriptionwithdate'] = 'Utenti che hanno lo stato Sospesa nella certificazione \'{$a->fullname}\'<br />
Data di sospensione il o dopo il \'{$a->conditiondate}\'';
$string['conditionrecertificationgraceperiod'] = 'Fine del periodo di grazia del rinnovo della certificazione';
$string['conditionrecertificationgraceperiodendsdescription'] = 'Utenti che si trovano alla fine del periodo di grazia del rinnovo della certificazione \'{$a->fullname}\'';
$string['conditionrecertificationgraceperiodendsdescriptionwithdate'] = 'Utenti che si trovano alla fine del periodo di grazia del rinnovo della certificazione \'{$a->fullname}\'<br />
Fine del periodo di grazia del rinnovo della certificazione il o prima del \'{$a->conditiondate}\'';
$string['conditionrecertificationstarted'] = 'Inizio periodo di rinnovo della certifcazione';
$string['conditionrecertificationstarteddescription'] = 'Utenti che hanno iniziato il periodo di rinnovo della certificazione \'{$a->fullname}\'';
$string['conditionrecertificationstarteddescriptionwithdate'] = 'Utenti che hanno iniziato il periodo di rinnovo della certificazione \'{$a->fullname}\'<br />
Data di rinnovo della certificazione iniziata il o dopo il \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Utenti assegnati alla certificazione';
$string['conditionuserallocateddescription'] = 'Utenti assegnati alla certificazione \'{$a}\'';
$string['conditionuserallocateddescriptionwithdate'] = 'Utenti assegnati alla certificazione \'{$a->fullname}\'<br />
Data di assegnazione il o dopo il \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Utenti non assegnati alla certificazione';
$string['conditionusernotallocateddescription'] = 'Utenti non assegnati alla certificazione \'{$a}\'';
$string['confirmdeallocateusers'] = 'L\'azione eliminerà le assegnazioni degli utenti selezionati e tutti i dati associati. L\'azione non potrà essere annullata.';
$string['confirmdeallocateusersheader'] = 'Rimozione assegnazione utenti';
$string['confirmdeletecertification'] = 'Sei sicuro di eliminare la certificazione \'{$a}\' e tutti i dati associati? L\'azione non potrà essere annullata.';
$string['confirmdeleteuserallocation'] = 'Sei sicuro di rimuovere l\'assegnazione dell\'utente \'{$a}\' e tutti i dati associati? L\'azione non potrà essere annullata.';
$string['confirmduplicate'] = 'Sarà creata una copia della certificazione e sarà possibile cambiare il programma ed altre proprietà. Durante la copia non saranno effettuate assegnazioni di utenti.';
$string['content'] = 'Contenuto';
$string['criteriaall'] = 'Tutte le certificazioni selezionate sono state certificate';
$string['criteriaany'] = 'Almeno una delle certificazioni selezionate è stata certificata';
$string['criteriaany_help'] = 'Quando un utente è già stato certificato in una delle certificazioni, la certificazione nella seconda certificazione non attiverà nuovamente le azioni';
$string['criteriaeach'] = 'Ogni volta che un utente è certificato in una delle certificazioni selezionate';
$string['criteriaeach_help'] = 'Equivalente alla creazione di più regole, una per ciascuna delle certificazioni selezionate';
$string['currentprogram'] = 'Programma corrente';
$string['currentprogram_help'] = 'Questo è il programma che l\'utente sta svolgendo';
$string['currentprogramprogress'] = 'Avanzamento del programma corrente';
$string['currentprogramstatus'] = 'Stato del programma corrente';
$string['dateoverrided'] = 'Data di sovrascrittura';
$string['dayssinceallocation'] = 'Giorni trascorsi dall\'assegnazione';
$string['daystakingcertification'] = 'Giorni trascorsi nella certificazione';
$string['deallocateusers'] = 'Rimuovi assegnazione utenti';
$string['default'] = 'Default';
$string['deleteallocation'] = 'Elimina assegnazione';
$string['deleteuserallocation'] = 'Elimina assegnazione dell\'utente';
$string['displaycertificationdate'] = 'Data di certificazione';
$string['displaycertificationduedate'] = 'Data limite della certificazione';
$string['displaycertificationid'] = 'ID interna della certificazione utilizzata negli URL';
$string['displaycertificationname'] = 'Nome della certificazione';
$string['displaycertificationprogramname'] = 'Nome del programma iniziale della certificazione';
$string['displaycertificationreopen'] = 'Data di inizio del rinnovo della certificazione';
$string['displayexpirydate'] = 'Data di scadenza della certificazione';
$string['displayexpirydatetimestamp'] = 'Data e ora di scadenza della certificazione';
$string['displaygraceperiodend'] = 'Data di fine del periodo di grazia';
$string['displayrecertificationprogramname'] = 'Nome del programma di rinnovo della certificazione';
$string['dontchange'] = 'Non cambiare';
$string['duedate'] = 'Data limite';
$string['duedate_help'] = 'La data limite di svolgimento della certificazione';
$string['duedateisonorafter'] = 'Data limite il o dopo il';
$string['duplicate'] = 'Duplica';
$string['dynamic'] = 'Dinamica';
$string['dynamicrules'] = 'Regole dinamiche';
$string['dynamicrulesplugincheck'] = 'La visualizzazione dell\'elenco delle regole dinamiche non è possibile senza il plugin tool_dynamicrules';
$string['dynamicrulewarningdeallocation'] = 'Gli utenti possono vedersi rimossa l\'assegnazione se sono stati assegnati tramite un\'altra regola dinamica, le assegnazioni manuali non saranno impattate.';
$string['editallocation'] = 'Modifica assegnazione';
$string['editcertification'] = 'Modifica certificazione \'{$a}\'';
$string['editcertificationname'] = 'Modifica nome della certificazione';
$string['editcertificationsettings'] = 'Modifica impostazioni della certificazione';
$string['editcontent'] = 'Modifica contenuto';
$string['editdetails'] = 'Modifica dettagli';
$string['editstatusanddates'] = 'Modifica stato e date';
$string['editstatusanddatesbulk'] = 'Modifica stato e date per più utenti';
$string['enddate'] = 'Data di fine';
$string['entitycertification'] = 'Certificazione';
$string['entitycertificationusers'] = 'Assegnazioni degli utenti alle certificazioni e completamenti';
$string['errorallocatinguserintorelatedprogram'] = 'Non è possibile assegnare l\'utente nel relativo programma';
$string['errorallocationsourcenotfound'] = 'Non è stata trovata la fonte dell\'assegnazione';
$string['erroralreadycertified'] = 'Utenti già certificati con la certificazione con questa data di inizio';
$string['errorcannotallocate'] = 'Non è possibile assegnare utente alla certificazione (assegnazione già presente o non consentita)';
$string['errorcantdeletecertification'] = 'Non è possibile eliminare la certificazione';
$string['errorcantdeletenotarchivedcertification'] = 'Non è possibile eliminare una certificazione non archiviata';
$string['errorcantmanageusers'] = 'Non è possibile gestire utenti';
$string['errorcantrestorecertification'] = 'Non è possibile ripristinare la certificazione';
$string['errorcertificationsdontexist'] = 'Alcune certificazioni non esistono';
$string['errorcouldnotallocate'] = 'Non è stato possibile assegnare l\'utente \'{$a->originaluserfullname}\' alla certificazione \'{$a->certification}\'';
$string['errorevaluatinguserallocationstatus'] = 'Si è verificato un errore durante la valutazione dello stato dell\'assegnazione dell\'utente';
$string['errorexpirydatepreviousduedate'] = 'La data di scadenza non può essere antecedente alla data limite di svolgimento';
$string['erroridnumberuniquetenant'] = 'Il codice identificativo è già usato da un\'altra certificazione';
$string['errorinvalidcertification'] = 'Certificazione non valida';
$string['errorinvaliddate'] = 'Data non valida';
$string['errorinvalidpastexpirydate'] = 'La data di scadenza non può essere nel passato';
$string['errorinvalidpaststartdate'] = 'La data di inizio non può essere nel passato';
$string['errorinvalidtimecertified'] = 'La data di certificazione non può essere nel futuro';
$string['errormissingassociatedprogram'] = 'Manca il programma associato';
$string['errornopermissionallocateusers'] = 'Non si dispone dei privilegi necessari per assegnare utenti alle certificazioni';
$string['errornopermissioncertifyuser'] = 'L\'utente non può essere contrassegnato come certificato perché risulta già certificato oppure non sei autorizzato ad eseguire questa azione.';
$string['errornopermissionmanagecertifications'] = 'Non si dispone dei privilegi necessari per gestire le certificazioni';
$string['errornopermissionviewallocatedusers'] = 'Non si dispone dei privilegi necessari per visualizzare gli utenti assegnati alle certificazioni';
$string['errornopermissionviewreports'] = 'Non si dispone dei privilegi necessari per visualizzare i report';
$string['errornothingtoexportforcertifications'] = 'Non c\'è niente da esportare dalle certificazioni condivise: {$a}';
$string['errorrecertificationprogram'] = 'Il programma deve essere diverso dal programma iniziale';
$string['errorreporttypedoesnotexist'] = 'Tipo di report non esistente';
$string['errorsameidnumber'] = 'Una certificazione con lo stesso codice identificativo è già esistente';
$string['erroruseralreadyallocatedincertification'] = 'Utente già assegnato alla certificazione';
$string['erroruseralreadyallocatedinprogram'] = 'Utente già assegnato al programma';
$string['errorusernotinsametenant'] = 'Utente non appartiene allo stesso tenant';
$string['eventcertificationcompleted'] = 'Completamento certificazione';
$string['eventcertificationcreated'] = 'Creazione certificazione';
$string['eventcertificationdeleted'] = 'Eliminazione certificazione';
$string['eventcertificationupdated'] = 'Aggiornamento certificazione';
$string['eventrecertificationgraceperiodended'] = 'Fine periodo di grazia del rinnovo della certificazione';
$string['eventrecertificationstarted'] = 'Inizio rinnovo della certificazione';
$string['eventuserallocated'] = 'Assegnazione alla certificazione';
$string['eventuserdeallocated'] = 'Rimozione assegnazione alla certificazione';
$string['eventuserupdated'] = 'Aggiornamento assegnazione utente';
$string['expired'] = 'Scduta';
$string['expiredcertificationslink'] = '<a href="{$a->href}">Certificazioni scadute: {$a->count}</a>';
$string['expireddateisonorafter'] = 'Scaduta il o dopo il';
$string['expireson'] = 'scade il {$a}';
$string['expirydate'] = 'Data di scadenza';
$string['expirydate_help'] = 'Data di scadenza della certificazione';
$string['export_content'] = 'Impostazioni';
$string['export_content_help'] = 'Certificazioni, nomi, descrizioni, tag, ecc.';
$string['export_dynamic_rules'] = 'Regole dinamiche';
$string['export_dynamic_rules_help'] = 'Tutte le regole dinamiche contenute in queste certificazioni';
$string['export_programs'] = 'Programmi associati';
$string['export_programs_help'] = 'Programmi, nomi, descrizioni, date, tag, ecc.';
$string['export_user_allocations'] = 'Assegnazioni utenti alla certificazione';
$string['export_user_allocations_help'] = 'Include le assegnazioni degli utenti a queste certificazioni. Non saranno inclusi i dati degli utenti.';
$string['exportcertificationsdescription'] = 'Certificazioni con i relativi programmi, corsi, assegnazioni utenti e regole dinamiche';
$string['exportonlyallocationspostfix'] = '(solo assegnazioni utente)';
$string['fullcertificationreport'] = 'Report completo della certificazione';
$string['futureallocation'] = 'Assegnazioni future';
$string['gotocertification'] = 'Vai alla certificazione';
$string['idnumber'] = 'Codice identificativo';
$string['import_content'] = 'Imposatzioni';
$string['import_content_help'] = 'Certificazioni, nomi, descrizioni, date, tag, ecc.';
$string['import_dynamic_rules'] = 'Regole dinamiche';
$string['import_dynamic_rules_help'] = 'Tutte le configurazioni di regole dinamiche di questi programmi';
$string['import_programs'] = 'Programmi associati';
$string['import_programs_help'] = 'Programmi, nomi, descrizioni, date, tag, ecc.';
$string['import_user_allocations'] = 'Assegnazioni utenti alla certificazione';
$string['import_user_allocations_help'] = 'Include le assegnazioni utenti a queste certificazioni';
$string['importcannotallocate'] = 'Non è possibile assegnare l\'utente \'{$a->originaluserfullname}\'  alla certificazione \'{$a->certification}\', assegnazione già esistente o non consentita';
$string['importlogfailed'] = 'Non è stato possibile importare la certificazione \'{$a->fullname}\'';
$string['importlogidnumberexists'] = 'Una certificazione con il codice identificativo \'{$a->originalidnumber}\' esiste già';
$string['importlogsuccess'] = 'Creata certificazione \'<a href="{$a->url}">{$a->fullname}</a>\'';
$string['importlogsuccessuserallocations'] = 'Assegnato l\'utente \'{$a->userfullname}\' alla certificazione \'{$a->certification}\'';
$string['include_shared_entities'] = 'Includi elementi condivisi';
$string['include_shared_entities_help'] = 'Abilitando questa impostazione, il file esportato conterrà:

* tutte le certificazioni condivise disponibili nel tenant corrente
* tutti i programmi associati alla certificazioni selezionate
* tutti i corsi dei programmi al di fuori della categoria di corsi del tannt corrente';
$string['isrecertification'] = 'È rinnovo della certificazione';
$string['keepcertificationdefaults'] = 'Mantieni i default della certificazione';
$string['lastallocationdate'] = 'Ultima data di assegnazione: {$a}';
$string['lessthanaday'] = 'Meno di un giorno';
$string['managedusersoverdue'] = 'Alcuni membri del team hanno certificazioni in ritardo.';
$string['manageprograms'] = 'Gestione programmi';
$string['manual'] = 'Manuale';
$string['manuallycertifieduser'] = 'Certificato  manualmente {$a->usertarget} ({$a->expirydate})';
$string['mappingerrorcertificationnotfound'] = 'La certificazione {$a} non è stata trovata';
$string['mappingnoticenoidnumber'] = 'La certificazione è stata individuata tramite il nome poiché il codice identificativo non è stato impostato. Si raccomanda di assegnare i codici identificativi alle certificazioni.';
$string['markcertificationcompletednotice'] = 'Spunta la certificazione come completata senza attendere il completamento del programma';
$string['messageprovider:certificationcompleted'] = 'Certificazione completata';
$string['messageprovider:certificationuserallocated'] = 'Assegnazione utente alla certificazione';
$string['messageprovider:certificationuserdeallocated'] = 'Rimozione assegnazione utente alla certificazione';
$string['missingcertification'] = 'Certificazione mancante';
$string['missingfullname'] = 'Nome mancante';
$string['missingprogram'] = 'Programma mancante';
$string['never'] = 'Mai';
$string['neverexpires'] = 'Non scade mai';
$string['newcertification'] = 'Nuova certificazione';
$string['newvaluefor'] = 'Nuovo valore di';
$string['notavailable'] = 'Non disponibile';
$string['notificationcertification'] = 'Questo programma è parte della certificazione \'{$a->certificationname}\'.<br /><br />';
$string['notificationcertificationcompletedexpiry'] = 'Dopo il {$a->reopendate} sarà possibile rifare il programma {$a->recertificationprogram}\'  per mantenere valida la certificazione.<br /><br />';
$string['notificationcertificationcompletedmanual'] = 'Gentile {$a->userfullname},<br /><br />
Congratulazioni per l\'ottenimento della certificazione \'{$a->certificationname}\'!<br /><br />
{$a->expirymessage}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationcompletedprogram'] = 'Gentile {$a->userfullname},<br /><br />
Congratulazioni per aver completato il programma \'{$a->programname}\'. Sei ora certificato in \'{$a->certificationname}\'!<br /><br />
E\' possibile visitare nuovamente i corsi del programma in qualsiasi momento. L\'intero programma è pagina \'La mia formazione\'.<br /><br />
{$a->expirymessage}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationdue'] = 'Questo programma è parte della certificazione \'{$a->certificationname}\', da svolgere entro {$a->duedate}.<br /><br />';
$string['notificationcertificationuserallocated'] = 'Gentile {$a->userfullname},<br /><br />
Benvenuto nel programma \'{$a->programname}\', disponibile nella pagina \'La mia formzione\'.<br /><br />
{$a->certmsg}<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationuserdeallocated'] = 'Gentile {$a->userfullname},<br /><br />
Il programma \'{$a->programname}\' è ora chiuso e non può più essere acceduto.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationwillexpireon'] = 'La tua certificazione scadrà il {$a}.<br /><br />';
$string['notificationsubjectcertificationcompleted'] = 'Certificazione \'{$a}\' completata';
$string['notificationsubjectcertificationcompletedmanual'] = 'Congratulazioni -  \'{$a}\' certificazione!';
$string['notificationsubjectcertificationuserallocated'] = 'Benvenuto in \'{$a}\'';
$string['notificationsubjectcertificationuserdeallocated'] = '\'{$a}\' chiusa';
$string['notset'] = 'Non impostato';
$string['nousersselected'] = 'Per favore selezionare almeno un utente';
$string['ongoingcertificationslink'] = '<a href="{$a->href}">Certificazioni in svolgimento: {$a->count}</a>';
$string['open'] = 'Aperta';
$string['outcomeallocation'] = 'Assegna utenti alla certificazione';
$string['outcomeallocationdescdate'] = 'Assegna utenti alla certificazione {$a->certificationname}<br />
{$a->startdatestr}<br />
Con gli utenti sospesi: {$a->suspendedusers}';
$string['outcomeallocationdesckeepdate'] = 'Rimuovi sospensione e mantieni la data esistente di inizio certificazione';
$string['outcomeallocationdesckeepstartdate'] = 'Mantieni la data di inizio di default della certificazione';
$string['outcomeallocationdescription'] = 'Assegna utenti alla certificazione {$a}<br />
Mantieni la data di inizio di default della certificazione';
$string['outcomeallocationdescriptionwithdate'] = 'Assegna utenti alla certificazione {$a->certificationname}<br />
Data di inizio della certificazione: \'{$a->startdate}\'';
$string['outcomeallocationdescstartdate'] = 'Data di inizio della certificazione: \'{$a->startdate}\'';
$string['outcomeallocationdescsuspendchangedate'] = 'Rimuovi sospensione e modifica la data di inizio della certificazione';
$string['outcomeallocationdontmodify'] = 'Non modificare le assegnazioni';
$string['outcomeallocationsuspendedusers'] = 'Con gli utenti sospesi';
$string['outcomeallocationsuspendedusers_help'] = 'Azione da svolgere quando gli utenti sono già assegnati ma la loro assegnazione è sospesa o terminata.';
$string['outcomeallocationunsuspend'] = 'Rimuovi sospensione, mantieni la data esistente di inizio certificazione';
$string['outcomeallocationunsuspendchangedate'] = 'Rimuovi sospensione, modifica la data di inizio certificazione';
$string['outcomedeallocate'] = 'Rimuovi gli utenti dalla certificazione';
$string['outcomedeallocatesuspend'] = 'Sospendi le assegnazioni esistenti';
$string['outcomedeallocation'] = 'Rimuovi assegnazioni utenti dalle certificazioni';
$string['outcomedeallocationdescription'] = 'Rimuovi assegnazioni utenti dalla certificazione {$a}';
$string['outcomedeallocationdescriptionsuspend'] = 'Sospendi le assegnazioni esistenti degli utenti dalla certificazione \'{$a}\'';
$string['overdue'] = 'In ritardo';
$string['overduecertificationslink'] = '<a href="{$a->href}">Certificazioni In ritardo: {$a->count}</a>';
$string['pluginname'] = 'Certificazioni';
$string['previewcertificationname'] = 'Anteprima nome della certificazione';
$string['previouscertexpirydate'] = 'Data precedente di scadenza della certificazione';
$string['privacy:metadata:certification_completions'] = 'Informazioni sul completamento della certificazione.';
$string['privacy:metadata:certification_completions:certificationid'] = 'Certificazioni completate dall\'utente.';
$string['privacy:metadata:certification_completions:certifiedby'] = 'Utente che ha generato la certificazione.';
$string['privacy:metadata:certification_completions:expirydate'] = 'Data di scadenza del completamento della certificazione.';
$string['privacy:metadata:certification_completions:revokedby'] = 'Utente che ha revocato la certificazione';
$string['privacy:metadata:certification_completions:timecertified'] = 'Orario in cui l\'utente ha completato la certificazione.';
$string['privacy:metadata:certification_completions:timecreated'] = 'Orario in cui è stato creato il record di completamento.';
$string['privacy:metadata:certification_completions:timemodified'] = 'Orario di modifica del completamento della certificazione.';
$string['privacy:metadata:certification_completions:userid'] = 'Utente che ha completato la certificazione.';
$string['privacy:metadata:certification_users'] = 'Informazioni sull\'assegnazione della certificazione all\'utente.';
$string['privacy:metadata:certification_users:certificationid'] = 'Certificazione assegnata a.';
$string['privacy:metadata:certification_users:currentprogramid'] = 'Programma corrente assegnato all\'utente';
$string['privacy:metadata:certification_users:isrecertification'] = 'Indicazione di utente in fase di rinnovo della certificazione';
$string['privacy:metadata:certification_users:status'] = 'Indicazione di utente sospeso dalla certificazione.';
$string['privacy:metadata:certification_users:timemodified'] = 'Orario di modifica della assegnazione dell\'utente';
$string['privacy:metadata:certification_users:userid'] = 'Utente assegnato';
$string['privacy:metadata:core_tag'] = 'Tag aggiunti alla certificazione';
$string['program'] = 'Programma';
$string['programchangewarning'] = 'Gli utenti che stanno svolgendo questo programma non saranno riassegnati automaticamente. La riassegnazione può essere fatta manualmente utente per utente. Lo stato degli utenti che hanno completato il programma o gli utenti che sono stati spuntati manualmente come certificati, rimarrà inalterato ma gli utenti saranno rimossi dal vecchio programma e non lo visualizzeranno più nella loro pagina con l\'elenco dei corsi.';
$string['programcourse'] = 'Corso del programma';
$string['programuserallocation'] = 'Assegnazioni utente al programma';
$string['progress'] = '{$a} completati';
$string['progressreport'] = 'Report dell\'avanzamento';
$string['recertdifferentprogram'] = 'Seleziona un programma differente';
$string['recertdifferentprogram_help'] = 'Selezionare \'Si\' se si desidera selezionare un programma differente per il rinnovo della certificazione rispetto al programma di certificazione iniziale.';
$string['recertduedaterelative'] = 'Data limite';
$string['recertduedaterelative_help'] = 'La data limite di svolgimento della certificazione';
$string['recertexpirydate'] = 'Data di scadenza';
$string['recertexpirydate_help'] = 'La data nella quale scadrà il rinnovo della certificazione dell\'utente';
$string['recertexpirydatewarning'] = 'La certificazione iniziale è impostata per non scadere mai, il rinnovo della certificazione sarà possibile solo per quegli utenti per i quali la data di scadenza è stata impostata manualmente.';
$string['recertgraceperiod'] = 'Periodo di grazia';
$string['recertgraceperiod_help'] = 'Il periodo di grazia è un intervallo di tempo aggiuntivo concesso all\'utente per completare il programma e certificarsi dopo la scadenza della certificazione precedente. L\'impostazione è disponibile solo se il programma di rinnovo della certificazione è diverso dal programma iniziale.';
$string['recertgraceperiodends'] = 'Fine del periodo di grazia';
$string['recertification'] = 'Rinnovo della certificazione';
$string['recertificationgraceperiodendsonorbefore'] = 'La fine del periodo di grazia del rinnovo della certificazione è il o dopo il';
$string['recertificationprogram'] = 'Programma di rinnovo della certificazione';
$string['recertificationprogram_help'] = 'Seleziona un programma da utilizzare per il rinnovo della certificazione. Questo programma deve essere differente dal programma iniziale di certificazione.';
$string['recertificationstartdate'] = 'Data di rinnovo della certificazione';
$string['recertificationstartedonorafter'] = 'Rinnovo della certificazione iniziata il o dopo il';
$string['recertstartdaterelative'] = 'Data di inizio';
$string['recertstartdaterelative_help'] = 'La data nella quale il programma di rinnovo della certificazione sarà reso disponile all\'utente.';
$string['recertstartdatewarning'] = 'In questa data sarà resettato il programma di rinnovo della certificazione. Accertarsi che gli utenti non siano iscritti nei corsi del programma, assegnati direttamente allo stesso programma o assegnati tramite altre certificazioni poiché possono perdere il loro stato di avanzamento.';
$string['reg_wpcertifications'] = 'Numero di certificazioni ({$a})';
$string['reportactivecerts'] = 'Report di sistema delle certificazioni attive';
$string['reportarchivedcerts'] = 'Report di sistema delle certificazioni archiviate';
$string['reportcertificationprogress'] = 'Report di sistema dell\'avanzamento delle certificazioni';
$string['reportcertsusers'] = 'Report di sistema degli utenti delle certificazioni';
$string['reportusercerts'] = 'Report di sistema dell\'elenco delle certificazioni degli utenti';
$string['requirerecertification'] = 'Richiedi rinnovo della certificazione';
$string['requirerecertification_help'] = 'Selezionare \'Si\' per abilitare il rinnovo della certificazione.';
$string['resetadditionalcourses'] = 'Resetta corsi aggiuntivi';
$string['resetadditionalcourses_help'] = 'Resetta i corsi che fanno parte del nuovo programma ma che non facevano parte del programma precedente';
$string['restore'] = 'Ripristina';
$string['revokecertification'] = 'Revoca certificazione';
$string['revoked'] = 'Revocata';
$string['revokedby'] = 'Revocata da';
$string['revokednotification'] = 'Certificazione revocata correttaemnte';
$string['revokedon'] = 'Revocata il';
$string['revokedthisuser'] = 'Certificazione di {$a} revocata';
$string['revokewarning'] = 'Sei sicuro di revocare la certificazione di \'{$a}\'?  le certificazioni ottenute tramite il completamento non saranno revocate.';
$string['rolemanager'] = 'Manager delle certificazioni';
$string['rolemanagerdescription'] = 'Crea e gestisce le certificazioni nel proprio tenant ed assegna gli  utenti';
$string['schedule'] = 'Date di certificazione';
$string['selectactiveandarchivedcertifications'] = 'Seleziona certificazioni attive e archiviate';
$string['selectadifferentprogram'] = 'Seleziona un programma differente';
$string['selectallactivecertifications'] = 'Seleziona tutte le certificazioni attive';
$string['selectallcertificationsinthisfile'] = 'Seleziona tutte le certificazioni in questo file';
$string['selectatleastonecertification'] = 'Seleziona almeno una certificazione';
$string['selectcertificationcondition'] = 'Certificazione';
$string['selectcertificationcondition_help'] = 'Seleziona la certificazione che soddisfa questa condizione';
$string['selectcertificationoutcome'] = 'Certificazione';
$string['selectcertificationoutcome_help'] = 'Seleziona la certificazione dove sarà applicata questa azione';
$string['selectcertificationstoallocate'] = 'Certificazioni';
$string['selectcertificationstoallocate_help'] = 'Seleziona la certificazione dove saranno assegnati gli  utenti';
$string['selectdate'] = 'Seleziona data';
$string['selectmanually'] = 'Seleziona manualmente...';
$string['selectprogram'] = 'Seleziona programma';
$string['selectprogram_help'] = 'Selezionare un programma da associare a questa certificazione';
$string['separatetenantsingroupswarning'] = 'Nei corsi condivisi tra tenant, gli utenti di ciascun tenant saranno aggiunti in gruppi separati.';
$string['startdate'] = 'Data di inizio';
$string['startdate_help'] = 'La data di  inizio della certificazione';
$string['status'] = 'Stato';
$string['suspended'] = 'Sospesa';
$string['suspendeddateisonorafter'] = 'Data di sospensione il o dopo il';
$string['system'] = 'Sistema';
$string['tagarea_tool_certification'] = 'Certificazioni';
$string['tags'] = 'Tag';
$string['timecreated'] = 'Creata il';
$string['timemodified'] = 'Modificata il';
$string['timesuspended'] = 'Sospesa il';
$string['toomanycertificationstoshow'] = 'Troppe certificazioni da visualizzare';
$string['uponcompletion'] = 'Al completamento';
$string['userallocation'] = 'Assegnazione utente';
$string['usercompletion'] = 'Completamento utente';
$string['userduedate'] = 'Data limite';
$string['userduedate_help'] = 'Seleziona la data limite di certificazione dell\'utente';
$string['usergotsuspended'] = 'Utente sospeso';
$string['userlist'] = 'Seleziona utenti';
$string['userlist_help'] = 'Selezionare utenti da assegnare a questa certificazione';
$string['users'] = 'Utenti';
$string['usersallocationnotavailable'] = 'Assegnazione utenti non disponibile';
$string['usersdeallocatedsuccess'] = 'Utenti rimossi correttamente dall\'assegnazione: {$a}';
$string['userseditedsuccess'] = 'Utenti modificati correttamente: {$a}';
$string['usersskipped'] = 'Utenti saltati poiché l\'opzione non è a loro disponibile: {$a}';
$string['userstartdate'] = 'Data di inizio';
$string['userstartdate_help'] = 'Selezionare la data nella quale l\'utente potrà cominciare la certificazione. La data avrà effetto solo su questo utente.';
$string['userstatus'] = 'Stato';
$string['userstatus_help'] = 'Lo stato di Sospesa nasconderà la certificazione alla vista degli  utenti, mentre lo stato di default la visualizzerà.';
$string['viewcertificationuserlog'] = 'Log attività della certificazione';
