<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'calendar', language 'ja', version '4.2'.
 *
 * @package     calendar
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityevent'] = '活動イベント';
$string['addevent'] = 'イベントを追加する';
$string['advancedoptions'] = '高度なオプション';
$string['allday'] = '終日';
$string['annually'] = '毎年';
$string['calendar'] = 'カレンダー';
$string['calendarexporturl'] = 'カレンダーURL';
$string['calendarheading'] = '{$a} カレンダー';
$string['calendarpreferences'] = 'カレンダープレファレンス';
$string['calendartypes'] = 'カレンダータイプ';
$string['calendarurl'] = 'カレンダーURL: {$a}';
$string['calendarurlcopiedtoclipboard'] = 'カレンダーURLクリップボードにコピーされました。';
$string['category'] = 'カテゴリ';
$string['categoryevent'] = 'カテゴリイベント';
$string['categoryevents'] = 'カテゴリイベント';
$string['clickhide'] = 'クリックして非表示にする';
$string['clickshow'] = 'クリックして表示する';
$string['colactions'] = '操作';
$string['colcalendar'] = 'カレンダー';
$string['collastupdated'] = '最終更新日時';
$string['colpoll'] = '更新間隔';
$string['commontasks'] = 'オプション';
$string['confirmeventdelete'] = '本当にこのイベント「 {$a} 」を削除してもよろしいですか?';
$string['confirmeventseriesdelete'] = '「 {$a->name} 」イベントはシリーズの一部です。このイベントのみ削除しますか、それともシリーズ内 {$a->count} イベントすべてを削除しますか?';
$string['confirmsubscriptiondelete'] = '本当に「 {$a} 」カレンダー購読を削除してもよろしいですか?';
$string['copycalendarurl'] = 'カレンダーURLをコピーする';
$string['copyurl'] = 'URLをコピーする';
$string['course'] = 'コース';
$string['coursecalendar'] = '{$a} カレンダー';
$string['courseevent'] = 'コースイベント';
$string['courseevents'] = 'コースイベント';
$string['courses'] = 'コース';
$string['customexport'] = 'カスタム範囲 ({$a->timestart} - {$a->timeend})';
$string['daily'] = '毎日';
$string['day'] = '日';
$string['dayeventsmany'] = '{$a->num} イベント {$a->day}';
$string['dayeventsnone'] = 'イベントなし {$a}';
$string['dayeventsone'] = '1 イベント {$a}';
$string['daynext'] = '翌日';
$string['dayprev'] = '前日';
$string['dayviewfor'] = '日表示:';
$string['dayviewtitle'] = '日表示: {$a}';
$string['daywithnoevents'] = 'この日にイベントはありません。';
$string['default'] = 'デフォルト';
$string['deleteallevents'] = 'すべてのイベントを削除する';
$string['deleteevent'] = 'イベントを削除する';
$string['deleteevents'] = 'イベントを削除する';
$string['deleteoneevent'] = 'このイベントを削除する';
$string['detailedmonthviewfor'] = '詳細月表示:';
$string['detailedmonthviewtitle'] = '詳細月表示: {$a}';
$string['durationminutes'] = '期間 (分)';
$string['durationnone'] = '期間なし';
$string['durationuntil'] = '終了日時:';
$string['editevent'] = 'イベントの編集';
$string['erroraddingevent'] = 'イベントの追加に失敗しました。';
$string['errorbadsubscription'] = 'カレンダー購読が見つかりませんでした。';
$string['errorbeforecoursestart'] = 'コース開始日前にイベントを設定できません';
$string['errorcannotimport'] = 'あなたは現時点ではカレンダー購読を設定できません。';
$string['errorhasuntilandcount'] = '「UNTIL」または「COUNT」は反復ルールに出現できますが「UNTIL」および「COUNT」は同じ反復ルールに存在できません。';
$string['errorinvalidbydayprefix'] = 'BYDAYルールの前の整数値は「MONTHLY」または「YEARLY」ルールにのみ渡せます。';
$string['errorinvalidbydaysuffix'] = 'BYDAYルールの曜日部分に有効な値は「MO」「TU」「WE」「TH」「FR」「SA」「SU」です。';
$string['errorinvalidbyhour'] = 'BYHOURルールの有効な値は0～23です。';
$string['errorinvalidbyminute'] = 'BYMINUTEルールの有効な値は0～59です。';
$string['errorinvalidbymonth'] = 'BYMONTHルールの有効な値は1～12です。';
$string['errorinvalidbymonthday'] = 'BYMONTHDAYルールの有効な値は1～31または-31～-1です。';
$string['errorinvalidbysecond'] = 'BYSECONDルールの有効な値は0～59です。';
$string['errorinvalidbysetpos'] = 'BYSETPOSルールの有効な値は1～366または-366～-1です。';
$string['errorinvalidbyweekno'] = 'BYWEEKNOルールの有効な値は1～53または-53～-1です。';
$string['errorinvalidbyyearday'] = 'BYYEARDAYルールの有効な値は1～366または-366～-1です。';
$string['errorinvaliddate'] = '日付が正しくありません';
$string['errorinvalidicalurl'] = 'iCal URLが有効ではありません。';
$string['errorinvalidinterval'] = 'INTERVALルールの値は正の整数にする必要があります。';
$string['errorinvalidminutes'] = '期間 (分) を1から999の間で指定してください。';
$string['errorinvalidrepeats'] = 'イベント数を1から99の間で指定してください。';
$string['errormustbeusedwithotherbyrule'] = 'BYSETPOSルールは別のBYxxxルールの一部としてのみ使用する必要があります。';
$string['errornodescription'] = '説明を入力してください';
$string['errornoeventname'] = '名称を入力してください';
$string['errornonyearlyfreqwithbyweekno'] = 'BYWEEKNOルールはYEARLYルールに対してのみ有効です。';
$string['errorrequiredurlorfile'] = 'カレンダーのインポートに必要なURLまたはファイルです。';
$string['errorrrule'] = '通過した繰り返しルールが正しくないようです。';
$string['errorrruleday'] = '繰り返しルールに無効な日付パラメータがあります。';
$string['errorrrulefreq'] = '繰り返しルールに無効な頻度パラメータがあります。';
$string['eventcalendareventcreated'] = 'カレンダーイベントが作成されました。';
$string['eventcalendareventdeleted'] = 'カレンダーイベントが削除されました。';
$string['eventcalendareventupdated'] = 'カレンダーイベントが更新されました。';
$string['eventdate'] = '日付';
$string['eventdescription'] = '説明';
$string['eventduration'] = '期間';
$string['eventendtime'] = '終了日時';
$string['eventendtimewrapped'] = '{$a} (終了時間)';
$string['eventinstanttime'] = '時間';
$string['eventkind'] = 'イベントタイプ';
$string['eventname'] = 'イベントタイトル';
$string['eventnameandcategory'] = '{$a->category}: {$a->name}';
$string['eventnameandcourse'] = '{$a->course}: {$a->name}';
$string['eventnamelocation'] = '{$a->name} ロケーション: {$a->location}';
$string['eventnone'] = 'イベントなし';
$string['eventrepeat'] = '繰り返し';
$string['events'] = 'イベントです。';
$string['eventsall'] = 'すべてのイベント';
$string['eventsdeleted'] = '{$a} イベントが削除されました。';
$string['eventsfor'] = '{$a} イベント';
$string['eventsimported'] = '{$a} イベントがインポートされました。';
$string['eventskey'] = 'イベントキー';
$string['eventsource'] = 'イベントソース';
$string['eventspersonal'] = 'マイパーソナルイベント';
$string['eventsrelatedtocategories'] = 'カテゴリ関連イベント';
$string['eventsrelatedtocourses'] = 'コースに関連したイベント';
$string['eventsrelatedtogroups'] = 'グループ関連イベント';
$string['eventsskipped'] = '{$a} イベントがスキップされました。';
$string['eventstarttime'] = '開始日時';
$string['eventstoexport'] = 'エクスポートするイベント';
$string['eventsubscriptioncreated'] = 'カレンダー購読が作成されました。';
$string['eventsubscriptiondeleted'] = 'カレンダー購読が削除されました。';
$string['eventsubscriptioneditwarning'] = 'このカレンダーイベントは購読の一部です。購読が削除された場合、あなたのこのイベントに対する変更を喪失します。';
$string['eventsubscriptionupdated'] = 'カレンダー購読が更新されました。';
$string['eventsupdated'] = '{$a} イベントが更新されました。';
$string['eventtime'] = '時間';
$string['eventtype'] = 'イベントタイプ';
$string['eventtypecategory'] = 'カテゴリ';
$string['eventtypecourse'] = 'コース';
$string['eventtypegroup'] = 'グループ';
$string['eventtypemodule'] = 'モジュール';
$string['eventtypeother'] = 'その他';
$string['eventtypesite'] = 'サイト';
$string['eventtypeuser'] = 'ユーザ';
$string['eventview'] = 'イベント詳細';
$string['expired'] = '期間終了';
$string['explain_site_timeformat'] = 'あなたは12または24時間表示をサイトの時間表示方法として選択できます。「デフォルト」を選択した場合、あなたの使用言語に合わせてフォーマットが自動的に選択されます。この設定はユーザプレファレンスでオーバーライドできます。';
$string['export'] = 'エクスポート';
$string['exportbutton'] = 'エクスポート';
$string['exportcalendar'] = 'カレンダーをエクスポートする';
$string['exporthelp'] = '<p>カレンダーのURLは他のカレンダーにイベントをインポートするための動的なリンクを提供します。ソースカレンダーの新規作成、変更および削除されたイベントは他のカレンダーにも<strong>反映されます</strong>。</p>
<p>あなたはカレンダーのエクスポートでイベントのバックアップコピーを作成して他のカレンダーにインポートできます。ソースカレンダーでの更新は他のカレンダーには<strong>反映されません</strong>。</p>';
$string['forcecalendartype'] = 'カレンダーを強制する';
$string['fri'] = '金';
$string['friday'] = '金曜日';
$string['fullcalendar'] = 'フルカレンダー';
$string['generateurlbutton'] = 'カレンダーURLを取得する';
$string['gotoactivity'] = '活動に移動する';
$string['gotocalendar'] = 'カレンダーに移動する';
$string['group'] = 'グループ';
$string['groupevent'] = 'グループイベント';
$string['groupevents'] = 'グループイベント';
$string['hideeventtype'] = '{$a} イベントを隠す';
$string['hourly'] = '毎時';
$string['importcalendar'] = 'カレンダーをインポートする';
$string['importcalendarexternal'] = '外部カレンダーをインポートしますか?';
$string['importcalendarfrom'] = 'インポート先';
$string['importcalendarheading'] = 'カレンダーをインポートする ...';
$string['importfromfile'] = 'カレンダーファイル (.ics)';
$string['importfrominstructions'] = 'リモートカレンダーのURLを提供するか、ファイルをアップロードしてください。';
$string['importfromurl'] = 'カレンダーURL';
$string['invalideventtype'] = 'あなたが選択したイベントタイプは有効ではありません。';
$string['invalidtimedurationminutes'] = 'あなたが入力した期間 (分) は有効ではありません。ゼロよりも大きな期間を分で入力するか、空白にしてください。';
$string['invalidtimedurationuntil'] = 'あなたはイベント開始日時より前の終了日時を選択しました。処理を続行する前に訂正してください。';
$string['iwanttoexport'] = 'エクスポート';
$string['less'] = '減らす';
$string['managesubscriptions'] = 'カレンダをインポートまたはエクスポートする';
$string['manyevents'] = '{$a} イベント';
$string['mon'] = '月';
$string['monday'] = '月曜日';
$string['monthly'] = '毎月';
$string['monthlyview'] = '月表示';
$string['monthnext'] = '来月';
$string['monthprev'] = '前月';
$string['monththis'] = '今月';
$string['more'] = '増やす';
$string['moreevents'] = 'さらに {$a} 件';
$string['namewithsource'] = '{$a->name} ({$a->source})';
$string['never'] = 'なし';
$string['newevent'] = '新しいイベント';
$string['newmonthannouncement'] = 'カレンダーが {$a} に設定されました。';
$string['nocalendarsubscriptions'] = 'まだカレンダー購読はありません。{$a} しますか?';
$string['notitle'] = 'タイトルなし';
$string['noupcomingevents'] = '直近のイベントはありません。';
$string['oneevent'] = '1 イベント';
$string['pollinterval'] = '更新間隔';
$string['pollinterval_help'] = 'あなたが新しいイベントに関してカレンダーを更新したい間隔です。';
$string['pref_lookahead'] = '直近イベントの日数範囲';
$string['pref_lookahead_help'] = 'この設定では直近イベントとしてイベントを表示するための将来的な日数の範囲を指定します。この日数を超えるイベントは直近イベントとして表示されることはありません。この日数範囲内のすべてのイベントが表示されるという<strong>保証はありません</strong>。多くの直近イベント (「直近イベントの最大表示件数」プレファレンス以上) が登録されている場合、最も時間の離れたイベントは表示されません。';
$string['pref_maxevents'] = '直近イベントの最大表示件数';
$string['pref_maxevents_help'] = 'この設定では表示できる直近イベントの最大数を設定します。あなたがここで大きな値を設定した場合、直近イベントの表示により多くの画面スペースが使われることになります。';
$string['pref_persistflt'] = 'フィルタ設定を記憶する';
$string['pref_persistflt_help'] = 'この設定を有効にした場合、Moodleはあなたの直近のイベントフィルタ設定を記憶してログインするたびに自動的にその内容をリストアします。';
$string['pref_startwday'] = '週の初め';
$string['pref_startwday_help'] = 'あなたがここで選択した曜日を週の初めとしてカレンダー週が表示されます。';
$string['pref_timeformat'] = '時間フォーマット';
$string['pref_timeformat_help'] = 'あなたは時間表示に関して12時間または24時間フォーマットを選択できます。「デフォルト」を選択した場合、あなたのサイトの言語設定に基づき自動的に時間フォーマットが選択されます。';
$string['preferences'] = 'プレファレンス';
$string['preferences_available'] = 'あなたのパーソナルプレファレンス';
$string['preferredcalendar'] = '推奨カレンダー';
$string['privacy:metadata:calendar:event'] = 'カレンダーコンポーネントはコアサブシステム内のユーザカレンダーイベント詳細を保存できます。';
$string['privacy:metadata:calendar:event:description'] = 'カレンダーイベントの説明です。';
$string['privacy:metadata:calendar:event:eventtype'] = 'カレンダーイベントのイベントタイプです。';
$string['privacy:metadata:calendar:event:name'] = 'カレンダーイベントの名称です。';
$string['privacy:metadata:calendar:event:timeduration'] = 'カレンダーイベントの継続時間です。';
$string['privacy:metadata:calendar:event:timestart'] = 'カレンダーイベントの開始日時です。';
$string['privacy:metadata:calendar:event_subscriptions'] = 'カレンダーコンポーネントはコアサブシステム内のユーザカレンダー購読詳細を保存できます。';
$string['privacy:metadata:calendar:event_subscriptions:eventtype'] = 'カレンダー購読のイベントタイプです。';
$string['privacy:metadata:calendar:event_subscriptions:name'] = 'カレンダー購読の名称です。';
$string['privacy:metadata:calendar:event_subscriptions:url'] = 'カレンダー購読のURLです。';
$string['privacy:metadata:calendar:preferences:calendar_savedflt'] = 'ユーザプレファレンスに表示される設定済みカレンダーイベントのタイプです。';
$string['recentupcoming'] = '最近および次の60日間';
$string['repeatedevents'] = '繰り返しイベント';
$string['repeateditall'] = '変更内容を他の {$a} 件の繰り返しイベントにも適用する';
$string['repeateditthis'] = '変更内容をこのイベントにのみ適用する';
$string['repeatevent'] = 'このイベントを繰り返す';
$string['repeatnone'] = '繰り返しなし';
$string['repeatweeksl'] = '毎週、作成イベント数';
$string['repeatweeksr'] = '件';
$string['requiresaction'] = '{$a} 必要アクション';
$string['sat'] = '土';
$string['saturday'] = '土曜日';
$string['showeventtype'] = '{$a} イベントを表示する';
$string['shown'] = '表示中';
$string['site'] = 'サイト';
$string['siteevent'] = 'サイトイベント';
$string['siteevents'] = 'サイトイベント';
$string['spanningevents'] = '進行中イベント';
$string['subscriptionname'] = 'カレンダー名';
$string['subscriptionremoved'] = 'カレンダー購読「 {$a} 」が削除されました。';
$string['subscriptions'] = '購読';
$string['subscriptionsource'] = 'イベントソース: {$a}';
$string['subscriptionupdated'] = 'カレンダー購読「 {$a} 」が更新されました。';
$string['sun'] = '日';
$string['sunday'] = '日曜日';
$string['thu'] = '木';
$string['thursday'] = '木曜日';
$string['timeformat_12'] = '12時間 (午前/午後)';
$string['timeformat_24'] = '24時間';
$string['timeperiod'] = '期間';
$string['today'] = '本日';
$string['todayplustitle'] = '本日 {$a}';
$string['tomorrow'] = '明日';
$string['tt_deleteevent'] = 'イベントを削除する';
$string['tt_editevent'] = 'イベントを編集する';
$string['tue'] = '火';
$string['tuesday'] = '火曜日';
$string['typecategory'] = 'カテゴリイベント';
$string['typeclose'] = '終了イベント';
$string['typecourse'] = 'コースイベント';
$string['typedue'] = '期限到来イベント';
$string['typegradingdue'] = '評定期限イベント';
$string['typegroup'] = 'グループイベント';
$string['typeopen'] = '開催中イベント';
$string['typesite'] = 'サイトイベント';
$string['typeuser'] = 'ユーザイベント';
$string['upcomingevents'] = '直近イベント';
$string['upcomingeventsfor'] = '直近イベント:';
$string['urlforical'] = 'iCalendarエクスポートおよびカレンダー購読のためのURL';
$string['user'] = 'ユーザ';
$string['userevent'] = 'ユーザイベント';
$string['userevents'] = 'ユーザイベント';
$string['viewupcomingactivitiesdue'] = '直近の活動期限を表示する';
$string['wed'] = '水';
$string['wednesday'] = '水曜日';
$string['weekly'] = '毎週';
$string['weeknext'] = '来週';
$string['weekthis'] = '今週';
$string['when'] = '期日';
$string['whendate'] = 'いつ: {$a}';
$string['yesterday'] = '昨日';
$string['youcandeleteallrepeats'] = 'このイベントは繰り返しイベントの一部です。あなたはこのイベントのみ削除できます。また、一度に {$a} 件すべてのイベント削除もできます。';
$string['yoursubscriptions'] = 'インポート済みカレンダ';
