<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'no', version '4.2'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['addedandupdatedpp'] = 'La til {$a->%new} nye H5P-biblioteker og oppdaterte {$a->%old} eksisterende.';
$string['addedandupdatedps'] = 'La til {$a->%new} nye H5P-biblioteker og oppdaterte {$a->%old} eksisterende.';
$string['addedandupdatedsp'] = 'La til {$a->%new} nytt H5P-bibliotek og oppdaterte {$a->%old} eksisterende.';
$string['addedandupdatedss'] = 'La til {$a->%new} nytt H5P-bibliotek og oppdaterte {$a->%old} eksisterende.';
$string['addednewlibraries'] = 'La til {$a->%new} nye H5P-biblioteker.';
$string['addednewlibrary'] = 'La til {$a->%new} nytt H5P-bibliotek.';
$string['addlibraries'] = 'Legg til bibliotek';
$string['ajaxfailed'] = 'Feilet ved lasting av data.';
$string['attribution'] = 'Attribution 4.0';
$string['attributionnc'] = 'Attribution-NonCommercial 4.0';
$string['attributionncnd'] = 'Attribution-NonCommercial-NoDerivs 4.0';
$string['attributionncsa'] = 'Attribution-NonCommercial-ShareAlike 4.0';
$string['attributionnd'] = 'Attribution-NoDerivs 4.0';
$string['attributionsa'] = 'Attribution-ShareAlike 4.0';
$string['author'] = 'Forfatter';
$string['by'] = 'by';
$string['cancellabel'] = 'Avbryt';
$string['close'] = 'Lukk';
$string['confirmdialogbody'] = 'Er du sikker på at du ønsker å gjøre dette? Handlingen er ikke reversibel.';
$string['confirmdialogheader'] = 'Bekreft handling';
$string['confirmlabel'] = 'Bekreft';
$string['contentchanged'] = 'Dette innholdet har endret seg siden sist du brukte det.';
$string['contentstatefrequency'] = 'Frekvens for tilstandslagring';
$string['contentstatefrequency_help'] = 'Hvor ofte skal man lagre tilstanden (i antall sekunder). Øk dette tallet hvis du har problemer med for mange ajax-forespørsler';
$string['copyright'] = 'Opphavsrett';
$string['copyrightinfo'] = 'Opphavsrettsinformasjon';
$string['copyrightstring'] = 'Opphavsrett';
$string['copyrighttitle'] = 'Informasjon om opphavsrett for dette innholdet.';
$string['couldnotcopy'] = 'Klarte ikke å kopiere fila.';
$string['couldnotsave'] = 'Klarte ikke å lagre fila.';
$string['create'] = 'Lag ny';
$string['currentpage'] = 'Side $current av $total';
$string['dataviewreportlabel'] = 'View Answers';
$string['disablefileextensioncheck'] = 'Slå av sjekk for fil-endelser';
$string['disablefileextensioncheckwarning'] = 'Advarsel! Det å slå av sjekk for fil-endelser kan ha alvorlige sikkerhetsimplikasjoner, siden man da tillater å laste opp php-filer. Dette kan gjøre det mulig for eksterne å kjøre ondsinnet kode på ditt nettsted. Gjør dette kun hvis du vet hva du holder på med.';
$string['disablefullscreen'] = 'Gå ut av fullskjermsvisning';
$string['displayoptionalwaysshow'] = 'Vis alltid';
$string['displayoptionauthoroff'] = 'Settes av forfatter, standard av';
$string['displayoptionauthoron'] = 'Settes av forfatter, standard på';
$string['displayoptiondownloadalways'] = 'Always';
$string['displayoptiondownloadnever'] = 'Never';
$string['displayoptiondownloadpermission'] = 'Only if user has permissions to export H5P';
$string['displayoptionnevershow'] = 'Vis aldri';
$string['displayoptionpermissions'] = 'Vis kun for brukere som har tilgang til å eksportere H5Per';
$string['displayoptionpermissionsembed'] = 'Show only if user has permissions to embed H5P';
$string['displayoptions'] = 'Visningsinnstillinger';
$string['download'] = 'Last ned';
$string['downloadfailed'] = 'Nedlastingen av det angitte biblioteket klarte ikke å fullføre.';
$string['downloadtitle'] = 'Last ned dette innholdet som en H5P-fil.';
$string['editor'] = 'Innholdstype';
$string['embed'] = 'Inkluder';
$string['embedloginfailed'] = 'You do not have access to this content. Try logging in.';
$string['embedtitle'] = 'Vis HTML-kode du kan bruke for å inkludere innholdet på en annen nettside.';
$string['empty'] = 'Ingen resultater tilgjengelig';
$string['enableabout'] = 'Om H5P-knapp';
$string['enablecopyright'] = 'Opphavsretts-knapp';
$string['enabledlrscontenttypes'] = 'Skru på LRS-avhengige innholdstyper';
$string['enabledlrscontenttypes_help'] = 'Gjør det mulig å bruke innholdstyper som er avhengig av en såkalt Learning Record Store for å virke, slik som Questionnaire-innholdstypen.';
$string['enabledownload'] = 'Allow download';
$string['enableembed'] = 'Inkluder-knapp';
$string['enableframe'] = 'Vis handlingslinjen og rammen';
$string['enablejavascript'] = 'Vær vennlig å slå på JavaScript-støtte i nettleseren din.';
$string['enablesavecontentstate'] = 'Lagre tilstanden til innholdet';
$string['enablesavecontentstate_help'] = 'Automatisk lagring av hva brukeren har svart og hvor langt brukeren har kommet. Dette betyr brukeren kan fortsette der han avsluttet.';
$string['filenotimage'] = 'Fila er ikke et bilde.';
$string['filetypenotallowed'] = 'Filtypen er ikke tillatt.';
$string['finished'] = 'Ferdig';
$string['fullscreen'] = 'Fullskjermsvisning';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'H5P-fil';
$string['h5ptitle'] = 'Besøk H5P.org for å se mer interaktivt innhold.';
$string['hideadvanced'] = 'Skjul avanserte instillinger';
$string['hvp:addinstance'] = 'Lag nye H5P-aktiviteter';
$string['hvp:getcachedassets'] = 'Påkrevd for å se H5P-aktiviteter';
$string['hvp:getembedcode'] = 'Se heft ved-koden når \'kontrollert av rettigheter\' er aktivert';
$string['hvp:getexport'] = 'Last ned .h5p-fil når \'kontrollert av rettigheter\' er aktivert';
$string['hvp:installrecommendedh5plibraries'] = 'Installer nye trygge H5P-innholdstyper anbefelt av H5P.org';
$string['hvp:manage'] = 'Rediger eksisterende H5P-aktiviteter';
$string['hvp:restrictlibraries'] = 'Begrens tilgangen til spesifikke H5P-innholdstyper';
$string['hvp:savecontentuserdata'] = 'Lagre brukerens fremgang for H5P-aktiviteter';
$string['hvp:saveresults'] = 'Lagre resultatene fra fullførte H5P-aktiviteter';
$string['hvp:updatelibraries'] = 'Installer nye H5P-innholdstyper eller oppdater eksisterende';
$string['hvp:userestrictedlibraries'] = 'Bruk av begrensede H5P-innholdstyper';
$string['hvp:view'] = 'Se og interager med H5P-aktiviteter';
$string['hvp:viewallresults'] = 'Se alle resultater for fullførte H5P-aktiviteter';
$string['hvp:viewresults'] = 'Se egne resultater for fullførte H5P-aktiviteter';
$string['installdenied'] = 'Du har ikke nok rettigheter til å installere biblioteket. Kontakt nettside-administrator.';
$string['installedlibraries'] = 'Installerte bibliotek';
$string['intro'] = 'Introduksjon';
$string['invalidaudioformat'] = 'Ugyldig lydfilformat. Bruk mp3 eller wav.';
$string['invalidcontentfolder'] = 'Ugyldig innholdskatalog';
$string['invalidcontenttype'] = 'Det valgte biblioteket er ikke gyldig.';
$string['invalidfieldtype'] = 'Ugyldig felt-type.';
$string['invalidfile'] = 'Fila "{$a->%filename}" er ikke tillatt. Bare filer med de følgende filendingene er tillatt: {$a->%files-allowed}.';
$string['invalidimageformat'] = 'Ugyldig bidlefilformat. Bruk jpg, png eller gif.';
$string['invalidlanguagefile'] = 'En ugyldig språkfil {$a->%file} i biblioteket {$a->%library}';
$string['invalidlanguagefile2'] = 'En ugyldig språkfil {$a->%languageFile} er inkludert i biblioteket {$a->%name}';
$string['invalidlibrary'] = 'Ugyldig bibliotek';
$string['invalidlibrarydata'] = 'Ugyldig data angitt for {$a->%property} i {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Ugyldig data angitt for {$a->%property} i {$a->%library}. Boolsk verdi forventet.';
$string['invalidlibraryname'] = 'Ugyldig biblioteksnavn: {$a->%name}';
$string['invalidlibrarynamed'] = 'H5P-biblioteket {$a->%library} brukt i innholdet er ugyldig';
$string['invalidlibraryoption'] = 'Ulovlig verdi {$a->%option} i {$a->%library}';
$string['invalidlibraryproperty'] = 'Kan ikke lese feltet {$a->%property} i {$a->%library}';
$string['invalidmainjson'] = 'Finner ingen gyldig h5p.json-fil';
$string['invalidmultiselectoption'] = 'Ugyldig valg gjort i flervalg.';
$string['invalidparameters'] = 'Ugyldige parametre';
$string['invalidselectoption'] = 'Ugyldig valg gjort.';
$string['invalidsemanticsjson'] = 'En ugyldig semantics.json-fil er inkludert i biblioteket {$a->%name}';
$string['invalidsemanticstype'] = 'Intern H5P-feil: ukjent innholdstype "{$a->@type}" i semantikken. Fjerner det aktuelle innholdet!';
$string['invalidstring'] = 'Angitt streng er ugyldig iforhold til det regulære uttrykket i semantikken. (verdi: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Ufyldig sikkerhetsnøkkel.';
$string['invalidvideoformat'] = 'Ugyldig videofilformat. Bruk mp4 eller webm.';
$string['invalidxapiresult'] = 'No xAPI results were found for the given content and user id combination';
$string['javascriptloading'] = 'Venter på JavaScript...';
$string['libraries'] = 'H5P-bibliotek';
$string['librarydirectoryerror'] = 'Biblioteks-katalogavnet må være lik machineName eller machineName-majorVersion.minorVersion (fra library.json). (Katalog: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Handlinger';
$string['librarylistinstancedependencies'] = 'Instansavhengigheter';
$string['librarylistinstances'] = 'Instanser';
$string['librarylistlibrarydependencies'] = 'Biblioteksavhengigheter';
$string['librarylistrestricted'] = 'Begrenset';
$string['librarylisttitle'] = 'Tittel';
$string['librarynotselected'] = 'You must select a content type.';
$string['license'] = 'Lisens';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licenseversion'] = 'License Version';
$string['loadingdata'] = 'Laster data.';
$string['lookforupdates'] = 'Se etter H5P-oppdateringer';
$string['maximumgrade'] = 'Maximum grade';
$string['maximumgradeerror'] = 'Please enter a valid positive integer as the max points available for this activity';
$string['maxscore'] = 'Max poeng';
$string['missingcontentfolder'] = 'Finner ingen gyldig innholdskatalog';
$string['missingcontentuserdata'] = 'Feil: Kunne ikke finne innholdsbrukerdata';
$string['missingcoreversion'] = 'Systemet kunne ikke installere <em>{$a->%component}</em>-komponenten fra pakken, den krever en nyere versjon av H5P-utvidelsen. Dette nettstedet kjører versjon {$a->%current}, mens påkrevd versjon er {$a->%required} eller høyere. Du bør vurdere å oppgradere for deretter å prøve på nytt.';
$string['missingdependency'] = 'Mangler avhengigheten {$a->@dep} som kreves av {$a->@lib}.';
$string['missinglibrary'] = 'Mangler et påkrevd bibliotek {$a->@library}';
$string['missinglibraryfile'] = 'Fila "{$a->%file}" mangler i biblioteket: "{$a->%name}"';
$string['missinglibraryjson'] = 'Klarte ikke å finne en library.json-fil med gyldig json format for bibliotek {$a->%name}';
$string['missinglibraryproperty'] = 'Det obligatoriske feltet {$a->%property} finnes ikke i {$a->%library}';
$string['missingmbstring'] = 'PHP-utvidelsen mbstring mangler. H5P trenger denne for å kunne virke';
$string['missingparameters'] = 'Mangler parametre';
$string['missinguploadpermissions'] = 'Vær oppmerksom på at bibliotekene kan skistere i den opplastede fila, men at du ikke tillates å laste opp nye bibliotek. Kontakt nettstedsadministratoren.';
$string['modulename'] = 'Interaktivt innhold';
$string['modulename_help'] = 'Aktivitetsmodulen H5P gjør deg istand til å lage interaktivt innhold som feks Interaktive videoer, spørsmåls-sett, dra og slipp, flervalg, presentasjoner og mye mer.

I tillegg til å være et forfatterverktøy for rikt innhold, gjør H5P det mulig å importere og eksportere H5P-filer for effektiv gjenbruk og deling av innhold.

Brukerinteraksjoner og poeng spores vha xAPI og er tilgjengelig gjennom Moodles karakterbok

Du kan legge til eksisterende interaktivt H5P-innhold fra andre nettsider ved å laste opp en .h5p-fil. Du kan lage og laste ned .h5p-filer på feks h5p.org';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Interaktivt innhold';
$string['nextpage'] = 'Neste side';
$string['noanswersubmitted'] = 'This user hasn\'t submitted an answer to the H5P yet';
$string['nocontent'] = 'Kunne ikke finne eller tolke content.json-fila';
$string['nocontenttype'] = 'Ingen bibliotek var angitt.';
$string['nocopyright'] = 'Informasjon om opphavsrett ikke tilgjengelig for dette innholdet.';
$string['nodata'] = 'Det finnes ikke data som passer til kriteriene.';
$string['noextension'] = 'Fila du lastet opp er ikke en gyldig H5P (Den har ikke .h5p som filendelse)';
$string['noh5ps'] = 'Der finnes ikke noe interaktivt innhold for dette kurset.';
$string['nojson'] = 'h5p.json-fila er ugyldig';
$string['noparameters'] = 'Ingen parametre';
$string['noparse'] = 'Jeg klarte ikke å tolke h5p.json-fila';
$string['nopermissiontogettranslations'] = 'You do not have permissions to retrieve translations';
$string['nopermissiontorestrict'] = 'Du har ikke tillatelse til å begrense tilgang til bibliotek.';
$string['nopermissiontosavecontentuserdata'] = 'Du har ikke tillatelse til å lagre brukerdata.';
$string['nopermissiontosaveresult'] = 'Du har ikke tillatelse til å lagre resultater for dette innholdet.';
$string['nopermissiontoupgrade'] = 'Du har ikke tillatelse til å oppgradere bibliotek.';
$string['nopermissiontoviewresult'] = 'Du har ikke tillatelse til å se resultater for dette innholdet.';
$string['nosuchlibrary'] = 'Biblioteket finnes ikke';
$string['notapplicable'] = '--';
$string['nounzip'] = 'Fila du lastet opp er ikke en gyldig H5P (Jeg klarer ikke å unzippe den)';
$string['noversionattribution'] = 'Attribution';
$string['noversionattributionnc'] = 'Attribution-NonCommercial';
$string['noversionattributionncnd'] = 'Attribution-NonCommercial-NoDerivs';
$string['noversionattributionncsa'] = 'Attribution-NonCommercial-ShareAlike';
$string['noversionattributionnd'] = 'Attribution-NoDerivs';
$string['noversionattributionsa'] = 'Attribution-ShareAlike';
$string['noziparchive'] = 'PHP-versjonen du bruker støtter ikke ZipArchive.';
$string['onlyupdate'] = 'Oppdater kun eksisterende bibliotek';
$string['options'] = 'Innstillinger';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['previouspage'] = 'Forrige side';
$string['removeoldlogentries'] = 'Fjern gamle H5P-loggmeldinger';
$string['removeoldmobileauthentries'] = 'Remove old H5P mobile auth entries';
$string['removetmpfiles'] = 'Fjern gamle midlertidige filer';
$string['reportingquestionsremaininglabel'] = 'questions remaining to grade';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Gradebook score:';
$string['reportingscoredelimiter'] = 'out of';
$string['reportingscorelabel'] = 'Score:';
$string['reportnotsupported'] = 'Not supported';
$string['reportsubmitgradelabel'] = 'Submit grade';
$string['resizescript'] = 'Inkluder dette scriptet på din nettside hvis du ønsker dynamisk endring av størrelse på inkludert innhold:';
$string['reuse'] = 'Reuse';
$string['score'] = 'Poeng';
$string['search'] = 'Søk';
$string['sendusagestatistics'] = 'Bidra med statistikk';
$string['sendusagestatistics_help'] = 'Bruks-statistikk blir sendt til h5p.org for å bedre forstå hvordan H5P brukes og hvor det ka forbedres. Les mer om hvilke <a {$a}>data som blir samlet på h5p.org</a>.';
$string['settings'] = 'H5P-innstillinger';
$string['showadvanced'] = 'Vis avanserte instillinger';
$string['showless'] = 'Show less';
$string['showmore'] = 'Show more';
$string['size'] = 'Størrelse';
$string['source'] = 'Kilde';
$string['startingover'] = 'Du starter på nytt.';
$string['sublevel'] = 'Sublevel';
$string['thumbnail'] = 'Miniatyrbilde';
$string['title'] = 'Tittel';
$string['unabletocreatedir'] = 'Ikke istand til å opprette katalog.';
$string['unabletogetfieldtype'] = 'Ikke istand til å hente felt-type.';
$string['undisclosed'] = 'Undisclosed';
$string['updatedlibraries'] = 'Oppdaterte {$a->%old} H5P-biblioteker.';
$string['updatedlibrary'] = 'Oppdaterte {$a->%old} H5P-bibliotek.';
$string['upgrade'] = 'Oppgrader H5P';
$string['upgradebuttonlabel'] = 'Oppgrader';
$string['upgradedone'] = 'Du har nå oppgrader {$a} innholdsinstans(er).';
$string['upgradeerror'] = 'En fil skjedde under prosesseringen:';
$string['upgradeerrorcontent'] = 'Klarte ikke å oppgradere innholdet med ID: %id:';
$string['upgradeerrordata'] = 'Klarte ikke å laste data for biblioteket %lib.';
$string['upgradeerrormissinglibrary'] = 'Missing required library %lib.';
$string['upgradeerrornotsupported'] = 'Parameters contain %used which is not supported.';
$string['upgradeerrorparamsbroken'] = 'Parameterne er ødelagt.';
$string['upgradeerrorscript'] = 'Klarte ikke å laste oppgraderingskoden til %lib.';
$string['upgradeerrortoohighversion'] = 'Parameters contain %used while only %supported or earlier are supported.';
$string['upgradeheading'] = 'Oppgrader {$a}-innhold';
$string['upgradeinprogress'] = 'Oppgraderer til %ver...';
$string['upgradeinvalidtoken'] = 'Feil: Ugyldig sikkerhetsnøkkel!';
$string['upgradelibrarycontent'] = 'Oppgrader H5P-innhold';
$string['upgradelibrarymissing'] = 'Feil: Et bibliotek mangler!';
$string['upgrademessage'] = 'Du er iferd med å oppgradere {$a} innholdsinstans(er). Men først må du velge hvilke versjon du ønsker å oppgradere til.';
$string['upgradenoavailableupgrades'] = 'Det finnes ingen oppgraderinger for dette biblioteket.';
$string['upgradenothingtodo'] = 'Det finnes ikke noe innhold å oppgradere';
$string['upgradereturn'] = 'Gå tilbake';
$string['upload'] = 'Laste opp';
$string['uploadlibraries'] = 'Last opp bilbliotek';
$string['user'] = 'Bruker';
$string['validatingh5pfailed'] = 'Validering av H5P pakken har feilet.';
$string['validationfailed'] = 'Valgt H5P er ikke gyldig.';
$string['viewreportlabel'] = 'Report';
$string['welcomecommunity'] = 'We hope you will enjoy H5P and get engaged in our growing community through our <a {$a->forums}>forums</a>.';
$string['welcomecontactus'] = 'If you have any feedback, don\'t hesitate to <a {$a}>contact us</a>. We take feedback very seriously and are dedicated to making H5P better every day!';
$string['welcomegettingstarted'] = 'To get started with H5P and Moodle take a look at our <a {$a->moodle_tutorial}>tutorial</a> and check out the <a {$a->example_content}>example content</a> at H5P.org for inspiration.';
$string['welcomeheader'] = 'Welcome to the world of H5P!';
$string['wrongversion'] = 'En ugyldig versjon av H5P-biblioteket {$a->%machineName} er brukt i innholdet. Innholdet bruker {$a->%contentLibrary}, mens det skal bruke {$a->%semanticsLibrary}.';
$string['year'] = 'År';
$string['years'] = 'År';
