<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ro', version '4.2'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acces interzis';
$string['accounts'] = 'Conturi';
$string['addcategory'] = 'Adaugă o categorie';
$string['additionalhtml'] = 'HTML suplimentar';
$string['additionalhtml_desc'] = 'Aceste setări îți permit să specifici codul HTML care vrei să fie adăugat la fiecare pagină. Poți seta codul HTML care va fi adăugat în cadrul tag-ul HEAD, imediat după ce eticheta BODY a fost deschisă, sau imediat înainte ca tag-ul BODY să fie închis. <br /> Făcând acest lucru vei putea adăuga anteturi/subsoluri personalizate pe fiecare pagină sau poți adăuga suport pentru servicii online, cum ar fi Google Analytics, foarte ușor și independent de tema aleasă.';
$string['additionalhtml_heading'] = 'Cod HTML suplimentar de adăugat la fiecare pagină.';
$string['additionalhtmlfooter'] = 'Înainte ca tag-ul BODY să fie închis';
$string['additionalhtmlfooter_desc'] = 'Conținutul de aici va fi adăugat în fiecare pagină chiar înainte ca tag-ul body să fie închis.';
$string['additionalhtmlhead'] = 'În tag-ul HEAD';
$string['additionalhtmlhead_desc'] = 'Conținutul de aici va fi adăugat la partea de jos a tag-ului HEAD pentru fiecare pagină.';
$string['additionalhtmltopofbody'] = 'Când tag-ul BODY este deschis';
$string['additionalhtmltopofbody_desc'] = 'Conținutul de aici va fi adăugat în la fiecare pagină imediat după deschiderea tag-ul body.';
$string['admincategory'] = 'Categorie: {$a}';
$string['adminseesall'] = 'Administratorii văd tot';
$string['adminseesallevents'] = 'Administratorii văd toate evenimentele';
$string['adminseesownevents'] = 'Administratorii sunt la fel ca ceilalți utilizatori';
$string['advancedfeatures'] = 'Funcţionalităţi avansate';
$string['agedigitalconsentverification'] = 'Vârsta minimă de exprimare a acordului';
$string['agedigitalconsentverification_desc'] = 'Permite verificarea vârstei minime de exprimare a acordului înainte de afișarea paginii de înscriere pentru utilizatorii auto-înregistrați. Astfel, site-ul este protejat de încercările minorilor de a se înscrie fără consimțământul părinților/tutorelui. <a target="_blank" href="{$a}"> Detaliile de contact </a> sunt furnizate minorilor pentru asistență suplimentară.';
$string['ageofdigitalconsentmap'] = 'Vârsta minimă de exprimare a acordului';
$string['ageofdigitalconsentmap_desc'] = 'Aici se poate specifica vârsta minimă de exprimare a acordului și vârsta necesară din orice țară în care este diferită de cea implicită. Scrie fiecare vârstă pe o nouă linie cu formatul: codul țării, vârsta (separată printr-o virgulă). Vârsta implicită este indicată de * în locul codului de țară. Codurile de țară sunt cele specificate în ISO 3166-2.';
$string['allcountrycodes'] = 'Toate codurile de ţară';
$string['allowattachments'] = 'Permite atașamente';
$string['allowbeforeblock'] = 'Lista de IP-uri permise va fi procesată prima';
$string['allowbeforeblockdesc'] = 'Implicit, sunt procesate mai întâi elementele din lista de IP-uri blocate. Dacă această opţiune este activată, elementele din lista de IP-uri permise vor fi procesate înaintea listei de IP-uri blocate.';
$string['allowcategorythemes'] = 'Permite teme de categorie';
$string['allowcohortthemes'] = 'Permite temele cohortei';
$string['allowcoursethemes'] = 'Permite teme de curs';
$string['allowedemaildomains'] = 'Domenii de email acceptate';
$string['allowediplist'] = 'Lista de IP-uri permise';
$string['allowemailaddresses'] = 'Domenii de email permise';
$string['allowemojipicker'] = 'Se selectează emoji';
$string['allowframembedding'] = 'Permite cadre încorporate';
$string['allowframembedding_help'] = 'Dacă este activat, acest site poate fi încorporat într-un cadru într-un sistem la distanță, așa cum se recomandă atunci când se utilizează pluginul de înscriere „Publicați ca instrument LTI”. În caz contrar, este recomandat să renunți la dezactivarea încorporării cadrelor din motive de securitate. Reține că pentru aplicația mobilă această setare este ignorată și încorporarea cadrelor este întotdeauna permisă.';
$string['allowguestmymoodle'] = 'Permiteți accesul vizitatorilor la tabloul de bord';
$string['allowindexing'] = 'Permiteți indexarea de către motoarele de căutare';
$string['allowindexing_desc'] = 'Acest lucru determină dacă permiți motoarelor de căutare să indexeze site-ul dvs. "Peste tot" va permite motoarelor de căutare să caute peste tot, inclusiv paginile de conectare și de înregistrare, ceea ce înseamnă că site-urile cu opțiunea "Conectare forțată" activată sunt încă indexate. Pentru a evita riscul ca spam-ul implicat în pagina de înscriere să poată fi căutat, utilizați "Peste tot, cu excepția paginilor de conectare și de înscriere". "Niciunde" va spune motoarelor de căutare să nu indexeze nicio pagină. Reține că aceasta este numai o etichetă în antetul site-ului. Depinde de motorul de căutare să respecte eticheta.';
$string['allowindexingeverywhere'] = 'Peste tot';
$string['allowindexingexceptlogin'] = 'În tot site-ul, cu excepția paginilor de login și signup';
$string['allowindexingnowhere'] = 'Nicăieri';
$string['allowobjectembed'] = 'Permite folosirea tagurilor EMBED și OBJECT';
$string['allowthemechangeonurl'] = 'Permite schimbări de temă în URL';
$string['allowuserblockhiding'] = 'Permite utilizatorilor să ascundă blocuri';
$string['allowusermailcharset'] = 'Permite utilizatorilor să selecteze setul de caractere';
$string['allowuserswitchrolestheycantassign'] = 'Permite utilizatorilor fără roluri de asignare să comute între roluri';
$string['allowuserthemes'] = 'Permite teme de utilizator';
$string['alternativefullnameformat'] = 'Format alternativ pentru nume complet';
$string['alternativefullnameformat_desc'] = 'Definește modul în care numele sunt afișate utilizatorilor cu opțiunea de a vedea numele complete (de către utilizatorii cu rolul de manager, profesor sau profesor care nu editează activitățile). Substituenții care pot fi utilizați sunt aceiași ca la setările "Format nume complet".';
$string['always'] = 'Întotdeauna';
$string['appearance'] = 'Aspect';
$string['aspellpath'] = 'Cale către aspell';
$string['authentication'] = 'Autentificare';
$string['authpreventaccountcreation'] = 'Permite crearea de conturi la autentificare';
$string['authpreventaccountcreation_help'] = 'Când un utilizator se autentifică, un cont pe site este creat în mod automat în cazul în care acesta nu există încă. Dacă o bază de date externă, cum ar fi LDAP, este folosită pentru autentificare, dar vrei să permiți accesul la site doar pentru utilizatorii cu un cont existent, atunci această opțiune trebuie să fie activată. Conturile noi vor trebui să fie create manual sau prin import de utilizatori. Reține că această setare nu se aplică la autentificarea MNet.';
$string['authsettings'] = 'Administrează autentificarea';
$string['autolang'] = 'Autodetectare limbă';
$string['autolangusercreation'] = 'La crearea contului, setează limba browserului utilizatorului ca limbă preferată';
$string['autologinguests'] = 'Autentifică automat vizitatorii';
$string['availableto'] = 'Disponibil pentru';
$string['availabletoanyone'] = 'Disponibil pentru fiecare vizitator al site-ului';
$string['availabletoauthenticated'] = 'Limitat pentru utilizatorii autentificați';
$string['backgroundcolour'] = 'Culoare transparentă';
$string['backup_shortname'] = 'Utilizați numele cursului în numele fișierului de backup';
$string['backup_shortnamehelp'] = 'Utilizați numele cursului ca parte a numelui fișierului de backup.';
$string['backups'] = 'Copii de rezervă';
$string['badwordsconfig'] = 'Introdu lista de cuvinte interzise separate prin virgule.';
$string['badwordsdefault'] = 'Dacă lista personalizată este goală, se va folosi o listă implicită din pachetul de limbă.';
$string['badwordslist'] = 'Lista personalizată de cuvinte interzise';
$string['blockediplist'] = 'Lista de IP-uri blocate';
$string['blockinstances'] = 'Instanțe';
$string['blockmultiple'] = 'Multiple';
$string['blockprotect'] = 'Protejează instanțele';
$string['blockprotect_help'] = 'Dacă blochezi un anumit tip de bloc, atunci nimeni nu va putea să adauge sau să șteargă exemple. (Poți, bineînțeles, să îl deblochezi din nou, dacă trebuie să editezi exemplele).

Acest lucru este destinat protejării bloc-urilor precum navigarea și setările, care sunt foarte dificil de recuperat odată ce au fost șterse accidental.';
$string['blockprotectblock'] = 'Protejează instanțele {$a}';
$string['blockprotected'] = 'Instanțele blocului {$a} sunt protejate.';
$string['blocksettings'] = 'Administrează blocuri';
$string['blockunprotect'] = 'Neprotejat';
$string['blockunprotectblock'] = 'Dezactivați protecția blocurilor {$a}';
$string['blockunprotected'] = 'Blocul {$a} nu mai este protejat.';
$string['bloglevel'] = 'Vizibilitate blog';
$string['bookmarkadded'] = 'Semn de carte adăugat.';
$string['bookmarkalreadyexists'] = 'A fost asociat deja un semn de carte acestei pagini.';
$string['bookmarkdeleted'] = 'Semn de carte șters.';
$string['bookmarkthispage'] = 'Adaugă un semn de carte acestei pagini';
$string['cacheapplication'] = 'Memoria cache a aplicației';
$string['cacheapplicationhelp'] = 'Elementele din cache sunt distribuite între toți utilizatorii și expiră la un interval de timp determinat (time to live - ttl).';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Cache-ul şi compresia Javascript scad semnificativ durata de încărcare a paginilor şi sunt foarte recomandate pentru siturile de producţie. Developerii vor dori probabil să dezactiveze această funcţionalitate.';
$string['cacherequest'] = 'Cerere pentru cache';
$string['cacherequesthelp'] = 'Cache specific al utilizatorului care expiră când cererea este completă. Conceput pentru a înlocui zone unde folosim stocări statice.';
$string['cachesession'] = 'Memoria cache a sesiunii';
$string['cachesessionhelp'] = 'Cache specific al utilizatorului care expiră când sesiunea se încheie. Conceput pentru a preveni acumularea de sesiune nefolosite/invalide.';
$string['cachesettings'] = 'Setări ale memoriei cache';
$string['cachetemplates'] = 'Memorie cache a șabloanelor';
$string['cachetemplates_help'] = 'Stocarea în cache a șabloanelor va îmbunătăți performanțele de încărcare a paginilor și este foarte recomandată pentru site-urile de producție. Dezvoltatorii vor dori probabil să dezactiveze această caracteristică.';
$string['caching'] = 'Caching';
$string['calendar_weekend'] = 'Zile de weekend';
$string['calendarexportsalt'] = 'Sarea de export calendar';
$string['calendarsettings'] = 'Calendar';
$string['calendartype'] = 'Tip de calendar';
$string['calendartype_desc'] = 'Alege un tip de calendar implicit pentru întregul site. Această setare poate fi suprascrisă în setările cursului sau de către useri în profilul lor personal.';
$string['campaign'] = 'Campanie';
$string['cannotdeletemodfilter'] = 'Nu puteţi dezinstala \'{$a->filter}\' deoarece face parte din modulul \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} nu poate fi dezinstalat';
$string['categoryemail'] = 'Email';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot este definit incorect în fișierul config.php. Include un caracter \'/\' la sfârșit, care trebuie eliminat.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot este definit incorect în fișierul config.php. Ar trebui să se potrivească cu adresa URL pe care o utilizați pentru a accesa această pagină.';
$string['change'] = 'schimbă';
$string['checkboxno'] = 'Nu';
$string['checkboxyes'] = 'Da';
$string['checkupgradepending'] = 'Actualizare';
$string['choosefiletoedit'] = 'Alege fișierul de modificat';
$string['cleanup'] = 'Cleanup';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'd';
$string['cliexitgraceful'] = 'În execuție procesul de închidere, așteptați ...';
$string['cliexitnow'] = 'Ieșiți chiar ACUM';
$string['cliincorrectvalueerror'] = 'Eroare, valoare incorectă "{$a->value}" pentru "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valoare incorectă, încercaţi din nou';
$string['clistatusdisabled'] = 'Status: dezactivat';
$string['clistatusenabled'] = 'Status: activat';
$string['clistatusenabledlater'] = 'status: modul de mentenanță CLI va fi activat {$a}';
$string['clitypevalue'] = 'introdu valoarea';
$string['clitypevaluedefault'] = 'introdu valoarea, apasă Enter pentru a folosi valoarea implicită ({$a})';
$string['cliunknowoption'] = 'Opţiuni necunoscute:
 {$a}
Te rugăm folosește--opţiunea Ajutor.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Pentru a șterge memoria cache rămasă după trecerea traficului utilizatorului la un cod nou:

   php admin/cli/purge_caches.php --muc
   php admin/cli/purge_caches.php --js
   php admin/cli/purge_caches.php --filter
   php admin/cli/purge_caches.php --other

Ar trebui să efectuați aceste curățări izolat, cu un decalaj între comenzi, pentru a reduce vârfurile de încărcare pe serverul web.';
$string['cliupgradedefault'] = 'Setare nouă: {$a}';
$string['cliupgradedefaultheading'] = 'Stabilește noi valori implicite';
$string['cliupgradedefaultverbose'] = 'Setare nouă: {$a->name}, valoare implicită: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Actualizarea liniei de comandă de la {$a->oldversion} la {$a->newversion} s-a finalizat cu succes.';
$string['cliupgrademaintenancenotrequired'] = 'Această actualizare NU VA DETERMINA modul mentenanță pentru utilizatori.';
$string['cliupgrademaintenancerequired'] = 'Aceaastă actualizare VA DETERMINA modul mentananță pentru utilizatori.';
$string['cliupgradenoneed'] = 'Nu este necesar upgrade pentru versiunea instalată {$a}. Mulțumim pentru vizită!';
$string['cliupgradepending'] = 'O actualizare se află în așteptare';
$string['cliupgradesetlock'] = 'Actualizarea a fost blocată numai pentru execuția CLI.';
$string['cliupgradeunsetlock'] = 'Blocarea actuală a execuției CLI a fost eliminată.';
$string['cliyesnoprompt'] = 'tastează d (pentru \'da\') sau \'n\' (pentru \'nu\')';
$string['close'] = 'Închide';
$string['cohort_customfield'] = 'Câmpuri personalizate ale cohortei';
$string['commentsperpage'] = 'Comentarii afişate per pagină';
$string['commonactivitysettings'] = 'Setări de bază';
$string['commonfiltersettings'] = 'Setări de filtrare de bază';
$string['commonsettings'] = 'Setări de bază';
$string['componentinstalled'] = 'Componentă instalată';
$string['computedfromlogs'] = 'Calculat de la jurnalele din {$a}';
$string['condifmodeditdefaults'] = 'Valorile implicite sunt utilizate în formularul de setări la crearea unei noi activități sau resurse.';
$string['confeditorhidebuttons'] = 'Selectați butoanele care ar trebui să fie ascunse în editorul HTML';
$string['configallcountrycodes'] = 'Aceasta este lista de ţări care pot fi selectate în diverse locuri, de exemplu profilul de utilizator. Dacă este goală (implicit), se va folosi lista din fişierul countries.php din pachetul de limbă engleză standard. Aceasta este lista din ISO 3166-1. Altfel, puteţi specifica o lista de coduri separate prin virgule, de exemplu \'GB,FR,ES\'. Dacă adăugaţi aici coduri noi, non-standard, va trebui să le adăugaţi în countries.php în ‘en’ şi în pachetul Dvs. de limbă.';
$string['configallowassign'] = 'Pentru fiecare rol din coloana din stânga, selectează ce roluri le pot atribui altora.';
$string['configallowattachments'] = 'Dacă această setare este activată, e-mailurile trimise de pe site-ul poate avea atașamente, cum ar fi ecusoane.';
$string['configallowcategorythemes'] = 'Dacă activezo această setare, se vor putea seta teme la nivel de categorie. În acest caz, vor fi afectate toate categoriile- şi cursurile-copil, în cazul în care acestea nu au deja setate teme proprii. ATENŢIE: Activarea temelor de categorie poate afecta performanţa sitului.';
$string['configallowcohortthemes'] = 'Dacă activezi acest lucru, temele pot fi setate la nivelul cohortei. Acest lucru va afecta toți utilizatorii cu o singură cohortă sau mai multe, dar cu aceeași temă.';
$string['configallowcoursethemes'] = 'Dacă activezi această setare, se vor putea seta teme la nivel de curs. Temele de curs au prioritate faţă de toate celelalte teme (de site, de utilizator sau de sesiune).';
$string['configallowedemaildomains'] = 'Enumeră domeniile de e-mail care pot fi dezvăluite în secțiunea „De la” a e-mailurilor de ieșire. Setarea prestabilită „Necompletat” va utiliza adresa fără răspuns pentru toate e-mailurile trimise. Este permisă utilizarea metacaracterelor de ex. * .example.com va permite e-mailurile trimise din orice subdomeniu al example.com, dar nu și example.com în sine. Acest lucru va necesita o intrare separată.';
$string['configallowemailaddresses'] = 'Pentru a restricționa noile adrese de e-mail la anumite domenii, listați-le aici separate prin spații. Toate celelalte domenii vor fi respinse. Pentru a permite subdomeniile, adăugați domeniul precedat de un „.” . Pentru a permite un domeniu rădăcină împreună cu subdomeniile sale, adăugați domeniul de două ori - o dată cu un „precedent”. și o dată fără de ex. .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Selectorul de emoji permite utilizatorilor să selecteze emoji-uri, cum ar fi zâmbete, pentru a adăuga la mesaje și alte zone de text printr-un buton de selectare a emoji-urilor din bara de instrumente Atto.';
$string['configallowemojipickerincompatible'] = 'Configurația actuală a bazei de date nu acceptă emoji. Pentru a activa selectorul de emoji, va trebui să <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> actualizați baza de date pentru suport unicode unic </a>.';
$string['configallowguestmymoodle'] = 'Dacă este activat, oaspeții pot accesa Tabloul de bord. În caz contrar, oaspeții sunt redirecționați către site-ul de acasă.';
$string['configallowobjectembed'] = 'Ca măsură de securitate implicită, utilizatorii normali nu au permisiunea de a insera elemente multimedia (cum ar fi Flash) în texte folosind taguri explicite EMBED sau OBJECT în fişierele HTML create (deşi acest lucru poate fi realizat în mod securizat folosind filtrul mediaplugins). Dacă doriţi să permiteţi folosirea acestor taguri, activaţi această opţiune.';
$string['configallowoverride'] = 'Puteţi permite utilizatorilor care au rolurile din partea stânga să aibă roluri în plus faţă de rolurile din coloană';
$string['configallowoverride2'] = 'Pentru fiecare rol din coloana din stânga, selectați pentru ce roluri acestea pot seta suprascrieri.<br />Utilizatorii trebuie să aibă, de asemenea, capabilitatea moodle/role:override sau moodle/role:safeoverride.';
$string['configallowswitch'] = 'Pentru fiecare rol din coloana din stânga, selectați la ce roluri pot comuta.<br />Utilizatorii trebuie să aibă și capacitatea moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'Dacă este activată, tema poate fi modificată adăugând fie: <br />?theme=themename  la orice adresă URL Moodle (de exemplu: mymoodlesite.com/?theme=afterburner), fie <br /> &theme=themename la orice adresă URL internă Moodle ( de exemplu: mymoodlesite.com/course/view.php?id=2&theme=afterburner).';
$string['configallowuserblockhiding'] = 'Doriţi ca utilizatorii să poată ascunde/afişa blocurile laterale în cadrul acestui site? Această funcţionalitate foloseşte Javascript şi cookie-uri pentru a memora starea fiecărui bloc minimizabil şi afectează doar pagina utilizatorului.';
$string['configallowusermailcharset'] = 'Dacă această setare este activată, fiecare utilizator din cadrul sitului va putea să-şi specifice singur setul de caractere pentru email.';
$string['configallowuserswitchrolestheycantassign'] = 'În mod implicit, moodle/role:assign este necesară pentru ca utilizatorii să-şi poată comuta rolurile. Dacă această setare este activată, se înlătură respectiva necesitate, iar rolurile din meniul dropdown "Comută rol pe" vor fi determinate doar de setările din tabelul "Permite asignări de roluri". Se recomandă ca setările din tabelul "Permite asignări de roluri" să nu permită utilizatorilor să comute pe un rol cu mai multe atribute decât rolul existent.';
$string['configallowuserthemes'] = 'Dacă această setare este activată, utilizatorii îşi vor putea seta propriile teme. Temele de utilizator au prioritate faţă de temele de site (dar nu şi faţă de temele de curs).';
$string['configallowview'] = 'Pentru fiecare rol în coloana din stânga, selectează ce roluri pot vedea, căuta și pot utiliza în filtrare.';
$string['configallusersaresitestudents'] = 'Pentru activitățile de pe site-ul acasă, TOȚI utilizatorii ar trebui să fie considerați cursanți? Dacă da, atunci oricine are un cont va avea voie să participe ca student la aceste activități. Dacă nu, atunci doar utilizatorii care sunt deja participanți la cel puțin un curs vor putea participa la aceste activități. Doar administratorii și profesorii special alocați pot acționa ca profesori pentru activitățile de acasă de pe site.';
$string['configauthenticationplugins'] = 'Vă rugăm selectaţi plugin-urile de autentificare pe care doriţi să le utilizaţi şi ordonaţi-le în funcţie de nivelul de securitate pe care îl oferă.';
$string['configautolang'] = 'Detectare limbă implicită din setarea browserului, dacă această setare este dezactivată, se foloseşte limba implicită a sitului.';
$string['configautolangusercreation'] = 'Dacă este activat, când contul unui utilizator este creat automat la prima autentificare (de exemplu, utilizând autentificarea LDAP sau OAuth 2), limba browserului utilizatorului este setată ca limbă preferată. În caz contrar, limba implicită pentru site este setată ca limbă preferată de utilizator.';
$string['configautologinguests'] = 'La accesarea unui curs cu acces de vizitator, utilizatorii ar trebui să fie automat autentificaţi ca vizitatori?';
$string['configbloglevel'] = 'Această setare vă permite să restricţionaţi gradul de vizibilitate al blogurilor de utilizator pe acest site. Atenţie, această setare specifică contextul maxim AL CELUI CARE VIZUALIZEAZĂ situl şi nu a autorului articolului sau a tipurilor de articole de pe blog. Dacă doriţi, puteţi să dezactivaţi complet funcţionalitatea de blog de pe site.';
$string['configcalendarcustomexport'] = 'Activează intervalul de date personalizat pentru exportul calendarului.';
$string['configcalendarexportsalt'] = 'Acest text generat în mod aleatoriu este folosit la îmbunătăţirea securităţii tokenurilor de autentificare utilizate la exportul calendarelor. Atenţie: toate tokenurile curente vor deveni invalide dacă modficaţi această sare de hash.';
$string['configcookiehttponly'] = 'Activează noua funcţionalitate PHP 5.2.0 - browserele primesc instrucţiuni să trimită doar cookie-uri cu request-uri http reale, nu ar trebui să existe acces la cookie-uri nu prin limbaje de scripting. Această funcţionalitate nu este suportată de toate browserele şi este posibil să nu fie complet compatibilă cu codul curent. Ajută la prevenirea anumitor atacuri de tip XSS.';
$string['configcookiesecure'] = 'Dacă serverul acceptă doar conexiuni https, este recomandat să activați trimiterea de cookie-uri sigure. Dacă este activat, asigurați-vă că serverul web nu acceptă http: // sau configurați redirecționarea permanentă către adresa https: // și trimiteți în mod ideal anteturi HSTS. Când adresa <em> wwwroot </em> nu începe cu https:// această setare este ignorată.';
$string['configcountry'] = 'Dacă setaţi o ţară aici, aceasta va fi ţara utilizată implicit pentru toate conturile noi. Pentru a obliga utilizatorii să aleagă o ţară, lăsaţi acest câmp gol.';
$string['configcoursegraceperiodafter'] = 'Clasificați cursurile trecute ca și cursuri în desfășurare pentru aceste zile după data de încheiere a cursului.';
$string['configcoursegraceperiodbefore'] = 'Clasificați cursurile viitoare ca și cursuri în desfășurare pentru aceste zile înaintea datei de începere a cursului.';
$string['configcourseoverviewfilesext'] = 'O listă separată prin virgule a fișierelor permise în zona rezumatele cursurilor .';
$string['configcourseoverviewfileslimit'] = 'Numărul maxim de fișiere care pot fi afișate lângă rezumatul cursului pe lista de cursuri. Primul fișier imagine adăugat este utilizat ca imagine a cursului în prezentarea generală a cursului de pe tablourile de bord ale utilizatorilor; orice fișier suplimentar este afișat numai pe pagina de cursuri.';
$string['configcourserequestnotify'] = 'Inserează numele de utilizator al utilizatorului care să fie înştiinţat atunci când se solicită crearea unui curs nou.';
$string['configcourserequestnotify2'] = 'Utilizatorii care vor fi înştiinţaţi atunci când se solicită un curs. Această listă cuprinde doar utilizatorii care au dreptul să aprobe cererile de creare de curs.';
$string['configcoursesperpage'] = 'Inserează numărul de cursuri care trebuie afișate pe pagină într-o listă de cursuri.';
$string['configcourseswithsummarieslimit'] = 'Numărul maxim de cursuri afișate într-o listă de cursuri, inclusiv rezumatele, înainte de a se reveni la o listă mai simplă.';
$string['configcronclionly'] = 'Rularea cronului dintr-un browser web poate expune informații privilegiate utilizatorilor anonimi. Astfel, se recomandă să execuți cronul numai din linia de comandă sau să setați o parolă cron pentru acces la distanță.';
$string['configcronremotepassword'] = 'Aceasta înseamnă că scriptul cron.php nu poate fi rulat dintr-un browser web fără a furniza parola utilizând următoarea formă de adresă URL: <pre> https://site.example.com/admin/cron.php?password=opensesame </ pre> Dacă aceasta este lăsată goală, nu este necesară nicio parolă.';
$string['configcurlcache'] = 'Durata de viaţă, în secunde, pentru cache-ul cURL.';
$string['configcustommenuitems'] = 'Aici poate fi configurat un meniu personalizat. Introdu fiecare element de meniu pe un rând nou cu următorul format:
textul meniului, o adresă URL a link-ului (opțional, nu pentru un element de meniu superior cu subelemente), un titlu de ajutor (opțional) și un cod de limbă sau o listă de coduri separate prin virgulă (opțional, pentru afișarea liniei numai utilizatorilor limbii specificate), separate prin caractere de tip bară verticală. Liniile care încep cu o cratimă vor apărea ca subelemente în meniul superior anterior și ### ca separator. De exemplu:
<pre>
Cursuri
-Toate cursurile|/course/
-Cautare curs|/course/search.php
-###
-FAQ|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
Aplicație mobilă|https://example.org/app|Descarcă aplicația noastră
</pre>';
$string['configcustomusermenuitems'] = 'Poți configura conținutul meniului utilizator (cu excepția link-ului de deconectare, care este adăugat automat). Fiecare linie este separată prin caractere pipe și constă din 1) un șir sub formă de „langstringname, componentname” sau ca text simplu și 2) un URL. Divizoarele pot fi utilizate adăugând o linie de unul sau mai multe # caractere acolo unde se dorește.';
$string['configdbsessions'] = 'Dacă este activată, această setare va utiliza baza de date pentru a stoca informații despre sesiunile curente. Rețineți că modificarea acestei setări va deconecta toți utilizatorii actuali (inclusiv dvs.). Dacă utilizați MySQL, vă rugăm să vă asigurați că „max_allowed_packet” în my.cnf (sau my.ini) este de cel puțin 4M. Alte drivere de sesiune pot fi configurate direct în config.php, consultați config-dist.php pentru mai multe informații. Această opțiune dispare dacă specificați driverul de sesiune în fișierul config.php.';
$string['configdebug'] = 'Dacă activaţi această opţiune, error_reporting din PHP va fi mărit astfel încât să fie afişate mai multe atenţionări. Acest parametru se adresează exclusiv dezvoltatorilor.';
$string['configdebugdisplay'] = 'Dacă activaţi acest parametru, raportarea erorilor va merge la pagina HTML. Aceasta este o variantă practică însă fragmentează XHTML, JS, cookies şi headere HTTP în general. Dacă nu activaţi acest parametru, raportarea erorilor va fi trimisă la logurile serverului, ceea ce va face mai uşoară depanarea. Setarea PHP error_log stabileşte în ce loguri se duce această raportare.';
$string['configdebugpageinfo'] = 'Activați dacă doriți ca informațiile despre pagină să fie afișate în subsolul paginii.';
$string['configdebugvalidators'] = 'Acitivați, dacă doriți să aveți link către servere de validare externe în subsolul paginii. S-ar putea să fie nevoie să creați noi utilizatori cu username <em>w3cvalidator</em>, și să permiteți accesul vizitatorilor. Aceste schimbări pot însă permite accesul neautorizat la server, nu activați accesul pe site-urile de producție!';
$string['configdefaulthomepage'] = 'La ce pagină ar trebui redirecționați utilizatorii după ce se conectează la site? Setarea determină, de asemenea, primul link în navigarea pentru utilizatorii temelor clasice.';
$string['configdefaultrequestcategory'] = 'Cursurile solicitate de utilizatorii care au permisiunea de a solicita cursuri noi în contextul sistemului vor fi plasate în această categorie, cu excepția cazului în care utilizatorii pot selecta o altă categorie.';
$string['configdefaultrequestedcategory'] = 'Categoria implicită în care vor fi plasate automat cursurile solicitate în cazul în care sunt aprobateContinuare.';
$string['configdefaultuserroleid'] = 'Toți utilizatorii conectați vor primi capacitățile rolului pe care îl specificați aici, la nivel de site, în completare la orice alte roluri care li s-ar fi putut acorda. Implicit este rolul de utilizator autentificat. Rețineți că acest lucru nu va intra în conflict cu alte roluri pe care le au, cu excepția cazului în care interziceți capabilitățile, ci doar asigură că toți utilizatorii au capabilități care nu pot fi alocate la nivelul cursului (de exemplu, postați intrări de blog, gestionați propriul calendar etc.).';
$string['configdeleteincompleteusers'] = 'După această perioadă, orice cont fără numele, prenumele sau câmpul de e-mail completat este șters.';
$string['configdeleteunconfirmed'] = 'Pentru anumite metode de autentificare, cum ar fi auto-înregistrarea prin e-mail, utilizatorii trebuie să-și confirme contul într-un anumit timp. După această perioadă, orice cont vechi neconfirmat este șters.';
$string['configdenyemailaddresses'] = 'În cazul în care doriţi să blocaţi mesaje e-mail primite de la adrese din anumite domenii enumeraţi aici domeniile interzise, folosiţi tasta "spaţiu" ca separator. Vor fi admise mesaje e-mail din orice alte domenii decât cele listate. În cazul în care doriţi să includeţi în listă şi sub-domenii adăugaţi numele domeniului precedat de semnul ".".  ex.  <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Dezactivează abilitatea utilizatorilor de a-şi schimba imaginile din profil utilizator.Continuare';
$string['configdisplayloginfailures'] = 'Aceasta va afișa utilizatorilor informații despre conectările anterioare nereușite.';
$string['configdndallowtextandlinks'] = 'Activați sau dezactivați drag and drop pentru texte si link-uri pe o pagină de curs, împreună cu drag și drop pentru fișiere. Rețineți că operațiunea "drag  a unui text în Firefox sau între browsere diferite nu este sigură iar datele pot să nu fie uploadate și textul uploadat să fie corupt.';
$string['configdoclang'] = 'Această limbă va fi utilizată în link-uri pentru paginile de documentare.';
$string['configdocroot'] = 'Definește calea către Moodle Docs pentru furnizarea de documentație specifică contextului prin link-urile „Documentație pentru această pagină” din subsolul fiecărei pagini. Dacă câmpul este lăsat necompletat, link-urile nu vor fi afișate.';
$string['configdoctonewwindow'] = 'Dacă este activat, atunci linkurile către Moodle Docs vor fi afișate într-o fereastră nouă.';
$string['configduration_high'] = 'Această valoare este prea mare. Valoarea maximă este {$a}.';
$string['configduration_low'] = 'Această valoare este prea mică. Valoarea minimă este {$a}.';
$string['configeditordictionary'] = 'Această valoare va fi utilizată dacă aspell nu are un dicţionar pentru limba folosită de utilizatori.';
$string['configeditorfontlist'] = 'Selectaţi fonturile care vor aparea în lista de fonturi din editor.';
$string['configemailchangeconfirmation'] = 'Câmp obligatoriu de confirmare a noii adrese de email atunci când utilizatorii schimbă adresa de email.';
$string['configemaildkimselector'] = 'Selectorul DKIM este arbitrar și înregistrările dvs. DNS trebuie să se potrivească cu aceasta.';
$string['configemailfromvia'] = 'Adăugați prin informații în secțiunea „De la” din e-mailul de ieșire. Aceasta informează destinatarul de unde a venit acest e-mail și, de asemenea, ajută la combaterea destinatarilor care răspund accidental la adresele de e-mail fără răspuns.';
$string['configemailheaders'] = 'Anteturi brute de e-mail pentru a fi adăugate textual la toate e-mailurile trimise.';
$string['configemailsubjectprefix'] = 'Text care urmează să fie pus înainte de linia subiect a tuturor mesajelor trimise.';
$string['configenableactivitychooser'] = 'Selectorul de activitate este o casetă de dialog cu o scurtă descriere a fiecărei activități și resurse. Dacă este dezactivat, sunt furnizate în schimb meniuri derulante separate pentru resurse și activități.';
$string['configenableanalytics'] = 'Modelele analitice, cum ar fi „Cursanții cu risc de abandon” sau „Activitățile viitoare”, pot genera predicții, pot trimite notificări din perspectivă educațională și pot oferi acțiuni suplimentare, cum ar fi trimiterea de mesaje către utilizatori.';
$string['configenableblogs'] = 'Această funcție permite tuturor utilizatorilor site-ului să aibă propriul blog.';
$string['configenablecalendarexport'] = 'Permite exportarea în sau înscrierea la calendare.';
$string['configenablecomments'] = 'Activează comentariile';
$string['configenablecourserequests'] = 'Dacă este activat, utilizatorii cu capacitatea de a solicita cursuri noi (moodle/course:request) vor avea opțiunea de a solicita un curs. Această capacitate nu este permisă pentru niciunul dintre rolurile implicite. Poate fi aplicat în contextul sistemului sau al categoriei.';
$string['configenabledevicedetection'] = 'Permite detectarea de telefoane mobile, smartphone-uri, tablete sau dispozitive implicite (PC-uri desktop, laptop-uri, etc) pentru aplicarea de teme și alte caracteristici.';
$string['configenablemobilewebservice'] = 'Activați serviciul mobil pentru aplicația Moodle oficială sau alte aplicații care îl solicită. Pentru mai multe informații, citiți {$a}';
$string['configenablerssfeeds'] = 'Dacă este activat, fluxurile RSS sunt generate de diferite funcții de pe site, cum ar fi bloguri, forumuri, activități de baze de date și glosare. Rețineți că fluxurile RSS trebuie, de asemenea, să fie activate pentru anumite module de activitate.';
$string['configenablerssfeedsdisabled'] = 'Acest parametru nu este disponibil din cauză că opţiunea Fluxuri RSS a fost dezactivată pentru tot situl. Pentru a o activa accesaţi secţiunea Variabile din Admin Configuration.';
$string['configenablerssfeedsdisabled2'] = 'Fluxurile RSS sunt în prezent dezactivate la nivel de site. Acestea pot fi activate în zona de funcții avansate în administrarea site-ului.';
$string['configenablestats'] = 'Dacă selectaţi "Da" aici, cronjob-ul Moodle va procesa înregistrările activităţii de pe site şi va aduna date statistice. În funcţie de traficul de pe site, această operaţiune poate să dureze mai mult sau mai puţin. Dacă activaţi acest parametru, veţi putea obţine o serie de grafice interesante despre fiecare din cursuri şi despre întregul site.';
$string['configenabletrusttext'] = 'În mod implicit Moodle "curăţă" orice text provenit de la utilizatori pentru a îndepărta orice script, media, etc. ce ar putea constitui un risc de securitate. Sistemul Trusted Content (Conţinut Securizat) este o metodă prin care se permite utilizatorilor de încredere să folosească fără restricţii acest tip de funcţionalităţi avansate. Pentru a activa acest sistem, mai întâi va trebui să activaţi acest parametru şi apoi să acordaţi dreptul Trusted Content (Conţinut Securizat) unui rol din cadrul Moodle. Textele create sau încărcate de utilizatorii cu rolul respectiv vor fi marcate ca fiind "de încredere" şi nu vor fi "curăţate" înainte de afişare.';
$string['configenablewebservices'] = 'Serviciile web permit altor sisteme, cum ar fi aplicația de mobil Moodle, să se conecteze la site și să efectueze operațiuni. Pentru o securitate suplimentară, setarea ar trebui să fie dezactivată dacă nu utilizați aplicația sau un instrument / serviciu extern care necesită integrare prin servicii web.';
$string['configenablewsdocumentation'] = 'Activați auto-generarea de documentație pentru servicii web. Un utilizator poate accesa propria sa documentație pe pagina sa cu cheia de securitate {$a}. Se afișează documentația doar pentru protocoalele activate.';
$string['configerrorlevel'] = 'Selectaţi numărul de avertizări PHP care doriţi să fie afişate. Recomandăm "Normal".';
$string['configexportlookahead'] = 'Zile care trebuie avute în vedere pe viitor în timpul exportului';
$string['configexportlookback'] = 'Zile din trecut care trebuie avute în vedere în timpul exportului';
$string['configextendedusernamechars'] = 'Dacă este activată, numele de utilizator pot include orice caractere, cu excepția literelor mari. În caz contrar, sunt permise numai caractere alfanumerice cu litere mici, subliniere (_), cratimă (-), punct (.) Și simbolul (@).';
$string['configextramemorylimit'] = 'Anumite scripturi ca de exemplu search, backup/restore sau cron necesită mai multă memorie. Setaţi valori mai mari pentru situri de dimensiuni mari.';
$string['configfilterall'] = 'Filtrează toate stringurile inclusiv heading-uri, titluri, bare de navigaţie, etc. Acest parametru este foarte util pentru cazurile în care lucraţi cu filtre multiple (pe mai multe limbi), altfel nu face decât să creeze o încărcare suplimentară a sitului oferind în schimb foarte puţine avantaje.';
$string['configfiltermatchoneperpage'] = 'Filtrele Automatic linking vor genera un unic link pentru prima secvenţă de text găsită în cadrul unei pagini întregi. Restul secvenţelor nu vor fi luate în considerare.';
$string['configfiltermatchonepertext'] = 'Filtrele automate de generare legături vor genera doar un singur link pentru prima instanță de text potrivită găsită în fiecare element de text de pe pagină. Toate celelalte sunt ignorate. Această setare nu are efect dacă „Filtrare potrivire o dată pe pagină” este activată.';
$string['configfilternavigationwithsystemcontext'] = 'Utilizarea implicită a filtrării este în strînsă legătură cu contextul în care e folosit (de exemplu, contextul cursului), dar pentru navigarea pe site, în mod implicit toate filtrele sunt setate la contextul site-ului și se pot aduce îmbunătățiri de performanță atunci când se utilizează filtrarea „conținut și antete”.';
$string['configfilteruploadedfiles'] = 'Procesează cu filtre toate fişierele HTML şi text încărcate înainte de a le afişa, fie doar fişierele HTML încărcate sau niciunul.';
$string['configforcelogin'] = 'În mod normal, pagina de start a site-ului și listele de cursuri (dar nu și cursurile) pot fi citite de oameni fără a se autentifica pe site. Dacă doriți să forțați oamenii să se conecteze înainte de a face ORICE pe site, atunci ar trebui să activați această setare.';
$string['configforceloginforprofiles'] = 'Această setare îi obligă pe oameni să se conecteze ca un cont real (non-guest) înainte de a vizualiza profilul oricărui utilizator. Dacă ați dezactivat această setare, este posibil să constatați că unii utilizatori postează reclame (spam) sau alt conținut neadecvat în profilurile lor, care sunt apoi vizibile pentru oricine.';
$string['configfrontpage'] = 'Articolele selectate mai sus vor fi afișate pe pagina de pornire a site-ului.';
$string['configfrontpagecourselimit'] = 'Numărul maxim de cursuri';
$string['configfrontpagecourselimithelp'] = 'Numărul maxim de cursuri care urmează să fie afișate pe pagina principală a site-ului în listele de cursuri.';
$string['configfrontpageloggedin'] = 'Elementele selectate mai sus vor fi afișate pe pagina de pornire a site-ului atunci când un utilizator este conectat.';
$string['configfullnamedisplay'] = 'Definește modul în care sunt afișate numele atunci când sunt afișate în întregime. Valoarea implicită, „language”, va afișa confom cu setarea șirului „fullnamedisplay” din pachetul de limbă curent pentru a decide. Unele limbi au convenții de afișare a numelor diferite.

Pentru majoritatea site-urilor monolingve, cea mai eficientă setare este „Prenume Nume”, dar puteți alege să ascundeți numele de familie. Substituenții care pot fi utilizați sunt: prenume, nume, prenume-fonetic, nume fonetic, nume de botez și nume alternativ.';
$string['configgeoipfile'] = 'Locația fișierului de date binare GeoLite2 City. Acest fișier nu face parte din distribuția Moodle și trebuie obținut separat de <a href="https://www.maxmind.com/"> MaxMind </a>. Puteți cumpăra o versiune comercială sau puteți folosi versiunea gratuită. Va trebui să vă înregistrați pentru a descărca fișierul bazei de date City, pe care îl puteți face la <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/"> https://dev.maxmind.com/geoip/geoip2/geolite2 / </a>. După ce ați înregistrat și descărcat fișierul, extrageți-l în directorul „{$a}” de pe server.';
$string['configgetremoteaddrconf'] = 'În cazul în care serverul dumneavoastră foloseşte un proxy, puteţi folosi acest parametru pentru a specifica anume care headere HTTP sunt de încredere şi pot să conţină adresa IP remote. Headerele vor fi citite în ordine şi se va folosi primul header care este disponibil.';
$string['configgradebookroles'] = 'Acest parametru vă permite să stabiliţi care sunt utilizatorii ale căror nume pot apărea în catalog. Pentru ca numele unui utilizator să apară în catalog, utilizatorul respectiv trebuie să aibă cel puţin unul din aceste roluri.';
$string['configgradeexport'] = 'Selectaţi formatele pe care le veţi folosi cel mai des în cadrul operaţiunii de export a catalogului. Plugin-urile selectate vor fi afişate în câmpurile "exportat în" corespunzătoare fiecărei note. În consecinţă, în funcţie de formatul de export ales, înregitrările fiecărei note vor fi marcate ca "nou" sau "actualizat". Dacă nu sunteţi sigur ce setare să realizaţi aici, nu selectaţi nicio opţiune.';
$string['confighiddenuserfields'] = 'Alegeţi câmpurile cu informaţii despre utilizatori pe care doriţi să le ascundeţi de alţi utilizatori în afară de profesori/administratori. Acest parametru permite setarea unui nivel de confidenţialitate crescut pentru informaţiile cursanţilor. Pentru selectarea mai multor câmpuri folosiţi tasta CTRL.';
$string['configidnumber'] = 'Această opţiune stabileşte următoarele (a)Dacă utilizatorilor li se solicită un număr identificator, (b)dacă utilizatorilor li se solicită un număr identificator dar aceştia nu sunt obligaţi să-l completeze (c)dacă utilizatorilor li se solicită un număr identificator pe care sunt obligaţi să-l completeze. În cazul în care utilizatorilor le este atribuit un identificator, acesta va fi afişat în cadrul Profilului.';
$string['configintro'] = 'În cadrul acestei pagini aveţi posibilitatea să specificaţi un număr de variabile cu ajutorul cărora Moodle va funcţiona corect pe serverul dumneavoastră. Nu acordaţi acum prea multă importanţă setării acestor parametri - în mod normal funcţionează foarte bine cu valorile implicite şi dacă doriţi puteţi oricând să reveniţi şi să modificaţi aceşti parametri în funcţie de necesităţi.';
$string['configintroadmin'] = 'În cadrul acestei pagini puteţi să configuraţi contul principal de administrator al sitului care va avea control deplin asupra acestuia. Asiguraţi-vă că introduceţi o combinaţie corectă şi sigură de nume utilizator/parolă şi că furnizaţi o adresă de email corectă. Ulterior veţi putea crea mai multe conturi de administratori.';
$string['configintrosite'] = 'Această pagină vă permite să configurați pagina de pornire a site-ului și numele acestui nou site. Puteți reveni aici mai târziu pentru a modifica aceste setări oricând folosind meniurile Administrare.';
$string['configiplookup'] = 'Atunci când executaţi clic pe o adresă IP (ca de exemplu 34.12.222.93) din cadrul logurilor se va afişa o hartă cu cea mai probabilă locaţie a respectivului IP. Pentru afişarea acestei informaţii puteţi alege dintre mai multe plugin-uri, fiecare cu avantajele şi dezavantajele corespunzătoare.';
$string['configkeeptagnamecase'] = 'Activaţi această opţiune dacă doriţi ca numele de etichete introduse de utilizatori să se păstreze aşa cum au fost ele introduse de utilizatori (combinaţia originală de majuscule şi litere mici).';
$string['configlang'] = 'Alegeți o limbă implicită pentru întregul site. Utilizatorii pot înlocui această setare folosind meniul de limbă sau setarea din profilul personal.';
$string['configlanglist'] = 'Dacă este lăsată necompletată, toate limbile instalate pe site vor fi afișate în meniul de limbă. Alternativ, meniul de limbă poate fi scurtat prin introducerea unei liste de coduri de limbă separate prin virgule, de ex. en, de, fr. Dacă se dorește, se poate specifica un nume diferit pentru limba decât numele pachetului lingvistic utilizând formatul: codul limbii | numele limbii, de ex. en_kids | Engleză, de_kids | Deutsch.';
$string['configlangmenu'] = 'Alegeţi dacă doriţi să afişaţi meniul de localizare generică în pagina principală, în pagina de logare, etc. Setarea acestui parametru nu afectează posibilitatea ca utilizatorul să-şi aleagă limba în care doreşte să fie afişată interfaţa, din cadrul profilului.';
$string['configlangstringcache'] = 'Cache pentru toate succesiunile lingvistice în fișiere compilate din directorul de date. Dacă traduceți Moodle sau modificați succesiunile de caractere în codul sursă Moodle, atunci poate doriți să schimbați setarea. În caz contrar, lăsați neschimbată această setare pentru a vedea beneficiile de performanță.';
$string['configlatinexcelexport'] = 'Selectaţi codarea pentru operaţiunile de export în Excel.';
$string['configlocale'] = 'Selectaţi o localizare pentru întregul sit - acest parametru va anula orice ale setări de afişare a datelor sau de limbă pentru toate versiunile de localizare a interfeţei (numele zilelor din calendar nu sunt afectate). Trebuie ca localizarea respectivă să fie instalată pe sistemul dumneavoastră de operare (de exemplu pentru Linux en_US.UTF-8 sau es_ES.UTF-8). De cele mai multe ori nu trebuie să setaţi nicio valoare pentru acest parametru.';
$string['configlockrequestcategory'] = 'Dacă este activat, utilizatorii cu capacitatea de a solicita cursuri noi în contextul sistemului nu vor putea selecta o categorie în formularul de solicitare a unui nou curs. O modalitate alternativă de a restricționa utilizatorii la solicitarea unui curs nou într-o singură categorie este aplicarea capacității de a solicita cursuri noi în contextul categoriei.';
$string['configloglifetime'] = 'Acest parametru specifică perioada de timp pentru care doriţi să păstrați înregistrările despre activitatea unui utilizator. Înregistrările mai vechi de perioada setată aici vor fi şterse automat. Se recomandă păstrarea înregistrărilor pentru o perioadă cât mai lungă de timp pentru eventualitatea în care veţi avea nevoie de ele, însă, dacă serverul dumneavoastră este foarte solicitat şi prezintă probleme de performanţă atunci este imdicat să setaţi o valoare mai mică pentru acest parametru. Nu se recomandă alegerea unor valori mai mici de 30 deoarece acest lucru poate afecta modul de creare al statisticilor.';
$string['configlookahead'] = 'Zile anticipare';
$string['configmailnewline'] = 'Newline characters used in mail messages. CRLF is required according to RFC 822bis, some mail servers do automatic conversion from LF to CRLF, other mail servers do incorrect conversion from CRLF to CRCRLF, yet others reject mails with bare LF (qmail for example). Try changing this setting if you are having problems with undelivered emails or double newlines.';
$string['configmaxbytes'] = 'Aceasta specifică o dimensiune maximă pentru fișierele încărcate pe site. Această setare este limitată de setările PHP post_max_size și upload_max_filesize, precum și de setarea Apache LimitRequestBody. La rândul său, maxbytes limitează gama de dimensiuni care pot fi alese la nivel de curs sau de activitate. Dacă se alege „Limita de încărcare a site-ului”, va fi utilizată dimensiunea maximă permisă de server.';
$string['configmaxconsecutiveidentchars'] = 'Parolele nu trebuie să aibă mai mult de acest număr de caractere consecutive identice. Utilizați 0 pentru dezactivare.';
$string['configmaxeditingtime'] = 'Acest parametru specifică intervalul de timp pe care utilizatorii îl au la dispoziţie pentru a modifica intervenţiile realizate pe forum, în glosar, comentarii, etc. Se recomandă folosirea valorii 30 minute.';
$string['configmaxevents'] = 'Evenimente de ținut cont în viitor';
$string['configmaxusersperpage'] = 'Numărul maxim de utilizatori afișați în selectoul unui curs, grup, cohortă, webservice, etc.';
$string['configmessaging'] = 'Dacă este activat, utilizatorii pot trimite mesaje către alți utilizatori de pe site.';
$string['configmessagingallowemailoverride'] = 'Permite utilizatorilor să primească notificări prin email trimise la o altă adresă de email decât cea de la profil.';
$string['configmessagingallusers'] = 'Dacă este activată, utilizatorii pot vizualiza lista tuturor utilizatorilor de pe site atunci când selectează pe cineva pentru care să trimită mesaje, iar preferințele acestora includ opțiunea de a accepta mesaje de la oricine de pe site. Dacă sunt dezactivate, utilizatorii pot vizualiza doar lista de utilizatori din cursurile lor și au doar două opțiuni în preferințele pentru mesaje - să accepte mesaje numai din contactele lor, sau din contactele lor și de la oricine din cursurile lor.';
$string['configmessagingdefaultpressenter'] = 'Dacă "Utilizați enter pentru a trimite" este activat implicit în setările mesajelor utiizatorilor.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Anunțurile citite și necitite pot fi șterse pentru a economisi spațiu. La cât timp după ce a fost creat un anunț acesta poate fi șters?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Notificările citite pot fi șterse pentru a avea mai mult spațiu. După cât timp de când a fost citită, poate fi ștearsă?';
$string['configminpassworddigits'] = 'Parolele trebuie să conțină minim atâtea cifre.';
$string['configminpasswordlength'] = 'Parolele trebuie să aibă minim atâtea caractere lungime.';
$string['configminpasswordlower'] = 'Parolele trebuie să aibă minim atâtea litere minuscule.';
$string['configminpasswordnonalphanum'] = 'Parolele trebuie să aibă minim atâtea caractere non-alfanumerice.';
$string['configminpasswordupper'] = 'Parolele trebuie să aibă minim atâtea litere majuscule.';
$string['configmodchooserdefault'] = 'Selectorul de activitate ar trebui să fie prezentat utilizatorilor în mod implicit?';
$string['configmycoursesperpage'] = 'Numărul maxim de cursuri ce vor fi afişate în lista de cursuri a unui utilizator';
$string['configmymoodleredirect'] = 'Această setare obligă redirecționarea la /my on login pentru non-administratori și înlocuiește top navigarea top level  cu /al meu';
$string['configmypagelocked'] = 'Această setare previne ca pagina implicită să fie editată de persoane care nu sunt administratori.';
$string['confignavcourselimit'] = 'Limită numărul de cursuri afișate utilizatorului în navigare.';
$string['confignavshowallcourses'] = 'Această setare determină dacă utilizatorii care sunt înscriși la cursuri pot vedea Cursurile (afișează toate cursurile) în navigare, în plus față de Cursurile mele (afișează cursurile la care sunt înscriși).';
$string['confignavshowcategories'] = 'Afișează categoriile de curs în bara de navigare și blocurile de navigare. Acest lucru nu se întîmplă la cursurile la care utilizatorul este în prezent înscris, acestea vor fi în continuare afișate sub mycourses fără categorii.';
$string['confignoreplyaddress'] = 'Uneori se trimit în exterior mesaje email în numele unui utilizator (ex. intervenţiile pe forum). Adresa de email pe care o specificaţi aici va fi completată în câmpul "De la" în toate cazurile când destinatarii mesajelor nu trebuie să poată răspunde direct utilizatorului trimiţător (ex. atunci când un utilizator nu doreşte afişarea adresei sale de email).';
$string['confignotifyloginfailures'] = 'Trimiteți mesaje de notificare de eroare la conectarea în site către acești utilizatori selectați. Acest lucru necesită activarea unui jurnal intern (de ex. Jurnal standard).';
$string['confignotifyloginthreshold'] = 'În cazul în care s-a activat funcţionalitatea de atenţionare în caz de logare ne-reuşită, câte tentative de logare a unui utilizator sau de la o adresă IP sunt admise înainte de a trimite notificarea?';
$string['confignotloggedinroleid'] = 'Utilizatorii care nu sunt logaţi pe site vor fi consideraţi ca având acest rol pe întregul site. Rolul pe care recomandăm să-l completaţi aici este cel de "utilizator vizitator" dar aveţi posibilitatea să introduceţi aici şi roluri create de dumneavoastră şi care sunt mai mult sau mai puţin restrictive. Pentru alte acțiuni, de exemplu crearea de postări, vor trebui să se logheze.';
$string['configopentowebcrawlers'] = 'Dacă activaţi acest parametru , Google va putea intra pe site-ul dumneavoastră ca utilizator vizitator. Mai mult, utilizatorii care au găsit site-ul dumneavoastră prin intermediul unei căutări Google vor putea accesa automat site-ul ca utilizatori vizitatori. Atenţie, utilizatorii de acest tip vor putea accesa doar cursurile care permit accesul utilizatorilor vizitatori.';
$string['configoverride'] = 'Definit în config.php';
$string['configpasswordpolicy'] = 'Dacă este activată, parolele utilizatorului vor fi verificate în raport cu politica de parole, așa cum este specificat în setările de mai jos. Activarea politicii de parolă nu va afecta utilizatorii existenți până când nu vor decide sau vor fi obligați să își schimbe parola sau dacă setarea „Verificați parola la autentificare” este activată.';
$string['configpasswordpolicycheckonlogin'] = 'Dacă este activată, parolele utilizatorului vor fi verificate în raport cu politica de parole de fiecare dată când utilizatorii se conectează. Dacă verificarea eșuează, utilizatorul va fi obligat să își schimbe parola înainte de a continua.
Este util să activați această setare după actualizarea politicii de parolă.';
$string['configpasswordresettime'] = 'Specifică timpul pe care persoanele  îl au pentru a valida o cerere de resetare a parolei înainte de a expira. De obicei, 30 de minute este o valoare potrivită.';
$string['configpathtodu'] = 'Calea către du. Cel mai probabil aceasta se prezintă sub forma /usr/bin/du. Dacă setaţi acest parametru, paginile care afişează conţinutul unui director cu multe fişiere se vor încărca mult mai repede.';
$string['configpathtophp'] = 'Calea către PHP CLI. Probabil ceva de genul /usr/bin/php. Dacă introduceți acest lucru, script-urile cron pot fi executate din interfața web admin.';
$string['configperfdebug'] = 'Dacă activaţi acest parametru, informaţiile despre performanţă vor fi afişate în partea de jos a temei standard.';
$string['configprofileroles'] = 'Lista de roluri care sunt vizibile pe profilurile utilizatorului și pagina de participare.';
$string['configprofilesforenrolledusersonly'] = 'Pentru a preveni utilizarea sitului de către spammeri, descrierile din profilul unui utilizator care nu s-a înscris la niciun curs nu sunt afişate. Utilizatorii noi va trebui să se înscrie la cel puţin un curs înainte de a-şi putea completa informaţiile dorite în Profil.';
$string['configprotectusernames'] = 'Dacă este activat, formularul de recuperare parolă nu va afișa niciun fel de sugestii care să permită ghicirea numelor de utilizator sau adreselor de e-mail ale contului.';
$string['configproxybypass'] = 'Listă de nume de gazde (parțiale) sau IP-uri separate prin virgulă, care ar trebui să evite proxy (de exemplu, 192.168., .domeniulmeu.ro)';
$string['configproxyfixunsafe_help'] = 'Aceasta încearcă să repare apelurile interne care nu trec prin proxy, adăugând agentul utilizator MoodleBot și folosind proxy-ul.';
$string['configproxyhost'] = 'În cazul în care acest <b>server</b> are nevoie de un computer proxy computer (eg un firewall) pentru a accesa Internetul, completaţi aici proxy hostname. Altfel nu completaţi nimic.';
$string['configproxylogunsafe_help'] = 'Aceasta încearcă să înregistreze apelurile interne care nu trec prin proxy și ar trebui.';
$string['configproxypassword'] = 'Password needed to access internet through proxy if required, empty if none (PHP cURL extension required).';
$string['configproxyport'] = 'În cazul în care acest server trebuie să folosească un computer proxy, completaţi aici portul proxy.';
$string['configproxytype'] = 'Tipul de web proxy (extensii PHP5 şi cURL obligatorii pentru suport SOCKS5)';
$string['configproxyuser'] = 'Username needed to access internet through proxy if required, empty if none (PHP cURL extension required).';
$string['configrecaptchaprivatekey'] = 'Șir de caractere (cheie secretă) utilizat pentru a comunica între serverul dvs. Moodle și serverul recaptcha. Cheile ReCAPTCHA pot fi obținute de la <a target="_blank" href="https://www.google.com/recaptcha"> Google reCAPTCHA </a>.';
$string['configrecaptchapublickey'] = 'Șir de caractere (cheia site-ului) utilizat pentru afișarea elementului reCAPTCHA în formularul de înscriere și formularul de asistență pentru site. Cheile ReCAPTCHA pot fi obținute de la <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Cuvântul folosit pentru cursant în cadrul cursurilor solicitate.';
$string['configrequestedstudentsname'] = 'Cuvântul folosit pentru cursanţi în cadrul cursurilor solicitate.';
$string['configrequestedteachername'] = 'Cuvântul folosit pentru profesor în cadrul cursurilor solicitate.';
$string['configrequestedteachersname'] = 'Cuvântul folosit pentru profesori în cadrul cursurilor solicitate.';
$string['configreverseproxyignore'] = 'Dacă serverul dvs. se află în spatele mai multor proxy-uri inverse care se atașează la antetul X-Forwarded-For, atunci specificați o listă separată prin virgulă a adreselor IP sau a subrețelor proxy-urilor inverse care trebuie ignorate pentru a găsi adresa IP corectă a utilizatorului.';
$string['configsectioninterface'] = 'Interfață';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Mentenanţă';
$string['configsectionmisc'] = 'Diverse';
$string['configsectionoperatingsystem'] = 'Sistem de operare';
$string['configsectionpermissions'] = 'Permisiune';
$string['configsectionrequestedcourse'] = 'Cereri curs';
$string['configsectionsecurity'] = 'Securitate';
$string['configsectionstats'] = 'Statistici';
$string['configsectionuser'] = 'Utilizator';
$string['configsecureforms'] = 'Moodle poate utiliza un nivel suplimentar de securitate atunci când acceptă date din formulare web. Dacă aceasta este activată, variabila HTTP_REFERER a browserului este verificată în raport cu adresa curentă a formularului. În foarte puține cazuri acest lucru poate provoca probleme dacă utilizatorul folosește un firewall (de exemplu, Zonealarm) configurat pentru a dezinstala HTTP_REFERER din traficul web. Simptomele sunt atunci când se blochează un formular. Dacă utilizatorii dvs. întâmpină probleme cu pagina de conectare (de exemplu), este posibil să doriți să dezactivați această setare, deși este posibil ca site-ul dvs. să fie mai deschis pentru atacurile la parole de tip forță brută. Dacă aveți îndoieli, lăsați această setare la "Da".';
$string['configservicespage'] = 'Inserează adresa URL a unei pagini de servicii și asistență sau lasă necompletat pentru link către serviciile Moodle pe moodle.com. Link-ul este afișat numai pentru administratorii site-ului.';
$string['configsessioncookie'] = 'Acest parametru permite personalizarea cookie-ului folosit pentru sesiunile Moodle. Este un parametru opţional şi este util pentru diferenţierea cookie-urilor în caz că există mai multe instanţe (cópii) Moodle care rulează pe acelaşi sit Web.';
$string['configsessioncookiedomain'] = 'Acest parametru permite modificarea domeniilor din care sunt acceptate cookie-uri Moodle. Acest parametru este folositor în cazul customizărilor Moodle (pluginuri de autenificare sau de înscriere) care trebuie să partajeze informaţii despre sesiunea Moodle cu o altă aplicaţie Web sau cu un alt subdomeniu. <strong>ATENŢIE: recomandarea noastră este să lăsaţi valoarea implicită pentru acest parametru (necompletat) deoarece o valoare incorectă poate bloca situl şi nu va mai permite logarea niciunui utilizator.</strong>';
$string['configsessioncookiepath'] = 'Dacă doriţi să schimbaţi locaţia unde browserele trimit cookie-urile Moodle, folosiţi acest parametru pentru a specifica un subdirector din cadrul sitului dumneavoastră web. În caz contrar, lăsaţi valoarea implicită "/".';
$string['configsessiontimeout'] = 'Dacă utilizatorii logaţi în acest sit sunt inactivi pentru o perioadă de timp (nu încarcă pagini) atunci ei vor fi automat de-logaţi (terminarea  automată a sesiunii). Acest parametru specifică mărimea perioadei de timp menţionate.';
$string['configsessiontimeoutwarning'] = 'Dacă persoanele conectate la acest site rămân inactive pentru o perioadă lungă de timp (fără a încărca alte pagini), atunci sunt avertizate că sesiunea lor este pe cale să se încheie. Această variabilă specifică cât timp ar trebui să fie acest interval.';
$string['configsessiontimeoutwarningcheck'] = 'Avertismentul privind expirarea sesiunii trebuie să fie mai mic decât expirarea sesiunii';
$string['configshowcommentscount'] = 'Afișează numărul de comentarii, va necesita încă o interogare atunci când se afișează link-ul cu comentarii';
$string['configshowicalsource'] = 'Arată sursa informației pentru evenimente iCal';
$string['configshowsiteparticipantslist'] = 'Toţi cursanţii şi profesorii din cadrul acestui sit vor fi afişaţi în cadrul unei liste cu participanţii la sit. Cine are permisiunea să vizualizeze lista cu participanţii la sit?';
$string['configsitedefaultlicense'] = 'Licența implicită a site-ului';
$string['configsitedefaultlicensehelp'] = 'Licența implicită pentru publicarea de conținut pe acest site';
$string['configsitemailcharset'] = 'Toate mesajele email generate de situl dumneavoastră vor folosi charset specificat aici. Această setare va putea fi modificată de fiecare utilizator în parte dacă se activează şi următorul parametru.';
$string['configsitemaxcategorydepth'] = 'Adâncimea maximă a categoriei';
$string['configsitemaxcategorydepthhelp'] = 'Aceasta specifică adâncimea maximă a categoriilor copil extinse la afișarea categoriilor sau a listei combinate. Categoriile de nivel mai profund vor apărea ca linkuri și utilizatorul le poate extinde făcând clic pe ele.';
$string['configslasharguments'] = '„Argumentele slash” (folosind <em> PATH_INFO </em>) sunt necesare pentru ca pachetele SCORM și resursele cu mai multe fișiere să fie afișate corect. Dacă serverul dvs. web nu acceptă „argumente slash” și nu puteți să-l configurați, această setare poate fi dezactivată, deși va face ca unele lucruri să nu funcționeze. <br /> Notă: Utilizarea „argumente slash” va fi necesar în viitoarele versiuni ale Moodle.';
$string['configsmartpix'] = 'La activarea acestui parametru imaginile se vor încărca prin intermediul unui script PHP care va căuta tema curentă, apoi toate temele principale şi apoi în folderul Moodle /pix. Activarea acestui parametru reduce necesitatea duplicării fişierelor imagine în cadrul temelor, însă influenţează oarecum performanţa.';
$string['configsmtpauthtype'] = 'Se setează tipul de autentificare pentru a fi utilizat pe serverul SMTP.';
$string['configsmtphosts'] = 'Completaţi aici numele complet al unuia sau mai multor servere SMTP locale pe care Moodle le poate folosi pentru a trimite mesaje de email. (ex. \'mail.a.com\' sau \'mail.a.com;mail.b.com\'). Dacă doriţi să specificaţi un alt port față de portul implicit (25) puteţi folosi sintaxa [server]:[port] (ex. \'mail.a.com:587\'). Pentru conexiuni securizate, portul 465 este utilizat de obicei cu SSL, portul 587 este utilizat de obicei cu TLS, specifica-ți protocolul de securitate mai jos, dacă este necesar. Dacă nu completaţi nimic în acest câmp Moodle va folosi metoda PHP implicită pentru trimiterea de mesaje email.';
$string['configsmtpmaxbulk'] = 'Numărul maxim de mesaje care pot fi trimise în cadrul unei singure sesiuni SMTP. Gruparea mesajelor poate mări viteza de transmitere a email-urilor. Dacă introduceţi valori mai mici de 2, pentru fiecare mesaj email trimis se va crea o nouă sesiune SMTP.';
$string['configsmtpoauthservice'] = 'Selectați serviciul OAuth 2 care este configurat pentru a comunica cu serverul SMTP. Dacă serviciul nu există încă, va trebui să-l creați. Rețineți că trebuie să setați tipul de autentificare SMTP la XOAUTH2.';
$string['configsmtpsecure'] = 'Dacă serverul smtp necesită conexiune securizată, specificați tipul corect de protocol.';
$string['configsmtpuser'] = 'În cazul în care aţi specificat un server SMTP în câmpurile de mai sus, şi dacă serverul respectiv solicită autentificare completaţi aici numele de utilizator şi parola.';
$string['configstartwday'] = 'Începutul săptămânii';
$string['configstatsfirstrun'] = 'This specifies how far back the logs should be processed <b>the first time</b> the cronjob wants to process statistics. If you have a lot of traffic and are on shared hosting, it\'s probably not a good idea to go too far back, as it could take a long time to run and be quite resource intensive. (Note that for this setting, 1 month = 28 days. In the graphs and reports generated, 1 month = 1 calendar month.)';
$string['configstatsmaxruntime'] = 'Stats processing poate fi un proces destul de solicitant, de aceea recomandăm să folosiţi o combinaţie între acest câmp şi câmpul următor pentru a stabili când începe şi cât timp durează rularea Stats.';
$string['configstatsmaxruntime2'] = 'Stats processing poate fi un proces destul de solicitant, specificaţi intervalul maxim în care se pot culege date pentru o zi de statistics. Numărul maxim de zile procesate la executarea unui cron este de 31.';
$string['configstatsmaxruntime3'] = 'Aceasta specifică timpul maxim permis pentru calcularea statisticilor pentru o zi, ținând cont de faptul că procesarea statisticilor poate pune o încărcătură mare pe server. Numărul maxim de zile procesate într-un cron poate fi specificat mai jos.';
$string['configstatsruntimedays'] = 'Aceasta specifică numărul maxim de zile procesate în fiecare execuție a statisticilor. Odată ce statisticile sunt actualizate, va fi procesată doar o zi, așa că ajustați această valoare în funcție de încărcarea serverului dvs., reducând-o dacă sunt necesare execuții cron mai scurte.';
$string['configstatsruntimestart'] = 'La ce oră trebuie să înceapă cronjob-ul care începe procesarea statisticilor? Se recomandă specificarea orelor diferite dacă există mai multe site-uri Moodle pe un server.';
$string['configstatsuserthreshold'] = 'Această setare specifică numărul minim de utilizatori înscriși pentru un curs care să fie inclus în calculele statistice.';
$string['configstrictformsrequired'] = 'Dacă este activată, utilizatorii nu pot să insereze un spațiu sau un sfârșit de linie decât în câmpurile obligatorii, în forme.';
$string['configstripalltitletags'] = 'Dezactivaţi acest parametru pentru a permite folosirea tagurilor HTML în numele activităţilor şi ale resurselor.';
$string['configsupportavailability'] = 'Determină cine are acces să contacteze asistența site-ului din subsol.';
$string['configsupportemail'] = 'Dacă SMTP este configurat pe acest site și nu este setată o pagină de asistență, această adresă de e-mail va primi mesaje trimise prin intermediul formularului de asistență. Dacă trimiterea eșuează, adresa de e-mail va fi afișată utilizatorilor conectați.';
$string['configsupportname'] = 'Numele persoanei sau a altei entități care oferă asistență prin intermediul formularului de asistență sau al paginii de asistență.';
$string['configsupportpage'] = 'Introduceți adresa URL a unei pagini de asistență sau lăsați necompletat pentru a afișa un formular de contact. Linkul este afișat în subsolul site-ului.';
$string['configtempdatafoldercleanup'] = 'Elimină fișierele de date temporare din folderul de date care sunt mai vechi decât perioada selectată.';
$string['configthemedesignermode'] = 'În mod normal, toate imaginile tematice și stilul foilor sunt salvate sub formă de cache în browsere și pe server pentru o foarte lungă perioadă de timp, pentru performanță. Dacă dumneavoastră concepeți teme sau dezvoltați coduri, atunci probabil că doriți să activați acest mod, astfel încât să nu aveți versiuni cache. Avertizare: acest lucru va face site-ul dumneavoastră mai lent pentru toți utilizatorii! Alternativ, puteți reseta, de asemenea, manual, temele cache  de pe pagina de selecție Teme.';
$string['configthemelist'] = 'Lasați necompletat, dacă doriţi ca orice temă validă să poată fi folosită. Dacă doriţi să reduceţi dimensiunile listei cu teme disponibile, completaţi aici o listă cu numele dorite, folosiţi virgula ca separator (Atenţie!: nu folosiţi spaţii). Iată un exemplu de listă: standard,orangewhite.';
$string['configtimezone'] = 'Acesta este fusul orar implicit pentru afișarea datelor - fiecare utilizator poate înlocui această setare în profilul său. Sarcinile Cron și alte setări ale serverului sunt specificate în acest fus orar. Ar trebui să modificați setarea dacă apare ca „Fus orar nevalid”';
$string['configuseblogassociations'] = 'Utilizatorii ar trebui să poată organiza blog-ul lor prin asocierea de postări cu  cursuri și module de curs?';
$string['configusesitenameforsitepages'] = 'Dacă este activat, shortname-ul site-ului va fi utilizate pentru nodul paginilor site-ului în navigarea, nu în seria "Pagini site"';
$string['configusetags'] = 'Activează funcţionalitatea etichetelor pentru întregul site?';
$string['configvariables'] = 'Variabile';
$string['configverifychangedemail'] = 'Permite verificarea adreselor de email la schimbarea acestora cu ajutorul setării de domenii admise/domenii interzise. Dacă dezactivaţi această setare, domeniile vor fi obligatorii doar pentru utilizatorii nou înregistraţi.';
$string['configvisiblecourses'] = 'Cursurile din categoriile ascunse se afişează normal.';
$string['configwarning'] = 'Atenţie la modificarea acestor parametri - setarea unor valori greşite poate cauza probleme.';
$string['configyuicomboloading'] = 'Această opțiune permite optimizarea încărcării fișierelor combinate pentru bibliotecile YUI. Această setare ar trebui să fie activată pe site-uri de producție din motive de performanță.';
$string['confirmation'] = 'Confirmare';
$string['confirmcontextlock'] = '{$a->contextname} este în prezent deblocat. Blocarea acestuia îl va face accesibil doar pentru citire și va împiedica utilizatorii să facă modificări. Sigur doriți să continuați?';
$string['confirmcontextunlock'] = '{$a->contextname} este în prezent blocat. Deblocarea acestuia va permite utilizatorilor să facă modificări. Sigur doriți să continuați?';
$string['confirmdeletecomments'] = 'Ești sigur că vrei să ștergi comentariul (comentariile) selectate?';
$string['confirmed'] = 'Confirmat';
$string['contactsitesupport'] = 'Contactați serviciul de asistență';
$string['contenttypeuninstalling'] = 'Sunt {$a->count} conținuturi acceptate de {$a->type}. Vor fi șterse. Sigur doriți să începeți?';
$string['contextlockappliestoadmin'] = 'Înghețarea contextelor se aplică administratorilor';
$string['contextlockappliestoadmin_desc'] = 'Dacă este dezactivat, administratorii rămân cu acces la scriere pentru orice contexte înghețate.';
$string['contextlocking'] = 'Context înghețat';
$string['contextlocking_desc'] = 'Această setare permite accesarea numai pentru citire pentru categoriile, cursurile, activitățile sau blocurile selectate.';
$string['cookiehttponly'] = 'Doar cookie-uri http';
$string['cookiesecure'] = 'Doar cookie-uri securizate';
$string['country'] = 'Ţara implicită';
$string['course_customfield'] = 'Câmpuri personalizate de curs';
$string['coursecolor'] = 'Culoare {$a}';
$string['coursecolorheading_desc'] = 'Cursurile care nu au o imagine a cursului adăugată în setările cursului sunt afișate pe tabloul de bord cu un card de curs implicit. Culorile utilizate în model pot fi specificate mai jos.';
$string['coursecolorsettings'] = 'Culorile cardurilor de curs';
$string['coursecontact'] = 'Manageri cursuri';
$string['coursecontact_desc'] = 'Acest parametru vă permite să stabiliţi care sunt utilizatorii care apar în descrierea cursului. Pentru ca un utilizator să apară în descrierea unui curs trebuie să aibă cel puţin unul din aceste roluri în cadrul cursului respectiv.';
$string['coursecontactduplicates'] = 'Afișează toate rolurile de contact ale cursului';
$string['coursecontactduplicates_desc'] = 'Dacă este activată, utilizatorii cu mai mult de unul din rolurile de contact ale cursurilor selectate vor fi afișați în descrierea cursului cu fiecare dintre rolurile lor. În caz contrar, ei vor fi afișați cu un singur rol (oricare dintre acestea este afișat prioritar în "Definiți roluri" în administrarea site-ului).';
$string['coursecreationguide'] = 'Adresa URL a ghidului pentru crearea unui curs Moodle';
$string['coursecreationguide_help'] = 'Definește calea către un ghid de pornire rapidă cu videoclipuri scurte și sfaturi generale pentru a crea cursuri. Un link către ghid este afișat pe pagina Cursurile mele atunci când nu se găsesc cursuri de afișat. Numai utilizatorii cu capabilitatea de a crea cursuri vor vedea acest link.';
$string['coursegraceperiodafter'] = 'Perioada de grație pentru cursurile trecute';
$string['coursegraceperiodbefore'] = 'Perioada de grație pentru cursurile viitoare';
$string['courselistshortnames'] = 'Afișa denumirea extinsă ale cursurilor';
$string['courselistshortnames_desc'] = 'Dacă este activată această funcție, denumirile prescurtate ale cursurilor vor fi afișate în plus față de numele complete din listele de curs. Dacă este necesar, numele extinse ale cursurilor pot fi personalizate prin editarea șirului "courseextendednamedisplay" utilizând funcția de personalizare limbă.';
$string['coursemgmt'] = 'Administrați cursurile și categoriile';
$string['courseoverview'] = 'Cursurile mele';
$string['coursepage'] = 'Pagină curs';
$string['courserequestnotify'] = 'Notificare solicitare curs';
$string['courserequestnotifyemail'] = '{$a->user} a solicitat un curs nou {$a->link}';
$string['courserequests'] = 'Cereri curs';
$string['courserequestspending'] = 'Solicitări de cursuri nerezolvate';
$string['courses'] = 'Cursuri';
$string['coursesperpage'] = 'Cursuri pe pagină';
$string['courseswithsummarieslimit'] = 'Cursuri cu limită de rezumate';
$string['creatornewroleid'] = 'Rolul creatorului de curs în noile cursuri';
$string['creatornewroleid_help'] = 'În cazul în care utilizatorul nu are deja permisiunea de a gestiona noul curs, utilizatorul este inscris automat folosind acest rol.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Activează cron';
$string['cron_enabled_desc'] = 'Cron ar trebui să fie activat în mod normal, cu toate acestea această setare permite dezactivarea temporară a acestuia, de exemplu înainte de repornirea serverului. Dacă este dezactivat, sistemul este împiedicat să înceapă noi sarcini de fundal. Rețineți că cronul nu ar trebui să fie dezactivat pentru o lungă perioadă de timp, deoarece acest lucru va împiedica funcționalitatea normală a platformei.';
$string['cron_help'] = 'Scriptul cron.php rulează o serie de sarcini la intervale diferite de timp, cum ar fi trimiterea e-mailurilor de notificare postare pe forum. Scriptul trebuie rulat în mod regulat - ideal în fiecare minut.';
$string['cron_keepalive'] = 'Menține în rulare';
$string['cron_keepalive_desc'] = 'Perioada de timp pentru a continua monitorizarea sarcinilor suplimentare. Această setare este folosită pentru a ne asigura că cron-ul rulează corect. Dacă utilizați procese dedicate, setați-le cu valoare 0. În caz contrar, setați-le la o valoare similară cu limita de concurență a proceselor ad-hoc. Evita perioadele rulare a proceselor mai lungi. Timpul maxim este de 15 minute.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Execuţie cron exclusiv prin linie de comandă';
$string['cronerrorclionly'] = 'Ne pare rău, accesul prin Internet la această pagină a fost dezactivat de administrator.';
$string['cronerrorpassword'] = 'Ne pare rău, parola pe care aţi furnizat-o nu vă permite accesul la această pagină';
$string['croninfrequent'] = 'A fost {$a->actual} între ultimele două rulări ale scriptului de întreținere cron și ar trebui să ruleze la fiecare {$a->expected}. Vă recomandăm să îl configurați pentru a rula mai frecvent.';
$string['cronremotepassword'] = 'Parolă cron pentru acces remote';
$string['cronwarning'] = '<a href="{$a->url}">scriptul admin/cron.php</a> nu a fost rulat pentru {$a->actual} și ar trebui să ruleze la fiecare {$a->expected}.';
$string['cronwarningcli'] = 'Scriptul <code>admin/cli/cron.php</code> nu a fost rulat pentru {$a->actual} și ar trebui să ruleze la fiecare {$a->expected}.';
$string['cronwarningnever'] = 'Script-ul <code>admin/cli/cron.php</code nu a fost rulat niciodată și ar trebui să ruleze la fiecare {$a->expected}.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">admin/cron.php script</a> nu a fost rulat niciodată și ar trebui să ruleze la fiecare {$a->expected}.';
$string['ctyperequired'] = 'Extensia ctype PHP este obligatorie pentru Moodle în vederea îmbunătăţirii performanţei sitului şi pentru a putea oferi compatibilitate cu mai multe limbi.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'Extensia cURL PHP este acum cerută de Moodle pentru a comunica cu arhivele Moodle.';
$string['curlsecurityallowedport'] = 'Liste cu porturi cURL acceptate';
$string['curlsecurityallowedportsyntax'] = 'Lista numerelor de porturi la care se poate conecta cURL. Intrările valide sunt doar numere întregi. Puneți fiecare intrare pe o nouă linie. Dacă este lăsat gol, toate porturile sunt permise. Dacă este setat, în aproape toate cazurile, atât 443 cât și 80 ar trebui specificate pentru ca CURL să se conecteze la porturile HTTPS și HTTP standard.';
$string['curlsecurityblockedhosts'] = 'cURL listă gazde blocate';
$string['curlsecurityblockedhostssyntax'] = 'Puneți fiecare intrare pe o nouă linie. Intrările valide sunt fie adrese IPv4 complete, fie IPv6 (cum ar fi 192.168.10.1, 0: 0: 0: 0: 0: 0: 0: 1, :: 1, fe80: :) care se potrivesc cu o singură gazdă; sau notație CIDR (cum ar fi 231.54.211.0/20 sau fe80 :: / 64); sau o gamă de adrese IP (cum ar fi 231.3.56.10-20 sau fe80 :: 1111-bbbb) unde intervalul se aplică ultimului grup al adresei; sau nume de domenii (cum ar fi localhost sau example.com); sau nume de domeniu wildcard (cum ar fi * .example.com sau * .sub.example.com). Liniile goale nu sunt permise.';
$string['curlsecurityurlblocked'] = 'URL-ul este blocat.';
$string['curltimeoutkbitrate'] = 'Bitrate utilizat la calcularea timeout-urilor cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Această setare este utilizată pentru a calcula un timeout corespunzător în timpul cererilor cURL mari. Ca parte a acestui calcul, o solicitare HEAD HTTP este făcută pentru a determina mărimea conținutului. Setarea la 0 dezactivează această cerere.';
$string['currenttheme'] = 'Tema curentă';
$string['customcheck'] = 'Alte verificări';
$string['custommenu'] = 'Meniu personalizat';
$string['custommenuitems'] = 'Elemente personalizate de meniu';
$string['customusermenuitems'] = 'Elemente în meniul utilizatorului';
$string['datarootsecurityerror'] = '<p><strong>AVERTIZARE SECURITATE!</strong></p><p>Directorul dataroot  se află într-o locaţie incorectă şi este disponibil (expus) pe Web. Acest lucru înseamnă că toate fişierele care conţin informaţii confidenţiale sunt disponibile oricui şi unele din ele ar putea fi folosite de hackeri pentru a intra pe situl dumneavoastră în calitate de administratori!</p>
<p>Va <em>trebui</em> să mutaţi directorul dataroot ({$a}) într-o altă locaţie care să nu fie publică, şi să actualizaţi setarea <code>$CFG->dataroot</code> din fişierul config.php corespunzător.</p>';
$string['datarootsecuritywarning'] = 'Este posibil ca situl dumneavoastră să nu fie configurat corect şi securizat. Asiguraţi-vă că directorul dataroot ({$a}) nu e accesibil via Web.';
$string['dbprefixtoolong'] = 'Prefixul bazei de date a site-ului dvs. ($CFG->prefix) este prea lung ({$a->current} caractere). Numărul maxim de caractere permis este {$a->maximum}.';
$string['dbsessions'] = 'Foloseşte baza de date pentru informaţii despre sesiune';
$string['debug'] = 'Mesaje debug';
$string['debugall'] = 'TOATE: afişează toate mesajele debug PHP rezonabile';
$string['debugdeveloper'] = 'DEZVOLTATOR: mesaje Moodle debug suplimentare pentru dezvoltatori';
$string['debugdisplay'] = 'Afişează mesaje de depanare';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIM: afişează doar erorile grave';
$string['debugnone'] = 'NICIUNA: nu afişa nicio eroare sau avertisment';
$string['debugnormal'] = 'NORMAL: afişează erori, atenţionări şi observaţii';
$string['debugpageinfo'] = 'Afișați informații despre pagină';
$string['debugsqltrace'] = 'Afișați originea interogărilor SQL';
$string['debugsqltrace1'] = 'Afișați fiecare interogare SQL pe o singură linie';
$string['debugsqltrace100'] = 'Afișați urmele complete ale stivei SQL';
$string['debugsqltrace2'] = 'Afișați 2 linii de urmărire a stivei SQL';
$string['debugsqltrace_desc'] = 'Dacă este activată, o urmărire parțială sau completă a stivei PHP este adăugată în SQL ca un comentariu.';
$string['debugstringids'] = 'Arată originea șirurilor de caractere din alte limbi';
$string['debugstringids_desc'] = 'Dacă este activată, componentele șirului de limbă și identificatorii sunt afișați când ?strings=1 sau &strings=1 sunt adăugate la adresa URL a paginii.';
$string['debugtemplateinfo'] = 'Afișează informații despre șablon';
$string['debugtemplateinfo_desc'] = 'Dacă este activat, șabloanele utilizate pentru randare sunt afișate sub formă de comentarii în pagina HTML. După modificarea setării, trebuie să curățați memoria cache. Utilizați această setare numai pentru depanare temporară, deoarece produce erori de validare HTML și poate întrerupe scripturile de pagină. De asemenea, poate altera funcționalitatea de bază!';
$string['debugvalidators'] = 'Arată verificator de link-uri';
$string['defaultcity'] = 'Orașul implicit';
$string['defaultcity_help'] = 'Un oraș introdus aici va fi orașul implicit la crearea de noi conturi de utilizator.';
$string['defaultformatnotset'] = 'Eroare în determinarea formatului implicit al cursului. Vă rugăm să verificați setările site-ului.';
$string['defaulthomepage'] = 'Pagina de pornire implicită pentru utilizatori';
$string['defaultrequestcategory'] = 'Categorie implicită pentru cursurile solicitate';
$string['defaultsettinginfo'] = 'Implicit: {$a}';
$string['defaultuserroleid'] = 'Rolul implicit al tuturor utilizatorilor';
$string['deleteincompleteusers'] = 'Şterge conturi utilizatori incomplete după';
$string['deleteunconfirmed'] = 'Şterge utilizatorii al căror cont nu a fost setat complet după';
$string['deleteuser'] = 'Șterge utilizator';
$string['density'] = 'Densitate';
$string['denyemailaddresses'] = 'Domenii email interzise';
$string['development'] = 'Dezvoltare';
$string['devicedetectregex'] = 'Expresii regulate de detecție dispozitiv';
$string['devicedetectregex_desc'] = '<p> În mod implicit, Moodle poate detecta dispozitive de tip implicit (computere desktop, laptopuri etc.), mobile (telefoane și dispozitive portabile mici), tablete (iPad-uri, tablete Android) și mai vechi (utilizatori Internet Explorer 6). Selectorul de teme poate fi folosit pentru a aplica teme separate tuturor acestora. Această setare permite expresii regulate care permit detectarea unor tipuri de dispozitive suplimentare (acestea au prioritate față de tipurile implicite). </p>
<p> De exemplu, puteți introduce expresia obișnuită „/(MIDP-1.0|Maemo|Windows CE) /” pentru a detecta unele telefoane caracteristice utilizate în mod obișnuit adăugând valoarea returnată „featurephone”. Aceasta adaugă „funcționalitate” pe selectorul de temă, care vă va permite să adăugați o temă care ar fi utilizată pe aceste dispozitive. Alte telefoane ar folosi în continuare tema selectată pentru tipul de dispozitiv mobil. </p>';
$string['devicedetectregexexpression'] = 'Expresie regulată';
$string['devicedetectregexvalue'] = 'Valoare returnată';
$string['devicetype'] = 'Tipul de dispozitiv';
$string['devlibdirpresent'] = 'Directoarele cu biblioteci de dezvoltare, în special <em>/vendor</em> și <em>/node_modules</em>, nu ar trebui să fie prezente pe site-urile publice. Pentru mai multe detalii, consultați <a href="{$a->moreinfourl}"> raportul general de securitate </a>.';
$string['disabled'] = 'Dezactivat';
$string['disableplugin'] = 'Dezactivează {$a}';
$string['disableuserimages'] = 'Dezactivează imaginile de profil ale utilizatorilor';
$string['displayerrorswarning'] = 'Nu se recomandă activarea setării PHP <em>display_errors</em> pe siturile de producţie deoarece este posibil ca unele erori să afişeze informaţii confidenţiale despre serverul dumneavoastră.';
$string['displayloginfailures'] = 'Afișează erorile de logare';
$string['divertallemails'] = 'Redirecționarea e-mailurilor';
$string['divertallemailsdetail'] = 'Folosit ca măsură de protecție în mediile de dezvoltare la testarea e-mailurilor și nu trebuie utilizat în producție.';
$string['divertallemailsexcept'] = 'Excepție de la redirecționarea e-mailurilor';
$string['divertallemailsexcept_desc'] = 'O listă de excepții ale regulilor e-mailurilor separate prin virgule sau linii noi. Fiecare regulă este interpretată ca o expresie regulată, de exemplu <pre> simone@acme.com
. * @ acme.com
fred (\\ +. *)? @ acme.com
</pre>';
$string['divertallemailsto'] = 'Redirecționarea tuturor e-mailurilor';
$string['divertallemailsto_desc'] = 'Dacă este setat, toate e-mailurile vor fi redirecționate către această adresă de e-mail.';
$string['dndallowtextandlinks'] = 'Upload drag and drop al textului/link-ului';
$string['doclang'] = 'Limba pentru documente';
$string['docroot'] = 'Moodle Docs document root';
$string['doctonewwindow'] = 'Deschide într-o fereastră nouă';
$string['doesnotfit'] = 'Setări de afișare a email-ului';
$string['doesnotfitdetail'] = 'Afișați setările pentru email-ul de renunțare la Moodle.';
$string['download'] = 'Descarcă';
$string['downloadcoursecontentallowed'] = 'Funcționalitatea descărcați conținutul cursului este disponibilă';
$string['downloadcoursecontentallowed_desc'] = 'Dacă funcționalitatea de descărcare a conținutului cursului este disponibilă pentru cursuri. Când e disponibilă, descărcarea conținutului cursului poate fi activată/dezactivată utilizând setarea „Activați descărcarea conținutului cursului” din meniul de editare a cursului (valoarea implicită pentru aceasta poate fi setată în <a href={$a} target="_blank"> Setarea implicită a cursului setări </a>).';
$string['durationunits'] = 'unități de durată';
$string['edithelpdocs'] = 'Modifică documente de ajutor';
$string['editlang'] = '<b>Modifică</b>';
$string['editorbackgroundcolor'] = 'Culoarea fundalului';
$string['editordictionary'] = 'Dicţionar editor';
$string['editorfontfamily'] = 'Familie fonturi';
$string['editorfontlist'] = 'Listă fonturi';
$string['editorfontsize'] = 'Dimensiune font';
$string['editorhidebuttons'] = 'Butoane ascunse';
$string['editorkillword'] = 'Filtru format Word';
$string['editorspelling'] = 'Corectare gramaticală';
$string['editorspellinghelp'] = 'Activează sau dez-activează funcţionalitatea "verificare scriere corectă". În cazul în care se activează această funcţionalitate, trebuie să aveţi instalat <strong>aspell</strong> pe server.';
$string['editstrings'] = 'Modifică cuvinte sau propoziții';
$string['emailchangeconfirmation'] = 'Confirmare schimbare email';
$string['emaildkim'] = 'Semnarea e-mailului Domain Keys Identified Mail (DKIM)';
$string['emaildkiminfo'] = 'Dacă ambele selector DKIM sunt setate și se găsește un fișier de certificat privat care se potrivește domeniului adresei „De la” e-mail din $CFG->dataroot/dkim/[domeniu]/[selector].privat, atunci e-mailul va fi semnat. În majoritatea cazurilor (de exemplu, dacă domeniile de e-mail permise sunt goale) este necesar un singur certificat în <pre> {$a->path} </pre>. Pentru mai multe detalii despre configurare, consultați documentația <a href="{$a->docs}"> Configurare e-mail </a>.';
$string['emaildkimselector'] = 'Selector DKIM';
$string['emailfromvia'] = 'Email via informație';
$string['emailheaders'] = 'Activați antetele';
$string['emailsubjectprefix'] = 'Textul prefixului subiectului din e-mail';
$string['emoticonalt'] = 'Text alternativ';
$string['emoticoncomponent'] = 'Componentă imagine';
$string['emoticonimagename'] = 'Denumire imagine';
$string['emoticons'] = 'Emoticonuri';
$string['emoticons_desc'] = 'Acest formular definește emoticoanele (sau smileys) folosite pe site-ul dumneavoastră. Pentru a elimina un rând din tabel, salvați  forma cu o valoare necompletată în oricare dintre câmpurile obligatorii. Pentru a înregistra un nou emoticon, completați câmpurile din ultimul rând necompletat. Pentru a reseta toate câmpurile la valorile implicite, urmați link-ul de mai sus.

* Text (obligatoriu) - Acest text va fi înlocuit cu imaginea emoticon. Ttrebuie să fie de cel puțin două caractere.
* Numele imaginii (obligatoriu) - Numele fișierului cu imaginea emoticonului fără extensie, în raport cu folderul componente imagini.
* Componenta de imagine (obligatoriu) - Componenta care oferă pictograma.
* Text alternativ (opțional) - Identificatorul șirului de caractere și componenta textului alternativ pentru emoticon.';
$string['emoticonsreset'] = 'Resetează setările emoticoanelor la valorile implicite';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Necompletat';
$string['enableactivitychooser'] = 'Activați selectorul de activitate';
$string['enableanalytics'] = 'Modele analitice';
$string['enableblogs'] = 'Activează blogurile';
$string['enablecalendarexport'] = 'Activează exportul calendarului';
$string['enablecomments'] = 'Activare comentarii';
$string['enablecourserelativedates'] = 'Activați funcționalitatea dată relativă a cursului';
$string['enablecourserelativedates_desc'] = 'Permiteți configurarea cursurilor pentru a afișa datele relative la data de începere a utilizatorului în curs.';
$string['enablecourserequests'] = 'Activează cererile de curs';
$string['enabled'] = 'Activat';
$string['enabledashboard'] = 'Activează tabloul de bord';
$string['enabledashboard_help'] = 'Tabloul de bord afișează în mod prestabilit cronologia, calendarul și elementele accesate recent. Puteți seta un tablou de bord prestabilit diferit pentru toată lumea și puteți permite utilizatorilor să-și personalizeze propriul tablou de bord. Dacă este dezactivat, trebuie să setați „Pagina de pornire pentru utilizatori” la o altă valoare decât Tabloul de bord.';
$string['enabledevicedetection'] = 'Activare detecție dispozitiv';
$string['enableglobalsearch'] = 'Activează căutarea generală';
$string['enableglobalsearch_desc'] = 'Dacă este activată, datele vor fi indexate și sincronizate de către cron.';
$string['enablegravatar'] = 'Activare Gravatar';
$string['enablegravatar_help'] = 'Dacă este activ, Moodle va încerca să adauge o poza de profil pentru utilizator din Gravatar, dacă utilizatorul nu a încărcat o imagine.';
$string['enablemobilewebservice'] = 'Activare servicii web pentru dispozitivele mobile';
$string['enablepdfexportfont'] = 'Activează fonturile PDF';
$string['enablepdfexportfont_desc'] = 'Dacă site-ul dvs. are cursuri în diferite limbi care necesită alte fonturi în fișierele PDF generate, puteți oferi opțiunea de a seta fontul în setările cursului. Trebuie să specificați fonturile disponibile în $CFG->pdfexportfont în config.php.';
$string['enableplugin'] = 'Activează {$a}';
$string['enablerecordcache'] = 'Activează Record Cache';
$string['enablerssfeeds'] = 'Activează feeduri RSS';
$string['enablesearchareas'] = 'Activați zonele de căutare';
$string['enablesharingtomoodlenet'] = 'Activează partajarea în MoodleNet (outbound)';
$string['enablesharingtomoodlenet_desc'] = 'Această acțiune le permite utilizatorilor să partajeze conținutul cursului către o instanță MoodleNet configurată, dacă au această capabilitate.';
$string['enablestats'] = 'Activează statistici';
$string['enabletrusttext'] = 'Activează conținut de încredere';
$string['enableuserfeedback'] = 'Activați feedback despre acest software';
$string['enableuserfeedback_desc'] = 'Dacă este activată, un link „Oferiți feedback despre acest software” este afișat în subsolul pagini pentru ca utilizatorii să ofere feedback despre software-ul Moodle către Moodle HQ. Dacă este setată opțiunea „Memento trimitere feedback următor”, utilizatorului i se va afișa și un memento pe tabloul de bord la intervalul specificat. Setarea „Memento feedback următor” la „Niciodată” dezactivează memento-ul tabloului de bord, lăsând în subsol linkul „Oferiți feedback despre acest software”.';
$string['enablewebservices'] = 'Activare servicii web';
$string['enablewsdocumentation'] = 'Documentație servicii web';
$string['encryptedpassword_edit'] = 'Inserați o valoare nouă';
$string['encryptedpassword_set'] = '(setat și criptat)';
$string['enroladminnewcourse'] = 'Înscrierea automată a administratorului la cursurile noi';
$string['enroladminnewcourse_help'] = 'Când un administrator adaugă un curs nou, ar trebui să fie înscris automat și să îi fie atribuit rolul de creator în noile cursuri?';
$string['enrolinstancedefaults'] = 'Instanță înscriere implicită';
$string['enrolinstancedefaults_desc'] = 'Setări înrolare implicite în noile cursuri';
$string['enrolmultipleusers'] = 'Înscrie utilizatorii';
$string['entitytasklog'] = 'Jurnal de acțiuni';
$string['environment'] = 'Mediu';
$string['environmenterrortodo'] = 'Înainte de a instala această versiune de Moodle trebuie să rezolvaţi toate problemele (erorile) de environment găsite mai sus.';
$string['environmenterrorupgrade'] = 'Atenţie: înainte de a actualiza această versiune de Moodle trebuie să rezolvaţi toate problemele (erorile) de environment găsite mai sus. Actualizarea versiunii fără rezolvarea problemelor de mai sus poate cauza pierderea de date. Sunteţi sigur că doriţi continuarea procesului de actualizare?';
$string['environmentmariadbwrongdbtype'] = '$CFG->dbtype eronat. Trebuie să îl modifici în fișierul config.php din \'mysqli\' în \'mariadb\'.';
$string['environmentmustfixsetting'] = 'Setarea PHP trebuie schimbată';
$string['environmentok'] = 'Mediul de lucru al serverului tău îndeplineşte dependințele minime necesare.';
$string['environmentrecommendcustomcheck'] = 'dacă acest test nu are rezultate pozitive, acest lucru indică o potenţială problemă';
$string['environmentrecommendinstall'] = 'trebuie instalat şi activat pentru a obţine cele mai bune rezultate';
$string['environmentrecommendversion'] = 'versiunea recomandată este {$a->needed} în timp ce dumneavoastră rulaţi versiunea {$a->current}';
$string['environmentrequirecustomcheck'] = 'acest test trebuie să treacă';
$string['environmentrequireinstall'] = 'trebuie instalat şi activat';
$string['environmentrequireversion'] = 'versiuna necesară este {$a->needed} în timp ce dumneavoastră rulaţi versiunea {$a->current}';
$string['environmentsettingok'] = 'setări recomandate detectate';
$string['environmentshouldfixcustomcheck'] = 'ar trebui activat pentru cele mai bune rezultate';
$string['environmentshouldfixsetting'] = 'setarea PHP ar trebui schimbată';
$string['environmentxmlerror'] = 'Eroare la citirea informaţiilor despre environment ({$a->error_code})';
$string['errordeletingconfig'] = 'A apărut o eroare la ștergerea înregistrărilor de configurare pentru plugin-ul "{$a}".';
$string['errorsetting'] = 'Nu s-au putut salva setările:';
$string['errorwithsettings'] = 'Unele setări nu au fost schimbate din cauza unei erori.';
$string['eventshandlersinuse'] = 'Următoarele pluginuri din sistemul dvs. utilizează metode depreciate Events 1 API: „{$a}”. Actualizați-le pentru a utiliza Events 2 API. Consultați https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Orice utilizator care poate să \'{$a}\'';
$string['exceptions'] = 'excepții';
$string['execpathnotallowed'] = 'Setările executable și local paths dezactivate în config.php';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Setări experimentale';
$string['extendedusernamechars'] = 'Permite folosirea de caractere speciale în numele de utilizator';
$string['extramemorylimit'] = 'Limita maximă memorie PHP suplimentară';
$string['fatalsessionautostart'] = '<p>Eroare de configurare gravă detectată, vă rugăm să anunțați administratorul serverului.</p><p> Pentru a funcționa în mod corespunzător, Moodle solicită ca administratorul să modifice setările PHP.</p><p>
<code>session.auto_start</code>trebuie setat la <code>off</code>.</p><p>Această setare este controlată prin editarea<code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Favicon va fi afișat lângă titlul paginii în tab-ul browser-ului. Se afșează un favicon Moodle, dacă nu este furnizat un favicon personalizat.';
$string['feedbacksettings'] = 'Setări feedback';
$string['fileconversioncleanuptask'] = 'Ștergeți înregistrările temporare pentru conversia fișierelor.';
$string['filecreated'] = 'Fișier nou creat';
$string['filescleanupperiod'] = 'Ștergeți fișierele din coșul de gunoi';
$string['filescleanupperiod_help'] = 'Cât de des sunt șterse fișierele din coșul de gunoi. Acestea sunt fișiere care sunt asociate cu un context care nu mai există, de exemplu atunci când un curs este șters. Vă rugăm să rețineți: Această setare poate duce la lipsa fișierelor într-un curs care este copiat, șters și apoi restaurat dacă setarea „Includeți fișiere” (backup_auto_files) în „Setări de backup automat” este dezactivată.';
$string['filesizeunits'] = 'unități de dimensiune a fișierului';
$string['filestoredin'] = 'Salvează fișier în dosar :';
$string['filestoredinhelp'] = 'Locaţia unde va fi stocat fişierul';
$string['filterall'] = 'Filtrează toate stringurile';
$string['filtermatchoneperpage'] = 'Filtrul se potrivește o dată pe pagină';
$string['filtermatchonepertext'] = 'Filtrul se potrivește o dată pe text';
$string['filternavigationwithsystemcontext'] = 'Filtru de navigare cu context al sistemului';
$string['filters'] = 'Filtre';
$string['filtersettings'] = 'Administrare filtre';
$string['filtersettingsgeneral'] = 'Setări generale filtre';
$string['filteruploadedfiles'] = 'Filtrează fişiere încărcate';
$string['forceclean'] = 'Optimizare conținut';
$string['forceclean_desc'] = 'Conținutul adăugat pe site este curățat / filtrat în mod normal înainte de a fi afișat, pentru a elimina orice ar putea constitui o amenințare la adresa securității. Cu toate acestea, conținutul nu este curățat în anumite locuri, cum ar fi descrieri de activitate, resurse de pagină sau blocuri HTML pentru a permite adăugarea de scripturi, suporturi media, cadre inline etc. Dacă această setare este activată, TOT conținutul va fi curățat. Din această cauză conținutul existent poate să nu mai fie afișat corect.';
$string['forcelogin'] = 'Obligă utilizatorii să se autentifice';
$string['forceloginforprofileimage'] = 'Obligă utilizatorii să se logheze pentru a vedea imaginile utilizatorului';
$string['forceloginforprofileimage_help'] = 'Dacă este activată opțiunea aceasta, utilizatorii trebuie să se conecteze pentru a vizualiza imaginile de profil ale utilizatorilor iar imaginea implicită a utilizatorului va fi folosită în toate e-mailurile de notificare.';
$string['forceloginforprofiles'] = 'Obligă utilizatorii să se autentifice dacă doresc să vizualizeze profile ale altor utilizatori';
$string['forcetimezone'] = 'Obligă folosirea fusului orar implicit';
$string['formatuninstallwithcourses'] = 'Sunt {$a->count} cursuri care utilizează{$a->format}. Formatul acestora va fi schimbat în {$a->defaultformat} (format implicit pentru acest site). Unele date cu format specific pot fi pierdute. Sigur doriți să continuați?';
$string['frontpage'] = 'Pagina principală';
$string['frontpagebackup'] = 'Copie de siguranță a paginii principale';
$string['frontpagedefaultrole'] = 'Rol implicit pentru prima pagină';
$string['frontpagefilters'] = 'Filtre pagina principală';
$string['frontpageloggedin'] = 'Elemente pagina principală la logare';
$string['frontpageoverrides'] = 'Suprascrierea permisiunilor de pe pagina principală';
$string['frontpagequestions'] = 'Întrebări din contextul pagini principale';
$string['frontpagerestore'] = 'Restaurare pagina principală';
$string['frontpageroles'] = 'Roluri pagina principală';
$string['frontpagesettings'] = 'Setări pagina principală';
$string['fullnamedisplay'] = 'Format nume complet';
$string['fullnamedisplayprivate'] = 'Format nume complet - privat';
$string['gdrequired'] = 'Extensia GD este necesară în Moodle pentru conversia imaginii.';
$string['generalsettings'] = 'Setări generale';
$string['geoipfile'] = 'Baza de date GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Sursa adresei IP de logare';
$string['globalsearch'] = 'Căutare generală';
$string['globalsearchmanage'] = 'Activați căutarea generală';
$string['googlemapkey3'] = 'Cheie API Google Maps V3';
$string['googlemapkey3_help'] = 'Trebuie să introduceți o cheie specială pentru a utiliza Google Maps pentru adresa IP de căutare. Puteți obține cheia gratuit la <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank"> https://developers.google.com/ maps/ documentation/ javascript / tutorial # api_key </a>';
$string['gotofirst'] = 'Mergi la primul string netradus';
$string['gradebook'] = 'Catalog';
$string['gradebookroles'] = 'Funcții gradate';
$string['gradeexport'] = 'Metode de export a funcțiilor primare';
$string['gravatardefaulturl'] = 'Imagine gravatar URL implicită';
$string['gravatardefaulturl_help'] = 'Pentru gravatar trebuie o imagine implicită pentru afișare dacă nu poate găsi o imagine pentru un anumit utilizator. Oferiți un URL complet pentru o imagine. Dacă nu completați acest câmp, Moodle va încerca să utilizeze imaginea implicită cel mai potrivită pentru pagina pe care o vizualizați. Rețineți, de asemenea, că Gravatar are un număr de coduri care pot fi folosite pentru <a href="https://en.gravatar.com/site/implement/images/#default-image"> genera implicit imagini </a>.';
$string['groupenrolmentkeypolicy'] = '';
$string['groupenrolmentkeypolicy_desc'] = 'Dacă este activată, cheile de înscriere în grup vor fi verificate în raport cu politica de parolă, așa cum este specificat în setările de mai sus.';
$string['guestroleid'] = 'Rol atribuit vizitatorilor';
$string['guestroleid_help'] = 'Acest rol este atribuit în mod automat vizitatorilor. Este, de asemenea, asignat temporar userilor neînrolați care accesează cursul via plugin-ul de înrolare a vizitatorilor.';
$string['h5pgetcontenttypestask'] = 'Descărcați tipurile de conținut interactiv H5P disponibile de pe h5p.org';
$string['helpadminseesall'] = 'În calendarul site-ului, administratorii văd și filtrează evenimentele din toate calendarele cursurilor sau doar cele din cursurile la care sunt înscriși? Indiferent de opțiunea aleasă, administratorii vor putea gestiona întotdeauna evenimentele pentru fiecare calendar de curs navigând mai întâi la curs și apoi accesând direct calendarul cursului.';
$string['helpcalendarcustomexport'] = 'Activați opțiunea de export a intervalului de date personalizat în exporturile din calendar. Exporturile din calendar trebuie să fie activate înainte ca acest lucru să fie funcțional.';
$string['helpexportlookahead'] = 'Pentru câte zile următoare calendarul caută evenimente în timpul exportului pentru opțiunea de export personalizată?';
$string['helpexportlookback'] = 'Pentru câte zile trecute calendarul caută evenimente în timpul exportului pentru opțiunea de export personalizată?';
$string['helpforcetimezone'] = 'Puteţi să permiteţi utilizatorilor să îşi selecteze individual fusul orar sau puteţi să setaţi un fus orar obligatoriu pentru toţi utilizatorii sitului';
$string['helpshowicalsource'] = 'Dacă este activat, numele de subscriere și link-ul vor fi afișate pentru evenimentele importate din iCal.';
$string['helpsitemaintenance'] = 'Pentru actualizări şi alte operaţiuni';
$string['helpstartofweek'] = 'Care este prima zi a săptămânii în calendar?';
$string['helpupcominglookahead'] = 'Care este perioada implicită în care funcţionalitatea de calendar caută evenimente programate?';
$string['helpupcomingmaxevents'] = 'Câte (numărul maxim de) evenimente viitoare sunt afişate implicit utilizatorilor?';
$string['helpweekenddays'] = 'Care sunt zilele din săptămână considerate "weekend" şi care vor fi afişate în calendar cu o altă culoare?';
$string['hiddenuserfields'] = 'Ascunde câmpuri utilizator';
$string['hidefromall'] = 'Ascunde pentru toţi utilizatorii';
$string['hidefromnone'] = 'Nu ascunde pentru niciun utilizatori';
$string['hidefromstudents'] = 'Ascunde pentru cursanţi';
$string['hostname'] = 'Numele gazdei';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Setări editor HTML';
$string['htmlsettings'] = 'Setări HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Securitate HTTP';
$string['iconvrequired'] = 'Instalarea extensiei ICONV este obligatorie';
$string['igbinary322buggyversion'] = 'Extensia php-igbinary instalată pe site poate duce la probleme la rularea cu PHP 7.2. Vi se recomandă fie să faceți upgrade la php-igbinary 3.2.5 sau o versiune ulterioară, fie, alternativ, să faceți upgrade la PHP 7.3 sau o versiune ulterioară.';
$string['ignore'] = 'Ignoră';
$string['includemoduleuserdata'] = 'Include informaţii despre utilizatori din cadrul modulelor';
$string['incompatibleblocks'] = 'Blocuri incompatibile';
$string['incompleteunicodesupport'] = 'Configurarea curentă a MySQL sau MariaDB utilizează „utf8”. Acest set de caractere nu acceptă caractere de patru octeți care includ unele emoji. Încercarea de a utiliza aceste caractere va duce la o eroare la actualizarea unei înregistrări, iar orice informație trimisă la baza de date se va pierde. Vă rugăm să luați în considerare modificarea setărilor în „utf8mb4”. Consultați documentația pentru detalii complete.';
$string['indexdata'] = 'Date de indexare';
$string['indexinginfo'] = 'Modul recomandat de a indexa conținutul site-ului dvs. este utilizând sarcina programată „Indexarea căutării globale”.';
$string['installhijacked'] = 'Ne pare rău, instalarea trebuie finalizată de la adresa IP originală.';
$string['installsessionerror'] = 'Nu se poate inițializa sesiunea PHP, vă rugăm să verificați dacă browser-ul dumneavoastră acceptă cookies.';
$string['intlrecommended'] = 'Extensia Intl este utilizată pentru a îmbunatăți suportul intern,';
$string['intlrequired'] = 'Extensia Intl este necesară pentru a îmbunătăți suportul pentru internaționalizare, cum ar fi sortarea locală și numele de domenii internaționale.';
$string['invalidagedigitalconsent'] = 'Vârsta mimimă de verificare a acordului nu este validă: {$a}';
$string['invalidforgottenpasswordurl'] = 'Adresa URL a parolei uitate nu este o adresă URL validă.';
$string['invalidsection'] = 'Secţiune incorectă';
$string['invalidthemepreset'] = 'Fișierul presetat ales nu este compatibil cu această temă. Eroarea de compilare SCSS a fost: „{$a}”';
$string['invaliduserchangeme'] = 'Numele de utilizator "changeme" este rezervat - nu puteţi folosi acest nume de utilizator pentru a crea un cont';
$string['ipblocked'] = 'Acest site nu este disponibil în prezent.';
$string['ipblocker'] = 'Blocare IP';
$string['ipblockersyntax'] = 'Puneți fiecare intrare pe o singură linie. Intrările valide sunt fie adresa IP completă (cum ar fi <b> 192.168.10.1 </b>) care se potrivește cu o singură gazdă; sau adresă parțială (cum ar fi <b> 192.168 </b>) care se potrivește cu orice adresă începând cu acele numere; sau notație CIDR (cum ar fi <b> 231.54.211.0/20 </b>); sau un interval de adrese IP (cum ar fi <b> 231.3.56.10-20 </b>) în care intervalul se aplică ultimei părți a adresei. Numele de domeniu text (cum ar fi „example.com”) nu sunt acceptate. Liniile goale și textul urmând un caracter „#” sunt ignorate.';
$string['iplookup'] = 'Căutare adresă IP';
$string['iplookupgeoplugin'] = 'Serviciul <a href="https://www.geoplugin.com"> geoPlugin </a> este utilizat în prezent pentru a căuta informații geografice. Pentru rezultate mai precise, vă recomandăm să instalați o copie locală a bazei de date MaxMind GeoLite.';
$string['iplookupinfo'] = 'Serverul online gratuit NetGeo este folosit pentru a căuta locațiile adreselor IP. Cu toate acestea, baza de date nu mai este întreținută și poate returna date incorecte. Se recomandă instalarea unei copii locale a bazei de date gratuite GeoLite2 City de la MaxMind.<br />
Dacă este furnizată o cheie Google Maps API V3, locația adresei IP este afișată folosind Google Maps. Aveți nevoie de un cont Google și pentru a solicita o cheie API Google Maps. Dacă nu este furnizată nicio cheie Google Maps API V3, locația adresei IP este afișată folosind OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'Acest produs include informaţii GeoLite, creat de MaxMind, disponibil la <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'S-a detectat că site-ul dvs. folosește un director personalizat de administrare. Această caracteristică nu mai este acceptată și va fi eliminată după Moodle 4.2.';
$string['ishttpswarning'] = 'Site-ul dumneavoastră nu utilizează HTTPS. Este recomandat să migrați site-ul la HTTPS pentru un sistem de securitate superior și pentru o integrare îmbunătățită a celorlalte sisteme.';
$string['keeptagnamecase'] = 'În etichete păstrează combinaţia majuscule/minuscule';
$string['lang'] = 'Limba implicită';
$string['langcache'] = 'Cache limbă meniu';
$string['langcache_desc'] = 'Salvează în memoria cache meniul de limbă. Dacă este activată, lista traducerilor disponibile este salvată în memoria cache. Cache-ul se va actualiza automat atunci când instalați sau ștergeți un pachet de limbă, prin intermediul instrumentului de gestionare in-built language. În cazul în care instalați manual un nou pachet de limbă, trebuie să eliminați toate cache-urile pentru a actualiza lista cache.';
$string['langlist'] = 'Meniu limbă';
$string['langmenu'] = 'Afişează meniu localizare';
$string['langmenuinsecurelayout'] = 'Afișați meniul de limbă într-un aspect sigur';
$string['langmenuinsecurelayout_desc'] = 'Dacă este activat, un utilizator își va putea schimba limba atunci când încearcă un test sau altă activitate folosind aspectul securizat.';
$string['langpackwillbeupdated'] = 'NOTĂ: Moodle va încerca să descarce actualizări pentru pachetele dvs. de limbă în timpul actualizării.';
$string['langstringcache'] = 'Cache șirurile de caractere pentru toate limbile';
$string['languagesettings'] = 'Setări limbă';
$string['latinexcelexport'] = 'Codare Excel';
$string['legacyfilesaddallowed'] = 'Permiteți adăugarea la fișierele vechi ale cursului';
$string['legacyfilesaddallowed_help'] = 'Dacă un curs are fișiere de curs vechi, permiteți adăugarea de noi fișiere și foldere.';
$string['legacyfilesinnewcourses'] = 'Fișiere de curs vechi în cursurile noi';
$string['legacyfilesinnewcourses_help'] = 'În mod implicit, zonele de fișiere de curs vechi sunt disponibile numai în cursurile actualizate. Vă rugăm să rețineți că unele caracteristici, cum ar fi backupul și restaurarea activității, nu sunt compatibile cu această setare.';
$string['libcurlwarning'] = 'S-a detectat că libcurl nu are suport CURLOPT_PROTOCOL. Din motive de securitate, se recomandă o instalare actualizată a libcurl.';
$string['licensesettings'] = 'Setări licențe';
$string['linkadmincategories'] = 'Categorii link administrator';
$string['linkadmincategories_help'] = 'Dacă este activat, categoriile de setări pentru administrator vor fi afișate ca link-uri în meniul de navigare și vor conduce la paginile categoriei administrator.';
$string['linkcoursesections'] = 'Întotdeauna creați link pentru secțiunile de curs';
$string['linkcoursesections_help'] = 'Încercați întotdeauna să oferiți un link pentru secțiunile de curs. Secțiunile de curs sunt, de obicei afișate doar ca link-uri în cazul în care formatul cursului afișează o singură secțiune pe pagină. Dacă această setare este activată, va fi întotdeauna furnizat un link.';
$string['loading'] = 'Încărcare';
$string['localetext'] = 'Limbă generală site';
$string['localstringcustomization'] = 'Personalizare locală a traducerii';
$string['location'] = 'Locație';
$string['locationsettings'] = 'Setări locație';
$string['locked'] = 'Blocat';
$string['lockoutduration'] = 'Durata de blocare a contului';
$string['lockoutduration_desc'] = 'Contul blocat este automat deblocat după această durată.';
$string['lockoutemailbody'] = 'Contul dumneavoastră cu numele de utilizator  {$a->username} pe serverul \'{$a->sitename}\'
a fost blocat după mai multe încercări nereușite de autentificare.

Pentru a debloca acest cont, mergeți la următoarea adresă

{$a->link}

În cele mai multe programe, apare ca un link albastru pe care puteți da clic. Dacă acest lucru nu funcționează, dați copy-past adresei în fereastra browserului.

Dacă aveți nevoie de ajutor, vă rugăm să contactați administratorul site-ului.
{$a->admin}

Vă mulțumim!';
$string['lockoutemailsubject'] = 'Contul dumneavoastră {$a} a fost blocat';
$string['lockouterrorunlock'] = 'Informații invalide furnizate pentru deblocarea contului.';
$string['lockoutthreshold'] = 'Prag de blocare a contului';
$string['lockoutthreshold_desc'] = 'Selectați numărul de încercări de conectare nereușite care au ca rezultat blocarea contului. Această caracteristică poate fi abuzată în atacurile de refuz de serviciu.';
$string['lockoutwindow'] = 'Fereastra de urmărire a blocării contului';
$string['lockoutwindow_desc'] = 'Timpul de urmărire pentru pragul de blocare, dacă nu sunt încercări eșuate, contorul de prag se resetează după acest timp.';
$string['lockrequestcategory'] = 'Preveniți selectarea categoriilor';
$string['log'] = 'Jurnale';
$string['logguests'] = 'Înregistrare acces vizitori';
$string['logguests_help'] = 'Această setare permite înregistrarea acțiunilor efectuate de către contul vizitator și de utilizatorii care nu sunt conectați. Ar fi recomandat să dezactivați această setare din motive de performanță. Este recomandat să păstrați această setare activată pe site-urile de producție.';
$string['logininfoinsecurelayout'] = 'Afișați utilizatorul conectat într-un aspect securizat';
$string['logininfoinsecurelayout_desc'] = 'Dacă este activat, numele complet al utilizatorului conectat va fi afișat în bara de navigare atunci când încercați un test sau altă activitate folosind aspectul securizat.';
$string['loginpageautofocus'] = 'Focalizați formularul de autentificare din pagină de login';
$string['loginpageautofocus_help'] = 'Activarea acestei opțiuni îmbunătățește gradul de utilizare a paginii de conectare, dar câmpurile de focalizare automată pot fi considerate o problemă de accesibilitate.';
$string['loglifetime'] = 'Jurnalizează';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Un logo complet pentru a fi folosit ca decor pentru unele teme (cum ar fi temele de bază). Această imagine poate avea o rezoluție destul de mare, deoarece va fi redusă pentru utilizare (și va fi stocată în cache pentru performanță). Logo-urile care sunt mai largi decât înalte dau de obicei rezultate mai bune.';
$string['logocompact'] = 'Logo compact';
$string['logocompact_desc'] = 'O versiune compactă a aceluiași logo ca mai sus, cum ar fi o emblemă, un paravan sau o pictogramă. Imaginea trebuie să fie clară chiar și la dimensiuni mici.';
$string['logossettings'] = 'Logo-uri';
$string['logstorenotrequired'] = 'Memorarea logărilor nu este necesară';
$string['logstoressupported'] = 'Logări memorate care acceptă acest raport';
$string['longtimewarning'] = '<b>Atenţie, este posibil ca acest proces să dureze o perioadă lungă de timp.</b>';
$string['mailnewline'] = 'Caractere linie nouă în email';
$string['maintenancemode'] = 'În modul mentenanţă';
$string['maintenancemodeisscheduled'] = 'Acest site va trece în modul de mentenanță în {$a->min} min {$a->sec} sec';
$string['maintenancemodeisscheduledlong'] = 'Site-ul va trece în modul de mentenanță în {$a->hour} ore {$a->min} min {$a->sec} sec';
$string['maintfileopenerror'] = 'A apărut o eroare la deschiderea fişierelor de mentenanţă!';
$string['maintinprogress'] = 'Mentenanţă în curs de realizare...';
$string['managecontextlock'] = 'Blocați acest context';
$string['managecontextlocklocked'] = '{$a->contextname} și orice contexte inferioare sunt acum blocate.';
$string['managecontextlockunlocked'] = '{$a->contextname} și orice contexte inferioare sunt acum deblocate.';
$string['managecontextunlock'] = 'Deblochează acest context';
$string['managecustomfields'] = 'Gestionați tipurile de câmpuri personalizate';
$string['manageformats'] = 'Gestionare formate de curs';
$string['manageformatsgotosettings'] = 'Formatul implicit poate fi schimbat în {$a}';
$string['managelang'] = 'Administrează';
$string['manageqbanks'] = 'Plugin-urile de administrare a băncii de întrebări';
$string['manageqbehaviours'] = 'Administrează funcționalitate întrebare';
$string['manageqtypes'] = 'Gestionare tipuri de întrebări';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Versiunea în dezvoltare';
$string['maturity200'] = 'Versiune stabilă';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Indiciu: Rulați acest script cu opțiunea --permite-instabil';
$string['maturitycoreinfo'] = 'Site-ul dumneavoastră rulează acum un cod de dezvoltare instabil "{$a}"';
$string['maturitycorewarning'] = 'Versiunea Moodle pe care urmează să o instalați sau să o actualizați conține cod de dezvoltare instabil „{$a}” care nu este potrivit pentru a fi utilizat la majoritatea site-urilor de producției. Dacă nu doriți acest lucru, trebuie să vă asigurați că actualizați platforma dintr-o ramură STABILĂ a codului Moodle. Consultați documentația Moodle pentru mai multe detalii.';
$string['maxbytes'] = 'Dimensiune maximă a fişierelor încărcate';
$string['maxconsecutiveidentchars'] = 'Caractere consecutive identice';
$string['maxeditingtime'] = 'Timp maxim disponibil pentru editarea intervenţiilor';
$string['maxsizeperdownloadcoursefile'] = 'Dimensiunea maximă per fișier';
$string['maxsizeperdownloadcoursefile_desc'] = 'Dimensiunea maximă a fiecărui fișier la descărcarea conținutului cursului. Fișierele care depășesc această dimensiune vor fi omise la descărcare.';
$string['maxtimelimit'] = 'Limită de timp maximă';
$string['maxtimelimit_desc'] = 'Pentru a restricționa timpul maxim de execuție PHP pe care Moodle îl va permite, fără ca niciun rezultat să fie afișat, introduceți aici o valoare în secunde. 0 înseamnă că restricțiile implicite Moodle sunt utilizate. Dacă aveți un server de front-end, cu propria limită de timp, setați această valoare mai mică pentru a primile erori PHP în jurnalele. Nu se aplică pentru scripturi CLI.';
$string['maxusersperpage'] = 'Număr maxim de utilizatori pe pagină';
$string['mbstringrecommended'] = 'Recomandăm cu tărie instalarea librăriei opţionale MBSTRING pentru îmbunătăţirea performanţei sitului în special dacă acesta este compatibil cu alte tipuri de limbi decât cele romanice.';
$string['mbstringrequired'] = 'Instalarea bibliotecii MBSTRING este necesară pentru a îmbunătăți performanța site-ului, mai ales dacă site-ul dvs. acceptă limbi non-latine.';
$string['mediapluginavi'] = 'Activează filtru .avi';
$string['mediapluginflv'] = 'Activează filtru .flv';
$string['mediapluginimg'] = 'Activați auto-încorporarea în imaginile corelate.';
$string['mediapluginmov'] = 'Activează filtru .mov';
$string['mediapluginmp3'] = 'Activează filtru .mp3';
$string['mediapluginmpg'] = 'Activează filtru .mpg';
$string['mediapluginogg'] = 'Activează filtru .ogg';
$string['mediapluginogv'] = 'Activează filtru .ogv';
$string['mediapluginram'] = 'Activează filtru .ram';
$string['mediapluginrm'] = 'Activează filtru .rm';
$string['mediapluginrpm'] = 'Activează filtru .rpm';
$string['mediapluginswf'] = 'Activează filtrul .swf';
$string['mediapluginswfnote'] = 'Ca măsură de securitate implicită utilizatorii nu vor avea permisiunea de a insera fişiere swf flash.';
$string['mediapluginwmv'] = 'Activează filtrul .wmv';
$string['mediapluginyoutube'] = 'Activează filtrul YouTube link';
$string['messaging'] = 'Activează sistem mesaje instant';
$string['messagingallowemailoverride'] = 'Suprascriere notificări pe email';
$string['messagingallusers'] = 'Permiteți mesageria la nivel de site';
$string['messagingcategory'] = 'Mesagerie';
$string['messagingdefaultpressenter'] = 'Folosiți Enter pentru a trimite mesaje în mod implicit';
$string['messagingdeleteallnotificationsdelay'] = 'Ștergeți toate notificările';
$string['messagingdeletereadnotificationsdelay'] = 'Șterge notificările citite';
$string['messagingssettings'] = 'Setările mesageriei';
$string['minpassworddigits'] = 'Cifre';
$string['minpasswordlength'] = 'Lungime parolă';
$string['minpasswordlower'] = 'Litere minuscule';
$string['minpasswordnonalphanum'] = 'Caractere non-alfanumerice';
$string['minpasswordupper'] = 'Litere majuscule';
$string['misc'] = 'Diverse';
$string['mlbackendsettings'] = 'Setări de backend pentru învățara automată (Machine learning )';
$string['mnetrestore_extusers'] = '<strong> Notă: </strong> Acest fișier de rezervă conține conturi de utilizator din alt sitem Moodle care vor fi restaurate ca parte a procesului.';
$string['mnetrestore_extusers_admin'] = '<strong> Notă: </strong> Acest fișier de rezervă pare să provină dintr-o altă instanță Moodle și conține conturi de utilizator din alt sistem Moodle. Procesul de restaurare va încerca să se potrivească sistemele Moodle Network pentru toți utilizatorii creați. Cei care nu se potrivesc vor fi comutați automat la autentificarea internă (în loc de una mnet). Jurnalul de restaurare vă va informa despre asta.';
$string['mnetrestore_extusers_mismatch'] = '<strong> Notă: </strong> Se pare că acest fișier de rezervă provine dintr-o altă instalare Moodle și conține conturi de utilizator de din alt sistem al rețelei Moodle care ar putea să nu se restabilească. Această operațiune nu este acceptată. Dacă sunteți sigur că a fost creat pe această instalare Moodle sau vă puteți asigura că toate gazdele de rețea Moodle necesare sunt configurate, vă recomandăm să încercați în continuare restaurarea.';
$string['mnetrestore_extusers_noadmin'] = '<strong> Notă: </strong> Acest fișier de rezervă pare să provină dintr-o altă instalare Moodle și conține conturi de utilizator la din alt sistem al rețelei Moodle. Nu aveți voie să executați acest tip de restaurare. Contactați administratorul site-ului sau, alternativ, restaurați acest curs fără informații de utilizator (module, fișiere ...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Utilizatorul din alt sistem Moodle Network {$a->username} (provenind de la {$a->mnethosturl}) a trecut la utilizatorul autentificat local {$a->auth}.';
$string['mobilenotconfiguredwarning'] = 'Aplicați Moodle nu este activată.';
$string['modassignmentinuse'] = 'Site-ul dvs. folosește în continuare pluginul Sarcina de lucru 2.2. Înainte de a face upgrade, trebuie să
1) să faceți backup tuturor activităților Sarcina de lucru 2.2 pe care doriți să le păstrați și să le restaurați ca activități Sarcina de lucru
și
2) să ștergeți toate datele activităților Sarcina de lucru 2.2 din baza de date.';
$string['modassignmentsubpluginsexist'] = '2.2. pot fi prezente subplugin-uri. Dosarul mod/assignment și toate subpluginurile sale trebuie eliminate înainte de actualizare.';
$string['modchooserdefault'] = 'Alegere implicită a activității';
$string['modeditdefaults'] = 'Valori implicite pentru setările de activitate';
$string['modsettings'] = 'Administrare activităţi';
$string['modulesecurity'] = 'Securitate modul';
$string['moodleapp'] = 'Moodle app';
$string['moodleapp_help'] = '<p> Aplicația pentru mobil Moodle este gratuită și  permite utilizatorilor să își acceseze cursurile pe dispozitive mobile. Funcțiile suplimentare ale aplicației sunt disponibile cu un plan de aplicații Pro sau Premium. </p>
<a href="https://moodle.com/mobile-app"> Descărcați aplicația Moodle </a> <br />
<a href="https://apps.moodle.com"> Portalul aplicațiilor Moodle </a>';
$string['moodlebrandedapp'] = 'Aplicația pentru mobil Moodle personalizată';
$string['moodlebrandedapp_help'] = '<p>Aplicația Moodle Personalizată are toate funcționalitățile aplicației noastre mobile gratuite pentru Moodle combinate cu propria dvs. identitate vizuală. </p>
<a href="https://moodle.com/branded-app"> Despre Aplicația Moodle Personalizată </a>';
$string['moodlebrandedappreference'] = 'Alternativ, obțineți o <a href="https://moodle.com/branded-app/">Aplicația Moodle Personalizat </a> cu propria dvs. identitate vizuală.';
$string['moodlepartners'] = 'Parteneri Moodle';
$string['moodlepartners_help'] = '<p>Partenerii Moodle sunt furnizori de servicii care sunt certificați de Moodle HQ pentru a oferi servicii Moodle de înaltă calitate pentru mediul de învățare online al organizației dvs. </p>
<a href="https://moodle.com/about-partners/"> Despre partenerii noștri </a> <br />
<a href="https://moodle.com/partners"> Găsiți un partener </a>';
$string['moodleservices'] = 'Servicii Moodle';
$string['moodleservices_help'] = 'Asigurați-vă că obțineți tot ce este mai bun de la mediul dvs. de învățare Moodle utilizând aceste servicii Moodle:';
$string['multilangforceold'] = 'Forțează vechea sintaxă multilang: &lt;span&gt; fără class="multilang"
și &lt;lang&gt;';
$string['mustenablestats'] = 'Funcţionalitatea Statistici nu a fost încă activată în cadrul acestui site.';
$string['mycourses'] = 'Cursurile mele';
$string['mycoursesperpage'] = 'Număr de cursuri';
$string['mydashboard'] = 'Tablou de bord implicit al sistemului';
$string['mymoodle'] = 'Tablou de bord';
$string['mymoodleredirect'] = 'Obligă utilizatorii să folosească My Moodle';
$string['mypage'] = 'Pagina Tablou de bord implicită';
$string['mypagelocked'] = 'Blochează pagina implicită';
$string['myprofile'] = 'Pagina de profil implicită';
$string['navadduserpostslinks'] = 'Adaugă link-uri pentru a vedea posturile utilizatorului';
$string['navadduserpostslinks_help'] = 'Dacă este activată, două linkuri vor fi adăugate fiecărui utilizator în navigare pentru a vizualiza discuțiile pe care le-a început utilizatorul și postările pe care le-a făcut utilizatorul pe forumuri pe tot site-ul sau în cursuri specifice.';
$string['navcourselimit'] = 'Limită curs';
$string['navigationupgrade'] = 'Această actualizare introduce două noi blocuri de navigare care vor înlocui aceste blocuri: Administrare, Cursuri, Activități și Participanți. Dacă ați setat permisiuni speciale pentru acele blocuri, ar trebui să verificați pentru a vă asigura că totul se comportă așa cum doriți.';
$string['navshowallcourses'] = 'Arată toate cursurile';
$string['navshowcategories'] = 'Afișează categoriile de curs';
$string['navshowfrontpagemods'] = 'Afișează activitățile de pe prima pagină în meniul de navigare';
$string['navshowfrontpagemods_help'] = 'Dacă este activată, activitățile de acasă ale site-ului vor fi afișate în navigarea în paginile site-ului. Această setare se aplică numai temelor bazate pe Classic.';
$string['navshowfullcoursenames'] = 'Afișează numele complet al cursului';
$string['navshowfullcoursenames_help'] = 'Dacă este activ, numele complete ale cursurilor vor fi utilizate în navigare, mai degrabă decât numele lor scurte.';
$string['navshowmycoursecategories'] = 'Afișează categoriile mele de curs';
$string['navshowmycoursecategories_help'] = 'Dacă este activat, cursurile din domeniul meu vor fi afișate în categorii.';
$string['navsortmycourseshiddenlast'] = 'Afișează cursurile mele ascunse la sfârșit';
$string['navsortmycourseshiddenlast_help'] = 'Dacă este activată, orice curs ascuns va fi listat după cursuri vizibile (pentru utilizatorii care pot vizualiza cursuri ascunse). În caz contrar, toate cursurile, indiferent de vizibilitatea lor, vor fi listate conform setării „Sortează cursurile mele”.';
$string['navsortmycoursessort'] = 'Ordinea cursurilor în blocul de navigare.';
$string['navsortmycoursessort_help'] = 'Cursurile ar trebui să fie listate în ordinea de sortare setată în Administrare site > Cursuri > Gestionare cursuri și categorii sau alfabetic după setarea cursului? Această setare se aplică numai temelor bazate pe tema Classic.';
$string['never'] = 'Niciodată';
$string['neverdeleteruns'] = 'Nu ștergeți niciodată rulările';
$string['newestdocindexed'] = 'Cel mai recent document indexat';
$string['nobookmarksforuser'] = 'Nu ai semne de carte.';
$string['nodatabase'] = 'Nicio bază de date';
$string['nohttpsformobilewarning'] = 'Se recomandă să activați HTTPS cu un certificat valid. Aplicația Moodle va încerca întotdeauna să utilizeze prima dată o conexiune securizată.';
$string['nomissingstrings'] = 'Nu se găsesc șiruri lipsă';
$string['none'] = 'Niciunul';
$string['nonewsettings'] = 'Actualizarea curentă nu a adăugat parametri noi.';
$string['nonexistentbookmark'] = 'Bookmark-ul solicitat nu există.';
$string['noreplyaddress'] = 'Adresă no-reply';
$string['noreplydomain'] = 'No-reply și domeniu';
$string['noreplydomaindetail'] = 'Setări pentru No-reply și domeniile configurate';
$string['noresults'] = 'N-am găsit niciun rezultat.';
$string['noroles'] = 'Nu sunt roluri';
$string['nosupportedlogstore'] = 'Nu a fost găsit istoricul logărilor';
$string['noteunneededblocks'] = 'Notă: Blocurile setate să fie afișate nu vor fi listate în meniul „Adăugați un bloc” într-un curs dacă sunt specificate în setarea temei ca fiind „Blocuri nefolosite”.';
$string['notifications'] = 'Notificări';
$string['notifyloginfailures'] = 'Trimite prin email eșecuri de autentificare la';
$string['notifyloginthreshold'] = 'Prag pentru notificări prin e-mail';
$string['notloggedinroleid'] = 'Rol pentru vizitatori';
$string['numberofmissingstrings'] = 'Șiruri netraduse: {$a}';
$string['numberofstrings'] = 'Număr total de șiruri: {$a->strings}<br />Netraduse: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Jetonul de reîmprospătare pentru unul dintre serviciile OAuth {$a->issuer} de pe site-ul dvs. {$a->siteurl} a expirat. Acest lucru va limita funcționalitatea oricăror pluginuri care utilizează acest serviciu. Pentru a remedia această problemă, vizitați pagina de configurare a serviciilor OAuth 2 și faceți clic pe pictograma „Conectare cont de sistem” din rândul tabelului pentru acest serviciu. Asigurați-vă că vă conectați folosind același cont de serviciu pentru sistemul OAuth de fiecare dată.';
$string['oauthrefreshtokenexpiredshort'] = 'Jetonul de reîmprospătare OAuth a expirat pentru {$a->issuer} de pe site-ul dvs. {$a->siteurl}.';
$string['onlynoreply'] = 'Doar când este primit de la o adresă no-reply';
$string['opcacherecommended'] = 'PHP opcode caching îmbunătățește performanța și reduce cerințele de memorie, extensia OPcache este recomandată și suportată complet.';
$string['opensslrecommended'] = 'Se recomandă instalarea librăriei OpenSSL - pentru a permite utilizarea funcţionalităţii Moodle Networking.';
$string['opensslrequired'] = 'Extensia OpenSSL PHP este acum necesară de Moodle pentru a oferi servicii criptografice mai puternice.';
$string['opentowebcrawlers'] = 'Deschis către Google';
$string['optionalmaintenancemessage'] = 'Mesaj opțional de mentenanță';
$string['oracledatabaseinuse'] = 'Suportul Oracle DB urmează să fie eliminat. Moodle 4.5 va fi ultima versiune cu suport Oracle DB. Pentru detalii, consultați anunțul pe moodle.org <a href="https://moodle.org/mod/forum/discuss.php?d=456122">Oracle database support in LMS deprecation</a>.';
$string['order1'] = 'Primul';
$string['order2'] = 'Al doilea';
$string['order3'] = 'Al treilea';
$string['order4'] = 'Al patrulea';
$string['outgoingmailconfig'] = 'Configurare trimitere e-mail';
$string['overridetossl'] = 'HTTPS pentru conectări a fost acum depreciat. Această instanță este acum forțată la SSL. Pentru a remedia acest avertisment, schimbați wwwroot din config.php la https://';
$string['pageinfodebugsummary'] = 'Această pagină este: {$a}';
$string['passwordchangelogout'] = 'Delogați-vă după schimbarea parolei';
$string['passwordchangelogout_desc'] = 'Dacă este activat, atunci în cazul schimbării unei parole, toate sesiunile browser-ului sunt încheiate, în afara celei în care este specificată noua parolă. (Această setare nu afectează modificările parolei, prin încărcarea de bulk useri).';
$string['passwordchangetokendeletion'] = 'Eliminați jetoanele de acces la serviciul web după schimbarea parolei';
$string['passwordchangetokendeletion_desc'] = 'Dacă este activată, când se schimbă o parolă, toate jetoanele de acces la serviciul web ale utilizatorului sunt șterse.';
$string['passwordpolicy'] = 'Politică parolă';
$string['passwordpolicycheckonlogin'] = 'Verificați parola la conectare';
$string['passwordresettime'] = 'Timpul maxim pentru validarea cererii de resetare a parolei.';
$string['passwordreuselimit'] = 'Limită de rotație a parolelor';
$string['passwordreuselimit_desc'] = 'De câte ori un utilizator trebuie să își schimbe parola înainte de a i se permite să reutilizeze o parolă. "Hashes" sunt parole utilizate anterior stocate în baza de date locală. Această caracteristică poate să nu fie compatibilă cu unele plugin-uri de autentificare externe.';
$string['pathtodot'] = 'Path to dot';
$string['pathtodot_help'] = 'Calea către dot. Pe Linux este ceva de forma /usr/bin/dot. Pe Windows este ceva de forma C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. Pe Mac este ceva de forma /opt/local/bin/dot. Pentru a putea genera grafică din fișiere DOT, trebuie să fiți instalat executabilul dot și să îl indicați aici.';
$string['pathtodu'] = 'Calea către du';
$string['pathtogs'] = 'Calea către ghostscript';
$string['pathtogs_help'] = 'La majoritatea instalărilor Linux, aceasta poate fi lăsată ca „/usr/bin/gs”. Pe Windows va fi ceva de forma „C:\\gs\\bin\\gswin32c.exe” (asigurați-vă că nu există spații în cale - dacă este necesar copiați fișierele „gswin32c.exe” și „gsdll32.dll” într-un folder nou fără niciun spațiu în cale)';
$string['pathtopdftoppm'] = 'Calea către pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> este o bibliotecă de randare PDF care include instrumentul pdftoppm pentru conversia fișierelor PDF în PNG. Performanța este în general mai bună decât atunci când utilizați Ghostscript, în special pentru fișierele mari. Dacă este disponibil, pdftoppm va fi folosit de preferință față de Ghostscript. La majoritatea instalărilor Linux, calea poate fi lăsată ca /usr/bin/pdftoppm. În caz contrar, trebuie să instalați pachetul poppler-utils sau poppler, în funcție de distribuția dvs. Linux. Pe Windows este furnizat de instalările Cygwin.';
$string['pathtopgdump'] = 'Calea către pg_dump';
$string['pathtopgdumpdesc'] = 'Completaţi acest câmp doar dacă aveţi mai mult de un pg_dump în sistemul dumneavoastră (de exemplu dacă aveţi instalate mai multe versiuni de postgresql)';
$string['pathtopgdumpinvalid'] = 'Calea către pg_dump este incorectă - calea furnizată nu este completă sau fişierul nu este executabil';
$string['pathtophp'] = 'Calea pentru PHP CLI';
$string['pathtopsql'] = 'Calea către psql';
$string['pathtopsqldesc'] = 'Completaţi acest câmp doar dacă aveţi mai mult de un psql în sistemul dumneavoastră (de exemplu dacă aveţi instalate mai multe versiuni de postgresql)';
$string['pathtopsqlinvalid'] = 'Calea către psql este incorectă - calea furnizată nu este completă sau fişierul nu este executabil';
$string['pathtopython'] = 'Calea către Python';
$string['pathtopythondesc'] = 'Calea către binarul Python executabil (atât Python 2, cât și Python 3 sunt acceptabile).';
$string['pathtosassc'] = 'Calea către Path to SassC';
$string['pathtosassc_help'] = 'Specificarea locației binarelor SassC va comuta compilatorul SASS de la implementarea PHP Moodle la SassC. Consultați https://github.com/sass/sassc pentru mai multe informații.';
$string['pcreunicodewarning'] = 'Estă recomandat cu tărie să utilizați extensia  PCRE PHP care este compatibilă cu caracterele Unicode.';
$string['perfdebug'] = 'Informaţii despre performanţă';
$string['performance'] = 'Performanţă';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'Parametru de versiune/cluster PostgreSQL pentru operațiuni pe linia de comandă. Dacă aveți doar un postgresql în sistemul dvs. sau nu sunteți sigur ce este acesta, lăsați acest spațiu necompletat.';
$string['phpfloatproblem'] = 'S-a detectat o problemă neașteptată în manipularea numerelor flotante PHP - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Site-ul dvs. este înregistrat. Ultima actualizare a înregistrării: {$a}.<br />Sarcina programată „Înregistrare site” vă menține înregistrarea la zi. De asemenea, puteți actualiza manual înregistrarea în orice moment.';
$string['pleaserefreshregistrationnewdata'] = 'Informațiile de înregistrare au fost modificate. Vă rugăm să o confirmați folosind butonul „Actualizați înregistrarea”.';
$string['pleaserefreshregistrationunknown'] = 'Site-ul dvs. a fost înregistrat, dar data de înregistrare este necunoscută. Vă rugăm să vă actualizați înregistrarea utilizând butonul „Actualizați înregistrarea” sau asigurați-vă că sarcina programată „Înregistrare site” este activată, astfel încât înregistrarea dvs. să fie actualizată automat.';
$string['plugin'] = 'Plugin';
$string['plugin_disabled'] = '{$a} dezactivat.';
$string['plugin_enabled'] = '{$a} activat.';
$string['plugins'] = 'Plugin-uri';
$string['pluginscheck'] = 'Verificați dependențele plugin-ului';
$string['pluginscheckfailed'] = 'A eșuat verificarea dependențelor pentru {$a->pluginslist}';
$string['pluginschecktodo'] = 'Trebuie să rezolvați toate cerințele de plugin înainte de a începe să instalați această versiune Moodle.';
$string['pluginsoverview'] = 'Listă plugin-uri';
$string['pluginsoverviewsee'] = 'Vezi <a href="{$a->url}">plugins overview</a> pagina pentru mai multe detalii.';
$string['policysettings'] = 'Setările politicilor site-ului';
$string['privacy:metadata'] = 'Plugin-ul Administrare nu stochează date personale.';
$string['privacyandpolicies'] = 'Politici de confidențialitate';
$string['privacysettings'] = 'Setări de confidențialitate';
$string['profilecategory'] = 'Categorie';
$string['profilecategoryname'] = 'Denumire categorie (trebuie să fie unică)';
$string['profilecategorynamenotunique'] = 'Numele acestei categorii este deja folosit';
$string['profilecommonsettings'] = 'Configurări uzuale';
$string['profileconfirmcategorydeletion'] = 'Acestea sunt {$a} câmpuri în această categorie care vor fi mutate în categoria de deasupra (sau de mai jos).<br />Doriți să ștergeți această categorie?';
$string['profileconfirmfielddeletion'] = 'Acestea sunt {$a} înregistrări ale utilizatorului pentru acest câmp care vor fi șterse.<br /> Doriți să ștergeți acest câmp?';
$string['profilecreatecategory'] = 'Creează un nou profil pentru categorie';
$string['profilecreatefield'] = 'Creează un nou câmp de profil';
$string['profilecreatenewcategory'] = 'Crearea unei noi categorii';
$string['profilecreatenewfield'] = 'Se creează un nou \'{$a}\' profil pentru câmp';
$string['profiledefaultcategory'] = 'Alte câmpuri';
$string['profiledefaultchecked'] = 'Selectate implicit';
$string['profiledefaultdata'] = 'Valoare implicită';
$string['profiledeletecategory'] = 'Ștergerea unei categorii';
$string['profiledeletefield'] = 'Se șterge câmpul \'{$a}\'';
$string['profiledescription'] = 'Descrierea câmpului';
$string['profiledscript'] = 'Scriptul a fost profilat';
$string['profiledscriptview'] = 'Vezi informația de profil pentru acest script';
$string['profileeditcategory'] = 'Editare categorie: {$a}';
$string['profileeditfield'] = 'Se editează câmpul de profil: {$a}';
$string['profilefield'] = 'Câmp de profil';
$string['profilefieldcolumns'] = 'Coloane';
$string['profilefieldispassword'] = 'Este câmp parolă?';
$string['profilefieldlink'] = 'Legătură';
$string['profilefieldlink_help'] = 'Pentru a transforma textul într-un link, introduceţi un URL care conţine $$, unde $$ va fi înlocuit cu textul respectiv. De exemplu, pentru a transforma un ID Twitter într-un link, introduceţi http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Ținta legătură';
$string['profilefieldmaxlength'] = 'Limita de caractere';
$string['profilefieldmaxlength_help'] = 'Pentru a utiliza acest câmp în setarea „Afișați identitatea utilizatorului”, limita trebuie să fie de 255 de caractere sau mai puțin.';
$string['profilefieldrows'] = 'Rânduri';
$string['profilefields'] = 'Câmpuri profil utilizator';
$string['profilefieldsize'] = 'Dimensiune afişare';
$string['profileforceunique'] = 'Datele sunt unice?';
$string['profileinvaliddata'] = 'Valoare incorectă';
$string['profilelocked'] = 'Acest câmp este blocat?';
$string['profilemenudefaultnotinoptions'] = 'Valoarea implicită nu se regăseşte printre opţiunile disponibile';
$string['profilemenunooptions'] = 'Meniul nu conţine nicio opţiune';
$string['profilemenuoptions'] = 'Opţiuni meniu (una pe fiecare linie)';
$string['profilemenutoofewoptions'] = 'Trebuie să furnizaţi cel puţin 2 opţiuni';
$string['profilename'] = 'Nume';
$string['profilenofieldsdefined'] = 'Nu a fost definit niciun câmp';
$string['profilerequired'] = 'Câmp obligatoriu?';
$string['profileroles'] = 'Roluri vizibile ale profilului';
$string['profilesforenrolledusersonly'] = 'Secţiunea Profil disponibilă doar pentru utilizatorii înscrişi la cursuri';
$string['profileshortname'] = 'Nume prescurtat (trebuie să fie unic)';
$string['profileshortnameinvalid'] = 'Acest nume prescurtat poate să conțină doar caractere alfanumerice (litere și numere) sau underscore (_).';
$string['profileshortnamenotunique'] = 'Acest nume prescurtat este deja folosit';
$string['profilesignup'] = 'Afişează pe pagina de înscriere?';
$string['profilespecificsettings'] = 'Setări specifice';
$string['profilevisible'] = 'Pentru cine este vizibil acest câmp?';
$string['profilevisible_help'] = '* Nu este vizibil - Pentru date cu caracter personal vizibile numai de către administratori și manageri
* Vizibil pentru utilizator - Pentru date cu caracter personal vizibile de către utilizator şi de către administratori
* Vizibil pentru utilizator, profesori și admini - Pentru date cu caracter personal vizibile de către utilizator, administratori și profesori (în profilul cursului)
* Vizibile pentru toată lumea';
$string['profilevisibleall'] = 'Vizibil pentru toţi';
$string['profilevisiblenone'] = 'Invizibil';
$string['profilevisibleprivate'] = 'Vizibil pentru utilizatorul';
$string['profilevisibleteachers'] = 'Vizibil pentru utilizator, profesori și administratori';
$string['profiling'] = 'Profilare';
$string['profilingallowall'] = 'Profilare continuă';
$string['profilingallowall_help'] = 'Dacă activați această setare, atunci, în orice moment, puteți utiliza parametrul PROFILEALL oriunde (PGC) pentru a activa profilarea pentru toate scripturile executate în timpul sesiunii Moodle. În mod similar, puteți utiliza parametrul PROFILEALLSTOP pentru a-l opri.';
$string['profilingallowme'] = 'Profilare selectivă';
$string['profilingallowme_help'] = 'Dacă activați această setare, pe urmă, în mod selectiv, puteți utiliza PROFILEME peste tot (PGC) și va avea loc profilarea pentru acel script. La fel, puteți utiliza parametrul DONTPROFILEME pentru a preveni profilarea';
$string['profilingautofrec'] = 'Profilare automată';
$string['profilingautofrec_help'] = 'Prin configurarea acestei setări, unele cereri (aleatorii, bazate pe frecvența specificată - 1 din N) vor fi selectate și profilate automat, stocând rezultatele pentru o analiză ulterioară. Rețineți că acest mod de profilare respectă setările de includere / excludere. Setați-l la 0 pentru a dezactiva profilarea automată.';
$string['profilingenabled'] = 'Activați profilarea';
$string['profilingenabled_help'] = 'Dacă activați această setare, atunci profilarea va fi disponibilă pe acest site și veți putea defini comportamentul acesteia configurând următoarele opțiuni.';
$string['profilingexcluded'] = 'Excludeți profilarea';
$string['profilingexcluded_help'] = 'Lista URL-urilor (separate prin virgulă sau linie nouă, excluzând wwwroot, apelabile) URL-urile care vor fi excluse de la profilarea celor definite prin setarea „Profilează acestea”.';
$string['profilingimportprefix'] = 'Prefixului de import';
$string['profilingimportprefix_desc'] = 'Pentru o detecție mai ușoară, toate rulările de profilare importate vor fi prefixate cu valoarea specificată aici.';
$string['profilingincluded'] = 'Profilați aceste';
$string['profilingincluded_help'] = 'Lista URL-urilor (separate prin virgulă sau linie nouă, excluzând wwwroot, apelabile) URL-uri care vor fi profilate automat. Exemple: /index.php, /course/view.php. De asemenea, acceptă wildchar-ul * în orice poziție. Exemple: /mod/forum/ *, /mod/*/view.php.';
$string['profilinglifetime'] = 'Profilarea rulează în continuare';
$string['profilinglifetime_help'] = 'Specificați timpul cât doriți să păstrați informații despre vechile rulări de profilare. Cele mai vechi vor fi eliminate periodic. Rețineți că acest lucru exclude orice execuție de profilare marcată ca „execuție de referință”.';
$string['profilingslow'] = 'Profilează paginile lente';
$string['profilingslow_help'] = 'Prin setarea unui timp minim în secunde, toate paginile mai încete vor fi profilate. Se vor păstra numai profilurile care sunt mai lente decât un profil existent pentru același script. Setați la 0 pentru a dezactiva. Rețineți că acest lucru respectă setările de excludere.';
$string['protectusernames'] = 'Protejează nume utilizatori';
$string['proxybypass'] = 'Gazdă proxy bypass';
$string['proxyfixunsafe'] = 'Remediați apelurile care nu trec prin proxi';
$string['proxyhost'] = 'Proxy host';
$string['proxylogunsafe'] = 'Jurnalizați apelurile care nu trec prin proxi';
$string['proxypassword'] = 'Parolă proxy';
$string['proxyport'] = 'Port proxy';
$string['proxytype'] = 'Tip proxy';
$string['proxyuser'] = 'Nume utilizator proxy';
$string['purgecaches'] = 'Ștergeți toată memoria cache';
$string['purgecachesconfirm'] = 'Moodle poate memora în cache teme, javascript, șiruri de limbă, text filtrat, fluxuri RSS și multe alte bucăți de date calculate. Ștergerea acestor fișiere cache va șterge acele date de pe server și va forța browserele să recupereze datele, astfel încât să puteți fi siguri că vedeți cele mai actualizate valori produse de codul curent. Nu există niciun pericol în curățarea cache-urilor, dar site-ul dvs. poate părea mai lent pentru o vreme până când serverul și clienții calculează informații noi și le stochează în cache.';
$string['purgecachesfinished'] = 'Toată memoria cache a fost ștearsă';
$string['purgecachesnoneselected'] = 'Selectați unul sau mai multe fișiere cache pentru a le șterge';
$string['purgecachespage'] = 'Ștergeți fișierele cache';
$string['purgefiltercache'] = 'Filtre text';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Șiruri de limbă';
$string['purgemuc'] = 'Toate fișierele MUC cache';
$string['purgeothercaches'] = 'Toate cache-urile de fișiere și diverse';
$string['purgeselectedcaches'] = 'Ștergeți fișierele cache selectate';
$string['purgeselectedcachesfinished'] = 'Fișierele cache selectate au fost șterse';
$string['purgetemplates'] = 'Șabloane';
$string['purgethemecache'] = 'Teme';
$string['query'] = 'Întrebare';
$string['question'] = 'Întrebare';
$string['questionbehaviours'] = 'Funcționalitățile întrebării';
$string['questioncwqpfscheck'] = 'Una sau mai multe întrebări aleatorii dintr-un test sunt configurate pentru a selecta întrebări dintr-un set de categorii de întrebări partajate și nepartajate. Consultați <a href="{$a->reporturl}">raportul cu întrebări aleatorii</a> și <a href="{$a->docsurl}">documentația</a>.';
$string['questioncwqpfsok'] = 'Perfect! Nu există întrebări „aleatorii” în testele dvs. care sunt configurate pentru a selecta întrebări dintr-un set de categorii de întrebări partajate și nepartajate.';
$string['questiontype'] = 'Tip de întrebare';
$string['questiontypes'] = 'Tipuri de întrebări';
$string['quizattemptsupgradedmessage'] = 'În Moodle 2.1 a avut loc un upgrade major la întrebări. Este posibil să se fi întârziat părți ale bazei de date actualizate pentru a fi rulate mai târziu. Înainte de a face upgrade la Moodle 2.7, acest upgrade trebuie să fie complet.';
$string['recaptchaprivatekey'] = 'Cheie secretă ReCAPTCHA';
$string['recaptchapublickey'] = 'Cheia ReCAPTCHA a site-ului';
$string['referrernone'] = 'Navigator implicit';
$string['referrerpolicy'] = 'Politica de utilizare a referitorului';
$string['referrerpolicydesc'] = 'Setați antetul politicii referitorului pentru a fi inclus cu răspunsurile de pe site-ul dvs.';
$string['register'] = 'Înregistrează site-ul';
$string['registration'] = 'Înregistrare';
$string['registration_help'] = 'Prin înregistrare:

* Veți primi alerte de securitate
* Puteți activa notificările push de aplicații mobile de pe site-ul dvs.
* Contribuiți la statisticile noastre Moodle ale comunității mondiale';
$string['registrationwarning'] = 'Site-ul dvs. nu este încă înregistrat.';
$string['registrationwarningcontactadmin'] = 'Site-ul dumneavoastră nu este încă înregistrat. Vă rugăm să anunțați administratorul.';
$string['releasenoteslink'] = 'Pentru informații referitoare la această versiune Moodle, vedeți <a target="_blank" href="{$a}">Informații versiune lansată</a>';
$string['rememberuserlicensepref'] = 'Rețineți preferința de licență a utilizatorului';
$string['rememberuserlicensepref_help'] = 'Dacă este activată, ultima licență selectată de utilizator este preselectată la încărcarea unui fișier în selectorul de fișiere. În caz contrar, licența implicită a site-ului este preselectată.';
$string['rememberusername'] = 'Ține minte numele de utilizator';
$string['rememberusername_desc'] = 'Activați dacă doriți să stocați cookie-uri permanente cu nume de utilizator în timpul conectării utilizatorului. Cookie-urile permanente pot fi considerate o problemă de confidențialitate dacă sunt utilizate fără consimțământ.';
$string['replacefrontsearch'] = 'Utilizat pentru căutarea cursului pe pagina principală';
$string['reportsmanage'] = 'Administrare rapoarte';
$string['required'] = 'Necesar';
$string['requiredentrieschanged'] = 'Notă: După actualizare, setarea „Intrări obligatorii înainte de vizualizare” este acum aplicată în următoarele activități ale bazei de date: <br/> {$a->text} <br/>';
$string['requiremodintro'] = 'Necesită descriere activitate';
$string['requiremodintro_desc'] = 'Dacă este activ, utilizatorii vor trebui să insereze o descriere pentru fiecare activitate.';
$string['requires'] = 'Necesită';
$string['resetindentation'] = 'Restează indentarea pe tot site-ul';
$string['resetindentation_help'] = 'Această acțiune va elimina orice indentare setată anterior pentru toate cursurile din site în {$a->format}.';
$string['resetindentation_title'] = 'Resetează indentarea în tot cursul?';
$string['resetindentationsuccess'] = 'Resetarea indentării.';
$string['restorecourse'] = 'Restaurează curs';
$string['restorernewroleid'] = 'Rolul restauratorilor la cursuri';
$string['restorernewroleid_help'] = 'Dacă utilizatorul nu are deja permisiunea de a gestiona cursul nou restaurat, utilizatorului i se atribuie automat acest rol și este înscris, dacă este necesar. Selectați „Nici unul” dacă nu doriți ca restauratorii să poată gestiona fiecare curs restaurat.';
$string['resultfilter'] = 'Filtrați pe baza rezultatelor';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Ignorați proxy-urile inverse';
$string['riskconfig'] = 'Utilizatorii ar putea avea posibilitatea de a modifica configurarea şi comportamentul sitului';
$string['riskconfigshort'] = 'Risc configurare';
$string['riskdataloss'] = 'Utilizatorii ar putea distruge cantități mari de conținut sau informații';
$string['riskdatalossshort'] = 'Risc de pierdere a datelor';
$string['riskmanagetrust'] = 'Utilizatorii ar putea avea posibilitatea de a modifica setările de siguranţă ale altor utilizatori';
$string['riskmanagetrustshort'] = 'Administrare setări siguranţă';
$string['riskpersonal'] = 'Utilizatorii ar putea avea posibilitatea să obţină acces la informaţii confidenţiale despre alţi utilizatori';
$string['riskpersonalshort'] = 'Risc confidenţialitate';
$string['riskspam'] = 'Utilizatorii ar putea avea posibilitatea de a trimite spam la alţi utilizatori ai acestui sit sau ai altor situri';
$string['riskspamshort'] = 'Risc de spam';
$string['riskxss'] = 'Utilizatorii ar putea avea posibilitatea de a adăuga fişiere şi texte care să permită cross-site scripting (XSS)';
$string['riskxssshort'] = 'Risc XSS';
$string['roleswithexceptions'] = '{$a->roles}, cu {$a->exceptions}';
$string['rssglobaldisabled'] = 'Dezactivat la nivel de site';
$string['save'] = 'Salvează';
$string['savechanges'] = 'Salvează modificările';
$string['scssinvalid'] = 'Codul SCSS nu este valid, eșuează cu: {$a}';
$string['search'] = 'Căutare';
$string['searchablecourses'] = 'Cursuri care pot fi căutate';
$string['searchallavailablecourses'] = 'Cursuri care se pot căuta';
$string['searchallavailablecourses_desc'] = 'În unele situații, este posibil ca motorul de căutare să nu funcționeze atunci când caută într-un număr mare de cursuri. Setați să căutați numai cursuri înscrise dacă trebuie să restricționați numărul de cursuri căutate.';
$string['searchallavailablecourses_off'] = 'Caută doar în cursurile la care sunteți înscris';
$string['searchallavailablecourses_on'] = 'Caută în cursurile pe care utilizatorul le poate accesa';
$string['searchallavailablecoursesdesc'] = 'Dacă este setat să caute numai în cadrul cursurilor înscrise, informațiile despre curs (numele și rezumatul) și conținutul cursului vor fi căutate numai în cursurile la care este înscris utilizatorul. În caz contrar, informațiile despre curs și conținutul cursului vor fi căutate în toate cursurile la care utilizatorul poate accesa , cum ar fi cursurile cu acces pentru oaspeți activat.';
$string['searchalldeleted'] = 'Toate conținuturile indexate au fost șterse';
$string['searchalternatesettings'] = 'Setări numai pentru interogări alternative';
$string['searchalternatesettings_desc'] = 'Dacă completați aceste setări, puteți selecta „setări alternative” pentru acest motor de căutare în opțiunea motorului de căutare numai pentru interogare din pagina „Gestionați căutarea globală”. Acest lucru este util numai când vă deplasați între două motoare de căutare de același tip.';
$string['searchareadisabled'] = 'Zonele de căutare sunt dezactivate';
$string['searchareaenabled'] = 'Zonele de căutare sunt activate';
$string['searchareas'] = 'Zone de căutare';
$string['searchbanner'] = 'Caută informații';
$string['searchbannerenable'] = 'Afișați informațiile despre căutare';
$string['searchbannerenable_desc'] = 'Dacă este activat, textul de mai jos va fi afișat în partea de sus a ecranului de căutare pentru toți utilizatorii. Aceasta poate fi utilizată pentru a informa utilizatorii atunci când se efectuează întreținerea motorului de căutare.';
$string['searchdefaultcategory'] = 'Categorie implicită de căutare';
$string['searchdefaultcategory_desc'] = 'Rezultatele din zona de căutare selectată vor fi afișate în mod implicit.';
$string['searchdeleteindex'] = 'Ștergeți toate conținuturile indexate';
$string['searchdisplay'] = 'Caută opțiunile de afișare a rezultatelor';
$string['searchenablecategories'] = 'Afișează rezultatele în categorii separate';
$string['searchenablecategories_desc'] = 'Dacă este activată această opțiune, rezultatele căutării vor fi afișate în categorii separate.';
$string['searchengine'] = 'Motor de căutare';
$string['searchenginealternatesettings'] = '{$a} (setări alternative)';
$string['searchenginequeryonly'] = 'Motor de căutare numai pentru interogări';
$string['searchenginequeryonly_desc'] = 'Acest motor de căutare va fi utilizat numai pentru a face interogări, nu pentru indexare. Utilizând această caracteristică puteți reindexa într-un alt motor de căutare, în timp ce interogările utilizatorilor continuă să funcționeze de la aceasta.';
$string['searchenginequeryonly_none'] = 'Niciuna (utilizați motorul de căutare principal pentru interogări)';
$string['searchenginequeryonlysame'] = 'Motorul de căutare numai pentru interogare și motorul principal de căutare nu pot fi setate la aceeași valoare.';
$string['searchhideallcategory'] = 'Ascunde categoria Toate rezultatele';
$string['searchhideallcategory_desc'] = 'Dacă este bifată, categoria cu toate rezultatele va fi ascunsă pe ecranul rezultatelor căutării.';
$string['searchincludeallcourses'] = 'Includeți toate cursurile vizibile';
$string['searchincludeallcourses_desc'] = 'Dacă este activată, rezultatele căutării vor include informații despre curs (numele și rezumatul) cursurilor care sunt vizibile pentru utilizator, chiar dacă nu au acces la conținutul cursului.';
$string['searchindexactions'] = 'Acțiuni de indexare';
$string['searchindexdeleted'] = 'Indexul a fost eliminat';
$string['searchindextime'] = 'Timp limită de indexare';
$string['searchindextime_desc'] = 'Când se indexează cantități mari de conținut nou, cronul se va opri după atingerea acestui termen. Va continua data viitoare când va rula cronul.';
$string['searchindexupdated'] = 'Actualizările din conținuturile motorului de căutare au fost actualizate';
$string['searchindexwhendisabled'] = 'Indexați atunci când este dezactivat';
$string['searchindexwhendisabled_desc'] = 'Permite cronului să creeze indexul de căutare chiar și atunci când căutarea este dezactivată. Acest lucru este util dacă doriți să construiți indexul înainte ca facilitatea de căutare să apară studenților.';
$string['searchinsettings'] = 'Căutare în setări';
$string['searchlastrun'] = 'Ultima rulare (time, # docs, # records, # ignores)';
$string['searchmanagement'] = 'Managementul căutărilor';
$string['searchmanagement_desc'] = 'Aceste opțiuni sunt utile atunci când efectuați modificări pe site-uri cu indexuri de căutare foarte mari, care necesită mult timp pentru a fi reconstruite.';
$string['searchmaxtopresults'] = 'Numărul maxim de rezultate afișate';
$string['searchmaxtopresults_desc'] = 'Numărul maxim de rezultate cu cel mai bine clasat care vor fi afișate deasupra rezultatelor căutării pentru conținutul cursurilor, cursuri și utilizatori.';
$string['searchnotavailable'] = 'Căutarea nu este disponibilă';
$string['searchoptions'] = 'Opțiuni de căutare';
$string['searchpartial'] = '(nu este complet indexat încă)';
$string['searchreindexed'] = 'Tot conținutul site-urilor a fost reindexat.';
$string['searchreindexindex'] = 'Reindexează tot conținutul site-urilor';
$string['searchresults'] = 'Rezultatele căutării';
$string['searchsetupinfo'] = 'Caută setup';
$string['searchteacherroles'] = 'Rolurile profesorului';
$string['searchteacherroles_desc'] = 'Selectați toate rolurile care determină ca utilizatorii cu rol mai înalt să apară primii în lista de căutări.';
$string['searchtopresults'] = 'Numărul maxim de rezultate';
$string['searchupdateindex'] = 'Actualizează conținuturile indexate';
$string['sectionerror'] = 'Eroare secțiune!';
$string['secureforms'] = 'Folosește o formă suplimentară de securitate';
$string['security'] = 'Securitate';
$string['selectdevice'] = 'Selectează dispozitivul';
$string['selectsearchengine'] = 'Selectează mototul de căutare';
$string['selecttheme'] = 'Selectează tema pentru dispozitivul {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Verificări server';
$string['serverlimit'] = 'Limită server';
$string['servicespage'] = 'Link pentru servicii și suport';
$string['sessionautostartwarning'] = '<p>Au fost detectate probleme grave de configurare, vă rugăm să anunțați administratorul serverului.</p><p> Pentru ca Moodle să funcționeze corespunzător, administratorul trebuie să modifice setările PHP.</p><p>
<code>session.auto_start</code> must be set to <code>off</code>.</p><p>Această setare este controlată prin editarea <code>php.ini</code>,
Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['sessioncookie'] = 'Prefix cookie';
$string['sessioncookiedomain'] = 'Domeniu cookie';
$string['sessioncookiepath'] = 'Cale cookie';
$string['sessionhandling'] = 'Gestionarea sesiunii';
$string['sessiontimeout'] = 'Timeout';
$string['sessiontimeoutwarning'] = 'Avertisment expirare';
$string['settingdependenton'] = 'Această setare poate fi ascunsă, pe baza valorii <strong> {$a} </strong>.';
$string['settingfileuploads'] = 'Încărcarea fișierului este necesară pentru funcționarea normală, vă rugăm să o  activați în configurarea PHP.';
$string['settingmaxinputvars'] = 'PHP setting max_input_vars este recomandat să fie cel puțin 5000.';
$string['settingmaxinputvarsrequired'] = 'PHP setting max_input_vars trebuie să fie cel puțin 5000.';
$string['settingmemorylimit'] = 'S-a detectat memorie insuficientă, vă rugăm să setați o limită mai mare de memorie în setările PHP.';
$string['settingsafemode'] = 'Moodle nu este compatibil cu safe mode, vă rugăm să solicitați administratorului serverului să îl închidă. Moodle nu poate rula în safe mode, pot apărea unele probleme.';
$string['setupsearchengine'] = 'Setați motorul de căutare';
$string['showcommentscount'] = 'Afișează numărul de comentarii';
$string['showdetails'] = 'Afișează detalii';
$string['showuseridentity'] = 'Afișează identitatea utilizatorului';
$string['showuseridentity_desc'] = 'Când selectați sau căutați utilizatori și când afișați liste de utilizatori, aceste câmpuri pot fi afișate pe lângă numele lor complet. Câmpurile sunt afișate numai utilizatorilor care au moodle / site-ul: viewuseridentity capability; implicit, profesori și manageri. (Această opțiune contează cel mai mult dacă alegeți unul sau două câmpuri obligatorii la instituția dumneavoastră.)

Câmpurile marcate cu * sunt câmpuri de profil de utilizator personalizate. Puteți selecta aceste câmpuri, dar sunt în prezent câteva pagini în care nu vor fi afișate.';
$string['simplexmlrequired'] = 'Extensia SimpleXML PHP este acum obligatorie pentru Moodle';
$string['sitemailcharset'] = 'Character set';
$string['sitemaintenance'] = 'Acest sit este în proces de depanare şi nu este disponibil la acest moment';
$string['sitemaintenancemode'] = 'Mod Depanare';
$string['sitemaintenanceoff'] = 'Modul Depanare a fost dezactivat şi situl funcţionază acum normal';
$string['sitemaintenanceon'] = 'Situl dumneavoastră este în acest moment în modul Depanare (doar utilizatorii administratori se pot loga şi utiliza situl)';
$string['sitemaintenanceoncli'] = 'Site-ul dumneavoastră este în prezent în modul de mentenanță CLI, nu este permis accesul web.';
$string['sitemaintenancetitle'] = '{$a} în mentenanță';
$string['sitemaintenancewarning'] = 'Situl dumneavoastră este acum în modul Depanare (doar utilizatorii administratori se pot loga). Pentru a reveni la modul normal de funcţionare  sitului, <a href="maintenance.php">dezactivează Mod Depanare</a>.';
$string['sitemaintenancewarning2'] = 'Site-ul dumneavoastră  este în prezent în modul de mentenanță (doar administratorii se pot conecta). Pentru a reveni  la funcționarea normală, <a href="{$a}"> dezactivați modul de mentenanță </a>.';
$string['sitemenubar'] = 'Navigare pe site';
$string['sitenameintitle'] = 'Include denumirea site-ului în titlul paginii';
$string['sitenameintitle_help'] = 'Această setare va adăuga numele site-ului la sfârșitul titlului paginii. Este încurajat să includeți numele site-ului în titlul paginii, deoarece va îmbunătăți accesibilitatea site-ului, permițând utilizatorilor să identifice rapid pagina în care se află în prezent.';
$string['sitepolicies'] = 'Setări de securitate';
$string['sitepolicy'] = 'URL politici site';
$string['sitepolicy_help'] = 'Adresa URL a politicii site-ului pe care toți utilizatorii înregistrați trebuie să o vadă și să o accepte înainte de a accesa site-ul. Rețineți că această setare va avea efect numai dacă gestionarul de politici de site este setat la valorile implicite (nucleu).';
$string['sitepolicyguest'] = 'URL politici site pentru vizitatori';
$string['sitepolicyguest_help'] = 'Adresa URL a politicii site-ului pe care toți vizitatorii trebuie să o vadă și să fie de acord înainte de a accesa site-ul. Rețineți că această setare va avea efect numai dacă gestionarul de politici de site este setat la valorile implicite (nucleu).';
$string['sitepolicyhandler'] = 'Managerul politicii site-ului';
$string['sitepolicyhandler_desc'] = 'Determină modul în care sunt gestionate politicile și acordul utilizatorului. Managerul implicit (de bază) permite specificarea unei adrese URL a politicii de site și a unei adrese URL a politicii de site pentru vizitatori. Managerul de politici permite setarea politicilor privind site-ul, confidențialitatea și alte politici. De asemenea, permite vizualizarea consimțământului utilizatorului și, dacă este necesar, acordul în numele minorilor.';
$string['sitepolicyhandlercore'] = 'Implicit (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Dacă este selectat, o secțiune de subiect va fi afișată pe pagina de pornire a site-ului.';
$string['sixtyfourbitsrequired'] = 'S-a detectat că site-ul tău nu utilizează o versiune PHP pe 64 de biți. Trrebuie să îți actualizezi sistemul (sistemul de operare, PHP...) înainte de a instala această versiune Moodle.';
$string['sixtyfourbitswarning'] = 'S-a detectat că site-ul dvs. nu folosește o versiune PHP pe 64 de biți. Este recomandat să vă actualizați site-ul pentru a asigura compatibilitatea cu versiunile Moodle viitoare.';
$string['slasharguments'] = 'Foloseşte slash arguments';
$string['slashargumentswarning'] = 'Este recomandat ca utilizarea argumentelor slash să fie activată. În viitor va fi necesar. Pentru mai multe detalii, consultați documentația <a href="https://docs.moodle.org/en/admin/environment/slasharguments"> Utilizarea argumentelor slash </a>.';
$string['smartpix'] = 'Căutare Smart pix';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Tipul autentificării SMTP';
$string['smtpdetail'] = 'Setările Simple Mail Transfer Protocol (SMTP) pentru trimiterea email-ului.';
$string['smtphosts'] = 'Gazde SMTP';
$string['smtpmaxbulk'] = 'Limită sesiune SMTP';
$string['smtppass'] = 'Parolă SMTP';
$string['smtpsecure'] = 'Securitate SMTP';
$string['smtpuser'] = 'Nume utilizator SMTP';
$string['soaprecommended'] = 'Instalarea extensiei SOAP opționale este utilă pentru serviciile web și unele plugin-uri.';
$string['sort_fullname'] = 'Denumirea completă a cursului';
$string['sort_idnumber'] = 'Numărul cursului';
$string['sort_shortname'] = 'Prescurtarea denumirii cursului';
$string['sort_sortorder'] = 'Sortează ordinea';
$string['spellengine'] = 'Corectorul de scriere';
$string['spelllanguagelist'] = 'Lista de limbi pentru corectorul de scriere';
$string['splrequired'] = 'Extensia SPL PHP este acum necesară pentru Moodle.';
$string['stats'] = 'Statistici';
$string['statsfirstrun'] = 'Interval maxim de procesare';
$string['statsmaxruntime'] = 'Durata maximă de rulare';
$string['statsmoodleorg'] = 'statistici';
$string['statsruntimedays'] = 'Zile de procesat';
$string['statsruntimestart'] = 'Porneşte la';
$string['statsuserthreshold'] = 'Limită utilizator';
$string['stickyblocks'] = 'Blocuri permanente';
$string['stickyblockscourseview'] = 'Pagină curs';
$string['stickyblocksduplicatenotice'] = 'Dacă adăugaţi aici un bloc ce există deja în cadrul unei pagini, se va crea un duplicat.<br/>Blocul fix nu va putea fi modificat, blocul duplicat va putea fi modificat.';
$string['stickyblocksmymoodle'] = 'My Moodle';
$string['stickyblockspagetype'] = 'Tipul paginii de configurat';
$string['strictformsrequired'] = 'Validare strictă a câmpurilor necesare';
$string['stripalltitletags'] = 'Ştergeţi etichetele HTML din numele tuturor activităţilor';
$string['supportandservices'] = 'Suport și servicii';
$string['supportavailability'] = 'Disponibilitate suport';
$string['supportcontact'] = 'Contact suport';
$string['supportemail'] = 'Email suport';
$string['supportemailsubject'] = 'Solicitare de suport pe site - {$a}';
$string['supportname'] = 'Denumirea activității de suport';
$string['supportpage'] = 'Link pagină de suport';
$string['suspenduser'] = 'Suspendare cont de utilizator';
$string['switchlang'] = 'Comutator director lang';
$string['systempaths'] = 'Căi de sistem';
$string['tablenosave'] = 'Schimbările în tabelul de mai sus sunt salvate automat';
$string['tablesnosave'] = 'Schimbările în tabelele de mai sus sunt salvate automat.';
$string['tabselectedtofront'] = 'În cazul tabelelor cu taburi, rândul din tabela selectată să fie afişat în prim plan?';
$string['tabselectedtofronttext'] = 'Tab selectat -- în prim plan';
$string['task_adhoc_concurrency_limit'] = 'Limită de concurență a sarcinilor ad hoc';
$string['task_adhoc_concurrency_limit_desc'] = 'Numărul de procese de sarcini ad hoc autorizate să ruleze simultan. Dacă limita este ridicată, sarcinile programate pot să nu ruleze regulat atunci când se găsesc un număr prea mare de sarcini ad hoc. Setarea 0 va dezactiva complet procesarea sarcinilor ad hoc.';
$string['task_adhoc_max_runtime'] = 'Durată de viață a proceselor de sarcini ad hoc';
$string['task_adhoc_max_runtime_desc'] = 'Durata unui proces de sarcini ad hoc înainte de a fi oprit. Se recomandă o durată redusă, deoarece nu este nicio limită a numărului de sarcini ad hoc în coadă. Dacă acest număr este prea mare și aveți o coadă mare de sarcini ad hoc, este posibil ca sarcinile programate să nu fie executate în mod regulat.';
$string['task_dbreads'] = 'Citiri din baza de date';
$string['task_dbstats'] = 'Bază de date';
$string['task_dbwrites'] = 'Scrieri în bazei de date';
$string['task_duration'] = 'Durata';
$string['task_endtime'] = 'Sfârșitul timpului';
$string['task_logmode'] = 'Când să se facă jurnalizarea';
$string['task_logmode_all'] = 'Stocați vizualizarea jurnalului tuturor sarcinilor';
$string['task_logmode_desc'] = 'Puteți alege când doriți să aibă loc înregistrarea sarcinilor. În mod implicit, jurnalele sunt înregistrate întotdeauna. Puteți dezactiva complet înregistrarea jurnalului sau puteți trece la jurnalul de sarcini care nu se execută.';
$string['task_logmode_failonly'] = 'Stocați jurnalele numai pentru procesele care nu se finalizează cu succes';
$string['task_logmode_none'] = 'Nu înregistra nimic';
$string['task_logoutput'] = 'Rezultatul rezolvării procesului';
$string['task_logretainruns'] = 'Păstrează procesele rulate';
$string['task_logretainruns_desc'] = 'Numărul de rulări ale fiecărei sarcini de păstrat. Această setare interacționează cu setarea „Perioadă de păstrare”: se va aplica cel care a rulat mai întâi.';
$string['task_logretention'] = 'Perioada de retenție';
$string['task_logretention_desc'] = 'Perioada maximă pentru care trebuie păstrate jurnalele. Această setare interacționează cu setarea „Perioadă de păstrare”: se va aplica cel care a rulat mai întâi';
$string['task_logtostdout'] = 'Afișare ieșire jurnal';
$string['task_logtostdout_desc'] = 'Când procesele rulează și ieșirea este capturată, dacă ieșirea capturată ar trebui să fie afișată și pe măsură ce se execută sarcina.';
$string['task_result'] = 'Rezultat';
$string['task_result:failed'] = 'Eșuare';
$string['task_scheduled_concurrency_limit'] = 'Limită de concurență a sarcinilor programate';
$string['task_scheduled_concurrency_limit_desc'] = 'Numărul de proceselor de sarcini planificate care pot rula simultan. Dacă limita este mare, atunci serverul poate experimenta o încărcare mare care afectează performanța. O setare 0 va dezactiva complet procesarea sarcinilor programate.';
$string['task_scheduled_max_runtime'] = 'Durata de viață a procesatorului de sarcini rulate';
$string['task_scheduled_max_runtime_desc'] = 'Durata de viață a unui proces cron programat înainte de a fi oprit.';
$string['task_starttime'] = 'Ora start';
$string['task_stats:dbreads'] = '{$a} citiri';
$string['task_stats:dbwrites'] = '{$a} scrieri';
$string['task_status'] = 'Status proces în execuție';
$string['task_status_desc'] = 'Sarcina de lucru \'{$a->name}\' este {$a->status}. Pentru detalii, vedeți {$a->class} în <a href="{$a->gotourl}">Sarcini de lucru programate</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Programat';
$string['taskadmintitle'] = 'Task-uri';
$string['taskanalyticscleanup'] = 'Golește modelele analitice';
$string['taskautomatedbackup'] = 'Back-up-uri automate';
$string['taskautomatedbackup_report'] = 'Automatizare rapoarte de backup';
$string['taskbackupcleanup'] = 'Șterge tabelele de backup, jurnalizarea și fișierele';
$string['taskbadgesadhoc'] = 'Acordă ecuson';
$string['taskbadgescron'] = 'Adăugați procese de execuție adhoc pentru acordarea ecusoanelor';
$string['taskbadgesmessagecron'] = 'Procesare în fundal pentru trimiterea notificărilor de ecusoane';
$string['taskblogcron'] = 'Sincronizați bloguri externe';
$string['taskcachecleanup'] = 'Elimină intrările cache expirate';
$string['taskcachecron'] = 'Procesare background pentru memoria cache';
$string['taskcalendarcron'] = 'Trimite notificări din calendar';
$string['taskcheckforupdates'] = 'Verifică actualizările';
$string['taskcompletiondaily'] = 'Completarea marcată ca începută';
$string['taskcompletionregular'] = 'Calculează regulat datele de finalizare';
$string['taskcontextcleanup'] = 'Șterge contextele';
$string['taskcreatecontexts'] = 'Creează contexte lipsă';
$string['taskdeletecachetext'] = 'Șterge vechile înregistrări de text cache';
$string['taskdeleteincompleteusers'] = 'Șterge utilizatorii cu date incomplete';
$string['taskdeleteunconfirmedusers'] = 'Șterge utilizatorii neconfirmati';
$string['taskeventscron'] = 'Procesare background pentru evenimente';
$string['taskfiletrashcleanup'] = 'Șterge fișierele în trash';
$string['taskglobalsearchindex'] = 'Indexarea căutării generale';
$string['taskglobalsearchoptimize'] = 'Optimizarea căutării generale';
$string['taskgradecron'] = 'Procesare background pentru catalog';
$string['taskgradehistorycleanup'] = 'Prelucrare în fundal a curățării tabelelor cu istoric de note';
$string['taskh5pcleanup'] = 'Ștergerea fișierelor neutilizate H5P';
$string['tasklegacycron'] = 'Rularea cronului pentru pluginuri';
$string['tasklockcleanuptask'] = 'Curățați metadatele sarcinilor ad-hoc';
$string['tasklogcleanup'] = 'Curățarea jurnalelor sarcinilor executate';
$string['tasklogging'] = 'Configurarea jurnalului de activități';
$string['tasklogs'] = 'Jurnalele de activități';
$string['taskmessagingcleanup'] = 'Procesare de fundal pentru mesagerie';
$string['taskpasswordresetcleanup'] = 'Șterge încercările de resetare a parolei';
$string['taskplagiarismcron'] = 'Prelucrare de fundal pentru cron în pluginuri de plagiat mei vechi';
$string['taskportfoliocron'] = 'Procesare în fundal pentru pluginuri de portofoliu';
$string['taskprocessing'] = 'Procesarea sarcinilor';
$string['taskquestioncron'] = 'Procesare în fundal pentru ștergerea afișării întrebărilor';
$string['taskquestionstatscleanupcron'] = 'Procesare de fundal pentru curățarea fișierelor cache de statistici ale întrebărilor';
$string['taskrefreshsystemtokens'] = 'Reîmprospătați jetoanele OAuth pentru conturile serviciilor';
$string['taskregistrationcron'] = 'Înregistrare site';
$string['tasksendfailedloginnotifications'] = 'Trimiteți notificări despre autentificările nereușite';
$string['tasksendnewuserpasswords'] = 'Trimite o nouă parolă a utilizatorului';
$string['tasksessioncleanup'] = 'Șterge sesiunile vechi';
$string['taskstatscron'] = 'Procesare background pentru statistici';
$string['tasktagcron'] = 'Procesare background pentru etichete';
$string['tasktempfilecleanup'] = 'Șterge fișierele temporare stale';
$string['tasktype'] = 'Tip';
$string['tempdatafoldercleanup'] = 'Șterge fișierele de date temporare mai vechi de';
$string['templates'] = 'Șabloane';
$string['testoutgoingmailconf'] = 'Testați configurația de trimitere a e-mailurilor';
$string['testoutgoingmailconf_errorcommunications'] = 'Site-ul dvs. nu a putut comunica cu serverul dvs. de e-mail. Vă rugăm să verificați configurația de e-mail.';
$string['testoutgoingmailconf_fromemail'] = 'De la nume de utilizator sau adresă de email';
$string['testoutgoingmailconf_fromemail_help'] = 'Acest câmp emulează trimiterea mesajului de la acel utilizator, dar antetul De la folosit în e-mailul real trimis va depinde de alte setări, cum ar fi domeniile de e-mail permise';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Nevalid din numele de utilizator sau e-mail. Trebuie să fie un format valid de email sau un nume de utilizator existent în Moodle.';
$string['testoutgoingmailconf_message'] = 'Acesta este un mesaj de testare pentru a confirma că ați configurat cu succes mesajele trimise de site-ul dvs. Trimis: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Trimite un mesaj test';
$string['testoutgoingmailconf_sentmail'] = 'Acest site a trimis cu succes un mesaj de testare către serverul de e-mail. <br /> De la: {$a->fromemail} <br /> Către: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: test mesaj. {$a->additional} Trimis: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Subiect adițional';
$string['testoutgoingmailconf_toemail'] = 'La adresa de email';
$string['testoutgoingmaildetail'] = 'Notă: Înainte de testare, vă rugăm să salvați configurația. <br /> {$a}';
$string['testsiteupgradewarning'] = 'În prezent utilizați site-ul de testare {$a}, pentru a-l actualiza corect, utilizați instrumentul de interfață din linia de comandă';
$string['themedesignermode'] = 'Mod temă a designer-ului';
$string['themedesignermodewarning'] = 'Modul de proiectare aspect pagină este activat. Acest lucru nu ar trebui să fie activat pe site-urile de producție, deoarece poate reduce semnificativ performanța.';
$string['themelist'] = 'Listă teme';
$string['themenoselected'] = 'Nicio temă selectată';
$string['themeresetcaches'] = 'Șterge temele din memoria cache';
$string['themeselect'] = 'Modificarea temei';
$string['themeselector'] = 'Selector temă';
$string['themesettings'] = 'Setări temă';
$string['therewereerrors'] = 'Au fost erori în datele dumneavoastră';
$string['thirdpartylibrary'] = 'Librărie';
$string['thirdpartylibrarylocation'] = 'Locație';
$string['thirdpartylibs'] = 'Biblioteci terțe';
$string['timezone'] = 'Fus orar implicit';
$string['timezoneforced'] = 'Această setare este forțată de administratorul site-ului';
$string['timezoneinvalid'] = 'Fusul orar nu este valid "{$}"';
$string['timezoneisforcedto'] = 'Forțează toți utilizatorii să folosească';
$string['timezonenotforced'] = 'Utilizatorii își pot selecta propriul fus orar';
$string['timezonephpdefault'] = 'Fus orar PHP implicit ({$a})';
$string['timezoneserver'] = 'Fus orar al serverului ({$a})';
$string['tlswarning'] = 'Nu a fost detectată nicio extensie PHP / cURL cu suport TLSv1.2. Este posibil ca unele servicii să nu funcționeze. Se recomandă insistent să vă actualizați bibliotecile TLS.';
$string['tokenduration'] = 'Durata simbolului creat de utilizator';
$string['tokenduration_desc'] = 'Durata de timp cât este valabil un jeton de servicii web creat de un utilizator (de exemplu prin intermediul aplicației mobile).';
$string['tokenizerrecommended'] = 'Se recomandă instalarea extensiei opţionale PHP Tokenizer -- îmbunătăţeşte performanţa Moodle Networking.';
$string['tools'] = 'Instrumente de administrare';
$string['toolsmanage'] = 'Gestionați instrumente de administrare';
$string['unattendedoperation'] = 'Operaţiune nesupravegheată';
$string['unbookmarkthispage'] = 'Şterge această pagină din favorite';
$string['unicoderequired'] = 'Este obligatoriu să salvaţi toate datele în format Unicode (UTF-8). La instalarea noilor versiuni va trebui să vă asiguraţi că bazele de date au Unicode ca implicit. La actualizări trebuie să realizaţi procedura de migrare la UTF-8 (pentru detalii consultaţi pagina Administrare).';
$string['uninstallplugin'] = 'Dezinstalați';
$string['unlockaccount'] = 'Deblochează cont';
$string['unoconvwarning'] = 'Versiunea unoconv pe care ați instalat-o nu este acceptată. Moodle necesită caracteristici corespunzătoare versiunii 0.7 sau superioare.';
$string['unsettheme'] = 'Temă nesetată';
$string['unsupported'] = 'Neacceptat';
$string['unsupporteddbfileformat'] = 'Baza de date utilizează Antelope ca format de fișier. Suportul UTF-8 complet în MySQL și MariaDB necesită formatul de fișier Barracuda. Vă rugăm să treceți la formatul de fișier Barracuda. Consultați documentația <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support"> MySQL full unicode support </a> pentru detalii.';
$string['unsupporteddbfilepertable'] = 'Pentru suportul complet al UTF-8, atât MySQL, cât și MariaDB necesită schimbarea setării MySQL „innodb_file_per_table” la „ON”. Consultați documentația pentru detalii suplimentare.';
$string['unsupporteddblargeprefix'] = 'Pentru suport complet al UTF-8, atât MySQL, cât și MariaDB necesită schimbarea setării MySQL „innodb_large_prefix” la „ON”. Consultați documentația pentru detalii suplimentare.';
$string['unsupporteddbstorageengine'] = 'Motorul de stocare a bazei de date utilizat nu mai este acceptat.';
$string['unsupporteddbtablerowformat'] = 'Baza de date conține tabele folosind Antelope ca format de fișier. Vă recomandăm să convertiți tabelele în formatul de fișier Barracuda. Consultați documentația <a href="https://docs.moodle.org/en/cli"> Administrare prin linie de comandă </a> pentru detalii despre un instrument pentru conversia tabelelor InnoDB în Barracuda.';
$string['unsupportedphpversion7'] = 'Versiunea PHP 7 și altele mai recente nu sunt acceptate.';
$string['unsupportedphpversion71'] = 'Versiunea PHP 7.1 și versiunile ulterioare nu sunt acceptate.';
$string['unsupportedphpversion72'] = 'Versiunea PHP 7.2 și versiunile ulterioare nu sunt acceptate.';
$string['unsupportedphpversion73'] = 'Versiunea PHP 7.3 și versiunile ulterioare nu sunt acceptate.';
$string['unsupportedphpversion74'] = 'Versiunea PHP 7.4 și versiunile ulterioare nu sunt acceptate.';
$string['unsupportedphpversion80'] = 'Versiunea 8.0 PHP și versiunile ulterioare nu sunt acceptate.';
$string['unsupportedphpversion81'] = 'Versiunea 8.1 PHP și versiunile ulterioare nu sunt acceptate.';
$string['unsupportedphpversion82'] = 'Versiunea PHP 8.2 și celelalte mai recente nu sunt acceptate.';
$string['unsupportedphpversion83'] = 'Versiunea PHP 8.3 și cele ulterioare nu sunt acceptate.';
$string['unsuspenduser'] = 'Activare cont de utilizator';
$string['updateaccounts'] = 'Actualizează conturile existente';
$string['updateautocheck'] = 'Verificare automata pentru actualizări disponibile';
$string['updateautocheck_desc'] = 'Dacă este activat, site-ul dumneavoastră va verifica automat actualizările disponibile pentru ambele codul Moodle și toate plugin-uri suplimentare. Dacă există o nouă actualizare disponibile, o notificare va fi trimisă la administratorii site-ului.';
$string['updateavailable'] = 'Există o versiune mai nouă de Moodle!';
$string['updateavailable_moreinfo'] = 'Mai multe informatii ...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versiunea {$a}';
$string['updateavailabledetailslink'] = 'Vezi {$a->url} pentru mai multe detalii';
$string['updateavailableforplugin'] = 'Există o versiune mai nouă pentru unele dintre plugin-urile tale  disponibile!';
$string['updateavailableinstall'] = 'Instalează acest update';
$string['updateavailableinstallall'] = 'Instalează actualizările disponibile ({$a})';
$string['updateavailableinstallallhead'] = 'Se instalează actualizările disponibile';
$string['updateavailablenot'] = 'Codul dumneavoastră Moodle este la zi!';
$string['updateavailablerecommendation'] = 'Este recomandat să vă actualizați site-ul la cea mai recentă versiune pentru a obține toate remedierile de securitate și ale bug-urilor.';
$string['updatecomponent'] = 'Actualizează componenta';
$string['updateminmaturity'] = 'Cod matur necesar';
$string['updateminmaturity_desc'] = 'Se trimit notificări în legătură cu actualizările numai în cazul în care codul disponibil are cel puțin nivelul de maturitate selectat. Actualizările pentru plugin-uri care nu declară nivelul lor maturitate al codului sunt întotdeauna raportate, indiferent de setare.';
$string['updatenotificationfooter'] = 'Site-ul dvs. Moodle {$a->siteurl} este configurat pentru a verifica automat actualizările disponibile. Primești acest mesaj ca administrator al site-ului. Puteți dezactiva verificările automate pentru actualizările disponibile în Administrarea site-ului / Server / Notificări de actualizare sau personaliza livrarea acestui mesaj prin pagina de preferințe.';
$string['updatenotifications'] = 'Notificări de actualizare';
$string['updatenotificationsubject'] = 'Există actualizări Moodle disponibile ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notificări în legătură cu noi builds';
$string['updatenotifybuilds_desc'] = 'Dacă este activată, actualizarea disponibilă pentru codul Moodle este de asemenea raportată atunci când un build nou pentru versiunea curentă este disponibil. Builds sunt îmbunătățiri continue ale unei versiuni Moodle. Ei sunt lansați, în general, în fiecare săptămână. Dacă este dezactivată, actualizarea disponibilă va fi raportată numai atunci când există o versiune superioară lansată pentru Moodle. Verificările pentru plugin-uri nu sunt afectate de această setare.';
$string['upgradeerror'] = 'Eroare necunoscută la upgradarea {$a->plugin} la versiunea            {$a->version}, nu se mai poate continua.';
$string['upgradeforumread'] = 'Moodle 1.5 are acum o nouă funcţionalitate care permite urmărirea stării unei intervenţii pe forum: citită/necitită.<br />Pentru a putea utiliza această funcţionalitate trebuie să <a href="{$a}">actualizaţi tabelele din baza de date</a>.';
$string['upgradeforumreadinfo'] = 'O nouă funcţionalitate a fost adăugată la Moodle 1.5: permite urmărirea stării citit/necitit a unei intervenţii pe forum. Pentru a putea utiliza această funcţionalitate va trebui să actualizaţi tabelele din baza de date cu informaţiile de urmărire pentru intervenţiile existente. În funcţie de dimensiunile sitului dumneavoastră această operaţiune poate să dureze destul de mult (câteva ore) şi poate să afecteze funcţionarea bazei de date, de aceea recomandăm realizarea acestei operaţiuni într-un interval de timp când situl nu este foarte solicitat. Chiar şi când această operaţiune este în derulare situl dumneavoastră va continua totuşi să funcţioneze normal şi utilizatorii nu vor fi afectaţi. O dată începută această operaţiune nu trebuie întreruptă - nu închideţi fereastra de browser în care aţi iniţiat-o. Chiar dacă închideţi din greşeală fereastra puteţi iniţia din nou operaţiunea.<br /><br />Doriţi să iniţiaţi acum operaţiunea de actualizare?';
$string['upgradekeyreq'] = 'Este necesară cheia de actualizare';
$string['upgradekeyset'] = 'Actualizează cheie (lăsați necompletat pentru a nu fi setat)';
$string['upgradelogs'] = 'Pentru a avea acces la toate funcţionalităţile va trebui să actualizaţi înregistrările. <a href="{$a}">Mai multe informații</a>';
$string['upgradelogsinfo'] = 'De curând au apărut modificări în modul în care se stochează înregistrările. Pentru a putea vizualiza toate înregistrările vechi în funcţie de fiecare activitate trebuie să realizaţi operaţiunea de actualizare. În funcţie de dimensiunea sitului dumneavoastră această operaţiune poate să dureze destul de mult şi în cazul siturilor de mari dimensiuni operaţiunea poate afecta funcţionarea bazei de date. O dată începută această operaţiune nu trebuie întreruptă - nu închideţi fereastra de browser în care aţi iniţiat-o. Nu vă faceţi griji - situl dumneavoastră va funcţiona normal în timpul operaţiunii de actualizare a înregistrărilor.<br /><br />Doriţi să începeţi operaţiunea de actualizare a înregistrărilor acum?';
$string['upgradepluginsfirst'] = 'Se recomandă să instalați mai intâi toate actualizările disponibile.';
$string['upgradepluginsinfo'] = 'Actualizare plugin-uri';
$string['upgradepluginsinfo_help'] = 'Există actualizări disponibile pentru unele din plugin-urile dumneavoastră. Ar trebui să le instalați pe toate înainte de a actualiza baza de date Moodle. Dacă site-ul dumneavoastră nu are suport pentru implementarea actualizării automate, trebuie să descărcați și să instalați versiuni noi plugin manual la server-ul dumneavoastră.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Setări noi';
$string['upgradesettingsintro'] = 'Setările prezentate mai jos au fost adăugate în timpul ultimei dvs. actualizări Moodle. Efectuați modificările necesare la valorile implicite și apoi faceți clic pe butonul „Salvați modificările” din partea de jos a acestei pagini.';
$string['upgradestalefiles'] = 'Versiunile mixte de Moodle au fost detectate, actualizarea nu poate continua';
$string['upgradestalefilesinfo'] = 'Procesul de actualizare Moodle a fost întrerupt deoarece scripturile PHP din cel puțin două versiuni majore ale Moodle au fost detectate în directorul Moodle.

Acest lucru poate provoca probleme semnificative ulterior, așa că, pentru a continua, trebuie să vă asigurați că directorul Moodle conține doar fișiere pentru o singură versiune de Moodle.

Modul recomandat de a curăța directorul Moodle este după cum urmează:

* redenumiți directorul actual Moodle în „moodle_old”
* creați un nou director Moodle care conține numai fișiere fie dintr-o descărcare standard a pachetului Moodle, fie din depozitul Moodle Git
* mutați fișierul original config.php și orice pluginuri non-standard din directorul „moodle_old” în noul director Moodle

Când aveți un director Moodle curat, reîmprospătați această pagină pentru a relua procesul de actualizare Moodle.

Acest avertisment este adesea cauzat de dezarhivarea unui pachet standard Moodle peste o versiune anterioară a Moodle. Deși acest lucru este OK pentru upgrade-uri minore, este foarte descurajat pentru upgrade-uri majore Moodle.

Acest avertisment poate fi, de asemenea, cauzat de o operațiune de verificare incompletă sau de actualizare din depozitul Git, caz în care este posibil să trebuiască doar să așteptați finalizarea operației sau poate rulați comanda corespunzătoare de curățare și reîncercați operația.

Puteți găsi mai multe informații în documentația de actualizare la <a href="{$a}"> {$a} </a>.';
$string['upgradestart'] = 'Actualizează acum baza de date Moodle';
$string['upgradesure'] = '<p> Fișierele dvs. Moodle au fost modificate și sunteți pe cale să vă actualizați automat serverul la această versiune: </p>
<p><<{$a}</ </strong> </p>
<p> După ce faceți acest lucru, nu vă mai puteți întoarce din nou. Rețineți că acest proces poate dura mult timp. </p>
<p> Sigur doriți să faceți upgrade la acest server la această versiune? </p>';
$string['upgradetimedout'] = 'Timpul de actualizare a expirat, vă rugăm să restartați actualizarea.';
$string['upgradingdata'] = 'Actualizare date';
$string['upgradinglogs'] = 'Actualizare jurnale';
$string['upgradingversion'] = 'Actualizarea la noua versiune';
$string['upwards'] = 'în sus';
$string['useblogassociations'] = 'Activare asociații';
$string['user'] = 'Utilizator';
$string['userbulk'] = 'Acțiuni în masă pentru utilizatori';
$string['userbulkdownload'] = 'Exportă utilizatorii ca';
$string['userdefaultpreferences'] = 'Setările implicite ale utilizatorului';
$string['userfeedbackafterupgrade'] = 'După fiecare actualizare majoră';
$string['userfeedbackencouragement'] = '<p> În Moodle 3.9 și mai departe, este inclusă o nouă caracteristică care oferă utilizatorilor opțiunea de a oferi feedback despre software-ul Moodle către Moodle HQ printr-un site de sondaj extern găzduit de Moodle HQ. Nici o informație de identificare a utilizatorului nu este redirecționată către site-ul sondajului. </p>
<p> Moodle HQ se străduiește să fie deschis și transparent cu privire la practicile sale de colectare a datelor. Astfel, dorim să ne asigurăm că sunteți conștient și controlați această funcționalitate. </p>
<p> Feedback-ul utilizatorilor va ajuta Moodle HQ la îmbunătățirea software-ului Moodle. Pentru a activa această funcție, accesați <a href="{$a}"> Setări de feedback </a>. </p>';
$string['userfeedbacknextreminder'] = 'Următorul memento de feedback';
$string['userfeedbacknextreminder_desc'] = 'Când ar trebui să cerem utilizatorului să ofere feedback din nou?';
$string['userfeedbackperiodically'] = 'Periodic';
$string['userfeedbackremindafter'] = 'Afișează memento după';
$string['userfeedbackremindafter_desc'] = 'Amintiți-le din nou utilizatorilor să ofere feedback după numărul dat de zile.';
$string['userfiltersdefault'] = 'Filtre implicite pentru utilizatori';
$string['userfiltersdefault_desc'] = 'Selectați filtrele care ar trebui să fie afișate în pagina „Răsfoiți lista de utilizatori” și în pagina „Acțiuni utilizator în bloc”. Țineți apăsată tasta Ctrl pentru a selecta mai multe elemente. Toate filtrele care nu sunt selectate vor fi disponibile făcând clic pe linkul „Afișați mai multe”.';
$string['userimagesdisabled'] = 'Imaginile de profil ale utilizatorului sunt dezactivate';
$string['userlist'] = 'Răsfoiește lista de utilizatori';
$string['usermanagement'] = 'Managementul utilizatorilor';
$string['userpolicies'] = 'Politici utilizatori';
$string['userpreference'] = 'Preferință utilizator';
$string['userquota'] = 'Spațiu de fișiere private';
$string['userquota_desc'] = 'Cantitatea maximă de date pe care fiecare utilizator o poate stoca în zona fișierelor sale private.';
$string['users'] = 'Utilizatori';
$string['usesitenameforsitepages'] = 'Utilizează numele site-ului pentru paginile site-ului';
$string['usetags'] = 'Activează funcționalitate tags';
$string['validateemptylineerror'] = 'Rândurile libere nu sunt valide';
$string['validateerror'] = 'Această valoare nu este validă';
$string['validateerrorlist'] = 'Aceste postări nu sunt valide: {$a}';
$string['validateiperror'] = 'Aceste adrese IP nu sunt valide: {$a}';
$string['verifychangedemail'] = 'Restricţionează domenii la schimbarea adresei email.';
$string['warningcurrentsetting'] = 'Valoarea curentă este incorectă: {$a}';
$string['warningiconvbuggy'] = 'Versiunea dumneavoastră de iconv library nu acceptă modificarea //IGNORE. Trebuie să instalați extensia mbstring care poate fi folosită în loc să ștergeți elementele care conțin caractere UTF-8 nevalide';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Completaţi opţiunile de mai jos dacă serverul dumneavoastră Moodle nu poate accesa Internetul în mod direct. Accesul la Internet este necesar în vederea descărcării informaţiilor despre environment, language packs, fluxurile RSS, fusuri orare, etc.<br /><em>Se recomandă instalarea extensiei PHP cURL.</em>';
$string['xmlrpcwebserviceenabled'] = 'S-a detectat că protocolul XML-RPC Web Service este activat pe site-ul dvs. Această caracteristică se bazează pe extensia PHP XML-RPC care nu mai este întreținută de PHP.';
$string['yuicomboloading'] = 'YUI combo se încarcă';
$string['ziprequired'] = 'Moodle funcţionează în prezent cu extensia Zip PHP, info-ZIP binaries sau PclZip library nu se mai folosesc.';
