<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'fr', version '4.2'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Accessibilité';
$string['accessibilitydisabled'] = 'La boîte à outils d’accessibilité Brickfield n’est pas activée sur ce site. Veuillez contacter l’administrateur du site pour l’activer.';
$string['accessibilityreport'] = 'Boîte à outils d’accessibilité';
$string['accessibilitytool'] = 'Outil d’accessibilité Brickfield';
$string['accessibilitytools'] = 'Outils d’accessibilité Brickfield';
$string['activate'] = 'Activer';
$string['activated'] = 'Le plugin est activé et prêt à l’utilisation';
$string['activationform'] = 'Enregistrement de Brickfield';
$string['activationheader'] = 'Activation de Brickfield';
$string['activationinfo'] = '<p>Pour utiliser ce plugin, vous devez fournir dans ce formulaire des clefs valides pour ce site.</p><p>{$a}, veuillez indiquer vos données (s’ouvre dans une nouvelle fenêtre)</a> pour obtenir ces clefs si vous ne les possédez pas encore.</p><p>Une fois le plugin activé, vos clefs seront validées au moyen des tâches programmées.</p>';
$string['activityresults:pluginname'] = 'Rapport des résultats de l’outil de vérification par activité';
$string['activityresults:toolname'] = 'Résumé des résultats par activité';
$string['activityresults:toolshortname'] = 'Résultats par activité';
$string['advanced:pluginname'] = 'Rapport avancé des résultats de l’outil de vérification';
$string['advanced:toolname'] = 'Résumé avancé';
$string['advanced:toolshortname'] = 'Avancé';
$string['allcourses'] = 'Tous les cours ({$a})';
$string['allcoursescat'] = 'Tous les cours de la catégorie {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'À la demande';
$string['analysis:disabled'] = 'Désactivé';
$string['analysistype'] = 'Activer les demandes d’analyse';
$string['analysistype_desc'] = 'Autorise les demandes d’analyse de contenus';
$string['analysistypedisabled'] = 'L’analyse de contenus est désactivée';
$string['bannercontentone'] = 'La boîte à outils d’accessibilité pour entreprises dispose d’un ensemble complet de fonctionnalités pour aider votre organisation à améliorer l’accessibilité de vos cours. <a href="{$a}">Contactez Brickfield Education Labs</a> pour réserver une démonstration gratuite des fonctionnalités avancées.';
$string['bannercontenttwo'] = 'Construisez une plateforme d’enseignement et d’apprentissage efficace et inclusive en trouvant le contenu qui ne respecte pas les directives, en corrigeant les problèmes et en préparant le contenu de votre cours Moodle avec des fichiers accessibles, un éditeur et des fonctionnalités améliorées.';
$string['bannerheadingone'] = 'Mettre à niveau vers la boîte à outils d’accessibilité pour entreprises';
$string['batch'] = 'Limite des lots';
$string['brickfield'] = 'Boîte à outils Brickfield';
$string['brickfield:viewcoursetools'] = 'Consulter les rapports par cours';
$string['brickfield:viewsystemtools'] = 'Consulter les rapports de tous les cours';
$string['bulkprocesscaches'] = 'Traiter en masse la mise en cache';
$string['bulkprocesscourses'] = 'Traiter en masse les vérifications d’accessibilité';
$string['buttonone'] = 'Obtenir une démo gratuite';
$string['cachepending'] = 'Le récapitulatif des données est en cours de création';
$string['checkdesc:alinksdontopennewwindow'] = 'Les liens s’ouvrant dans une nouvelle fenêtre doivent auparavant avertir les utilisateurs.';
$string['checkdesc:amustcontaintext'] = 'Un lien doit contenir du texte afin d’être perceptible.';
$string['checkdesc:areadontopennewwindow'] = 'Les zones, utilisées dans les cartes d’images, qui s’ouvrent dans une nouvelle fenêtre doivent avertir les utilisateurs à l’avance.';
$string['checkdesc:areahasaltvalue'] = 'Les zones, utilisées dans les cartes d’images, doivent avoir un texte alternatif (alt), comme pour les images.';
$string['checkdesc:asuspiciouslinktext'] = 'Le texte du lien doit être descriptif et fournir un contexte sur sa destination.';
$string['checkdesc:basefontisnotused'] = 'Les éléments « basefont » (traditionnellement utilisés pour le formatage) ne sont pas accessibles et ne doivent pas être utilisés.';
$string['checkdesc:blinkisnotused'] = 'Les éléments « blink », qui s’allument et s’éteignent, ne sont pas accessibles et ne doivent pas être utilisés.';
$string['checkdesc:boldisnotused'] = 'Les éléments en gras (b) ne doivent pas être utilisés ; il faut utiliser « strong » à la place.';
$string['checkdesc:contenttoolong'] = 'La longueur totale du contenu de la page ne doit pas dépasser 500 mots.';
$string['checkdesc:csstexthascontrast'] = 'Le contraste des couleurs entre le texte et le fond est trop faible.';
$string['checkdesc:embedhasassociatednoembed'] = 'Les éléments « embed » (pour l’intégration d’éléments multimédia) doivent avoir les éléments « noembed » correspondants.';
$string['checkdesc:headerh3'] = 'Les titres qui suivent les titres « h3 » (dans l’éditeur, le choix le plus grand pour les titres) ne doivent pas rompre la hiérarchie des titres de page.';
$string['checkdesc:headershavetext'] = 'Un titre doit contenir du texte pour être visible.';
$string['checkdesc:iisnotused'] = 'Les éléments en italique « i » ne doivent pas être utilisés ; il faut utiliser « em » à la place.';
$string['checkdesc:imgaltisdifferent'] = 'Le texte alternatif « alt » de l’image ne doit pas être le nom du fichier de l’image.';
$string['checkdesc:imgaltistoolong'] = 'Le texte alternatif « alt » de l’image ne doit pas dépasser le maximum autorisé (125) de caractères.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Le texte alternatif « alt » de l’image ne doit pas être vide, en particulier lorsque l’image comporte un lien vers un autre site.';
$string['checkdesc:imgaltnotplaceholder'] = 'Le texte alternatif « alt » de l’image ne doit pas être un simple texte de remplacement, tel que « image ».';
$string['checkdesc:imghasalt'] = 'Le texte alternatif « alt » de l’image ne doit pas être absent des éléments image, sauf si l’image est purement décorative et sans signification.';
$string['checkdesc:imgwithmaphasusemap'] = 'Les cartes d’images, avec des zones cliquables, nécessitent des éléments « usemap » et « map » correspondants.';
$string['checkdesc:legendtextnotempty'] = 'Les éléments « legend », utilisés pour décrire les éléments d’un ensemble de champs, doivent contenir du texte.';
$string['checkdesc:marqueeisnotused'] = 'Les éléments « marquee » (défilement automatique) ne sont pas accessibles et ne doivent pas être utilisés.';
$string['checkdesc:noheadings'] = 'L’absence de titre rend le contenu moins structuré et plus difficile à lire.';
$string['checkdesc:objectmusthaveembed'] = 'Les éléments « object » (pour l’intégration de ressources externes) ne doivent pas omettre les éléments « embed » correspondants.';
$string['checkdesc:objectmusthavetitle'] = 'Les éléments « object » (pour l’intégration de ressources externes) ne doivent pas omettre de leur description « titre » correspondante.';
$string['checkdesc:objectmusthavevalidtitle'] = 'Les éléments « object » (pour l’intégration de ressources externes) doivent avoir des éléments « title » correspondants avec du texte.';
$string['checkdesc:strikeisnotused'] = 'Les éléments « strike » (texte barré) ne doivent pas être utilisés ; il faut utiliser l’élément « del » (supprimé) à la place.';
$string['checkdesc:tabledatashouldhaveth'] = 'Idéalement, les tableaux ne doivent pas omettre leur en-tête.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Les élément « summary » et « caption » des tableaux ne doivent pas être identiques.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Idéalement, les tableaux ne devraient pas comporter de cellules fusionnées.';
$string['checkdesc:tablethshouldhavescope'] = 'Les paramètres « scope » de rangée ou de colonne du tableau (utilisés pour associer une ligne et une colonne à chaque cellule) doivent être déclarés.';
$string['checkidvalidation'] = 'Tâche de vérification des checkids non valides';
$string['checkscompleted'] = 'Verifications terminées : {$a}';
$string['checktype'] = 'Groupe de vérifications';
$string['checktype:form'] = 'Formulaire';
$string['checktype:image'] = 'Image';
$string['checktype:layout'] = 'Mise en page';
$string['checktype:link'] = 'Lien';
$string['checktype:media'] = 'Média';
$string['checktype:table'] = 'Tableau';
$string['checktype:text'] = 'Texte';
$string['checktyperesults:pluginname'] = 'Rapport des types de contenu de l’outil d’accessibilité';
$string['checktyperesults:toolname'] = 'Résumé des types de contenu';
$string['checktyperesults:toolshortname'] = 'Types de contenu';
$string['cmpercent'] = 'Pourcentage d’activités global';
$string['cmpercenterrors'] = 'Pourcentage d’erreurs global';
$string['cmpercenttitle'] = 'Répartition globale en % des activités par rapport aux erreurs';
$string['confirmationmessage'] = 'Ce cours a été programmé pour être analysé. L’analyse sera terminée au plus tôt à {$a}. Veuillez revenir plus tard.';
$string['contactadmin'] = 'Veuillez contacter l’administrateur du site pour terminer l’enregistrement.';
$string['contactus'] = 'Contactez-nous';
$string['contentfive'] = 'Corriger automatiquement les balises HTML obsolètes.';
$string['contentfour'] = 'Identifier les activités qui présentent le plus de problèmes d’accessibilité afin de prioriser les efforts.';
$string['contentone'] = 'Évaluer automatiquement le contenu de vos cours et de vos évaluations en fonction des problèmes d’accessibilité.';
$string['contentsix'] = 'Fournir aux enseignants des conseils au bon moment pour créer un meilleur contenu.';
$string['contentthree'] = 'Fournir à vos étudiants des contenus dans des formats accessibles, notamment en audio, en ePub et en braille électronique.';
$string['contenttwo'] = 'Mettre à jour en masse les textes imprécis ou manquants pour les liens web, les descriptions d’images et les sous-titres de vidéos.';
$string['contenttypeerrors'] = 'Résultats des tests de contenu d’activité par cours et par type de contenu.';
$string['contentyperesults'] = 'Total de réussites/échecs pour les zones de contenu par cours.';
$string['contextid'] = 'Contextid';
$string['core_course'] = 'Cours';
$string['core_question'] = 'Banques de question';
$string['count'] = 'Nombre';
$string['country'] = 'Pays';
$string['country_help'] = 'Pays du site';
$string['coursecount'] = 'Nombre de cours';
$string['deletehistoricaldata'] = 'Supprimer les résultats des anciennes vérifications';
$string['dependency'] = 'Dépend de';
$string['emptycategory'] = 'Aucun cours trouvé pour la catégorie {$a}';
$string['emptytagcourses'] = 'Aucun résultat trouvé pour les cours avec les tags configurés';
$string['enableaccessibilitytools'] = 'Activer les outils d’accessibilité';
$string['enableaccessibilitytools_desc'] = 'La boîte à outils d’accessibilité aide à identifier des problèmes d’accessibilité dans les cours.';
$string['error:nocoursespecified'] = 'Le rapport de synthèse nécessite un identifiant de cours valide. Veuillez accéder à la boîte à outils d’accessibilité à partir d’un cours.';
$string['errorlink'] = 'Modifier l’instance d’erreur pour {$a}';
$string['errors'] = 'Erreurs : {$a}';
$string['errors:pluginname'] = 'Liste d’erreurs de l’outil d’accessibilité';
$string['errors:toolname'] = 'Résumé de la liste d’erreurs';
$string['errors:toolshortname'] = 'Liste d’erreurs';
$string['eventanalysis_requested'] = 'Analyse de contenu demandées';
$string['eventanalysis_requesteddesc'] = 'Une analyse de contenu a été demandée pour le cours {$a}.';
$string['eventreport_downloaded'] = 'Résumé d’accessibilité téléchargé';
$string['eventreport_downloadeddesc'] = 'Résumé d’accessibilité a été téléchargé pour le cours d’ID {$a}.';
$string['eventreport_viewed'] = 'Rapport d’accessibilité consulté';
$string['eventreport_vieweddesc'] = 'Le rapport d’accessibilité a été consulté pour l’identifiant de cours {$a->cours},
l’identifiant de la catégorie {$a->category}, l’onglet {$a->tab}.';
$string['failed'] = 'Échoué';
$string['failedcount'] = 'Échoués : {$a}';
$string['footerheading'] = 'Section du pied de page';
$string['fullcachedone'] = 'Désactiver pour relancer la mise en cache';
$string['hashcorrect'] = 'Le code saisi est correct.';
$string['hashincorrect'] = 'Le code saisi est erroné.';
$string['headingfive'] = 'Corrections HTML';
$string['headingfour'] = 'Concentrer l’effort';
$string['headingone'] = 'Évaluer le contenu';
$string['headingsix'] = 'Assistance de performance';
$string['headingthree'] = 'Formats de fichiers accessibles';
$string['headingtwo'] = 'Remédiation';
$string['hideshow'] = 'Cacher/afficher';
$string['icon:analytics-custom'] = 'Icône analyse de données';
$string['icon:file-edit-custom'] = 'Icône modification de fichier';
$string['icon:hands-helping-custom'] = 'Icône main';
$string['icon:search-plus-custom'] = 'Icône recherche';
$string['icon:tools-custom'] = 'Icône outils';
$string['icon:wand-magic-custom'] = 'Icône baguette magique';
$string['inactive'] = 'Le plugin est inactif et ne peut pas être utilisé. Veuillez entrer des clefs d’enregistrement valides, et appuyez sur « Activer ».';
$string['innercontextid'] = 'Contextid intérieur';
$string['installed'] = 'Plugin installé';
$string['installedcli'] = 'Plugin installé via la ligne de commande';
$string['installeddescription'] = 'Le plugin a été installé, rediriger vers le formulaire d’activation.';
$string['invalidaccessibilitytool'] = 'Le sous-plugin d’accessibilité demandé n’est pas valide.';
$string['invalidcategoryid'] = 'Catégorie non valide, veuillez vérifier votre saisie';
$string['invalidcourseid'] = 'Cours non valide, veuillez vérifier votre saisie';
$string['invalidlinkphrases'] = 'cliquer|cliquer ici|plus|plus ici|info|info ici|information|information ici|Plus d’informations|Plus d’informations ici|informations complémentaires|informations complémentaires ici|plus de détails|plus de détails ici|détails|détails ici';
$string['language'] = 'Langue';
$string['language_help'] = 'Langue du site';
$string['messageprovider:warningcheckid'] = 'Avertissement de checkids non valides';
$string['mobileservice'] = 'Services mobiles activés ({$a})';
$string['module'] = 'Module';
$string['modulename'] = 'Nom';
$string['moreinfo'] = 'Plus d’informations';
$string['newwindowphrases'] = 'nouvelle fenêtre|nouvelle-fenêtre|nouvelle_fenêtre';
$string['noerrorsfound'] = 'Aucune erreur d’accessibilité fréquente n’a été trouvée avec ces paramètres. Bravo !';
$string['norecords'] = 'Aucun enregistrement pertinent n’a été trouvé pour vos paramètres de recherche.';
$string['notregistered'] = 'Votre boîte à outils d’accessibilité doit être enregistrée.';
$string['notvalidated'] = 'Votre boîte à outils d’accessibilité est fonctionnelle en attendant d’être validé.';
$string['numcourses'] = 'Nombre de cours ({$a})';
$string['numfactivities'] = 'Nombre d’activités ({$a})';
$string['numfiles'] = 'Nombre de fichiers ({$a})';
$string['numinstances'] = 'Nombre d’instances';
$string['numusers'] = 'Nombre d’utilisateurs ({$a})';
$string['pagedesc:checktype'] = '<p>Afin de résumer et d’analyser les résultats des différents contrôles effectués, nous regroupons ces contrôles en différents types de contenu. Ainsi, tous les résultats des contrôles d’accessibilité liés aux images se trouvent dans le groupe de type de contenu « Image », tous les résultats des contrôles d’accessibilité liés à la mise en page se trouvent dans le groupe de type de contenu « Mise en page », et ainsi de suite.</p><p>Les activités sont incluses soit en tant qu’activités, soit en tant que ressources, soit en tant que zones de contenu relatives aux cours eux-mêmes.</p><p>La page du graphique des types de contenu affiche la répartition des erreurs par groupe de type de contenu : Image, Mise en page, Lien, Média, Tableau et Texte.</p>';
$string['pagedesc:pertarget'] = '<p>Afin de résumer et d’analyser les résultats de contrôle par activité, nous regroupons ces résultats de contrôle dans les différentes activités détectées.</p><p>Les activités sont incluses soit comme des activités, des ressources ou d’autres domaines de contenu relatifs aux cours eux-mêmes. Chaque activité sans erreur détectée est comptée comme réussie, chaque activité avec une ou plusieurs erreurs détectées est comptée comme échouée. Le rapport entre les activités réussies et les activités échouées est ensuite affiché.</p><p>La page du tableau de ventilation des activités affiche le rapport entre les instances réussies et les instances échouées au total, par activité, comme un devoir, un cours, une étiquette, etc.</p>.';
$string['pagedesctitle:checktype'] = 'Explication des types de contenu';
$string['pagedesctitle:pertarget'] = 'Explication de la répartition des activités';
$string['passed'] = 'Réussi';
$string['passedcount'] = 'Réussis : {$a}';
$string['passrate'] = 'Taux de réussite : {$a}%';
$string['pdf:filename'] = 'Rapport_Resume_Brickfield_ID_Cours-{$a}';
$string['percheckerrors'] = 'Nombre de tests spécifiques et d’erreurs par vérification et par cours.';
$string['perpage'] = 'Éléments à afficher par page';
$string['pluginname'] = 'Boîte à outils d’accessibilité';
$string['printable:downloadpdf'] = 'Télécharger en PDF';
$string['printable:pluginname'] = 'Rapport résumé de l’outil de vérification d’accessibilité';
$string['printable:printreport'] = 'Rapport imprimable';
$string['printable:toolname'] = 'Rapport résumé';
$string['printable:toolshortname'] = 'Rapport résumé';
$string['privacy:metadata'] = 'Le plugin de rapport sur les contrôles d’accessibilité n’enregistre aucune donnée personnelle.';
$string['processanalysisrequests'] = 'Traiter les demandes d’analyse de contenu';
$string['registernow'] = 'Veuillez vous inscrire dès maintenant.';
$string['registration'] = 'Formulaire d’inscription';
$string['registrationinfo'] = '<p>Ce processus d’enregistrement vous autorise à utiliser la version « débutant » de la boite à outils d’accessibilité Brickfield pour votre site Moodle enregistré.</p><p>Cette utilisation est soumise aux <a href="{$a}" target="_blank">conditions générales de Brickfield Education Labs (ouvre une nouvelle fenêtre)</a> et à l’acceptation de celles-ci, afin d’utiliser ce produit.</p>';
$string['release'] = 'Version de Moodle ({$a})';
$string['remaining'] = '({$a} erreurs restantes)';
$string['response:0'] = 'Cette URL ne mène nulle part.';
$string['response:404'] = 'L’URL de cette page n’a pas été trouvée';
$string['schedule:blocknotscheduled'] = '<p>Ce cours n’a pas encore été programmé pour être analysé, afin de trouver les problèmes d’accessibilité courants.</p>';
$string['schedule:notscheduled'] = '<p>Ce cours n’a pas encore été programmé pour une analyse visant à trouver des problèmes d’accessibilité communs.</p><p>En cliquant sur le bouton « Envoyer pour analyse », vous confirmez que vous souhaitez que tout le contenu HTML pertinent de votre cours, comme les descriptions des sections de cours, les descriptions des activités, les questions, les pages et autres, soit programmé pour une analyse.</p><p>Cette analyse effectuera plusieurs vérifications d’accessibilité communes sur le contenu HTML de votre cours, et ces résultats s’afficheront ensuite sur ces pages de rapport de la boîte à outils d’accessibilité. L’analyse sera traitée en arrière-plan, par des tâches programmées, de sorte que sa rapidité d’exécution dépendra de la chronologie des tâches et des horaires d’exécution des tâches.</p>';
$string['schedule:requestanalysis'] = 'Envoyer pour analyse';
$string['schedule:scheduled'] = 'L’analyse de ce cours a été programmée.';
$string['schedule:sitenotscheduled'] = '<p>Le contenu global (indépendant du cours) n’a pas encore été programmé pour être analysé afin de trouver des problèmes d’accessibilité communs.</p><p>En cliquant sur le bouton « Envoyer pour analyse », vous confirmez que vous voulez que tout votre contenu global (indépendant du cours) pertinent soit programmé pour être analysé.</p><p>Cette analyse effectuera plusieurs vérifications d’accessibilité communes sur ce contenu, et ces résultats s’afficheront ensuite sur ces pages de rapport de la boîte à outils d’accessibilité. L’analyse sera traitée en arrière-plan, par des tâches programmées, de sorte que sa rapidité d’exécution dépendra de la chronologie des tâches et des horaires d’exécution des tâches.</p>';
$string['schedule:sitescheduled'] = 'Le contenu global (indépendant du cours) a été programmé pour l’analyse.';
$string['secretkey'] = 'Clef d’API';
$string['secretkey_help'] = 'Ce code est reçu par courriel après l’inscription.';
$string['sendfollowinginfo'] = '<p>Les informations suivantes seront envoyées périodiquement pour contribuer uniquement aux statistiques générales. Elles ne seront pas rendues publiques.</p> {$a}';
$string['settings'] = 'Réglages de la boîte à outils d’accessibilité';
$string['sitehash'] = 'Clef secrète';
$string['sitehash_help'] = 'Ce code est reçu par courriel après l’inscription.';
$string['taberrors'] = 'Erreurs de vérification';
$string['targetavetitle'] = 'Nombre moyen d’erreurs par activité';
$string['targetpercentage'] = 'Pourcentage d’instances passées/échouées par activité';
$string['targetratio'] = 'Proportion de tests passés';
$string['tblcheck'] = 'Vérification';
$string['tblcheckexample'] = 'Exemple';
$string['tblcheckfailed'] = 'Vérifications en échec';
$string['tblchecksummary'] = 'Résumé';
$string['tbledit'] = 'Modifier';
$string['tblerrorcount'] = 'Erreurs';
$string['tblhtmlcode'] = 'Code HTML existant';
$string['tblinstance'] = 'Instance';
$string['tblline'] = 'Ligne';
$string['tbloverallpercentage'] = '% d’erreurs global';
$string['tblpercentage'] = 'Pourcentage';
$string['tblpreview'] = 'Prévisualisation';
$string['tbltarget'] = 'Activité';
$string['tblupdateto'] = 'Mettre à jour vers';
$string['titleactivityresultsall'] = 'Résultats par activité : tous les cours vérifiés ({$a->count} cours)';
$string['titleactivityresultspartial'] = 'Résultats par activité : cours {$a->name}';
$string['titleall'] = 'Détails des erreurs : tous les cours vérifiés ({$a->count} cours)';
$string['titlechecktyperesultsall'] = 'Résultats par type de contenu : tous les cours vérifiés ({$a->count} cours)';
$string['titlechecktyperesultspartial'] = 'Résultats par type de contenu : cours {$a->name}';
$string['titleerrorsall'] = 'Détails des erreurs : tous les cours vérifiés ({$a->count} cours)';
$string['titleerrorscount'] = 'Détails des erreurs (affichage des {$a} premières erreurs)';
$string['titleerrorspartial'] = 'Détails des erreurs : cours {$a->name}';
$string['titlepartial'] = 'Détails des erreurs : cours {$a->name}';
$string['titleprintableall'] = 'Cours {$a->name}';
$string['titleprintablepartial'] = 'Cours {$a->name}';
$string['tools'] = 'Rapports';
$string['toperrors'] = 'Erreurs les plus fréquentes';
$string['toptargets'] = 'Activités avec erreurs';
$string['totalactivities'] = 'Total des activités';
$string['totalactivitiescount'] = 'Total des activités : {$a}';
$string['totalareas'] = 'Total des zones';
$string['totalerrors'] = 'Total des erreurs';
$string['totalgrouperrors'] = 'Total des erreurs par type de contenu';
$string['updatesummarydata'] = 'Mise à jour des données récapitulatives du site';
$string['usersmobileregistered'] = 'Nombre d’utilisateurs avec appareil mobile enregistré ({$a})';
$string['validationerror'] = 'La validation de la clef d’enregistrement a échoué. Vérifiez que l’URL et les clefs de votre site enregistré sont correctes.';
$string['warningcheckidbody'] = 'Il y a un problème avec le contrôle Brickfield qui est actif mais ne figure pas dans la base de données. Veuillez enquêter.';
$string['warningcheckidsubject'] = 'Avertissement checkID de la boîte à outil Brickfield';
