<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'it', version '4.2'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Puoi visualizzare l\'anteprima del quiz, tuttavia se questo fosse un tentativo reale, non ti sarà possibile in quanto:';
$string['action'] = 'Azione';
$string['activityoverview'] = 'Ci sono quiz che devi svolgere';
$string['adaptive'] = 'Modo adattivo';
$string['adaptive_help'] = 'L\'impostazione consente di rispondere più volte alla stessa domanda all\'interno dello stesso tentativo. Se uno studente sbaglia la risposta, potrà rispondere nuovamente ma potrà subire una penalizzazione se l\'impostazione Penalità è attiva.';
$string['add'] = 'Aggiungi';
$string['addaquestion'] = 'una domanda';
$string['addarandomquestion'] = 'una domanda casuale';
$string['addarandomquestion_help'] = 'Le domande casuali sono prese casualmente dalla categoria indicata. Studenti diversi e tentativi diversi dello stesso studente visualizzeranno domande diverse.';
$string['addarandomselectedquestion'] = 'Aggiungi una domanda scelta casualmente ...';
$string['addasection'] = 'una nuova intestazione di sezione';
$string['adddescriptionlabel'] = 'Aggiungi un elemento descrittivo';
$string['addingquestion'] = 'Creazione domanda';
$string['addingquestions'] = '<p>Questa parte della pagina ti consente la gestione del deposito delle domande. Le domande vengono salvate in categorie per aiutarti a mantenerle organizzate e possono essere utilizzate in qualsiasi quiz del tuo corso o in altri corsi, se decidi di pubblicarle.</p>
<p>Dopo aver selezionato o creato una categoria di domande potrai creare o modificare le domande. Puoi selezionare un qualsiasi numero di domande e aggiungerle al quiz nell\'altra parte della pagina.</p>';
$string['addmoreoverallfeedbacks'] = 'Aggiungi altri {no} campi per feedback';
$string['addnewgroupoverride'] = 'Aggiungi personalizzazione di gruppo';
$string['addnewpagesafterselected'] = 'Aggiungi nuove pagine dopo le domande selezionate';
$string['addnewquestionsqbank'] = 'Aggiungi domande alla categoria {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Aggiungi personalizzazione individuale';
$string['addpagebreak'] = 'Inserisci interruzione di pagina';
$string['addpagehere'] = 'Aggiungi pagina';
$string['addquestion'] = 'Aggiungi domanda';
$string['addquestionfrombankatend'] = 'Aggiungi dal deposito delle domande alla fine';
$string['addquestionfrombanktopage'] = 'Aggiungi alla pagina {$a} una domanda del deposito';
$string['addquestions'] = 'Aggiungi domande';
$string['addquestionstoquiz'] = 'Aggiungi domande al quiz attuale';
$string['addrandom'] = 'Aggiungi {$a} domande casuali';
$string['addrandom1'] = '<< Aggiungi';
$string['addrandom2'] = 'domande casuali';
$string['addrandomfromcategory'] = 'Aggiungi domande casuali dalla categoria:';
$string['addrandomquestion'] = 'Aggiungi domanda casuale';
$string['addrandomquestionatend'] = 'Aggiungi una domanda casuale alla fine';
$string['addrandomquestiontopage'] = 'Aggiungi alla pagina {$a} una domanda casuale';
$string['addrandomquestiontoquiz'] = 'Aggiungi domanda casuale al quiz {$a}';
$string['addselectedquestionstoquiz'] = 'Aggiungi al quiz le domande selezionate';
$string['addselectedtoquiz'] = 'Aggiungi selezione al quiz';
$string['addtoquiz'] = 'Aggiungi al quiz';
$string['affectedstudents'] = '{$a} considerati';
$string['aftereachquestion'] = 'ogni domanda';
$string['afternquestions'] = 'ogni {$a} domande';
$string['age'] = 'età';
$string['allattempts'] = 'Tutti i tentativi';
$string['allinone'] = 'Illimitate';
$string['allowreview'] = 'Autorizza revisione';
$string['alreadysubmitted'] = 'È probabile che tu abbia già inviato questo tentativo';
$string['alternativeunits'] = 'Unità alternative';
$string['alwaysavailable'] = 'Sempre disponibile';
$string['alwayslatest'] = 'Sempre la più recente';
$string['analysisoptions'] = 'Opzioni di analisi';
$string['analysistitle'] = 'Tabella per l\'analisi dell\'elemento';
$string['answer'] = 'Risposta';
$string['answered'] = 'Risposta fornita';
$string['answerhowmany'] = 'Una o più risposte?';
$string['answers'] = 'Risposte';
$string['answersingleno'] = 'Risposta fornita';
$string['answersingleyes'] = 'Una sola risposta';
$string['answertoolong'] = 'Risposta troppo lunga dopo la linea {$a} (255 caratteri max)';
$string['anytags'] = 'Qualsiasi tag';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = 'Confermi la rimozione delle domande selezionate?';
$string['asshownoneditscreen'] = 'Come visualizzato sulla pagina di modifica';
$string['attempt'] = 'Tentativo {$a}';
$string['attemptalreadyclosed'] = 'Questo tentativo è già stato svolto.';
$string['attemptclosed'] = 'Il tentativo non è stato ancora chiuso';
$string['attemptduration'] = 'Tempo impiegato';
$string['attemptedon'] = 'Tentativo del';
$string['attempterror'] = 'Non puoi tentare questo quiz adesso in quanto: {$a}';
$string['attempterrorcontentchange'] = 'Questa anteprima del quiz non esiste più. (Quando un quiz viene modificato, tutte le anteprime in corso vengono eliminate automaticamente.)';
$string['attempterrorcontentchangeforuser'] = 'Il tentativo non esiste più.';
$string['attempterrorinvalid'] = 'L\'ID del tentativo non è valido';
$string['attemptfirst'] = 'Primo tentativo';
$string['attemptgradeddelay'] = 'Ritardo notifica della valutazione del tentativo';
$string['attemptgradeddelay_desc'] = 'Il ritardo da applicare prima di inviare la notifica di valutazione del tentativo per consentire al docente di modificare la valutazione.';
$string['attemptincomplete'] = 'Il tentativo (di {$a}) non è stato ancora completato.';
$string['attemptlast'] = 'Ultimo tentativo';
$string['attemptnumber'] = 'Tentativo';
$string['attemptquiz'] = 'Tenta il quiz';
$string['attemptquiznow'] = 'Tenta il quiz adesso';
$string['attemptreviewtitle'] = '{$a}: Revisione tentativo';
$string['attemptreviewtitlepaged'] = '{$a->name}: Revisione tentativo (pagina {$a->currentpage} di {$a->totalpages})';
$string['attempts'] = 'Tentativi';
$string['attempts_help'] = 'Il numero massimo consentito di tentativi (non è il numero di tentativi aggiuntivi).';
$string['attemptsallowed'] = 'Tentativi permessi';
$string['attemptsdeleted'] = 'Tentativi eliminati';
$string['attemptselection'] = 'Scegli quali tentativi analizzare:';
$string['attemptsexist'] = 'Non puoi più aggiungere o eliminare domande.';
$string['attemptsnum'] = 'Tentativi: {$a}';
$string['attemptsnumthisgroup'] = 'Tentativi: {$a->total} ({$a->group} da questo gruppo)';
$string['attemptsnumyourgroups'] = 'Tentativi: {$a->total} ({$a->group} dai tuoi gruppi)';
$string['attemptsonly'] = 'Visualizza solo gli studenti con tentativi';
$string['attemptstate'] = 'Stato';
$string['attemptstillinprogress'] = 'Tentativo in svolgimento';
$string['attemptsummarytitle'] = '{$a}: Riepilogo dei tentativi';
$string['attemptsunlimited'] = 'Tentativi illimitati';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (pagina {$a->currentpage} di {$a->totalpages})';
$string['autosaveperiod'] = 'Frequenza di salvataggio automatico';
$string['autosaveperiod_desc'] = 'Le risposte degli studenti possono essere salvate automaticamente durante lo svolgimento di un quiz. Le risposte vengono salvate man mano che vengono date secondo il ritardo impostato. Va individuato un compromesso poiché una ritardo basso aumenterà il carico sul server ma ridurrà la probabilità che uno studente perda il suo lavoro. Se si desidera impostare una ritardo breve, si consiglia di aumentarne il valore gradualmente monitorando al contempo il carico sul server e aggiustando la frequenza di conseguenza. Impostare a 0 per disabilitare il salvataggio automatico.';
$string['back'] = 'Torna all\'anteprima della domanda';
$string['backtocourse'] = 'Torna al corso';
$string['backtoquestionlist'] = 'Torna all\'elenco delle domande';
$string['backtoquiz'] = 'Torna alla modifica del quiz';
$string['basicideasofquiz'] = 'Le basi per costruire un quiz';
$string['bestgrade'] = 'Voto migliore';
$string['bothattempts'] = 'Visualizza gli studenti con e senza tentativi';
$string['browsersecurity'] = 'Livello sicurezza browser';
$string['browsersecurity_help'] = 'Impostando "Pop-up a schermo intero con sicurezza Javascript":

* il quiz si avvierà solo se il browser ha JavaScript abilitato
* il quiz sarà visualizzato a schermo intero in una finestra pop-up senza interfaccia di navigazione che coprirà tutte le finestre sottostanti
* gli studenti per quanto possibile non potranno usare funzioni come il copia e incolla.';
$string['cachedef_overrides'] = 'Informazioni sulle personalizzazioni individuali e di gruppo';
$string['calculated'] = 'con Calcolo';
$string['calculatedquestion'] = 'Domanda con Calcolo non supportata alla linea {$a}. La domanda sarà ignorata.';
$string['cannotcreatepath'] = 'Non è possibile creare il percorso ({$a})';
$string['cannoteditafterattempts'] = 'Non puoi aggiungere o eliminare domande perché esistono tentativi già svolti. ({$a})';
$string['cannotfindprevattempt'] = 'Non è possibile trovare il tentativo da cui ricominciare.';
$string['cannotfindquestionregard'] = 'Errore nella lettura delle domande da rivalutare!';
$string['cannotinsert'] = 'Non è possibile inserire la domanda';
$string['cannotinsertrandomquestion'] = 'Non è stato possibile aggiungere una nuova domanda casuale!';
$string['cannotloadquestion'] = 'Non è stato possibile caricare le opzioni della domanda';
$string['cannotloadtypeinfo'] = 'Impossibile caricare le informazioni specifiche per il tipo di domanda';
$string['cannotopen'] = 'Non è possibile aprire il file da esportare ({$a})';
$string['cannotremoveallsectionslots'] = 'Sono state selezionate tutte le domande sottostanti l\'intestazione della sezione \'{$a}\'. Non è possibile rimuovere tutte le domande sottostanti un\'intestazione di sezione.';
$string['cannotremoveslots'] = 'Non è possibile rimuovere domande';
$string['cannotrestore'] = 'Non è stato possibile ripristinare la sessione delle domande';
$string['cannotreviewopen'] = 'Non puoi rivedere il tentativo poiché ancora aperto.';
$string['cannotsavelayout'] = 'Non è stato possibile salvare l\'impaginazione';
$string['cannotsavenumberofquestion'] = 'Non è stato possibile salvare il numero di domande per pagina';
$string['cannotsavequestion'] = 'Non è possibile salvare l\'elenco delle domande';
$string['cannotsetgrade'] = 'Non è possibile impostare un  nuovo voto massimo per il quiz';
$string['cannotsetsumgrades'] = 'Non è stato possibile impostare la somma dei voti';
$string['cannotstartgradesmismatch'] = 'Non è possibile avviare un tentativo. Il quiz è valutato con un punteggio di {$a->grade} ma non contiene nessuna domanda che possa dare un punteggio. Puoi risolvere il problema nella pagina di modifica del quiz.';
$string['cannotstartmissingquestion'] = 'Non è possibile avviare tentativi del quiz. Il quiz contiene una domanda che non esiste.';
$string['cannotstartnoquestions'] = 'Non è possibile avviare un tentativo. Il quiz non è stato impostato. Non è stata aggiunta nessuna domanda.';
$string['cannotwrite'] = 'Non è possibile scrivere il file da esportare ({$a})';
$string['canredoquestions'] = 'Consenti di riprovare durante il tentativo';
$string['canredoquestions_desc'] = 'Consente di visualizzare il pulsante \'Riprova\' dopo che lo studente ha dato una risposta alla domanda. Gli studenti potranno così rispondere ad una domanda simile (selezionata a caso) senza dover terminare il tentativo in svolgimento e cominciarne un altro. L\'impostazione è particolarmente utile per i quiz di prova.

L\'impostazione ha effetto solo sulle domande e sui comportamenti delle domande dove lo studente può rispondere compiutamente senza dover inviare il tentativo. A titolo di esempio, non sono supportati i comportamenti di tipo Feedback immediato e Interattivo con tentativi multipli e le domande di tipo componimento.';
$string['canredoquestions_help'] = 'Consente di visualizzare il pulsante \'Riprova\' dopo che lo studente ha dato una risposta alla domanda. Gli studenti potranno così rispondere ad una domanda simile (selezionata a caso) senza dover terminare il tentativo in svolgimento e cominciarne un altro. L\'impostazione è particolarmente utile per i quiz di prova.

L\'impostazione ha effetto solo sulle domande e sui comportamenti delle domande dove lo studente può rispondere compiutamente senza dover inviare il tentativo. A titolo di esempio, non sono supportati i comportamenti di tipo Feedback immediato e Interattivo con tentativi multipli e le domande di tipo componimento.';
$string['canredoquestionsyes'] = 'Gli studenti hanno la possibilità di provare un\'altra domanda';
$string['caseno'] = 'No, maiuscolo/minuscolo è irrilevante';
$string['casesensitive'] = 'Rilevanza maiuscolo/minuscolo';
$string['caseyes'] = 'Si, maiuscolo/minuscolo è rilevante';
$string['categoryadded'] = 'La categoria \'{$a}\' è stata aggiunta';
$string['categorydeleted'] = 'La categoria \'{$a}\' è stata eliminata';
$string['categorynoedit'] = 'Non hai il privilegio  di modificare la categoria \'{$a}\'.';
$string['categoryupdated'] = 'La categoria è stata modificata con successo';
$string['close'] = 'Chiudi finestra';
$string['closebeforeopen'] = 'Non è stato possibile aggiornare il quiz. Hai specificato una data di chiusura antecedente a quella di apertura.';
$string['closed'] = 'Chiuso';
$string['closepreview'] = 'Chiudi anteprima';
$string['closereview'] = 'Chiudi revisione';
$string['comment'] = 'Commento';
$string['commentorgrade'] = 'Commenta o modifica valutazione';
$string['comments'] = 'Commenti';
$string['completedon'] = 'Terminato';
$string['completionattemptsexhausted'] = 'oppure all\'esaurimento dei tentativi consentiti';
$string['completionattemptsexhausted_help'] = 'L\'attività sarà considerata completata quando lo studente avrà esaurito il massimo numero di tentativi consentiti';
$string['completionattemptsexhausteddesc'] = 'Esaurimento dei tentativi';
$string['completiondetail:minattempts'] = 'Svolgere tentativi: {$a}';
$string['completiondetail:passgrade'] = 'Ottenere la sufficienza';
$string['completiondetail:passorexhaust'] = 'Ottenere la sufficienza o esaurire tutti i tentativi';
$string['completionminattempts'] = 'Numero minimo di tentativi:';
$string['completionminattemptsdesc'] = 'Numero minimo di tentativi obbligatori: {$a}';
$string['completionminattemptserror'] = 'Il numero minimo di tentativi deve essere inferiore o uguale ai tentativi consentiti.';
$string['completionminattemptsgroup'] = 'Tentativi obbligatori';
$string['completionpass'] = 'Valutazione sufficiente';
$string['completionpass_help'] = 'L\'attività sarà considerata completata quando lo studente avrà ottenuto un punteggio pari o superiore alla sufficienza impostata nella registro valutatore.';
$string['completionpassdesc'] = 'Lo studente deve raggiungere la sufficienza per completare l\'attività';
$string['completionpassorattemptsexhausteddesc'] = 'Lo studente deve ottenere un voto sufficiente o esaurire tutti i tentativi disponibili per completare l\'attività';
$string['configadaptive'] = 'Impostando a Si, lo studente avrà la possibilità di rispondere più volte a una domanda anche all\'interno dello stesso tentativo di risposta al quiz.';
$string['configattemptsallowed'] = 'Limitazione del numero dei tentativi consentiti di risposta al quiz .';
$string['configdecimaldigits'] = 'Numero di cifre decimali da visualizzare nelle valutazioni o nei punteggi degli studenti.';
$string['configdecimalplaces'] = 'Numero di cifre decimali da visualizzare nelle valutazioni o nei punteggi dei quiz.';
$string['configdecimalplacesquestion'] = 'Numero di cifre decimali da visualizzare nelle valutazioni o nei punteggi delle domande individuali.';
$string['configdelay1'] = 'Dopo il primo tentativo, lo studente dovrà aspettare per il tempo impostato prima di ritentare il quiz';
$string['configdelay1st2nd'] = 'Dopo il primo tentativo, lo studente dovrà aspettare per il tempo impostato prima di ritentare il quiz';
$string['configdelay2'] = 'Lo studente dovrà aspettare per  tempo impostato prima di ritentare il quiz per la terza volta o per le volte successive.';
$string['configdelaylater'] = 'Lo studente dovrà aspettare per  tempo impostato prima di ritentare il quiz per la terza volta o per le volte successive.';
$string['configeachattemptbuildsonthelast'] = 'Consentendo tentativi multipli  ogni nuovo tentativo conterrà i risultati del tentativo precedente.';
$string['configgrademethod'] = 'La strategia di valutazione da usare per calcolare il voto finale se il quiz consente più tentativi.';
$string['configintro'] = 'I valori impostati sotto saranno i valori di default per o nuovi quiz. È anche possibile stabilire quali impostazioni siano da considerarsi "avanzate".';
$string['configmaximumgrade'] = 'Il voto di default rispetto al quale sarà rapportato il voto del quiz.';
$string['confignavmethod'] = 'Con la navigazione libera è possibile rispondere alle domande in qualsiasi ordine. Con la navigazione sequenziale le risposte dovranno essere date secondo l\'ordine impostato';
$string['confignewpageevery'] = 'Quando si aggiungono domande a un quiz, in base a questa impostazione saranno inseriti automaticamente dei salti di pagina .';
$string['configoutcomesadvanced'] = 'Nelle pagine di modifica quiz gli obiettivi compariranno tra le impostazioni avanzate.';
$string['configpenaltyscheme'] = 'Penalità da sottrarre per ogni risposta errata nella modalità adattiva.';
$string['configpopup'] = 'Obbliga lo svolgimento del quiz in una finestra popup ed usa JavaScript per limitare le azioni degli utenti.';
$string['configrequirepassword'] = 'Per tentare il quiz gli studenti dovranno inserire questa password.';
$string['configrequiresubnet'] = 'Gli studenti possono rispondere al quiz solo da questi computer.';
$string['configreviewoptions'] = 'Queste opzioni controllano quali informazioni gli utenti possono vedere quando esaminano i tentativi effettuati o i riepiloghi dei quiz.';
$string['configshowblocks'] = 'Consento di visualizzare i blocchi durante lo svolgimento del quiz.';
$string['configshowuserpicture'] = 'Visualizza l\'immagine dell\'utente durante i tentativi di risposta.';
$string['configshufflewithin'] = 'Abilita la modifica casuale  dell\'ordine delle risposte ad ogni nuovo tentativo. Deve essere abilitata anche la corrispondente opzione nella configurazione delle domanda.';
$string['configtimelimit'] = 'Tempo massimo di default (espresso minuti) per rispondere ai quiz. 0 significa senza tempo massimo.';
$string['configtimelimitsec'] = 'Tempo massimo di default, espresso in  secondi, per rispondere ai quiz. 0 significa nessun tempo massimo.';
$string['configurerandomquestion'] = 'Configura domanda';
$string['confirmclose'] = 'Stai per inviare e terminare il tentativo. Una volta inviato, le risposte date non potranno più essere modificate.';
$string['confirmremovequestion'] = 'Sei sicuro di rimuovere la domanda {$a}?';
$string['confirmremovesectionheading'] = 'Sei sicuro di rimuovere l\'intestazione della sezione \'{$a}\'?';
$string['confirmserverdelete'] = 'Sei sicuro di voler rimuovere il server <b>{$a}</b> dalla lista?';
$string['connectionerror'] = 'La connessione di rete si è interrotta (Il salvataggio automatico è fallito).

Annota tutte le risposte date in questa pagina negli ultimi minuti, poi prova a riconnetterti.

Una volta ripristinata la connessione, le tue risposte saranno salvate e questo messaggio scomparirà.';
$string['connectionok'] = 'La connessione di rete si è ripristinata. Puoi proseguire.';
$string['containercategorycreated'] = 'Questa categoria è stata creata per contenere tutte le categorie originali spostate a livello di sito a causa di quanto sotto specificato.';
$string['continueattemptquiz'] = 'Prosegui il tentativo';
$string['continuepreview'] = 'Continua l\'ultima anteprima';
$string['copyingfrom'] = 'Creazione di una copia della domanda \'{$a}\'';
$string['copyingquestion'] = 'Copia di una domanda';
$string['correct'] = 'Giusto';
$string['correctanswer'] = 'Risposta esatta';
$string['correctanswerformula'] = 'Formula della risposta esatta';
$string['correctansweris'] = 'Risposta esatta: {$a}';
$string['correctanswerlength'] = 'Cifre significative';
$string['correctanswers'] = 'Risposte esatte';
$string['correctanswershows'] = 'La risposta esatta avrà';
$string['corrresp'] = 'Risposta corretta';
$string['countdown'] = 'Conto alla rovescia';
$string['countdownfinished'] = 'Il quiz è terminato, devi inviare le tue risposte ora.';
$string['countdowntenminutes'] = 'Il quiz terminerà  tra dieci minuti';
$string['coursetestmanager'] = 'Formato Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Crea una categoria e aggiungi una domanda casuale';
$string['createfirst'] = 'Devi prima creare qualche domanda a risposta-breve.';
$string['createmultiple'] = 'Aggiungi al quiz molte domande casuali';
$string['createnewquestion'] = 'Crea una nuova domanda';
$string['createquestionandadd'] = 'Crea una nuova domanda ed aggiungila al quiz.';
$string['custom'] = 'Formato personalizzato';
$string['dataitemneed'] = 'È necessario aggiungere almeno un insieme di elementi per ottenere una domanda valida';
$string['datasetdefinitions'] = 'Definizioni dei dataset riusabili per la categoria {$a}';
$string['datasetnumber'] = 'Numero';
$string['daysavailable'] = 'Giorni disponibili';
$string['decimaldigits'] = 'Cifre decimali nei punteggi';
$string['decimalplaces'] = 'Cifre decimali nei punteggi';
$string['decimalplaces_help'] = 'L\'impostazione stabilisce il numero di cifre decimali da visualizzare nelle valutazioni. L\'impostazione influenza solamente la visualizzazione dei voti, non influenza la precisione dei calcoli né come i voti sono memorizzati nel database.';
$string['decimalplacesquestion'] = 'Cifre decimali nei punteggi delle domande';
$string['decimalplacesquestion_help'] = 'Le cifre decimali  da usare per visualizzare i punteggi delle singole domande.';
$string['decimalpoints'] = 'Cifre decimali';
$string['default'] = 'Default';
$string['defaultgrade'] = 'Punteggio di default della domanda';
$string['defaultinfo'] = 'La categoria di default per le domande.';
$string['delay1'] = 'Ritardo tra primo e secondo tentativo';
$string['delay1st2nd'] = 'Obbligo attesa tra 1mo e 2ndo tentativo';
$string['delay1st2nd_help'] = 'Dopo il primo tentativo, lo studente dovrà aspettare per il tempo impostato prima di ritentare il quiz';
$string['delay2'] = 'Ritardo tra i successivi tentativi';
$string['delaylater'] = 'Obbligo attesa tra i successivi tentativi';
$string['delaylater_help'] = 'Lo studente dovrà aspettare per  tempo impostato prima di ritentare il quiz per la terza volta o per le volte successive.';
$string['deleteattemptcheck'] = 'Sei sicuro di voler cancellare questi tentativi?';
$string['deleteselected'] = 'Elimina selezionati';
$string['deletingquestionattempts'] = 'Cancellazione tentativi di risposta';
$string['description'] = 'Commento';
$string['disabled'] = 'Disabilitato';
$string['displayoptions'] = 'Opzioni';
$string['donotuseautosave'] = 'Non usare il salvataggio auomatico';
$string['download'] = 'Click per scaricare il del file della categoria esportata';
$string['downloadextra'] = '(il file è anche salvato nei files del corso nella cartella /backupdata/quiz)';
$string['dragtoafter'] = 'Dopo {$a}';
$string['dragtostart'] = 'All\'inizio';
$string['duplicateresponse'] = 'Questo invio è stato ignorato perché hai già dato una risposta equivalente.';
$string['eachattemptbuildsonthelast'] = 'Ogni tentativo parte dall\'ultimo';
$string['eachattemptbuildsonthelast_help'] = 'Se sono permessi tentativi multipli e questa impostazione è abilitata,  ogni nuovo tentativo conterrà i risultati del tentativo precedente. In questo modo sarà possibile completare un quiz tentandolo più volte.';
$string['edit_slotdisplaynumber_hint'] = 'Modifica numero della domanda (massimo 16 caratteri)';
$string['edit_slotdisplaynumber_label'] = 'Nuovo valore di {$a}';
$string['editcategories'] = 'Modifica categorie';
$string['editcategory'] = 'Modifica categoria';
$string['editcatquestions'] = 'Modifica le domande della categoria';
$string['editingquestion'] = 'Modifica domanda';
$string['editingquiz'] = 'Modifica quiz';
$string['editingquiz_help'] = 'I concetti da tenere in considerazione per creare un quiz sono:

* Il quiz, che può presentare domande su una o più pagine
* Il deposito delle domande, dove sono memorizzate le domande suddivise in categorie
* Le domande casuali, per presentare domande diverse per ciascuno studente e per ciascun tentativo';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Modifica quiz: {$a}';
$string['editmaxmark'] = 'Modifica punteggio massimo';
$string['editoverride'] = 'Modifica personalizzazione';
$string['editqcats'] = 'Modifica categorie di domande';
$string['editquestion'] = 'Modifica domanda';
$string['editquestions'] = 'Modifica domande';
$string['editquiz'] = 'Modifica quiz';
$string['editquizquestions'] = 'Modifica le domande del quiz';
$string['emailconfirmautosubmitsmall'] = 'Grazie per avere inviato le risposte a \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Gentile {$a->username},

grazie per aver inviato le tue risposte al quiz \'{$a->quizname}\' nel corso \'{$a->coursename}\' alle {$a->submissiontime}.

Questa email conferma che le tue risposte sono state ricevute correttamente.

Puoi accedere al quiz tramite l\'indirizzo {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Gentile  {$a->username},

il tempo per svolgere il quiz \'{$a->quizname}\' nel corso \'{$a->coursename}\' è scaduto. Le risposte sono state inviate automaticamente alle {$a->submissiontime}.

Questo messaggio conferma che le risposte sono state salvate.

Per accedere al quiz: {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Grazie per aver risposto al quiz \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Conferma invio: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Gentile {$a->studentname},

le risposte quiz \'{$a->quizname}\' delle {$a->attempttimefinish} nel corso \'{$a->coursename}\' sono state valutate.

Potrai rivedere il tentativo e visualizzare punteggio e feedback accedendo a \'{$a->quizurl}\' .';
$string['emailmanualgradedsubject'] = 'Il tentativo del quiz {$a->quizname} è stato valutato';
$string['emailnotifybody'] = 'Gentile {$a->username},

{$a->studentname} ha completato il quiz \'{$a->quizname}\' ({$a->quizurl})
nel corso \'{$a->coursename}\'

Le risposte possono essere visualizzate all\'indirizzo {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completato {$a->quizname}. Visualizza: {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} ha completato il quiz {$a->quizname}';
$string['emailoverduebody'] = 'Gentile {$a->studentname},

hai avviato un tentativo del quiz \'{$a->quizname}\' nel corso {$a->coursename} ma non lo hai completato. Avresti dovuto inviarlo entro il {$a->attemptduedate}.

Se desideri inviare il tentativo, vai su {$a->attemptsummaryurl} e fai click sul pulsante invia.
Devi inviare il tentativo prima del {$a->attemptgraceend}, altrimenti il tentativo non sarà tenuto in considerazione.';
$string['emailoverduesmall'] = 'Non hai inviato il tentativo del quiz {$a->quizname}. Per favore, se desideri nviare il tentativo, vai su {$a->attemptsummaryurl} prima del {$a->attemptgraceend}';
$string['emailoverduesubject'] = 'Il tentativo è fuori tempo massimo: {$a->quizname}';
$string['empty'] = 'Vuoto';
$string['enabled'] = 'Abilitato';
$string['endtest'] = 'Termina il tentativo...';
$string['erroraccessingreport'] = 'Non puoi accedere a questo report';
$string['errorinquestion'] = 'Errore nella domanda';
$string['errormissingquestion'] = 'Errore: Il sistema ha perso la domanda con id {$a}';
$string['errornotnumbers'] = 'Errore - le risposte devono essere numeriche';
$string['errorunexpectedevent'] = 'Rilevato l\'inatteso codice evento {$a->event} per la domanda {$a->questionid} nel tentativo {$a->attemptid}.';
$string['essay'] = 'Risposta a Testo libero';
$string['essayquestions'] = 'Domande';
$string['eventattemptautosaved'] = 'Salvataggio automatico del tentativo quiz';
$string['eventattemptdeleted'] = 'Eliminazione tentativo qiuz';
$string['eventattemptmanualgradingcomplete'] = 'Completamento valutazione manuale del tentativo del quiz';
$string['eventattemptpreviewstarted'] = 'Avvio anteprima tentativo quiz';
$string['eventattemptquestionrestarted'] = 'Riavvio tentativo quiz';
$string['eventattemptreviewed'] = 'Revisione tentativo quiz';
$string['eventattemptsummaryviewed'] = 'Visualizzazione riepilogo del quiz';
$string['eventattemptupdated'] = 'Aggiornamento tentativo quiz';
$string['eventattemptviewed'] = 'Visualizzazione tentativo quiz';
$string['eventeditpageviewed'] = 'Visualizzazione pagina modifica quiz';
$string['eventoverridecreated'] = 'Creazione personalizzazione quiz';
$string['eventoverridedeleted'] = 'Eliminazione personalizzazione quiz';
$string['eventoverrideupdated'] = 'Eliminazione personalizzazione quiz';
$string['eventpagebreakcreated'] = 'Creazione interruzione di pagina';
$string['eventpagebreakdeleted'] = 'Eliminazione interruzione di pagina';
$string['eventquestionmanuallygraded'] = 'Valutazione domanda manualmente';
$string['eventquizattemptabandoned'] = 'Abbandono tentativo quiz';
$string['eventquizattemptregraded'] = 'Rivalutazione tentativo quiz';
$string['eventquizattemptreopened'] = 'Riapertura tentativo del quiz';
$string['eventquizattemptstarted'] = 'Avvio tentativo quiz';
$string['eventquizattemptsubmitted'] = 'Consegna tentativo quiz';
$string['eventquizattempttimelimitexceeded'] = 'Supero tempo limite tentativo quiz';
$string['eventquizgradeupdated'] = 'Aggiornamento valutazione quiz';
$string['eventquizrepaginated'] = 'Rimpaginazione quiz';
$string['eventreportviewed'] = 'Visualizzazione report quiz';
$string['eventsectionbreakcreated'] = 'Creazione interruzione di sezione';
$string['eventsectionbreakdeleted'] = 'Eliminazione interruzione di sezione';
$string['eventsectionshuffleupdated'] = 'Aggiornamento distribuzione nella sezione';
$string['eventsectiontitleupdated'] = 'Aggiornamento sezione del titolo';
$string['eventslotcreated'] = 'Creazione slot';
$string['eventslotdeleted'] = 'Eliminazione slot';
$string['eventslotmarkupdated'] = 'Aggiornamento slot';
$string['eventslotmoved'] = 'Spostato slot';
$string['everynquestions'] = 'Ogni {$a} domande';
$string['everyquestion'] = 'Ogni domanda';
$string['everythingon'] = 'Tutto su';
$string['existingcategory'] = 'Categoria esistente';
$string['exportcategory'] = 'esporta categoria';
$string['exporterror'] = 'Si è verificato  un errore durante il processo di esportazione';
$string['exportingquestions'] = 'Le domande sono in esportazione';
$string['exportname'] = 'Nome del file';
$string['exportquestions'] = 'Esporta domande su file';
$string['extraattemptrestrictions'] = 'Ulteriori restrizioni sui tentativi';
$string['false'] = 'Falso';
$string['feedback'] = 'Feedback';
$string['feedbackerrorboundaryformat'] = 'Le valutazioni di riferimento per il feedback devono essere una percentuale o un numero. Il valore immesso nella posizione {$a} non è valido.';
$string['feedbackerrorboundaryoutofrange'] = 'Le valutazioni di riferimento per il feedback devono essere tra 0% e 100%. Il valore immesso nella posizione {$a} è fuori dell\'intervallo.';
$string['feedbackerrorjunkinboundary'] = 'Devi definire le valutazioni di riferimento senza lasciare  vuoti.';
$string['feedbackerrorjunkinfeedback'] = 'Devi definire i feedback complessivi senza lasciare vuoti.';
$string['feedbackerrororder'] = 'Le valutazioni di riferimento devono essere in ordine decrescente. Il valore immesso nella posizione {$a} è fuori sequenza.';
$string['file'] = 'File';
$string['fileformat'] = 'Formato file';
$string['fillcorrect'] = 'Compilare con l\'esatta';
$string['filloutnumericalanswer'] = 'È necessario impostare almeno una risposta e la relativa tolleranza. La prima risposta corrispondente a quella data sarà usata per determinare il punteggio e il feedback. Se l\'elenco termina con un feedback senza risposta, allora tale feedback sarà visualizzato agli studenti la cui risposta non ha trovato corrispondenza con nessuna di quelle previste.';
$string['filloutoneanswer'] = 'Devi fornire almeno una risposta. Le risposte lasciate in bianco non saranno utilizzate. Puoi usare \'*\' per far corrispondere qualsiasi carattere. La prima risposta che corrisponde sarà utilizzata per determinare il punteggio ed il feedback.';
$string['filloutthreequestions'] = 'Devi fornire almeno tre domande con le corrispondenti risposte. Puoi fornire risposte errate aggiuntive inserendo una risposta senza domanda. Gli inserimenti senza domanda e senza risposta non saranno utilizzati.';
$string['fillouttwochoices'] = 'Devi fornire almeno due scelte. Le scelte lasciate in bianco non saranno utilizzate.';
$string['finishattemptdots'] = 'Completa il tentativo...';
$string['finishreview'] = 'Fine revisione';
$string['forceregeneration'] = 'forza rigenerazione';
$string['formatnotfound'] = 'Formato di importazione/esportazione {$a} non trovato';
$string['formulaerror'] = 'Errori nella formula!';
$string['fractionsaddwrong'] = 'I voti positivi che hai scelto non assommano al 100% ma al {$a}%.<br />Vuoi tornare indietro e correggere?';
$string['fractionsnomax'] = 'Una delle risposte deve essere 100%, perché sia<br />possibile una votazione piena per questa domanda.<br />Vuoi tornare indietro e correggere?';
$string['fromfile'] = 'da file';
$string['functiondisabledbysecuremode'] = 'La funzionalità è al momento disabilitata';
$string['generalfeedback'] = 'Feedback generale';
$string['generalfeedback_help'] = 'l feedback generale alla domanda è un testo che viene visualizzato allo studente dopo che ha risposto alla domanda stessa. Diversamente dal feedback per una domanda, che dipende dal tipo di domanda e dalla specifica risposta data dallo studente, tutti gli studenti visualizzano il medesimo feedback generale.';
$string['gobacktoquiz'] = 'Torna indietro';
$string['graceperiod'] = 'Tempo extra per l\'invio';
$string['graceperiod_desc'] = 'L\'intervallo di tempo di default concesso allo studente per inviare il tentativo dopo lo scadere del tempo massimo. Da usare in combinazione con l\'impostazione \'Consenti allo studente di inviare il tentativo entro un limite di tempo stabilito, senza consentirgli di rispondere ad altre domande\'.';
$string['graceperiod_help'] = 'L\'intervallo di tempo concesso allo studente per inviare il tentativo dopo lo scadere del tempo massimo. Da usare in combinazione con l\'impostazione \'Consenti allo studente di inviare il tentativo entro un limite di tempo stabilito, senza consentirgli di rispondere ad altre domande\'.';
$string['graceperiodmin'] = 'Tempo extra per l\'ultimo invio';
$string['graceperiodmin_desc'] = 'Esiste un potenziale problema nel momento in cui si chiude un quiz. Da una parte si desidera che gli studenti possano utilizzare fino all\'ultimo secondo il tempo a loro disposizione, aiutati dal timer che invia il quiz automaticamente allo scadere del tempo massimo. D\'altra parte allo scadere del tempo il server potrebbe sovraccaricarsi e richiedere più tempo per elaborare le risposte. Di conseguenza, per non penalizzare gli studenti a causa di rallentamenti del server,  verranno accettati i tentativi inviati dopo lo scadere del tempo massimo ma comunque entro il numero di secondi impostato come tempo extra per l\'ultimo invio. Naturalmente gli studenti potrebbero approfittarne ed utilizzare questi secondi per rispondere alle domande, quindi dovrai impostare un valore di compromesso in base alle reali performance che il server può offrire durante lo svolgimento dei quiz.';
$string['graceperiodtoosmall'] = 'Il tempo extra per l\'invio deve essere maggiore di {$a}.';
$string['grade'] = 'Valutazione';
$string['gradeall'] = 'Valuta tutto';
$string['gradeaverage'] = 'Voto medio';
$string['gradeboundary'] = 'Limite voto';
$string['gradeessays'] = 'Valuta i testi';
$string['gradehighest'] = 'Voto più alto';
$string['grademethod'] = 'Metodo di valutazione';
$string['grademethod_help'] = 'Quando sono consentiti più tentativi di risposta, è possibile aggregare in vari modi i voti ottenuti nei diversi tentativi:

* Voto più alto tra tutti i tentativi
* Voto medio dei tentativi
* Primo tentativo (i voti ottenuti negli altri tentativi non sono presi in considerazione)
* Ultimo tentativo (i voti ottenuti negli altri tentativi non sono presi in considerazione)';
$string['gradesdeleted'] = 'Valutazioni quiz cancellate';
$string['gradesofar'] = '<b>{$a->method}: {$a->mygrade} / {$a->quizgrade}</b>.';
$string['gradetopassmustbeset'] = 'La sufficienza non può essere zero poiché il completamento del quiz è impostato per richiedere la sufficienza. Per favore imposta un valore diverso da zero.';
$string['gradetopassnotset'] = 'Il quiz non ha una sufficienza impostata. È possibile impostarla nella sezione "Valutazione" delle impostazioni del quiz.';
$string['gradetopassoutof'] = 'Sufficienza: {$a->grade} su {$a->maxgrade}';
$string['gradingdetails'] = 'Punteggi di questo invio: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Tenendo conto delle penalità  precedenti, questo dà  <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Questo invio ha ricevuto una penalità  di {$a}.';
$string['gradingdetailszeropenalty'] = 'Non sei stato penalizzato per questo invio.';
$string['gradingmethod'] = 'Metodo di valutazione: {$a}';
$string['groupoverrides'] = 'Personalizzazioni di gruppo';
$string['groupoverridesdeleted'] = 'La personalizzazione di gruppo è stata eliminata';
$string['groupsnone'] = 'Non ci sono gruppi ai quali puoi accedere.';
$string['guestsno'] = 'Spiacente, gli ospiti non possono vedere o provare il quiz';
$string['hidebreaks'] = 'Nascondi salti pagina';
$string['hidereordertool'] = 'Nascondi numeri per ordinamento';
$string['history'] = 'Storico delle risposte date:';
$string['howquestionsbehave_desc'] = 'Impostazioni di default per il comportamento delle domande nei quiz';
$string['imagedisplay'] = 'Immagine da visualizzare';
$string['import_help'] = 'L\' opzione consente di importare domande da file.

Se il file di importazione contiene anche caratteri non-ASCII, sarà necessario utilizzare la codifica UTF-8. Quando generi i file di importazione delle domande, devi fare attenzione se usi applicativi MS Office in quanto tali applicativi usano delle codifiche particolari che non possono essere gestite correttamente.

I formati di importazione ed esportazione delle domande sono acquisiti da Moodle attraverso plugin, pertanto nel database di Moduli e Plugin potrebbero essere disponibili ulteriori formati.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importa categoria';
$string['importerror'] = 'Errore durante il processo di importazione';
$string['importfilearea'] = 'Importazione da file già nei files del corso...';
$string['importfileupload'] = 'Caricamento del file da importare';
$string['importfromthisfile'] = 'Importazione da questo file';
$string['importingquestions'] = 'Importazione di {$a} domande da file';
$string['importmax10error'] = 'C\'è un errore nella domanda. Non puoi avere più di dieci risposte';
$string['importmaxerror'] = 'C\'è un errore nella domanda. Ci sono troppe risposte.';
$string['importquestions'] = 'Importa domande da file';
$string['inactiveoverridehelp'] = '* Questa personalizzazione non ha attualmente effetto perché lo studente non può accedere all\'attività. Questo può essere causato dalla mancata appartenenza al gruppo corretto, a una errata assegnazione di ruolo, ad altre restrizioni di accesso o perché l\'attività è nascosta.';
$string['incorrect'] = 'Sbagliato';
$string['indicator:cognitivedepth'] = 'Quiz cognitivo';
$string['indicator:cognitivedepth_help'] = 'L\'indicatore è basato sulla profondità cognitiva toccata dallo studente svolgendo attività Quiz.';
$string['indicator:cognitivedepthdef'] = 'Quiz cognitivo';
$string['indicator:cognitivedepthdef_help'] = 'Durante l\'intervallo di analisi, il partecipante ha raggiunto questa percentuale di coinvolgimento cognitivo offerto dalle attività Quiz (Livelli: Nessuna visualizzazione, Visualizzazione, Invio, Visualizzazione feedback, Commento al feedback, Nuovo invio dopo il feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Quiz sociale';
$string['indicator:socialbreadth_help'] = 'L\'indicatore è basato sulla dimensione sociale raggiunta dallo studente svolgendo attività Quiz.';
$string['indicator:socialbreadthdef'] = 'Quiz sociale';
$string['indicator:socialbreadthdef_help'] = 'Durante l\'intervallo di analisi, il partecipante ha raggiunto questa percentuale di coinvolgimento sociale offerto dall\'attività Quiz (Livelli: Nessuna partecipazione, Partecipazione da solo, Partecipazione con altri)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Risposte di ciascuno ai vari  elementi';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Numero iniziale di campi per il feedback complessivo';
$string['initialnumfeedbacks_desc'] = 'Durante la creazione dei quiz, per il feedback complessivo saranno resi disponibili il numero impostato di campi. Una volta creato il quiz, saranno visualizzatii campi compilati. Il valore minimo per questa impostazione è pari ad 1.';
$string['inprogress'] = 'in svolgimento';
$string['introduction'] = 'Descrizione';
$string['invalidattemptid'] = 'Questo ID di tentativo non esiste';
$string['invalidcategory'] = 'ID categoria non valido';
$string['invalidoverrideid'] = 'L\'ID della personalizzazione non è valida';
$string['invalidquestionid'] = 'Id domanda non valido';
$string['invalidquizid'] = 'ID quiz non valido';
$string['invalidrandomslot'] = 'L\'ID dello spazio della domanda casuale non è valido.';
$string['invalidsource'] = 'Il sorgente non è accettato come valido.';
$string['invalidsourcetype'] = 'Tipo sorgente non valido.';
$string['invalidstateid'] = 'Id stato non valido';
$string['lastanswer'] = 'La tua ultima risposta è stata';
$string['layout'] = 'Impaginazione';
$string['layoutasshown'] = 'Disposizione pagina come da visualizzazione.';
$string['layoutasshownwithpages'] = 'Disposizione pagina come da visualizzazione. <small>(Salto pagina automatico ogni {$a} domande.)</small>';
$string['layoutshuffledandpaged'] = 'Domande in sequenza casuale con {$a} domande per pagina';
$string['layoutshuffledsinglepage'] = 'Domande in sequenza casuale, tutte in una pagina';
$string['legacyquizaccessrulescron'] = 'Elaborazione regole obsolete di accesso ai quiz';
$string['legacyquizreportscron'] = 'Elaborazione report obsoleti dei quiz';
$string['link'] = 'Collegamento';
$string['listitems'] = 'Elenco degli elementi di questo quiz';
$string['literal'] = 'Letterale';
$string['loadingquestionsfailed'] = 'Caricamento domande fallito: {$a}';
$string['makecopy'] = 'Salva come nuova domanda';
$string['managetypes'] = 'Gestisci i tipi di domanda e i servers';
$string['manualgradequestion'] = 'Valutazione manuale della domanda {$a->question} in {$a->quiz} by {$a->user}';
$string['manualgrading'] = 'Valutazioni';
$string['mark'] = 'Invia';
$string['markall'] = 'Invia la pagina';
$string['marks'] = 'Punteggio';
$string['marks_help'] = 'Il punteggio numerico per ciascuna domanda e il punteggio totale per il tentativo';
$string['match'] = 'Corrispondenza';
$string['matchanswer'] = 'Risposta corrispondente';
$string['matchanswerno'] = 'Risposta corrispondente {$a}';
$string['max'] = 'Massimo';
$string['maxmark'] = 'Punteggio massimo';
$string['messageprovider:attempt_grading_complete'] = 'Notifica di valutazione del tentativo';
$string['messageprovider:attempt_overdue'] = 'Notifiche sui tentativi dei quiz fuori tempo massimo';
$string['messageprovider:confirmation'] = 'Conferme sui propri completamenti di quiz';
$string['messageprovider:submission'] = 'Notifiche di consegne quiz';
$string['min'] = 'Minimo';
$string['minutes'] = 'Minuti';
$string['missingcorrectanswer'] = 'Deve essere specificata la risposta corretta';
$string['missingitemtypename'] = 'Nome mancante';
$string['missingquestion'] = 'Questa domanda sembra non esistere più';
$string['modulename'] = 'Quiz';
$string['modulename_help'] = 'Il modulo di attività quiz consente al docente di creare questionari con diversi tipi di domande: scelta multipla, vero/falso, corrispondenza, risposta breve, calcolata, eccetera.

Il docente può impostare il quiz affinché sia possibile tentarlo più volte con l\'ordine delle domande cambiato casualmente o con domande pescate casualmente ad ogni nuovo tentativo. È anche possibile impostare un tempo massimo di svolgimento.

Ogni tentativo viene valutato automaticamente (ad eccezione delle domande componimento) e la valutazione viene memorizzata nel registro valutatore.

Il docente può decidere quando e come far vedere agli studenti le risposte esatte, i feedback ed eventuali suggerimenti.

È possibile usare il quiz per:

* esami dei corsi
* brevi test su dispense di studio o alla termine di un argomento
* pratica di esami usando domande provenienti da esami di anni precedenti
* dare un feedback sulla performance
* autovalutazione';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Quiz';
$string['moveselectedonpage'] = 'Sposta le domande selezionate a pagina: {$a}';
$string['multichoice'] = 'Risposta multipla';
$string['multipleanswers'] = 'Scegli almeno una risposta.';
$string['mustbesubmittedby'] = 'Questo tentativo deve essere inviato entro {$a}.';
$string['name'] = 'Nome';
$string['navigatenext'] = 'Pagina successiva';
$string['navigateprevious'] = 'Pagina precedente';
$string['navmethod'] = 'Metodo di navigazione';
$string['navmethod_free'] = 'Libero';
$string['navmethod_help'] = 'Con il metodo di navigazione sequenziale lo studente dovrà procedere ordinatamente e non potrà tornare indietro o saltare in avanti.';
$string['navmethod_seq'] = 'Sequenziale';
$string['navnojswarning'] = 'Attenzione: le risposte non verranno salvate usando i link. Utilizza il pulsante Avanti in fondo alla pagina.';
$string['neverallononepage'] = 'Tutte le domande su una sola pagina';
$string['newattemptfail'] = 'Errore: Non è stato possibile avviare un nuovo tentativo del quiz';
$string['newcategory'] = 'Nuova categoria';
$string['newpage'] = 'Salto pagina';
$string['newpage_help'] = 'Per i quiz molto lunghi è utile distribuire le domande su più pagine, limitando il numero delle stesse per ogni pagina. Aggiungendo domande a un quiz, verranno automaticamente aggiunti dei salti-pagina secondo l\'impostazione scelta. In ogni caso i salti-pagina potranno essere liberamente spostati a mano in seguito nella pagina di modifica del quiz.';
$string['newpageevery'] = 'Inizia automaticamente una nuova pagina';
$string['newsectionheading'] = 'Nuova intestazione';
$string['noanswers'] = 'Non è stata selezionata nessuna risposta!';
$string['noattempts'] = 'Non è presente nessun tentativo di questo quiz';
$string['noattemptsfound'] = 'Non sono stati trovati tentativi';
$string['noattemptstoshow'] = 'Non ci sono tentativi da visualizzare';
$string['nocategory'] = 'Categoria errata o non specificata';
$string['noclose'] = 'Senza data di chiusura';
$string['nocommentsyet'] = 'Ancora nessun commento.';
$string['noconnection'] = 'Al momento non c\'è connessione con un web service che può elaborare questa domanda. Contatta il tuo amministratore di sistema';
$string['nodataset'] = 'niente - non è un carattere jolly';
$string['nodatasubmitted'] = 'Non è stato inviato nessun dato.';
$string['noessayquestionsfound'] = 'Non è stata trovata nessuna  domanda valutata manualmente';
$string['nogradewarning'] = 'Questo quiz non è valutato, quindi non può essere impostato un feedback complessivo dipendente dalla valutazione.';
$string['nomoreattempts'] = 'Non sono permessi altri tentativi';
$string['none'] = 'Nessuno';
$string['noopen'] = 'Senza data di apertura';
$string['nooverridedata'] = 'Devi personalizzare almeno una delle impostazioni del quiz';
$string['nopossibledatasets'] = 'Insieme dati non accettabile';
$string['noquestionintext'] = 'Il testo della domanda non contiene alcuna domanda inglobata';
$string['noquestions'] = 'Ancora non sono state aggiunte domande';
$string['noquestionsfound'] = 'Non sono state trovate domande';
$string['noquestionsinquiz'] = 'Non ci sono domande in questo quiz.';
$string['noquestionsnotinuse'] = 'Questa domanda casuale non è in uso poiché la sua categoria è vuota.';
$string['noquestionsonpage'] = 'Pagina vuota';
$string['noresponse'] = 'Nessuna risposta';
$string['noreview'] = 'Non hai il privilegio di rivedere questo quiz';
$string['noreviewattempt'] = 'Non hai il privilegio di rivedere questo tentativo.';
$string['noreviewshort'] = 'Non permesso';
$string['noreviewuntil'] = 'Non hai il privilegio di rivedere questo quiz fino a {$a}';
$string['noreviewuntilshort'] = 'Disponibile {$a}';
$string['noscript'] = 'I JavaScript devono essere abilitati per poter continuare!';
$string['notavailabletostudents'] = 'Nota: Attualmente questo quiz non è disponibile agli studenti.';
$string['notenoughrandomquestions'] = 'Non ci sono domande sufficienti per creare la domanda {$a->name} ({$a->id}) nella categoria  {$a->category}.';
$string['notenoughsubquestions'] = 'Non sono state definite sufficienti sotto domande!<br />Vuoi tornare indietro e correggere la domanda?';
$string['notifyattemptsgradedtask'] = 'Invio notifiche della valutazione di tentativi del quiz';
$string['notimedependentitems'] = 'Elementi dipendenti dal tempo non sono attualmente supportati dal modulo quiz. Nel frattempo si può fissare un limite di tempo per l\'intero quiz. Preferisci scegliere un elemento differente (o usare lo stesso l\'elemento corrente)?';
$string['notyetgraded'] = 'Non ancora valutato';
$string['notyetviewed'] = 'Non ancora visualizzato';
$string['notyourattempt'] = 'Questo non è il tuo tentativo!';
$string['noview'] = 'L\'utente autenticato non ha il privilegio di visualizzare questo quiz';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} hanno eseguito {$a->attemptnum} tentativi';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerica';
$string['numquestionsx'] = 'Domande: {$a}';
$string['oneminute'] = '1 minuto';
$string['onlyteachersexport'] = 'Solo i docenti possono esportare domande';
$string['onlyteachersimport'] = 'Solo i docenti con diritto di modifica possono importare domande';
$string['onthispage'] = 'Questa pagina';
$string['open'] = 'Senza risposta';
$string['openafterclose'] = 'Non è stato possibile aggiornare il quiz. La data di apertura è successiva alla data di chiusura.';
$string['openclosedatesupdated'] = 'Date apertura e chiusura quiz aggiornate';
$string['optional'] = 'opzionale';
$string['orderandpaging'] = 'Ordinamento e impaginazione';
$string['orderandpaging_help'] = 'I numeri 10, 20, 30, ... a fianco di ciascuna domanda indicano l\'ordinamento delle domande. Gli incrementi di 10 consentono di lasciare spazi per inserire ulteriori domande.

Per inserire una interruzione di pagina dopo una determinata domanda, seleziona la casella accanto alla domanda e fai click sul pulsante "Aggiungi pagina dopo la domanda selezionata" .

Per riordinare le domande presenti su più pagine, dai click sul pulsante "Rimpagina" e scegli il numero di domande da far apparire su ciascuna pagina.';
$string['orderingquiz'] = 'Ordinamento e impaginazione';
$string['orderingquizx'] = 'Ordinamento ed impaginazione:{$a}';
$string['outcomesadvanced'] = 'Gli obiettivi sono impostazioni avanzate';
$string['outof'] = '{$a->grade} su un massimo di {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} su un massimo di {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback complessivo';
$string['overallfeedback_help'] = 'Il feedback complessivo al quiz è un testo che viene visualizzato allo studente dopo che ha risposto al quiz stesso. Il testo visualizzato può dipendere dalla valutazione finale ottenuta in funzione dei limiti configurati (espressi come percentuale o come numero).';
$string['overdue'] = 'In ritardo';
$string['overduehandling'] = 'Allo scadere del tempo massimo';
$string['overduehandling_desc'] = 'Le modalità di gestione del tentativo nel caso in cui lo studente non invii il quiz prima dello scadere del tempo massimo.';
$string['overduehandling_help'] = 'L\'impostazione controlla cosa succede quando lo studente non invia il proprio tentativo prima dello scadere del tempo. Nel caso in cui gli studenti stiano ancora lavorando sul quiz, il timer invierà automaticamente il tentativo, tuttavia se gli studenti non fossero più in linea per qualche motivo, l\'impostazione consente di decidere l\'azione da eseguire.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'I tentativi devono essere inviati prima dello scadere del tempo, altrimenti non saranno validi.';
$string['overduehandlingautosubmit'] = 'I tentativi aperti saranno inviati automaticamente';
$string['overduehandlinggraceperiod'] = 'Consenti di inviare i tentativi entro un limite di tempo stabilito, senza consentire di rispondere ad altre domande';
$string['overduemustbesubmittedby'] = 'Il tentativo è fuori tempo massimo e dovrebbe essere già stato inviato. Se desideri che il quiz sia valutato, devi inviarlo entro {$a}. In mancanza, il tentativo non riceverà nessun punteggio.';
$string['override'] = 'Personalizzazione';
$string['overridedeletegroupsure'] = 'Sei sicuro di eliminare la personalizzazione per il gruppo {$a}?';
$string['overridedeleteusersure'] = 'Sei sicuro di eliminare la personalizzazione per l\'utente {$a}?';
$string['overridegroup'] = 'Personalizzazione per il gruppo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Personalizzazioni';
$string['overridesforquiz'] = 'Impostazioni personalizzazioni: {$a}';
$string['overridesnoneforgroups'] = 'Non sono state create modifiche alle impostazioni di gruppo per questo quiz.';
$string['overridesnoneforusers'] = 'Non sono state create personalizzazioni individuali in questo quiz.';
$string['overridessummary'] = 'Esistono personalizzazioni delle impostazioni ({$a})';
$string['overridessummarygroup'] = 'Gruppi: {$a}';
$string['overridessummarythisgroup'] = 'Esistono personalizzazioni ({$a}) per questo gruppo';
$string['overridessummaryuser'] = 'Utenti: {$a}';
$string['overridessummaryyourgroups'] = 'Esistono personalizzazioni ({$a}) per i tuoi gruppi';
$string['overrideuser'] = 'Personalizzazione per l\'utente';
$string['overrideusereventname'] = '{$a->quiz} - Personalzizzazione';
$string['page-mod-quiz-attempt'] = 'Pagina del tentativo del quiz';
$string['page-mod-quiz-edit'] = 'Modifica pagina quiz';
$string['page-mod-quiz-report'] = 'Qualsiasi pagina con report del quiz';
$string['page-mod-quiz-review'] = 'Pagina di revisione del tentativo del quiz';
$string['page-mod-quiz-summary'] = 'Pagina di riepilogo del tentativo del quiz';
$string['page-mod-quiz-view'] = 'Pagina informativa del quiz';
$string['page-mod-quiz-x'] = 'Qualsiasi pagina con modulo quiz';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Dimensione pagina';
$string['parent'] = 'Categoria superiore';
$string['parentcategory'] = 'Categoria superiore';
$string['parsingquestions'] = 'Analisi domande da file di importazione.';
$string['partiallycorrect'] = 'Parzialmente corretto';
$string['penalty'] = 'Penalità';
$string['penaltyscheme'] = 'Penalità';
$string['penaltyscheme_help'] = 'In caso di risposta sbagliata verrà applicata una penalizzazione al punteggio della domanda. Il valore della penalizzazione si imposta nella configurazione della domanda. La penalizzazione si applica solo con il Modo adattivo.';
$string['percentcorrect'] = 'Percentuale corretta';
$string['pleaseclose'] = 'La tua richiesta è stata elaborata. Ora puoi chiudere questa finestra';
$string['pluginadministration'] = 'Gestione Quiz';
$string['pluginname'] = 'Quiz';
$string['popup'] = 'Visualizza il quiz in una finestra \'sicura\'';
$string['popupblockerwarning'] = 'Questa sezione del test avviene in modo protetto, il che significa che devi eseguire il quiz in una finestra "sicura". Per favore, disattiva il blocco dei popup nel tuo browser. Grazie.';
$string['popupnotice'] = 'Gli studenti visualizzeranno questo quiz in una finestra "sicura"';
$string['preprocesserror'] = 'Si è verificato un errore durante la pre-elaborazione!';
$string['preview'] = 'Anteprima';
$string['previewquestion'] = 'Anteprima domanda';
$string['previewquiz'] = 'Anteprima {$a}';
$string['previewquiznow'] = 'Anteprima immediata quiz';
$string['previewquizstart'] = 'Anteprima quiz';
$string['previous'] = 'Stato precedente';
$string['privacy:metadata:core_question'] = 'L\'attività Quiz memorizza informazioni sull\'utilizzo delle domande nel sottosistema core_question.';
$string['privacy:metadata:quiz'] = 'L\'attività Quiz utilizza i Report del quiz.';
$string['privacy:metadata:quiz_attempts'] = 'Dettagli su ogni tentativo del quiz.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Numero del tentativo.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Pagina corrente su cui si trova l\'utente.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Orario di notifica all\'utente della avvenuta valutazione manuale del tentativo';
$string['privacy:metadata:quiz_attempts:preview'] = 'Indicatore di anteprima del quiz.';
$string['privacy:metadata:quiz_attempts:state'] = 'Stato corrente del tentativo.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Somma delle valutazioni nel tentativo.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Orario di verifica dello stato.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Data e ora di completamento del tentativo.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Orario di modifica del tentativo.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Orario di modifica del tentativo tramite modifica offline.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Orario di inizio del tentativo.';
$string['privacy:metadata:quiz_grades'] = 'Dettagli sulla valutazione generale del quiz.';
$string['privacy:metadata:quiz_grades:grade'] = 'Valutazione generale del quiz.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Il quiz che è stato valutato.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Orario di modifica della valutazione.';
$string['privacy:metadata:quiz_grades:userid'] = 'L\'utente che ha ricevuto una valutazione.';
$string['privacy:metadata:quiz_overrides'] = 'Dettagli sulle personalizzazioni per questo quiz.';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Quiz con informazioni sulla personalizzazione.';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Nuovo orario di chiusura del quiz.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Nuovo tempo massimo del quiz.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Nuovo orario di apertura del quiz.';
$string['privacy:metadata:quiz_overrides:userid'] = 'L\'utente personalizzato.';
$string['privacy:metadata:quizaccess'] = 'L\'attività Quiz utilizza le Regole di accesso al quiz.';
$string['publish'] = 'Rendere pubblico';
$string['publishedit'] = 'Devi avere il permesso nel corso da pubblicare per aggiungere o modificare le domande in questa categoria';
$string['qbrief'] = 'D. {$a}';
$string['qname'] = 'nome';
$string['qti'] = 'Formato IMS QTI';
$string['qtypename'] = 'tipo, nome';
$string['question'] = 'Domanda';
$string['questionbank'] = 'dal deposito domande';
$string['questionbankmanagement'] = 'Gestione Deposito domande';
$string['questionbehaviour'] = 'Comportamento domanda';
$string['questioncats'] = 'Categorie di domande';
$string['questiondeleted'] = 'Questa domanda è stata eliminata. Contattare il docente.';
$string['questiondependencyadd'] = 'È possibile rispondere alla domanda {$a->thisq} senza restrizioni • Click per modificare';
$string['questiondependencyfree'] = 'Questa domanda non ha restrizioni';
$string['questiondependencyremove'] = 'Per rispondere alla domanda {$a->thisq} è necessario rispondere alla domanda precedente {$a->previousq} • Click per modificare';
$string['questiondependsonprevious'] = 'Per rispondere a questa domanda è necessario rispondere alla domanda precedente.';
$string['questiondraftonly'] = 'La domanda {$a} è in stato di bozza. Per utilizzarla nel quiz, andare nel deposito delle delle domande e modificare lo stato in pronto.';
$string['questiondraftwillnotwork'] = 'Questa domanda è in stato di bozza. Per utilizzarla nel quiz, andare nel deposito delle delle domande e modificare lo stato in pronto.';
$string['questioninuse'] = 'La domanda \'{$a->questionname}\' è attualmente usata in: <br />{$a->quiznames}<br />La domanda non sarà  cancellata da tali quiz ma solamente dalla categoria.';
$string['questionmissing'] = 'Mancano le domande per questa sessione';
$string['questionname'] = 'Nome della domanda';
$string['questionnonav'] = '<span class="accesshide">Domanda </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informazione </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'La domanda {$a} non può essere caricata dal database';
$string['questionorder'] = 'Ordinamento domande';
$string['questionposition'] = 'Nuova posizione ordinale della domanda {$a}';
$string['questions'] = 'Domande';
$string['questionsetpreview'] = 'Anteprima set di domande';
$string['questionsinclhidden'] = 'Domande (incluse le nascoste)';
$string['questionsinthisquiz'] = 'Domande in questo quiz';
$string['questionsmatchingfilter'] = 'Domande che corrispondono al filtro: {$a}';
$string['questionsperpage'] = 'Domande per pagina';
$string['questionsperpageselected'] = 'È stato definito il numero di domande per pagina per cui l\'impaginazione è al momento bloccata. Come risultato, i controlli per l\'impaginazione sono stati disabilitati. Questo si può cambiare in {$a}.';
$string['questionsperpagex'] = 'Domande per pagina: {$a}';
$string['questiontext'] = 'Testo della domanda';
$string['questiontextisempty'] = '[Testo della domanda mancante]';
$string['questiontype'] = 'Tipo domanda {$a}';
$string['questiontypesetupoptions'] = 'Opzioni di impostazione per i tipi domanda:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (più recente)';
$string['quiz:addinstance'] = 'Aggiungere quiz';
$string['quiz:attempt'] = 'Tentare quiz';
$string['quiz:deleteattempts'] = 'Eliminare tentativi dei quiz';
$string['quiz:emailconfirmsubmission'] = 'Ricevere messaggio di conferma all\'invio del proprio tentativo';
$string['quiz:emailnotifyattemptgraded'] = 'Ricevere notifica della valutazione del proprio tentativo';
$string['quiz:emailnotifysubmission'] = 'Ricevere notifica via email all\'invio di tentativi';
$string['quiz:emailwarnoverdue'] = 'Ricevere una notifica quando è scaduto il tempo massimo per svolgere il tentativo del quiz';
$string['quiz:grade'] = 'Valutare i quiz manualmente';
$string['quiz:ignoretimelimits'] = 'Ignorare tempo massimo del quiz';
$string['quiz:manage'] = 'Gestire quiz';
$string['quiz:manageoverrides'] = 'Gestire personalizzazioni quiz';
$string['quiz:preview'] = 'Visualizzare anteprima quiz';
$string['quiz:regrade'] = 'Rivalutare i tentativi dei quiz';
$string['quiz:reopenattempts'] = 'Riaprire tentativi quiz mai inviati';
$string['quiz:reviewmyattempts'] = 'Rivedere i propri tentativi';
$string['quiz:view'] = 'Visualizzare informazioni sui quiz';
$string['quiz:viewoverrides'] = 'Visualizzare personalizzazioni quiz';
$string['quiz:viewreports'] = 'Visualizzare report sui quiz';
$string['quizavailable'] = 'Il quiz è disponibile fino a: {$a}';
$string['quizclose'] = 'Chiusura';
$string['quizclosed'] = 'Il quiz è stato chiuso il {$a}';
$string['quizcloses'] = 'Chiusura';
$string['quizcloseson'] = 'Il quiz chiuderà il {$a}';
$string['quizeventcloses'] = '{$a} chiude';
$string['quizeventopens'] = '{$a} apre';
$string['quizisclosed'] = 'Questo quiz è chiuso';
$string['quizisclosedwillopen'] = 'Il quiz è chiuso (apre il {$a})';
$string['quizisopen'] = 'Questo quiz è aperto';
$string['quizisopenwillclose'] = 'Quiz aperto (chiude il {$a})';
$string['quiznavigation'] = 'Navigazione quiz';
$string['quizopen'] = 'Apertura';
$string['quizopenclose'] = 'Date di apertura e chiusura';
$string['quizopenclose_help'] = 'Gli studenti possono tentare il quiz solo dopo la data di apertura. Devono anche terminare il tentativo entro la data di chiusura.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Questo quiz è aperto.';
$string['quizopenedon'] = 'Il quiz è aperto dal {$a}';
$string['quizopens'] = 'Quiz disponibile';
$string['quizopenwillclose'] = 'Questo quiz è aperto, sarà chiuso il {$a} alle';
$string['quizordernotrandom'] = 'Ordinamento del quiz non casuale';
$string['quizorderrandom'] = '* Ordinamento del quiz casuale';
$string['quizreport'] = 'Report del quiz';
$string['quizsettings'] = 'Impostazioni quiz';
$string['quiztimer'] = 'Quiz Timer';
$string['quizwillopen'] = 'Questo quiz sarà aperto il {$a}';
$string['random'] = 'Domanda casuale';
$string['randomcreate'] = 'Crea Domande casuali';
$string['randomediting'] = 'Modifica domanda casuale';
$string['randomfromcategory'] = 'Domande casuali dalla categoria:';
$string['randomfromexistingcategory'] = 'Domanda random da una categoria esistente';
$string['randomfromunavailabletag'] = '{$a} (non disponibile)';
$string['randomnosubcat'] = 'Domande presenti in questa categoria, escluse le sotto categorie.';
$string['randomnumber'] = 'Numero di domande casuali';
$string['randomquestion'] = 'Domanda casuale';
$string['randomquestion_help'] = 'Le domande casuali consentono di inserire domande scelte casualmente da una categoria o in base a tag presenti in una attività.';
$string['randomquestiontags'] = 'Tag';
$string['randomquestiontags_help'] = 'È possibile restringere ulteriormente i criteri di selezione specificando alcuni tag di domanda.

Le domande "casuali" verranno selezionate tra le domande che hanno questi tag.';
$string['randomquestionusinganewcategory'] = 'Domanda random da una nuova categoria';
$string['randomwithsubcat'] = 'Domande presenti in questa categoria, incluse le sotto categorie.';
$string['readytosend'] = 'Stai per inviare l\'intero quiz per la valutazione. Sei sicuro di voler continuare?';
$string['reattemptquiz'] = 'Ritenta il quiz';
$string['recentlyaddedquestion'] = 'Domanda aggiunta recentemente';
$string['recurse'] = 'Includi anche le domande presenti nelle sotto categorie';
$string['redoesofthisquestion'] = 'Altre domande dove lo studente ha riprovato: {$a}';
$string['redoquestion'] = 'Riprova con una domanda simile a questa';
$string['regrade'] = 'Rivaluta tutti i tentativi';
$string['regradecomplete'] = 'Tutti i tentativi sono stati rivalutati';
$string['regradecount'] = '{$a->changed} su {$a->attempt} valutazioni sono state cambiate';
$string['regradedisplayexplanation'] = 'I tentativi che cambiano durante la rivalutazione sono visualizzati come link alla finestra di revisione della domanda';
$string['regradenotallowed'] = 'Non hai l\'autorizzazione di rivalutare questo quiz';
$string['regradingquestion'] = 'Ricalcolo valutazione "{$a}".';
$string['regradingquiz'] = 'Rivalutazione quiz "{$a}"';
$string['remove'] = 'Rimuovi';
$string['removeallgroupoverrides'] = 'Elimina tutte le personalizzazioni di gruppo';
$string['removeallquizattempts'] = 'Elimina tutti i tentativi del quiz';
$string['removealluseroverrides'] = 'a tutte le personalizzazioni individuali';
$string['removeemptypage'] = 'Rimuovi pagina vuota';
$string['removepagebreak'] = 'Elimina interruzione di pagina';
$string['removeselected'] = 'Rimuovi selezionati';
$string['rename'] = 'Cambia il nome';
$string['renderingserverconnectfailed'] = 'Il server <b>{$a}</b> non è riuscito ad elaborare una richiesta RQP. Controlla la correttezza del URL.';
$string['reopenattempt'] = 'Riapri';
$string['reopenattemptareyousuremessage'] = 'll tentativo {$a->attemptnumber} di {$a->attemptuser} sarà riaperto.';
$string['reopenattemptareyousuretitle'] = 'Riaprire il tentativo?';
$string['reopenattemptwrongstate'] = 'Il tentativo {$a->attemptid} è nello stato errato ({$a->stato}) per essere riaperto.';
$string['reopenedattemptwillbeinprogress'] = 'Il tentativo rimarrà aperto e potrà essere proseguito.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Il tentativo rimarrà aperto e potrà essere continuato fino al {$a}., quando il quiz sarà chiuso.';
$string['reopenedattemptwillbesubmitted'] = 'Il tentativo sarà inviato immediatamente per la valutazione.';
$string['reorderquestions'] = 'Riordina domande';
$string['reordertool'] = 'Visualizza numeri per ordinamento';
$string['repaginate'] = 'Rimpagina con {$a} domande per pagina';
$string['repaginatecommand'] = 'Rimpagina';
$string['repaginatenow'] = 'Rimpagina ora';
$string['replace'] = 'Sostituisci';
$string['replacementoptions'] = 'Opzioni di sostituzione';
$string['report'] = 'Report';
$string['reportanalysis'] = 'Analisi risultati';
$string['reportattemptsfrom'] = 'Tentativi di';
$string['reportattemptsthatare'] = 'Stato dei tentativi';
$string['reportdisplayoptions'] = 'Opzioni di visualizzazione';
$string['reportfullstat'] = 'Statistiche dettagliate';
$string['reportmulti_percent'] = 'Percentuali multiple';
$string['reportmulti_q_x_student'] = 'Scelte studente multiple';
$string['reportmulti_resp'] = 'Risposte individuali';
$string['reportmustselectstate'] = 'Devi scegliere almeno uno stato';
$string['reportnotfound'] = 'Report sconosciuto ({$a})';
$string['reportoverview'] = 'Panoramica';
$string['reportregrade'] = 'Rivaluta tentativi';
$string['reportresponses'] = 'Dettaglio risposte date';
$string['reports'] = 'Report';
$string['reportshowonly'] = 'Visualizza solo tentativi';
$string['reportshowonlyfinished'] = 'Visualizza al più un tentativo completato per utente ({$a})';
$string['reportsimplestat'] = 'Statistiche semplici';
$string['reportusersall'] = 'tutti gli utenti che hanno tentato il quiz';
$string['reportuserswith'] = 'utenti iscritti che hanno tentato il quiz';
$string['reportuserswithorwithout'] = 'utenti iscritti che hanno o non hanno tentato il quiz';
$string['reportuserswithout'] = 'utenti iscritti che non hanno tentato il quiz';
$string['reportwhattoinclude'] = 'Cosa includere nel report';
$string['requirepassword'] = 'Password d\'accesso';
$string['requirepassword_help'] = 'Impostando una password di accesso, gli studenti dovranno inserirla prima di tentare il quiz.';
$string['requiresubnet'] = 'Indirizzi di rete abilitati';
$string['requiresubnet_help'] = 'È possibile limitare l\'accesso a un quiz ai soli computer presenti su una particolare sotto rete di una LAN o di Internet, specificando una lista di indirizzi IP, parziali o completi, separati da virgole. L\'impostazione è particolarmente utile per "proteggere" un quiz, ad esempio quando si vuole consentire l\'accesso al quiz solo alle persone presenti in un certa sala.';
$string['response'] = 'Risposta data';
$string['responses'] = 'Risposte date';
$string['results'] = 'Risultati';
$string['returnattempt'] = 'Torna al tentativo';
$string['reuseifpossible'] = 'riutilizza rimossi in prcedenza';
$string['reverttodefaults'] = 'Torna ai default del quiz';
$string['review'] = 'Revisione';
$string['reviewafter'] = 'Consenti revisione dopo che il quiz è stato chiuso';
$string['reviewalways'] = 'Consenti revisione in qualunque momento';
$string['reviewattempt'] = 'Rivedi tentativo';
$string['reviewbefore'] = 'Consenti revisione durante l\'apertura del quiz';
$string['reviewclosed'] = 'Dopo che il quiz è stato chiuso';
$string['reviewduring'] = 'Durante il tentativo';
$string['reviewimmediately'] = 'Subito dopo il tentativo';
$string['reviewnever'] = 'Non consentire mai la revisione';
$string['reviewofquestion'] = 'Revisione della domanda {$a->question} in {$a->quiz} di{$a->user}';
$string['reviewopen'] = 'Dopo, mentre il quiz è ancora aperto';
$string['reviewoptions'] = 'Gli studenti possono rivedere';
$string['reviewoptionsheading'] = 'Opzioni di revisione';
$string['reviewoptionsheading_help'] = 'Queste impostazioni controllano le informazioni che gli utenti potranno visualizzare dopo avere tentato il quiz.

**Durante il tentativo** è rilevante solo se si usano i comportamenti in grado di visualizzare feedback durante lo svolgimento del tentativo, come ad esempio "interattivo con risposte multiple".

**Subito dopo il tentativo**  ha valenza entro i due minuti successivi al completamento del tentativo.

** Più tardi, a quiz ancora aperto** è come il caso precedente ma entro la data di chiusura del quiz.

** Dopo la chiusura del quiz** ha valenza dopo la data di chiusura del quiz. Se il quiz non ha una data di chiusura, questa condizione non sarà mai soddisfatta.';
$string['reviewoverallfeedback'] = 'Feedback complessivo';
$string['reviewoverallfeedback_help'] = 'Il feedback visualizzato al termine del tentativo in funzione del punteggio totale ottenuto dallo studente.';
$string['reviewresponse'] = 'Revisione risposte date';
$string['reviewresponsetoq'] = 'Rivedi la risposta data (domanda {$a})';
$string['reviewthisattempt'] = 'Rivedi le risposte date in questo tentativo';
$string['rqp'] = 'Domanda remota';
$string['rqps'] = 'Domande remote';
$string['sameasoverall'] = 'Stesse del punteggio finale';
$string['save'] = 'Salva';
$string['saveandedit'] = 'Salva modifiche e aggiorna domande';
$string['saveattemptfailed'] = 'Errore nel salvataggio dell\'attuale tentativo di risposta al quiz.';
$string['savedfromdeletedcourse'] = 'Salvato dal corso cancellato "<b>{$a}</b>"';
$string['savegrades'] = 'Salva i voti';
$string['savemyanswers'] = 'Salva le mie risposte';
$string['savenosubmit'] = 'Salva senza inviare';
$string['saveoverrideandstay'] = 'Salva ed inserisci un\'altra personalizzazione';
$string['savequiz'] = 'Salva l\'intero quiz';
$string['saving'] = 'Salvataggio in corso';
$string['savingnewgradeforquestion'] = 'Salvataggio della nuovo voto della domanda id {$a}.';
$string['savingnewmaximumgrade'] = 'Salvataggio del nuovo punteggio massimo';
$string['score'] = 'Valutazione grezza';
$string['scores'] = 'Valutazioni';
$string['search:activity'] = 'Quiz - Informazioni sull\'attività';
$string['sectionheadingedit'] = 'Modifica intestazione \'{$a}\'';
$string['sectionheadingremove'] = 'Elimina intestazione \'{$a}\'';
$string['sectionnoname'] = 'Sezione senza titolo';
$string['seequestions'] = '(Visualizza domande)';
$string['select'] = 'Seleziona';
$string['selectall'] = 'Seleziona tutto';
$string['selectattempt'] = 'Seleziona tentativo';
$string['selectcategory'] = 'Seleziona categoria';
$string['selectedattempts'] = 'Tentativi selezionati...';
$string['selectmultipleitems'] = 'Seleziona più elementi';
$string['selectmultipletoolbar'] = 'Seleziona barre degli strumenti multiple';
$string['selectnone'] = 'Deseleziona tutto';
$string['selectquestionslot'] = 'Seleziona domanda {$a}';
$string['selectquestiontype'] = '-- Scegli il tipo di domanda --';
$string['serveradded'] = 'Server aggiunto';
$string['serveridentifier'] = 'Identificativo';
$string['serverinfo'] = 'Informazioni sul server';
$string['servers'] = 'Server';
$string['serverurl'] = 'URL del server';
$string['shortanswer'] = 'Risposta breve';
$string['show'] = 'Visualizza';
$string['showall'] = 'Visualizza tutte le domande nella stessa pagina';
$string['showblocks'] = 'Visualizza i blocchi durante lo svolgimento del quiz';
$string['showblocks_help'] = 'Se impostato a si, i blocchi saranno visualizzati durante lo svolgimento del quiz.';
$string['showbreaks'] = 'Visualizza salti pagina';
$string['showcategorycontents'] = 'Visualizza il contenuto della categoria {$a->arrow}';
$string['showcorrectanswer'] = 'Visualizzare le risposte esatte nel feedback?';
$string['showdetailedmarks'] = 'Visualizza dettagli punteggio';
$string['showeachpage'] = 'Visualizza una pagina alla volta';
$string['showfeedback'] = 'Visualizzare il feedback dopo le risposte?';
$string['showinsecurepopup'] = 'Finestra popup \'sicura\'';
$string['showlargeimage'] = 'Immagine grande';
$string['shownoattempts'] = 'Visualizza studenti senza tentativi';
$string['shownoattemptsonly'] = 'Visualizza solo gli studenti senza tentativi';
$string['shownoimage'] = 'Nessuna immagine';
$string['showreport'] = 'Visualizza report';
$string['showsmallimage'] = 'Immagine piccola';
$string['showteacherattempts'] = 'Visualizza i tentativi degli insegnanti';
$string['showuserpicture'] = 'Visualizza immagini degli utenti';
$string['showuserpicture_help'] = 'Abilitando l\'impostazione, il nome dello studente e la sua immagine saranno visualizzati durante lo svolgimento del tentativo e sulla schermata di revisione allo scopo di rendere più facile controllare  che un utente non sia entrato con il nome di un altro.';
$string['shuffle'] = 'Ordine casuale';
$string['shuffleanswers'] = 'Risposte in ordine casuale';
$string['shuffledrandomly'] = 'In ordine casuale';
$string['shufflequestions'] = 'Ordinamento casuale';
$string['shufflequestions_help'] = 'Consente di cambiare in modo casuale l\'ordine delle domande presenti nella sezione tutte le volte che si avvia un nuovo tentativo.

L\'impostazione è utile per rendere più difficile la condivisione delle ripsoste tra gli studenti ma renderà anche più difficile il colloquio con gli insegnati relativo alle domande.';
$string['shufflewithin'] = 'Alternative in ordine casuale';
$string['shufflewithin_help'] = 'Abilitando l\'impostazione, la sequenza della possibili risposte alternative sarà cambiata in modo casuale  ad ogni tentativo da parte dello studente. L\'impostazione funzionerà solo se l\'analoga impostazione sarà abilitata anche nelle impostazioni delle domande.';
$string['singleanswer'] = 'Scegli una risposta.';
$string['sortage'] = 'Ordine temporale';
$string['sortalpha'] = 'Ordine alfabetico';
$string['sortquestionsbyx'] = 'Ordina domande per: {$a}';
$string['sortsubmit'] = 'Ordina domande';
$string['sorttypealpha'] = 'Ordine per tipo, nome';
$string['specificapathnotonquestion'] = 'Il percorso del file non è nella domanda specificata';
$string['specificquestionnotonquiz'] = 'La domanda specificata non è nel quiz specificato.';
$string['startagain'] = 'Ricomincia';
$string['startattempt'] = 'Avvia il tentativo';
$string['startedon'] = 'Iniziato';
$string['startnewpreview'] = 'Avvia una nuova anteprima';
$string['stateabandoned'] = 'Non inviato';
$string['statefinished'] = 'Completato';
$string['statefinisheddetails'] = 'Inviato {$a}';
$string['stateinprogress'] = 'In svolgimento';
$string['statenotloaded'] = 'Lo stato della domanda {$a} non è stato caricato dal database';
$string['stateoverdue'] = 'Fuori tempo massimo';
$string['stateoverduedetails'] = 'Deve essere inviato da {$a}';
$string['status'] = 'Stato';
$string['stoponerror'] = 'Stop in caso di errore';
$string['submission_confirmation'] = 'Inviare le risposte e terminare?';
$string['submission_confirmation_unanswered'] = 'Domande senza risposta: {$a}';
$string['submitallandfinish'] = 'Invia e termina';
$string['subneterror'] = 'Spiacente, questo quiz è impostato in modo da essere accessibile solo da certi indirizzi di rete. Attualmente i tuo computer non è abilitato all\'utilizzo di questo quiz.';
$string['subnetnotice'] = 'Questo quiz è impostato in modo da essere accessibile solo da certi indirizzi di rete. Il tuo computer non è su una sotto-rete abilitata. Comunque come insegnante puoi vedere l\'anteprima.';
$string['subplugintype_quiz'] = 'Report';
$string['subplugintype_quiz_plural'] = 'Report';
$string['subplugintype_quizaccess'] = 'Regola di accesso';
$string['subplugintype_quizaccess_plural'] = 'Regole di accesso';
$string['substitutedby'] = 'sarà  sostituito da';
$string['summaryofattempt'] = 'Riepilogo del tentativo';
$string['summaryofattempts'] = 'Riepilogo dei tuoi tentativi precedenti ';
$string['temporaryblocked'] = 'Temporaneamente non è permesso ritentare il quiz.<br />Potrai tentare nuovamente il:';
$string['theattempt'] = 'Il tentativo';
$string['theattempt_help'] = 'Imposta se lo studente può avere o meno la possibilità di rivedere il proprio tentativo.';
$string['time'] = 'Ora';
$string['timecompleted'] = 'Completato';
$string['timedelay'] = 'Non è permesso accedere al quiz finché non sarà passato il tempo per poter accedere a un altro quiz';
$string['timeleft'] = 'Tempo rimasto';
$string['timelimit'] = 'Tempo massimo';
$string['timelimit_help'] = 'L\'impostazione consente la visualizzazione de limite di tempo nella pagina iniziale del quiz e un timer nel blocco navigazione quiz che presenta il conto alla rovescia del tempo rimasto.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Spiacente! Il tempo per il quiz è scaduto!';
$string['timestr'] = '%H:%M:%S del %d/%m/%y';
$string['timesup'] = 'Tempo scaduto!';
$string['timetaken'] = 'Tempo impiegato';
$string['timing'] = 'Durata';
$string['tofile'] = 'su file';
$string['tolerance'] = 'Tolleranza';
$string['toomanyrandom'] = 'Il numero di domande casuali richieste è maggiore di quello  delle domande contenute in questa categoria! ({$a})';
$string['top'] = 'Top';
$string['totalmarksx'] = 'Totale punti: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Totale di {$a} domande nella categoria.';
$string['true'] = 'Vero';
$string['truefalse'] = 'Vero/falso';
$string['type'] = 'Tipo';
$string['unfinished'] = 'aperto';
$string['ungraded'] = 'Non valutato';
$string['unit'] = 'Unità';
$string['unknowntype'] = 'Tipo di domanda non supportato alla linea {$a}. La domanda sarà ignorata';
$string['updateoverdueattemptstask'] = 'Aggiornamento dei tentativi di quiz scaduti';
$string['updatequizslotswithrandomxofy'] = 'Aggiornamento degli slot dei quiz con i dati delle domande "casuali" ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Aggiorna impostazioni quiz';
$string['updatingatttemptgrades'] = 'Aggiornamento voti del tentativo.';
$string['updatingfinalgrades'] = 'Aggiornamento voti finali.';
$string['updatingthegradebook'] = 'Aggiornamento registro valutatore.';
$string['upgradesure'] = '<div>In particolare il modulo quiz  eseguirà  cambiamenti significativi delle tabelle e l\'aggiornamento software non è stato ancora testato sufficientemente. prima di procedere, si raccomanda vivamente di eseguire il backup delle tabelle.</div>';
$string['upgradingquizattempts'] = 'Aggiornamento tentativi quiz: quiz {$a->done}/{$a->outof} (Id del quiz  {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Aggiornamento tentativi quiz molto vecchi: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Questa categoria è stata spostata a livello di sito, perché, dopo la cancellazione del corso, le domande in essa contenute erano utilizzate da altri quiz esistenti nel server.';
$string['useroverrides'] = 'Personalizzazioni individuali';
$string['useroverridesdeleted'] = 'Personalizzazioni individuali eliminate';
$string['usersnone'] = 'Nessuno studente ha accesso al quiz';
$string['validate'] = 'Convalida';
$string['viewallanswers'] = 'Vedi {$a} quiz completati';
$string['viewallreports'] = 'Vedi risultati per {$a} tentativi';
$string['viewed'] = 'Visualizzato';
$string['warningmissingtype'] = '<b>La domanda è di un tipo ancora non installato su questo Moodle.<br />Per favore, avverti il tuo amministratore Moodle .</b>';
$string['wheregrade'] = 'Dov\'è il mio voto';
$string['wildcard'] = 'Carattere jolly';
$string['windowclosing'] = 'Questa finestra si chiuderà tra breve.';
$string['withsummary'] = 'con statistiche riepilogative';
$string['wronguse'] = 'Non puoi utilizzare la pagina in questo modo';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'È necessario essere iscritti al corso prima di tentare il quiz';
$string['yourfinalgradeis'] = 'Il tuo voto finale per questo quiz è {$a}';
