<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_generator', language 'sr_cr', version '4.2'.
 *
 * @package     tool_generator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['additionalmodules'] = 'Додатне активности';
$string['additionalmodules_help'] = 'Изаберите још активности које имплементирају функцију course_backend_generator_create_activity које ћете укључити у тест курс.';
$string['bigfile'] = 'Велика датотека {$a}';
$string['courseexplanation'] = 'Ово има за циљ да обезбеди стандардизовано мерило за проверу поузданости
и перформансе различитих компоненти система (као што је креирање резервне копије и њено рестаурирање).

Овај тест је важан зато што је претходно било много случајева где систем, суочен са употребом у реалним ситуацијама (нпр. курс са 1, 000 активности), није радио.

Курсеви креирани помоћу овог алата могу да заузму велики део базе података и простора за смештај датотека (десетине гигабајта). Мораћете да обришете курсеве (и сачекате да различити алати за чишћења буду покренути) како бисте поново ослободите овај простор.

**Немојте користити овај алат на продукционом серверу**.
Користите га искључиво на развојном серверу.
(Да би се избегло случајно коришћење, овај алат је онемогућен, осим ако у систему порука за отклањање грешака нисте  изабрали опцију РАЗВОЈНЕ.)';
$string['coursesize_0'] = 'XS (~10KB; креирај за ~1 секунд)';
$string['coursesize_1'] = 'S (~10MB; креирај за ~30 секунди)';
$string['coursesize_2'] = 'M (~100MB; креирај за ~2 минута)';
$string['coursesize_3'] = 'L (~1GB; креирај за ~30 минута)';
$string['coursesize_4'] = 'XL (~10GB; креирај за ~2 сата)';
$string['coursesize_5'] = 'XXL (~20GB; креирај за ~4 сата)';
$string['coursewithoutusers'] = 'Изабрани курсеви немају кориснике';
$string['createcourse'] = 'Креирај курс';
$string['createtestplan'] = 'Креирај план тестирања';
$string['creating'] = 'Креира се курс';
$string['done'] = 'урађено ({$a})';
$string['downloadtestplan'] = 'Преузми план тестирања';
$string['downloadusersfile'] = 'Преузми корисничке датотеке';
$string['error_nocourses'] = 'Не постоје курсеви за генерисање пкана тестирања';
$string['error_noforumdiscussions'] = 'Изабрани куrс не садржи дискусије на форумима';
$string['error_noforuminstances'] = 'Изабрани курс не садржи инстанце модула "Форум"';
$string['error_noforumreplies'] = 'Изабрани курс не садржи одговоре на форумима';
$string['error_nonexistingcourse'] = 'Наведени курс не постоји';
$string['error_nopageinstances'] = 'Изабрани курс не садржи инстанце модула "Страница"';
$string['error_notdebugging'] = 'Није доступно на овом серверу јер систем порука за отклањање грешака није постављен на опцију РАЗВОЈНЕ';
$string['error_nouserspassword'] = 'Потребно је да у  датотеци config.php подесите $CFG->tool_generator_users_password за генерисање плана тестирања';
$string['fullname'] = 'Пробни курс: {$a->size}';
$string['maketestcourse'] = 'Направи пробни курс';
$string['maketestplan'] = 'Направи JMeter план тестирања';
$string['notenoughusers'] = 'Изабрани курс нема довољан број корисника';
$string['pluginname'] = 'Генератор развојних података';
$string['privacy:metadata'] = 'Додатак Генератор развојних података не чува никакве личне податке.';
$string['progress_checkaccounts'] = 'Проверавају се кориснички налози ({$a})';
$string['progress_coursecompleted'] = 'Курс је завршен ({$a}s)';
$string['progress_createaccounts'] = 'Креирају се кориснички налози ({$a->from} - {$a->to})';
$string['progress_createassignments'] = 'Креирају се задаци ({$a})';
$string['progress_createbigfiles'] = 'Креирају се велике датотеке ({$a})';
$string['progress_createcourse'] = 'Креира се курс {$a}';
$string['progress_createforum'] = 'Креира се форум ({$a} порука)';
$string['progress_createpages'] = 'Креирају се странице ({$a})';
$string['progress_createsmallfiles'] = 'Креирају се мале датотеке ({$a})';
$string['progress_enrol'] = 'Уписују се корисници на курс ({$a})';
$string['progress_sitecompleted'] = 'Сајт је завршен ({$a}s)';
$string['shortsize_0'] = 'XS';
$string['shortsize_1'] = 'S';
$string['shortsize_2'] = 'M';
$string['shortsize_3'] = 'L';
$string['shortsize_4'] = 'XL';
$string['shortsize_5'] = 'XXL';
$string['sitesize_0'] = 'XS (~10MB; 3 курса, креиран за ~30 секунди)';
$string['sitesize_1'] = 'S (~50MB; 8 курсева, креиран за ~2 минута)';
$string['sitesize_2'] = 'M (~200MB; 73 курса, креиран за ~10 минута)';
$string['sitesize_3'] = 'L (~1\'5GB; 277 курсева, креиран за ~1\'5 сат)';
$string['sitesize_4'] = 'XL (~10GB; 1065 курсева, креиран за ~5 сати)';
$string['sitesize_5'] = 'XXL (~20GB; 4177 курсева, креиран за ~10 сати)';
$string['size'] = 'Величина курса';
$string['smallfiles'] = 'Мале датотеке';
$string['targetcourse'] = 'Тестирај циљни курс';
$string['testplanexplanation'] = 'Овај алат креира JMeter датотеку са планом тестирања заједно са датотеком са корисничким именима и лозинкама.

Овај план тестирања је дизајниран тако да ради заједно са {$a}, који олакшава да се тест покрене у специфичном Moodle окружењу, прикупе информације о покренутим тестирањима, као и да се упореде резултати. Зато ће бити потребно да га преузмете и употребите његов скрипт test_runner.sh или да пратите упутства о инсталацији и коришћењу.

Потребно је да подесите лозинку за кориснике курса у датотеци config.php (нпр. $CFG->tool_generator_users_password = \'moodle\';). Како би се спречила ненамерна употреба алата, не постоји стандардна вредност за ову лозинку. Потребно је да користите опцију за ажурирање лозинки у случају да корисници вашег курса имају друге лозинке или у случају да су лозинке креиране помоћу алата tool_generator, али без подешавања вредности $CFG->tool_generator_users_password.

Алат је део tool_generatora тако да добро ради са курсевима који су креирани помоћу генератора сајта и курсева. Такође, алат се може користити са било којим курсом који садржи барем:

* Довољан број уписаних корисника (зависно од величине плана тестирања који изаберете) са лозинком ресетованом на  \'moodle\'
* Инстанцу модула \'Страница\'
* Инстанцу модула \'Форум\' са најмање једном дискусијом и једним одговором

Када будете покретали велике планове тестирања, било би добро да узмете у обзир перформансе вашег сервера,  пошто количина података за учитавање, које генерише JMeter, може бити посебно велика. Период убрзања је прилагођен броју нити (корисника) како би се смањила ова врста проблема, али је оптерећење и даље огромно.


**Немојте покретати план тестирања на продукционом серверу**. Ова функција само креира датотеке за потребе JMeter тестирања тако да сам по себи није опасна, али **НИКАДА** не треба покретати овај тест на продукционом серверу.';
$string['testplansize_0'] = 'XS број корисника: ({$a->users}, број петљи: {$a->loops} и период убрзања {$a->rampup})';
$string['testplansize_1'] = 'S број корисника: ({$a->users}, број петљи: {$a->loops} и период убрзања {$a->rampup})';
$string['testplansize_2'] = 'M број корисника: ({$a->users}, број петљи: {$a->loops} и период убрзања {$a->rampup})';
$string['testplansize_3'] = 'L број корисника: ({$a->users}, број петљи: {$a->loops} и период убрзања {$a->rampup})';
$string['testplansize_4'] = 'XL број корисника: ({$a->users}, број петљи: {$a->loops} и период убрзања {$a->rampup})';
$string['testplansize_5'] = 'XXL број корисника: ({$a->users}, број петљи: {$a->loops} и период убрзања {$a->rampup})';
$string['updateuserspassword'] = 'Ажурирај лозинке корисника курса';
$string['updateuserspassword_help'] = 'Потребно је да се JMeter пријави као корисник курса; корисничке лозинке можете да подесите користећи подешавање $CFG->tool_generator_users_password у датотеци config.php; ово подешавање ажурира лозинке корисника курса на основу $CFG->tool_generator_users_password. То може бити корисно у случају да користите курс који није генерисан помоћу алатке за генерисање пробних курсева или ако  $CFG->tool_generator_users_password није био подешен када стре креирали пробне курсеве.';
