<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'sr_lt', version '4.2'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Brisanje aktivnost u toku...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" nije ispravna vrednost za godine.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" ima više ili manje od jednog zareza (graničnika)';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" nije ispravna vrednost za zemlju (državu)';
$string['agedigitalconsentmapinvaliddefault'] = 'Podrazumevana vrednost (*) nedostaje.';
$string['agelocationverificationdisabled'] = 'Potvrda uzrasta i mesta onemogućena';
$string['alreadyloggedin'] = 'Već ste prijavljeni kao {$a}. Potrebno je da se odjavite pre nego što se prijavite pod drugim korisničkim imenom.';
$string['authnotexisting'] = 'Dodatak ѕa proveru identiteta ne postoji';
$string['backupcontainexternal'] = 'Ova datoteka rezervne kopije sadrži spoljašnje Moodle mrežne servere koji nisu lokalno podešeni';
$string['backuptablefail'] = 'Tabele rezervnre kopije nisu mogle biti uspešno podešene!';
$string['blockcannotconfig'] = 'Ovaj blok ne podržava globalnu konfiguraciju';
$string['blockcannotinistantiate'] = 'Problem prilikom kreiranja instance objekta bloka';
$string['blockcannotread'] = 'Nije bilo moguće pročitati podatke za blockid= {$a}';
$string['blockdoesnotexist'] = 'Ovaj blok ne postoji';
$string['blockdoesnotexistonpage'] = 'Ovaj blok (id={$a->instanceid}) ne postoji na ovoj stranici ({$a->url}).';
$string['blocknameconflict'] = 'Konflikt u nazivu: blok {$a->name} ima isti naslov kao i postojeći blok: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Funkcija "Povratni komentar" (Comment callback) je odbila ovaj komentar';
$string['cannotaddcoursemodule'] = 'Nije bilo moguće dodati novi modul';
$string['cannotaddcoursemoduletosection'] = 'Nije bilo moguće dodati novi modul u ovu sekciju';
$string['cannotaddmodule'] = '{$a} modul nije mogao biti dodat listi modula!';
$string['cannotaddnewmodule'] = 'Nije bilo moguće dodati novi modul {$a}';
$string['cannotaddrss'] = 'Nemate dozvolu da dodajete RSS izvore vesti';
$string['cannotaddthisblocktype'] = 'Ne možete da dodate blok {$a} na ovu stranicu.';
$string['cannotassignrole'] = 'Nije moguće dodeliti ulogu na nivou kursa';
$string['cannotassignrolehere'] = 'Nije Vam dozvoljeno da dodeljujete ovu ulogu (id = {$a->roleid}) u ovom kontekstu ({$a->context})';
$string['cannotassignselfasparent'] = 'Nije moguće sebi dodeliti nadređenu ulogu';
$string['cannotcallscript'] = 'Ne možete da pozovete ovaj skript na taj način';
$string['cannotcallusgetselecteduser'] = 'Ne možete da pozovete user_selector::get_selected_user ukoliko je opcija multiselect uključena';
$string['cannotcreatebackupdir'] = 'Nije bilo moguće kreirati direktorijum za rezervnu kopiju podataka. Administrator sajta mora da reši taj problem';
$string['cannotcreatecategory'] = 'Kategorija nije ubačena';
$string['cannotcreatedboninstall'] = '<p>Nije moguće kreirati bazu podataka.</p> <p>Navedena baza ne postoji, a dati korisnik nema ovlašćenja da kreira bazu podataka.</p> <p>Administrator sajta treba da proveri konfiguraciju baze podataka.</p>';
$string['cannotcreategroup'] = 'Greška prilikom kreiranja grupe';
$string['cannotcreatelangbase'] = 'Greška: Nije bilo moguće kreirati osnovni direktorijum jezika';
$string['cannotcreatelangdir'] = 'Nije moguće kreirati direktorijum jezika';
$string['cannotcreateorfindstructs'] = 'Greška u pronalaženju ili kreiranju sturkture sekcija za ovaj kurs';
$string['cannotcreatepopupwin'] = 'Nedefinisani element - nije moguće kreirati iskačući prozor';
$string['cannotcreatesitedir'] = 'Nije moguće kreirati direktorijum sajta. Administrator sajta mora da reši taj problem';
$string['cannotcreatetempdir'] = 'Nije moguće kreirati privremeni direktorijum';
$string['cannotcreateuploaddir'] = 'Nije moguće kreirati direktorijum za postavljanje datoteka. Administrator sajta mora da reši taj problem';
$string['cannotcustomisefiltersblockuser'] = 'Ne možete da prilagodite podešavanja filtera u kontekstu korisnika odnosno u kontekstu bloka';
$string['cannotdeletebackupids'] = 'Nije bilo moguće obrisati id oznake prethodnih rezervnih kopija';
$string['cannotdeletecategorycourse'] = 'Nije uspelo brisanje kursa \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'Nije bilo moguće obrisati pitanja iz kategorije  \'{$a}\'';
$string['cannotdeletecourse'] = 'Nemate dozvolu da obrišete ovaj kurs';
$string['cannotdeletecustomfield'] = 'Greška pri brisanju prilagođenog polja podataka';
$string['cannotdeletedir'] = 'Nije moguće obrisati ({$a})';
$string['cannotdeletefile'] = 'Nije moguće obrisati ovu datoteku';
$string['cannotdeleterole'] = 'Ne  može biti obrisano zbog {$a}';
$string['cannotdeleterolewithid'] = 'Nije moguće obrisati ulogu sa ID {$a}';
$string['cannotdeletethisrole'] = 'Ne možete da obrišete ovu ulogu zato što je koristi sistem ili je to poslednja uloga sa administratorskim nivoom pristupa.';
$string['cannotdisableformat'] = 'Podrazumevani format ne može biti onemogućen.';
$string['cannotdownloadcomponents'] = 'Nije moguće preuzeti komponente.';
$string['cannotdownloadlanguageupdatelist'] = 'Nije moguće preuzeti spisak ažuriranih jezika sa download.moodle.org';
$string['cannotdownloadzipfile'] = 'Nije moguće preuzeti arhivu';
$string['cannoteditcomment'] = 'Ovaj komentar nije vaš i ne možete da ga uređujete!';
$string['cannoteditcommentexpired'] = 'Ne možete ovo da uređujete. Vreme je isteklo!';
$string['cannoteditpostorblog'] = 'Ne možete da postujete ili uređujete blog';
$string['cannoteditsiteform'] = 'Ne možete urediti kurs sajta koristeći ovaj obrazac';
$string['cannotedituserpreferences'] = 'Ne mogu se menjati preferencije ovog korisnika';
$string['cannotedityourprofile'] = 'Oprostite, ali ne možete da uređujete svoj profil';
$string['cannotexecduringupgrade'] = 'Ne može se izvršiti u toku nadogradnje';
$string['cannotfindcategory'] = 'Nije moguće pronaći zapis u bazi o kategoriji čiji je identifikator {$a}';
$string['cannotfindcomponent'] = 'Nije moguće pronaći komponentu.';
$string['cannotfindcontext'] = 'Nije moguće pronaći kontekst.';
$string['cannotfindcourse'] = 'Nije moguće pronaći kurs';
$string['cannotfinddocs'] = 'Nije moguće pronaći datoteke dokumentacije za "{$a}" jezik';
$string['cannotfindgradeitem'] = 'Nije moguće naći grade_item';
$string['cannotfindgroup'] = 'Nije moguće naći grupu';
$string['cannotfindhelp'] = 'Nije moguće pronaći datoteke pomoći za "{$a}" jezik.';
$string['cannotfindinfo'] = 'Nije moguće naći informacije za: "{$a}"';
$string['cannotfindlang'] = 'Nije moguće pronaći "{$a}" jezički paket!';
$string['cannotfindteacher'] = 'Nije moguće pronaći predavača';
$string['cannotfinduser'] = 'Nije moguće pronaći korisnika po imenu "{$a}"';
$string['cannotgeoplugin'] = 'Nije moguće uspostaviti vezu sa geoPlugin serverom na https://www.geoplugin.com. Molimo, proverite podešavanja proksi servera ili instalirajte datoteku za MaxMind GeoLite City.';
$string['cannotgetblock'] = 'Nije moguće pristupiti blokovima u bazi podataka';
$string['cannotgetcats'] = 'Nije moguće dobiti zapis kategorije';
$string['cannotgetdata'] = 'Nije moguće dobiti podatak';
$string['cannotgradeuser'] = 'Nije moguće oceniti ovog korisnika';
$string['cannothaveparentcate'] = 'Категорија курса не може имати надређену категорију!';
$string['cannotimport'] = 'Greška prilikom uvoza';
$string['cannotimportformat'] = 'Oprostite, ali uvoz ovog formata još uvek nije implementiran';
$string['cannotimportgrade'] = 'Greška u uvozu ocena';
$string['cannotinsertgrade'] = 'Nije moguće ubaciti stavku ocene bez ID oznake kursa!';
$string['cannotinsertrate'] = 'Nije bilo moguće ubaciti novo ocenjivanje ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Nije moguć unos ID za novi zapis: {$a}';
$string['cannotmailconfirm'] = 'Greška u slanju e-poruke za potvrdu promene lozinke';
$string['cannotmanualctrack'] = 'Nije podržano ručno praćenje završetka ove aktivnosti';
$string['cannotmapfield'] = 'Otkrivena je kolizija prilikom mapiranja - dva polja mapiraju istu stavku ocene {$a}';
$string['cannotmarktopic'] = 'Nije bilo moguće označiti tu temu za ovaj kurs';
$string['cannotmigratedatacomments'] = 'Nije moguće migrirati komentare modula podataka';
$string['cannotmodulename'] = 'Nije moguće dobiti naziv modula prilikom kreiranja navigacije';
$string['cannotmoduletype'] = 'Nije moguće dobiti tip modula prilikom kreiranja navigacije';
$string['cannotmovecategory'] = 'Kategorija se ne može premestiti';
$string['cannotmovecourses'] = 'Nije moguće premestiti kurseve iz kategorije u kojoj se nalaze u drugu kategoriju.';
$string['cannotmoverolewithid'] = 'Nije moguće premestiti ulogu sa ID {$a}';
$string['cannotopencsv'] = 'Nije moguće otvoritu CSV datoteku';
$string['cannotopenfile'] = 'Nije moguće otvoriti datoteku ({$a})';
$string['cannotopenforwrit'] = 'Nije moguće otvoriti za upsisivanje: {$a}';
$string['cannotopentemplate'] = 'Nije moguće otvoriti datoteku šablona ({$a})';
$string['cannotopenzip'] = 'Nije moguće otvoriti zip arhivu, verovatno zbog greške sa zip ekstenzijom na 64-bitnom operativnom sistemu.';
$string['cannotoverridebaserole'] = 'Nije moguće menjati osnovne mogućnosti uloge';
$string['cannotoverriderolehere'] = 'Nije Vam dozvljeno da menjate ovu ulogu (id = {$a->roleid}) u ovom kontekstu ({$a->context})';
$string['cannotreadfile'] = 'Nije moguće pročitati datoteku ({$a})';
$string['cannotreadtmpfile'] = 'Greška prilikom čitanja privremene datoteke';
$string['cannotreaduploadfile'] = 'Nije bilo moguće pročitati postavljenu datoteku';
$string['cannotremovefrommeta'] = 'Nnje bilo moguće ukloniti izabrani kurs iz ovog metakursa!';
$string['cannotreprocessgrades'] = 'Nije moguće ponovo obraditi ocene za aktivnost {$a}';
$string['cannotresetguestpwd'] = 'Ne možete da resetujete lozinku gosta';
$string['cannotresetmail'] = 'Greška prilikom resetovanja lozinke i njenog slanja na Vašu elektronsku adresu';
$string['cannotresetthisrole'] = 'Nije moguće resetovati ovu ulogu';
$string['cannotrestore'] = 'Pojavila se greška te poroces restauracije ne može biti završen!';
$string['cannotrestoreadminorcreator'] = 'Morate da bude kreator kursa ili administrator kako bi restauraciju rezervne kopije u novi kurs';
$string['cannotrestoreadminoredit'] = 'Morate da bude predavač ili administrator kako bi restauraciju rezervne kopije u izabrani kurs';
$string['cannotsaveagreement'] = 'Nije bilo moguće sačuvati Vaš sporazum';
$string['cannotsaveblock'] = 'Greška prilikom pokušaja da se sačuva konfiguracija bloka';
$string['cannotsavecomment'] = 'Nije moguće sačuvati komentar';
$string['cannotsavedata'] = 'Nije moguće sačuvati podatke';
$string['cannotsavefile'] = 'Nije moguće sačuvati datoteku "{$a}"!';
$string['cannotsavemd5file'] = 'Nije moguće sačuvati md5 datoteku.';
$string['cannotsavezipfile'] = 'Nije moguće sačuvti ZIP arhivu.';
$string['cannotservefile'] = 'Nije moguće prikazati datoteku zbog problema sa konfiguracijom servera.';
$string['cannotsetparentforcatoritem'] = 'Nije moguće postaviti nadređenu kategoriju ili kurs';
$string['cannotsetpassword'] = 'Nije moguće podesiti korisničku lozinku!';
$string['cannotsetprefgrade'] = 'Nije moguće postaviti parametar aggregationview na {$a} za ovu kategoriju ocena.';
$string['cannotsettheme'] = 'Nije moguće podesiti šemzu izgleda';
$string['cannotsetupblock'] = 'NIJE bilo moguće uspešno podesiti tabele blokova !';
$string['cannotsetupcapformod'] = 'Nije bilo moguće podesiti mogućnosti za  {$a}';
$string['cannotsetupcapforplugin'] = 'Nije bilo moguće podesiti mogućnosti za  {$a}';
$string['cannotshowhidecoursesincategory'] = 'Nije moguće prikazati/sakriti kurseve u kategoriji {$a}';
$string['cannotsignup'] = 'Ne možete kreirati novi nalog jer ste već ulogovani kao {$a}.';
$string['cannotswitcheditmodeon'] = 'Nije moguće uključiti režim uređivanja';
$string['cannotunassigncap'] = 'Nije moguće ukloniti zastarelu sposobnost {$a->cap} iz uloge {$a->role}';
$string['cannotunassignrolefrom'] = 'Nije moguće ovom korisniku ukloniti id uloge: {$}';
$string['cannotunzipfile'] = 'Nije moguće raspakovati ZIP datoteku.';
$string['cannotupdatemod'] = 'Nije bilo moguće ažurirati {$a}';
$string['cannotupdatepasswordonextauth'] = 'Ažuriranje lozinke na eksternom sistemu za proveru identiteta: {$a} nije uspelo. Za više informacija pogledajte zapise na serveru.';
$string['cannotupdateprofile'] = 'Greška prilikom ažuriranja korisničkog zapisa';
$string['cannotupdaterecord'] = 'Nije moguće ažurirati zapis sa ID {$a}';
$string['cannotupdaterss'] = 'Nije moguće ažurirati RSS izvor vesti';
$string['cannotupdatesubcourse'] = 'Nije moguće ažurirati podređeni kurs';
$string['cannotupdateusermsgpref'] = 'Nije moguće ažuriranje korisnikovih podešavanja privatnih poruka';
$string['cannotupdateuseronexauth'] = 'Ažuriranje korisničkih podataka na eksternom sistemu za proveru identiteta: {$a} nije uspelo. Za više informacija pogledajte zapise na serveru.';
$string['cannotuploadfile'] = 'Greška u obradi datoteke za postavljanje';
$string['cannotuseadmin'] = 'Morate da budete administrator da biste koristili ovu stranicu';
$string['cannotuseadminadminorteacher'] = 'Morate da budete predavač ili administrator da biste koristili ovu stranicu';
$string['cannotusepage'] = 'Samo predavači i adminstratori mogu da koriste ovu stranicu';
$string['cannotusepage2'] = 'Oprostite, ne možet da koristite ovu stranicu';
$string['cannotviewcategory'] = 'Nemate dozvolu da vidite ovaj spisak kurseva.';
$string['cannotviewprofile'] = 'Ne možete videti profil ovog korisnika';
$string['cannotviewreport'] = 'Ne možete videti ovaj izveštaj';
$string['cannotwritefile'] = 'Nije moguće upisivanje u ovu datoteku ({$a})';
$string['categoryerror'] = 'Greška kategorije';
$string['categoryidnumbertaken'] = 'ID broj se već koristi za drugu kategoriju';
$string['categorynamerequired'] = 'Neophodan je naziv kategorije';
$string['categorytoolong'] = 'Naziv kategorije je predug';
$string['commentmisconf'] = 'ID komentara je pogrešno konfigurisan';
$string['componentisuptodate'] = 'Komponenta je dostupna u svojoj najnovijoj verziji';
$string['confirmationnotenabled'] = 'Potvrda korisnika nije omogućena na ovom sajtu';
$string['confirmsesskeybad'] = 'Nažalost, ali ključ vaše sesije ne može biti potvrđen kako bi se izvršila ova akcija. Ova sigurnosna opcija sprečava slučajno ili zlonamerno izvršavanje važnih funkcija u vaše ime. Proverite da li ste stvarno hteli da izvršite ovu funkciju.';
$string['contenttypenotfound'] = 'Tip banke sadržaja \'{$a}\' ne postoji ili nije prepoznat.';
$string['contentvisibilitynotfound'] = 'Vidljivost sadržaja sa vrednošću \'{$a}\'  ne postoji ili nije prepoznat.';
$string['couldnotassignrole'] = 'Došlo je do ozbiljne, ali neodređene greške prilikom pokušaja dodele Vaše nove uloge';
$string['couldnotupdatenoexistinguser'] = 'Nije moguće ažurirati korisnika - korisnik ne postoji';
$string['couldnotverifyagedigitalconsent'] = 'Došlo je do greške pri pokušaju provere saglasnosti o digitalnom uzrastu.<br />Molimo kontaktirajte administratora.';
$string['countriesphpempty'] = 'Greška: Datoteka countries.php u jezičkom paketu {$a} je prazna ili nedostaje.';
$string['coursedoesnotbelongtocategory'] = 'Kurs ne pripada ovoj kategoriji';
$string['courseformatnotfound'] = 'Format kursa \'{$a}\' ne postoji ili nije prepoznat';
$string['coursegroupunknown'] = 'Odgovarajući kurs za grupu {$a} nije zadat';
$string['courseidnotfound'] = 'ID oznaka kursa ne postoji';
$string['courseidnumbertaken'] = 'ID broj se već koristi za drugi kurs ({$a})';
$string['coursemisconf'] = 'Kurs je pogrešno konfigurisan';
$string['courserequestdisabled'] = 'Oprostite, ali administrator je onemogućio slanje zahteva za pokretanje novih kurseva.';
$string['csvcolumnduplicates'] = 'Otkrivene su duplikati kolona';
$string['csvemptyfile'] = 'CSV datoteka je prazna';
$string['csvfewcolumns'] = 'Nema dovoljno kolona, molimo proverite podešavanje znaka za razdvajanje';
$string['csvfileerror'] = 'Nešto nije u redu sa formatom CSV datoteke. Molimo vas da proverite da li se broj zaglavlja i kolona poklapa, kao i da li su znak za razdvajanje i kodni raspored datoteke ispravni. {$a}';
$string['csvinvalidcols'] = '<b>Neispravna CSV datoteka:</b> Prva linija mora da sadrži "Header Fields" a datoteeka mora da bude tipa <br />"Expanded Fields/Comma Separated"<br />ili<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Neispravna CSV datoteka - svaka linija mora da ima 49 ili 70 polja';
$string['csvloaderror'] = 'Došlo je do greške prilikom učitavanja CSV datoteke: {$a}';
$string['csvnodata'] = 'Neispravna CSV datoteka - CSV datoteka ima zaglavlja, ali ne sadrži nikakve podatke.';
$string['csvweirdcolumns'] = 'Neispravan format CSV datoteke - broj kolona nije svuda isti!';
$string['dbconnectionfailed'] = '<p>Greška: Konekcija sa bazom podataka nije uspela</p>
<p>Moguće je da je baza podataka preopterećena ili da na drugi način ne funkioniše kako treba.</p>
<p>Administrator sajta, takođe, treba da proveri da li su svi podaci vezani za bazu podataka ispravno navedeni u config.php datoteci</p>';
$string['dbdriverproblem'] = '<p>Greška: uočen je problem sa drajverom baze podataka</p>
<p>Administrator sajta bi trebalo da proveri konfiguraciju servera</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Uočen je ozbiljan problem sa sesijom baze podataka.<br /><br />Molimo, obavestite administratora servera.';
$string['dbsessionhandlerproblem'] = 'Podešavanje sessije baze podataka nije uspeleo. Molimo obavestite administratora servera.';
$string['dbsessionmysqlpacketsize'] = 'Otkrivene je ozbiljna greška sesije baze podataka. Molimo, obavestite administratora. Ovaj problem je najverovatnije izazvan malom vrednošću u MySQL podešavanju max_allowed_packet';
$string['dbupdatefailed'] = 'Ažuriranje baze podataka nije uspelo';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" nije moguće menjati. Otrkivena je zavisnost od  {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = '"DDL sql execution" greška';
$string['ddlfieldalreadyexists'] = 'Polje "{$a}" već postoji';
$string['ddlfieldnotexist'] = 'Polje "{$a->fieldname}" ne postoji u tabeli "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabela "{$a}" već postoji';
$string['ddltablenotexist'] = 'Tabela "{$a}" ne postoji';
$string['ddlunknownerror'] = 'Nepoznata DDL greška';
$string['ddlxmlfileerror'] = 'Pronađena je greška u datoteci XML baze podataka';
$string['ddsequenceerror'] = 'Definicija tabele "{$a}" je netačna; može postojati samo jedna auto-kolona, i ona mora biti definisana kao ključ.';
$string['destinationcmnotexit'] = 'Odredišni kurs ne postoji';
$string['detectedbrokenplugin'] = 'Dodatak "{$a}" je neispravan ili zastareo. Oprostite, ali nije moguće nastaviti.';
$string['dmlexceptiononinstall'] = '<p>Došlo je do greške u bazi podataka [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Greška prilikom parsiranja SQL upita';
$string['dmlreadexception'] = 'Greška prilikom čitanja iz baze podataka';
$string['dmltransactionexception'] = 'Transakciona greška baze podataka';
$string['dmlwriteexception'] = 'Greška prilikom upisvanja u bazu podataka';
$string['dndmaxbytes'] = 'Datoteka je prevelika. Maksimalna dozvoljena veličina je {$a->size}.';
$string['dndread'] = 'Greška pri čitanju datoteke';
$string['dndunkownfile'] = 'Ovaj tip datoteke nije podržan';
$string['dndupload'] = 'Došlo je do nepoznate greške prilikom otpremanja datoteke';
$string['downgradedcore'] = 'GREŠKA! Kôd koji koristite je STARIJI od verzije kojа je kreirala ovе bazе!';
$string['downloadedfilecheckfailed'] = 'Nije uspela provera preuzete datoteke';
$string['duplicatefieldname'] = 'Otkriven je duplikat naziva polja "{$a}"';
$string['duplicatenosupport'] = 'Aktivnost \'{$a->modname}\' ne može da bude duplirana zato što tip modula {$a->modtype} ne podržava kreiranje i restaurisanje rezervne kopije.';
$string['duplicateparaminsql'] = 'GREŠKA: dupli naziv parametra u upitu';
$string['duplicaterolename'] = 'Već postoji uloga sa ovim imenom!';
$string['duplicateroleshortname'] = 'Već postoji uloga sa ovim skraćenim nazivom!';
$string['duplicateusername'] = 'Duplikat korisničkog imena - zapis se preskače';
$string['editedpagenotfound'] = 'Sistem nije mogao da odredi stranicu na kojoj se nalazite. Osvežite stranicu i pokušajte ponovo.';
$string['emailfail'] = 'Slanje e-pošte nije uspelo';
$string['encryption_decryptfailed'] = 'Dešifrovanje nije uspelo';
$string['encryption_encryptfailed'] = 'Šifrovanje nije uspelo';
$string['encryption_invalidkey'] = 'Neispravan ključ';
$string['encryption_keyalreadyexists'] = 'Ključ već postoji';
$string['encryption_nokey'] = 'Ključ nije pronađen';
$string['encryption_wrongmethod'] = 'Podaci se ne podudaraju sa podržanim načinom šifrovanja';
$string['enddatebeforestartdate'] = 'Datum završetka kursa mora da bude nakon datuma početka kursa.';
$string['error'] = 'Došlo je do greške';
$string['error_question_answers_missing_in_db'] = 'Nije pronađen odgovor koji se poklapa sa "{$a->answer}" u tabeli question_answers u bazi podataka. Do toga je došlo prilikom restauriranja pitanja sa identifikatorom {$a->filequestionid} iz datoteke rezervne kopije, koje je upareno sa postojećim pitanjem sa identifikatorom {$a->dbquestionid} u bazi podataka.';
$string['errorcleaningdirectory'] = 'Greška pri čišćenju direktorijuma "{$a}"';
$string['errorcopyingfiles'] = 'Greška pri kopiranju datoteka';
$string['errorcreatingdirectory'] = 'Greška pri kreiranju direktorijuma "{$a}"';
$string['errorcreatingfile'] = 'Greška pri kreiranju datoteke "{$a}"';
$string['errorcreatingrole'] = 'Greška u kreiranju uloge';
$string['errorfetchingrssfeed'] = 'Greška prilikom preuzimanja RSS izvora vesti.';
$string['erroronline'] = 'Greška u liniji {$a}';
$string['erroroutput'] = 'Ispis greške, stoga je onemogućeno automatsko preusmeravanje.';
$string['errorparsingxml'] = 'Greška pri parsiranju XML-a: {$a->errorstring} u redu {$a->errorline}, na znaku {$a->errorchar}';
$string['errorprocessingarchive'] = 'Greška u obradi arhive';
$string['errorreadingfile'] = 'Greška prilikom čitanja datoteke "{$a}"';
$string['errorsavingrequest'] = 'Došlo je do greške priliko pokušaja da sačuvate svoj zahtev.';
$string['errorsettinguserpref'] = 'Greška u podešavanju korisnikovih preferenci';
$string['errorunzippingfiles'] = 'Greška pri raspakivanju datoteka';
$string['expiredkey'] = 'Ključ je istekao';
$string['externalauthpassworderror'] = 'Lozinka za spoljnu proveru identiteta nije prazan niz';
$string['externalfilenolocation'] = 'Spoljašnja datoteka nema putanju';
$string['failtoloadblocks'] = 'Jedan ili više blokova je registrovano u bazzi podataka, ali nisu uspeli da se učitaju!';
$string['fieldrequired'] = '"{$a}" je obavezno polje';
$string['fileexists'] = 'Datoteka već postoji';
$string['filemismatch'] = 'Neslaganje naziva datoteke (koja nije ključna).  Datoteka "{$a->current}" treba da bude {$a->file}';
$string['filenotfound'] = 'Nažalost traženi dokument nije bilo moguće pronaći';
$string['filenotreadable'] = 'Datoteka nije čitljiva';
$string['filterdoesnothavelocalconfig'] = 'Filter {$a} ne dopušta lokalnu konfiguraciju.';
$string['filternotactive'] = 'Filter {$a} trenutno nije aktivan';
$string['filternotenabled'] = 'Filter nije omogućen!';
$string['filternotinstalled'] = 'Filter {$a} trenutno nije instaliran';
$string['forumblockingtoomanyposts'] = 'Prekoračili ste ograničenje za broj poslatih poruka na ovom forumu';
$string['functionalityremoved'] = 'Pokušavate da pristupite funkcionalnosti koja je uklonjena.';
$string['generalexceptionmessage'] = 'Izuzetak (greška) - {$a}';
$string['gradecantregrade'] = 'Došlo je do greške prilikom izračunavanja ocene: {$a}';
$string['gradepubdisable'] = 'Objavljivanje ocena je onemogućeno';
$string['gradesneedregrading'] = 'Neophodno je ponovo izračunati ocene kursa';
$string['groupalready'] = 'Korisnik već pripada grupi {$a}';
$string['groupexistforcourse'] = 'Grupa "{$a}" već postoji u ovom kursu';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Grupa "{$a->name}" sa id brojem "{$a->idnumber}" već postoji na ovom kursu.';
$string['grouphasidnumber'] = 'Grupa "{$a}" ima id broj i možda je automatski kreorana od strane eksternog sistema. Nemate ovlašćenje da uklonite ovu grupu..';
$string['groupinghasidnumber'] = 'Grupisanje "{$a}" ima id broj i možda je automatski kreirano od strane eksternog sistema. Nemate ovlašćenje da uklonite ovo grupisanje..';
$string['groupingnotaddederror'] = 'Grupisanje "{$a}" nije dodato';
$string['groupnotaddederror'] = 'Grupa "{$a}" nije dodata';
$string['groupnotaddedtogroupingerror'] = 'Grupisanje "{$a}" nije dodato';
$string['groupunknown'] = 'Grupa {$a} ne pripada datom kursu';
$string['groupusernotmember'] = 'Korisnik nije član ove grupe';
$string['guestcantaccessprofiles'] = 'Gosti ne mogu da pristupe korisničkim profilima. Ulogujte se sa pravim korisničkim nalogom da biste nastavili rad.';
$string['guestnocomment'] = 'Gostima nije dozvoljeno da postuju komentare';
$string['guestnoeditprofile'] = 'Gost ne može da uređuje svoj profil';
$string['guestnoeditprofileother'] = 'Korisnički profil gosta se ne može uređivati';
$string['guestnorate'] = 'Gostima nije dozvoljeno da ocenjuju pojmove';
$string['guestsarenotallowed'] = 'Korisniku sa nalogom gosta nije dozvoljeno da uradi';
$string['hackdetected'] = 'Otkriven je hakerski napad!';
$string['hashpoolproblem'] = 'Neispravan sadržaj skupa datoteke $a}.';
$string['headersent'] = 'Zaglavlja su već poslata';
$string['idnumbertaken'] = 'Ovaj ID broj se već koristi';
$string['idnumbertoolong'] = 'ID broj je predugačak';
$string['importformatnotimplement'] = 'Oprostite, ali uvoz ovog formata još nije implementiran!';
$string['incorrectext'] = 'Datoteka ima neispravnu ekstenziju';
$string['inplaceeditableerror'] = 'Greška pri pozivu procesora ažuriranja';
$string['installproblem'] = 'Obično nije moguće ispraviti greške koje nastanu tokom instalacije. Možda ćete morati da kreirate novu bazu podataka, ili da upotrebite neki drugi prefiks baze podataka ako želite da ponovite instalaciju.';
$string['internalauthpassworderror'] = 'Lozinka nedostaje ili su neispravna pravila za kreiranje lozinke za internu proveru identiteta';
$string['invalidaccess'] = 'Neispravan pristup ovoj stranici';
$string['invalidaccessparameter'] = 'Neispravan parameter pristupa';
$string['invalidaction'] = 'Neispravan parameter akcije';
$string['invalidactivityid'] = 'Neispravan ID aktivnosti';
$string['invalidadminsettingname'] = 'Neispravno admin podešavanje ({$a})';
$string['invalidargorconf'] = 'Nisu prosleđeni ispravni argumenti ili je konfiguracija servera neispravna';
$string['invalidarguments'] = 'Nisu prosleđeni ispravni argumenti';
$string['invalidblockinstance'] = 'Neispravna instanca bloka ѕa {$a}';
$string['invalidbulkenrolop'] = 'Zatražena je neispravna operacija za masovni upis';
$string['invalidcategory'] = 'Pogrešna kategorija';
$string['invalidcategoryid'] = 'Neispravna ID oznaka kategorije!';
$string['invalidcomment'] = 'Komentar je neispravan';
$string['invalidcommentarea'] = 'Neispravnо područje za komentar';
$string['invalidcommentid'] = 'Neispravna ID oznaka komentara';
$string['invalidcommentitemid'] = 'Neispravna ID oznaka stavke komentara';
$string['invalidcommentparam'] = 'Neispravni parametri komentara';
$string['invalidcomponent'] = 'Neispravan naziv komponente';
$string['invalidconfirmdata'] = 'Neispravni podaci za potvrdu';
$string['invalidcontentid'] = 'Neispravna ID oznaka sadržaja';
$string['invalidcontext'] = 'Neispravan kontekst';
$string['invalidcountrycode'] = 'Neispravan kôd države: {$a}';
$string['invalidcourse'] = 'Neispravan kurs';
$string['invalidcourseformat'] = 'Format kursa nije validan';
$string['invalidcourseid'] = 'Pokušavate da koristite neispravan ID kursa';
$string['invalidcourselevel'] = 'Pogrešan nivo konteksta';
$string['invalidcoursemodule'] = 'Neispravan ID modula kursa';
$string['invalidcoursemoduleid'] = 'Neispravna ID oznaka modula kursa: {$a}';
$string['invalidcoursenameshort'] = 'Neispravan kratak naziv kursa';
$string['invaliddata'] = 'Prosleđeni podaci su neispravni';
$string['invaliddatarootpermissions'] = 'Otkrivena su neispravna ovlašćenja pri pokušaju kreiranja direktorijuma. Uključite mod za otkrivanje grešaka za više detalja.';
$string['invaliddevicetype'] = 'Neispravan tip uređaja';
$string['invalidelementid'] = 'Neispravna ID oznaka elementa';
$string['invalidentry'] = 'Ovo nije ispravan unos';
$string['invalidevent'] = 'Neispravan događaj';
$string['invalidfieldname'] = '"{$a}" nije ispravno ime polja';
$string['invalidfiletype'] = '"{$a}" nije ispravan tip datoteke';
$string['invalidformatpara'] = 'Pogrešan format za parametar izbora';
$string['invalidformdata'] = 'Neispravni podaci u obrascu';
$string['invalidfunction'] = 'Neispravna funkcija';
$string['invalidgradeitemid'] = 'Neispravna ID oznaka stavke ocene';
$string['invalidgroupid'] = 'Navedena je neispravna ID oznaka grupe';
$string['invalidipformat'] = 'Neispravan format IP adrese';
$string['invaliditemid'] = 'Neispravna ID oznaka stavke';
$string['invalidkey'] = 'Neispravan ključ';
$string['invalidlanguagecode'] = 'Neispravan jezički kôd: {$a}';
$string['invalidlegacy'] = 'Neispravna definicija nasleđene uloge za tip: {$a}';
$string['invalidmd5'] = 'Neispravna md5 datoteka';
$string['invalidmode'] = 'Neispravan mod ({$a})';
$string['invalidmodule'] = 'Neispravan modul';
$string['invalidmoduleid'] = 'Neispravna ID oznaka modula: {$a}';
$string['invalidmodulename'] = 'Neispravan naziv modula: {$a}';
$string['invalidnum'] = 'Neispravna numerička vrednost';
$string['invalidnumkey'] = 'Polje $conditions ne može da sadrži numeričke ključeve. Popravite kôd!';
$string['invalidoutcome'] = 'Neispravna ID oznaka ishoda';
$string['invalidpagesize'] = 'Neispravna veličina stranice';
$string['invalidpasswordpolicy'] = 'Neispravna pravila za kreiranje lozinke';
$string['invalidpaymentmethod'] = 'Neispravan način plaćanja {$a}';
$string['invalidpersistenterror'] = 'Greška: {$a}';
$string['invalidqueryparam'] = 'GREŠKA: Pogrešan broj parametara upita. Očekivano {$a->expected}, a dobijeno {$a->actual}.';
$string['invalidratingarea'] = 'Neispravno područje za ocenjivanje';
$string['invalidrecord'] = 'Nije moguće pronaći podatke u tabeli baze {$a}.';
$string['invalidrecordunknown'] = 'Nije moguće pronaći podatke u bazi podataka';
$string['invalidrequest'] = 'Neispravan zahtev';
$string['invalidrole'] = 'Neispravna uloga';
$string['invalidroleid'] = 'Neispravan ID uloge';
$string['invalidscaleid'] = 'Neispravna ID oznaka skale';
$string['invalidsection'] = 'Zapis modula kursa sadrži neispravnu sekciju';
$string['invalidsesskey'] = 'Vaša sesija je najverovatnije istekla. Prijavite se ponovo.';
$string['invalidshortname'] = 'Neispravan skraćeni naziv kursa';
$string['invalidsourcefield'] = 'Polje izvora radne verzije datoteke je neispravno';
$string['invalidstatedetected'] = 'Nešto je krenulo naopako: {$a}. Normalno, ovo ne bi trebalo da se događa.';
$string['invalidurl'] = 'Neispravan url';
$string['invaliduser'] = 'Neispravan korisnik';
$string['invaliduserdata'] = 'Neispravni korisnički podaci: {$a}';
$string['invaliduserfield'] = 'Neispravno korisničko polje: {$a}';
$string['invaliduserid'] = 'Neispravna ID oznaka korisnika';
$string['invalidusername'] = 'Dato korisničko ime sadrži neispravne znakove';
$string['invalidusernameblank'] = 'Polje za korisničko ime ne može biti prazno';
$string['invalidxmlfile'] = '"{$a}" nije ispravna XML datoteka';
$string['iplookupfailed'] = 'Nije moguće pronaći geografske podatke o ovoj IP adresi {$a}.';
$string['iplookupprivate'] = 'Nije moguće prikazati pretragu privatne IP adrese';
$string['ipmismatch'] = 'Klijentska IP adresa se ne poklapa';
$string['listcantmovedown'] = 'Pomeranje stavke nadole nije uspelo, pošto je to poslednja stavka u nizu.';
$string['listcantmoveleft'] = 'Pomeranje stavke ulevo nije uspelo, pošto ona nema nadređenu stavku';
$string['listcantmoveright'] = 'Pomeranje stavke udesno nije uspelo, pošto nema stavke koja bi joj bila nadređena. Pomerite je ispod druge stavke, i onda je možete pomeriti udesno.';
$string['listcantmoveup'] = 'Pomeranje stavke nagore nije uspelo, pošto je to prva stavka u nizu.';
$string['listnochildren'] = 'Nema podređenih stavki';
$string['listnoitem'] = 'Stavka nije pronađena';
$string['listnopeers'] = 'Nisu pronađene srodne stavke';
$string['listupdatefail'] = 'Operacija nad bazom nije uspela pri uređivanju hijerarhije liste';
$string['logfilenotavailable'] = 'Zapisi nisu dostupni';
$string['loginasnoenrol'] = 'Ne možete se upisivati ili ispisivati sa kursa dok traje sesija "Prijavi se kao"';
$string['loginasonecourse'] = 'Ne možete da pristupite ovom kursu.<br /> Morate prvo da završite sesiju "Prijavi se kao", pre ulaska na bilo koji drugi kurs.';
$string['maxareabytes'] = 'Nemate dovoljno prostora da biste sačuvali ovu datoteku.';
$string['maxbytesfile'] = 'Datoteka {$a->file} je prevelika. Maksimalna veličina datoteke koju možete postaviti je {$a->size}.';
$string['maxdraftitemids'] = 'Postavljanje vaših datoteka je privremeno ograničeno nakon što se postavili veliki broj datoteka. Molimo sačekajte, pa pokušajte ponovo.';
$string['messageundeliveredbynotificationsettings'] = 'Poruka nije mogla da se pošalje jer je administrator sajta onemogućio lične poruke između korisnika (u \'Podešavanja za slanje obaveštenja\').';
$string['messagingdisable'] = 'Slanje poruka na ovom sajtu nije omogućeno';
$string['mimetexisnotexist'] = 'Vaš sistem nije konfigurisan kako bi mogao da pokrene mimeTeX. Morate da pribavite C izvorni kôd sa <a href="https://www.forkosh.com/mimetex.zip">http://www.forkosh.com/mimetex.zip</a>,  da ga kompajlirate i postavite izvršnu datoteku u vaš moodle/filter/tex/ direktorijum.';
$string['mimetexnotexecutable'] = 'Prilagođeni mimetex nije moguće pokrenuti!';
$string['missing_moodle_backup_xml_file'] = 'Rezervnoj kopiji podataka nedostaje XML datoteka: {$a}';
$string['missingcategoryrole'] = 'Nije moguće dodeliti ulogu korisniku: nedostaje uloga za kategoriju.';
$string['missingfield'] = 'Polje "{$a}" nedostaje';
$string['missingkeyinsql'] = 'Greška: nedostaje parametar "{$a}" u upitu';
$string['missingparam'] = 'Nedostaje neophodni parametar ({$a})';
$string['missingparameter'] = 'Nedostaje parametar';
$string['missingrequiredfield'] = 'Nedostaje neko obavezno polje';
$string['missinguseranditemid'] = 'Nedostaje userid i itemid';
$string['missingvarname'] = 'Nedostaje ime neophodne varijable';
$string['mixedtypesqlparam'] = 'GREŠKA: Izmešani tipovi sql parametara upita!!!';
$string['mnetdisable'] = 'MNET je isključen';
$string['mnetlocal'] = 'Udaljeni MNET korisnici ne mogu da se prijave lokalno';
$string['moduledisable'] = 'Ovaj modul ({$a}) je onemogućen za ovaj konkretan kurs';
$string['moduledoesnotexist'] = 'Ovaj modul ne postoji';
$string['moduleinstancedoesnotexist'] = 'Instanca ovog modula ne postoji';
$string['modulemissingcode'] = 'Modulu {$a} nedostaje kôd potreban za izvođenje ove funkcije';
$string['moodlenet:invalidshareformat'] = 'Neispravan MoodleNet format za deljenje';
$string['moodlenet:usernotconfigured'] = 'Nemate dozvolu da delite sadržaj na MoodleNet platformi ili je vaš nalog pogrešno konfigurisan.';
$string['movecatcontentstoroot'] = 'Premeštanje sadržaja kategorije u osnovni direktorijum nije dozvoljeno. Morate da premestite sadržaje u postojeću kategoriju!';
$string['movecatcontentstoselected'] = 'Neki od sadržaja kategorije ne mogu se premestiti u izabranu kategoriju.';
$string['movecategorynotpossible'] = 'Ne možete da premestite kategoriju  \'{$a}\' u izabranu kategoriju.';
$string['movecategoryownparent'] = 'Ne možete postaviti da kategorija  \'{$a}\' bude sama sebi nadređena';
$string['movecategoryparentconflict'] = 'Ne možete postaviti da kategorija \'{$a}\' bude potkategorija jedne od njenih potkategorija.';
$string['mssqlrcsmodemissing'] = 'Baza ne koristi očekivani READ_COMMITTED_SNAPSHOT režim rada usled čega može doći do pogrešnih rezultata, posebno pri scenarijima sa visokom paralelizacijom. Molimo omogućite navedeni režim da bi se baza korektno ponašala. Više informacija o ovome možete naći u okviru <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">dokumentacije</a>.';
$string['multiplerecordsfound'] = 'Pronađeni su višestruki zapisi, a očekivan je samo jedan zapis.';
$string['multiplerestorenotallow'] = 'Nije dozvoljeno istovremenо pokretanje više procedura restаuracije podataka!';
$string['mustbeloggedin'] = 'Morate biti prijavljeni na sistem kako biste ovo uradili';
$string['mustbeteacher'] = 'Morate biti predavač da biste videli ovu stranicu';
$string['myisamproblem'] = 'Tabele u bazi podataka koriste MyISAM sistem, Preporučuje se upotreba ACID kompatibilnog sistema sa punom podrškom za transakcije, poput InnoDB.';
$string['needcopy'] = 'Prvo morate nešto da kopirate!';
$string['needcoursecategroyid'] = 'Mora biti naveden ili identifikator kursa ili kategorija';
$string['needphpext'] = 'Potrebno je da dodate {$a} podršku vašoj PHP instalaciji';
$string['noadmins'] = 'Nema administratora!';
$string['noblocks'] = 'Nijedan blok nije pronađen!';
$string['nocapabilitytousethisservice'] = 'Korisnik nema potrebne sposobnosti za korišćenje ovog servisa';
$string['nocategorydelete'] = 'Kategorija \'{$a}\' se ne može obrisati!';
$string['nocontext'] = 'Žao nam je, ali taj kurs nije validan kontekst';
$string['nodata'] = 'Nema podataka';
$string['noexistingcategory'] = 'Nema kategorije';
$string['nofile'] = 'Datoteka nije navedena';
$string['nofiltersenabled'] = 'Nijedan filter nije omogućen';
$string['nofolder'] = 'Traženi direktorijum ne postoji';
$string['noformdesc'] = 'Za ovu aktivnost nije pronađena formslib datoteka sa opisom obrasca.';
$string['noguest'] = 'Ovde nema gostiju!';
$string['noinstances'] = 'Nema instanci {$a} u ovom kursu!';
$string['nologinas'] = 'Nije vam dozvoljeno da se prijavite kao taj korisnik';
$string['nonmeaningfulcontent'] = 'Besmislen sadržaj';
$string['noparticipants'] = 'Nije pronađen ni jedan učesnik na ovom kursu';
$string['noparticipatorycms'] = 'Nažalost, nemate module kursa sa učesnicima za koje bi se mogao kreirati izveštaj';
$string['nopermissions'] = 'Žao nam je, ali trenutno nemate ovlašćenja da to radite ({$a}).';
$string['nopermissiontoaccesspage'] = 'Nemate dozvolu da pristupite ovoj stranici.';
$string['nopermissiontocomment'] = 'Ne možete da dodate komentar u ovaj rečnik!';
$string['nopermissiontodelentry'] = 'Ne možete da obrišete ovaj komentar!';
$string['nopermissiontoeditcomment'] = 'Ne možete da uređujete komentare drugih korisnika!';
$string['nopermissiontohide'] = 'Nemate ovlašćenja za sakrivanje!';
$string['nopermissiontoimportact'] = 'Nemate neophodna ovlašćenja da biste uvezli aktivnosti u ovaj kurs';
$string['nopermissiontolock'] = 'Nemate ovlašćenja za zaključavanje!';
$string['nopermissiontomanagegroup'] = 'Nemate neophodna ovlašćenja da biste upravljali grupama';
$string['nopermissiontorate'] = 'Ocenjivanje stavki nije dozvoljeno';
$string['nopermissiontoshow'] = 'Nemate ovlašćenja da vidite ovo!';
$string['nopermissiontounlock'] = 'Nemate ovlašćenja za otključavanje!';
$string['nopermissiontoupdatecalendar'] = 'Žao nam je, ali nemate ovlašćenja da ažurirate događaje u kalendaru.';
$string['nopermissiontoviewcalendar'] = 'Žao nam je, ali nemate dozvolu da vidite događaj u kalendaru.';
$string['nopermissiontoviewgrades'] = 'Ne mogu da vide ocene';
$string['nopermissiontoviewletergrade'] = 'Nedostaje ovlašćenje da bi se videle slovne ocene';
$string['nopermissiontoviewpage'] = 'Nije Vam dozvoljeno da gledate ovu stranicu';
$string['nosite'] = 'Nije moguće pronaći kurs najvišeg nivoa!';
$string['nositeid'] = 'Ne postoji ID sajta';
$string['nostartdatenoenddate'] = 'Datum završetka kursa se može odraditi samo ukoliko je unet i datum početka kursa.';
$string['nostatstodisplay'] = 'Izvinite, nema raspoloživih podataka za prikaz';
$string['notallowedtoupdateprefremotely'] = 'Nemate dozvolu da ažurirate preference ovog korisnika udaljeno';
$string['notavailable'] = 'Trenutno nije na raspolaganju.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Niste član ove grupe';
$string['notownerofkey'] = 'Niste vlasnik ovg ključa';
$string['nousers'] = 'Ne postoji takav korisnik';
$string['oauth1accesstoken'] = 'OAuth 1.0 greška: nismo dobili token za pristup.';
$string['oauth1requesttoken'] = 'OAuth 1.0 greška: nismo dobili token za zahtev - moguće je da je davalac usluga privremeno nedostupan.';
$string['oauth2refreshtokenerror'] = 'Nije moguće osvežiti  OAuth 2 token. HTTP status za udaljenu krajnju tačku: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Nije moguće osvežiti OAuth 2 token za jednog ili više davaoca identiteta. Pogledajte izlazne podatke zadatka za više informacija.';
$string['oauth2upgradetokenerror'] = 'Nije moguće osvežiti  OAuth 2 token. HTTP status za udaljenu krajnju tačku: {$a}';
$string['onlyadmins'] = 'Samo administratori mogu to da rade';
$string['onlyeditingteachers'] = 'Samo predavači sa uređivačkim privilegijama mogu to da rade';
$string['onlyeditown'] = 'Možete menjati samo lične podatke';
$string['opensslsealerror'] = 'OpenSSL ne može da zapečati podatke';
$string['opensslsignerror'] = 'OpenSSL ne može da potpiše podatke';
$string['orderidnotfound'] = 'Identifikator narudžbe {$a} nije pronađen';
$string['pagenotexist'] = '<p>Došlo je do neuobičajene greške prilikom pokušaja pristupa stranici koja ne postoji:</p>{$a}';
$string['pagenotexisttitle'] = '404 Greška: datoteka nije pronađena';
$string['pathdoesnotstartslash'] = 'Nisu prosleđeni ispravni argumenti; putanja ne počinje sa kosom crtom (/)!';
$string['pleasereport'] = 'Ako imate vremena, obavestite nas šta ste pokušali da uradite kada je došlo do greške:';
$string['pluginrequirementsnotmet'] = 'Dodatak "{$a->pluginname}" ({$a->pluginversion}) nije mogao biti instaliran. On zahteva noviju verziju Moodle sistema (Vi trenutno koristite {$a->currentmoodle}, a potrebna Vam je verzija {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Dodatak "{$a->pluginname}" {$a->pluginversion} ne podržava ovu verziju Moodlea {$a->moodleversion}. Potražite informacije o dodatku kako biste pronašli verzije koje su podržane.';
$string['prefixcannotbeempty'] = '<p>Greška: prefiks tabela baze podataka ne može biti prazan ({$a})</p>
<p>Administrator sajta mora da reši ovaj problem.</p>';
$string['prefixtoolong'] = '<p>Greška: prefiks tabele baze podataka je predug ({$a->dbfamily})</p>
<p>Administrator sajta mora da reši ovaj problem. Maksimalna dužina prefiksa tabela u {$a->dbfamily} je {$a->maxlength} znak(ov)a.</p>';
$string['privatefilesupload'] = 'Postavljanje datoteka u korisnički privatni prostor za datoteke više nije podržano. Postavite datoteku u prostor za radne verzije datoteka a zatim ih premestite sa core_user::add_user_private_files';
$string['processingstops'] = 'Obrada se ovde zaustavlja. Preostali zapisi biće ignorisani.';
$string['protected_cc_not_supported'] = 'Zaštićeni kertridži nisu podržani.';
$string['querystringcannotbeempty'] = 'String upita ne može biti prazan';
$string['redirecterrordetected'] = 'Otkriveno je preusmeravanje koje nije podržano, pa je izvršenje skripte okončano.';
$string['refoundto'] = 'Može biti refundirano na iznos od {$a}';
$string['refoundtoorigi'] = 'Refundirano na originala iznos od: {$a}';
$string['registrationdisabled'] = 'Registracija je onemogućena na ovom sajtu';
$string['remotedownloaderror'] = '<p>Preuzimanje ove komponente na vaš server nije uspelo. Proverite podešavanja proksi servera. PHP cURL ekstenzija se preporučuje.</p>
<p>Morate da preuzmete <a href="{$a->url}">{$a->url}</a> datoteku ručno, kopirate je u direktorijum "{$a->dest}" na svom serveru i tamo je raspakujete.</p>';
$string['remotedownloadnotallowed'] = 'Nije dozvoljeno preuzimanje komponenti na Vaš server (opcija allow_url_fopen je onemogućena).<br /><br />Morate ručno preuzeti datoteku <a href="{$a->url}">{$a->url}</a>, kopirati je u "{$a->dest}" na svom serveru i tamo je raspakovati.';
$string['reportnotavailable'] = 'Ova vrsta izveštaj je jedino dostupna za sajt.';
$string['requirecorrectaccess'] = 'Neispravna url adresa ili port';
$string['requireloginerror'] = 'Kurs ili aktivnost nisu dostupni.';
$string['restore_path_element_missingmethod'] = 'Nedostaje metod za restauraciju {$a}. Metod mora biti definisan od strane programera.';
$string['restore_path_element_noobject'] = 'Objekat za restauraciju {$a} nije objekat.';
$string['restorechecksumfailed'] = 'Dogodio se problem sa podacima za restauraciju koji su smešteni u Vašoj sesiji. Molimo proverite Vaša ograničenja PHP memorije/veličine DB paketa. Proces resturacije je zaustavljen.';
$string['restrictedcontextexception'] = 'Nažalost, izvršenje spoljašnje funkcije krši restrikciju konteksta.';
$string['restricteduser'] = 'Žao nam je, ali vaš tekući nalog "{$a}" je ograničen i ne možete uraditi ovu akciju';
$string['reverseproxyabused'] = 'Uključen je reverzni proksi tako da nije moguće direktno pristupiti serveru. <br />Kontaktirajte server administratora.';
$string['rpcerror'] = 'Ups! Vaša MNET komunikacija nije uspela! Ovde je poruka o grešci koju treba proslediti administratoru: {$a}';
$string['scheduledbackupsdisabled'] = 'Administrator servera je onemogućio kreiranje planiranih rezervnih kopija';
$string['secretalreadyused'] = 'Link za potvrdu promene lozinke je već iskorišćen. Lozinka nije promenjena';
$string['sectionnotexist'] = 'Ova sekcija ne postoji';
$string['sendmessage'] = 'Pošalji poruku';
$string['sendmessagesent'] = 'Hvala na povratnim informacijama o:<br>{$a}';
$string['serverconnection'] = 'Greška u povezivanju sa serverom';
$string['servicedonotexist'] = 'Usluga ne postoji';
$string['sessioncannotobtainlock'] = '<p>Nije moguće dobiti zaključavanje za sesiju sa ID oznakom {$a->id} unutar {$a->acquiretimeout}.</p>
<p>Verovatno je druga stranica ({$a->whohaslock}) još uvek aktivna u drugoj kartici veb čitača, ili nije došlo do otključavanje usled greške.</p>
<p>Možete sačekati da istekne vreme zaključavanja sesije ({$a->lockexpire}) ili možete da ponovo pokrenete sesiju vašeg veb čitača. Ako se ova greška ponavlja, molimo vas da obavestite administratora servera.</p>';
$string['sessioncookiesdisable'] = 'Nepravilna upotreba require_key_login() - kolačići sesije moraju biti onemogućeni!';
$string['sessiondiskfull'] = 'Particija za čuvanje sesija je puna. Prijava na sistem trenutno nije moguća. Molimo vas da obavestite administratora servera.';
$string['sessionerroruser'] = 'Vaša sesija je istekla. Molimo vas da se prijavite ponovo.';
$string['sessionerroruser2'] = 'Došlo je do greške koja utiče na vašu tekuću sesiju. Molimo vas da prijavite se na sistem ponovo ili ponovo pokrenite svoj veb čitač.';
$string['sessionexpired'] = 'Sesija je istekla';
$string['sessionhandlerproblem'] = 'Procedura za obradu sesije je pogrešno podešena';
$string['sessionipnomatch'] = 'Nažalost, ali izgleda da se Vaš IP broj promenio od kada ste se prijavili na sistem. Ova sigurnosna opcija sprečava krakere da ukradu Vaš indentitet dok ste prijavljeni na ovaj sajt. Normalni korisnici ne bi trebalo da vide ovu poruku - molimo Vas da tražite pomoć od administratora sajta.';
$string['sessionipnomatch2'] = '<p>Oprostite, ali izgleda da se, od trenutka kada ste se prvi put prijavili na sistem, promenila vaša IP adresa. Ova bezbednosna funkcija sprečava zlonamerne korisnike od krađe vašeg identiteta dok ste prijavljeni na ovom sajtu. Ovu grešku možete videti ukoliko koristite bežični pristup internetu. Molimo vas da kontaktirate administratora za pomoć.</p>
<p>Ukoliko želite da nastavite molimo vas pritisnite taster F5 kako biste osvežili ovu stranicu.</p>';
$string['sessionwaiterr'] = 'Vreme je isteklo dok ste čekali zaključavanje sesije.<br /> Sačekajte da se vaši trenutni zahtevi završe i pokušajte ponovo kasnije.';
$string['shortnametaken'] = 'Skraćeni naziv se već koristi za drugi kurs ({$a})';
$string['sitepolicynotagreed'] = 'Niste se saglasili sa pravilnikom o korišćenju sajta: <a href="{$a}">Kliknite ovde da biste otvorili pravilnik.</a>';
$string['socksnotsupported'] = 'SOCKS5 proksi nije podržan u PHP4';
$string['spellcheckernotconf'] = 'Provera pravopisa nije konfigurisana';
$string['sslonlyaccess'] = 'Iz razloga bezbednosti dozvoljene su samo https konekcije.';
$string['statscatchupmode'] = 'Statistika je trenutno u režimu nadoknađivanja zaostalih, još neobrađenih podataka. Do sada je obrađeno {$a->daysdone} dan/a, a još {$a->dayspending} dan/a čeka na obradu. Vratite se nešto kasnije!';
$string['statsdisable'] = 'Statistika nije omogućena';
$string['statsnodata'] = 'Nema dostupnih podataka za tu kombinaciju kursa i vremenskog perioda.';
$string['storedfilecannotcreatefile'] = 'Nije moguće kreirati datoteku lokalnog skupa datoteka. Molimo proverite ovlašćenja za direktorijum sa podacima i raspoloživ prostor na disku.';
$string['storedfilecannotcreatefiledirs'] = 'Nije moguće kreirati direktorijume lokalnog skupa datoteka. Molimo proverite ovlašćenja za direktorijum sa podacima.';
$string['storedfilecannotread'] = 'Nije moguće pročitati datoteku. Ili datoteka ne postoji ili postoji problem sa ovlašćenjima.';
$string['storedfilecannotreadfile'] = 'Nije moguće učitati datoteku \'{$a}\'. Datoteka ili ne postoji ili postoji problem sa ovlašćenjem za pristup datoteci.';
$string['storedfilenotcreated'] = 'Nije moguće kreirati datoteku  {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Nepoznati izuzetak (greška) u vezi sa lokalnim datotekama ({$a})';
$string['tagdisabled'] = 'Oznake su onemogućene';
$string['tagnotfound'] = 'Navedena oznaka (tag) nije pronađena u bazi podataka';
$string['targetdatabasenotempty'] = 'Odredišna baza podataka nije prazna. Transfer je poništen iz razloga bezbednosti';
$string['textconditionsnotallowed'] = 'Poređenja uslova za tekstualne kolоne nisu dozvoljena. Molimo da u upitu koristite sql_compare_text().';
$string['themenotinstall'] = 'Ova šema izgleda nije instalirana';
$string['tokengenerationfailed'] = 'Nije moguće generisati novi token.';
$string['transactionvoid'] = 'Transakcija se ne može poništiti, pošto je već poništena.';
$string['unenrolerror'] = 'Došlo je do greške prilikom pokušaja ispisivanja te osobe';
$string['unicodeupgradeerror'] = 'Žao nam je, ali Vaša baza podataka nije u Unicode formatu, a ova vezija Moodlea ne može da je prebaci u Unicode bazu podataka. Molimo prvo uradite nadogradnju sistema do Moodle 1.7.x verzije i uradite Unicode migraciju sa administratorske stranice. Nakon što to uradite moći ćete da pređete na Moodle {$a}';
$string['unknowaction'] = 'Nepoznata akcija!';
$string['unknowcategory'] = 'Kategorija nije poznata!';
$string['unknowcontext'] = 'Ovo je nepoznati kontekst({$a}) u get_child_contexts!';
$string['unknowformat'] = 'Format nije poznat ({$a})';
$string['unknownbackupexporterror'] = 'Nepoznata greška u toku pripreme podataka za uvoz';
$string['unknownblockregion'] = 'Područje bloka \'{$a}\' nije prepoznato na ovoj stranici.';
$string['unknowncategory'] = 'Nepoznata kategorija sa ID brojem kategorije "{$a}"';
$string['unknowncontext'] = 'Ovo je nepoznat kontekst';
$string['unknowncourse'] = 'Ne postoji kurs pod nazivom "{$a}"';
$string['unknowncourseidnumber'] = 'Nepoznati ID kursa  "{$a}"';
$string['unknowncourserequest'] = 'Nepoznat zahtev za pokretanje novog kursa';
$string['unknowncoursesection'] = 'Nepoznata sekcija na kursu "{$a}"';
$string['unknownevent'] = 'Nepoznati događaj';
$string['unknownfiletype'] = 'Greška! Nepoznati tip filtera';
$string['unknowngroup'] = 'Nepoznata grupa "{$a}"';
$string['unknownhelp'] = 'Nepoznata tema pomoći {$a}';
$string['unknownjsinrequirejs'] = 'Nije moguće naći JavaScript biblioteku {$a}';
$string['unknownmodulename'] = 'Nepoznati naziv modula za obrazac';
$string['unknownrole'] = 'Nepoznata uloga "{$a}"';
$string['unknownsortcolumn'] = 'Nepoznata kolumna za sortiranje {$a}';
$string['unknownuseraction'] = 'Žao nam je, ali sistem nije razumeo ovu akciju korisnika';
$string['unknownuserselector'] = 'Nepoznata opcija za izbor korisnika';
$string['unknoworder'] = 'Nepoznati redosled';
$string['unknowparamtype'] = 'Nepoznati tip parametra {$a}';
$string['unknowquestiontype'] = 'Nepodržani tip pitanja {$a}';
$string['unknowuploadaction'] = 'Greška: nepoznata akcija za postavljanje datoteke na server ({$a})';
$string['unspecifycourseid'] = 'Morate navesti ID oznaku kursa, skraćeni naziv ili ID broj';
$string['unsupportedevent'] = 'Nepodržani tip događaja';
$string['unsupportedstate'] = 'Nepodržani status završenosti';
$string['unsupportedwebserver'] = 'Oprostite, softver za Web server ({$a}) nije podržan';
$string['upgraderequires19'] = 'Greška: Nova verzija Moodlea je instalirana na server, Na žalost,  ažuriranje sa prethodne verzije nije podržano.<br />MOlimo Vas da prvo ažurirate Moodle na poslednju 1.9.x verziju. Na prethodnu verziju se, takođe, možete bratiti tako što ćete ponovo instalirati originalne datoeke.';
$string['upgraderunning'] = 'Sajt se ažurira, molimo pokušajte kasnije';
$string['urlnotdefinerss'] = 'Nije defisana URL adresa za RSS izvor vesti';
$string['useradmineditadmin'] = 'Samo je administratorima dozvoljeno da menjaju druge administratorske naloge';
$string['useradminodelete'] = 'Administratorski nalozi ne mogu biti obrisani.';
$string['userautherror'] = 'Nepoznat dodatak za proveru identiteta';
$string['userauthunsupported'] = 'Dodatak za proveru identiteta ovde nije podržan';
$string['useremailduplicate'] = 'Duplikat adrese';
$string['userisfilteredout'] = 'Ovaj korisnik ne odgovara filterima i podešavanjima tabele!';
$string['usermustbemnet'] = 'Korisnici na MNET kontrolnoj listi pristupa mora biti udaljeni MNET korisnik';
$string['usernamelowercase'] = 'Korisničko ime mora biti malim slovima';
$string['usernotaddederror'] = 'Korisnik nije dodat - greška';
$string['usernotaddedregistered'] = 'Korisnik nije dodat - već je registrovan';
$string['usernotaddedusernameexists'] = 'Korisnik nije dodat - korisničko ime već postoji pod drugom adresom e-pošte';
$string['usernotavailable'] = 'Detaljnije informacije o ovom korisniku vam nisu dostupne';
$string['usernotdeletedadmin'] = 'Korisnik nije obrisan pošto nije moguće obrisati administratorske naloge';
$string['usernotdeleteddeleted'] = 'Ovaj korisnik je već obrisan.';
$string['usernotdeletederror'] = 'Korisnik nije obrisan - greška';
$string['usernotdeletedmissing'] = 'Korisnik nije obrisan - korisničko ime nije pronađeno';
$string['usernotdeletedoff'] = 'Korisnik nije obrisan - brisanje nije dozvoljeno.';
$string['usernotfullysetup'] = 'Korisnik nije u potpunosti podešen';
$string['usernotincourse'] = 'Ovaj korsinik nije na ovom kursu';
$string['usernotrenamedadmin'] = 'Ne mogu se preimenovati administratorski nalozi.';
$string['usernotrenamedexists'] = 'Korisnik nije preimenovan - novo korisničko ime je već zauzeto';
$string['usernotrenamedmissing'] = 'Korisnik nije preimenovan - nije pronađeno staro korisničko ime';
$string['usernotrenamedoff'] = 'Korisnik nije preimenovan - preimenovanje nije dozvoljeno.';
$string['usernotupdatedadmin'] = 'Ne mogu se izmeniti administratorski nalozi.';
$string['usernotupdatederror'] = 'Korisnik nije ažuriran - greška';
$string['usernotupdatednotexists'] = 'Nisu izmenjeni podaci o korisniku - ne postoje podaci.';
$string['userquotalimit'] = 'Dostigli ste memorijski limit za svoje datoteke';
$string['userselectortoomany'] = 'user_selector je dobio više od jednog izabranog korisnika, iako opcija za višestruki izbor nije uključena.';
$string['verifyagedigitalconsentnotpossible'] = 'Žao nam je, potvrda saglasnosti o digitalnom uzrastu nije trenutno moguća.';
$string['wrongcall'] = 'Ovaj skript je pozvan pogrešno';
$string['wrongcontextid'] = 'ID konteksta je neisoravan (nije ga moguće naći)';
$string['wrongdestpath'] = 'Pogrešna odredišna putanja';
$string['wrongroleid'] = 'Neispravan ID uloge';
$string['wrongsourcebase'] = 'Pogrešna baza izvornog URL-a';
$string['wrongusernamepassword'] = 'Pogrešno korisničko ime/lozinka';
$string['wrongzipfilename'] = 'Pogrešan naziv arhive';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Nije bilo moguće kreirati kurs - Nema ovlašćenja';
$string['wwwrootmismatch'] = 'Otkriven je neispravan pristup. Ovom serveru se jedino može pristupiti preko adrese "{$a}". Molimo vas da obavestite administratora.';
$string['wwwrootslash'] = 'U config.php datoteci neispravno je podešena linija $CFG->wwwroot. Ona na kraju ne sme da ima kosu crtu  /<br />Molimo vas da o tome obavestite administratora.';
$string['xmldberror'] = 'XMLDB greška!';
$string['youcannotdeletecategory'] = 'Ne možete da obrišete kategoriju \'{$a}\' zato što ne možete da obrišete sadržaje ili da ih premestite negde drugo.';
