<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_wp', language 'lo', version '4.2'.
 *
 * @package     tool_wp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutexportfile'] = 'ກ່ຽວກັບໄຟລ໌ນີ້';
$string['activitycompletion'] = 'ການສຳເລັດກິດຈະກຳ';
$string['allcohorts'] = 'ກຸ່ມທັງໝົດ';
$string['allcohorts_help'] = 'ກຸ່ມທັງໝົດຜູ້ໃຊ້ນີ້ສາມາດຈັດການ';
$string['alldata'] = 'ຂໍ້ມູນທັງໝົດ';
$string['allsystemcohorts'] = 'ກຸ່ມລະບົບທັງໝົດ';
$string['cantlocatefileindraftarea'] = 'ບໍ່ສາມາດຊອກຫາໄຟລ໌ເຂດສະບັບຮ່າງຂອງຜູ້ໃຊ້.';
$string['certificates'] = 'ໃບຢັ້ງຢືນ';
$string['certificatetemplates'] = 'ຮ່າງໃບຢັ້ງຢືນ';
$string['certificatetemplates_help'] = 'ລວມມີແມ່ແບບໃບຢັ້ງຢືນ, ໜ້າ ແລະ ອົງປະກອບ. ໝາຍໄວ້ວ່າໃບຢັ້ງຢືນທີ່ອອກແລ້ວແມ່ນບໍ່ໄດ້ລວມນຳ';
$string['certificatetemplatesdetails'] = 'ລາຍລະອຽດຮ່າງໃບຢັ້ງຢືນ';
$string['change'] = 'ປ່ຽນແປງ';
$string['cleanupexpiredimportsexports'] = 'ລ້າງການນຳເຂົ້າ ແລະ ສົ່ງອອກທີ່ໝົດອາຍຸ';
$string['codechanged'] = 'ການອອກລະຫັດຖືກປ່ຽນແປງຈາກ \'{$a->from}\' ໄປເປັນ \'{$a->to}\'';
$string['cohortdetails'] = 'ລາຍລະອຽດກຸ່ມ';
$string['cohortdetails_help'] = 'ລາຍລະອຽດກຸ່ມສຳລັບແຕ່ລະຕົວຢ່າງທີ່ໄດ້ເລືອກ';
$string['cohortdetailswithmembers'] = 'ລາຍລະອຽດກຸ່ມລວມທັງສະມາຊິກ';
$string['cohortdetailswithmembers_help'] = 'ລາຍລະອຽດກຸ່ມລວມມີຂໍ້ມູນສະມາຊິກ. ໝາຍໄວ້ວ່າຜູ້ໃຊ້ບໍ່ໄດ້ລວມນຳ';
$string['cohortmembers'] = 'ສະມາຊິກກຸ່ມ';
$string['cohortmembers_help'] = 'ພຽງແຕ່ຂໍ້ມູນສະມາຊິກກຸ່ມຈະຖືກລວມນຳ, ແຕ່ຜູ້ໃຊ້ແທ້ຈິງຈະບໍ່ມີ';
$string['confighideparentlang'] = 'ເຊື່ອງຊຸດ Workplace ຫຼັກ';
$string['confighideparentlangdesc'] = 'ຖ້າເປີດໃຊ້ງານ, ຕົວຫຼັກຂອງຊຸດພາສາ Workplace ທີ່ຕິດຕັ້ງແລ້ວ ຈະບໍ່ສະແດງຢູ່ໃນເມນູພາສາ. ຕົວຢ່າງ, \'English (en)\' ບໍ່ສະແດງຖ້າ \'English for Workplace (en_wp)\' ຖືກຕິດຕັ້ງ.';
$string['confirmdeleteexport'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບການສົ່ງອອກນີ້?';
$string['confirmdeleteimport'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບການນຳເຂົ້ານີ້?';
$string['confirmprevbutton'] = 'ອອກຈາກເວັບໄຊທ໌ບໍ? ການປ່ຽນແປງທີ່ທ່ານໄດ້ເຮັດອາດບໍ່ໄດ້ຖືກບັນທຶກ.';
$string['confirmprocess'] = 'ໂດຍການຄຣິກໃສ່ "ດຳເນີນການ", ຂະບວນການຈະເລີ່ມຕົ້ນໄວໄວນີ້. ທ່ານຈະໄດ້ຮັບການແຈ້ງເຕືອນເມື່ອມັນສິ້ນສຸດລົງ.';
$string['conflictidnumber'] = 'ເພີ່ມການຕໍ່ທ້າຍຕົວເລກໃສ່ໝາຍເລກລະຫັດປະຈຳຕົວຂອງກຸ່ມ';
$string['conflicts'] = 'ຂັດແຍ່ງ';
$string['conflictshortname'] = 'ເພີ່ມການຕໍ່ທ້າຍຕົວເລກໃສ່ຊື່ຫຍໍ້ລາຍວິຊາ';
$string['content'] = 'ເນື້ອຫາ';
$string['copiedtoclipboard'] = 'ສຳເນົາຂໍ້ຄວາມໃສ່ຄລິບບອດແລ້ວ';
$string['copytoclipboard'] = 'ສຳເນົາໃສ່ຄລິບບອດແລ້ວ';
$string['coursecontentbackup'] = 'ອະນຸຍາດການສຳຮອງເນື້ອຫາລາຍວິຊາ';
$string['coursecontentbackupdesc'] = 'ການຕັ້ງຄ່ານີ້ ຄວບຄຸມວ່າຜູ້ໃຊ້ທີ່ສາມາດສໍາຮອງວິຊາໄດ້ຮັບອະນຸຍາດໃຫ້ລວມເອົາເນື້ອໃນລາຍວິຊາເປັນສ່ວນໜຶ່ງຂອງການສົ່ງອອກ. ຖ້າບໍ່ໄດ້ຕັ້ງຄ່າ, ພຽງແຕ່ຜູ້ໃຊ້ທີ່ສາມາດແກ້ໄຂການຕັ້ງຄ່າເວັບໄຊທ໌ສາມາດສົ່ງອອກເນື້ອໃນຫຼັກສູດເປັນສ່ວນໜຶ່ງຂອງການເຄື່ອນຍ້າຍ. ການຮັກສາການຕັ້ງຄ່ານີ້ຖືກປິດໄວ້ຈະຊ່ວຍຫຼຸດຜ່ອນຂະໜາດໄຟລ໌ທີ່ສົ່ງອອກ.';
$string['coursereset'] = 'ຕັ້ງຄ່າລາຍວິຊາຄືນໃໝ່ສຳລັບຜູ້ໃຊ້ແຕ່ລະຄົນ';
$string['coursesadmintab'] = 'ການຮຽນຮູ້';
$string['createdby'] = 'ສ້າງແລ້ວໂດຍ';
$string['csvcolumn'] = 'ຖັນ CVS';
$string['csvdefaultvalue'] = 'ຄ່າມາດຕະຖານ';
$string['csvfieldsmapping'] = 'ການສ້າງແຜນທີ່ຊ່ອງຂໍ້ມູນ';
$string['csvmappingnotspecified'] = 'ບໍ່ໄດ້ລະບຸ';
$string['csvwpcolumn'] = 'Moodle Workplace';
$string['deletegradeshistory'] = 'ລຶບປະຫວັດຄະແນນໃນເວລາການຕັ້ງຄ່າລາຍວິຊາຄືນໃໝ່';
$string['deletegradeshistory_desc'] = 'ຂໍແນະນຳໃຫ້ລຶບປະຫວັດຄະແນນໃນລະຫວ່າງການຕັ້ງຄ່າຫຼັກສູດຄືນໃໝ່ ໂດຍສະເພາະເມື່ອການຕັ້ງຄ່າ "ກູ້ຄືນຄະແນນມາດຕະຖານ" ເປີດຢູ່. ຖ້າປະຫວັດຄະແນນບໍ່ໄດ້ຖືກລຶບໃນລະຫວ່າງການຕັ້ງລາຍວິຊາຄືນໃໝ່, ຂະບວນການກູ້ຄະແນນລາຍວິຊາໃນການລົງທະບຽນຮຽນຄືນໃໝ່ຈະກູ້ຄະແນນຄືນ, ແນວໃດກໍຕາມ ຂໍ້ມູນການສຳເລັດກິດຈະກຳທັງໝົດຈະບໍ່ປາກົດອີກຕໍ່ໄປ.';
$string['descriptionformat'] = 'ຮູບແບບລາຍລະອຽດ';
$string['descriptionformatdefault'] = 'ຮູບແບບລາຍລະອຽດມາດຕະຖານ';
$string['doexport'] = 'ສົ່ງອອກ';
$string['doimport'] = 'ນຳເຂົ້າ';
$string['doyouagreelicense'] = 'ທ່ານໄດ້ອ່ານເງື່ອນໄຂເຫຼົ່ານີ້ ແລະ ໄດ້ເຊັນໃບອະນຸຍາດ Moodle Workplace™ ທີ່ເປັນເຈົ້າຂອງແລ້ວບໍ?';
$string['entitiescountpostfix'] = '({$a})';
$string['entitycertificateissues'] = 'ອອກໃບຢັ້ງຢືນ';
$string['entitycertificateissueuser'] = 'ອອກໃບຢັ້ງຢືນ: {$a}';
$string['entitycoursereset'] = 'ຂໍ້ມູນການຕັ້ງຄ່າລາຍວິຊາຄືນໃໝ່';
$string['entityidentifier'] = '{$a->name} ({$a->idnumber})';
$string['errorcantdeleteexport'] = 'ບໍ່ສາມາດລຶບການສົ່ງອອກ';
$string['errorcantdeleteimport'] = 'ບໍ່ສາມາດລຶບການນຳເຂົ້າ';
$string['errorcohortsameidnumber'] = 'ກຸ່ມທີ່ມີ idnumber ອັນດຽວກັນມີຢູ່ແລ້ວ';
$string['errorcouldnotallocatecohort'] = 'ບໍ່ສາມາດຈັດສັນຜູ້ໃຊ້ \'{$a->originaluserfullname}\' ໄປຫາກຸ່ມ \'{$a->name}\'';
$string['errorcouldnotimportissue'] = 'ບໍ່ສາມາດນຳເຂົ້າໃບຢັ້ງຢືນທີ່ອອກແລ້ວສຳລັບ \'{$a}\'';
$string['errorcoursesdonotexist'] = 'ບາງວິຊາບໍ່ມີ';
$string['errorcoursessameshortname'] = 'ວິຊາທີ່ມີຊື່ຫຍໍ້ອັນດຽວກັນມີຢູ່ແລ້ວ';
$string['errorcustomfielddoesnotexist'] = 'ບໍ່ມີຊ່ອງຂໍ້ມູນກຳນົດເອງ, ບໍ່ສາມາດນຳເຂົ້າຂໍ້ມູນ \'{$a}\'';
$string['errorcustomfieldnotfound'] = 'ບໍ່ພົບຊ່ອງຂໍ້ມູນຂອງຊ່ອງຂໍ້ມູນກຳນົດເອງ';
$string['errorcustomfieldnotfounddetail'] = 'ບໍ່ພົບ \'{$a}\' ຂອງຊ່ອງຂໍ້ມູນກຳນົດເອງ';
$string['errornegativenumber'] = 'ທ່ານຕ້ອງໃສ່ໝາຍເລກທີ່ບໍ່ເປັນລົບທີ່ນີ້.';
$string['eventcoursemodulereset'] = 'ຕັ້ງຄ່າຊຸດລາຍວິຊາຄືນໃໝ່ສຳລັບຜູ້ໃຊ້ແຕ່ລະຄົນ';
$string['eventcoursereset'] = 'ຕັ້ງຄ່າລາຍວິຊາຄືນໃໝ່ສຳລັບຜູ້ໃຊ້ແຕ່ລະຄົນ';
$string['eventexportcreated'] = 'ສ້າງການສົ່ງອອກແລ້ວ';
$string['eventexportdeleted'] = 'ລຶບການສົ່ງອອກແລ້ວ';
$string['eventexportupdated'] = 'ປັບປຸງການສົ່ງອອກແລ້ວ';
$string['eventimportcreated'] = 'ສ້າງການນຳເຂົ້າແລ້ວ';
$string['eventimportdeleted'] = 'ລຶບການນຳເຂົ້າແລ້ວ';
$string['eventimportupdated'] = 'ປັບປຸງການນຳເຂົ້າແລ້ວ';
$string['export_content'] = 'ລາຍລະອຽດແມ່ແບບໃບຢັ້ງຢືນ';
$string['export_content_help'] = 'ແມ່ແບບໃບຢັ້ງຢືນ, ໜ້າ ແລະ ອົງປະກອບ.';
$string['export_issued'] = 'ອອກໃບຢັ້ງຢືນແລ້ວ';
$string['export_issued_help'] = 'ອອກໃບຢັ້ງຢືນໃຫ້ຜູ້ໃຊ້ແລ້ວ. ການສຳເນົາບັນດາຜູ້ໃຊ້ເອງຈະບໍ່ລວມມີ.';
$string['exportcoursecategoriescontent'] = 'ລາຍລະອຽດປະເພດລາຍວິຊາ';
$string['exportcoursecategoriescontent_help'] = 'ລວມມີລາຍລະອຽດປະເພດລາຍວິຊາ. ການແຕ່ງຕັ້ງໜ້າທີ່ ແລະ ຕົວກອງຂອງປະເພດຈະບໍ່ລວມຢູ່ນຳ.';
$string['exportcoursecontent'] = 'ໂຄງຮ່າງລາຍວິຊາ';
$string['exportcoursecontent_help'] = 'ສິ່ງນີ້ລວມມີທຸກສິ່ງທຸກຢ່າງໃນລາຍວິຊາຍົກເວັ້ນເນື້ອຫາຂອງມັນ.

ໄຟລ໌ທີ່ສົ່ງອອກແລ້ວຈະບັນຈຸການຕັ້ງຄ່າອັນດຽວກັນເປັນຊຸດເຫຼົ່ານັ້ນເປັນຄ່າມາດຕະຖານໃນເວັບໄຊທ໌ນີ້ ເມື່ອກຳລັງສ້າງການສຳຮອງລາຍວິຊາມາດຕະຖານ. ບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້ຈະຖືກລວມນຳ.';
$string['exported'] = 'ສົ່ງອອກແລ້ວ';
$string['exporter'] = 'ຕົວສົ່ງອອກ';
$string['exportercreatefrom'] = 'ສ້າງການສົ່ງອອກຈາກ';
$string['exportercreatefrom_help'] = 'ທາງເລືອກນີ້ອະນຸຍາດທ່ານກຳນົດບໍ່ວ່າທ່ານຕ້ອງການສົ່ງອອກຫົວໜ່ວຍຈາກເວັບໄຊທ໌ທັງໝົດ ຫຼື ສະເພາະຜູ້ທີ່ກ່ຽວຂ້ອງກັບຜູ້ເຊົ່າປະຈຸບັນ';
$string['exportercreatefromcurrenttenant'] = 'ຜູ້ເຊົ່າປະຈຸບັນ';
$string['exporterdesc'] = 'ອອກໃບຢັ້ງຢືນ ແລະ ແມ່ແບບແລ້ວ';
$string['exporterdescription'] = 'ລາຍວິຊາທີ່ບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້, ການນຳໃຊ້ການກຳນົດຄ່າສຳຮອງຂໍ້ມູນລາຍວິຊາມາດຕະຖານ';
$string['exporterdescriptioncategories'] = 'ປະເພດ ແລະ ປະເພດຍ່ອຍລາຍວິຊາ';
$string['exporterdescriptioncohorts'] = 'ກຸ່ມ, ລວມທັງສະມາຊິກຸ່ມທີ່ບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້';
$string['exporternotavailable'] = 'ຕົວສົ່ງອອກ \'{$a}\' ບໍ່ມີຢູ່ທີ່ນີ້';
$string['exporternotfound'] = 'ບໍ່ສາມາດຊອກຫາຕົວສົ່ງອອກ \'{$a}\'';
$string['exporterrequirestenant'] = 'ຕົວສົ່ງອອກ \'{$a}\' ຕ້ອງການຜູ້ເຊົ່າ';
$string['exportersettingsinvalid'] = 'ການຕັ້ງຄ່າຕົວສົ່ງອອກບໍ່ແມ່ນຮູບແບບ JSON ທີ່ຖືກຕ້ອງ';
$string['exportersettingsvalidationfailed'] = 'ການກວດສອບການຕັ້ງຄ່າຕົວສົ່ງອອກລົ້ມເຫຼວ: {$a}';
$string['exportersunavailable'] = 'ບໍ່ມີຕົວສົ່ງອອກທີ່ມີຢູ່ສໍາລັບທ່ານທີ່ຈະນໍາໃຊ້';
$string['exportgeneralsettings'] = 'ການຕັ້ງຄ່າທົ່ວໄປ';
$string['exportgeneralsettingsdesc'] = 'ເລືອກຕົວສົ່ງອອກທີ່ທ່ານຕ້ອງການໃຊ້. ໃນຂັ້ນຕອນຕໍ່ໄປທ່ານຈະສາມາດຈຳກັດການເລືອກຂອງທ່ານ ແລະ ກໍານົດອົງປະກອບທີ່ທ່ານຕ້ອງການທີ່ຈະສົ່ງອອກ.';
$string['exportimport'] = 'ການໂອນຍ້າຍ';
$string['exportimportconflictsuffix'] = 'ເພີ່ມຕົວເລກທ້າຍໄປທີ່ຊ່ອງຂໍ້ມູນ \'{$a}\'';
$string['exportimportentityunavailable'] = '{$a} (ບໍ່ມີໃຫ້)';
$string['exportimporterrorentityexists'] = 'ມີຕົວຢ່າງທີ່ມີ \'{$a}\' ດຽວກັນຢູ່ແລ້ວ';
$string['exportimportfieldchanged'] = 'ປ່ຽນຊ່ອງຂໍ້ມູນ \'{$a->field}\' ຈາກ \'{$a->from}\' ໄປຫາ \'{$a->to}\' ແລ້ວ';
$string['exportimportsettings'] = 'ການຕັ້ງຄ່າການໂອນຍ້າຍ';
$string['exportimportsitecontent'] = 'ເນື້ອໃນ: ຫຼັກສູດ, ໝວດໝູ່, ໂຄງການ ແລະ ການຢັ້ງຢືນ';
$string['exportimportsitedescription'] = 'ເນື້ອຫາເວັບໄຊທ໌ເຕັມທີ່ລວມທັງຜູ້ເຊົ່າທັງໝົດພ້ອມກັບໜ່ວຍງານທັງໝົດທີ່ຢູ່ໃນພວກມັນ. ການສໍາຮອງຂອງລາຍວິຊາຈະປະກອບມີເນື້ອຫາ ແລະ ຂໍ້ມູນຜູ້ໃຊ້ທັງໝົດຍົກເວັ້ນບັນທຶກ';
$string['exportimportsiteerror'] = 'ບໍ່ສາມາດນຳເຂົ້າເວັບໄຊທ໌';
$string['exportimportsitesame'] = 'ບໍ່ສາມາດນຳເຂົ້າໃນເວັບໄຊທ໌ດຽວກັນທີ່ສົ່ງອອກມາຈາກ';
$string['exportimportsitesuccess'] = 'ນຳເຂົ້າເວັບໄຊທ໌ແລ້ວ';
$string['exportimportstatuscompleted'] = 'ສຳເລັດ';
$string['exportimportstatuscreated'] = 'ບໍ່ພ້ອມ';
$string['exportimportstatuserror'] = 'ຜິດພາດ';
$string['exportimportstatusinprogress'] = 'ກຳລັງດຳເນີນ';
$string['exportimportstatusscheduled'] = 'ຕາຕະລາງ';
$string['exportimportuserfieldserror'] = 'ບໍ່ສາມາດນຳເຂົ້າຊ່ອງຂໍ້ມູນໂປຣໄຟລ໌ຜູ້ໃຊ້ \'{$a}\'';
$string['exportimportusersall'] = 'ເລືອກຜູ້ໃຊ້ທັງໝົດ';
$string['exportimportusersdescription'] = 'ຜູ້ໃຊ້ເວັບໄຊທ໌ ແລະ ຜູ້ເຊົ່າ';
$string['exportimportuserserror'] = 'ບໍ່ສາມາດສ້າງຜູ້ໃຊ້ \'{$a}\'';
$string['exportimportuserslanguseselected'] = 'ນຳໃຊ້ພາສາທີ່ໄດ້ເລືອກ';
$string['exportimportusersmanual'] = 'ເລືອກຜູ້ໃຊ້ດ້ວຍຕົນເອງ...';
$string['exportimportusersmissinglangerror'] = 'ພາສາຜູ້ໃຊ້ຫາຍໄປໃນລະບົບ';
$string['exportimportusersmissinglangerrorlog'] = 'ພາສາຜູ້ໃຊ້ \'{$a->lang}\' ຫາຍໄປໃນລະບົບ';
$string['exportimportusersmnetconflict'] = 'ມູນຄ່າເຈົ້າພາບ MNet ແຕກຕ່າງກັນ';
$string['exportimportusersmnetmatchlocal'] = 'ປັບປຸງມູນຄ່າໃຫ້ກົງກັບເວັບໄຊທ໌';
$string['exportimportusersmnetuseexisting'] = 'ນຳເຂົ້າມູນຄ່າທີ່ມີຢູ່';
$string['exportimportuserspicture'] = 'ຮູບພາບຜູ້ໃຊ້';
$string['exportimportusersprofile'] = 'ໂປຼໄຟລ໌ຜູ້ໃຊ້';
$string['exportimportuserssuccess'] = 'ສ້າງຜູ້ໃຊ້ \'{$a}\' ແລ້ວ';
$string['exportimportuserssuspended'] = 'ລວມເອົາຜູ້ໃຊ້ທີ່ຖືກໂຈະ';
$string['exportimportuserstenant'] = 'ເລືອກຜູ້ໃຊ້ທັງໝົດຈາກ \'{$a}\'';
$string['exportnotfound'] = 'ບໍ່ພົບການສົ່ງອອກ';
$string['exportnotfoundornotready'] = 'ບໍ່ພົບການສົ່ງອອກ ຫຼື ບໍ່ພ້ອມທີ່ຈະນໍາເຂົ້າ';
$string['exportnotready'] = 'ການສົ່ງອອກບໍ່ພ້ອມສຳລັບການນຳເຂົ້າ';
$string['exportoptions'] = 'ທາງເລືອກ';
$string['exportoptionsdesc'] = 'ລະບຸອົງປະກອບໃດທີ່ທ່ານຕ້ອງການສົ່ງອອກໂດຍການເລືອກພວກມັນ.';
$string['exportreview'] = 'ທົບທວນຄືນ';
$string['exportreviewdesc'] = 'ກວດເບິ່ງວ່າທຸກຢ່າງຖືກຕ້ອງ ຫຼື ບໍ່ກ່ອນທີ່ຈະສົ່ງອອກໄຟລ໌.';
$string['exports'] = 'ສົ່ງອອກ';
$string['exportstatus'] = 'ສະຖານະ';
$string['filecontent'] = 'ເນື້ອຫາໄຟລ໌';
$string['grade'] = 'ຄະແນນ';
$string['idnumberchanged'] = 'ໝາຍເລກປະຈຳຕົວໄດ້ປ່ຽນແປງຈາກ \'{$a->from}\' ໄປເປັນ \'{$a->to}\'';
$string['import_content'] = 'ລາຍລະອຽດແມ່ແບບໃບຢັ້ງຢືນ';
$string['import_content_help'] = 'ແມ່ແບບໃບຢັ້ງຢືນ, ໜ້າ ແລະ ອົງປະກອບ';
$string['import_issued'] = 'ອອກໃບຢັ້ງຢືນແລ້ວ';
$string['import_issued_help'] = 'ອອກໃບຢັ້ງຢືນນີ້ໃຫ້ກັບຜູ້ໃຊ້';
$string['importallselectedcategory'] = 'ນຳເຂົ້າທັງໝົດໃນປະເພດທີ່ເລືອກ';
$string['importallsystemcontext'] = 'ນຳເຂົ້າທັງໝົດໃນເນື້ອຫາລະບົບ';
$string['importchoosetenant'] = 'ເລືອກຜູ້ເຊົ່າ';
$string['importconflictcreatecourse'] = 'ສ້າງວິຊາຫວ່າງເປົ່າ';
$string['importconflictcreatecourseincategory'] = 'ສ້າງຫຼັກສູດຫວ່າງເປົ່າໃນໝວດ \'{$a}\'';
$string['importconflictincategory'] = 'ໃນປະເພດ';
$string['importconflictinstances'] = 'ຕົວຢ່າງ ({$a}):';
$string['importconflicts'] = 'ຂັດແຍ່ງ';
$string['importconflictsdesc'] = 'ແກ້ໄຂຂໍ້ຂັດແຍ່ງ, ຖ້າຈຳເປັນ.';
$string['importconflictskip'] = 'ຢ່ານຳເຂົ້າ';
$string['importcoursecontent'] = 'ການສຳຮອງລາຍວິຊາບໍ່ລວມເອົາຂໍ້ມູນຜູ້ໃຊ້';
$string['importcoursecontent_help'] = 'ນໍາເຂົ້າການສໍາຮອງລາຍວິຊາສໍາລັບແຕ່ລະຕົວຢ່າງທີ່ເລືອກ';
$string['importdestination'] = 'ປາຍທາງ';
$string['imported'] = 'ນຳເຂົ້າແລ້ວ';
$string['importeitherexportidorfile'] = 'ຈະຕ້ອງລະບຸໄຟລ໌ exportid ຫຼື ໄຟລ໌ໃດໜຶ່ງ, ແຕ່ບໍ່ແມ່ນທັງສອງ.';
$string['importer'] = 'ຕົວນຳເຂົ້າ';
$string['importernotfound'] = 'ຕົວນຳເຂົ້າ {$a} ບໍ່ພົບ ຫຼື ມີໃຫ້';
$string['importerrequired'] = 'ມີຕົວນໍາເຂົ້າຫຼາຍກວ່າໜຶ່ງອັນ, ຕົວນໍາເຂົ້າຕ້ອງຖືກລະບຸ';
$string['importerrequirestenant'] = 'ຕົວນຳເຂົ້າ \'{$a}\' ຕ້ອງການຜູ້ເຊົ່າ';
$string['importersettingsinvalid'] = 'ການຕັ້ງຄ່າຕົວນໍາເຂົ້າບໍ່ຖືກຕ້ອງໃນຮູບແບບ JSON';
$string['importersettingsvalidationfailed'] = 'ການກວດສອບການຕັ້ງຄ່າຕົວນໍາເຂົ້າລົ້ມເຫຼວ: {$a}';
$string['importformat'] = 'ຮູບແບບໄຟລ໌';
$string['importformatauto'] = 'ກວດຈັບອັດຕະໂນມັດ';
$string['importformatcsv'] = 'CSV';
$string['importformatworkplace'] = 'ຮູບແບບ Workspace';
$string['importfromfile'] = 'ນຳເຂົ້າໃໝ່ຈາກໄຟລ໌ນີ້';
$string['importgeneralsettings'] = 'ການຕັ້ງຄ່າທົ່ວໄປ';
$string['importgeneralsettingsalt'] = 'ເລືອກປາຍທາງສໍາລັບຂໍ້ມູນທີ່ນໍາເຂົ້າ. ທ່ານຈະສາມາດລະບຸອົງປະກອບທີ່ທ່ານຕ້ອງການທີ່ຈະນໍາເຂົ້າໃນຂັ້ນຕອນຕໍ່ໄປ.';
$string['importhasconflits'] = 'ການນຳເຂົ້າມີຂໍ້ຂັດແຍ່ງ: {$a}';
$string['importincrementidnumber'] = 'ເພີ່ມຕົວເລກທ້າຍໃສ່ໝາຍເລກລະຫັດປະຈຳຕົວ';
$string['importintothecurrenttenant'] = 'ນຳເຂົ້າໃສ່ໃນຜູ້ເຊົ່າປະຈຸບັນ';
$string['importlogerror'] = 'ບໍ່ສາມາດນຳເຂົ້າແມ່ແບບໃບຢັ້ງຢືນ \'{$a->name}\'';
$string['importlogexception'] = 'ຍົກເວັ້ນ: {$a}';
$string['importlogfailed'] = 'ບໍ່ສາມາດນຳເຂົ້າລາຍວິຊາ \'{$a->fullname}\'';
$string['importlogfailedcohort'] = 'ບໍ່ສາມາດນຳເຂົ້າກຸ່ມ \'{$a->name}\'';
$string['importlogfailedcoursecategory'] = 'ບໍ່ສາມາດນຳເຂົ້າປະເພດລາຍວິຊາ \'{$a->name}\'';
$string['importlogsuccess'] = 'ສ້າງລາຍວິຊາ \'<a href="{$a->url}">{$a->fullname}</a>\' ໃໝ່ແລ້ວ';
$string['importlogsuccesscertificates'] = 'ສ້າງແມ່ແບບໃບຢັ້ງຢືນ \'<a href="{$a->url}">{$a->name}</a>\' ໃໝ່ກັບ {$a->pagescount} ໜ້າ ແລະ ອົງປະກອບ {$a->elementscount}';
$string['importlogsuccesscohort'] = 'ສ້າງກຸ່ມ \'<a href="{$a->url}">{$a->name}</a>\' ໃໝ່';
$string['importlogsuccesscohortallocations'] = 'ຈັດສັນຜູ້ໃຊ້ \'{$a->userfullname}\' ເຂົ້າໃນກຸ່ມ \'{$a->name}\'';
$string['importlogsuccesscoursecategory'] = 'ສ້າງປະເພດລາຍວິຊາ \'<a href="{$a->url}">{$a->name}</a>\' ໃໝ່';
$string['importlogsuccessissue'] = 'ສ້າງການອອກໃບຢັ້ງຢືນໃໝ່ໃນ \'{$a->template}\' ໃຫ້ກັບຜູ້ໃຊ້: \'{$a->originalusefullname}\'';
$string['importnotenant'] = 'ມີໃຫ້ສຳລັບຜູ້ເຊົ່າທັງໝົດ';
$string['importnotfound'] = 'ບໍ່ພົບການນຳເຂົ້າ';
$string['importoptions'] = 'ທາງເລືອກ';
$string['importoptionsdesc'] = 'ລະບຸອົງປະກອບໃດທີ່ທ່ານຕ້ອງການນໍາເຂົ້າໂດຍການເລືອກພວກມັນ.';
$string['importproblem'] = 'ບັນຫາ: {$a}';
$string['importproblemaffects'] = 'ມັນມີຜົນກະທົບ:';
$string['importreview'] = 'ທົບທວນຄືນ';
$string['importreviewdesc'] = 'ກວດເບິ່ງວ່າທຸກຢ່າງຖືກຕ້ອງຫຼືບໍ່ກ່ອນທີ່ຈະນໍາເຂົ້າໄຟລ໌.';
$string['imports'] = 'ນຳເຂົ້າ';
$string['importselectsource'] = 'ເລືອກແຫຼ່ງຂໍ້ມູນ';
$string['importselectsourcedesc'] = 'ອັບໂຫຼດໄຟລ໌ CSV ຫຼື Moodle Workplace ທີ່ຖືກຕ້ອງ. ໃນຂັ້ນຕອນຕໍ່ໄປ ທ່ານຈະສາມາດກໍານົດອົງປະກອບທີ່ທ່ານຕ້ອງການທີ່ຈະນໍາເຂົ້າຈາກໄຟລ໌.';
$string['importselecttenant'] = 'ເລືອກຜູ້ເຊົ່າ...';
$string['importsetidnumbertoempty'] = 'ຕັ້ງຄ່າໝາຍເລກລະຫັດປະຈຳຕົວ';
$string['importsolution'] = 'ການແກ້ໄຂ:';
$string['importstatus'] = 'ສະຖານະ';
$string['importunknownerror'] = 'ຂໍ້ຜິດພາດບໍ່ຮູ້ຈັກ {$a}';
$string['importunknownformat'] = 'ບໍ່ສາມາດກວດພົບຮູບແບບໄຟລ໌ຈາກສ່ວນຂະຫຍາຍໄດ້, ກະລຸນາເລືອກຮູບແບບ';
$string['includecoursecontent'] = 'ລວມທັງເນື້ອຫາລາຍວິຊາ';
$string['includecoursecontent_help'] = 'ລວມທັງເນື້ອໃນລາຍວິຊາທັງໝົດເຊັ່ນ: ກິດຈະກຳ, ຕົວກອງ, ນັດໝາຍປະຕິທິນ, ແລະອື່ນໆ.

ໄຟລ໌ທີ່ສົ່ງອອກຈະມີການຕັ້ງຄ່າດຽວກັນກັບທີ່ຕັ້ງເປັນຄ່າເລີ່ມຕົ້ນຢູ່ໃນເວັບໄຊທ໌ນີ້ ເມື່ອສ້າງການສໍາຮອງຫຼັກສູດມາດຕະຖານ. ບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້ຈະຖືກລວມເຂົ້າ.';
$string['instances'] = 'ຕົວຢ່າງ';
$string['instancescount'] = 'ຕົວຢ່າງ ({$a}):';
$string['invaliddevice'] = 'ທ່ານກຳລັງພະຍາຍາມເຂົ້າເຖິງເວັບໄຊທ໌ Moodle Workplace ໂດຍໃຊ້ແອັບ Moodle. ກະລຸນາດາວໂຫຼດແອັບ Moodle Workplace ເພື່ອສືບຕໍ່';
$string['loading'] = 'ກຳລັງໂຫຼດ...';
$string['log'] = 'ບັນທຶກ';
$string['managecoursecategories'] = 'ຈັດການປະເພດລາຍວິຊາ';
$string['mappingerrorbadgeheader'] = 'ບາງປ້າຍບໍ່ມີຢູ່';
$string['mappingerrorbadgelog'] = 'ບໍ່ພົບປ້າຍ {$a}';
$string['mappingerrorcertificateheader'] = 'ບາງແມ່ແບບໃບຢັ້ງຢືນບໍ່ມີຢູ່';
$string['mappingerrorcertificatelog'] = 'ບໍ່ພົບໃບຢັ້ງຢືນ {$a}';
$string['mappingerrorcohortheader'] = 'ບາງກຸ່ມບໍ່ມີຢູ່';
$string['mappingerrorcohortlog'] = 'ບໍ່ພົບກຸ່ມ {$a}';
$string['mappingerrorcompetencyheader'] = 'ບາງຄວາມສາມາດບໍ່ມີຢູ່';
$string['mappingerrorcompetencylog'] = 'ບໍ່ພົບຄວາມສາມາດ {$a}';
$string['mappingerrorcontextnotfound'] = 'ບໍ່ພົບເນື້ອໃນ';
$string['mappingerrorcoursenotfound'] = 'ບໍ່ພົບລາຍວິຊາ {$a}';
$string['mappingerroruserfieldheader'] = 'ບາງຊ່ອງຂໍ້ມູນໂປຣໄຟລ໌ຜູ້ໃຊ້ບໍ່ມີຢູ່';
$string['mappingerroruserfieldlog'] = 'ບໍ່ພົບຊ່ອງຂໍ້ມູນໂປຣໄຟລ໌ຜູ້ໃຊ້ {$a}';
$string['mappingerrorusernotfound'] = 'ບໍ່ສາມາດຊອກຫາຜູ້ໃຊ້ {$a} ໃນຜູ້ເຊົ່າປັດຈຸບັນໄດ້';
$string['mappingnoticecoursecreated'] = 'ລາຍວິຊາຫວ່າງເປົ່າ <a href="{$a->courseurl}">{$a->fullname}</a> ຖືກສ້າງແລ້ວ';
$string['mappingnoticecourseidnumber'] = 'ບໍ່ພົບລາຍວິຊາທີ່ມີຊື່ຫຍໍ້ \'{$a->shortname}\'. ພົບ <a href="{$a->courseurl}">ລາຍວິຊາອື່ນ</a> ທີ່ມີ idnumber \'{$a->idnumber}\', ແຕ່ລາຍວິຊານີ້ມີຊື່ຫຍໍ້ທີ່ແຕກຕ່າງກັນ';
$string['mappingnoticeuseremail'] = 'ບໍ່ພົບຜູ້ໃຊ້ທີ່ມີຊື່ຜູ້ໃຊ້ \'{$a->username}\'. <a href="{$a->profileurl}">ຜູ້ໃຊ້ອື່ນ</a> ທີ່ມີອີເມລ {$a->email} ຖືກພົບ, ແຕ່ຜູ້ໃຊ້ນີ້ມີຊື່ຜູ້ໃຊ້ທີ່ແຕກຕ່າງກັນ';
$string['messagefullexportcomplete'] = 'ການສົ່ງອອກຂອງທ່ານໄດ້ສຳເລັດໃນວັນທີ {$a->date}

ສະຖານະ: {$a->status}

ຄລິກ <a href="{$a->url}">ທີ່ນີ້</a> ເພື່ອເບິ່ງລາຍລະອຽດ';
$string['messagefullimportcomplete'] = 'ການນຳເຂົ້າຂອງທ່ານສຳເລັດໃນວັນທີ {$a->date}

ສະຖານະ: {$a->status}

ຄລິກ <a href="{$a->url}">ທີ່ນີ້</a> ເພື່ອເບິ່ງລາຍລະອຽດ';
$string['messageprovider:exportcomplete'] = 'ສົ່ງອອກສຳເລັດແລ້ວ';
$string['messageprovider:importcomplete'] = 'ນຳເຂົ້າສຳເລັດແລ້ວ';
$string['migrationcannotswitchtenant'] = 'ບໍ່ພົບຜູ້ເຊົ່າທີ່ມີ id ຫຼື idnumber {$a} ຫຼື ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ປ່ຽນໄປໃຊ້ມັນ';
$string['migrationnotenanterror'] = 'ທາງເລືອກຜູ້ເຊົ່າ ແລະ ບໍ່ແມ່ນຜູ້ເຊົ່າບໍ່ສາມາດໃຊ້ຮ່ວມກັນໄດ້';
$string['migrationschoosefrom'] = 'ເລືອກຈາກ';
$string['noavailableimporter'] = 'ພວກເຮົາບໍ່ສາມາດຊອກຫາຕົວນໍາເຂົ້າທີ່ມີຢູ່ສໍາລັບໄຟລ໌ນີ້.';
$string['noavailableimporters'] = 'ບໍ່ມີຕົວສົ່ງອອກໃຫ້';
$string['nocategoriesavailable'] = 'ບໍ່ມີປະເພດໃຫ້';
$string['noconflictsfound'] = 'ບໍ່ພົບຂໍ້ຂັດແຍ່ງ';
$string['nodetails'] = 'ບໍ່ພົບລາຍລະອຽດ';
$string['nonproductionsite'] = 'ເວັບໄຊທ໌ທີ່ບໍ່ແມ່ນການຜະລິດ';
$string['nonproductionsitemessage'] = 'ນີ້ແມ່ນເວັບໄຊທ໌ທີ່ບໍ່ແມ່ນການຜະລິດ';
$string['nopermissioncategoryimport'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ນໍາເຂົ້າໃນປະເພດນີ້.';
$string['nopermissioncategoryrestore'] = 'ທ່ານບໍ່ມີສິດໃນການກູ້ຂໍ້ມູນໃນປະເພດນີ້.';
$string['nopermissionform'] = 'ທ່ານບໍ່ມີສິດໃນການເຂົ້າເຖິງແບບຟອມນີ້.';
$string['nopermissiontab'] = 'ທ່ານບໍ່ມີສິດໃນການເຂົ້າເຖິງໜ້ານີ້.';
$string['nothing'] = 'ບໍ່ມີຫຍັງ';
$string['nothingtoexport'] = 'ບໍ່ມີຫຍັງທີ່ຈະສົ່ງອອກ';
$string['nothingtoimport'] = 'ບໍ່ມີຫຍັງທີ່ຈະນຳເຂົ້າ';
$string['notpossible'] = 'ເປັນໄປບໍ່ໄດ້';
$string['numhour'] = '{$a} ຊົ່ວໂມງ';
$string['outcomes'] = 'ຜົນໄດ້ຮັບ';
$string['performanceinfo'] = 'ຂໍ້ມູນປະສິດທິພາບແຖບ (DB ອ່ານ/ຂຽນ: {$and->reads}/{$and->writes})';
$string['pluginname'] = 'Workplace';
$string['privacy:metadata:certificationid'] = 'ລະຫັດການຢັ້ງຢືນທີ່ລາຍວິຊານີ້ມາຈາກ.';
$string['privacy:metadata:courseid'] = 'ລາຍວິຊາທີ່ເຄີຍໄດ້ຕັ້ງຄ່າຄືນໃໝ່.';
$string['privacy:metadata:exportcreatedby'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ດໍາເນີນການສົ່ງອອກ.';
$string['privacy:metadata:exportstatus'] = 'ສະຖານະຂອງການສົ່ງອອກ.';
$string['privacy:metadata:grade'] = 'ໃຫ້ຄະແນນຜູ້ໃຊ້ມີຢູ່ໃນລາຍວິຊາກ່ອນທີ່ມັນຈະຖືກຕັ້ງຄ່າຄືນໃໝ່.';
$string['privacy:metadata:importcreatedby'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ດໍາເນີນການນໍາເຂົ້າ.';
$string['privacy:metadata:importstatus'] = 'ສະຖານະການນຳເຂົ້າ.';
$string['privacy:metadata:programid'] = 'ລະຫັດປະຈຳຕົວໂປຣແກຣມບ່ອນທີ່ລາຍວິຊານີ້ມາຈາກ.';
$string['privacy:metadata:reason'] = 'ເຫດຜົນວ່າເປັນຫຍັງລາຍວິຊານີ້ຖືກຕັ້ງຄ່າຄືນໃໝ່.';
$string['privacy:metadata:resetinfo'] = 'ຂໍ້ມູນກ່ຽວກັບສິ່ງທີ່ໄດ້ຖືກຕັ້ງຄ່າຄືນໃໝ່ໃນລາຍວິຊາ.';
$string['privacy:metadata:resetstatus'] = 'ສະຖານະຂອງການຕັ້ງຄ່າຄືນໃໝ່.';
$string['privacy:metadata:tenantid'] = 'ລະຫັດປະຈຳຕົວທີ່ກ່ຽວຂ້ອງກັບຜູ້ເຊົ່າ.';
$string['privacy:metadata:timecreated'] = 'ເວລາຂອງການສ້າງ';
$string['privacy:metadata:timemodified'] = 'ເວລາທີ່ໄດ້ດັດແປງ.';
$string['privacy:metadata:timerequested'] = 'ຮ້ອງຂໍການຕັ້ງຄ່າເວລາຄືນໃໝ່.';
$string['privacy:metadata:tool_wp_course_reset'] = 'ຕັ້ງຄ່າລາຍວິຊາຄືນໃໝ່.';
$string['privacy:metadata:tool_wp_export'] = 'ຂໍ້ມູນກ່ຽວກັບການສົ່ງອອກປະຕິບັດຢູ່ໃນເວັບໄຊທ໌.';
$string['privacy:metadata:tool_wp_import'] = 'ຂໍ້ມູນກ່ຽວກັບການນໍາເຂົ້າປະຕິບັດຢູ່ໃນເວັບໄຊທ໌.';
$string['privacy:metadata:userid'] = 'ຜູ້ໃຊ້ທີ່ໄດ້ຕັ້ງຄ່າລາຍວິຊາຄືນໃໝ່.';
$string['privacy:metadata:usermodified'] = 'ຜູ້ໃຊ້ທີ່ໄດ້ດັດແປງ.';
$string['privacy:metadata:userrequested'] = 'ຜູ້ໃຊ້ທີ່ຮ້ອງຂໍການຕັ້ງຄ່າລາຍວິຊາຄືນໃໝ່.';
$string['privacy:metadata:wascompleted'] = 'ຖ້າຫາກວ່າລາຍວິຊາໄດ້ຖືກສໍາເລັດໂດຍຜູ້ໃຊ້ກ່ອນການຕັ້ງຄ່າຄືນໃໝ່.';
$string['problem'] = 'ບັນຫາ';
$string['proceed'] = 'ດຳເນີນ';
$string['processing'] = 'ກຳລັງດຳເນີນ';
$string['productionsite'] = 'ເວັບໄຊທ໌ການຜະລິດ';
$string['productionstate'] = 'ສະຖານະການຜະລິດ';
$string['productionstatedesc'] = 'ເວັບໄຊທ໌ທີ່ບໍ່ແມ່ນການຜະລິດຈະສະແດງຜູ້ປະຕິເສດໃນມຸມຂວາລຸ່ມຂອງຫນ້າຈໍ.';
$string['quotedentity'] = '\'{$a}\'';
$string['reason'] = 'ເຫດຜົນຂອງການຕັ້ງຄ່າຄືນໃໝ່';
$string['recovercoursegrades'] = 'ເມື່ອເປີດໃຊ້ການຕັ້ງຄ່ານີ້ໃຫ້ແນ່ໃຈວ່າຈະເປີດໃຊ້ການຕັ້ງຄ່າ \'ລຶບປະຫວັດຄະແນນໃນລະຫວ່າງການຕັ້ງຄ່າຂອງການຕັ້ງຄ່າລາຍວິຊາຄືນໃໝ່\'.';
$string['refresh'] = 'ປິດແລ້ວເປີດໃໝ່';
$string['reg_moodleproduct'] = 'ຜະລິດຕະພັນ Moodle ({$a})';
$string['reg_wpactiveusers'] = 'ຈຳນວນຜູ້ໃຊ້ທີ່ບໍ່ຊ້ຳກັນທີ່ເຂົ້າສູ່ລະບົບໃນເດືອນແລ້ວນີ້ ({$a})';
$string['reg_wpcertificates'] = 'ຈຳນວນຂອງໃບຢັ້ງຢືນ ({$a})';
$string['reg_wpcertificatesissues'] = 'ຈຳນວນຂອງໃບຢັ້ງຢືນ ({$a}) ທີ່ອອກແລ້ວ';
$string['reg_wpparticipantnumberaverage'] = 'ຈຳນວນຜູ້ເຂົ້າຮ່ວມທີ່ເຄື່ອນໄຫວໂດຍສະເລ່ຍໃນເດືອນແລ້ວນີ້ ({$a})';
$string['reg_wpplugins'] = 'ລາຍຊື່ປລັກອິນທີ່ຕິດຕັ້ງ ແລະ ເປີດໃຊ້ງານ, ຈໍານວນຕົວຢ່າງ ({$a})';
$string['reg_wpproductionstate'] = 'ລະບຸການຜະລິດ ({$a})';
$string['resetinfo'] = 'ການຕັ້ງຄ່າຂໍ້ມູນຄືນໃໝ່';
$string['resetstatus'] = 'ການຕັ້ງຄ່າສະຖານະຄືນໃໝ່';
$string['safenavigation'] = 'ມັນປອດໄພທີ່ຈະສືບຕໍ່ການນຳທາງໃນເວັບໄຊທ໌.';
$string['selectallcategoriesinthisfile'] = 'ເລືອກປະເພດລາຍວິຊາທັງໝົດໃນໄຟລ໌ນີ້';
$string['selectallcohortsinthisfile'] = 'ເລືອກກຸ່ມທັງໝົດໃນໄຟລ໌ນີ້';
$string['selectallcoursesinthisfile'] = 'ເລືອກລາຍວິຊາທັງໝົດໃນໄຟລ໌ນີ້';
$string['selectalltemplates'] = 'ເລືອກແມ່ແບບໃບຢັ້ງຢືນທັງໝົດ';
$string['selectalltemplatesinfile'] = 'ເລືອກແມ່ແບບໃບຢັ້ງຢືນທັງໝົດໃນໄຟລ໌ນີ້';
$string['selectatleastonecategory'] = 'ເລືອກຢ່າງໜ້ອຍໜຶ່ງປະເພດ';
$string['selectatleastonecohort'] = 'ເລືອກຢ່າງໜ້ອຍໜຶ່ງກຸ່ມ';
$string['selectatleastonecourse'] = 'ເລືອກຢ່າງໜ້ອຍໜຶ່ງວິຊາ';
$string['selectatleastonetemplate'] = 'ເລືອກຢ່າງໜ້ອຍໜຶ່ງແມ່ແບບ';
$string['selectcoursecategory'] = 'ເລືອກປະເພດລາຍວິຊາ';
$string['selectcoursesmanually'] = 'ເລືອກວິຊາດ້ວຍຕົນເອງ...';
$string['selectedcoursecategory'] = 'ເລືອກປະເພດລາຍວິຊາແລ້ວ: {$a}';
$string['selectexporter'] = 'ເລືອກຕົວສົ່ງອອກ';
$string['selectimporter'] = 'ເລືອກຕົວນຳເຂົ້າ';
$string['selectmanually'] = 'ເລືອກດ້ວຍຕົນເອງ...';
$string['selectmanuallycategories'] = 'ເລືອກປະເພດ ແລະ ປະເພດຍ່ອຍດ້ວຍຕົນເອງ';
$string['selectmanuallycertificates'] = 'ເລືອກແມ່ແບບໃບຢັ້ງຢືນດ້ວຍຕົນເອງ';
$string['shortnamechanged'] = 'ຊື່ຫຍໍ້ໄດ້ປ່ຽນແປງຈາກ \'{$a->from}\' ໄປເປັນ \'{$a->to}\'';
$string['showless'] = 'ສະແດງໜ້ອຍລົງ';
$string['showxmore'] = 'ສະແດງ {$a} ເພີ່ມເຕີມ...';
$string['solution'] = 'ການແກ້ໄຂ';
$string['stepx'] = 'ຂັ້ນຕອນ {$a}.';
$string['tenant'] = 'ຜູ້ເຊົ່າ';
$string['thissite'] = '(ເວັບໄຊທ໌ນີ້)';
$string['timerequested'] = 'ຮ້ອງຂໍເວລາ';
$string['timereseted'] = 'ຕັ້ງຄ່າເວລາຄືນໃໝ່';
$string['uploadimportfile'] = 'ອັບໂຫຼດໄຟລ໌';
$string['userrequested'] = 'ຜູ້ໃຊ້ທີ່ຮ້ອງຂໍ';
$string['viewexport'] = 'ເບິ່ງການສົ່ງອອກ';
$string['viewimport'] = 'ເບິ່ງການນຳເຂົ້າ';
$string['viewlicense'] = 'ເບິ່ງໃບອະນຸຍາດ';
$string['wascompleted'] = 'ສຳເລັດແລ້ວ';
$string['willbeimported'] = 'ຈະຖືກນຳເຂົ້າ';
$string['workplacelicenseheader'] = 'ໃບອະນຸຍາດ Moodle Workplace';
$string['workplacelicensenotagreed'] = 'ທ່ານບໍ່ສາມາດເບິ່ງເນື້ອຫານີ້ໄດ້ຈົນກວ່າຜູ້ເບິ່ງແຍງເວັບໄຊທ໌ຈະເຫັນດີກັບໃບອະນຸຍາດ Moodle Workplace.';
$string['wp:manageexportimport'] = 'ຈັດການການສົ່ງອອກ/ນຳເຂົ້າ Workplace';
$string['wp:useexportimport'] = 'ນຳໃຊ້ການສົ່ງອອກ/ນຳເຂົ້າ Workplace';
