<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlecloudsignup', language 'es', version '4.2'.
 *
 * @package     local_moodlecloudsignup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['FOSUserBundle:change_password.flash.success'] = 'La contraseña ha sido cambiada';
$string['FOSUserBundle:change_password.submit'] = 'Cambiar contraseña';
$string['FOSUserBundle:form.current_password'] = 'Contraseña actual:';
$string['FOSUserBundle:form.email'] = 'Email:';
$string['FOSUserBundle:form.group_name'] = 'Nombre del grupo:';
$string['FOSUserBundle:form.new_password'] = 'Nueva contraseña:';
$string['FOSUserBundle:form.new_password_confirmation'] = 'Repetir nueva contraseña:';
$string['FOSUserBundle:form.password'] = 'Contraseña:';
$string['FOSUserBundle:form.password_confirmation'] = 'Repetir contraseña:';
$string['FOSUserBundle:form.username'] = 'Nombre de usuario:';
$string['FOSUserBundle:group.edit.submit'] = 'Actualizar grupo';
$string['FOSUserBundle:group.flash.created'] = 'El grupo ha sido creado';
$string['FOSUserBundle:group.flash.deleted'] = 'El grupo ha sido borrado';
$string['FOSUserBundle:group.flash.updated'] = 'El grupo ha sido actualizado';
$string['FOSUserBundle:group.new.submit'] = 'Crear grupo';
$string['FOSUserBundle:group.show.name'] = 'Nombre del grupo';
$string['FOSUserBundle:layout.logged_in_as'] = 'Identificado como %username%';
$string['FOSUserBundle:layout.login'] = 'Entrar';
$string['FOSUserBundle:layout.logout'] = 'Salir';
$string['FOSUserBundle:layout.register'] = 'Registro';
$string['FOSUserBundle:profile.edit.submit'] = 'Actualización';
$string['FOSUserBundle:profile.flash.updated'] = 'El perfil ha sido actualizado';
$string['FOSUserBundle:profile.show.email'] = 'Email';
$string['FOSUserBundle:profile.show.username'] = 'Nombre de usuario';
$string['FOSUserBundle:registration.back'] = 'Volver a la página inicial.';
$string['FOSUserBundle:registration.check_email'] = 'Un email ha sido enviado a %email%. Contiene un enlace de activación que debes seguir para activar tu cuenta.';
$string['FOSUserBundle:registration.confirmed'] = 'Enhorabuena %username%, tu cuenta está ahora activada.';
$string['FOSUserBundle:registration.email.message'] = 'Hola %username%!

Para finalizar la activación de tu cuenta - por favor visita %confirmationUrl%

Saludos,
el Equipo.';
$string['FOSUserBundle:registration.email.subject'] = 'Bienvenido %username%!';
$string['FOSUserBundle:registration.flash.user_created'] = 'El usuario se ha creado correctamente';
$string['FOSUserBundle:registration.submit'] = 'Registrar';
$string['FOSUserBundle:resetting.check_email'] = 'Un email ha sido enviado a %email%. Contiene un enlace de activación que debes pulsar para restablecer tu contraseña.';
$string['FOSUserBundle:resetting.email.message'] = 'Hola %username%!

Para restablecer tu contraseña - por favor visita %confirmationUrl%

Saludos,
el Equipo.';
$string['FOSUserBundle:resetting.email.subject'] = 'Restablecer contraseña';
$string['FOSUserBundle:resetting.flash.success'] = 'La contraseña se ha restablecido correctamente';
$string['FOSUserBundle:resetting.password_already_requested'] = 'La contraseña para este usuario ya ha sido solicitada dentro de las últimas 24 horas.';
$string['FOSUserBundle:resetting.request.invalid_username'] = 'El nombre de usuario o dirección de correo electrónico %username% no existe.';
$string['FOSUserBundle:resetting.request.submit'] = 'Restablecer contraseña';
$string['FOSUserBundle:resetting.request.username'] = 'Nombre de usuario o dirección de correo electrónico:';
$string['FOSUserBundle:resetting.reset.submit'] = 'Cambiar contraseña';
$string['FOSUserBundle:security.login.password'] = 'Contraseña:';
$string['FOSUserBundle:security.login.remember_me'] = 'Recordarme';
$string['FOSUserBundle:security.login.submit'] = 'Iniciar sesión';
$string['FOSUserBundle:security.login.username'] = 'Nombre de usuario:';
$string['homepage:Table.activities'] = 'Actividades ilimitadas';
$string['homepage:Table.annualprice'] = 'Precio anual*';
$string['homepage:Table.button'] = 'Registrarse';
$string['homepage:Table.conferencing'] = 'Videoconferencia';
$string['homepage:Table.gb'] = '%limit% Gb';
$string['homepage:Table.maxuploads'] = 'Subida de archivo máximo';
$string['homepage:Table.maxusers'] = 'Usuarios máximo';
$string['homepage:Table.mb'] = '%limit% Mb';
$string['homepage:Table.mobile'] = 'Mobile habilitado';
$string['homepage:Table.noplugins'] = 'Sin paquete extra de plugins';
$string['homepage:Table.notheme'] = 'Sin temas avanzados';
$string['homepage:Table.plan'] = 'Plan';
$string['homepage:Table.plugins'] = 'Paquete extra de plugins';
$string['homepage:Table.sitename'] = 'Nombre personalizado del sitio';
$string['homepage:Table.theme'] = 'Tema avanzado';
$string['homepage:Table.uptodate'] = 'Siempre actualizado';
$string['homepage:body.intro'] = 'de la gente que hace Moodle';
$string['homepage:body.title'] = 'Alojamiento Moodle';
$string['homepage:general.faq'] = 'FAQ';
$string['homepage:general.servicestatus'] = 'Estado del servicio';
$string['homepage:needmore'] = '¿Necesitas un plan más grande?<a href="https://moodle.com/contact">Contacta con nosotros</a>.';
$string['homepage:notfound.badnews'] = 'Las malas noticias son que el sitio que estas buscando no existe - ha sido borrado o aún no está en línea.';
$string['homepage:notfound.button'] = 'Regístrate y consigue este sitio.';
$string['homepage:notfound.goodnews'] = 'Las buenas noticias son que el sitio está disponible y lo puedes conseguir';
$string['homepage:notfound.title'] = 'Tenemos buenas y malas noticias';
$string['homepage:page.description'] = 'Las soluciones de alojamiento Moodle que proporciona Moodle están disponibles para que cualquiera ejecute el software de aprendizaje en la nube';
$string['homepage:page.title'] = 'MoodleCloud: Servicios de Alojamiento Gratuito de los creadores de Moodle';
$string['homepage:plans.free.description'] = 'Para clases individuales o sólo para probar Moodle';
$string['homepage:plans.free.name'] = 'Moodle Gratis';
$string['homepage:plans.free.plan_free'] = 'Gratis';
$string['homepage:plans.school1.description'] = 'Ideal para varias clases';
$string['homepage:plans.school1.name'] = 'Moodle para el Colegio';
$string['homepage:plans.school1.plan_idmedium'] = 'Medio';
$string['homepage:plans.school1.plan_idsmall'] = 'Pequeño';
$string['homepage:plans.school1.plan_tiny'] = 'Diminuto';
$string['homepage:sitelimit'] = '** Limitado a uno por cliente';
$string['homepage:taxes'] = '* Más impuestos aplicables';
$string['langconfig:direction'] = 'izquierda-a-derecha';
$string['langconfig:langname'] = 'Inglés';
$string['login:brandname'] = 'MoodleCloud';
$string['login:gotoportal'] = 'Ir al Portal';
$string['login:logout'] = 'Cerrar sesión';
$string['login:security.login.password'] = 'Contraseña';
$string['login:security.login.password_placeholder'] = 'Contraseña';
$string['login:security.login.submit'] = 'Iniciar sesión';
$string['login:security.login.username'] = 'Nombre del sitio MoodleCloud';
$string['login:security.login.username_placeholder'] = 'misitio';
$string['login:security.token.invalid'] = 'Falló el ingreso al portal. Por favor inténtelo nuevamente.';
$string['login:signup.login.panel.title'] = 'Ingresar';
$string['messages:auditlog.administrator'] = 'Equidpo de Adminstración de MoodleCloud';
$string['messages:auditlog.automatedtool'] = 'Bot de MoodleCloud';
$string['messages:auditlog.site.removalComplete'] = 'El sitio fue quitado';
$string['messages:auditlog.site.removalQueued'] = 'Se puso en cola para quitar el sitio';
$string['messages:close'] = 'Cerrar';
$string['plans:packages.free'] = 'Moodle Gratuito';
$string['plans:packages.school'] = 'Moodle para Escuela';
$string['plans:plans.free.0.description'] = 'Moodle Gratuito';
$string['plans:plans.free.0.name'] = 'Gratuito';
$string['plans:plans.school_1000.0.description'] = 'Moodle para Escuela / Mediana';
$string['plans:plans.school_1000.0.name'] = 'Mediana';
$string['plans:plans.school_250.0.description'] = 'Moodle para Escuela / Pequeñísima';
$string['plans:plans.school_250.0.name'] = 'Pequeñísima';
$string['plans:plans.school_500.0.description'] = 'Moodle para Escuela / Pequeña';
$string['plans:plans.school_500.0.name'] = 'Pequeña';
$string['pluginname'] = 'Registro MoodleCloud y Portal';
$string['portal:addons.School_1000_0.title'] = 'Moodle para Escuela / Mediana';
$string['portal:addons.School_250_0.title'] = 'Moodle para Escuela / Pequeñísima';
$string['portal:addons.School_500_0.title'] = 'Moodle para Escuela / Pequeña';
$string['portal:addons.buttons.add'] = 'Añadir';
$string['portal:addons.buttons.remove'] = 'Quitar';
$string['portal:addons.buttons.removing'] = 'Quitando';
$string['portal:addons.errors.doesnotexist'] = 'El complemento que Usted intentó especificar no existe.';
$string['portal:addons.nostudentads.description'] = 'Los administradores y profesores todavía pueden ver anuncios relacionados con servicios Moodle.';
$string['portal:addons.nostudentads.flashes.disabled'] = 'A Usted no se le volverá a cobrar por este complemento. Se les mostrarán anuncios a los estudiantes al finalizar este periodo de facturación, %billingendperiod%.';
$string['portal:addons.nostudentads.flashes.disabled.failed'] = 'Ocurrió un error al deshabilitar los anuncios. Por favor inténtelo nuevamente más tarde o contáctenos.';
$string['portal:addons.nostudentads.flashes.enabled'] = '¡Gracias por su apoyo! Ya no se mostrarán anuncios a estudiantes en su sitio.';
$string['portal:addons.nostudentads.label'] = 'Anuncios';
$string['portal:addons.nostudentads.removalconfirmation.body'] = 'A Usted no se le volverá a cobrar por este complemento. Se les mostrarán anuncios a los estudiantes al finalizar este periodo de facturación.';
$string['portal:addons.nostudentads.removalconfirmation.title'] = 'Quitar anuncio';
$string['portal:addons.nostudentads.states.disabled'] = 'Actualmente su sitio muestra Anuncios Google Ads a estudiantes para ayudar a pagar por nuestro alojamiento gratuito.';
$string['portal:addons.nostudentads.states.enabled'] = 'Su sitio actualmente ya no muestra anuncios Google Ads a estudantes porque Usted ha pagado para quitarlos.';
$string['portal:addons.nostudentads.title'] = 'Ocultar anuncios de la vista del estudiante';
$string['portal:addons.panel.lead'] = 'Aquí hay algunas características adicionales para mejorar su sitio';
$string['portal:addons.panel.title'] = 'Complementos';
$string['portal:addons.pay'] = 'Proceda a pagar';
$string['portal:addons.strings.cost'] = '%price% %currency%';
$string['portal:addons.strings.month'] = 'mes';
$string['portal:addons.strings.price'] = '%price% %currency% / %period%';
$string['portal:billing.billingdetails.change.fields.cancel'] = 'Cancelar';
$string['portal:billing.billingdetails.change.fields.save'] = 'Hacer pago';
$string['portal:billing.billingdetails.change.labels.ccname'] = 'Nombre del tarjetahabiente';
$string['portal:billing.billingdetails.change.labels.ccnumber'] = 'Número de Tarjeta de Crédito';
$string['portal:billing.billingdetails.change.labels.cvv'] = 'CVV';
$string['portal:billing.billingdetails.change.labels.expiration'] = 'Fecha de Caducidad MM/AA';
$string['portal:billing.billingdetails.change.panel.cardrequiredbecause'] = 'Los detalles de su tarjeta de crédito son almacenados en nuestro confiable procesador de pagos, PayPal.';
$string['portal:billing.billingdetails.change.panel.title'] = 'Detalles de tarjeta de crédito';
$string['portal:billing.billingdetails.change.panel.verificationamount'] = 'Nota, Para verificar los detalles de su tarjeta, se autorizará un pequeño cargo (típicamente $1) a su tarjeta y desaparecerá de su estado de cuenta después de unos cuantos días.';
$string['portal:billing.billingdetails.change.placeholders.ccname'] = 'Juan Camaney';
$string['portal:billing.billingdetails.change.placeholders.expiration'] = 'MM/AA';
$string['portal:billing.billingdetails.set.fields.pay'] = 'Hacer pago';
$string['portal:billing.billingdetails.set.fields.save'] = 'Siguiente';
$string['portal:billing.billingdetails.strings.changepaymentdetails'] = 'Cambiar detalles del pago';
$string['portal:billing.billingdetails.strings.usethis'] = 'Usar este método de pago';
$string['portal:billing.errors.hard.addnewmethod'] = 'Ocurrió un problema duirante el procesamiento del pago. Usted podría querer revisar la información proporcionada e intentarlo nuevamente.';
$string['portal:billing.errors.hard.cancellation'] = 'Ocurrió un problema duirante el procesamiento del pago. Nosotros lo contactaremos en cuanto el problema haya sido resuelto.';
$string['portal:billing.errors.hard.gateway'] = 'No podemos procesar pagos en este momento. Por favor inténtelo nuevamente más tarde.';
$string['portal:billing.errors.hard.generic'] = 'Ocurrió un problema duirante el procesamiento del pago. Por favor revise los detalles de su método de pago.';
$string['portal:billing.errors.hard.updatenewmethod'] = 'Su nueva información de pago fue almacenada exitosamente, pero ocurrió un error akl actualizar su suscripción actual. Nosotros lo contactaremos en cuanto el problema haya sido resuelto.';
$string['portal:billing.errors.soft.contactbank'] = 'Ocurrió un problema duirante el procesamiento del pago. Por favor contacte a su banco o inténtelo de nuevo en un momento.';
$string['portal:billing.errors.soft.generic'] = 'Ocurrió un problema duirante el procesamiento del pago. Por favor inténtelo nuevamente en un momento.';
$string['portal:billing.errors.soft.wrongcardtype'] = 'No podemos aceptar el tipo de tarjeta que Usted uha usado. Por favor use una diferente';
$string['portal:billing.events.chargedsuccessfully.title'] = 'Su pago delpaquete MoodleCloud fue exitoso';
$string['portal:billing.events.chargedunsuccessfully.title'] = '¡Oh no! Falló su pago de MoodleCloud';
$string['portal:billing.events.wentpastdue.title'] = '¡Oh oh! Su pago de MoodleCloud ha sido declinado otra vez';
$string['portal:billing.paymentMethods.mastercard'] = 'MasterCard';
$string['portal:billing.paymentMethods.panel.title'] = 'Por favor seleccione un método de pago';
$string['portal:billing.paymentMethods.types.creditcard'] = 'Tarjeta de Crédito';
$string['portal:billing.paymentMethods.types.paypal'] = 'PayPal';
$string['portal:billing.paymentMethods.visa'] = 'Visa';
$string['portal:billing.receipt.abn'] = 'Australian Business Number';
$string['portal:billing.receipt.amount'] = 'Cantidad';
$string['portal:billing.receipt.billedto'] = 'Facturado a';
$string['portal:billing.receipt.cardnumber'] = 'Número de tarjeta';
$string['portal:billing.receipt.date'] = 'Fecha de facturación';
$string['portal:billing.receipt.email'] = 'Email';
$string['portal:billing.receipt.gstlegend'] = '* Impuesto GST solamente es aplicable a Residentes Australianos';
$string['portal:billing.receipt.lineitems.description'] = 'Descripción';
$string['portal:billing.receipt.lineitems.gst'] = 'AU GST*';
$string['portal:billing.receipt.lineitems.total'] = 'Cantidad total';
$string['portal:billing.receipt.name'] = 'Nombre';
$string['portal:billing.receipt.pagetitle'] = 'Factura con impuesto de MoodleCloud  %reference% para %url% en %date%';
$string['portal:billing.receipt.paypalaccount'] = 'Cuenta PayPal';
$string['portal:billing.receipt.pleaseretain'] = 'Por favor conserve una copia de esta factura con impuestos para sus registros.';
$string['portal:billing.receipt.reference'] = 'Referencia de factura';
$string['portal:billing.receipt.summary.chargedto'] = 'Cobrado a';
$string['portal:billing.receipt.summary.outstanding'] = 'Pendiente';
$string['portal:billing.receipt.tandc'] = 'Términos y Condiciones';
$string['portal:billing.receipt.termsaturl'] = 'Usted puede encontrar los Términos del Servicio en <a href="%termsurl%">%termsfullurl%</a>.';
$string['portal:billing.receipt.title'] = 'Factura con impuestos';
$string['portal:billing.receipt.url'] = 'URL';
$string['portal:billing.strings.gstnotice'] = 'El precio incluye impuesto GST';
$string['portal:billing.subscriptions.panel.title'] = 'Pago recurrente';
$string['portal:billing.subscriptions.statuses.Active.title'] = 'Activa';
$string['portal:billing.subscriptions.statuses.Canceled.title'] = 'Cancelada';
$string['portal:billing.subscriptions.statuses.Expired.title'] = 'Caducada';
$string['portal:billing.subscriptions.statuses.Pending.title'] = 'Pendiente';
$string['portal:billing.subscriptions.table.nextBillingDate.title'] = 'Fecha del próximo pago';
$string['portal:billing.subscriptions.table.nextBillingPeriodAmount.title'] = 'Cantidad';
$string['portal:billing.subscriptions.table.planId.title'] = 'Plan';
$string['portal:billing.subscriptions.table.status.title'] = 'Estatus';
$string['portal:billing.transactions.panel.title'] = 'Historia de cuentas';
$string['portal:billing.transactions.statuses.authorization_expired.title'] = 'Falló';
$string['portal:billing.transactions.statuses.authorized.title'] = 'Autorizada';
$string['portal:billing.transactions.statuses.authorizing.title'] = 'Procesando';
$string['portal:billing.transactions.statuses.failed.title'] = 'Falló';
$string['portal:billing.transactions.statuses.gateway_rejected.title'] = 'Falló';
$string['portal:billing.transactions.statuses.processor_declined.title'] = 'Falló';
$string['portal:billing.transactions.statuses.settled.title'] = 'Transacción completada';
$string['portal:billing.transactions.statuses.settlement_confirmed.title'] = 'Transacción completada';
$string['portal:billing.transactions.statuses.settlement_declined.title'] = 'Falló';
$string['portal:billing.transactions.statuses.settlement_pending.title'] = 'Autorizada';
$string['portal:billing.transactions.statuses.settling.title'] = 'Autorizada';
$string['portal:billing.transactions.statuses.submitted_for_settlement.title'] = 'Autorizada';
$string['portal:billing.transactions.statuses.unrecognized.title'] = 'Desconocida';
$string['portal:billing.transactions.statuses.voided.title'] = 'Falló';
$string['portal:billing.transactions.table.amount.title'] = 'Cantidad';
$string['portal:billing.transactions.table.creationDate.title'] = 'Fecha';
$string['portal:billing.transactions.table.invoice.title'] = 'Factura';
$string['portal:billing.transactions.table.planId.title'] = 'Plan';
$string['portal:billing.transactions.table.status.title'] = 'Estatus';
$string['portal:export.title'] = 'Su exportación de MoodleCloud está lista para descargarse';
$string['portal:graphs.axes.dbsize'] = 'Tamaño de la BasedeDatos';
$string['portal:graphs.axes.filesize'] = 'Tamño de archivo';
$string['portal:graphs.axes.users'] = 'Usuarios';
$string['portal:graphs.filetypes.application'] = 'Datos de aplicación';
$string['portal:graphs.filetypes.audio'] = 'Audio';
$string['portal:graphs.filetypes.example'] = 'Ejemplo';
$string['portal:graphs.filetypes.image'] = 'Imágenes';
$string['portal:graphs.filetypes.message'] = 'Mensajes';
$string['portal:graphs.filetypes.model'] = 'Modelos';
$string['portal:graphs.filetypes.multipart'] = 'Elementos multiparte';
$string['portal:graphs.filetypes.text'] = 'Texto';
$string['portal:graphs.filetypes.video'] = 'Vídeos';
$string['portal:historical.fetchfailure.lead'] = 'Lo siento, no pudimos recuperar tu información histórica.Si vuelves más tarde puede que tengamos algo para ti.';
$string['portal:historical.fetchfailure.title'] = '¡Oh no!';
$string['portal:list.body.title'] = 'Portal';
$string['portal:list.table.titles.location'] = 'Ubicación';
$string['portal:list.table.titles.package'] = 'Paquete';
$string['portal:list.table.titles.site'] = 'Sitio';
$string['portal:list.table.titles.subdomain'] = 'Subdominio';
$string['portal:messages.csrffailure'] = 'Imposible confirmar los cambios. Por favor inténtalo de nuevo.';
$string['portal:messages.pendingprovision'] = '<span class="mc-spin glyphicon glyphicon-refresh"></span> Este sitio todavía está siendo creado. Por favor espera, pronto estará en línea.';
$string['portal:messages.removalfailed'] = 'La eliminación falló. Se ha notificado al soporte de MoodleCloud. Por favor inténtalo de nuevo más tarde.';
$string['portal:messages.removalqueued'] = 'En cola para su borrado.';
$string['portal:messages.sitenotfound'] = 'El sitio no pudo ser cargado. Por favor inténtalo de nuevo.';
$string['portal:page.body.title'] = 'Portal';
$string['portal:page.button'] = 'Obtener otro sitio';
$string['portal:page.tabs.billing'] = 'Facturación';
$string['portal:page.tabs.package'] = 'Paquete';
$string['portal:page.tabs.paymentdetails'] = 'Detalles de pago';
$string['portal:page.tabs.statistics'] = 'Estadísticas';
$string['portal:page.tabs.support'] = 'Soporte';
$string['portal:page.tabs.tools'] = 'Herramientas';
$string['portal:page.title'] = 'MoodleCloud: Portal';
$string['portal:plans.plans.MCFREE.cost'] = 'Gratis';
$string['portal:plans.plans.MCFREE.invoicetitle'] = 'Add-ons para el Alojamiento Gratuito MoodleCloud';
$string['portal:plans.plans.MCFREE.invoicetitleurl'] = 'Add-ons para el Alojamiento Gratuito MoodleCloud en %url%';
$string['portal:plans.plans.MCFREE.title'] = 'Anuncios para Moodle Gratuito';
$string['portal:plans.plans.MCSCHOOL.invoicetitle'] = 'Moodle para la Escuela';
$string['portal:plans.plans.MCSCHOOL.title'] = 'Moodle para la Escuela';
$string['portal:plans.strings.plan'] = 'Plan';
$string['portal:purchases.confirmationpage.cancel'] = 'No gracias';
$string['portal:purchases.confirmationpage.continue'] = 'Pagar ahora';
$string['portal:purchases.confirmationpage.lead'] = 'Estás comprando:';
$string['portal:purchases.confirmationpage.paymentnotice'] = 'Se te cargará esta cantidad hoy, y este día o alrededor del día %dayofmonth%  de cada mes hasta que quites este add-on.';
$string['portal:purchases.confirmationpage.title'] = 'Confirmación del método de pago';
$string['portal:siteinfo.page.title'] = 'Información del sitio para %subdomain%';
$string['portal:siteinfo.panels.historical.title'] = 'Histórico de estadísticas';
$string['portal:siteinfo.panels.info.limit_disk'] = '%maxbytes% Mb de espacio de disco';
$string['portal:siteinfo.panels.info.limit_users'] = '%maxusers% usuarios';
$string['portal:siteinfo.panels.info.limits'] = 'Límites';
$string['portal:siteinfo.panels.info.location'] = 'Localización del alojamiento';
$string['portal:siteinfo.panels.info.package'] = 'Paquete';
$string['portal:siteinfo.panels.info.sitename'] = 'Nombre del sitio';
$string['portal:siteinfo.panels.info.status'] = 'Estado';
$string['portal:siteinfo.panels.info.title'] = 'Información';
$string['portal:siteinfo.panels.info.version'] = 'Versión';
$string['portal:siteinfo.panels.statistics.title'] = 'Estadísticas';
$string['portal:statistics.fetchfailure.lead'] = 'Lo siento, no hemos podido obtener tus estadísticas actuales. Si regresas más tarde, podríamos tenerlas listas para tí.';
$string['portal:statistics.fetchfailure.title'] = '¡Oh no!';
$string['portal:statistics.graphs.databasesize'] = 'Tamaño de base de datos';
$string['portal:statistics.graphs.files'] = 'Ficheros';
$string['portal:statistics.graphs.users'] = 'Usuarios';
$string['portal:support.certifiedpartner'] = 'Tu Partner Moodle local es:';
$string['portal:support.contact.button'] = 'Contactar ahora';
$string['portal:support.contact.flash'] = 'Tu petición ha sido enviada, ¡gracias!';
$string['portal:support.contact.sendbutton'] = 'Enviar consulta';
$string['portal:support.contact.title'] = 'Contactar a su socio';
$string['portal:support.title'] = '¿Necesitas ayuda con tu sitio Moodle?';
$string['portal:tasks.removal.warning.title'] = 'El  "%subdomain%" del sitio MoodleCloud está inactivo y será eliminado pronto';
$string['portal:view.actionpending.panel.body'] = 'Cambios en progreso';
$string['portal:view.actionpending.panel.lead'] = 'Están en progreso modificaciones para este sitio y estarán bloqueados nuevos cambios hasta que se hayan completado las acciones en curso.</p>';
$string['portal:view.actionpending.panel.title'] = 'Modificaciones pendientes';
$string['portal:view.billing.addcc.button'] = 'Guardar arjeta de crédito';
$string['portal:view.billing.addcc.success'] = 'Método de pago guardado exitosamente';
$string['portal:view.billing.panel.empty'] = 'sted no ha hecho compra alguna. Cuando Usted compre un complemento para su sitio MoodleCloud, entonces los detalles de su facturación y la historia de su facturación se mostrarán aquí.';
$string['portal:view.billing.panel.title'] = 'Detalles de tarjeta de crédito';
$string['portal:view.billing.payment.success'] = 'Su pago fue exitoso.';
$string['portal:view.billing.paymentmethod.title'] = 'Método actual de pago';
$string['portal:view.danger.modal.buttons.cancel'] = '¡No, ha sido una completa confusión!';
$string['portal:view.danger.modal.buttons.continue'] = 'Sí, de verdad. Borrar mi sitio MoodleCloud';
$string['portal:view.danger.modal.lead'] = 'Al confirmar abajo, estás confirmando que ya has obtenido todo el contenido, y aceptas que tu sitio será permanentemente borrado de nuestros sistemas.';
$string['portal:view.danger.modal.title'] = 'Confirmar borrado';
$string['portal:view.danger.panel.body.buttons.remove'] = 'Borrar mi sitio de MoodleCloud';
$string['portal:view.danger.panel.body.buttons.title'] = '¿Está Usted seguro de querer dejarnos?';
$string['portal:view.danger.panel.body.lead'] = '<p>Una vez que borres este sitio MoodleCloud, este realmente desaparecerá.</p>
<p>Por favor, asegurate de que has terminado con él y que has obtenido y puesto a salvo cualquier contenido que puedas necesitar.</p>';
$string['portal:view.danger.panel.body.title'] = 'Borrar mi sitio de MoodleCloud';
$string['portal:view.danger.panel.title'] = 'Cosas peligrosas';
$string['portal:view.export.flash'] = 'Ahora mismo estamos exportando su sitio "%subdomain%". Se le enviará un Email cuando el proceso esté completo.';
$string['portal:view.export.panel.body.intro'] = 'El exportar su sitio le dará a Usted la BasedeDatos y todos sus archivos. Usted puede usar esto para alojar su sitio Moodle en su propio servidor o en el servidor de su  <a href="https://moodle.com/partners/">Moodle Partner</a>. Por favor tenga en cuenta que el proceso de esportación tardará un tiempo. Usted recibirá un Email con un enlace para descarga cuando esté listo.';
$string['portal:view.export.panel.body.link'] = 'Su sitio fue exportadao por última vez en  %day% %month% %year%. Usted puede  <a href="%linktobackup%">descargarlo aquí</a>.';
$string['portal:view.export.panel.body.requested'] = 'Su solicitud para exportar su sitio está siendo procesada. Se le enviará un Email cuando la exportación esté disponible para descargarse.';
$string['portal:view.export.panel.button'] = 'Exportar este sitio';
$string['portal:view.export.panel.lead'] = 'Exportar este sitio';
$string['portal:view.export.panel.title'] = 'Datos de su MoodleCloud';
$string['regions:au'] = 'Autralia';
$string['regions:eu'] = 'Irlanda';
$string['regions:us'] = 'Estados Unidos';
$string['signup:auditlog.account.created'] = 'Se creó nueva cuenta de usuario';
$string['signup:auditlog.account.linked'] = 'Enlazado a cuenta existente';
$string['signup:auditlog.account.validated'] = 'Validación completa de cuenta de usuario';
$string['signup:auditlog.account.validationstarted'] = 'Mensaje de validación de cuenta enviado';
$string['signup:auditlog.site.automaticallyconfirmed'] = 'Sitio confirmado sin validación de cuenta';
$string['signup:auditlog.site.provisionQueued'] = 'Sitio puesto en cola para aprovisionamiento';
$string['signup:auditlog.site.provisionmailedout'] = 'Mensaje Email de Aprovisionamiento de finalización enviado';
$string['signup:auditlog.site.reserved'] = 'El sitio fue reservado';
$string['signup:authcode.body.lead_email'] = '¡Revise su buzón de Email! Le hemos enviado un código de verificación temporal a  %email%. Escriba debajo su código de verificación.';
$string['signup:authcode.body.lead_phone'] = 'Hemos mandado un código temporal de verificación a  %phonenumber%. Ingrese debajo su código de verificación.';
$string['signup:authcode.body.links.nocodereceived'] = 'No recibí mi código';
$string['signup:authcode.body.links.startover'] = '¿Desea empezar nuevamente? <a href="%link%">Regresemos al principio</a>.';
$string['signup:authcode.body.title'] = 'Confirma tu número de teléfono.';
$string['signup:authcode.form.fields.authcode'] = 'Código de verificación';
$string['signup:authcode.form.fields.continue'] = 'Continuar';
$string['signup:authcode.form.placeholders.authcode'] = '123456';
$string['signup:authcode.modal.button'] = 'Cerrar';
$string['signup:authcode.modal.lead_email'] = 'Si nuestro mensaje de Email no ha llegado a su buzón o a su carpeta de \'spam\'  (correo no deseado), es posible que lo estemos enviando al lugar equivocado; asegúrese de que se lo estemos enviando a Usted al revisar su dirección Email en la página de verificación (cierre esta caja para verla).';
$string['signup:authcode.modal.lead_phone'] = 'Si nuestro mensaje de texto SMS no ha llegado a su teléfono móvil/celular, es posible que lo estemos enviando al lugar equivocado; asegúrese de que se lo estemos enviando a Usted al revisar su número de teléfono  en la página de verificación (cierre esta caja para verla).';
$string['signup:authcode.modal.link'] = 'Visite las FAQ para más detalles.';
$string['signup:authcode.modal.title'] = 'No recibí mi código';
$string['signup:errors.blacklistinline'] = 'Lo siento, este sitio no está disponible.';
$string['signup:errors.invalidinline'] = 'Lo siento, los nombres de los sitios deben tener entre 3 y 53 caracteres y únicamente pueden estar compuestos de letras (a-z), números y guiones.';
$string['signup:errors.maxsites'] = 'Ya existe una cuenta de usuario con ese número de teléfono. Los usuarios únicamente pueden crear un sitio MoodleCloud.';
$string['signup:errors.mustlogin'] = 'Este número de teléfono está enlazado a una cuenta existente. <a href="%loginurl%">Por favor ingrese</a> o use un número de teléfono diferente.';
$string['signup:errors.reserved'] = '¡Oh no! Alguien ya ha registrado este nombre.';
$string['signup:errors.sessiontimeout'] = 'Debido a inactividad, su sesión se ha desconectado.';
$string['signup:freesitelimit.buttons.buy_a_plan'] = 'Comprar Un Plan';
$string['signup:freesitelimit.buttons.go_to_portal'] = 'Ir al Portal';
$string['signup:freesitelimit.text'] = 'Existe un límite de un sitio gratuito por cuenta y al parecer Usted ya tiene un sitio gratuito.';
$string['signup:freesitelimit.title'] = 'Demasiado de algo bueno';
$string['signup:messages.emailverified'] = '¡Gracias por completar la verificación del Email!';
$string['signup:messages.failedvalidationcode'] = 'Algo no está del todo bien. ¿La has introducido correctamente?';
$string['signup:messages.passwordupdated'] = '¡Genial! Hemos actualizado tu contraseña. Puedes utilizarla para acceder a tu sitio MoodleCloud.';
$string['signup:messages.sessionmoved'] = 'El proceso de creación del sitio ha sido continuado en otra parte y se interrumpió aquí por razones de seguridad.';
$string['signup:messages.validationcode'] = '¡Hola desde MoodleCloud!  Para completar el proceso de configuración de %subdomain%.moodlecloud.com utiliza este código de verificación:  %code%';
$string['signup:nopassword.body.continue'] = 'Siguiente';
$string['signup:nopassword.body.lead'] = '(aquí podría haber un poco de texto)';
$string['signup:nopassword.body.text'] = 'Su contraseña para este sitio es la misma que su cuenta existente de MoodleCloud';
$string['signup:nopassword.body.title'] = 'Asi que, acerca de su contraseña.';
$string['signup:page.description'] = 'Software de aprendizaje gratuito Moodle alojado en servidores en la nube para que profesores e instructores desplieguen sitios Moodle en un instante';
$string['signup:page.title'] = 'MoodleCloud: Registro para Alojamiento Moodle gratuito';
$string['signup:password.body.lead'] = 'Usted usará esta contraseña para ingresar tanto a a su sitio  como al Portal MoodleCloud.';
$string['signup:password.body.title'] = 'Por último, ¡indica tu contraseña!';
$string['signup:password.form.fields.password'] = 'Nueva contraseña';
$string['signup:password.form.fields.password_confirmation'] = 'Y otra vez, solo para estar seguros';
$string['signup:password.form.fields.save'] = 'Guardar contraseña';
$string['signup:payment.body.charges.taxfree'] = 'Usted seleccionó el paquete %package% , plan %plan%. Su pago de (dólares australianos) AUD %costperyear% es para una suscripción de 12 meses a este plan.';
$string['signup:payment.body.charges.withgst'] = 'Usted seleccionó el paquete %package% , plan %plan%. Su pago de (dólares australianos) AUD %costperyear% (incluyendo impuesto GST) es para una suscripción de 12 meses a este plan.';
$string['signup:payment.body.title'] = 'Selecione su método de pago';
$string['signup:payment.form.fields.continue'] = 'Siguiente';
$string['signup:personal.body.lead'] = 'Únicamente necesitamos saber quién eres y estar seguros de que aceptas nuestras Condiciones de Servicio.';
$string['signup:personal.body.title'] = '¡Tu sitio está disponible!';
$string['signup:personal.form.fields.city'] = 'Ciudad';
$string['signup:personal.form.fields.continue'] = 'Continuar';
$string['signup:personal.form.fields.country'] = 'País';
$string['signup:personal.form.fields.email'] = 'Correo electrónico';
$string['signup:personal.form.fields.email_confirmation'] = 'Confirmación de dirección Email';
$string['signup:personal.form.fields.firstname'] = 'Nombre';
$string['signup:personal.form.fields.lastname'] = 'Apellido(s)';
$string['signup:personal.form.fields.marketing'] = 'Deseo recibir novedades de MoodleCloud, sugerencias y actualizaciones.';
$string['signup:personal.form.fields.marketingnote'] = 'Nosotros solamente le enviaremos notificaciones Email cuando estemos avisando de novedades, sugerencias o actualizaciones de cualquiera de nuestros productos. Usted puede des-suscribirse  en cualquier momento. Vea nuestra  <a href="%privacyurl%" target="_blank">Política de Privacidad</a> para más detalles.';
$string['signup:personal.form.fields.organisationname'] = 'Nombre de la Organización';
$string['signup:personal.form.fields.organisationtype.charity'] = 'Beneficiencia';
$string['signup:personal.form.fields.organisationtype.charter_school'] = 'Escuela Autónoma';
$string['signup:personal.form.fields.organisationtype.college'] = 'Colegio';
$string['signup:personal.form.fields.organisationtype.college_department'] = 'Departamento del Colegio';
$string['signup:personal.form.fields.organisationtype.company_course_provider'] = 'Proveedor de curso de Compañía';
$string['signup:personal.form.fields.organisationtype.company_department'] = 'Departamento de Compañía';
$string['signup:personal.form.fields.organisationtype.company_internal'] = 'Interno de Compañía';
$string['signup:personal.form.fields.organisationtype.government'] = 'Gobierno';
$string['signup:personal.form.fields.organisationtype.high_school'] = 'Escuela Secundaria/Preparatoria';
$string['signup:personal.form.fields.organisationtype.high_school_department'] = 'Desprtamento de Escuela Secundaria/Preparatoria';
$string['signup:personal.form.fields.organisationtype.high_school_district'] = 'Distrito de Escuela Secundaria/Preparatoria';
$string['signup:personal.form.fields.organisationtype.independant_teacher'] = 'Profesor independiente';
$string['signup:personal.form.fields.organisationtype.other'] = 'Otro';
$string['signup:personal.form.fields.organisationtype.primary_school'] = 'Escuela Primaria';
$string['signup:personal.form.fields.organisationtype.school_district'] = 'Distrito Escolar';
$string['signup:personal.form.fields.organisationtype.university'] = 'Universidad Completa';
$string['signup:personal.form.fields.organisationtype.university_department'] = 'Departamento de Universidad';
$string['signup:personal.form.fields.organisationtype_label'] = 'Tipo de organización';
$string['signup:personal.form.fields.password'] = 'Contraseña';
$string['signup:personal.form.fields.personalrole'] = 'Su rol';
$string['signup:personal.form.fields.phonenumber'] = 'Teléfono móvil';
$string['signup:personal.form.fields.postcode'] = 'Código Postal';
$string['signup:personal.form.fields.state'] = 'Estado';
$string['signup:personal.form.fields.street'] = 'Dirección';
$string['signup:personal.form.fields.streetaddress'] = 'Dirección';
$string['signup:personal.form.fields.tandc'] = 'Para continuar, primero tienes que aceptar nuestras Condiciones de Servicio.';
$string['signup:personal.form.fields.timezone'] = 'Zona horaria';
$string['signup:personal.form.placeholders.country'] = 'Seleccionar...';
$string['signup:personal.form.placeholders.organisationtype'] = 'Seleccionar...';
$string['signup:personal.form.placeholders.timezone'] = 'Selecciona la zona horaria';
$string['signup:privacy.title'] = 'Política de Privacidad de MoodleCloud';
$string['signup:provision_mail.page.html'] = '<h1>¡Bienvenido a MoodleCloud!</h1>
<p>Tu sitio Moodle gratuito <a href="%url%">%url%</a> ha sido creado.</p>
<p>Puedes acceder a tu sitio Moodle utilizando el nombre de usuario "admin" y la contraseña que configuraste durante el registro.</p>
<p>Tu sitio gratuito está limitado a 50 usuarios activos por cuenta y a 200Mb de espacio en disco.</p>
<p>Consejos:</p>
<ul>
<li>Puedes eliminar usuarios no deseados desde la Administración de Sitio dejando espacio para más.</li>
<li>Para evitar tener contenido reduciendo tu espacio disponible, utiliza recursos públicos que están disponibles en la red, como páginas web, videos de Youtube y similares.</li>
</ul>
<p>Para monitorizar tu uso, en cualquier momento puedes visitar tu portal MoodleCloud en moodlecloud.com. Accede utilizando el nombre de tu sitio "%subdomain%" y la misma contraseña que la de la cuenta "admin" de tu sitio.</p>
<p>Saludos,</p>
<p>El equipo MoodleCloud</p>';
$string['signup:provision_mail.page.plain'] = '¡Bienvenido a MoodleCloud!
Tu sitio Moodle gratuito <a href="%url%">%url%</a> ha sido creado.
Puedes acceder a tu sitio Moodle utilizando el nombre de usuario "admin" y la contraseña que configuraste durante el registro.
Tu sitio gratuito está limitado a 50 usuarios activos por cuenta y a 200Mb de espacio en disco.
Consejos:
  - Puedes eliminar usuarios no deseados desde la Administración de Sitio dejando espacio para más.
  - Para evitar tener contenido reduciendo tu espacio disponible, utiliza recursos públicos que están disponibles en la red, como páginas web, videos de Youtube y similares.

Para monitorizar tu uso, en cualquier momento puedes visitar tu portal MoodleCloud en moodlecloud.com. Accede utilizando el nombre de tu sitio "%subdomain%" y la misma contraseña que la de la cuenta "admin" de tu sitio.

Saludos,
El equipo MoodleCloud';
$string['signup:provision_mail.page.title'] = '¡Tu sitio MoodleCloud %fqdn% está preparado!';
$string['signup:provision_mail.subject'] = '¡Tu sitio MoodleCloud %site.fqdn% está preparado!';
$string['signup:reserve.available'] = '!Hurra! El nombre de tu sitio está disponible.';
$string['signup:reserve.body.lead'] = 'Elige un nombre único para tu sitio y selecciona una localización (en ella es donde tu sitio será alojado, así que te recomendamos que elijas la más próxima a tí y tus estudiantes).';
$string['signup:reserve.body.title'] = '¡Tu sitio MoodleCloud está a solo unos clicks de distancia!';
$string['signup:reserve.form.fields.continue'] = 'Obtener mi sitio';
$string['signup:reserve.form.fields.region'] = 'Localización';
$string['signup:reserve.form.fields.subdomain'] = 'Nombre del sitio';
$string['signup:reserve.form.placeholders.subdomain'] = 'tusitio.moodlecloud.com';
$string['signup:reserve.form.tooltips.region'] = 'La localización es donde tu sitio será alojado. Recomendamos que elijas la más próxima a ti y tus estudiantes.';
$string['signup:signin.body.lead'] = 'Ingresar usando su nombre y contraseña del sitio MoodleCloud.';
$string['signup:signin.body.title'] = 'Ingresar a MoodleCloud para comenzar';
$string['signup:status.body.ariasetupcomplete'] = 'La configuración de tu nuevo sitio se ha completado. Ahora puedes acceder.';
$string['signup:status.body.lead'] = '<p>¡Ha sido rápido!</p>
<p>Lo querías, ahora tienes tu propio sitio Moodle.</p>
<p>Entra y continua creando tu precioso espacio de apredizaje.</p>';
$string['signup:status.body.login'] = 'Acceder';
$string['signup:status.body.title'] = '¡Listo! Tu propio sitio Moodle, ¡gratuito!';
$string['signup:steps.x'] = 'Paso %x%';
$string['signup:steps.xofy'] = 'Paso %x% de %y%';
$string['signup:support.body.notready'] = 'Siéntese, ¡su sitio MoodleCloud ya casi está listo!';
$string['signup:support.body.portal.text'] = 'En su <a href="%portalurl%">Portal de MoodleCloud</a> Usted puede revisar sus paquetes y pagos vigentes, información de facturación y más. Para ingresar al portal, su  <strong>nombre_de_usuario</strong> es la URL de su sitio, y su <strong>contraseña</strong> es su contraseña de administador Moodle. El portal es accesible desde su sitio MoodleCloud o desde moodlecloud.com.';
$string['signup:support.body.portal.title'] = 'Portal';
$string['signup:support.body.support.title'] = 'Soporte';
$string['signup:support.form.fields.continue'] = 'Gracias, ¡ahora lléveme a mi sitio Moodle!';
$string['signup:support.head.lead'] = 'Antes de dirigirse a su nuevo y reluciente sitio Moodle en %siteurl%, nos gustaría comunicarle algunos detalles importantes.';
$string['signup:support.head.lead_paid'] = 'Gracias. Su pago ha sido procesado exitosamente.';
$string['signup:support.head.title'] = '¡Éxito!';
$string['signup:support.link'] = '¡LLéveme ahora a mi sitio MoodleCloud!';
$string['signup:support.partner.link'] = 'Usted puede contactar a su Socio Moodle mediante la <a href="%supporturl%">pestaña de Soporte en su Portal</a>.';
$string['signup:support.partner.title'] = 'Basándonos en la información que Usted nos dió, lo hemos apareado con este Socio Moodle:';
$string['signup:terms.title'] = 'Condiciones de Servicio del sitio MoodleCloud';
$string['signup:texts.statusintro'] = 'TODO';
$string['signup:texts.statustitle'] = 'Lo estabas esperando. Tu propio sitio Moodle, ¡gratuito!';
$string['signup:usertype.body.lead_create'] = '¿Es nuevo en MoodleCloud? Crear ahora una cuenta nueva.';
$string['signup:usertype.body.lead_login'] = '¿Ya tiene un sitio MoodleCloud? Ingrese para conectar sus sitios a una sola cuenta.';
$string['signup:usertype.body.title'] = 'Comencemos';
$string['signup:usertype.form.fields.existing'] = 'Ingresar';
$string['signup:usertype.form.fields.new'] = 'Crear cuenta nueva';
$string['signup:verification_mail.page.title'] = 'Código de verificación MoodleCloud';
$string['signup:verification_mail.subject'] = 'Verificación de cuenta MoodleCloud';
$string['status:label.expired'] = 'Borrado por inactividad';
$string['status:label.pendingIdentityConfirmation'] = 'Pendiente de verificación';
$string['status:label.pendingPayment'] = 'Pago pendiente';
$string['status:label.pendingProvision'] = 'En cola para su creación';
$string['status:label.pendingRemoval'] = 'En cola para su borrado';
$string['status:label.provisioned'] = 'Funcionando';
$string['status:label.removed'] = 'Borrado';
$string['status:label.reserved'] = 'Reservado';
$string['status:tooltip.expired'] = 'Este sitio ha sido borrado de nuestros sistemas por inactividad.';
$string['status:tooltip.pendingIdentityConfirmation'] = 'Este sitio ha sido reservado y una confirmación ha sido enviada vía SMS';
$string['status:tooltip.pendingPayment'] = 'Este sitio ha sido reservado; sin embargo, actualmente el pago está incompleto.';
$string['status:tooltip.pendingProvision'] = 'Este sitio ha sido enviado a nuestros sistemas y estará disponible para tí ¡realmente pronto!';
$string['status:tooltip.pendingRemoval'] = 'Este sitio ha sido programado para ser borrado y pronto desaparecerá de nuestros sistemas de forma completa.';
$string['status:tooltip.provisioned'] = 'Este sitio está actualmente funcionando y disponible.';
$string['status:tooltip.removed'] = 'Este sitio ha sido borrado.';
$string['status:tooltip.reserved'] = 'Este sitio ha sido reservado pero el proceso de registro todavía no se ha completado.';
$string['telephony:lookup.apifailure'] = '¡Oh, no! Algo fue mal con nuestro sistema de mensajes. Por favor, inténtalo de nuevo en unos momentos.';
$string['telephony:lookup.invalidnumber'] = 'Número de teléfono inválido.';
$string['telephony:lookup.notacellphone'] = 'Debes introducir un número válido de teléfono móvil/celular.';
$string['telephony:validator.apifailure'] = '¡Oh, no! Algo fue mal con nuestro sistema de mensajes. Por favor, inténtalo de nuevo en unos momentos.';
$string['validators:billing.ccname.mustexist'] = 'Usted debe de proporcionar el nombre del titular de la tarjeta de crédito.';
$string['validators:fos_user.current_password.invalid'] = 'La contraseña introducida es inválida';
$string['validators:fos_user.email.already_used'] = 'La dirección de email ya está siendo utilizada';
$string['validators:fos_user.email.blank'] = 'Por favor, introduce tu dirección de email';
$string['validators:fos_user.email.invalid'] = 'La dirección de email no es válida';
$string['validators:fos_user.email.long'] = '[-Inf,Inf]La dirección de email es muy larga';
$string['validators:fos_user.email.short'] = '[-Inf,Inf]La dirección de email es muy corta';
$string['validators:fos_user.group.blank'] = 'Por favor, introduce un nombre';
$string['validators:fos_user.group.long'] = '[-Inf,Inf]El nombre es muy largo';
$string['validators:fos_user.group.short'] = '[-Inf,Inf]El nombre es muy corto';
$string['validators:fos_user.new_password.blank'] = 'Por favor, introduce una nueva contraseña';
$string['validators:fos_user.new_password.short'] = '[-Inf,Inf]La nueva contraseña es muy corta';
$string['validators:fos_user.password.blank'] = 'Por favor, introduce una contraseña';
$string['validators:fos_user.password.mismatch'] = 'Las contraseñas introducidas no coinciden';
$string['validators:fos_user.password.short'] = '[-Inf,Inf]La contraseña es muy corta';
$string['validators:fos_user.username.already_used'] = 'El nombre de usuario ya está en uso';
$string['validators:fos_user.username.blank'] = 'Por favor, introduce un nombre de usuario';
$string['validators:fos_user.username.long'] = '[-Inf,Inf]El nombre de usuario es muy largo';
$string['validators:fos_user.username.short'] = '[-Inf,Inf]El nombre de usuario es muy corto';
$string['validators:signup.country.mustexist'] = 'Por favor elija su país';
$string['validators:signup.email.format'] = 'Por favor ingrese una dirección Email válida.';
$string['validators:signup.email.mismatch'] = 'Las direcciones Email que ingresó no coinciden.';
$string['validators:signup.email.mustexist'] = 'Por favor ingrese una dirección Email válida.';
$string['validators:signup.phone.mustexist'] = 'Por favor ingrese su número de teléfono móvil/celular.';
$string['validators:signup.phone.notacellphone'] = 'Por favor proporcione un número de teléfono móvil/celular válido en formato internacional. Nosotros le enviaremos un código de validación a este número.';
$string['validators:signup.phone.wrongformat'] = 'Por favor proporcione su número de telkéfono en formato internacional, comenzando con \'+\' e incluyendo su código de país.';
$string['validators:signup.status.password_length'] = 'Su contraseña debe de tener 5 caracteres o más.';
$string['validators:signup.status.password_mismatch'] = 'Las contraseñas que ingresó no coinciden.';
$string['validators:signup.tandc.mustagree'] = 'Para utilizar el Servicio MoodleCloud debes aceptar las Condiciones de Servicio definidas.';
$string['validators:signup.timezone.mustselect'] = 'Por favor, selecciona tu zona horaria';
$string['validators:site.firstname.mustexist'] = 'Debes especificar tu nombre';
$string['validators:site.lastname.mustexist'] = 'Debes especificar tu apellido(s)';
$string['validators:site.subdomain.format'] = 'El nombre del sitio debe comenzar por una letra. Tiene que contener una combinación de letras, números y guiones únicamente.';
$string['validators:site.subdomain.maxlength'] = 'El nombre del sitio (sin el dominio) debe tener 53 caracteres o menos';
$string['validators:site.subdomain.minlength'] = 'El nombre del sitio (sin el dominio) debe tener por los menos 3 caracteres';
$string['validators:site.subdomain.mustexist'] = 'Debes especificar un nombre del sitio';
