<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'sk', version '4.2'.
 *
 * @package     auth_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = 'Používateľ s týmto používateľským menom už na tomto portáli existuje. Ak sa jedná o váš účet, prihláste sa pomocou svojho používateľského mena a hesla  a pridajte ich ako prepojené prihlasovacie údaje na svojej stránke predvolieb.';
$string['alreadylinked'] = 'Tento externý účet je na tomto portáli už prepojený s účtom';
$string['auth_oauth2description'] = 'Overovanie založené na štandarde OAuth 2';
$string['auth_oauth2settings'] = 'Nastavenie overovania OAuth 2.';
$string['confirmaccountemail'] = 'Dobrý deň {$a->fullname},

Na stránke "{$a->sitename}"  bola zadaná požiadavka na vytvorenie nového používateľského účtu s vašou emailovou adresou.

Potvrďte prosím túto žiadosť na stránke:
{$a->link}

Vo väčšine emailových programov by sa vám táto adresa mala zobraziť ako odkaz, na ktorý stačí kliknúť. Ak to tak nie je, skopírujte si adresu do schránky a vložte ju do adresného riadku vo svojom webovom prehliadači.

Ak potrebujete pomoc, spojte sa so administrátorom servera.

S pozdravom,
{$a->admin}

Ak ste tak neurobili, mohol by sa niekto pokúsiť ohroziť váš účet.
Okamžite kontaktujte administrátora serveru.';
$string['confirmaccountemailsubject'] = '{$a}: potvrdenie účtu';
$string['confirmationinvalid'] = 'Potvrdzovací odkaz je alebo neplatný, alebo platnosť vypršala. Znovu spusťte prihlasovací proces a vygenerujte nový potvrdzovací email.';
$string['confirmationpending'] = 'Tento účet čaká na potvrdenie emailom.';
$string['confirmlinkedloginemail'] = 'Dobrý deň {$a->fullname},

Na stránke "{$a->sitename}"  bola zadaná požiadavka na prepojenie používateľského mena {$a->issuername} a vašej emailovej adresy  {$a->linkedemail}.

Potvrďte prosím túto žiadosť a prepojte tieto prihlasovacie údaje na stránke:
{$a->link}

Vo väčšine emailových programov by sa vám táto adresa mala zobraziť ako odkaz, na ktorý stačí kliknúť. Ak to tak nie je, skopírujte si adresu do schránky a vložte ju do adresného riadku vo svojom webovom prehliadači.

Ak potrebujete pomoc, spojte sa so administrátorom servera.

S pozdravom,
{$a->admin}

Ak ste tak neurobili, mohol by sa niekto pokúsiť ohroziť váš účet.
Okamžite kontaktujte administrátora serveru.';
$string['confirmlinkedloginemailsubject'] = '{$a}: spojený s potvrdením prihlásenia';
$string['createaccountswarning'] = 'Tento overovací modul umožňuje používateľom na vašom portáli vytvárať účty.  Ak použijete tento modul, mali by ste povoliť nastavenie „authpreventaccountcreation“.';
$string['createnewlinkedlogin'] = 'Prepojenie nového účtu ({$a})';
$string['emailconfirmlink'] = 'Prepojiť svoje účty';
$string['emailconfirmlinksent'] = '<p>Bol nájdený existujúci účet s touto emailovou adresou, ale zatiaľ nie je prepojený.</p>
   <p>Pred prihlásením musia byť tieto účty prepojené.</p>
   <p>Email by mal byť zaslaný na vašu adresu, na <b>{$a}</b></p>
   <p>Obsahuje jednoduché inštrukcie na prepojenie vašich účtov.</p>
   <p>Ak máte mať aj ďalej problémy, obráťte sa na administrátora portálu.</p>';
$string['emailpasswordchangeinfo'] = 'Dobrý deň {$a->fullname},

Na stránke "{$a->sitename}" požaduje niekto (pravdepodobne Vy) zmenu hesla.

Vaše heslo však nie je možné obnoviť, pretože používate k prihláseniu účet na inom webe.

Prihláste sa prosím ako predtým pomocou odkazu na prihlasovacej stránke.
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = 'Zmeniť informáciu hesla';
$string['info'] = 'Externý účet';
$string['issuer'] = 'OAuth 2 Service';
$string['issuernologin'] = 'Na prihlásenie nie je možné použiť tohto poskytovateľa';
$string['key'] = 'Kľúč';
$string['linkedlogins'] = 'Prepojiť prihlásenia';
$string['linkedloginshelp'] = 'Pomoc s prepojenými prihláseniami';
$string['loggedin'] = 'Používateľ bol úspešne overený u poskytovateľa.';
$string['loginerror_authenticationfailed'] = 'Proces overovania sa napodaril.';
$string['loginerror_cannotcreateaccounts'] = 'Účet s vašou emailovou adresou nebol nájdený.';
$string['loginerror_invaliddomain'] = 'Na tomto portáli nie je emailová adresa povolená.';
$string['loginerror_nouserinfo'] = 'Neboli vrátené žiadne informácie o používateľovi. Služba OAuth 2 môže byť nesprávne nakonfigurovaná.';
$string['loginerror_userincomplete'] = 'Vrátené informácie o používateľovi neobsahovali používateľské meno a emailovú adresu. Služba OAuth 2 môže byť nesprávne nakonfigurovaná.';
$string['noconfiguredidps'] = 'Neexistujú žiadni nakonfigurovaní poskytovatelia OAuth2.';
$string['noissuersavailable'] = 'Žiadna s nakonfigurovaných služieb OAuth 2 vám neumožňuje prepojiť prihlasovacie účty.';
$string['notenabled'] = 'Ospravedlňujeme sa, modul overovania OAuth 2 nie je povolený';
$string['notloggedindebug'] = 'Pokus o prihlásenie sa nepodaril. Dôvod: {$a}';
$string['notwhileloggedinas'] = 'Prepojené prihlásenia nie je možné spravovať, ak ste prehlásený ako iný používateľ.';
$string['oauth2:managelinkedlogins'] = 'Spravovať vlastné prepojené prihlasovacie účty';
$string['plugindescription'] = 'Tento overovací modul zobrazuje zoznam identít poskytovateľov nakonfigurovaných na prihlasovaciu stránku. Voľba poskytovateľa identity umožňuje používateľov prihlásiť sa identifikačnými údajmi od poskytovateľa OAuth 2.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'Overovanie OAuth 2';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'Tento zásuvný modul je pripojený k podsystému overovania';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Potvrdzovací token.';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Časové razítko vypršania platnosti potvrdzovacieho tokenu.';
$string['privacy:metadata:auth_oauth2:email'] = 'Externý email namapovaný na tento účet.';
$string['privacy:metadata:auth_oauth2:issuerid'] = 'Identifikátor poskytovateľa OAuth 2 pre toto prihlásenie OAuth 2';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'Účty OAuth 2 prepojené s účtom Moodle používateľa.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Označuje časové razítko, kedy bol používateľský účet prepojený s prihlásením OAuth 2.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Časové razítko zmeny tohto záznamu.';
$string['privacy:metadata:auth_oauth2:userid'] = 'ID používateľského účtu, ku ktorému je prepojené prihlasovanie OAuth 2.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'ID používateľa, ktorý tento účet upravil.';
$string['privacy:metadata:auth_oauth2:username'] = 'Externé používateľské meno namapované na tento účet.';
$string['testidplogin'] = 'Otestujte prihlásenie pomocou:';
$string['userinfo'] = 'Používateľské údaje od poskytovateľa:';
$string['value'] = 'Hodnota';
