<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'sk', version '4.2'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcia';
$string['addanotherhint'] = 'Pridať ďalšiu pomôcku';
$string['addcategory'] = 'Pridať kategóriu';
$string['addmorechoiceblanks'] = 'Prázdne miesta pre viac možností';
$string['adminreport'] = 'Správa o možných problémoch v databáze Vašich otázok';
$string['advancedsearchoptions'] = 'Možnosti vyhľadávania';
$string['alltries'] = 'Všetky pokusy';
$string['answer'] = 'Odpoveď';
$string['answers'] = 'Odpovede';
$string['answersaved'] = 'Odpoveď bola uložená';
$string['attemptfinished'] = 'Pokus bol uložený';
$string['attemptfinishedsubmitting'] = 'Pokus bol uložený potvrdením: {$a}';
$string['attemptoptions'] = 'Možnosti pokusov';
$string['availableq'] = 'Dostupný?';
$string['badbase'] = 'Neplatný základ mocniny: {$a}**';
$string['behaviour'] = 'Správanie';
$string['behaviourbeingused'] = 'Je využívané správanie: {$a}';
$string['broken'] = 'Toto je "mŕtvy odkaz", ukazuje na neexistujúci súbor.';
$string['byandon'] = 'používateľom <em>{$a->user}</em> dňa <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Nie je možné kopírovať súbor zálohy';
$string['cannotcreate'] = 'Nie je možné vytvoriť nový záznam v tabuľke pokusov ';
$string['cannotcreatepath'] = 'Nie je možné vytvoriť cestu {$a}';
$string['cannotdeletebehaviourinuse'] = 'Nie je možné vymazať správanie otázok \'{$a}\', pretože už bolo použité v pokusoch testu.';
$string['cannotdeletecate'] = 'Nemôžete vymazať túto kategóriu, pretože je to východzia kategória pre tento obsah.';
$string['cannotdeleteneededbehaviour'] = 'Nie je možné vymazať chovanie otázok \'{$a}\', pretože na ňom závisia iné.';
$string['cannotdeleteqtypeinuse'] = 'Nemôžete vymazať chýbajúci typ otázky \'{$a}\'. V banke otázok sú uložené otázky tohto typu.';
$string['cannotdeleteqtypeneeded'] = 'Nemôžete vymazať chýbajúci typ otázky \'{$a}\'. Existujú iné typy otázok, ktoré na ňom závisia.';
$string['cannotdeletetopcat'] = 'Nie je možné odstrániť najvyššiu kategóriu.';
$string['cannotedittopcat'] = 'Nie je možné upraviť najvyššiu kategóriu.';
$string['cannotenable'] = 'Typ otázky {$a} nie je možné priamo vytvoriť ';
$string['cannotenablebehaviour'] = 'Správanie otázky "{$a}" nemôže byť použité priamo, pretože je určené iba pre vnútornú potrebu systému.';
$string['cannotfindcate'] = 'Nepodarilo sa nájsť záznam v kategórii';
$string['cannotfindquestionfile'] = 'Nepodarilo sa nájsť dátový súbor otázky vo formáte ZIP';
$string['cannotgetdsfordependent'] = 'Nepodarilo sa získať vybraný dataset pre otázku od neho závisiacu (otázka {$a->id}, dataset: {$a->item})';
$string['cannotgetdsforquestion'] = 'Nepodarilo sa získať vybraný dataset pre výpočtovú otázku  (otázka: {$a})';
$string['cannothidequestion'] = 'Nebolo možné skryť otázku';
$string['cannotimportformat'] = 'Prepáčte, ale importovanie tohto formátu nebolo ešte implementované.';
$string['cannotinsertquestion'] = 'Nie je možné vložiť novú otázku';
$string['cannotinsertquestioncatecontext'] = 'Nepodarilo sa vložiť novú kategóriu otázok {$a->cat} nesprávny identifikátor kontextu {$a->ctx}';
$string['cannotloadquestion'] = 'Nepodarilo sa nahrať otázku';
$string['cannotmovequestion'] = 'Nemôžete použiť tento skript pre presun otázok, ktoré majú asociované súbory z rozličných oblastí.';
$string['cannotopenforwriting'] = 'Nie je možné otvoriť {$a} pre zápis';
$string['cannotpreview'] = 'Nemôžete prezrieť tieto otázky';
$string['cannotread'] = 'Nie je možné načítať súbor pre import (alebo je súbor prázdny)';
$string['cannotretrieveqcat'] = 'Nepodarilo sa získať kategóriu otázky';
$string['cannotunhidequestion'] = 'Nepodarilo sa odkryť otázku';
$string['cannotunzip'] = 'Nie je možné rozbaliť súbor.';
$string['cannotwriteto'] = 'Nie je možné exportovať otázky do {$a}';
$string['categories'] = 'Kategórie';
$string['category'] = 'Kategória';
$string['categorycurrent'] = 'Aktuálna kategória';
$string['categorycurrentuse'] = 'Použiť túto kategóriu';
$string['categorydoesnotexist'] = 'Táto kategória neexistuje';
$string['categoryinfo'] = 'Informácie o kategórii';
$string['categorymove'] = 'Kategória \'{$a->name}\' obsahuje {$a->count} otázok.  (niektoré z nich môžu byť  skryté otázky alebo náhodné, ktoré sú aj ďalej používané v niektorom z existujúcich testov). <br />
Vyberte si prosím inú kategóriu, do ktorej ich prenesiete.';
$string['categorymoveto'] = 'Uložiť v kategórii';
$string['categorynamecantbeblank'] = 'Názov kategórie nemôže byť prázdny';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Zmeniť voľby';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategória "{$a->name}"</a> v kurze "{$a->coursename}" zmení svoj status zdieľania z <strong>{$a->changefrom} na {$a->changeto}</strong>.';
$string['check'] = 'Skontrolovať';
$string['chooseqtypetoadd'] = 'Vyberte si typ otázky, ktorú chcete pridať';
$string['clearwrongparts'] = 'Vymazať nesprávne odpovede';
$string['clickflag'] = 'Označiť otázku';
$string['clicktoflag'] = 'Kliknite na označenie tejto otázky pre ďalšie použitie';
$string['clicktounflag'] = 'Odznačiť otázku';
$string['clickunflag'] = 'Odznačiť otázku';
$string['closepreview'] = 'Zatvoriť náhľad';
$string['combinedfeedback'] = 'Kombinovaná spätná väzba';
$string['comment'] = 'Komentár';
$string['commented'] = 'Komentované: {$a}';
$string['commentormark'] = 'Komentujte alebo prepíšte známku';
$string['comments'] = 'Komentáre';
$string['commentx'] = 'Komentár: {$a}';
$string['complete'] = 'Ukončené';
$string['contexterror'] = 'Sem by ste sa nemali dostať. Iba ak presúvate kategóriu do iného kontextu.';
$string['copy'] = 'Kopírovať z {$a} a zmeniť odkazy';
$string['correct'] = 'Správna odpoveď';
$string['correctfeedback'] = 'Pre ľubovoľnú správnu odpoveď';
$string['correctfeedbackdefault'] = 'Vaša odpoveď je správna.';
$string['created'] = 'Vytvorené';
$string['createdby'] = 'Vytvorená ';
$string['createdmodifiedheader'] = 'Vytvorené / naposledy uložené';
$string['createnewquestion'] = 'Vytvoriť novú otázku';
$string['cwrqpfs'] = 'Náhodné otázky z otázok v podkategóriách';
$string['cwrqpfsinfo'] = '<p>Počas aktualizácie Moodle na verziu 1.9 budú rozdelené kategórie otázok do rozdielnych kontextov. U niektorých kategórií sa zmení ich status zdieľania. To sa stane v zriedkavom prípade, že jedna alebo viacero \'náhodných\' otázok v teste je tvorená z podkategórií, v ktorých sú niektoré zdieľané a niektoré nezdieľané (ako je to v prípade Vášho portálu). </p>

<p>Nasledovné kategórie otázok, z ktorých boli vybrané \'náhodné\' otázky, budú mať zmenený status zdieľania na rovnaký, ako má kategória s \'náhodnou\' otázkou pri aktualizácii na 1.9. Otázky, ktoré sa nachádzajú v týchto kategóriách, budú aj ďalej správne fungovať v existujúcich testoch, až kým ich z nich neodstránite.</p>';
$string['cwrqpfsnoprob'] = 'Žiadne kategórie otázok neodpovedajú problému \'náhodné otázky z podkategórií\'.';
$string['decimalplacesingrades'] = 'Desatinné miesta v známkach';
$string['defaultfor'] = 'Východzí pre {$a}';
$string['defaultinfofor'] = 'Východzia kategória pre otázky zdieľané v kontexte \'{$a}\'.';
$string['defaultmark'] = 'Východzia hodnota známky';
$string['defaultmarkmustbepositive'] = 'Predvolená známka musí byť kladná.';
$string['deletecoursecategorywithquestions'] = 'V banke otázok sú otázky asociované s touto kategóriou. Ak budete pokračovať, budú vymazané. Ak potrebujete, najprv ich presuňte použitím rozhrania pre otázky.';
$string['deletequestioncheck'] = 'Naozaj chcete vymazať \'{$a}\'?';
$string['deletequestionscheck'] = 'Naozaj chcete vymazať nasledovné otázky?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Vymazávanie správania otázky \'{$a}\'';
$string['deletingqtype'] = 'Vymazávam \'{$a}\' typ otázky...';
$string['didnotmatchanyanswer'] = '[Nezhoduje sa so žiadnou odpoveďou]';
$string['disabled'] = 'Nepovolené';
$string['displayoptions'] = 'Možnosti zobrazenia';
$string['disterror'] = 'Distribúcia {$a} spôsobila problémy';
$string['donothing'] = 'Nekopírujte alebo nepresúvajte súbory ani nemeňte odkazy.';
$string['editcategories'] = 'Upraviť kategórie';
$string['editcategories_help'] = 'Pri väčšom počte je lepšie roztriediť testové otázky do kategórií a podkategórií.

Každá kategória má svoj kontext, ktorý určuje, kde môžu byť otázky z danej kategórie použité:

* Kontext aktivity - otázky sú dostupné iba v danom module aktivity
* Kontext kurzu - otázky sú dostupné v celom kurze
* Kontext kategórie kurzov - otázky sú dostupné vo všetkých kurzoch v danej kategórii kurzov
* Systémový kontext - otázky sú dostupné vo všetkých kurzoch na portáli

Kategórie otázok se tiež používajú pri práci s náhodne vyberanými otázkami. Tie sa vyberajú vždy z jednej vybranej kategórie otázok.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Upraviť kategóriu';
$string['editingcategory'] = 'Úprava kategórie';
$string['editingquestion'] = 'Úprava otázky';
$string['editquestion'] = 'Upraviť otázku';
$string['editquestions'] = 'Upraviť otázky';
$string['editthiscategory'] = 'Upraviť túto kategóriu';
$string['emptyxml'] = 'Neznáma chyba- prázdny súbor imsmanifest.xml';
$string['enabled'] = 'Povolené';
$string['erroraccessingcontext'] = 'Prístup k kontextu nie je povolený';
$string['errordeletingquestionsfromcategory'] = 'Chyba pri vymazávaní otázok z kategórie {$a}.';
$string['errorduringpost'] = 'Chyba nastala po spracovaní ';
$string['errorduringpre'] = 'Chyba nastala pred spracovaním ';
$string['errorduringproc'] = 'Chyba nastala počas spracovania';
$string['errorduringregrade'] = 'Nepodarilo sa preznámkovať otázku {$a->qid}, zmena na stav {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Chyba pri kopírovaní súboru {$a}.';
$string['errorfilecannotbemoved'] = 'Chyba pri presúvaní súboru {$a}.';
$string['errorfileschanged'] = 'Chyba: súbory odkazované z otázok boli zmenené potom, čo bol zobrazený tento formulár.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Otázka ({$a}) za vyskytuje na viacerých miestach v teste s rozličnými váhami. Toto v súčasnosti nie je podporované štatistickým výkazom a môže byť pre túto otázku nespoľahlivé.';
$string['errormanualgradeoutofrange'] = 'Bodová známka {$a->grade} neleží medzi 0 a {$a->maxgrade} u otázky "{$a->name}". Získané skóre ani komentár neboli uložené.';
$string['errormovingquestions'] = 'Chyba pri presúvaní otázok s identifikátormi {$a}.';
$string['errorpostprocess'] = 'Chyba nastala po spracovaní ';
$string['errorpreprocess'] = 'Chyba nastala pred spracovaním ';
$string['errorprocess'] = 'Chyba nastala počas spracovania';
$string['errorprocessingresponses'] = 'Vyskytla sa chyba pri spracovaní vašich odpovedí \'{$a}\'. Kliknite pre návrat na predchádzajúcu stránku a pokúste sa ich odoslať opäť.';
$string['errorsavingcomment'] = 'Chyba pri ukladaní komentára u otázky {$a->name} do databázy.';
$string['errorsavingflags'] = 'Vyskytla sa chyba pri ukladaní označenia.';
$string['errorupdatingattempt'] = 'Chyba pri aktualizácii pokusu id {$a->id} v databáze.';
$string['eventquestioncategorycreated'] = 'Kategória otázok bola vytvorená';
$string['eventquestioncategorydeleted'] = 'Kategória otázok bola vymazaná';
$string['eventquestioncategorymoved'] = 'Kategória otázok bola presunutá';
$string['eventquestioncategoryupdated'] = 'Kategória otázok bola aktualizovaná';
$string['eventquestioncategoryviewed'] = 'Kategória otázok bola zobrazená';
$string['eventquestioncreated'] = 'Otázka bola vytvorená';
$string['eventquestiondeleted'] = 'Otázka bola vymazaná';
$string['eventquestionmoved'] = 'Otázka bola presunutá';
$string['eventquestionsexported'] = 'Otázka bola exportovaná';
$string['eventquestionsimported'] = 'Otázka bola importovaná';
$string['eventquestionupdated'] = 'Otázka bola aktualizovaná';
$string['eventquestionviewed'] = 'Otázka bola zobrazená';
$string['export'] = 'Export';
$string['exportasxml'] = 'Exportovať ako Moodle XML';
$string['exportcategory'] = 'Exportovať kategóriu';
$string['exportcategory_help'] = '<p align="center"><b>Exportovať kategóriu</b></p>

<p><b>Kategória:</b> na výber kategórie, z ktorej budú vyberané exportné otázky, sa používa rozbaľovací zoznam.</p>

<p>Niektoré importné formáty (GIFT a XML formát) povoľujú, aby bola kategória zahrnutá v zapísanom súbore, umožňujúce pri importe obnoviť kategórie alebo definovať, do ktorej kategórie sa majú otázky importovať. Aby sa to uskutočnilo musí byť zaškrtnuté pole <b>do súboru</b>.</p>';
$string['exporterror'] = 'Vyskytla sa chyba počas exportu';
$string['exportfilename'] = 'test';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Stiahnuť túto otázku vo formáte XML Moodle';
$string['exportquestions'] = 'Exportovať otázky do súboru';
$string['exportquestions_help'] = 'Táto funkcia Vám umožňuje export celej kategórie (a všetky jej podkategórie) otázok do  súboru. Upozornenie: u väčšiny formátov súborov sa pri exporte úloh niektoré informácie stratia. ';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Spätná väzba';
$string['filecantmovefrom'] = 'Súbory otázok nemôžu byť presunuté, pretože nemáte oprávnenie odstrániť súbory zo zdrojového umiestnenia.';
$string['filecantmoveto'] = 'Súbory otázok nemôžu byť presunuté alebo skopírované, pretože nemáte oprávnenie pridať súbory do cieľového umiestnenia.';
$string['fileformat'] = 'Formát súboru';
$string['filesareacourse'] = 'miesto pre súbory kurzu';
$string['filesareasite'] = 'miesto pre súbory portálu';
$string['filestomove'] = 'Presunúť / kopírovať súbory do {$a}?';
$string['fillincorrect'] = 'Vyplniť správne odpovede';
$string['filterbytags'] = 'Filtrovať podľa štítkov ...';
$string['firsttry'] = 'Prvý pokus';
$string['flagged'] = 'Označené';
$string['flagthisquestion'] = 'Označiť túto otázku';
$string['formquestionnotinids'] = 'Formulár obsahoval otázku, ktorá nemá správny identifikátor';
$string['fractionsnomax'] = 'Jedna alebo viac odpovedí má mať bodovanie 100%, aby bolo možné dosiahnuť plné bodovanie za túto otázku!';
$string['generalfeedback'] = 'Všeobecná spätná väzba';
$string['generalfeedback_help'] = 'Všeobecná spätná väzba je zobrazená študentovi po vyriešení otázky. Na rozdiel od špecifickej spätnej väzby, ktorá sa líši podľa typu otázky a odpovedi študenta, je všeobecná spätná väzba zobrazená všetkým študentom. Môže napr. obsahovať vysvetlenie správnej odpovede, odkaz na ďalšie informácie pre záujemcov a pod.';
$string['getcategoryfromfile'] = 'Získať kategóriu zo súboru';
$string['getcontextfromfile'] = 'Získať kontext zo súboru';
$string['hintn'] = 'Pomôcka {#}';
$string['hintnoptions'] = 'Možnosti nápovedy {no}';
$string['hinttext'] = 'Text pomôcky';
$string['howquestionsbehave'] = 'Ako sa otázky správajú';
$string['howquestionsbehave_help'] = 'Študenti môžu s otázkami v teste interagovať rôznymi spôsobmi. Môžete napríklad chcieť, aby študenti zadali odpoveď na každú otázku a potom odoslali celý test skôr, ako bude čokoľvek ohodnotené alebo dostanú spätnú väzbu. Bol by to režim „Odložená spätná väzba“.

Prípadne si môžete želať, aby študenti odoslali každú otázku za pochodu, aby získali okamžitú spätnú väzbu, a ak sa im to nepodarí okamžite, majú ďalší pokus s menším počtom bodov. Bol by to režim „Interaktívny s viacerými pokusmi“.

Toto sú pravdepodobne dva najčastejšie používané spôsoby správania.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ID číslo';
$string['idnumber_help'] = 'Ak je použité, ID číslo musí byť v každej kategórii otázky jedinečné. Poskytuje iný spôsob ako identifikovať otázku, ktorá je niekedy užitočná, ale môže byť spravidla prázdna.';
$string['ignorebroken'] = 'Ignorovať chybné odkazy';
$string['import'] = 'Import';
$string['importcategory'] = 'Importovať kategóriu';
$string['importcategory_help'] = '<p><b>Kategória:</b> na výber kategórie, do ktorej budú importované otázky, je použitý rozbaľovací zoznam.</p>

<p>Niektoré import formáty (GIFT a XML formát) povoľujú špecifikovanie kategórie vo vnútri importovaného súboru. Na to musí byť zaškrtnuté pole <b>zo súboru</b>. Ak nie je, otázky budú pridelené do vybranej kategórie bez ohľadu na inštrukcie v súbore.</p>

<p>Neexistujúce kategórie špecifikované v importovanom súbore budú vytvorené.</p>';
$string['importerror'] = 'Pri spracovaní importu sa vyskytla chyba';
$string['importerrorquestion'] = 'Chyba pri importe otázky';
$string['importfromcoursefiles'] = '... alebo vyberte pre import súbor kurzu';
$string['importfromupload'] = 'Vyberte súbor na nahranie ...';
$string['importingquestions'] = 'Importuje sa {$a} otázok zo súboru';
$string['importparseerror'] = 'Pri importe súboru sa vyskytla jedna alebo viac chýb. Pre import aspoň niektorých otázok sa vráťte a zmeňte nastavenie „Zastaviť pri chybe“ na „Ne“.';
$string['importquestions'] = 'Importovať otázky zo súboru';
$string['importquestions_help'] = 'Táto funkcia umožňuje import otázok v rozličných formátoch pomocou textového súboru. Tento musí byť v kódovaní UTF-8.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Vybraný súbor nie je v kódovaní znakov UFT-8. {$a} súbory musia používať UTF-8.';
$string['importwrongfiletype'] = 'Typ súboru ({$a->actualtype}) neodpovedá očakávanému typu ({$a->expectedtype}).';
$string['impossiblechar'] = 'Nesprávny znak {$a} bol zistený ako zátvorka';
$string['includesubcategories'] = 'Zobraziť tiež otázky z podkategórií';
$string['incorrect'] = 'Nesprávna odpoveď';
$string['incorrectfeedback'] = 'Pre akúkoľvek nesprávnu odpoveď';
$string['incorrectfeedbackdefault'] = 'Vaša odpoveď nie je správna.';
$string['information'] = 'Informácia';
$string['invalidanswer'] = 'Nekompletná odpoveď';
$string['invalidarg'] = 'Neboli dodané správne argumenty alebo je nesprávna konfigurácia servera';
$string['invalidcategoryidforparent'] = 'Nesprávny identifikátor kategórie pre nadradenú kategóriu!';
$string['invalidcategoryidtomove'] = 'Nesprávny identifikátor kategórie pre presun!';
$string['invalidconfirm'] = 'Potvrdzujúci reťazec bol nesprávny';
$string['invalidcontextinhasanyquestions'] = 'Nesprávny kontext zaslaný do question_context_has_any_questions.';
$string['invalidgrade'] = 'Známky ({$a}) neodpovedajú očakávanému typu známok. Tato otázka bola preskočená.';
$string['invalidpenalty'] = 'Neplatná penalizácia';
$string['invalidwizardpage'] = 'Bola zadaná nesprávna alebo žiadna stránka so sprievodcom.';
$string['lastmodifiedby'] = 'Naposledy upravené';
$string['lasttry'] = 'Posledný pokus';
$string['linkedfiledoesntexist'] = 'Odkazovaný súbor {$a} neexistuje';
$string['makechildof'] = 'Vytvoriť potomka z \'{$a}\'';
$string['makecopy'] = 'Vytvoriť kópiu';
$string['maketoplevelitem'] = 'Presunúť do najvyššej úrovne';
$string['manualgradeinvalidformat'] = 'Toto nie je platné číslo';
$string['manualgradeoutofrange'] = 'Hodnotenie je mimo povoleného rozsahu';
$string['manuallygraded'] = 'Manuálne hodnotenie {$a->mark} s komentárom: {$a->comment}';
$string['mark'] = 'Hodnotenie';
$string['markedoutof'] = 'Max. hodnotenie';
$string['markedoutofmax'] = 'Max. hodnotenie {$a}';
$string['markoutofmax'] = 'Známka {$a->mark} z {$a->max}';
$string['marks'] = 'Hodnotenia';
$string['matchgrades'] = 'Súhlas známok';
$string['matchgrades_help'] = 'Importované známky sa musia zhodovať s jednou nasledovných: 100, 90, 80, 75, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (aj záporné hodnoty).

Ak nie, sú dve možnosti:

* Ak známka nie je v zozname, bude hlásená chyba -
Ak otázka zahŕňa známky, ktoré nie sú v zozname, zobrazí sa hlásenie chyby a otázka nebude importovaná
* Ak nie je v zozname, použi najbližšiu hodnotu - Ak sa zistí, že známka sa nezhoduje s hodnotami v zozname, známka je zmenená na najbližšiu hodnotu v zozname.';
$string['matchgradeserror'] = 'Ak hodnotenie nie je uvedené, nahlásiť chybu';
$string['matchgradesnearest'] = 'Ak hodnotenie nie je uvedené, použiť najbližšiu';
$string['missingcourseorcmid'] = 'Je potrebné poskytnúť courseid alebo cmid do funkcie print_question.';
$string['missingcourseorcmidtolink'] = 'Je potrebné poskytnúť courseid alebo cmid do funkcie get_question_edit_link.';
$string['missingimportantcode'] = 'Tomuto typu otázky chýba dôležitý kód: {$a}.';
$string['missingoption'] = 'Cloze otázke {$a} chýbajú jej možnosti';
$string['modified'] = 'Naposledy uložené';
$string['move'] = 'Presunúť z {$a} a zmeniť odkazy.';
$string['movecategory'] = 'Presunúť kategóriu';
$string['movedquestionsandcategories'] = 'Presunuté otázky a kategórie otázok z {$a->oldplace} do {$a->newplace}.';
$string['movelinksonly'] = 'Zmeňte iba miesto, kam odkaz ukazuje, nepresúvajte ani nekopírujte súbory.';
$string['moveq'] = 'Presunúť otázky';
$string['moveqtoanothercontext'] = 'Presunúť otázku do iného kontextu.';
$string['moveto'] = 'Presunúť do';
$string['movingcategory'] = 'Presunutie kategórie';
$string['movingcategoryandfiles'] = 'Naozaj chcete presunúť kategóriu {$a->name} a všetky podriadené kategórie do kontextu "{$a->contextto}"?<br /> Bolo zistených  {$a->urlcount} súborov odkazovaných z otázok v {$a->fromareaname}, chceli by ste ich skopírovať alebo presunúť do {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Naozaj chcete presunúť kategóriu "{$a->name}" a všetky podriadené kategórie do kontextu "{$a->contextto}"?';
$string['movingquestions'] = 'Presúvanie otázok a akýchkoľvek súborov';
$string['movingquestionsandfiles'] = 'Naozaj chcete presunúť otázky  {$a->questions} do kontextu <strong>"{$a->tocontext}"</strong>?<br /> Bolo zistených  <strong>{$a->urlcount} súborov</strong> odkazovaných z otázok v {$a->fromareaname}, chceli by ste ich skopírovať alebo presunúť do {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Naozaj chcete presunúť otázky  {$a->questions} do kontextu <strong>"{$a->tocontext}"</strong>?<br /> Nie sú <strong>žiadne</strong> súbory odkazované z otázok v {$a->fromareaname}.';
$string['needtochoosecat'] = 'Potrebujete vybrať kategóriu, do ktorej presuniete otázku. Alebo stlačte \'zrušiť\'.';
$string['nocate'] = 'Žiadna takáto kategória {$a}!';
$string['nopermissionadd'] = 'Nemáte oprávnenia pridávať otázky';
$string['nopermissionedit'] = 'Nemáte oprávnenie upravovať tieto otázky.';
$string['nopermissionmove'] = 'Nemáte oprávnenia odtiaľto presúvať otázky. Musíte otázku uložiť v tejto kategórii alebo ako novú otázku.';
$string['noprobs'] = 'Vo Vašej databáze otázok neboli zistené žiadne problémy.';
$string['noquestionbanks'] = 'Nebol nájdený žiadny doplnok banky otázok.';
$string['noquestions'] = 'Neboli nájdené žiadne otázky, ktoré by bolo možné exportovať Vybrali ste správnu kategóriu?';
$string['noquestionsinfile'] = 'Importovaný súbor neobsahuje žiadne úlohy.';
$string['noresponse'] = '[Žiadna odozva]';
$string['notagfiltersapplied'] = 'Neboli použité žiadne filtre štítkov';
$string['notanswered'] = 'Nezodpovedané';
$string['notchanged'] = 'Nezmenené od posledného pokusu';
$string['notenoughanswers'] = 'Tento typ otázky vyžaduje minimálne {$a} odpovede';
$string['notenoughdatatoeditaquestion'] = 'Nebol špecifikovaný ani ID otázky, ani ID kategórie ani typ otázky.';
$string['notenoughdatatomovequestions'] = 'Potrebujete zadať ID otázok, ktoré chcete presunúť.';
$string['notflagged'] = 'Neoznačená';
$string['notgraded'] = 'Nehodnotené';
$string['notshown'] = 'Nezobraziť';
$string['notyetanswered'] = 'Ešte nezodpovedané';
$string['notyourpreview'] = 'Tento náhľad Vám neprináleží';
$string['novirtualquestiontype'] = 'Pre otázku typu {$a} neexistuje virtuálna kategória';
$string['numqas'] = 'Počet odpovedí';
$string['numquestions'] = 'Počet otázok';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} hidden +{$a->numdraft} draft)';
$string['options'] = 'Voľby';
$string['page-question-category'] = 'Stránka kategórií otázok';
$string['page-question-edit'] = 'Stránka úpravy otázok';
$string['page-question-export'] = 'Stránka exportu otázok';
$string['page-question-import'] = 'Stránka importu otázok';
$string['page-question-x'] = 'Stránka akejkoľvek otázky';
$string['parent'] = 'Rodič';
$string['parentcategory'] = 'Nadradená kategória';
$string['parentcategory_help'] = '<h2>Nadradená kategória</h2>

<p>Kategória, v ktorej je umiestnená aktuálna kategória. \'Vrch\' znamená, že táto kategória nie je podradenou v žiadnej inej kategórii.</p>

<p>Normálne uvidíte viaceré kontexty kategórií tučným písmom. Každý kontext obsahuje vlastnú hierarchiu kategórií. Ak kontexty nevidíte, tak nemáte na to oprávnenie. </p>

<p>Ak v kontexte existuje iba jedna kategória, nebudete schopní ju presunúť - v každom kontexte musí byť minimálne jedna. </p>

<p>Viď tiež:</p>
<ul>
  <li><a href="help.php?module=question&amp;file=categories.html">Kategórie otázok</a></li>
  <li><a href="help.php?module=question&amp;file=categorycontexts.html">Kontexty kategórií</a></li>
  <li><a href="help.php?module=question&amp;file=permissions.html">Oprávnenia k otázkam</a></li>
</ul>';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Zátvorka pred ** nie je správne uzavretá v {$a}**';
$string['parenthesisinproperstart'] = 'Zátvorka pred ** nie je správne otvorená v {$a}**';
$string['parsingquestions'] = 'Spracovávam otázky z importného súboru.';
$string['partiallycorrect'] = 'Čiastočne správna odpoveď';
$string['partiallycorrectfeedback'] = 'Pre ľubovoľnú čiastočne správnu odpoveď';
$string['partiallycorrectfeedbackdefault'] = 'Vaša odpoveď je čiastočne správna.';
$string['penaltyfactor'] = 'Trestný faktor';
$string['penaltyfactor_help'] = '<p>Môžete špecifikovať, aká veľká časť dosiahnutého skóre by mala byť odčítaná za každú nesprávnu odpoveď. Táto možnosť je relevantná, ak je v teste povolený adaptívny režim, takže študenti majú povolené na danú úlohu odpovedať opakovane. Trestný faktor by malo byť číslo medzi 0 a 1. Trestný faktor 1 znamená, že študent musí odpovedať správne pri prvom pokuse, aby za otázku dostal vôbec nejaké body. Trestný faktor 0 znamená, že študent môže skúsiť odpovedať koľkokrát chce a vždy dostane plný počet bodov.</p>';
$string['penaltyforeachincorrecttry'] = 'Penalizácia pre každý nesprávny pokus';
$string['penaltyforeachincorrecttry_help'] = 'Keď sú otázky spustené pomocou správania „Interaktívny s viacerými pokusmi“ alebo „Adaptívny režim“, takže študent bude mať niekoľko pokusov, aby otázku dostal správne, potom táto možnosť riadi, koľko budú penalizované za každý nesprávny pokus.

Penalizácia je pomerná časť celkového hodnotenia otázky, takže ak má otázka hodnotu troch bodov a penalizácia je 0,3333333, potom študent získa 3, ak otázku odpovie správne na prvý raz, 2, ak ju odpovie správne na druhý pokus, a 1 z nich sa to podarí na tretí pokus.

V prípade niektorých otázok s viacerými časťami sa táto logika bodovania aplikuje samostatne na každú časť otázky. Podrobnosti závisia od typu otázky a môžu byť komplikované, ale zásadou je čo najspravodlivejšie priznať študentom uznanie za vedomosti, ktoré preukázali.';
$string['permissionedit'] = 'Upraviť túto otázku';
$string['permissionmove'] = 'Presunúť túto otázku';
$string['permissionsaveasnew'] = 'Uložiť ako novú otázku';
$string['permissionto'] = 'Máte oprávnenie na:';
$string['previewquestion'] = 'Zobraziť náhľad otázky: {$a}';
$string['privacy:metadata:database:question'] = 'Podrobnosti o konkrétnej otázke.';
$string['privacy:metadata:database:question:createdby'] = 'Osoba, ktorá vytvorila otázku';
$string['privacy:metadata:database:question:generalfeedback'] = 'Všeobecná spätná väzba pre túto otázku.';
$string['privacy:metadata:database:question:modifiedby'] = 'Osoba, ktorá túto otázku naposledy aktualizovala.';
$string['privacy:metadata:database:question:name'] = 'Názov otázky.';
$string['privacy:metadata:database:question:questiontext'] = 'Text otázky.';
$string['privacy:metadata:database:question:timecreated'] = 'Dátum a čas vytvorenia otázky.';
$string['privacy:metadata:database:question:timemodified'] = 'Dátum a čas úpravy otázky.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Kroky pokusu otázky môžu mať k tomuto kroku ďalšie údaje. Údaje sú uložené v tabuľke step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Názov položky údajov.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Hodnota položky údajov.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Každý pokus otázky má viacero krokov pre označenie jednotlivých fáz od začiatku až po dokončenie. Táto tabuľka ukladá informácie pre každý z týchto krokov.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Známka, ktorá bola udelená tejto otázke, bola zmenená na hodnotu z maxima 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Stav tohto kroku pokusu otázky na konci kroku prechodu.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Dátum a čas, kedy začal tento krok prechodu.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Používateľ, ktorý uskutočnil krok prechodu.';
$string['privacy:metadata:database:question_attempts'] = 'Informácia o pokuse v danej otázke.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Označenie, že používateľ túto úlohu označil v rámci pokusu.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Zhrnutie odpovede na otázku.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Čas aktualizácie pokusu otázky.';
$string['privacy:metadata:database:question_bank_entries'] = 'Podrobnosti o konkrétnej položke v banke otázok.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'Osoba, ktorá vlastní túto položku v banke otázok.';
$string['privacy:metadata:link:qbehaviour'] = 'Subsystém Otázky používa zásuvný modul Správanie otázok.';
$string['privacy:metadata:link:qformat'] = 'Subsystém Otázky používa zásuvný modul Formát otázok pre import a export otázok v rozličných formátoch.';
$string['privacy:metadata:link:qtype'] = 'Subsystém Otázky používa zásuvný modul Typy otázok, ktorý obsahuje rozličné typy otázok.';
$string['published'] = 'zdieľaná';
$string['qbanknotfound'] = 'Doplnok banky otázok \'{$a}\' neexistuje alebo nie je rozpoznaný.';
$string['qtypeveryshort'] = 'T';
$string['question_version'] = 'Verzia otázky';
$string['questionaffected'] = '<a href="{$a->qurl}">Otázka "{$a->name}" ({$a->qtype})</a> je zaradená v tejto kategórii otázok. Zároveň je tiež použitá v <a href="{$a->qurl}"> teste "{$a->quizname}"</a> v kurze "{$a->coursename}".';
$string['questionbank'] = 'Banka otázok';
$string['questionbanknavigation'] = 'Terciárna navigácia banky otázok';
$string['questionbehaviouradminsetting'] = 'Nastavenia správania otázok';
$string['questionbehavioursdisabled'] = 'Správania otázok na deaktiváciu';
$string['questionbehavioursdisabledexplained'] = 'Zadajte čiarkami oddelený zoznam chovania otázok, ktoré nechcete zobraziť v menu.';
$string['questionbehavioursorder'] = 'Poradie správania otázok';
$string['questionbehavioursorderexplained'] = 'Zadajte čiarkami oddelený zoznam chovania otázok, v akom poradí sa majú objaviť v menu.';
$string['questioncategories'] = 'Kategórie otázok';
$string['questioncategory'] = 'Kategória otázok';
$string['questioncatsfor'] = 'Kategórie otázok v kontexte \'{$a}\'';
$string['questiondoesnotexist'] = 'Táto otázka neexistuje';
$string['questionformtagheader'] = '{$a} štítky';
$string['questionidmismatch'] = 'Nesúhlasia identifikátory otázok';
$string['questionloaderror'] = 'Nepodarilo sa načítať možnosti otázky.';
$string['questionname'] = 'Názov otázky';
$string['questionnamecopy'] = '{$a} (kópia)';
$string['questionno'] = 'Otázka {$a}';
$string['questionpreviewdefaults'] = 'Predvolené nastavenia zobrazenia náhľadu otázky';
$string['questionpreviewdefaults_desc'] = 'Pri prvom náhľade otázky z banky otázok sú použité tieto východzie hodnoty. Po prvom zobrazení náhľadu otázky používateľom sú jeho osobné preferencie uložené ako používateľské predvoľby.';
$string['questions'] = 'Otázky';
$string['questionsaveerror'] = 'Nastala chyba počas ukladania otázky - ({$a})';
$string['questionsinuse'] = '(* Úlohy označené hviezdičkou sú už niekde použité, napríklad v testoch. Ak teda budete pokračovať, nebudú tieto otázky naozaj vymazané iba budú skryté.)';
$string['questionsmovedto'] = 'Otázky, ktoré sú stále používané, boli presunuté do "{$a}" v nadradenej kategórii.';
$string['questionsrescuedfrom'] = 'Otázky uložené z kontextu {$a}.';
$string['questionsrescuedfrominfo'] = 'Tieto otázky (niektoré z nich môžu byť skryté) boli uložené, keď bol vymazaný kontext {$a}, pretože sú využívané v testoch alebo iných aktivitách.';
$string['questiontags'] = 'Štítky otázok';
$string['questiontext'] = 'Text otázky';
$string['questiontype'] = 'Typ otázky';
$string['questionuse'] = 'Použiť otázku v tejto aktivite';
$string['questionvariant'] = 'Variant otázky';
$string['questionx'] = 'Otázka {$a}';
$string['requiresgrading'] = 'Vyžaduje hodnotenie';
$string['responsehistory'] = 'História odpovedí';
$string['restart'] = 'Začať znova';
$string['restartwiththeseoptions'] = 'Začať znova s týmito voľbami';
$string['restoremultipletopcats'] = 'Záložný súbor obsahuje viac ako jednu kategóriu najvyššej úrovne pre kontext {$a}.';
$string['reviewresponse'] = 'Zobraziť spätnú väzbu';
$string['rightanswer'] = 'Správna odpoveď';
$string['rightanswer_help'] = 'Automaticky zobrazené zhrnutie správnej odpovede. Jeho rozsah býva spravidla obmedzený, a ak nestačí, je vhodné miesto toho zvážiť vysvetliť správne riešenie v rámci "Všeobecná spätná väzba" a túto možnosť vypnúť.';
$string['save'] = 'Uložiť';
$string['savechangesandcontinueediting'] = 'Uložiť zmeny a pokračovať v úpravách';
$string['saved'] = 'Uložené: {$a}';
$string['saveflags'] = 'Uložiť stav označenia';
$string['selectacategory'] = 'Zvoľte kategóriu:';
$string['selectaqtypefordescription'] = 'Zvoľte typ otázky pre zobrazenie jej opisu';
$string['selectcategoryabove'] = 'Vybrať kategóriu z uvedených';
$string['selectquestionsforbulk'] = 'Zvoľte otázky pre hromadné akcie';
$string['settingsformultipletries'] = 'Nastavenia pre viaceré pokusy';
$string['shareincontext'] = 'Zdieľať kontext pre {$a}';
$string['showhidden'] = 'Zobraziť aj staré otázky';
$string['showmarkandmax'] = 'Zobraziť známku a maximum';
$string['showmaxmarkonly'] = 'Zobraziť iba známku';
$string['shown'] = 'Zobraziť';
$string['shownumpartscorrect'] = 'Zobraziť počet správnych odpovedí';
$string['shownumpartscorrectwhenfinished'] = 'Zobraziť počet správnych odpovedí';
$string['showquestiontext'] = 'Zobraziť text otázky v zozname otázok';
$string['specificfeedback'] = 'Špecifická spätná väzba';
$string['specificfeedback_help'] = 'Spätná väzba, ktorá závisí na odpovedi študenta';
$string['started'] = 'Začaté';
$string['state'] = 'Stav';
$string['step'] = 'Krok';
$string['steps'] = 'Kroky';
$string['stoponerror'] = 'Zastaviť proces kôli chybe';
$string['stoponerror_help'] = 'Toto nastavenie určuje, či import zastaví na chybe, takže sa neimportujú žiadne otázky, alebo či sa chybné otázky budú ignorovať a správne budú naimportované.';
$string['submissionoutofsequence'] = 'Prístup mimo poradia. Pri riešení testu prosím neklikajte na tlačíidlo späť.';
$string['submissionoutofsequencefriendlymessage'] = 'Zadali ste vstup mimo poradia. Táto situácia môže nastať, keď používate tlačíidlá prehliadača Dozadu alebo Dopredu; počas testu ich prosím nepoužívajte. Môže sa to stať, ak kliknete na niečo pri načítavaní. Pokračujte kliknutím na tlačidlo <strong> Pokračovať </strong> .';
$string['submit'] = 'Odoslať';
$string['submitandfinish'] = 'Odoslať a ukončiť';
$string['submitted'] = 'Odoslať: {$a}';
$string['tagarea_question'] = 'Otázky';
$string['technicalinfo'] = 'Technické informácie';
$string['technicalinfo_help'] = 'Táto technická informácia je pravdepodobne užitočná iba pre vývojárov, ktorí pracujú na nových typoch otázok. Môže to byť tiež užitočné pri diagnostike problémov s otázkami.';
$string['technicalinfomaxfraction'] = 'Maximálny podiel: {$a}';
$string['technicalinfominfraction'] = 'Minimálny podiel: {$a}';
$string['technicalinfoquestionsummary'] = 'Zhrnutie otázky: {$a}';
$string['technicalinforesponsesummary'] = 'Prehľad odpovedí: {$a}';
$string['technicalinforightsummary'] = 'Zhrnutie správnej odpovede: {$a}';
$string['technicalinfostate'] = 'Stav otázky: {$a}';
$string['technicalinfovariant'] = 'Variant otázky: {$a}';
$string['tofilecategory'] = 'Zapísať kategóriu do súboru';
$string['tofilecontext'] = 'Zapísať kontext do súboru';
$string['topfor'] = 'Najlepšie pre {$a}';
$string['uninstallbehaviour'] = 'Odinštalovať toto správanie otázok.';
$string['uninstallqtype'] = 'Odinštalovať tento typ otázok';
$string['unknown'] = 'Neznámy';
$string['unknownbehaviour'] = 'Neznáme správanie: {$a}.';
$string['unknownorunhandledtype'] = 'Neznámy alebo neošetrený typ otázky: {$a}.';
$string['unknownquestion'] = 'Neznáma otázka: {$a}.';
$string['unknownquestioncatregory'] = 'Neznáma kategória otázok: {$a}.';
$string['unknownquestiontype'] = 'Neznámy typ otázky: {$a}.';
$string['unknowntolerance'] = 'Neznámy typ presnosti {$a}';
$string['unpublished'] = 'nezdieľaná';
$string['unusedcategorydeleted'] = 'Táto kategória bola vymazaná, pretože po vymazaní kurzu sa otázky použité v tejto kategórii už viac nepoužili na serveri.';
$string['updatedisplayoptions'] = 'Aktualizovať možnosti zobrazenia';
$string['upgradeproblemcategoryloop'] = 'Pri aktualizácii kategórií otázok sa vyskytol problém. V systéme kategórií je uzavretá slučka. Identifikátory kategórií, ktorých sa tento problém dotýka, sú {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Nepodarilo sa aktualizovať kategóriu otázok {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Pri aktualizácii kategórií otázok sa vyskytol problém. Kategória {$a->id} sa odkazuje na nadradenú kategóriu {$a->parent}, ktorá neexistuje. Nadradená kategória bola zmenená.';
$string['whethercorrect'] = 'Či je správna';
$string['whethercorrect_help'] = 'Týka sa informácií o správnosti odpovede ("Správne", "Čiastočne správne" a "Nesprávne") a akéhokoľvek zvýrazneného textu, ktorý poskytuje tú istú informáciu.';
$string['whichtries'] = 'Ktorý pokus';
$string['withselected'] = 'S vybranými';
$string['wrongprefix'] = 'Nesprávne formátovaný prefix názvu {$a}';
$string['xoutofmax'] = '{$a->mark} z {$a->max}';
$string['yougotnright'] = 'Vybrali ste správne {$a->num}.';
$string['youmustselectaqtype'] = 'Musíte zvoliť typ otázky';
$string['yourfileshoulddownload'] = 'Váš vyexportovaný súbor sa začne čoskoro sťahovať. Ak nie, prosím <a href="{$a}">kliknite sem</a>.';
