<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'sr_lt', version '4.2'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Pregledajte sve kurseve';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Još uvek niste upisani ni na jedan kurs.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Pregledajte sve dostupne kurseve i započnite sa učenjem.';
$string['addon.block_myoverview.noresult'] = 'Vaša pretraga se ne podudara ni sa jednim kursom.';
$string['addon.block_myoverview.noresultdescription'] = 'Pokušajte da prilagodite svoje filtere ili pregledajte sve kurseve.';
$string['addon.blog.errorloadentries'] = 'Greška prilikom učitavanja blog članaka.';
$string['addon.blog.showonlyyourentries'] = 'Prikažite samo svoje članke';
$string['addon.calendar.calendarevent'] = 'Događaj u kalendaru';
$string['addon.calendar.calendarevents'] = 'Događaji u kalendaru';
$string['addon.calendar.calendarreminders'] = 'Podsetnici u kalendaru';
$string['addon.calendar.currentmonth'] = 'Tekući mesec';
$string['addon.calendar.defaultnotificationtime'] = 'Podrazumevano vreme za slanje obaveštenja';
$string['addon.calendar.errorloadevent'] = 'Greška prilikom učitavanja događaja.';
$string['addon.calendar.errorloadevents'] = 'Greška prilikom učitavanja događaja.';
$string['addon.calendar.monthlyview'] = 'Mesečni pregled';
$string['addon.calendar.noevents'] = 'Nema događaja';
$string['addon.calendar.reminders'] = 'Podsetnici';
$string['addon.calendar.setnewreminder'] = 'Podesite novi podsetnik';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} pre';
$string['addon.competency.errornocompetenciesfound'] = 'Nije pronađena nijedna kompetencija';
$string['addon.competency.nocompetencies'] = 'Nema kompetencija';
$string['addon.coursecompletion.complete'] = 'Završi';
$string['addon.coursecompletion.couldnotloadreport'] = 'Nije moguće učitati izveštaj o završetku kursa. Molimo vas, pokušajte ponovo kasnije.';
$string['addon.enrol_self.confirmselfenrol'] = 'Da li ste sigurni da želite da se upišete na ovaj kurs?';
$string['addon.enrol_self.errorselfenrol'] = 'Došlo je do greške prilikom samostalnog upisa.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Komfiguriši uređaj';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Vašim korisnicima na njihove mobilne uređaje ne stižu nikakva obaveštenja sa ovog sajta. Uključite slanje obaveštenja na mobilne uređaje na stranici za podešavanja obaveštenja.';
$string['addon.messages.contactlistempty'] = 'Spisak osoba za kontakt je prazan';
$string['addon.messages.contactname'] = 'Ime osobe za kontakt';
$string['addon.messages.deletemessage'] = 'Obriši poruku';
$string['addon.messages.deletemessageconfirmation'] = 'Da li sigurni da želite da obrišete ovu poruku? Ona će biti izbrisan samo iz vaše istorije poruka ali će i dalje biti vidljiva korisniku koji je poslao ili primio poruku.';
$string['addon.messages.errordeletemessage'] = 'Greška prilikom brisanja poruke.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Greška prilikom preuzimanja kontakata sa servera.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Greška prilikom preuzimanja diskusija sa servera.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Greška prilikom preuzimanja poruka sa servera.';
$string['addon.messages.errorwhileretrievingusers'] = 'Greška prilikom preuzimanja korisnika sa servera.';
$string['addon.messages.messagenotsent'] = 'Poruka nije poslata. Molimo vas, pokušajte ponovo kasnije.';
$string['addon.messages.newmessages'] = 'Nove poruke';
$string['addon.messages.nousersfound'] = 'Nije pronađen nijedan korisnik';
$string['addon.messages.showdeletemessages'] = 'Prikaži brisanje poruka';
$string['addon.messages.type_blocked'] = 'Blokiran';
$string['addon.messages.type_offline'] = 'Oflajn';
$string['addon.messages.type_online'] = 'Onlajn';
$string['addon.messages.type_search'] = 'Rezultati pretrage';
$string['addon.messages.type_strangers'] = 'Drugi';
$string['addon.messages.useentertosenddescdesktop'] = 'Ako je onemogućeno, možete koristiti kombinaciju tastera Ctrl + Enter da biste poslali poruku.';
$string['addon.messages.useentertosenddescmac'] = 'Ako je onemogućeno, možete koristiti kombinaciju tastera Cmd + Enter da biste poslali poruku.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Nije moguće poslati poruku(e) u prepisku {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Nije moguće poslati poruku(e) korisniku {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Molimo vas da prihvatite izjavu o predaji rada.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Detalji o zadatku i obrazac za predaju rada će biti dostupni od <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Ovaj zadatak će prihvatiti predate radove od <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Ne možete da dodate ili menjate rad u aplikaciji jer izjava o predatom radu ne može da se preuzme sa sajta.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Aplikacije još uvek ne podržava određene metode ocenjivanja i one se ne mogu menjati.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Ne možete da predate rad na ocenjivanje u aplikaciji jer nije bilo moguće preuzeti sa sajta izjavu o predaji rada.';
$string['addon.mod_assign.duedateno'] = 'Bez krajnjeg roka';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Ne možete da dodate ili menjate rad u aplikaciji jer neki dodaci još uvek nemaju podršku za uređivanje.';
$string['addon.mod_assign.errorshowinginformation'] = 'Nije moguće prikazati informacije o predatom radu.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Aplikacija ne podržava ove povratne informacije. Moguće je da one ne sadrži sve informacije.';
$string['addon.mod_assign.gradenotsynced'] = 'Ocena nije sinhronizovana';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Učesnici koji nisu predali rad nisu prikazani.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Broj radnih verzija: {{count}}';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Broj učesnika: {{count}}';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Broj predatih radova koje treba oceniti: {{count}}';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Broj predatih zadataka (radova): {{count}}';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Broj timova: {{count}}';
$string['addon.mod_assign.submissionnotsupported'] = 'Aplikacija ne podržava ovaj predati rad. Moguće je da rad ne sadrži sve informacije.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'ocena korisnika';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Ocena predatog rada je izmenjena na sajtu.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Predati rad korisnika je izmenjen na sajtu.';
$string['addon.mod_chat.confirmloss'] = 'Jeste li sigurni? Istorija sesije u \'Pričaonica\' može biti izgubljena.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Greška prilikom povezivanja sa pričaonicom.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Greška prilikom preuzimanja podataka za \'Pričaonicu\'.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Greška prilikom preuzimanja korisnika pričaonice.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Greška prilikom preuzimanja poruka sa servera.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Greška prilikom slanja poruke.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Morate biti onlajn kako biste slali poruke.';
$string['addon.mod_chat.nosessionsfound'] = 'Nije pronađena nijedna sesija';
$string['addon.mod_chat.showincompletesessions'] = 'Prikaži nepotpune sesije';
$string['addon.mod_choice.errorgetchoice'] = 'Greška prilikom preuzimanja podataka za \'Izbor\'';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% korisnika je izabralo opciju: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Vaš poslednji odgovor mora biti sinhronizovan pre nego što bude uključen u rezultate.';
$string['addon.mod_data.edittagsnotsupported'] = 'Žao nam je, aplikacija ne podržava uređivanje oznaka.';
$string['addon.mod_data.errorapproving'] = 'Greška prilikom odobravanja ili odbijanja unosa.';
$string['addon.mod_data.errordeleting'] = 'Greška prilikom brisanja unosa.';
$string['addon.mod_data.gettinglocation'] = 'Dobijanje lokacije';
$string['addon.mod_data.locationnotenabled'] = 'Određivanje lokacije nije omogućeno';
$string['addon.mod_data.locationpermissiondenied'] = 'Dozvola za pristup vašoj lokaciji je odbijena.';
$string['addon.mod_data.mylocation'] = 'Moja lokacija';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Žao nam je, aplikacija ne podržava pretragu po oznakama.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Upitnik sa Captcha elementom ne može da bude završen ako nije konfigurisan, ako ste u oflajn režimu ili ako je server isključen.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Broj poslatih odgovora: {{count}}';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Ovaj upitnik je sačuvan kako bi kasnije bio predat.';
$string['addon.mod_feedback.questionscountdescription'] = 'Broj pitanja: {{count}}';
$string['addon.mod_folder.emptyfilelist'] = 'Nema datoteka za prikaz.';
$string['addon.mod_forum.errorgetforum'] = 'Greška pri preuzimanju podataka foruma.';
$string['addon.mod_forum.errorgetgroups'] = 'Greška prilikom preuzimanja podešavanja grupa.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum nije dostupan u ovom redosledu sortiranja';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Pokušajte da promenite redosled sortiranja ili idite na lokaciju da vidite ovaj forum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Nije moguće kreirati novu diskusiju u svim grupama.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Još uvek nema diskusija na ovom forumu.';
$string['addon.mod_forum.group'] = 'Grupa';
$string['addon.mod_forum.numdiscussions'] = 'Broj diskusija: {{numdiscussions}}';
$string['addon.mod_forum.numreplies'] = 'Broj odgovora: {{numreplies}}';
$string['addon.mod_forum.postingroup'] = 'Slanje poruka u grupi "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Osveži postove';
$string['addon.mod_glossary.browsemode'] = 'Pregledaj pojmove';
$string['addon.mod_glossary.byalphabet'] = 'Abecednim redom';
$string['addon.mod_glossary.byauthor'] = 'Grupiši po autoru';
$string['addon.mod_glossary.bycategory'] = 'Grupiši po kategoriji';
$string['addon.mod_glossary.bynewestfirst'] = 'Najnoviji prvo';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Nedavno ažurirani';
$string['addon.mod_glossary.bysearch'] = 'Pretraži';
$string['addon.mod_glossary.cannoteditentry'] = 'Ne možete da uređujete pojam';
$string['addon.mod_glossary.entriestobesynced'] = 'Pojmovi za sinhronizaciju';
$string['addon.mod_glossary.entrypendingapproval'] = 'Ovaj pojam čeka odobrenje.';
$string['addon.mod_glossary.errordeleting'] = 'Greška prilikom brisanja pojma.';
$string['addon.mod_glossary.errorloadingentries'] = 'Došlo je do greške prilikom učitavanja pojmova.';
$string['addon.mod_glossary.errorloadingentry'] = 'Došlo je do greške prilikom učitavanja pojma.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Došlo je do greške prilikom učitavanja rečnika.';
$string['addon.mod_glossary.noentriesfound'] = 'Nije pronađen nijedan pojam.';
$string['addon.mod_glossary.searchquery'] = 'Upit za pretragu';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Preuzmi H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Greška prilikom preuzimanju podataka o H5P aktivnosti.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P paket nije preuzet. Morate da ga preuzmete da biste mogli da ga koristite.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P paket je izmenjen od poslednjeg preuzimanja. Morate ga ponovo preuzeti kako biste mogli da ga koristite.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Morate biti onlajn kako biste videli H5P paket.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Pregledajte pokušaj {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Prikaži opis';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Ova lekcija sadrži prelaz na nausimično odabranu stranicu sa sadržajem, pa je nije moguće uraditi u aplikaciji dok se ne pokrene u veb čitaču.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Ova pokušaj ne može više biti pregledan zato što je završen drugi pokušaj.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Ovaj pokušaj je završen u oflajn režimu.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Oflajn pokušaj je sinhronizovan. Da li želite da ga pregledate?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Pokušaj je završen na veb sajtu.';
$string['addon.mod_lti.errorgetlti'] = 'Greška prilikom preuzimanja podataka modula.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Inicijalna URL adresa nije ispravna.';
$string['addon.mod_lti.launchactivity'] = 'Pokreni aktivnost';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Greška prilikom učitavanja sadržaja stranice.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Možete pokušati da rešite ovaj test u aplikaciji, ali ćete svoj pokušaj rešavanja morati da pošaljete putem veb čitača, zbog sledećih razloga:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Ovaj pokušaj rešavanja testa ne može da bude predat zbog sledećih razloga:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Ovaj pokušaj nije sinhronizovan od {{$a}}. Ako ste u međuvremenu ovaj pokušaj nastavili  na nekom drugom uređaju, postoji mogućnost da ste izgubili podatke.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Došlo je do greške prilikom pokušaja da se sačuvaju odgovori. Da li ste sigurni da želite da napustite test?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Ovaj test ne možete rešavati u aplikaciji zato što ona ne podržava ponašanje pitanja:';
$string['addon.mod_quiz.errordownloading'] = 'Greška prilikom preuzimanja neophodnih podataka.';
$string['addon.mod_quiz.errorgetattempt'] = 'Greška prilikom preuzimanja podataka o pokušaju rešavanja testa.';
$string['addon.mod_quiz.errorgetquestions'] = 'Greška prilikom preuzimanja pitanja.';
$string['addon.mod_quiz.errorgetquiz'] = 'Greška prilikom preuzimanja podataka testa.';
$string['addon.mod_quiz.errorparsequestions'] = 'Došlo je do greške prilikom učitavanja pitanja. Molimo, pokušajte da rešite ovaj test u veb čitaču.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Ovaj test se ne može rešavati u aplikaciji zato što sadrži pitanja koje aplikacija ne podržava:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Ovaj test se ne može rešavati u aplikaciji zato što sadrži pravila za pristup koje aplikacija ne podržava:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Došlo je do greške prilikom snimanja podataka o pokušaju rešavanja testa.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Vaš pokušaj rešavanja testa je poslat i sačuvan. Na sajt će biti poslat kada ponovo budete onlajn.';
$string['addon.mod_quiz.finishnotsynced'] = 'Test je završen, ali nije sinhronizovan';
$string['addon.mod_quiz.opentoc'] = 'Otvori iskačući prozor sa navigacijom.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Oflajn pokušaj je odbačen zato što je ili završen na sajtu ili nije pronađen.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Neki oflajn odgovori su odbačeni zato što su pitanja izmenjena onlajn.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Pokušaj rešavanja testa je nije završen zato što su neki oflajn odgovori odbačeni. Pregledajte svoje odgovore, a zatim ponovo pošaljite svoj pokušaj.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Ovaj test sadrži pitanja koja aplikacija ne podržava:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Greška prilikom učitavanja sadržaja.';
$string['addon.mod_resource.openthefile'] = 'Otvori';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Ova datoteka se promenila od kada ste je poslednji put otvorili.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Postoji novija verzija ove datoteke. Da biste je videli, povežite svoj uređaj na internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Ocena ne može da se izračuna.';
$string['addon.mod_scorm.dataattemptshown'] = 'Ovi podaci pripadaju pokušaju broj {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Došlo je do greške prilikom pokušaja kreiranja novog oflajn pokušaja. Molimo, pokušajte ponovo.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Greška prilikom preuzimanja SCORM paketa: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Greška prilikom preuzimanja podataka SCORM paketa.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Žao nam je, aplikacija podržava samo SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Особа која је одговорна у вашој институцији (школи/организацији).
је онемогућила преузимање SCORM пакета.';
$string['addon.mod_scorm.errornovalidsco'] = 'Ovaj SCORM paket nema vidljiv SCO koji bi bio učitan.';
$string['addon.mod_scorm.errorpackagefile'] = 'Žao nam je, aplikacija podržava samo ZIP arhive.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Došlo je do greške prilikom sinhronizacije. Molimo, pokušajte ponovo.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Ovaj pokušaj ima podatke koji nisu sinhronizovan.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Ovaj pokušaj ne može biti poslat zato što ste premašili maksimalan broj dozvoljenih pokušaja.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Ovaj SCORM paket nije preuzet. Biće automatski preuzet kada ga otvorite.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Ovaj SCORM paket je menjan od poslednjeg preuzimanja. Biće automatski preuzet kada ga otvorite.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Neki oflajn podaci o pokušaju {{number}} su odbačeni zato što se ne mogu računati kao novi pokušaj.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Neki pokušaji nisu mogli biti sinhronizovani sa sajtom zato što poslednji onlajn pokušaj nije završen. Molimo vas da prvo završite onlajn pokušaj.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Žao nam je, bilo je problema sa predajom vašeg upitnika. Molim vas, pokušajte ponovo.';
$string['addon.mod_survey.errorgetsurvey'] = 'Greška prilikom preuzimanja podataka za \'Upitnik\' (Survey)';
$string['addon.mod_survey.results'] = 'Rezultati';
$string['addon.mod_url.accessurl'] = 'Pristupite URL adresi';
$string['addon.mod_url.pointingtourl'] = 'URL adresa sa kojom je ovaj resurs povezan.';
$string['addon.mod_wiki.errorloadingpage'] = 'Došlo je do greške prilikom učitavanja stranice.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Ovaj viki još uvek nema nikakav sadržaj.';
$string['addon.mod_wiki.gowikihome'] = 'Idi na početnu stranicu vikija';
$string['addon.mod_wiki.subwiki'] = 'Podviki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Naslov  se mora uneti';
$string['addon.mod_wiki.viewpage'] = 'Pogledaj stranicu';
$string['addon.mod_wiki.wikipage'] = 'Viki stranica';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Strategija procene {{$a}} nije podržana';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Morate da unesete naslov.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Predati rad je izmenjen na sajtu.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Procena je izmenjena na sajtu.';
$string['addon.notes.warningnotenotsent'] = 'Nije moguće dodati ili obrisati belešku/e kursu {{course}}. {{error}}';
$string['addon.notifications.allownotifications'] = 'Dozvoli obaveštenja';
$string['addon.notifications.errorgetnotifications'] = 'Greška prilikom preuzimanja obaveštenja.';
$string['addon.notifications.notifications'] = 'Obaveštenja';
$string['addon.notifications.playsound'] = 'Reprodukuj zvuk';
$string['addon.notifications.therearentnotificationsyet'] = 'Nema obaveštenja.';
$string['addon.notifications.typeofnotification'] = 'Vrsta obaveštenja';
$string['addon.privatefiles.couldnotloadfiles'] = 'Nije moguće učitati spisak datoteka.';
$string['addon.privatefiles.emptyfilelist'] = 'Nema datoteka za prikaz.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Nažalost, trenutno nije moguće otpremiti datoteke na vaš sajt.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Želite li da obrišete sve podatke preuzete sa sajta?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Želite li da obrišete podatke preuzete sa svih kurseva?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Želite li da obrišete sve podatke preuzete sa \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Preuzimanja kurseva';
$string['addon.storagemanager.courseinfo'] = 'Preuzmite sadržaj kursa kako biste mogli da radite oflajn. Vaša aktivnost će se automatski sinhronizovati kada vaš uređaj ponovo bude onlajn.';
$string['addon.storagemanager.deleteallsitedata'] = 'Obrišete sve podatke preuzete sa sajta';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Ovo će obrisati sve podatke preuzete sa \'{{name}}\', uključujući sve preuzete kurseve i podatke koji vam omogućavaju da radite oflajn.';
$string['addon.storagemanager.deletecourses'] = 'Obrišete podatke preuzete sa svih kurseva';
$string['addon.storagemanager.deletedata'] = 'Obrišite preuzete podatke';
$string['addon.storagemanager.deletedatafrom'] = 'Obrišete sve podatke preuzete sa \'{{name}}\'';
$string['addon.storagemanager.downloadedcourses'] = 'Preuzeti kursevi';
$string['addon.storagemanager.downloads'] = 'Preuzimanja';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Greška prilikom brisanja preuzetih podataka.';
$string['addon.storagemanager.managedownloads'] = 'Upravljanje preuzimanjima';
$string['addon.storagemanager.totaldownloads'] = 'Ukupan broj preuzimanja';
$string['addon.storagemanager.totalspaceusage'] = 'Ukupan iskorišćen prostor';
$string['appstoredescription'] = 'NAPOMENA: Ova zvanična Moodle Mobile će raditi SAMO sa onim Moodle sajtovima koji su podešeni tako da to omogućavaju. Ako imate problema sa povezivanjem, obratite se administratoru vašeg Moodle sajta.
 
Ako je vaš Moodle sajt ispravno konfigurisan, ovu aplikaciju možete koristiti kako biste:
 
- pregledali sadržaje svojih kurseva, čak i kada ste oflajn
- primali trenutna obaveštenja o porukama i drugim događajima
- brzo pronašli i kontaktirali druge polaznike na svojim kursevima
- otpremali slike, audio, video i druge datoteke sa svog mobilnog uređaja
- videli svoje ocene na kursu
- i još mnogo toga!
 
Za sve najnovije informacije molimo vas, pogledajte http://docs.moodle.org/en/Mobile_app
 
Zaista bismo voleli da čujemo vaše komentare o postojećim funkcionalnostima, kao i sugestije o tome šta još želite da ova aplikacija radi!
 
Aplikacija zahteva sledeća ovlašćenje:
Snimanje zvuka - za snimanje zvuka i otpremanje snimka na Moodle
Čitanje i modifikovanje sadržaja vaše SD kartice - sadržaji se preuzimaju na SD karticu vašeg telefona tako da možete da ih vidite i kada se u oflajn režimu
Pristup mreži - kako biste mogli da se povežete sa svojim Moodle sajtom i proverite da li ste povezani ili ne (i u tom slučaju se prebacite u oflajn režim)
Izvršavanje pri pokretanju - tako da možete da primate lokalna obaveštenja čak i kada aplikacija radi u pozadini
Sprečavanja da mobilni telefon uđe u režim mirovanja - tako da možete da primite obaveštenja u bilo kom trenutku';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple Keynote prezentacija';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple Numbers radna tabela';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple Pages dokument';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive audio';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive datoteka';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive direktorijum';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive video';
$string['core.ajaxendpointnotfound'] = 'AJAX krajnja tačka nije pronađena. Ovo se može dogoditi ako je Moodle sajt isuviše star ili ako blokira pristup ovoj krajnjoj tački. Moodle aplikacija podržava samo Moodle sisteme {{$a}} i novije.';
$string['core.browser'] = 'Veb čitač';
$string['core.calculating'] = 'Израчунавање';
$string['core.cannotconnect'] = 'Nije moguće povezati se sajtom';
$string['core.cannotdownloadfiles'] = 'Osoba koja je odgovorna u vašoj instituciji (školi/organizaciji).
je onemogućila preuzimanje datoteka.';
$string['core.cannotinstallapk'] = 'Nije moguće instalirati .apk datoteke';
$string['core.cannotinstallapkinfo'] = 'Iz bezbednosnih razloga, ne možete da instalirate nepoznate aplikacije na svoj uređaj iz ove aplikacije. Ako i dalje želite da nastavite sa instalacijom, potrebno je da otvorite aplikaciju u pretraživaču.';
$string['core.cannotlogoutpageblocks'] = 'Sačuvajte ili odbacite promene pre nego što nastavite.';
$string['core.cannotopeninapp'] = 'Ova datoteka možda neće raditi kako se očekuje na ovom uređaju. Da li biste ipak želeli da je otvorite?';
$string['core.cannotopeninappdownload'] = 'Ova datoteka možda neće raditi kako se očekuje na ovom uređaju. Da li biste ipak želeli da je preuzmete?';
$string['core.captureaudio'] = 'Snimi audio';
$string['core.capturedimage'] = 'Slikano.';
$string['core.captureimage'] = 'Uslikaj';
$string['core.capturevideo'] = 'Snimi video';
$string['core.certificaterror'] = 'Vaš uređaj ne može prepozna sertifikat ovoga sajta (smatra ga rizičnim): {{details}}';
$string['core.clearsearch'] = 'Obriši pretragu';
$string['core.clearstoreddata'] = 'Očisti skladište {{$a}}';
$string['core.clicktoseefull'] = 'Kliknite kako biste videli kompletan sadržaj.';
$string['core.comments.commentsnotworking'] = 'Komentari se ne mogu preuzeti';
$string['core.comments.warningcommentsnotsent'] = 'Nije moguće sinhronizovati komentare. {{error}}';
$string['core.confirmcanceledit'] = 'Da li ste sigurni da želite da napustite ovu stranicu? Sve promene će biti izgubljene.';
$string['core.confirmleaveunknownchanges'] = 'Da li ste sigurni da želite da napustite ovu stranicu? Ako imate promene koje nisu sačuvane, one će biti izgubljene.';
$string['core.confirmloss'] = 'Da li ste sigurni? Sve promene će biti izgubljene.';
$string['core.confirmopeninbrowser'] = 'Da li želite da otvorite u veb čitaču?';
$string['core.connectionlost'] = 'Veza sa sajtom je izgubljena';
$string['core.contactsupport'] = 'Obratite se podršci';
$string['core.contactverb'] = 'Kontakt';
$string['core.contenteditingsynced'] = 'Sadržaj koji uređujete je sinhronizovan.';
$string['core.contentlinks.chooseaccount'] = 'Izaberi nalog';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Izaberite nalog sa kojim treba otvoriti link.';
$string['core.contentlinks.confirmurlothersite'] = 'Ovaj link pripada drugom sajtu. Da li želite da ga otvorite?';
$string['core.contentlinks.errornoactions'] = 'Nije moguće pronaći akciju koju treba izvesti sa ovim linkom.';
$string['core.contentlinks.errornosites'] = 'Nije moguće pronaći nijedan sajt za ovaj link.';
$string['core.contentlinks.errorredirectothersite'] = 'URL adresa za preusmeravanje ne može da upućuje na drugi sajt.';
$string['core.copiedtoclipboard'] = 'Tekst kopiran u klipbord';
$string['core.copytoclipboard'] = 'Kopiraj u klipbord';
$string['core.course.activitydisabled'] = 'Vaša institucija je onemogućila ovu aktivnost u mobilnoj aplikaciji.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Vaša institucija je instalirala dodatak koji još uvek nije podržan.';
$string['core.course.allsections'] = 'Sve sekcije';
$string['core.course.aria:sectionprogress'] = 'Napredak unutar sekcije:';
$string['core.course.availablespace'] = 'Trenutno imate oko {{available}} slobodnog prostora.';
$string['core.course.cannotdeletewhiledownloading'] = 'Datoteke se ne mogu obrisati dok se aktivnost preuzima. Sačekajte da se preuzimanje završi.';
$string['core.course.confirmdownload'] = 'Nameravate da preuzmete {{size}}.{{availableSpace}} Da li ste sigurni da želite da nastavite?';
$string['core.course.confirmdownloadunknownsize'] = 'Nismo mogli da izračunamo veličinu preuzimanje. {{availableSpace }} Da li ste sigurni da želite da nastavite?';
$string['core.course.confirmdownloadzerosize'] = 'Nameravaš da započneš preuzimanje.{{availableSpace}} Da li ste sigurni da želite da nastavite?';
$string['core.course.confirmlimiteddownload'] = 'Trenutno niste povezani na Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Nameravate da preuzmete <strong>najmanje</strong> {{size}}. {{availableSpace}} Da li ste sigurni da želite da nastavite?';
$string['core.course.couldnotloadsectioncontent'] = 'Nije moguće učitati sadržaj sekcije. Pokušajte ponovo kasnije.';
$string['core.course.couldnotloadsections'] = 'Nije moguće učitati sekcije. Pokušajte ponovo kasnije.';
$string['core.course.downloadcoursesprogressdescription'] = 'Preuzimanje kurseva: preuzeto {{count}} od ukupno {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Preuzimanje sekcija: preuzeto {{count}} od ukupno {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Greška prilikom preuzimanju kursa.';
$string['core.course.errordownloadingsection'] = 'Greška prilikom preuzimanja sekcije.';
$string['core.course.errorgetmodule'] = 'Greška prilikom preuzimanja podataka modula.';
$string['core.course.insufficientavailablequota'] = 'Vaš uređaj nije mogao da dodeli prostor za čuvanje ovog preuzetog sadržaja. Možda je uređaj rezervisao prostor za ažuriranja aplikacija i sistema. Prvo očistite nešto prostora za skladištenje.';
$string['core.course.insufficientavailablespace'] = 'Pokušavate da preuzmete {{size}}. Ovo će ostaviti vaš uređaj sa nedovoljno velikim prostorom za normalan rad. Prvo očistite nešto prostora za skladištenje.';
$string['core.course.lastaccessedactivity'] = 'Poslednja aktivnost kojoj je pristupljeno';
$string['core.course.manualcompletionnotsynced'] = 'Ručni završetak nije sinhronizovan.';
$string['core.course.modulenotfound'] = 'Resurs ili aktivnost nisu pronađeni. Proverite da li ste onlajn i da li su resurs odnosno aktivnost još uvek dostupni.';
$string['core.course.nextactivity'] = 'Sledeća aktivnost';
$string['core.course.nextactivitynotfound'] = 'Sledeća aktivnost nije pronađena. Moguće je da je sakrivena ili obrisana.';
$string['core.course.nocontentavailable'] = 'Nikakav sadržaj nije dostupan u ovom trenutku.';
$string['core.course.previousactivity'] = 'Prethodna aktivnost';
$string['core.course.previousactivitynotfound'] = 'Prethodna aktivnost nije pronađena. Moguće je da je sakrivena ili obrisana.';
$string['core.course.refreshcourse'] = 'Osveži kurs';
$string['core.course.useactivityonbrowser'] = 'Još uvek možete da koristite aktivnost (resurs) pomoću veb čitača vašeg uređaja.';
$string['core.course.warningmanualcompletionmodified'] = 'Ručni završetak aktivnosti je izmenjen na sajtu.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Neki oflajn ručni završeci kursa \'{{name}}\' su obrisani. {{error}}';
$string['core.coursenogroups'] = 'Niste član nijedne grupe na ovom kursu.';
$string['core.courses.browserenrolinstructions'] = 'Preusmerićemo vas na veb čitač vašeg uređaja. Kada završite svoj upis, vratite se u ovu aplikaciju.';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorije koje su ispod nivoa {{$a}} ne mogu se preuzeti.';
$string['core.courses.completeenrolmentbrowser'] = 'Završite upis u veb čitaču';
$string['core.courses.confirmselfenrol'] = 'Da li ste sigurni da želite da se upišete na ovaj kurs?';
$string['core.courses.downloadcourses'] = 'Preuzmite sve kurseve';
$string['core.courses.enrolme'] = 'Upiši me';
$string['core.courses.errorloadcategories'] = 'Došlo je do greške prilikom učitavanja kategorija.';
$string['core.courses.errorloadcourses'] = 'Došlo je do greške prilikom učitavanja kurseva.';
$string['core.courses.errorloadplugins'] = 'Dodaci potrebni za ovaj kurs nisu mogli pravilno da se učitaju. Ponovo pokrenite aplikaciju kako biste pokušali ponovo da učitate dodatke.';
$string['core.courses.errorsearching'] = 'Došlo je do greške prilikom pretraživanja.';
$string['core.courses.errorselfenrol'] = 'Došlo je do greške prilikom pokušaja samostalnog upisa.';
$string['core.courses.filtermycourses'] = 'Filtriraj moje kurseve';
$string['core.courses.notenrollable'] = 'Ne možete sami da se upišete na ovaj kurs.';
$string['core.courses.otherenrolments'] = 'Ostali upisi';
$string['core.courses.password'] = 'Pristupna lozinka kursa';
$string['core.courses.refreshcourses'] = 'Osvežite kurseve';
$string['core.courses.searchcoursesadvice'] = 'Možete koristiti dugme za pretragu kurseva kako biste im pristupili kao gost ili se sami upisali na one koji to dopuštaju.';
$string['core.courses.selfenrolment'] = 'Samostalni upis';
$string['core.courses.showonlyenrolled'] = 'Prikaži samo moje kurseve';
$string['core.courses.totalcoursesearchresults'] = 'Ukupno kurseva: {{$a}}';
$string['core.currentdevice'] = 'Trenutni uređaj';
$string['core.datastoredoffline'] = 'Podaci su sačuvani u mobilnom uređaju, zato što ne mogu da se pošalju. Automatski će biti poslati kasnije.';
$string['core.deletedoffline'] = 'Obrisano oflajn';
$string['core.deleting'] = 'Brisanje';
$string['core.desktop'] = 'Stoni računar';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Odbaci';
$string['core.dismiss'] = 'Obustavi';
$string['core.dontshowagain'] = 'Ne prikazuj ponovo.';
$string['core.downloaded'] = 'Preuzeto';
$string['core.downloading'] = 'Preuzimanje';
$string['core.editor.hidetoolbar'] = 'Sakrij traku sa alatkama';
$string['core.editor.toggle'] = 'Uključi/isključi editor';
$string['core.emptysplit'] = 'Ova stranica će se pojaviti prazna ukoliko je levi panel prazan ili se učitava.';
$string['core.endingtime'] = 'Vreme završetka: {{$a}}';
$string['core.errorchangecompletion'] = 'Došlo je do greške prilikom promene statusa završetka. Molimo, pokušajte ponovo.';
$string['core.errorcode'] = 'Kôd greške: {{errorCode}}';
$string['core.errordeletefile'] = 'Greška prilikom brisanja datoteke. Molimo, pokušajte ponovo.';
$string['core.errordetailshide'] = 'Sakrij podatke o grešci';
$string['core.errordetailsshow'] = 'Prikaži podatke o grešci';
$string['core.errordownloading'] = 'Greška prilikom preuzimanja datoteke.';
$string['core.errordownloadingsomefiles'] = 'Greška prilikom preuzimanja datoteka modula. Moguće je da neke datoteke nedostaju.';
$string['core.errorfileexistssamename'] = 'Već postoji datoteka sa ovim nazivom.';
$string['core.errorinvalidform'] = 'Obrazac sadrži neispravne podatke. Proverite da li ste popunili sva neophodna polja i da li su podaci ispravni.';
$string['core.errorinvalidresponse'] = 'Neočekivani odgovor za {{method}} veb-servis.';
$string['core.errorloadingcontent'] = 'Greška prilikom učitavanju sadržaja.';
$string['core.errorofflinedisabled'] = 'Oflajn pregledanje je onemogućeno na vašem sajtu. Morate biti povezani na internet da biste koristili aplikaciju.';
$string['core.erroropenfiledownloading'] = 'Greška prilikom otvaranja datoteke: potrebno je da sačekate da se preuzimanje završi.';
$string['core.erroropenfilenoapp'] = 'Greška prilikom otvaranja datoteke: nije pronađena aplikacija koja može da otvori ovaj tip datoteke.';
$string['core.erroropenfilenoextension'] = 'Greška prilikom otvaranja datoteke: datoteka nema ekstenziju.';
$string['core.erroropenpopup'] = 'Ova aktivnost pokušava da otvori iskačući prozor. Ova aplikacija to ne podržava.';
$string['core.errorrenamefile'] = 'Greška prilikom pokušaja promene naziva datoteke. Molimo, pokušajte ponovo.';
$string['core.errorsitesupport'] = 'Ako problem i dalje postoji, obratite se podršci sajta.';
$string['core.errorsomedatanotdownloaded'] = 'Ako ste preuzeli ovu aktivnost, imajte na umu da se neki podaci ne preuzimaju (tokom procesa preuzimanja) iz razloga performansi i korišćenja podataka.';
$string['core.errorsomethingwrong'] = 'Nešto nije u redu. Molim vas, pokušajte ponovo';
$string['core.errorsync'] = 'Došlo je do greške prilikom sinhronizaciji. Molimo, pokušajte ponovo.';
$string['core.errorsyncblocked'] = '{{$a}} trenutno ne može da se sinhronizuje zbog tekućeg procesa. Molimo, pokušajte ponovo kasnije. Ako se problem i dalje bude javljao, pokušajte ponovo da pokrenete aplikaciju.';
$string['core.errorurlschemeinvalidscheme'] = 'Ova URL adresa bi trebalo da se koristi u drugoj aplikaciji: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL adresa ovog sajta ne može da se otvori u ovoj aplikaciji.';
$string['core.exactalarmsturnedoff'] = 'Obaveštenja u realnom vremenu su isključena';
$string['core.exactalarmsturnedoffmessage'] = 'Da ne biste propustili nijedno važno obaveštenje, uključite \'Alarmi i podsetnici\' u podešavanjima svog mobilnog uređaja.';
$string['core.filenameexist'] = 'Naziv datoteke već postoji: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Nameravate da otpremite {{size}}. Da li ste sigurni da želite da nastavite?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Nismo mogli da izračunamo veličinu datoteka za otpremanje. Da li ste sigurni da želite da nastavite?';
$string['core.fileuploader.discardrecording'] = 'Odbacite snimak';
$string['core.fileuploader.errorcapturingaudio'] = 'Greška prilikom snimanja audio zapisa.';
$string['core.fileuploader.errorcapturingimage'] = 'Greška prilikom snimanja slike.';
$string['core.fileuploader.errorcapturingvideo'] = 'Greška prilikom snimanja video zapisa.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Greška prilikom preuzimanja slike iz albuma.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Morate biti onlajn kako biste otpremili datoteke.';
$string['core.fileuploader.errornoapp'] = 'Nemate instaliranu aplikaciju koja može da obavi ovu radnju.';
$string['core.fileuploader.errorreadingfile'] = 'Greška prilikom učitavanja datoteke.';
$string['core.fileuploader.errorwhileuploading'] = 'Došlo je do greške prilikom otpremanja datoteke.';
$string['core.fileuploader.file'] = 'Датотека';
$string['core.fileuploader.fileuploaded'] = 'Datoteka je uspešno otpremljena.';
$string['core.fileuploader.maxbytesfile'] = 'Datoteka {{$a.file}} je prevelika. Maksimalna veličina koju možete da otpremite je {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Dozvola za pristup mikrofonu je odbijena.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Pristup mikrofonu je ograničen.';
$string['core.fileuploader.pauserecording'] = 'Pauziraj snimanje';
$string['core.fileuploader.photoalbums'] = 'Foto albumi';
$string['core.fileuploader.readingfile'] = 'Učitavanje datoteke';
$string['core.fileuploader.readingfileperc'] = 'Učitavanje datoteke: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Nastavi snimanje';
$string['core.fileuploader.selectafile'] = 'Izaberi datoteku';
$string['core.fileuploader.startrecordinginstructions'] = 'Dodirnite da biste započeli snimanje';
$string['core.fileuploader.uploadafile'] = 'Otpremi datoteku';
$string['core.fileuploader.uploading'] = 'Otpremanje';
$string['core.fileuploader.uploadingperc'] = 'Otpremanje: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Idi na {{$a}}';
$string['core.h5p.errorgetemail'] = 'Greška prilikom dobavljanja e-pošte korisnika. Proverite svoju vezu i pokušajte ponovo.';
$string['core.h5p.offlinedisabled'] = 'Sajt ne dozvoljava preuzimanje H5P paketa.';
$string['core.h5p.play'] = 'Reprodukuj H5P';
$string['core.hasdatatosync'] = '{{$a}} ima oflajn podatke koje treba sinhronizovati.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Da li ovaj sadržaj ne funkcioniše?';
$string['core.image'] = 'Slika';
$string['core.imageviewer'] = 'Prikazivač slike';
$string['core.ioscookieshelp'] = 'Ugrađeni sadržaj može zahtevati kolačiće da bi funkcionisao. Idite na iOS podešavanja aplikacije, omogućite podešavanje \'Dozvoli praćenje na više veb sajtova\' (Allow Cross-Website Tracking\') i pokušajte ponovo.';
$string['core.lastdownloaded'] = 'Poslednji put preuzeto';
$string['core.lastsync'] = 'Poslednja sinhronizacija';
$string['core.loadmore'] = 'Učitaj još';
$string['core.login.authenticating'] = 'Provera identiteta';
$string['core.login.changepasswordbutton'] = 'Promeni lozinku';
$string['core.login.changepasswordhelp'] = 'Ako imate problema sa promenom lozinke, pokušajte ponovo kasnije ili se obratite osobi koja je odgovorna u vašoj instituciji (školi/organizaciji).';
$string['core.login.changepasswordinstructions'] = 'Ne možete promeniti lozinku u aplikaciji. Kliknite na sledeće dugme kako biste otvorili sajt u veb čitaču i promenili svoju lozinku. Uzmite u obzir da ćete morati da zatvorite veb čitač nakon promene lozinke, jer nećete biti automatski preusmereni na aplikaciju.';
$string['core.login.changepasswordlogoutinstructions'] = 'Ako želite da promenite lokaciju ili da se odjavite, kliknite na sledeće dugme:';
$string['core.login.changepasswordreconnectinstructions'] = 'Ako niste ispravno promenili lozinku, od vas će se tražiti da to uradite ponovo.';
$string['core.login.changepasswordsupportsubject'] = 'Potrebna mi je pomoć da promenim lozinku';
$string['core.login.confirmdeletesite'] = 'Da li ste sigurni da želite da uklonite nalog na sajtu {{sitename}}?';
$string['core.login.connect'] = 'Povežite se!';
$string['core.login.connecttomoodle'] = 'Povežite se sa Moodleom';
$string['core.login.connecttomoodleapp'] = 'Pokušavate da se povežete sa Moodle sajtom. Preuzmite zvaničnu Moodle aplikaciju kako biste pristupili ovom sajtu.';
$string['core.login.connecttoworkplaceapp'] = 'Pokušavate da se povežete na Moodle Workplace sajt. Preuzmite aplikaciju Moodle Workplace kako biste pristupili ovom veb sajtu.';
$string['core.login.contactyouradministrator'] = 'Obratite se administratoru vašeg sajta za dalju pomoć.';
$string['core.login.contactyouradministratorissue'] = 'Zamolite administratora da proveri sledeći problem: {{$a}}';
$string['core.login.credentialsdescription'] = 'Za prijavu na sistem unesite svoje korisničko ime i lozinku.';
$string['core.login.credentialshelp'] = 'Ako imate problema sa prijavom na sajt, pokušajte ponovo kasnije ili se obratite osobi koja je odgovorna u vašoj instituciji (školi/organizaciji).';
$string['core.login.credentialssupportsubject'] = 'Potrebna je pomoć prilikom prijavljivanja';
$string['core.login.emailconfirmsentnoemail'] = '<p>Trebalo bi da je poslata e-poruka na vašu adresu.</p><p><p>Poruka sadrži jednostavna uputstva o daljem postupku registracije.</p>';
$string['core.login.emailnotmatch'] = 'Adrese e-pošte se ne poklapaju';
$string['core.login.erroraccesscontrolalloworigin'] = 'Cross-Origin poziv koji pokušavate da izvedete je odbijen. Molimo, proverite https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'Došlo je do greške prilikom brisanja ovog naloga. Molim vas, pokušajte ponovo.';
$string['core.login.errorexampleurl'] = 'URL adresa https://campus.example.edu je samo primer URL adrese. To nije pravi sajt. <strong>Upotrebite URL adresu sajta vaše škole odnosno organizacije.</strong>';
$string['core.login.errorqrnoscheme'] = 'Ova URL adresa nije ispravna URL adresa za prijavu.';
$string['core.login.errorupdatesite'] = 'Došlo je do greške prilikom ažuriranju tokena sajta.';
$string['core.login.exceededloginattempts'] = 'Da li vam je potrebna pomoć prilikom prijavljivanja? Pokušajte {{recoverPassword}} ili se obratite za pomoć podršci.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'obnavljanje vaše lozinke';
$string['core.login.exceededloginattemptssupportsubject'] = 'Ne mogu da se prijavim';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Da li vam je potrebna pomoć prilikom prijavljivanja? Pokušajte da se obratite podršci vašeg sajta.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Da li vam je potrebna pomoć prilikom prijavljivanja? Pokušajte {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Čini se da imate problema sa pristupom svom nalogu. Možete se obratite osobi koja je odgovorna u vašoj instituciji (školi/organizaciji) ili pokušajte ponovo kasnije.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Ne mogu da resetujem svoju lozinku';
$string['core.login.faqcannotconnectanswer'] = 'Molimo vas, obratite se administratoru vašeg sajta.';
$string['core.login.faqcannotconnectquestion'] = 'Tačno sam uneo adresu svog sajta, ali još uvek ne mogu da se povežem.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Ako ste pokušali da pretražujete po URL adresi i još uvek ne možete da pronađete svoj Moodle sajt, obratite se osobi koja se brine o Moodleu u vašoj instituciji (školi/organizaciji).';
$string['core.login.faqcannotfindmysitequestion'] = 'Ne mogu da pronađem svoj sajt pomoću URL adrese.';
$string['core.login.faqcantloginanswer'] = '<p>Kada se povežete na svoj Moodle sajt, trebalo bi da budete u mogućnosti da se prijavite sa svojim uobičajenim korisničkim imenom i lozinkom.</p><br><p>Ako ste zaboravili korisničko ime ili lozinku, izaberite opciju <strong>Izgubljena lozinka?</strong>. Ako i dalje imate problema sa prijavljivanjem ili ne vidite nijednu opciju za preuzimanje korisničkog imena ili lozinke, obratite se osobi koja se brine o Moodleu u vašoj instituciji (školi/organizaciji).</p>';
$string['core.login.faqcantloginquestion'] = 'Ne mogu da se prijavim.';
$string['core.login.faqmore'] = 'Proverite <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">Najčešće postavljana pitanja (FAQ)</a> za više odgovora.';
$string['core.login.faqsetupsiteanswer'] = 'Posetite {{$link}} kako biste proverili različite opcije koje imate da napravite sopstveni Moodle sajt.';
$string['core.login.faqsetupsitelinktitle'] = 'Započnite';
$string['core.login.faqsetupsitequestion'] = 'Želim da pokrenem sopstveni Moodle sajt.';
$string['core.login.faqtestappanswer'] = 'Da biste testirali aplikaciju na Moodle Demo sajtu, u polje <strong>Vaš sajt</strong> unesite "teacher" ili „student" i pritisnite dugme <strong>Poveži se sa svojim sajtom</strong>.';
$string['core.login.faqtestappquestion'] = 'Mogu li da testiram aplikaciju na demo sajtu?';
$string['core.login.faqwhatisurlanswer'] = '<p>Ukoliko ne možete da pronađete svoj sajt prema imenu, pokušajte da ga pronađete prema njegovoj URL adresi (veb adresi).</p><p>Da biste pronašli adresu svog sajta:</p>
<ol><li>Otvorite veb čitač i idite na stranicu za prijavu vašeg Moodle sajta.</li><li>Na vrhu stranice, u traci za adresu, videćete URL adresu svog Moodle sajta npr. "mojaskola.edu.rs".<br>{{$image}}</li><li>Kopirajte adresu (nemojte kopirati deo adrese koji počinje sa /login), u Moodle aplikaciju a onda pritisnite dugme <strong>Poveži se sa svojim sajtom</strong></li><li>Sada se možete prijaviti na sajt koristeći svoje korisničko ime i lozinku.</li></ol><p>Ako ste pokušali da pretražujete prema URL adresi i još uvek ne možete da pronađete svoj Moodle sajt, obratite se osobi koja se brine o Moodleu u vašoj instituciji (školi/organizaciji).</p>';
$string['core.login.faqwhatisurlquestion'] = 'Kako mogu da pronađem svoj sajt?';
$string['core.login.faqwhereisqrcode'] = 'Gde mogu da pronađem QR kôd?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Ako je osoba koja je odgovorna u vašoj instituciji (školi/organizaciji), to omogućila, naći ćete QR kôd na veb sajtu, na dnu stranice vašeg korisničkog profila.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Pronađite svoj sajt';
$string['core.login.helpmelogin'] = '<p>Postoji više hiljada Moodle sajtova širom sveta. Ova aplikacija može da se poveže samo sa Moodle sajtovima koji su eksplicitno omogućili pristup mobilnoj aplikaciji.</p><p>Ako ne možete da se povežete sa Moodle sajtom, obratite se administratoru vašeg sajta i zatražite da pročita <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Da biste testirali aplikaciju na Moodle demo sajtu upišite <i>teacher</i> ili <i>student</i> u polje <i>Adresa sajta</i> i kliknite dugme <b>Povežite se!</b>.</p>';
$string['core.login.invalidaccount'] = 'Proverite svoje podatke za prijavu i pokušajte ponovo.';
$string['core.login.invalidmoodleversion'] = 'Verzija sistema je previše stara. Moodle App radi sa verzijom {{$a}} i novijim.';
$string['core.login.invalidsite'] = 'URL adresa sajta nije ispravna.';
$string['core.login.invalidtime'] = 'Vreme nije ispravno';
$string['core.login.invalidvaluemax'] = 'Maksimalna vrednost je {{$a}}';
$string['core.login.invalidvaluemin'] = 'Minimalna vrednost je {{$a}}';
$string['core.login.loggedoutssodescription'] = 'Morate ponovo da potvrdite svoj identitet. Potrebno je da se prijavite na sajt u prozoru veb čitača.';
$string['core.login.loginbutton'] = 'Prijava';
$string['core.login.logininsiterequired'] = 'Potrebno je da se prijavite na sajt u prozoru veb čitača.';
$string['core.login.mobileservicesnotenabled'] = 'Mobilni servisi nisu omogućeni na vašem sajtu.';
$string['core.login.notloggedin'] = 'Morate biti prijavljeni.';
$string['core.login.onboardingcreatemanagecourses'] = 'Kreirajte i upravljajte svojim kursevima';
$string['core.login.onboardingenrolmanagestudents'] = 'Upišite i upravljajte svojim polaznicima';
$string['core.login.onboardinggetstarted'] = 'Počnite da koristite Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Već imam Moodle sajt';
$string['core.login.onboardingimalearner'] = 'Ja sam polaznik';
$string['core.login.onboardingimaneducator'] = 'Ja sam predavač';
$string['core.login.onboardingineedasite'] = 'Potreban mi je Moodle sajt';
$string['core.login.onboardingprovidefeedback'] = 'Obezbedite pravovremene povratne informacije';
$string['core.login.onboardingtoconnect'] = 'Da biste se povezali sa Moodle aplikacijom, biće vam potreban Moodle sajt';
$string['core.login.onboardingwelcome'] = 'Dobrodošli u Moodle aplikaciju!';
$string['core.login.or'] = 'ili';
$string['core.login.passwordrequired'] = 'Neophodna je lozinka';
$string['core.login.policyacceptmandatory'] = 'Razumem i prihvatam obavezna pravila o korišćenju sajta';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA slika';
$string['core.login.recaptchaexpired'] = 'Verifikacija je istekla. Ponovo odgovorite na bezbednosno pitanje.';
$string['core.login.recaptchaincorrect'] = 'Odgovor na bezbednosno pitanje je netačan.';
$string['core.login.reconnect'] = 'Povežite se ponovo';
$string['core.login.reconnecthelp'] = 'Ako imate problema sa ponovnim povezivanjem, pokušajte ponovo kasnije ili se obratite osobi koja je odgovorna u vašoj instituciji (školi/organizaciji).';
$string['core.login.reconnectssodescription'] = 'Vaša sesija je istekla. Prijavite se ponovo u prozoru veb čitača kako biste nastavili.';
$string['core.login.reconnectsupportsubject'] = 'Potrebna mi je pomoć pri ponovnom povezivanju';
$string['core.login.reconnecttosite'] = 'Ponovo se povežite sa sajtom';
$string['core.login.removeaccount'] = 'Ukloni nalog';
$string['core.login.searchby'] = 'Pretraga po:';
$string['core.login.selectsite'] = 'Molimo izaberite svoj nalog:';
$string['core.login.signupplugindisabled'] = '{{$a}} nije omogućen.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Obrazac za registraciju sadrži obavezno prilagođeno polje koje aplikaciji ne podržava. Kreirajte nalog koristeći veb čitač.';
$string['core.login.siteaddress'] = 'Vaš sajt';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Broj nepročitanih obaveštenja: {{count}}';
$string['core.login.sitehasredirect'] = 'Vaš sajt sadrži najmanje jednu HTTP redirekciju. Aplikacija ne može da prati redirekcije. Ovo bi mogao da bude problem koji sprečava aplikaciju da se poveže sa vašim sajtom.';
$string['core.login.siteinmaintenance'] = 'Vaš sajt je u režimu održavanja';
$string['core.login.sitenotallowed'] = 'Ovaj sajt više nije dostupan.';
$string['core.login.sitepolicynotagreederror'] = 'Saglasnost sa pravilnikom o korišćenju sajta nije potvrđena.';
$string['core.login.siteurl'] = 'URL adresa sajta';
$string['core.login.siteurlrequired'] = 'Neophodna je URL adresa, npr. <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Još uvek ne možete da se povežete?';
$string['core.login.toggleremove'] = 'Uredite spisak naloga';
$string['core.login.unsupportedsite'] = 'Sajt nije dostupan preko aplikacije';
$string['core.login.unsupportedsitemessage'] = 'Sajtu {{site}} se ne može pristupiti preko ove aplikacije.<br><br>I dalje mu možete pristupiti pomoću veb čitačа.';
$string['core.login.usernamerequired'] = 'Korisničko ime je neophodno';
$string['core.login.visitchangepassword'] = 'Da li želite da posetite sajt kako biste promenili lozinku?';
$string['core.login.webservicesnotenabled'] = 'Veb servisi nisu omogućeni na sajtu.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Još uvek možete da se povežete sa sajtom tako što ćete uneti svoje korisničko ime i lozinku.';
$string['core.login.yourenteredsite'] = 'Povežite se sa svojim sajtom';
$string['core.lostconnection'] = 'Vaša sesija je istekla. Prijavite se ponovo kako biste nastavili.';
$string['core.mainmenu.switchaccount'] = 'Promeni nalog';
$string['core.mainmenu.usermenutourdescription'] = 'Mesto gde možete da proverite svoje ocene, promenite podešavanja ili promenite nalog.';
$string['core.mainmenu.usermenutourtitle'] = 'Istražite svoje lično područje';
$string['core.needhelp'] = 'Potrebna vam je pomoć?';
$string['core.networkerroriframemsg'] = 'Ovaj sadržaj nije dostupan oflajn. Povežite se na internet i pokušajte ponovo.';
$string['core.networkerrormsg'] = 'Bilo je problema sa povezivanjem na sajt. Proverite vezu i pokušajte ponovo.';
$string['core.nooptionavailable'] = 'Nema dostupnih opcija';
$string['core.nopasswordchangeforced'] = 'Ne možete nastaviti bez promene svoje lozinke.';
$string['core.nopermissionerror'] = 'Žao nam je, ali trenutno nemate ovlašćenja da to uradite';
$string['core.notapplicable'] = 'n/a';
$string['core.notdownloadable'] = 'Nije moguće preuzeti';
$string['core.notnow'] = 'Ne sada';
$string['core.notsent'] = 'Nije poslato';
$string['core.nummore'] = '{{$a}} još';
$string['core.openfile'] = 'Otvori datoteku';
$string['core.openfilewithextension'] = 'Otvorite datoteku sa ekstenzijom {{extension}}';
$string['core.openfullimage'] = 'Kliknite ovde da biste prikazali sliku u punoj veličini';
$string['core.openinbrowser'] = 'Otvori u veb čitaču';
$string['core.openinbrowserdescription'] = 'Bićete preusmereni u veb čitač';
$string['core.openmodinbrowser'] = 'Otvorite {{$a}} u veb čitaču';
$string['core.opensecurityquestion'] = 'Otvoreno sigurnosno pitanje';
$string['core.opensettings'] = 'Otvorite podešavanja';
$string['core.openwith'] = 'Otvori sa...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Reprodukuj';
$string['core.policy.havereadandagreepolicy'] = 'Pročitao /la sam i slažem se sa {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'Još nema pravila i saglasnosti.';
$string['core.policy.policyacceptmandatory'] = 'Razumem i prihvatam obavezna pravila o korišćenju sajta';
$string['core.policy.sitepolicynotagreederror'] = 'Saglasnost sa pravilnikom o korišćenju sajta nije potvrđena.';
$string['core.policy.viewpolicy'] = 'Pogledajte pravilnik o korišćenju sajta {{policyname}}.';
$string['core.pulltorefresh'] = 'Povucite da biste osvežili';
$string['core.qrscanner'] = 'QR skener';
$string['core.question.cannotdeterminestatus'] = 'Nije moguće odrediti status';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Vaš sajt još uvek ne podržava da uz odgovor budu priložene datoteke.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Vaš sajt još uvek ne podržava uređivanje ugrađenih datoteka.';
$string['core.question.errorquestionnotsupported'] = 'Aplikacija ne podržava ovaj tip pitanja: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Dodirnite da biste izabrali, a zatim još jednom da bi ste spustili spuštanje.';
$string['core.question.questionmessage'] = 'Pitanje {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Bićete preusmereni na sajt.';
$string['core.reminders.atthetime'] = 'U vreme događaja';
$string['core.reminders.custom'] = 'Prilagođeno...';
$string['core.reminders.customreminder'] = 'Prilagođeni podsetnik';
$string['core.reminders.delete'] = 'Obriši podsetnik';
$string['core.reminders.reminderset'] = 'Podsetnik je podešen za {{$a}}';
$string['core.reminders.reminderunset'] = 'Podsetnik je obrisan';
$string['core.reminders.setareminder'] = 'Podesite podsetnik';
$string['core.reminders.setareminderfor'] = 'Podesite podsetnik za "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Podesite podsetnik';
$string['core.reminders.timebefore'] = '{{value}} {{units}} ranije';
$string['core.reminders.value'] = 'Vrednost';
$string['core.removefiles'] = 'Uklonite datoteke {{$ a}}';
$string['core.reportbuilder.filtersapplied'] = 'Možda su na ovaj prikaz primenjeni filteri. Da biste uredili filtere ili promenili redosled sortiranja, <a href="{{$a}}">otvorite ovaj izveštaj u svom veb čitaču.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Sakrij kolone';
$string['core.reportbuilder.showcolumns'] = 'Prikaži kolone';
$string['core.requireduserdatamissing'] = 'Ovaj korisnik nema u svom profilu neke neophodne podatke. Molimo vas, uneseti podatke na svoj sajt i pokušajte ponovo.<br>{{$ a}}';
$string['core.resume'] = 'Nastavi';
$string['core.retry'] = 'Pokušaj ponovo';
$string['core.scanqr'] = 'Skenirajte QR kôd';
$string['core.scrollbackward'] = 'Pomerite se unazad';
$string['core.scrollforward'] = 'Pomerite se napred';
$string['core.search.allcategories'] = 'Sve kategorije';
$string['core.search.empty'] = 'Šta tražite?';
$string['core.search.filtercategories'] = 'Filtrirajte rezultate prema';
$string['core.search.filtercourses'] = 'Pretraži u';
$string['core.search.noresults'] = 'Nema rezultata za "{{$a}}"';
$string['core.search.noresultshelp'] = 'Proverite greške u kucanju ili pokušajte da koristite druge ključne reči';
$string['core.search.resultby'] = 'Prema  {{$a}}';
$string['core.searching'] = 'Pretraživanje';
$string['core.serverconnection'] = 'Greška prilikom povezivanja sa serverom: {{details}}';
$string['core.settings.about'] = 'O aplikaciji';
$string['core.settings.appsettings'] = 'Podešavanja aplikacije';
$string['core.settings.appversion'] = 'Verzija aplikacije';
$string['core.settings.cannotsyncloggedout'] = 'Ovaj sajt ne može da se sinhronizuje jer ste se odjavili. Pokušajte ponovo kada se ponovo prijavite na sajt.';
$string['core.settings.cannotsyncoffline'] = 'Sinhronizacija sajta nije uspela jer vaš uređaj nije povezan na internet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Vaš uređaj nije povezan na Wi-Fi mrežu. Povežite se na Wi-Fi mrežu ili isključite opciju za uštedu podataka u podešavanjima aplikacije.';
$string['core.settings.changelanguage'] = 'Promenite jezik na {{$a}}';
$string['core.settings.changelanguagealert'] = 'Promena jezika će ponovo pokrenuti aplikaciju.';
$string['core.settings.colorscheme'] = 'Šema boja';
$string['core.settings.colorscheme-dark'] = 'Tamna';
$string['core.settings.colorscheme-light'] = 'Svetla';
$string['core.settings.colorscheme-system'] = 'Podrazumeva se za sistem';
$string['core.settings.colorscheme-system-notice'] = 'Podrazumevani režim sistema će zavisiti od podrške vašeg uređaja.';
$string['core.settings.compilationinfo'] = 'Informacije o kompilaciji';
$string['core.settings.connecttosync'] = 'Vaš uređaj je oflajn. Povežite se na internet kako biste sinhronizovali sajtove.';
$string['core.settings.connectwifitosync'] = 'Povežite se na Wi-Fi mrežu ili isključite opciju za uštedu podataka kako biste sinhronizovali sajtove.';
$string['core.settings.copyinfo'] = 'Kopirajte informacije o uređaju u klipbord';
$string['core.settings.cordovadevicemodel'] = 'Model Cordova uređaja';
$string['core.settings.cordovadeviceosversion'] = 'Verzija operativnog sistema Cordova uređaja';
$string['core.settings.cordovadeviceplatform'] = 'Platforma Cordova uređaja';
$string['core.settings.cordovadeviceuuid'] = 'UUID Cordova uređaja';
$string['core.settings.cordovaversion'] = 'Cordova verzija';
$string['core.settings.debugdisplaydescription'] = 'Ako je omogućena ova opcija, poruka o grešci će prikazati više podataka o samoj grešci ako je to moguće.';
$string['core.settings.developeroptions'] = 'Opcije za programere';
$string['core.settings.deviceinfo'] = 'Informacija o uređaju';
$string['core.settings.deviceos'] = 'Operativni sistem uređaja';
$string['core.settings.displayformat'] = 'Format prikaza';
$string['core.settings.enableanalytics'] = 'Omogući analitiku';
$string['core.settings.enableanalyticsdescription'] = 'Ako je ova opcija omogućena, aplikacija će prikupljati anonimno podatake o korišćenju.';
$string['core.settings.enabledownloadsection'] = 'Omogući preuzimanje sekcija.';
$string['core.settings.enablefirebaseanalytics'] = 'Omogućite Firebase analitiku';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Ako je ova opcija omogućena, aplikacija će prikupljati anonimno podatake o korišćenju.';
$string['core.settings.enablerichtexteditor'] = 'Omogućite obogaćeni editor teksta';
$string['core.settings.enablerichtexteditordescription'] = 'Ako je ova opcija uključena obogaćeni editor teksta biće dostupan na mestima gde treba uneti neki sadržaj.';
$string['core.settings.enablesyncwifi'] = 'Dozvolite sinhronizaciju samo kada ste povezani na Wi-Fi mrežu.';
$string['core.settings.encryptedpushsupported'] = 'Podržano je prosleđivanje šifrovanih obaveštenja';
$string['core.settings.entriesincache'] = 'Broj unosa u keš memoriju: {{$a}}';
$string['core.settings.errorsyncsite'] = 'Greška prilikom sinhronizacije podataka sajta. Molimo, proverite vašu internet vezu i pokušajte ponovo.';
$string['core.settings.estimatedfreespace'] = 'Procenjeni slobodan prostora';
$string['core.settings.filesystemroot'] = 'Osnovni direktorijum sistema datoteka';
$string['core.settings.fontsize'] = 'Veličina teksta';
$string['core.settings.forcedsetting'] = 'Ovo podešavanje je nametnuto konfiguracijom vašeg sajta.';
$string['core.settings.helpusimprove'] = 'Pomozite nam da poboljšamo ovu aplikaciju';
$string['core.settings.ioscookies'] = 'Unakrsno praćenje veb sajtova (Cross-Website Tracking)';
$string['core.settings.ioscookiesdescription'] = 'Ugrađeni sadržaj sa sajta može zahtevati kolačiće na više sajtova kako bi normalno funkcionisao. Da biste to omogućili, idite na iOS podešavanja aplikacije i uključite opciju \'Dozvoli unakrsno praćenje vab sajtova\'';
$string['core.settings.legaldisclaimer'] = 'Pravno ograda (od odgovornosti)';
$string['core.settings.localnotifavailable'] = 'Lokalna obaveštenja dostupna';
$string['core.settings.locationhref'] = 'Webview URL adresa';
$string['core.settings.logintosync'] = 'Prijavite se da biste sinhronizovali';
$string['core.settings.navigatorlanguage'] = 'Jezik navigatora';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Status inernet veze';
$string['core.settings.opensourcelicenses'] = 'Licence otvorenog kôda';
$string['core.settings.privacypolicy'] = 'Politika privatnosti';
$string['core.settings.publisher'] = 'Izdavač';
$string['core.settings.pushid'] = 'ID oznaka prosleđenih obaveštenja';
$string['core.settings.reportinbackground'] = 'Prijavite greške automatski';
$string['core.settings.screen'] = 'Informacije o ekranu';
$string['core.settings.showdownloadoptions'] = 'Prikaži opcije za preuzimanja';
$string['core.settings.siteinfo'] = 'Informacije o sajtu';
$string['core.settings.sitesynccompleted'] = 'Sinhronizacija sajta je završena.';
$string['core.settings.sitesyncfailed'] = 'Sinhronizacija sajta nije uspela';
$string['core.settings.spaceusage'] = 'Iskorištenost prostora';
$string['core.settings.syncdatasaver'] = 'Ušteda podataka: sinhronizujte samo kada ste povezani na Wi-Fi mrežu';
$string['core.settings.synchronization'] = 'Sinhronizacija';
$string['core.settings.synchronizenow'] = 'Sinhronizuj sada';
$string['core.settings.synchronizenowhelp'] = 'Sinhronizacija sajta će poslati promene na čekanju i sve oflajn aktivnosti sačuvane na uređaju. Takođe, biće sinhronizovni i neki podaci kao što su poruke i obaveštenja.';
$string['core.settings.syncsettings'] = 'Podešavanja sinhronizacije';
$string['core.settings.wificonnection'] = 'WiFi veza';
$string['core.settings.youradev'] = 'Sada ste programer';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Izaberite nalog za čuvanje datoteke.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Već postoji datoteka sa ovim nazivom. Da li želite da zamenite postojeću datoteku ili da joj naziv promenite u "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Ne postoje memorisani sajtovi. Molimo, dodajte sajt pre nego što pokušate da podelite datoteke sa aplikacijom.';
$string['core.sharedfiles.nosharedfiles'] = 'Ne postoje deljene datoteke koje se nalaze na ovom sajtu.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Ovde nemate datoteke koje možete da otpremite. Ako želite da otpremite datoteku iz druge aplikacije, pronađite tu datoteku i kliknite na dugme \'Otvori u\'.';
$string['core.sharedfiles.rename'] = 'Promeni naziv';
$string['core.sharedfiles.replace'] = 'Zameni';
$string['core.sharedfiles.sharedfiles'] = 'Deljene datoteke';
$string['core.sharedfiles.successstorefile'] = 'Datoteka je uspešno sačuvana. Izaberete datoteku kako biste je otpremili među svoje privatne datoteke ili iskoristili u nekoj aktivnosti.';
$string['core.sitenotfound'] = 'Sajt nije pronađen';
$string['core.sitenotfoundhelp'] = 'Ne možemo da pronađemo sajt koji ste uneli. Proverite da li postoje greške u kucanju ili pokušajte ponovo kasnije. Ako i dalje vidite ovu poruku obratite osobi koja je odgovorna u vašoj instituciji (školi/organizaciji).';
$string['core.siteunavailablehelp'] = 'Sajt "{{site}}" trenutno nije dostupan. Molimo vas, pokušajte ponovo kasnije ili se obratite osobi koja je odgovorna u vašoj instituciji (školi/organizaciji).';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Izvinite...';
$string['core.start'] = 'Počni';
$string['core.startingtime'] = 'Vreme početka: {{$a}}';
$string['core.storingfiles'] = 'Čuvanje datoteka';
$string['core.submittedoffline'] = 'Predato (oflajn)';
$string['core.swipenavigationtourdescription'] = 'Prevucite prstom nalevo i nadesno';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Aplikacija ne podržava ovo područje oznaka';
$string['core.tag.tagareabadgedescription'] = 'Postoji {{count}} stavke/i.';
$string['core.tag.warningareasnotsupported'] = 'Neka područja oznaka nisu prikazana jer ih aplikacija ne podržava.';
$string['core.thereisdatatosync'] = 'Broj oflajn podatak koje treba sinhronizovati: {{$a}}';
$string['core.toggledelete'] = 'Uključite /isključite dugmad za brisanje';
$string['core.tryagain'] = 'Pokušaj ponovo';
$string['core.turnon'] = 'Uključi';
$string['core.turnonexactalarms'] = 'Uključite upozorenja u realnom vremenu';
$string['core.turnonnotifications'] = 'Uključite obaveštenja';
$string['core.turnonnotificationsmessage'] = 'Da li želite da primate obaveštenja o aktivnostima i zadacima?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh!';
$string['core.unexpectederror'] = 'Neočekivana greška. Zatvorite i ponovo otvorite aplikaciju, a zatim pokušajte ponovo.';
$string['core.unicodenotsupported'] = 'Neki emotikoni nisu podržani na ovom sajtu. Takvi znakovi će biti uklonjeni prilikom slanja poruke.';
$string['core.unicodenotsupportedcleanerror'] = 'Prilikom čišćenja Unicode karaktera pronađen je prazan tekst.';
$string['core.unknown'] = 'Nepoznato';
$string['core.unzipping'] = 'Raspakivanje';
$string['core.updaterequired'] = 'Potrebno je ažuriranje aplikacije';
$string['core.updaterequireddesc'] = 'Ažurirajte aplikaciju na verziju {{$a}}';
$string['core.user.completeprofile'] = 'Popunite profil';
$string['core.user.completeprofilehelp'] = 'Ako imate problema sa popunjavanjem svog profila, pokušajte ponovo kasnije ili se obratite osobi koja je odgovorna u vašoj instituciji (školi/organizaciji).';
$string['core.user.completeprofilenotice'] = 'Pre nego što nastavite, popunite obavezna polja u svom korisničkom profilu.';
$string['core.user.completeprofilereconnectinstructions'] = 'Ako niste ispravno popunili svoj profil, od vas će se tražiti da to uradite ponovo.';
$string['core.user.completeprofilesupportsubject'] = 'Potrebna mi je pomoć da popunim profil';
$string['core.user.completeyourprofile'] = 'Popunite svoj profil';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Podaci o ovom korisniku vam nisu dostupni.';
$string['core.user.errorloaduser'] = 'Greška prilikom učitavanja korisnika.';
$string['core.user.sendemail'] = 'E-pošta';
$string['core.user.support'] = 'Obratite se podršci sajta';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Korisnik sa ID oznakom {{id}}';
$string['core.usernologin'] = 'Provera identiteta za ovaj nalog je opozvana';
$string['core.viewcode'] = 'Prikaži kôd';
$string['core.vieweditor'] = 'Prikaži editor';
$string['core.viewembeddedcontent'] = 'Prikaži ugrađeni sadržaj';
$string['core.wanttochangesite'] = 'Želite da promenite sajt ili da se odjavite?';
$string['core.warningofflinedatadeleted'] = 'Oflajn promene komponente {{component}} \'{{name}}\' su odbačene. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Novije promene ove aktivnosti su napravljene sa drugog uređaja.';
$string['core.warnopeninbrowser'] = '<p>Nameravate da napustiti aplikaciju kako biste otvorili sledeću URL adresu u veb čitaču svog uređaja. Da li želite da nastavite?</p>
<p><b>{{url}}</b></p>';
$string['core.whoissiteadmin'] = '"Administratori sajta" su osobe koji upravljaju Moodleom u vašoj školi (univerzitetu, kompaniji ili obrazovnoj organizaciji). Ako ne znate kako da ih kontaktirate, obratite se svojim predavačima/trenerima.';
$string['core.whyisthishappening'] = 'Zašto se ovo dešava?';
$string['core.wsfunctionnotavailable'] = 'Funkcija veb service nije dostupna.';
$string['core.youreoffline'] = 'Vaš uređaj je oflajn';
$string['core.youreonline'] = 'Vaš uređaj je ponovo onlajn';
$string['core.zoomin'] = 'Povećajte';
$string['core.zoomout'] = 'Smanjite';
$string['freemium.autologoutclosingtheapp'] = 'Odmah nakon napuštanja aplikacije';
$string['freemium.autologoutcustomtime'] = 'Prilagođeno vreme nakon napuštanja aplikacije';
$string['freemium.autologoutdefault'] = 'Podrazumevano';
$string['freemium.autologouttitle'] = 'Automatski se odjavite sa ovog uređaja';
$string['freemium.biometriclogin'] = 'Biometrijska prijava';
$string['freemium.biometriclogindescription'] = 'Stavite prst u čitač otiska prsta.';
$string['freemium.biometricloginenablefaceid'] = 'Uključite FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Uključite Fingerprint';
$string['freemium.biometricloginenabletouchid'] = 'Uključite TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Prijavite se pomoću FaceID-a';
$string['freemium.biometricloginloginwithfingerprint'] = 'Prijavite se pomoću Fingerprinta';
$string['freemium.biometricloginloginwithtouchid'] = 'Prijavite se pomoću TouchID-a';
$string['freemium.biometricloginskip'] = 'Preskoči ovo za sada';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} omogućen.';
$string['freemium.biometricloginturnoff'] = 'Ovu funkciju možete da uključite i isključite u bilo kom trenutku u podešavanjima.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Fingerprint';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Koristite biometrijsko prijavljivanje pomoću otiska prsta ili prepoznavanja lica.';
$string['freemium.change'] = 'Promeni';
$string['freemium.coursesbatchdownloaddisabled'] = 'Preuzimanje kurseva u paketu nije omogućeno za ovaj sajt.';
$string['freemium.coursesdownloadlimitreached'] = 'Ograničenje u broju preuzitih kurseva je dostignuto! Možete da preuzmete samo {{limit}} kursa/eva. Obratite se administratoru da poveća ovo ograničenje ili uklonite neke preuzete kurseve sa svog uređaja.';
$string['freemium.downloadmainapplicationrequired'] = 'Možete se povezati sa ovim veb sajtom samo pomoću namenski kreirane aplikacije.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Sajt sa kojim pokušavate da se povežete ima namenski kreiranu aplikaciju koju biste možda želeli da isprobate.';
$string['freemium.feature_autologout'] = 'Automatska odjava';
$string['freemium.feature_biometriclogin'] = 'Biometrijska prijava';
$string['freemium.feature_coursesdownload'] = 'Preuzeti kursevi';
$string['freemium.feature_multimediapushnotifications'] = 'Multimedijalna prosleđena obaveštenja';
$string['freemium.feature_pushnotificationsdevices'] = 'Uređaji na koje se obaveštenja prosleđuju';
$string['freemium.feature_qrlogin'] = 'Potvrdite identitet pomoću QR kôda';
$string['freemium.feature_remotethemes'] = 'Udaljene teme';
$string['freemium.feature_sitelogo'] = 'Logo sajta';
$string['freemium.notallowed'] = 'Nije dozvoljeno';
$string['freemium.nottoday'] = 'Ne danas';
$string['freemium.qrlogindisabled'] = 'Provera identiteta u aplikaciji pomoću QR kôda nije omogućena za sajt:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'QR kôd je istekao. Osvežite stranicu sa QR kôdom i ponovo je skenirajte.';
$string['freemium.qrloginipmismatch'] = 'Чини се да уређај који користите за повезивање није у истој мрежи као уређај који приказује QR код. Проверите да ли су оба уређаја повезана на исту мрежу (нпр. исту WiFi мрежу).<br><br>Ако се грешка и даље јавља, обратите се администратору свог сајта.';
$string['freemium.ratetheapp'] = 'Da li uživate u našoj aplikaciji?';
$string['freemium.ratetheapp_feedbackko'] = 'Recite nam šta je pošlo naopako';
$string['freemium.ratetheapp_feedbackmessage'] = 'Vaše povratne informacije će biti anonimne';
$string['freemium.ratetheapp_feedbackok'] = 'Pošaljite povratne informacije';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Napišite nešto ovde';
$string['freemium.ratetheapp_feedbacksent'] = 'Hvala! Vaše povratne informacije su uspešno poslate';
$string['freemium.ratetheapp_sendtostore'] = 'Možete li izdvojiti trenutak da ocenite našu aplikaciju? To će nam pomoći da je poboljšamo.';
$string['freemium.remindmelater'] = 'Podseti me kasnije';
$string['freemium.settingsoptions_autologout'] = 'Automatska odjava';
$string['freemium.settingsoptionsfacial'] = 'Omogućite prijavu prepoznavanjem lica';
$string['freemium.settingsoptionsfingerprint'] = 'Omogućite prijavu otiskom prsta';
$string['freemium.subscription'] = 'Pretplata na sajt';
$string['freemium.subscriptiondetails'] = 'Detaljni podaci o pretplati';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = 'Broj prilagođenih jezičkih stringova koji se ignorišu: {{ overflowCount }}';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = 'Broj prilagođenih jezičkih stavki u meniju koji se ignorišu: {{ overflowCount }}';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = 'Broj funkcija koje su, iako konfigurisane kao isključene, još uvek uključene: {{ overflowCount }}';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Vaša prilagođena tema se ne primenjuje';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Logo vašeg sajta se ne primenjuje';
$string['freemium.subscriptionfeature_limited'] = 'Ograničena na {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Neograničeno';
$string['freemium.subscriptionplan'] = 'Plan pretplate';
$string['freemium.subscriptionplan_bma'] = 'BMA';
$string['freemium.subscriptionplan_expired'] = 'istekao';
$string['freemium.subscriptionplan_free'] = 'Besplatno';
$string['freemium.subscriptionplan_premium'] = 'Premijum';
$string['freemium.subscriptionplan_pro'] = 'Pro';
$string['freemium.subscriptionplan_upgrade'] = 'Nadogradite svoj plan';
$string['freemium.subscriptionplan_validuntil'] = 'važi do{{ date }}';
$string['freemium.subscriptionplandescription'] = 'Planovi pretplate pokazuju koja ograničenja se primenjuju za ovaj sajt.';
$string['freemium.subscriptionplanlearnmore'] = 'Saznajte više';
$string['freemium.upsell_renewexpired'] = 'Vaša pretplata je istekla';
$string['freemium.upsell_renewexpiring'] = 'Vaša pretplata ističe za {{ days }} dan/a';
$string['freemium.upsell_renewtitle'] = 'Obnovite pretplatu';
$string['freemium.upsell_upgradefreeaccept'] = 'Nadogradite';
$string['freemium.upsell_upgradefreemessage'] = 'Trenutno koristite besplatni plan, nadogradite kako biste otključali dodatne funkcije.';
$string['freemium.upsell_upgradefreepostpone'] = 'Kasnije';
$string['freemium.upsell_upgradefreetitle'] = 'Nadogradite svoj plan';
$string['pluginname'] = 'Moodle App jezički stringovi';
$string['privacy_metadata'] = 'Ovaj dodatak ne čuva nikakve korisničke podatke.';
$string['workplace.teams.isoverdue'] = 'Ima stavke koje su zakasnele ili istekle';
