<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_learnr', language 'sr_lt', version '4.2'.
 *
 * @package     theme_learnr
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconcoloradministrationsetting'] = 'Boja ikonice aktivnosti za ”Administracija”';
$string['activityiconcoloradministrationsetting_desc'] = 'Boja ikonice aktivnosti za ”Administracija”';
$string['activityiconcolorassessmentsetting'] = 'Boja ikonice aktivnosti za ”Procena”';
$string['activityiconcolorassessmentsetting_desc'] = 'Boja ikonice aktivnosti za ”Procena”';
$string['activityiconcolorcollaborationsetting'] = 'Boja ikonice aktivnosti za ”Saradnja”';
$string['activityiconcolorcollaborationsetting_desc'] = 'Boja ikonice aktivnosti za ”Saradnja”';
$string['activityiconcolorcommunicationsetting'] = 'Boja ikonice aktivnosti za ”Komunikacija”';
$string['activityiconcolorcommunicationsetting_desc'] = 'Boja ikonice aktivnosti za ”Komunikacija”';
$string['activityiconcolorcontentsetting'] = 'Boja ikonice aktivnosti za ”Sadržaj”';
$string['activityiconcolorcontentsetting_desc'] = 'Boja ikonice aktivnosti za ”Sadržaj”';
$string['activityiconcolorinterfacesetting'] = 'Boja ikonice aktivnosti za ”Interfejs”';
$string['activityiconcolorinterfacesetting_desc'] = 'Boja ikonice aktivnosti za ”Interfejs”';
$string['activityiconcolorsheading'] = 'Boje ikonica aktivnosti';
$string['activitynavigation'] = 'Navigacija kroz aktivnosti';
$string['activitynavigationsetting'] = 'Elementi navigacije kroz aktivnosti';
$string['activitynavigationsetting_desc'] = 'Sa ovim podešavanje elementi za prelazak na prethodnu i sledeću aktivnost/resurs, kao i padajući meni za prelazak na određenu aktivnost/resurs će biti prikazani. Ovakvi elementi korisničkog interfejsa su već postojali u Boost temi u osnovnoj instalaciji Moodlea sve do verzije Moodle 3.11, ali su uklonjeni u verziji 4.0. Sa temom LearnR, možete vratiti ove elemente.';
$string['additionalresourcesfileurlpersistent'] = 'URL adresa (trajna)';
$string['additionalresourcesfileurlrevisioned'] = 'URL adresa (revidirana)';
$string['additionalresourcesheading'] = 'Dodatni resursi';
$string['additionalresourceslistsetting'] = 'Spisak dodatnih resursa';
$string['additionalresourceslistsetting_desc'] = 'Ovo je spisak datoteka koje ste postavili u polje za datoteke dodatnih resursa. Navedene URL adrese se mogu koristiti kako biste linkove kao ovim datotekama upotrebili u svom prilagođenom CSS opisu stilova, u fusnoti ili gde god je potrebno da koristite postavljene datoteke, a gde direktno postavljanje datoteka nije moguće.';
$string['additionalresourcessetting'] = 'Dodatni resursi';
$string['additionalresourcessetting_desc'] = 'Sa ovim podešavanjem možete da postavite dodatne resurse u temu. Prednost postavljanje datoteka u ovu polje za datoteka je u tome što se one mogu isporučiti bez provere da li je korisnik prijavljen. To je i razlog zašto treba da dodajete samo datoteke koje nisu kritične. Svima treba da bude dozvoljen pristup koji  ne treba da bude zaštićen validnom prijavom. Čim postavite barem jednu datoteku u ovo polje za datoteke i sačuvate podešavanja, u nastavku ove stranice će se pojaviti spisak koji će vam dati URL adresu koju možete koristiti za povezivanje sa odgovarajućom datotekom.';
$string['backgroundimagesetting'] = 'Pozadinska slika';
$string['backgroundimagesetting_desc'] = 'Ovde možete da postavite prilagođenu sliku koja će biti prikazana kao pozadina sajta. Pozadinska slika koju ovde postavite će zameniti pozadinsku sliku u vašim datotekama  sa predefinisanim podešavanjima teme.';
$string['backgroundimagesheading'] = 'Opšte pozadinske slike';
$string['backtotop'] = 'Povratak na vrh';
$string['backtotopbuttonsetting'] = 'Dugme \'Povratak na vrh\'';
$string['backtotopbuttonsetting_desc'] = 'Sa ovim podešavanjem, dugme za povratak na vrh će se pojaviti u donjem desnom uglu stranice čim korisnik skroluje stranicu nadole. Ovakvo dugme je već postojalo u Boost grafičkoj temi u Moodle osnovnoj instalaciji sve do verzije Moodle 3.11, ali je uklonjeno u verziji 4.0. Uz LearnR, možete povratiti ovo dugme.';
$string['bgdark'] = 'Tamna boja navigacione trake';
$string['bgdark_desc'] = 'Menja vrednost klase .bg-dark class.';
$string['bgwhite'] = 'Svetla boja navigacione trake';
$string['bgwhite_desc'] = 'Menja vrednost klase .bg-white class.';
$string['blockregionoutsidebottomwidth'] = 'Širina regiona blokova za region \'Spolja (dole)\'.';
$string['blockregionoutsidebottomwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Spolja (dole)\' koji se prikazuje ispod glavnog sadržaja. Možete birati između pune širine, širine sadržaja kursa i širine čitavog ekrana.';
$string['blockregionoutsideleftwidth'] = 'Širina regiona blokova za region \'Spolja (levo)\'.';
$string['blockregionoutsideleftwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Spolja (levo)\'. koji se prikazaju levo od glavnog sadržaja. Podrazumevano, LearnR koristi širinu od 300 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 10% ili vrednost širine okvira za prikaz (viewport) kao što je 10vw.';
$string['blockregionoutsiderightwidth'] = 'Širina regiona blokova za region \'Spolja (desno)\'.';
$string['blockregionoutsiderightwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Spolja (desno)\'. koji se prikazaju desno od glavnog sadržaja. Podrazumevano, LearnR koristi širinu od 300 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 10% ili vrednost širine okvira za prikaz (viewport) kao što je 10vw.';
$string['blockregionoutsidetopwidth'] = 'Širina regiona blokova za region \'Spolja (gore)\'.';
$string['blockregionoutsidetopwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Spolja (gore)\' koji se prikazuje na samom vrhu stranice. Možete birati između pune širine, širine sadržaja kursa i širine čitavog ekrana.';
$string['blockregionsforlayout'] = 'Dodatni regioni blokova za stranicu tipa \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Sa ovim podešavanjem možete da omogućite dodatne regione blokova za stranicu tipa \'{$a}\'';
$string['blockregionsheading'] = 'Dodatni regioni blokova';
$string['blockregionsheading_desc'] = '<p>LearnR pruža veliki broj dodatnih regiona za blokove koji se mogu koristiti za dodavanje i prikazivanje blokova na čitavoj Moodle stranici:</p>
<ul><li><em>Spoljni regioni blokova</em> postavljeni su na sve četiri strane Moodle stranice. Mogu se koristiti za prikazivanje blokova koji prate prikazanu Moodle stranicu, ali direktno ne pripadaju glavnom sadržaju.</li>
<li><em>Region blokova zaglavlja</em> se nalazi između regiona Spolja (gore) i glavnog sadržaja stranice. Može se koristiti za prikazivanje bloka kao informacije u zaglavlju kursa.</li>
<li><em>Regioni blokova sadržaja</em> se postavljaju direktno iznad i ispod glavnog sadržaja u regionu glavnog sadržaja. Mogu se koristiti za dodavanje blokova u sam tok sadržaja kursa.</li>
<li><em>Regioni blokova podnožja</em> nalaze se na dnu stranice između regiona Spolja (dole) i fusnote. Imate na raspolaganju tri regiona podnožja za pravljenje stubaca sa blokovima ako je potrebno.</li>
<li>The <em>Region blokova ”Van stranice”</em> je neka vrsta  specijalnog regiona jer se prikazuje preko cele Moodle stranice kao fioka. Fioka se otvara pomoću specijalne ikonice od 9 tačaka (tri reda sa po tri tačkice) smeštene u samom gornjem desnom uglu navigacione trake. Na raspolaganju su vam tri ovakva regiona za kreiranje stubaca sa blokovima ukoliko je to potrebno</li></ul>
<p>Molimo vas da obratite pažnju:</p>
<ul><li>Standardno, svi dodatni regioni blokova su onemogućeni. Omogućite pojedine regione blokova na određenim vrstama stranicama u skladu sa svojim potrebama. Pokušajte da budete što je moguće više fokusirani – previše regiona blokova može dovesti do nepotrebne distrakcije krajnjih korisnika.</li>
<li>Čim se omogući dodatni region blokova, on postaje vidljiv svim autorizovanim korisnicima, a mogu ga uređivati predavači i menadžeri (naravno, u zavisnosti od činjenice da li je određenom korisniku dozvoljeno da uređuje određenu Moodle stranicu). Ali postoje i mogućnosti  theme/learnr:viewregion* i theme/learnr:editregion* koji vam omogućavaju da fino podesite upotrebu svakog regiona sa blokovima zavisno od vaših potreba.</li>
<li>Regioni blokova Spolja (levo), Spolja (desno), Sadržaj (gornji), Sadržaj (donji) i Zaglavlje nisu dostupni za sve vrste stranica.</li></ul>';
$string['blockregionsheading_experimental'] = 'Imajte na umu: <em>regioni blokova Spolja (levo) i Spolja (desno) </em> u potpunosti funkcionišu u trenutnom stanju implementacije, ali se moraju <em>smatrati kao eksperimentalni</em> pošto se još uvek ne prikazuju pravilno na ekranima srednje širine Imajući ovo u vidu, koristite ih pažljivo. Ovaj problem će biti rešen u narednoj verziji grafičke teme.';
$string['blocksgeneralheading'] = 'Opšti
 blokovi';
$string['blockstab'] = 'Blokovi';
$string['bodybg'] = 'Boja pozadine tela stranice';
$string['bodybg_desc'] = 'Promenite boju pozadine tela stranice.';
$string['bootstrapcolordangersetting'] = 'Bootstrap boja za "Opasnost"';
$string['bootstrapcolordangersetting_desc'] = 'Bootstrap boja za "Opasnost"';
$string['bootstrapcolorinfosetting'] = 'Bootstrap boja za "Info"';
$string['bootstrapcolorinfosetting_desc'] = 'Bootstrap boja za "Info"';
$string['bootstrapcolorsheading'] = 'Bootstrap boje';
$string['bootstrapcolorsuccesssetting'] = 'Bootstrap boja za "Uspeh"';
$string['bootstrapcolorsuccesssetting_desc'] = 'Bootstrap boja za "Uspeh"';
$string['bootstrapcolorwarningsetting'] = 'Bootstrap boja za "Upozorenje"';
$string['bootstrapcolorwarningsetting_desc'] = 'Bootstrap boja za "Upozorenje"';
$string['bootstrapdangercolor'] = 'Boja opasnosti';
$string['bootstrapdarkcolor'] = 'Tamna boja';
$string['bootstrapinfocolor'] = 'Info boja';
$string['bootstraplightcolor'] = 'Svetla boja';
$string['bootstrapnone'] = 'Bez Bootstrap boje';
$string['bootstrapprimarycolor'] = 'Primarna boja';
$string['bootstrapsecondarycolor'] = 'Sekundarna boja';
$string['bootstrapsuccesscolor'] = 'Boja uspeha';
$string['bootstrapwarningcolor'] = 'Boja upozorenja';
$string['brandcolorsheading'] = 'Brend boje';
$string['brandingtab'] = 'Brendiranje';
$string['cachedef_flavours'] = 'Vizuelni identiteti koji se primenjuju na datu ID oznaku kategorije stranice za trenutnog korisnika';
$string['cachedef_fontawesome'] = 'FontAwesome datoteke (koje su postavljene u LearnR podešavanjima)';
$string['choosereadme'] = '<p>Grafička tema LearnR je u potpunosti inspirisana temama LearnR i Fordson. Odlikuju je izvanredne karakteristike, poboljšanja korisničkog iskustva (UX) i brojne funkcionalnosti. Da bismo stvari podigli na viši nivo, ugradili smo mnoge karakteristike, stilove i najpopularnije funkcionalnosti teme Fordson.</p><p>LearnR temu održava<br />Moodle an Hochschulen e.V.,</p><p>u saradnji sa<br />lern.link GmbH</p><p>zajedno sa<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Zatvori fioku ”Van stranice”';
$string['configtitle'] = 'LearnR';
$string['configtitlecontent'] = 'Sadržaj';
$string['configtitlefeel'] = 'Navigacija & Blokovi';
$string['configtitleflavours'] = 'Vizuelni identiteti';
$string['configtitlefunctionality'] = 'Funkcionalnost';
$string['configtitlelook'] = 'Izgled';
$string['contactcontentsetting'] = 'Sadržaj stranice za kontakt';
$string['contactcontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici za (što nije isto što i standardna Moodle stranica \'Kontaktirajte podršku sajta\').';
$string['contactdisabled'] = 'Stranica za kontakt je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['contactheading'] = 'Kontakt';
$string['contactlinkpositionboth'] = 'Dodajte link ka stranici za kontakt u fusnotu i na ikonicu u podnožju (znak pitanja).';
$string['contactlinkpositionfooter'] = 'Dodajte link ka stranici za kontakt na ikonicu u podnožju (znak pitanja).';
$string['contactlinkpositionfootnote'] = 'Dodajte link ka stranici za kontakt u fusnotu';
$string['contactlinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici za kontakt';
$string['contactlinkpositionsetting'] = 'Pozicija link ka stranici za kontakt';
$string['contactlinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici za kontakt automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['contactpagetitledefault'] = 'Kontakt';
$string['contactpagetitlesetting'] = 'Naslov stranice za kontakt';
$string['contactpagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice za kontakt. Ovaj tekst će se takođe koristiti kao tekst linka ka stranici za kontakt ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici za kontakt\'.';
$string['contentwidthheading'] = 'Širina sadržaja';
$string['courseactivitiesbtntext'] = 'Aktivnosti na kursu';
$string['courseblockpanelbtn'] = 'Upravljanje kursom';
$string['courseblockpanelbtnclose'] = 'Zatvori';
$string['courseboxheight'] = 'Visina pločice kursa';
$string['courseboxheight_desc'] = 'Kontrolišite visinu pločice kursa na naslovnoj strani i na stranici kategorije kurseva.';
$string['coursecontentmaxwidthsetting'] = 'Maksimalna širina sadržaja kursa';
$string['coursecontentmaxwidthsetting_desc'] = 'Sa ovim podešavanjem, možete izmeniti širinu sadržaja Moodle kursa bez ručnih izmena SCSS skupa stilova. Ova širina se koristi kao širina stranice na stranicama kursa i u okviru nekoliko aktivnosti. Standardno, Moodle koristi maksimalnu širinu sadržaja kursa od 830 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 1200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 100% ili vrednost širine okvira za prikaz (viewport) kao što je 90vw.';
$string['courseenrollmentcode'] = 'Kôd za upis na kurs';
$string['courseheaderheading'] = 'Zaglavlje kursa';
$string['courseheaderimageenabled'] = 'Prikažite sliku kursa u zaglavlju kursa';
$string['courseheaderimageenabled_desc'] = 'Kada je omogućena ova opcija, slika kursa (koja se može postaviti u podešavanjima kursa) je prikazana, kako u zaglavlju kursa, isto tako i na stranici \'Moji kursevi\' gde su uvek slike kurseva i prikazaju.';
$string['courseheaderimagefallback'] = 'Rezervna slika zaglavlja kursa';
$string['courseheaderimagefallback_desc'] = 'Ako postavite sliku u ovom podešavanju, ona će se koristi kao rezervna slika i biće prikazana se u zaglavlju kursa ako slika kursa nije postavljena u podešavanjima nekog kursa. Ako pak ovde ne postavite sliku, slika zaglavlja kursa će biti prikazana samo u određenom kursu ukoliko je slika kursa učitana u podešavanjima ovog konkretnog kursa.';
$string['courseheaderimageheight'] = 'Visina slike zaglavlja kursa';
$string['courseheaderimageheight_desc'] = 'Sa ovim podešavanjem kontrolišete visinu prikazane slike zaglavlja kursa.';
$string['courseheaderimagelayout'] = 'Izgled slike zaglavlja kursa';
$string['courseheaderimagelayout_desc'] = 'Sa ovim podešavanjem kontrolišete izgled slike zaglavlja kursa i naslova kursa.';
$string['courseheaderimagelayoutheadingabove'] = 'Naslov kursa iznad slike kursa';
$string['courseheaderimagelayoutstackeddark'] = 'Naslov kursa preko slike kursa (bela boja fonta za tamne pozadinske slike)';
$string['courseheaderimagelayoutstackedlight'] = 'Naslov kursa preko slike kursa (crna boja fonta za svetle pozadinske slike)';
$string['courseheaderimageposition'] = 'Pozicija slike zaglavlja kursa';
$string['courseheaderimageposition_desc'] = 'Sa ovim podešavanjem kontrolišete pozicioniranje slike unutar kontejnera slike zaglavlja kursa. Prva vrednost je horizontalni a druga vertikalni položaj.';
$string['coursemanagementbutton'] = 'Upravljanje kursom';
$string['coursemanagetitle'] = 'Kurs';
$string['courserelatedhintsheading'] = 'Saveti vezani za kurs';
$string['coursestab'] = 'Kursevi';
$string['coursestyle1'] = 'Stil pločica jedan';
$string['coursestyle2'] = 'Stil pločica dva';
$string['coursestyle3'] = 'Stil pločica tri';
$string['coursestyle4'] = 'Stil pločice četiri sa rezimeom kursa';
$string['coursestyle5'] = 'Horizontalni stil jedan';
$string['coursestyle6'] = 'Horizontalna pozadinska slike sa svim detaljima';
$string['coursestyle7'] = 'Horizontalna pozadinska slike samo sa naslovom i imenima predavača';
$string['coursestyle8'] = 'Standardni prikaz Moodle kursa';
$string['coursetab'] = 'Kurs';
$string['coursetilestyle'] = 'Prikaz pločica kurseva';
$string['coursetilestyle_desc'] = 'Kada gledate kategorije kurseva, možete birati između sledećih stilova za prikaz kurseva na početnoj stranici i u području kategorija kurseva.';
$string['createinfo'] = 'Specijalno dugme za kreiranje kursa';
$string['createinfodesc'] = 'Ovo dugme se pojavljuje na početnoj stranici kada korisnik može da kreira nove kurseve. Dugme će videti oni sa ulogom kreatora kursa na nivou sajta.';
$string['cssh5pheading'] = 'Neobrađeni CSS za H5P';
$string['cssh5psetting'] = 'Neobrađeni CSS za H5P';
$string['cssh5psetting_desc'] = 'Koristite ovo polje kako biste naveli CSS kôd koji će moduli mod_h5p i mod_hvp primeniti na prezentaciju H5P sadržaja. Pregledajte H5P tipove sadržaja kako biste pronašli potrebne CSS selektore.';
$string['customfontsfileurlpersistent'] = 'URL adresa (trajna)';
$string['customfontsfileurlrevisioned'] = 'URL adresa (revidirana)';
$string['customfontsheading'] = 'Prilagođeni fontovi';
$string['customfontslistsetting'] = 'Spisak prilagođenih fontova';
$string['customfontslistsetting_desc'] = 'Ovo je spisak fontova koje ste postavili u polje za datoteke prilagođenih fontova. Dati CSS odlomci kôda se mogu koristiti za dodavanje ovih fontova u vaš prilagođeni SCSS. Imajte na umu da ćete za sada morati sami da vodite računa o vrednosti formata fonta, kao i o CSS svojstvima porodice fontova, stila fonta i težine fonta jer LearnR još uvek nije u stanju da analizira sintaksu datoteke fontova.';
$string['customfontssetting'] = 'Prilagođeni fontovi';
$string['customfontssetting_desc'] = 'Sa ovim podešavanjem možete da postavite prilagođene fontove u temu. Prednost postavljanja fontova u ovaj prostor za datoteke je u tome što se ti fontovi mogu isporučiti bez provere da li je korisnik prijavljen i mogu se koristiti kao lokalno instalirani fontovi svuda na sajtu. Čim postavite barem jedan font u ovo područje za datoteka i sačuvate podešavanja, ispod će se pojaviti spisak koja će vam dati CSS odlomke kôda koje možete koristiti kao šablon za referenciranje određenih fontova u vašem prilagođenom SCSS-u.';
$string['drawerbg'] = 'Boja pozadine fioke';
$string['drawerbg_desc'] = 'Promenite boju pozadine fioke.';
$string['easyenrollbtn'] = 'Kôdovi za upis';
$string['emailbrandinghtmldemobody'] = '<p>Telo e-poruke ovde počinje.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Telo e-poruke se ovde završava.</p>';
$string['emailbrandinghtmlheading'] = 'Pregled e-pošte - HTML';
$string['emailbrandinghtmlintro'] = 'Ovo je pregled e-pošte u HTML formatu, zasnovane na prefiksima i sufiksima brendiranja koji su trenutno podešeni u jezičkom paketu.';
$string['emailbrandinghtmlnopreview'] = 'Do sada, e-poruke u HTML formatu nisu bile prilagođene u okviru ove funkcije. E-poruke će se sastavljati i slati normalno.';
$string['emailbrandinginstruction'] = 'Kako da';
$string['emailbrandinginstruction0'] = 'Sa ovom LearnR funkcijom, možete primeniti brendiranje na svu e-poštu koju Moodle šalje.';
$string['emailbrandinginstructionli1'] = 'Idite na <a href="{$a->url}" target="_blank">stranicu za prilagođavanje jezika</a> kako biste otvorili <em>{$a->lang}</em> jezički paket za uređivanje.';
$string['emailbrandinginstructionli2'] = 'Potražite i izmenite ove stringove u <code>theme_learnr</code> jezičkom paketu:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Ovaj isečak kôda će biti dodat <em>na početak / pre tela</em> svih <em>e-poruka u HTML formatu</em> koje Moodle šalje.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Ovaj isečak kôda će biti dodat   <em>na kraj / nakon tela</em> svih <em>e-poruka u HTML formatu</em> koje Moodle šalje.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Ovaj isečak kôda će biti dodat <em>na početak / pre tela</em> svih <em> e-poruka u formatu običnog teksta </em> koje Moodle šalje.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Ovaj isečak kôda će biti dodat <em>na kraj / nakon tela</em> svih <em> e-poruka u formatu običnog teksta </em> koje Moodle šalje.';
$string['emailbrandinginstructionli3'] = 'Sačuvajte promene jezičkog paketa.';
$string['emailbrandinginstructionli4'] = 'Vratite se na ovu stranicu i pogledajte preglede e-pošte u nastavku ove stranice.';
$string['emailbrandingintroheading'] = 'Uvod';
$string['emailbrandingintronote'] = 'Imajte na umu: ovo je napredna funkcionalnost koja koristi neka zaobilazna rešenja kako bi se obezbedile opcija za brendiranje e-pošte. Molimo vas da pažljivo pratite uputstva.';
$string['emailbrandingpitfalls'] = 'Zamke';
$string['emailbrandingpitfalls0'] = 'Koristeći ovu funkciju, trebalo bi da bude te svesni nekih zamki koje postoje:';
$string['emailbrandingpitfallsli1'] = 'Obavezno je da izmenite stringove jezičkog paketa <em>trenutnog podrazumevanog jezika</em> na ovom sajtu. Čak i ako imate instalirano više jezičkih paketa, efekta će imati samo promene podrazumevanog jezika će.';
$string['emailbrandingpitfallsli2'] = 'Uvažavanje jezika primaoca e-pošte nije moguće. Zbog toga, trebalo bi da koristite jezički neutralne termine u okviru odlomaka kôda za brendiranja e-pošte.';
$string['emailbrandingpitfallsli3'] = 'Ako ikada promenite podrazumevani jezik sajta u budućnosti, moraćete da migrirate izmenjene stringove jezičkog paketa u novi podrazumevani jezički paket.';
$string['emailbrandingpitfallsli4'] = 'U e-porukama formatu običnog teksta, postoji prelom reda i prazan red koji se automatski dodaje posle prefiksa, kao i prazan red koji se automatski dodaje ispred sufiksa. Ovo je zato da bi se osiguralo da sufiks i prefiks ne stoje direktno uz telo e-poruke.';
$string['emailbrandingpitfallsli5'] = 'U e-porukama u HTML formatu, prefiks i sufiks se direktno dodaju ispred i iznad tela e-poruke. Ovo je zato da biste bili sigurni da možete lako da radite sa HTML oznakama, ali ćete morati sami da vodite računa o svim razmacima oko tela e-poruke.';
$string['emailbrandingpitfallsli6'] = 'U e-porukama u HTML formatu, možete otvoriti HTML oznaku u isečku kôda prefiksa i zatvoriti oznaku u isečku kôda sufiksa bez problema. Samo zapamtite da kreirate ispravan HTML u rezultirajućoj e-poruci.';
$string['emailbrandingtab'] = 'Brendiranje e-pošte';
$string['emailbrandingtextdemobody'] = 'Telo e-poruke ovde počinje.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Telo e-poruke se ovde završava.';
$string['emailbrandingtextheading'] = 'Pregled e-pošte - običan tekst';
$string['emailbrandingtextintro'] = 'Ovo je pregled e-pošte u formatu običnog teksta, zasnovane na prefiksima i sufiksima brendiranja koji su trenutno podešeni u jezičkom paketu.';
$string['emailbrandingtextnopreview'] = 'Do sada, e-poruke u formatu običnog teksta nisu bile prilagođene u okviru ove funkcije. E-poruke će se sastavljati i slati normalno.';
$string['enablecontactsetting'] = 'Omogući stranicu za kontakt';
$string['enablehelpsetting'] = 'Omogući stranicu za pomoć';
$string['enableimprintsetting'] = 'Omogući impresum';
$string['enablemaintenancesetting'] = 'Omogući stranicu sa informacijama o održavanju';
$string['enrollcoursecard'] = 'Prikaži kurs';
$string['error:infobannerdismissnonotdismissible'] = 'Dati info baner se ne može odbaciti';
$string['error:infobannerdismissnonotvalid'] = 'Navedeni broj info banera nije ispravan';
$string['exporttomistar'] = 'Izvoz u MIStar';
$string['faviconheading'] = 'Favikonica';
$string['faviconheading_desc'] = 'Imajte na umu: LearnR ima sopstveno polje za postavljanje favikonice i ne koristi favikonicu iz <a href="{$a}">podešavanja favikonice osnovne instalacije Moodlea</a>.<br />LearnR vam posebno omogućava da zaobiđete postavljenu favikonicu u okviru njegovih vizuelnih identiteta .';
$string['faviconsetting'] = 'Favikonica';
$string['faviconsetting_desc'] = 'Ovde možete da postavite prilagođenu sliku (u .ico ili .png formatu) koju će veb čitač prikazati kao favikonicu vašeg Moodle sajta. Ako ne postavite svoju prilagođenu favikonicu, koristiće se standardna Moodle favikonica.';
$string['flavoursappliesto'] = 'Primenjuje se na';
$string['flavoursapplytocategories'] = 'Primenite na kategorije kurseva';
$string['flavoursapplytocategories_help'] = 'Ovde definišete da li ovaj vizuelni identitet treba primeniti na kategorije kurseva.';
$string['flavoursapplytocategories_ids'] = 'Kategorije kurseva';
$string['flavoursapplytocategories_ids_help'] = 'Ovde definišete jednu ili više zasebnih kategorija kurseva na koje treba primeniti ovaj vizuelni identitet. Čim se prikazana Moodle stranica nalazi unutar jedne od konfigurisanih kategorija kursa, vizuelni identitet će biti primenjen.';
$string['flavoursapplytocohorts'] = 'Primenite na kohorte';
$string['flavoursapplytocohorts_help'] = 'Ovde definišete da li ovaj vizuelni identitet treba primeniti na kohorte.';
$string['flavoursapplytocohorts_ids'] = 'Kohorte';
$string['flavoursapplytocohorts_ids_help'] = 'Ovde definišete jednu ili više zasebnih kohorti na koje treba primeniti ovaj vizuelni identitet. Čim je korisnik član jedne od konfigurisanih kohorti, vizuelni identitet će biti primenjen.<br /><br />Imajte u vidu da, ako definišete više od jedne kohorte, nema potrebe da korisnik bude član svih kohorti u isto vreme.<br /><br />Takođe, imajte na umu da se u trenutnom stanju implementacije kohorte tretiraju kao da su sistemske.';
$string['flavoursbackgroundimage'] = 'Pozadinska slika';
$string['flavoursbackgroundimage_help'] = 'Sa ovim podešavanjem vizuelni identitet će zameniti pozadinsku sliku koja je konfigurisana u podešavanjima izgleda teme LearnR.';
$string['flavoursbacktooverview'] = 'Nazad na pregled vizuelnih identiteta';
$string['flavourscreateflavour'] = 'Kreiraj vizuelni identitet';
$string['flavourscustomcss'] = 'Prilagođeni CSS';
$string['flavourscustomcss_help'] = 'Sa ovim podešavanjem možete uneti prilagođeni CSS za vizuelni identitet. Biće dodat u stek CSS kôda koji se šalje veb čitaču čim se primeni vizuelni identitet. Imajte na umu da u trenutnom stanju implementacije, ovo podešavanje dozvoljava korišćenje samo prilagođenog CSS-a, ali ne i SCSS-a.';
$string['flavoursdelete'] = 'Obriši';
$string['flavoursdeleteconfirmation'] = 'Da li zaista želite da obrišete vizuelni identitet <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Obriši vizuelni identitet';
$string['flavoursdescription'] = 'Opis';
$string['flavoursdescription_help'] = 'Opis vizuelnog identiteta koristi se interno samo kako bi vam omogućio da identifikujete određeni vizuelni identitet na spisku.';
$string['flavoursedit'] = 'Uredi';
$string['flavourseditflavour'] = 'Uredi vizuelni identitet';
$string['flavoursfavicon'] = 'Favikonica';
$string['flavoursfavicon_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti favikonicu koja je konfigurisana u podešavanjima izgleda LearnR teme.';
$string['flavoursflavours'] = 'Vizuelni identiteti';
$string['flavoursgeneralsettings'] = 'Opšta podešavanja';
$string['flavoursincludesubcategories'] = 'Uključite potkategorije';
$string['flavoursincludesubcategories_help'] = 'Ako je označeno, vizuelni identitet će biti primenjen i na potkategorije izabranih kategorija.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti logotip koji je konfigurisan u podešavanjima izgleda teme LearnR.';
$string['flavourslogocompact'] = 'Kompaktan logo';
$string['flavourslogocompact_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti logotip koji je konfigurisan u podešavanjima izgleda teme LearnR.';
$string['flavoursnothingtodisplay'] = 'Još uvek nije kreiran nijedan vizuelni identitet. Molimo vas da napravite svoj prvi vizuelni identitet kako biste pokrenuli stvari.';
$string['flavoursnotificationcreated'] = 'Vizuelni identitet je uspešno kreiran';
$string['flavoursnotificationdeleted'] = 'Vizuelni identitet je uspešno obrisan';
$string['flavoursnotificationedited'] = 'Vizuelni identitet je uspešno editovan';
$string['flavoursoverview_desc'] = '<p>Vizuelni identiteti LearnR tema nude mogućnost da izmenite  pojedina podešavanja izgleda Moodlea u određenim kontekstima. Na ovoj stranici možete kreirati vizuelne identitete i upravljati njima.</p><p>Unutar svakog identiteta definišete da li ga treba primeniti na određene kategorije kurseva ili određene kohorte. Nakon toga, tokom svakog prikazivanja Moodle stranice, LearnR proverava da li je vizuelni identitet primenljiv. Imajte na umu da se za svako prikazivanje Moodle stranice primenjuje samo prvi odgovarajući vizuelni identitet sa spiska, a preostali se zanemaruju. Stoga je redosled vizuelnih identiteta na ovoj stranici ključan.</p><p>Takođe imajte na umu da se nakon svake promene koju napravite u skupu vizuelnih
 identiteta, keš teme čisti. Ovo je neophodno kako biste bili sigurni da su veb čitaču sva podešavanja isporučena propisno i ažurno.</p>';
$string['flavourspreview'] = 'Pregled';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Pregled vizuelnog identiteta';
$string['flavourstitle'] = 'Naslov';
$string['flavourstitle_help'] = 'Naslov vizuelnog identiteta se koristi samo interno da bi vam omogućio da dokumentujete određeni identitet na listi vizuelnih identiteta.';
$string['fontawesomecheck-fa6free-fallback-description'] = 'Novije FontAwesome verzije koriste identifikatore starijih ikonica kako bi ih remapirali na novije ikonice (ili, kako bi neke od njih odstranili). Ako vidite mapu ikonice homogenog (solidnog) izgleda na levoj strani, vaša FontAwesome verzija 6 ispravno prikazuje remapirane ikonice iz FontAwesome verzije 4.';
$string['fontawesomecheck-fa6free-fallback-title'] = 'FontAwesome 4 rezerva';
$string['fontawesomecheck-fa6free-filter-description'] = 'Pošto imate instaliran dodatak za FontAwesome filter, trebalo bi da budete sigurni da filter pravilno rukuje novim FontAwesome 6 ikonicama. Ako vidite ikonicu korisnika na levoj strani, filter radi ispravno sa ikonicama FontAwesome verzije 6.';
$string['fontawesomecheck-fa6free-filter-title'] = 'FontAwesome filter';
$string['fontawesomecheck-fa6free-general-description'] = 'Ako vidite ikonicu štrikle na levoj strani, FontAwesome generalno normalno funkcioniše na vašem sajtu.';
$string['fontawesomecheck-fa6free-general-title'] = 'Opšta funkcionalnost';
$string['fontawesomecheck-fa6free-newstuff-description'] = 'U poređenju sa FontAwesome 4 skupom ikonica, novije FontAwesome verzije isporučuju se sa dodatnim ikonicama  Ako vidite ikonicu virusa na levoj strani, vaša FontAwesome 6 verzija ispravno prikazuje nove ikonice.';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'FontAwesome 6 ikonice';
$string['fontawesomecheckssetting'] = 'FontAwesome provere';
$string['fontawesomecheckssetting_desc'] = 'Ovde možete vizuelno da proverite da li su FontAwesome datoteke pravilno postavljene i dodate na Moodle stranicu. Ako jedna od provera ne uspe, proverite još jednom da li ste ispravno postavili sve obavezne datoteke.';
$string['fontawesomefilessetting'] = 'FontAwesome datoteke';
$string['fontawesomefilessetting_desc'] = 'Sa ovim podešavanjem možete da postavite novije FontAwesome datoteke u Moodle. Morate sami da postavite FontAwesome datoteka u Moodle zbog ograničenja vezanih za licenciranja. Idite na <a href="https://fontawesome.com">fontawesome.com</a>, preuzmite FontAwesome paket i postavite ga ovde.';
$string['fontawesomefilesstructurenote'] = 'Imajte na umu da datoteke moraju biti postavljene sa pravilnom strukturom direktorijuma i ispravnim nazivima datoteka. Počnite kreiranjem <em>css</em> i <em>webfonts</em> direktorijuma u biraču datoteka, postavite <em>fa-solid-900.woff2</em> datoteku u <em>webfonts</em> direktorijum i sačuvajte stranicu sa podešavanjima. Čim to uradite, u nastavku će se pojaviti spisak datoteka koji vam pomaže da identifikujete i postavite prave datoteke u ove direktorijume.';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Ovo je dodatna CSS datoteka koja dodaje font za FontAwesome brend ikonice na Moodle stranicu.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Ovo je glavna CSS datoteka koja dodaje sve dostupne FontAwesome glifove na Moodle stranicu.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Ovo je dodatna CSS datoteka koja dodaje font za FontAwesome obične ikonice na Moodle stranicu.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Ovo je dodatna CSS datoteka koja dodaje font za FontAwesome ikonice homogenog (solidnog) izgleda na Moodle stranicu.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Ovo je CSS datoteka koja osigurava da se FontAwesome 4 ikonice i dalje pravilno prikazuju u Moodleu.';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.ttf'] = 'Ovo je datoteka fonta za FontAwesome brend ikonice (u TTF formatu).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.woff2'] = 'Ovo je datoteka fonta za FontAwesome brend ikonice (u WOFF2 formatu).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.ttf'] = 'Ovo je datoteka fonta za FontAwesome obične ikonice (u TTF formatu).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.woff2'] = 'Ovo je datoteka fonta za FontAwesome obične ikonice (u WOFF2 formatu).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.ttf'] = 'Ovo je datoteka fonta za FontAwesome ikonice homogenog (solidnog) izgleda (u TTF formatu).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.woff2'] = 'Ovo je datoteka fonta za FontAwesome ikonice homogenog (solidnog) izgleda (u WOFF2 formatu).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.ttf'] = 'Ovo je datoteka fonta za kompatibilnost FontAwesome verzijom 4 (u TTF formatu).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.woff2'] = 'Ovo je datoteka fonta za kompatibilnost FontAwesome verzijom 4 (u WOFF2 formatu).';
$string['fontawesomelistmandatorymissing'] = 'Ovo je obavezna datoteka koja omogućava da FontAwesome funkcioniše, ali nije pravilno učitana. Pokušajte da je pravilno postavite.';
$string['fontawesomelistmandatoryuploaded'] = 'Ovo je obavezna datoteka koja omogućava da FontAwesome funkcioniše, i pravilno je postavljena.';
$string['fontawesomelistnote'] = 'Imajte na umu da, ukoliko postavite samo delić obaveznih datoteka, FontAwesome ikonice mogu izgledati kao pokvarene na Moodle stranici. Ovo se ne može popraviti dok ne postavite sve obavezne datoteke ili ponovo uklonite sve datoteke.';
$string['fontawesomelistoptionalmissing'] = 'Ovo je opciona datoteka za poboljšanje skupa FontAwesome ikonica  ali nije postavljena. Ovo je sasvim OK, sve dok vam ova datoteka ne zatreba.';
$string['fontawesomelistoptionaluploaded'] = 'Ovo je opciona datoteka za poboljšanje skupa FontAwesome ikonica i pravilno je postavljena.';
$string['fontawesomelistsetting'] = 'Spisak FontAwesome datoteka';
$string['fontawesomelistsetting_desc'] = 'Ovo je spisak FontAwesome datoteka koje ste postavili na server u gornje prostor za FontAwesome datoteke. Ovde su navedene sve datoteke koje su validne za konfigurisanu FontAwesome verziju; druge datoteke koje ste možda postavili, ali koji nisu validne ili potrebne FontAwesome datoteke se zanemaruju. FontAwesome datoteke se automatski dodaju na Moodle stranice i imaju neposredan efekat čim sačuvate ovo podešavanje.';
$string['fontawesomeversionfa6free'] = 'Besplatno ažuriranje na FontAwesome 6';
$string['fontawesomeversionnone'] = 'Zadržite FontAwesome 4 (kako je isporučeno sa Moodle osnovnom instalacijom)';
$string['fontawesomeversionsetting'] = 'FontAwesome verzija';
$string['fontawesomeversionsetting_desc'] = 'Osnovna Moodle instalacija se isporučuje sa  FontAwesome 4 ikonicama koje su sasvim OK, ali je FontAwesome prilično unapređen. Ukoliko želite da koristite novije FontAwesome ikonice, to možete učiniti pomoću ovog podešavanja. Čim izaberete drugu verziju, osim FontAwesome 4, pojaviće se dodatna podešavanja gde možete da postavite novije FontAwesome verzije.';
$string['footertab'] = 'Podnožje';
$string['footnoteheading'] = 'Fusnota';
$string['footnotesetting'] = 'Fusnota';
$string['footnotesetting_desc'] = 'Šta god da dodate u ovo tekstualno polje, sadržaj će biti prikazan na kraju stranice, u podnožju (ne u plutajućem podnožju) na svakoj stranici koja koristi rasporede "drawers", "columns2" ili "login". Sadržaj u ovom polje mogu biti, na primer autorska prava, uslovi korišćenja ili naziv vaše organizacije.<br/> Ako želite ponovo da uklonite fusnotu, samo obrišite sadržaj tekstualnog polja.';
$string['gradebooktitle'] = 'Knjiga ocena';
$string['h5pcontentmaxwidthsetting'] = 'Maksimalna širina H5P banke sadržaja';
$string['h5pcontentmaxwidthsetting_desc'] = 'Sa ovim podešavanjem, možete izmeniti širinu Moodle H5P banke sadržaja kursa bez ručnih izmena SCSS skupa stilova. Ova širina se koristi za H5P editor unutar banke sadržaja. Ona se <em>ne</em> koristi za širinu H5P aktivnosti. Standardno, Moodle koristi maksimalnu širinu H5P banke sadržaja od 960 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 1200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 100% ili vrednost širine okvira za prikaz (viewport) kao što je 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Sadržaj stranice za pomoć';
$string['helpcontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici za pomoć.';
$string['helpdisabled'] = 'Stranica za pomoć je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['helpheading'] = 'Pomoć';
$string['helplinkpositionboth'] = 'Dodajte link ka stranici za pomoć u fusnotu i na ikonicu u podnožju (znak pitanja).';
$string['helplinkpositionfooter'] = 'Dodajte link ka stranici za pomoć na ikonicu u podnožju (znak pitanja).';
$string['helplinkpositionfootnote'] = 'Dodajte link ka stranici za pomoć
 u fusnotu';
$string['helplinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici za pomoć';
$string['helplinkpositionsetting'] = 'Pozicija linka ka stranici za pomoć';
$string['helplinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici za pomoć automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['helppagetitledefault'] = 'Pomoć';
$string['helppagetitlesetting'] = 'Naslov stranice za pomoć';
$string['helppagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice za pomoć. Ovaj tekst će se koristiti i kao tekst linka ka stranici za pomoći ako u skladu sa tim konfigurišete podešavanje \'Pozicija linka ka stranici za pomoć\'.';
$string['hideloginform'] = 'Sakrij obrazac za prijavu';
$string['hideloginform_desc'] = '<b>BUDITE PAŽLJIVI! Provera ove funkcije će ukloniti obrazac za prijavu.</b> Sakrijte obrazac za prijavu samo ako koristite neki drugi metod prijavljivanja, kao što je npr. Google Login, i kada nikada nemate potrebu da koristite obrazac za prijavu. Da biste se povratili obrazac, morate da uklonite datoteku  /moodle/theme/learnr/templates/core/loginform.mustache. Brisanje ove datoteke će omogućiti da se obrazac za prijavu ponovo pojavi, u slučaju da nikako ne budete mogli da pristupite obrascu.';
$string['hidenodesprimarynavigationsetting'] = 'Sakrij čvorove u primarnoj navigaciji';
$string['hidenodesprimarynavigationsetting_desc'] = 'Sa ovim podešavanjem možete da sakrijete jedan ili više čvorova iz primarne navigacije';
$string['iconnavbartab'] = 'Navigacija ikonicama';
$string['iconnavheading'] = 'Navigacija ikonicama';
$string['iconnavinfo'] = 'Kontrolni panel - navigacija ikonicama';
$string['iconnavinfo_desc'] = 'Kreirajte dugmad sa ikonicama za upotrebu na početnoj stranici. Dugmad se pojavljuju na vrhu stranice na kontrolnom panelu.';
$string['imprintcontentsetting'] = 'Sadržaj impresuma';
$string['imprintcontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici sa impresumom.';
$string['imprintdisabled'] = 'Stranica sa impresumom je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['imprintheading'] = 'Impresum';
$string['imprintlinkpositionboth'] = 'Dodajte link ka stranici sa impresumom u fusnotu i na ikonicu u podnožju (znak pitanja).';
$string['imprintlinkpositionfooter'] = 'Dodajte link ka stranici sa impresumom na ikonicu u podnožju (znak pitanja).';
$string['imprintlinkpositionfootnote'] = 'Dodajte link ka stranici sa impresumom u fusnotu';
$string['imprintlinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici sa impresumom';
$string['imprintlinkpositionsetting'] = 'Pozicija linka ka stranici sa impresumom';
$string['imprintlinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici sa impresumom automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['imprintpagetitledefault'] = 'Impresum';
$string['imprintpagetitlesetting'] = 'Naslov stranice sa impresumom';
$string['imprintpagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice sa impresumom. Ovaj tekst će se koristiti i kao tekst linka ka stranici sa impresumom ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici sa impresumom\'.';
$string['infobannerbsclasssetting'] = 'Bootstrap klasa info banera {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'Sa ovim podešavanjem, možete da izaberete Bootstrap stil sa kojim će info baner {$a->no} biti prikazan. Ako izaberete opciju \'Bez Bootstrap boje\', info baner će biti prikazan bez bilo kakve Bootstrap boje, što vam daje slobodu da sami stilizujete baner u editoru teksta.';
$string['infobannerclose'] = 'Zatvori';
$string['infobannercontentsetting'] = 'Sadržaj info banera {$a->no}';
$string['infobannercontentsetting_desc'] = 'Ovde unosite informacije koje treba da budu prikazane u info baneru {$a->no}.';
$string['infobannerdismissconfirm'] = 'Da li zaista želite da resetujete vidljivost info banera {$a->no} i da ga ponovo prikažete svim korisnicima koji su ga prethodno odbacili?';
$string['infobannerdismissfail'] = 'Resetovanje vidljivosti info banera {$a->no} nije uspelo za najmanje jednog korisnika';
$string['infobannerdismissiblesetting'] = 'Info baner {$a->no} se može odbaciti';
$string['infobannerdismissiblesetting_desc'] = 'Sa ovim podešavanjem možete učiniti da info baner {$a->no} može da se odbaci. Ako korisnik klikne na dugme  X u info baneru, baner će za ovog korisnika biti trajno sakriven. Vidljivost se nikako ne resetuje automatski, čak i ako promenite sadržaj info banera. Ako želite da resetujete vidljivost info banera, kliknite na dugme \'Resetuj vidljivost\'.';
$string['infobannerdismissreset'] = 'Resetuj vidljivost odbačenog info banera';
$string['infobannerdismissresetbutton'] = 'Resetuj vidljivost info banera {$a->no}';
$string['infobannerdismisssuccess'] = 'Vidljivost info banera {$a->no} je resetovana';
$string['infobannerenabledsetting'] = 'Omogući info baner {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Sa ovim podešavanjem možete omogućiti info baner {$a->no}.';
$string['infobannerendsetting'] = 'Vreme završetka prikazivanja info banera {$a->no}';
$string['infobannerendsetting_desc'] = 'Sa ovim podešavanjem možete da definišete do kada treba da bude prikazan info baner {$a->no}. Konfigurisano vreme se tretira kao vreme servera, a ne kao vreme korisnika.';
$string['infobannerheading'] = 'Info baner {$a->no}';
$string['infobannermodeperpetual'] = 'Trajno';
$string['infobannermodesetting'] = 'Režim prikaza info banera {$a->no}';
$string['infobannermodesetting_desc'] = 'Sa ovim podešavanjem možete da definišete da li info baner {$a->no} treba da bude trajni (koji se uvek prikazuje) ili vremenski ograničeni baner (koji se prikazuje samo u konfigurisanom vremenskom intervalu)';
$string['infobannermodetimebased'] = 'Vremenski ograničeno';
$string['infobannerordersetting'] = 'Pozicija info banera {$a->no}';
$string['infobannerordersetting_desc'] = 'Sa ovim podešavanjem definišete poziciju info banera {$a->no}. Standardno, info baneri su poređani odozgo prema dole, kao što ih vidite na ovoj stranici sa podešavanjima. Međutim, sa ovim podešavanjem možete info baneru da dodelite drugu poziciju. Ako dodelite istu poziciju za dva ili više info banera, oni će biti ponovo poređani prema redosledu na ovoj stranici sa podešavanjima.';
$string['infobannerpageloginpage'] = 'Stranica za prijavu';
$string['infobannerpagessetting'] = 'Vrste stranica za prikaz banera sa informacijama {$a->no}';
$string['infobannerpagessetting_desc'] = 'Sa ovim podešavanjem, možete da izaberete vrste stranica na kojima info baner {$a->no} treba da bude prikazan.';
$string['infobannerstartsetting'] = 'Vreme početka prikazivanja info banera {$a->no}';
$string['infobannerstartsetting_desc'] = 'Sa ovim podešavanjem, možete da definišete od kada treba da bude prikazan info baner {$a->no}. Konfigurisano vreme se tretira kao vreme servera, a ne kao vreme korisnika.';
$string['infobannertab'] = 'Info baner';
$string['javascriptdisabledhint'] = 'Savet ako je JavaScript onemogućen';
$string['javascriptdisabledhint_desc'] = 'Sa ovim podešavanjem na vrhu Moodle stranice će se pojaviti savet ako JavaScript nije omogućen. Ovo je posebno korisno jer nekoliko Moodle funkcija ne radi bez JavaScripta.';
$string['javascriptdisabledhinttext'] = 'JavaScript je onemogućen u vašem veb čitaču.<br />Mnoge Moodle funkcije neće biti upotrebljive ili će izgledati kao da ne rade.<br />Omogućite JavaScript kako bi Moodle mogao normalno da funkcioniše.';
$string['javascriptheading'] = 'JavaScript';
$string['latestcourses'] = 'Skorašnji kursevi';
$string['learnr:configure'] = 'Konfigurisanje teme kao ne-administrator';
$string['learnr:editregioncontentlower'] = 'Uređivanje regiona blokova Sadržaj (donji)';
$string['learnr:editregioncontentupper'] = 'Uređivanje regiona blokova Sadržaj (gornji)';
$string['learnr:editregionfootercenter'] = 'Uređivanje regiona blokova Podnožje (centar)';
$string['learnr:editregionfooterleft'] = 'Uređivanje regiona blokova Podnožje (levo)';
$string['learnr:editregionfooterright'] = 'Uređivanje regiona blokova Podnožje (desno)';
$string['learnr:editregionheader'] = 'Uređivanje regiona blokova Zaglavlja';
$string['learnr:editregionoffcanvascenter'] = 'Uređivanje regiona blokova Van-stranice (centar)';
$string['learnr:editregionoffcanvasleft'] = 'Uređivanje regiona blokova Van-stranice (levo)';
$string['learnr:editregionoffcanvasright'] = 'Uređivanje regiona blokova Van-stranice (desno)';
$string['learnr:editregionoutsidebottom'] = 'Uređivanje regiona blokova Spolja (dole)';
$string['learnr:editregionoutsideleft'] = 'Uređivanje regiona blokova Spolja (levo)';
$string['learnr:editregionoutsideright'] = 'Uređivanje regiona blokova Spolja (desno)';
$string['learnr:editregionoutsidetop'] = 'Uređivanje regiona blokova Spolja (gore)';
$string['learnr:viewhintcourseselfenrol'] = 'Sposobnost da se vidi savet za neograničeni samostalni upis na vidljivim kursevima.';
$string['learnr:viewhintinhiddencourse'] = 'Sposobnost da se vidi savet u sakrivenim aktivnostima';
$string['learnr:viewregioncontentlower'] = 'Sposobnost da se vidi region blokova Sadržaj (donji)';
$string['learnr:viewregioncontentupper'] = 'Sposobnost da se vidi region blokova Sadržaj (gornji)';
$string['learnr:viewregionfootercenter'] = 'Sposobnost da se vidi region blokova Podnožje (centar)';
$string['learnr:viewregionfooterleft'] = 'Sposobnost da se vidi region blokova Podnožje (levo)';
$string['learnr:viewregionfooterright'] = 'Sposobnost da se vidi region blokova Podnožje (desno)';
$string['learnr:viewregionheader'] = 'Sposobnost da se vidi region blokova Zaglavlje';
$string['learnr:viewregionoffcanvascenter'] = 'Sposobnost da se vidi region blokova Van-stranice (centar)';
$string['learnr:viewregionoffcanvasleft'] = 'Sposobnost da se vidi region blokova Van-stranice (levo)';
$string['learnr:viewregionoffcanvasright'] = 'Sposobnost da se vidi region
 blokova Van-stranice (desno)';
$string['learnr:viewregionoutsidebottom'] = 'Sposobnost da se vidi region blokova Spolja (dole)';
$string['learnr:viewregionoutsideleft'] = 'Sposobnost da se vidi region blokova Spolja (levo)';
$string['learnr:viewregionoutsideright'] = 'Sposobnost da se vidi region blokova Spolja (desno)';
$string['learnr:viewregionoutsidetop'] = 'Sposobnost da se vidi region blokova Spolja (gore)';
$string['loginbackgroundimage'] = 'Pozadinske slike stranice za prijavu';
$string['loginbackgroundimage_desc'] = 'Slike koja će biti prikazana kao pozadina stranice za prijavu. Jedna od ovih slika će biti nasumično izabrana i prikazana kada korisnik pristupi stranici za prijavu. Proverite da se u nazivu datoteke ne koriste znakovi koji nisu ASCII, ukoliko želite da prikažete tekst za pozadinske slike stranice za prijavu.';
$string['loginbackgroundimagesheading'] = 'Pozadinske slike stranice za prijavu';
$string['loginbackgroundimagetextsetting'] = 'Prikaži tekst za pozadinske slike stranice za prijavu';
$string['loginbackgroundimagetextsetting_desc'] = 'Sa ovim opcionim podešavanjem možete dodati tekst, npr. obaveštenje o autorskim pravima na pozadinske slike koje ste postavili. Ovaj tekst će se pojaviti na vrhu podnožja stranice za prijavu. Međutim, zbog veličine ekrana, tekst se prikazuje samo na ekranima većih veličina.<br/>
Svaki red se sastoji od identifikatora datoteke (naziv datoteke), teksta koji treba da se prikaže i boje teksta (elementi u redu su odvojeni vertikalnom crtom |). Svaku pojedinačni stavku u ovom podešavanju treba napisati u novom redu. <br/>
Na primer:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
Kao boju teksta možete koristiti vrednosti "tamno" ili "svetlo".<br />
Možete definisati tekstove za proizvoljan broj vaših postavljenih pozadinskih slika stranice za prijavu. Tekstovi će biti dodati samo onim slikama koje odgovaraju njihovom nazivu datoteke sa identifikatorom navedenim u ovom podešavanju.';
$string['loginformheading'] = 'Obrazac za prijavu';
$string['loginformpositionsetting'] = 'Pozicija obrasca za prijavu';
$string['loginformpositionsetting_center'] = 'Centralno';
$string['loginformpositionsetting_desc'] = 'Sa ovim podešavanjem možete optimizovati obrazac za prijavu tako da odgovara većem broju pozadinskih slika. Standardno, obrazac za prijavu se prikazuje u centru stranice za prijavu. Alternativno, možete da ga pomerite levo ili desno na stranici za prijavu kako bi se ostali delovi pozadinske slike jasno videli. Naravno, ovo podešavanje možete promeniti i ako pozadinska slika uopšte nije postavljena.';
$string['loginformpositionsetting_left'] = 'Poravnato levo';
$string['loginformpositionsetting_right'] = 'Poravnato desno';
$string['loginformtransparencysetting'] = 'Transparentnost obrasca za prijavu';
$string['loginformtransparencysetting_desc'] = 'Sa ovim podešavanjem, možete učiniti da obrazac za prijavu bude malo providan kako bi se pozadinska slika jasnije videla.';
$string['loginpagetab'] = 'Stranica za prijavu';
$string['logocompactsetting'] = 'Kompaktan logo';
$string['logocompactsetting_desc'] = 'Ovde možete da postavite kompaktnu verziju istog logotipa kao što je gornji, kao što je amblem, štit ili ikonica. Ova slika se posebno koristi u traci za navigaciju na vrhu svake Moodle stranice. Slika treba da bude jasna čak i pri malim veličinama.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Ovde možete da postavite logo koji će se koristiti kao dekoracija. Ova slika se posebno koristi na stranici za prijavu i može biti prilično visoke rezolucije jer će biti smanjena za upotrebu.';
$string['logosheading'] = 'Logotipi';
$string['logosheading_desc'] = 'Imajte na umu: LearnR ima sopstveno polje za postavljanje logotipa i ne koristi logo iz <a href="{$a}">podešavanja logotipa osnovne instalacije Moodlea</a>.<br />LearnR vam posebno omogućava da postavite više formata slika nego što nudi osnovna instalacija Moodlea. Takođe vam daje mogućnost da izmenite postavljene logotipe u okviru njegovih vizuelnih identiteta.';
$string['maintenancecontentsetting'] = 'Sadržaj stranice sa informacijama o održavanju';
$string['maintenancecontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici sa informacijama o održavanju (što nije isto što i standardna Moodle stranica sa režimom održavanja).';
$string['maintenancedisabled'] = 'Stranica sa informacijama o održavanju je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['maintenanceheading'] = 'Održavanje';
$string['maintenancelinkpositionboth'] = 'Dodajte link ka stranici sa informacijama o održavanju u fusnotu i na ikonicu u podnožju (znak pitanja).';
$string['maintenancelinkpositionfooter'] = 'Dodajte link ka stranici sa informacijama o održavanju na ikonicu u podnožju (znak pitanja).';
$string['maintenancelinkpositionfootnote'] = 'Dodajte link ka sa informacijama o održavanju u fusnotu';
$string['maintenancelinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici sa sa informacijama o održavanju';
$string['maintenancelinkpositionsetting'] = 'Pozicija linka ka stranici sa informacijama o održavanju';
$string['maintenancelinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici sa informacijama o održavanju automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['maintenancepagetitledefault'] = 'Održavanje';
$string['maintenancepagetitlesetting'] = 'Naslov stranice sa informacijama o održavanju';
$string['maintenancepagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice sa informacijama o održavanju. Ovaj tekst će se koristiti i kao tekst linka ka stranici sa sa informacijama o održavanju ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici sa informacijama o održavanju\'.';
$string['manageuserstitle'] = 'Korisnici';
$string['marketingurltarget'] = 'Odredište linka';
$string['marketingurltargetdesc'] = 'Izaberite kako treba da se otvori link';
$string['marketingurltargetnew'] = 'Nova stranica';
$string['marketingurltargetparent'] = 'Nadređeni okvir';
$string['marketingurltargetself'] = 'Tekuća stranica';
$string['mediumcontentmaxwidthsetting'] = 'Maksimalna širina središnjeg sadržaja';
$string['mediumcontentmaxwidthsetting_desc'] = 'Sa ovim podešavanjem, možete izmeniti širinu središnjeg sadržaja Moodlea bez ručnih izmena SCSS skupa stilova. Ova širina stranice se koristi u određenim aktivnostima kao što je to aktivnost \'Baza podataka\'. Standardno, Moodle koristi maksimalnu širinu središnjeg sadržaja od 1120 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 1200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 100% ili vrednost širine okvira za prikaz (viewport) kao što je 90vw.';
$string['misctab'] = 'Razno';
$string['mobileappearanceheading'] = 'Izgled na mobilnim uređajima';
$string['mobilecss'] = 'Dodatni CSS za mobilnu aplikaciju';
$string['mobilecss_desc'] = 'Sa ovim podešavanjem možete uneti prilagođeni CSS kôd kako biste prilagodili interfejs svoje mobilne aplikacije. CSS kôd će biti dodat samo u prikaz mobilne aplikacije ove Moodle instance, i neće biti prikazan u verziji za veb čitač. Pročitajte više o ovoj funkciji na href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Moodle razvojni dokumenti</a>';
$string['mobilecss_donotchange'] = 'Ovaj korak je neophodan kako bi se poslao CSS kôd u aplikaciju za mobilne uređaje. Ne menjajte URL adresu tamo osim ako zaista ne želite da ponovo uklonite CSS kôd iz aplikacije za mobilne uređaje.';
$string['mobilecss_overwrite'] = 'Čim dodate bilo koji CSS kôd u ovo podešavanje i sačuvate ga, <a href="{$a->url}">Moodle osnovno podešavanje <em>mobilecssurl</em></a> će automatski biti zamenjeno URL adresom LearnR theme. Trenutno je ovo podešavanje postavljeno na  <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Čim dodate bilo koji CSS kôd u ovo podešavanje i sačuvate ga, <a href="{$a->url}">Moodle osnovno podešavanje <em>mobilecssurl</em></a> će automatski biti postavljeno na URL adresu LearnR teme.';
$string['mobiletab'] = 'Aplikacija za mobilne uređaje';
$string['myprogresspercentage'] = '%';
$string['navbarcolorsetting'] = 'Boja navigacione trake';
$string['navbarcolorsetting_dark'] = 'Tamna navigaciona traka sa svetlom bojom fonta';
$string['navbarcolorsetting_desc'] = 'Sa ovim podešavanjem možete promeniti boju navigacione trake iz podrazumevane svetle u tamnu ili obojenu navigacionu traku.';
$string['navbarcolorsetting_light'] = 'Svetla navigaciona traka sa tamnom bojom fonta (neizmenjeno, onako kako je izvorno podešeno u osnovnoj Moodle instalaciji)';
$string['navbarcolorsetting_primarydark'] = 'Primarna boja navigacione traka sa svetlom bojom fonta';
$string['navbarcolorsetting_primarylight'] = 'Primarna boja navigacione trake sa tamnom bojom fonta';
$string['navbarheading'] = 'Navigaciona traka';
$string['navicon'] = 'Ikonica';
$string['navicon1'] = 'Ikonica početne stranice jedan';
$string['navicon2'] = 'Ikonica početne stranice dva';
$string['navicon3'] = 'Ikonica početne stranice tri';
$string['navicon4'] = 'Ikonica početne stranice četiri';
$string['navicon5'] = 'Ikonica početne stranice pet';
$string['navicon6'] = 'Ikonica početne stranice šest';
$string['navicon7'] = 'Ikonica početne stranice sedam';
$string['navicon8'] = 'Ikonica početne stranice osam';
$string['naviconbuttoncreatetextdefault'] = 'Kreiraj kurs';
$string['naviconbuttontext'] = 'Tekst linka';
$string['naviconbuttontextdesc'] = 'Tekst koji će se pojaviti ispod ikonice.';
$string['naviconbuttonurl'] = 'URL adresa linka';
$string['naviconbuttonurldesc'] = 'URL adresa sa kojom je dugme povezano. Dugme možete da povežete sa bilo kojom adresom, uključujući i spoljašnje veb sajtove, samo unesite odgovarajuću URL adresu. Ako je vaš Moodle sajt u poddirektorijumu, podrazumevana URL adresa neće funkcionisati. Podesite URL adresu tako da ona održava poziciju poddirektorijum. Na primer, ako je naziv vašeg poddirektorijuma "moodle", onda bi URL adresu trebalo promeniti u /moodle/my/';
$string['navicondesc'] = 'Naziv ikonice koju želite da koristite. Spisak ikonica možete naći <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">ovde</a>. Unesite samo ono što sledi iza "fa-",", npr. "star".';
$string['naviconslidedesc'] = 'Predlažemo da kao tekst ikonice koristite: arrow-circle-down, ili izaberite sa spiska ikonica koji možete naći <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">ovde</a>. Unesite samo ono što sledi iza "fa-",", npr. "star".';
$string['navigationheading'] = 'Navigacija';
$string['navigationtab'] = 'Navigacija';
$string['nomycourses'] = 'Niste upisani ni na jedan kurs';
$string['openoffcanvas'] = 'Otvori fioku ”Van stranice”';
$string['outsideregionsheading'] = 'Spoljni regioni';
$string['outsideregionsheading_desc'] = 'Spoljni regioni, ne samo da se mogu uključiti pomoću gornjih podešavanja, već se njihov izgled takođe može prilagoditi.';
$string['outsideregionsplacement'] = 'Horizontalni položaj spoljnih regiona';
$string['outsideregionsplacement_desc'] = 'Sa ovim podešavanjem možete da kontrolišete da li na većim ekranima, regioni blokova \'Spolja (levo)\' i \'Spolja (desno)\' treba da budu postavljeni blizu glavnog sadržaja stranice ili blizu ivica ekrana.';
$string['outsideregionsplacementnearwindowedges'] = 'Prikažite regione \'Spolja (levo)\' i \'Spolja (desno)\' blizu ivica ekrana';
$string['outsideregionsplacementnextmaincontent'] = 'Prikažite regione \'Spolja (levo)\' i \'Spolja (desno)\' pored glavnog sadržaja stranice';
$string['outsideregionswidthcoursecontentwidth'] = 'Širina sadržaja kursa';
$string['outsideregionswidthfullwidth'] = 'Puna širina';
$string['outsideregionswidthherowidth'] = 'Hero širina';
$string['pagenavbuttonsbg'] = 'Dugmad za fioke, pomoć, povratak na vrh';
$string['pagenavbuttonsbg_desc'] = 'Promenite boju dugmadi bočnih fioka, dugmeta za pomoć i dugmeta za povratak na vrh.';
$string['pagetab'] = 'Stranica';
$string['pagewidthheading'] = 'Širina stranice';
$string['pluginname'] = 'LearnR';
$string['presetheading'] = 'Predefinisana podešavanja teme';
$string['primarynavigationheading'] = 'Primarna navigacija';
$string['privacy:metadata'] = 'Tema LearnR ne čuva nikakve lične podatke o bilo kom korisniku.';
$string['progresstitle'] = 'Napredak';
$string['region-content-lower'] = 'Sadržaj (donji)';
$string['region-content-upper'] = 'Sadržaj (gornji)';
$string['region-footer-center'] = 'Podnožje (centar)';
$string['region-footer-left'] = 'Podnožje (levo)';
$string['region-footer-right'] = 'Podnožje (desno)';
$string['region-header'] = 'Zaglavlje';
$string['region-none'] = 'Nijedan';
$string['region-offcanvas-center'] = 'Van stranice (centar)';
$string['region-offcanvas-left'] = 'Van stranice (levo)';
$string['region-offcanvas-right'] = 'Van stranice (desno)';
$string['region-outside-bottom'] = 'Spolja (dole)';
$string['region-outside-left'] = 'Spolja (levo)';
$string['region-outside-right'] = 'Spolja (desno)';
$string['region-outside-top'] = 'Spolja (gore)';
$string['resourcescachecontrolnote'] = 'Imajte na umu da se datoteke šalju veb čitaču sa podešenim zaglavljem \'Kontrola-Keša\' koje govori veb čitaču da kešira datoteku. Ako ste sigurni da nećete menjati datoteku u bliskoj budućnosti, možete da koristite trajnu URL adresu za povezivanje sa datotekom. Međutim, ako planirate da menjate datoteku, s vremena na vreme, ali da zadržite njen isti naziv, bilo bi bolje da koristite revidiranu URL adresu i ponovo povežete datoteku svaki put kada je ažurirate kako biste izbegli da veb čitač prikazuje keširanu, zastarele verzije datoteke.';
$string['resourcestab'] = 'Resursi';
$string['scrollspy'] = 'Čuvar pozicije klizne trake';
$string['scrollspysetting'] = 'Čuvar pozicije klizne trake';
$string['scrollspysetting_desc'] = 'Sa ovim podešavanjem, nakon uključivanja/isključivanja prekidača režima uređivanje, pozicija klizne trake u veb čitaču (tj. mesto na kojem je korisnik bio u trenutku kada je uključio režim uređivanje) biće sačuvana.';
$string['scssheading'] = 'Neobrađen SCSS';
$string['scsstab'] = 'SCSS';
$string['sections-bars'] = 'Stil jednobojne trake';
$string['sections-boost'] = 'Boost standardno';
$string['sections-boxed'] = 'Stil kutije';
$string['sections-learnr'] = 'LearnR standardni stil';
$string['sectionstyle'] = 'Birač stila sekcija na kursu';
$string['sectionstyle_desc'] = 'Izaberite stil za sekcije na kursu.';
$string['showadvertonpages'] = 'Birač stranica za reklame';
$string['showadvertonpages-course'] = 'Početna stranica kursa';
$string['showadvertonpages-dash'] = 'Stranica kontrolnog panela';
$string['showadvertonpages-home'] = 'Početna stranica';
$string['showadvertonpages-mycourses'] = 'Stranica \'Moji kursevi\'';
$string['showadvertonpages_desc'] = 'Izaberite na kojim stranicama želite da budu prikazane reklamne pločice.';
$string['showcourseactivities'] = 'Prikaži meni aktivnosti na kursu';
$string['showcourseactivities_desc'] = 'Prikaži ikonicu menija aktivnosti na kursu u zaglavlju.';
$string['showcourseindexnav'] = 'Prikaži fioke stranice';
$string['showcourseindexnav_desc'] = 'Isključite ovo podešavanje kako biste sakrili navigacione panele fioka. Nije preporučljivo, ali može biti korisno za instalacije Moodlea za korporacije ili organizacije. Uklanjanje fioka pojednostavljuje korisnički interfejs i može biti poželjno za jednostavnije obuke.

Prikažite ili sakrijte navigacionu fioku sa indeksom kursa.';
$string['showcoursemanagement'] = 'Prikaži Upravljanje Kursom';
$string['showcoursemanagement_desc'] = 'Upravljanje Kursom je panel sa skupom najčešće korišćenih linkova za predavače. Ovo je klizni panel čiji se prekidač (za uključivanje/isključivanje) nalazi u zaglavlju kursa';
$string['showeasyenrolbtn'] = 'Prikaži dugme za Jednostavan Upis';
$string['showeasyenrolbtn_desc'] = 'Prikažite brzu vezu u zaglavlju za dodatak \'Jednostavan Upis\'. Ovo omogućava predavačima da lako i brzo dođu do svojih kôdova za upis dok su na kursu.';
$string['showhintcourseguestaccessgeneral'] = 'Trenutno posmatrate ovaj kurs kao <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Da biste imali pun pristup kursu, možete <a href="{$a->url}">samostalno da se upišete na ovaj kurs</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Sa ovim podešavanjem, kada korisnik pristupa kursu u ulozi gosta,  u zaglavlju kursa će se pojaviti savet. Ako kurs daje mogućnost za samostalni upis, korisniku će takođe biti prikazan link do stranice za upis.';
$string['showhintcoursehiddengeneral'] = 'Ovaj kurs je trenutno <strong>sakriven</strong>. Samo upisani predavači mogu pristupiti ovom kursu kada je sakriven.';
$string['showhintcoursehiddensetting'] = 'Prikaži savet u sakrivenim kursevima';
$string['showhintcoursehiddensetting_desc'] = 'Sa ovim podešavanjem, savet će se pojaviti u zaglavlju kursa sve dok je kurs sakriven. Ovo pomaže da se odmah, na prvi pogled identifikuje status vidljivosti kursa, bez potrebe da se ona proverava u podešavanjima kursa.';
$string['showhintcoursehiddensettingslink'] = 'Vidljivost možete promeniti u <a href="{$a->url}">podešavanjima kurs</a>.';
$string['showhintcourseselfenrolfrom'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis od {$a->from} pa nadalje.';
$string['showhintcourseselfenrolfromuntil'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis od {$a->from} do {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Ako ne želite da bilo koji korisnik Moodlea ima slobodan pristup ovom kursu, molimo vas da ograničite podešavanja samostalnog upisa.';
$string['showhintcourseselfenrolsetting'] = 'Prikaži savet za samostalni upis bez lozinke za upis';
$string['showhintcourseselfenrolsetting_desc'] = 'Sa ovim podešavanjem, u zaglavlju kursa će se pojaviti savet ako je kurs vidljiv i ako je, trenutno, moguć upis bez lozinke za upis.';
$string['showhintcourseselfenrolsince'] = 'Instanca upisa <strong>{$a->name}</strong> trenutno dozvoljava neograničeni samostalni upis.';
$string['showhintcourseselfenrolsinceuntil'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis do {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Ovaj kurs je trenutno vidljiv svima i moguć je <strong>samostalni upis bez lozinke za upis<strong>.';
$string['showhintcourseselfenrolstartfuture'] = 'Ovaj kurs je trenutno vidljiv svima i planirano je da <strong>samostalni upis bez lozinke za upis<strong> postane moguć.';
$string['showhintcourseselfenrolunlimited'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis na neodređeno vreme.';
$string['showhintcourseselfenroluntil'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis do {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Prikaži savet korisnicima koji pristupaju kao gosti';
$string['showlatestcourses'] = 'Prikaži padajući meni sa najnovijim kursevima';
$string['showlatestcourses_desc'] = 'Ovo će, u padajućem meniju desno od naslova kursa, prikazati poslednjih 7 kurseva koje je korisnik posetio . U ovom trenutku, to nije deo glavne navigacije, već element navigacije na stranicama kursa.';
$string['showprogressbar'] = 'Prikaži traku napredovanja na kursu';
$string['showprogressbar_desc'] = 'Prikažite traku napredovanja za polaznika na vrhu svake stranice glavnog kursa.';
$string['showswitchedroleincoursesetting'] = 'Prikaži savet za izmenjenu ulogu';
$string['showswitchedroleincoursesetting_desc'] = 'Sa ovim podešavanjem, u zaglavlju kursa će se pojaviti savet ukoliko je korisnik promenio ulogu na kursu. Standardno, ove informacije se prikazuju samo u blizini slike korisnika u korisničkom meniju. Ako omogućite ovu opciju, možete takođe da prikažete ove informacije - zajedno sa linkom \'Povratak na moju normalnu ulogu\' - i na samoj stranici kursa.';
$string['sliderinfo'] = 'Specijalno dugme-ikonica za klizno tekstualno polje';
$string['sliderinfodesc'] = 'Ovo dugme će prikazati/sakriti posebno tekstualno polje koji se pojavljuje (kao klizni prozor) odmah ispod navigacione trake sa ikonicama. Ovo je idealno za prikazivanje različtih vrsta poruka, poput reklamiranja popularnih kurseva, pružanja neophodne pomoći ili navođenje potrebne obuke za osoblje, itd.';
$string['slidetextbox'] = 'Slajd - polje za tekst';
$string['slidetextbox_desc'] = 'Sadržaj ovog polja za tekst biće prikazano kada se pritisne dugme slajda.';
$string['staticpagestab'] = 'Statične stranice';
$string['switchedroleto'] = 'Trenutno gledate ovaj kurs sa ulogom: <strong>{$a->role}</strong>';
$string['templateemailhtmlprefix'] = '';
$string['templateemailhtmlsuffix'] = '';
$string['templateemailtextprefix'] = '';
$string['templateemailtextsuffix'] = '';
$string['tilebackgroundimagepositionsetting'] = 'Pozicija pozadinske slike reklamne pločice {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Sa ovim podešavanjem kontrolišete pozicioniranje pozadinske slike unutar kontejnera reklamne pločice  {$a->no}. Prva vrednost je horizontalni, druga vertikalni položaj.';
$string['tilebackgroundimagesetting'] = 'Pozadinska slika reklamne pločice {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Ovde možete da postavite datoteku slike koja će biti prikazana kao pozadinska slika iza sadržaja reklamne pločice {$a->no}. Proverite da li je sadržaj i dalje čitljiv na pozadinskoj slici. Ovo je opciono podešavanje, reklamna pločica će biti prikazana čak i ako ne postavite pozadinsku sliku.';
$string['tilecolumnssetting'] = 'Broj kolona reklamnih pločica po redu';
$string['tilecolumnssetting_desc'] = 'Ovde definišete broj kolona po redu u prikazanoj mreži reklamnih pločica. Imajte na umu da se ovaj broj kolona odnosi na desktop/veće ekrane. Na manjim ekranima i mobilnim ekranima, kolone reklamnih pločica se automatski pakuju.';
$string['tilecontentsetting'] = 'Sadržaj reklamne pločice {$a->no}';
$string['tilecontentsetting_desc'] = 'Ovde unosite sadržaj koji treba da bude prikazan u reklamnoj pločici {$a->no}. Sadržaj se prikazuje u sredini pločice. Ovo je opciono podešavanje, reklamna pločica će biti prikazana čak i ako ne postavite nikakav sadržaj.';
$string['tileenabledsetting'] = 'Omogući reklamnu pločicu {$a->no}';
$string['tileenabledsetting_desc'] = 'Sa ovim podešavanjem možete omogućiti reklamnu pločicu {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Pozicija reklamnih pločica na naslovnoj stranici';
$string['tilefrontpagepositionsetting_after'] = 'Nakon sadržaja naslovne stranice';
$string['tilefrontpagepositionsetting_before'] = 'Pre sadržaja naslovne stranice';
$string['tilefrontpagepositionsetting_desc'] = 'Reklamne pločice se prikazuju samo na naslovnoj stranici sajta. Sa ovim podešavanjem kontrolišete da li se reklamne pločice prikazuju pre ili posle sadržaja naslovne stranice. Ako na naslovnoj stranici sajta želite da prikažete samo reklamne pločice  i ništa drugo, sav ostali sadržaj naslovne stranice možete ukloniti promenom <a href="{$a->url}">podešavanja naslovne stranice</a>.';
$string['tileheading'] = 'Reklamna pločica {$a->no}';
$string['tileheightsetting'] = 'Visina reklamnih pločica';
$string['tileheightsetting_desc'] = 'Sa ovim podešavanje kontrolišete visinu reklamnih pločica. Konfigurisana visina je minimalna visina svake pločice. Ako je sadržaj pločice veći od ove visine, ceo red pločica biće automatski uvećan po potrebi.';
$string['tilelinksetting'] = 'URL adresa linka reklamne pločice {$a->no}';
$string['tilelinksetting_desc'] = 'Ovde možete podesiti (Moodle-internu ili eksternu) URL adresu koja će biti ponuđena kao link za dugme za na dnu reklamne pločice {$a->no}. Ovo je opciono podešavanje, reklamne pločice će biti prikazana čak i ako ne podesite URL adresu linka.';
$string['tilelinktargetsetting'] = 'Odredište linka reklamne pločice {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Ovde možete da podesite odredište linka koji je postavljen kao link dugmeta čim postavite URL adresu linka u reklamnoj pločici {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Nova kartica';
$string['tilelinktargetsetting_samewindow'] = 'Isti prozor';
$string['tilelinktitlefallback'] = 'Link';
$string['tilelinktitlesetting'] = 'Naslov linka reklamne pločice {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Ovde možete podesiti naslov linka, koji se koristi kao natpis na dugmeta linka čim unesete URL adrese linka u reklamnu pločicu {$a->no}. Imajte na umu da ukoliko unesete URL adresu, ali ne i naslov linka, dugme linka biće označeno natpisom \'Link\'';
$string['tileordersetting'] = 'Pozicija reklamne pločice {$a->no}';
$string['tileordersetting_desc'] = 'Sa ovim podešavanjem definišete poziciju reklamne pločice {$a->no}. Standardno, reklamne pločice su poređane odozgo prema dole i sa leva na desno, kao što ih vidite na ovoj stranici sa podešavanjima. Međutim, sa ovim podešavanjem možete reklamnoj pločici da dodelite drugu poziciju. Ako dodelite istu poziciju za dve ili više reklamnih pločica, one će biti ponovo poređane prema redosledu na ovoj stranici sa podešavanjima.';
$string['tilesgeneralheading'] = 'Opšta podešavanja reklamnih pločica';
$string['tilestab'] = 'Reklamne pločice';
$string['tiletitlesetting'] = 'Naslov reklamne pločice {$a->no}';
$string['tiletitlesetting_desc'] = 'Ovde unosite naslov koji treba da bude prikazan u reklamnoj pločici {$a->no}. Ovo je opciono podešavanje, reklamna pločica će biti prikazana čak i ako ne unesete njen naslov.';
$string['trimsummary'] = 'Skratite rezime kursa';
$string['trimsummary_desc'] = 'Unesite broj kako biste skratili dužinu rezimea kursa. Ovaj broj predstavlja broj znakova koji će biti prikazani.';
$string['trimtitle'] = 'Skratite naslov kursa';
$string['trimtitle_desc'] = 'Unesite broj kako biste skratili dužinu naslova. Ovaj broj predstavlja broj znakova koji će biti prikazani.';
$string['upgradenotice_2022080922'] = 'Od ovog verzije, LearnR ima sopstveni logo i podešavanja kompaktnog logotipa, i više ne koristi ove datoteke iz osnovnih podešavanja Moodlea.';
$string['upgradenotice_2022080922_copied'] = 'Postojeće podešavanje <strong>{$a}</strong> kopirano je iz osnovnih podešavanja Moodlea u LearnR podešavanje {$a} tokom ove nadogradnje. Molimo vas da još jednom proverite rezultat.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'kompaktan logo';
$string['upgradenotice_2022080922_notcopied'] = 'Podešavanje <strong>{$a}</strong> u okviru teme LearnR je sada prazno. Ako od sada želite da koristite {$a} u okviru teme LearnR, samo ga kasnije postavite u LearnR podešavanje {$a}.';
$string['userreportgradebook'] = 'Izveštaj o korisniku';
$string['viewallcourses'] = 'Prikaži sve kurseve';
