<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'sl', version '4.2'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Postopek varnostnega kopiranja se je zaključil';
$string['asyncbackupcompletebutton'] = 'Nadaljuj';
$string['asyncbackupcompletedetail'] = 'Postopek varnostnega kopiranja se je uspešno zaključil. <br/> Varnostna kopija vam je na voljo na <a href="{$a}">strani za obnovo.</a>';
$string['asyncbackuperror'] = 'Postopek varnostnega kopiranja je spodletel';
$string['asyncbackuperrordetail'] = 'Postopek varnostnega kopiranja je spodletel. Prosimo, da se obrnete na vašega sistemskega administratorja.';
$string['asyncbackuppending'] = 'Postopek varnostnega kopiranja je na čakanju';
$string['asyncbackupprocessing'] = 'Varnostno kopiranje je v teku';
$string['asyncbadexecution'] = 'Napačna izvršitev krmilnika varnostnega kopiranja. Je {$a}, a bi morala biti 2.';
$string['asynccheckprogress'] = 'Napredek lahko kadarkoli preverite na <a href="{$a}">strani za obnovo</a>.';
$string['asyncemailenable'] = 'Omogoči pošiljanje sporočil';
$string['asyncemailenabledetail'] = 'Če je omogočeno bodo uporabniki prejelo obvestilo o zaključku asinhronega varnostnega kopiranja ali obnove.';
$string['asyncgeneralsettings'] = 'Asinhrono varnostno kopiranje/obnova';
$string['asyncmessagebody'] = 'Sporočilo';
$string['asyncmessagebodydefault'] = 'Pozdravljeni {user_firstname},<br/> Vaša {operation} (ID: {backupid}) je bila uspešno zaključena. <br/><br/>Na voljo vam je tukaj: {link}.';
$string['asyncmessagebodydetail'] = 'Sporočilo, ki se pošlje ob zaključku asinhronega varnostnega kopiranja ali obnove.';
$string['asyncmessagesubject'] = 'Zadeva';
$string['asyncmessagesubjectdefault'] = 'Moodlova {operation} je uspešno zaključena';
$string['asyncmessagesubjectdetail'] = 'Zadeva sporočila';
$string['asyncnowait'] = 'Ni vam potrebno čakati na tej strani, saj se bo postopek nadaljeval v ozadju.';
$string['asyncprocesspending'] = 'Postopek na čakanju';
$string['asyncrestorecomplete'] = 'Postopek obnove je zaključen';
$string['asyncrestorecompletebutton'] = 'Nadaljuj';
$string['asyncrestorecompletedetail'] = 'Postopek obnove je uspešno zaključen. Klik na nadaljuj vas bo odpeljal na <a href="{$a}">predmet obnove.</a>';
$string['asyncrestoreerror'] = 'Postopek obnove je spodletel';
$string['asyncrestoreerrordetail'] = 'Postopek obnove je spodletel. Obrnite se na vašega sistemskega administratorja.';
$string['asyncrestoreinprogress'] = 'Obnove v teku';
$string['asyncrestoreinprogress_help'] = 'Na tem mestu so prikazane asinhrone obnove predmetov, ki so v teku.';
$string['asyncrestorepending'] = 'Postopek obnove je na čakanju';
$string['asyncrestoreprocessing'] = 'Postopek obnove je v teku';
$string['asyncreturn'] = 'Nazaj na predmet';
$string['autoactivedescription'] = 'Izberite, ali se bo izvajalo samodejno varnostno kopiranje ali ne. Če je izbrano ročno samodejno varnostno kopiranje, je avtomatsko varnostno kopiranje mogoče le prek skripta CLI. To je mogoče storiti ročno v ukazni vrstici ali prek skripta cron.';
$string['autoactivedisabled'] = 'Onemogočeno';
$string['autoactiveenabled'] = 'Omogočeno';
$string['autoactivemanual'] = 'Ročno';
$string['automatedbackupschedule'] = 'Urnik';
$string['automatedbackupschedulehelp'] = 'Izberite dneve tedna, ob katerih želite izvesti samodejne varnostne kopije.';
$string['automatedbackupsinactive'] = 'Samodejnih varnostnih kopij skrbnik spletnega mesta ni omogočil';
$string['automatedbackupstatus'] = 'Status samodejnih varnostnih kopij';
$string['automateddeletedays'] = 'Izbriši varnostne kopije starejše od';
$string['automatedmaxkept'] = 'Največje število shranjenih varnostnih kopij';
$string['automatedmaxkepthelp'] = 'Določi največje število zadnjih avtomatskih varnostnih kopij, ki bodo shranjene za vsak predmet. Starejše varnostne kopije bodo avtomatsko izbrisane.';
$string['automatedminkept'] = 'Najmanjše število shranjenih varnostnih kopij';
$string['automatedminkepthelp'] = 'Če se varnostne kopije, starejše od določenega števila dni, izbrišejo, se lahko zgodi, da neaktivni predmeti ostanejo brez varnostnih kopij. Da to preprečite, morate določiti minimalno število varnostnih kopij.';
$string['automatedsettings'] = 'Nastavitve samodejnega varnostnega kopiranja';
$string['automatedsetup'] = 'Nastavitev samodejnega varnostnega kopiranja';
$string['automatedstorage'] = 'Shramba samodejnega varnostnega kopiranja';
$string['automatedstoragehelp'] = 'Izberite mesto, kjer se bodo varnostne kopije hranile, ko bodo samodejno ustvarjene.';
$string['backupactivity'] = 'Dejavnost varnostnega kopiranja: {$a}';
$string['backupcourse'] = 'Varnostno kopiranje predmeta: {$a}';
$string['backupcoursedetails'] = 'Podrobnosti predmeta';
$string['backupcoursesection'] = 'Odsek: {$a}';
$string['backupcoursesections'] = 'Odseki predmeta';
$string['backupdate'] = 'Datum izvedbe';
$string['backupdetails'] = 'Podrobnosti varnostnega kopiranja';
$string['backupdetailsnonstandardinfo'] = 'Označena dototeka ni standardna varnostna kopija Moodla. Obnovitveni postopek bo poskušal pretvoriti varnostno kopijo v standardni format in jo nato obnoviti.';
$string['backupformat'] = 'Oblika';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Neznan format';
$string['backuplog'] = 'Tehnične informacije in opozorila';
$string['backupmode'] = 'Način';
$string['backupmode10'] = 'Splošno';
$string['backupmode20'] = 'Uvozi';
$string['backupmode30'] = 'Vozlišče';
$string['backupmode40'] = 'Isto spletno mesto';
$string['backupmode50'] = 'Samodejno';
$string['backupmode60'] = 'Pretvorjeno';
$string['backupmode70'] = 'Asinhrono';
$string['backupsection'] = 'Varnostna kopija odseka predmeta: {$a}';
$string['backupsettings'] = 'Nastavitve varnostne kopije';
$string['backupsitedetails'] = 'Podrobnosti spletnega mesta';
$string['backupstage16action'] = 'Nadaljuj';
$string['backupstage1action'] = 'Naprej';
$string['backupstage2action'] = 'Naprej';
$string['backupstage4action'] = 'Izvedi varnostno kopiranje';
$string['backupstage8action'] = 'Nadaljuj';
$string['backuptype'] = 'Tip';
$string['backuptypeactivity'] = 'Dejavnost';
$string['backuptypecourse'] = 'Predmet';
$string['backuptypesection'] = 'Odsek';
$string['backupversion'] = 'Različica varnostne kopije';
$string['cannotfindassignablerole'] = 'Vloge "{$a}" v varnostni kopiji ni mogoče preslikati v nobeno vlogo, ki jo lahko dodelite vi.';
$string['choosefilefromactivitybackup'] = 'Območje varnostnega kopiranja dejavnosti';
$string['choosefilefromactivitybackup_help'] = 'Ko varnostno kopiranje dejavnosti uporablja privzete vrednosti, se varnostne kopije shranjujejo sem.';
$string['choosefilefromautomatedbackup'] = 'Samodejne varnostne kopije';
$string['choosefilefromautomatedbackup_help'] = 'Vsebuje samodejno ustvarjene varnostne kopije.';
$string['choosefilefromcoursebackup'] = 'Območje varnostne kopije predmeta';
$string['choosefilefromcoursebackup_help'] = 'Ko varnostno kopiranje predmeta uporablja privzete vrednosti, se varnostne kopije shranjujejo sem.';
$string['choosefilefromuserbackup'] = 'Uporabnikovo zasebno območje varnostne kopije';
$string['choosefilefromuserbackup_help'] = 'Ko je izbrana možnost "Anonimiziraj informacije o uporabniku", se varnostne kopije shranijo sem.';
$string['config_keep_groups_and_groupings'] = 'Privzeto obdrži trenutne skupine in razvrščanje.';
$string['config_keep_roles_and_enrolments'] = 'Privzeto obdrži trenutne vloge in vpise.';
$string['config_overwrite_conf'] = 'Dovoli uporabniku, da prepiše trenutno konfiguracijo predmeta';
$string['config_overwrite_course_fullname'] = 'Privzeto prepiši polno ime predmeta s tistim iz varnostne kopije. To zahteva, da je izbrana opcija "Prepiši konfiguracijo predmeta" in da ima trenutni uporabnik možnost spreminjanja polnega imena predmeta (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Privzeto prepiši kratko ime predmeta s tistim iz varnostne kopije. To zahteva, da je izbrana opcija "Prepiši konfiguracijo predmeta" in da ima trenutni uporabnik možnost spreminjanja polnega imena predmeta (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Privzeto prepiši začetni datum predmeta s tistim iz varnostne kopije. To zahteva, da je izbrana opcija "Prepiši konfiguracijo predmeta" in da ima trenutni uporabnik možnost spreminjanja datumov predmeta pri obnovitvi (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Nastavi privzeto vrednosti za vključitev dejavnosti v varnostno kopijo.';
$string['configgeneralanonymize'] = 'Če je omogočeno, so vse informacije, ki se nanašajo na uporabnike, privzeto anonimizirane.';
$string['configgeneralbadges'] = 'Nastavitev privzetih vrednosti za vključitev značk v varnostno kopijo.';
$string['configgeneralblocks'] = 'Nastavi privzete vrednosti za vključitev blokov v varnostno kopijo.';
$string['configgeneralcalendarevents'] = 'Nastavi privzeto izbiro za vključevanje dogodkov iz koledarja v varnostni kopiji.';
$string['configgeneralcomments'] = 'Nastavi privzete vrednosti za vključitev komentarjev v varnostno kopijo.';
$string['configgeneralcompetencies'] = 'Nastavi privzeto izbiro za vključevanje kompetenc v varnostni kopiji.';
$string['configgeneralcontentbankcontent'] = 'Določi privzeto nastavitev za vključitev zbirke vsebin v varnostno kopijo.';
$string['configgeneralfiles'] = 'Nastavi privzeto vrednost za vključitev datotek v varnostno kopijo. Prosimo pomnite: Posledica onemogočanja te nastavitve bo varnostna kopija v kateri bodo vključeni zgolj sklici na datoteke. To ne predstavlja težave, če bo varnostna kopija obnovljena na istem portalu in datoteke medtem niso bile izbrisane glede na nastavitev \'Počisti datoteke bazena za smeti\' (filescleanupperiod).';
$string['configgeneralfilters'] = 'Nastavi privzete vrednosti za vključitev filtrov v varnostno kopijo.';
$string['configgeneralgroups'] = 'Nastavi privzeto za vključevanje skupin in skupkov v varnostno kopijo.';
$string['configgeneralhistories'] = 'Nastavi privzete vrednosti za vključitev uporabnikove zgodovine v varnostno kopijo.';
$string['configgenerallogs'] = 'Če je omogočeno, bodo dnevniki privzeto vključeni v varnostne kopije.';
$string['configgeneralquestionbank'] = 'Če je omogočeno, bo zbirka vprašanj privzeto vključena v varnostno kopijo. OPOMBA: če onemogočite to nastavitev, boste onemogočili varnostno kopiranje dejavnosti, ki uporabljajo zbirko vprašanj, na primer kviz.';
$string['configgeneralroleassignments'] = 'Če je omogočeno pri privzetih vlogah, bodo naloge vključene v varnostne kopije.';
$string['configgeneralusers'] = 'Nastavi privzete vrednosti za vključitev uporabnikov v varnostne kopije.';
$string['configgeneraluserscompletion'] = 'Če je omogočeno, bodo informacije o uporabnikovih zaključkih privzeto vključene v varnostne kopije.';
$string['configlegacyfiles'] = 'Nastavi privzeto izbiro za vključevanje podedovanih datotek predmeta v varnostno kopijo. Podedovane datoteke predmeta so od Moodle različic, starejših od 2.0.';
$string['configloglifetime'] = 'To določa, kako dolgo želite ohraniti informacije zapisov varnostnih kopij. Zapisi, ki so starejši od določene starosti, so samodejno izbrisani. Priporočljivo je, da je ta vrednost nizka, ker so zapisane informacije v varnostnih kopijah lahko ogromne.';
$string['configrestoreactivities'] = 'Nastavi privzeto izbiro za obnavljanje aktivnosti.';
$string['configrestorebadges'] = 'Nastavi privzeto izbiro za obnavljanje značk.';
$string['configrestoreblocks'] = 'Nastavi privzeto izbiro za obnavljanje blokov.';
$string['configrestorecalendarevents'] = 'Nastavi privzeto izbiro za obnavljanje dogodkov iz koledarja.';
$string['configrestorecomments'] = 'Nastavi privzeto izbiro za obnavljanje komentarjev.';
$string['configrestorecompetencies'] = 'Nastavi privzeto izbiro za obnavljanje kompetenc.';
$string['configrestorecontentbankcontent'] = 'Določi privzeto nastavitev za obnovo vsebine zbirke vsebin.';
$string['configrestoreenrolments'] = 'Nastavi privzeto izbiro za obnavljanje metod vpisa.';
$string['configrestorefilters'] = 'Nastavi privzeto izbiro za obnavljanje filtrov.';
$string['configrestoregroups'] = 'Nastavi privzeto izbiro za obnavljanje skupin in razvrščanj, če so bile vključene v varnostno kopijo.';
$string['configrestorehistories'] = 'Nastavi privzeto izbiro za obnavljanje zgodovine uporabnika, če je bila vključena v varnostno kopijo.';
$string['configrestorelogs'] = 'Če je to omogočeno, bodo poročila privzeto obnovljena, če so bila vključena v varnostno kopijo.';
$string['configrestoreroleassignments'] = 'Če je to omogočeno, bodo dodelitve vlog privzeto obnovljene, če so bile vključene v varnostno kopijo.';
$string['configrestoreusers'] = 'Določi privzeto možnost ali naj se obnovi uporabnike, če so bili vključeni v varnostno kopijo.';
$string['configrestoreuserscompletion'] = 'Če je to omogočeno bodo informacije o uporabnikovem dokončanju privzeto obnovljene, če so bile vključene v varnostno kopijo.';
$string['confirmcancel'] = 'Prekliči varnostno kopiranje';
$string['confirmcancelimport'] = 'Prekliči uvoz';
$string['confirmcancelno'] = 'Ne prekliči';
$string['confirmcancelquestion'] = 'Ali ste prepričani, da želite preklicati?
Vse vnešene informacije bodo izgubljene.';
$string['confirmcancelrestore'] = 'Prekliči obnovo';
$string['confirmcancelyes'] = 'Prekliči varnostno kopiranje';
$string['confirmnewcoursecontinue'] = 'Novo opozorilo za predmet';
$string['confirmnewcoursecontinuequestion'] = 'Začasen (skrit) predmet bo ustvarjen med postopkom obnovitve predmeta. Za prekinitev obnovitve pritisnite gumb Prekliči. Med obnovitvijo ne zapirajte brskalnika.';
$string['copiesinprogress'] = 'Za ta predmet je kopiranje že v teku. <a href="{$a}">Poglejte kopije v teku.</a>';
$string['copycoursedesc'] = 'Ta predmet bo podvojen in vstavljen v izbrano kategorijo.';
$string['copycourseheading'] = 'Kopiraj predmet';
$string['copycoursetitle'] = 'Kopiraj predmet: {$a}';
$string['copydest'] = 'Cilj';
$string['copyfieldnotfound'] = 'Zahtevanega polja ni mogoče najti';
$string['copyformfail'] = 'AJAX predložitev obrazca za kopiranje predmeta je spodletela.';
$string['copyingcourse'] = 'Kopiranje predmeta je v teku';
$string['copyingcourseshortname'] = 'kopiram';
$string['copyop'] = 'Trenutni postopek';
$string['copyprogressheading'] = 'Kopije predmeta v teku';
$string['copyprogressheading_help'] = 'Ta tabela prikazuje status vseh vaših nedokončanih kopij predmeta.';
$string['copyprogresstitle'] = 'Potek kopije predmeta';
$string['copyreturn'] = 'Kopiraj in se vrni';
$string['copysource'] = 'Vir';
$string['copyview'] = 'Kopiraj in oglej';
$string['coursecategory'] = 'Kategorija predmeta bo obnovljena v';
$string['courseid'] = 'Izvorni ID';
$string['coursesettings'] = 'Nastavitve predmeta';
$string['coursetitle'] = 'Naslov';
$string['currentstage1'] = 'Začetne nastavitve';
$string['currentstage16'] = 'Zaključeno';
$string['currentstage2'] = 'Nastavitve sheme';
$string['currentstage4'] = 'Potrditev in pregled';
$string['currentstage8'] = 'Izvedi varnostno kopiranje';
$string['enableasyncbackup'] = 'Omogoči asinhrone varnostne kopije';
$string['enableasyncbackup_help'] = 'Če je omogočeno bodo vsi postopki varnostnega kopiranja in obnove izvedeni asinhrono. To ne vpliva na izvoze in uvoze. Asinhrono izvajanje varnostnih kopij in obnov omogoča uporabniku, da lahko med izvajanjem postopka varnostnega kopiranja ali obnove na strani počne druge stvari.';
$string['enterasearch'] = 'Vnesite iskalni niz';
$string['error_block_for_module_not_found'] = 'Posamezni zapuščen blok (id: {$a->bid}) za modul predmeta (id: {$a->mid}). Ta blok ne bo vključen v varnostno kopijo';
$string['error_course_module_not_found'] = 'Najden je zapuščen modul predmeta (id: {$a}). Ta modul ne bo vključen v varnostno kopijo.';
$string['errorcopyingbackupfile'] = 'Kopiranje varnostne kopije v začasno mapo pred obnavljanjem ni bilo uspešno.';
$string['errorfilenamemustbezip'] = 'Ime datoteka, ki jo vnašate, mora biti v formatu ZIP in mora imeti končnico .mbz';
$string['errorfilenamerequired'] = 'Vnesti morate veljavno ime za to varnostno kopijo';
$string['errorfilenametoolong'] = 'Ime datoteke mora biti krajše od 255 znakov.';
$string['errorinvalidformat'] = 'Neznan format varnostne kopije';
$string['errorinvalidformatinfo'] = 'Izbrana datoteka ni veljavna varnostna kopija Moodla in ne more biti obnovljena.';
$string['errorminbackup20version'] = 'Ta varnostna kopija je bila ustvarjena z eno od razvojnih različic varnostnega kopiranja Moodla ({$a->backup}). Minimalna zahteva je {$a->min}. Ni mogoče obnoviti.';
$string['errorrestorefrontpagebackup'] = 'Prvo stran lahko obnovite samo na prvi strani';
$string['executionsuccess'] = 'Varnostna kopija je uspešno ustvarjena.';
$string['extractingbackupfileto'] = 'Razširi varnostno kopijo v: {$a}';
$string['failed'] = 'Varnostno kopiranje je spodletelo';
$string['filealiasesrestorefailures'] = 'Napake pri obnovi vzdevkov';
$string['filealiasesrestorefailures_help'] = 'Vzdevki so simbolične povezave do drugih datotek, vključno s shranjenimi v zunanjih skladiščih. V nekaterih primerih jih Moodle ne more obnoviti, na primer pri obnavljanju varnostne kopije na drugem spletnem mestu, ali ko referenčna datoteka ne obstaja.

Več podrobnosti in dejanski razlog za napako lahko najdete v obnovljeni dnevniški datoteki.';
$string['filealiasesrestorefailures_link'] = 'obnovi/vzdevki datotek';
$string['filealiasesrestorefailuresinfo'] = 'Nekateri vzdevki, vključeni v varnostno kopijo, se ne morejo obnoviti. Naslednji seznam vsebuje njihova pričakovana mesta in izvorne datoteke, na katere so se nanašali na izvornem spletnem mestu.';
$string['filename'] = 'Ime datoteke';
$string['filereferencesincluded'] = 'Referenca datoteke do zunanjih vsebin je vključena v paket varnostne kopije in ne bo delovala na drugih spletnih mestih.';
$string['filereferencesnotsamesite'] = 'Varnostna kopija je z drugega spletnega mesta, referenca datoteke se ne more obnoviti.';
$string['filereferencessamesite'] = 'Varnostna kopija je z istega spletnega mesta, referenca datoteke se lahko obnovi.';
$string['generalactivities'] = 'Vključi dejavnosti in vire';
$string['generalanonymize'] = 'Anonimiziraj informacije';
$string['generalbackdefaults'] = 'Splošne privzete vrednosti varnostnega kopiranja';
$string['generalbadges'] = 'Vključi značke';
$string['generalblocks'] = 'Vključi bloke';
$string['generalcalendarevents'] = 'Vključi dogodke s koledarja';
$string['generalcomments'] = 'Vključi komentarje';
$string['generalcompetencies'] = 'Vključi kompetence';
$string['generalcontentbankcontent'] = 'Vključi vsebino zbirke vsebin';
$string['generalenrolments'] = 'Vključi metode vpisa';
$string['generalfiles'] = 'Vključi datoteke';
$string['generalfilters'] = 'Vključi filtre';
$string['generalgradehistories'] = 'Vključi zgodovine';
$string['generalgroups'] = 'Vključi skupine in skupke';
$string['generalhistories'] = 'Vključi zgodovine';
$string['generallegacyfiles'] = 'Vključi podedovane datoteke predmeta';
$string['generallogs'] = 'Vključi dnevnike';
$string['generalquestionbank'] = 'Vključi zbirko vprašanj';
$string['generalrestoredefaults'] = 'Splošne privzete izbire obnovitve';
$string['generalrestoresettings'] = 'Splošne nastavitve obnovitve';
$string['generalroleassignments'] = 'Vključi dodeljevanje vlog';
$string['generalsettings'] = 'Splošne nastavitve varnostnega kopiranja';
$string['generalusers'] = 'Vključi uporabnike';
$string['generaluserscompletion'] = 'Vključi informacije o uporabnikovih zaključkih';
$string['hidetypes'] = 'Skrij možnosti tipa';
$string['importbackupstage16action'] = 'Nadaljuj';
$string['importbackupstage1action'] = 'Naprej';
$string['importbackupstage2action'] = 'Naprej';
$string['importbackupstage4action'] = 'Izvedi uvoz';
$string['importbackupstage8action'] = 'Nadaljuj';
$string['importcurrentstage0'] = 'Izbira predmeta';
$string['importcurrentstage1'] = 'Začetne nastavitve';
$string['importcurrentstage16'] = 'Zaključeno';
$string['importcurrentstage2'] = 'Nastavitve sheme';
$string['importcurrentstage4'] = 'Potrditev in pregled';
$string['importcurrentstage8'] = 'Izvedi uvoz';
$string['importfile'] = 'Uvozi varnostno kopijo';
$string['importgeneralduplicateadminallowed'] = 'Dovoli razrešitev konfilkotv za račun admin';
$string['importgeneralduplicateadminallowed_desc'] = 'Če ima stran račun z uporabniškim imenom \'admin\', potem lahko pride do konflikta pri obnavljanju varnostne kopije, ki vsebuje ta račun. Če je ta nastavitev omogočena, bo konflikt rešen s spreminjanjem uporabniškega imena v varnostni kopiji na \'admin_xyz‘.';
$string['importgeneralmaxresults'] = 'Seznam največjega števila predmetov za uvoz';
$string['importgeneralmaxresults_desc'] = 'To nadzoruje število predmetov, ki so navedeni v prvem koraku uvažanja';
$string['importgeneralsettings'] = 'Splošne privzete vrednosti za uvoz';
$string['importrootsettings'] = 'Nastavitve uvoza';
$string['importsettings'] = 'Splošne nastavitve uvoza';
$string['importsuccess'] = 'Uvoz je zaključen. Kliknite "Nadaljuj" za vrnitev v predmet.';
$string['includeactivities'] = 'Vključi:';
$string['includeditems'] = 'Vključeni elementi:';
$string['includefilereferences'] = 'Referenca datoteke do zunanjih vsebin';
$string['includesection'] = 'Odsek {$a}';
$string['includeuserinfo'] = 'Podatki o uporabniku';
$string['inprogress'] = 'Varnostno kopiranje je v teku';
$string['jumptofinalstep'] = 'Skoči na zadnji korak';
$string['keep'] = 'Obdrži';
$string['keptroles'] = 'Vključi vpise vlog';
$string['keptroles_help'] = 'Uporabniki z izbranimi vlogami bodo vpisani v nov predmet. Uporabnikovi podatki ne bodo kopirani, razen če je omogočena možnost \'Vključi uporabnikove podatke\'.';
$string['locked'] = 'Zaklenjeno';
$string['lockedbyconfig'] = 'Ta nastavitev je zaklenjena v privzetih vrednostih varnostnega kopiranja';
$string['lockedbyhierarchy'] = 'Zaklenjeno z odvisnostmi';
$string['lockedbypermission'] = 'Nimate zadostnih pravic za spreminjanje te nastavitve';
$string['loglifetime'] = 'Obdrži dnevnike za';
$string['managefiles'] = 'Uredi varnostne kopije';
$string['mergerestoredefaults'] = 'Obnovi privzete izbire pri obnavljanju v drug predmet';
$string['missingfilesinpool'] = 'Med izdelavo varnostne kopije nekaterih datotek ni bilo možno shraniti, zato jih ne bo možno obnoviti.';
$string['module'] = 'Modul';
$string['moodleversion'] = 'Različica Moodle';
$string['morecoursesearchresults'] = 'Najdeno število predmetov je večje od {$a}. Število prvih prikazanih rezultatov: {$a}';
$string['moreresults'] = 'Obstaja preveč zadetkov, vnesite natančnejše iskanje.';
$string['nomatchingcourses'] = 'Ni predmetov za prikaz';
$string['norestoreoptions'] = 'Ni kategorij ali obstoječih predmetov, v katere bi lahko obnavljali.';
$string['originalwwwroot'] = 'Povezava varnostne kopije';
$string['overwrite'] = 'Prepiši';
$string['pendingasyncdeletedetail'] = 'Ta predmet ima na čakanju asinhrono varnostno kopiranje. <br/> Dokler se varnostno kopiranje ne zaključi, predmetov ni mogoče izbrisati.';
$string['pendingasyncdetail'] = 'Asinhrono varnostno kopiranje dovoljuje, da ima uporabnik na čakanju zgolj eno varnostno kopiranje za posamezen vir. <br/> Več varnostnih kopiranj posameznega vira ne more biti uvrščenih v čakalno vrsto, saj bi to povzročilo več varnostnih kopij z enako vsebino.';
$string['pendingasyncedit'] = 'Varnostno kopiranje za ta predmet je na čakanju. Prosimo, da do zaključka varnostnega kopiranja tega predmeta ne urejate.';
$string['pendingasyncerror'] = 'Varnostno kopiranje za ta vir je na čakanju';
$string['preparingdata'] = 'Pripravljanje podatkov';
$string['preparingui'] = 'Priprava za prikaz strani';
$string['previousstage'] = 'Prejšnji';
$string['privacy:metadata:backup:detailsofarchive'] = 'Ta arhiv lahko vsebuje različne podatke povezane z predmetom kot so ocene, vpisi uporabnika in podatki o dejavnosti.';
$string['privacy:metadata:backup:externalpurpose'] = 'Namen tega arhiva je shranjevati informacije povezane z predmetom, ki so v prihodnosti lahko obnovljene.';
$string['privacy:metadata:backup_controllers'] = 'Seznam operacij za varnostne kopije';
$string['privacy:metadata:backup_controllers:itemid'] = 'ID predmeta';
$string['privacy:metadata:backup_controllers:operation'] = 'Operacija, ki je bila izvedena, npr. obnovi.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Čas, ko je bil ukaz ustvarjen';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Čas, ko je bilo dejanje spremenjeno';
$string['privacy:metadata:backup_controllers:type'] = 'Tip elementa, s katerim operiramo, npr. dejavnost.';
$string['qcategory2coursefallback'] = 'Kategorija vprašanj "{$a->name}", ki je prvotno v varnostni kopiji v okviru kategorije sistem/predmet, bo ob obnovi ustvarjena v okviru predmeta';
$string['qcategorycannotberestored'] = 'Kategorije vprašanj "{$a->name}" pri obnovi ni mogoče ustvariti ';
$string['question2coursefallback'] = 'Kategorija vprašanj "{$a->name}", ki je prvotno v varnostni kopiji v okviru kategorije sistem/predmet, bo ob obnovi ustvarjena v okviru predmeta';
$string['questioncannotberestored'] = 'Vprašanja "{$a->name}" z obnovitvijo ne morejo biti ustvarjena';
$string['recyclebin_desc'] = 'Opomba: Te nastavitve bodo uporabljene tudi za koš.';
$string['replacerestoredefaults'] = 'Obnovi privzete izbire pri obnavljanju v drug predmet z izbrisano vsebino';
$string['restoreactivity'] = 'Obnovi dejavnost';
$string['restorecourse'] = 'Obnovi predmet';
$string['restorecoursesettings'] = 'Nastavitve predmeta';
$string['restoredcourseid'] = 'ID obnovljenega predmeta: {$a}';
$string['restoreexecutionsuccess'] = 'Predmet je uspešno obnovljen; s klikom na po kliku na gumb "Nadaljuj" si lahko ogledate predmet, ki ste ga obnovili.';
$string['restorefileweremissing'] = 'Nekaterih datotek ni bilo mogoče obnoviti, ker jih ni v varnostni kopiji.';
$string['restorenewcoursefullname'] = 'Novo ime predmeta';
$string['restorenewcourseshortname'] = 'Novo kratko ime predmeta';
$string['restorenewcoursestartdate'] = 'Nov datum začetka';
$string['restorerolemappings'] = 'Obnovi preslikave vlog';
$string['restorerootsettings'] = 'Obnovi nastavitve';
$string['restoresection'] = 'Obnovi odsek';
$string['restorestage1'] = 'Potrdi';
$string['restorestage16'] = 'Pregled';
$string['restorestage16action'] = 'Izvedi obnovo';
$string['restorestage1action'] = 'Naprej';
$string['restorestage2'] = 'Cilj';
$string['restorestage2action'] = 'Naprej';
$string['restorestage32'] = 'Postopek';
$string['restorestage32action'] = 'Nadaljuj';
$string['restorestage4'] = 'Nastavitve';
$string['restorestage4action'] = 'Naprej';
$string['restorestage64'] = 'Zaključeno';
$string['restorestage64action'] = 'Nadaljuj';
$string['restorestage8'] = 'Shema';
$string['restorestage8action'] = 'Naprej';
$string['restoretarget'] = 'Obnovi cilj';
$string['restoretocourse'] = 'Obnovi v predmet:';
$string['restoretocurrentcourse'] = 'Obnovi v ta predmet';
$string['restoretocurrentcourseadding'] = 'Spoji varnostno kopijo predmeta v ta predmet';
$string['restoretocurrentcoursedeleting'] = 'Izbriši vsebino tega predmeta in nato obnovi';
$string['restoretoexistingcourse'] = 'Obnovi v obstoječi predmet';
$string['restoretoexistingcourseadding'] = 'Spoji varnostno kopijo predmeta v obstoječi predmet';
$string['restoretoexistingcoursedeleting'] = 'Izbriši vsebino obstoječega predmeta in nato obnovi';
$string['restoretonewcourse'] = 'Obnovi kot nov predmet';
$string['restoringcourse'] = 'Obnavljanje predmeta v teku';
$string['restoringcourseshortname'] = 'obnavljanje';
$string['rootenrolmanual'] = 'Obnovi kot ročne vpise';
$string['rootsettingactivities'] = 'Vključi dejavnosti in vire';
$string['rootsettinganonymize'] = 'Anonimiziraj uporabnikove informacije';
$string['rootsettingbadges'] = 'Vključi značke';
$string['rootsettingblocks'] = 'Vključi bloke';
$string['rootsettingcalendarevents'] = 'Vključi dogodke s koledarja';
$string['rootsettingcomments'] = 'Vključi komentarje';
$string['rootsettingcompetencies'] = 'Vključi kompetence';
$string['rootsettingcontentbankcontent'] = 'Vključi vsebino zbirke vsebin';
$string['rootsettingcustomfield'] = 'Vključi polja po meri';
$string['rootsettingenrolments'] = 'Vključi metode vpisa';
$string['rootsettingenrolments_always'] = 'Ja, vedno';
$string['rootsettingenrolments_never'] = 'Ne, obnovi uporabnike kot ročne vpise';
$string['rootsettingenrolments_withusers'] = 'Ja, a samo če so vključeni uporabniki';
$string['rootsettingfiles'] = 'Vključi datoteke';
$string['rootsettingfilters'] = 'Vključi filtre';
$string['rootsettinggradehistories'] = 'Vključi zgodovino ocen';
$string['rootsettinggroups'] = 'Vključi skupine in skupke';
$string['rootsettingimscc1'] = 'Pretvori v standard IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Pretvori v standard IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Vključi podedovane datoteke predmeta';
$string['rootsettinglogs'] = 'Vključi dnevnike predmeta';
$string['rootsettingquestionbank'] = 'Vključi zbirko vprašanj';
$string['rootsettingroleassignments'] = 'Vključi dodeljevanje uporabnikovih vlog';
$string['rootsettings'] = 'Nastavitve varnostne kopije';
$string['rootsettingusers'] = 'Vključi vpisane uporabnike';
$string['rootsettinguserscompletion'] = 'Vključi podrobnosti uporabnikovih zaključkov';
$string['samesitenotification'] = 'V to varnostno kopijo so bili vključeni zgolj sklici na datoteke, in ne datoteke same. Obnova bo delovala zgolj na tem portalu.';
$string['sectionactivities'] = 'Dejavnosti';
$string['sectioninc'] = 'Vključeno v varnostno kopijo (brez informacij o uporabniku)';
$string['sectionincanduser'] = 'Vključeno v varnostno kopijo z informacijami o uporabniku';
$string['selectacategory'] = 'Izberi kategorijo';
$string['selectacourse'] = 'Izberi predmet';
$string['setting_course_fullname'] = 'Ime predmeta';
$string['setting_course_shortname'] = 'Kratko ime predmeta';
$string['setting_course_startdate'] = 'Datum začetka predmeta';
$string['setting_keep_groups_and_groupings'] = 'Obdrži trenutne skupine in skupke';
$string['setting_keep_roles_and_enrolments'] = 'Obdrži trenutne vloge in vpise';
$string['setting_overwrite_conf'] = 'Prepiši konfiguracijo predmeta';
$string['setting_overwrite_course_fullname'] = 'Prepiši polno ime predmeta';
$string['setting_overwrite_course_shortname'] = 'Prepiši kratko ime predmeta';
$string['setting_overwrite_course_startdate'] = 'Prepiši začetni datum predmeta';
$string['showtypes'] = 'Prikaži možnosti tipa';
$string['sitecourseformatwarning'] = 'To ni varnostna kopija prve strani. Obnovijo se lahko samo na prvi strani';
$string['skiphidden'] = 'Preskoči skrite predmete';
$string['skiphiddenhelp'] = 'Izberite, če želite preskočiti skrite predmete';
$string['skipmodifdays'] = 'Preskoči predmete, ki niso bili spremenjeni od';
$string['skipmodifdayshelp'] = 'Izberite, če želite preskočiti predmete, ki niso bili spremenjeni izbrano število dni';
$string['skipmodifprev'] = 'Preskoči predmete, ki niso bili spremenjeni od prejšnjega varnostnega kopiranja';
$string['skipmodifprevhelp'] = 'Izberite, če želite preskočiti predmete, ki niso bili spremenjeni od zadnjega varnostnega kopiranja. To zahteva, da je beleženje dnevnika omogočeno.';
$string['status'] = 'Stanje';
$string['storagecourseandexternal'] = 'Območje datotek varnostnih kopij predmeta in določeni imenik';
$string['storagecourseonly'] = 'Območje datotek varnostnih kopij predmeta';
$string['storageexternalonly'] = 'Določeni imenik za samodejne varnostne kopije';
$string['successful'] = 'Varnostna kopija uspešna';
$string['successfulcopy'] = 'Kopiranje uspešno';
$string['successfulrestore'] = 'Obnova uspešna';
$string['timetaken'] = 'Porabljeni čas';
$string['title'] = 'Naslov';
$string['totalcategorysearchresults'] = 'Skupno število kategorij: {$a}';
$string['totalcoursesearchresults'] = 'Skupno število predmetov: {$a}';
$string['undefinedrolemapping'] = 'Vloga preslikave ni definirana za arhetip.';
$string['unnamedsection'] = 'Neimenovani odsek';
$string['userdata'] = 'Vključi uporabnikove podatke';
$string['userdata_help'] = 'Če je omogočeno, bodo podatki, kot so objave na forumu, oddane naloge, itd., kopirani v nov predmet za vse uporabnike z vlogo izbrano z \'Vključi vpise vlog\'.';
$string['userinfo'] = 'Informacije o uporabniku';
