<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'lt', version '4.2'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'Padaryti';
$string['activityisscheduledfordeletion'] = 'Vykdomas veiklos naikinimas...';
$string['agedigitalconsentmapinvalidage'] = '„{$a}“ nėra tinkama amžiaus reikšmė.';
$string['agedigitalconsentmapinvalidcomma'] = '„{$a}“ turi daugiau arba mažiau nei vieną kablelio skyriklį.';
$string['agedigitalconsentmapinvalidcountry'] = '„{$a}“ nėra tinkama šalies reikšmė.';
$string['agedigitalconsentmapinvaliddefault'] = 'Trūksta numatytosios (*) reikšmės.';
$string['agelocationverificationdisabled'] = 'Amžiaus ir vietos patvirtinimas išjungtas';
$string['alreadyloggedin'] = 'Jūs jau prisijungęs kaip {$a}; prieš jungdamiesi kito naudotojo vardu, turite atsijungti.';
$string['authnotexisting'] = 'Autentifikavimo papildinio nėra';
$string['backupcontainexternal'] = 'Šis atsarginio kopijavimo failas apima išorinio „Moodle“ tinklo pagrindinius kompiuterius, kurie nesukonfigūruoti vietinėje sistemoje';
$string['backuptablefail'] = 'Atsarginio kopijavimo lentelių nebuvo įmanoma nustatyti sėkmingai!';
$string['blockcannotconfig'] = 'Atsarginio kopijavimo lentelių nebuvo įmanoma nustatyti sėkmingai!';
$string['blockcannotinistantiate'] = 'Kilo problema kuriant bloko objekto egzempliorių';
$string['blockcannotread'] = 'Nepavyko perskaityti blockid= {$a} duomenų';
$string['blockdoesnotexist'] = 'Tokio bloko nėra';
$string['blockdoesnotexistonpage'] = 'Tokio bloko (id={$a->instanceid}) nėra šiame puslapyje ({$a->url}).';
$string['blocknameconflict'] = 'Konfliktas dėl pavadinimo suteikimo: blokas {$a->name} turi tokį patį pavadinimą kaip ir esamas blokas {$a->conflict}!';
$string['callbackrejectcomment'] = 'Komentarų atšaukimas atmetė šį komentarą';
$string['cannotaddcoursemodule'] = 'Nepavyko įtraukti naujo kursų modulio';
$string['cannotaddcoursemoduletosection'] = 'Nepavyko įtraukti naujo kursų modulio į šią dalį';
$string['cannotaddmodule'] = '{$a} modulio nepavyko įtraukti į šio modulio sąrašą!';
$string['cannotaddnewmodule'] = 'Nepavyko įtraukti naujo {$a} modulio';
$string['cannotaddrss'] = 'Jūs neturite teisių įtraukti RSS informacijos santraukų';
$string['cannotaddthisblocktype'] = 'Negalite įtraukti {$a} bloko į šį puslapį.';
$string['cannotassignrole'] = 'Negalima priskirti vaidmens kursuose';
$string['cannotassignrolehere'] = 'Jums neleidžiama priskirti šio vaidmens (id = {$a->roleid}) šiame kontekste ({$a->context})';
$string['cannotassignselfasparent'] = 'Negalima priskirti savęs kaip pirminio!';
$string['cannotcallscript'] = 'Negalite iškviesti šio scenarijaus tokiu būdu';
$string['cannotcallusgetselecteduser'] = 'Negalite iškviesti user_selector::get_selected_user, jei įjungtas kelių variantų pasirinkimas.';
$string['cannotcreatebackupdir'] = 'Nepavyko sukurti atsarginių duomenų aplanko. Šios svetainės administratorius turi pakoreguoti failo teises.';
$string['cannotcreatecategory'] = 'Kategorija nebuvo įterpta';
$string['cannotcreatedboninstall'] = '<p>Nepavyko sukurti duomenų bazės.</p>
<p>Nurodyta duomenų bazė neegzistuoja ir nurodytas naudotojas neturi leidimo kurti duomenų bazės.</p>
<p>Svetainės administratorius turėtų patikrinti duomenų bazės konfigūraciją.</p>';
$string['cannotcreategroup'] = 'Įvyko klaida kuriant grupę';
$string['cannotcreatelangbase'] = 'Klaida: nepavyko sukurti pagrindinio kalbos katalogo';
$string['cannotcreatelangdir'] = 'Negalima sukurti kalbos katalogo';
$string['cannotcreateorfindstructs'] = 'Įvyko klaida ieškant šių kursų dalių struktūrų arba jas kuriant';
$string['cannotcreatepopupwin'] = 'Neapibrėžtas elementas – negalima sukurti iššokančiojo lango';
$string['cannotcreatesitedir'] = 'Negalima sukurti svetainės aplanko. Šios svetainės administratorius turi pakoreguoti failo teises.';
$string['cannotcreatetempdir'] = 'Negalima sukurti laikinojo katalogo';
$string['cannotcreateuploaddir'] = 'Negalima sukurti įkelties aplanko. Šios svetainės administratorius turi pakoreguoti failo teises.';
$string['cannotcustomisefiltersblockuser'] = 'Negalite tinkinti naudotojo filtrų parametrų arba blokuoti kontekstų.';
$string['cannotdeletebackupids'] = 'Nepavyko panaikinti ankstesnių atsarginių kopijų ID';
$string['cannotdeletecategorycourse'] = 'Kursų {$a} nepavyko panaikinti.';
$string['cannotdeletecategoryquestions'] = 'Nepavyko panaikinti klausimų iš kategorijos {$a}';
$string['cannotdeletecourse'] = 'Jūs neturite teisės panaikinti šių kursų';
$string['cannotdeletecustomfield'] = 'Įvyko klaida naikinant pasirinktinio lauko duomenis';
$string['cannotdeletedir'] = 'Negalima panaikinti ({$a})';
$string['cannotdeletefile'] = 'Negalima panaikinti šio failo';
$string['cannotdeleterole'] = 'Negalima panaikinti, nes {$a}';
$string['cannotdeleterolewithid'] = 'Negalima panaikinti vaidmens, kurio ID {$a}';
$string['cannotdeletethisrole'] = 'Negalite panaikinti šio vaidmens, nes jį naudoja sistema arba tas vaidmuo vienintelis turi administratoriaus teises.';
$string['cannotdisableformat'] = 'Numatytasis formatas negali būti išjungtas.';
$string['cannotdownloadcomponents'] = 'Negalima atsisiųsti komponentų';
$string['cannotdownloadlanguageupdatelist'] = 'Negalima atsisiųsti kalbos naujinių sąrašo iš download.moodle.org';
$string['cannotdownloadzipfile'] = 'Negalima atsisiųsti ZIP failo';
$string['cannoteditcomment'] = 'Šis komentaras ne jūsų, todėl negalite redaguoti!';
$string['cannoteditcommentexpired'] = 'Negalite redaguoti. Baigėsi laikas!';
$string['cannoteditpostorblog'] = 'Negalite skelbti arba redaguoti tinklaraščių';
$string['cannoteditsiteform'] = 'Negalite redaguoti svetainės kursų naudodami šią formą';
$string['cannotedituserpreferences'] = 'Negalima redaguoti šio naudotojo nuostatų';
$string['cannotedityourprofile'] = 'Atsiprašome, bet negalite redaguoti savo profilio';
$string['cannotexecduringupgrade'] = 'Negalima vykdyti atnaujinimo metu';
$string['cannotfindcategory'] = 'Nepavyko rasti kategorijos įrašo duomenų bazėje pagal ID – {$a}';
$string['cannotfindcomponent'] = 'Nepavyko rasti komponento';
$string['cannotfindcontext'] = 'Nepavyko rasti konteksto';
$string['cannotfindcourse'] = 'Nepavyko rasti kursų';
$string['cannotfinddocs'] = 'Nepavyko rasti {$a} kalbos dokumentų failų';
$string['cannotfindgradeitem'] = 'Nepavyko rasti grade_item';
$string['cannotfindgroup'] = 'Nepavyko rasti grupės';
$string['cannotfindhelp'] = 'Nepavyko rasti {$a} kalbos žinyno failų';
$string['cannotfindinfo'] = 'Nepavyko rasti {$a} informacijos';
$string['cannotfindlang'] = 'Nepavyko rasti {$a} kalbos paketo!';
$string['cannotfindteacher'] = 'Nepavyko rasti dėstytojo';
$string['cannotfinduser'] = 'Nepavyko rasti naudotojo vardu {$a}';
$string['cannotgeoplugin'] = 'Nepavyksta prisijungti prie geoPlugin serverio adresu https://www.geoplugin.com. Patikrinkite tarpinio serverio nustatymus arba įdiekite MaxMind GeoLite City duomenų failą.';
$string['cannotgetblock'] = 'Nepavyko nuskaityti blokų iš duomenų bazės';
$string['cannotgetcats'] = 'Nepavyko gauti kategorijos įrašo';
$string['cannotgetdata'] = 'Nepavyko gauti duomenų';
$string['cannotgradeuser'] = 'Negalima įvertinti šio naudotojo';
$string['cannothaveparentcate'] = 'Kurso kategorija negali turėti pirminės kategorijos!';
$string['cannotimport'] = 'Importavimo klaida';
$string['cannotimportformat'] = 'Atsiprašome, šio formato importavimo galimybė dar neįdiegta!';
$string['cannotimportgrade'] = 'Įvertinimo importavimo klaida';
$string['cannotinsertgrade'] = 'Negalima įterpti įvertinimo elemento be kurso ID!';
$string['cannotinsertrate'] = 'Negalima įterpti naujo įvertinimo ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Negalima įterpti naujo įrašo ID {$a}';
$string['cannotmailconfirm'] = 'Įvyko klaida siunčiant slaptažodžio keitimo patvirtinimo el. laišką';
$string['cannotmanualctrack'] = 'Veikla neteikia galimybės sekti atlikimo rankiniu būdu proceso';
$string['cannotmapfield'] = 'Aptiktas susiejimo konfliktas – du laukai susieti su tuo pačiu įvertinimo elementu {$a}';
$string['cannotmarktopic'] = 'Nepavyko pažymėti šių kursų temos';
$string['cannotmigratedatacomments'] = 'Negalima perkelti duomenų modulio komentarų';
$string['cannotmodulename'] = 'Negalima gauti modulio pavadinimo komponavimo versijos naršymo sistemoje';
$string['cannotmoduletype'] = 'Negalima gauti modulio tipo komponavimo versijos naršymo sistemoje';
$string['cannotmovecategory'] = 'Negalima perkelti kategorijos';
$string['cannotmovecourses'] = 'Negalima perkelti kursų iš kategorijos, kurioje jie yra į kitą.';
$string['cannotmoverolewithid'] = 'Negalima perkelti vaidmens, kurio ID {$a}';
$string['cannotopencsv'] = 'Negalima atidaryti CSV failo';
$string['cannotopenfile'] = 'Negalima atidaryti failo ({$a})';
$string['cannotopenforwrit'] = 'Negalima atidaryti norint rašyti: {$a}';
$string['cannotopentemplate'] = 'Negalima atidaryti šablono failo ({$a})';
$string['cannotopenzip'] = 'Negalima atidaryti ZIP failo, tikriausiai dėl 64 bitų OS zip plėtinio klaidos.';
$string['cannotoverridebaserole'] = 'Negalima pakeisti pagrindinio vaidmens galimybių';
$string['cannotoverriderolehere'] = 'Jums neleidžiama keisti šio vaidmens (id = {$a->roleid}) šiame kontekste ({$a->context})';
$string['cannotreadfile'] = 'Negalima perskaityti failo ({$a})';
$string['cannotreadtmpfile'] = 'Įvyko klaida bandant perskaityti laikinąjį failą';
$string['cannotreaduploadfile'] = 'Nepavyko perskaityti įkelto failo';
$string['cannotremovefrommeta'] = 'Nepavyko pašalinti pasirinktų kursų iš šių metakursų!';
$string['cannotreprocessgrades'] = 'Nepavyko iš naujo apdoroti šios veiklos „{$a}“ įvertinimų';
$string['cannotresetguestpwd'] = 'Negalite iš naujo nustatyti svečio slaptažodžio';
$string['cannotresetmail'] = 'Įvyko klaida iš naujo nustatant slaptažodį ir siunčiant jums laišką';
$string['cannotresetthisrole'] = 'Negalima iš naujo nustatyti šio vaidmens';
$string['cannotrestore'] = 'Įvyko klaida, todėl nepavyko pabaigti atkūrimo proceso!';
$string['cannotrestoreadminorcreator'] = 'Jūs turite būti kūrėjas arba administratorius, kad galėtumėte atkurti naujus kursus!';
$string['cannotrestoreadminoredit'] = 'Jūs turite būti redaguojantis dėstytojas arba administratorius, kad galėtumėte atkurti pasirinktus kursus!';
$string['cannotsaveagreement'] = 'Nepavyko įrašyti jūsų sutarties';
$string['cannotsaveblock'] = 'Įvyko klaida bandant įrašyti bloko konfigūraciją';
$string['cannotsavecomment'] = 'Negalima įrašyti komentaro';
$string['cannotsavedata'] = 'Negalima įrašyti duomenų';
$string['cannotsavefile'] = 'Negalima įrašyti failo {$a}!';
$string['cannotsavemd5file'] = 'Negalima įrašyti md5 failo';
$string['cannotsavezipfile'] = 'Negalima įrašyti ZIP failo';
$string['cannotservefile'] = 'Negalima aptarnauti failo dėl serverio konfigūracijos problemos.';
$string['cannotsetparentforcatoritem'] = 'Negalima nustatyti kategorijos arba kursų elemento pirminio elemento!';
$string['cannotsetpassword'] = 'Nepavyko nustatyti naudotojo slaptažodžio!';
$string['cannotsetprefgrade'] = 'Nepavyko nustatyti šio įverčio kategorijos nuostatos Agregavimo rodinys reikšmės {$a}';
$string['cannotsettheme'] = 'Nepavyko nustatyti šios temos!';
$string['cannotsetupblock'] = 'Blokų lentelių nebuvo įmanoma nustatyti sėkmingai!';
$string['cannotsetupcapformod'] = 'Nepavyko nustatyti {$a} galimybių';
$string['cannotsetupcapforplugin'] = 'Nepavyko nustatyti {$a} galimybių';
$string['cannotshowhidecoursesincategory'] = 'Negalima rodyti / slėpti kursų kategorijoje {$a}.';
$string['cannotsignup'] = 'Jūs negalite sukurti naujos paskyros, nes jūs jau esate prisijungęs kaip {$a}.';
$string['cannotswitcheditmodeon'] = 'Nepavyko įjungti redagavimo režimo';
$string['cannotunassigncap'] = 'Nerekomenduojamos galimybės {$a->cap} nepavyko atskirti nuo vaidmens {$a->role}';
$string['cannotunassignrolefrom'] = 'Negalima šio naudotojo atskirti nuo vaidmens, kurio ID {$a}';
$string['cannotunzipfile'] = 'Negalima išskleisti failo';
$string['cannotupdatemod'] = 'Nepavyko atnaujinti {$a}';
$string['cannotupdatepasswordonextauth'] = 'Nepavyko atnaujinti išorinio autentifikavimo slaptažodžio: {$a}. Dėl išsamesnės informacijos žr. serverio žurnalus.';
$string['cannotupdateprofile'] = 'Įvyko klaida naujinant naudotojo įrašą';
$string['cannotupdaterecord'] = 'Nepavyko atnaujinti įrašo ID {$a}';
$string['cannotupdaterss'] = 'Negalima atnaujinti RSS';
$string['cannotupdatesubcourse'] = 'Nepavyko atnaujinti antrinių kursų!';
$string['cannotupdateusermsgpref'] = 'Negalima atnaujinti naudotojo žinučių nuostatų';
$string['cannotupdateuseronexauth'] = 'Nepavyko atnaujinti išorinio autentifikavimo naudotojo duomenų: {$a}. Dėl išsamesnės informacijos žr. serverio žurnalus.';
$string['cannotuploadfile'] = 'Įvyko klaida apdorojant įkelties failą';
$string['cannotuseadmin'] = 'Turite turėti administratoriaus teises, kad galėtumėte naudotis šiuo puslapiu';
$string['cannotuseadminadminorteacher'] = 'Turite būti dėstytojas arba turite turėti administratoriaus teises, kad galėtumėte naudotis šiuo puslapiu';
$string['cannotusepage'] = 'Tik dėstytojai ir administratoriai gali naudotis šiuo puslapiu';
$string['cannotusepage2'] = 'Atsiprašome, jūs negalite naudotis šiuo puslapiu';
$string['cannotviewcategory'] = 'Neturite leidimo peržiūrėti šio kursų sąrašo.';
$string['cannotviewprofile'] = 'Negalite peržiūrėti šio naudotojo profilio';
$string['cannotviewreport'] = 'Negalite peržiūrėti šios ataskaitos';
$string['cannotwritefile'] = 'Negalima rašyti į failą ({$a})';
$string['categoryerror'] = 'Kategorijos klaida';
$string['categoryidnumbertaken'] = 'ID numeris jau yra naudojamas kitai kategorijai';
$string['categorynamerequired'] = 'Reikalingas kategorijos pavadinimas';
$string['categorytoolong'] = 'Per ilgas kategorijos pavadinimas';
$string['commentmisconf'] = 'Komentaro ID yra neteisingai sukonfigūruotas';
$string['componentisuptodate'] = 'Komponentas atnaujintas';
$string['confirmationnotenabled'] = 'Naudotojo patvirtinimas šioje svetainėje neįjungtas';
$string['confirmsesskeybad'] = 'Atsiprašome, bet jūsų seanso raktas negali būti patvirtintas, kad galėtumėte atlikti šį veiksmą. Ši saugos funkcija saugo, kad jūsų vardu svarbios funkcijos nebūtų vykdomos atsitiktinai arba norint pakenkti. Patikrinkite, ar tikrai norite vykdyti šią funkciją.';
$string['contenttypenotfound'] = 'Turinio banko tipas „{$a}“ neegzistuoja arba jis neatpažįstamas.';
$string['contentvisibilitynotfound'] = 'Turinio matomumas su reikšme „{$a}“ neegzistuoja arba nėra atpažįstamas.';
$string['couldnotassignrole'] = 'Bandant priskirti jums vaidmenį, įvyko rimta klaida, bet jos apibrėžti nepavyko';
$string['couldnotupdatenoexistinguser'] = 'Negalima atnaujinti naudotojo – tokio naudotojo nėra';
$string['couldnotverifyagedigitalconsent'] = 'Bandant patvirtinti skaitmeninio sutikimo amžių įvyko klaida.<br />Susisiekite su administratoriumi.';
$string['countriesphpempty'] = 'Klaida: failo countries.php nėra kalbų pakete {$a} arba failas yra tuščias.';
$string['coursedoesnotbelongtocategory'] = 'Kursas nepriklauso šiai kategorijai';
$string['courseformatnotfound'] = 'Kurso formatas \'{$a}\' neegzistuoja arba jis neatpažįstamas.';
$string['coursegroupunknown'] = 'Kursai, atitinkantys grupę {$a}, nenurodyti';
$string['courseidnotfound'] = 'Kurso ID neegzistuoja.';
$string['courseidnumbertaken'] = 'ID numeris jau yra naudojamas kitam kursui ({$a})';
$string['coursemisconf'] = 'Kursas neteisingai sukonfigūruotas';
$string['courserequestdisabled'] = 'Atsiprašome, bet kurso sukūrimo prašymą administratorius išjungė';
$string['csvcolumnduplicates'] = 'Rasti besidubliuojantys stulpeliai';
$string['csvemptyfile'] = 'CSV failas yra tuščias';
$string['csvfewcolumns'] = 'Nepakanka stulpelių, patikrinkite skyriklio nustatymą';
$string['csvfileerror'] = 'Kažkas negerai su CSV failo formatu. Patikrinkite, ar sutampa antraščių ir stulpelių skaičius ir ar teisingi skyriklis bei failo koduotė. {$a}';
$string['csvinvalidcols'] = '<b>Neteisingas CSV failas:</b> pirmoje eilutėje turi būti antraštės laukai, o failo tipas turi būti <br />Išplėstiniai laukai / kableliais atskirtos reikšmės<br />arba<br /> Išplėstiniai laukai su CAVV rezultato kodu / kableliais atskirtos reikšmės';
$string['csvinvalidcolsnum'] = 'Neteisingas CSV failas – kiekvienoje eilutėje turi būti 49 arba 70 laukų';
$string['csvloaderror'] = 'Įvyko klaida įkeliant CSV failą!';
$string['csvnodata'] = 'Neteisingas CSV failas – CSV faile yra antraštės, bet jame nėra jokių duomenų.';
$string['csvweirdcolumns'] = 'Neteisingas CSV failo formatas – stulpelių numeravimas nenuoseklus!';
$string['dbconnectionfailed'] = '<p>Klaida: nepavyko prisijungti prie duomenų bazės</p> <p>Gali būti, kad duomenų bazė yra perkrauta arba veikia ne taip, kaip reikia.</p> <p>Svetainės administratorius taip pat turėtų patikrinti, ar duomenų bazės išsami informacija teisingai nurodyta faile config.php.</p>';
$string['dbdriverproblem'] = '<p>Klaida: aptikta duomenų bazės tvarkyklės problema</p> <p>Svetainės administratorius turėtų patikrinti serverio konfigūraciją</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Aptikta rimta duomenų bazės seanso problema.<br /><br />Praneškite serverio administratoriui.';
$string['dbsessionhandlerproblem'] = 'Nepavyko nustatyti duomenų bazės seanso.<br /><br />Praneškite serverio administratoriui.';
$string['dbsessionmysqlpacketsize'] = 'Aptikta rimta seanso klaida.<br /><br />Praneškite administratoriui; greičiausiai šios problemos priežastis yra maža MySQL parametro max_allowed_packet reikšmė.';
$string['dbupdatefailed'] = 'Nepavyko atnaujinti duomenų bazės';
$string['ddldependencyerror'] = '{$a->targettype} {$a->targetname} negalima modifikuoti. Rasta priklausomybė nuo {$a->offendingtype} {$a->offendingname}';
$string['ddlexecuteerror'] = 'DDL SQL vykdymo klaida';
$string['ddlfieldalreadyexists'] = 'Laukas {$a} jau yra';
$string['ddlfieldnotexist'] = 'Lauko {$a->fieldname} nėra lentelėje {$a->tablename}';
$string['ddltablealreadyexists'] = 'Lentelė {$a} jau yra';
$string['ddltablenotexist'] = 'Lentelės {$a} nėra';
$string['ddlunknownerror'] = 'Nežinoma DDL bibliotekos klaida';
$string['ddlxmlfileerror'] = 'Rasta XML duomenų bazės failo klaidų';
$string['ddsequenceerror'] = 'Neteisingas lentelės {$a} apibrėžimas; gali būti tik vienas automatinis stulpelis ir jis turi būti apibrėžtas kaip raktas.';
$string['destinationcmnotexit'] = 'Paskirties kursų modulio nėra';
$string['detectedbrokenplugin'] = 'Papildinys {$a} turi defektų arba yra pasenęs; atsiprašome, tęsti negalima.';
$string['dmlexceptiononinstall'] = '<p>Įvyko duomenų bazės klaida [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Klaida analizuojant SQL užklausą';
$string['dmlreadexception'] = 'Įvyko klaida nuskaitant iš duomenų bazės';
$string['dmltransactionexception'] = 'Duomenų bazės operacijos klaida';
$string['dmlwriteexception'] = 'Įvyko klaida rašant į duomenų bazę';
$string['dndmaxbytes'] = 'Failas per didelis. Didžiausias leistinas dydis yra {$a->size}.';
$string['dndread'] = 'Klaida skaitant failą';
$string['dndunkownfile'] = 'Šis failo tipas nepalaikomas';
$string['dndupload'] = 'Įkeliant failą įvyko nežinoma klaida';
$string['downgradedcore'] = 'KLAIDA!!! Kodas, kurį naudojate, yra SENESNIS už tą versiją, kurią naudojant buvo kuriamos šios duomenų bazės!';
$string['downloadedfilecheckfailed'] = 'Nepavyko patikrinti atsisiųsto failo';
$string['duplicatefieldname'] = 'Aptiktas pasikartojantis failo vardas "{$a}"';
$string['duplicatenosupport'] = '„{$a->modname}“ veikla negali būti dubliuojama, nes modulis {$a->modtype} nepalaiko atsarginės kopijos ir atkūrimo.';
$string['duplicateparaminsql'] = 'KLAIDA: dubliuojasi parametro pavadinimas užklausoje';
$string['duplicaterolename'] = 'Vaidmuo su tokiu pavadinimu jau yra!';
$string['duplicateroleshortname'] = 'Vaidmuo su tokiu trumpuoju pavadinimu jau yra!';
$string['duplicateusername'] = 'Besidubliuojantis naudotojo vardas – praleidžiamas įrašas';
$string['editedpagenotfound'] = 'Sistema negalėjo nustatyti puslapio, kuriame esate. Atnaujinkite puslapį ir bandykite dar kartą.';
$string['emailfail'] = 'Nepavyko išsiųsti / gauti laiško';
$string['encryption_decryptfailed'] = 'Iššifruoti nepavyko';
$string['encryption_encryptfailed'] = 'Šifruoti nepavyko';
$string['encryption_invalidkey'] = 'Neteisingas raktas';
$string['encryption_keyalreadyexists'] = 'Raktas jau yra';
$string['encryption_nokey'] = 'Raktas nerastas';
$string['encryption_wrongmethod'] = 'Duomenys neatitinka palaikomo šifravimo metodo';
$string['enddatebeforestartdate'] = 'Kurso baigimo data turi būti vėlesnė nei pradžios data.';
$string['error'] = 'Įvyko klaida';
$string['error_question_answers_missing_in_db'] = 'Nepavyko rasti atsakymo, atitinkančio „{$a->answer}“ klausimų_atsakymų duomenų bazės lentelėje. Tai įvyko atkuriant klausimą su ID {$a->filequestionid} atsarginės kopijos faile, kuris buvo suderintas su esamu klausimu, kurio ID {$a->dbquestionid} duomenų bazėje.';
$string['errorcleaningdirectory'] = 'Įvyko klaida valant katalogą {$a}';
$string['errorcopyingfiles'] = 'Įvyko klaida kopijuojant failus';
$string['errorcreatingdirectory'] = 'Įvyko klaida kuriant katalogą {$a}';
$string['errorcreatingfile'] = 'Įvyko klaida kuriant failą {$a}';
$string['errorcreatingrole'] = 'Įvyko klaida kuriant vaidmenį';
$string['errorfetchingrssfeed'] = 'Įvyko klaida kviečiant RSS informacijos santraukas.';
$string['erroronline'] = 'Klaida eilutėje {$a}';
$string['erroroutput'] = 'Klaidos išvestis, todėl išjungiamas automatinis peradresavimas.';
$string['errorparsingxml'] = 'Įvyko klaida analizuojant XML: {$a->errorstring} eilutėje {$a->errorline}, simbolis {$a->errorchar}';
$string['errorprocessingarchive'] = 'Apdorojant archyvo failą įvyko klaida';
$string['errorreadingfile'] = 'Įvyko klaida skaitant failą {$a}';
$string['errorsavingrequest'] = 'Įvyko klaida bandant įrašyti jūsų užklausą.';
$string['errorsettinguserpref'] = 'Įvyko klaida bandant nustatyti naudotojo nuostatą';
$string['errorunzippingfiles'] = 'Įvyko klaida bandant išskleisti failus';
$string['expiredkey'] = 'Baigėsi rakto galiojimo laikas';
$string['externalauthpassworderror'] = 'Reikalingas išorinio autentifikavimo slaptažodis';
$string['externalfilenolocation'] = 'Išorinis failas neturi vietos kelio';
$string['failtoloadblocks'] = 'Vienas ar daugiau blokų užregistruota duomenų bazėje, tačiau nė vieno iš jų nepavyko įkelti!';
$string['fieldrequired'] = '{$a} yra būtinas laukas';
$string['fileexists'] = 'Failas yra';
$string['filemismatch'] = 'Neatitinka nepagrindinio failo vardas. Failas {$a->current} turėtų būti {$a->file}.';
$string['filenotfound'] = 'Atsiprašome, užklausto failo rasti nepavyko';
$string['filenotreadable'] = 'Failas nėra skaitomo formato';
$string['filterdoesnothavelocalconfig'] = 'Filtras {$a} neleidžia vietinės konfigūracijos.';
$string['filternotactive'] = 'Filtras {$a} šiuo metu neaktyvus';
$string['filternotenabled'] = 'Filtras neįjungtas!';
$string['filternotinstalled'] = 'Filtras {$a} neįdiegtas';
$string['forumblockingtoomanyposts'] = 'Viršijote nustatytą ribą, kiek galima skelbti šiame forume';
$string['functionalityremoved'] = 'Bandote pasiekti pašalintą funkciją.';
$string['generalexceptionmessage'] = 'Išimtis – {$a}';
$string['gradecantregrade'] = 'Įvyko klaida įvertinimo skaičiavimo metu: {$a}';
$string['gradepubdisable'] = 'Įvertinimo publikavimas išjungtas';
$string['gradesneedregrading'] = 'Kurso įvertinimus reikia perskaičiuoti';
$string['groupalready'] = 'Naudotojas jau priklauso grupei {$a}';
$string['groupexistforcourse'] = 'Grupė {$a} jau yra šiame kurse';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: šio kurso grupė „{$a->name}“, kurios ID numeris yra „{$a->idnumber}“, jau yra';
$string['grouphasidnumber'] = 'Grupė „{$a}“ turi ID numerį ir galėjo būti automatiškai sukurta išorinės sistemos. Neturite leidimo pašalinti šios grupės.';
$string['groupinghasidnumber'] = 'Grupavimas „{$a}“ turi ID numerį ir galėjo būti automatiškai sukurtas išorinės sistemos. Neturite leidimo pašalinti šio grupavimo.';
$string['groupingnotaddederror'] = 'Grupavimas "{$a}" nepridėtas';
$string['groupnotaddederror'] = 'Grupė {$a} neįtraukta';
$string['groupnotaddedtogroupingerror'] = 'Grupė  "{$a->groupname}" nėra įtraukta į grupavimą "{$a->groupingname}"';
$string['groupunknown'] = 'Grupė {$a} nesusieta su nurodytais kursais';
$string['groupusernotmember'] = 'Naudotojas nėra šios grupės narys.';
$string['guestcantaccessprofiles'] = 'Svečiai negali pasiekti naudotojo profilio. Prisijunkite su pilna naudotojo paskyra, kad tęsti.';
$string['guestnocomment'] = 'Svečiams neleidžiama skelbti komentarų!';
$string['guestnoeditprofile'] = 'Svečias negali redaguoti savo profilio';
$string['guestnoeditprofileother'] = 'Svečio profilis negali būti redaguojamas';
$string['guestnorate'] = 'Svečiams neleidžiama vertinti įrašų';
$string['guestsarenotallowed'] = 'Svečiui neleidžiama to daryti';
$string['hackdetected'] = 'Aptikta programišiaus ataka!';
$string['hashpoolproblem'] = 'Neteisingas telkinio failo turinys {$a}.';
$string['headersent'] = 'Antraštės jau išsiųstos';
$string['idnumbertaken'] = 'ID numeris jau naudojamas kitiems kursams';
$string['idnumbertoolong'] = 'Per ilgas ID numeris';
$string['importformatnotimplement'] = 'Atsiprašome, šio formato importavimo galimybė dar neįdiegta!';
$string['incorrectext'] = 'Failas turi neteisingą plėtinį';
$string['inplaceeditableerror'] = 'Klaida kreipiantis į atnaujinimo procesorių';
$string['installproblem'] = 'Dažniausiai neįmanoma atkurti iš klaidų atsiradusių instaliuojant, jums gali reikėti sukurti naują duomenų bazę ar naudoti kitą duomenų bazės priešdėlį jei norite vėl pabandyti instaliuoti.';
$string['internalauthpassworderror'] = 'Trūksta vidinės autentifikacijos slaptažodžio arba neatitinka reikalavimų slaptažodžiui';
$string['invalidaccess'] = 'Į šį puslapį įeita netinkamai';
$string['invalidaccessparameter'] = 'Klaidingas prieigos parametras';
$string['invalidaction'] = 'Klaidingas veiksmo parametras';
$string['invalidactivityid'] = 'Klaidingas veiklos ID';
$string['invalidadminsettingname'] = 'Klaidingas administratoriaus parametras ({$a})';
$string['invalidargorconf'] = 'Nepateikta galiojančių argumentų arba neteisingai sukonfigūruotas serveris';
$string['invalidarguments'] = 'Nepateikta galiojančių argumentų';
$string['invalidblockinstance'] = 'Klaidingas bloko egzempliorius, skirtas {$a}';
$string['invalidbulkenrolop'] = 'Pateikta netinkama masinės registracijos operacijos užklausa.';
$string['invalidcategory'] = 'Neteisinga kategorija!';
$string['invalidcategoryid'] = 'Klaidingas kategorijos ID!';
$string['invalidcomment'] = 'Neteisingas komentaras';
$string['invalidcommentarea'] = 'Klaidinga komentavimo sritis';
$string['invalidcommentid'] = 'Neteisingas komentaro ID';
$string['invalidcommentitemid'] = 'Neteisingas komentaro elemento ID';
$string['invalidcommentparam'] = 'Klaidingi komentaro parametrai';
$string['invalidcomponent'] = 'Klaidingas komponento pavadinimas';
$string['invalidconfirmdata'] = 'Neteisingi patvirtinimo duomenys';
$string['invalidcontentid'] = 'Neteisingas turinio ID';
$string['invalidcontext'] = 'Neteisingas kontekstas';
$string['invalidcountrycode'] = 'Neteisingas šalies kodas: {$a}';
$string['invalidcourse'] = 'Neteisingas kursas';
$string['invalidcourseformat'] = 'Neteisingas kurso formatas';
$string['invalidcourseid'] = 'Bandote panaudoti neteisingą kurso ID: ({$a})';
$string['invalidcourselevel'] = 'Neteisingas konteksto lygis';
$string['invalidcoursemodule'] = 'Neteisingas kurso modulio ID';
$string['invalidcoursemoduleid'] = 'Netinkamas kurso modulio ID: {$a}';
$string['invalidcoursenameshort'] = 'Neteisingas trumpasis kurso pavadinimas';
$string['invaliddata'] = 'Pateikti neteisingi duomenys';
$string['invaliddatarootpermissions'] = 'Bandant sukurti katalogą aptikti netinkami leidimai. Norėdami gauti daugiau informacijos, įjunkite derinimą.';
$string['invaliddevicetype'] = 'Netinkamas įrenginio tipas';
$string['invalidelementid'] = 'Klaidingas elemento ID!';
$string['invalidentry'] = 'Šis įrašas netinkamas!';
$string['invalidevent'] = 'Klaidingas įvykis';
$string['invalidfieldname'] = '{$a} yra netinkamas lauko pavadinimas';
$string['invalidfiletype'] = '{$a} yra netinkamas failo tipas';
$string['invalidformatpara'] = 'Neteisingas parametro pasirinkimo formatas';
$string['invalidformdata'] = 'Neteisingi formos duomenys';
$string['invalidfunction'] = 'Neteisinga funkcija';
$string['invalidgradeitemid'] = 'Neteisingas įvertinimo elemento ID';
$string['invalidgroupid'] = 'Nurodytas klaidingas grupės ID';
$string['invalidipformat'] = 'Klaidingas IP adreso formatas';
$string['invaliditemid'] = 'Klaidingas elemento ID';
$string['invalidkey'] = 'Neteisingas raktas';
$string['invalidlanguagecode'] = 'Neteisingas kalbos kodas: {$a}';
$string['invalidlegacy'] = 'Neteisingas apibrėžimas, apibūdinantis senstelėjusio vaidmens tipą: {$a}';
$string['invalidmd5'] = 'Kintamojo patikra nepavyko – bandykite dar kartą';
$string['invalidmode'] = 'Klaidingas režimas ({$a})';
$string['invalidmodule'] = 'Klaidingas modulis';
$string['invalidmoduleid'] = 'Klaidingas modulio ID: {$a}';
$string['invalidmodulename'] = 'Klaidingas modulio pavadinimas: {$a}';
$string['invalidnum'] = 'Klaidinga skaitinė reikšmė';
$string['invalidnumkey'] = '$conditions masyve negali būti skaitinių raktų, pataisykite kodą!';
$string['invalidoutcome'] = 'Klaidingas rezultato ID';
$string['invalidpagesize'] = 'Neleistinas puslapio dydis';
$string['invalidpasswordpolicy'] = 'Neatitinka slaptažodžio strategijos';
$string['invalidpaymentmethod'] = 'Neleistinas mokėjimo būdas: {$a}';
$string['invalidpersistenterror'] = 'Klaida: {$a}';
$string['invalidqueryparam'] = 'KLAIDA: neteisingas užklausos parametrų skaičius. Tikėtasi {$a->expected}, gauta {$a->actual}.';
$string['invalidratingarea'] = 'Klaidinga vertinimo sritis';
$string['invalidrecord'] = 'Nepavyko rasti duomenų įrašo duomenų bazės lentelėje {$a}.';
$string['invalidrecordunknown'] = 'Nepavyko rasti duomenų įrašo duomenų bazėje.';
$string['invalidrequest'] = 'Klaidinga užklausa';
$string['invalidrole'] = 'Klaidingas vaidmuo';
$string['invalidroleid'] = 'Klaidingas vaidmens ID';
$string['invalidscaleid'] = 'Neteisingas skalės ID';
$string['invalidsection'] = 'Kursų modulio įraše yra klaidinga dalis';
$string['invalidsesskey'] = 'Greičiausiai baigėsi jūsų sesijai skirtasis laikas. Prašome prisijungti dar kartą.';
$string['invalidshortname'] = 'Netinkamas trumpo kurso pavadinimas';
$string['invalidsourcefield'] = 'Netinkamas juodraščio failo šaltinio laukas';
$string['invalidstatedetected'] = 'Kažkas blogai: {$a}. Įprastomis sąlygomis taip neturėtų nutikti.';
$string['invalidurl'] = 'Klaidingas URL';
$string['invaliduser'] = 'Klaidingas naudotojas';
$string['invaliduserdata'] = 'Netinkami naudotojo duomenys: {$a}';
$string['invaliduserfield'] = 'Netinkamas naudotojo ardas: {$a}';
$string['invaliduserid'] = 'Neteisingas naudotojo ID';
$string['invalidusername'] = 'Naudotojo varde yra neleistinų simbolių';
$string['invalidusernameblank'] = 'Naudotojo vardo laukas negali būti tuščias';
$string['invalidxmlfile'] = '{$a} yra netinkamas XML failas';
$string['iplookupfailed'] = 'Negalima rasti geografinės informacijos apie šį IP adresą {$a}';
$string['iplookupprivate'] = 'Negalima rodyti paruoštos privataus IP adreso reikšmės';
$string['ipmismatch'] = 'Kliento IP adreso neatitiktis';
$string['listcantmovedown'] = 'Nepavyko perkelti elemento žemyn, nes jis yra paskutinis iš lygiaverčių elementų.';
$string['listcantmoveleft'] = 'Nepavyko perkelti elemento kairėn, nes jis neturi pirminio elemento';
$string['listcantmoveright'] = 'Nepavyko perkelti elemento dešinėn, nes nėra kito elemento, kurio antriniu elementu jis galėtų būti. Perkelkite jį žemiau kito elemento, tada galėsite perkelti jį dešinėn.';
$string['listcantmoveup'] = 'Nepavyko perkelti elemento aukštyn, nes jis yra pirmasis iš lygiaverčių.';
$string['listnochildren'] = 'Nerasta elemento antrinių elementų';
$string['listnoitem'] = 'Elementas nerastas';
$string['listnopeers'] = 'Nerasta elementui lygiaverčių elementų';
$string['listupdatefail'] = 'Nepavyko DB operacija redaguoti sąrašo hierarchiją';
$string['logfilenotavailable'] = 'Žurnalai nepasiekiami';
$string['loginasnoenrol'] = 'Negalite naudotis įregistravimo ir išregistravimo funkcijomis kursų seanse Prisijungti kaip';
$string['loginasonecourse'] = 'Negalite įvesti šių kursų.<br /> Turite nutraukti seansą Prisijungti kaip prieš įeidami į bet kuriuos kitus kursus.';
$string['maxareabytes'] = 'Failas yra didesnis nei šioje srityje likusi erdvė.';
$string['maxbytesfile'] = 'Failas {$a->file} yra per didelis. Didžiausias dydis, kurį galite įkelti, yra {$a->size}.';
$string['maxdraftitemids'] = 'Įkėlus daug failų, failų įkėlimas laikinai apribotas. Palaukite ir bandykite dar kartą.';
$string['messageundeliveredbynotificationsettings'] = 'Pranešimo nepavyko išsiųsti, nes svetainės administratorius išjungė asmeninius pranešimus tarp naudotojų (pranešimų nustatymuose).';
$string['messagingdisable'] = 'Šioje svetainėje susirašinėjimas išjungtas';
$string['mimetexisnotexist'] = 'Jūsų sistema nesukonfigūruota paleisti mimeTeX. Turite gauti C šaltinį iš <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>, jį sukompiliuoti ir įdėti vykdomąjį failą į savo moodle/filter/tex/ katalogą.';
$string['mimetexnotexecutable'] = 'Pasirinktinio „mimetex“ negalima vykdyti!';
$string['missing_moodle_backup_xml_file'] = 'Atsarginei kopijai trūksta XML failo: {$a}';
$string['missingcategoryrole'] = 'Nepavyko priskirti vaidmens naudotojui: trūksta kategorijos vaidmens.';
$string['missingfield'] = 'Trūksta lauko {$a}';
$string['missingkeyinsql'] = 'KLAIDA: užklausoje trūksta parametro {$a}';
$string['missingparam'] = 'Trūko būtino parametro ({$a})';
$string['missingparameter'] = 'Trūksta parametro';
$string['missingrequiredfield'] = 'Trūksta būtino lauko';
$string['missinguseranditemid'] = 'Trūksta naudotojo ID ir elemento ID';
$string['missingvarname'] = 'Trūksta kintamojo pavadinimo, kurį būtina nurodyti!';
$string['mixedtypesqlparam'] = 'KLAIDA: supainioti SQL užklausos parametrų tipai!';
$string['mnetdisable'] = 'MNET išjungta';
$string['mnetlocal'] = 'Nuotoliniai MNET naudotojai negali prisijungti per vietinę sistemą';
$string['moduledisable'] = 'Šio modulio ({$a}) naudojimo šiuose kursuose galimybė buvo išjungta';
$string['moduledoesnotexist'] = 'Tokio modulio nėra';
$string['moduleinstancedoesnotexist'] = 'Šio modulio egzemplioriaus nėra';
$string['modulemissingcode'] = 'Modulyje {$a} trūksta kodo, reikalingo norint atlikti šią funkciją';
$string['moodlenet:invalidshareformat'] = 'Neteisingas „MoodleNet“ bendrinimo formatas';
$string['moodlenet:usernotconfigured'] = 'Neturite leidimo dalytis turiniu MoodleNet arba jūsų paskyra neteisingai sukonfigūruota.';
$string['movecatcontentstoroot'] = 'Kategorijos turinio perkėlimas į šaknį neleidžiamas. Turite perkelti turinį į esamą kategoriją!';
$string['movecatcontentstoselected'] = 'Kai kurios kategorijos turinio negalima perkelti į pasirinktą kategoriją.';
$string['movecategorynotpossible'] = 'Jūs negalite perkelti kategorijos \'{$a}\' į pažymėtą kategoriją.';
$string['movecategoryownparent'] = 'Kategorijos „{$a}“ negalite padaryti kaip pirminės kategorijos.';
$string['movecategoryparentconflict'] = 'Kategorijos „{$a}“ negalite padaryti vienos iš subkategorijų subkategorija.';
$string['mssqlrcsmodemissing'] = 'Duomenų bazėje nenaudojamas numatytas READ_COMMITTED_SNAPSHOT režimas, dėl kurio gali būti gauti klaidingi rezultatai, ypač esant dideliems lygiagretumo scenarijams. Įjunkite jį. Norėdami gauti daugiau informacijos, žr. dokumentaciją <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">MSSQL diegimas, skirtas PHP</a>.';
$string['multiplerecordsfound'] = 'Rasta keletas įrašų, tikėtasi rasti tik vieną.';
$string['multiplerestorenotallow'] = 'Neleidžiama atkurti kelių elementų vienu metu!';
$string['mustbeloggedin'] = 'Turite prisijungti, kad galėtumėte tai atlikti';
$string['mustbeteacher'] = 'Turite būti dėstytojas, kad galėtumėte žiūrėti šį puslapį';
$string['myisamproblem'] = 'Duomenų bazės lentelės naudoja „MyISAM“ duomenų bazės variklį, rekomenduojama naudoti su ACID suderinamą variklį, palaikantį visas operacijas, tokį kaip „InnoDB“.';
$string['needcopy'] = 'Pirmiausia turite ką nors nukopijuoti!';
$string['needcoursecategroyid'] = 'Turi būti nurodytas kursų ID arba kategorija';
$string['needphpext'] = 'Turite įtraukti {$a} palaikymą į PHP įdiegtį';
$string['noadmins'] = 'Nėra administratorių!';
$string['noblocks'] = 'Blokų nerasta!';
$string['nocapabilitytousethisservice'] = 'Naudotojas neturi galimybės, būtinos norint naudotis šia paslauga';
$string['nocategorydelete'] = 'Kategorija {$a} negali būti panaikinta!';
$string['nocontext'] = 'Atsiprašome, tačiau šis kursas nėra leistinas kontekstas';
$string['nodata'] = 'Nėra duomenų';
$string['noexistingcategory'] = 'Nėra kategorijos';
$string['nofile'] = 'Nenurodytas failas';
$string['nofiltersenabled'] = 'Nė vienas filtras neįjungtas.';
$string['nofolder'] = 'Nėra užklausto katalogo';
$string['noformdesc'] = 'Nerastas „formslib“ formos aprašo failas, naudotinas šiai veiklai.';
$string['noguest'] = 'Ne svečiams!';
$string['noinstances'] = 'Šiuose kursuose nėra {$a} egzempliorių!';
$string['nologinas'] = 'Jums neleidžiama prisijungti šio naudotojo vardu';
$string['nonmeaningfulcontent'] = 'Nėra reikšminio turinio';
$string['noparticipants'] = 'Nerasta šių kursų dalyvių';
$string['noparticipatorycms'] = 'Atsiprašome, tačiau jūs neturite tokių kursų modulių, kuriuose daugiausia dalyvaujate ir apie kuriuos galėtumėme pateikti ataskaitą';
$string['nopermissions'] = 'Atsiprašome, tačiau šiuo metu jūs neturite teisės atlikti šio veiksmo ({$a}).';
$string['nopermissiontoaccesspage'] = 'Neturite leidimo pasiekti šį puslapį.';
$string['nopermissiontocomment'] = 'Negalite įtraukti komentarų';
$string['nopermissiontodelentry'] = 'Negalite ištrinti šio komentaro!';
$string['nopermissiontoeditcomment'] = 'Negalite redaguoti kitų žmonių įrašų!';
$string['nopermissiontohide'] = 'Neturite teisės slėpti!';
$string['nopermissiontoimportact'] = 'Neturite teisių, leidžiančių importuoti veiklas į šiuos kursus';
$string['nopermissiontolock'] = 'Neturite teisės užrakinti!';
$string['nopermissiontomanagegroup'] = 'Neturite teisių, leidžiančių valdyti grupes';
$string['nopermissiontorate'] = 'Elementų vertinimas pažymiais neleidžiamas!';
$string['nopermissiontoshow'] = 'Neturite teisės peržiūrėti!';
$string['nopermissiontounlock'] = 'Neturite teisės atrakinti!';
$string['nopermissiontoupdatecalendar'] = 'Atsiprašome, tačiau jūs neturite teisių, leidžiančių atnaujinti kalendoriaus įvykį.';
$string['nopermissiontoviewcalendar'] = 'Atsiprašome, bet jūs neturite leidimo peržiūrėti kalendoriaus įvykio.';
$string['nopermissiontoviewgrades'] = 'Negalima peržiūrėti įvertinimų.';
$string['nopermissiontoviewletergrade'] = 'Trūksta teisių, leidžiančių peržiūrėti raidinius įvertinimus';
$string['nopermissiontoviewpage'] = 'Jums neleidžiama žiūrėti šio puslapio';
$string['nosite'] = 'Nepavyko rasti aukščiausio lygio kursų!';
$string['nositeid'] = 'Nėra svetainės ID';
$string['nostartdatenoenddate'] = 'Kurso pabaigos data gali būti nustatyta tik tuomet, jei pradžios data taip pat nustatyta.';
$string['nostatstodisplay'] = 'Atsiprašome, nėra galimų parodyti duomenų';
$string['notallowedtoupdateprefremotely'] = 'Jums neleidžiama atnaujinti šio naudotojo nuostatų nuotoliniu būdu';
$string['notavailable'] = 'Šiuo metu nepasiekiama';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Jūs nesate šios kursų grupės narys';
$string['notownerofkey'] = 'Jūs nesate šio rakto savininkas';
$string['nousers'] = 'Tokio naudotojo nėra!';
$string['oauth1accesstoken'] = 'OAuth 1.0 klaida: negavome prieigos rakto.';
$string['oauth1requesttoken'] = 'OAuth 1.0 klaida: negavome užklausos prieigos rakto – paslaugos teikėjas gali laikinai neveikti.';
$string['oauth2refreshtokenerror'] = 'Nepavyko atnaujinti OAuth 2 prieigos rakto. HTTP būsena nuotoliniam galutiniam taškui: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Nepavyko atnaujinti vieno ar kelių išdavėjų OAuth 2 prieigos rakto. Norėdami gauti daugiau informacijos, peržiūrėkite užduoties išvestį.';
$string['oauth2upgradetokenerror'] = 'Nepavyko naujovinti OAuth 2 prieigos rakto. HTTP būsena nuotoliniam galutiniam taškui: {$a}';
$string['onlyadmins'] = 'Tik administratoriai gali tai daryti';
$string['onlyeditingteachers'] = 'Tik redaguojantys dėstytojai gali tai daryti';
$string['onlyeditown'] = 'Galite redaguoti tik savo informaciją';
$string['orderidnotfound'] = 'Užsakymo ID {$a} nerastas';
$string['pagenotexist'] = '<p>Įvyko neįprasta klaida bandant peržiūrėti puslapį, kurio nėra:</p>{$a}';
$string['pagenotexisttitle'] = '404 Klaida: Failas nerastas';
$string['pathdoesnotstartslash'] = 'Nepateikta leistinų argumentų, kelias neprasideda pasviruoju brūkšniu!';
$string['pleasereport'] = 'Jei turite laiko, pateikite mums informacijos, ką bandėte atlikti tuo metu, kai įvyko klaida:';
$string['pluginrequirementsnotmet'] = 'Papildinio {$a->pluginname} ({$a->pluginversion}) nepavyko įdiegti. Jam reikia naujesnės „Moodle“ versijos (dabar jūs naudojatės {$a->currentmoodle}, reikia {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Papildinys „{$a->pluginname}“ {$a->pluginversion} nepalaiko šios Moodle versijos {$a->moodleversion}. Ieškokite papildinio informacijos, kad rastumėte palaikomas versijas.';
$string['prefixcannotbeempty'] = '<p>Klaida: duomenų bazės lentelės priešvardis negali būti tuščias ({$a})</p> <p>Svetainės administratorius turi išspręsti šią problemą.</p>';
$string['prefixtoolong'] = '<p>Klaida: duomenų bazės lentelės priešvardis yra per ilgas ({$a->dbfamily})</p> <p>Svetainės administratorius turi išspręsti šią problemą. Maksimalus lentelės priešvardžio, naudojamo {$a->dbfamily}, ilgis yra {$a->maxlength} simboliai (-ių).</p>';
$string['privatefilesupload'] = 'Įkėlimas tiesiai į naudotojo asmeninių failų sritį nebepalaikomas. Įkelkite į juodraščio sritį ir perkelkite failus naudodami core_user::add_user_private_files';
$string['processingstops'] = 'Apdorojimo procesas sustojo čia. Likę įrašai ignoruoti.';
$string['protected_cc_not_supported'] = 'Apsaugoti kasetė nepalaikoma';
$string['querystringcannotbeempty'] = 'Užklausos eilutė negali būti tuščia.';
$string['redirecterrordetected'] = 'Aptiktas nepalaikomas peradresavimas, scenarijaus vykdymas nutrauktas';
$string['refoundto'] = 'Gali būti grąžinta {$a}';
$string['refoundtoorigi'] = 'Grąžinta pradinė suma: {$a}';
$string['registrationdisabled'] = 'Registracija šioje svetainėje išjungta';
$string['remotedownloaderror'] = 'Nepavyko į serverį atsisiųsti komponento, patikrinkite tarpinio serverio parametrus, labai rekomenduojama naudoti PHP cURL plėtinį.<br /><br />Turite rankiniu būdu atsisiųsti <a href="{$a->url}">{$a->url}</a> failą, nukopijuoti jį į {$a->dest} serveryje ir ten jį išskleisti.';
$string['remotedownloadnotallowed'] = 'Neleidžiama atsisiųsti komponentų į serverį (allow_url_fopen išjungta).<br /><br />Turite rankiniu būdu atsisiųsti <a href="{$a->url}">{$a->url}</a> failą, nukopijuoti jį į {$a->dest} serveryje ir ten jį išskleisti.';
$string['reportnotavailable'] = 'Šį ataskaitos tipą galima naudoti tik svetainės kursams';
$string['requirecorrectaccess'] = 'Neteisingas url arba port\'as';
$string['requireloginerror'] = 'Nėra prieigos prie kursų arba prie veiklos.';
$string['restore_path_element_missingmethod'] = 'Atkūrimo metodas {$a} nerasta. Jis turi būti nustatytas administratoriaus.';
$string['restore_path_element_noobject'] = 'Atkuriamas objektas {$a} nėra objektas.';
$string['restorechecksumfailed'] = 'Kilo bėdų dėl atkurtos informacijos, saugomos jūsų seanse. Patikrinkite PHP atminties / DB paketo dydžio ribas. Atkūrimas sustabdytas.';
$string['restrictedcontextexception'] = 'Atsiprašome, tačiau išorinės funkcijos vykdymas pažeidžia konteksto apribojimą.';
$string['restricteduser'] = 'Atsiprašome, tačiau šiai paskyrai {$a} uždrausta tą daryti';
$string['reverseproxyabused'] = 'Įjungtas atvirkštinis tarpinis serveris, todėl serverio negalima pasiekti tiesiogiai.<br />Susisiekite su serverio administratoriumi.';
$string['rpcerror'] = 'Oi! Nepavyko MNET ryšys! Čia klaidos pranešimas, kurį reikia perduoti administratoriui: {$a}';
$string['scheduledbackupsdisabled'] = 'Suplanuotą atsarginį kopijavimą išjungė serverio administratorius';
$string['secretalreadyused'] = 'Slaptažodžio keitimo patvirtinimo saitas jau panaudotas, slaptažodis nebuvo pakeistas';
$string['sectionnotexist'] = 'Tokios dalies nėra';
$string['sendmessage'] = 'Siųsti žinutę';
$string['sendmessagesent'] = 'Dėkojame už atsiliepimą apie:<br>{$a}';
$string['serverconnection'] = 'Klaida jungiantis į serverį';
$string['servicedonotexist'] = 'Tokios paslaugos nėra';
$string['sessioncannotobtainlock'] = '<p>Nepavyko užrakinti seanso ID {$a->id} per {$a->acquiretimeout}.</p>
<p>Tikėtina, kad kitame naršyklės skirtuke vis dar veikia kitas puslapis ({$a->whohaslock}) arba jis neatleido užrakto dėl klaidos.</p>
<p>Galite palaukti, kol baigsis sesijos užrakto skirtasis laikas ({$a->lockexpire}) arba galite iš naujo paleisti naršyklės seansą. Jei ši klaida išlieka, praneškite serverio administratoriui.</p>';
$string['sessioncookiesdisable'] = 'Neteisingai naudojama require_key_login() – seanso slapukai turi būti išjungti!';
$string['sessiondiskfull'] = 'Seanso skaidinys pilnas. Šiuo metu neįmanoma prisijungti. Prašome praneškite serverio administratoriui.';
$string['sessionerroruser'] = 'Baigėsi Jūsų sesijai skirtas laikas. Prisijunkite dar kartą.';
$string['sessionerroruser2'] = 'Aptikta serverio klaida, turinti įtakos prisijungimo sesijai. Prisijunkite dar kartą arba iš naujo paleiskite naršyklę.';
$string['sessionexpired'] = 'Sesija pasibaigė';
$string['sessionhandlerproblem'] = 'Seanso tvarkytuvas netinkamai sukonfigūruotas';
$string['sessionipnomatch'] = 'Atsiprašome, tačiau atrodo, kad jūsų IP numeris ne toks pat, koks buvo pirmąkart jums prisijungus. Ši saugos funkcija saugo nuo įsilaužėlių, vagiančių jūsų tapatybę, kol esate prisijungęs svetainėje. Įprasti naudotojai neturėtų matyti šios žinutės – kreipkitės pagalbos į svetainės administratorių.';
$string['sessionipnomatch2'] = 'Atsiprašome, tačiau atrodo, kad jūsų IP numeris ne toks pat, koks buvo pirmąkart jums prisijungus. Ši saugos funkcija saugo nuo įsilaužėlių, vagiančių jūsų tapatybę, kol esate prisijungęs svetainėje. Šią klaidą galite matyti, jei naudojatės belaidžiais tinklais arba jei naudojatės tarptinkliniais ryšiais. Kreipkitės pagalbos į svetainės administratorių.<br /><br />Norėdami tęsti, paspauskite klavišą F5, kad atnaujintumėte šį puslapį.';
$string['sessionwaiterr'] = 'Baigėsi laikas skirtas laukti sesijos užrakinimo <br /> Palaukite kol jūsų dabartinės užklausos baigs darbą ir pabandykite vėliau.';
$string['shortnametaken'] = 'Trumpasis pavadinimas jau naudojamas kitiems kursams';
$string['sitepolicynotagreed'] = 'Svetainės politika nepriimta: <a href="{$a}"> Spustelėkite čia, jei norite atidaryti svetainės politiką. </a>';
$string['socksnotsupported'] = 'SOCKS5 tarpinis serveris nepalaikomas PHP4';
$string['spellcheckernotconf'] = 'Rašybos tikrintuvas nesukonfigūruotas';
$string['sslonlyaccess'] = 'Saugumo sumetimais prisijungti leidžiama tik per „https“, atsiprašome.';
$string['statscatchupmode'] = 'Statistika šiuo metu veikia pagavos režimu. Jau apdorota {$a->daysdone} d., o laukia {$a->dayspending} d. Patikra tuoj veiks toliau!';
$string['statsdisable'] = 'Statistika neįjungta';
$string['statsnodata'] = 'Nėra duomenų, susijusių su šiuo kursų ir laikotarpio deriniu';
$string['storedfilecannotcreatefile'] = 'Nepavyko sukurti vietinio failų telkinio failo. Patikrinkite „dataroot“ ir laisvos vietos diske leidimus.';
$string['storedfilecannotcreatefiledirs'] = 'Nepavyko sukurti vietinių failų telkinio katalogų. Patikrinkite leidimus „dataroot“.';
$string['storedfilecannotread'] = 'Negalima nuskaityti failo. Arba failo nėra, arba yra leidimo problema.';
$string['storedfilecannotreadfile'] = 'Nepavyko nuskaityti failo „{$a}“. Arba failo nėra, arba yra leidimo problema.';
$string['storedfilenotcreated'] = 'Nepavyko sukurti failo {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Nežinoma išimtis, susijusi su vietiniais failais ({$a})';
$string['tagdisabled'] = 'Žymės išjungtos!';
$string['tagnotfound'] = 'Nurodytos žymės nepavyko rasti duomenų bazėje';
$string['targetdatabasenotempty'] = 'Tikslinė duomenų bazė nėra tuščia. Perdavimas nutrauktas saugumo sumetimais.';
$string['textconditionsnotallowed'] = 'Neleidžiama lyginti teksto stulpelių sąlygų. Užklausoje naudokite sql_compare_text().';
$string['themenotinstall'] = 'Ši tema neįdiegta!';
$string['tokengenerationfailed'] = 'Negalima sugeneruoti naujo atpažinimo ženklo.';
$string['transactionvoid'] = 'Operacijos negalima anuliuoti, nes ji jau anuliuota';
$string['unenrolerror'] = 'Įvyko klaida bandant išregistruoti šį asmenį';
$string['unicodeupgradeerror'] = 'Atsiprašome, tačiau jūsų duomenų bazė vis dar nėra „Unicode“ formato, o ši „Moodle“ versija negali perkelti jūsų duomenų bazės į „Unicode“. Pirmiausia atnaujinkite versiją į „Moodle 1.7.x“ ir atlikite perkėlimą į „Unicode“ naudodamiesi administratoriaus puslapiu. Tai padarę turėtumėte galėti perkelti į „Moodle“ {$a}.';
$string['unknowaction'] = 'Nežinomas veiksmas!';
$string['unknowcategory'] = 'Nežinoma kategorija!';
$string['unknowcontext'] = 'Nežinomas kontekstas ({$a}) – get_child_contexts!';
$string['unknowformat'] = 'Nežinomas formatas ({$a})';
$string['unknownbackupexporterror'] = 'Įvyko nežinoma klaida rengiant informaciją importuoti';
$string['unknownblockregion'] = 'Bloko srities {$a} neatpažįsta šiame puslapyje.';
$string['unknowncategory'] = 'Nežinoma kategorija su kategorijos ID numeriu „{$a}“';
$string['unknowncontext'] = 'Tai nežinomas kontekstas.';
$string['unknowncourse'] = 'Nežinomas kursas pavadinimu „{$a}“';
$string['unknowncourseidnumber'] = 'Nežinomas kursų ID {$a}';
$string['unknowncourserequest'] = 'Nežinomas kurso sukūrimo prašymas';
$string['unknowncoursesection'] = 'Nežinoma kurso tema kurse „{$a}“';
$string['unknownevent'] = 'Nežinomas įvykis';
$string['unknownfiletype'] = 'Nežinomo filtro tipo klaida';
$string['unknowngroup'] = 'Nežinoma grupė {$a}';
$string['unknownhelp'] = 'Nežinoma žinyno tema {$a}';
$string['unknownjsinrequirejs'] = 'Nepavyko rasti „JavaScript“ bibliotekos {$a}.';
$string['unknownmodulename'] = 'Nežinomas formos modulio pavadinimas';
$string['unknownrole'] = 'Nežinomas vaidmuo {$a}';
$string['unknownsortcolumn'] = 'Nežinomas rikiavimo stulpelis {$a}';
$string['unknownuseraction'] = 'Atsiprašome, nesuprantamas naudotojo veiksmas';
$string['unknownuserselector'] = 'Nežinomas naudotojo išrinkiklis';
$string['unknoworder'] = 'Nežinomas rikiavimas eilės tvarka';
$string['unknowparamtype'] = 'Nežinomas parametro tipas: {$a}';
$string['unknowquestiontype'] = 'Nepalaikomas klausimo tipas {$a}';
$string['unknowuploadaction'] = 'Klaida: nežinomas įkėlimo veiksmas ({$a})';
$string['unspecifycourseid'] = 'Turite nurodyti kursų ID, trumpąjį pavadinimą arba ID numerį';
$string['unsupportedevent'] = 'Nepalaikomas įvykio tipas';
$string['unsupportedstate'] = 'Nepalaikoma užbaigimo būsena';
$string['unsupportedwebserver'] = 'Žiniatinklio serverio programinė įranga ({$a}) nepalaikoma, atsiprašome.';
$string['upgraderequires19'] = 'Klaida: nauja „Moodle“ versija buvo įdiegta serveryje, deja, ankstesnės versijos plėtotė nepalaikoma.<br />Pirmiausia atnaujinkite versiją į naujausią 1.9.x leidimą. Taip pat galite sugrąžinti ankstesnę versiją iš naujo įdiegdami pradinius failus.';
$string['upgraderunning'] = 'Naujinama svetainės versija, bandykite vėliau.';
$string['urlnotdefinerss'] = 'Nenurodytas RSS informacijos santraukos URL';
$string['useradmineditadmin'] = 'Tik administratoriai gali modifikuoti kitų administratorių paskyras';
$string['useradminodelete'] = 'Administratoriaus paskyrų ištrinti negalima.';
$string['userautherror'] = 'Nežinomas autentifikavimo papildinys';
$string['userauthunsupported'] = 'Autentifikavimo papildinys čia nepalaikomas';
$string['useremailduplicate'] = 'Besidubliuojantis adresas';
$string['userisfilteredout'] = 'Šis naudotojas neatitinka filtrų ir lentelės nuostatų!';
$string['usermustbemnet'] = 'Naudotojai MNET prieigos kontroliniame sąraše turi būti nuotoliniai MNET naudotojai';
$string['usernamelowercase'] = 'Naudotojo vardas turi būti rašomas mažosiomis raidėmis';
$string['usernotaddederror'] = 'Naudotojas neįtrauktas – klaida';
$string['usernotaddedregistered'] = 'Naudotojas neįtrauktas – jau užregistruotas';
$string['usernotavailable'] = 'Šio naudotojo išsami informacija jums neprieinama';
$string['usernotdeletedadmin'] = 'Naudotojas neištrintas, nes administratoriaus paskyrų ištrinti negalima.';
$string['usernotdeleteddeleted'] = 'Šis naudotojas jau buvo ištrintas.';
$string['usernotdeletederror'] = 'Naudotojas nepanaikintas – klaida';
$string['usernotdeletedmissing'] = 'Naudotojas nepanaikintas – nepavyko rasti naudotojo vardo';
$string['usernotdeletedoff'] = 'Naudotojas nepanaikintas – panaikinti neleidžiama';
$string['usernotfullysetup'] = 'Naudotojas nėra visiškai nustatytas';
$string['usernotincourse'] = 'Šio naudotojo nėra šiuose kursuose!';
$string['usernotrenamedadmin'] = 'Negalima pervardyti administratorių paskyrų';
$string['usernotrenamedexists'] = 'Naudotojas nepervardytas – nurodytas naujas naudotojo vardas jau naudojamas';
$string['usernotrenamedmissing'] = 'Naudotojas nepervardytas – nepavyko rasti senojo naudotojo vardo';
$string['usernotrenamedoff'] = 'Naudotojas nepervardytas – pervardyti neleidžiama';
$string['usernotupdatedadmin'] = 'Negalima atnaujinti administratorių paskyrų';
$string['usernotupdatederror'] = 'Naudotojas neatnaujintas – klaida';
$string['usernotupdatednotexists'] = 'Naudotojas neatnaujintas – tokio nėra';
$string['userquotalimit'] = 'Pasiekėte failo kvotos limitą.';
$string['userselectortoomany'] = 'user_selector rado daugiau negu vieną pasirinktą naudotoją, nors kelių variantų pasirinkimas išjungtas.';
$string['verifyagedigitalconsentnotpossible'] = 'Atsiprašome, skaitmeninis amžiaus sutikimo patvirtinimas šiuo metu negalimas.';
$string['wrongcall'] = 'Šis scenarijus iškviestas neteisingai';
$string['wrongcontextid'] = 'Konteksto ID buvo neteisingas (nepavyksta jo rasti)';
$string['wrongdestpath'] = 'Neteisingas paskirties kelias';
$string['wrongroleid'] = 'Neteisingas vaidmens ID!';
$string['wrongsourcebase'] = 'Neteisingas šaltinio URL pagrindas';
$string['wrongusernamepassword'] = 'Neteisingas naudotojas / slaptažodis';
$string['wrongzipfilename'] = 'Neteisingas ZIP failo vardas';
$string['wscouldnotcreateecoursenopermission'] = 'WS – nepavyko sukurti kursų – trūksta teisių';
$string['wwwrootmismatch'] = 'Aptikta neteisinga prieiga: prieiga prie šio serverio galima tik per {$a} adresą, atsiprašome.<br />Praneškite serverio administratoriui.';
$string['wwwrootslash'] = 'Aptiktas neteisingas $CFG->wwwroot faile config.php: jis neturi baigtis pasviruoju brūkšniu.<br />Praneškite serverio administratoriui.';
$string['xmldberror'] = 'XMLDB klaida!';
$string['youcannotdeletecategory'] = 'Negalite panaikinti kategorijos {$a}, nes jūs neturite teisės panaikinti turinio ar perkelti jo kur nors kitur.';
