<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'lt', version '4.2'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Veiksmai vertintojo sąsajai';
$string['actionsforpost'] = 'Veiksmai įrašui';
$string['activitydate:due'] = 'Pateikti iki:';
$string['activityoverview'] = 'Yra naujų forumo pranešimų';
$string['addanewdiscussion'] = 'Įtraukti diskusijų temą';
$string['addanewquestion'] = 'Įtraukti naują klausimą';
$string['addanewtopic'] = 'Įtraukti naują temą';
$string['addreply'] = 'Pridėti atsakymą';
$string['addtofavourites'] = 'Pažymėti šią diskusiją';
$string['advancedsearch'] = 'Išplėstinė paieška';
$string['alldiscussions'] = 'Visos diskusijos';
$string['allforums'] = 'Visi forumai';
$string['allowdiscussions'] = 'Ar {$a} gali skelbti šiame forume?';
$string['allowsallsubscribe'] = 'Šiame forume visi gali pasirinkti, ar prenumeruoti, ar ne';
$string['allowsdiscussions'] = 'Šiame forume vienam asmeniu leidžiama pradėti vieną diskusijų temą';
$string['allsubscribe'] = 'Prenumeruoti visus forumus';
$string['allunsubscribe'] = 'Atsisakyti visų forumų prenumeratos';
$string['allusers'] = 'Visi dalyviai';
$string['alreadyfirstpost'] = 'Tai jau yra pirmasis diskusijos skelbimas';
$string['anyfile'] = 'Bet kuris failas';
$string['areaattachment'] = 'Prisegti failai';
$string['areapost'] = 'Žinutės';
$string['attachment'] = 'Priedas';
$string['attachment_help'] = 'Galite pasirinktinai pridėti vieną arba kelis failus prie forumo skelbimo. Jei pridėsite vaizdą, jis bus rodomas po žinutės.';
$string['attachmentname'] = 'Priedas {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Negalite eksportuoti priedų be skelbimo ID';
$string['attachments'] = 'Priedai';
$string['attachmentswordcount'] = 'Priedų ir žodžių skaičius';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} atsakyta privačiai {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} atsakyta {$a->author}';
$string['availability'] = 'Prieinamumas';
$string['blockafter'] = 'Skelbimo blokavimo slenkstis';
$string['blockafter_help'] = 'Šis parametras nurodo maksimalų skelbimų, kuriuos naudotojas gali paskelbti per nurodytą laikotarpį, skaičių. Naudotojams, turintiems galimybę mod/forum:postwithoutthrottling, skelbimų limitai netaikomi.';
$string['blockperiod'] = 'Blokavimo laikotarpis';
$string['blockperiod_help'] = 'Besimokantieji gali būti užblokuoti neleidžiant jiems per nurodytą laikotarpį skelbti daugiau skelbimų, nei nurodyta. Naudotojams, turintiems galimybę mod/forum:postwithoutthrottling, skelbimų limitai netaikomi.';
$string['blockperioddisabled'] = 'Neblokuoti';
$string['blogforum'] = 'Standartinis forumas, rodomas į tinklaraštį panašiu formatu';
$string['bynameondate'] = '{$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Naudotojo diskusijų sekimo būsena';
$string['calendardue'] = '{$a} atlikta';
$string['cancelreply'] = 'Atšaukti atsakymą';
$string['cannotadd'] = 'Nepavyko įtraukti šio forumo diskusijos';
$string['cannotadddiscussion'] = 'Norint įtraukti diskusijų į šį forumą, būtina grupės narystė.';
$string['cannotadddiscussionall'] = 'Neturite teisės įtraukti naujos diskusijų temos, skirtos visiems dalyviams.';
$string['cannotadddiscussiongroup'] = 'Negalite įtraukti diskusijos įrašo, kadangi nepriklausote reikiamai grupei';
$string['cannotaddsubscriber'] = 'Nepavyko į šį forumą įtraukti prenumeruotojo, turinčio ID {$a}!';
$string['cannotaddteacherforumto'] = 'Nepavyko įtraukti konvertuoto dėstytojo forumo egzemplioriaus į kursų dalį 0';
$string['cannotcreatediscussion'] = 'Nepavyko sukurti naujos diskusijos';
$string['cannotcreateinstanceforteacher'] = 'Nepavyko sukurti naujo kursų modulio egzemplioriaus, skirto mokytojų forumui';
$string['cannotdeletepost'] = 'Negalite panaikinti šio įrašo!';
$string['cannoteditposts'] = 'Negalite redaguoti kitų žmonių įrašų!';
$string['cannotexportforum'] = 'Negalite eksportuoti šios diskusijos';
$string['cannotfavourite'] = 'Atsiprašome, bet jūs neturite teisės pažymėti diskusijas.';
$string['cannotfinddiscussion'] = 'Nepavyko rasti šio forumo diskusijos';
$string['cannotfindfirstpost'] = 'Nepavyko rasti pirmojo šio forumo įrašo';
$string['cannotfindorcreateforum'] = 'Nepavyko rasti arba sukurti pagrindinio svetainės skelbimų forumo';
$string['cannotfindparentpost'] = 'Nepavyko rasti skelbimo {$a} pirminio skelbimo';
$string['cannotmovefromsingleforum'] = 'Nepavyko perkelti diskusijos iš paprasto vienos diskusijos forumo';
$string['cannotmovenotvisible'] = 'Forumas nematomas';
$string['cannotmovetonotexist'] = 'Negalite pereiti į tą forumą – jo nėra!';
$string['cannotmovetonotfound'] = 'Tikslinis forumas šiuose kursuose nerastas.';
$string['cannotmovetosingleforum'] = 'Nepavyko perkelti diskusijos į paprastą vientisą diskusijų forumą';
$string['cannotpindiscussions'] = 'Atsiprašome, bet jūs neturite teisės prisegti diskusijų.';
$string['cannotpurgecachedrss'] = 'Nepavyko išvalyti talpykloje saugomų šaltinio ir (arba) paskirties forumo (-ų) RSS informacijos santraukų – patikrinkite savo failą „permissionsforums“';
$string['cannotremovesubscriber'] = 'Nepavyko iš šio forumo pašalinti prenumeruotojo, turinčio ID {$a}!';
$string['cannotreply'] = 'Negalite atsakyti į šį įrašą';
$string['cannotsplit'] = 'Šio forumo diskusijų negalima skaidyti';
$string['cannotsubscribe'] = 'Apgailestaujame, bet norėdami prenumeruoti turite būti grupės narys.';
$string['cannottrack'] = 'Nepavyko baigti sekti šio forumo';
$string['cannotunsubscribe'] = 'Nepavyko atsisakyti šio forumo prenumeratos';
$string['cannotupdatepost'] = 'Negalite atnaujinti šio įrašo';
$string['cannotuseseperategroupsandsingletopic'] = 'Atskiros grupės negali būti naudojamos su viena paprasta diskusija.';
$string['cannotusesingletopicandseperategroups'] = 'Viena paprasta diskusija negali būti naudojama su atskiromis grupėmis.';
$string['cannotviewpostyet'] = 'Dar negalite skaityti kitų besimokančiųjų įrašų šioje diskusijoje, nes nesate patys paskelbę.';
$string['cannotviewusersposts'] = 'Nėra nei vieno skelbimo parašyto šio naudotojo  kuriuos jūs galėtumėte peržiūrėti.';
$string['cleanreadtime'] = 'Senų skelbimų žymėjimo kaip perskaitytų valanda';
$string['clicktofavourite'] = 'Jūs nepažymėjote šios diskusijos. Spustelėkite žvaigždutę, kas pažymėtumėte.';
$string['clicktolockdiscussion'] = 'Spustelėkite, jei norite užrakinti šią diskusiją';
$string['clicktosubscribe'] = 'Jūs nesate užsiprenumeravęs šios diskusijos. Spragtelėkite, kad užsiprenumeruotumėte.';
$string['clicktounfavourite'] = 'Jūs pažymėjote šią diskusiją. Spustelėkite žvaigždutę, kad nebežymetume..';
$string['clicktounlockdiscussion'] = 'Spustelėkite, jei norite atrakinti šią diskusiją';
$string['clicktounsubscribe'] = 'Jūs esate užsiprenumeravę šią diskusiją. Spragtelėkite, jei norite atsisakyti.';
$string['close'] = 'Uždaryti';
$string['closegrader'] = 'Uždaryti vertinimą';
$string['completiondetail:discussions'] = 'Pradėti diskusijas: {$a}';
$string['completiondetail:posts'] = 'Parašyti diskusijų įrašų: {$a}';
$string['completiondetail:replies'] = 'Paskelbti atsakymų: {$a}';
$string['completiondiscussions'] = 'Besimokantieji turi sukurti diskusijas:';
$string['completiondiscussionsdesc'] = 'Besimokantysis turi sukurti bent {$a} diskusiją(-as)';
$string['completiondiscussionsgroup'] = 'Reikalauti diskusijų';
$string['completiondiscussionshelp'] = 'reikalaujama diskusijos norint baigti';
$string['completionposts'] = 'Besimokantysis turi skelbti diskusijas arba atsakymus:';
$string['completionpostsdesc'] = 'Besimokantysis turi paskelbti bent {$a} diskusiją(-as) arba atsakymą(-us)';
$string['completionpostsgroup'] = 'Reikalauti įrašų';
$string['completionpostshelp'] = 'reikalaujama diskusijų arba atsakymų norint baigti';
$string['completionreplies'] = 'Besimokantysis turi skelbti atsakymus:';
$string['completionrepliesdesc'] = 'Besimokantysis turi paskelbti bent {$a} atsakymą(-us)';
$string['completionrepliesgroup'] = 'Reikalauti atsakymų';
$string['completionreplieshelp'] = 'reikalaujama atsakymų norint baigti';
$string['configcleanreadtime'] = 'Paros valanda, kai seni skelbimai turi būti valomi iš perskaitytų skelbimų lentelės.';
$string['configdigestmailtime'] = 'Žmonės, kurie pasirenka gauti laiškus sutrumpinta forma, juos gaus kiekvieną dieną. Šis nustatymas kontroliuoja kokiu dienos laiku tie laiškai bus išsiųsti (kitas „cron“, kuris veiks po šitos valandos išsiųs tai).';
$string['configdisplaymode'] = 'Numatytasis diskusijų režimas, jei toks nenustatytas.';
$string['configenablerssfeeds'] = 'Šis perjungimas įjungs RSS informacijos santraukų galimybę visuose forumuose. Vis tiek turėsite rankiniu būdu įjungti informacijos santraukas kiekvieno forumo parametruose.';
$string['configenabletimedposts'] = 'Nustatykite \'Taip\', jei norite leisti nustatyti rodymo laikotarpius, kai paskelbėte naują forumo diskusiją.';
$string['configlongpost'] = 'Bet koks įrašas, ilgesnis už šį ilgį (simboliais, neįskaitant HTML), laikomas ilgu. Svetainės pagrindiniame puslapyje, socialinio formato kursų puslapiuose ar vartotojų profiliuose rodomi įrašai sutrumpinami iki natūralaus lūžio tarp forum_shortpost ir forum_longpost reikšmių.';
$string['configmanydiscussions'] = 'Maksimalus diskusijų, rodomų viename forumo lape, skaičius';
$string['configmaxattachments'] = 'Numatytasis maksimalus leidžiamas skelbimo priedų skaičius.';
$string['configmaxbytes'] = 'Numatytasis maksimalus visų svetainės forumo priedų dydis (priklauso nuo kursų apribojimų ir kitų vietinių parametrų)';
$string['configoldpostdays'] = 'Dienų skaičius, kuriam praėjus bet kuris skelbimas laikomas perskaitytu.';
$string['configreplytouser'] = 'Kai forumo skelbimas išsiunčiamas, ar jame turėtų būti naudotojo pašto adresas, kad gavėjai galėtų atsakyti asmeniškai, o ne per forumą? Net jei nustatyta Taip, naudotojai savo profilyje gali pasirinkti slėpti savo el. pašto adresą.';
$string['configrssarticlesdefault'] = 'Jei RSS informacijos santraukos yra įjungtos, nustato numatytą straipsnių skaičių (diskusijų ar skelbimų).';
$string['configrsstypedefault'] = 'Jei RSS informacijos santraukos yra įjungtos, nustato numatytą veiklos tipą.';
$string['configshortpost'] = 'Bet kuris skelbimas, neviršijantis šio ilgio (simboliais, neįskaitant HTML), laikomas trumpu (žr. toliau).';
$string['configsubscriptiontype'] = 'Numatytieji parametrai prenumeratos režimui.';
$string['configtrackingtype'] = 'Skaitymo sekimo numatytasis parametras.';
$string['configtrackreadposts'] = 'Nustatykite Taip, jei norite sekti perskaitytus / neperskaitytus kiekvieno naudotojo skelbimus.';
$string['configusermarksread'] = 'Jei nustatyta Taip, naudotojas turi rankiniu būdu pažymėti skelbimą kaip perskaitytą. Jei pažymėta Ne, peržiūrėjus skelbimą, jis žymimas kaip perskaitytas.';
$string['confirmsubscribe'] = 'Ar tikrai norite prenumeruoti forumą {$a}?';
$string['confirmsubscribediscussion'] = 'Ar tikrai norite prenumeruoti diskusiją \'{$a->discussion}\' forume \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Ar tikrai norite atsisakyti forumo {$a} prenumeratos?';
$string['confirmunsubscribediscussion'] = 'Ar tikrai norite nebeprenumeruoti diskusijos \'{$a->discussion}\' forume \'{$a->forum}\'?';
$string['couldnotadd'] = 'Jūsų skelbimo nepavyko įtraukti dėl nežinomos klaidos';
$string['couldnotdeletereplies'] = 'Apgailestaujame, panaikinti negalima, nes žmonės į jį jau atsakė';
$string['couldnotupdate'] = 'Jūsų skelbimo nepavyko atnaujinti dėl nežinomos klaidos';
$string['created'] = 'Sukurtas';
$string['crontask'] = 'Forumo laiškai ir priežiūros darbai';
$string['cutoffdate'] = 'Paskutinė diena pristatymui';
$string['cutoffdate_help'] = 'Jei nustatyta, forumas nepriims pranešimų po šios datos.';
$string['cutoffdatereached'] = 'Šiame diskusijų forume yra pasiekta įrašų skelbimo galutinė data, todėl nebegalite daugiau skelbti įrašų.';
$string['cutoffdatevalidation'] = 'Galutinė data pristatymui negali būti ankstesnė nei pristatymo data.';
$string['delete'] = 'Naikinti';
$string['deleteddiscussion'] = 'Diskusijos tema buvo panaikinta';
$string['deletedpost'] = 'Įrašas panaikintas';
$string['deletedposts'] = 'Šie įrašai buvo panaikinti';
$string['deleteduser'] = 'Pašalinti dalyviai';
$string['deletesure'] = 'Ar tikrai norite naikinti šį įrašą?';
$string['deletesureplural'] = 'Ar tikrai norite naikinti šį skelbimą ir visus atsakymus į jį? ({$a} skelbimai)';
$string['digestmailheader'] = 'Tai jūsų kasdienė naujų {$a->sitename} forumų skelbimų santrauka. Norėdami keisti savo forumo el. pašto nuostatas, eikite į {$a->userprefs}.';
$string['digestmailpost'] = 'Pakeisti savo forumo santraukos parinktis';
$string['digestmailpostlink'] = 'Pakeisti savo forumo santraukos parinktis: {$a}';
$string['digestmailprefs'] = 'jūsų naudotojo profilis';
$string['digestmailsubject'] = '{$a}: forumo santrauka';
$string['digestmailtime'] = 'Valanda išsiųsti sutrauktus laiškus';
$string['digestsentusers'] = 'El. pašto santrauka sėkmingai išsiųsta {$a} naudotojams (-ų).';
$string['disallowsubscribe'] = 'Prenumeratos neleidžiamos';
$string['disallowsubscribeteacher'] = 'Prenumeratos neleidžiamos (išskyrus dėstytojus)';
$string['disallowsubscription'] = 'Prenumerata';
$string['disallowsubscription_help'] = 'Šis forumas buvo sukonfigūruotas taip, kad jūs negalite prenumeruoti diskusijų.';
$string['discussion'] = 'Diskusijos tema';
$string['discussionlistsortbycreatedasc'] = 'Rikiuoti didėjimo tvarka pagal sukūrimo datą';
$string['discussionlistsortbycreateddesc'] = 'Rikiuoti mažėjimo tvarka pagal sukūrimo datą';
$string['discussionlistsortbydiscussionasc'] = 'Rikiuoti didėjimo tvarka pagal diskusijos pavadinimą';
$string['discussionlistsortbydiscussiondesc'] = 'Rikiuoti mažėjimo tvarka pagal diskusijos pavadinimą';
$string['discussionlistsortbygroupasc'] = 'Rikiuoti didėjimo tvarka pagal grupę';
$string['discussionlistsortbygroupdesc'] = 'Rikiuoti mažėjimo tvarka pagal grupę';
$string['discussionlistsortbylastpostasc'] = 'Rikiuoti didėjimo tvarka pagal paskutinio įrašo sukūrimo datą';
$string['discussionlistsortbylastpostdesc'] = 'Rikiuoti mažėjimo tvarka pagal paskutinio įrašo sukūrimo datą';
$string['discussionlistsortbyrepliesasc'] = 'Rikiuoti didėjimo tvarka pagal atsakymų skaičių';
$string['discussionlistsortbyrepliesdesc'] = 'Rikiuoti mažėjimo tvarka pagal atsakymų skaičių';
$string['discussionlistsortbystarterasc'] = 'Rikiuoti didėjimo tvarka pagal diskusijų pradžios pavadinimą';
$string['discussionlistsortbystarterdesc'] = 'Rikiuoti mažėjimo tvarka pagal diskusijų pradžios pavadinimą';
$string['discussionlocked'] = 'Ši diskusija buvo užrakinta, todėl jūs negalite pateikti atsakymus joje.';
$string['discussionlockingdisabled'] = 'Neužrakinti diskusijos';
$string['discussionlockingheader'] = 'Diskusijos užraktas';
$string['discussionmoved'] = 'Ši diskusija perkelta į {$a}.';
$string['discussionmovedpost'] = 'Ši diskusija perkelta <a href="{$a->discusshref}">čia</a> forume <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Diskusijos pavadinimas';
$string['discussionnownotsubscribed'] = '{$a->name} NEBUS informuojama (-as) apie naujus įrašus \'{$a->discussion}\' iš \'{$a->forum}\'';
$string['discussionnowsubscribed'] = 'Jums bus pranešta apie naujus įrašus „{$a->discussion}“ forume „{$a->forum}“.';
$string['discussionpin'] = 'Prisegti';
$string['discussionpinned'] = 'Prisegta';
$string['discussionpinned_help'] = 'Prisegtos diskusijos bus rodomos forumo viršuje.';
$string['discussions'] = 'Diskusijos';
$string['discussionsplit'] = 'Diskusija buvo padalyta';
$string['discussionsstartedby'] = 'Diskusijos, kurias pradėjo {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusijos, kurias neseniai pradėjo {$a}';
$string['discussionsstartedbyuserincourse'] = 'Diskusija {$a->coursename} pradėta {$a->fullname}';
$string['discussionsstartedincourse'] = 'Diskusijos prasidėjo {$a}';
$string['discussionstartedby'] = 'Diskusiją pradėjo {$a}';
$string['discussionsubscribed'] = 'Dabar prenumeruojate šią diskusiją.';
$string['discussionsubscribestart'] = 'Siųsti man pranešimus apie naujus pranešimus šioje diskusijoje';
$string['discussionsubscribestop'] = 'Aš nenoriu, kad būtų pranešta apie naujas žinutes šioje diskusijoje';
$string['discussionsubscription'] = 'Diskusijos prenumerata';
$string['discussionsubscription_help'] = 'Diskusijų prenumerata reiškia, kad Jūs gausite pranešimus apie naujas žinutes šioje diskusijoje.';
$string['discussionunpin'] = 'Atsegti';
$string['discussionunsubscribed'] = 'Dabar atšaukėte šios diskusijos prenumeratą.';
$string['discussthistopic'] = 'Diskutuoti šia tema';
$string['discusstopicname'] = 'Diskutuokite tema: {$a}';
$string['displayend'] = 'Rodymo pabaiga';
$string['displayend_help'] = 'Šis parametras nurodo, ar forumo skelbimas turėtų būti slepiamas po tam tikros datos. Atkreipkite dėmesį, kad administratoriai visada gali peržiūrėti forumo skelbimus.';
$string['displayenddate'] = 'Rodymo pabaiga: {$a}.';
$string['displaymode'] = 'Rodymo režimas';
$string['displayperiod'] = 'Rodymo laikotarpis';
$string['displaystart'] = 'Rodymo pradžia';
$string['displaystart_help'] = 'Šis parametras nurodo, ar forumo skelbimas turėtų būti rodomas po tam tikros datos. Atkreipkite dėmesį, kad administratoriai visada gali peržiūrėti forumo skelbimus.';
$string['displaystartdate'] = 'Rodymo pradžia: {$a}.';
$string['displaywordcount'] = 'Rodyti žodžių skaičių';
$string['displaywordcount_help'] = 'Šis parametras nurodo ar turėtų būti rodomas kiekviename skelbime žodžių skaičius.';
$string['duedate'] = 'Data pristatymui';
$string['duedate_help'] = 'Data pristatymui nurodo iki kada reikia paskelbti įrašą. Nors ši data kalendoriuje rodoma kaip galutinė diskusijų pristatymo data, skelbti vis tiek bus leidžiama po šios datos. Nustatykite diskusijų forumo galutinę pabaigos datą, kad nebūtų galima skelbti įrašų po tam tikros datos.';
$string['duedatetodisplayincalendar'] = 'Data pristatymui rodoma kalendoriuje';
$string['eachuserforum'] = 'Kiekvienas asmuo paskelbia vieną diskusiją';
$string['edit'] = 'Redaguoti';
$string['editdiscussion'] = 'Redaguoti diskusiją';
$string['editdiscussiontopic'] = 'Redaguoti diskusijos temą';
$string['editedby'] = 'Redagavo {$a->name} – pradinis pateikimas {$a->date}';
$string['editedpostupdated'] = '{$a} skelbimas buvo atnaujintas';
$string['editing'] = 'Redaguojama';
$string['emaildigestcompleteshort'] = 'Užbaigti skelbimai';
$string['emaildigestdefault'] = 'Numatyta ({$a})';
$string['emaildigestoffshort'] = 'Be santraukos';
$string['emaildigestsubjectsshort'] = 'Tik temos';
$string['emaildigesttype'] = 'El. laiško santraukos parinktys';
$string['emaildigesttype_help'] = 'Pranešimo tipas, kuris gaunamas iš kiekvieno forumo.

* Numatyta - laikomasi numatyto santraukos nustatymo, nurodyto naudotojo profilyje. Jei atnaujinsite savo profilį, tada šis pakeitimas atsispindės taip pat ir čia ;
* Be santraukos – Jūs gausite po vieną el. laišką kiekvienam forumo skelbimui;
* Santrauka - užbaigti skelbimai – Jūs gausite po el. laišką per dieną su pilnu kiekvieno forumo skelbimo turiniu;
*  Santrauka - tik temos – Jūs gausite vieną el. laišką per dieną su kiekvieno forumo skelbimo temomis.';
$string['emptymessage'] = 'Kažkas atsitiko su skelbimu. Gal palikote jį tuščią arba priedas yra per didelis. Jūsų pakeitimai NEĮRAŠYTI.';
$string['errorcannotlock'] = 'Jūs neturite teisių užrakinti diskusijas.';
$string['errordiscussionnotfound'] = 'Diskusija nerasta';
$string['erroremptymessage'] = 'Skelbimo žinutė negali būti tuščia';
$string['erroremptysubject'] = 'Skelbimo tema negali būti tuščia.';
$string['errorenrolmentrequired'] = 'Norėdami pasiekti šį turinį, turite būti įregistruoti šiame kurse';
$string['errorforumnotfound'] = 'Forumas, kuriam priklauso ši diskusija, nerastas';
$string['errorwhiledelete'] = 'Naikinant įrašą įvyko klaida.';
$string['eventassessableuploaded'] = 'Turinys paskelbtas.';
$string['eventcoursesearched'] = 'Ieškota kurse';
$string['eventdiscussioncreated'] = 'Diskusija sukurta';
$string['eventdiscussiondeleted'] = 'Diskusija ištrinta';
$string['eventdiscussionmoved'] = 'Diskusija perkelta';
$string['eventdiscussionpinned'] = 'Diskusija prisegta';
$string['eventdiscussionsubscriptioncreated'] = 'Diskusijos prenumerata sukurta';
$string['eventdiscussionsubscriptiondeleted'] = 'Diskusijos prenumerata ištrinta';
$string['eventdiscussionunpinned'] = 'Diskusija atsegta';
$string['eventdiscussionupdated'] = 'Diskusija atnaujinta';
$string['eventdiscussionviewed'] = 'Diskusija peržiūrėta';
$string['eventpostcreated'] = 'Žinutė sukurta';
$string['eventpostdeleted'] = 'Žinutė ištrinta';
$string['eventpostupdated'] = 'Žinutė atnaujinta';
$string['eventreadtrackingdisabled'] = 'Skaitymo sekimas išjungtas';
$string['eventreadtrackingenabled'] = 'Skaitymo sekimas įjungtas';
$string['eventsubscribersviewed'] = 'Prenumeratoriai peržiūrėti';
$string['eventsubscriptioncreated'] = 'Prenumerata sukurta';
$string['eventsubscriptiondeleted'] = 'Prenumerata ištrinta';
$string['eventuserreportviewed'] = 'Naudotojo ataskaita peržiūrėta';
$string['everyonecanchoose'] = 'Kiekvienas naudotojas gali pasirinkti prenumeruoti';
$string['everyonecannowchoose'] = 'Dabar kiekvienas naudotojas gali pasirinkti prenumeruoti';
$string['everyoneisnowsubscribed'] = 'Dabar visi naudotojai užsiprenumeravę šį forumą';
$string['everyoneissubscribed'] = 'Visi naudotojai užsiprenumeravę šį forumą';
$string['existingsubscribers'] = 'Esami prenumeratoriai';
$string['export'] = 'Eksportuoti';
$string['exportattachmentname'] = 'Eksportuoti priedą {$a} į portfelį';
$string['exportdiscussion'] = 'Eksportuoti visą diskusiją į portfelį';
$string['exporthumandates'] = 'Datų pateikimas suprantama forma';
$string['exporthumandates_help'] = 'Datos gali būti eksportuojamos žmonėms suprantama forma arba kaip laiko žyma (skaičių seka).';
$string['exportoptions'] = 'Eksporto parinktys';
$string['exportstriphtml'] = 'Pašalinti HTML';
$string['exportstriphtml_help'] = 'Pašalinamos HTML žymos, tokios kaip p ir br iš paskelbtų diskusijų įrašų.';
$string['favourites'] = 'Pažymėta';
$string['favouriteupdated'] = 'Pažymėjimo parinktis atnaujinta.';
$string['firstpost'] = 'Pirmas įrašas';
$string['forcedreadtracking'] = 'Leisti priverstinį skaitymo sekimą';
$string['forcedreadtracking_desc'] = 'Leidžia forumuose nustatyti priverstinį skaitymo sekimą. Kai kuriems naudotojams bus sumažintas našumas, ypač kursuose, kuriuose daug forumų ir skelbimų. Kai išjungta, visi forumai, anksčiau nustatyti "Priversti", laikoma neprivalomais.';
$string['forcesubscribed'] = 'Forumas reikalauja kiekvienam užsiprenumeruoti';
$string['forcesubscribed_help'] = 'Šis forumas buvo sukonfigūruotas taip, kad jūs negalite atsisakyti diskusijų.';
$string['forum'] = 'Forumai';
$string['forum:addinstance'] = 'Pridėti naują forumą';
$string['forum:addnews'] = 'Įtraukti skelbimų';
$string['forum:addquestion'] = 'Pridėti klausimą';
$string['forum:allowforcesubscribe'] = 'Leisti priverstinę prenumeratą';
$string['forum:canoverridecutoff'] = 'Forumo įrašai po galutinės datos';
$string['forum:canoverridediscussionlock'] = 'Atsakyti į užrakintas diskusijas';
$string['forum:canposttomygroups'] = 'Paskelbti visoms grupėms, prie kurių turite prieigą';
$string['forum:cantogglefavourite'] = 'Pažymėti diskusijas';
$string['forum:createattachment'] = 'Kurti priedus';
$string['forum:deleteanypost'] = 'Naikinti bet kuriuos skelbimus (bet kada)';
$string['forum:deleteownpost'] = 'Naikinti savo skelbimus (iki termino)';
$string['forum:editanypost'] = 'Redaguoti bet kurį skelbimą';
$string['forum:exportdiscussion'] = 'Eksportuoti visą diskusiją';
$string['forum:exportforum'] = 'Eksportuoti forumą';
$string['forum:exportownpost'] = 'Eksportuoti savo skelbimą';
$string['forum:exportpost'] = 'Eksportuoti skelbimą';
$string['forum:grade'] = 'Vertinti forumą';
$string['forum:managesubscriptions'] = 'Tvarkyti prenumeratorius';
$string['forum:movediscussions'] = 'Perkelti diskusijas';
$string['forum:pindiscussions'] = 'Prisegti diskusijas';
$string['forum:postprivatereply'] = 'Į žinutes atsakyti privačiai';
$string['forum:postwithoutthrottling'] = 'Netaikyti skelbimo slenksčio';
$string['forum:rate'] = 'Vertinti įrašus';
$string['forum:readprivatereplies'] = 'Peržiūrėti asmeninius atsakymus';
$string['forum:replynews'] = 'Atsakyti į skelbimus';
$string['forum:replypost'] = 'Atsakyti į skelbimus';
$string['forum:splitdiscussions'] = 'Skaidyti diskusijas';
$string['forum:startdiscussion'] = 'Pradėti naujas diskusijas';
$string['forum:viewallratings'] = 'Peržiūrėti visus neapdorotus asmenų parašytus pažymius';
$string['forum:viewanyrating'] = 'Peržiūrėti bendrus kurio nors asmens gautus pažymius';
$string['forum:viewdiscussion'] = 'Peržiūrėti diskusijas';
$string['forum:viewhiddentimedposts'] = 'Peržiūrėti paslėptus skelbimus su apribotu laiku';
$string['forum:viewqandawithoutposting'] = 'Visada peržiūrėti klausimų ir atsakymų skelbimus';
$string['forum:viewrating'] = 'Peržiūrėti bendrus jūsų gautus pažymius';
$string['forum:viewsubscribers'] = 'Peržiūrėti prenumeratorius';
$string['forumauthorhidden'] = 'Autorius (paslėptas)';
$string['forumblockingalmosttoomanyposts'] = 'Tuoj pasieksite publikavimo slenkstį. Per paskutinį {$a->blockperiod} paskelbėte {$a->numposts} kartus (-ų), o limitas yra {$a->blockafter} skelbimai (-ų).';
$string['forumbodydeleted'] = 'Forumo turinys buvo pašalintas ir jis daugiau nebepasiekiamas.';
$string['forumbodyhidden'] = 'Šis įrašas šiuo metu yra paslėptas, greičiausiai todėl, kad pirmiausia turite paskelbti diskusiją, o forumo pranešimai turi būti išsiųsti. Kita galimybė – dabartinis laikas nepatenka į įrašui nustatytą rodymo laikotarpį.';
$string['forumgrader'] = 'Forumo vertintojas';
$string['forumgradingnavigation'] = 'Forumo vertinimo navigacija';
$string['forumgradingpanel'] = 'Forumo vertinimo skydelis';
$string['forumintro'] = 'Aprašymas';
$string['forumname'] = 'Forumo pavadinimas';
$string['forumposts'] = 'Forumo skelbimai';
$string['forums'] = 'Forumai';
$string['forumsubjectdeleted'] = 'Forumo įrašas pašalintas';
$string['forumsubjecthidden'] = 'Tema (paslėpta)';
$string['forumtracked'] = 'Neperskaityti skelbimai sekami';
$string['forumtrackednot'] = 'Neperskaityti skelbimai nesekami';
$string['forumtype'] = 'Forumo tipas';
$string['forumtype_help'] = 'Yra 5 forumų tipai:

* Viena paprasta diskusija – viena diskusijos tema, į kurią gali atsakyti visi (negalima naudoti su atskiromis grupėmis)
* Kiekvienas asmuo paskelbia vieną diskusiją – kiekvienas besimokantysis gali paskelbti tik vieną naują diskusijos temą, į kurią kiekvienas gali atsakyti
* Klausimų ir atsakymų forumas – prieš peržiūrėdamas kitų besimokančiųjų įrašus, besimokantysis pirmiausia turi paskelbti savo atsakymą į dėstytojo paskelbtą klausimą
* Standartinis forumas, rodomas į tinklaraštį panašiu formatu – atviras forumas, kuriame kiekvienas gali bet kada pradėti naują diskusiją ir kuriame diskusijų temos rodomos viename puslapyje su nuorodomis „Diskutuoti šia tema“
* Standartinis bendro naudojimo forumas – atviras forumas, kuriame kiekvienas gali bet kada pradėti naują diskusiją';
$string['generalforum'] = 'Standartinis bendro naudojimo forumas';
$string['generalforums'] = 'Bendrieji forumai';
$string['grade_forum_header'] = 'Viso forumo vertinimas';
$string['grade_forum_name'] = 'Visas forumas';
$string['grade_forum_title'] = 'Įvertinimas';
$string['grade_rating_name'] = 'Reitingas';
$string['graded'] = 'Įvertintas';
$string['gradedby'] = 'Įvertinta';
$string['gradeforrating'] = 'Įvertinimas reitingui: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Paslėpto reitingo įvertinimas';
$string['gradeforwholeforum'] = 'Įvertinimas forumui: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Įvertinimas forumui paslėptas';
$string['gradeitem:forum'] = 'Diskusijų forumas';
$string['gradeitemnameforrating'] = '{$a->name} įvertinimas';
$string['gradeitemnameforwholeforum'] = '{$a->name} visas forumas';
$string['grades:gradesavedfor'] = '{$a->fullname} įvertinimas išsaugotas';
$string['grades:gradesavefailed'] = 'Nepavyko išsaugoti {$a->fullname} įvertinimo: {$a->error}';
$string['gradeusers'] = 'Įvertinti dalyvius';
$string['grading'] = 'Vertinimas';
$string['gradingstatus'] = 'Įvertinimo būsena:';
$string['hiddenforumpost'] = 'Paslėptos forumo žinutės';
$string['hidegraderpanel'] = 'Slėpti vertintojo skydelį';
$string['hidepreviousrepliescount'] = 'Slėpti ankstesnius atsakymus ({$a})';
$string['hideusersearch'] = 'Slėpti naudotojo paiešką';
$string['indexoutoftotal'] = '{$a->index} iš {$a->total}';
$string['indicator:cognitivedepth'] = 'Kognityvinis forumas';
$string['indicator:cognitivedepth_help'] = 'Šis rodiklis pagrįstas pažinimo gyliu, kurį besimokantysis pasiekia Forumo veikloje.';
$string['indicator:cognitivedepthdef'] = 'Kognityvinis forumas';
$string['indicator:cognitivedepthdef_help'] = 'Per šį analizės intervalą dalyvis pasiekė šį kognityvinio įsitraukimo procentą, kurį siūlo Forumo veikla (Lygiai = Neperžiūrėta, Peržiūrėta, Pateikta, Peržiūrėtas atsiliepimas, Pakomentuotas atsiliepimas, Pateikta iš naujo po peržiūros)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialinis forumas';
$string['indicator:socialbreadth_help'] = 'Šis rodiklis pagrįstas socialiniu platumu, kurį besimokantysis pasiekia Forumo veikloje.';
$string['indicator:socialbreadthdef'] = 'Socialinis forumas';
$string['indicator:socialbreadthdef_help'] = 'Dalyvis pasiekė šį socialinio įsitraukimo procentą, kurį siūlo Forumo veikla per šį analizės intervalą (Lygiai = Nedalyvauja, Dalyvis vienas, Dalyvis su kitais)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = '{$a}';
$string['inreplyto'] = 'Atsakymas į {$a}';
$string['introblog'] = 'Šio forumo skelbimai buvo automatiškai nukopijuoti iš šių kursų naudotojų tinklaraščių, nes tie tinklaraščių įrašai nebeprieinami';
$string['intronews'] = 'Bendros naujienos ir skelbimai';
$string['introsocial'] = 'Atviras forumas, kuriame galima kalbėtis visomis norimomis temomis';
$string['introteacher'] = 'Dėstytojams skirtas forumas – tik pastabos ir diskusija';
$string['invalidaccess'] = 'Į šį puslapį įeita netinkamai';
$string['invaliddigestsetting'] = 'Pateiktas netinkamas pašto santraukos nustatymas';
$string['invaliddiscussionid'] = 'Diskusijos ID klaidingas arba jo nebėra';
$string['invalidforcesubscribe'] = 'Neleistinas priverstinės prenumeratos režimas';
$string['invalidforumid'] = 'Forumo ID klaidingas';
$string['invalidparentpostid'] = 'Pirminio skelbimo ID klaidingas';
$string['invalidpostid'] = 'Neleistinas skelbimo ID – {$a}';
$string['lastpost'] = 'Paskutinis įrašas';
$string['learningforums'] = 'Mokymosi forumai';
$string['lockdiscussion'] = 'Užrakinti šią diskusiją';
$string['lockdiscussionafter'] = 'Neaktyvus laikotarpis diskusijos užrakinimui';
$string['lockdiscussionafter_help'] = 'Diskusijos gali būti automatiškai užrakintos po tam tikro laiko nuo paskutinio atsakymo.

Naudotojai, kurie turi galimybę atsakyti į užrakintas diskusijas, gali atrakinti diskusiją pateikiant atsakymą joje.';
$string['locked'] = 'Užrakinta';
$string['lockupdated'] = 'Užrakto parinktis atnaujinta.';
$string['longpost'] = 'Ilgas skelbimas';
$string['mailnow'] = 'Siųsti forumo pranešimus be redagavimo-uždelsimo';
$string['managesubscriptionsoff'] = 'Baigti prenumeratorių tvarkymą';
$string['managesubscriptionson'] = 'Valdyti prenumeratorius';
$string['manydiscussions'] = 'Diskusijų skaičius puslapyje';
$string['markalldread'] = 'Žymėti visus šios diskusijos skelbimus kaip perskaitytus.';
$string['markallread'] = 'Žymėti visus šio forumo skelbimus kaip perskaitytus.';
$string['markasread'] = 'Pažymėti kaip skaitytą';
$string['markasreadonnotification'] = 'Kai siunčiami forumo skelbimų pranešimai';
$string['markasreadonnotification_help'] = 'Kai Jums pranešama apie forumo skelbimus, galite pasirinkti ar skelbimai turėtų būti pažymėti kaip perskaityti, sekant diskusijas.';
$string['markasreadonnotificationno'] = 'Pažymėti skelbimą kaip neperskaitytą';
$string['markasreadonnotificationyes'] = 'Pažymėti skelbimą kaip perskaitytą';
$string['markread'] = 'Žymėti kaip perskaitytą';
$string['markreadbutton'] = 'Žymėti kaip<br />perskaitytą';
$string['markunread'] = 'Žymėti kaip neperskaitytą';
$string['markunreadbutton'] = 'Žymėti kaip<br />neperskaitytą';
$string['maxattachments'] = 'Maksimalus priedų skaičius';
$string['maxattachments_help'] = 'Šis parametras nurodo maksimalų failų, kuriuos galima pridėti prie forumo skelbimo, skaičių.';
$string['maxattachmentsize'] = 'Maksimalus priedo dydis';
$string['maxattachmentsize_help'] = 'Šis parametras nurodo maksimalų failo, kurį galima pridėti prie forumo skelbimo, dydį.';
$string['maxtimehaspassed'] = 'Apgailestaujame, baigėsi maksimalus šio skelbimo redagavimo ({$a}) laikas!';
$string['message'] = 'Žinutės tekstas';
$string['messageinboundattachmentdisallowed'] = 'Nepavyko paskelbti atsakymo, nes jame yra pridėtas priedas, o forumas neleidžia priedų.';
$string['messageinboundfilecountexceeded'] = 'Nepavyko paskelbti atsakymo, nes pridėta daugiau nei nustatytas didžiausias leidžiamų forumo priedų skaičius ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Nepavyko paskelbti atsakymo, nes bendras priedo dydis ({$a->filesize}) yra didesnis už didžiausią leidžiamą forumo dydį ({$ a-> maxbytes}).';
$string['messageinboundforumhidden'] = 'Nepavyko paskelbti atsakymo, nes forumas šiuo metu nepasiekiamas.';
$string['messageinboundnopostforum'] = 'Nepavyko paskelbti atsakymo, nes neturite leidimo skelbti {$a->forum->name} forume.';
$string['messageinboundthresholdhit'] = 'Nepavyko paskelbti atsakymo. Jūs pasiekėte šiame forume nustatytą skelbimų limitą';
$string['messageprovider:digests'] = 'Prenumeruotos forumų santraukos';
$string['messageprovider:posts'] = 'Prenumeruoti forumų skelbimai';
$string['missingsearchterms'] = 'Šie paieškos terminai rodomi tik šios žinutės HTML apraše:';
$string['modeflatnewestfirst'] = 'Rodyti atsakymus standartiškai, pirmiausia rodant naujausią';
$string['modeflatoldestfirst'] = 'Rodyti atsakymus standartiškai, pirmiausia rodant seniausią';
$string['modenested'] = 'Rodyti atsakymus įdėtuoju formatu';
$string['modenestedv2'] = 'Rodyti atsakymus eksperimentine įdėtąją forma';
$string['modethreaded'] = 'Rodyti atsakymus gijų formatu';
$string['modulename'] = 'Diskusijų forumas';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Forumai';
$string['more'] = 'daugiau';
$string['movedmarker'] = '(Perkelta)';
$string['movethisdiscussionlabel'] = 'Perkelti dabartinę diskusiją į nurodytą forumą';
$string['movethisdiscussionto'] = 'Perkelti šią diskusiją į ...';
$string['mustprovidediscussionorpost'] = 'Norėdami eksportuoti, turite pateikti diskusijos ID arba įrašo ID.';
$string['myprofileotherdis'] = 'Forumo diskusijos';
$string['myprofileowndis'] = 'Mano forumo diskusijos';
$string['myprofileownpost'] = 'Mano forumo skelbimai';
$string['namenews'] = 'Skelbimai';
$string['namenews_help'] = 'Skelbimų forumas yra specialus skelbimams skirtas forumas, automatiškai sukuriamas kuriant kursus. Kursuose gali būti tik vienas naujienų forumas. Skelbimų forume gali skelbti tik dėstytojai ir administratoriai. Blokas "Naujausios naujienos" rodys paskutines naujienas iš skelbimų forumo.';
$string['namesocial'] = 'Socialinis forumas';
$string['nameteacher'] = 'Dėstytojų forumas';
$string['newforumposts'] = 'Nauji forumo skelbimai';
$string['nextdiscussiona'] = 'Kita diskusija: {$a}';
$string['nextuser'] = 'Kitas dalyvis';
$string['noattachments'] = 'Nėra šio skelbimo priedų';
$string['nodiscussions'] = 'Šiame forume dar nėra diskusijų temų';
$string['nodiscussionsstartedby'] = 'Nėra šio naudotojo pradėtų diskusijų';
$string['nodiscussionsstartedbyyou'] = 'Jūs dar nepradėjote nei vienos diskusijos';
$string['noguestpost'] = 'Šiame forume rašyti gali tik prisijungę naudotojai.';
$string['noguestpost:title'] = 'Jei norite tęsti, prisijunkite';
$string['noguestsubscribe'] = 'Atsiprašome, svečiai negali užsiprenumeruoti.';
$string['noguesttracking'] = 'Apgailestaujame, svečiams neleidžiama nustatyti sekimo parinkčių.';
$string['nomorepostscontaining'] = 'Nerasta daugiau žinučių, kuriose yra {$a}';
$string['nonews'] = 'Skelbimų dar nepaskelbta.';
$string['noonecansubscribenow'] = 'Prenumeratos dabar neleidžiamos';
$string['nopermissiontosubscribe'] = 'Neturite teisės peržiūrėti forumo prenumeratorių';
$string['nopermissiontoview'] = 'Neturite teisių peržiūrėti šį skelbimą';
$string['nopostforum'] = 'Apgailestaujame, jums neleidžiama skelbti šiame forume';
$string['noposts'] = 'Skelbimų nėra';
$string['nopostsmadebyuser'] = '{$a} neparašė nei vieno pranešimo';
$string['nopostsmadebyyou'] = 'Jūs neparašėte nei vieno pranešimo';
$string['noquestions'] = 'Šiame forume dar nėra klausimų';
$string['nosubscribers'] = 'Dar nėra šio forumo prenumeratorių';
$string['notexists'] = 'Diskusijos nebėra';
$string['notgraded'] = 'Neįvertinta';
$string['nothingnew'] = 'Nieko naujo iš {$a}';
$string['notingroup'] = 'Apgailestaujame, bet norėdami peržiūrėti šį forumą turite priklausyti grupei.';
$string['notinstalled'] = 'Forumo modulis neįdiegtas';
$string['notlocked'] = 'Užrakinta';
$string['notpartofdiscussion'] = 'Šis skelbimas nėra diskusijos dalis!';
$string['notrackforum'] = 'Nesekti neperskaitytų skelbimų';
$string['notsubscribed'] = 'Prenumeruoti';
$string['nousersmatch'] = 'Pagal nurodytus kriterijus nerastas (-i) naudotojas (-ai).';
$string['noviewdiscussionspermission'] = 'Neturite teisės peržiūrėti šio forumo diskusijų';
$string['nowallsubscribed'] = 'Dabar prenumeruojate visus forumus, esančius {$a}.';
$string['nowallunsubscribed'] = 'Dabar esate atšaukę prenumeratą visiems forumams, esantiems {$}.';
$string['nowgradinguser'] = 'Dabar vertinama {$a}';
$string['nownotsubscribed'] = '{$a->name} NEGAUS {$a->forum} kopijų el. paštu.';
$string['nownottracking'] = '{$a->name} nebeseka {$a->forum}.';
$string['nowsubscribed'] = 'Jums bus pranešta apie naujus pranešimus forume „{$a->forum}“.';
$string['nowtracking'] = '{$a->name} dabar seka {$a->forum}.';
$string['numberofreplies'] = 'Atsakymų skaičius: {$a}';
$string['numposts'] = '{$a} skelbimai';
$string['olderdiscussions'] = 'Visos naujienos';
$string['oldertopics'] = 'Visos naujienos';
$string['oldpostdays'] = 'Dienos, po kurių bus perskaityta';
$string['page-mod-forum-discuss'] = 'Forumo modulio diskusijų puslapis';
$string['page-mod-forum-view'] = 'Forumo modulio pagrindinis puslapis';
$string['page-mod-forum-x'] = 'Bet kuris forumo modulio puslapis';
$string['parent'] = 'Rodyti pirminį';
$string['parentofthispost'] = 'Šio skelbimo pirminis skelbimas';
$string['permalink'] = 'Tiesioginė nuoroda';
$string['permanentlinktoparentpost'] = 'Nuolatinė nuoroda į šio įrašo pagrindinį puslapį';
$string['permanentlinktopost'] = 'Nuolatinė šio įrašo nuoroda';
$string['pindiscussion'] = 'Prisegti šią diskusiją';
$string['pinupdated'] = 'Smeigtuko parinktis buvo atnaujinta.';
$string['pluginadministration'] = 'Forumo administravimas';
$string['pluginname'] = 'Forumas';
$string['postadded'] = '<p>Jūsų skelbimas sėkmingai įtrauktas.</p> <p>Jei norite atlikti pakeitimų, turite {$a} jam redaguoti.</p>';
$string['postaddedsuccess'] = 'Jūsų skelbimas sėkmingai įtrauktas.';
$string['postaddedtimeleft'] = 'Jei norite atlikti pakeitimų, turite {$a} jam redaguoti.';
$string['postbymailsuccess'] = 'Jūsų atsakymas "{$a->subject}" sėkmingai paskelbtas: {$a-discussionurl}';
$string['postbymailsuccess_html'] = 'Jūsų atsakymas <a href="{$a->discussionurl}">{$a->subject}</a> sėkmingai paskelbtas.';
$string['postbyuser'] = '{$a->post} žinutė {$a->user}';
$string['postincontext'] = 'Peržiūrėti šį skelbimą kontekste';
$string['postisprivatereply'] = 'Tai privatus atsakymas. (Dėstytojai ir kiti naudotojai, galintys peržiūrėti privačius atsakymus, taip pat gali tai matyti.)';
$string['postmailinfo'] = 'Tai pranešimo, paskelbto {$a}, kopija.';
$string['postmailinfolink'] = 'Tai yra pranešimo kopija paskelbto kurse {$a->coursename}.

Norėdami atsakyti spustelėkite šią nuorodą: {$a->replylink}';
$string['postmailnow'] = '<p>Šis skelbimas bus nedelsiant išsiųstas visiems forumo prenumeratoriams.</p>';
$string['postmailreply'] = 'Norėdami atsakyti, spustelėkite šią nuorodą: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Daugiausia atskiros žinios';
$string['postrating2'] = 'Atskiros ir sujungtos';
$string['postrating3'] = 'Daugiausia sujungtos žinios';
$string['posts'] = 'Skelbimai';
$string['postsfrom'] = 'Įrašai nuo';
$string['postsmadebyuser'] = 'Pranešimą parašė {$a}';
$string['postsmadebyuserincourse'] = 'Pranešimas parašytas {$a->fullname} paskaitoje {$a->coursename}';
$string['postsmadeincourse'] = 'Įrašai, sukurti {$a}';
$string['poststo'] = 'Skelbia į';
$string['posttoforum'] = 'Skelbti forume';
$string['posttomygroups'] = 'Skelbti kopiją visoms grupėms';
$string['posttomygroups_help'] = 'Skelbti pranešimo kopiją visoms grupėms, kuriose esate įtrauktas. Grupių, prie kurių neturite prieigos, dalyviai nematys šio pranešimo';
$string['postupdated'] = 'Jūsų skelbimas atnaujintas';
$string['potentialsubscribers'] = 'Potencialūs prenumeratoriai';
$string['prevdiscussiona'] = 'Ankstesnė diskusija: {$a}';
$string['previoususer'] = 'Išsaugoti pakeitimus ir pereiti prie ankstesnio naudotojo';
$string['privacy:digesttypenone'] = 'Neturime jokių duomenų, susijusių su pageidaujamu šio forumo santraukos tipu.';
$string['privacy:digesttypepreference'] = 'Pasirinkote gauti šį forumo santraukos tipą: „{$a->type}“.';
$string['privacy:discussionsubscriptionpreference'] = 'Šiam forumui pasirinkote šią diskusijų prenumeratos nuostatą: „{$a->preference}“';
$string['privacy:metadata:core_rating'] = 'Forumas naudoja įvertinimo posistemį, kad palaikytų pranešimų įvertinimą.';
$string['privacy:metadata:core_tag'] = 'Forumas naudoja žymų posistemį, kad palaikytų įrašų žymėjimą.';
$string['privacy:metadata:forum_digests'] = 'Informacija apie kiekvieno forumo santraukos nuostatas.';
$string['privacy:metadata:forum_digests:forum'] = 'Užsiprenumeravo forumą.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Santraukos pirmenybė.';
$string['privacy:metadata:forum_digests:userid'] = 'Naudotojo su santraukos nuostata ID.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informacija apie individualių forumo diskusijų abonementus';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Diskusijos, kuri buvo prenumeruojama, ID.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Prenumeratos pradžios laikas.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Naudotojo, kuris prenumeruoja diskusiją, ID.';
$string['privacy:metadata:forum_discussions'] = 'Informacija apie atskiras naudotojo sukurtas forumo diskusijas';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODO – ką saugo šis laukas';
$string['privacy:metadata:forum_discussions:name'] = 'Diskusijos pavadinimas, pasirinktas autoriaus.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Laikas, kai diskusija buvo paskutinį kartą pakeista.';
$string['privacy:metadata:forum_discussions:userid'] = 'Naudotojo, kursi sukūrė diskusiją, ID,';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Naudotojo, kuris paskutinį kartą kokiu nors būdu pakeitė diskusiją, ID.';
$string['privacy:metadata:forum_grades'] = 'Forumo įvertinimo duomenys';
$string['privacy:metadata:forum_grades:forum'] = 'Forumas, kuris buvo įvertintas';
$string['privacy:metadata:forum_grades:grade'] = 'Įvertinimas suteiktas';
$string['privacy:metadata:forum_grades:userid'] = 'Naudotojas, kuris buvo įvertintas';
$string['privacy:metadata:forum_posts'] = 'Informacija apie kiekvieno forumo santraukos nuostatas.';
$string['privacy:metadata:forum_posts:created'] = 'Laikas, kai įrašas sukurtas.';
$string['privacy:metadata:forum_posts:discussion'] = 'Diskusija, kurioje yra įrašas.';
$string['privacy:metadata:forum_posts:message'] = 'Forumo žinutė.';
$string['privacy:metadata:forum_posts:modified'] = 'Laikas, kai įrašas buvo paskutinį kartą pakeistas.';
$string['privacy:metadata:forum_posts:parent'] = 'Pirminis įrašas, į kurį buvo atsakyta.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Naudotojo ID, kuriam buvo išsiųstas šis atsakymas.';
$string['privacy:metadata:forum_posts:subject'] = 'Forumo įrašo tema.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Forumo žinutė.';
$string['privacy:metadata:forum_posts:userid'] = 'Naudotojo, kuris parašė forumo įrašą, ID.';
$string['privacy:metadata:forum_queue'] = 'Laikinas pranešimų žurnalas, kuris bus išsiųstas santraukos forma';
$string['privacy:metadata:forum_queue:discussionid'] = 'Forumo diskusijos ID';
$string['privacy:metadata:forum_queue:postid'] = 'Forumo įrašo ID';
$string['privacy:metadata:forum_queue:timemodified'] = 'Pakeistas pradinio įrašo laikas';
$string['privacy:metadata:forum_queue:userid'] = 'Naudotojas, kuriam reikia pranešti apie įrašą';
$string['privacy:metadata:forum_read'] = 'Informacija apie tai, kuriuos įrašus perskaitė naudotojas.';
$string['privacy:metadata:forum_read:discussionid'] = 'Diskusija, kurioje yra įrašas.';
$string['privacy:metadata:forum_read:firstread'] = 'Pirmą kartą perskaitytas įrašas.';
$string['privacy:metadata:forum_read:lastread'] = 'Paskutinį kartą, kai buvo perskaitytas įrašas.';
$string['privacy:metadata:forum_read:postid'] = 'Įrašas, kuris buvo perskaitytas.';
$string['privacy:metadata:forum_read:userid'] = 'Naudotojo, su kuriuo susijęs šis įrašas, ID.';
$string['privacy:metadata:forum_subscriptions'] = 'Informacija apie tai, kokius forumus naudotojas užsiprenumeravo.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forumas, kuris buvo prenumeruotas.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Naudotojo, su kuriuo susijusi ši forumo prenumerata, ID.';
$string['privacy:metadata:forum_track_prefs'] = 'Informacija apie tai, kuriuose forumuose naudotojas pasirinko stebėti įrašų skaitymus.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forumas, kuriame įjungtas skaitymo stebėjimas.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Naudotojo, su kuriuo susijusi ši forumo stebėjimo nuostata, ID.';
$string['privacy:metadata:preference:autosubscribe'] = 'Ar užsiprenumeruoti diskusijas atsakant į jų įrašus.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Pageidautina diskusijų sąrašo rūšiavimo tvarka';
$string['privacy:metadata:preference:maildigest'] = 'Visos svetainės laiškų santraukos nuostata';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Ar pažymėti forumo įrašus kaip perskaitytus, kai jie gaunami kaip žinutės.';
$string['privacy:metadata:preference:trackforums'] = 'Ar įgalinti skaitymo stebėjimą.';
$string['privacy:postwasread'] = 'Šis įrašas pirmą kartą buvo perskaitytas {$a->firstread}, o paskutinį kartą skaitytas {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Pasirinkote nesekti pranešimų, kuriuos perskaitėte šiame forume.';
$string['privacy:request:delete:discussion:name'] = 'Pašalinti autoriaus prašymu';
$string['privacy:request:delete:post:message'] = 'Įrašo turinys  buvo pašalintas autoriaus prašymu.';
$string['privacy:request:delete:post:subject'] = 'Pašalinti autoriaus prašymu';
$string['privacy:subscribedtoforum'] = 'Jūs prenumeruojate šį forumą.';
$string['privatereply'] = 'Atsakyti privačiai';
$string['privatereply_help'] = 'Kai atsakote privačiai, jūsų įrašas taip pat matomas naudotojams, galintiems peržiūrėti privačius atsakymus, pvz., dėstytojams.';
$string['processingdigest'] = 'Apdorojama naudotojo {$a} el. pašto santrauka';
$string['processingpost'] = 'Apdorojamas skelbimas {$a}';
$string['prune'] = 'Skaidyti';
$string['prunediscussion'] = 'Padalinti diskusiją';
$string['prunedpost'] = 'Pagal šį skelbimą sukurta nauja diskusija';
$string['pruneheading'] = 'Skaidyti diskusiją ir perkelti šį skelbimą į naują diskusiją';
$string['qandaforum'] = 'Klausimų ir atsakymų forumas';
$string['qandanotify'] = 'Tai klausimų ir atsakymų forumas. Norėdami pamatyti kitus atsakymus, pirmiausia turite paskelbti savo atsakymą.';
$string['re'] = 'Ats.:';
$string['readtherest'] = 'Skaityti likusią šios temos dalį';
$string['removeallforumtags'] = 'Pašalinti visas forumo žymas';
$string['removefromfavourites'] = 'Nebežymėti šios diskusijos';
$string['replies'] = 'Atsakymai';
$string['repliesmany'] = 'kol kas atsakymų: {$a}';
$string['repliesone'] = 'kol kas atsakymų: {$a}';
$string['reply'] = 'Atsakyti';
$string['reply_handler'] = 'Atsakyti į forumo pranešimus elektroniniu paštu';
$string['reply_handler_name'] = 'Atsakyti į forumo pranešimus';
$string['replyauthorself'] = '{$a} (jūs)';
$string['replyforum'] = 'Atsakyti forume';
$string['replyingtoauthor'] = 'Atsakoma į {$a} ...';
$string['replyplaceholder'] = 'Parašyti atsakymą ...';
$string['replypostdiscussion'] = 'Atsakyti į diskusiją';
$string['replytopostbyemail'] = 'Jūs galite atsakyti į tai elektroniniu paštu.';
$string['replytouser'] = 'Naudoti el. pašto adresą atsakyme';
$string['resetdigests'] = 'Naikinti visus naudotojo forumo santraukos nustatymus';
$string['resetforums'] = 'Naikinti skelbimus iš';
$string['resetforumsall'] = 'Naikinti visus skelbimus';
$string['resetsubscriptions'] = 'Naikinti visas forumo prenumeratas';
$string['resettrackprefs'] = 'Naikinti visas forumo sekimo nuostatas';
$string['rssarticles'] = 'Naujausių RSS straipsnių skaičius';
$string['rssarticles_help'] = 'Šis parametras nurodo į RSS informacijos santrauką įtrauktinų straipsnių (diskusijų arba skelbimų) skaičių. Dažniausiai tai 5–20 straipsnių.';
$string['rsssubscriberssdiscussions'] = 'Diskusijų RSS informacijos santrauka';
$string['rsssubscriberssposts'] = 'Skelbimų RSS informacijos santrauka';
$string['rsstype'] = 'Šios veiklos RSS informacijos santrauka';
$string['rsstype_help'] = 'Norėdami įjungti šios veiklos RSS informacijos santrauką, pasirinkite diskusijas arba skelbimus, įtrauktinus į informacijos santrauką.';
$string['rsstypedefault'] = 'RSS informacijos santraukos tipas';
$string['search'] = 'Ieškoti';
$string['search:activity'] = 'Diskusija - veiklos informacija';
$string['search:post'] = 'Forumas - skelbimai';
$string['searchdatefrom'] = 'Skelbimai turi būti naujesni nei šis';
$string['searchdateto'] = 'Skelbimai turi būti senesni nei šis';
$string['searchforumintro'] = 'Įveskite paieškos terminus viename arba keliuose šiuose laukuose:';
$string['searchforums'] = 'Ieškoti forumuose';
$string['searchfullwords'] = 'Šie žodžiai turėtų būti rodomai kaip visi žodžiai';
$string['searchnotwords'] = 'Šie žodžiai NETURĖTŲ būti įtraukti';
$string['searcholderposts'] = 'Ieškoti senesniuose skelbimuose...';
$string['searchphrase'] = 'Skelbime turi būti rodoma ši konkreti frazė';
$string['searchresults'] = 'Ieškos rezultatai';
$string['searchsubject'] = 'Šie žodžiai turėtų būti temoje';
$string['searchtags'] = 'Yra pažymėtas';
$string['searchuser'] = 'Šis vardas turėtų sutapti su autoriaus';
$string['searchuserid'] = 'Autoriaus „Moodle“ ID';
$string['searchusers'] = 'Ieškoti naudotojų';
$string['searchwhichforums'] = 'Pasirinkite, kuriuose forumuose ieškoti';
$string['searchwords'] = 'Šie žodžiai gali būti rodomi bet kurioje skelbimo vietoje';
$string['seeallposts'] = 'Peržiūrėti visus šio naudotojo skelbimus';
$string['sendstudentnotificationsdefault'] = 'Numatytasis nustatymas "Informuoti besimokančiuosius"';
$string['sendstudentnotificationsdefault_help'] = 'Nustatykite numatytą reikšmė "Informuoti besimokančiuosius" žymimajam langeliui įvertinimo formoje.';
$string['sendstudentnotificationsno'] = 'Ne';
$string['sendstudentnotificationsyes'] = 'Taip, informuoti besimokantįjį';
$string['settings'] = 'Nustatymai';
$string['shortpost'] = 'Trumpas skelbimas';
$string['showgraderpanel'] = 'Rodyti vertintojo skydelį';
$string['showingcountoftotaldiscussions'] = 'Diskusijų sąrašas. Rodoma {$a->count} iš {$a->total} diskusijų';
$string['showmoreusers'] = 'Rodyti daugiau naudotojų';
$string['showpreviousrepliescount'] = 'Rodyti ankstesnius atsakymus ({$a})';
$string['showsubscribers'] = 'Rodyti / redaguoti esamus prenumeratorius';
$string['showusersearch'] = 'Rodyti naudotojo paiešką';
$string['singleforum'] = 'Viena paprasta diskusija';
$string['smallmessage'] = '{$a->user} paskelbė {$a->forumname}';
$string['smallmessagedigest'] = 'Forumo santrauka, kurioje {$a} pranešimai';
$string['starredonly'] = 'Ieškoti tik žvaigždute pažymėtose diskusijose';
$string['startedby'] = 'Pradėjo';
$string['subject'] = 'Tema';
$string['subplugintype_forumreport'] = 'Forumo ataskaita';
$string['subplugintype_forumreport_plural'] = 'Forumo ataskaitos';
$string['subscribe'] = 'Prenumeruoti forumą';
$string['subscribeall'] = 'Prenumeruoti visus šiame forume';
$string['subscribed'] = 'Užsiprenumeruota';
$string['subscribediscussion'] = 'Prenumeruoti šią diskusiją';
$string['subscribeenrolledonly'] = 'Atsiprašome, tik registruoti naudotojai gali prenumeruoti forumo pranešimus.';
$string['subscribenone'] = 'Atsisakyti visų prenumeratos šiame forume';
$string['subscribers'] = 'Prenumeratoriai';
$string['subscriberstowithcount'] = '"{$a->name}" ({$a->count}) prenumeratoriai';
$string['subscribestart'] = 'Siųsti man šio forumo skelbimo el. laiškų kopijas';
$string['subscribestop'] = 'Nenoriu šio forumo skelbimo el. laiškų kopijų';
$string['subscription'] = 'Prenumerata';
$string['subscription_help'] = 'Jei užsiprenumeravote forumą, reiškia, kad gausite forumo skelbimų el. laiškų kopijas. Paprastai galite pasirinkti, ar norite prenumeruoti, nors kartais prenumerata yra priverstinė, todėl forumo skelbimų el. laiškų kopijas gauna visi.';
$string['subscriptionandtracking'] = 'Prenumerata ir sekimas';
$string['subscriptionauto'] = 'Automatinė prenumerata';
$string['subscriptiondisabled'] = 'Prenumeravimas išjungtas';
$string['subscriptionforced'] = 'Priverstinė prenumerata';
$string['subscriptionmode'] = 'Prenumeravimo režimas';
$string['subscriptionmode_help'] = 'Kai dalyvis užsiprenumeruoja forumą, reiškia, kad jis gaus forumo skelbimų el. laiškų kopijas. Yra 4 prenumeratos režimo parinktys:

* Pasirinktinė prenumerata – dalyviai gali pasirinkti, ar prenumeruoti
* Priverstinė prenumerata – visi turi prenumeruoti ir negali atsisakyti prenumeratos
* Automatinė prenumerata – iš pradžių visiems užsakoma prenumerata, bet jie gali pasirinkti bet kada jos atsisakyti
* Prenumeravimas išjungtas – prenumeravimas neleidžiamas';
$string['subscriptionmodeconfirm'] = 'Ar tikrai norite pakeisti prenumeratos režimą į {$a}?';
$string['subscriptionoptional'] = 'Pasirinktinė prenumerata';
$string['subscriptions'] = 'Prenumeratos';
$string['tagarea_forum_posts'] = 'Forumo skelbimai';
$string['tagsdeleted'] = 'Forumo žymos buvo ištrintos';
$string['thisforumhasduedate'] = 'Šiame forume įrašus skelbti galima iki {$a}.';
$string['thisforumisdue'] = 'Šiame forume įrašus skelbti buvo galima iki {$a}.';
$string['thisforumisthrottled'] = 'Šiame forume ribojama, kiek skelbimų galima paskelbti per nurodytą laikotarpį – šiuo metu tai {$a->blockafter} skelbimai (-ų) per {$a->blockperiod}';
$string['timed'] = 'Su laiku';
$string['timeddiscussion'] = 'Diskusija su laiku';
$string['timedhidden'] = 'Laikina būsena: Paslėpta nuo besimokančiųjų';
$string['timedposts'] = 'Skelbimai su apribotu laiku';
$string['timedvisible'] = 'Laikina būsena: Rodoma visiems naudotojams';
$string['timestartenderror'] = 'Rodoma pabaigos data negali būti ankstesnė nei pradžios data';
$string['togglediscussionmenu'] = 'Perjungti diskusijų meniu';
$string['togglefullscreen'] = 'Įjungti pilnojo ekrano režimą';
$string['togglesettingsdrawer'] = 'Perjungti nustatymų meniu';
$string['trackforum'] = 'Sekti neperskaitytus skelbimus';
$string['tracking'] = 'Sekama';
$string['trackingoff'] = 'Išjungtas';
$string['trackingon'] = 'Įjungtas';
$string['trackingoptional'] = 'Pasirinktinai';
$string['trackingtype'] = 'Ar įjungti šio forumo perskaitytų skelbimų sekimą?';
$string['trackingtype_help'] = 'Skaitymo stebėjimas leidžia dalyviams patikrinti, kurių įrašų jie dar nematė, paryškinant naujus įrašus.

Jei nustatyta kaip neprivaloma, dalyviai gali pasirinkti, ar įjungti ar išjungti forumo stebėjimą. (Naudotojai taip pat turi įjungti forumo stebėjimą savo forumo nuostatose.)

Jei svetainės administratorius įgalino „Leisti priverstinio skaitymo stebėjimą“, galimas kitas pasirinkimas – priverstinis. Tai reiškia, kad stebėjimas visada įjungtas, neatsižvelgiant į naudotojų forumo nuostatas.';
$string['trackreadposts_header'] = 'Forumo sekimas';
$string['unlockdiscussion'] = 'Neberakinti šios diskusijos';
$string['unpindiscussion'] = 'Nebesegti šios diskusijos';
$string['unread'] = 'Neperskaityta';
$string['unreadpost'] = 'Neskaitytas įrašas';
$string['unreadposts'] = 'Neperskaityti skelbimai';
$string['unreadpostsnumber'] = 'Neperskaitytų skelbimų: {$a}';
$string['unreadpostsone'] = '1 neperskaitytas skelbimas';
$string['unsubscribe'] = 'Atsisakyti forumo prenumeratos';
$string['unsubscribeall'] = 'Atsisakyti visų forumų prenumeratos';
$string['unsubscribeallconfirm'] = 'Dabar esate užsiprenumeravę {$a->forums} forumus ir {$a->discussions} diskusijas. Ar tikrai norite atsisakyti visų forumų ir diskusijų ir išjungti diskusijų automatinį prenumeravimą?';
$string['unsubscribeallconfirmdiscussions'] = 'Šiuo metu Jūs prenumeruojate {$a->discussions} diskusijas. Ar tikrai norite atsisakyti visų diskusijų prenumeratos ir išjungti diskusijų auto-prenumeratą?';
$string['unsubscribeallconfirmforums'] = 'Šiuo metu Jūs prenumeruojate {$a->forums} forumus. Ar tikrai norite atsisakyti visų forumų prenumeratos ir išjungti diskusijų auto-prenumeratą?';
$string['unsubscribealldone'] = 'Visos jūsų forumų prenumeratos buvo pašalintos. Gali būti, kad dar gausite pranešimus iš forumų, kuriuose taikoma priverstinė prenumerata. Norėdami valdyti forumo pranešimus, eikite į savo pranešimų siuntimų nuostatas iš savo profilio.';
$string['unsubscribeallempty'] = 'Apgailestaujame, nesate užsiprenumeravę jokių forumų. Jei nenorite gauti jokių el. laiškų iš šio serverio, savo profilyje išjunkite el. pašto adresą.';
$string['unsubscribed'] = 'Prenumeratos atsisakyta';
$string['unsubscribediscussion'] = 'Neprenumeruoti šios diskusijos';
$string['unsubscribediscussionlink'] = 'Atsisakyti prenumeratos diskusijai: {$a}';
$string['unsubscribelink'] = 'Atsisakyti iš šio forumo: {$a}';
$string['unsubscribeshort'] = 'Atsisakyti prenumeratos';
$string['useexperimentalui'] = 'Naudoti eksperimentinį įdėtos diskusijos rodinį';
$string['usermarksread'] = 'Rankinis perskaitytų žinučių žymėjimas';
$string['usernavigation'] = 'Naudotojo navigacija';
$string['usersforumposts'] = 'Naudotojo forumo pranešimai';
$string['viewalldiscussions'] = 'Peržiūrėti visas diskusijas';
$string['viewconversation'] = 'Peržiūrėti diskusijas';
$string['viewgrades'] = 'Žiūrėti įvertinimus';
$string['viewparentpost'] = 'Peržiūrėti pirminį įrašą';
$string['viewthediscussion'] = 'Peržiūrėti diskusiją';
$string['warnafter'] = 'Skelbimo įspėjimo slenkstis';
$string['warnafter_help'] = 'Besimokantieji gali būti įspėjami, kai bus beveik pasiekę maksimalų skelbimų, leidžiamų per nurodytą laikotarpį, skaičių. Šis parametras nurodo, po kiek skelbimų besimokantieji gaus įspėjimą. Naudotojams, turintiems galimybę mod/forum:postwithoutthrottling, skelbimų limitai netaikomi.';
$string['warnformorepost'] = 'Įspėjimas! Šiame forume yra daugiau nei viena diskusija, naudojama paskiausia';
$string['yournewquestion'] = 'Jūsų naujas klausimas';
$string['yournewtopic'] = 'Jūsų nauja diskusijų tema';
$string['yourreply'] = 'Jūsų atsakymas';
