<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_cas', language 'da', version '4.2'.
 *
 * @package     auth_cas
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['CASform'] = 'Godkendelsesvalg';
$string['auth_cas_auth_logo'] = 'Logo til godkendelsesmetode';
$string['auth_cas_auth_logo_description'] = 'Upload et for dine brugere genkendeligt logo til CAS-godkendelse.';
$string['auth_cas_auth_name'] = 'Navn til godkendelsesmetode';
$string['auth_cas_auth_name_description'] = 'Angiv et for dine brugere genkendeligt navn til CAS-godkendelse.';
$string['auth_cas_auth_service'] = 'CAS';
$string['auth_cas_auth_user_create'] = 'Opret brugere eksternt';
$string['auth_cas_baseuri'] = 'CAS-serverens URI<br />Hvis for eksempel CAS-serveren svarer på host.domain.dk/CAS/, skal der stå<br />cas_basedir = CAS/';
$string['auth_cas_baseuri_key'] = 'Base URI';
$string['auth_cas_broken_password'] = 'Du kan ikke fortsætte uden at ændre din kode, imidlertid er der ingen side at gøre det på. Kontakt din Moodle-admin';
$string['auth_cas_cantconnect'] = 'LDAP-delen af CAS-modulet kan ikke forbinde til serveren: {$a}';
$string['auth_cas_casversion'] = 'CAS-protokol version';
$string['auth_cas_certificate_check'] = 'Vælg "Ja", hvis du ønsker at validere servercertifikatet';
$string['auth_cas_certificate_check_key'] = 'Servervalidering';
$string['auth_cas_certificate_path'] = 'Sti til filen med CA-kæde (PEM-format) til validering af servercertifikat';
$string['auth_cas_certificate_path_empty'] = 'Hvis du slår Servervalidering til, skal du angive en certifikatsti';
$string['auth_cas_certificate_path_key'] = 'Certifikatsti';
$string['auth_cas_changepasswordurl'] = 'URL til skift af adgangskode';
$string['auth_cas_create_user'] = 'Aktiver denne indstilling, hvis du ønsker at indsætte brugere der er CAS-godkendte i Moodles database. Ellers er det kun brugere der er godkendt i Moodle, der kan logge ind.';
$string['auth_cas_create_user_key'] = 'Opret bruger';
$string['auth_cas_curl_ssl_version'] = 'Den SSL-version (2 eller 3) der skal bruges. Som standard vil PHP prøve at vælge selv, men nogle gange skal det gøres manuelt.';
$string['auth_cas_curl_ssl_version_SSLv2'] = 'SSLv2';
$string['auth_cas_curl_ssl_version_SSLv3'] = 'SSLv3';
$string['auth_cas_curl_ssl_version_TLSv10'] = 'TLSv1.0';
$string['auth_cas_curl_ssl_version_TLSv11'] = 'TLSv1.1';
$string['auth_cas_curl_ssl_version_TLSv12'] = 'TLSv1.2';
$string['auth_cas_curl_ssl_version_TLSv1x'] = 'TLSv1.x';
$string['auth_cas_curl_ssl_version_default'] = 'Standard';
$string['auth_cas_curl_ssl_version_key'] = 'cURL SSL-version';
$string['auth_cas_enabled'] = 'Aktiver denne indstilling hvis du ønsker at benytte CAS-godkendelse.';
$string['auth_cas_hostname'] = 'Værtsnavn for CAS-server<br />F.eks: host.domain.dk';
$string['auth_cas_hostname_key'] = 'Værtsnavn';
$string['auth_cas_invalidcaslogin'] = 'Desværre, dit login mislykkedes - du kunne ikke godkendes.';
$string['auth_cas_language'] = 'Vælg sprog til godkendelsessider';
$string['auth_cas_language_key'] = 'Sprog';
$string['auth_cas_logincas'] = 'Benyt sikker forbindelse';
$string['auth_cas_logout_return_url'] = 'Skriv den URL CAS-brugere skal omdirigeres til efter de er logget ud.<br />Efterlades feltet tomt, vil brugere omdirigeres til den lokation Moodle omdirigerer brugere til.';
$string['auth_cas_logoutcas'] = 'Vælg "Ja" hvis du vil logge ud af CAS når du afbryder forbindelsen til Moodle.';
$string['auth_cas_logoutcas_key'] = 'CAS\' logout-indstilling';
$string['auth_cas_multiauth'] = 'Vælg "Ja" hvis du vil have flerstrenget godkendelse (CAS + anden godkendelse)';
$string['auth_cas_multiauth_key'] = 'Multi-godkendelse';
$string['auth_cas_port'] = 'CAS-serverens port';
$string['auth_cas_port_key'] = 'Port';
$string['auth_cas_proxycas'] = 'Vælg "Ja" hvis du vil bruge CAS i proxy-tilstand';
$string['auth_cas_proxycas_key'] = 'Proxy-tilstand';
$string['auth_cas_server_settings'] = 'CAS-serverens konfiguration';
$string['auth_cas_text'] = 'Sikker forbindelse';
$string['auth_cas_use_cas'] = 'Brug CAS';
$string['auth_cas_version'] = 'CAS-protokolversion at bruge';
$string['auth_casdescription'] = 'Denne metode benytter en CAS-server (Central Authentication Service) til at godkende brugere i et SSO (Single Sign On) -miljø. Du kan også benytte en simpel LDAP-godkendelse. Hvis brugernavn og adgangskode er gyldige ifølge CAS, opretter Moodle en ny brugerprofil i databasen om nødvendigt med bruger-attributter fra LDAP. Efterfølgende er det kun brugernavn og adgangskode der bliver kontrolleret.';
$string['auth_casnotinstalled'] = 'Kan ikke bruge CAS-godkendelse. PHP\'s LDAP-modul er ikke installeret.';
$string['noldapserver'] = 'Der er ikke konfigureret en LDAP-server til CAS! Synkronisering deaktiveret.';
$string['pluginname'] = 'Benyt en CAS-server (SSO)';
$string['privacy:metadata'] = 'Godkendelsesplugin\'et CAS server (SSO) gemmer ingen personlige data.';
$string['synctask'] = 'CAS\'s brugersynkroniseringsjob';
