<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'es_mx', version '4.2'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Contenido Acerca de nosotros';
$string['aboutuscontentsetting_desc'] = 'En esta configuración, usted puede añadir contenido de texto enriquecido que será mostrado en la página de \'Acerca de nosotros\'.';
$string['aboutusdisabled'] = 'La página de \'Acerca de nosotros\' está deshabilitada para este sitio. Aquí no hay nada que ver.';
$string['aboutusheading'] = 'Acerca de nosotros';
$string['aboutuslinkpositionboth'] = 'Añadir un enlace a la página \'Acerca de nosotros\' a la nota al pie y al ícono (signo de ?) del pie de página';
$string['aboutuslinkpositionfooter'] = 'Añadir un enlace a la página \'Acerca de nosotros\' al ícono (signo de ?) en el pie de página';
$string['aboutuslinkpositionfootnote'] = 'Añadir un enlace a la página \'Acerca de nosotros\' a la nota al pie';
$string['aboutuslinkpositionnone'] = 'No mostrar automáticamente un enlace a la página \'Acerca de nosotros\'';
$string['aboutuslinkpositionsetting'] = 'Posición del enlace a \'Acerca de nosotros\'';
$string['aboutuslinkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace hacia la página de \'Acerca de nosotros\'  debería ser añadido automáticamente a la página de Moodle. Si usted no quiere mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia {$a->url} desde cualquier lugar en Moodle.';
$string['aboutuspagetitledefault'] = 'Acerca de nosotros';
$string['aboutuspagetitlesetting'] = 'Título de la página Acerca de nosotros';
$string['aboutuspagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página \'Acerca de nosotros\'. Este texto será usado como texto del enlace a la página de \'Acerca de nosotros\' además si usted configura apropiadamente \'Posición de enlace a página de Acerca de nosotros\'.';
$string['activitybrandingtab'] = 'Marcado personalizado de actividad';
$string['activityiconcoloradministrationsetting'] = 'Color del ícono de actividad para "Administración"';
$string['activityiconcoloradministrationsetting_desc'] = 'El color del ícono de actividad para "Administración"';
$string['activityiconcolorassessmentsetting'] = 'Color del ícono de actividad para "Evaluación"';
$string['activityiconcolorassessmentsetting_desc'] = 'El color del ícono de actividad para "Evaluación"';
$string['activityiconcolorcollaborationsetting'] = 'Color del ícono de actividad para "Colaboración"';
$string['activityiconcolorcollaborationsetting_desc'] = 'El color del ícono de actividad para "Colaboración"';
$string['activityiconcolorcommunicationsetting'] = 'Color del ícono de actividad para "Comunicación"';
$string['activityiconcolorcommunicationsetting_desc'] = 'El color del ícono de actividad para "Comunicación"';
$string['activityiconcolorcontentsetting'] = 'Color del ícono de actividad para "Contenido"';
$string['activityiconcolorcontentsetting_desc'] = 'El color del ícono de actividad para "Contenido"';
$string['activityiconcolorinterfacesetting'] = 'Color del ícono de actividad para "Interfaz"';
$string['activityiconcolorinterfacesetting_desc'] = 'El color del ícono de actividad para "Interfaz"';
$string['activityiconcolorsheading'] = 'Colores de ícono de actividad';
$string['activitynavigationsetting'] = 'Elementos de navegación de actividad';
$string['activitynavigationsetting_desc'] = 'Con esta configuración son mostrados los elementos para saltar a la actividad/recurso siguiente y anterior, y el menú desplegable para saltar a una actividad/recurso distinto. Los elementos de la interfaz del usuario similares a esto ya existían en Boost en el Moodle estándar hasta Moodle 3.11, pero fueron eliminados en 4.0. Con Boost Union, usted puede volver a tenerlos.';
$string['activitypurposeadministration'] = 'Administración';
$string['activitypurposeassessment'] = 'Evaluación';
$string['activitypurposecollaboration'] = 'Colaboración';
$string['activitypurposecommunication'] = 'Comunicación';
$string['activitypurposecontent'] = 'Contenido';
$string['activitypurposeheading'] = 'Propósitos de ícono de actividad';
$string['activitypurposeheading_desc'] = 'Con estas configuraciones, usted puede anular el color del fondo del ícono de actividad, el cual está definido por el propósito de la actividad (y que es una característica fijada del plugin en cada actividad).';
$string['activitypurposeheadingtechnote'] = 'Nota técnica: Debido a la manera en la que el núcleo de Moodle implementa los propósitos de la actividad y sus colores. los propósitos de la actividad solamente son sobre-escritos con CSS por Boost Union. Actualmente, todas las áreas en el núcleo de Moodle que muestran íconos de actividad coloreados deberían de estar cubiertas. Si usted observa cualquier área o plugin de terceros que continúa mostrando los colores del propósito de la actividad sin cambios, por favor repórtelo a {$a}.';
$string['activitypurposeinterface'] = 'Interfaz';
$string['activitypurposeother'] = 'Otro';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistente)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (revisada)';
$string['additionalresourcesheading'] = 'Recursos adicionales';
$string['additionalresourceslistsetting'] = 'Lista de recursos adicionales';
$string['additionalresourceslistsetting_desc'] = 'Esta es la lista de archivos que usted ha subido al área de archivos de recursos adicionales. Las URLS dadas pueden ser usadas para enlazar a estos archivos desde adentro de su CSS personalizado, desde la nota al pie, o desde cualquier lugar en donde usted necesite usar archivos subidos pero que no pueda subirlos.';
$string['additionalresourcessetting'] = 'Recursos adicionales';
$string['additionalresourcessetting_desc'] = 'Con esta configuración usted puede subir recursos adicionales al tema. La ventaja de subir archivos a esta área es que esos archivos pueden ser proporcionados sin una comprobación de que el usuario esté ingresado al sitio. Esto es también la razón por la cual usted solamente debería de añadir archivos que NO SON  críticos y a los cuales todos deberían de tener permitido acceder y que no necesitan estar protegidos con un ingreso válido al sitio. Tan pronto como usted haya subido al menos un archivo a esta área de archivos y haya guardado la configuración, aparecerá una lista debajo que le dará la URL que usted puede usar para referenciar un archivo particular.';
$string['addpreferredlangsetting'] = 'Añadir enlace a idioma preferido al menú de idiomas';
$string['addpreferredlangsetting_desc'] = 'Con esta configuración usted puede añadir una configuración de  \'Configurar idioma preferido\' al menú del idioma dentro del menú del usuario. Comprensiblemente, esta configuración solamente es procesada si la configuración para <a href="{$a->url1}">Mostrar menú de idioma</a> está habilitada, y al menos <a href="{$a->url2}">un segundo paquete de idioma está instalado</a> y <a href="{$a->url3}">es ofrecido para seleccionar</a>.';
$string['administrationtab'] = 'Administración';
$string['alternativelogolinkurlsetting'] = 'URL de enlace de logo alternativo';
$string['alternativelogolinkurlsetting_desc'] = 'Con esta configuración usted puede poner una URL de enlace alternativo que será usado como enlace en el logo de la barra de navegación. Usted puede usar esta configuración, por ejemplo,enlazar al sitio web se su organización en lugar de la Portada de Moodle, para mantener una barra de navegación homogénea en todos los sistemas de su organización.';
$string['backgroundimagepositionsetting'] = 'Posición de imagen del fondo';
$string['backgroundimagepositionsetting_desc'] = 'Con esta configuración, usted controla la posición de la imagen del fondo dentro de la ventana del navegador. El primer valor es la posición horizontal, el segundo valor es la posición vertical.';
$string['backgroundimagesetting'] = 'Imagen del fondo';
$string['backgroundimagesetting_desc'] = 'Aquí puede usted subir una imagen personalizada para mostrar como fondo del sitio. La imagen del fondo que usted suba sobre-escribirá la imagen del fondo en los archivos de su pre-configuración del tema.';
$string['backgroundimagesheading'] = 'Imágenes del fondo general';
$string['backtotop'] = 'Regresar a Superior';
$string['backtotopbuttonsetting'] = 'Botón para Regresar a Superior';
$string['backtotopbuttonsetting_desc'] = 'Con esta configuración, aparecerá un botón para regresar a superior en la esquina inferior derecha de la página tan pronto como el usuario se desplace a la parte inferior de la página. Un botón como este ya existía en Boost en el Moodle estándar hasta Moodle 3.11, pero fue eliminado en Moodle 4.0. Con Boost Union usted puede tenerlo de regreso..';
$string['blockdrawerwidthsetting'] = 'Ancho del cajón de bloque';
$string['blockdrawerwidthsetting_desc'] = 'Con esta configuración usted puede anular el ancho del cajón de bloque de Moodle sin modificaciones manuales de SCSS. de forma predeterminada Moodle usa un ancho máximo del contenido de enmedio de 315px. Usted puede ingresar otros valores basados en pixeles como 400p, pero valores con otras unidades como valores basados en porcentajes o valores de ancho del puerto de vista NO funcionarán.';
$string['blockregionfooterwidth'] = 'Ancho de la región de bloque para región de \'Pie de página\'';
$string['blockregionfooterwidth_desc'] = 'Con esta configuración, usted puede configurar el ancho de la región del bloque \'Pie de página\'. Usted puede elegir entre ancho completo, ancho del contenido del curo y ancho heroico.';
$string['blockregionoutsidebottomwidth'] = 'Ancho de región de bloque \'Afuera (inferior)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Con esta configuración usted puede configurar el ancho de la región del bloque \'Afuera (fondo) que es mostrado debajo del contenido principal. Usted puede elegir entre ancho completo, contenido del curo y ancho heroico.';
$string['blockregionoutsideleftwidth'] = 'Ancho de región de bloque \'Afuera (izquierda)\'';
$string['blockregionoutsideleftwidth_desc'] = 'Con esta configuración usted puede configurar el ancho de la región del bloque \'Afuera (izquierda) que es mostrada en el lado izquierdo del área principal de contenido. Boost Union usa un ancho de 300px. Usted puede escribir otros valores en pixeles como por ejemplo 200px. pero también puede ingresar un valor basado en porcentaje como 10% o un valor de ancho del punto de vista como 10vw.';
$string['blockregionoutsiderightwidth'] = 'Ancho de región de bloque \'Afuera (derecha)\'';
$string['blockregionoutsiderightwidth_desc'] = 'Con esta configuración usted puede configurar el ancho de la región del bloque \'Afuera (derecha) que es mostrada en el lado derecho del área principal de contenido. Boost Union usa un ancho de 300px. Usted puede escribir otros valores en pixeles como por ejemplo 200px. pero también puede ingresar un valor basado en porcentaje como 10% o un valor de ancho del punto de vista como 10vw.';
$string['blockregionoutsidetopwidth'] = 'Ancho de región de bloque \'Afuera (superior)\'';
$string['blockregionoutsidetopwidth_desc'] = 'Con esta configuración usted puede configurar el ancho de la región del bloque \'Afuera (superior) que es mostrada en la parte más superior de la página. Usted puede elegir entre ancho completo, contenido del curo y ancho heroico.';
$string['blockregionsforlayout'] = 'Regiones de bloque adicionales para el diseño \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Con esta configuración, usted puede habilitar regiones de bloque adicionales para el diseño \'{$a}\'.';
$string['blockregionsheading'] = 'Regiones de bloque adicionales';
$string['blockregionsheading_desc'] = '<p>Boost Union proporciona una gran cantidad de regiones de bloques adicionales que se pueden usar para agregar y mostrar bloques en toda la página de Moodle:</p>
<ul><li>Las <em>regiones del bloque Exterior</em> se colocan en los cuatro lados de la página de Moodle. Se pueden utilizar para mostrar bloques que acompañan a la página de Moodle mostrada pero que no pertenecen directamente al contenido principal.</li>
<li>La <em>región del bloque del Encabezado</em> se coloca entre el área Exterior (superior) y el área de contenido principal. Se puede utilizar para mostrar un bloque como información del encabezado del curso.
<li>Las <em>regiones de bloques de Contenido</em> se colocan directamente encima y debajo del contenido principal en el área de contenido principal. Se pueden utilizar para agregar bloques al flujo de contenido del curso.</li>
<li>Las <em>regiones del bloque de Pie de página</em> se colocan en la parte inferior de la página, entre el área Exterior (inferior) y el Pie de página. Tiene tres regiones de pie de página disponibles para crear columnas si fuera necesario.</li>
<li>La <em>región del bloque Fuera-del-lienzo</em> es de alguna manera especial, ya que se desplaza sobre toda la página de Moodle como un cajón. El cajón se abre mediante el ícono de 9 puntos en el lado derecho de la barra de navegación. Tienes tres regiones Fuera del lienzo disponibles para crear columnas si fuera necesario.</li></ul>
<p>Por favor tenga en cuenta:</p>
<ul><li>De forma predeterminada, todas las regiones de bloqueo adicionales están deshabilitadas. Habilite las regiones de bloqueo particulares en los diseños de página particulares de acuerdo con sus necesidades. Intente concentrarse lo más posible: demasiadas regiones de bloque podrían abrumar a los usuarios finales.</li>
<li>Tan pronto como se habilita una región de bloque adicional, es visible para todos los usuarios autenticados y es editable por profesores y administradores (dependiendo de si el usuario en particular tiene permiso para editar la página de Moodle en particular, por supuesto). Pero también hay capacidades theme/boost_union:viewregion* y theme/boost_union:editregion* que le permiten ajustar el uso de cada región de bloque según sus necesidades.
<li>Las regiones de bloque Exterior (izquierda), Exterior (derecha), Contenido (superior), Contenido (inferior) y Encabezado no están disponibles para todos los diseños de página.</li></ul>';
$string['blockregionsheading_experimental'] = 'Por favor tenga en cuenta: Las regiones de bloque <em>Afuera (izquierda) y Afuera (derecha)  </em> están funcionando totalmente en el estado actual de implementación, pero tienen que ser <em>consideradas como experimentales</em> porque aun no cubren apropiadamente en pantallas de ancho medio. Contra este fondo, por favor úselas con cuidado. Este problema será corregido en una futura versión próxima.';
$string['blocksgeneralheading'] = 'Bloques generales';
$string['blockstab'] = 'Bloques';
$string['boost_union:configure'] = 'Poder configura el tema como no-admin';
$string['boost_union:editregioncontentlower'] = 'Poder editar la región del bloque del Contenido (inferior)';
$string['boost_union:editregioncontentupper'] = 'Poder editar la región del bloque del Contenido (superior)';
$string['boost_union:editregionfootercenter'] = 'Poder editar la región del bloque del Pie de página (centro)';
$string['boost_union:editregionfooterleft'] = 'Poder editar la región del bloque del Pie de página (izquierda)';
$string['boost_union:editregionfooterright'] = 'Poder editar la región del bloque del Pie de página (derecha)';
$string['boost_union:editregionheader'] = 'Poder editar la región del bloque del Encabezado';
$string['boost_union:editregionoffcanvascenter'] = 'Poder editar la región del bloque de Afuera-del-lienzo (centro)';
$string['boost_union:editregionoffcanvasleft'] = 'Poder editar la región del bloque de Afuera-del-lienzo (izquierda)';
$string['boost_union:editregionoffcanvasright'] = 'Poder editar la región del bloque de Afuera-del-lienzo (derecha)';
$string['boost_union:editregionoutsidebottom'] = 'Poder editar la región del bloque del Afuera (inferior)';
$string['boost_union:editregionoutsideleft'] = 'Poder editar la región del bloque del Afuera (izquierda)';
$string['boost_union:editregionoutsideright'] = 'Poder editar la región del bloque del Afuera (derecha)';
$string['boost_union:editregionoutsidetop'] = 'Poder editar la región del bloque del Afuera (superior)';
$string['boost_union:viewhintcourseselfenrol'] = 'Poder ver una pista para auto inscripción irrestricta en un curso visible.';
$string['boost_union:viewhintinhiddencourse'] = 'Poder ver una pista en un curso oculto.';
$string['boost_union:viewregioncontentlower'] = 'Poder ver la región del bloque del Contenido (inferior)';
$string['boost_union:viewregioncontentupper'] = 'Poder ver la región del bloque del Contenido (superior)';
$string['boost_union:viewregionfootercenter'] = 'Poder ver la región del bloque del Pie de página (centro)';
$string['boost_union:viewregionfooterleft'] = 'Poder ver la región del bloque del Pie de página (izquierda)';
$string['boost_union:viewregionfooterright'] = 'Poder ver la región del bloque del Pie de página (derecha)';
$string['boost_union:viewregionheader'] = 'Poder ver la región del bloque del Encabezado';
$string['boost_union:viewregionoffcanvascenter'] = 'Poder ver la región del bloque de Afuera-del-lienzo (centro)';
$string['boost_union:viewregionoffcanvasleft'] = 'Poder ver la región del bloque de Afuera-del-lienzo (izquierda)';
$string['boost_union:viewregionoffcanvasright'] = 'Poder ver la región del bloque de Afuera-del-lienzo (derecha)';
$string['boost_union:viewregionoutsidebottom'] = 'Poder ver la región del bloque de Afuera (inferior)';
$string['boost_union:viewregionoutsideleft'] = 'Poder ver la región del bloque de Afuera (izquierda)';
$string['boost_union:viewregionoutsideright'] = 'Poder ver la región del bloque de Afuera (derecha)';
$string['boost_union:viewregionoutsidetop'] = 'Poder ver la región del bloque de Afuera (superior)';
$string['bootstrapcolordangersetting'] = 'Color Bootstrap para "Peligro"';
$string['bootstrapcolordangersetting_desc'] = 'El color Bootstrap para "Peligro"';
$string['bootstrapcolorinfosetting'] = 'Color Bootstrap para "Info"';
$string['bootstrapcolorinfosetting_desc'] = 'El color Bootstrap para "Info"';
$string['bootstrapcolorsheading'] = 'Colores Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Color Bootstrap para "Éxito"';
$string['bootstrapcolorsuccesssetting_desc'] = 'El color Bootstrap para "Éxito"';
$string['bootstrapcolorwarningsetting'] = 'Color Bootstrap para "Advertencia"';
$string['bootstrapcolorwarningsetting_desc'] = 'El color Bootstrap para "Advertencia"';
$string['bootstrapdangercolor'] = 'Color de peligro';
$string['bootstrapdarkcolor'] = 'Color oscuro';
$string['bootstrapinfocolor'] = 'Color de información';
$string['bootstraplightcolor'] = 'Color claro';
$string['bootstrapnone'] = 'Sin color Bootstrap';
$string['bootstrapprimarycolor'] = 'Color primario';
$string['bootstrapsecondarycolor'] = 'Color secundario';
$string['bootstrapsuccesscolor'] = 'Color de éxito';
$string['bootstrapwarningcolor'] = 'Color de advertencia';
$string['brandcolorsheading'] = 'Color de la marca';
$string['breadcrumbsheading'] = 'Camino de migajas';
$string['cachedef_flavours'] = 'Sabores que aplican a una ID de categoría de página dada para el usuario actual';
$string['cachedef_smartmenu_items'] = 'elementos del menú inteligente';
$string['cachedef_smartmenus'] = 'Menúes inteligentes';
$string['cachedef_touchiconsios'] = 'Archivos de ícono táctil para iOS';
$string['categorybreadcrumbs'] = 'Mostrar el camino de migajas de categoría en el encabezado del curso';
$string['categorybreadcrumbs_desc'] = 'De forma predeterminada, la pista de migas de pan de categoría del curso  no es mostrada en páginas del curso en el encabezado del curso. con esta configuración, usted puede mostrar las migas de pan d la categoría del curso en el encabezado del curso arriba del nombre del curso.';
$string['choosereadme'] = 'El tema Boost Union es un tema mejorado hijo de Boost que, por un lado, hace más fácilmente configurable Boost, y por otra parte, proporcionar características adicionales útiles para la operación diaria de administradores, profesores y estudiantes.</p><p>Boost Union es mantenido por<br />Moodle an Hochschulen e.V.,</p><p>en cooperación con<br />lern.link GmbH</p><p>tjunto con<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Cerrar cajón Afuera-del-lienzo';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Contenido';
$string['configtitlefeel'] = 'Sensación';
$string['configtitleflavours'] = 'Sabores';
$string['configtitlefunctionality'] = 'Funcionalidad';
$string['configtitlelook'] = 'Aspecto';
$string['contactcontentsetting'] = 'Contenido de página de contacto';
$string['contactcontentsetting_desc'] = 'En esta configuración, usted puede añadir contenido de texto enriquecido que será mostrado en una página para contacto (que no es la misma que la página incluida en Moodle de "Ponerse en contacto con soporte del sitio").';
$string['contactdisabled'] = 'La página de contacto está deshabilitada para este sitio. Aquí no hay nada para ver.';
$string['contactheading'] = 'Contacto';
$string['contactlinkpositionboth'] = 'Añadir un enlace a la página de contacto a la nota al pie y al ícono del pie de página (signo de interrogación)';
$string['contactlinkpositionfooter'] = 'Añadir un enlace a la página de contacto al ícono del pie de página (signo de interrogación)';
$string['contactlinkpositionfootnote'] = 'Añadir un enlace a la página de contacto de la nota al pie';
$string['contactlinkpositionnone'] = 'No mostrar automáticamente un enlace a la página de contacto';
$string['contactlinkpositionsetting'] = 'Posición del enlace de página de contacto';
$string['contactlinkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que debería ser añadido automáticamente o no un enlace a la página de contacto a la página de Moodle. Si usted no quiere mostrar automáticamente un enlace, usted puede añadir manualmente un enlace a {$a->url} desde cualquier lugar en Moodle.';
$string['contactpagetitledefault'] = 'Contacto';
$string['contactpagetitlesetting'] = 'Título de página de contacto';
$string['contactpagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página de contacto. Este texto será usado como texto de enlace hacia la página de contacto también si usted configura apropiadamente \'Posición de enlace de página de contacto\'.';
$string['contentwidthheading'] = 'Ancho del contenido';
$string['coursecontentmaxwidthsetting'] = 'Ancho máximo de contenido del curso';
$string['coursecontentmaxwidthsetting_desc'] = 'Con esta configuración, usted puede anular el ancho del contenido del curso de Moodle sin modificaciones manuales de SCSS. Este ancho es usado como el ancho de la página de las páginas de curso y dentro de ciertas actividades. de forma predeterminada, Moodle usa un ancho máximo de contenido del curso de 830 px. Usted puede ingresar ya sea valores en pixeles como 1200px, pero también puede ingresar un valor basado en porcentaje como 100%, o un valor de ancho del portal de vista como 90vw.';
$string['courseheaderheading'] = 'Encabezado  del curso';
$string['courseheaderimageenabled'] = 'Mostrar la imagen del curso en el encabezado del curso';
$string['courseheaderimageenabled_desc'] = 'Cuando se habilita, la imagen del curso (la cual puede ser subida en las configuraciones del curso) es mostrada en el encabezado de un curso. Las imágenes del curso son mostradas allí adicionalmente a la página de \'Mis cursos\' donde siempre  son mostradas.';
$string['courseheaderimagefallback'] = 'Imagen de reserva del encabezado del curso';
$string['courseheaderimagefallback_desc'] = 'Si usted sube una imagen en esta configuración, es usada como imagen en caso de necesidad y es mostrada en el encabezado del curso cuando no se ha subido una imagen del curso en las configuraciones de un curso en particular. Si usted no sube una imagen aquí, una imagen del encabezado del curso solamente es mostrada en un curso particular si una imagen de curso es subida en estas configuraciones de este curso en particular.';
$string['courseheaderimageheight'] = 'Altura de imagen del encabezado del curso';
$string['courseheaderimageheight_desc'] = 'Con esta configuración usted controla la altura de la imagen del encabezado del curso presentado.';
$string['courseheaderimagelayout'] = 'Diseño de imagen de encabezado del curso';
$string['courseheaderimagelayout_desc'] = 'Con esta configuración, usted controla el diseño de la imagen del encabezado del curso y el título del curso.';
$string['courseheaderimagelayoutheadingabove'] = 'Título del curso arriba de la imagen del curso';
$string['courseheaderimagelayoutstackeddark'] = 'Título del curso apilado sobre la imagen del curso (color blanco de font para imágenes de fondo oscuras)';
$string['courseheaderimagelayoutstackedlight'] = 'Titulo del curso apilado sobre la imagen del curso (color negro del font para imágenes claras del fondo)';
$string['courseheaderimageposition'] = 'Posición de la imagen del encabezado del curso';
$string['courseheaderimageposition_desc'] = 'Con esta configuración, usted controla la posición de la imagen del encabezado del curso dentro del contenedor de la imagen del encabezado del curso. El primer valor es la posición horizontal, el segundo valor es la posición vertical.';
$string['courseindexcompletioninfoposition'] = 'Posición de indicación de finalización de actividad';
$string['courseindexcompletioninfoposition_desc'] = 'Elegir la posición en donde la indicación de finalización es mostrada. <em>Fin de línea</em> muestra el indicador estándar de finalización al final de la línea de la fila del índice del curso. <em>Inicio de línea</em> muestra el indicador estándar de finalización al inicio de la fila del índice del curso.  <em>Color del ícono</em> NO muestra el indicador estándar de finalización, pero codifica la información de finalización como fondo del ícono del módulo del curso.';
$string['courseindexcompletioninfopositionendofline'] = 'Fin de línea';
$string['courseindexcompletioninfopositioniconcolor'] = 'Color del ícono';
$string['courseindexcompletioninfopositionstartofline'] = 'Inicio de línea';
$string['courseindexdrawerwidthsetting'] = 'Ancho del cajón del índice del curso';
$string['courseindexdrawerwidthsetting_desc'] = 'Con esta configuración usted puede anular el ancho del cajón del índice del curso de Moodle sin modificaciones manuales de SCSS. de forma predeterminada Moodle usa un ancho máximo del índice del curso de 285px. Usted puede ingresar otros valores basados en pixeles como 320p, pero valores con otras unidades como valores basados en porcentajes o valores de ancho del puerto de vista NO funcionarán.';
$string['courseindexheading'] = 'Índice del curso';
$string['courseindexmodiconenabled'] = 'Mostrar íconos de tipo de actividad en el índice del curso';
$string['courseindexmodiconenabled_desc'] = 'Cuando se habilita, el ícono del tipo de actividad correspondiente es mostrado enfrente de la fila del índice con el título de la actividad. Al hacer esto, el tipo de actividad del curso está, ya sea reemplazando al indicador de finalización del curso, el cual es movido desde el frente al final de la línea de columna del índice del curso, o está coloreado por el color del estado de finalización.';
$string['coursemanagementheading'] = 'Gestión del curso';
$string['courseoverviewheading'] = 'Bloque de vista general del curso';
$string['courseoverviewshowcourseimagessetting'] = 'Mostrar imágenes del curso';
$string['courseoverviewshowcourseimagessetting_desc'] = 'Con esta configuración usted controla si es que la imagen del curso es visible o no adentro del bloque de Vista general del curso. Es posible elegir una configuración diferente para Vista en tarjeta, Vista resumen y Vista en Lista.';
$string['courseoverviewshowprogresssetting'] = 'Mostrar progreso de finalización del curso';
$string['courseoverviewshowprogresssetting_desc'] = 'con esta configuración usted puede controlar si es que el progreso de finalización del curso es visible o no dentro del bloque de vista general del curso.';
$string['courserelatedhintsheading'] = 'Pistas relacionadas con el curso';
$string['coursestab'] = 'Cursos';
$string['coursetab'] = 'Curso';
$string['cssh5pheading'] = 'CSS crudo para H5P';
$string['cssh5psetting'] = 'CSS crudo para H5P';
$string['cssh5psetting_desc'] = 'Use este campo para proporcionar código CSS que será aplicado a la presentación de contenido H5P por mod_h5p y mod_hvp. Por favor inspeccione los tipos de contenido H5P para encontrar los selectores CSS necesarios.ectors.';
$string['customfontsfileurlpersistent'] = 'URL (persistente)';
$string['customfontsfileurlrevisioned'] = 'URL (revisada)';
$string['customfontsheading'] = 'Fonts personalizados';
$string['customfontslistsetting'] = 'Lista de fonts personalizados';
$string['customfontslistsetting_desc'] = 'Esta es la lista de fonts (tipos de letra) que usted ha subido a el área de archivos de fonts personalizados. Los fragmentos de código CSS dados pueden ser usados para añadir estos fonts a su SCSS personalizado. Por favor tenga en cuenta que usted tendrá que tener cuidado del valor del formato del font además de la familia del font, el estilo del font y la ponderación del font en las propiedades del CSS porque actualmente Boost Union no puede analizar el contenido de los archivos de font.';
$string['customfontssetting'] = 'Fonts personalizados';
$string['customfontssetting_desc'] = 'Con esta configuración usted puede subir fonts personalizados al tema. La ventaja de subir fonts a esta área de archivos es que estos fonts pueden ser entregados sin una comprobación acerca de que el usuario estuviera o no ingresado y los fonts instalados localmente pueden ser usados en cualquier parte del sitio. Tan pronto como usted haya subido al menos un font a esta área de archivos y haya guardado las configuraciones, aparecerá una lista debajo la cual le dará pequeños fragmentos de código CSS que usted puede usar como una plantilla de muestra para referencia a fonts particulares en su SCSS personalizado.';
$string['dashboardtab'] = 'Tablero / Mis cursos';
$string['dontchange'] = 'No cambiar nada';
$string['drawerwidthheading'] = 'Ancho del cajón';
$string['emailbrandinghtmldemobody'] = '<p>E-Mail inicia aquí.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Aquí termina E-Mail body.</p>';
$string['emailbrandinghtmlheading'] = 'Previsualización de E-mail HTML';
$string['emailbrandinghtmlintro'] = 'Esta es una pre-visualización de un E-mail HTML  basado en los prefijos y sufijos del marcado personalizado que están actualmente configurados en el paquete de idioma.';
$string['emailbrandinghtmlnopreview'] = 'Hasta ahora, los E-mails en HTML no han sido personalizados dentro de esta característica. Los E-mails serán compuestos y enviados normalmente.';
$string['emailbrandinginstruction'] = 'Cómo';
$string['emailbrandinginstruction0'] = 'Con esta característica de Boost Union usted puede aplicar personalización de su marca a todos los E-mails que Moodle esté enviando.';
$string['emailbrandinginstructionli1'] = 'Vaya a la <a href="{$a->url}" target="_blank">página de configuraciones de la personalización del idioma</a> para abrir el paquete del idioma <em>{$a->lang}</em> para editarlo.';
$string['emailbrandinginstructionli2'] = 'Buscar y modificar estas cadenas de caracteres en el paquete de idioma para <code>theme_boost_union</code> :';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Este cachito será añadido <em>al principio / antes del body</em> de todos los <em>E-mails en HTML</em> que Moodle esté enviando.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Este cachito será añadido <em>al final de / después del body</em> de todos los <em>E-mails HTML</em> que Moodle esté enviando.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Este cachito será añadido <em>al principio de / antes del body</em> de todos los <em>E-mails en texto simple</em> que Moodle esté enviando.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Este cachito será añadido <em>al final de / después del body</em> de todos los <em>E-mails en texto simple</em> que Moodle esté enviando.';
$string['emailbrandinginstructionli3'] = 'Guardar los cambios al paquete de idioma';
$string['emailbrandinginstructionli4'] = 'Regrese a esta página y échele un ojo a las vistas previas de E-mail debajo.';
$string['emailbrandingintroheading'] = 'Introducción';
$string['emailbrandingintronote'] = 'Por favor tenga en cuenta: Esta es una funcionalidad avanzada que usa algunos trucos para proporcionar opciones de marcado personalizado del E-mail. Por favor siga las instrucciones de cerca.';
$string['emailbrandingpitfalls'] = 'Riesgos';
$string['emailbrandingpitfalls0'] = 'Usando esta característica, hay algunas desventajas que usted debería de conocer:';
$string['emailbrandingpitfallsli1'] = 'Es necesario que usted modifique las cadenas de texto del idioma del <em>idioma predeterminado actual</em> de este sitio. Aun y cuando usted tuviera varios paquetes de idioma instalados, solamente tendrán un efecto los cambios al idioma predeterminado.';
$string['emailbrandingpitfallsli2'] = 'El respetar el idioma del destinatario no es posible. Así pues, usted debería de usar términos agnósticos del idioma dentro de sus textos de marcado personalizado de "snippets" (fragmentitos de código) del E-mail.';
$string['emailbrandingpitfallsli3'] = 'Si usted alguna vez cambia el idioma predeterminado del sitio en el futuro, usted tendrá que migrar las cadenas de texto del paquete de idioma modificadas al nuevo paquete de idioma predeterminado.';
$string['emailbrandingpitfallsli4'] = 'En E-mails de texto plano, hay un salto de línea y una línea vacía añadidos automáticamente después del prefijo y una línea vacía añadida automáticamente antes del fragmento de código del sufijo. Esto es  para asegurar que el prefijo y el sufijo no se peguen directamente al cuerpo del E-mail.';
$string['emailbrandingpitfallsli5'] = 'En E-mails de HTML, el prefijo y el sufijo son añadidos directamente antes y arriba del cuerpo del E-mail. esto es para asegurar que usted pueda trabajar con marcas (tags) HTML fácilmente. Sin embargo, usted tendrá que manejar todos los espaciados alrededor del cuerpo por usted mismo.';
$string['emailbrandingpitfallsli6'] = 'En E-mails HTML usted puede abrir una marca (tag) HTML en el fragmento de código del prefijo y cerrar la marca en el fragmento del código del sufijo sin problemas. Solamente recuerde crear HTML válido en el correo resultante.';
$string['emailbrandingtab'] = 'Marcado personalizado de E-mail';
$string['emailbrandingtextdemobody'] = 'Aquí principia el body del E-mail.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

El body del E-mail termina aquí.';
$string['emailbrandingtextheading'] = 'Previsualización de E-mail texto simple';
$string['emailbrandingtextintro'] = 'Esta es una vista previa de un E-mail a texto simple basado en los prefijos y sufijos del marcado personalizado que actualmente están configurados en el paquete de idioma.';
$string['emailbrandingtextnopreview'] = 'Hasta ahora, los E-mails en texto simple no han sido personalizados dentro de esta característica. Los E-mails serán compuestos y enviados normalmente.';
$string['enableaboutussetting'] = 'Habilitar página Acerca de nosotros';
$string['enablecontactsetting'] = 'Habilitar página de contacto';
$string['enablefooterbutton'] = 'Habilitar pie de página';
$string['enablefooterbutton_desc'] = 'Con "pie de página", se entiende el círculo que contiene el signo de interrogación al fondo de la página.<br />Al hacerle clic, al usuario se le presenta un sobrepuesto. dependiendo de la configuración del sitio, Moodle presenta varios enlaces (como "Documentación para esta página\'"o "Resumen de retención de datos" en este sobrepuesto.<br />Con esta configuración usted puede controlar si es que se muestra o se suprime el botón del pie de página en el fondo de la página.';
$string['enablefooterbuttonboth'] = 'Habilitar en escritorio, tableta y móvil';
$string['enablefooterbuttondesktop'] = 'Habilitar en escritorio y tableta solamente; ocultar en móvil (sin cambios conforme es presentado por el núcleo de Moodle)';
$string['enablefooterbuttonhidden'] = 'Ocultar en todos los dispositivos';
$string['enablefooterbuttonmobile'] = 'Habilitar solamente en móvil, ocultar en escritorio y tableta';
$string['enablehelpsetting'] = 'Habilitar página de ayuda';
$string['enableimprintsetting'] = 'Habilitar imprimir';
$string['enablemaintenancesetting'] = 'Página de información de mantenimiento habilitado';
$string['enableofferssetting'] = 'Habilitar página de Ofertas';
$string['enablepage1setting'] = 'Habilitar página Genérica 1';
$string['enablepage2setting'] = 'Habilitar página Genérica 2';
$string['enablepage3setting'] = 'Habilitar página Genérica 3';
$string['error:infobannerdismissnonotdismissible'] = 'El banner de información dado no es descartable';
$string['error:infobannerdismissnonotvalid'] = 'El número del banner de información dado no es válido';
$string['error:smartmenusmenuitemnotfound'] = 'Elemento del menú inteligente no encontrado';
$string['error:smartmenusmenunotfound'] = 'Menú inteligente no encontrado';
$string['extscssgithubfilepath_example'] = 'Ejemplo: Si usted puede ver el archivo en su cuenta en GitHub en https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/master/extscss.scss, la ruta al archivo será <em>/extscss.scss</em>.';
$string['extscssgithubpostfilepath'] = 'Ruta al archivo External Post SCSS Github';
$string['extscssgithubpostfilepath_desc'] = 'La ruta dentro del repositorio privado GitHub donde está localizado el archivo Post SCSS.';
$string['extscssgithubprefilepath'] = 'Ruta al archivo External Pre SCSS Github';
$string['extscssgithubprefilepath_desc'] = 'La ruta dentro del repositorio privado GitHub donde está localizado el archivo Pre SCSS.';
$string['extscssgithubrepo'] = 'Repositorio externo SCSS Github API';
$string['extscssgithubrepo_desc'] = 'El repositorio privado GitHub en donde están localizados los archivos SCSS.';
$string['extscssgithubrepo_example'] = 'Ejemplo: Si usted puede ver el archivo en su cuenta GitHub en https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/master/extscss.scss, el repositorio será <em>moodle-theme_boost_union-extscsstest</em>.';
$string['extscssgithubtoken'] = 'Token Externo SCSS Github API';
$string['extscssgithubtoken_desc'] = 'El token API GitHub que será usado para obtener el código SCSS del repositorio GitHub  privado.';
$string['extscssgithubtoken_docs'] = 'Ir a <a href="https://github.com/settings/tokens">configuraciones de su token Github</a> para generar un token API y ver la documentación oficial.';
$string['extscssgithubuser'] = 'Usuario externo de API GitHub SCSS';
$string['extscssgithubuser_desc'] = 'El usuario de API GitHub o la organización propietaria del repositorio privado GitHub.';
$string['extscssgithubuser_example'] = 'Ejemplo: Si usted puede ver el archivo en sucuenta GitHub en https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/master/extscss.scss, el usuario será <em>moodle-an-hochschulen</em>.';
$string['extscssheading'] = 'SCSS externo';
$string['extscssheading_instr'] = 'Instrucciones:';
$string['extscssheading_structure'] = 'El SCSS externo debe ser proporcionado como archivo de texto simple, sin ningún encabezado ni pie de página, que solamente contenga el código SCSS.';
$string['extscsssource'] = 'Fuente SCSS Externa';
$string['extscsssource_desc'] = 'Elegir el tipo de fuente desde donde usted quiere obtener el SCSS externo.';
$string['extscsssourcedownload'] = 'URL descarga pública';
$string['extscsssourcegithub'] = 'Repositorio GitHub  privado';
$string['extscsssourcenone'] = 'Ninguno';
$string['extscssurlpost'] = 'URL de descarga Post SCSS Externo';
$string['extscssurlpost_desc'] = 'La URL para descarga pública desde donde debería obtenerse el Post SCSS externo.';
$string['extscssurlpre'] = 'URL para descargar External Pre SCSS';
$string['extscssurlpre_desc'] = 'La URL para descarga pública desde donde será buscado el Pre SCSS Externo.';
$string['extscssvalidationsetting'] = 'Validación de SCSS externo';
$string['faviconheading'] = 'Favicon';
$string['faviconheading_desc'] = 'Por favor tome en cuenta: Boost Union tiene su propio favicon subido y no usa el favicon de la <a href="{$a}">configuración de favicon de Moodle</a>.<br />Boost Union especialmente le permite sobre-escribir el favicon subido dentro de sus sabores.';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Aquí puede usted subir una imagen personalizada (formato .ico o .png) que el navegador mostrará como el favicon (ícono favorito) de su sitio web Moodle. Si no sube un favicon personalizado, será usado un favicon estándar de Moodle.';
$string['flavoursappliesto'] = 'Aplica a';
$string['flavoursapplytocategories'] = 'Aplicar a categorías de curso';
$string['flavoursapplytocategories_help'] = 'Aquí usted define si es que este sabor debería de ser aplicado a categorías de curso.';
$string['flavoursapplytocategories_ids'] = 'Categorías de curso';
$string['flavoursapplytocategories_ids_help'] = 'Aquí usted define una o más categorías particulares de curso a las que debería aplicarse este sabor. Tan pronto como la página renderizada de Moodle sea localizada adentro de una de las categorías configuradas, el sabor será aplicado.';
$string['flavoursapplytocohorts'] = 'Aplicar a cohortes';
$string['flavoursapplytocohorts_help'] = 'Aquí usted define si es que este sabor debería de ser aplicado a cohortes';
$string['flavoursapplytocohorts_ids'] = 'Cohortes';
$string['flavoursapplytocohorts_ids_help'] = 'Aquí usted define una o más cohortes particulares a las cuales este sabor le debería ser aplicado. Tan pronto como el usuario sea un miembro de una de las cohortes configuradas, el sabor es aplicado.<br /><br />Por favor recuerde que si usted define más de una cohorte, no hay necesidad de que el usuario sea un miembro de todas ellas al mismo tiempo..<br /><br />Por favor también recuerde que en el estado actual de implementación, las cohortes de categoría son tratadas igual que si fueran cohortes del sistema.';
$string['flavoursbackgroundimage'] = 'Imagen del fondo';
$string['flavoursbackgroundimage_help'] = 'Con esta configuración el sabor sobre-escribirá la imagen del fondo que está configurada en las configuraciones de aspecto de Boost Union.';
$string['flavoursbacktooverview'] = 'Regresar a vista general de sabor';
$string['flavourscreateflavour'] = 'Crear sabor';
$string['flavourscustomcss'] = 'CSS personalizado';
$string['flavourscustomcss_help'] = 'Con esta configuración usted puede escribir CSS personalizado para el sabor. Será añadido a la pila de código CSS que es enviada al navegador tan pronto como se aplique el sabor. Por favor tenga en cuenta que en el estado actual de implementación, esta configuración solamente permite el uso de CSS personalizado, no así de SCSS.';
$string['flavoursdelete'] = 'Eliminar';
$string['flavoursdeleteconfirmation'] = '¿Realmente desea eliminar el sabor <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Eliminar sabor';
$string['flavoursdescription'] = 'Descripción';
$string['flavoursdescription_help'] = 'La descripción del sabor es solamente usada internamente para permitirle identificar un sabor particular en la lista de sabores.';
$string['flavoursedit'] = 'Editar';
$string['flavourseditflavour'] = 'Editar sabor';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Con esta configuración el sabor sobre-escribirá al favicon que está configurado en las configuraciones de aspecto de Boost Union.';
$string['flavoursflavours'] = 'Sabores';
$string['flavoursgeneralsettings'] = 'Configuraciones generales';
$string['flavoursincludesubcategories'] = 'Incluir subcategorías';
$string['flavoursincludesubcategories_help'] = 'Si se activa, el sabor también será aplicado a las subcategorías de las categorías elegidas.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Con esta configuración el sabor sobre-escribirá al logo que está configurado en las configuraciones de aspecto de Boost Union.';
$string['flavourslogocompact'] = 'Logo cvompacto';
$string['flavourslogocompact_help'] = 'Con esta configuración el sabor sobre-escribirá al logo que está configurado en las configuraciones de aspecto de Boost Union.';
$string['flavoursnothingtodisplay'] = 'No hay ningún sabor creado aun. Por favor cree su primer sabor para hacer que las cosas funcionen.';
$string['flavoursnotificationcreated'] = 'El sabor fue creado exitosamente';
$string['flavoursnotificationdeleted'] = 'El sabor fue eliminado exitosamente';
$string['flavoursnotificationedited'] = 'El sabor fue editado exitosamente';
$string['flavoursoverview_desc'] = '<p>Los sabores de Boost Union ofrecen una posibilidad de anular configuraciones particulares de aspecto y apariencia de Moodle en contextos particulares. En esta página, usted puede crear y gestionar sabores.</p><p>Dentro de cada sabor, usted define si es que debería de ser aplicado a categorías particulares de curso o cohortes particulares.Después, durante cada renderizado de página de Moodle, Boost Union comprueba si se aplica algún sabor. Por favor tenga en cuenta que, para cada renderizado de página de Moodle solamente el primer sabor coincidente en la lista es aplicado y los sabores restantes son ignorados. Así, el orden de los sabores en esta página es clave.</p><p>Por favor tenga en cuenta también que después de cada cambio que usted haga al conjunto de sabores, la caché del tema es purgada. Esto es necesario para asegurar que todos los bienes sean enviados apropiadamente y actualizados al navegador.</p>';
$string['flavourspreview'] = 'Vista previa';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Previsualizar sabor';
$string['flavourstitle'] = 'Título';
$string['flavourstitle_help'] = 'El título del sabor solamente es usado internamente para permitirle documentar un sabor particular en la lista de sabores.';
$string['footerheading'] = 'Pie de página';
$string['footersuppresscontactsetting'] = 'Suprimir enlace a \'Ponerse en contacto con el soporte del curso\'';
$string['footersuppresscontactsetting_desc'] = 'Con esta configuración, usted puede suprimir enteramente el enlace a \'Ponerse en contacto con el soporte del sitio\' en el pie de página. Este enlace de otra forma aparecería si estuviera activado <a href="{$a->url}">Enlace para ponerse en contacto con el soporte del sitio</a>.';
$string['footersuppressfeedbacksetting'] = 'Suprimir enlace a \'Dar retroalimentación acerca de este software\'';
$string['footersuppressfeedbacksetting_desc'] = 'Con esta configuración, usted puede suprimir enteramente el enlace a \'Dar retroalimentación acerca de este software\' en el pie de página. Este enlace de otra forma aparecería si estuviera activado <a href="{$a->url}">Retroalimentación acerca de este software</a>.';
$string['footersuppresshelpsetting'] = 'Suprimir enlace a \'Ayuda y documentación\'';
$string['footersuppresshelpsetting_desc'] = 'Con esta configuración usted puede suprimir completamente el enlace hacia \'Ayuda y documentación\' en el pie de página. En caso contrario, este enlace aparecería si está activado una <a href="{$a->url}"> Raíz de documentos Moodle Docs</a>.';
$string['footersuppressiconssetting'] = 'Suprimir íconos en frente de los enlaces del pie de página';
$string['footersuppressiconssetting_desc'] = 'Con esta configuración, usted puede suprimir completamente los íconos enfrente de los enlaces del pie de página.\'Documentación para esta página\' tiene un ícono de un libro. \'Servicios y soporte\' un aro salvavidas, etc...';
$string['footersuppresslogininfosetting'] = 'Suprimir Información para ingresar';
$string['footersuppresslogininfosetting_desc'] = 'Con esta configuración usted puede suprimir completamente la información para ingresar al sitio en el pie de página. En caso contrario esta información  mostraría enlaces al perfil del usuario y a la página para salir del sitio.';
$string['footersuppresspoweredsetting'] = 'Suprimir enlace a \'Impulsado por Moodle\'';
$string['footersuppresspoweredsetting_desc'] = 'Con esta configuración usted puede suprimir completamente el enlace de \'Impulsado por Moodle\' en el pie de página. En caso contrario este enlace   mostraría información acerca de que este sitio está ejecutando Moodle y proporcionaría un enlace hacia Moodle HQ.';
$string['footersuppressservicessetting'] = 'Suprimir enlace a \'Servicios y soporte\'';
$string['footersuppressservicessetting_desc'] = 'Con esta configuración, usted puede suprimir enteramente el enlace a \'Servicios y soporte\' en el pie de página. Este enlace de otra forma aparecería si estuviera activado <a href="{$a->url}">Enlace para servicios y soporte</a>.';
$string['footersuppressstandardfooter'] = 'Suprimir salida de pie de página por plugin \'{$a}\'';
$string['footersuppressstandardfooter_desc'] = 'Con esta configuración, usted puede suprimir enteramente la salida del pie de página por el plugin \'{$a}\'. Plugins (aun los que son parte del núcleo estándar de Moodle,que técnicamente siguen siendo plugins) pueden añadir contenido adicional al pie de página al implementar una función particular. este plugin ha implementado esta función y podría añadir contenido al pie de página en ciertas circunstancias.';
$string['footersuppressthemeswitchsetting'] = 'Suprimir enlace a cambiador del tema';
$string['footersuppressusertoursetting'] = 'Suprimir enlace a \'Reiniciar tour de usuario en esta página\'';
$string['footersuppressusertoursetting_desc'] = 'Con esta configuración, usted puede suprimir enteramente el enlace a \'Reiniciar tour de usuario en esta página\' en el pie de página. Este enlace de otra forma proporcionaría la posibilidad de reiniciar un tour de usuario en una página particular.';
$string['footertab'] = 'Pie de página';
$string['footnoteheading'] = 'Nota al pie';
$string['footnotesetting'] = 'Nota al pie';
$string['footnotesetting_desc'] = 'Todo lo que usted escriba en esta área de texto será mostrado al final de una página, en el pie de página( no en el pie de página flotante) de todas las páginas que usen el diseño de "cajones", "columnas2" o"ingreso". El contenido en esta área podría ser, por ejemplo, para Copyright (Derechos Reservados), los términos de uso, o el nombre de su organización. <br/> Si usted quiere quitar de nuevo el pie de página, simplemente vacíe el área de texto.a.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github issues</a>';
$string['h5pcontentmaxwidthsetting'] = 'Ancho máximo de banco de contenido H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'Con esta configuración usted puede anular el ancho del banco de contenido H5P de Moodle sin modificaciones manuales de SCSS. Este ancho es usado para el editor H5P dentro del banco de contenido.<em> NO ES</em> usado para el ancho de la actividad H5P. De forma predeterminada, Moodle usa un ancho máximo del banco de contenido H5P de 960px. Usted puede ingresar otros valores basados en pixeles como 1200px, pero usted también puede ingresar un valor basado en porcentaje como 100%, o un valor del ancho de la vista como 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Contenido de página de ayuda';
$string['helpcontentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido que será mostrado en una página de ayuda.';
$string['helpdisabled'] = 'La página de ayuda está deshabilitada en este sitio. No hay nada para ver aquí.';
$string['helpheading'] = 'Ayuda';
$string['helplinkpositionboth'] = 'Añadir un enlace a la página de ayuda en la nota al pie y en ícono (interrogación) del pie de página';
$string['helplinkpositionfooter'] = 'Añadir un enlace a la página de ayuda en el ícono (interrogación) del pie de página';
$string['helplinkpositionfootnote'] = 'Añadir un enlace a la página de ayuda en la nota al pie';
$string['helplinkpositionnone'] = 'No mostrar automáticamente un enlace hacia la página de ayuda';
$string['helplinkpositionsetting'] = 'Posición del enlace hacia página de ayuda';
$string['helplinkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace hacia la página de ayuda debería ser añadido automáticamente a la página de Moodle. Si usted no quiere mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia {$a->url} desde cualquier lugar en Moodle.';
$string['helppagetitledefault'] = 'Ayuda';
$string['helppagetitlesetting'] = 'Título de la página de ayuda';
$string['helppagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página de ayuda. Este texto será usado como texto del enlace a la página de ayuda además si usted configura apropiadamente \'Posición de enlace a página de ayuda\'.';
$string['hidenodesprimarynavigationsetting'] = 'Ocultar nodos en la navegación primaria';
$string['hidenodesprimarynavigationsetting_desc'] = 'Con esta configuración usted puede ocultar uno o varios nodos de la navegación primaria.<br /><br />
Por favor tenga en cuenta: Aquí, usted puede simplemente quitar nodos de navegación. Pero si usted quiere añadir nodos de navegación personalizados, por favor considere usar la <a href="{$a->url}">Funcionalidad de menú inteligente de Boost Union</a>.';
$string['imprintcontentsetting'] = 'Imprimir contenido';
$string['imprintcontentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido que será mostrado en la página para imprimir.';
$string['imprintdisabled'] = 'La página para imprimir está deshabilitada para este sitio. No hay nada para ver aquí.';
$string['imprintheading'] = 'Imprimir';
$string['imprintlinkpositionboth'] = 'Añadir un enlace a la página para imprimir a la nota al pie y al ícono (caracter de interrogación) del pie de página';
$string['imprintlinkpositionfooter'] = 'Añadir un enlace a la página para imprimir al ícono (caracter de interrogación) del pie de página';
$string['imprintlinkpositionfootnote'] = 'Añadir un enlace a la página para imprimir a la nota al pie';
$string['imprintlinkpositionnone'] = 'No mostrar automáticamente un enlace a la página para imprimir';
$string['imprintlinkpositionsetting'] = 'Posición de enlace para Imprimir';
$string['imprintlinkpositionsetting_desc'] = 'en esta configuración usted puede configurar si debería o no ser añadido automáticamente un enlace a la página para imprimir a la página Moodle. Si usted no quiere mostrar un enlace automáticamente, usted puede añadir manualmente un enlace a {$a->url} desde cualquier lugar en Moodle.';
$string['imprintpagetitledefault'] = 'Imprimir';
$string['imprintpagetitlesetting'] = 'Título de página imprimir';
$string['imprintpagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página para imprimir. Este texto será usado como el texto del enlace a la pagina de imprimir además si usted configura apropiadamente \'Posición de enlace para imprimir\'.';
$string['infobannerbsclasssetting'] = 'Banner de información no. {$a->no} Bootstrap class';
$string['infobannerbsclasssetting_desc'] = 'Con esta configuración usted puede seleccionar el estilo de Bootstrap con el cual debería ser mostrado el banner de información {$a->no}. Si usted elige la opción de \'Sin color Bootstrap\', el banner de información será sacado sin un color Bootstrap particular, lo que le dará a usted la libertad para estilizar el banner usted mismo dentro del editor de texto enriquecido.';
$string['infobannerclose'] = 'Cerrar';
$string['infobannercontentsetting'] = 'Banner de información {$a->no} contenido';
$string['infobannercontentsetting_desc'] = 'Aquí, usted escribe la información que será mostrada dentro del banner de información {$a->no}.';
$string['infobannerdismissconfirm'] = '¿Realmente quiere reiniciar la visibilidad del banner de información {$a->no} y desea volver a mostrarlo para todos los usuarios que lo hayan descartado?';
$string['infobannerdismissfail'] = 'El reinicio de la visibilidad del banner de información {$a->no} ha fallado para al menos un usuario.';
$string['infobannerdismissiblesetting'] = 'Banner de información {$a->no} descartable';
$string['infobannerdismissiblesetting_desc'] = 'Con esta configuración, usted puede hacer descartable el banner de información {$a->no}. Si el usuario hace clic en el botón-x en el banner de información, el banner será ocultado al usuario permanentemente. La visibilidad no es reiniciada automáticamente, aunque usted cambie el contenido del banner de información. Si usted quiere reiniciar la visibilidad del banner de información, haga clic en el botón inferior de \'Reiniciar visibilidad0';
$string['infobannerdismissreset'] = 'Reiniciar visibilidad de banner de información descartado';
$string['infobannerdismissresetbutton'] = 'Reiniciar visibilidad de banner de información {$a->no}';
$string['infobannerdismisssuccess'] = 'La visibilidad del banner de información {$a->no} ha sido reiniciada';
$string['infobannerenabledsetting'] = 'Habilitar banner de información {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Con esta configuración usted puede habilitar el banner de información {$a->no}.';
$string['infobannerendsetting'] = 'Banner de información {$a->no} hora de término';
$string['infobannerendsetting_desc'] = 'Con esta configuración usted puede definir hasta cuando será mostrado el banner de información {$a->no} . La hora configurada es interpretada como la hora del servidor, no la hora del usuario.';
$string['infobannerheading'] = 'Banner de información {$a->no}';
$string['infobannermodeperpetual'] = 'Perpetuo';
$string['infobannermodesetting'] = 'Banner de información {$a->no} modo de visualización';
$string['infobannermodesetting_desc'] = 'Con esta configuración usted puede definir si es que el banner de información {$a->no} debería ser un banner perpetuo (que es mostrado siempre) o un banner controlado por tiempo (que es mostrado solamente dentro del intervalo de tiempo configurado).';
$string['infobannermodetimebased'] = 'Controlado por tiempo';
$string['infobannerordersetting'] = 'Banner de información {$a->no} posición de ordenamiento';
$string['infobannerordersetting_desc'] = 'Con esta configuración usted define la posición del orden del banner de información {$a->no}. De forma predeterminada, los banners de información están ordenados de superior a inferior y de izquierda a derecha tal y como usted los ve en esta página de configuración aquí. Sin embargo, usted puede decidir asignar otra posición de ordenamiento con esta configuración. Si usted asigna la misma posición de ordenamiento a dos o más banners de información, ellos serán ordenados nuevamente de acuerdo al orden en esta página de configuraciones.';
$string['infobannerpageloginpage'] = 'Página para ingreso';
$string['infobannerpagessetting'] = 'Diseño de la página a mostrar banner de información {$a->no}';
$string['infobannerpagessetting_desc'] = 'Con esta configuración, usted puede seleccionar los diseños de página en las cuales el banner de información {$a->no}debería ser mostrado.';
$string['infobannerstartsetting'] = 'Banner de información {$a->no} hora de inicio';
$string['infobannerstartsetting_desc'] = 'Con esta configuración usted puede definir desde cuando será mostrado el banner de información {$a->no} . La hora configurada es interpretada como la hora del servidor, no la hora del usuario.';
$string['infobannertab'] = 'Banner de información';
$string['invalidurl'] = 'La URL dada es inválida';
$string['javascriptdisabledhint'] = 'Pista para JavaScript deshabilitado';
$string['javascriptdisabledhint_desc'] = 'Con esta configuración, aparecerá una pista en la parte superior de la página de Moodle si JavaScript no está habilitado. Esto es particularmente útil porque varias características de Moodle no funcionan sin JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript está deshabilitado en su navegador.<br />Muchas características de Moodle no se podrán usar o aparecerán rotas.<br />Por favor habilite JavaScript para poder tener la experiencia Moodle completa.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Enlaces';
$string['loginbackgroundimage'] = 'Imágenes del fondo de página de ingreso';
$string['loginbackgroundimage_desc'] = 'Las imágenes a mostrar como un fondo de la página para ingresar al sitio. Una de estas imágenes será seleccionada al azar y será mostrada cuando el usuario visite la página para ingresar al sitio. Por favor asegúrese de que no use caracteres NO-ASCII (eñes, letras acentuadas...) en el nombre del archivo si usted quiere mostrar texto para imágenes del fondo para página de ingreso.';
$string['loginbackgroundimagepositionsetting'] = 'Posición de la imagen del fondo de la página para ingresar al sitio';
$string['loginbackgroundimagepositionsetting_desc'] = 'Con esta configuración, usted controla la posición de la imagen del fondo de la página para ingresar al sitio dentro de la ventana del navegador. El primer valor es la posición horizontal, el segundo valor es la posición vertical.';
$string['loginbackgroundimagesheading'] = 'Imágenes del fondo de la página de ingreso';
$string['loginbackgroundimagetextsetting'] = 'Mostrar texto para imágenes de fondo de página de ingreso';
$string['loginbackgroundimagetextsetting_desc'] = 'Con esta configuración opcional usted puede añadir texto, como por ejemplo un aviso de Derechos Reservados (C)  a sus imágenes de fondo subidas. Este texto aparecerá en la parte superior del pie de página en la página para ingresar al sitio. Sin embargo, por razones del uso de espacio de pantalla, solamente es mostrado en los tamaños de pantalla más grandes.
.<br/>
Cada línea consiste del identificador del archivo (el nombre del archivo), el texto que debería ser mostrado y el color del texto, separados por un caracter de barra vertical | . Cada declaración necesita estar escrita en una nueva línea. <br/>
Por ejemplo:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
Como color del texto, usted puede usar los valores "dark" (oscuro) o "light" (claro).<br />
Usted puede declarar textos para una cantidad arbitraria de sus imágenes de fondo para página de ingreso subidas. Los textos serán añadidos solamente a aquellas imágenes que coincidan sus nombres de archivos con el identificador declarado en esa configuración.';
$string['loginformheading'] = 'Formato para ingresar';
$string['loginformpositionsetting'] = 'Posición del formato para ingresar';
$string['loginformpositionsetting_center'] = 'Centrado';
$string['loginformpositionsetting_desc'] = 'Con esta configuración usted puede optimizar el formato para ingresar para que se ajuste a una mayor variedad de imágenes de fondo. de forma predeterminada, el formato para ingresar es mostrado centrado en la página para ingresar. Alternativamente, usted puede moverlo a la izquierda o a la derecha de la página para ingresar para permitir que otras partes de la imagen del fondo se muestren. Por supuesto, usted también puede cambiar esta configuración  si no se sube ninguna imagen de fondo.';
$string['loginformpositionsetting_left'] = 'Alineado a la izquierda';
$string['loginformpositionsetting_right'] = 'Alineado a la derecha';
$string['loginformtransparencysetting'] = 'Transparencia de formato para ingreso';
$string['loginformtransparencysetting_desc'] = 'Con esta configuración, usted puede hacer el formato para ingreso al sitio ligeramente transparente para permitir que la imagen del fondo luzca aun más.';
$string['loginidpshowintrosetting'] = 'Intro ingreso IDP';
$string['loginidpshowintrosetting_desc'] = 'Con esta configuración usted controla si la introducción a <em>\'{$a}\'</em> es mostrada arriba de los botones para ingreso mediante Proveedores de Identidad Externos (IDP) o no. De forma predeterminada la introducción es mostrada y los usuarios serán rápidamente informados acerca de para qué son los botones de IDP. Si usted deshabilita esta configuración, la intro IDP es ocultada. Esto le permite a usted proporcionar una interfaz de ingreso del usuario limpia si usted simplemente usa proveedores de identidad externos como OAuth2 o OIDC.';
$string['loginlocalintro'] = 'Ingrese con su cuenta de Moodle';
$string['loginlocalloginenablesetting'] = 'Ingreso local';
$string['loginlocalloginenablesetting_desc'] = 'Con esta configuración usted controla si es que el formato para ingreso local es o no mostrado en la página para ingreso. De forma predeterminada, el formato para ingreso local es mostrado y los usuarios ingresan al sitio de forma normal. Si usted deshabilita esta configuración, el formato para ingreso local es ocultado. Esto le permite a usted el proporcionar solamente botones para ingresar para proveedores de identidad externos como OAuth2 o OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Por favor tenga en cuenta: Tan pronto como usted oculte el formato para ingreso local, usted se arriesga a que los administradores no puedan ingresar más al sitio con una cuenta  local si hubiera un problema con el proveedor de identidad externo. Para permitir ingresos locales en esos casos, se proporciona una <a href="{$a->url}">entrada lateral a página de ingreso local</a>. En esta entrada lateral a la página de ingreso local, también se aplican todas las medidas de seguridad para ingresar a Moodle.';
$string['loginlocalloginformhead'] = 'Ingreso local';
$string['loginlocalloginlocalnotdisabled'] = 'El ingreso local está habilitado en el formato de ingreso estándar. No hay necesidad de ingresar en esta página de ingreso local aquí. Por favor use la <a href="{$a->url}">página de ingreso estándar</a> para ingresar al sitio.';
$string['loginlocalshowintrosetting'] = 'ntroducción al ingreso local';
$string['loginlocalshowintrosetting_desc'] = 'Con esta configuración, usted controla si una introducción <em>\'{$a}\'</em> es o no mostrada arriba del formato para ingreso local. de forma predeterminada, la introducción NO es mostrada. Pero si usted la habilita, esta introducción puede ayudarle a los usuarios a comprender cuales credenciales usar en el formato para ingreso local, especialmente si usted proporciona más de un método de ingreso o si usted ha cambiado el orden de los métodos para ingresar.';
$string['loginorderfirsttimesignupsetting'] = 'Información para visitantes por primera vez y Auto registro';
$string['loginorderguestsetting'] = 'Ingreso de visitante';
$string['loginorderheading'] = 'Orden para ingresar';
$string['loginorderheading_desc'] = 'Con estas configuraciones, usted controla el orden de los métodos para ingresar al sitio en el formato para ingreso. El orden presentado estará definido desde el número ordinal más bajo al más alto, saltándose todos los métodos de ingreso y elementos del formato para ingreso que estén deshabilitados en Moodle.';
$string['loginorderheading_note'] = 'Nota técnica: El orden presentado será realizado con órdenes flexbox CSS, NO se hará re-arreglo de los widgets para ingresar en la HTML DOM. Esto debería estar bien en todos los navegadores modernos pero podría no funcionar en navegadores realmente mucho muy antiguos.';
$string['loginorderidpsetting'] = 'Ingreso IDP';
$string['loginorderlocalsetting'] = 'Ingreso Local';
$string['loginpagetab'] = 'Página de ingreso';
$string['loginprovidersheading'] = 'Proveedores de ingreso';
$string['logocompactsetting'] = 'Logo compacto';
$string['logocompactsetting_desc'] = 'Aquí usted puede subir una versión compacta del mismo logo de arriba, como por ejemplo un emblema, escudo o ícono. Esta imagen es especialmente usada en la barra de navegación en la parte superior de cada página de Moodle. La imagen debería ser clara aun en tamaños pequeños.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Aquí puede usted subir un logo completo a ser usado como decoración. Esta imagen es especialmente usada en la página para ingresar al sitio. Esta imagen puede ser de bastante alta resolución porque será reducida en escala para su uso.';
$string['logosheading'] = 'Logos';
$string['logosheading_desc'] = 'Por favor tome en cuenta: Boost Union tiene su propio logo subido y no usa el logo de la <a href="{$a}">configuración del logo de Moodle</a>.<br />Boost Union especialmente le permite subir más formatos de imágenes que lo que permite el Moodle estándar y le permite sobre-escribir los logos subidos dentro de sus sabores.';
$string['maintenancecontentsetting'] = 'Contenido de página de información de mantenimiento';
$string['maintenancecontentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido que será mostrado en la página para información de mantenimiento (que no es la misma que la página estándar de mantenimiento de Moodle).';
$string['maintenancedisabled'] = 'La página de información de mantenimiento está deshabilitada para este sitio. No hay nada que ver aquí.';
$string['maintenanceheading'] = 'Mantenimiento';
$string['maintenancelinkpositionboth'] = 'Añadir un enlace a la página de información de mantenimiento a la nota al pie y al ícono (signo interrogación) del pie de página.';
$string['maintenancelinkpositionfooter'] = 'Añadir un enlace a la página de información de mantenimiento al ícono (signo interrogación) del pie de página.';
$string['maintenancelinkpositionfootnote'] = 'Añadir un enlace a la página de información de mantenimiento a la nota al pie';
$string['maintenancelinkpositionnone'] = 'No mostrar automáticamente un enlace a la página de información de mantenimiento';
$string['maintenancelinkpositionsetting'] = 'Posición del enlace hacia página de información de Mantenimiento';
$string['maintenancelinkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace hacia la página de información de mantenimiento debería ser añadido automáticamente a la página de Moodle. Si usted no quiere mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia {$a->url} desde cualquier lugar en Moodle.';
$string['maintenancepagetitledefault'] = 'Mantenimiento';
$string['maintenancepagetitlesetting'] = 'Título de página de información de mantenimiento';
$string['maintenancepagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página de información sobre Mantenimiento. Este texto será usado como texto del enlace hacia la página de información de mantenimiento además si usted configura apropiadamente \'Posición de enlace de página de información de mantenimiento\'.';
$string['markbrokenlinkssetting'] = 'Marcar enlaces rotos';
$string['markbrokenlinkssetting_desc'] = 'Añadir un ícono de "cadena rota" frente a enlaces rotos (que llevan a archivos en borrador que no han sido procesados apropiadamente) y marcar el enlace en el color bootstrap para "peligro". En contraste a configuraciones de  "Marcar enlaces externos" y "Marcar enlaces mailto", no hay posibilidad de limitar el alcance de esta configuración porque marcar enlaces rotos es un indicador de que algo está roto y debe ser corregido manualmente.';
$string['markexternallinksscopesetting'] = 'Marcar alcance de enlaces externos';
$string['markexternallinksscopesetting_desc'] = 'Con esta configuración usted controla el alcance donde Boost Union  debería marcar los enlaces externos. De forma predeterminada, Boost Union marca enlaces externos en toda la página Moodle y hace su mejor esfuerzo para cubrir algunos casos límite donde añadir los íconos de enlace externo no tendrían mucho sentido. Sin embargo, usted también puede limitar el alcance para evitar mejor los casos extremos.';
$string['markexternallinkssetting'] = 'Marcar enlaces externos';
$string['markexternallinkssetting_desc'] = 'Añadir un ícono de \'enlace externo\' después de enlaces externos (que lleva al usuario a un destino fuera de Moodle).';
$string['marklinksscopesetting_coursemain'] = 'Dentro del área de contenido principal de páginas principales del curso solamente';
$string['marklinksscopesetting_wholepage'] = 'En toda la página completa';
$string['markmailtolinksscopesetting'] = 'Marcar alcance de enlaces mailto';
$string['markmailtolinksscopesetting_desc'] = 'Con esta configuración usted controla el alcance en donde Boost Union debería marcar los enlaces mailto. de forma predeterminada, Boost Union marca los enlaces mailto en toda la página de Moodle. sin embargo, usted también puede limitar el alcance para evitar casos límite.';
$string['markmailtolinkssetting'] = 'Marcar enlaces mailto';
$string['markmailtolinkssetting_desc'] = 'Añade un ícono de un "sobre" frente a enlaces mailto.';
$string['mediumcontentmaxwidthsetting'] = 'Ancho máximo de contenido de medios';
$string['mediumcontentmaxwidthsetting_desc'] = 'Con esta configuración usted puede anular el ancho del contenido de enmedio de Moodle sin modificaciones manuales con SCSS. Este ancho de página es usado en ciertas actividades como por ejemplo la actividad de BasedeDatos. de forma predeterminada, Moodle usa un ancho máximo de contenido de enmedio de 1120px. Usted puede ingresar otros valores basados en pixeles como por ejemplo 1200px, pero usted también puede ingresar un valor basado en porcentaje como 100% o un valor del ancho de portal de vista como 90vw.';
$string['misctab'] = 'Misceláneos';
$string['mobileappearanceheading'] = 'Apariencia en Mobile';
$string['mobileappheading'] = 'App mobile';
$string['mobilecss'] = 'CSS adicional para App Mobile';
$string['mobilecss_desc'] = 'Con esta configuración usted puede escribir código CSS personalizado para personalizar su interfaz de App mobile. El código CSS será añadido solamente a la representación de la App Mobile de esta instancia Moodle y no será mostrado en la versión para navegador web. Lea más acerca de esta característica en los  <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Moodle dev docs</a>.';
$string['mobilecss_donotchange'] = 'Este paso es necesario para mover el código CSS a la App Mobile. No cambie  la URL a menos que usted realmente quiera quitar el código CSS de la App Mobile de nuevo.';
$string['mobilecss_overwrite'] = 'Tan pronto como usted añada algún código CSS a esta configuración y guarde la configuración, la  <a href="{$a->url}">Moodle core setting <em>mobilecssurl</em></a> será automáticamente configurada a una URL del tema Boost Union. Actualmente esta configuración está configurada a <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Tan pronto como usted añada algún código CSS a esta configuración y guarde la configuración, la  <a href="{$a->url}">Moodle core setting <em>mobilecssurl</em></a> será automáticamente configurada a una URL del tema Boost Union.';
$string['mobiletab'] = 'App Mobile';
$string['modiconactivity'] = 'Actividad';
$string['modiconactivityunknown'] = 'Desconocido';
$string['modicongtmoodle4'] = 'Ícono de Moodle 4';
$string['modiconlistsetting'] = 'Lista de archivos de íconos personalizados';
$string['modiconlistsetting_desc'] = 'Esta es la lista de archivos de íconos personalizados que usted ha subido al área de archivos de íconos personalizados de arriba. Todos los archivos válidos de íconos están enlistados aquí. Además, hay  otros archivos que usted podría haber subido también pero que no son archivos válidos de íconos, los que son mostrados como archivos rotos.';
$string['modiconltmoodle311'] = 'Ícono antiguo de Moodle 3';
$string['modiconnamefail'] = 'Este archivo fue subido dentro de la carpeta correcta para la actividad <em>{$a}</em>, pero el nombre del archivo NO es válido. Por favor cambie el nombre del archivo, ya sea a  <em>monologo.svg</em> / <em>monologo.png</em> (para íconos de Moodle 4) o cámbielo a  <em>icon.svg</em> / <em>icon.png</em> (para íconos antiguos de Moodle 3).';
$string['modiconnotexist'] = 'Este archivo fue subido a una ubicación inapropiada, ya que es imposible deducir una actividad particular desde la ruta del archivo <em>{$a}</em>.';
$string['modiconsenablesetting'] = 'Habilitar íconos personalizados para actividades y recursos';
$string['modiconsenablesetting_desc'] = 'Con esta configuración, usted puede modificar los íconos para actividades y recursos que son usados por Moodle en las páginas del curso y en el Selector de actividad.';
$string['modiconserrorcreatingpath'] = 'No se pudo crear la carpeta pix_plugins/mod folder could en su directorio Moodledata.<br />El mensaje de la excepción fue:{$a}.';
$string['modiconsfiles'] = 'Archivos de íconos personalizados';
$string['modiconsfiles_desc'] = 'Aquí puede usted subir íconos personalizados para todos o solamente algunos módulos de actividad instalados en esta instancia Moodle.';
$string['modiconsfileshowto'] = 'Para subir un ícono de actividad personalizado particular, comience creando una carpeta con el nombre interno (en idioma inglés) de la actividad; por ejemplo, <em>assign</em> para la actividad de Tarea ( assigment). En esta carpeta, usted sube el ícono como un archivo SVG llamado  monologo.svg  y, de ser posible, como \'plan B\' un archivo PNG llamado monologo.png. Si usted quiere personalizar los íconos coloreados que han estado en uso hasta Moodle 3 y que podrían seguir siendo utilizados por plugins antiguos, usted puede también subirlos como archivos icon.svg y icon.png . Sin embargo, por favor acostúmbrese a usar íconos monocromáticos SVG donde sea posible para obtener los mejores resultados. Entonces, por favor guarde la página de configuraciones. Tan pronto como usted guarde la página de configuraciones con al menos un archivo, aparecerá una lista de archivos debajo, la cual le ayuda a comprobar si es que los íconos personalizados han sido subidos correctamente.';
$string['modiconsfilestech'] = 'Nota técnica: Después de guardar esta configuración, el estructura de la carpeta subida y los archivos de íconos serán copiados a la carpeta  pix_plugins/mod en su directorio Moodledata. Esto es en donde el núcleo de Moodle busca los íconos de actividad personalizados. Todos los archivos de íconos que ya existan en este lugar serán sobre-escritoss cuando usted guarde esta configuración.';
$string['modiconsheading'] = 'Íconos de actividad';
$string['modiconsuccess3x'] = 'Este ícono será usado para la actividad de <em>{$a}</em> como ícono antiguo de Moodle 3.';
$string['modiconsuccess4x'] = 'Este ícono será usado para la actividad de <em>{$a}</em> como ícono de Moodle 4.';
$string['modiconversion'] = 'Versión de ícono';
$string['navbarcolorsetting'] = 'Color de Barra de Navegación';
$string['navbarcolorsetting_dark'] = 'Barra de Navegación oscura con color claro de font';
$string['navbarcolorsetting_desc'] = 'Con esta configuración usted puede cambiar el color de la Barra de Navegación del predeterminado de Barra de Navegación clara hacia una oscura o coloreada.';
$string['navbarcolorsetting_light'] = 'Barra de Navegación clara con color oscuro de font (sin cambios tal como es presentada por Moodle original)';
$string['navbarcolorsetting_primarydark'] = 'Barra de Navegación de color primario con color claro del font';
$string['navbarcolorsetting_primarylight'] = 'Barra de Navegación de color primario con color oscuro del font';
$string['navbarheading'] = 'Barra de Navegación';
$string['navigationheading'] = 'Navegación';
$string['navigationtab'] = 'Navegación';
$string['offerscontentsetting'] = 'Contenido de Ofertas';
$string['offerscontentsetting_desc'] = 'En esta configuración, usted puede añadir contenido de texto enriquecido que será mostrado en la página de Ofertas.';
$string['offersdisabled'] = 'La página de Ofertas está deshabilitada para este sitio. Aquí no hay nada que ver.';
$string['offersheading'] = 'Ofertas';
$string['offerslinkpositionboth'] = 'Añadir un enlace a la página de Ofertas a la nota al pie y al ícono (signo de ?) del pie de página';
$string['offerslinkpositionfooter'] = 'Añadir un enlace a la página de Ofertas a al ícono (signo de ?) del pie de página';
$string['offerslinkpositionfootnote'] = 'Añadir un enlace a la página de Ofertas a la nota al pie';
$string['offerslinkpositionnone'] = 'No mostrar automáticamente un enlace a la página de Ofertas';
$string['offerslinkpositionsetting'] = 'Posición del enlace a Ofertas';
$string['offerslinkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace hacia la página de Ofertas debería ser añadido automáticamente a la página de Moodle. Si usted no quiere mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia {$a->url} desde cualquier lugar en Moodle.';
$string['offerspagetitledefault'] = 'Ofertas';
$string['offerspagetitlesetting'] = 'Título de página de Ofertas';
$string['offerspagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página de Ofertas. Este texto será usado como un texto del enlace hacia la página de Ofertas cuando usted configure apropiadamente \'Posición del enlace a página de Ofertas\'.';
$string['openoffcanvas'] = 'Abrir cajón Afuera-del-lienzo';
$string['outsideregionsheading'] = 'Regiones de afuera';
$string['outsideregionsheading_desc'] = 'Las regiones de afuera no solamente pueden ser habilitadas con las configuraciones del diseño de arriba, su apariencia también puede ppersonalizarse.';
$string['outsideregionsplacement'] = 'Colocación horizontal de regiones afuera';
$string['outsideregionsplacement_desc'] = 'Con esta configuración, usted puede controlar si, en pantallas más grandes, las regiones de bloque \'Afuera (izquierda)\' y \'Afuera (derecha)\' deberían ser colocadas cerca del área del contenido principal o cerca de los bordes de la ventana.';
$string['outsideregionsplacementnearwindowedges'] = 'Mostrar regiones \'Afuera (izquierda)\' y \'Afuera (derecha)\' cerca de los bordes de la ventana.';
$string['outsideregionsplacementnextmaincontent'] = 'Mostrar regiones \'Afuera (izquierda)\' y \'Afuera (derecha)\' junto al área del contenido principal';
$string['outsideregionswidthcoursecontentwidth'] = 'Ancho del contenido del curso';
$string['outsideregionswidthfullwidth'] = 'Ancho completo';
$string['outsideregionswidthherowidth'] = 'Ancho heroe';
$string['page1contentsetting'] = 'Contenido de página Genérica 1';
$string['page1contentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido, que será mostrado en la página Genérica 1.';
$string['page1disabled'] = 'La página Genérica 1 está deshabilitada para este sitio. Aquí no hay nada que ver.';
$string['page1heading'] = 'Página Genérica 1';
$string['page1linkpositionboth'] = 'Añadir un enlace a la página Genérica 1 a la nota al pie y al ícono del signo de interrogación (?) del pie de página';
$string['page1linkpositionfooter'] = 'Añadir un enlace a la página Genérica 1 al ícono del signo de interrogación (?) del pie de página';
$string['page1linkpositionfootnote'] = 'Añadir un enlace a la página Genérica 1 a la nota al pie';
$string['page1linkpositionnone'] = 'No mostrar automáticamente un enlace hacia la página Genérica 1';
$string['page1linkpositionsetting'] = 'Posición de la página Genérica 1';
$string['page1linkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace a la página Genérica 1 debería ser añadido automáticamente a la página de Moodle. Si usted no desea mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia  {$a->url} desde cualquier lugar en Moodle.';
$string['page1pagetitledefault'] = 'Página Genérica 1';
$string['page1pagetitlesetting'] = 'Título de la página Genérica 1';
$string['page1pagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página Genérica 1. Este texto será usado como un texto del enlace hacia la página Genérica 1 cuando usted configure apropiadamente \'Posición del enlace a página Genérica 1\'.';
$string['page2contentsetting'] = 'Contenido de página Genérica 2';
$string['page2contentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido, que será mostrado en la página Genérica 2.';
$string['page2disabled'] = 'La página Genérica 2 está deshabilitada para este sitio. Aquí no hay nada que ver.';
$string['page2heading'] = 'Página Genérica 2';
$string['page2linkpositionboth'] = 'Añadir un enlace a la página Genérica 2 a la nota al pie y al ícono del signo de interrogación (?) del pie de página';
$string['page2linkpositionfooter'] = 'Añadir un enlace a la página Genérica 2 al ícono del signo de interrogación (?) del pie de página';
$string['page2linkpositionfootnote'] = 'Añadir un enlace a la página Genérica 2 a la nota al pie';
$string['page2linkpositionnone'] = 'No mostrar automáticamente un enlace a la página Genérica 2';
$string['page2linkpositionsetting'] = 'Posición del enlace a página Genérica 2';
$string['page2linkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace a la página Genérica 2 debería ser añadido automáticamente a la página de Moodle. Si usted no desea mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia  {$a->url} desde cualquier lugar en Moodle.';
$string['page2pagetitledefault'] = 'Página Genérica 2';
$string['page2pagetitlesetting'] = 'Título de Página Genérica 2';
$string['page2pagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página Genérica 2. Este texto será usado como un texto del enlace hacia la página Genérica 2 cuando usted configure apropiadamente \'Posición del enlace a página Genérica 2\'.';
$string['page3contentsetting'] = 'Contenido de Página Genérica 3';
$string['page3contentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido, que será mostrado en la página Genérica 3.';
$string['page3disabled'] = 'La página Genérica 3 está deshabilitada para este sitio. Aquí no hay nada que ver.';
$string['page3heading'] = 'Página Genérica 3';
$string['page3linkpositionboth'] = 'Añadir un enlace a la página Genérica 3 a la nota al pie y al ícono del signo de interrogación (?) del pie de página';
$string['page3linkpositionfooter'] = 'Añadir un enlace a la página Genérica 3 al ícono del signo de interrogación (?) del pie de página';
$string['page3linkpositionfootnote'] = 'Añadir un enlace a la página Genérica 3 a la nota al pie';
$string['page3linkpositionnone'] = 'No mostrar automáticamente un enlace hacia la página Genérica 3';
$string['page3linkpositionsetting'] = 'Posición de enlace hacia página Genérica 3';
$string['page3linkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace a la página Genérica 1 debería ser añadido automáticamente a la página de Moodle. Si usted no desea mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia  {$a->url} desde cualquier lugar en Moodle.';
$string['page3pagetitledefault'] = 'Página Genérica 3';
$string['page3pagetitlesetting'] = 'Título de Página Genérica 3';
$string['page3pagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página Genérica 3. Este texto será usado como un texto del enlace hacia la página Genérica 3 cuando usted configure apropiadamente \'Posición del enlace a página Genérica 3\'.';
$string['pagelayoutstab'] = 'Diseños de página';
$string['pagetab'] = 'Página';
$string['pagewidthheading'] = 'Ancho de página';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Políticas';
$string['policyoverviewnavigationsetting'] = 'Mostrar navegación en página de vista general de política';
$string['policyoverviewnavigationsetting_desc'] = 'De forma predeterminada, la página de vista general de política (proporcionada por tool_policy) no muestra un menú de navegación ni pie de página. Con esta configuración, usted puede mostrar la navegación primaria y el pie de página en esa página.';
$string['presetbutton'] = 'Configurar preconfiguración del tema en Boost';
$string['presetheading'] = 'Pre-configuraciones del tema';
$string['presetheading_desc'] = 'Las pre-configuraciones del tema pueden ser usadas para alterar dramáticamente la apariencia del tema. Boost Union no re-implementa la configuración de pre-configuraciones del tema; si usted quiere usar pre-configuraciones del tema, por favor configúrelas directamente en Boost. Boost Union las heredará y usará la pre-configurador configurada.';
$string['primarynavigationheading'] = 'Navegación primaria';
$string['privacy:metadata'] = 'El tema Boost Union no almacena ninguna información personal de ningún usuario.';
$string['region-content-lower'] = 'Contenido (inferior)';
$string['region-content-upper'] = 'Contenido (superior)';
$string['region-footer-center'] = 'Pie de página (centro)';
$string['region-footer-left'] = 'Pie de página (izquierdo)';
$string['region-footer-right'] = 'Pie de página (derecho)';
$string['region-header'] = 'Encabezado';
$string['region-none'] = 'Ninguno';
$string['region-offcanvas-center'] = 'Afuera-del-lienzo (centro)';
$string['region-offcanvas-left'] = 'Afuera-del-lienzo (izquierda)';
$string['region-offcanvas-right'] = 'Afuera-del-lienzo (derecha)';
$string['region-outside-bottom'] = 'Afuera (abajo)';
$string['region-outside-left'] = 'Afuera (izquierda)';
$string['region-outside-right'] = 'Afuera (derecho)';
$string['region-outside-top'] = 'Afuera (superior)';
$string['resourcescachecontrolnote'] = 'Por favor tenga en cuenta que los archivos están incluidos en el navegador con el conjunto del encabezado de \'Cache-Control\' que le dice al navegador que debe cachear el archivo. Si usted está seguro de que usted no cambiará el archivo en el futuro cercano, usted puede usar la URL persistente para enlazarla al archivo. sin embargo, si usted planea modificar un archivo pero mantener el mismo nombre de archivo de vez en cuando, usted debería entonces usar la URL revisada y re-enlazar al archivo donde usted la haya usado en cualquier momento que actualice el archivo para evitar que el navegador muestre versiones cacheadas obsoletas del archivo.';
$string['resourcestab'] = 'Recursos';
$string['scrollspysetting'] = 'Desplazamiento-espía';
$string['scrollspysetting_desc'] = 'Con esta configuración, al activar y desactivar el modo de edición, la posición del cursor donde el usuario estaba cuando estaba haciendo el cambio es preservada.';
$string['scssheading'] = 'SCSS crudo';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Configurar idioma preferido';
$string['settingsoverview'] = 'Vista general de configuraciones';
$string['settingsoverview_all'] = 'Todas las configuraciones en una página';
$string['settingsoverview_all_desc'] = 'Aquí puede usted abrir la página de las configuraciones de la categoría estándar de Moodle para Boost Union, que muestra todas las configuraciones en una página. Pero tenga cuidado, está muy densa.';
$string['settingsoverview_content_desc'] = 'Las configuraciones para el contenido global de su sitio Moodle están localizadas aquí: Pie de página, páginas estáticas, banners de información. mosaicos de anuncios y deslizadores.';
$string['settingsoverview_feel_desc'] = 'Las configuraciones para el comportamiento global de su sitio Moodle están localizadas aquí: Elementos de navegación, ayudas para la navegación, bloques y enlaces.';
$string['settingsoverview_flavours_desc'] = 'Con sabores, usted puede diversificar el aspecto de su sitio Moodle entre cohortes o entre categorías de curso.';
$string['settingsoverview_functionality_desc'] = 'Aquí están localizadas las configuraciones para funcionalidad adicional relacionada con el curso o global en su sitio Moodle.';
$string['settingsoverview_look_desc'] = 'Configuraciones para marcaje de su sitio Moodle están localizadas aquí: Colores, íconos, imágenes, tamaños y, por supuesto, SCSS personalizado.';
$string['settingsoverview_smartmenus_desc'] = 'Con menúes inteligentes, usted puede extender los elementos de navegación de su sitio Moodle en el menú principal y los menúes de usuario además de introducir un menú del fondo o un menú superior.';
$string['settingsoverview_title'] = 'Vista general de configuraciones de Boost Union';
$string['showfullnameinusermenussetting'] = 'Mostrar nombre completo en el menú del usuario';
$string['showfullnameinusermenussetting_desc'] = 'Con esta configuración, usted puede mostrar el nombre completo de los usuarios ingresados en la parte superior del menú del usuario. Esto puede ser especialmente útil para situaciones de examen donde los profesores tienen que confirmar que el usuario está ingresado con su propia cuenta, pero que también podría ser útil para el usuario mismo. En contraste contra el tema Classic, que muestra el nombre completo del usuario en la Barra de navegación cerca del avatar, esta técnica de aquí no ocupa ningún espacio raro adicional en la Barra de navegación.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Usted está ingresado como:';
$string['showhintcourseguestaccessgeneral'] = 'Usted actualmente está viendo este curso como <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Para tener acceso completo al curso, usted puede <a href="{$a->url}">auto inscribirse a este curso</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso siempre que un usuario esté accediendo al curso con la característica de acceso de invitados. Si elcurso proporciona una auto inscripción activa, también se presentará al usuario  un enlace hacia esa página.';
$string['showhintcoursehiddengeneral'] = 'Este curso actualmente está <strong>oculto</strong>. Solamente los profesores inscritos pueden acceder a este curso cuando está oculto.';
$string['showhintcoursehiddensetting'] = 'Mostrar pista en cursos ocultos';
$string['showhintcoursehiddensetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso mientras la visibilidad del curso esté oculta. Esto ayuda a identificar el estado de visibilidad de un curso de un vistazo sin la necesidad de buscar en las configuraciones del curso.';
$string['showhintcoursehiddensettingslink'] = 'Usted puede cambiar la visibilidad en las <a href="{$a->url}">configuraciones del curso</a>.';
$string['showhintcourseselfenrolfrom'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones desde {$a->from} en adelante.';
$string['showhintcourseselfenrolfromuntil'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones desde {$a->from} hasta {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Si usted no quiere que cualquier usuario Moodle tenga acceso a este curso libremente, por favor restrinja las configuraciones de auto inscripción.';
$string['showhintcourseselfenrolsetting'] = 'Mostrar pista para auto inscripción sin clave de inscripción';
$string['showhintcourseselfenrolsetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso si el curso fuera visible y actualmente fuera posible la inscripción sin clave de inscripción.';
$string['showhintcourseselfenrolsince'] = 'La <strong>{$a->name}</strong> instancia de inscripción permite actualmente la auto inscripción sin restricciones.';
$string['showhintcourseselfenrolsinceuntil'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones hasta {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Este curso actualmente es visible para todos y es posible la  <strong>auto inscripción sin una clave de inscripción</strong>';
$string['showhintcourseselfenrolstartfuture'] = 'Este curso actualmente es visible para todos y está planeado que sea posible la <strong>auto inscripción sin una clave de inscripción</strong>.';
$string['showhintcourseselfenrolunlimited'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones indefinidamente.';
$string['showhintcourseselfenroluntil'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones hasta {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Mostrar pista para acceso de invitado';
$string['showhintforumnotifications'] = 'Este curso actualmente está <strong>oculto</strong>. Esto significa que <strong>los estudiantes NO seránnotificados</strong> en línea ni por Email sobre cualquier mensaje que usted publique en este foro.';
$string['showhintforumnotificationssetting'] = 'Mostrar pista para notificaciones en foro en cursos ocultos';
$string['showhintforumnotificationssetting_desc'] = 'Con esta configuración aparecerá una pista, no solo en el encabezado del curso, sino también en foros siempre que la visibilidad del curso esté oculta. Esto es para clarificar que las notificaciones dentro de un foro no son enviadas a estudiantes y para ayudar a los profesores a comprender esta circunstancia.';
$string['shownavbarstarredcourses_config'] = 'Configurar cursos destacados en la página de \'Mis cursos\'';
$string['shownavbarstarredcourses_label'] = 'Cursos destacados';
$string['shownavbarstarredcoursessetting'] = 'Mostrar popover de cursos destacados en la Barra de Navegación';
$string['shownavbarstarredcoursessetting_desc'] = 'Con esta configuración usted puede mostrar un menú popover con enlaces a cursos destacados junto a los menúes de notificación y mensajes.';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Mostrar cajón de bloque del lado derecho de la página inicial del sitio al primer ingreso.';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Con esta configuración el cajón del lado derecho de la página inicial del sitio será mostrado en su estado expandido de forma predeterminada. Esto solamente aplica a usuarios que ingresan por vez primera y no sobre-escribe el estado del alternador de cada usuario individual.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Mostrar cajón de bloque del lado derecho de la página inicial del sitio en ingreso de invitado.';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Con esta configuración el cajón del lado derecho de la página inicial del sitio será mostrado en su estado expandido de forma predeterminada. Esto solamente aplica a usuarios que ingresan como visitantes.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Mostrar cajón de bloque a la derecha de la página inicial del sitio al visitarla';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Con esta configuración el cajón del lado derecho de la página inicial del sitio será mostrado en su estado expandido de forma predeterminada. Esto solamente aplica a usuarios que NO están ingresados y no sobre-escribe el estado del alternador de cada usuario individual.';
$string['showswitchedroleincoursesetting'] = 'Mostrar pista para rol cambiado';
$string['showswitchedroleincoursesetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso si el usuario ha cambiado su rol en el curso. de forma predeterminada, esta información solamente es mostrada junto al avatar del usuario en el menú del usuario. Al habilitar esta opción, usted puede mostrar esta información junto con un enlace para regresar a su rol - dentro de la página del curso también.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'De forma predeterminada, en la <a href="{$a}">página de gestión del curso</a>, Moodle requiere que usted abra los detalles del curso o que pase por las configuraciones del curso antes de hacer clic en un elemento adicional de la interfaz del usuario para ver el curso. Al habilitar esta configuración, usted puede añadir un ícono para \'Ver curso\' directamente en el listado de la categoría en la página de gestión del curso.';
$string['showviewcourseiconincoursemgntsetting'] = 'Ícono de mostrar vista del curso';
$string['sitebrandingtab'] = 'Marcado personalizado del sitio';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Cajón del bloque a la derecha de la página inicial del sitio';
$string['slidebackgroundimagealtsetting'] = 'Atributo alt de imagen de fondo de página  {$a->no}';
$string['slidebackgroundimagealtsetting_desc'] = 'Aquí puede usted configurar un atributo alt para la imagen de la página {$a->no}. Esta es una configuración opcional, la página será mostrada aun y cuando usted no configure un atributo alt. Por favor tenga en cuenta que el no proporcionar un atributo alt disminuye la accesibilidad.';
$string['slidebackgroundimagesetting'] = 'Imagen del fondo de página {$a->no}';
$string['slidebackgroundimagesetting_desc'] = 'Aquí usted puede subir un archivo de imagen que será mostrada como imagen del fondo detrás del contenido de la página {$a->no}. Por favor asegúrese de comprobar que el contenido sigue siendo legible sobre la imagen de fondo. Por favor también asegúrese que la proporción del aspecto de todas las imágenes de fondo de las páginas sea igual (porque ela proporción de aspecto de la imagen de fondo controla la altura de la página y usted podría querer evitar que parpadee cuando se cambien las páginas). Esta es una configuración obligatoria, la página no será mostrada si usted no sube una imagen de fondo.';
$string['slidecaptionsetting'] = 'Subtítulos de página {$a->no}';
$string['slidecaptionsetting_desc'] = 'Aquí usted escribe el subtítulo que debería ser mostrado en la página {$a->no}. El subtítulo es mostrado al fondo en el centro de la página. Esta es una configuración opcional; la página será mostrada aun y cuando usted no configure un subtítulo.';
$string['slidecontentsetting'] = 'Contenido de página {$a->no}';
$string['slidecontentsetting_desc'] = 'Aquí usted ingresa el contenido que debería ser mostrado en la página {$a->no}.  el contenido es mostrado al fondo centro de la página. Si se configura un subtítulo, el contenido es mostrado debajo del subtítulo. Por favor tenga en cuenta que el editor de texto enriquecido produce texto alineado a la izquierda de forma predeterminada, pero usted podría querer cambiar eso a texto centrado para un aspecto más bonito. Por favor también absténgase de añadir demasiado contenido a la página y por favor pruebe su contenido en dispositivos pequeños porque el contenido que se rebosa de la página simplemente estará oculto. Esta es una configuración opcional, la página será mostrada aunque usted no configure ningún contenido.';
$string['slidecontentstylesetting'] = 'Estilo de contenido de página {$a->no}';
$string['slidecontentstylesetting_dark'] = 'Color oscuro (color negro de font para imágenes claras del fondo)';
$string['slidecontentstylesetting_darkshadow'] = 'Oscuro y Sombra (color negro del font con una sombra clara para imágenes claras de fondo)';
$string['slidecontentstylesetting_desc'] = 'Aquí usted puede modificar el estilo del contenido de la página {$a->no}. De forma predeterminada, el estilo del contenido es un color blanco del font para imágenes de fondo oscuro. Sin embargo, para permitir un estilizado fácil y consistente en todos los tipos de imágenes de fondo, usted puede anular el estilo aquí. Por favor tenga en cuenta que esta configuración sobre-escribirá el color del font que usted configuró en el editor de texto enriquecido arriba en cualquier caso.';
$string['slidecontentstylesetting_light'] = 'Claro (color blanco de font para imágenes oscuras de fondo)';
$string['slidecontentstylesetting_lightshadow'] = 'Claro y Sombra (color blanco de font con una sombra oscura para imágenes oscuras del fondo)';
$string['slideenabledsetting'] = 'Habilitar página {$a->no}';
$string['slideenabledsetting_desc'] = 'Con esta configuración usted puede habilitar página {$a->no}.';
$string['slideheading'] = 'Página {$a->no}';
$string['slidelinksetting'] = 'URL del enlace a página {$a->no}';
$string['slidelinksetting_desc'] = 'Aquí usted puede configurar una URL (interna de Moodle o externa) a la cual se enlazará el contenido de la página de la página {$a->no}. Esta es una configuración opcional; la página será mostrada aun y cuando usted no configure una URL de enlace.';
$string['slidelinksourcesetting'] = 'Fuente del enlace de página {$a->no}';
$string['slidelinksourcesetting_both'] = 'Imagen del fondo y elementos de texto';
$string['slidelinksourcesetting_desc'] = 'Aquí usted puede controlar cuales elementos en el enlace del deslizador enlazan al URL del enlace dado. Usted puede elegir entre enlazar solamente la imagen del fondo, enlazar a los elementos de texto de la página (subtítulos y contenido) o enlazar a ambos dos.';
$string['slidelinksourcesetting_image'] = 'Solamente imagen del fondo';
$string['slidelinksourcesetting_text'] = 'Solamente elementos de texto';
$string['slidelinktargetsetting'] = 'Destino del enlace de página {$a->no}';
$string['slidelinktargetsetting_desc'] = 'Aquí puede usted configurar el destino del enlace que es configurado para el enlace de la página tan pronto como usted configure una URL de enlace en la página {$a->no}.';
$string['slidelinktargetsetting_newtab'] = 'Pestaña nueva';
$string['slidelinktargetsetting_samewindow'] = 'Misma ventana';
$string['slidelinktitlesetting'] = 'Títlo del enlace a página {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Aquí usted puede configurar un título del enlace que es presentado como una herramientita tan pronto como el usuario pasa el ratón encima de la página  {$a->no}. Esta es una configuración opcional, la página será enlazada aun y cuando usted no configure un título del enlace. Por favor tenga en cuenta que el no proporcionar un título del enlace disminuye la accesibilidad.';
$string['slideordersetting'] = 'Posición de ordenamiento de página {$a->no}';
$string['slideordersetting_desc'] = 'Con esta configuración usted define la posición de orden de la página {$a->no}. De forma predeterminada, las páginas están ordenadas como usted la ve aquí en esta página de configuraciones. Sin embargo, usted puede decidir asignar otro orden de posición con esta configuración. Si usted asigna la misma posición de orden a dos o más páginas, serán ordenadas nuevamente, de acuerdo al orden en esta página de configuraciones.';
$string['slideranimationsetting'] = 'Tipo de animación del deslizador';
$string['slideranimationsetting_desc'] = 'Con esta configuración usted controla la animación del deslizador. \'Página\' aplica a una animación deslizante. \'Desvanecido\' aplica una animación que se desvanece y \'Ninguno\' quita todas las animaciones.';
$string['slideranimationsetting_fade'] = 'Desvanecido';
$string['slideranimationsetting_none'] = 'Ninguno';
$string['slideranimationsetting_slide'] = 'Página';
$string['sliderarrownavsetting'] = 'Habilitar navegación por flechas';
$string['sliderarrownavsetting_desc'] = 'con esta configuración usted puede añadir flechas de navegación a ambos lados del deslizador.';
$string['sliderfrontpagepositionsetting'] = 'Posición del deslizador en página inicial del sitio';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Después del contenido de la página inicial del sitio (y después de mosaicos de anuncios)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Después del contenido de la página inicial del sitio (pero antes de mosaicos de anuncios)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Antes del contenido de la página inicial del sitio (y después de mosaicos de anuncios)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Antes del contenido de la página inicial del sitio (pero antes de mosaicos de anuncios)';
$string['sliderfrontpagepositionsetting_desc'] = 'El deslizador soamente es mostrado en la página inicial del sitio. Con esta configuración usted controla si es que el deslizador es mostrado antes del contenido de la página inicial del sitio o después del contenido de la página inicial del sitio. Si usted desea mostrar solamente el deslizador en la página inicial del sitio y nada más, todos los otros contenidos del inicio del sitio pueden ser removidos al cambia las  <a href="{$a->url}">configuraciones de la página inicial del sitio</a>.';
$string['slidergeneralheading'] = 'Deslizador general';
$string['sliderindicatornavsetting'] = 'Habilitar indicadores de navegación al deslizador';
$string['sliderindicatornavsetting_desc'] = 'Con esta configuración, usted puede añadir indicadores de navegación al fondo del deslizador.';
$string['sliderintervalsetting'] = 'Velocidad del intervalo del deslizador';
$string['sliderintervalsetting_desc'] = 'Con esta configuración usted controla por cuanto tiempo se muestra una página en milisegundos. El valor mínimo es 1000 (un segundo) y el valor máximo es 10000 (10 segundos).';
$string['sliderkeyboardsetting'] = 'Permitir interacción de teclado del deslizador';
$string['sliderkeyboardsetting_desc'] = 'Con esta configuración, usted habilita entradas por teclado (tecs de flechas) para controlar el deslizador. Por favor tenga en cuenta que deshabilitar esto disminuye la accesibilidad.';
$string['sliderpausesetting'] = 'Pausar deslizador al pasar el ratón encima';
$string['sliderpausesetting_desc'] = 'Con esta configuración usted impide que el deslizador cicle las páginas cuando un usuario pasa el ratón encima de una página. Por favor tenga en cuenta que deshabilitar esto disminuye la accesibilidad.';
$string['sliderridesetting'] = 'Ciclar las páginas';
$string['sliderridesetting_afterinteraction'] = 'Después de interacción';
$string['sliderridesetting_desc'] = 'Con esta configuración usted controla el comportamiento del ciclado del deslizador, \'Al cargar la página\' inicia  a ciclar páginas después que la página ha terminado de cargar. \'después de interacción\' iniciará el ciclado después que un usuario haya interactuado con la página. \'Nunca\' deshabilita el ciclado automático de páginas por completo, requiriendo que el usuario teclee algo para ciclar páginas.';
$string['sliderridesetting_never'] = 'Nunca';
$string['sliderridesetting_onpageload'] = 'En carga de página';
$string['slidertab'] = 'Deslizador';
$string['sliderwrapsetting'] = 'Ciclar continuamente por las páginas';
$string['sliderwrapsetting_desc'] = 'Con esta configuración usted hace que el deslizador cicle por todas las páginas. Si usted deshabilita esto, el deslizador dejará de ciclar en la última página.';
$string['smartmenus'] = 'Menúes inteligentes';
$string['smartmenus_desc'] = '<p>Los menúes inteligentes le permiten a los administradores del sitio el crear menúes personalizables que pueden ser colocados en diferentes lugares en el sitio, como por ejemplo el menú principal del sitio, el menú del fondo del móvil y el menú del usuario. Los menúes pueden ser configurados para mostrar diferentes tipos de contenido, incluyendo enlaces a otras páginas o recursos, enlaces a categorías, o enlaces al perfil del usuario.</p><p>Los administradores del sitio pueden crear un nuevo menú y especificar los elementos del menú, y mostrar configuraciones. El administrador puede también elegir donde será mostrado el menú en el sitio y si es que debería o no ser visible ´para todos los usuarios o solamente para ciertos roles de usuario.</p>';
$string['smartmenusbycohort'] = 'Por cohortes';
$string['smartmenusbycohort_help'] = 'Restringir la visibilidad basada en los cohortes del usuario.';
$string['smartmenusbydate'] = 'Por fecha';
$string['smartmenusbydate_help'] = 'Restringir la visibilidad basada en la fecha';
$string['smartmenusbydatefrom'] = 'Desde';
$string['smartmenusbydatefrom_help'] = 'Restringir la visibilidad antes de que la fecha dada sea alcanzada';
$string['smartmenusbydateuntil'] = 'Hasta';
$string['smartmenusbydateuntil_help'] = 'Restringir la visibilidad después de que la fecha dada es alcanzada';
$string['smartmenusbylanguage'] = 'Por idioma';
$string['smartmenusbylanguage_help'] = 'Restringir la visibilidad basándose en el idioma del usuario';
$string['smartmenusbyrole'] = 'Por rol';
$string['smartmenusbyrole_help'] = 'Restringir la visibilidad basándose en los roles del usuario.';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Estado de finalización';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'La lista de elementos del menú dinámico de cursos contendrá todos los cursos del usuario que coincidan con el estado de finalización seleccionado. Por ejemplo, si usted seleccionó \'En progreso\' como el estado de finalización, la lista de elementos del menú dinámico de cursos solamente contendrá cursos en los cuales el usuario actual actualmente está trabajando.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Completado';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Inscrito';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'En progreso';
$string['smartmenusdynamiccoursescoursecategory'] = 'Categoría del curso';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'La lista de elementos del menú de cursos dinámico contendrá todos los cursos de las categoría de curso seleccionadas.';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Incluir subcategorías';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'Si se activa, el menú de cursos dinámico también contendrá todos los cursos de las subcategorías de las categorías de cursos seleccionadas.';
$string['smartmenusdynamiccoursesdaterange'] = 'Rango de fechas';
$string['smartmenusdynamiccoursesdaterange_help'] = 'La lista de elementos del menú de cursos dinámico contendrá todos los cursos que caen en el rango de fechas seleccionado.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Futuro';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Pasado';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Presente';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Rol de inscipción';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'La lista dinámica de elementos del menú de cursos contendrá todos los cursos donde el usuario está inscrito con  el rol seleccionado.';
$string['smartmenusexperimental'] = 'Por favor tenga en cuenta: La funcionalidad de menúes inteligentes es completamente usable en el estado actual de implementación, pero tiene que ser <em>considerada como experimental</em> debido a la gran cantidad de combinaciones de configuraciones que aun podrían disparar problemas inesperados. En vista de este hecho, por favor pruebe sus menúes inteligentes con sus configuraciones de menú individuales de forma concienzuda. Si encuentra algún problema, por favor repórtelo en <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> con pasos claros para reproducir el problema.';
$string['smartmenusgeneralsectionheader'] = 'Configuraciones generales';
$string['smartmenusmenuaddnewitem'] = 'Añadir elemento del menú';
$string['smartmenusmenucardform'] = 'Formato tarjeta';
$string['smartmenusmenucardform_help'] = 'Seleccionar el formato de la tarjeta para menúes del estilo de tarjetas, eligiendo entre cuadrado, retrato, paisaje o ancho fluido.';
$string['smartmenusmenucardformfullwidth'] = 'Ancho completo';
$string['smartmenusmenucardformlandscape'] = 'Paisaje';
$string['smartmenusmenucardformportrait'] = 'Retrato';
$string['smartmenusmenucardformsquare'] = 'Cuadro';
$string['smartmenusmenucardoverflowbehavior'] = 'Comportamiento del desborde de tarjeta';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Seleccionar cómo debería de comportarse el menú cuando se desborda de su contenedor, eligiendo entre mostrar una barra de desplazamiento o envolviendo a los elementos desbordados.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'No rodear';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Rodear';
$string['smartmenusmenucardsize'] = 'Tamaño de tarjeta';
$string['smartmenusmenucardsize_help'] = 'Seleccionar el tamaño de la tarjeta para los menúes de estilo tarjeta, eligiendo entre pequeñito, pequeño, mediano o grande.';
$string['smartmenusmenucardsizelarge'] = 'Grande';
$string['smartmenusmenucardsizemedium'] = 'Mediana';
$string['smartmenusmenucardsizesmall'] = 'Pequeña';
$string['smartmenusmenucardsizetiny'] = 'Pequeñita';
$string['smartmenusmenucreate'] = 'Crear menú';
$string['smartmenusmenucreatesuccess'] = 'Menú inteligente creado exitosamente';
$string['smartmenusmenucssclass'] = 'Clase CSS';
$string['smartmenusmenucssclass_help'] = 'Escribir una clase CSS para el menú. Esto puede ser usado para aplicar estilizado personalizado al menú.';
$string['smartmenusmenudeleteconfirm'] = '¿Está seguro de querer eliminar este menú de los menúes inteligentes?';
$string['smartmenusmenudeletesuccess'] = 'Menú inteligente eliminado exitosamente';
$string['smartmenusmenudescription'] = 'Descripción';
$string['smartmenusmenudescription_help'] = 'La descripción del menú. Esto será usado primeramente como documentación interna, pero usted puede mostrarlo dentro del menú al usar la opción para \'Mostrar descripción\'.';
$string['smartmenusmenuduplicate'] = 'Duplicar menú y sus elementos';
$string['smartmenusmenuduplicatesuccess'] = 'Menú y elementos del menú duplicados exitosamente';
$string['smartmenusmenuedit'] = 'Editar menú';
$string['smartmenusmenueditsuccess'] = 'Menú inteligente actualizado exitosamente';
$string['smartmenusmenuitemcardappearanceheader'] = 'Apariencia de tarjeta';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Color del fondo de tarjeta';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Seleccionar el Color del fondo de tarjeta del elemento del menú';
$string['smartmenusmenuitemcardimage'] = 'Imagen de tarjeta';
$string['smartmenusmenuitemcardimage_help'] = 'Seleccionar una imagen a mostrar junto al título del elemento del menú en la tarjeta.';
$string['smartmenusmenuitemcardtextcolor'] = 'Color del texto de tarjeta';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Seleccionar el color para el texto de tarjeta del elemento del menú.';
$string['smartmenusmenuitemcreate'] = 'Crear elemento del menú';
$string['smartmenusmenuitemcreatesuccess'] = 'Elemento del menú inteligente creado exitosamente';
$string['smartmenusmenuitemcssclass'] = 'Clase CSS';
$string['smartmenusmenuitemcssclass_help'] = 'Escribir una clase CSS para el elemento del menú. Esto puede ser usado para aplicar estilizado personalizado al elemento del menú.';
$string['smartmenusmenuitemdeleteconfirm'] = '¿Está seguro de querer eliminar este elemento del menú del menú inteligente?';
$string['smartmenusmenuitemdeletesuccess'] = 'Elemento del menú inteligente eliminado exitosamente';
$string['smartmenusmenuitemdisplayfield'] = 'Presentación del nombre del curso';
$string['smartmenusmenuitemdisplayfield_help'] = 'El nombre del curso que será usado como el título de los elementos del menú dinámico de cursos. Elija entre nombre completo del curso y nombre corto del curso';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Nombre completo del curso';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Nombre corto del curso';
$string['smartmenusmenuitemdisplayoptions'] = 'Presentación del título';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Elegir cómo desea que sea mostrado el título del elemento del menú.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Ocultar texto del título y mostrar solamente ícono (en todos los dispositivos)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Ocultar texto del título y mostrar solamente ícono (en dispositivos móviles)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Mostrar texto y el ícono como título';
$string['smartmenusmenuitemduplicate'] = 'Duplicar elemento del menú';
$string['smartmenusmenuitemduplicatesuccess'] = 'Elemento del menú duplicado exitosamente';
$string['smartmenusmenuitemedit'] = 'Editar elemento del menú';
$string['smartmenusmenuitemeditsuccess'] = 'Elemento del menúiteligente actualizado exitosamente';
$string['smartmenusmenuitemicon'] = 'Ícono';
$string['smartmenusmenuitemicon_help'] = 'El ícono a mostrar junto al título del elemento del menú.';
$string['smartmenusmenuitemlinktarget'] = 'Destino del enlace';
$string['smartmenusmenuitemlinktarget_help'] = 'El destino para el enlace del elemento del menú. El enlace del elemento del menú abrirá en este destino cuando se elija (por ejemplo, en la nueva ventana o en una nueva pestaña).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Nueva pestaña';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Misma ventana';
$string['smartmenusmenuitemlistsort'] = 'Ordenamiento de lista de cursos';
$string['smartmenusmenuitemlistsort_help'] = 'La lista de cursos será ordenada por el criterio seleccionado y orden de ordenamiento. Elija entre nombre completo, nombre corto, ID del curso y número ID del curso como criterio en combinación con orden de ordenamiento ascendente y descendente.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'ID de curso ascendiente';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'ID de curso descendiente';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'Número ID de curso ascendiente';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'Número ID de curso descendiente';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Nombre completo de curso ascendiente';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Nombre completo de curso descendiente';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Nombre corto de curso ascendiente';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Nombre corto de curso descendiente';
$string['smartmenusmenuitemmode'] = 'Modo de elemento del menú';
$string['smartmenusmenuitemmode_help'] = '<p>Seleccione el modo de cómo el elemento del menú debería ser mostrado dentro del menú.</p><ul><li>enLínea: el elemento del menú es mostrado como un elemento regular del menú dentro del menú. esta es la opción predeterminada.</li><li>Submenú: El elemento del menú es mostrado como un elemento submenú, que puede ser expandido o colapsado al hacer clic en el elemento padre. Este modo es útil para construir un tercer nivel de navegación además de ser útil para elementos de menú de cursos dinámicos, donde las listas de cursos pueden ser mostradas como elementos de submenú de este elemento del menú. El título de este elemento del menú es usado como el texto para el elemento del submenú.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'Aun no hay ningún elemento añadido a este menú inteligente. Por favor añada un elemento a este menú.';
$string['smartmenusmenuitemorder'] = 'Ordenamiento';
$string['smartmenusmenuitemorder_help'] = 'Re-arreglar la posición de elemento si fuera necesario. Todos los elementos en el menú serán ordenados por este valor de ordenamiento.';
$string['smartmenusmenuitempresentationheader'] = 'Presentación del elemento del menú';
$string['smartmenusmenuitemresponsive'] = 'Ocultamiento responsivo';
$string['smartmenusmenuitemresponsive_help'] = 'Al habilitar cualquiera de estas casillas de selección, el elemento del menú estará oculto en dispositivos con el tamaño dado de visualización.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Escritroio';
$string['smartmenusmenuitemresponsivemobile'] = 'Móvil';
$string['smartmenusmenuitemresponsivetablet'] = 'Tableta';
$string['smartmenusmenuitemrestriction'] = 'Reglas de acceso';
$string['smartmenusmenuitems'] = 'Elementos del menú';
$string['smartmenusmenuitemstructureheader'] = 'Estructura de elemento del menú';
$string['smartmenusmenuitemtextcount'] = 'Número de palabras';
$string['smartmenusmenuitemtextcount_help'] = 'Especificar el número máximo de palabras a ser mostradas como título en los elementos del menú  de cursos dinámico. Si usted deja este campo vacío, el título será mostrado completamente.';
$string['smartmenusmenuitemtextposition'] = 'Posición de texto en tarjeta';
$string['smartmenusmenuitemtextposition_help'] = '<p>Seleccione la posición del texto del elemento del menú en relación a la imagen de la tarjeta, eligiendo entre debajo de imagen, superior sobrepuesto y fondo sobrepuesto.</p><ul><li>Superior sobrepuesto: Muestra el título del elemento del menú sobre el sobrepuesto y en la parte superior de la tarjeta.</li><li>Fondo sobrepuesto: Muestra el título del elemento del menú sobre el sobrepuesto y al fondo de la tarjeta.</li><li>Debajo de imagen: Muestra el título del elemento del menú debajo de la imagen de la tarjeta.</li></ul>';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Debajo de imagen';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Sobrepuesto al fondo';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Sobrepuesto en superior';
$string['smartmenusmenuitemtitle'] = 'Título';
$string['smartmenusmenuitemtitle_help'] = 'El título del menú. Esto será usado como la etiqueta de este elemento del menú. Si usted quiere mostrar un separador en el menú, elija Encabezado como tipo y use los signos del gato (###) como título.';
$string['smartmenusmenuitemtooltip'] = 'Herramientita';
$string['smartmenusmenuitemtooltip_help'] = 'La herramientita que será mostrada cuando el usuario pase el ratón encima del elemento del menú.';
$string['smartmenusmenuitemtype'] = 'Tipo de elemento del menú';
$string['smartmenusmenuitemtype_help'] = '<p>Seleccionar el tipo de elemento del menú que desea crear, eligiendo entre estático, encabezado y cursos dinámicos.</p><ul><li>Estático: Un elemento de menú estático es simplemente un enlace a una URL fija que no cambia.</li><li>encabezado: Un elemento del menú de encabezado es usado para agrupar elementos del menú relacionados juntos debajo de un encabezado común. NO tiene un enlace y no se le puede dar clic.</li><li>Cursos dinámicos: Un elemento de menú de cursos dinámicos es usado para mostrar una lista de cursos basada en ciertos criterios, como por ejemplo categoría de cursos, rol de inscripción al curso, estado de finalización del curso o rango de fechas. el contenido mostrado en un elemento de menú de cursos dinámicos se actualizará automáticamente conforme cambie el criterio.</li></ul>';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Cursos dinámicos';
$string['smartmenusmenuitemtypeheading'] = 'Encabezado';
$string['smartmenusmenuitemtypestatic'] = 'Estático';
$string['smartmenusmenuitemurl'] = 'URL de elemento del menú';
$string['smartmenusmenuitemurl_help'] = 'La URL estática para el elemento del menú. Este es el enlace a donde será re-dirigido cuando el elemento del menú es seleccionado.';
$string['smartmenusmenulocation'] = 'Ubicación(es) del menú';
$string['smartmenusmenulocation_help'] = '<p>Seleccione las ubicaciones donde desea que aparezca el menú en la página:</p><ul><li>La navegación principal se encuentra en la parte superior de la página donde Moodle ya muestra el Sitio de Inicio, el Panel de control, Mis cursos y elementos de navegación de administración del sitio.</li><li>La barra del menú se encuentra encima de la navegación principal, en la parte superior de la página.</li><li>Se puede acceder al menú del usuario haciendo clic en el avatar del usuario en la barra de navegación.</li><li>La barra inferior se coloca en la parte inferior de la pantalla y se puede utilizar para implementar una navegación en miniatura para acceder fácilmente a áreas importantes, como el Tablero, la página de mis cursos o la página del Sitio de inicio.</li></ul><p>Tenga en cuenta que al habilitar la barra inferior, el ícono de hamburguesa será reemplazado por el logotipo de su sitio, porque los usuarios pueden acceder a la navegación principal usando la barra inferior.</li></ul><p> p>';
$string['smartmenusmenulocationbottom'] = 'Barra al fondo';
$string['smartmenusmenulocationmain'] = 'Navegación principal';
$string['smartmenusmenulocationmenu'] = 'Barra del menú';
$string['smartmenusmenulocationuser'] = 'Menú del usuario';
$string['smartmenusmenumode'] = 'Modo del menú';
$string['smartmenusmenumode_help'] = '<p>Seleccione el modo de cómo los elementos del menú deberían ser mostrados.</p><ul><li>Submenú: Los elementos del menú son mostrados como un submenú con el título del menú como nodo paterno. Esta es la opción predeterminada.</li><li>enLínea: Los elementos del menú son mostrados directamente en la navegación, uno después del otro. Por favor tenga presente que esta opción no está soportada para menús del tipo tarjeta.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Comportamiento del menú Más';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Selecciona lo que debería pasar si hubiera demasiados menúes para acomodar en la localización del menú.</p><ul><li>No cambiar nada: No se aplicará ningún comportamiento particular, los menúes excesivos serán movidos al menú \'Más\' automáticamente.</li><li>Forzar dentro del menú Más: Este modo mueve el menú directamente adentro del menú \'Más\' aunque todavía hubiera espacio.</li><li>Mantener afuera del menú Más: Este modo conserva el menú afuera dl menú \'Más\' tanto como sea posible.</li></ul>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Forzar dentro de menú Más';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Mantener fuera del menú Más';
$string['smartmenusmenunothingtodisplay'] = 'Aun no hay ningún menú inteligente creado. Por favor primeramente cree su primer menú inteligente para que funcionen las cosas.';
$string['smartmenusmenupresentationheader'] = 'Presentación del menú';
$string['smartmenusmenushowdescription'] = 'Mostrar descripción';
$string['smartmenusmenushowdescription_help'] = '<p>Seleccione si/cómo se debe mostrar la descripción en el menú, eligiendo entre Nunca, Arriba, Abajo y Ayuda.</p><ul><li>Nunca: No mostrar la descripción en el menú y utilizarla únicamente para fines internos. Esta es la opción predeterminada.</li><li>Arriba: muestra la descripción en la parte superior de la lista de elementos del menú.</li><li>Debajo: muestra la descripción al final de la lista de menús del menú elementos.</li><li>Ayuda: muestra la descripción como icono de ayuda cerca de la lista de elementos del menú.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Arriba';
$string['smartmenusmenushowdescriptionbelow'] = 'Debajo';
$string['smartmenusmenushowdescriptionhelp'] = 'Ayuda';
$string['smartmenusmenushowdescriptionnever'] = 'Nunca';
$string['smartmenusmenustructureheader'] = 'Estructura del menú';
$string['smartmenusmenutitle'] = 'Título';
$string['smartmenusmenutitle_help'] = 'El título del menú.Esto será usado como la etiqueta del nodo paterno de este menú.';
$string['smartmenusmenutype'] = 'Tipo de presentación';
$string['smartmenusmenutype_help'] = '<p>Selecionar el tipo de presentación para el menú, eligiendo entre lista y tarjeta.</p><ul><li>Lista: Un menú de lista está compuesto de enlaces de texto simple. Esta es la opción predeterminada.</li><li>Tarjeta: Un menú de tarjeta está compuesto de tarjetas.</li></ul>';
$string['smartmenusmenutypecard'] = 'Tarjeta';
$string['smartmenusmenutypelist'] = 'Lista';
$string['smartmenusmodeinline'] = 'enLínea';
$string['smartmenusmodesubmenu'] = 'Submenú';
$string['smartmenusnorestrict'] = 'No restringido';
$string['smartmenusoperator'] = 'Operador';
$string['smartmenusoperator_help'] = 'Seleccionar al operador para la condición de cohorte (Cualquiera o Todos)';
$string['smartmenusrestrictbycohortsheader'] = 'Restringir visibilidad por cohorte';
$string['smartmenusrestrictbydateheader'] = 'Restringir visibilidad por fecha';
$string['smartmenusrestrictbylanguageheader'] = 'Restringir visibilidad por idioma';
$string['smartmenusrestrictbyrolesheader'] = 'Restringir visibilidad por roles';
$string['smartmenusrolecontext'] = 'Contexto';
$string['smartmenusrolecontext_help'] = 'Seleccionar el contexto para el cual el rol del usuario será constatado (Cualquier contexto o contexto sistema solamente)';
$string['smartmenussavechangesandconfigure'] = 'Guardar y configurar elementos';
$string['smartmenussettings'] = 'Configuraciones de menú inteligente';
$string['speciallinksmarkupheading'] = 'Marcado especial de enlaces';
$string['staticpagestab'] = 'Páginas estáticas';
$string['switchedroleto'] = 'Usted actualmente está viendo este curso con el rol de: <strong>{$a->role}</strong>';
$string['task_purgecache'] = 'Purgar caché del tema';
$string['templateemailhtmlprefix'] = '';
$string['templateemailhtmlsuffix'] = '';
$string['templateemailtextprefix'] = '';
$string['templateemailtextsuffix'] = '';
$string['tilebackgroundimagepositionsetting'] = 'Posición de imagen del fondo de mosaico de anuncio {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Con esta configuración usted controla la posición de la imagen del fondo dentro del contenedor del mosaico de anuncio {$a->no}. el primer valor es la posición horizontal y el segundo valor es la posición vertical.';
$string['tilebackgroundimagesetting'] = 'Imagen del fondo de mosaico de anuncio {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Aquí puede usted subir una imagen que será mostrada como imagen del fondo detrás del contenido del mosaico de anuncio {$a->no}. Por favor asegúrese o verifique que el contenido aun es legible sobre de la imagen del fondo. Esta es una configuración opcional, el mosaico de anuncio funcionará aun y cuando usted no suba ninguna imagen de fondo.';
$string['tilecolumnssetting'] = 'Número de columnas de mosaico de anuncios por fila';
$string['tilecolumnssetting_desc'] = 'Aquí usted define el número de columnas por fila en la rejilla presentada de mosaicos de anuncios. Por favor tenga en cuenta que este número de columnas aplica para computadoras de escritorio / pantallas más grandes. en pantallas más pequeñas y pantallas de móviles, las columnas de mosaico de anuncios son acomodadas dando vuelta automáticamente.';
$string['tilecontentsetting'] = 'Mosaico de anuncio {$a->no} contenido';
$string['tilecontentsetting_desc'] = 'Aquí usted configura el contenido que será mostrado en el mosaico de anuncio {$a->no}. el contenido es mostrado a la mitad del mosaico. esta es una configuración adicional, el mosaico de anuncio será mostrado aun cuando usted no configure ningún contenido.';
$string['tilecontentstylesetting'] = 'Estilo de contenido del mosaico de anuncio {$a->no}';
$string['tilecontentstylesetting_dark'] = 'Oscuro (color negro de font para imágenes claras del fondo)';
$string['tilecontentstylesetting_darkshadow'] = 'Oscuro y Sombras (color negro de font con una sombra clara para imágenes claras del fondo)';
$string['tilecontentstylesetting_desc'] = 'Aquí usted puede modificar el estilo del contenido del mosaico de anuncio {$a->no}. de forma predeterminada, el estilo del contenido es controlado por el estilo que usted configura en el editor de texto enriquecido de arriba. sin embargo, para permitir el estilizado fácil y consistente, especialmente l usar texto sobre imágenes de fondo, usted puede anular el estilo aquí.';
$string['tilecontentstylesetting_light'] = 'Claro (color blanco de font para imágenes oscuras del fondo)';
$string['tilecontentstylesetting_lightshadow'] = 'Claro y Sombras (color blanco de font con una sombra oscura para imágenes oscuras del fondo)';
$string['tilecontentstylesetting_nochange'] = 'Sin cambios (controlar todo el estilo en el editor de texto enriquecido)';
$string['tileenabledsetting'] = 'Habilitar mosaico de anuncio {$a->no}';
$string['tileenabledsetting_desc'] = 'Con esta configuración, usted puede habilitar el mosaico de anuncio {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Posición de los mosaicos de anuncio en la página inicial del sitio';
$string['tilefrontpagepositionsetting_after'] = 'Después del contenido de la página inicial del sitio';
$string['tilefrontpagepositionsetting_before'] = 'Antes del contenido de la página inicial del sitio';
$string['tilefrontpagepositionsetting_desc'] = 'Los mosaicos de anuncios son mostrados solamente en la página inicial del sitio. Con esta configuración usted controla si los mosaicos de anuncios son mostrados antes del contenido del la página inicial del sitio o después del contenido de la página inicial del sitio. Si usted quiere mostrar solamente  los mosaicos de anuncios en la página inicial del sitio y nada más, todos los contenidos de la página inicial pueden ser eliminados al cambiar las <a href="{$a->url}">configuraciones de la página inicial del sitio</a>.';
$string['tileheading'] = 'Mosaico de anuncio {$a->no}';
$string['tileheightsetting'] = 'Altura de mosaico de anuncio';
$string['tileheightsetting_desc'] = 'Con esta configuración usted puede controlar la altura de los mosaicos de anuncio. La altura configurada es la altura mínima de cada mosaico. Si el contenido del mosaico es más alto que esta altura configurada, toda la fila de mosaicos será hecha más alta automáticamente cuanto como sea necesario.';
$string['tilelinksetting'] = 'Mosaico de anuncio {$a->no} URL del enlace';
$string['tilelinksetting_desc'] = 'Aquí puede usted configurar una URL (interna o externa) que será ofrecida como un botón de enlace al final del mosaico de anuncio {$a->no}. Esta es una configuración opcional, el mosaico del anuncio funcionará aun cuando usted no haya configurado ninguna URL de enlace..';
$string['tilelinktargetsetting'] = 'Mosaico de anuncio  {$a->no} destino del enlace';
$string['tilelinktargetsetting_desc'] = 'Aquí puede usted configurar el destino del enlace que es configurado para el botón del enlace tan pronto como usted configure una URL de enlace en el mosaico de anuncio {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Nueva pestaña';
$string['tilelinktargetsetting_samewindow'] = 'Misma ventana';
$string['tilelinktitlefallback'] = 'Enlace';
$string['tilelinktitlesetting'] = 'Mosaico de anuncio {$a->no} título del enlace';
$string['tilelinktitlesetting_desc'] = 'Aquí usted puede configurar un título del enlace que será usado como etiqueta del botón del enlace tan pronto como usted configure una URL del enlace en el mosaico de anuncio {$a->no}. Por favor tenga en cuenta que si usted configura una URL del enlace pero no configura un título del enlace, el botón del enlace será etiquetado simplemente con \'Enlace\'';
$string['tileordersetting'] = 'Mosaico de anuncio {$a->no} posición de orden';
$string['tileordersetting_desc'] = 'Con esta configuración usted define la posición del orden del mosaico de anuncio  {$a->no}. De forma predeterminada, los mosaicos de anuncio están ordenados de superior a inferior y de izquierda a derecha tal y como usted los ve en esta página de configuración aquí. Sin embargo, usted puede decidir asignar otra posición de ordenamiento con esta configuración. Si usted asigna la misma posición de ordenamiento a dos o más mosaicos de anuncio, ellos serán ordenados nuevamente de acuerdo al orden en esta página de configuraciones.';
$string['tilesgeneralheading'] = 'Generalidades de mosaicos de anuncio';
$string['tilestab'] = 'Mosaicos de anuncio';
$string['tiletitlesetting'] = 'Título de mosaico de anuncio {$a->no}';
$string['tiletitlesetting_desc'] = 'Aquí usted escribe el título que debería ser mostrado en el mosaico de anuncio {$a->no}. . Esta es una configuración opcional, el mosaico de anuncio será mostrado aun cuando usted no le ponga un título.';
$string['touchiconfilesios'] = 'Archivos de ícono táctil para iOS';
$string['touchiconfilesios_desc'] = 'Con esta opción usted puede subir archivos que son usados como ícono de pantalla inicial tan pronto como el sitio Moodle es añadido a la pantalla inicial de iOS como un marcador.';
$string['touchiconfilesios_example'] = 'Nombre de archivo de ejemplo: apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Los archivos recomendados tienen un buen tamaño para ser mostrados apropiadamente en dispositivos iOS actuales y deberían de ser proporcionados. Los archivos opcionales son (o han sido anteriormente) soportados por dispositivos iOS también, pero deberían realmente ser considerados como opcionales amenos que usted tenga un dispositivo antiguo que deba soportar.';
$string['touchiconfilesios_optional'] = 'Archivos opcionales para iOS:';
$string['touchiconfilesios_recommended'] = 'Archivos recomendados para iOS:';
$string['touchiconfilesioslist'] = 'Archivos de ícono táctil para lista de iOS:';
$string['touchiconfilesioslist_desc'] = 'Esta es la lista de archivos que usted ha subido a los archivos de ícono táctil para el área de archivos de iOS.';
$string['touchiconlistiosoptionalmissing'] = 'Este es un archivo opcional a ser usado como un ícono táctil en dispositivos iOS y NO fue subido.';
$string['touchiconlistiosoptionaluploaded'] = 'Este es un archivo opcional a ser usado como un ícono táctil en dispositivos iOS y fue subido.';
$string['touchiconlistiosrecommendedmissing'] = 'Este es un archivo recomendado a ser  usado como ícono táctil en dispositivos iOS, pero no fue subido apropiadamente.';
$string['touchiconlistiosrecommendeduploaded'] = 'Este es un archivo recomendado a ser  usado como ícono táctil en dispositivos iOS y fue subido.';
$string['upgradenotice_2022080922'] = 'A partir de esta versión, Boost Union tiene sus propias configuraciones de logo y logo compacto y no usa más esos archivos de las configuraciones de Moodle estándar.';
$string['upgradenotice_2022080922_copied'] = 'El <strong>{$a}</strong> existente de las configuraciones del Moodle estándar ha sido copiado a la configuración de {$a} de Boost Union durante esta actualización. Por favor revise dos veces el resultado.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'logo compacto';
$string['upgradenotice_2022080922_notcopied'] = 'La configuración de <strong>{$a}</strong> dentro de Boost Union ahora está vacía. Si usted quiere usar un/una {$a} dentro de Boost Union de ahora en adelante, simplemente súbalo a la configuración de {$a} de Boost Union más tarde.';
$string['usermenuheading'] = 'Menú del usuario';
