<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_o365', language 'nl', version '4.2'.
 *
 * @package     local_o365
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acp_coursesynccustom'] = 'Aangepaste cursussynchronisatie';
$string['acp_coursesynccustom_bulk'] = 'Bulk acties';
$string['acp_coursesynccustom_bulk_disable'] = 'Cursussynchronisatie uitschakelen voor cursussen op deze pagina';
$string['acp_coursesynccustom_bulk_enable'] = 'Cursussynchronisatie inschakelen voor cursussen op deze pagina';
$string['acp_coursesynccustom_confirm_all_action'] = 'Weet je zeker dat je de synchronisatiestatus van alle cursussen wilt wijzigen? Dit kan niet ongedaan worden gemaakt.';
$string['acp_coursesynccustom_controlled_per_course'] = 'Cursussynchronisatie configureren in cursus toestaan';
$string['acp_coursesynccustom_controlled_per_course_desc'] = 'Indien ingeschakeld kunnen aangemelde gebruikers in Moodle die beschikken over de permissie om op te treden als Team-eigenaar (met de permissie "Team eigenaar" [local/o365:teamowner]) de cursussynchronisatie beheren vanuit het Microsoft blok in de cursus.';
$string['acp_coursesynccustom_disable_all'] = 'Cursussynchronisatie uitschakelen in alle cursussen';
$string['acp_coursesynccustom_enable_all'] = 'Cursussynchronisatie inschakelen in alle cursussen';
$string['acp_coursesynccustom_enabled'] = 'Ingeschakeld';
$string['acp_coursesynccustom_new_course'] = 'Standaard ingeschakeld voor nieuwe cursus';
$string['acp_coursesynccustom_new_course_desc'] = 'Indien ingeschakeld wordt bij alle nieuwe cursussen standaard de synchronisatie ingeschakeld.';
$string['acp_coursesynccustom_off'] = 'Uitgeschakeld<br />Teams uitschakelen voor alle cursussen.';
$string['acp_coursesynccustom_onall'] = 'Alle features ingeschakeld<br />Schakel aanmaken Teams in voor alle cursussen.';
$string['acp_coursesynccustom_oncustom'] = 'Aangepast<br />Stelt geautoriseerde gebruikers in staat te selecteren voor welke cursussen Teams worden gemaakt:<br><span id="adminsetting_coursesync" style="font-weight: bold"><a href="{$a}">Aangepaste cursussynchronisatie</a></span>';
$string['acp_coursesynccustom_savemessage'] = 'Je wijzigingen zijn opgeslagen.';
$string['acp_coursesynccustom_sds_course'] = 'Vergrendeld voor SDS cursus';
$string['acp_coursesynccustom_searchwarning'] = 'Let op: Zoekopdrachten zullen alle niet opgeslagen voortgang verliezen. Klik op Bewaar wijzigingen om ervoor te zorgen dat je wijzigingen worden opgeslagen.';
$string['acp_coursesynccustom_settings_header'] = 'Sync-opties';
$string['acp_healthcheck'] = 'Health check';
$string['acp_maintenance'] = 'Onderhoudshulpmiddelen';
$string['acp_maintenance_cleandeltatoken'] = 'Delta Tokens gebruikerssynchronisatie opruimen';
$string['acp_maintenance_recreatedeletedgroups_course'] = 'Cursus';
$string['acp_maintenance_recreatedeletedgroups_course_group'] = 'Cursusgroep';
$string['acp_maintenance_recreatedeletedgroups_group_type_course'] = 'Cursus';
$string['acp_maintenance_recreatedeletedgroups_group_type_course_group'] = 'Cursusgroep';
$string['acp_maintenance_recreatedeletedgroups_status'] = 'Status';
$string['acp_maintenance_recreatedeletedgroups_status_created_fail'] = 'Aanmaken groep mislukt';
$string['acp_maintenance_recreatedeletedgroups_status_created_success'] = 'Groep is opnieuw aangemaakt';
$string['acp_maintenance_recreatedeletedgroups_status_sync_disabled'] = 'Cursussynchronisatie is uitgeschakeld';
$string['acp_maintenance_resyncgroupusers'] = 'Gebruikers opnieuw synchroniseren in Microsoft 365 groepen voor cursussen';
$string['acp_maintenance_resyncgroupusers_course_output'] = 'Output opnieuw synchroniseren';
$string['acp_parentsite_name'] = 'Moodle';
$string['acp_teamconnection'] = 'Team-verbinding beheren';
$string['acp_teamconnections'] = 'Team-verbindingen beheren';
$string['acp_teamconnections_actions'] = 'Acties';
$string['acp_teamconnections_connected_team'] = 'Verbonden Team';
$string['acp_teamconnections_current_connection'] = 'HUIDIGE VERBINDING';
$string['acp_teamconnections_exception_invalid_team_id'] = 'Onogeldig Team ID';
$string['acp_teamconnections_exception_no_unified_token'] = 'Unified token ophalen voor API calls mislukt.';
$string['acp_teamconnections_exception_not_configured'] = 'Microsoft 365 is niet volledig geconfigureerd.';
$string['acp_teamconnections_form_team'] = 'Selecteer Team';
$string['acp_teamconnections_group_only'] = '(Alleen groep)';
$string['acp_teamconnections_invalid_connection'] = 'Ongeldige verbinding';
$string['acp_teamconnections_no_owner'] = 'Eigenaar toevoegen om te verbinden met Teams.';
$string['acp_teamconnections_not_connected'] = 'Niet verbonden';
$string['acp_teamconnections_sync_disabled'] = 'Cursussynchronisatie moet eerst worden ingeschakeld om Teams verbindingen te kunnen beheren.';
$string['acp_teamconnections_table_cannot_create_team_from_group'] = 'Kan geen Team aanmaken van groep - geen eigenaar';
$string['acp_teamconnections_table_connect'] = 'Verbinden';
$string['acp_teamconnections_table_connect_to_different_team'] = 'Verbind met een ander Team';
$string['acp_teamconnections_table_update'] = 'Bijwerken';
$string['acp_teamconnections_team_missing'] = '(Team ontbreekt)';
$string['acp_tenants_actions'] = 'Acties';
$string['acp_tenants_add'] = 'Nieuwe tenant toevoegen';
$string['acp_tenants_additional_tenants'] = 'Bijkomende tenants';
$string['acp_tenants_delete'] = 'Verwijderen';
$string['acp_tenants_hosttenant'] = 'Host Tenant: {$a}';
$string['acp_tenants_legacy_tenants'] = 'Legacy tenants (Actie vereist)';
$string['acp_tenants_none'] = 'Je hebt geen tenants geconfigureerd. ALs je multitenancy hebt ingeschakeld in Azure AD, is je Moodle site mogelijk open voor alle Microsoft 365 gebruikers.';
$string['acp_tenants_revokeaccess'] = 'Toegang intrekken';
$string['acp_tenants_tenant'] = 'Tenant';
$string['acp_tenants_title'] = 'Multitenancy';
$string['acp_tenants_title_desc'] = 'Op deze pagina kun je toegang voor multitenancy vanuit Microsoft 365 voor Moodle instellen.';
$string['acp_tenantsadd_linktext'] = 'Doorgaan naar inlogpagina Microsoft 365';
$string['acp_userconnections'] = 'Gebruikersverbindingen beheren';
$string['acp_userconnections_column_actions'] = 'Acties';
$string['acp_userconnections_column_muser'] = 'Moodle gebruiker';
$string['acp_userconnections_column_o365user'] = 'Microsoft 365 gebruiker';
$string['acp_userconnections_column_status'] = 'Verbindingsstatus';
$string['acp_userconnections_column_usinglogin'] = 'Met login';
$string['acp_userconnections_filtering_muserfullname'] = 'Volledige naam in Moodle';
$string['acp_userconnections_filtering_musername'] = 'Gebruikersnaam in Moodle';
$string['acp_userconnections_filtering_o365username'] = 'Gebruikersnaam in Microsoft 365';
$string['acp_userconnections_manualmatch_musername'] = 'Moodle gebruiker';
$string['acp_userconnections_manualmatch_o365username'] = 'Gebruikersnaam in Moodle 365';
$string['acp_userconnections_manualmatch_uselogin'] = 'Log in met Microsoft 365';
$string['acp_userconnections_resync_notconnected'] = 'Deze gebruiker is niet verbonden met Microsoft 365';
$string['acp_userconnections_table_connected'] = 'Verbonden';
$string['acp_userconnections_table_disconnect'] = 'Verbinding verbreken';
$string['acp_userconnections_table_noconnection'] = 'Geen verbinding';
$string['acp_userconnections_table_resync'] = 'Opnieuw synchroniseren';
$string['acp_userconnections_table_unmatch'] = 'Match ongedaan maken';
$string['acp_usermatch'] = 'Gebruikers matchen';
$string['acp_usermatch_matchqueue'] = 'Stap 2: Wachtrij voor matchen';
$string['acp_usermatch_matchqueue_clearall'] = 'Alles opruimen';
$string['acp_usermatch_matchqueue_clearerrors'] = 'Fouten opruimen';
$string['acp_usermatch_matchqueue_clearqueued'] = 'In wachtrij opruimen';
$string['acp_usermatch_matchqueue_clearsuccess'] = 'Opruimen succesvol';
$string['acp_usermatch_matchqueue_column_muser'] = 'Gebruikersnaam in Moodle';
$string['acp_usermatch_matchqueue_column_o365user'] = 'Gebruikersnaam in Microsoft 365';
$string['acp_usermatch_matchqueue_column_openidconnect'] = 'OpenID Connect';
$string['acp_usermatch_matchqueue_column_status'] = 'Status';
$string['acp_usermatch_matchqueue_status_error'] = 'Fout: {$a}';
$string['acp_usermatch_matchqueue_status_queued'] = 'In wachtrij';
$string['acp_usermatch_matchqueue_status_success'] = 'Succesvol';
$string['acp_usermatch_upload'] = 'Stap 1: Nieuwe matches uploaden';
$string['settings_adminconsent'] = 'Beheerderstoestemming';
$string['settings_adminconsent_btn'] = 'Geef beheerderstoestemming';
$string['settings_adminconsent_details'] = 'Om toegang te verkrijgen tot de nodige rechten, moet een beheerder toestemming geven. Klik op deze knop en meld je dan aan met een Azure-beheerder om toestemming te geven. Dit is nodig, telkens je beheerdersrechten wijzigt in Azure.';
$string['settings_coursesync'] = 'Cursussynchronisatie';
$string['settings_coursesync_courses_per_task'] = 'Aantal cursussen te synchroniseren per taak';
$string['settings_coursesync_courses_per_task_details'] = 'Het aantal cursussen waarvan de Team/groep-status gesynchroniseerd moet worden bij elke uitvoering van de geplande taak.';
$string['settings_coursesync_delete_group_on_course_deletion'] = 'Verwijder de Microsoft 365-groep, als de verbonden Moodle-cursus verwijderd werd.';
$string['settings_coursesync_delete_group_on_course_deletion_details'] = 'Indien ingeschakeld, zal Moodle de Microsoft 365-groep (en het bijhorend Team) verwijderen als de verbonden cursus verwijderd werd uit Moodle. Let op: dit geldt niet voor cursussen die aangemaakt werden via SDS-sync';
$string['settings_coursesync_delete_group_on_course_sync_disabled'] = 'Verwijder de Microsoft 365-groepen als cursus-synchronisatie is uitgeschakeld';
$string['settings_coursesync_delete_group_on_course_sync_disabled_details'] = 'Indien ingeschakeld, zal Moodle de verbonden Microsoft 365-groep (en bijhorend Team) proberen te verwijderen als de cursus-synchronisatie uitgeschakeld is voor een Moodle-cursus.';
$string['settings_coursesync_details'] = 'Indien ingeschakeld, worden er Teams aangemaakt en onderhouden voor cursussen op de Moodle-site (Standaard: uitgeschakeld). Dit zal alle nodige Teams aanmaken tijdens elke cron-uitvoering en zal alle huidige toegewezen gebruikers als Team-beheerders en leden toevoegen, afhankelijk van de mogelijkheid. Nadien worden de Team-lidmaatschappen onderhouden, als er gebruikers ingeschreven of uitgeschreven worden uit Moodle-cursussen.';
$string['settings_secthead_coursesync_desc'] = 'Met deze instellingen kan je de synchronisatie tussen Moodle en Microsoft Teams beheren.';
$string['settings_serviceresourceabstract_detect'] = 'Detecteer';
$string['settings_serviceresourceabstract_detecting'] = 'Bezig met detecteren';
$string['settings_serviceresourceabstract_empty'] = 'Geef een waarde in of klik op "Detecteer" om te proberen de correcte waardes detecteren.';
$string['settings_serviceresourceabstract_error'] = 'Er is een fout opgetreden bij het detecteren van de instellingen. Geef deze manueel op.';
$string['settings_serviceresourceabstract_invalid'] = 'Deze waarde lijkt niet geldig te zijn.';
$string['settings_serviceresourceabstract_valid'] = '{$a} is geldig.';
$string['settings_setup_step1'] = 'Stap 1/3: Registreer Moodle bij Azure AD';
$string['settings_setup_step1_credentials_end'] = 'Als het onmogelijk is om de AzureAD-app te installeren via PowerShell, <a href="https://aka.ms/MoodleTeamsManualSetup" target="_blank">klik hier</a> voor de manuele instructies.';
$string['settings_setup_step1_desc'] = 'Registreer een nieuwe AzureAD Applicatie voor jouw Microsoft 365 omgeving door gebruik te maken van Windows PowerShell:

<a href="{$a}/local/o365/scripts/Moodle-AzureAD-Powershell.zip" class="btn btn-primary" target="_blank">Download Windows PowerShell Script</a>

<p style="margin-top:10px"><a href="https://aka.ms/MoodleTeamsPowerShellReadMe" target="_blank">Klik hier</a> om de instructies te lezen om het script te laten lopen.</p>
<p>Indien gevraagd, gebruik deze link als Moodle URL:</p><h5><b>{$a}</b></h5>';
$string['settings_setup_step1_existing_settings'] = 'Bestaande instellingen';
$string['settings_setup_step1clientcreds'] = '<br />Als het script succesvol uitgevoerd is, kopieer de Application ID en Secret die getoond worden door het script in de <a href="{$a}">OpenID Connect authentication plugin configuratie-pagina</a>.';
$string['settings_setup_step2'] = 'Stap 2/3: Kies de verbindingsmethode';
$string['settings_setup_step2_desc'] = 'Deze sectie laat je toe om te kiezen hoe de Microsoft 365 integration-suite verbinding maakt met de Microsoft 365-diensten.<br />
In het verleden was het mogelijk om de Microsoft 365-diensten te verbinden via "Toepassingsmachtigingen" of via een toegewezen gebruiker via "Gedelegeerde machtigingen".<br />
<b>Sinds maart 2022 wordt enkel nog "Toepassingsmachtigingen" ondersteund. Alle toekomstige nieuwe functies zullen enkel nog geïmplementeerd en getest worden met de "Toepassingsmachtigingen"-verbindingsmethode.</b>';
$string['settings_setup_step3'] = 'Stap 3/3: Beheerderstoestemmingen &amp; extra informatie';
$string['settings_setup_step3_desc'] = 'Deze laatste stap laat toe om de beheerder toestemming te geven om een aantal Azure-rechten te gebruiken en verzamelt bijkomende informatie over je Microsoft 365-omgeving.<br /><br />';
$string['ucp_connection_linked'] = 'Koppel je accounts in Moodle en Microsoft 365';
