<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'nl', version '4.2'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acessar'] = 'Toegang tot cursus';
$string['background_color'] = 'Achtergrondkleur';
$string['background_color_desc'] = 'Achtergrondkleur van bovenkant en voettekst!';
$string['background_color_random'] = 'Willekeurig thema {$a}';
$string['choosereadme'] = 'Boost Magnific is een thema met zorg ontworpen om vrolijke kleuren naar Moodle te brengen.';
$string['contact_address'] = 'Adres';
$string['contact_email'] = 'E-mail';
$string['contact_phone'] = 'Telefoonnummer';
$string['content_pagefonts'] = 'Extra lettertypen van Google';
$string['content_pagefonts_desc'] = 'Voeg hier de @import-link van Google toe voor extra lettertypen.<br>Je kunt meerdere imports toevoegen.<br><a href="https://fonts.google.com/selection/embed" target="google">Inbedcode</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Standaard Moodle';
$string['content_type_empty'] = '(Geen inhoud)';
$string['content_type_footer'] = 'Inhoudstype voor voettekst';
$string['content_type_footer_desc'] = 'Selecteer het type inhoud dat je in de voettekst wilt weergeven.';
$string['content_type_home'] = 'Inhoudstype voor startpagina';
$string['content_type_home_desc'] = 'Selecteer het type inhoud dat je op de startpagina wilt weergeven.';
$string['content_type_html'] = 'Pagina die moet worden gemaakt met editor';
$string['continuar'] = 'Blijf studeren';
$string['countlesson'] = '{$a} les';
$string['countlessons'] = '{$a} lessen';
$string['customcss'] = 'Aangepaste CSS';
$string['customcss_desc'] = 'Alle CSS-regels die je aan dit tekstgebied toevoegt, worden weerspiegeld op alle pagina\'s, waardoor het gemakkelijk is om dit thema aan te passen.';
$string['custommenuitems'] = 'Aangepast hoofdmenu-items';
$string['custommenuitems_desc'] = 'Je kunt een aangepast menu maken naast de hoofdmenu\'s. Het hoofdmenu moet vlak langs de rand beginnen, en submenu\'s moeten worden voorafgegaan door een koppelteken (-). Het aantal koppeltekens bepaalt de diepte van het item. Zo verschijnen items met een enkel koppelteken in een submenu onder het vorige topniveau-item, en items met twee koppeltekens verschijnen in een submenu onder het voorafgaande submenu.
De inhoud van elk menu-item moet bestaan uit maximaal drie elementen (<strong>label</strong> | <strong>url</strong> | <strong>tooltip</strong> | <strong>lang</strong>), gescheiden door het "|"-teken.
<ul>
<li><strong>label</strong>: Dit is de tekst die binnen het menu-item wordt weergegeven. Je moet een label opgeven voor elk menu-item.</li>
<li><strong>url</strong>: Dit is de URL waarnaar de gebruiker wordt geleid wanneer hij op het menu-item klikt. Dit is optioneel; als het niet wordt opgegeven, wordt het item nergens gelinkt.<br>
Andere attributen zoals "target" kunnen worden toegevoegd aan het einde van de URL.</li>
<li><strong>tooltip</strong>: Als je een URL opgeeft, kun je er ook voor kiezen om een tooltip te geven voor de link die is gemaakt met de URL. Dit is optioneel, en als het niet is gedefinieerd, wordt het label gebruikt als de tooltip voor het menu-item.</li>
<li><strong>lang</strong>: Je kunt een taalcode toevoegen (of een door komma\'s gescheiden lijst van codes) als het vierde element van de regel. De regel wordt alleen weergegeven als de gebruiker de vermelde ta(a)l(en) heeft geselecteerd.</li>
</ul>
Hieronder staat een voorbeeld van hoe je een aangepast menu zou maken:
<blockquote><pre>
Cursussen
-Alle cursussen | /cursus/
-Mijn cursussen
--Voorbeeldcursus
---Voorbeeldcursus 7 | /cursus/bekijken.php?id=7
---Voorbeeldcursus 9 | /cursus/bekijken.php?id=9
--Testcursus
---Testcursus 2 | /cursus/bekijken.php?id=2
---Testcursus 5 | /cursus/bekijken.php?id=5
Google
-Google in elke taal | https://google.com/" target="_blank
-Google in Mexico | https://www.google.com.mx/" target="_blank|Google Label|en
-Google in het Portugees | https://google.com.br/" target="_blank|Google Label|pt,pt_br,pt_br_kids
Ondersteuningspagina | https://support.com/" target="_blank
</pre></blockquote>
Voor Moodle met ondersteuning voor meerdere talen moet de waarde van <strong>label</strong> worden opgemaakt als <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profiel,moodle | /gebruiker/profiel.php
berichten,bericht | /bericht/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/nl/Gevorderde_thema-instellingen" target="_blank">Meer menu-informatie</a>';
$string['editor_link_footer'] = 'Bewerk het voettekstblok voor de {$a} taal';
$string['editor_link_footer_all'] = 'Bewerk het voettekstblok voor alle talen';
$string['editor_link_home'] = 'Bewerk de startpagina voor de {$a} taal';
$string['editor_link_home_all'] = 'Bewerk de startpagina voor alle talen';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Het favicon wordt naast de paginatitel weergegeven in het tabblad van de browser. Een Moodle-favicon wordt weergegeven als er geen aangepast favicon is verstrekt.';
$string['fontfamily'] = 'Lettertypen voor de site';
$string['fontfamily_desc'] = 'Kies welk lettertype je wilt gebruiken voor de tekst op je Moodle-site.';
$string['fontfamily_menus'] = 'Menulettertypen';
$string['fontfamily_menus_desc'] = 'Kies welk lettertype je wilt gebruiken voor menu\'s op je Moodle-site.';
$string['fontfamily_sitename'] = 'Lettertype voor de sitenaam';
$string['fontfamily_sitename_desc'] = 'Het lettertype dat wordt toegepast op de sitenaam als er geen logo wordt verstrekt.';
$string['fontfamily_title'] = 'Lettertypen voor titels';
$string['fontfamily_title_desc'] = 'Kies welk lettertype je wilt gebruiken voor titels op je Moodle-site.';
$string['fontpreview'] = 'Voorbeeld van Lettertypeoverzicht';
$string['footer_contact_title'] = 'Titel van contactblok';
$string['footer_contact_title_default'] = 'Neem contact met ons op';
$string['footer_contact_title_desc'] = 'Voer de titel in van het blok dat in de voettekst verschijnt met de contactgegevens.';
$string['footer_description'] = 'Beschrijving';
$string['footer_description_desc'] = 'Beschrijf jouw Moodle, wat je doet, en deze informatie wordt onder het logo in de voettekst van Moodle getoond';
$string['footer_frontpage_blockcourses_instructor'] = 'Toon de naam van de professor';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Als aangevinkt, toont het de namen van professoren in de cursuslijst!';
$string['footer_frontpage_blockcourses_text'] = 'Korte tekst die het blok "{$a}" uitlegt';
$string['footer_frontpage_blockcourses_text_desc'] = 'Voeg een tekst toe die spreekt over "{$a}"!';
$string['footer_links_title'] = 'Titel van koppelingsblok';
$string['footer_links_title_default'] = 'Belangrijke koppelingen';
$string['footer_show_copywriter'] = 'Getoond met ❤️';
$string['footer_show_copywriter_desc'] = 'Afvinken als je "Gemaakt met ❤️" wilt verbergen';
$string['footer_social_title'] = 'Titel van koppelingsblok voor sociale media';
$string['footer_social_title_default'] = 'Volg ons op sociale media';
$string['footer_social_title_desc'] = 'Voer de titel in van het blok dat in de voettekst verschijnt met de gegevens van jouw sociale netwerken.';
$string['footerblink'] = 'Koppelingen van voettekstblok';
$string['footerblink_desc'] = 'Je kunt hier een Voettekst Blok Links configureren om te worden getoond door thema\'s.<br>Elke regel bestaat uit enkele menutekst of taalsleutel of tekst, een koppeling-URL (optioneel), gescheiden door verticale strepen. Bijvoorbeeld:<br><pre>Moodle-ondersteuning|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Contactblok';
$string['footerblock_copywriter'] = 'Gemaakt met ❤️';
$string['footerblock_description'] = 'Beschrijvingsblok';
$string['footerblock_links'] = 'Links blok';
$string['footerblock_social'] = 'Sociaal blok';
$string['free_name'] = 'Gratis';
$string['frontpage_about_description'] = 'Beschrijf wat je doet';
$string['frontpage_about_description_desc'] = 'Beschrijf in maximaal 5 regels het doel van jouw Moodle';
$string['frontpage_about_enable'] = 'Schakel het Over blok in';
$string['frontpage_about_enable_desc'] = 'Als aangevinkt, zal het Over blok onder de Banner verschijnen!';
$string['frontpage_about_info'] = 'Gegevensbox {$a}';
$string['frontpage_about_logo'] = 'Verschillend logo om hier te tonen';
$string['frontpage_about_logo_desc'] = 'Indien ingesteld, wordt dit logo hier gebruikt in plaats van het top-logo.<br>Niet ingesteld gebruikt het top-logo!';
$string['frontpage_about_number'] = 'Hoeveelheid gegevens';
$string['frontpage_about_number_desc'] = 'Voer de hierboven genoemde hoeveelheid informatie in';
$string['frontpage_about_text'] = 'Gegevensnaam';
$string['frontpage_about_text_1_defalt'] = 'Cursussen';
$string['frontpage_about_text_2_defalt'] = 'Docenten';
$string['frontpage_about_text_3_defalt'] = 'Studenten';
$string['frontpage_about_text_4_defalt'] = 'Lessen';
$string['frontpage_about_text_desc'] = 'Voer de naam van de gegevens in die op de startpagina worden getoond';
$string['frontpage_about_title'] = 'Titel Over blok';
$string['frontpage_about_title_default'] = 'Onze wereldwijde gemeenschap';
$string['heart'] = 'Als je dit thema leuk vindt, vergeet dan niet om op ❤️ te klikken op de themapagina <a href="{$a}" target="_blank">door hier te klikken</a>';
$string['instructor'] = 'Instructeur';
$string['login_backgroundcolor'] = 'Achtergrondkleur';
$string['login_backgroundcolor_desc'] = 'Selecteer de achtergrondkleur van de pagina voor wachtwoordherstel';
$string['login_backgroundfoto'] = 'Achtergrondafbeelding';
$string['login_backgroundfoto_desc'] = 'Selecteer de achtergrondafbeelding voor inloggen/wachtwoordherstel/account aanmaken. Standaardafbeelding is: {$a}';
$string['login_forgot_description'] = 'Tekst aan de zijkant van het scherm Wachtwoord vergeten';
$string['login_forgot_description_desc'] = 'Tekst die alleen op het scherm Wachtwoord vergeten verschijnt';
$string['login_login_description'] = 'Tekst aan de zijkant van het inlogscherm';
$string['login_login_description_desc'] = 'Tekst die alleen op het inlogscherm verschijnt';
$string['login_signup_description'] = 'Tekst aan de zijkant van het scherm Een account aanmaken';
$string['login_signup_description_desc'] = 'Tekst die alleen op het scherm Een account aanmaken verschijnt';
$string['login_theme'] = 'Inlogthema';
$string['login_theme_block'] = 'Centraal wit blok met optionele achtergrond';
$string['login_theme_desc'] = 'Kies welk thema je wil in het inloggebied';
$string['login_theme_image_login'] = 'Achtergrondafbeelding en inloggen aan de zijkant';
$string['login_theme_imagetext_login'] = 'Achtergrondafbeelding, tekst over de afbeelding en inloggen aan de zijkant';
$string['login_theme_login'] = 'Alleen inlogscherm, geen zijafbeelding';
$string['logo_color'] = 'Gekleurd Logo';
$string['logo_color_desc'] = 'Upload alstublieft uw gekleurde LOGO als u het bovenaan wilt opnemen. Dit logo wordt weergegeven terwijl de pagina wordt gescrold, en het menu wordt weergegeven op een witte achtergrond.';
$string['logo_write'] = 'Logo van het bovenste menu tijdens scrollen';
$string['logo_write_desc'] = 'Upload alsjeblieft je logo als je het bovenaan wilt opnemen. Dit logo wordt weergegeven wanneer het scrollen bovenaan blijft, en het menu wordt weergegeven op een gekleurde achtergrond.';
$string['matricular'] = 'Inschrijven';
$string['mycourses_color'] = 'Achtergrondkleur blok';
$string['mycourses_color_desc'] = 'De achtergrondkleur voor het blok.';
$string['mycourses_icon'] = 'Pictogram';
$string['mycourses_icon_desc'] = 'Een representatief pictogram voor het blok. Pictogramgrootte moet 48x48 pixels zijn.';
$string['mycourses_info'] = 'Blok {$a}';
$string['mycourses_numblocos'] = 'Geen blokken';
$string['mycourses_numblocos_desc'] = 'Hoeveel afbeeldingen wil je in de diavoorstelling?';
$string['mycourses_numblocos_nenhum'] = 'Geen dia\'s op de startpagina';
$string['mycourses_title'] = 'Korte bloktitel';
$string['mycourses_title_desc'] = 'Een korte en beschrijvende titel voor het blok.';
$string['mycourses_url'] = 'Blok link';
$string['mycourses_url_desc'] = 'De URL om naartoe te navigeren bij het klikken op het blok. Het kan een externe link of een interne link binnen het platform zijn.';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'Het Boost Magnific-thema slaat geen persoonlijke gegevens op over een gebruiker.';
$string['settings_about_heading'] = 'Over je Moodle';
$string['settings_css_heading'] = 'Lettertypen en CSS';
$string['settings_footer_heading'] = 'Voettekst Blok';
$string['settings_icons_block'] = 'Pictogram {$a}';
$string['settings_icons_change_icons'] = 'Verander het standaardpictogram in de cursuslijst';
$string['settings_icons_default_audio_file'] = 'Audio';
$string['settings_icons_default_book'] = 'Boek';
$string['settings_icons_default_download'] = 'Downloaden';
$string['settings_icons_default_game'] = 'Spel';
$string['settings_icons_default_money'] = 'Financieel';
$string['settings_icons_default_slide'] = 'Dia\'s';
$string['settings_icons_default_support'] = 'Ondersteuning';
$string['settings_icons_default_video_file'] = 'Video';
$string['settings_icons_heading'] = 'Pictogrammen';
$string['settings_icons_image'] = 'Pictogramafbeelding';
$string['settings_icons_image_desc'] = 'Upload de SVG- of PNG-afbeelding van het gewenste pictogram om in de cursus te vervangen.<br>Aanbevolen grootte: 24px. Als PNG, onthoud de transparantie.';
$string['settings_icons_module_disable'] = 'Aangepaste pictogramselectie is uitgeschakeld. Activeer in {$a}';
$string['settings_icons_name'] = 'Pictogramnaam';
$string['settings_icons_name_desc'] = 'Voeg de pictogramnaam toe voor eenvoudige selectie in de module';
$string['settings_icons_none'] = 'Geen aangepaste pictogrammen';
$string['settings_icons_num'] = 'Aantal pictogrammen';
$string['settings_icons_num_desc'] = 'Aantal aangepaste pictogrammen dat u wilt toevoegen';
$string['settings_icons_select_icon'] = 'Selecteer het aangepaste pictogram. Bewerk in {$a}';
$string['settings_login_heading'] = 'Inlogscherm';
$string['settings_mycourses_heading'] = 'Mijn cursusblokken';
$string['settings_slideshow_heading'] = 'Diavoorstelling';
$string['settings_theme_heading'] = 'Thema';
$string['settings_top_heading'] = 'Hoofdmenu';
$string['sitefonts'] = 'Extra Google-lettertypen';
$string['sitefonts_desc'] = 'Voeg de @import-code van Google-lettertypen in zoals aangegeven in de afbeelding hieronder. Na het opslaan wordt het veld \'Site Lettertype\' bijgewerkt en worden deze lettertypen weergegeven. Je kunt indien nodig meerdere @import toevoegen.';
$string['slidecaption_desc'] = 'Voer de bijschrifttekst in die op de dia moet worden gebruikt';
$string['slideshow_image'] = 'Dia Afbeelding';
$string['slideshow_image_desc'] = 'De afbeelding moet 1250px X 400px zijn.';
$string['slideshow_info'] = 'Dia {$a}';
$string['slideshow_numslides'] = 'Hoeveel afbeeldingen in de diavoorstelling';
$string['slideshow_numslides_desc'] = 'Hoeveel afbeeldingen wilt u in de diavoorstelling?';
$string['slideshow_numslides_nenhum'] = 'Geen dia\'s op de startpagina';
$string['slideshow_text'] = 'Korte beschrijvende tekst voor de dia';
$string['slideshow_text_desc'] = 'Voeg een korte tekst toe over de dia.';
$string['slideshow_url'] = 'Knoppenlink voor dia\'s';
$string['slideshow_url_desc'] = 'Voeg de bestemmingslink in voor de knop van de dia-afbeelding';
$string['social_facebook'] = 'Jouw Facebook';
$string['social_facebook_desc'] = 'De Facebook-URL van jouw organisatie.';
$string['social_instagram'] = 'Jouw Instagram';
$string['social_instagram_desc'] = 'De Instagram-URL van jouw organisatie.';
$string['social_linkedin'] = 'Jouw Linkedin';
$string['social_linkedin_desc'] = 'De Linkedin-URL van jouw organisatie.';
$string['social_twitter'] = 'Jouw Twitter';
$string['social_twitter_desc'] = 'De Twitter-URL van jouw organisatie.';
$string['social_youtube'] = 'Jouw Youtube';
$string['social_youtube_desc'] = 'De Youtube-URL van jouw organisatie.';
$string['theme_boost_magnific_about_editbooton'] = 'Over blok bewerken';
$string['theme_boost_magnific_frontpage_bloco'] = 'Blok "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Thuisblokken';
$string['theme_boost_magnific_mycourses_editbooton'] = 'Blokken bewerken';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Diavoorstelling bewerken';
$string['theme_color'] = 'Kleurselectie';
$string['theme_color-color_buttons'] = 'Knoppenkleur';
$string['theme_color-color_buttons_desc'] = 'De kleur die wordt gebruikt voor knoppen, voegt visuele samenhang toe en benadrukt interactieve acties.';
$string['theme_color-color_names'] = 'Namenkleur';
$string['theme_color-color_names_desc'] = 'Kleur gebruikt om namen of identificatoren te markeren, zorgt voor duidelijkheid en nadruk op specifieke tekstinformatie.';
$string['theme_color-color_primary'] = 'Primaire kleur';
$string['theme_color-color_primary_desc'] = 'De belangrijkste primaire kleur van het thema, meestal gebruikt voor highlight- en nadrukselementen.';
$string['theme_color-color_secondary'] = 'Secundaire kleur';
$string['theme_color-color_secondary_desc'] = 'Een secundaire kleur die complementair is aan de primaire kleur, gebruikt om secundaire elementen te markeren of te contrasteren met de primaire kleur.';
$string['theme_color-color_titles'] = 'Titelkleur';
$string['theme_color-color_titles_desc'] = 'De kleur die wordt gebruikt voor titels, zorgt voor nadruk en visuele structuur van de pagina-inhoud.';
$string['theme_color_blue'] = 'Blauw';
$string['theme_color_desc'] = 'Selecteer de kleuren van Moodle-teksten en knoppen of klik op de lijn hieronder:';
$string['theme_color_green'] = 'Groen';
$string['theme_color_green_d'] = 'Donkergroen';
$string['theme_color_heading'] = 'Kleurselectie omgeving';
$string['theme_color_red_d'] = 'Rood';
$string['theme_color_sugestion'] = 'Kleursuggestie';
$string['theme_color_sugestion_text'] = 'Klik op de lijn om de kleur toe te passen op de onderstaande velden:';
$string['theme_color_violet'] = 'Paars';
$string['theme_login_branco'] = 'Alleen inlogscherm, geen zijafbeelding, met het formulier op een witte achtergrond';
$string['top_color_heading'] = 'Kleur van bovenkant scrollen';
$string['top_scroll'] = 'Maak het menu vast bij het scrollen van de pagina';
$string['top_scroll_background_color'] = 'Achtergrondkleur van bovenmenu bij scrollen';
$string['top_scroll_background_color_desc'] = 'Stel de achtergrondkleur in wanneer de pagina wordt gescrold.';
$string['top_scroll_desc'] = 'Indien ingeschakeld, wordt het menu bovenaan het scherm vastgemaakt terwijl u de pagina scrollt, zodat je gemakkelijk toegang hebt tot de menuopties.';
$string['top_scroll_text_color'] = 'Tekstkleur van menu bij scrollen';
$string['top_scroll_text_color_desc'] = 'Stel de tekstkleur van het menu in wanneer de pagina wordt gescrold.';
$string['vvveb_home_access'] = 'Toegang tot cursus';
$string['vvveb_home_automatically_my_course'] = 'Niet bewerken. Dit blok wordt automatisch vervangen door de cursussen waarvoor de student is ingeschreven.';
$string['vvveb_home_mycourses_heading'] = 'Mijn cursussen';
$string['vvveb_home_popular_course'] = 'Populaire cursussen';
$string['vvveb_home_team_subtitle'] = 'Wij zijn een groep professionals die zich inzetten voor hun werk';
$string['vvveb_home_team_title'] = 'Ontmoet ons team';
