<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'cs', version '4.2'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Akceptovat';
$string['accept_grades'] = 'Akceptovat hodnocení z nástroje';
$string['accept_grades_admin'] = 'Akceptovat hodnocení z nástroje';
$string['accept_grades_admin_help'] = 'Určete, zda poskytovatel nástroje může přidávat, aktualizovat, číst a mazat známky spojené s instancí tohoto nástroje.

Někteří poskytovatelé nástroje podporují reportování známek zpátky do Moodle postavené na aktivitách v rámci nástroje, vytváří integrovanější zkušenost.';
$string['accept_grades_help'] = 'Specifikujte, zda poskytovatel nástroje může přidávat, aktualizovat, číst a odstraňovat ohodnocení spojená pouze s instancí tohoto externího nástroje.

Někteří poskytovatelé nástrojů podporují zpětné hlášení ohodnocení v Moodle založené na akcích vykonaných v rámci nástroje, čím se nástroj jeví ještě lépe integrován.

Poznámka: Toto nastavení lze v konfiguraci nástroje ignorovat.';
$string['accepted'] = 'Přijato';
$string['action'] = 'Akce';
$string['activate'] = 'Aktivovat';
$string['activatetoadddescription'] = 'Než budete moci přidat popis, musíte nejdříve aktivovat tento nástroj.';
$string['active'] = 'Aktivita';
$string['activity'] = 'činnosti';
$string['add_ltiadv'] = 'Přidat pokročilý LTI';
$string['add_ltilegacy'] = 'Přidat starý LTI';
$string['addnewapp'] = 'Povolit externí aplikaci';
$string['addserver'] = 'Přidat nový důvěryhodný server';
$string['addtype'] = 'Přidat externí konfigurační nástroj';
$string['allow'] = 'Povolit';
$string['allowsetting'] = 'Povolit nástroj pro ukládání 8K v nastavení Moodlu';
$string['always'] = 'Vždy';
$string['autoaddtype'] = 'Přidat nástroj';
$string['automatic'] = 'Automaticky, na základě nástroje URL';
$string['baseurl'] = 'Základní URL/registrované jméno aplikace';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth základní řetězec';
$string['basiclti_endpoint'] = 'Návrat LTI';
$string['basiclti_in_new_window'] = 'Vaše aktivita byla otevřena v novém okně';
$string['basiclti_in_new_window_open'] = 'Otevřít v novém okně';
$string['basiclti_parameters'] = 'Parametry spuštění LTI';
$string['basicltiactivities'] = 'LTI činnosti';
$string['basicltifieldset'] = 'Příklad vlastního nastavení pole';
$string['basicltiintro'] = 'Popis činnosti';
$string['basicltiname'] = 'Jméno činnosti';
$string['basicltisettings'] = 'Základní nastavení LTI (Learning Tool Interoperability)';
$string['cachedef_keyset'] = 'Ukládá informace o sadách klíčů do mezipaměti nástrojů';
$string['cancel'] = 'Zrušit';
$string['cancelled'] = 'Zrušeno';
$string['cannot_delete'] = 'Nemůžete zrušit konfiguraci tohoto nástroje.';
$string['cannot_edit'] = 'Nemůžete upravit konfiguraci tohoto nástroje.';
$string['capabilities'] = 'Pravomoci';
$string['capabilities_help'] = 'Vyberte ty funkce, které chcete nabídnout poskytovateli nástrojů. Může být zvolena více než jedna volba.';
$string['capabilitiesrequired'] = 'Aby se aktivoval tento nástroj, vyžaduje přístup k těmto údajům:';
$string['cleanaccesstokens'] = 'Externí nástroj odstranění přístupových tokenů';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Pokračujte kliknutím</a>';
$string['clientidadmin'] = 'ID klienta';
$string['clientidadmin_help'] = 'ID klienta lze považovat za jedinečnou hodnotu použitou k identifikaci nástroje. Vytváří se automaticky pro každý nástroj, který používá bezpečnostní profil JWT uvedený v LTI 1.3 a měl by být součástí detailů předaných poskytovateli nástroje, aby mohli nakonfigurovat spojení na konci.';
$string['comment'] = 'Poznámka';
$string['configpassword'] = 'Výchozí heslo vzdáleného nástroje';
$string['configpreferheight'] = 'Výchozí preferovaná výška';
$string['configpreferwidget'] = 'Jako výchozí spuštění nastavit widget';
$string['configpreferwidth'] = 'Výchozí preferovaná šířka';
$string['configresourceurl'] = 'Výchozí URL zdroje';
$string['configtoolurl'] = 'Výchozí URL vzdáleného nástroje';
$string['configtypes'] = 'Povolit aplikace LTI';
$string['configured'] = 'Konfigurováno';
$string['confirmtoolactivation'] = 'Jsi si jistý, že chcete aktivovat tento nástroj?';
$string['contentitem_deeplinking'] = 'Podporuje přímé odkazování (zpráva s položkou obsahu)';
$string['contentitem_deeplinking_help'] = 'Pokud je zaškrtnuto, budou při přidávání externího nástroje k dispozici možnost "Vybrat obsah ".';
$string['contentitem_multiple_description'] = 'K vašemu kurzu budou přidány následující položky:';
$string['contentitem_multiple_graded'] = 'Hodnocená aktivita (maximální známka: {$a})';
$string['course_tool_types'] = 'Nástroje kurzu';
$string['courseactivitiesorresources'] = 'Činnosti kurzu nebo zdroje materiálů';
$string['courseid'] = 'ID číslo kurzu';
$string['courseinformation'] = 'Informace kurzu';
$string['courselink'] = 'Přejít na kurz';
$string['coursemisconf'] = 'Kurz je špatně konfigurován';
$string['createdon'] = 'Vytvořeno';
$string['curllibrarymissing'] = 'Pro Externí nástroj musí být nainstalována knihovna  PHP Curl';
$string['custom'] = 'Uživatelské parametry';
$string['custom_config'] = 'Použít vlastní nástroj konfigurace.';
$string['custom_help'] = 'Uživatelské parametry jsou nastavení používaná poskytovatelem nástroje. Kupříkladu, uživatelský parametr se může použít na zobrazení specifického zdroje od poskytovatele.

Je bezpečné nechat toto pole nezměněné, není-li to nařízeno poskytovatelem nástroje.';
$string['custominstr'] = 'Uživatelské parametry';
$string['debuglaunch'] = 'Volby ladění';
$string['debuglaunchoff'] = 'Normální spuštění';
$string['debuglaunchon'] = 'Spuštění v ladícím režimu';
$string['default'] = 'Výchozí';
$string['default_launch_container'] = 'Kontejner výchozího spuštění';
$string['default_launch_container_help'] = 'Kontejner spuštění ovlivňuje zobrazení nástroje při spouštění z kurzu. Některé kontejnery spuštění vytvářejí plochu v zobrazení kurzu, jiné se integrují do prostředí Moodle.

* **Standardní** - Použije kontejner spuštění specifikován konfigurací nástroje.
* **Vložený** - Nástroj se zobrazí v rámci stávajícího okna Moodle způsobem podobným většině ostatních typů aktivit.
* **Vložený, bez bloků** - Nástroj se zobrazí v rámci stávajícího okna Moodle, pouze s ovládači navigace v horní části stránky.
* **Nové okno** - Nástroj se otevře v novém okně, zabírající celý dostupný prostor.
     V závislosti od prohlížeče jej otevře v nové tabulce nebo vyskakovacím okně.
     Je možné, že prohlížeče zabrání otevření nového okna.';
$string['delegate'] = 'Delegovat na učitele';
$string['delegate_tool'] = 'Jak je uvedeno v definici přímých odkazů nebo delegování na učitele';
$string['delete'] = 'Odstranit';
$string['delete_confirmation'] = 'Jste si jisti, že chcete odstranit tuto konfiguraci externího nástroje?';
$string['deletetype'] = 'Odstranit konfiguraci externího nástroje';
$string['display_description'] = 'Při spuštění zobrazit jmého činnosti';
$string['display_description_help'] = 'Je-li tato možnost zvolena, popis činnosti (specifikovaný výše) se zobrazí nad obsahem nástroje.

Popis lze využít k poskytnutí dodatečných instrukcí po uživatele spouštějícího nástroj, ale není povinný.

Popis se nikdy nezobrazí, je-li kontejner spouštění nástroje otevřen v novém okně.';
$string['display_name'] = 'Při spuštění zobrazit jmého činnosti';
$string['display_name_help'] = 'Je-li tato možnost zvolena, název činnosti (specifikovaný výše) se zobrazí nad obsahem nástroje.

Je možné, že poskytovatel nástroje zobrazí jeho název taky. Tato možnost zabrání tomu, aby se název zobrazil dvakrát.

Název se nikdy nezobrazí, je-li kontejner spouštění nástroje otevřen v novém okně.';
$string['domain_mismatch'] = 'Nástroj URL domény spuštění neodpovídá konfiguraci nástroje.';
$string['donot'] = 'Neodeslat';
$string['donotaccept'] = 'Nepřijmout';
$string['donotallow'] = 'Nepovolit';
$string['duplicateregurl'] = 'Tato registrace URL je již používána';
$string['dynreg_update_btn_new'] = 'Zaregistrovat jako nový externí nástroj';
$string['dynreg_update_btn_update'] = 'Aktualizovat';
$string['dynreg_update_name'] = 'Název nástroje';
$string['dynreg_update_notools'] = 'V kontextu nejsou žádné nástroje.';
$string['dynreg_update_text'] = 'K doméně registrace jsou připojeny existující nástroje. Chcete aktualizovat již nainstalovaný externí nástroj nebo vytvořit nový externí nástroj?';
$string['dynreg_update_url'] = 'Základní URL';
$string['dynreg_update_version'] = 'Verze LTI';
$string['dynreg_update_warn_dupdomain'] = 'Nedoporučuje se mít více externích nástrojů ve stejné doméně.';
$string['editdescription'] = 'K získání popise nástroje klikněte zde';
$string['edittype'] = 'Úprava konfigurace externího nástroje';
$string['embed'] = 'Vložený';
$string['embed_no_blocks'] = 'Vložený bez bloků';
$string['enableemailnotification'] = 'Odeslat potvrzující emaily';
$string['enableemailnotification_help'] = 'Je-li tato možnost aktivována, studující dostanou emailovou notifikaci tehdy, když jsou jejich práce odeslané prostřednictvím nástroje ohodnoceny.';
$string['enterkeyandsecret'] = 'Zadejte svůj uživatelský klíč a sdílený klíče';
$string['enterkeyandsecret_help'] = 'Pokud jste dostali uživatelský klíč a/nebo sdílený klíč, zadejte je zde';
$string['errorbadurl'] = 'Adresa URL není platná adresa URL nástroje nebo balíčku.';
$string['errorincorrectconsumerkey'] = 'Uživatelský klíč je neplatný.';
$string['errorinvaliddata'] = 'Neplatná data: {$a}';
$string['errorinvalidmediatype'] = 'Neplatný typ média: {$a}';
$string['errorinvalidresponseformat'] = 'Neplatný obsah - Formát položky odpovědi.';
$string['errormisconfig'] = 'Nekonfigurovatelný nástroj. Požádejte správce Moodle aby nastavil konfiguraci tohoto nástroje.';
$string['errortooltypenotfound'] = 'Typ nástroje LTI nebyl nalezen.';
$string['existing_window'] = 'Stávající okno';
$string['extensions'] = 'Externí služby LTI';
$string['external_tool_type'] = 'Nakonfigurovatelný nástroj';
$string['external_tool_type_help'] = '* **Automaticky, na základě URL nástroje** - Nejlepší konfigurační nástroj je vybrán automaticky. Není-li URL adresa nástroje rozpoznána, může být nutné zadat konfigurační detaily ručně do konfiguračního nástroje.
* **Konkrétní předkonfigurovaný nástroj** - Konfigurační nástroj pro konkrétní nástroje bude použit při komunikaci s externím poskytovatelem nástrojů. V případě, že URL adresa nástroje nevypadá, že patří k poskytovateli, zobrazí se varování. Není vždy nutné zadávat URL nástroje.
* **Vlastní konfigurace** - Uživatelský klíč a sdílený klíč může být nutné zadat ručně. Uživatelský klíč a sdílený klíč lze získat od poskytovatele nástroje. Nicméně, ne všechny nástroje vyžadují uživatelský klíč a sdílený klíč, v těchto případech mohou být pole prázdné.


### Předkonfigurovaný editační nástroj

Pro přednastavený nástroj jsou k dispozici tři ikony v rozbalovacím seznamu:

* **Přidat** - Vytvořit konfiguraci nástrojů na úrovni kurzů. Všechny externí instance nástroje v tomto kurzu mohou použít konfigurační nástroj.
* **Upravit** - Vybrat nástroj na úrovni kurzů z rozbalovací nabídky a poté klepněte na tuto ikonu.  Mohou být upravovány podrobnosti o konfiguraci nástroje.
* **Odstranit** - Odstranit vybraný nástroj na úrovni kurzu.';
$string['external_tool_types'] = 'Nakonfigurovatelnénástroje';
$string['failedtoconnect'] = 'Moodle nemůže komunikovat se systémem  "{$a}"';
$string['failedtocreatetooltype'] = 'Nepodařilo se vytvořit nový nástroj. Zkontrolujte prosím adresu URL a zkuste to znovu.';
$string['failedtodeletetoolproxy'] = 'Nepodařilo se smazat registraci nástroje. Možná budete muset navštívit "Správa externích registrací nástroje" a odstranit ji ručně.';
$string['filter_basiclti_configlink'] = 'Nakonfigurujte své oblíbené weby a jejich hesla';
$string['filter_basiclti_password'] = 'Heslo je povinné';
$string['filterconfig'] = 'Správa LTI';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Pro špatně nastavenou konfiguraci použijte existující';
$string['fixnew'] = 'Nová konfigurace';
$string['fixnewconf'] = 'Pro špatně nastavenou konfiguraci definujte novou konfiguraci';
$string['fixold'] = 'Použijte existující';
$string['force_ssl'] = 'Vnutit SSL';
$string['force_ssl_help'] = '\'Volba této možnosti donutí použít SSL pro všechna spuštění směrem k poskytovateli tohoto nástroje.

Kromě toho i všechny požadavky webové služby od poskytovatele nástroje budou používat SSL.

Používáte-li tuto možnost, potvrďte, že tento Moodle portál a poskytovatel nástroje podporují SSL.';
$string['forced_help'] = 'Toto nastavení bylo vynuceno v konfiguraci úrovně kurzu nebo portálu. Z tohoto rozhraní jej nemůžete změnit.';
$string['generaltool'] = 'Obecný nástroj';
$string['global_tool_types'] = 'Předkonfigurované nástroje';
$string['grading'] = 'Směrování známek';
$string['icon_url'] = 'URL ikony';
$string['icon_url_help'] = 'URL adresa ikony umožňuje, aby se dala ikona, která se zobrazuje ve výpisu kurzů pro tuto činnosti, upravovat. Namísto použití standardní ikony LTI lze specifikovat ikonu, která vyjadřuje typ činnosti.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'Kognitivní LTI';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě LTI.';
$string['indicator:cognitivedepthdef'] = 'Kognitivní LTI';
$string['indicator:cognitivedepthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta kognitivní angažovanosti nabízené aktivitami LTI (Úrovně = Bez zobrazení, Zobrazení, Příspěvek, Zobrazení zpětné vazby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociální LTI';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě LTI.';
$string['indicator:socialbreadthdef'] = 'Sociální LTI';
$string['indicator:socialbreadthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta sociální angažovanosti nabízené aktivitou LTI  (Úrovně = Bez účasti, Účastník sám, Účastník s ostatními)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'Spustit přihlašovací adresu URL';
$string['initiatelogin_help'] = 'Adresa URL nástroje, na kterou mají být odeslány požadavky na zahájení přihlášení. Tato adresa URL je vyžadována před úspěšným odesláním zprávy do nástroje.';
$string['invalidid'] = 'LTI ID bylo chybné';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Typ veřejného klíče';
$string['keytype_help'] = 'Metoda ověřování použitá k ověření nástroje.';
$string['keytype_keyset'] = 'Adresa URL sady klíčů';
$string['keytype_rsa'] = 'Klíč RSA';
$string['launch_in_moodle'] = 'Spustit nástroj v Moodle';
$string['launch_in_popup'] = 'Spustit nástroj ve vyskakovacím okně';
$string['launch_url'] = 'Nástroj URL';
$string['launch_url_help'] = 'Adresa URL nástroje udává webovou adresu Externího nástroje, a může obsahovat další informace, jako jsou zdroje pro zobrazení informací.
Pokud si nejste jisti, co zapsat na URL nástroje, obraťte se na poskytovatele nástrojů pro další informace.

Můžete zadat URL balíčku, pokud máte jeden údaj, a zbytek formuláře se automaticky vyplní.

Pokud jste zvolili přednastavený nástroj, nepotřebujete zadávat URL nástroj. Je-li použit  odkaz nástroje, stačí spustit v systému poskytovatele nástroje, a nepřecházet na konkrétní zdroj, to bude pravděpodobně tento případ.';
$string['launchinpopup'] = 'Spustit kontejner';
$string['launchinpopup_help'] = '\'Kontejner spuštění ovlivňuje zobrazení nástroje při spouštění z kurzu. Některé kontejnery spuštění vytvářejí plochu v zobrazení kurzu, jiné se integrují do prostředí Moodle.

* **Standardní** - Použije kontejner spuštění specifikován konfigurací nástroje.
* **Vložený** - Nástroj se zobrazí v rámci stávajícího okna Moodle způsobem podobným většině ostatních typů aktivit.
* **Vložený, bez bloků** - Nástroj se zobrazí v rámci stávajícího okna Moodle, pouze s ovládači navigace v horní části stránky.
* **Nové okno** - Nástroj se otevře v novém okně, zabírající celý dostupný prostor.
     V závislosti od prohlížeče jej otevře v nové tabulce nebo vyskakovacím okně.
   Je možné, že prohlížeče zabrání otevření nového okna.';
$string['launchoptions'] = 'Možnosti spuštění';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Přidat konfigurace specifických nástrojů kurzu';
$string['lti:addinstance'] = 'Přidat nový externí nástroj';
$string['lti:addmanualinstance'] = 'Přidat ručně nakonfigurovaný nástroj';
$string['lti:addpreconfiguredinstance'] = 'Přidat předkonfigurovaný nástroj';
$string['lti:admin'] = 'Buďte při spuštění nástroje správcem';
$string['lti:grade'] = 'Zobrazit zámky vrácené externím nástrojem';
$string['lti:manage'] = 'Buďe instruktorem při spuštění nástroje';
$string['lti:requesttooladd'] = 'Požadavky na nástroj jsou nastaveny na celý web';
$string['lti:view'] = 'Spustit LTI činnosti';
$string['lti_administration'] = 'Úprava předkonfigurovaného nástroje';
$string['lti_errormsg'] = 'Nástroj vrátil následující chybovou zprávu: "{$a}"';
$string['lti_launch_error'] = 'Při spuštění externího nástroje se objevila chyba:';
$string['lti_launch_error_tool_request'] = '<p>
Abyste poslal administrátorovi požadavek na dokončení konfigurace nástroje, klikněte <a href="{$a->admin_request_url}" target="_top">zde</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Tato chyba může být důsledkem chybějícího zákaznického klíče a sdíleného hesla pro poskytovatele nástroje.</p>
<p>Máte-li zákaznický klíč a sdílené heslo, můžete je zadat při editování instance externího nástroje (přesvědčte se, že jsou rozšířené možnosti viditelné).</p>
<p>Alternativně, můžete <a href="{$a->course_tool_editor}">vytvořit konfiguraci na úrovni kurzu pro poskytovatele nástroje</a>.
</p>';
$string['lti_tool_request_added'] = 'Požadavek na konfiguraci byl úspěšně odeslán. Možná budete muset kontaktovat správce k dokončení  konfigurace.';
$string['lti_tool_request_existing'] = 'Konfigurace nástroje pro doménu nástroje byla již odeslána.';
$string['ltisettings'] = 'Nastavení LTI';
$string['ltiunknownserviceapicall'] = 'Neznámé volání LTI služby API.';
$string['ltiversion'] = 'Verze LTI';
$string['ltiversion_help'] = 'Verze LTI používá pro podepisování zpráv a servisních požadavků: LTI 1.0 / 1.1 a LTI 2.0 používají bezpečnostní profil OAuth 1.0A; LTI 1.3.0 používá JWT.';
$string['main_admin'] = 'Obecná nápověda';
$string['main_admin_help'] = 'Externí nástroje umožňují uživatelům Moodle hladce komunikovat se studijními zdroji hostovanými vzdáleně. Prostřednictvím speciálního protokolu spuštění, bude mít vzdálený nástroj přístup k některým obecným informacím o uživateli. Například, název instituce, ID kurzu, ID uživatele a další informace, jako je jméno uživatele nebo e-mail.

Nástroje uvedené na této stránce jsou rozděleny do tří kategorií:

* **Aktivní** -  Tito poskytovatelé nástroje byly schváleny a konfigurovány správcem. Mohou být použity v rámci kurzu na těchto stránkách. Jsou-li zadány uživatelský a sdílený klíč, je navázáno důvěryhodné spojení  mezi touto stránkou a vzdáleným nástrojem, který poskytuje zabezpečený komunikační kanál.
* **Čekající** - Tito poskytovatelé nástroje byli importování balíčkem, ale nebyly nakonfigurováni správcem. Učitelé mohou i nadále používat nástroje z těchto poskytovatelů, pokud mají uživatelský  a sdílený klíč, nebo pokud nejsou vyžadovány.
* **Odmítnuté** - Tito poskytovatelé nástroje jsou označeny tak, že je správce nemá v úmyslu dzpřístupnit na webu. Učitelé mohou i nadále používat nástroje z těchto poskytovatelů, pokud mají uživatelský  a sdílený  klíč, nebo pokud nejsou vyžadovány.';
$string['manage_external_tools'] = 'Správa nástrojů';
$string['manage_tool_proxies'] = 'Správa registrací externích nástrojů';
$string['manage_tools'] = 'Správa předkonfigurovaných nástrojů';
$string['manuallyaddtype'] = 'Případně můžete  <a href="{$a}">nastavit nástroj manuálně</a>.';
$string['miscellaneous'] = 'Různé';
$string['misconfiguredtools'] = 'Byly zjištěny chybné nástroje';
$string['missingparameterserror'] = 'Stránka je chybná: "{$a}"';
$string['module_class_type'] = 'Typ modulu Moodle';
$string['modulename'] = 'Externí nástroj';
$string['modulename_help'] = 'Modul Externí nástroj umožňuje studentům pracovat s prostředky a činnostmi na jiných webových stránkách. Externí nástroj může například poskytovat přístup k novému typu činnosti nebo k výukovým materiálům od jiného vydavatele.

Chcete-li vytvořit modul Externí nástroj, je nutné, aby poskytovatel nástroje podporoval LTI (Learning Tools Interoperability). Učitel může vytvořit modul Externí nástroj nebo využít nástroje, které nakonfiguroval správce stránek.

Modul Externí nástroj se liší od modulu URL v několika aspektech:

* Externí nástroje mají automaticky přístup k informacím o uživateli, který spustil daný nástroj - např. jeho jméno, instituci či kurz.
* Externí nástroje podporují čtení, aktualizaci a odstranění hodnocení spojené s činností daného studenta.
* Konfigurace modulu Externí nástroj vytvoří důvěryhodné spojení mezi vaším Moodle a nástrojem poskytovatele umožňující bezpečnou komunikaci mezi nimi.';
$string['modulename_link'] = 'mod/lti/view';
$string['modulename_shortcut_link'] = 'mod/lti/view/custom';
$string['modulenameplural'] = 'Externí nástroje';
$string['modulenamepluralformatted'] = 'Externí nástroje';
$string['name'] = 'Jméno';
$string['never'] = 'Nikdy';
$string['new_window'] = 'Nové okno';
$string['no_lti_configured'] = 'Není nakonfigurován žádný aktivní externí nástroj.';
$string['no_lti_pending'] = 'Nejsou žádné čekající externí nástroje.';
$string['no_lti_rejected'] = 'Nejsou žádné odmítnuté externí nástroje.';
$string['no_lti_tools'] = 'Neexistují žádné nakonfigurované externí nástroje.';
$string['no_tp_accepted'] = 'Neexistují žádné přijaté registrace externích nástrojů.';
$string['no_tp_cancelled'] = 'Neexistují žádné zrušené  registrace externích nástrojů.';
$string['no_tp_configured'] = 'Neexistují žádné neregistrované nakonfigurované registrace externích nástrojů.';
$string['no_tp_pending'] = 'Neexistují žádné nevyřízené registrace externích nástrojů.';
$string['no_tp_rejected'] = 'Neexistují žádné odmítnuté registrace externích nástrojů.';
$string['noattempts'] = 'Pro instanci tohoto nástroje nebyly provedeny žádné pokusy';
$string['noltis'] = 'Nejsou žádné instance LTI';
$string['noprofileservice'] = 'Profil služby nebyl nalezen';
$string['noservers'] = 'Nenalezen server';
$string['notypes'] = 'Zatím není v Moodle nastaven žádný LTI nástroj. Klikněte na odkaz Instaluj nahoře a některý přidejte.';
$string['noviewusers'] = 'Nebyl nalezen žádný uživatel  s oprávněním používat tento nástroj';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 vyžaduje, aby byl pro váš webový server nakonfigurován a dostupný platný soubor openssl.cnf. Chcete-li konfigurovat a povolit openssl pro tento web, kontaktujte správce webu.';
$string['optionalsettings'] = 'Možnosti nastavení';
$string['organization'] = 'Detaily organizace';
$string['organizationdescr'] = 'Popis organizace';
$string['organizationid_default'] = 'Výchozí ID organizace';
$string['organizationid_default_help'] = 'Výchozí hodnota pro ID organizace. ID stránek identifikuje tuto instalaci Moodle.';
$string['organizationidguid'] = 'ID organizace';
$string['organizationidguid_help'] = 'Unikátní identifikátor pro tuto instanci Moodle předaný nástroji jako Platforma instance GUID.

Pokud je toto pole prázdné, použije se výchozí hodnota.';
$string['organizationurl'] = 'URL organizace';
$string['organizationurl_help'] = 'Základní adresa URL této instance Moodle.

Je-li toto pole prázdné, výchozí hodnota je použita na základě konfigurace serveru.';
$string['pagesize'] = 'Počet odpovědí na stránku';
$string['parameter'] = 'Parametry nástroje';
$string['parameter_help'] = 'Parametry nástroje jsou požadovaná nastavení, které mají být předány poskytovatelem nástrojů v akceptovaném nástroji proxy.';
$string['password'] = 'Sdílené heslo';
$string['password_admin'] = 'Sdílené heslo';
$string['password_admin_help'] = 'Sdílené heslo může být považováno za heslo použité k ověření přístupu k nástroji. Může být poskytnuto spolu se zákaznickým klíčem poskytovatele nástroje.

Nástroje, které nevyžadují od Moodle bezpečnou komunikaci a neposkytují dodatečné služby (např. zpětné hlášení hodnocení), nemusí požadovat sdílené heslo.';
$string['password_help'] = 'Pro předkonfigurované nástroje není třeba zadat sdílené heslo, protože je poskytováno jako součást procesu konfigurace.

Toto pole by se mělo zadávat při vytváření odkazu na poskytovatele nástroje, který ještě není nakonfigurován.
Musí-li se použít poskytovatel nástroje více než jednou, přidání konfigurace nástroje kurzu je dobrý nápad.

Sdílené heslo může být považováno za heslo použité k ověření přístupu k nástroji. Může být poskytnuto spolu se zákaznický klíčem od poskytovatele nástroje.

Nástroje, které nevyžadují od Moodle bezpečnou komunikaci a neposkytují dodatečné služby (např. zpětné hlášení hodnocení), nemusí požadovat sdílené heslo.';
$string['pending'] = 'Probíhající';
$string['pluginadministration'] = 'Správa Externího nástroje';
$string['pluginname'] = 'Externí nástroj';
$string['preferheight'] = 'Preferovaná výška';
$string['preferwidget'] = 'Preferované spuštění Widget';
$string['preferwidth'] = 'Preferovaná šířka';
$string['press_to_submit'] = 'Stiskněte pro spuštěni této činnosti';
$string['privacy'] = 'Soukromí';
$string['privacy:metadata:coursefullname'] = 'Celý název kurzu, ke kterému uživatel přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:courseid'] = 'ID kurzu, ke kterému uživatel přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:courseidnumber'] = 'Číslo ID kurzu, ke kterému uživatel přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:courseshortname'] = 'Krátké jméno kurzu, ke kterému uživatel přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:createdby'] = 'Uživatel, který záznam vytvořil';
$string['privacy:metadata:email'] = 'E-mailová adresa uživatele, který přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:externalpurpose'] = 'Uživatel LTI poskytuje informace o uživateli a kontext poskytovateli nástrojů LTI.';
$string['privacy:metadata:firstname'] = 'Jméno uživatele, který přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:fullname'] = 'Celé jméno uživatele, který přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:lastname'] = 'Příjmení uživatele, který přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:lti_submission'] = 'Odeslání LTI';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Časové razítko indikující datum odeslání řešení';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Časové razítko indikující datum úpravy řešení';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Známka pro uživatele jako procento';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Původní známka uživatele';
$string['privacy:metadata:lti_submission:userid'] = 'ID uživatele, který odeslal řešení na činnost LTI';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI proxy';
$string['privacy:metadata:lti_tool_proxies:name'] = 'LTI proxy jméno';
$string['privacy:metadata:lti_types'] = 'Typy LTI';
$string['privacy:metadata:lti_types:name'] = 'Název typu LTI';
$string['privacy:metadata:role'] = 'Role uživatele v kurzu, který přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:timecreated'] = 'Čas vytvoření záznamu';
$string['privacy:metadata:timemodified'] = 'Čas úpravy záznamu';
$string['privacy:metadata:userid'] = 'ID uživatele, který přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:useridnumber'] = 'ID číslo uživatele, který přistupuje ke spotřebiteli LTI';
$string['privacy:metadata:username'] = 'Uživatelské jméno uživatele, který přistupuje k spotřebiteli LTI';
$string['publickey'] = 'Veřejný klíč';
$string['publickey_help'] = 'Veřejný klíč (ve formátu PEM) poskytovaný nástrojem umožňuje ověření podpisů příchozích zpráv a požadavků na služby.';
$string['publickeyset'] = 'Veřejná sada klíčů';
$string['publickeyset_help'] = 'Sada veřejných klíčů, odkud moodle načte veřejný klíč nástroje, aby bylo možné ověřit podpisy příchozích zpráv a požadavků na služby.';
$string['quickgrade'] = 'Povolit rychlé hodnocení';
$string['quickgrade_help'] = 'Je-li tato možnost aktivována, více nástrojů může být hodnoceno na jedné stránce. Přidejte hodnocení a komentáře, potom stiskněte tlačítko "Uložit všechny moje zpětné vazby", abyste uložil všechny změny této stránky.';
$string['redirect'] = 'Během několika vteřin budete přesměrováni. Pokud se tak nestane, použijte tlačítko.';
$string['redirectionuris'] = 'Přesměrování URI(s)';
$string['redirectionuris_help'] = 'Seznam identifikátorů URI (jeden na řádek), které nástroj používá při žádosti o autorizaci. Nejméně jeden musí být zaregistrován před úspěšným odesláním zprávy do nástroje.';
$string['register'] = 'Registrace';
$string['register_warning'] = 'Registrační stránka vypadá, že  otevření již trvá nějakou dobu. Pokud se neobjeví, zkontrolujte, zda jste zadali správnou adresu URL v nastavení konfigurace.';
$string['registertype'] = 'Konfigurace nové registrace externího nástroje';
$string['registration_options'] = 'Registrační volby';
$string['registrationname'] = 'Jméno poskytovatele nástroje';
$string['registrationname_help'] = 'Zadejte název poskytovatele nástroje, jak je registrovaný.';
$string['registrationurl'] = 'Registrační URL';
$string['registrationurl_help'] = 'Registrační URL by měl být k dispozici od poskytovatele nástroje jako místo, kde mají být zasílány žádosti o registraci.';
$string['reject'] = 'Odmítnout';
$string['rejected'] = 'Odmitnuto';
$string['resource'] = 'Zdroj';
$string['resourcekey'] = 'Zákaznické heslo';
$string['resourcekey_admin'] = 'Zákaznické heslo';
$string['resourcekey_admin_help'] = 'Zákaznický klíč může být myšlen jako uživatelské jméno použité k ověření přístupu k nástroji.
Může být použitý poskytovatelem nástroje na jedinečnou identifikaci Moodle portálu, ze kterého uživatelé spouštějí nástroj.

Zákaznický klíč musí poskytnout poskytovatel nástroje. Metoda získání zákaznického klíče se liší od poskytovatele k poskytovateli. Může to být automatický proces, nebo se může požadovat dialog s poskytovatelem nástroje.

Nástroje, které nevyžadují od Moodle bezpečnou komunikaci a neposkytují dodatečné služby (např. zpětné hlášení hodnocení), nemusí požadovat heslo zdroje.';
$string['resourcekey_help'] = 'Pro předkonfigurované nástroje není třeba zadat heslo zdroje, protože je poskytováno jako součást procesu konfigurace.

Toto pole by se mělo zadávat při vytváření odkazu na poskytovatele nástroje, který ještě není nakonfigurován.
Musí-li se použít poskytovatel nástroje více než jednou, přidání konfigurace nástroje kurzu je dobrý nápad.

Zákaznický klíč může být myšlen jako uživatelské jméno použité k ověření přístupu k nástroji.
Může být použitý poskytovatelem nástroje na jedinečnou identifikaci Moodle portálu, ze kterého uživatelé spouštějí nástroj.

Zákaznický klíč musí poskytnout poskytovatel nástroje. Metoda získání zákaznického klíče se liší od poskytovatele k poskytovateli. Může to být automatický proces, nebo se může požadovat dialog s poskytovatelem nástroje.

Nástroje, které nevyžadují od Moodle bezpečnou komunikaci a neposkytují dodatečné služby (např. zpětné hlášení hodnocení), nemusí požadovat heslo zdroje.';
$string['resourceurl'] = 'URL zdroje';
$string['return_to_course'] = 'Pro návrat do kurzu klikněte <a href="{$a->link}" target="_top">zde</a>.';
$string['saveallfeedback'] = 'Uložit všechny mé odpovědi';
$string['search:activity'] = 'Externí nástroj - informace';
$string['secure_icon_url'] = 'Ikona URL pro zabezpečený přístup';
$string['secure_icon_url_help'] = 'Podobná ikoně URL, ale používá se tehdy, kdy uživatel přistupuje do Moodle bezpečně přes SSL. Toto pole zabrání tomu, aby prohlížeč zobrazoval varování o nezabezpečeném obrazu.';
$string['secure_launch_url'] = 'Zabezpečený nástroj URL';
$string['secure_launch_url_help'] = 'Podobně jako na URL nástroje, ale používá místo URL nástroje, pokud je vyžadována vysoká bezpečnost. Moodle bude používat zabezpečenou adresu URL pro nástroj namísto URL nástroje případě, že web Moodle je přístupný přes SSL, nebo pokud konfigurační nástroj je nastaven, aby se spustil vždy pomocí protokolu SSL.';
$string['selectcontent'] = 'Vybrat obsah';
$string['send'] = 'Odeslat';
$string['services'] = 'Služby';
$string['services_help'] = 'Zvolte ty služby, které chcete nabídnout poskytovateli nástroje. Je možné zvolit více než jednu službu.';
$string['setupoptions'] = 'Nastavení voleb';
$string['share_email'] = 'Sdílejte email poskytovatele';
$string['share_email_admin'] = 'Sdílejte email poskytovatele';
$string['share_email_admin_help'] = 'Specifikujte, zda bude emailová adresa uživatele, spouštějícího nástroj, sdílena s poskytovatelem nástroje.
Poskytovatel nástroje může potřebovat emailové adresy spouštějících, aby rozlišil uživatele se stejným jménem v UI, nebo aby posílal emaily uživatelům na základě akcí prováděných v rámci nástroje.';
$string['share_email_help'] = 'Specifikujte, zda bude emailová adresa uživatele, spouštějícího nástroj, sdílena s poskytovatelem nástroje.

Poskytovatel nástroje může potřebovat emailové adresy spouštějících, aby rozlišil uživatele se stejným jménem, nebo aby posílal emaily uživatelům na základě akcí prováděných v rámci nástroje.

Poznámka: Toto nastavení lze v konfiguraci nástroje ignorovat.';
$string['share_name'] = 'Sdílejte jméno poskytovatele';
$string['share_name_admin'] = 'Sdílejte jméno poskytovatele';
$string['share_name_admin_help'] = 'Specifikujte, zda by mělo být celé jméno uživatele, spouštějícího nástroj, sdíleno s poskytovatelem nástroje.
Poskytovatel nástroje může potřebovat celé jména spouštějících, aby zobrazoval v rámci nástroje smysluplné informace.';
$string['share_name_help'] = 'Specifikujte, zda by mělo být celé jméno uživatele, spouštějícího nástroj, sdíleno s poskytovatelem nástroje.

Poskytovatel nástroje může potřebovat celé jména spouštějících, aby zobrazoval v rámci nástroje smysluplné informace.

Poznámka: Toto nastavení lze v konfiguraci nástroje ignorovat.';
$string['share_roster'] = 'Povolit nástroj pro přístup k seznamu kurzů';
$string['share_roster_admin'] = 'Nástroj umožňující přístup k seznamu kurzů';
$string['share_roster_admin_help'] = 'Určete, zda může nástroj přistupovat k seznamu uživatelů zařazených do kurzů, z nichž je tento nástroj spouštěn.';
$string['share_roster_help'] = '\'Specifikujte, zda nástroj může přistupovat k seznamu uživatelů zapsaných do tohoto kurzu.

Poznámka: Toto nastavení lze v konfiguraci nástroje ignorovat.';
$string['show_in_course_activity_chooser'] = 'Zobrazit ve výběru aktivit jako předkonfigurovaný nástroj';
$string['show_in_course_lti1'] = 'Použití konfiguračního nástroje';
$string['show_in_course_lti1_help'] = 'Tento nástroj může být učitelům zobrazen v Průvodci přidání  k výběru a přidání do kurzu. Alternativně může být  v rozbalovací nabídce předkonfigurovaného nástroje při přidávání externí nástroje do kurzu. Další možností je na konfiguraci nástroje, který lze použít pouze v případě, že je použita přesná adresa URL nástroje při přidávání externího nástroje do kurzu.';
$string['show_in_course_lti2'] = 'Použití konfiguračního nástroje';
$string['show_in_course_lti2_help'] = 'Tento nástroj může být učitelům zobrazen v Průvodci přidání  k výběru a přidání modulu do kurzu nebo v rozbalovací nabídce předkonfigurovaného nástroje při přidávání externí nástroje do kurzu.';
$string['show_in_course_no'] = 'Nezobrazovat; používat pouze tehdy, když je zadaný nástroj URL';
$string['show_in_course_preconfigured'] = 'Když přidáváte Externí nástroj, zobrazit jako předkonfigurovaný nástroj';
$string['sitehost'] = 'Název hostitele webu';
$string['siteid'] = 'ID stránek';
$string['size'] = 'Velikost parametrů';
$string['submission'] = 'Odeslání';
$string['submissions'] = 'Odevzdané úkoly';
$string['submissionsfor'] = 'Příspěvky  {$a}';
$string['subplugintype_ltiresource'] = 'Zdroje LTI služby';
$string['subplugintype_ltiresource_plural'] = 'Zdroje LTI služeb';
$string['subplugintype_ltiservice'] = 'LTI služba';
$string['subplugintype_ltiservice_plural'] = 'LTI služby';
$string['subplugintype_ltisource'] = 'LTI služba';
$string['subplugintype_ltisource_plural'] = 'LTI služby';
$string['successfullycreatedtooltype'] = 'Úspěšně vytvořen nový nástroj!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Úspěšně připojený konfigurační nástroj z vybraného obsahu.';
$string['toggle_debug_data'] = 'Přepnout ladící data';
$string['tool_config_not_found'] = 'Pro URL nenalezen konfigurační nástroj';
$string['tool_settings'] = 'Nastavení nástroje';
$string['tooldescription'] = 'Popis nástroje';
$string['tooldescription_help'] = 'Popis nástroje, který bude zobrazen učiteli v seznamu aktivit.

To by mělo popsat, na co nástroj slouží a co dělá a jakékoliv další informace, které učitel potřebuje vědět.';
$string['tooldetailsaccesstokenurl'] = 'Přístupový token URL';
$string['tooldetailsauthrequesturl'] = 'Adresa URL požadavku na ověření';
$string['tooldetailsclientid'] = 'ID klienta';
$string['tooldetailsdeploymentid'] = 'ID nasazení';
$string['tooldetailsmailtosubject'] = 'Konfigurace nástroje LTI';
$string['tooldetailsmodalemail'] = 'E-mail';
$string['tooldetailsmodallink'] = 'Zobrazení podrobností konfigurace';
$string['tooldetailsmodaltitle'] = 'Podrobnosti o konfiguraci nástroje';
$string['tooldetailsplatformid'] = 'ID platformy';
$string['tooldetailspublickeyseturl'] = 'URL veřejné sady klíčů';
$string['toolisbeingused'] = 'Tento nástroj byl použit  {$a} krát';
$string['toolisnotbeingused'] = 'Tento nástroj dosud nebyl použit';
$string['toolproxy'] = 'Registrace externích nástrojů';
$string['toolproxy_help'] = 'Externí registrací nástroje umožňují správcům Moodle konfigurovat externí nástroje z Proxy Tool získané od poskytovatele nástroje podporující LTI 2,0. Žádost o registraci URL poskytovatele nástrojů je vše, co je zapotřebí k zahájení procesu. Oprávnění a služby nabízené poskytovatelem nástroje jsou vybrány při konfiguraci nové registrace.

Nástroje uvedené na této stránce jsou rozděleny do čtyř kategorií:

* ** Nakonfigurováno ** - Tyto registrační nástroje byly nastaveny, ale registrační proces ještě nebyl spuštěn.
* **Čekající** - Proces registrace těchto nástrojů byl zahájen, ale nebyl dokončen. Otevřít a uložit nastavení tak,
          aby je šlo přesunout zpět do kategorie "Nakonfigurováno".
* **Akceptováno** - Tyto registrační nástroje byly schváleny; zdroje uvedené v Proxy Tool se objeví na straně
        předkonfigurovaném nástrojů s počátečním stavem "Čekající".
* **Odmítnuté** - Tyto registrační nástroje jsou ty, které byly odmítnuty během procesu registrace.
         Otevřít a uložit nastavení tak, aby je šlo přesunout zpět do kategorie "Nakonfigurováno", takže registrační
         proces může být restartován.';
$string['toolproxyregistration'] = 'Registrace externího nástroje';
$string['toolregistration'] = 'Registrace externího nástroje';
$string['toolsetup'] = 'Konfigurace externího nástroje';
$string['tooltypeadded'] = 'Přidán předkonfigurovaný nástroj';
$string['tooltypedeleted'] = 'Předkonfigurovaný nástroj odstraněn';
$string['tooltypenotdeleted'] = 'Předkonfigurovaný nástroj nelze odstranit';
$string['tooltypes'] = 'Nástroj';
$string['tooltypeupdated'] = 'Předkonfigurovaný nástroj aktualizován';
$string['toolurl'] = 'Nástroj URL';
$string['toolurl_contentitemselectionrequest'] = 'URL pro výběr obsahu';
$string['toolurl_contentitemselectionrequest_help'] = 'Adresa URL pro výběr obsahu bude použita pro spuštění stránky výběru obsahu od poskytovatele nástrojů. Pokud je prázdná, použije se adresa URL nástroje';
$string['toolurl_help'] = 'Adresa URL nástroje se používá tak, aby odpovídala URL nástroje ke správné konfiguraci nástroje. Prefix URL s http (s) je volitelný.

Navíc, základní adresa URL je použita jako URL nástroje , pokud adresa URL nástroje není uvedena v instanci externího nástroje.

Například, základ URL ze  *tool.com* by odpovídalo následujícím:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Základ URL ze *www.tool.com/quizzes* by odpovídalo následujícím:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Základ URL ze *quiz.tool.com* by odpovídalo následujícím:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Pokud mají dvě různé konfigurace nástroje jsou ve stejné doméně, použije se nejkonkrétnější zápis.

Můžete také vložit adresu URL balíčku, pokud máte jednu adresu a podrobnosti pro nástroj se automaticky vyplní.';
$string['toolurlplaceholder'] = 'Nástroj URL ...';
$string['typename'] = 'Název nástroje';
$string['typename_help'] = 'Název nástroje se používá k identifikaci poskytovatele nástroje v rámci Moodle. Zadaný název budou vidět lektoři při přidávání externích nástrojů do kurzů.';
$string['types'] = 'Typy';
$string['unabletocreatetooltype'] = 'Nelze vytvořit nástroj';
$string['unabletofindtooltype'] = 'Nepodařilo se najít nástroj pro {$a->id}';
$string['unknownstate'] = 'Neznámý stav';
$string['update'] = 'Aktualizovat';
$string['useraccountinformation'] = 'Informace o účtu uživatele';
$string['userpersonalinformation'] = 'Osobní údaje 165.987.343';
$string['using_tool_cartridge'] = 'Použít balíček nástrojů';
$string['using_tool_configuration'] = 'Použít konfiguraci nástroje:';
$string['validurl'] = 'Správná adresa URL musí začínat http(s)://';
$string['viewsubmissions'] = 'Zobrazit stránku s odevzdanými úkoly a hodnocením';
