<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'simplecertificate', language 'cs', version '4.2'.
 *
 * @package     simplecertificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allusers'] = 'Všichni uživatelé';
$string['awardedsubject'] = 'Oznámení o vystavení certifikátu: {$a->certificate} vydaného uživateli {$a->student}';
$string['awardedto'] = 'Udělen';
$string['bulkaction'] = 'Vyberte hromadnou operaci';
$string['bulkbuttonlabel'] = 'Odeslat';
$string['bulkview'] = 'Hromadné operace';
$string['cantdeleteissue'] = 'Chyba při odstraňování vydaných osvědčení';
$string['cantissue'] = 'Certifikát nelze vydat, protože uživatel nesplnil požadavky kurzu';
$string['certificatecopy'] = 'KOPIE';
$string['certificateimage'] = 'Obrázek osvědčení';
$string['certificateimage_help'] = 'To je obrázek, který bude použit pro osvědčení';
$string['certificatename'] = 'Název osvědčení';
$string['certificatename_help'] = 'Název osvědčení';
$string['certificatenot'] = 'Instance certifikátu nebyla nalezena';
$string['certificatepath'] = 'Cesta k osvědčení';
$string['certificatepath_help'] = 'Jsou povoleny pouze soubory .crt';
$string['certificates'] = 'Osvědčení';
$string['certificatestitle'] = 'Moje osvědčení';
$string['certificatetext'] = 'Text Osvědčení';
$string['certificatetext_help'] = 'Tento text bude použit na osvědčení, některé výrazy budou nahrazeny proměnnými, jako je název kurzu, jméno studenta, známka ...
Jsou to:

{USERNAME} -> Uživatelské jméno
{COURSENAME} -> Celý název kurzu (nebo definovaný alternativní název)
{GRADE} -> Známka
{DATE} -> Datum
{OUTCOME} -> Očekávané výstupy
{HOURS} -> Definované hodiny kurzu (dotace)
{TEACHERS} -> Seznam učitelů
{IDNUMBER} -> ID uživateler
{FIRSTNAME} -> Jméno uživatele
{LASTNAME} -> Příjmení uživatele
{EMAIL} ->  e-mail uživatele
{ICQ} -> ICQ uživatele
{SKYPE} -> Skype uživatele
{YAHOO} -> Yahoo messenger uživatele
{AIM} -> AIM uživatele
{MSN} -> MSN uživatele
{PHONE1} -> První telefon uživatele
{PHONE2} -> Druhý telefon uživatele
{INSTITUTION} -> Instituce uživatele
{DEPARTMENT} -> Oddělení uživatele
{ADDRESS} -> Adresa uživatele
{CITY} -> Město uživatele
{COUNTRY} -> Země uživatele
{URL} -> URL uživatele
{PROFILE_xxxx} -> Uživatelské pole z profilu uživatele


Abyste mohli používat pole ve vlastních profilech, musíte použít prefix "PORFILE_" např.: vytvoříte uživatelské pole NAROZEN, potom musí být na osvědčení použito {PROFILE_NAROZEN}.
V textu můžete použít základní HTML, základní fonty (české sady si dodefinujte), tabulky, ale vyhněte se definici pozice.';
$string['certificatetextx'] = 'Horizontální pozice textu osvědčení';
$string['certificatetexty'] = 'Vertikální pozice textu osvědčení';
$string['certificateverification'] = 'Ověření osvědčení';
$string['certlifetime'] = 'Doba uchování osvědčení (v měsících):';
$string['certlifetime_help'] = 'Určuje dobu, po kterou chcete zachovat vydaná osvědčení. Vydaná osvědčení, které jsou starší než tento interval, se automaticky vymažou.';
$string['code'] = 'Kód';
$string['codex'] = 'Horizontální pozice QR kódu osvědčení';
$string['codey'] = 'Vertikální pozice QR kódu osvědčení';
$string['completedusers'] = 'Uživatelé, kteří splnili požadavky kurzu';
$string['completiondate'] = 'Absolvování kurzu';
$string['coursegrade'] = 'Známka kurzu';
$string['coursename'] = 'Alternativní název kurzu';
$string['coursename_help'] = 'Alternativní název kurzu';
$string['coursenotfound'] = 'Kurz nebyl nalezen';
$string['coursesections'] = 'Sekce kurzu';
$string['coursestartdate'] = 'Datum zahájení kurzu';
$string['coursetimereq'] = 'Požadovaná doba studia (v minutách)';
$string['coursetimereq_help'] = 'Zde zadejte minimální dobu v minutách, kterou musí student strávit v kurzu, než bude moci získat osvědčení.';
$string['datefmt'] = 'Formát data';
$string['datefmt_help'] = 'Zadejte platný PHP formát data dle vzoru (http://www.php.net/manual/en/function.strftime.php). Nebo nechte prázdné a bude použit formát podle jazyka uživatele.';
$string['defaultcertificatetextx'] = 'Výchozí horizontální pozice textu';
$string['defaultcertificatetexty'] = 'Výchozí vertikální pozice textu';
$string['defaultcodex'] = 'Výchozí horizontální pozice QR kódu';
$string['defaultcodey'] = 'Výchozí vertikální pozice QR kódu';
$string['defaultheight'] = 'Výchozí výška';
$string['defaultperpage'] = 'Na stránku';
$string['defaultperpage_help'] = 'Počet osvědčení na stránku (Max. 200)';
$string['defaultwidth'] = 'Výchozí šířka';
$string['deleteall'] = 'Odstranit všechny';
$string['deleteselected'] = 'Odstranit vybraná';
$string['deletissuedcertificates'] = 'Odstranit vydaná osvědčení';
$string['delivery'] = 'Způsob výstupu';
$string['delivery_help'] = 'Vyberte si, jak mají studenti získat své  osvědčení.

Otevřít v prohlížeči: Otevře osvědčení v novém okně prohlížeče.
Vnutit stažení: Otevře okno Stažení souboru.
Zaslat Osvědčení Emailem : Tato volba odešle studentovi osvědčení jako přílohu e-mailu.
Poté, co uživatel obdrží své osvědčení, může kliknout na odkaz na osvědčení v kurzu, uvidí datum získání osvědčení a bude moci přezkoumat obdržené osvědčení (QCR kód).';
$string['designoptions'] = 'Nastavení vzhledu';
$string['download'] = 'Vnutit stažení';
$string['emailcertificate'] = 'Zaslat e-mailem (Současně zvolte uložit!)';
$string['emailfrom'] = 'Nastavení odesílatele e-mailu';
$string['emailfrom_help'] = 'Alternativní nastavení odesílatele e-mailu';
$string['emailoncompletion'] = 'E-mail o dokončení kurzu';
$string['emailothers'] = 'Další e-maily';
$string['emailothers_help'] = 'Zadejte e-mailové adresy, oddělené čárkou, těch uživatelů, kteří mají být upozorněni e-mailem, když studenti obdrží certifikát.';
$string['emailsent'] = 'E-maily byly odeslány';
$string['emailstudentsubject'] = 'Váš certifikát z kurzu {$a->course}';
$string['emailstudenttext'] = 'V příloze je vaše Osvědčení kurzu {$a->course}.';
$string['emailteachermail'] = '{$a->student} obdržel osvědčení: "{$a->certificate}"
za kurz {$a->course}.

Zde si je můžete zobrazit:

    {$a->url}';
$string['emailteachermailhtml'] = '{$a->student} obdržel osvědčen: "<i>{$a->certificate}</i>"
za kurz {$a->course}.

Zde si je můžete zobrazit:

    <a href="{$a->url}">Přehled osvědčení</a>.';
$string['emailteachers'] = 'E-mail učitele';
$string['emailteachers_help'] = 'Je-li povoleno, jsou učitelé e-mailem upozorněni, když studenti obdrží osvědčení.';
$string['enablesecondpage'] = 'Povolit zadní stranu Osvědčení';
$string['enablesecondpage_help'] = 'Povolit zadní stranu osvědčení. Pokud je zadní strana zakázána a QR kód povolen, je na zadní straně  vytištěn pouze QR kód osvědčení. Lze použít pro ověření platnosti Osvědčení.';
$string['eventcertificate_verified'] = 'Certifikát byl ověřen';
$string['eventcertificate_verified_description'] = 'Uživatel s id {$a-> userid} ověřil certifikát s identifikačním číslem {$a->certificateid}, který byl vydán uživateli s  id {$a->certiticate_userid}.';
$string['filenotfound'] = 'Soubor nenalezen';
$string['getcertificate'] = 'Získat Osvědčení';
$string['grade'] = 'Hodnocení';
$string['gradefmt'] = 'Formát hodnocení';
$string['gradefmt_help'] = 'Pokud se rozhodnete tisknout známku na osvědčení, máte tři možnosti:

Procenta: vytiskne známku v procentech
Body: vytiskne bodovou hodnotu známky
Slovní známky: vytiskne hodnotu známky dle získaných procent';
$string['gradeletter'] = 'Slovní známky';
$string['gradepercent'] = 'Procento hodnocení';
$string['gradepoints'] = 'Počet bodů hodnocení';
$string['height'] = 'Výška osvědčení';
$string['hours'] = 'hodin';
$string['intro'] = 'Úvod';
$string['invalidcode'] = 'Neplatný kód osvědčení';
$string['issued'] = 'Vystaveno';
$string['issuedcertificatenotfound'] = 'Vydaný certifikát nebyl nalezen';
$string['issueddate'] = 'Datum vystavení';
$string['issueddownload'] = 'Stáhnout vydaná osvědčení [id: {$a}]';
$string['issuedview'] = 'Vydané certifikáty';
$string['issueoptions'] = 'Volby vystavení';
$string['keywords'] = 'oevědčení, kurz, pdf, moodle';
$string['modulename'] = 'Jednoduché Osvědčení';
$string['modulename_help'] = 'Modul Jednoduchý Certifikát umožňuje učiteli vytvářet vlastní certifikát, který může být vydán účastníkům, kteří splnili požadavky definované učitelem.';
$string['modulenameplural'] = 'Jednoduché Osvědčení';
$string['multipdf'] = 'Stáhnout certifikáty v zip souboru';
$string['neverdeleteoption'] = 'Nikdy neodstraňovat';
$string['nocertificatesissued'] = 'Nejsou žádná vydaná osvědčení';
$string['nodelivering'] = 'Bez zaslání, uživatel získá tento certifikát jinou cestou';
$string['nohavecertificates'] = 'Ještě nemáte osvědčení';
$string['notreceived'] = 'Nevydaný osvědčení';
$string['onepdf'] = 'Stáhnout certifikáty v jednom souboru PDF';
$string['openbrowser'] = 'Otevřít v novém okně';
$string['opendownload'] = 'Pro uložení osvědčení klikněte na tlačítko';
$string['openemail'] = 'Klikněte na tlačítko a osvědčení Vám bude zasláno jako příloha e-mailu.';
$string['openwindow'] = 'Klikněte na tlačítko a osvědčení se otevře v novém okně prohlížeče.';
$string['pluginadministration'] = 'Správa osvědčení';
$string['pluginname'] = 'Jednoduché osvědčení';
$string['printdate'] = 'Datum tisku';
$string['printdate_help'] = 'Toto je datum, které bude vytištěno, pokud je vybrán datum tisku. Pokud je zvoleno datum ukončení kurzu, ale student nedokončil kurz, vytiskne se datum, kdy získal certifikát. Můžete také vybrat vytisknuté datum podle toho, kdy byla činnost oznámkována. Pokud je certifikát vydán předtím, než je tato činnost hodnocena, vytiskne se datum, kdy získal certifikát.';
$string['printgrade'] = 'Tisk známky';
$string['printgrade_help'] = 'Můžete si vybrat libovolné dostupné známky z kurzu, abyste mohli vytisknout hodnocení získané pro danou položku v certifikátu. Známky jsou uvedeny v pořadí, ve kterém se objevují v hodnocení. Formát známky zvolte dole.';
$string['printoutcome'] = 'Tisk Očekávaných výstupů';
$string['printoutcome_help'] = 'Můžete zvolit jakýkoli výsledek kurzu a vytisknout název výsledku a získané hodnocení výsledku uživatele v certifikátu. Příkladem může být: Výstup úkolu: Splněno.';
$string['printqrcode'] = 'Vytisknout QR kód Osvědčení';
$string['printqrcode_help'] = 'Vytisknout (nebo ne) QR kód Osvědčení';
$string['qrcodefirstpage'] = 'Vytisknout QR kód na první straně';
$string['qrcodefirstpage_help'] = 'Vytisknout QR kód na první straně';
$string['qrcodeposition'] = 'Umístění QR kódu Osvědčení';
$string['qrcodeposition_help'] = 'Umístění QR kódu Osvědčení polohou XY (v milimetrech)';
$string['receiveddate'] = 'Datum vydání';
$string['report'] = 'Sestava';
$string['requiredtimenotmet'] = 'Z získání tohoto osvědčení musíte studovat kurz alespoň {$a->requiredtime} minut.';
$string['secondimage'] = 'Obrázek na pozadí Osvědčení';
$string['secondimage_help'] = 'Obrázek, který bude použit v zadní části osvědčení';
$string['secondpageoptions'] = 'Zadní strana Osvědčení';
$string['secondpagetext'] = 'Text na zadní straně Osvědčení';
$string['secondpagex'] = 'Horizontální pozice textu na zadní straně osvědčení';
$string['secondpagey'] = 'Vertikální pozice textu na zadní straně osvědčení';
$string['secondtextposition'] = 'Pozice textu na zadní straně osvědčení';
$string['secondtextposition_help'] = 'Pozice textu na zadní straně osvědčení polohou XY (v milimetrech)';
$string['sendtoemail'] = 'Zaslat uživateli e-mailem';
$string['showusers'] = 'Zobrazit';
$string['signhead'] = 'Nastavení značky';
$string['signheight'] = 'Výchozí výška';
$string['signimage'] = 'Výchozí obrázek';
$string['signinfo_help'] = 'Vlastnost po řádku. Použijte strukturu: klíč=hodnota';
$string['signname'] = 'Název';
$string['signposx'] = 'Výchozí horizontální poloha';
$string['signposy'] = 'Výchozí vertikální poloha';
$string['signwidth'] = 'Výchozí šířka';
$string['simplecertificate:addinstance'] = 'Přidat aktivitu Jednoduchý Certifikát';
$string['simplecertificate:manage'] = 'Správa aktivity Jednoduchý Certifikát';
$string['simplecertificate:view'] = 'Zobrazit aktivitu Jednoduchý Certifikát';
$string['size'] = 'Velikost Osvědčení';
$string['size_help'] = 'Jedná se šířku a výšku velikosti osvědčení (v milimetrech) , výchozí velikost je A4 na šířku';
$string['standardview'] = 'Vydat testovací osvědčení';
$string['subtitleallcertificates'] = 'Osvědčení ze všech kurzů';
$string['subtitlecoursecertificates'] = 'Osvědčení z kurzu';
$string['summaryofattempts'] = 'Přehled obdržených Osvědčení';
$string['textposition'] = 'Umístění textu Osvědčení';
$string['textposition_help'] = 'Umístění textu Osvědčení  polohou textu XY (v milimetrech)';
$string['timestartdatefmt'] = 'Formát data zahájení zápisu';
$string['timestartdatefmt_help'] = 'Zadejte platný formát datového formátu PHP (<a href="http://www.php.net/manual/en/function.strftime.php"> Formáty dat </a>). Nebo ponechte prázdné, abyste použili formát zvoleného jazyka uživatele.';
$string['upgradeerror'] = 'Chyba při aktualizaci $a';
$string['usercontextnotfound'] = 'Kontext uživatele nebyl nalezen';
$string['userdateformat'] = 'Formát data dle jazyku uživatele';
$string['usernotfound'] = 'Uživatel nebyl nalezen';
$string['variablesoptions'] = 'Další nastavení';
$string['verifycertificate'] = 'Ověřit Osvědčení';
$string['viewcertificateviews'] = 'Zobrazit {$a} vydaná osvědčení';
$string['width'] = 'Šířka Osvědčení';
