<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'fr', version '4.2'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Toutes les compétences filles sont atteintes';
$string['competencies'] = 'Compétences';
$string['competenciesarenotenabled'] = 'Les compétences ne sont pas activées.';
$string['competenciessettings'] = 'Réglages des compétences';
$string['completeplanstask'] = 'Achèvement des plans de formation à rendre';
$string['coursecompetencyoutcome_complete'] = 'Marquer la compétence comme atteinte';
$string['coursecompetencyoutcome_evidence'] = 'Joindre une preuve';
$string['coursecompetencyoutcome_none'] = 'Ne rien faire';
$string['coursecompetencyoutcome_recommend'] = 'Envoyer pour validation';
$string['coursemodulecompetencyoutcome_complete'] = 'Marquer la compétence comme atteinte';
$string['coursemodulecompetencyoutcome_evidence'] = 'Joindre une preuve';
$string['coursemodulecompetencyoutcome_none'] = 'Ne rien faire';
$string['coursemodulecompetencyoutcome_recommend'] = 'Envoyer pour validation';
$string['deletecompetencyratings'] = 'Supprimer les évaluations de compétence';
$string['duplicateditemname'] = '{$a} (copie)';
$string['enablecompetencies'] = 'Activer les compétences';
$string['enablecompetencies_desc'] = 'Les compétences permettent l’évaluation des utilisateurs relativement à des plans de formation.';
$string['errorcannotchangeapastduedate'] = 'La date limite est passée ; elle ne peut pas être modifiée.';
$string['errorcannotsetduedateinthepast'] = 'La date limite ne peut pas être fixée dans le passé.';
$string['errorcannotsetduedatetoosoon'] = 'La date limite est trop proche.';
$string['errorcompetencyrule'] = 'Règle de compétence « {$a} » inconnue';
$string['errorcoursecompetencyrule'] = 'Règle de compétence de cours « {$a} » inconnue';
$string['errorinvalidcourse'] = 'Cours non valide.';
$string['errornocompetency'] = 'La compétence {$a} est introuvable';
$string['errorplanstatus'] = 'Statut des plans de formation « {$a} » inconnu';
$string['errorscalealreadyused'] = 'Le barème ne peut pas être modifié, car il est déjà utilisé.';
$string['errorscaleconfiguration'] = 'Le barème doit être configuré en choisissant la valeur par défaut et le seuil de compétence.';
$string['errorusercomptencystatus'] = 'Statut de la compétence utilisateur « {$a} » inconnu';
$string['eventcompetencycreated'] = 'Compétence créée';
$string['eventcompetencydeleted'] = 'Compétence supprimée';
$string['eventcompetencyframeworkcreated'] = 'Référentiel de compétences créé';
$string['eventcompetencyframeworkdeleted'] = 'Référentiel de compétences supprimé';
$string['eventcompetencyframeworkupdated'] = 'Référentiel de compétences modifié';
$string['eventcompetencyframeworkviewed'] = 'Référentiel de compétences consulté';
$string['eventcompetencyupdated'] = 'Compétence modifiée';
$string['eventcompetencyviewed'] = 'Compétence consultée';
$string['eventevidencecreated'] = 'Preuve de compétence créée';
$string['eventplanapproved'] = 'Plan de formation approuvé';
$string['eventplancompleted'] = 'Plan de formation terminé.';
$string['eventplancreated'] = 'Plan de formation créé';
$string['eventplandeleted'] = 'Plan de formation supprimé';
$string['eventplanreopened'] = 'Plan de formation rouvert';
$string['eventplanreviewrequestcancelled'] = 'Demande de validation de plan de formation annulée';
$string['eventplanreviewrequested'] = 'Validation de plan de formation demandée';
$string['eventplanreviewstarted'] = 'Validation de plan de formation commencée';
$string['eventplanreviewstopped'] = 'Validation de plan de formation arrêtée';
$string['eventplanunapproved'] = 'Plan de formation désapprouvé';
$string['eventplanunlinked'] = 'Plan de formation délié';
$string['eventplanupdated'] = 'Plan de formation modifié';
$string['eventplanviewed'] = 'Plan de formation consulté';
$string['eventtemplatecreated'] = 'Modèle de plan de formation créé';
$string['eventtemplatedeleted'] = 'Modèle de plan de formation supprimé';
$string['eventtemplateupdated'] = 'Modèle de plan de formation modifié';
$string['eventtemplateviewed'] = 'Modèle de plan de formation consulté';
$string['eventusercompetencyplanviewed'] = 'Plan de compétences utilisateur consulté';
$string['eventusercompetencyrated'] = 'Compétence utilisateur évaluée';
$string['eventusercompetencyratedincourse'] = 'Compétence utilisateur évaluée dans un cours';
$string['eventusercompetencyratedinplan'] = 'Compétence utilisateur évaluée dans un plan de formation';
$string['eventusercompetencyreviewrequestcancelled'] = 'Demande de validation de compétence utilisateur annulée';
$string['eventusercompetencyreviewrequested'] = 'Validation de compétence utilisateur demandée';
$string['eventusercompetencyreviewstarted'] = 'Validation de compétence utilisateur commencée';
$string['eventusercompetencyreviewstopped'] = 'Validation de compétence utilisateur arrêtée';
$string['eventusercompetencyviewed'] = 'Compétence utilisateur consultée';
$string['eventusercompetencyviewedincourse'] = 'Compétence utilisateur consultée dans un cours';
$string['eventusercompetencyviewedinplan'] = 'Compétence utilisateur consultée dans un plan de formation';
$string['eventuserevidencecreated'] = 'Preuve d’acquis créée';
$string['eventuserevidencedeleted'] = 'Preuve d’acquis supprimée';
$string['eventuserevidenceupdated'] = 'Preuve d’acquis modifiée';
$string['evidence_competencyrule'] = 'La règle pour la compétence a été atteinte.';
$string['evidence_coursecompleted'] = 'Le cours « {$a} » a été achevée.';
$string['evidence_coursemodulecompleted'] = 'L’activité « {$a} » a été achevée.';
$string['evidence_courserestored'] = 'L’évaluation a été restaurée avec le cours « {$a} ».';
$string['evidence_evidenceofpriorlearninglinked'] = 'La preuve d’acquis « {$a} » a été liée.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'La preuve d’acquis « {$a} » a été déliée.';
$string['evidence_manualoverride'] = 'L’évaluation de la compétence a été donnée manuellement.';
$string['evidence_manualoverrideincourse'] = 'L’évaluation de la compétence a été donnée manuellement dans le cours « {$a} ».';
$string['evidence_manualoverrideinplan'] = 'L’évaluation de la compétence a été donnée manuellement dans le plan « {$a} ».';
$string['invalidevidencedesc'] = 'Description de preuve non valide';
$string['invalidgrade'] = 'Évaluation non valide';
$string['invalidpersistenterror'] = 'Erreur : {$a}';
$string['invalidplan'] = 'Plan de formation non valide';
$string['invalidtaxonomy'] = 'Taxonomie non valide : {$a}';
$string['invalidurl'] = 'L’URL n’est pas valide. Veuillez vous assurer qu’elle commence par « http:// » ou « https:// ».';
$string['nouserplanswithcompetency'] = 'Aucun plan de formation ne contient cette compétence.';
$string['planstatusactive'] = 'Actif';
$string['planstatuscomplete'] = 'Achevé';
$string['planstatusdraft'] = 'Brouillon';
$string['planstatusinreview'] = 'En cours de validation';
$string['planstatuswaitingforreview'] = 'En attente de validation';
$string['pointsrequiredaremet'] = 'Le nombre de points requis est atteint';
$string['privacy:evidence:action:complete'] = 'Compétence achevée is non évalué';
$string['privacy:evidence:action:log'] = 'Journal de l’action';
$string['privacy:evidence:action:override'] = 'Note de compétence de remplacement';
$string['privacy:metadata:competency'] = 'Un enregistrement des compétences';
$string['privacy:metadata:competency_coursecomp'] = 'Un enregistrement des compétences liées à un cours';
$string['privacy:metadata:competency_coursecompsetting'] = 'Un enregistrement des réglages des compétences dans un cours';
$string['privacy:metadata:competency_evidence'] = 'Un enregistrement de preuve modifiant le statut d’une compétence';
$string['privacy:metadata:competency_framework'] = 'Un enregistrement des référentiels de compétences';
$string['privacy:metadata:competency_modulecomp'] = 'Un enregistrement des compétences liées à un module';
$string['privacy:metadata:competency_plan'] = 'Un enregistrement des plans de formation';
$string['privacy:metadata:competency_plancomp'] = 'Un enregistrement des compétences dans un plan de formation';
$string['privacy:metadata:competency_relatedcomp'] = 'Un enregistrement des relations entre compétences';
$string['privacy:metadata:competency_template'] = 'Un enregistrement des modèles de plan de formation';
$string['privacy:metadata:competency_templatecohort'] = 'Un enregistrement des cohortes associées à un modèle de plan de formation';
$string['privacy:metadata:competency_templatecomp'] = 'Un enregistrement des compétences dans un modèle de plan de formation';
$string['privacy:metadata:competency_usercomp'] = 'Un enregistrement du statut des compétences d’un utilisateur';
$string['privacy:metadata:competency_usercompcourse'] = 'Un enregistrement du statut des compétences d’un utilisateur dans un cours';
$string['privacy:metadata:competency_usercompplan'] = 'Un enregistrement du statut des compétences dans un plan de formation';
$string['privacy:metadata:competency_userevidence'] = 'Un enregistrement des preuves d’acquis';
$string['privacy:metadata:competency_userevidencecomp'] = 'Un enregistrement des compétences associées avec des preuves d’acquis';
$string['privacy:metadata:core_comments'] = 'Commentaires sur les plans de formation et les compétences';
$string['privacy:metadata:evidence:action'] = 'Le type d’action effectuée sur la preuve';
$string['privacy:metadata:evidence:actionuserid'] = 'L’utilisateur qui a effectué l’action';
$string['privacy:metadata:evidence:desca'] = 'Les paramètres optionnels de la description de preuve traduisible';
$string['privacy:metadata:evidence:desccomponent'] = 'Le composant de la description de preuve traduisible';
$string['privacy:metadata:evidence:descidentifier'] = 'Un identifiant de la description de la preuve traduisible';
$string['privacy:metadata:evidence:grade'] = 'La note associée à la preuve';
$string['privacy:metadata:evidence:note'] = 'Une annotation non traduite annexée à la preuve';
$string['privacy:metadata:evidence:url'] = 'Une URL associée à la preuve';
$string['privacy:metadata:plan:description'] = 'La description du plan de formation';
$string['privacy:metadata:plan:duedate'] = 'La date limite du plan de formation';
$string['privacy:metadata:plan:name'] = 'Le nom du plan de formation';
$string['privacy:metadata:plan:reviewerid'] = 'L’identifiant du contrôleur du plan de formation';
$string['privacy:metadata:plan:status'] = 'Le statut du plan de formation';
$string['privacy:metadata:plan:userid'] = 'L’identifiant de l’utilisateur dont c’est le plan de formation';
$string['privacy:metadata:timecreated'] = 'La date et l’heure de la création de l’enregistrement';
$string['privacy:metadata:timemodified'] = 'La date et l’heure de la modification de l’enregistrement';
$string['privacy:metadata:usercomp:grade'] = 'La note donnée pour la compétence';
$string['privacy:metadata:usercomp:proficiency'] = '';
$string['privacy:metadata:usercomp:reviewerid'] = 'L’identifiant du contrôleur';
$string['privacy:metadata:usercomp:status'] = 'Le statut de la compétence';
$string['privacy:metadata:usercomp:userid'] = 'L’identifiant de l’utilisateur dont c’est la compétence';
$string['privacy:metadata:userevidence:description'] = 'La description de la preuve';
$string['privacy:metadata:userevidence:name'] = 'Le nom de la preuve d’acquis';
$string['privacy:metadata:userevidence:url'] = 'L’URL associé à la preuve';
$string['privacy:metadata:usermodified'] = 'L’utilisateur qui a créé ou modifié l’enregistrement';
$string['privacy:path:plans'] = 'Plans de formation';
$string['privacy:path:relatedtome'] = 'Lié avec moi';
$string['privacy:path:userevidence'] = 'Preuve d’acquis';
$string['pushcourseratingstouserplans'] = 'Envoyer les évaluations du cours vers les plans de formation individuels';
$string['pushcourseratingstouserplans_desc'] = 'Valeur par défaut dans les réglages des cours pour la modification des plans de formation individuels lorsque les compétences du cours sont évaluées.';
$string['syncplanscohorts'] = 'Synchronisation des plans de formation depuis les modèles de plan de cohorte';
$string['taxonomy_behaviour'] = 'Comportement';
$string['taxonomy_competency'] = 'Compétence';
$string['taxonomy_concept'] = 'Concept';
$string['taxonomy_domain'] = 'Domaine';
$string['taxonomy_indicator'] = 'Indicateur';
$string['taxonomy_level'] = 'Niveau';
$string['taxonomy_outcome'] = 'Objectif';
$string['taxonomy_practice'] = 'Entraînement';
$string['taxonomy_proficiency'] = 'Aptitude';
$string['taxonomy_skill'] = 'Habileté';
$string['taxonomy_value'] = 'Valeur';
$string['usercommentedonacompetency'] = '{$a->fullname} a commenté la compétence « {$a->competency} » :

{$a->comment}

Voir {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} a commenté la compétence « {$a->competency} »:</p>
<div>{$a->comment}</div>
<p>Voir <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} a commenté la compétence « {$a->competency} ».';
$string['usercommentedonacompetencysubject'] = '{$a} a commenté une compétence.';
$string['usercommentedonaplan'] = '{$a->fullname} a commenté le plan de formation « {$a->plan} »:

{$a->comment}

Voir {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} a commenté le plan de formation « {$a->plan} »:</p>
<div>{$a->comment}</div>
<p>Voir <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} a commenté le plan de formation « {$a->plan} ».';
$string['usercommentedonaplansubject'] = '{$a} a commenté un plan de formation.';
$string['usercompetencystatus_idle'] = 'En suspens';
$string['usercompetencystatus_inreview'] = 'En cours de validation';
$string['usercompetencystatus_waitingforreview'] = 'En attente de validation';
$string['userplans'] = 'Plans de formation';
