<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'fr', version '4.2'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Titre pour accessibilité';
$string['acceptTerms'] = 'J’accepte les <a href=":url" target="_blank">conditions d’utilisation</a>';
$string['accountDetailsLinkText'] = 'ici';
$string['actions'] = 'Actions';
$string['add'] = 'Ajouter';
$string['addedandupdatedpp'] = '{$a->%new} bibliothèques H5P ajoutées et {$a->%old} mises à jour.';
$string['addedandupdatedps'] = '{$a->%new} bibliothèques H5P ajoutées et {$a->%old} mise à jour.';
$string['addedandupdatedsp'] = '{$a->%new} bibliothèque H5P ajoutée et {$a->%old} mises à jour.';
$string['addedandupdatedss'] = '{$a->%new} bibliothèque H5P ajoutée et {$a->%old} mise à jour.';
$string['addednewlibraries'] = '{$a->%new} bibliothèques H5P ajoutées.';
$string['addednewlibrary'] = '{$a->%new} bibliothèque H5P ajoutée.';
$string['additionallicenseinfo'] = 'Toute information supplémentaire sur la licence';
$string['address'] = 'Adresse';
$string['age'] = 'Âge typique';
$string['ageDescription'] = 'L’audience cible de ce contenu. Format du champ, séparé par des virgules : « 1,34-45,-50,59- ».';
$string['altText'] = 'Texte alternatif';
$string['atto_h5p'] = 'Bouton d’insertion H5P';
$string['atto_h5p_description'] = 'Le bouton d’insertion H5P de l’éditeur Atto permet aux utilisateurs d’insérer des contenus H5P en saisissant une URL ou du code d’intégration ou en déposant un fichier H5P.';
$string['author'] = 'Auteur';
$string['authorcomments'] = 'Commentaires de l’auteur';
$string['authorcommentsdescription'] = 'Commentaire pour l’éditeur du contenu (ce texte ne sera pas publié dans les informations de copyright).';
$string['authorname'] = 'Nom de l’auteur';
$string['authorrole'] = 'Rôle de l’auteur';
$string['back'] = 'Retour';
$string['by'] = 'par';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Non';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Oui';
$string['cancelPublishConfirmationDialogDescription'] = 'Voulez-vous vraiment annuler le processus de partage ?';
$string['cancelPublishConfirmationDialogTitle'] = 'Annuler le partage';
$string['cancellabel'] = 'Annuler';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-Pas d’utilisation commerciale (CC BY NC)';
$string['ccattributionncnd'] = 'Attribution-Pas d’utilisation commerciale-Pas de modification (CC BY NC ND)';
$string['ccattributionncsa'] = 'Attribution-Pas d’utilisation commerciale-Partage dans les mêmes conditions (CC BY NC SA)';
$string['ccattributionnd'] = 'Attribution-Pas de modification (CC BY ND)';
$string['ccattributionsa'] = 'Attribution-Partage dans les mêmes conditions (CC BY SA)';
$string['ccpdd'] = 'Marque du domaine public (CC0)';
$string['changeHasBeenSubmitted'] = 'Une modification a été envoyée pour';
$string['changedby'] = 'Modifié par';
$string['changedescription'] = 'Description de la modification';
$string['changelog'] = 'Journal des modifications';
$string['changeplaceholder'] = 'Photo recadrée, texte modifié, etc.';
$string['city'] = 'Localité';
$string['close'] = 'Fermer';
$string['confirmdialogbody'] = 'Veuillez confirmer que vous voulez continuer. Cette action est irréversible.';
$string['confirmdialogheader'] = 'Confirmer l’action';
$string['confirmlabel'] = 'Confirmer';
$string['connectionLost'] = 'Connexion perdue. Les résultats seront enregistrés et envoyés lorsque la connexion sera rétablie.';
$string['connectionReestablished'] = 'Connexion rétablie.';
$string['contactPerson'] = 'Personne de contact';
$string['contactPersonDescription'] = 'H5P contactera la personne de contact en cas de problème avec le contenu partagé par l’éditeur. Ni le nom de la personne de contact, ni aucune autre information ne sera publiée ou partagée avec des tierces parties';
$string['contentAvailable'] = 'Votre contenu sera normalement disponible dans le Hub H5P dans un jour ouvrable.';
$string['contentCopied'] = 'Le contenu est copié dans le presse-papier';
$string['contentLicenseTitle'] = 'Info du contenu de la licence';
$string['contentUpdateSoon'] = 'Votre contenu sera bientôt modifié';
$string['contentchanged'] = 'Ce contenu a changé depuis votre dernière utilisation.';
$string['contentinuse'] = 'Ce contenu peut être utilisé dans d’autres endroits.';
$string['contenttype'] = 'Type de contenu';
$string['copyright'] = 'Droits d’utilisation';
$string['copyrightWarning'] = 'Des contenus sous copyright ne peuvent pas être partagés dans le Hub H5P. Si le contenu est publié sous une licence utilisée pour les ressources éducatives ouvertes (OER), comme Creative Commons, veuillez choisir la licence appropriée. Dans le cas contraire, ce contenu ne pourra pas être partagé.';
$string['copyrightinfo'] = 'Information de copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Afficher les informations de copyright de ce contenu.';
$string['couldNotParseJSONFromZip'] = 'Impossible d’analyser le JSON du paquetage : {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Impossible de lire le fichier du paquetage : {$a->%fileName}';
$string['country'] = 'Pays';
$string['creativecommons'] = 'Creative Commons';
$string['currentStep'] = 'Étape :step sur :total';
$string['date'] = 'Date';
$string['deletelibraryconfirm'] = '<p>Voulez-vous vraiment supprimer la version <em>{$a->version}</em> de la bibliothèque <em>{$a->name}</em> ? Ceci supprimera la bibliothèque et toutes ses utilisations.</p><p>Cette opération ne peut pas être annulée.</p>';
$string['deletelibraryversion'] = 'Supprimer la version';
$string['deleting'] = 'Suppression d’une bibliothèque';
$string['description'] = 'Description';
$string['disablefullscreen'] = 'Désactiver le plein écran';
$string['discipline:dropdownButton'] = 'Bouton déroulant';
$string['discipline:in'] = 'dans';
$string['discipline:searchPlaceholder'] = 'Taper pour chercher des disciplines';
$string['disciplineDescription'] = 'Vous pouvez sélectionner plusieurs disciplines';
$string['disciplineLabel'] = 'Disciplines';
$string['disciplineLimitReachedMessage'] = 'Vous pouvez sélectionner jusqu’à :numDisciplines disciplines';
$string['disciplines'] = 'Disciplines';
$string['download'] = 'Télécharger';
$string['downloadtitle'] = 'Télécharger ce contenu comme fichier H5P.';
$string['editInfoTitle'] = 'Modifier l’info du <strong>:title</strong>';
$string['editcontent'] = 'Modifier le contenu H5P';
$string['editingFailed'] = 'Échec de modification.';
$string['editor'] = 'Éditeur';
$string['emailAddress'] = 'Adresse de courriel';
$string['emailAddressDescription'] = 'L’adresse de courriel sera utilisée par H5P pour contacter l’éditeur en cas de problème avec le contenu ou si l’éditeur doit récupérer son compte. Elle ne sera pas publiée, ni partagée avec des tierces parties';
$string['embed'] = 'Intégrer';
$string['embedtitle'] = 'Afficher le code d’intégration de ce contenu.';
$string['error:emptycontentid'] = 'L’URL donnée est incorrecte ou vous ne pouvez pas modifier ce fichier.';
$string['eventh5pdeleted'] = 'H5P supprimé';
$string['eventh5pviewed'] = 'Contenu H5P consulté';
$string['feature'] = 'Fonctionnalité';
$string['fetchtypesfailure'] = 'Aucune information n’a pu être obtenue sur les types de contenu H5P disponibles. Échec de connexion au dépôt H5P';
$string['fileExceedsMaxSize'] = 'Un des fichiers du paquetage dépasse la taille maximale autorisée pour les fichiers. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Filtre d’affichage H5P';
$string['filter_displayh5p_description'] = 'Le filtre d’affichage H5P convertit les URLs en contenu H5P intégré.';
$string['fullscreen'] = 'Plein écran';
$string['gpl'] = 'Licence publique générale GNU v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'CSS personnalisé';
$string['h5pcustomcss_help'] = 'CSS à appliquer au contenu H5P.';
$string['h5peditor'] = 'Éditeur H5P';
$string['h5pfilenotfound'] = 'Fichier H5P introuvable';
$string['h5pinvalidurl'] = 'URL de contenu H5P non valide';
$string['h5plibraryhandler'] = 'Gestionnaire de bibliothèques H5P';
$string['h5plibraryhandler_help'] = 'La bibliothèque H5P utilisée pour l’affichage du contenu H5P. La dernière version est recommandée.';
$string['h5pmanage'] = 'Gérer les types de contenu H5P';
$string['h5poverview'] = 'Vue d’ensemble H5P';
$string['h5ppackage'] = 'Type de contenu H5P';
$string['h5ppackage_help'] = 'Un type de contenu H5P est un fichier avec une extension H5P ou ZIP, contenant toutes les bibliothèques nécessaire à l’affichage du contenu.';
$string['h5pprivatefile'] = 'Ce contenu H5P ne peut pas être affiché, car vous n’avez pas accès au fichier .h5p.';
$string['h5psettings'] = 'Réglages H5P';
$string['h5ptitle'] = 'Visitez h5p.org pour obtenir encore plus de contenus cools.';
$string['height'] = 'hauteurs';
$string['helpChoosingLicense'] = 'Aidez-moi à choisir une licence';
$string['hideadvanced'] = 'Cacher avancé';
$string['icon'] = 'Icône';
$string['iconDescription'] = '640x480px. Si non sélectionné, le contenu utilisera l’icône de catégorie';
$string['installedcontentlibraries'] = 'Bibliothèques H5P installées';
$string['installedcontenttypes'] = 'Types de contenu H5P installés';
$string['installedh5p'] = 'H5P installé';
$string['invalidAge'] = 'Saisie non valide pour l’âge typique. Formats possibles, séparés par des virgules : « 1, 34-45, -50, -59- ».';
$string['invalidcontextid'] = 'Fichier H5P introuvable (contextid non valide)';
$string['invalidfile'] = 'Le fichier « {$a->%filename} » n’est pas autorisé. Seuls les fichiers avec les extensions suivantes sont permis : {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Fichier de langue {$a->%file} non valide dans la bibliothèque {$a->%library}';
$string['invalidlanguagefile2'] = 'Un fichier de langue {$a->%languageFile} non valide a été inclus dans la bibliothèque {$a->%name}';
$string['invalidlibrarydata'] = 'Données non valide fournies pour {$a->%property} dans {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Données non valide fournies pour {$a->%property} dans {$a->%library}. Un booléen est attendu.';
$string['invalidlibraryname'] = 'Nom de bibliothèque non valide : {$a->%name}';
$string['invalidlibrarynamed'] = 'La bibliothèque H5P {$a->%library} utilisée dans ce contenu n’est pas valide';
$string['invalidlibraryoption'] = 'Option non valide {$a->%option} dans {$a->%library}';
$string['invalidlibraryproperty'] = 'Impossible de lire la propriété {$a->%property} dans {$a->%library}';
$string['invalidmainjson'] = 'Un fichier valide h5p.json est manquant';
$string['invalidmultiselectoption'] = 'Option sélectionnée non valide dans le multi-select.';
$string['invalidpackage'] = 'Type de contenu H5P non valide';
$string['invalidselectoption'] = 'Option sélectionnée non valide dans le select.';
$string['invalidsemanticsjson'] = 'Un fichier semantics.json non valide a été inclus dans la bibliothèque {$a->%name}';
$string['invalidsemanticstype'] = 'Erreur interne H5P : type de contenu inconnu « {$a->@type} » dans la sémantique. Suppression du contenu !';
$string['invalidstring'] = 'La chaîne fournie n’est pas valide selon l’expression régulière dans la sémantique (valeur : « {$a->%value} », expression régulière : « {$a->%regexp} »).';
$string['isNowSubmitted'] = 'Est envoyée au Hub H5P';
$string['keywordExists'] = 'Le mot-clef existe déjà !';
$string['keywords'] = 'Mot-clefs';
$string['keywordsDescription'] = 'Vous pouvez ajouter plusieurs mots-clefs séparés par des virgules. Tapez « Entrée » ou « Ajouter » pour confirmer les mots-clefs';
$string['keywordsExits'] = 'Les mots-clefs existent déjà !';
$string['keywordsPlaceholder'] = 'Ajouter des mots-clefs';
$string['language'] = 'Langue';
$string['level'] = 'Niveau';
$string['librariesmanagerdescription'] = '<p>H5P permet aux utilisateurs de créer des contenus interactifs en fournissant divers types de contenus.</p><p>Pour s’assurer que seuls des contenus H5P fiables sont utilisés sur votre site, vous devez <em>soit</em></p><ul><li>déposer des types de contenus depuis h5p.org, <em>soit</em></li><li>activer la tâche programmée « Télécharger depuis h5p.org les types de contenus H5P disponibles ».</li></ul><p>Remarque : les utilisateurs ne pourront utiliser que les types de contenu H5P installés sur votre site.</p>';
$string['librarydirectoryerror'] = 'Le nom de dossier de la bibliothèque doit correspondre à machineName ou machineName-majorVersion.minorVersion (tiré de library.json) (dossier : {$a->%directoryName} , machineName : {$a->%machineName}, majorVersion : {$a->%majorVersion}, minorVersion : {$a->%minorVersion}).';
$string['license'] = 'Licence';
$string['licenseCC010'] = 'CC0 1.0 universel (CC0 1.0) Transfert dans le Domaine Public';
$string['licenseCC010U'] = 'CC0 1.0 universel';
$string['licenseCC10'] = '1.0 générique';
$string['licenseCC20'] = '2.0 générique';
$string['licenseCC25'] = '2.5 générique';
$string['licenseCC30'] = '3.0 non portée';
$string['licenseCC40'] = '4.0 internationale';
$string['licenseDescription'] = 'Sélectionner une licence pour votre contenu';
$string['licenseDetails'] = 'Détails de la licence';
$string['licenseDialogDescription'] = 'Cliquer sur une licence pour avoir des infos sur son usage correct';
$string['licenseGPL'] = 'Licence générale publique';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licenseVersionDescription'] = 'Sélectionner une version de licence';
$string['licensee'] = 'Détenteur de licence';
$string['licenseextras'] = 'Suppléments de licence';
$string['licenseversion'] = 'Version de la licence';
$string['lockh5pdeploy'] = 'Ce contenu H5P n’est pas disponible car il est en cours de déploiement. Veuillez essayer plus tard.';
$string['logoUploadText'] = 'Logo ou avatar de l’organisation';
$string['longDescription'] = 'Description longue';
$string['longDescriptionPlaceholder'] = 'Description longue de votre contenu';
$string['mainTitle'] = 'Partage de <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Ce fichier ne peut pas être affiché, car son type de contenu est désactivé. Veuillez contacter l’administrateur pour demander l’activation de ce type de contenu.';
$string['maxLength'] = ':length est le nombre maximum de caractères';
$string['missingcontentfolder'] = 'Un contenu de dossier valide est manquant';
$string['missingcoreversion'] = 'Le système n’a pas pu installer le composant {$a->%component} à partir du paquetage. Ce composant requiert une version plus récente du plugin H5P. Ce site utilise actuellement la version {$a->%current}, alors que la version requise est {$a->%required} ou ultérieure. Veuillez mettre à jour votre plugin et essayer à nouveau.';
$string['missingdependency'] = 'Dépendance manquante {$a->@dep} requise par {$a->@lib}.';
$string['missinglibrary'] = 'Bibliothèque manquante {$a->@library}';
$string['missinglibraryfile'] = 'Le fichier « {$a->%file} » manquent dans la bibliothèque « {$a->%name} »';
$string['missinglibraryjson'] = 'Impossible de trouver le fichier library.json en format json valide pour la bibliothèque {$a->%name}';
$string['missinglibraryproperty'] = 'La propriété requise {$a->%property} manque de {$a->%library}';
$string['missingmainlibrary'] = 'Bibliothèque principale manquante {$a->@library}';
$string['missingmbstring'] = 'L’extension PHP mbstring n’est pas chargée. Elle est requise pour un fonctionnement correct de H5P.';
$string['missinguploadpermissions'] = 'Remarque : les bibliothèques sont peut-être présentes dans le fichier déposé, mais vous n’avez pas les permissions requises pour déposer de nouvelles bibliothèques. Veuillez contacter l’administrateur du site.';
$string['next'] = 'Suivant';
$string['nocopyright'] = 'Aucune information de copyright disponible pour ce contexte.';
$string['noextension'] = 'Le fichier déposé n’est pas un paquetage HTML5 valide (il n’a pas l’extension de fichier .h5p).';
$string['noh5plibhandlerdefined'] = 'Il n’y a pas de gestionnaire de bibliothèques H5P installé, le contenu H5P ne peut pas être affiché.';
$string['nojson'] = 'Le fichier h5p.json n’est pas valide';
$string['nopermissiontodeploy'] = 'Ce fichier ne peut pas être affiché, car il a été déposé par un utilisateur qui n’a pas les permissions requises pour déployer de contenu H5P.';
$string['nopermissiontoedit'] = 'Vous n’avez pas les permissions requises pour modifier le contenu H5P.';
$string['notrustablefile'] = 'Ce fichier ne peut pas être affiché, car il a été déposé par un utilisateur qui n’a pas les permissions requises pour modifier les types de contenu H5P. Veuillez demander à l’administrateur du site d’installer ce type de contenu.';
$string['nounzip'] = 'Le fichier déposé n’est pas un paquetage HTML5 valide (il est impossible de le décompresser).';
$string['offlineDialogBody'] = 'Impossible d’envoyer des informations sur votre achèvement de cette tâche. Veuillez vérifier votre connexion internet.';
$string['offlineDialogHeader'] = 'La connexion avec le serveur a été perdue';
$string['offlineDialogRetryButtonLabel'] = 'Réessayer maintenant';
$string['offlineDialogRetryMessage'] = 'Nouvelle tentative dans :num…';
$string['offlineSuccessfulSubmit'] = 'Résultats envoyés sans erreur.';
$string['optionalInfo'] = 'Info facultatives';
$string['originator'] = 'Expéditeur';
$string['pd'] = 'Domaine public';
$string['pddl'] = 'Licence et Transfert dans le Domaine Public';
$string['pdm'] = 'Marque du domaine public (PDM)';
$string['phone'] = 'Téléphone';
$string['pleaseWait'] = 'Veuillez patienter…';
$string['pluginname'] = 'Paquetage H5P';
$string['privacy:metadata'] = 'Le sous-système H5P n’enregistre aucune donnée personnelle.';
$string['publisherDescription'] = 'Description éditeur';
$string['publisherDescriptionText'] = 'Ceci sera affiché sous « Informations de l’éditeur » des contenus partagés';
$string['publisherFieldDescription'] = 'Ceci sera affiché sous « Nom de l’éditeur » des contenus partagés';
$string['publisherFieldTitle'] = 'Éditeur';
$string['registerOnHub'] = 'S’enregistrer au Hub H5P';
$string['registrationFailed'] = 'Une erreur est survenue';
$string['registrationFailedDescription'] = 'Il n’a pas été possible de créer un compte. Veuillez ré-essayer plus tard.';
$string['registrationTitle'] = 'Enregistrement au Hub H5P';
$string['remove'] = 'Retirer';
$string['removeChip'] = 'Retirer :chip de la liste';
$string['removeImage'] = 'Retirer l’image';
$string['requiredInfo'] = 'Info requises';
$string['resizescript'] = 'Pour permettre le redimensionnement dynamique des contenus intégrés, inclure ce script dans votre site.';
$string['resubmitScores'] = 'Tentative d’envoyer les résultats enregistrés.';
$string['reuse'] = 'Réutiliser';
$string['reuseContent'] = 'Réutiliser contenu';
$string['reuseDescription'] = 'Réutiliser ce contenu.';
$string['reviewAndSave'] = 'Relire et enregistrer';
$string['reviewAndShare'] = 'Relire et partager';
$string['reviewInfo'] = 'Info de relecture';
$string['reviewMessage'] = 'Veuillez relire l’info ci-dessous avant de partager';
$string['saveChanges'] = 'Enregistrer les modifications';
$string['screenshots'] = 'Copies-écran';
$string['screenshotsDescription'] = 'Ajouter jusqu’à cinq copies-écran de votre contenu';
$string['share'] = 'Partager';
$string['shareFailed'] = 'Échec du partage.';
$string['shareTryAgain'] = 'Quelque chose s’est mal passé ; veuillez essayer de partager de nouveau.';
$string['shared'] = 'Partagé';
$string['sharingNote'] = 'Tous les détails du contenu peuvent être modifiés après le partage';
$string['shortDescription'] = 'Description courte';
$string['shortDescriptionPlaceholder'] = 'Description courte de votre contenu';
$string['showadvanced'] = 'Afficher avancé';
$string['showless'] = 'Montrer moins';
$string['showmore'] = 'Montrer plus';
$string['size'] = 'Taille';
$string['someKeywordsExits'] = 'Certains de ces mots-clefs existent déjà';
$string['source'] = 'Source';
$string['startingover'] = 'Vous allez recommencer depuis le début.';
$string['status'] = 'Statut';
$string['subContentWarning'] = 'Les sous-contenus (images, questions, etc.) seront partagés sous :license, à moins qu’une autre license ne soit spécifiée dans l’outil auteur';
$string['sublevel'] = 'Sous-niveau';
$string['submitted'] = 'Envoyé !';
$string['successfullyRegistred'] = 'Vous avez enregistré un compte sur le Hub H5P';
$string['successfullyRegistredDescription'] = 'Les infos de votre compte peuvent être modifiées';
$string['successfullyUpdated'] = 'Les réglages de votre compte sur le Hub H5P ont été modifiés';
$string['task_h5p'] = 'Tâche programmée H5P';
$string['task_h5p_description'] = 'La tâche programmée H5P télécharge les types de contenu H5P depuis le site h5p.org.';
$string['thumbnail'] = 'Vignette';
$string['title'] = 'Titre';
$string['undisclosed'] = 'Non communiqué';
$string['unpackedFilesExceedsMaxSize'] = 'La taille totale des fichiers décompressés dépasse la taille maximale autorisée. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Enregistrer les réglages du compte';
$string['updatedlibraries'] = '{$a->%old} bibliothèques H5P mises à jour.';
$string['updatedlibrary'] = '{$a->%old} bibliothèque H5P mise à jour.';
$string['uploadlibraries'] = 'Déposer des types de contenus H5P';
$string['uploadsuccess'] = 'Types de contenus H5P déposés correctement';
$string['width'] = 'largeur';
$string['wrongversion'] = 'La version de la bibliothèque H5P {$a->%machineName} utilisée dans ce contenu n’est pas valide. Le contenu contient {$a->%contentLibrary}, mais ce devrait être {$a->%semanticsLibrary}.';
$string['year'] = 'Année';
$string['years'] = 'Année(s)';
$string['yearsfrom'] = 'Années (de)';
$string['yearsto'] = 'Années (à)';
$string['zip'] = 'Code postal';
