<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_intelliboard', language 'fr', version '4.2'.
 *
 * @package     local_intelliboard
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a0'] = 'Tableau de bord des compétences';
$string['a1'] = 'Compétences';
$string['a10'] = 'Apprenants inscrits';
$string['a11'] = 'Liste des compétences assignées au cours';
$string['a12'] = 'Statut d’apprenant';
$string['a13'] = 'Nom de la compétence';
$string['a14'] = 'Créé sur';
$string['a15'] = 'Attribué à';
$string['a16'] = 'Technicien Indiqué';
$string['a17'] = 'Classement';
$string['a18'] = 'Compétences acquises';
$string['a19'] = 'Classement de la compétence par Date';
$string['a2'] = 'Compétence';
$string['a20'] = 'Évaluateur d’une compétence';
$string['a21'] = 'Activités assignées';
$string['a22'] = 'Compétence atteinte/acquise';
$string['a23'] = 'Compétences évaluées';
$string['a24'] = '# Preuves';
$string['a25'] = 'Apprenants complétés';
$string['a26'] = 'Ce tableau affiche le nombre de compétences attribuées à un cours, les apprenants qui ont été évalués (qu’ils soient compétents ou non) et les apprenants qui ont été désignés compétents dans la compétence.';
$string['a27'] = 'hors de';
$string['a28'] = 'Détails';
$string['a29'] = 'Activer le tableau de bord des compétences';
$string['a3'] = 'Activités assignées';
$string['a30'] = 'Activer les rapports de compétences';
$string['a31'] = 'Structures';
$string['a32'] = 'Plans d’apprentissage';
$string['a33'] = 'Évalué, Compétent';
$string['a34'] = 'Évalué, Non Compétent';
$string['a35'] = 'Non Évalué';
$string['a36'] = 'Aperçu des compétences';
$string['a37'] = 'Une compétence n’a pas été créée. Veuillez contacter votre administrateur système.';
$string['a38'] = 'Cours liés aux compétences';
$string['a39'] = 'Totaux de compétence';
$string['a4'] = 'Progrès de la compétence';
$string['a40'] = 'Cours liés';
$string['a5'] = 'Compétences évaluées';
$string['a6'] = '# Preuves';
$string['a7'] = 'Apprenants évalués';
$string['a8'] = 'Le progrès';
$string['a9'] = 'Apprentis compétents';
$string['account'] = 'Information d’abonnement';
$string['actions'] = 'actes';
$string['active'] = 'Actif';
$string['activities'] = 'Activités';
$string['activities_resources'] = 'Activités / Ressources';
$string['activity'] = 'Activité';
$string['activity_grades'] = 'Notes d’activité';
$string['activity_name'] = 'Nom de l’activité';
$string['activity_participation'] = 'Participation à l’activité';
$string['activity_progress'] = 'Progrès de l’activité';
$string['address'] = 'Adresse';
$string['adm_dshb_adm_dashb_totals'] = 'Totaux';
$string['adm_dshb_course_enrollments_types'] = 'Types d’inscription aux cours';
$string['adm_dshb_report_activity_stats_summary'] = 'Résumé des statistiques d\'activité du rapport';
$string['adm_dshb_report_quiz_activity_detail'] = 'Détail de l\'activité du quiz du rapport';
$string['adm_dshb_report_user_status'] = 'Signaler le statut de l\'utilisateur';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Inscription des utilisateurs, session, niveaux d’achèvement des activités';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Inscriptions aux cours avec vue d’ensemble de l’achèvement';
$string['adm_dshb_user_map'] = 'Carte des utilisateurs';
$string['adm_dshb_user_site_summary_details'] = 'Détail de l’utilisation du site par les utilisateurs';
$string['admin_dashboard'] = 'Tableau de bord Admin';
$string['adv_settings'] = 'Paramètres avancés';
$string['ajax'] = 'La fréquence';
$string['ajax_desc'] = 'Session stockant la fréquence via AJAX. 0 - AJAX désactivé (en secondes)';
$string['all_cohorts'] = 'Toutes les cohortes';
$string['all_courses'] = 'Tous les cours';
$string['all_data'] = 'Toutes les données';
$string['all_fields_required'] = 'Tous les champs sont obligatoires';
$string['all_modules'] = 'Tous les modules';
$string['all_selected'] = 'Tous sélectionnés';
$string['all_time'] = 'Tout le temps';
$string['allmod'] = 'L’ensemble des Activités';
$string['analityc_3_name'] = 'Aperçu du quiz et détails des questions';
$string['analytics'] = 'Analytique';
$string['answers'] = 'Réponses';
$string['api'] = 'API alternative';
$string['api_desc'] = 'Utiliser un serveur API alternatif (pour éviter le blocage du pare-feu)';
$string['assignment_name'] = 'Nom du devoir';
$string['assignments'] = 'Devoirs';
$string['attendance'] = 'Présence';
$string['attendanceapibase'] = 'Chemin de base de l’API de présence';
$string['attendanceapikey'] = 'Clé de l’API de présence';
$string['attendanceapisecret'] = 'Secret de l’API de présence';
$string['attendanceconsumerkey'] = 'Consumer key';
$string['attendancesharedsecret'] = 'Secret partagé';
$string['attendancetoolurl'] = 'URL de l’outil';
$string['authentication'] = 'Création de compte';
$string['authorized_user_descr'] = 'IntelliBoard nécessite un utilisateur autorisé. L’utilisateur autorisé sera probablement un administrateur de site et doit avoir des privilèges pour gérer les services Web, les protocoles et les jetons. Pour un examen supplémentaire, accédez à Administration du site > Plugins > Services Web > Services externes > Service IntelliBoard > Utilisateur autorisé';
$string['average_grade'] = 'la note moyenne';
$string['avg_score'] = 'La note moyenne';
$string['avg_time_spent_per_stud'] = 'Temps moyen passé par étudiant';
$string['avg_visits_per_stud'] = 'Visites moyennes par étudiant';
$string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API endpoint';
$string['bb_col_consumer_key'] = 'BlackBoard Collaborate consumer key';
$string['bb_col_meetings'] = 'Réunions BlackBoard Collaborate';
$string['bb_col_secret'] = 'BlackBoard Collaborate secret';
$string['bbbapiendpoint'] = 'BBB API endpoint';
$string['bbbmeetings'] = 'Réunions BigBlueButton';
$string['bbbserversecret'] = 'Secret du serveur BBB';
$string['billingcycles'] = 'Cycles de facturation';
$string['cache_compresstracking'] = 'Enregistrer dans le cache Moodle';
$string['cachedef_bb_collaborate_access_token'] = 'Jeton d’accès BB Collaborate';
$string['cachedef_instructor_course_data'] = 'Cache pour les données de cours';
$string['cachedef_reports_list'] = 'Cache pour la liste des rapports';
$string['cachedef_track_config'] = 'Intelliboard Suivi des données totales';
$string['cachedef_tracking'] = 'Intelliboard Suivi des données';
$string['cancel_subscription'] = 'Annuler l’abonnement';
$string['canceled'] = 'Annulé';
$string['categories'] = 'Catégories';
$string['category'] = 'Catégorie';
$string['check_active_bb_col_meetings'] = 'Vérifier les réunions BlackBoard Collaborate actives';
$string['check_active_meetings'] = 'Vérifier les réunions actives';
$string['cipherlist'] = 'CURLOPT SSL CIPHER LIST';
$string['cipherlist_desc'] = 'Specify ciphers to use for TLS';
$string['city'] = 'Ville';
$string['class_average'] = 'Moyenne de la classe';
$string['click_link_below_support_pages'] = 'Cliquez sur le lien ci-dessous pour accéder aux pages de support IntelliBoard:';
$string['close'] = 'Fermer';
$string['closed'] = 'Fermé';
$string['cohorts'] = 'Groupes';
$string['completed'] = 'Terminé';
$string['completed_activities'] = 'Activités terminées';
$string['completed_activities_resources'] = 'Activités terminées / ressources';
$string['completed_activities_resourses'] = 'Activités terminées / ressources';
$string['completed_courses'] = 'Cours complétés';
$string['completed_on'] = 'Terminé le {$a}';
$string['completion'] = 'Achèvement';
$string['completion_is_not_enabled'] = 'L’achèvement n’est pas activé pour ce cours';
$string['completion_not_enabled'] = 'Achèvement non activé';
$string['completion_status'] = 'L’état d’achèvement';
$string['completions'] = 'Statut d’achèvement de l’activité';
$string['completions_completed'] = 'État d’achèvement (terminé)';
$string['completions_desc'] = '1) L’utilisateur a terminé cette activité. Il n’est pas spécifié s’ils ont réussi ou échoué. <br> <br>
2) L’utilisateur a terminé cette activité avec une note supérieure à la note de passage. <br> <br>
3) L’utilisateur a terminé cette activité mais sa note est inférieure à la note de passage.';
$string['completions_fail'] = 'Statut d’achèvement (échoué)';
$string['completions_pass'] = 'Statut d’achèvement (réussite)';
$string['compresstracking'] = 'Compress Tracking';
$string['compresstracking_desc'] = 'Écrire les données de suivi du temps dans un fichier ou redis et transférer les données vers la base de données avec le travail cron (par défaut : toutes les 15 minutes)';
$string['confirm_and_sign_up'] = 'Confirmer et s’inscrire';
$string['congratulations_intb_register'] = 'Toutes nos félicitations';
$string['congratulations_intb_register_msg'] = 'Merci d’avoir commencé votre essai gratuit de 15 jours avec IntelliBoard ! Veuillez vérifier votre e-mail pour confirmer votre compte IntelliBoard. Pour commencer, utilisez le lien d’authentification unique (SSO), s’il est activé depuis Administration du site > IntelliBoard ou connectez-vous <a href="https://app.intelliboard.net/signin">ici</a>. Le lien SSO se lit comme "INTELLIBOARD.NET" et se trouve dans le coin supérieur droit du tableau de bord. Pour toute question, veuillez contacter Support@IntelliBoard.net.';
$string['cor_incor_answers'] = 'Réponses correctes/incorrectes';
$string['correct'] = 'Correct';
$string['correct_number'] = 'Correct {$a}';
$string['correlations'] = 'Corrélations';
$string['country'] = 'Pays';
$string['course'] = 'Le cours';
$string['course_activities'] = 'Activer les activités du cours';
$string['course_category'] = 'Catégorie de cours';
$string['course_chart'] = 'Activer le graphique du cours';
$string['course_completion_status'] = 'État d’achèvement du cours';
$string['course_completions'] = 'Cours complétés';
$string['course_enrollment_types'] = 'Types d’inscription aux cours';
$string['course_enrollments_with_completion_overview'] = 'Inscriptions aux cours avec vue d’ensemble de l’achèvement';
$string['course_grade'] = 'Note de cours';
$string['course_idnumber'] = 'Numéro d’identification';
$string['course_max_grade'] = 'Note maximale du cours';
$string['course_name'] = 'Nom du cours';
$string['course_name_a'] = 'Cours : {$a}';
$string['course_overview'] = 'Aperçu du cours';
$string['course_progress'] = 'Progression du cours';
$string['course_short_name'] = 'Nom abrégé du cours';
$string['course_start_date'] = 'Date de début du cours';
$string['course_started'] = 'Cours commencé';
$string['course_status'] = 'Statut';
$string['course_success'] = 'Réussite du cours';
$string['courseaverage'] = 'Moyenne du cours';
$string['coursecontainer_filter'] = 'Activer le filtre du conteneur de cours';
$string['courses'] = 'Cours';
$string['courses_avg_grade'] = 'Note moyenne des cours';
$string['courses_in_progress'] = 'Cours en progression';
$string['courses_sum_grade'] = 'Note cumulée du cours par valeur de l’échelle des notes';
$string['coursessessions'] = 'Séances de cours';
$string['coursessessionspage'] = 'Page des sessions de cours';
$string['created'] = 'Créé';
$string['criteria_all_courses'] = 'Tous les cours suivants doivent être suivis';
$string['criteria_any_course'] = 'L’un des cours suivants doit être suivi';
$string['criteria_method'] = 'Méthode des critères';
$string['csv'] = 'CSV';
$string['current_grade'] = 'Note actuelle';
$string['custommenuitem'] = 'Afficher dans le menu personnalisé';
$string['customod'] = 'Activités personnalisées';
$string['daily'] = '10 derniers jours';
$string['dashboard'] = 'Tableau de bord';
$string['dashboard_link'] = 'Cliquez pour voir les analyses';
$string['dashboard_settings'] = 'Paramètres du tableau de bord';
$string['date_created'] = 'Date créée';
$string['date_format'] = 'Format de date';
$string['debug'] = 'Debug CURL requests';
$string['debug_desc'] = 'Debug';
$string['delete_message'] = 'Supprimer le rapport SQL ? ';
$string['department'] = 'Département';
$string['details'] = 'Détails';
$string['disable_time_and_visits_users_overview'] = 'Désactiver le temps passé et les visites dans la vue d’ensemble des utilisateurs';
$string['disabled'] = 'désactivé';
$string['do_not_use_compresstracking'] = 'Ne pas utiliser Compress Tracking';
$string['done'] = 'Fait !';
$string['downloadinvoice'] = 'Télécharger la facture';
$string['due_date'] = 'Date d’échéance';
$string['email'] = 'Courriel';
$string['email_is_required'] = 'L’e-mail est requis';
$string['email_subscr'] = 'E-mail d’abonnement';
$string['enable_badges_report'] = 'Activer le rapport "Badges"';
$string['enable_bb_col_debug'] = 'Activer BlackBoard Collaborate debug';
$string['enable_bb_col_meetings'] = 'Activer BlackBoard Collaborate meetings';
$string['enable_sso'] = 'Activer Single Sign On (SSO) Link';
$string['enable_sso_descr'] = 'Activez le lien d’authentification unique pour un accès en un clic pour les administrateurs de site à l’accès IntelliBoard SuperAdmin sur app.IntelliBoard.net';
$string['enable_time_and_visits_users_overview'] = 'Activer le temps passé et les visites dans la vue d’ensemble des utilisateurs';
$string['enable_time_tracking'] = 'Activer le suivi du temps';
$string['enable_time_tracking_descr'] = 'Activez le suivi du temps pour obtenir des informations supplémentaires sur l’accès des utilisateurs, les visites et le temps passé. IntelliBoard fournit des informations supplémentaires sur le suivi du temps séparément des tableaux de temps passé de Moodle.';
$string['enable_transcripts'] = 'Activer Transcripts';
$string['enable_webservice'] = 'Activer les services web';
$string['enableattendance'] = 'Activer Présence';
$string['enablebbbdebug'] = 'BigBlueButton debug mode';
$string['enablebbbmeetings'] = 'Activer monitoring of BigBlueButton meetings';
$string['enabled'] = 'Suivi activé';
$string['enabled_desc'] = 'Activer le suivi';
$string['enableexportcustomfont'] = 'Police compatible japonais/chinois';
$string['enablesyncattendance'] = 'Activer BB Collaborate sessions synchronization avec Présence';
$string['enroled_on'] = 'Date de l’inscription';
$string['enrolled'] = 'Inscrit';
$string['enrolled_completed'] = 'Inscrit : {$a->courses}, Complété : {$a->completed_courses}';
$string['enrolled_completed_learners'] = 'Apprenants inscrits / complétés';
$string['enrolled_date'] = 'Date d’inscription';
$string['enrolled_users_completed'] = 'Utilisateurs inscrits : {$ a-> users}, Terminés : {$ a-> completed}';
$string['enrollments'] = 'Inscriptions';
$string['enrolment_expiration'] = 'Expiration de l’inscription';
$string['enrolment_method'] = 'Méthode d’inscription';
$string['enter_course_and_quiz'] = 'Veuillez sélectionner votre cours et votre quiz.';
$string['enter_quiz'] = 'Veuillez sélectionner votre quiz.';
$string['excel'] = 'Excel';
$string['expired'] = 'Expiré';
$string['failed'] = 'Échoué';
$string['failed_on'] = 'Terminé (échoué) sur {$a}';
$string['file_compresstracking'] = 'Enregistrer dans MoodleData';
$string['filter1'] = 'Utilisateurs supprimés';
$string['filter1_desc'] = 'Afficher les utilisateurs supprimés';
$string['filter2'] = 'Utilisateurs suspendus';
$string['filter2_desc'] = 'Afficher les utilisateurs suspendus';
$string['filter3'] = 'Utilisateur invité';
$string['filter3_desc'] = 'Afficher l’utilisateur [invité] dans les rapports';
$string['filter4'] = 'Filtre de cours';
$string['filter4_desc'] = 'Afficher les cours non visibles';
$string['filter5'] = 'Filtre de méthode d’inscription';
$string['filter5_desc'] = 'Afficher les méthodes d’inscription non actives';
$string['filter6'] = 'Filtre d’inscription de l’utilisateur';
$string['filter6_desc'] = 'Afficher les utilisateurs dont l’inscription n’est pas active';
$string['filter7'] = 'Activités / Ressources filter';
$string['filter7_desc'] = 'Afficher les activités / ressources non visibles';
$string['filter8'] = 'Filtre des utilisateurs inscrits';
$string['filter8_desc'] = 'Afficher uniquement les utilisateurs inscrits (non recommandé)';
$string['filter_all_time'] = 'Filtre temporel : Tout le temps';
$string['filter_dates'] = 'Filtrer les dates:';
$string['filter_last_year'] = 'Filtre temporel : l’année dernière';
$string['filter_this_year'] = 'Filtre temporel : Cette année';
$string['filters'] = 'Filtres de tableau de bord';
$string['first_access'] = 'Premier accès';
$string['first_name'] = 'Prénom';
$string['firstname_lastname'] = '{First Name} {Last Name}';
$string['goal_grade'] = 'Note d’objectif';
$string['grade'] = 'Note';
$string['grade_activities_overview'] = 'Aperçu des activités notées';
$string['graded'] = 'Noté';
$string['grades'] = 'Notes';
$string['grades_alt_text'] = 'Texte alternatif pour le menu de navigation';
$string['grid_view'] = 'Vue Grille';
$string['group_aggregation'] = 'Agrégation de groupe';
$string['help'] = 'Besoin d’aide ?';
$string['highest_grade'] = 'Meilleure note';
$string['hosting_provider'] = 'Fournisseur d’hébergement';
$string['ianalytics'] = 'IntelliBoard Analytics';
$string['id_number'] = 'Numéro d’identification';
$string['import'] = 'Importer';
$string['importing_logs'] = 'Importer les journaux';
$string['importing_totals'] = 'Importer des totaux';
$string['importtrackingtask'] = 'Tâche de suivi d’importation';
$string['in1'] = 'Vu/Aperçu';
$string['in10'] = 'Utilisation des événements';
$string['in11'] = 'Progression de l’apprenant';
$string['in12'] = 'Progression du niveau';
$string['in13'] = 'Temps passé (%)';
$string['in14'] = '% progression';
$string['in15'] = 'Achèvement d’apprenants';
$string['in16'] = 'Dernier accès';
$string['in17'] = 'Temps total passé';
$string['in18'] = 'Total des visites';
$string['in19'] = 'Note moyenne';
$string['in2'] = 'Progression actuelle';
$string['in20'] = 'Retourner aux apprenants';
$string['in201'] = 'Retour aux activités';
$string['in21'] = 'Niveau moyen du cours';
$string['in22'] = 'Activé(e)';
$string['in23'] = 'Vous n’avez aucun apprenant à afficher.';
$string['in24'] = 'Module';
$string['in25'] = 'Note de passage';
$string['in26'] = 'Engagement des apprenants';
$string['in27'] = 'Nombre total d’étudiants';
$string['in28'] = 'Temps moyen passé';
$string['in29'] = 'Étudiants actifs';
$string['in3'] = 'Total des cours';
$string['in30'] = 'Étudiants non actifs';
$string['in31'] = 'Utilisation de l’activité';
$string['in32'] = 'Temps moyen dans la période sélectionnée';
$string['in33'] = 'Utilisation du sujet';
$string['in34'] = 'Avancement de la note étudiant';
$string['in4'] = 'Total des apprenants';
$string['in5'] = 'Nombre total de cours et leurs niveaux';
$string['in6'] = 'Apprenants complétés';
$string['in7'] = 'Apprenants incomplets';
$string['in8'] = 'niveau moyen d’un apprenant';
$string['in9'] = 'Corrélations';
$string['inactivity'] = 'Inactivité';
$string['inactivity_desc'] = 'Temps d’inactivité de l’utilisateur (en secondes)';
$string['incomplete'] = 'Incomplet';
$string['incorrect'] = 'Incorrect';
$string['incorrect_number'] = 'Incorrect {$a}';
$string['initial_reports'] = 'Rapports initiaux';
$string['initial_reports_warning'] = 'Pour envoyer par e-mail, planifier et personnaliser davantage ces rapports, cliquez sur "<a href="{$a}">Se connecter et mettre à niveau</a>".';
$string['inprogress'] = 'En cours';
$string['institution'] = 'Institution';
$string['instructor_course_shortname'] = 'Afficher le nom abrégé du cours à la place du nom complet du cours';
$string['instructor_course_visibility'] = 'Afficher les cours masqués/suspendus pour [instructeur]';
$string['instructor_courses_table_name'] = 'Notes de cours';
$string['instructor_courses_table_name_activities'] = 'Cours {$a->fullname}, Activités';
$string['instructor_courses_table_name_activity'] = 'Cours {$a->course}, Activité {$a->name}, Notes';
$string['instructor_courses_table_name_learner'] = 'Cours {$a->course}, Apprenant {$a->learner}, Notes';
$string['instructor_courses_table_name_learners'] = 'Cours {$a->fullname}, Étudiants';
$string['instructor_custom_groups'] = 'Groupes personnalisés d’instructeurs';
$string['instructor_hide_need_help'] = 'Masquer le bouton "Besoin d’aide"';
$string['instructor_hide_suspended_enrollments'] = 'Masquer les inscriptions suspendues';
$string['instructor_mode'] = 'Afficher tous les cours disponibles pour [instructeur]';
$string['instructor_mode_access'] = 'Afficher tous les cours disponibles pour [instructeur] avec les autorisations [mise à jour]';
$string['instructor_redirect'] = 'Redirection de l’instructeur vers le dashboard';
$string['instructor_show_suspended_enrollments'] = 'Afficher les inscriptions suspendues';
$string['intb_settings_descr'] = 'IntelliBoard nécessite un e-mail d’abonnement principal et unique. Veuillez saisir ci-dessous l’e-mail que vous souhaitez utiliser comme e-mail d’abonnement. L’e-mail doit être vérifié deux fois par le biais d’un e-mail de confirmation avant utilisation. Pour toute question, veuillez contacter <a href=\'mailto:Support@IntelliBoard.net\'>Support@IntelliBoard.net</a>. Pour une liste complète des paramètres IntelliBoard, accédez à Administration du site > Plugins > Plugins locaux > IntelliBoard';
$string['intelliBoard_migration_tool'] = 'Outil de migration IntelliBoard';
$string['intelliBoard_migration_tool_info'] = 'L’outil de migration IntelliBoard est utilisé pour migrer les données historiques de la table des journaux Moodle vers un nouveau format. Veuillez noter que la procédure de stockage des journaux Moodle ne changera pas. Une fois les données historiques migrées vers un nouveau format, des valeurs historiques telles que «Temps passé» et «Visites» seront disponibles pour un aperçu sur IntelliBoard.net.';
$string['intelliboard:attendanceadmin'] = 'Administrateur de Présence ';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [Parcourir toutes les cohortes]';
$string['intelliboard:competency'] = 'IntelliBoard [competency]';
$string['intelliboard:instructors'] = 'IntelliBoard [instructor]';
$string['intelliboard:manage'] = 'IntelliBoard [manage]';
$string['intelliboard:students'] = 'IntelliBoard [student]';
$string['intelliboard:view'] = 'IntelliBoard [view]';
$string['intelliboard_logs'] = 'Journaux IntelliBoard';
$string['intelliboard_reports'] = 'Rapports IntelliBoard';
$string['intelliboard_settings'] = 'Paramètres IntelliBoard';
$string['intelliboard_start_tracking'] = 'commencer le suivi IntelliBoard';
$string['intelliboard_terms'] = 'Accords IntelliBoard';
$string['intelliboard_totals'] = 'Totaux IntelliBoard';
$string['intelliboard_tracking'] = 'Suivi IntelliBoard';
$string['intelliboardaccess'] = 'Vous n’êtes pas autorisé à voir cette page. Veuillez contacter votre administrateur pour obtenir de l’aide.';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intellicart'] = 'Intégration IntelliCart';
$string['intellicart_app_reports_integration'] = 'Intégration avec les rapports IntelliBoard';
$string['intellicart_desc'] = 'Autoriser les étudiants à voir les rapports IntelliCart.';
$string['intellicart_instructor_integration'] = 'Intégration avec le tableau de bord de l’instructeur';
$string['intellicart_student_integration'] = 'Intégration avec le tableau de bord étudiant';
$string['invalid_email'] = 'Courriel non valide';
$string['invalid_user'] = 'Utilisateur non valide';
$string['issuer'] = 'Émetteur';
$string['items_per_query'] = 'Éléments par requête';
$string['join_a_webinar'] = 'Rejoignez un webinaire';
$string['key'] = 'Key';
$string['last_access'] = 'Dernier accès';
$string['last_access_on_course'] = 'Dernier accès sur le parcours : {$a}';
$string['last_day'] = 'Jour';
$string['last_hour'] = 'Heure';
$string['last_month'] = 'Les 30 derniers jours';
$string['last_name'] = 'Nom de famille';
$string['last_quarter'] = '3 derniers mois';
$string['last_semester'] = '6 derniers mois';
$string['last_week'] = 'Les 7 derniers jours';
$string['last_year'] = 'L’année dernière';
$string['lastname_firstname'] = '{Last Name} {First Name}';
$string['learner_menu'] = 'Afficher "Tableau de bord de l’apprenant" dans le menu du bloc de navigation uniquement pour les apprenants inscrits';
$string['learner_name'] = 'Nom de l’apprenant';
$string['learner_tf_last_week'] = 'Filtre temporel : 7 jours ';
$string['learners'] = 'Apprenants';
$string['learners_enrolled'] = 'Learners Enrolled';
$string['learners_enrolled_period'] = 'Apprenants inscrits pendant la période sélectionnée';
$string['learning'] = 'Apprentissage';
$string['learning_plan_filter'] = 'Filtre de plan d’apprentissage';
$string['learning_plan_viewer_role'] = 'Rôle "Lecteur du plan d’apprentissage"';
$string['learning_progress'] = 'Progrès d’apprentissage';
$string['letter'] = 'Lettre';
$string['list_view'] = 'Vue liste';
$string['load'] = 'Performance';
$string['loading'] = 'Chargement…';
$string['loading2'] = 'Veuillez patienter, chargement…';
$string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Demande d’API terminée pour BB Collaborate';
$string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Suivi terminé de la session BB Collaborate';
$string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'Début du suivi de la session BB Collaborate';
$string['log_values_include'] = 'Les valeurs de journal incluent des journaux pour chaque utilisateur par jour.';
$string['logs'] = 'Outil de migration';
$string['logs_to_process'] = 'Journaux à traiter {$a}';
$string['lowest_grade'] = 'Note la plus basse';
$string['messageprovider:intelliboard_notification'] = 'Notification Intelliboard';
$string['messages'] = 'Messages';
$string['modulename'] = 'Nom du module';
$string['modules'] = 'Modules';
$string['monitors'] = 'Moniteurs';
$string['monitorselect'] = 'Veuillez sélectionner au moins un moniteur sur App.IntelliBoard.net. Cliquez sur un moniteur, puis sur Paramètres des moniteurs, et sélectionnez-le dans "Visible dans Moodle". ';
$string['monthly'] = '365 derniers jours';
$string['moodle'] = 'Moodle';
$string['moodle_logs'] = 'Journaux Moodle';
$string['moodle_settings'] = 'Paramètres Moodle';
$string['more_courses'] = 'Plus de cours';
$string['more_users'] = 'Plus d’utilisateurs';
$string['my_course_average_all'] = 'ma moyenne de cours (tous les cours)';
$string['mygrade'] = 'Ma note';
$string['myorders'] = 'Commandes passées';
$string['myprogress'] = 'Progression de mes notes';
$string['myseats'] = 'Seats';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlmonth'] = '%c';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlquarter'] = 'Trimestre';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlyear'] = '%Y';
$string['mysubscriptions'] = 'Abonnements';
$string['mywaitlist'] = 'Liste d’attente';
$string['n1'] = 'Aperçu/vue [Progression de l’apprenant]';
$string['n10'] = 'Tableau de bord de l’instructeur';
$string['n101'] = 'Activer le tableau de bord de l’instructeur';
$string['n11'] = 'Texte alternatif pour le menu de navigation';
$string['n12'] = 'Aperçu/vue [Aperçu du cours]';
$string['n13'] = 'Nombre total d’étudiants';
$string['n14'] = 'Widget : Engagement des apprenants';
$string['n15'] = 'Widget : Utilisation des activités';
$string['n16'] = 'Widget : Utilisation du sujet';
$string['n17'] = 'Page d’analyse';
$string['n18'] = 'Widget : Avancement de la note étudiant';
$string['n19'] = 'Lien de navigation pour les rapports dans les cours';
$string['n2'] = 'Aperçu [Avancement des notes]';
$string['n3'] = 'Aperçu [Avancement de l’activité]';
$string['n4'] = 'Aperçu [Totaux]';
$string['n5'] = 'Progression Actuelle';
$string['n6'] = 'Widget : Corrélations';
$string['n7'] = 'Widget : Utilisation de l’événement';
$string['n8'] = 'Page des cours';
$string['n9'] = 'Page des rapports';
$string['name'] = 'Nom ';
$string['names_order'] = 'Ordre des noms';
$string['next'] = 'Page suivante';
$string['no_competency'] = 'il semble que vous n’ayez pas activé les compétences sur votre site Moodle.';
$string['no_data'] = 'Pas de données';
$string['no_data_notification'] = 'Il n’y a pas de nouvelles données pour [date]';
$string['not_connected'] = 'Pas connecté';
$string['not_quiz'] = 'Oups, il semble que vous n’ayez créé aucun quiz pour le cours sélectionné.';
$string['notstarted'] = 'Pas commencé';
$string['num_attempts'] = 'Nombre de tentatives';
$string['num_completed_activity'] = 'Nombre d’étudiants ayant achevé cette activité';
$string['number_of_completed_learners'] = 'Nombre d’étudiants ayant achevé le cours';
$string['number_of_learners'] = 'Nombre d’étudiants inscrits';
$string['number_of_modules'] = 'Nombre d’activités';
$string['number_of_sessions'] = 'Nombre de sessions';
$string['number_of_visits'] = 'Visites';
$string['number_this_week'] = '{$a} cette semaine';
$string['number_today'] = '{$a} aujourd’hui';
$string['numberofseats'] = 'Nombre de places';
$string['ok'] = 'approuvé';
$string['overall_course_average'] = 'Moyenne générale des cours (tous les apprenants, tous les cours)';
$string['participation'] = 'Participation';
$string['passed'] = 'Passé';
$string['passed_on'] = 'Terminé (réussite) sur {$a}';
$string['passing_score_for'] = 'Note pour réussir {$a}';
$string['password'] = 'Mot de passe';
$string['pdf'] = 'PDF';
$string['percentage_completed_learners'] = 'Pourcentage d’étudiants ayant achevé';
$string['please_accept_terms_and_conditions'] = 'Veuillez accepter les termes et conditions';
$string['please_wait_or_cancel'] = 'Veuillez patienter pour continuer ou <a href="{$a}"> Annuler </a>';
$string['pluginname'] = 'IntelliBoard.net Plugin';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgremonth'] = 'MM';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarter'] = 'Trimestre';
$string['postgrequarteryear'] = 'T YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';
$string['postgreweek'] = 'YYYY, "semaine" WW';
$string['postgreyear'] = 'YYYY';
$string['powered_by'] = 'Fait par <a href="https://intelliboard.net/">IntelliBoard</a>';
$string['price'] = 'Prix';
$string['privacy:metadata:local_intelliboard_assign'] = 'Tableau des attributions de sous-comptes Intelliboard';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'ID d’instance Moodle connectée';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Rel type d’enregistrement';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Horodatage des enregistrements';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Type d’instance Moodle';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'ID UTILISATEUR de l’enregistrement';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'Liste des sessions synchronisées';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Données de synchronisation supplémentaires';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID of sync log';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'ID de session Moodle';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Type de séance';
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'Liste des participants à la session Collaborate';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Nom d’utilisateur';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Temps passé en session';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'ID utilisateur (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Première entrée en session';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID de participation à la session';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Dernière sortie de session';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Nombre de rejoins à la session';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Rôle de session';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'UUID de session';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'UUID utilisateur (service BlackBoard Collaborate)';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Liste des sessions suivies';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID du journal de suivi';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'UUID de session';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Temps de suivi';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Journaux sur les participants aux réunions BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Heure à laquelle l’utilisateur s’est connecté à la réunion';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Heure à laquelle l’utilisateur s’est déconnecté de la réunion';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Nom complet du participant à la réunion';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = '! Le participant a connecté un microphone';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = '! Le participant a connecté sa webcam';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'ID de participant';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = '! Le participant n’a pas de microphone ou de webcam connecté';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = '! Le participant est le présentateur';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'ID de réunion (ID dans le tableau local_intelliboard_bbb_meet)';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'ID de réunion (ID dans le serveur BigBlueButton)';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Rôle du participant à la réunion';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'ID utilisateur (ligne dans le tableau "utilisateur")';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Journaux des réunions BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'Le mot de passe qui sera demandé aux participants pour rejoindre la réunion';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'ID de ligne dans le tableau bigbluebuttonbn';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'ID du module de cours';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'Identifiant du cours';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Date de création (chaîne)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Heure de création (horodatage)';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'Le numéro d’accès à composer que les participants peuvent appeler à l’aide d’un téléphone ordinaire.';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Durée de la réunion';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Heure de fin de la réunion';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = '! La réunion a été interrompue de force';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = '! Les utilisateurs ont rejoint la réunion';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'ID du journal de réunion';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'ID de réunion interne (sur le serveur BBB)';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Nombre d’auditeurs';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Nombre max de participants';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'Identifiant de la réunion';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Intitulé de la réunion';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Nombre de modérateurs';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'Mot de passe requis pour permettre aux modérateurs de rejoindre la réunion ou pour certaines actions d’administration.';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'ID du propriétaire (utilisateur qui a créé la réunion)';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Nombre de participants';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = '! La réunion sera enregistrée';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Statut de la réunion (actif | arrêté)';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Heure de début de la réunion';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Nombre de participants avec caméra vidéo connectée';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'Le numéro de poste pour le pont vocal (à utiliser si connecté au système téléphonique)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Nombre de participants avec microphone connecté';
$string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard alt/logs/by-hour table';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'Table ID [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'L’heure';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'Le temps passé par heure';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'Le nombre de visites, clics de souris, par jour';
$string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard alt/logs/by-day table';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Horodatage du jour de l’année';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Temps passé, par jour';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'The ID of the table [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Visites, clics de souris, par jour';
$string['privacy:metadata:local_intelliboard_ntf'] = 'Table principal des notifications Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Pièce jointe à la notification';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Notification en copie cc';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Notification par e-mail ';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'ID externe de notification';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'ID de notification';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'Message de notification';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'État des notifications';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Sujet de la notification';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Étiquettes de notification';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Type de notification';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Notification External App ID';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Tableau d’historique des notifications Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Historique des notifications';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'ID Historique des notifications ';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'Identifiant de notification';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Nom de notification ';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Historique des notifications horodatage';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'Notification ExternalAppID';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Tableau des paramètres dynamiques des notifications IntelliBoard';
$string['privacy:metadata:local_intelliboard_reports'] = 'Tableau des rapports sql personnalisés d’IntelliBoard';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'Nom du rapport personnalisé';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64 encoded SQL code';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'Statut du rapport - activé/non activé';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Date de création';
$string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard alt/logs/total table';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Total des cours sur Moodle';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Nombre total de sessions utilisateur dans Moodle';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Horodatage du jour de l’année';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Temps total des utilisateurs passé dans Moodle';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Nombre total de visites par tous les utilisateurs de Moodle ';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard alt/logs/all-time table';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'ID de cours visité par l’utilisateur';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Premier accès des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Dernier accès des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Type de page [cours,module,profil,site]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Type d’identifiant de page';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Temps passé par les utilisateurs sur une page';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Type de navigateur des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'ID utilisateur qui visite la page Moodle.';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Dernière adresse IP des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Langue du navigateur des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Système d’exploitation des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Visites des utilisateurs sur une page';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transcripts courses records';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Date d’achèvement';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'Identifiant du cours';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Nom complet du cours';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Date de l’inscription';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Enroll record ID';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Méthode d’inscription';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Note finale';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Prénom de l’utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Note formatée';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'ID de la note';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'ID d’élément de note';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Note maximale';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Note minimale';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Groupes d’utilisateurs';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Nom de famille de l’utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Rôles d’utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'État de la transcription';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Horodatage lors de la création de l’enregistrement';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Horodatage de la dernière mise à jour de l’enregistrement';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Date de désinscription';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Courriel de l’utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transcripts user enroll ID';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'Identifiant d’utilisateur';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Relevés de notes des cours';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'ID du module de cours';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Date d’achèvement';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Identifiant du cours';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Note finale';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Note formatée';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'ID de la note';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'ID d’élément de note';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Note maximale';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Note minimale';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Identifiant du module';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Nom de l’activité';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Type de module';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Date de début';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Statut';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Horodatage de création de l’enregistrement';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Horodatage de la dernière mise à jour de l’enregistrement';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transcripts user enroll ID';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'Identifiant d’utilisateur';
$string['privacy_msg'] = 'En cochant cette case, vous confirmez avoir lu et accepté notre politique de confidentialité.';
$string['privacy_policy'] = 'Politique de confidentialité.';
$string['privacy_shield_policy'] = 'Avenant sur le traitement des données';
$string['process'] = 'Traiter';
$string['product'] = 'Produit';
$string['progress'] = 'Le progrès';
$string['protocol'] = 'Protocole';
$string['protocol_descr'] = 'IntelliBoard nécessite l’activation du protocole REST ou SOAP. Pour des raisons de sécurité, seuls les protocoles en cours d’utilisation doivent être activés. Pour un examen supplémentaire, accédez à Administration du site> Plugins> Services Web> Gérer les protocoles';
$string['protocols_descr'] = 'IntelliBoard nécessite l’activation du protocole REST ou SOAP. Pour des raisons de sécurité, seuls les protocoles en cours d’utilisation doivent être activés. Pour un examen supplémentaire, accédez à Administration du site> Plugins> Services Web> Gérer les protocoles';
$string['ques_breakdown'] = 'Répartition des questions';
$string['quiz_finished'] = 'Quiz achevé';
$string['quiz_grades'] = 'Notes au quiz';
$string['quiz_name'] = 'Nom du test';
$string['quiz_name_a'] = 'Test : {$a}';
$string['quizzes'] = 'Questionnaires';
$string['recurringperiod'] = 'Période récurrente';
$string['registered'] = 'Inscrit';
$string['registrations'] = 'Inscriptions';
$string['remove_message'] = 'Le rapport SQL a été supprimé';
$string['report'] = 'rapport';
$string['report1_name'] = 'Statut de l’utilisateur';
$string['report2_name'] = 'Statistiques du cours';
$string['report3_name'] = 'Statistiques d’activité';
$string['report45_name'] = 'Activité sur le quiz';
$string['report_activity_stats_summary'] = 'Statistiques d’activité';
$string['report_user_profile_information'] = 'Informations sur le profil utilisateur';
$string['reports'] = 'Rapports';
$string['reportselect'] = 'Veuillez sélectionner au moins un rapport sur App.IntelliBoard.net. Cliquez sur un rapport, puis sur Paramètres du rapport, et sélectionnez-le dans "Visible dans Moodle". ';
$string['rest'] = 'REST';
$string['return_to_courses'] = 'Retour aux cours';
$string['return_to_grades'] = 'Retour aux notes';
$string['return_to_home'] = 'Retourner à l’acceuil';
$string['return_to_sessions'] = 'Retour aux séances';
$string['review_support_doc'] = 'Consulter la documentation support';
$string['role1'] = 'Premier rôle';
$string['role2'] = 'Deuxième rôle';
$string['s25'] = 'Temps consacré à l’activité';
$string['s45'] = 'Activité';
$string['s46'] = 'Pourcentage d’étudiants qui ont essayé';
$string['s47'] = 'Sujet';
$string['s48'] = 'Temps passé sur le sujet';
$string['save'] = 'Sauvegarder';
$string['scale_percentage'] = 'Pourcentage';
$string['scale_percentage_round'] = 'Pourcentage arrondi';
$string['scale_raw'] = 'Désactiver l’échelle';
$string['scale_real'] = 'Afficher la note réelle à la place du pourcentage';
$string['scale_total'] = 'Note totale';
$string['scale_value'] = 'Valeur';
$string['scales'] = 'Activer l’échelle personnalisée';
$string['scalesettings'] = 'Paramètres d’échelle';
$string['score'] = 'Note';
$string['seatnumber'] = 'Nombre de places';
$string['seatscode'] = 'Code des places';
$string['seatsused'] = 'Place utilisé';
$string['section'] = 'Section';
$string['sections'] = 'Sections';
$string['select'] = 'Sélectionner';
$string['select_course'] = 'Sélectionnez un cours';
$string['select_date'] = 'Sélectionner une date';
$string['select_manager_role'] = 'Sélectionnez le rôle de gestionnaire';
$string['select_quiz'] = 'Sélectionnez le test';
$string['select_user'] = 'Sélectionnez l’utilisateur';
$string['selectall'] = 'Tout sélectionner';
$string['self_hosted'] = 'Auto-hébergé';
$string['server'] = 'Serveur IntelliBoard';
$string['server_au'] = 'IntelliBoard Australie';
$string['server_error'] = 'Oups ! Quelque chose d’inattendu s’est produit. Veuillez nous contacter à support@intelliboard.net';
$string['server_eu'] = 'IntelliBoard Europe';
$string['server_usa'] = 'IntelliBoard USA';
$string['session_name'] = 'Nom de la séance';
$string['session_time'] = 'Date de la séance';
$string['settings'] = 'Paramètres';
$string['setup'] = 'Se connecter maintenant';
$string['setup_subheading'] = 'Connectez-vous pour découvrir la puissance de vos données. Pas de carte de crédit. Aucune obligation. Seulement 15 jours gratuits de bonheur de données.';
$string['shield_msg'] = 'En cochant cette case, vous confirmez que vous avez lu et accepté notre avenant sur le traitement des données.';
$string['show_dashboard_tab'] = 'Tableau de bord';
$string['showing_1_to_10'] = 'Afficher 1 à 10';
$string['sign_in'] = 'S’identifier';
$string['sign_up'] = 'S’inscrire';
$string['sizemode'] = 'Mode Taille : Grand (> 5 000 utilisateurs) ';
$string['soap'] = 'SOAP';
$string['sqlreport'] = 'Rapport SQL';
$string['sqlreportactive'] = 'Activé';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportcreate'] = 'Créer un rapport';
$string['sqlreportdate'] = 'Créé sur';
$string['sqlreportinactive'] = 'Désactivé';
$string['sqlreportname'] = 'Nom du rapport';
$string['sqlreports'] = 'Rapports SQL';
$string['sslversion'] = 'CURLOPT SSLVERSION';
$string['sslversion_desc'] = 'Entrez un paramètre long as pour contrôler la plage de versions de versions SSL / TLS à utiliser';
$string['sso'] = 'Lien SSO';
$string['sso_desc'] = 'Lien SSO vers IntelliBoard.net ';
$string['ssodomain'] = 'Sous domaine SSO';
$string['ssodomain_desc'] = 'Authentification unique avec serveur/compte séparés';
$string['ssomenu'] = 'Élément de menu SSO ';
$string['ssomenu_desc'] = 'Lien SSO dans le menu du bloc de navigation (pour l’Admin UNIQUEMENT)';
$string['status'] = 'Statut';
$string['student_course_visibility'] = 'Afficher les cours cachés/suspendus pour [étudiant]';
$string['student_grades'] = 'Notes d’étudiant';
$string['student_redirect'] = 'Redirection des étudiants ver le dashboard';
$string['subscriptiondate'] = 'Date de souscription';
$string['success_message'] = 'Le rapport SQL a été enregistré';
$string['successfull_connected'] = 'Connecté avec succès';
$string['support'] = 'Soutien';
$string['support_close'] = 'Fermer';
$string['support_connect'] = 'Cliquez sur les boutons de rapport dans le rectangle ci-dessous. Découvrez la puissance d’IntelliBoard : 1 bouton d’accès à vos informations LMS. Vouloir plus? Cliquez sur "Cliquez pour afficher les analyses". Vous en voulez encore plus ? <a href="{$a->connect_link}">"Connect & Upgrade"</a> en haut à droite, ou partout où vous voyez le lien.';
$string['support_demo'] = 'Planifier une démo';
$string['support_info1'] = 'Vous pouvez rejoindre nos <a target=\'_blank\' href=\'https://intelliboard.net/events\'>webinaires</a> pendant que nous vous faisons découvrir les rapports et les analyses d’IntelliBoard 5.0 !';
$string['support_info2'] = 'Rejoignez nos <a target=\'_blank\' href=\'https://intelliboard.net/events\'>Webinaires</a>, ou planifiez une visite personnelle de vos propres données. Grâce à notre assistance et à nos services de classe mondiale, vous verrez votre LMS sous un tout nouveau jour. ';
$string['support_page'] = 'Examiner la documentation ';
$string['support_terms'] = 'Tous droits réservés.';
$string['support_text1'] = 'Toutes vos données Moodle : faciles, partageables, compréhensibles et attrayantes. IntelliBoard est un plugin Moodle qui met entre vos mains <strong>120+</strong> rapports et moniteurs. ';
$string['support_text10'] = 'Passer à <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Cliquez ici</a> pour télécharger la page d\'IntelliBoard Pro.';
$string['support_text2'] = 'Toutes vos données Moodle : faciles, partageables, compréhensibles et attrayantes. IntelliBoard est votre solution de rapport et d’analyse Moodle, vous offrant plus de 120 rapports et analyses pour vous aider à éclairer vos décisions commerciales en matière d’éducation.';
$string['support_text3'] = 'Bienvenue sur IntelliBoard ! Les institutions du monde entier utilisent IntelliBoard pour surveiller la rétention, les progrès, l’achèvement et l’engagement. Toutes vos données LMS dans des rapports et des graphiques facilement récupérables, intuitifs, partageables, compréhensibles et attrayants.';
$string['support_text4'] = 'Découvrez une plateforme de reporting et de visualisation facile à utiliser qui vous aidera à atteindre vos objectifs de rétention, d\'engagement et de conformité.';
$string['support_text6'] = 'Besoin de plus d’informations ? Cliquez sur l’un des boutons bleus pour nous contacter.';
$string['support_text7'] = 'Pour commencer à utiliser <strong>IntelliBoard Lite</strong>, veuillez <a href="{$a->meeting_link}">planifier une consultation</a> avec l\'un de nos experts en analyse d\'apprentissage.';
$string['support_text8'] = 'Si vous avez <strong>déjà acheté</strong> une licence et voyez cet écran, veuillez contacter votre responsable de compte pour obtenir de l\'aide.';
$string['support_text9'] = 'Besoin de modèles prédictifs, de notifications et de suivi des interventions ?';
$string['support_trial'] = 'Commencer votre essai gratuit';
$string['suspended'] = 'Suspendu';
$string['sync_data_with_attendance'] = 'Synchroniser les données avec Présence';
$string['synctranscriptstask'] = 'Sync Transcripts Task';
$string['t01'] = 'Filtre temporel: 30 derniers jours';
$string['t02'] = 'Filtre temporel: 3 derniers mois';
$string['t03'] = 'Filtre temporel: 6 derniers mois';
$string['t04'] = 'Activer [header] Cours terminés';
$string['t05'] = 'Activer [header] Cours en progression';
$string['t06'] = 'Activer [header] Cours niveau moyen';
$string['t07'] = 'Activer [header] Messages';
$string['t08'] = 'Activer [header] Note récapitulative des cours';
$string['t09'] = 'L’enseignant peut voir ses propres étudiants';
$string['t1'] = 'Activer le tableau de bord Apprenants';
$string['t10'] = 'Activer le widget [Quizzes]';
$string['t11'] = 'Activer le widget [Course Progress]';
$string['t12'] = 'Activer le widget [Activity participation]';
$string['t13'] = 'Activer le widget [Learning]';
$string['t14'] = 'Activer le widget [Course success]';
$string['t15'] = 'Activer le widget [Correlations]';
$string['t16'] = 'Activer le cours enseignant';
$string['t17'] = 'Activer la catégorie de cours';
$string['t18'] = 'Activer l’achèvement du cours';
$string['t19'] = 'Activer le niveau';
$string['t2'] = 'Activer le tableau de bord';
$string['t20'] = 'Activer la note moyenne du cours';
$string['t21'] = 'Activer le temps de cours passé';
$string['t22'] = 'Activer la date de début du cours';
$string['t23'] = 'Activer la colonne [Course start date]';
$string['t24'] = 'Activer la colonne [Enrolled date]';
$string['t25'] = 'Activer la colonne [Progress]';
$string['t26'] = 'Activer la colonne [Letter]';
$string['t27'] = 'Activer la colonne [Completed Activities]';
$string['t28'] = 'Activer la colonne [Note]';
$string['t29'] = 'Activer la colonne [Course Completion Status]';
$string['t3'] = 'Activer les cours';
$string['t30'] = 'Activer la colonne [Activity Grades]';
$string['t31'] = 'Activer la colonne du widget [Assignments][Grade]';
$string['t32'] = 'Activer la colonne du widget [Assignments][Due Date]';
$string['t33'] = 'Activer la colonne du widget [Quizzes][Grade]';
$string['t34'] = 'Activer la colonne du widget [Quizzes][Due Date]';
$string['t35'] = 'Activer la colonne du widget [Course Progress][Progress]';
$string['t36'] = 'Activer la colonne du widget [Course Progress][Grade]';
$string['t37'] = 'Activer la colonne du widget [Course Progress][Enrolled]';
$string['t38'] = 'Activer la colonne du widget [Course Progress][Completed]';
$string['t39'] = 'Activer l’option [Progress][Goal Grade]';
$string['t4'] = 'Activer les notes';
$string['t40'] = 'Activer l’option [Progress][Class Avg.]';
$string['t41'] = 'Activer [Activity Grades header] Terminé le';
$string['t42'] = 'Activer [Activity Grades header] Dernier accès au cours';
$string['t43'] = 'Activer la colonne Type d’activité [Activity Grades]';
$string['t44'] = 'Activer la colonne [Notes d’activité]';
$string['t45'] = 'Activer la colonne Noté [Activity Grades]';
$string['t46'] = 'Activer la colonne complétée [Activity Grades]';
$string['t47'] = 'Cours [grid] couleur de fond';
$string['t48'] = 'Activer les rapports';
$string['t49'] = 'Signaler les colonnes de filtre';
$string['t5'] = 'Activer le graphique [Activity progress]';
$string['t50'] = 'Rôles de l’enseignant';
$string['t51'] = 'Rôles de l’étudiant';
$string['t52'] = 'Activer les lignes du widget [Course Progress][Category] ';
$string['t53'] = 'Activer la ligne "moyenne" du graphique sur [Avancement de l’activité]';
$string['t54'] = 'Activer la colonne Temps passé [Notes d’activité]';
$string['t6'] = 'Activer le graphique [Course progress]';
$string['t7'] = 'Activer [My course average]';
$string['t8'] = 'Activer [Overall course average]';
$string['t9'] = 'Activer le widget [Assignments]';
$string['table_set_iag'] = 'Cours > Activités';
$string['table_set_iag1'] = 'Cours > Activités > Notes';
$string['table_set_iag1_c1'] = 'Nom de l’étudiant';
$string['table_set_iag1_c2'] = 'Adresse de courriel';
$string['table_set_iag1_c3'] = 'Statut';
$string['table_set_iag1_c4'] = 'Note';
$string['table_set_iag1_c5'] = 'Noté';
$string['table_set_iag1_c6'] = 'Visites';
$string['table_set_iag1_c7'] = 'Temps passé';
$string['table_set_iag_c1'] = 'Nom de l’activité';
$string['table_set_iag_c2'] = 'Type';
$string['table_set_iag_c3'] = 'Étudiants ayant achevés';
$string['table_set_iag_c4'] = 'Note moyenne';
$string['table_set_iag_c5'] = 'Visites';
$string['table_set_iag_c6'] = 'Temps passé';
$string['table_set_iag_c7'] = 'Actions';
$string['table_set_icg'] = 'Cours';
$string['table_set_icg_c1'] = 'Libellé du cours';
$string['table_set_icg_c11'] = 'Actions - Activités';
$string['table_set_icg_c12'] = 'Actions – Étudiants';
$string['table_set_icg_c2'] = 'Libellé court';
$string['table_set_icg_c3'] = 'Catégorie';
$string['table_set_icg_c4'] = 'Étudiants inscrits / ayant achevés';
$string['table_set_icg_c5'] = 'Note moyenne du cours ';
$string['table_set_icg_c6'] = 'Sections';
$string['table_set_icg_c7'] = 'Activités / Ressources';
$string['table_set_icg_c8'] = 'Visites';
$string['table_set_icg_c9'] = 'Temps passé';
$string['table_set_ilg'] = 'Cours > Étudiants';
$string['table_set_ilg1'] = 'Cours > Étudiants > Notes';
$string['table_set_ilg1_c1'] = 'Nom de l’activité';
$string['table_set_ilg1_c2'] = 'Type';
$string['table_set_ilg1_c3'] = 'Note';
$string['table_set_ilg1_c4'] = 'Noté';
$string['table_set_ilg1_c5'] = 'Statut';
$string['table_set_ilg1_c6'] = 'Visites';
$string['table_set_ilg1_c7'] = 'Temps passé';
$string['table_set_ilg_c1'] = 'Nom d’étudiant';
$string['table_set_ilg_c10'] = 'Action';
$string['table_set_ilg_c2'] = 'Adresse de courriel';
$string['table_set_ilg_c3'] = 'Inscrits';
$string['table_set_ilg_c4'] = 'Dernier accès';
$string['table_set_ilg_c5'] = 'Statut';
$string['table_set_ilg_c6'] = 'Note';
$string['table_set_ilg_c7'] = 'Activités / ressources complétées';
$string['table_set_ilg_c8'] = 'Visites';
$string['table_set_ilg_c9'] = 'Temps passé';
$string['te1'] = 'Courriel';
$string['te12'] = 'Prénom';
$string['te13'] = 'Nom de famille';
$string['te1_desc'] = 'Entrez le prénom, le nom, le courriel utilisé avec l’abonnement IntelliBoard.net. Si vous n’avez pas d’abonnement actif, inscrivez-vous sur <a target="_blank" href="https://intelliboard.net"> IntelliBoard.net </a>. Les tableaux de bord de l’apprenant et de l’instructeur ne sont pas actifs par défaut.';
$string['teacher'] = 'Enseignant';
$string['telephone1'] = 'Téléphone 1';
$string['telephone2'] = 'Téléphone 2';
$string['term_of_use'] = 'Conditions d’utilisation';
$string['terms_msg'] = 'En cochant cette case, vous confirmez avoir lu et accepté nos Conditions d’utilisation.';
$string['tex1'] = 'Tableau de bord Apprenant IntelliBoard n’est pas activé.';
$string['this_year'] = 'Cette année';
$string['time'] = 'Temps';
$string['time_1'] = 'Matin';
$string['time_2'] = 'Après midi';
$string['time_3'] = 'Soir';
$string['time_4'] = 'Hors heures';
$string['time_period_due'] = 'Période (date d’échéance)';
$string['time_spent'] = 'Temps passé';
$string['timespent'] = '------ Temps passé ----';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Paramètres avancés: TLS v1.2';
$string['topics'] = 'Sujets';
$string['total'] = 'Total';
$string['total_activities_resources'] = 'Total des activités / ressources';
$string['total_numbers'] = 'Date: {$ a-> timepoint}, Sessions: {$a->sessions}, Visites: {$a->visits}, Temps passé: {$a->timespend}';
$string['total_numbers2'] = 'UTILISATEUR: {$a->userid}, Page: {$a->page}, Param: {$a->param}, Visites: {$a->visits}, Temps passé: {$a->timespend}';
$string['total_numbers3'] = '---- Date: {$a->timecreated}, Track ID: {$a->trackid}, Visites: {$a->visits}, Temps passé: {$a->timespend}';
$string['total_time_spent'] = 'Temps total passé ';
$string['total_time_spent_enrolled_learners'] = 'Temps total passé par les apprenants inscrits sur le parcours';
$string['total_values_include'] = 'Les valeurs totales incluent des sessions uniques, des cours, des visites, le temps passé.';
$string['total_visits_enrolled_learners'] = 'Total des visites des apprenants inscrits sur le parcours';
$string['totara'] = 'Totara';
$string['trackadmin'] = 'Suivi des administrateurs';
$string['trackadmin_desc'] = 'Activer le suivi pour les utilisateurs admin (non recommandé)';
$string['trackdetails'] = 'Suivi du temps utilisateur - horaire';
$string['tracking'] = 'Suivi de session';
$string['tracking_title'] = 'Suivi du temps';
$string['tracklogs'] = 'Suivi du temps utilisateur - quotidien';
$string['trackmedia'] = 'Suivi des médias HTML5 ';
$string['trackmedia_desc'] = 'Suivi des vidéos HTML5';
$string['tracktotals'] = 'Track Time Aggregate - Quotidien';
$string['transcripts'] = 'Transcripts';
$string['transcriptssyncrecordsnum'] = 'Transcripts Processing Size';
$string['transcriptssyncrecordsnum_desc'] = 'Le nombre d’enregistrements d’inscriptions d’utilisateurs qui seront traités en une seule fois';
$string['ts1'] = 'Tableau de bord de l’apprenant';
$string['ts2'] = 'Page du tableau de bord de l’apprenant';
$string['ts3'] = 'Cours de tableau de bord pour apprenants';
$string['ts4'] = 'Niveaux de tableau de bord de l’apprenant';
$string['ts5'] = 'Rapports du tableau de bord des apprenants';
$string['type'] = 'Type';
$string['type_here'] = 'Entrez ici…';
$string['used'] = 'Utilisé';
$string['user_enrollments_sessions_completion'] = 'Inscription de l’utilisateur, sessions et achèvement des activités';
$string['user_enrolments'] = 'Inscriptions d’utilisateurs';
$string['user_grade_avg'] = '{$a->user} note : {$a->grade}, note moyenne : {$a->avg_grade_site})';
$string['user_map'] = 'Carte des utilisateurs ';
$string['user_site_summary_detail'] = 'Utilisation du site par l’utilisateur';
$string['user_time_avg'] = '{$a->user} temps : {$a->timespend}, Temps moyen : {$a->avg_timespend_site}';
$string['user_visit_avg'] = '{$a->user} Visites : {$a->visits}, Visites moyennes : {$a->avg_visits_site}';
$string['username'] = 'Nom d’utilisateur';
$string['users'] = 'Utilisateurs';
$string['users_activity'] = 'Activité des utilisateurs';
$string['users_overview'] = 'Aperçu des utilisateurs';
$string['verifyhost'] = 'CURLOPT SSL VERIFYHOST';
$string['verifyhost_desc'] = 'Cette option détermine si libcurl vérifie que le certificat de serveur est pour le serveur sous lequel il est connu.';
$string['verifypeer'] = 'CURLOPT SSL VERIFYPEER';
$string['verifypeer_desc'] = 'Cette option détermine si curl vérifie l’authenticité du certificat du pair.';
$string['view_course_details'] = 'Voir les détails du cours';
$string['viewed'] = 'Vu';
$string['visits'] = 'Visites';
$string['web_services_descr'] = 'IntelliBoard nécessite l’activation des services Web. Les services Web permettent à d’autres systèmes (par exemple, IntelliBoard) d’accéder à ce système LMS et aux opérations de préformage. Pour des raisons de sécurité, cette option doit être désactivée lorsqu’elle n’est pas utilisée. Pour un examen supplémentaire, accédez à Administration du site > Fonctionnalités avancées > Services Web';
$string['weekday_0'] = 'Lundi';
$string['weekday_1'] = 'Mardi';
$string['weekday_2'] = 'Mercredi';
$string['weekday_3'] = 'Jeudi';
$string['weekday_4'] = 'Vendredi';
$string['weekday_5'] = 'Samedi';
$string['weekday_6'] = 'Dimanche';
$string['weekly'] = '90 derniers jours';
$string['widget_name27'] = 'Les inscriptions cumulées';
$string['widget_name28'] = 'Engagement';
$string['widget_name29'] = 'Authentifications unique';
$string['widget_name30'] = 'Inscriptions par cours';
$string['widget_name31'] = 'Registraires et superviseur';
$string['x_completions'] = '{$a} achèvement';
$string['you_have_certificates'] = 'Vous avez {$a} certificats';
$string['you_need_to_enable_at_least_one_protocol'] = 'Vous devez activer au moins un protocole';
