<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_learnr', language 'fr', version '4.2'.
 *
 * @package     theme_learnr
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconcoloradministrationsetting'] = 'La couleur de l’icône d’activité pour « Administration »';
$string['activityiconcoloradministrationsetting_desc'] = 'La couleur de l’icône d’activité pour « Évaluation »';
$string['activityiconcolorassessmentsetting'] = 'La couleur de l’icône d’activité pour « Évaluation »';
$string['activityiconcolorassessmentsetting_desc'] = 'La couleur de l’icône d’activité pour « Évaluation »';
$string['activityiconcolorcollaborationsetting'] = 'Couleur de l’icône d’activité pour « Collaboration »';
$string['activityiconcolorcollaborationsetting_desc'] = 'La couleur de l’icône d’activité pour « Collaboration »';
$string['activityiconcolorcommunicationsetting'] = 'Couleur de l’icône d’activité pour « Communication »';
$string['activityiconcolorcommunicationsetting_desc'] = 'La couleur de l’icône d’activité pour « Communication »';
$string['activityiconcolorcontentsetting'] = 'Couleur de l’icône d’activité pour « Contenu »';
$string['activityiconcolorcontentsetting_desc'] = 'La couleur de l’icône d’activité pour «  Contenu »';
$string['activityiconcolorinterfacesetting'] = 'Couleur de l’icône d’activité pour « Interface »';
$string['activityiconcolorinterfacesetting_desc'] = 'La couleur de l’icône d’activité pour « Interface »';
$string['activityiconcolorsheading'] = 'Couleurs de l’icône d’activité';
$string['activitynavigation'] = 'Navigation d’activité';
$string['activitynavigationsetting'] = 'Éléments de navigation d’activité';
$string['activitynavigationsetting_desc'] = 'Avec ce paramètre, les éléments permettant de passer à l’activité / ressource précédente et suivante ainsi que le menu déroulant permettant de passer à une activité / ressource distincte s’affichent. Des éléments d’interface utilisateur comme celui-ci existaient déjà sur Boost dans le noyau de Moodle jusqu’à Moodle 3.11, mais ont été supprimés dans 4.0. Avec LearnR, vous pouvez les faire revenir.';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistante)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (révisée)';
$string['additionalresourcesheading'] = 'Ressources additionnelles';
$string['additionalresourceslistsetting'] = 'Liste de ressources additionnelles';
$string['additionalresourceslistsetting_desc'] = 'Liste des fichiers qui ont été téléchargés dans la zone de fichiers « Ressources additionnelles ». Vous pouvez utiliser les URL indiquées pour lier les fichiers dans le HTML supplémentaire depuis le CSS dédié ou dans la note de pied de page. Cela est utile partout où vous souhaitez utiliser des fichiers, mais que vous ne pouvez pas en télécharger.';
$string['additionalresourcessetting'] = 'Ressources additionnelles';
$string['additionalresourcessetting_desc'] = 'Avec ce paramètre, vous pouvez déposer des ressources supplémentaires sur le thème. L’avantage de déposer des fichiers dans cette zone de fichiers est que ces fichiers peuvent être livrés sans vérification si l’utilisateur est connecté. C’est aussi pourquoi vous ne devez ajouter que des fichiers non critiques, accessibles par tout le monde sans être protégés par un identifiant valide. Dès que vous avez déposé au moins un fichier dans cette zone de fichiers et que vous avez enregistré les paramètres, une liste qui vous donnera l’URL que vous pouvez utiliser pour référencer un fichier particulier apparaîtra en dessous.';
$string['backgroundimagesetting'] = 'Image d’arrière-plan';
$string['backgroundimagesetting_desc'] = 'On peut télécharger ici une image personnalisée à afficher en arrière-plan du site. L’image d’arrière-plan téléchargée remplacera l’image d’arrière-plan des fichiers de préréglage de thème.';
$string['backgroundimagesheading'] = 'Image d’arrière plan générale';
$string['backtotop'] = 'Retour au début';
$string['backtotopbuttonsetting'] = 'Bouton de retour au début';
$string['backtotopbuttonsetting_desc'] = 'Avec ce paramètre, un bouton de retour en haut apparaîtra dans le coin inférieur droit de la page dès que l’utilisateur fait défiler la page. Un bouton comme celui-ci existait déjà sur Boost dans Moodle Core jusqu’à Moodle 3.11, mais a été supprimé dans 4.0. Avec LearnR, vous pouvez le ramener.';
$string['bgdark'] = 'Couleur sombre de la barre de navigation';
$string['bgdark_desc'] = 'Change la valeur de la classe .bg-dark.';
$string['bgwhite'] = 'Couleur claire de la barre de navigation';
$string['bgwhite_desc'] = 'Change la valeur de la classe .bg-white.';
$string['blockregionoutsidebottomwidth'] = 'Largeur de la zone du bloc « Extérieur (en bas) »';
$string['blockregionoutsidebottomwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Extérieur (en bas) » qui s’affiche sous le contenu principal. On peut choisir entre la pleine largeur, la largeur du contenu du cours et la largeur du modèle.';
$string['blockregionoutsideleftwidth'] = 'Largeur de la zone du bloc « Extérieur (à gauche) »';
$string['blockregionoutsideleftwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Extérieur (à gauche) » qui s’affiche sur le côté gauche de la zone de contenu principale. Par défaut, LearnR utilise une largeur de 300px. On peut saisir d’autres valeurs basées sur les pixels comme 200px, mais également une valeur basée sur un pourcentage comme 10% ou une valeur de largeur de fenêtre comme 10vw.';
$string['blockregionoutsiderightwidth'] = 'Largeur de la zone du bloc « Extérieur (à droite) »';
$string['blockregionoutsiderightwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Extérieur (à droite) » qui s’affiche sur le côté droit de la zone de contenu principale. Par défaut, LearnR utilise une largeur de 300px. On peut saisir d’autres valeurs basées sur les pixels comme 200px, mais également saisir une valeur basée sur un pourcentage comme 10% ou une valeur de largeur de fenêtre comme 10vw.';
$string['blockregionoutsidetopwidth'] = 'Largeur de la zone du bloc « Extérieur (en haut) »';
$string['blockregionoutsidetopwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Extérieur (en haut) » qui s’affiche au-dessus du contenu principal. On peut choisir entre la pleine largeur, la largeur du contenu du cours et la largeur du modèle.';
$string['blockregionsforlayout'] = 'Régions de bloc supplémentaires pour la mise en page \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Ce paramètre permet de activer des régions de bloc supplémentaires pour la mise en page \'{$a}\'.';
$string['blockregionsheading'] = 'Régions de blocs supplémentaires';
$string['blockregionsheading_desc'] = '<p>LearnR fournit un grand nombre de régions de blocs supplémentaires qui peuvent être utilisées pour ajouter et afficher des blocs sur toute la page Moodle :</p>
<ul><li>Les <em>régions du bloc extérieur</em> sont placées sur les quatre côtés de la page Moodle. Ils peuvent être utilisés pour afficher des blocs qui accompagnent la page Moodle affichée mais n’appartiennent pas directement au contenu principal.</li>
<li>La <em>région du bloc d’en-tête</em> est placée entre la zone Extérieure (en haut) et la zone de contenu principale. Elle peut être utilisée pour afficher un bloc en tant qu’informations d’en-tête de cours.</li>
<li>Les <em>régions du bloc de contenu</em> sont placées directement au-dessus et en dessous du contenu principal dans la zone de contenu principale. Elles peuvent être utilisées pour ajouter des blocs au flux de contenu du cours.</li>
<li>Les <em>régions du bloc de pied de page</em> sont placées en bas de la page entre la zone Extérieure (en bas) et la note de bas de page. Trois zones de pied de page sont disponibles pour créer des colonnes si nécessaire.</li>
<li>La <em>région de bloc hors canevas</em> est en quelque sorte spéciale car elle survole toute la page Moodle en tant que tiroir. Le tiroir est ouvert par l’icône à 9 points tout à droite de la barre de navigation. Trois régions hors canevas sont disponibles pour créer des colonnes si nécessaire.</li></ul>
<p>À noter :</p>
<ul><li>Par défaut, toutes les régions de bloc supplémentaires sont désactivées. Les régions de bloc particulières sur les mises en page particulières peuvent être activées en fonction des besoins. Mieux vaut condenser autant que possible : un trop grand nombre de régions de blocs pourrait submerger les utilisateurs finaux.</li>
<li>Dès qu’une région de bloc supplémentaire est activée, elle est visible pour tous les utilisateurs authentifiés et modifiable par les enseignants et les gestionnaires (selon le fait que l’utilisateur particulier est autorisé à modifier la page Moodle particulière, bien sûr). Mais il existe également des fonctionnalités theme/learnr:viewregion* et theme/learnr:editregion* qui permettent d’affiner l’utilisation de chaque région de bloc en fonction de vos besoins.</li>
<li>Les régions des blocs Extérieure (gauche), Extérieure (droite), Contenu (supérieur), Contenu (inférieur) et En-tête ne sont pas disponibles pour toutes les mises en page.</li></ul>';
$string['blockregionsheading_experimental'] = 'Remarque : les régions de bloc <em>Extérieur (gauche) et Extérieur (droit)</em> fonctionnent pleinement dans l’état actuel de la mise en œuvre, mais doivent être <em>considérées comme expérimentales</em> car elles ne vont pas encore couvrir correctement les écrans de largeur moyenne. Dans ce contexte, elles sont à utiliser avec précaution. Ce problème sera résolu dans une prochaine version.';
$string['blocksgeneralheading'] = 'Blocs généraux';
$string['blockstab'] = 'Blocs';
$string['bodybg'] = 'Couleur de fond du corps';
$string['bodybg_desc'] = 'Modifie la couleur de l’arrière-plan du corps.';
$string['bootstrapcolordangersetting'] = 'Couleur Bootstrap pour « Danger »';
$string['bootstrapcolordangersetting_desc'] = 'La couleur Bootstrap pour « Danger »';
$string['bootstrapcolorinfosetting'] = 'Couleur Bootstrap pour « Info »';
$string['bootstrapcolorinfosetting_desc'] = 'La couleur Bootstrap pour « Info »';
$string['bootstrapcolorsheading'] = 'Couleurs Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Couleur Bootstrap pour « Succès »';
$string['bootstrapcolorsuccesssetting_desc'] = 'La couleur Bootstrap pour « Succès »';
$string['bootstrapcolorwarningsetting'] = 'Couleur Bootstrap pour « Attention »';
$string['bootstrapcolorwarningsetting_desc'] = 'La couleur Bootstrap pour « Attention »';
$string['bootstrapdangercolor'] = 'Couleur de danger';
$string['bootstrapdarkcolor'] = 'Couleur sombre';
$string['bootstrapinfocolor'] = 'Couleur d’info';
$string['bootstraplightcolor'] = 'Couleur claire';
$string['bootstrapnone'] = 'Pas de couleur Bootstrap';
$string['bootstrapprimarycolor'] = 'Couleur primaire';
$string['bootstrapsecondarycolor'] = 'Couleur secondaire';
$string['bootstrapsuccesscolor'] = 'Couleur de succès';
$string['bootstrapwarningcolor'] = 'Couleur d’attention';
$string['brandcolorsheading'] = 'Couleurs de la marque';
$string['brandingtab'] = 'Image de marque';
$string['cachedef_flavours'] = 'Types qui s’appliquent à un numéro d’identifiant de catégorie de page donné pour l’utilisateur actuel';
$string['cachedef_fontawesome'] = 'Fichiers FontAwesome (qui sont téléchargés dans les paramètres de LearnR)';
$string['choosereadme'] = '<p>Le thème LearnR est entièrement inspiré des thèmes LearnR et Fordson. LearnR reprend des fonctionnalités exceptionnelles, des améliorations UX et des fonctionnalités de LearnR. Pour améliorer les choses, nous avons intégré de nombreuses styles et fonctionnalités les plus populaires du thème Fordson.<p><p>LearnR est maintenu par<br />Moodle an Hochschulen e.V.,</p>< p>en coopération avec<br />lern.link GmbH</p><p>en collaboration avec<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Fermer le tiroir hors canevas';
$string['configtitle'] = 'LearnR';
$string['configtitlecontent'] = 'Contenu';
$string['configtitlefeel'] = 'Sensation';
$string['configtitleflavours'] = 'Types';
$string['configtitlefunctionality'] = 'Fonctionnalité';
$string['configtitlelook'] = 'Apparence';
$string['contactcontentsetting'] = 'Contenu de la page Contact';
$string['contactcontentsetting_desc'] = 'Ce réglage permet d’ajouter du contenu en texte enrichi qui sera affiché sur une page de contact (qui n’est pas la même que la page intégrée Moodle « Contacter l’assistance du site »).';
$string['contactdisabled'] = 'La page de contact est désactivée pour ce site. Il n’y a rien à voir ici.';
$string['contactheading'] = 'Contact';
$string['contactlinkpositionboth'] = 'Ajouter à la note de bas de page et à l’icône de pied de page (point d’interrogation) un lien vers la page de contact';
$string['contactlinkpositionfooter'] = 'Ajouter à l’icône du pied de page (point d’interrogation) un lien vers la page de contact';
$string['contactlinkpositionfootnote'] = 'Ajouter à la note de bas de page un lien vers la page de contact';
$string['contactlinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page de contact';
$string['contactlinkpositionsetting'] = 'Position du lien de la page de contact';
$string['contactlinkpositionsetting_desc'] = 'Ce réglage permet de configurer si un lien vers la page de contact doit être ajouté automatiquement à la page Moodle. Si vous ne souhaitez pas afficher un lien automatiquement, vous pouvez en ajouter manuellement vers {$a->url} depuis n’importe où dans Moodle.';
$string['contactpagetitledefault'] = 'Contact';
$string['contactpagetitlesetting'] = 'Titre de la page Contact';
$string['contactpagetitlesetting_desc'] = 'Ce réglage permet de définir le titre de la page de contact. Ce texte sera également utilisé comme texte de lien vers la page de contact si vous configurez la « Position du lien de la page de contact » en conséquence.';
$string['contentwidthheading'] = 'Largeur du contenu';
$string['courseactivitiesbtntext'] = 'Activités du cours';
$string['courseblockpanelbtn'] = 'Gestion du cours';
$string['courseblockpanelbtnclose'] = 'Fermer';
$string['courseboxheight'] = 'Hauteur des tuiles de cours';
$string['courseboxheight_desc'] = 'Détermine la hauteur de la tuile du cours sur la page d’accueil et les catégories de cours.';
$string['coursecontentmaxwidthsetting'] = 'Largeur maximale du contenu du cours';
$string['coursecontentmaxwidthsetting_desc'] = 'Ce paramètre permet de remplacer la largeur du contenu par défaut de Moodle sans modifications SCSS manuelles. Cette largeur est utilisée comme largeur de page des pages de cours et dans plusieurs activités. Par défaut, Moodle utilise une largeur maximale du contenu de cours de 830px. Il est possible de saisir d’autres valeurs basées sur les pixels comme 1200px, mais également de saisir une valeur basée sur un pourcentage comme 100% ou une valeur de largeur de fenêtre comme 90vw.';
$string['courseenrollmentcode'] = 'Code d’inscription au cours';
$string['courseheaderheading'] = 'En-tête du cours';
$string['courseheaderimageenabled'] = 'Afficher l’image du cours dans l’en-tête du cours';
$string['courseheaderimageenabled_desc'] = 'Lorsqu’elle est activée, l’image du cours (qui peut être déposée dans les paramètres de cours d’un cours) s’affiche dans l’en-tête d’un cours. Les images des cours y sont affichées en plus de la page « Mes cours » où elles sont toujours affichées.';
$string['courseheaderimagefallback'] = 'Image de remplacement de l’en-tête du cours';
$string['courseheaderimagefallback_desc'] = 'Une image déposée dans ce réglage sera utilisée comme image de remplacement et s’affiche dans l’en-tête du cours si aucune image de cours n’est déposée dans les paramètres de cours d’un cours particulier. Si vous ne déposez pas d’image ici, une image d’en-tête de cours n’est affichée dans un cours particulier que si une image de cours est déposée dans les paramètres de cours de ce cours particulier.';
$string['courseheaderimageheight'] = 'Hauteur de l’image d’en-tête du cours';
$string['courseheaderimageheight_desc'] = 'Ce réglage permet de contrôler la hauteur de l’image d’en-tête du cours présentée.';
$string['courseheaderimagelayout'] = 'Mise en page de l’image d’en-tête du cours';
$string['courseheaderimagelayout_desc'] = 'Ce paramètre permet de contrôler la mise en page de l’image d’en-tête du cours et du titre du cours.';
$string['courseheaderimagelayoutheadingabove'] = 'Titre du cours au-dessus de l’image du cours';
$string['courseheaderimagelayoutstackeddark'] = 'Titre du cours superposé sur l’image du cours (couleur de police blanche pour les images d’arrière-plan sombre)';
$string['courseheaderimagelayoutstackedlight'] = 'Titre du cours superposé sur l’image du cours (couleur de police noire pour les images d’arrière-plan clair)';
$string['courseheaderimageposition'] = 'Position de l’image d’en-tête du cours';
$string['courseheaderimageposition_desc'] = 'Ce paramètre permet de contrôler le positionnement de l’image d’en-tête de cours dans le conteneur d’images d’en-tête de cours. La première valeur est la position horizontale, la deuxième valeur est la position verticale.';
$string['coursemanagementbutton'] = 'Conseils liés au cours';
$string['coursemanagetitle'] = 'Cours';
$string['courserelatedhintsheading'] = 'Conseils liés au cours';
$string['coursestab'] = 'Cours';
$string['coursestyle1'] = 'Tuile style n°1';
$string['coursestyle2'] = 'Tuile style n°2';
$string['coursestyle3'] = 'Tuile style n°3';
$string['coursestyle4'] = 'Tuile avec résumé de cours';
$string['coursestyle5'] = 'Horizontal';
$string['coursestyle6'] = 'Horizontal avec image en arrière-plan et tous les détails';
$string['coursestyle7'] = 'Horizontal avec image en arrière-plan (Titre et Enseignant seulement)';
$string['coursestyle8'] = 'Affichage de cours par défaut de Moodle';
$string['coursetab'] = 'Cours';
$string['coursetilestyle'] = 'Style de la tuile d’affichage du cours';
$string['coursetilestyle_desc'] = 'Lors de l’affichage des catégories de cours, vous pouvez choisir parmi les styles suivants pour afficher les cours sur la page d’accueil et dans les zones de catégories de cours.';
$string['createinfo'] = 'Bouton de création de cours spécial';
$string['createinfodesc'] = 'Ce bouton apparaît sur la page d’accueil lorsqu’un utilisateur peut créer de nouveaux cours. Ceux qui ont le rôle de créateur de cours au niveau du site verront ce bouton.';
$string['cssh5pheading'] = 'CSS brut pour H5P';
$string['cssh5psetting'] = 'CSS brut pour H5P';
$string['cssh5psetting_desc'] = 'Utiliser ce champ pour fournir le code CSS qui sera appliqué à la présentation du contenu H5P par mod_h5p et mod_hvp. Inspecter les types de contenu H5P pour trouver les sélecteurs CSS nécessaires.';
$string['customfontsfileurlpersistent'] = 'URL (persistante)';
$string['customfontsfileurlrevisioned'] = 'URL (révisée)';
$string['customfontsheading'] = 'Polices personnalisées';
$string['customfontslistsetting'] = 'Liste des polices personnalisées';
$string['customfontslistsetting_desc'] = 'Il s’agit de la liste des polices que vous avez téléchargées dans la zone de fichiers des polices personnalisées. Les extraits CSS donnés peuvent être utilisés pour ajouter ces polices à votre SCSS personnalisé. Veuillez noter que vous devrez vous occuper vous-même de la valeur du format de police ainsi que des propriétés CSS font-family, font-style et font-weight pour le moment, car Boost Union n’est pas encore en mesure d’analyser les fichiers de police.';
$string['customfontssetting'] = 'Polices personnalisées';
$string['customfontssetting_desc'] = 'Avec ce paramètre, vous pouvez télécharger des polices personnalisées sur le thème. L’avantage de télécharger des polices dans cette zone de fichiers est que ces polices peuvent être livrées sans vérification si l’utilisateur est connecté et peuvent être utilisées comme polices installées localement partout sur le site. Dès que vous avez déposé au moins une police dans cette zone de fichiers et que vous avez enregistré les paramètres, une liste qui vous donnera des extraits de code CSS que vous pouvez utiliser comme passe-partout pour référencer des polices particulières dans votre SCSS personnalisé, apparaîtra en dessous.';
$string['drawerbg'] = 'Couleur de fond du tiroir';
$string['drawerbg_desc'] = 'Modifie la couleur de l’arrière-plan du tiroir.';
$string['easyenrollbtn'] = 'Codes d’inscription';
$string['emailbrandinghtmldemobody'] = '<p>Le corps du courriel commence ici.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Le corps du courriel se termine ici.</p>';
$string['emailbrandinghtmlheading'] = 'Aperçu du courriel HTML';
$string['emailbrandinghtmlintro'] = 'Il s’agit de l’aperçu d’un courriel HTML basé sur les préfixes et suffixes de marque actuellement définis dans le paquetage de langue.';
$string['emailbrandinghtmlnopreview'] = 'Jusqu’à présent, les courriels HTML n’ont pas été personnalisés dans cette fonctionnalité. Ils seront composés et envoyés normalement.';
$string['emailbrandinginstruction'] = 'Comment';
$string['emailbrandinginstruction0'] = 'Avec cette fonctionnalité de LearnR, vous pouvez appliquer une image de marque à tous les courriels envoyés par Moodle.';
$string['emailbrandinginstructionli1'] = 'Aller à la <a href="{$a->url}" target="_blank">page des paramètres de personnalisation de la langue</a> pour ouvrir le paquetage de langue <em>{$a->lang}</em> en mode édition.';
$string['emailbrandinginstructionli2'] = 'Rechercher et modifier ces chaînes dans le paquetage de <code>langue theme_learnr</code> :';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code> : cet extrait sera ajouté <em>au début / avant le corps</em> de tous les <em>courriels HTML</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailtextsuffix</code> : cet extrait sera ajouté <em>à la fin / après le corps</em> de tous les <em>courriels HTML</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailhtmlprefix</code> : cet extrait sera ajouté <em>au début / avant le corps</em> de tous les <em>courriels texte</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code> : cet extrait sera ajouté <em>à la fin / après le corps</em> de tous les <em>courriels texte</em> que Moodle envoie.';
$string['emailbrandinginstructionli3'] = 'Enregistrer les modifications apportées au paquetage de langue.';
$string['emailbrandinginstructionli4'] = 'Revenir sur cette page et visualiser les aperçus des courriels ci-dessous.';
$string['emailbrandingintroheading'] = 'Introduction';
$string['emailbrandingintronote'] = 'Remarque : il s’agit d’une fonctionnalité avancée qui utilise des solutions de contournement pour fournir des options de personnalisation des courriels. Veuillez suivre attentivement les instructions.';
$string['emailbrandingpitfalls'] = 'Pièges';
$string['emailbrandingpitfalls0'] = 'En utilisant cette fonctionnalité, vous devez être conscient de certains pièges :';
$string['emailbrandingpitfallsli1'] = 'Il est obligatoire de modifiier les chaînes du pack de langue de la <em>langue par défaut actuelle</em> de ce site. Même si plusieurs modules linguistiques sont installés, seules les modifications apportées à la langue par défaut seront impactées.';
$string['emailbrandingpitfallsli2'] = 'Le respect de la langue du destinataire n’est pas possible. Ainsi, il faut utiliser des termes indépendants de la langue dans vos extraits de marque de messagerie électronique.';
$string['emailbrandingpitfallsli3'] = 'Si la langue par défaut du site est modifier, il faudra migrer les chaînes du paquetage de langue modifié vers le nouveau paquetage de langue par défaut.';
$string['emailbrandingpitfallsli4'] = 'Dans les courriels en texte brut, il y a un saut de ligne et une ligne vide ajoutés automatiquement après le préfixe et une ligne vide ajoutée automatiquement avant l’extrait de suffixe. Cela permet de s’assurer que le suffixe et le préfixe ne collent pas directement au corps du courriel.';
$string['emailbrandingpitfallsli5'] = 'Dans les courriels en HTML, le préfixe et le suffixe sont directement ajoutés avant et au-dessus du corps du courriel. Cela permet de s’assurer de pouvoir travailler facilement avec les balises HTML, mais tout l’espace autour du corps devra être géré manuellement.';
$string['emailbrandingpitfallsli6'] = 'Dans les courriels en HTML, on peut ouvrir une balise HTML dans l’extrait de préfixe et fermer la balise dans l’extrait de suffixe sans problème. Ne pas oublier de créer un code HTML valide dans le courriel résultant.';
$string['emailbrandingtab'] = 'Étiquette de messagerie électronique';
$string['emailbrandingtextdemobody'] = 'Le corps de l’e-mail commence ici.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Le corps de l’e-mail se termine ici.';
$string['emailbrandingtextheading'] = 'Aperçu des courriels en texte brut';
$string['emailbrandingtextintro'] = 'Il s’agit d’un aperçu d’un courriel en clair basé sur les préfixes et suffixes de marque actuellement définis dans le paquetage de langue.';
$string['emailbrandingtextnopreview'] = 'Jusqu’à présent, les courriels texte n’ont pas été personnalisés dans cette fonctionnalité. Ils seront composés et envoyés normalement.';
$string['enablecontactsetting'] = 'Activer la page de contact';
$string['enablehelpsetting'] = 'Activer la page d’aide';
$string['enableimprintsetting'] = 'Activer l’impression';
$string['enablemaintenancesetting'] = 'Activer la page d’informations sur la maintenance';
$string['enrollcoursecard'] = 'Afficher le cours';
$string['error:infobannerdismissnonotdismissible'] = 'La bannière d’information donnée n’est pas dissimulable';
$string['error:infobannerdismissnonotvalid'] = 'Le numéro de bannière d’information donné n’est pas valide';
$string['exporttomistar'] = 'Exporter vers MIStar';
$string['faviconheading'] = 'Icône de favori';
$string['faviconheading_desc'] = 'Remarque : LearnR a son propre téléchargement de favicon et n’utilise pas le favicon du <a href="{$a}">paramètre de favicon du noyau Moodle</a>.<br />LearnR permet en particulier de remplacer le téléchargement de favicon par des variantes.';
$string['faviconsetting'] = 'Icône de favori';
$string['faviconsetting_desc'] = 'Remarque : LearnR a son propre téléchargement de favicon et n’utilise pas le favicon du <a href="{$a}">paramètre de favicon du noyau Moodle</a>.<br />LearnR permet en particulier de remplacer le téléchargement de favicon par des variantes.';
$string['flavoursappliesto'] = 'Appliquer à';
$string['flavoursapplytocategories'] = 'Appliquer aux catégories de cours';
$string['flavoursapplytocategories_help'] = 'Ici, on définit si cette variante doit être appliquée aux catégories de cours.';
$string['flavoursapplytocategories_ids'] = 'Catégories de cours';
$string['flavoursapplytocategories_ids_help'] = 'Ici, on définit une ou plusieurs catégories de cours particulières auxquelles cette variante doit être appliquée. Dès que la page Moodle fournie se trouve dans l’une des catégories de cours configurées, la variante est appliquée.';
$string['flavoursapplytocohorts'] = 'Appliquer aux cohortes';
$string['flavoursapplytocohorts_help'] = 'On définit ici si ce type doit être appliqué aux cohortes.';
$string['flavoursapplytocohorts_ids'] = 'Cohortes';
$string['flavoursapplytocohorts_ids_help'] = 'Ici, on définit une ou plusieurs cohortes particulières auxquelles cette variante doit être appliquée. Dès que l’utilisateur est membre d’une des cohortes configurées, la variante est appliquée.<br /><br />À noter que, si on définit plus d’une cohorte, il n’est pas nécessaire que l’utilisateur soit un membre de toutes en même temps.<br /><br />À noter également qu’en l’état actuel de la mise en œuvre, les cohortes de catégories sont traitées comme s’il s’agissait de cohortes du système.';
$string['flavoursbackgroundimage'] = 'Image d’arrière plan';
$string['flavoursbackgroundimage_help'] = 'Avec ce paramètre, la variante remplacera l’image d’arrière-plan qui est configurée dans les paramètres d’apparence de LearnR.';
$string['flavoursbacktooverview'] = 'Retour à l’aperçu des variantes';
$string['flavourscreateflavour'] = 'Créer la variante';
$string['flavourscustomcss'] = 'CSS personnalisé';
$string['flavourscustomcss_help'] = 'Ce paramètre permet d’écrire du CSS personnalisé pour la variante. Il sera ajouté à la pile de code CSS qui est envoyée au navigateur dès que la variante s’applique. À noter que dans l’état actuel de la mise en œuvre, ce paramètre n’autorise que l’utilisation de CSS personnalisés, pas de SCSS.';
$string['flavoursdelete'] = 'Supprimer';
$string['flavoursdeleteconfirmation'] = 'Voulez-vous vraiment supprimer la variante <em>{$a}</em> ?';
$string['flavoursdeleteflavour'] = 'Supprimer la variante';
$string['flavoursdescription'] = 'Description';
$string['flavoursdescription_help'] = 'La description de la variante est juste utilisée en interne pour permettre d’identifier une variante particulière dans la liste des variantes.';
$string['flavoursedit'] = 'Modifier';
$string['flavourseditflavour'] = 'Modifier la variante';
$string['flavoursfavicon'] = 'Icône de favori';
$string['flavoursfavicon_help'] = 'Avec ce paramètre, la variante remplacera l’icône de favori qui est configuré dans les paramètres d’apparence de LearnR.';
$string['flavoursflavours'] = 'variantes';
$string['flavoursgeneralsettings'] = 'Réglages généraux';
$string['flavoursincludesubcategories'] = 'Inclure les sous-catégories';
$string['flavoursincludesubcategories_help'] = 'Si cochée, la variante sera également appliquée aux sous-catégories des catégories choisies.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Avec ce paramètre, la variante remplacera le logo qui est configuré dans les paramètres d’apparence de LearnR.';
$string['flavourslogocompact'] = 'Logo compact';
$string['flavourslogocompact_help'] = 'Avec ce paramètre, la variante remplacera le logo qui est configuré dans les paramètres d’apparence de LearnR.';
$string['flavoursnothingtodisplay'] = 'Il n’y a pas encore de variantes créées. Veuillez créer votre première variante pour faire avancer les choses.';
$string['flavoursnotificationcreated'] = 'La variante a été créée avec succès';
$string['flavoursnotificationdeleted'] = 'La variante a été supprimée avec succès';
$string['flavoursnotificationedited'] = 'La variante a été modifiée avec succès';
$string['flavoursoverview_desc'] = '<p>Les variantes de LearnR offrent la possibilité de remplacer certains paramètres d’apparence et de convivialité de Moodle dans des contextes particuliers. Sur cette page, on peut créer et gérer des variantes.</p><p>Dans chaque variante, on définit si elle doit être appliquée à des catégories de cours particulières ou à des cohortes particulières. Ensuite, lors de chaque rendu de page Moodle, LearnR vérifie si une variante s’applique. À noter que, pour chaque rendu de page Moodle, seule la première version correspondante de la liste est appliquée et les versions restantes sont ignorées. Ainsi, l’ordre des variantes sur cette page est essentiel.</p><p>À noter également qu’après chaque modification apportée à l’ensemble des variantes, le cache du thème est purgé. Cela est nécessaire pour s’assurer que tous les éléments sont correctement envoyés et mis à jour dans le navigateur.</p>';
$string['flavourspreview'] = 'Aperçu';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Aperçu de la variante';
$string['flavourstitle'] = 'Titre';
$string['flavourstitle_help'] = 'Le titre de la variante est simplement utilisé en interne pour permettre de documenter une variante particulière dans la liste des variantes.';
$string['fontawesomecheck-fa6free-fallback-description'] = 'Les nouvelles versions de FontAwesome utilisent pour remapper les anciens identifiants d’icônes vers les plus récents ou même se débarrasser de certaines icônes. Siune icône de carte solide est visible sur le côté gauche, la version de FontAwesome 6 affiche correctement les icônes remappées de FontAwesome 4.';
$string['fontawesomecheck-fa6free-fallback-title'] = 'FontAwesome 4 de secours';
$string['fontawesomecheck-fa6free-filter-description'] = 'Comme le plugin de filtre FontAwesome est installé, il faut s’assurer que le filtre gère également correctement les nouvelles icônes FontAwesome 6. Si une icône d’utilisateurs apparaît sur le côté gauche, c’est que le filtre fonctionne correctement avec les icônes de la version FontAwesome 6.';
$string['fontawesomecheck-fa6free-filter-title'] = 'Filtre FontAwesome';
$string['fontawesomecheck-fa6free-general-description'] = 'Si une icône de coche apparaît sur le côté gauche, FontAwesome fonctionne généralement sur votre site.';
$string['fontawesomecheck-fa6free-general-title'] = 'Fonctionnalité générale';
$string['fontawesomecheck-fa6free-newstuff-description'] = 'Les nouvelles versions de FontAwesome sont livrées avec des icônes supplémentaires par rapport au jeu d’icônes FontAwesome 4. Si une icône de virus apparaît sur le côté gauche, votre version de FontAwesome 6 affiche correctement les nouvelles icônes qui sont nouvelles dans FontAwesome 6.';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'Icônes FontAwesome 6';
$string['fontawesomecheckssetting'] = 'Contrôles FontAwesome';
$string['fontawesomecheckssetting_desc'] = 'Ici, il est possible de vérifier visuellement si les fichiers FontAwesome ont été téléchargés et ajoutés correctement à la page Moodle. Si l’une des vérifications échoue, veuillez revérifier si vous avez correctement téléchargé tous les fichiers obligatoires.';
$string['fontawesomefilessetting'] = 'Fichiers FontAwesome';
$string['fontawesomefilessetting_desc'] = 'Ce paramètre permet de télécharger des fichiers FontAwesome plus récents sur Moodle. Vous devez télécharger vous-même les fichiers FontAwesome sur Moodle en raison de contraintes de licence. Rendez-vous simplement sur <a href="https://fontawesome.com">fontawesome.com</a>, téléchargez le package FontAwesome et téléchargez les fichiers ici.';
$string['fontawesomefilesstructurenote'] = 'Veuillez noter que les fichiers doivent être téléchargés avec la structure de dossiers correcte et avec les noms de fichiers corrects. Veuillez commencer par créer un dossier <em>css</em> et un dossier <em>webfonts</em> dans le sélecteur de fichiers, téléchargez le fichier <em>fa-solid-900.woff2</em> dans le <em> dossier webfonts</em> et enregistrez la page des paramètres. Dès que vous avez fait cela, une liste de fichiers apparaîtra ci-dessous qui vous aidera à identifier et à télécharger les bons fichiers dans ces dossiers.';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Il s’agit d’un fichier CSS supplémentaire qui ajoute la police des icônes de la marque FontAwesome à la page Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Il s’agit du fichier CSS principal qui ajoute tous les glyphes FontAwesome disponibles à la page Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Il s’agit d’un fichier CSS supplémentaire qui ajoute la police des icônes régulières FontAwesome à la page Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Il s’agit d’un fichier CSS supplémentaire qui ajoute la police des icônes solides FontAwesome à la page Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Il s’agit du fichier CSS qui garantit que les icônes FontAwesome 4 dans Moodle s’affichent toujours correctement.';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.ttf'] = 'Il s’agit du fichier de police des icônes de la marque FontAwesome (au format TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.woff2'] = 'Il s’agit du fichier de police pour les icônes de la marque FontAwesome (au format WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.ttf'] = 'Il s’agit du fichier de police pour les icônes régulières FontAwesome (au format TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.woff2'] = 'Il s’agit du fichier de police pour les icônes régulières FontAwesome (au format WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.ttf'] = 'Il s’agit du fichier de police pour les icônes solides FontAwesome (au format TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.woff2'] = 'Il s’agit du fichier de police pour les icônes solides FontAwesome (au format WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.ttf'] = 'Il s’agit du fichier de police pour la compatibilité FontAwesome v4 (au format TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.woff2'] = 'Il s’agit du fichier de police pour la compatibilité FontAwesome v4 (au format WOFF2).';
$string['fontawesomelistmandatorymissing'] = 'C’est un fichier obligatoire pour que FontAwesome fonctionne, mais il n’a pas été téléchargé correctement. Veuillez essayer de le télécharger correctement.';
$string['fontawesomelistmandatoryuploaded'] = 'C’est un fichier obligatoire pour que FontAwesome fonctionne et il a été téléchargé correctement.';
$string['fontawesomelistnote'] = 'Veuillez noter que, si vous ne téléchargez qu’une fraction des fichiers obligatoires, les icônes FontAwesome peuvent apparaître comme brisées sur la page Moodle. Cela ne peut pas être résolu tant que tous les fichiers obligatoires n’auront pas été téléchargés ou supprimés à nouveau.';
$string['fontawesomelistoptionalmissing'] = 'Il s’agit d’un fichier facultatif pour améliorer le jeu d’icônes FontAwesome, mais il n’a pas été téléchargé. Cela fonctionne tant que vous n’en avez pas besoin.';
$string['fontawesomelistoptionaluploaded'] = 'Il s’agit d’un fichier facultatif pour améliorer le jeu d’icônes FontAwesome et il a été téléchargé correctement.';
$string['fontawesomelistsetting'] = 'Liste des fichiers FontAwesome';
$string['fontawesomelistsetting_desc'] = 'Voici la liste des fichiers FontAwesome téléchargés dans la zone de fichiers FontAwesome ci-dessus. Tous les fichiers FontAwesome valides pour la version configurée de FontAwesome sont répertoriés ici, les autres fichiers que vous avez peut-être également téléchargés mais qui ne sont pas valides ou nécessaires sont ignorés. Les fichiers FontAwesome sont automatiquement ajoutés aux pages Moodle et ont un effet direct dès que vous enregistrez ce paramètre.';
$string['fontawesomeversionfa6free'] = 'Utiliser la version gratuite de FontAwesome 6';
$string['fontawesomeversionnone'] = 'Garder FontAwesome 4 (tel que livré avec le noyau Moodle)';
$string['fontawesomeversionsetting'] = 'Version de FontAwesome';
$string['fontawesomeversionsetting_desc'] = 'Le noyau de Moodle est livré avec les icônes FontAwesome 4 qui conviennent, mais FontAwesome a évolué depuis lors. Ce paramètre permet d’utiliser des icônes FontAwesome plus récentes. Dès qu’une autre version que FontAwesome 4 est choisie, des paramètres supplémentaires apparaîtront où on pourra télécharger des versions plus récentes de FontAwesome.';
$string['footertab'] = 'Pied de page';
$string['footnoteheading'] = 'Note de pied de page';
$string['footnotesetting'] = 'Note de pied de page';
$string['footnotesetting_desc'] = 'Tout ce que vous ajoutez à cette zone de texte sera affiché à la fin d’une page, dans le pied de page (pas le pied de page flottant) sur chaque page qui utilise les mises en page « tiroirs », « columns2 » ou « login ». Le contenu de cette zone peut être, par exemple, le copyright, les conditions d’utilisation ou le nom de votre organisation. <br/> Si vous souhaitez supprimer à nouveau la note de bas de page, videz simplement la zone de texte.';
$string['gradebooktitle'] = 'Carnet de notes';
$string['h5pcontentmaxwidthsetting'] = 'Largeur maximale de la banque de contenu H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'Ce paramètre permet de remplacer la largeur de la banque de contenu H5P de Moodle sans modifications SCSS manuelles. Cette largeur est utilisée pour l’éditeur H5P dans la banque de contenu. Elle n’est <em>pas</em> utilisée pour la largeur de l’activité H5P. Par défaut, Moodle utilise une largeur maximale de banque de contenu H5P de 960px. Vous pouvez entrer d’autres valeurs basées sur les pixels comme 1200px, mais vous pouvez également entrer une valeur basée sur un pourcentage comme 100% ou une valeur de largeur de fenêtre comme 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Contenu de la page d’aide';
$string['helpcontentsetting_desc'] = 'Dans ce paramètre, on peut ajouter du contenu en texte enrichi qui sera affiché sur une page d’aide.';
$string['helpdisabled'] = 'La page d’aide est désactivée pour ce site. Il n’y a rien à voir ici.';
$string['helpheading'] = 'Aide';
$string['helplinkpositionboth'] = 'Ajouter un lien vers la page d’aide à la note de bas de page et à l’icône de pied de page (point d’interrogation)';
$string['helplinkpositionfooter'] = 'Ajouter un lien vers la page d’aide à l’icône du pied de page (point d’interrogation)';
$string['helplinkpositionfootnote'] = 'Ajouter un lien vers la page d’aide à la note de bas de page';
$string['helplinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page d’aide';
$string['helplinkpositionsetting'] = 'Position du lien de la page d’aide';
$string['helplinkpositionsetting_desc'] = 'Dans ce paramètre, il est possible de configurer si un lien vers la page d’aide doit être ajouté automatiquement à la page Moodle. Si vous ne souhaitez pas afficher un lien automatiquement, il est possible d’ajouter manuellement un lien vers {$a->url} depuis n’importe où dans Moodle.';
$string['helppagetitledefault'] = 'Aide';
$string['helppagetitlesetting'] = 'Titre de la page d’aide';
$string['helppagetitlesetting_desc'] = 'Dans ce paramètre, il est possible de définir le titre de la page d’aide. Ce texte sera également utilisé comme texte de lien vers la page d’aide si on configure la « Position du lien de la page d’aide » en conséquence.';
$string['hideloginform'] = 'Masquer le formulaire de connexion';
$string['hideloginform_desc'] = '<b>ATTENTION ! Si vous cochez cette option, le formulaire de connexion sera supprimé.</b> Ne cachez le formulaire de connexion que si vous utilisez une autre méthode de connexion telle que la connexion avec Google que vous n’avez jamais besoin d’utiliser le formulaire de connexion. Pour faire marche arrière, vous devez supprimer le fichier /moodle/theme/learnr/templates/core/loginform.mustache. Sa suppression entraînera la réapparition du formulaire de connexion, au cas où vous seriez totalement bloqué.';
$string['hidenodesprimarynavigationsetting'] = 'Masquer les nœuds dans la navigation principale';
$string['hidenodesprimarynavigationsetting_desc'] = 'Ce paramètre permet de masquer un ou plusieurs nœuds de la navigation principale.';
$string['iconnavbartab'] = 'Icônes de navigation';
$string['iconnavheading'] = 'Icônes de navigation';
$string['iconnavinfo'] = 'Icône de navigation du tableau de bord';
$string['iconnavinfo_desc'] = 'Crée des boutons avec des icônes à utiliser sur la page d’accueil. Ceux-ci apparaissent en haut de la page sur le tableau de bord.';
$string['imprintcontentsetting'] = 'Contenu de l’impression';
$string['imprintcontentsetting_desc'] = 'Dans ce paramètre, vous pouvez ajouter du contenu en texte enrichi qui sera affiché sur la page d’impression.';
$string['imprintdisabled'] = 'L’impression est désactivée pour ce site. Il n’y a rien à voir ici.';
$string['imprintheading'] = 'Impression';
$string['imprintlinkpositionboth'] = 'Ajouter un lien vers la page d’impression à la note de bas de page et à l’icône de pied de page (point d’interrogation)';
$string['imprintlinkpositionfooter'] = 'Ajouter un lien vers la page d’impression à l’icône du pied de page (point d’interrogation)';
$string['imprintlinkpositionfootnote'] = 'Ajouter un lien vers la page d’impression à la note de bas de page';
$string['imprintlinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page d’impression';
$string['imprintlinkpositionsetting'] = 'Position du lien d’impression';
$string['imprintlinkpositionsetting_desc'] = 'Dans ce paramètre, vous pouvez configurer si un lien vers la page d’impression doit être ajouté automatiquement à la page Moodle. Si vous ne souhaitez pas afficher un lien automatiquement, vous pouvez ajouter manuellement un lien vers {$a->url} depuis n’importe où dans Moodle.';
$string['imprintpagetitledefault'] = 'Impression';
$string['imprintpagetitlesetting'] = 'Titre de la page d’impression';
$string['imprintpagetitlesetting_desc'] = 'Dans ce paramètre, vous pouvez définir le titre de la page d’impression. Ce texte sera également utilisé comme texte de lien vers la page d’impression si vous configurez « Position du lien d’impression » en conséquence.';
$string['infobannerbsclasssetting'] = 'Classe Boostrap de la bannière d’information n° {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'Avec ce paramètre, vous pouvez sélectionner le style Bootstrap avec lequel la bannière d’informations n° {$a->no} doit être affiché. Si vous choisissez l’option « Aucune couleur Bootstrap », la bannière d’informations sera affichée sans aucune couleur Bootstrap particulière, ce qui vous donne la liberté de styliser la bannière vous-même dans l’éditeur de texte enrichi.';
$string['infobannerclose'] = 'Fermer';
$string['infobannercontentsetting'] = 'Contenu de la bannière d’information n° {$a->no}';
$string['infobannercontentsetting_desc'] = 'Ici, vous saisissez les informations qui doivent être affichées dans la bannière d’information n° {$a->no}.';
$string['infobannerdismissconfirm'] = 'Voulez-vous vraiment réinitialiser la visibilité de la bannière d’information n° {$a->no} et souhaitez-vous la réafficher pour tous les utilisateurs qui l’ont ignorée ?';
$string['infobannerdismissfail'] = 'La réinitialisation de la visibilité du bandeau d’information n° {$a->no} a échoué pour au moins un utilisateur';
$string['infobannerdismissiblesetting'] = 'Révocabilité de la bannière d’information n° {$a->no}';
$string['infobannerdismissiblesetting_desc'] = 'Avec ce paramètre, la bannière d’informations n° {$a->no} pourra être ignorée. Si l’utilisateur clique sur le bouton x dans la bannière d’informations, la bannière sera masquée de façon permanente pour cet utilisateur. La visibilité n’est en aucun cas réinitialisée automatiquement, même si vous modifiez le contenu de la bannière d’information. Si vous souhaitez réinitialiser la visibilité de la bannière d’informations, cliquez sur le bouton « Réinitialiser la visibilité » ci-dessous.';
$string['infobannerdismissreset'] = 'Réinitialiser la visibilité de la bannière d’informations ignorée';
$string['infobannerdismissresetbutton'] = 'Réinitialiser la visibilité de la bannière d’information n° {$a->no}';
$string['infobannerdismisssuccess'] = 'La visibilité de la bannière d’information n° {$a->no} a été réinitialisée';
$string['infobannerenabledsetting'] = 'Activer la bannière d’information n° {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Avec ce paramètre, vous pouvez activer la bannière d’information n° {$a->no}.';
$string['infobannerendsetting'] = 'Date de fin de la bannière d’information n° {$a->no}';
$string['infobannerendsetting_desc'] = 'Avec ce paramètre, vous pouvez définir jusqu’à quand la bannière d’information n° {$a->no} doit être affichée. La date configurée est interprétée comme l’heure du serveur et non comme l’heure de l’utilisateur.';
$string['infobannerheading'] = 'Bannière d’information n° {$a->no}';
$string['infobannermodeperpetual'] = 'Perpétuelle';
$string['infobannermodesetting'] = 'Mode d’affichage de la bannière d’information n° {$a->no}';
$string['infobannermodesetting_desc'] = 'Avec ce paramètre, vous pouvez définir si la bannière d’information n° {$a->no} doit être une bannière perpétuelle (qui est toujours affichée) ou une bannière à durée contrôlée (qui n’est affichée que dans l’intervalle de temps configuré)';
$string['infobannermodetimebased'] = 'Durée contrôlée';
$string['infobannerordersetting'] = 'Position de la bannière d’information no. {$a->no}';
$string['infobannerordersetting_desc'] = 'Avec ce paramètre, vous définissez la position d’ordre de la bannière d’information n° {$a->no}. Par défaut, les bannières d’informations sont classées de haut en bas comme vous les voyez sur cette page de paramètres ici. Cependant, vous pouvez décider d’attribuer une autre position avec ce paramètre. Si vous attribuez la même position à deux bannières d’information ou plus, elles seront à nouveau classées selon l’ordre indiqué sur cette page de paramètres.';
$string['infobannerpageloginpage'] = 'Page de connexion';
$string['infobannerpagessetting'] = 'Pages sur lesquelles afficher la bannière d’informations n° {$a->no}';
$string['infobannerpagessetting_desc'] = 'Avec ce paramètre, vous pouvez sélectionner les pages sur lesquelles la bannière d’information n° {$a->no} doit être affichée.';
$string['infobannerstartsetting'] = 'Date de début de la bannière d’information n° {$a->no}';
$string['infobannerstartsetting_desc'] = 'Avec ce paramètre, vous pouvez définir à partir de quand la bannière d’information n° {$a->no} doit être affichée. La date configurée est interprétée comme l’heure du serveur et non comme l’heure de l’utilisateur.';
$string['infobannertab'] = 'Bannière d’information';
$string['javascriptdisabledhint'] = 'Indice JavaScript désactivé';
$string['javascriptdisabledhint_desc'] = 'Avec ce paramètre, un indice apparaîtra en haut de la page Moodle si JavaScript n’est pas activé. Ceci est particulièrement utile car plusieurs fonctionnalités de Moodle ne fonctionnent pas sans JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript est désactivé dans votre navigateur.<br />De nombreuses fonctionnalités de Moodle ne seront pas utilisables ou sembleront brisées.<br />Veuillez activer JavaScript pour profiter pleinement de l’expérience Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['latestcourses'] = 'Cours récents';
$string['learnr:configure'] = 'Pour pouvoir configurer le thème en tant que non-administrateur';
$string['learnr:editregioncontentlower'] = 'Pour pouvoir modifier la région du bloc Contenu (inférieur)';
$string['learnr:editregioncontentupper'] = 'Pour pouvoir modifier la région du bloc Contenu (supérieur)';
$string['learnr:editregionfootercenter'] = 'Pour pouvoir modifier la région du pied de page (centrale)';
$string['learnr:editregionfooterleft'] = 'Pour pouvoir modifier la région du pied de page (gauche)';
$string['learnr:editregionfooterright'] = 'Pour pouvoir modifier la région du pied de page (droite)';
$string['learnr:editregionheader'] = 'Pour pouvoir modifier la région de l’en-tête';
$string['learnr:editregionoffcanvascenter'] = 'Pour pouvoir modifier la région de bloc hors-canevas (centre)';
$string['learnr:editregionoffcanvasleft'] = 'Pour pouvoir modifier la région de bloc hors-canevas (gauche)';
$string['learnr:editregionoffcanvasright'] = 'Pour pouvoir modifier la région de bloc hors-canevas (droite)';
$string['learnr:editregionoutsidebottom'] = 'Pour pouvoir modifier la région extérieure au bloc (en bas)';
$string['learnr:editregionoutsideleft'] = 'Pour pouvoir modifier la région extérieure au bloc (à gauche)';
$string['learnr:editregionoutsideright'] = 'Pour pouvoir modifier la région extérieure au bloc (à droite)';
$string['learnr:editregionoutsidetop'] = 'Pour pouvoir modifier la région extérieure au bloc (en haut)';
$string['learnr:viewhintcourseselfenrol'] = 'Pour pouvoir voir un indice d’auto-inscription illimitée à un cours visible.';
$string['learnr:viewhintinhiddencourse'] = 'Pouvoir voir un indice dans un cours caché.';
$string['learnr:viewregioncontentlower'] = 'Pour pouvoir voir la région du bloc Contenu (inférieur)';
$string['learnr:viewregioncontentupper'] = 'Pour pouvoir voir la région du bloc Contenu (supérieur)';
$string['learnr:viewregionfootercenter'] = 'Pour pouvoir voir la région du bloc Pied de page (centre)';
$string['learnr:viewregionfooterleft'] = 'Pour pouvoir voir la région du bloc Pied de page (gauche)';
$string['learnr:viewregionfooterright'] = 'Pour pouvoir voir la région du bloc Pied de page (droite)';
$string['learnr:viewregionheader'] = 'Pour pouvoir voir la région du bloc d’en-tête';
$string['learnr:viewregionoffcanvascenter'] = 'Pour pouvoir voir la région de bloc hors-canevas (centre)';
$string['learnr:viewregionoffcanvasleft'] = 'Pour pouvoir voir la région de bloc hors-canevas (gauche)';
$string['learnr:viewregionoffcanvasright'] = 'Pour pouvoir voir la région de bloc hors-canevas (droite)';
$string['learnr:viewregionoutsidebottom'] = 'Pour pouvoir voir la région extérieure au bloc (en bas)';
$string['learnr:viewregionoutsideleft'] = 'Pour pouvoir voir la région extérieure au bloc (à gauche)';
$string['learnr:viewregionoutsideright'] = 'Pour pouvoir voir la région extérieure au bloc (à droite)';
$string['learnr:viewregionoutsidetop'] = 'Pour pouvoir voir la région extérieure au bloc (en haut)';
$string['loginbackgroundimage'] = 'Images d’arrière-plan de la page de connexion';
$string['loginbackgroundimage_desc'] = 'Les images à afficher en arrière-plan de la page de connexion. L’une de ces images sera choisie au hasard et affichée lorsque l’utilisateur visitera la page de connexion. Assurez-vous de ne pas utiliser de caractères non ASCII dans les noms de fichiers si vous voulez afficher du texte pour les images d’arrière-plan.';
$string['loginbackgroundimagesheading'] = 'Images d’arrière-plan de la page de connexion';
$string['loginbackgroundimagetextsetting'] = 'Afficher le texte des images d’arrière-plan de connexion';
$string['loginbackgroundimagetextsetting_desc'] = 'Avec ce paramètre facultatif, vous pouvez ajouter du texte, par exemple un avis de droit d’auteur sur vos images d’arrière-plan téléchargées. Ce texte apparaîtra en haut du pied de page sur la page de connexion. Cependant, pour des raisons d’espace sur l’écran, il n’est affiché que sur des tailles d’écran plus grandes.<br/>
Chaque ligne se compose de l’identifiant du fichier (le nom du fichier), du texte qui doit être affiché et de la couleur du texte, séparés par un caractère tuyau. Chaque déclaration doit être écrite dans une nouvelle ligne. <br/>
Par exemple :<br/>
background-image-1.jpg|Copyright : CC0|dark<br/>
Comme couleur de texte, vous pouvez utiliser les valeurs « dark » ou « light ».<br />
Vous pouvez déclarer des textes pour une quantité arbitraire de vos images d’arrière-plan de connexion téléchargées. Les textes seront ajoutés uniquement aux images dont le nom de fichier correspond à l’identifiant déclaré dans ce paramètre.';
$string['loginformheading'] = 'Formulaire de connexion';
$string['loginformpositionsetting'] = 'Position du formulaire de connexion';
$string['loginformpositionsetting_center'] = 'Centrée';
$string['loginformpositionsetting_desc'] = 'Ce paramètre permet d’optimiser le formulaire de connexion pour l’adapter à une plus grande variété d’images d’arrière-plan. Par défaut, le formulaire de connexion s’affiche centré sur la page de connexion. Alternativement, on peut le déplacer vers la gauche ou vers la droite de la page de connexion pour laisser apparaître d’autres parties de l’image d’arrière-plan. Bien sûr, on peut également modifier ce paramètre si aucune image d’arrière-plan n’est téléchargée du tout.';
$string['loginformpositionsetting_left'] = 'Alignée à gauche';
$string['loginformpositionsetting_right'] = 'Alignée à droite';
$string['loginformtransparencysetting'] = 'Transparence du formulaire de connexion';
$string['loginformtransparencysetting_desc'] = 'Ce paramètre permet de rendre le formulaire de connexion légèrement transparent pour faire ressortir encore plus l’image d’arrière-plan.';
$string['loginpagetab'] = 'Page de connexion';
$string['logocompactsetting'] = 'Logo compact';
$string['logocompactsetting_desc'] = 'Ici, on peut télécharger une version compacte du même logo que ci-dessus, comme un emblème, un bouclier ou une icône. Cette image est notamment utilisée dans la barre de navigation en haut de chaque page Moodle. L’image doit être claire même à de petites tailles.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Ici, il est possible de télécharger un logo complet à utiliser comme décoration. Cette image est notamment utilisée sur la page de connexion. Cette image peut être assez haute résolution car elle sera réduite pour être utilisée.';
$string['logosheading'] = 'Logos';
$string['logosheading_desc'] = 'Remarque : LearnR a son propre téléchargement de logo et n’utilise pas le logo du <a href="{$a}">paramètre de logo du noyau Moodle</a>.<br />LearnR permet en particulier de télécharger plus de formats d’images que le noyau de Moodle autorise et permet de remplacer les logos téléchargés dans ses variantes.';
$string['maintenancecontentsetting'] = 'Contenu de la page d’informations sur la maintenance';
$string['maintenancecontentsetting_desc'] = 'Dans ce paramètre, on peut ajouter du contenu en texte enrichi qui sera affiché sur une page d’informations de maintenance (qui n’est pas la même que la page de mode de maintenance intégrée de Moodle).';
$string['maintenancedisabled'] = 'La page d’informations sur la maintenance est désactivée pour ce site. Il n’y a rien à voir ici.';
$string['maintenanceheading'] = 'Maintenance';
$string['maintenancelinkpositionboth'] = 'Ajouter un lien vers la page d’informations sur la maintenance à la note de bas de page et à l’icône de pied de page (point d’interrogation)';
$string['maintenancelinkpositionfooter'] = 'Ajouter un lien vers la page d’informations sur la maintenance à l’icône du pied de page (point d’interrogation)';
$string['maintenancelinkpositionfootnote'] = 'Ajouter un lien vers la page d’informations sur la maintenance dans la note de bas de page';
$string['maintenancelinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page d’informations sur la maintenance';
$string['maintenancelinkpositionsetting'] = 'Position du lien de la page d’informations sur la maintenance';
$string['maintenancelinkpositionsetting_desc'] = 'Dans ce paramètre, il est possible de configurer si un lien vers la page d’informations de maintenance doit être ajouté automatiquement à la page Moodle. Pour ne pas afficher un lien automatiquement, ajouter manuellement un lien vers {$a->url} depuis n’importe où dans Moodle.';
$string['maintenancepagetitledefault'] = 'Maintenance';
$string['maintenancepagetitlesetting'] = 'Titre de la page d’information de la maintenance';
$string['maintenancepagetitlesetting_desc'] = 'Dans ce paramètre, il est possible de définir le titre de la page d’informations de maintenance. Ce texte sera également utilisé comme texte de lien vers la page d’informations sur la maintenance si on configure la « Position du lien de la page d’informations sur la maintenance » en conséquence.';
$string['manageuserstitle'] = 'Utilisateurs';
$string['marketingurltarget'] = 'Cible du lien';
$string['marketingurltargetdesc'] = 'Choisir comment le lien doit être ouvert';
$string['marketingurltargetnew'] = 'Nouvelle page';
$string['marketingurltargetparent'] = 'Cadre parent';
$string['marketingurltargetself'] = 'Page actuelle';
$string['mediumcontentmaxwidthsetting'] = 'Largeur maximale du contenu moyen';
$string['mediumcontentmaxwidthsetting_desc'] = 'Ce paramètre permet de remplacer la largeur de contenu moyenne de Moodle sans modifications SCSS manuelles. Cette largeur de page est utilisée dans certaines activités comme l’activité de base de données. Par défaut, Moodle utilise une largeur maximale de contenu moyen de 1120px. Il est possible de saisir d’autres valeurs basées sur les pixels comme 1200px, mais vous pouvez également saisir une valeur basée sur un pourcentage comme 100% ou une valeur de largeur de fenêtre comme 90vw.';
$string['misctab'] = 'Divers';
$string['mobileappearanceheading'] = 'Apparence mobile';
$string['mobilecss'] = 'CSS supplémentaire pour l’application mobile';
$string['mobilecss_desc'] = 'Ce paramètre permet d’écrire un code CSS personnalisé pour personnaliser l’interface de l’application mobile. Le code CSS sera uniquement ajouté à la représentation de l’application mobile de cette instance Moodle et ne sera pas affiché dans la version du navigateur Web. En savoir plus sur cette fonctionnalité dans la <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">docs de développement Moodle</a>.';
$string['mobilecss_donotchange'] = 'Cette étape est nécessaire pour envoyer le code CSS à l’application mobile. Ne modifiez pas l’URL à moins que vous ne souhaitiez vraiment supprimer à nouveau le code CSS de l’application mobile.';
$string['mobilecss_overwrite'] = 'Dès qu’on ajoute un code CSS à ce paramètre et qu’on enregistre le paramètre, le paramètre principal <a href="{$a->url}"> de Moodle <em>mobilecssurl</em></a> sera automatiquement remplacé par une URL du thème Boost Union. Actuellement, ce paramètre est défini sur <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Dès qu’on ajoute un code CSS à ce paramètre et qu’on enregistre le paramètre, le paramètre principal <a href="{$a->url}"> de Moodle <em>mobilecssurl</em></a> sera automatiquement défini vers une URL du thème LearnR.';
$string['mobiletab'] = 'Application mobile';
$string['myprogresspercentage'] = '%';
$string['navbarcolorsetting'] = 'Couleur de la barre de navigation';
$string['navbarcolorsetting_dark'] = 'Barre de navigation sombre avec une couleur de police claire';
$string['navbarcolorsetting_desc'] = 'Ce paramètre permet de changer la couleur de la barre de navigation de la barre de navigation claire par défaut à une barre sombre ou colorée.';
$string['navbarcolorsetting_light'] = 'Barre de navigation claire avec une couleur de police sombre (inchangée telle que présentée par le noyau Moodle)';
$string['navbarcolorsetting_primarydark'] = 'Barre de navigation de couleur primaire avec une couleur de police claire';
$string['navbarcolorsetting_primarylight'] = 'Barre de navigation de couleur primaire avec une couleur de police sombre';
$string['navbarheading'] = 'Barre de navigation';
$string['navicon'] = 'Icône';
$string['navicon1'] = 'Première icône de la page d’accueil';
$string['navicon2'] = 'Deuxième icône de la page d’accueil';
$string['navicon3'] = 'Troisième icône de la page d’accueil';
$string['navicon4'] = 'Quatrième icône de la page d’accueil';
$string['navicon5'] = 'Cinquième icône de la page d’accueil';
$string['navicon6'] = 'Sixième icône de la page d’accueil';
$string['navicon7'] = 'Septième icône de la page d’accueil';
$string['navicon8'] = 'Huitième icône de la page d’accueil';
$string['naviconbuttoncreatetextdefault'] = 'Créer un cours';
$string['naviconbuttontext'] = 'Texte du lien';
$string['naviconbuttontextdesc'] = 'Texte à afficher sous l’icône.';
$string['naviconbuttonurl'] = 'URL du lien';
$string['naviconbuttonurldesc'] = 'URL vers laquelle le bouton pointera. Vous pouvez créer un lien vers n’importe où, y compris des sites Web externes, il vous suffit d’entrer l’URL appropriée. Si votre site Moodle se trouve dans un sous-répertoire, l’URL par défaut ne fonctionnera pas. Veuillez ajuster l’URL pour refléter le sous-répertoire. Exemple si « moodle » était votre dossier de sous-répertoire, l’URL devrait être changée en /moodle/my/';
$string['navicondesc'] = 'Nom de l’icône que vous souhaitez utiliser.  <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">Voir la liste ici</a>. Entrez simplement ce qui se trouve après « fa- », par ex. « star ».';
$string['naviconslidedesc'] = 'Texte d’icône suggéré : arrow-circle-down. Ou choisir <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">dans la liste ici</a>. Entrez simplement ce qui se trouve après « fa- », par ex. « star ».';
$string['navigationheading'] = 'Navigation';
$string['navigationtab'] = 'Navigation';
$string['nomycourses'] = 'Vous n’êtes inscrit dans aucun cours';
$string['openoffcanvas'] = 'Tiroir hors toile ouvert';
$string['outsideregionsheading'] = 'Régions extérieures';
$string['outsideregionsheading_desc'] = 'Les régions extérieures peuvent non seulement être activées avec les paramètres de mise en page ci-dessus, mais leur apparence peut également être personnalisée.';
$string['outsideregionsplacement'] = 'Placement horizontal des régions extérieures';
$string['outsideregionsplacement_desc'] = 'Ce paramètre permet de contrôler si, sur des écrans plus grands, les régions de bloc « Extérieur (gauche) » et « Extérieur (droite) » doivent être placées près de la zone de contenu principale ou plutôt près des bords de la fenêtre.';
$string['outsideregionsplacementnearwindowedges'] = 'Afficher les régions « Extérieur (gauche) » et « Extérieur (droite) » près des bords de la fenêtre';
$string['outsideregionsplacementnextmaincontent'] = 'Afficher les régions « Extérieur (gauche) » et « Extérieur (droite) » à côté de la zone de contenu principale';
$string['outsideregionswidthcoursecontentwidth'] = 'Largeur du contenu du cours';
$string['outsideregionswidthfullwidth'] = 'Pleine largeur';
$string['outsideregionswidthherowidth'] = 'Largeur de l’image de bandeau';
$string['pagenavbuttonsbg'] = 'Boutons tiroir, aide, retour en haut';
$string['pagenavbuttonsbg_desc'] = 'Change la couleur des boutons du tiroir latéral, du bouton d’aide et de bouton de retour en haut.';
$string['pagetab'] = 'Page';
$string['pagewidthheading'] = 'Largeur de la page';
$string['pluginname'] = 'LearnR';
$string['presetheading'] = 'Préréglages du thème';
$string['primarynavigationheading'] = 'Navigation principale';
$string['privacy:metadata'] = 'Le thème LearnR n’enregistre aucune donnée personnelle sur un utilisateur.';
$string['progresstitle'] = 'Progression';
$string['region-content-lower'] = 'Contenu (inférieur)';
$string['region-content-upper'] = 'Contenu (supérieur)';
$string['region-footer-center'] = 'Pied de page (centre)';
$string['region-footer-left'] = 'Pied de page (gauche)';
$string['region-footer-right'] = 'Pied de page (droite)';
$string['region-header'] = 'Entête';
$string['region-none'] = 'Aucun';
$string['region-offcanvas-center'] = 'Hors toile (au centre)';
$string['region-offcanvas-left'] = 'Hors toile (à gauche)';
$string['region-offcanvas-right'] = 'Hors toile (à droite)';
$string['region-outside-bottom'] = 'Extérieur (en bas)';
$string['region-outside-left'] = 'Extérieur (à gauche)';
$string['region-outside-right'] = 'Extérieur (à droite)';
$string['region-outside-top'] = 'Extérieur (en haut)';
$string['resourcescachecontrolnote'] = 'Veuillez noter que les fichiers sont envoyés au navigateur avec l’en-tête « Cache-Control » qui indique au navigateur de mettre le fichier en cache. Si vous êtes certain de ne pas modifier le fichier dans un proche avenir, vous pouvez utiliser l’URL persistante pour créer un lien vers le fichier. Cependant, si vous envisagez de modifier un fichier mais que vous conservez le même nom de temps en temps, vous devriez plutôt utiliser l’URL révisée et refaire le lien avec le fichier chaque fois que vous mettez à jour le fichier pour éviter que les navigateurs n’affichent en cache les versions obsolètes du fichier.';
$string['resourcestab'] = 'Ressources';
$string['scrollspy'] = 'Défilement-espion';
$string['scrollspysetting'] = 'Défilement-espion';
$string['scrollspysetting_desc'] = 'Avec ce paramètre, lors de l’activation et de la désactivation du mode d’édition, la position de défilement à l’endroit où se trouvait l’utilisateur lors de l’exécution de la bascule est conservée.';
$string['scssheading'] = 'SCSS brut';
$string['scsstab'] = 'SCSS';
$string['sections-bars'] = 'Style de barres de section solide';
$string['sections-boost'] = 'Valeurs par défaut de Boost';
$string['sections-boxed'] = 'Style en boîte';
$string['sections-learnr'] = 'Style par défaut de LearnR';
$string['sectionstyle'] = 'Sélecteur de style de section de cours';
$string['sectionstyle_desc'] = 'Choisir un style pour les sections de cours.';
$string['showadvertonpages'] = 'Sélecteur de page pour les tuiles publicitaires';
$string['showadvertonpages-course'] = 'Page d’accueil du cours';
$string['showadvertonpages-dash'] = 'Page du tableau de bord';
$string['showadvertonpages-home'] = 'Page d’accueil';
$string['showadvertonpages-mycourses'] = 'Page « Mes cours »';
$string['showadvertonpages_desc'] = 'Sélectionnez les pages sur lesquelles afficher les tuiles publicitaires.';
$string['showcourseactivities'] = 'Afficher le menu des activités du cours';
$string['showcourseactivities_desc'] = 'Afficher une icône de menu d’activités du cours dans l’entête.';
$string['showcourseindexnav'] = 'Afficher la navigation dans l’index du cours';
$string['showcourseindexnav_desc'] = 'Décocher cette case pour masquer les panneaux de navigation des tiroirs. Non recommandé mais pourrait être utile pour les installations de formation d’entreprise ou d’organisation de Moodle. Le retrait des tiroirs simplifie l’interface utilisateur et peut être souhaité pour une simple formation.';
$string['showcoursemanagement'] = 'Afficher la gestion du cours';
$string['showcoursemanagement_desc'] = 'La gestion des cours est un ensemble de liens les plus utilisés par les enseignants. Il s’agit d’un panneau coulissant qui s’ouvre depuis l’entête du cours.';
$string['showeasyenrolbtn'] = 'Afficher le bouton d’inscription facile';
$string['showeasyenrolbtn_desc'] = 'Afficher un lien d’accès rapide vers l’inscription facile dans l’en-tête. Cela permet aux enseignants d’accéder rapidement à leurs codes d’inscription lorsqu’ils sont dans un cours.';
$string['showhintcourseguestaccessgeneral'] = 'Vous consultez actuellement ce cours en tant que <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Pour avoir un accès complet au cours, vous pouvez <a href="{$a->url}">vous inscrire vous-même à ce cours</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l’en-tête du cours lorsqu’un utilisateur y accède avec la fonction d’accès invité. Si le cours propose une auto-inscription active, un lien vers cette page est également présenté à l’utilisateur.';
$string['showhintcoursehiddengeneral'] = 'Ce cours est actuellement <strong>masqué</strong>. Seuls les enseignants inscrits peuvent accéder à ce cours lorsqu’il est masqué.';
$string['showhintcoursehiddensetting'] = 'Afficher l’indice dans les cours masqués';
$string['showhintcoursehiddensetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l’en-tête du cours tant que la visibilité du cours est masquée. Cela permet d’identifier l’état de visibilité d’un parcours en un coup d’œil sans avoir à consulter les paramètres du parcours.';
$string['showhintcoursehiddensettingslink'] = 'Vous pouvez modifier la visibilité dans les <a href="{$a->url}">paramètres du cours</a>.';
$string['showhintcourseselfenrolfrom'] = 'L’instance d’inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée à partir du {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'L’instance d’inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée de {$a->from} à {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Si vous ne souhaitez pas qu’un utilisateur Moodle puisse s’inscrire librement à ce cours, veuillez restreindre les paramètres d’auto-inscription.';
$string['showhintcourseselfenrolsetting'] = 'Afficher un indice pour l’auto-inscription sans clé d’inscription';
$string['showhintcourseselfenrolsetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l’en-tête du cours si le cours est visible et qu’une inscription sans clé d’inscription est actuellement possible.';
$string['showhintcourseselfenrolsince'] = 'L’instance d’inscription <strong>{$a->name}</strong> autorise actuellement l’auto-inscription sans restriction.';
$string['showhintcourseselfenrolsinceuntil'] = 'L’instance d’inscription <strong>{$a->name}</strong> autorise l’auto-inscription illimitée jusqu’au {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Ce cours est actuellement visible et l\'<strong>auto-inscription sans clé d’inscription</strong> est actuellement possible.';
$string['showhintcourseselfenrolstartfuture'] = 'Ce cours est actuellement visible et l\'<strong>auto-inscription sans clé d’inscription</strong> devrait devenir possible.';
$string['showhintcourseselfenrolunlimited'] = 'L’instance d’inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée à l’infini.';
$string['showhintcourseselfenroluntil'] = 'L’instance d’inscription <strong>{$a->name}</strong> autorise l’auto-inscription illimitée jusqu’au {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Afficher l’indice pour l’accès invité';
$string['showlatestcourses'] = 'Afficher la liste déroulante des derniers cours';
$string['showlatestcourses_desc'] = 'Affiche les 7 derniers cours qu’un utilisateur a visité dans un menu déroulant à droite du titre du cours. Pour le moment, cela ne fait pas partie de la navigation principale, c’est plutôt un élément de navigation dans les pages de cours.';
$string['showprogressbar'] = 'Afficher la barre de progression du cours';
$string['showprogressbar_desc'] = 'Affiche une barre de progression pour les étudiants en haut de chaque page principale de cours.';
$string['showswitchedroleincoursesetting'] = 'Afficher l’indice de changement de rôle';
$string['showswitchedroleincoursesetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l’en-tête du cours si l’utilisateur a changé de rôle dans le cours. Par défaut, ces informations ne sont affichées qu’à côté de l’avatar de l’utilisateur dans le menu utilisateur. En activant cette option, vous pouvez également afficher ces informations - ainsi qu’un lien pour revenir en arrière - dans la page du cours.';
$string['sliderinfo'] = 'Bouton icône du tiroir d’informations spéciales';
$string['sliderinfodesc'] = 'Ce bouton affichera/cachera une zone de texte spéciale qui glisse vers le bas depuis la barre de navigation des icônes. C’est idéal pour présenter des cours, fournir de l’aide ou référencer la formation du personnel.';
$string['slidetextbox'] = 'Zone de texte du tiroir';
$string['slidetextbox_desc'] = 'Le contenu de cette zone de texte s’affichera lorsque vous appuierez sur le bouton tiroir.';
$string['staticpagestab'] = 'Pages statiques';
$string['switchedroleto'] = 'Vous consultez actuellement ce cours avec le rôle : <strong>{$a->role}</strong>';
$string['tilebackgroundimagepositionsetting'] = 'Emplacement de l’image d’arrière-plan de la tuile publicitaire {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Ce paramètre permet de contrôler le positionnement de l’image d’arrière-plan dans le conteneur {$a->no} de la tuile publicitaire. La première valeur est la position horizontale, la deuxième valeur est la position verticale.';
$string['tilebackgroundimagesetting'] = 'Tuile publicitaire {$a->no} image d’arrière-plan';
$string['tilebackgroundimagesetting_desc'] = 'Ici, il est possible de télécharger un fichier image qui sera affiché comme image d’arrière-plan derrière le contenu de la tuile publicitaire {$a->no}. Assurez-vous ou vérifiez que le contenu est toujours lisible sur l’image d’arrière-plan. Il s’agit d’un paramètre facultatif, la tuile publicitaire fonctionnera même si vous ne téléchargez aucune image d’arrière-plan.';
$string['tilecolumnssetting'] = 'Nombre de colonnes de tuiles publicitaires par ligne';
$string['tilecolumnssetting_desc'] = 'Ici, on définit le nombre de colonnes par ligne dans la grille de tuiles publicitaires présentée. Veuillez noter que ce nombre de colonnes s’applique aux ordinateurs de bureau/écrans plus grands. Sur les écrans plus petits et les écrans mobiles, les colonnes de tuiles publicitaires sont automatiquement enveloppées.';
$string['tilecontentsetting'] = 'Contenu de la tuile publicitaire {$a->no}';
$string['tilecontentsetting_desc'] = 'Saisir ici le contenu qui doit être affiché dans la tuile publicitaire {$a->no}. Le contenu est affiché au milieu de la tuile. Il s’agit d’un paramètre facultatif, la tuile publicitaire s’affichera même si vous ne définissez aucun contenu.';
$string['tileenabledsetting'] = 'Activer la tuile publicitaire {$a->no}';
$string['tileenabledsetting_desc'] = 'Ce paramètre permet d’activer la tuile publicitaire {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Position des tuiles publicitaires sur l’accueil du site';
$string['tilefrontpagepositionsetting_after'] = 'Après le contenu de l’accueil du site';
$string['tilefrontpagepositionsetting_before'] = 'Avant le contenu de l’accueil du site';
$string['tilefrontpagepositionsetting_desc'] = 'Les tuiles publicitaires sont affichées uniquement sur l’accueil du site. Ce paramètre permet de contrôler si les tuiles publicitaires sont affichées avant le contenu d’accueil du site ou après le contenu d’accueil du site. Pour afficher uniquement les tuiles publicitaires sur l’accueil du site et rien d’autre, tout autre contenu d’accueil du site peut être supprimé en modifiant les <a href="{$a->url}">paramètres d’accueil du site</a>.';
$string['tileheading'] = 'Tuile publicitaire {$a->no}';
$string['tileheightsetting'] = 'Hauteur des tuiles publicitaires';
$string['tileheightsetting_desc'] = 'Ce paramètre permet de contrôler la hauteur des tuiles publicitaires. La hauteur configurée est la hauteur minimale de chaque tuile. Si le contenu d’une tuile est supérieur à cette hauteur configurée, toute la rangée de tuiles sera automatiquement augmentée selon les besoins.';
$string['tilelinksetting'] = 'Lien URL de la tuile publicitaire {$a->no}';
$string['tilelinksetting_desc'] = 'Ici, il est possible de définir une URL (interne ou externe à Moodle) qui sera proposée comme bouton de lien à la fin de la tuile publicitaire {$a->no}. Il s’agit d’un paramètre facultatif, la tuile publicitaire fonctionnera même si aucune URL de lien n’est définie.';
$string['tilelinktargetsetting'] = 'Cible du lien vers la tuile publicitaire {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Ici, il est possible de définir la cible du lien qui est définie pour le bouton de lien dès que vous définissez une URL de lien dans la tuile publicitaire {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Nouvel onglet';
$string['tilelinktargetsetting_samewindow'] = 'Même fenêtre';
$string['tilelinktitlefallback'] = 'Lien';
$string['tilelinktitlesetting'] = 'Titre du lien de la tuile publicitaire {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Ici, un titre de lien qui sera utilisé comme étiquette du bouton de lien peut être défini dès qu’on définit une URL de lien dans la tuile publicitaire {$a->no}. Veuillez noter que si on définit une URL de lien mais qu’on ne définit pas de titre de lien, le bouton de lien sera simplement étiqueté avec « Lien ».';
$string['tileordersetting'] = 'Position de l’ordre de la tuile publicitaire {$a->no}';
$string['tileordersetting_desc'] = 'Ce paramètre définit la position d’ordre de la tuile publicitaire {$a->no}. Par défaut, les tuiles publicitaires sont classées de haut en bas et de gauche à droite comme montré sur cette page de paramètres ici. Cependant, ce paramètre permet de décider d’attribuer un autre ordre. Si on attribue la même position de commande à deux tuiles publicitaires ou plus, elles seront à nouveau classées selon l’ordre indiqué sur cette page de paramètres.';
$string['tilesgeneralheading'] = 'Paramètres généraux des tuiles publicitaires';
$string['tilestab'] = 'Tuiles publicitaires';
$string['tiletitlesetting'] = 'Titre de la tuile publicitaire {$a->no}';
$string['tiletitlesetting_desc'] = 'Saisir ici le titre qui doit être affiché dans la tuile publicitaire {$a->no}. Il s’agit d’un paramètre facultatif, la tuile publicitaire s’affichera même si vous ne définissez pas de titre.';
$string['trimsummary'] = 'Tronquer le résumé du cours';
$string['trimsummary_desc'] = 'Saisir un nombre pour réduire la longueur du résumé. Ce nombre représente les caractères qui seront affichés.';
$string['trimtitle'] = 'Tronquer le nom du cours';
$string['trimtitle_desc'] = 'Saisir un nombre pour réduire la longueur du titre. Ce nombre représente les caractères qui seront affichés.';
$string['upgradenotice_2022080922'] = 'À partir de cette version, LearnR a ses propres paramètres de logo et de logo compact et n’utilise plus ces fichiers des paramètres de base de Moodle.';
$string['upgradenotice_2022080922_copied'] = 'Le <strong>{$a}</strong> existant des paramètres de base de Moodle a été copié dans le paramètre de LearnR{$a} lors de cette mise à niveau. Merci de vérifier le résultat.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'logo compact';
$string['upgradenotice_2022080922_notcopied'] = 'Le paramètre <strong>{$a}</strong> dans LearnR est maintenant vide. Pour utiliser un {$a} dans LearnR à partir de maintenant, téléchargez-le simplement dans le paramètre LearnR {$a} plus tard.';
$string['userreportgradebook'] = 'Rapport de l’utilisateur';
$string['viewallcourses'] = 'Afficher tous les cours';
