<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'lo', version '4.2'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'ປະຕິເສດການເຂົ້າເຖິງ';
$string['accounts'] = 'ບັນຊີ';
$string['addcategory'] = 'ເພີ່ມປະເພດ';
$string['additionalhtml'] = 'HTML ເພີ່ມເຕີມ';
$string['additionalhtml_desc'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ອະນຸຍາດໃຫ້ທ່ານສາມາດລະບຸ HTML ທີ່ທ່ານຕ້ອງການເພີ່ມໃສ່ທຸກໜ້າ. ທ່ານສາມາດຕັ້ງ HTML ທີ່ຈະຖືກເພີ່ມເຂົ້າໄປພາຍໃນແທັກ HEAD ສໍາລັບ ໜ້າ, ທັນທີຫຼັງຈາກເປີດແທັກ BODY, ຫຼື ທັນທີກ່ອນທີ່ຈະປິດແທັກເນື້ອໃນ.<br /> ການເຮັດອັນນີ້ອະນຸຍາດໃຫ້ທ່ານເພີ່ມສ່ວນຫົວ ຫຼື ສ່ວນທ້າຍແບບກໍານົດເອງໃສ່ໃນທຸກໜ້າ, ຫຼື ເພີ່ມການສະໜັບສະໜູນ ການບໍລິການເຊັ່ນ: Google Analytics ໄດ້ຢ່າງງ່າຍດາຍ, ບໍ່ຂຶ້ນກັບຫົວຂໍ້ທີ່ທ່ານເລືອກ.';
$string['additionalhtml_heading'] = 'HTML ເພີ່ມເຕີມທີ່ຈະເພີ່ມເຂົ້າໃນທຸກໜ້າ.';
$string['additionalhtmlfooter'] = 'ກ່ອນທີ່ BODY ຈະປິດ';
$string['additionalhtmlfooter_desc'] = 'ເນື້ອຫາຢູ່ທີ່ນີ້ຈະຖືກເພີ່ມເຂົ້າໃສ່ໃນທຸກໜ້າ ກ່ອນທີ່ແທັກເນື້ອໃນຈະປິດ.';
$string['additionalhtmlhead'] = 'ພາຍໃນ HEAD';
$string['additionalhtmlhead_desc'] = 'ເນື້ອຫາຢູ່ທີ່ນີ້ຈະຖືກເພີ່ມເຂົ້າໃສ່ທາງລຸ່ມຂອງແທັກ HEAD ສໍາລັບທຸກໜ້າ.';
$string['additionalhtmltopofbody'] = 'ເມື່ອ BODY ຖືກເປີດ';
$string['additionalhtmltopofbody_desc'] = 'ເນື້ອຫາຢູ່ທີ່ນີ້ຈະຖືກເພີ່ມເຂົ້າໃສ່ທຸກໜ້າ ທັນທີຫຼັງຈາກເປີດແທັກເນື້ອໃນ.';
$string['admincategory'] = 'ປະເພດ: {$ a}';
$string['adminseesall'] = 'ແອດມິນເບິ່ງທັງໝົດ';
$string['adminseesallevents'] = 'ຜູ້ເບິ່ງແຍງລະບົບເບິ່ງເຫດການທັງໝົດ';
$string['adminseesownevents'] = 'ຜູ້ເບິ່ງແຍງລະບົບຄືກັນກັບຜູ້ໃຊ້ຄົນອື່ນ';
$string['advancedfeatures'] = 'ຄຸນລັກສະນະຂັ້ນສູງ';
$string['agedigitalconsentverification'] = 'ການກວດສອບການຍິນຍອມໃນຍຸກດິຈິຕອລ';
$string['agedigitalconsentverification_desc'] = 'ເປີດໃຊ້ການກວດສອບການຍິນຍອມຂອງຍຸກດິຈິຕອລ ກ່ອນສະແດງໜ້າລົງທະບຽນສໍາລັບຜູ້ໃຊ້ລົງທະບຽນດ້ວຍຕົນເອງ. ອັນນີ້ປົກປ້ອງເວັບໄຊທ໌ຂອງທ່ານຈາກຜູ້ເຍົາລົງທະບຽນໂດຍບໍ່ໄດ້ຮັບການຍິນຍອມຈາກພໍ່ແມ່/ຜູ້ປົກຄອງ. ລາຍລະອຽດ <a target="_blank" href="{$a}">ລາຍຊື່ຕິດຕໍ່ສະໜັບສະຫນູນ</a> ແມ່ນສະໜອງໃຫ້ກັບຜູ້ເຍົາສໍາລັບການຊ່ວຍເຫຼືອເພີ່ມເຕີມ.';
$string['ageofdigitalconsentmap'] = 'ຍຸກດິຈິຕອລຂອງການຍິນຍອມ';
$string['ageofdigitalconsentmap_desc'] = 'ຍຸກດິຈິຕອລເລີ່ມຕົ້ນຂອງການຍິນຍອມເຫັນດີ, ແລະ ອາຍຸຢູ່ໃນປະເທດໃດໜຶ່ງທີ່ມັນແຕກຕ່າງຈາກມາດຕະຖານ, ອາດຈະຖືກລະບຸຢູ່ທີ່ນີ້. ໃສ່ແຕ່ລະອາຍຸຢູ່ໃນແຖວໃໝ່ທີ່ມີຮູບແບບ: ລະຫັດປະເທດ, ອາຍຸ (ແຍກດ້ວຍໝາຍຈຸດ). ອາຍຸເລີ່ມຕົ້ນແມ່ນສະແດງໂດຍ * ແທນລະຫັດປະເທດ. ລະຫັດປະເທດແມ່ນເປັນໄປຕາມທີ່ລະບຸໄວ້ໃນ ISO 3166-2.';
$string['allcountrycodes'] = 'ລະຫັດປະເທດທັງໝົດ';
$string['allowattachments'] = 'ອະນຸຍາດໄຟລ໌ແນບ';
$string['allowbeforeblock'] = 'ລາຍຊື່ທີ່ໄດ້ຮັບອະນຸຍາດຈະຖືກປະມວນຜົນກ່ອນ';
$string['allowbeforeblockdesc'] = 'ໂດຍຄ່າເລີ່ມຕົ້ນ, ລາຍການຢູ່ໃນລາຍຊື່ IPs ທີ່ຖືກປິດກັ້ນໄວ້ຈະຖືກຈັບຄູ່ກັນກ່ອນ. ຖ້າຕົວເລືອກນີ້ຖືກເປີດໃຊ້, ລາຍການຢູ່ໃນລາຍການ IPs ທີ່ໄດ້ຮັບອະນຸຍາດຈະຖືກປະມວນຜົນກ່ອນລາຍຊື່ທີ່ຖືກປິດກັ້ນ.';
$string['allowcategorythemes'] = 'ອະນຸຍາດຮູບແບບສີສັນປະເພດ';
$string['allowcohortthemes'] = 'ອະນຸຍາດໃຫ້ມີຮູບແບບສີສັນກຸ່ມ';
$string['allowcoursethemes'] = 'ອະນຸຍາດຮູບແບບສີສັນລາຍວິຊາ';
$string['allowedemaildomains'] = 'ອະນຸຍາດໂດເມນອີເມລ';
$string['allowediplist'] = 'ອະນຸຍາດລາຍການ IP';
$string['allowemailaddresses'] = 'ອະນຸຍາດໂດເມນອີເມລ';
$string['allowemojipicker'] = 'ຕົວເລືອກອີໂມຈິ';
$string['allowframembedding'] = 'ອະນຸຍາດການຝັງກອບ';
$string['allowframembedding_help'] = 'ຖ້າເປີດໃຊ້, ເວັບໄຊທ໌ນີ້ອາດຈະຖືກຝັງຢູ່ໃນກອບໃນລະບົບຫ່າງໄກ, ຕາມທີ່ແນະນໍາເມື່ອໃຊ້ປລັກອິນການລົງທະບຽນ \'ເຜີຍແຜ່ເປັນເຄື່ອງມື LTI\'. ບໍ່ດັ່ງນັ້ນ, ຂໍແນະນຳໃຫ້ປິດການຝັງກອບເພື່ອເຫດຜົນດ້ານຄວາມປອດໄພ. ກະລຸນາຮັບຊາບວ່າ ສຳລັບແອັບມືຖືການຕັ້ງຄ່ານີ້ບໍ່ໄດ້ໃສ່ໃຈ ແລະ ການຝັງຕິດກອບແມ່ນໄດ້ຮັບອະນຸຍາດສະເໝີ.';
$string['allowguestmymoodle'] = 'ອະນຸຍາດໃຫ້ແຂກເຂົ້າເຖິງແຜງໜ້າປັດ';
$string['allowindexing'] = 'ອະນຸຍາດໃຫ້ດັດສະນີໂດຍເຄື່ອງຈັກຊອກຫາ';
$string['allowindexing_desc'] = 'ສິ່ງນີ້ ກຳນົດວ່າຈະອະນຸຍາດໃຫ້ເຄື່ອງຈັກຊອກຫາເພື່ອສ້າງດັດຊະນີເວັບໄຊທ໌ຂອງທ່ານຫຼືບໍ່. "ຢູ່ທົ່ວທຸກແຫ່ງ" ຈະອະນຸຍາດໃຫ້ເຄື່ອງຈັກຊອກຫາ ເພື່ອຄົ້ນຫາຢູ່ທົ່ວທຸກບ່ອນລວມທັງໜ້າເຂົ້າສູ່ລະບົບ ແລະ
 ໜ້າລົງທະບຽນ, ຊຶ່ງໝາຍຄວາມວ່າເວັບໄຊທ໌ທີ່ມີການບັງຄັບເຂົ້າສູ່ລະບົບທີ່ເປີດຢູ່ແມ່ນຍັງຖືກດັດສະນີຢູ່. ເພື່ອຫຼີກເວັ້ນຄວາມສ່ຽງຂອງສະແປມທີ່ກ່ຽວຂ້ອງກັບ ໜ້າສະໝັກທີ່ສາມາດຄົ້ນຫາໄດ້, ໃຊ້ "ທຸກບ່ອນຍົກເວັ້ນໜ້າເຂົ້າສູ່ລະບົບ ແລະ ສະໝັກສະມາຊິກ". "ບໍ່ມີບ່ອນໃດ" ຈະບອກເຄື່ອງຈັກຊອກຫາບໍ່ໃຫ້ດັດສະນີໜ້າໃດໜຶ່ງ. ໃຫ້ສັງເກດວ່າອັນນີ້ເປັນພຽງແຕ່ແທັກຢູ່ໃນສ່ວນຫົວຂອງເວັບໄຊທ໌. ມັນຂຶ້ນຢູ່ກັບເຄື່ອງຈັກຊອກຫາທີ່ຈະເຄົາລົບແທັກ.';
$string['allowindexingeverywhere'] = 'ຢູ່ທຸກບ່ອນ';
$string['allowindexingexceptlogin'] = 'ຢູ່ທຸກບ່ອນຍົກເວັ້ນໜ້າເຂົ້າສູ່ລະບົບ ແລະ ລົງທະບຽນ';
$string['allowindexingnowhere'] = 'ບໍ່ມີບ່ອນໃດ';
$string['allowobjectembed'] = 'ອະນຸຍາດ EMBED ແລະ ແທັກ OBJECT';
$string['allowthemechangeonurl'] = 'ອະນຸຍາດໃຫ້ມີການປ່ຽນແປງຮູບແບບສີສັນໃນ URL';
$string['allowuserblockhiding'] = 'ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ເຊື່ອງບລັອກ';
$string['allowusermailcharset'] = 'ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ເລືອກຊຸດຕົວອັກສອນ';
$string['allowuserswitchrolestheycantassign'] = 'ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ໂດຍບໍ່ມີຄວາມສາມາດແຕ່ງຕັ້ງໜ້າທີ່ໃຫ້ປ່ຽນບົດບາດ';
$string['allowuserthemes'] = 'ອະນຸຍາດຮູບແບບສີສັນຜູ້ໃຊ້';
$string['alternativefullnameformat'] = 'ຮູບແບບຊື່ເຕັມສຳຮອງ';
$string['alternativefullnameformat_desc'] = 'ອັນນີ້ກໍານົດວິທີການສະແດງຊື່ໃຫ້ກັບຜູ້ໃຊ້ດ້ວຍຄວາມສາມາດ viewlnames (ໂດຍຜູ້ໃຊ້ເລີ່ມຕົ້ນທີ່ມີບົດບາດເປັນຜູ້ຈັດການ, ຄູສອນ ຫຼື ຄູບໍ່ໄດ້ແກ້ໄຂ). ຕົວຍຶດບ່ອນທີ່ສາມາດໃຊ້ໄດ້ຄືກັບການຕັ້ງຄ່າ "ຮູບແບບຊື່ເຕັມ".';
$string['always'] = 'ສະເໝີ';
$string['appearance'] = 'ຮູບລັກສະນະ';
$string['aspellpath'] = 'ເສັ້ນທາງໄປສູ່ aspell';
$string['authentication'] = 'ການກວດສອບຄວາມຖືກຕ້ອງ';
$string['authpreventaccountcreation'] = 'ປ້ອງກັນການສ້າງບັນຊີເມື່ອກວດສອບຄວາມຖືກຕ້ອງ';
$string['authpreventaccountcreation_help'] = 'ເມື່ອຜູ້ໃຊ້ກວດສອບຄວາມຖືກຕ້ອງ, ບັນຊີຢູ່ໃນເວັບໄຊທ໌ຈະຖືກສ້າງຂຶ້ນໂດຍອັດຕະໂນມັດຖ້າມັນຍັງບໍ່ທັນມີຢູ່. ຖ້າຖານຂໍ້ມູນພາຍນອກ, ເຊັ່ນ LDAP, ຖືກໃຊ້ສໍາລັບການກວດສອບຄວາມຖືກຕ້ອງ, ແຕ່ເຈົ້າຕ້ອງການຈໍາກັດການເຂົ້າເຖິງເວັບໄຊທ໌ກັບຜູ້ໃຊ້ທີ່ມີບັນຊີທີ່ມີຢູ່ແລ້ວເທົ່ານັ້ນ, ຫຼັງຈາກນັ້ນທາງເລືອກນີ້ຄວນຖືກເປີດໃຊ້ງານ. ບັນຊີໃໝ່ຈະຕ້ອງຖືກສ້າງຂຶ້ນດ້ວຍຕົນເອງ ຫຼື ຜ່ານຄຸນສົມບັດຂອງຜູ້ໃຊ້ອັບໂຫຼດ. ຈື່ໄວ້ວ່າ ການຕັ້ງຄ່ານີ້ບໍ່ໄດ້ນໍາໃຊ້ກັບການກວດສອບຄວາມຖືກຕ້ອງ MNet.';
$string['authsettings'] = 'ຈັດການການພິສູດຢືນຢັນຕົວ';
$string['autolang'] = 'ກວດຫາພາສາອັດຕະໂນມັດ';
$string['autolangusercreation'] = 'ໃນການສ້າງບັນຊີ ໃຫ້ຕັ້ງພາສາໂປຼແກຼມທ່ອງເວັບຂອງຜູ້ໃຊ້ເປັນພາສາທີ່ເຂົາເຈົ້າຕ້ອງການ';
$string['autologinguests'] = 'ເຂົ້າສູ່ລະບົບແຂກໂດຍອັດຕະໂນມັດ';
$string['availableto'] = 'ມີໃຫ້ກັບ';
$string['backgroundcolour'] = 'ສີໂປ່ງໃສ';
$string['backup_shortname'] = 'ໃຊ້ຊື່ວິຊາໃນຊື່ໄຟລ໌ສຳຮອງຂໍ້ມູນ';
$string['backup_shortnamehelp'] = 'ໃຊ້ຊື່ຫຼັກສູດເປັນສ່ວນໜຶ່ງຂອງຊື່ໄຟລ໌ສຳ ຮອງ.';
$string['backups'] = 'ການສຳຮອງຂໍ້ມູນ';
$string['badwordsconfig'] = 'ໃສ່ລາຍການຄຳສັບທີ່ບໍ່ດີຂອງທ່ານແຍກດ້ວຍໝຍຈຸດ.';
$string['badwordsdefault'] = 'ຖ້າລາຍການກຳນົດເອງຫວ່າງເປົ່າ, ລາຍຊື່ເລີ່ມຕົ້ນຈາກຊຸດພາສາຈະຖືກໃຊ້.';
$string['badwordslist'] = 'ບັນຊີລາຍການຄໍາສັບທີ່ບໍ່ດີທີ່ກໍານົດເອງ';
$string['blockediplist'] = 'ລາຍການ IP ທີ່ຖືກປິດກັ້ນ';
$string['blockinstances'] = 'ຕົວຢ່າງ';
$string['blockmultiple'] = 'ຫຼາຍ';
$string['blockprotect'] = 'ປົກປ້ອງຕົວຢ່າງ';
$string['blockprotect_help'] = 'ຖ້າທ່ານລັອກປະເພດສະເພາະຂອງການປິດກັ້ນ, ຈາກນັ້ນຈະບໍ່ມີໃຜສາມາດເພີ່ມ ຫຼື ລຶບຕົວຢ່າງໄດ້. (ແນ່ນອນ, ທ່ານສາມາດປົດລັອກໄດ້ອີກ ຖ້າທ່ານຕ້ອງການແກ້ໄຂຕົວຢ່າງຕ່າງໆ.)

ອັນນີ້ມີຈຸດປະສົງເພື່ອປົກປ້ອງການປິກກັ້ນຕ່າງໆເຊັ່ນ: ການນໍາທາງ ແລະ ການຕັ້ງຄ່າເຊິ່ງຍາກຫຼາຍທີ່ຈະໄດ້ກັບຄືນມາຖ້າຖືກລຶບໂດຍບັງເອີນ.';
$string['blocksettings'] = 'ຈັດການບລັອກ';
$string['blockunprotect'] = 'ບໍ່ໄດ້ປ້ອງກັນ';
$string['bloglevel'] = 'ບລ໋ອກທີ່ເບິ່ງເຫັນ';
$string['bookmarkadded'] = 'ເພີ່ມບຸກມາກແລ້ວ.';
$string['bookmarkalreadyexists'] = 'ທ່ານໄດ້ບຸກມາກໜ້ານີ້ໄວ້ແລ້ວ.';
$string['bookmarkdeleted'] = 'ບຸກມາກຖືກລຶບແລ້ວ.';
$string['bookmarkthispage'] = 'ບຸກມາກຫນ້ານີ້';
$string['cacheapplication'] = 'ໂປຼແກຼມເກັບຂໍ້ມູນແຄດ';
$string['cacheapplicationhelp'] = 'ລາຍການເກັບຂໍ້ມູນແຄດຖືກແບ່ງປັນໃຫ້ກັບຜູ້ໃຊ້ທຸກຄົນ ແລະ ໝົດອາຍຸຕາມເວລາທີ່ກໍານົດໄວ້ເພື່ອດໍາລົງຊີວິດ (ttl).';
$string['cachejs'] = 'Javascript ທີ່ເກັບຂໍ້ມູນແຄດ';
$string['cachejs_help'] = 'ການເກັບຂໍ້ມູນແຄດ ແລະ ການບີບອັດ Javascript ຊ່ວຍປັບປຸງປະສິດທິພາບການໂຫຼດໜ້າເວັບໄດ້ດີຫຼາຍ. ມັນຖືກແນະນໍາຢ່າງແຂງແຮງສໍາລັບສະຖານທີ່ຜະລິດ. ຜູ້ພັດທະນາອາດຈະຕ້ອງການປິດການນຳໃຊ້ຄຸນສົມບັດນີ້.';
$string['cacherequest'] = 'ຮ້ອງຂໍການເກັບຂໍ້ມູນແຄດ';
$string['cacherequesthelp'] = 'ການເກັບຂໍ້ມູນແຄດສະເພາະຂອງຜູ້ໃຊ້ທີ່ໝົດອາຍຸເມື່ອຄຳຮ້ອງຂໍສຳເລັດ. ອອກແບບມາເພື່ອທົດແທນພື້ນທີ່ບ່ອນທີ່ພວກເຮົາກໍາລັງໃຊ້ຮ້ານສະຖິດຢູ່.';
$string['cachesession'] = 'ໄລຍະເວລາການເກັບຂໍ້ມູນແຄດ';
$string['cachesessionhelp'] = 'ການເກັບຂໍ້ມູນແຄດສະເພາະຂອງຜູ້ໃຊ້ທີ່ໝົດອາຍຸເມື່ອເຊດຊັນຂອງຜູ້ໃຊ້ສິ້ນສຸດລົງ. ອອກແບບມາເພື່ອບັນເທົາອາການບວມ/ຕືງຄຽດ.';
$string['cachesettings'] = 'ການຕັ້ງຄ່າການເກັບຂໍ້ມູນແຄດ';
$string['cachetemplates'] = 'ແມ່ແບບການເກັບຂໍ້ມູນແຄດ';
$string['cachetemplates_help'] = 'ການເກັບຂໍ້ມູນແຄດໃສ່ແມ່ແບບຈະຊ່ວຍປັບປຸງປະສິດທິພາບການໂຫຼດໜ້າ ແລະ ຖືກແນະນໍາຢ່າງສູງສໍາລັບສະຖານທີ່ຜະລິດ. ຜູ້ພັດທະນາອາດຈະຕ້ອງການປິດການນຳໃຊ້ຄຸນສົມບັດນີ້.';
$string['caching'] = 'ການເກັບຂໍ້ມູນແຄດ';
$string['calendar_weekend'] = 'ວັນທ້າຍອາທິດ';
$string['calendarexportsalt'] = 'ປະຕິທິນການສົ່ງອອກເກືອ';
$string['calendarsettings'] = 'ປະຕິທິນ';
$string['calendartype'] = 'ປະເພດປະຕິທິນ';
$string['calendartype_desc'] = 'ເລືອກປະເພດປະຕິທິນເລີ່ມຕົ້ນສຳລັບທັງເວັບໄຊທ໌. ການຕັ້ງຄ່ານີ້ສາມາດຖືກລົບລ້າງໄດ້ຢູ່ໃນການຕັ້ງຄ່າຫຼັກສູດ ຫຼື ໂດຍຜູ້ໃຊ້ຢູ່ໃນໂປຼໄຟລ໌ສ່ວນຕົວຂອງເຂົາເຈົ້າ.';
$string['cannotdeletemodfilter'] = 'ທ່ານບໍ່ສາມາດຖອນການຕິດຕັ້ງ \'{$a->filter}\' ໄດ້ເພາະວ່າມັນເປັນສ່ວນໜຶ່ງຂອງຊຸດ \'{$a->module}\'.';
$string['cannotuninstall'] = 'ບໍ່ສາມາດຖອນຕິດຕັ້ງ {$a} ໄດ້.';
$string['categoryemail'] = 'ອີເມລ';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot ຖືກກຳນົດບໍ່ຖືກຕ້ອງຢູ່ໃນໄຟລ໌ config.php. ມັນລວມມີຕົວອັກສອນ \'/\' ຢູ່ທ້າຍທີ່ຕ້ອງຖືກຍົກຍ້າຍອອກໄປ.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot ຖືກກຳນົດບໍ່ຖືກຕ້ອງຢູ່ໃນໄຟລ໌ config.php. ມັນຄວນຈະກົງກັບ URL ທີ່ທ່ານກຳລັງໃຊ້ເພື່ອເຂົ້າຫາໜ້ານີ້.';
$string['change'] = 'ປ່ຽນແປງ';
$string['checkboxno'] = 'ບໍ່';
$string['checkboxyes'] = 'ແມ່ນແລ້ວ';
$string['checkupgradepending'] = 'ຍົກລະດັບ';
$string['choosefiletoedit'] = 'ເລືອກໄຟລ໌ທີ່ຈະແກ້ໄຂ';
$string['cleanup'] = 'ທໍາຄວາມສະອາດ';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'ກຳລັງອອກໄປຢ່າງສະຫງ່າງາມ, ກະລຸນາລໍຖ້າ ...';
$string['cliexitnow'] = 'ອອກໄປດຽວນີ້';
$string['cliincorrectvalueerror'] = 'ຜິດພາດ, ຄ່າບໍ່ຖືກຕ້ອງ "{$a->value}" ສໍາລັບ "{$a->option}"';
$string['cliincorrectvalueretry'] = 'ຄ່າບໍ່ຖືກຕ້ອງ, ກະລຸນາລອງໃໝ່';
$string['clistatusdisabled'] = 'ສະຖານະ: ປິດການນຳໃຊ້';
$string['clistatusenabled'] = 'ສະຖານະ: ເປີດການນຳໃຊ້';
$string['clistatusenabledlater'] = 'ສະຖານະ: ໂໝດການ ບຳລຸງຮັກສາ CLI ຈະຖືກເປີດນຳໃຊ້ໃນ {$a}';
$string['clitypevalue'] = 'ປະເພດມູນຄ່າ';
$string['clitypevaluedefault'] = 'ພິມຄ່າ, ກົດ Enter ເພື່ອໃຊ້ຄ່າເລີ່ມຕົ້ນ ({$a})';
$string['cliunknowoption'] = 'ຕົວເລືອກທີ່ບໍ່ຮູ້ຈັກ:
   {$a}
ກະລຸນາໃຊ້ --ຕົວເລືອກຊ່ວຍເຫຼືອ.';
$string['cliupgradedefault'] = 'ການຕັ້ງຄ່າໃໝ່: {$a}';
$string['cliupgradedefaultheading'] = 'ການຕັ້ງຄ່າຄ່າເລີ່ມຕົ້ນໃໝ່';
$string['cliupgradedefaultverbose'] = 'ການຕັ້ງຄ່າໃໝ່: {$a->name}, ຄ່າເລີ່ມຕົ້ນ: {$a->defaultsettingting}';
$string['cliupgradefinished'] = 'ຍົກລະດັບແຖວຄຳສັ່ງຈາກ {$a->oldversion} ເປັນ {$a->newversion} ສຳເລັດແລ້ວ.';
$string['cliupgradenoneed'] = 'ບໍ່ຈຳເປັນຕ້ອງຍົກລະດັບສຳລັບສະບັບທີ່ຕິດຕັ້ງແລ້ວ {$a}. ຂອບໃຈທີ່ເຂົ້າມາແລ້ວ!';
$string['cliupgradepending'] = 'ການຍົກລະດັບຍັງລໍຖ້າການອະນຸມັດຢູ່';
$string['cliyesnoprompt'] = 'ປະເພດ y (ໝາຍຄວາມວ່າແມ່ນ) ຫຼື n (ໝາຍຄວາມວ່າບໍ່)';
$string['close'] = 'ປິດ';
$string['commentsperpage'] = 'ຄຳເຫັນທີ່ສະແດງຕໍ່ໜ້າ';
$string['commonactivitysettings'] = 'ການຕັ້ງຄ່າກິດຈະກໍາທົ່ວໄປ';
$string['commonfiltersettings'] = 'ການຕັ້ງຄ່າຕົວກັ່ນກອງທົ່ວໄປ';
$string['commonsettings'] = 'ການຕັ້ງຄ່າທົ່ວໄປ';
$string['componentinstalled'] = 'ຕິດຕັ້ງອົງປະກອບແລ້ວ';
$string['computedfromlogs'] = 'ຄຳນວນຈາກບັນທຶກຕັ້ງແຕ່ {$a}.';
$string['condifmodeditdefaults'] = 'ຄ່າເລີ່ມຕົ້ນແມ່ນໃຊ້ໃນຮູບແບບການຕັ້ງຄ່າເມື່ອສ້າງກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນໃໝ່.';
$string['confeditorhidebuttons'] = 'ເລືອກປຸ່ມທີ່ຄວນຈະຖືກເຊື່ອງໄວ້ໃນຕົວແກ້ໄຂ HTML.';
$string['configallcountrycodes'] = 'ນີ້ແມ່ນລາຍຊື່ປະເທດທີ່ອາດຈະຖືກເລືອກຢູ່ໃນບ່ອນຕ່າງໆ, ຕົວຢ່າງ: ຢູ່ໃນໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້. ຖ້າຫວ່າງເປົ່າ (ຄ່າເລີ່ມຕົ້ນ) ລາຍການຢູ່ໃນ countries.php ໃນຊຸດພາສາອັງກິດມາດຕະຖານຖືກໃຊ້. ນັ້ນແມ່ນບັນຊີລາຍຊື່ຈາກ ISO 3166-1. ບໍ່ດັ່ງນັ້ນ, ເຈົ້າສາມາດລະບຸລາຍການລະຫັດທີ່ຂັ້ນດ້ວຍໝາຍຈຸດ, ຕົວຢ່າງ: \'GB, FR, ES\'. ຖ້າເຈົ້າເພີ່ມລະຫັດໃໝ່, ທີ່ບໍ່ໄດ້ມາດຕະຖານຢູ່ທີ່ນີ້, ເຈົ້າຈະຕ້ອງໄດ້ເພີ່ມພວກມັນເຂົ້າໃສ່ countries.php ໃນ \'en\' ແລະ ຊຸດພາສາຂອງທ່ານ.';
$string['configallowassign'] = 'ເຈົ້າສາມາດອະນຸຍາດໃຫ້ຄົນທີ່ມີບົດບາດຢູ່ເບື້ອງຊ້າຍແຕ່ງຕັ້ງໜ້າທີ່ຖັນໃຫ້ກັບຄົນອື່ນ';
$string['configallowattachments'] = 'ຖ້າເປີດນຳໃຊ້, ອີເມວທີ່ສົ່ງມາຈາກເວັບໄຊທ໌ ສາມາດມີໄຟລ໌ແນບໄດ້ເຊັ່ນ: ປ້າຍ.';
$string['configallowcategorythemes'] = 'ຖ້າເຈົ້າເປີດໃຊ້ສິ່ງນີ້, ຈາກນັ້ນຮູບແບບສີສັນສາມາດຕັ້ງຄ່າຢູ່ໃນລະດັບປະເພດໄດ້. ສິ່ງນີ້ຈະມີຜົນກະທົບກັບປະເພດ ແລະ ວິຊາທັງໝົດຂອງເດັກ ເວັ້ນເສຍແຕ່ວ່າເຂົາເຈົ້າໄດ້ຕັ້ງຮູບແບບສີສັນຂອງເຂົາເຈົ້າໂດຍສະເພາະ. ຄຳເຕືອນ: ການເປີດໃຊ້ຮູບແບບສີສັນປະເພດອາດຈະກະທົບກັບປະສິດທິພາບ.';
$string['configallowcohortthemes'] = 'ຖ້າເຈົ້າເປີດໃຊ້ສິ່ງນີ້, ຈາກນັ້ນຮູບແບບສີສັນສາມາດຕັ້ງຄ່າຢູ່ໃນລະດັບກຸ່ມໄດ້. ສິ່ງນີ້ຈະມີຜົນກະທົບກັບຜູ້ໃຊ້ທັງໝົດທີ່ມີພຽງກຸ່ມດຽວ ຫຼື ຫຼາຍກ່ວາໜຶ່ງແຕ່ມີຮູບແບບສີສັນອັນດຽວກັນ.';
$string['configallowcoursethemes'] = 'ຖ້າເປີດໃຊ້, ຈາກນັ້ນວິຊາຈະໄດ້ຮັບອະນຸຍາດໃຫ້ຕັ້ງຮູບແບບສີສັນຂອງຕົນເອງ. ຮູບແບບສີສັນວິຊາຈະລົບລ້າງການເລືອກຮູບແບບສີສັນອື່ນທັງໝົດ (ເວັບໄຊທ໌, ຜູ້ໃຊ້, ປະເພດ, ກຸ່ມທີມ ຫຼື ຮູບແບບສີສັນທີ່ກໍານົດໂດຍ URL).';
$string['configallowedemaildomains'] = 'ລາຍຊື່ໂດເມນອີເມລທີ່ອະນຸຍາດໃຫ້ເປີດເຜີຍໄດ້ໃນພາກສ່ວນ "ຈາກ" ຂອງອີເມລຂາອອກ. ຄ່າເລີ່ມຕົ້ນຂອງ "ຫວ່າງເປົ່າ" ຈະໃຊ້ທີ່ຢູ່ບໍ່ມີການຕອບກັບສໍາລັບທຸກອີເມລຂາອອກ. ການອະນຸຍາດໃຫ້ໃຊ້ຕົວອັກສອນຕົວແທນເຊັ່ນ: *.example.com ຈະອະນຸຍາດໃຫ້ສົ່ງອີເມລຈາກທຸກໂດເມນຍ່ອຍຂອງ example.com, ແຕ່ບໍ່ແມ່ນ example.com ເອງ. ອັນນີ້ຈະຕ້ອງການການປ້ອນແຍກຕ່າງຫາກ.';
$string['configallowemailaddresses'] = 'ເພື່ອຈຳກັດທີ່ຢູ່ອີເມລໃໝຕໍ່ກັບໂດເມນໃດໜຶ່ງ, ໃຫ້ເຮັດລາຍຊື່ພວກມັນໄວ້ບ່ອນນີ້ແຍກກັນດ້ວຍຍະຫວ່າງ. ໂດເມນອື່ນທັງໝົດຈະຖືກປະຕິເສດ. ເພື່ອອະນຸຍາດໃຫ້ໂດເມນຍ່ອຍ, ເພີ່ມໂດເມນທີ່ມີຕົວອັກສອນກ່ອນໜ້າ \'.\'. ເພື່ອອະນຸຍາດໃຫ້ມີໂດເມນຮາກຮ່ວມກັບໂດເມນຍ່ອຍຂອງມັນ, ໃຫ້ເພີ່ມໂດເມນສອງຄັ້ງ - ຄັ້ງດຽວກັບກ່ອນໜ້າ \'.\' ແລະ ຄັ້ງໜຶ່ງໂດຍບໍ່ມີ ຕົວຢ່າງ: .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'ຕົວເລືອກອີໂມຈິ ຊ່ວຍໃຫ້ຜູ້ໃຊ້ສາມາດເລືອກສັນຍາລັກຕ່າງໆເຊັ່ນ: ຮອຍຍິ້ມ, ເພື່ອເພີ່ມຂໍ້ຄວາມ ແລະ ພື້ນທີ່ຂໍ້ຄວາມອື່ນໆຜ່ານປຸ່ມຕົວເລືອກອີໂມຈິ ໃນແຖບເຄື່ອງມື Atto.';
$string['configallowemojipickerincompatible'] = 'ການຕັ້ງຄ່າຖານຂໍ້ມູນປັດຈຸບັນຂອງທ່ານບໍ່ສະໜັບສະໜູນອີໂມຈິຢ່າງຖືກຕ້ອງ. ເພື່ອເປີດໃຊ້ຕົວເລືອກອີໂມຈິ, ທ່ານຈະຕ້ອງ <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">upgrade your database for full unicode support</a>.';
$string['configallowguestmymoodle'] = 'ຖ້າເປີດໃຊ້ງານ, ແຂກສາມາດເຂົ້າຫາແຜງໜ້າປັດ. ຖ້າບໍ່ດັ່ງນັ້ນ, ແຂກຈະຖືກນໍາໄປຫາໜ້າທໍາອິດຂອງເວັບໄຊທ໌.';
$string['configallowobjectembed'] = 'ໃນຖານະເປັນມາດຕະການຮັກສາຄວາມປອດໄພເລີ່ມຕົ້ນ, ຜູ້ໃຊ້ປົກກະຕິບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ຝັງມັນຕິມີເດຍ (ເຊັ່ນ: Flash) ພາຍໃນຂໍ້ຄວາມໂດຍໃຊ້ແທັກ EMBED ແລະ OBJECT ທີ່ຊັດເຈນໃນ HTML ຂອງເຂົາທ່ານ (ເຖິງແມ່ນວ່າມັນຍັງສາມາດເຮັດໄດ້ຢ່າງປອດໄພໂດຍໃຊ້ຕົວກັ່ນຕອງ mediaplugins). ຖ້າທ່ານຕ້ອງການອະນຸຍາດໃຫ້ແທັກເຫຼົ່ານີ້ເປີດໃຊ້ຕົວເລືອກນີ້.';
$string['configallowoverride'] = 'ທ່ານສາມາດອະນຸຍາດໃຫ້ຄົນທີ່ມີບົດບາດຢູ່ທາງເບື້ອງຊ້າຍລົບລ້າງບາງບົດບາດຂອງຖັນໄດ້';
$string['configallowoverride2'] = 'ເລືອກວ່າບົດບາດໃດສາມາດຖືກຍົກເລີກໄດ້ໂດຍແຕ່ລະໜ້າທີ່ຢູ່ໃນຖັນເບື້ອງຊ້າຍ. <br />ກະລຸນາຮັບຊາບວ່າການຕັ້ງຄ່າເຫຼົ່ານີ້ນຳໃຊ້ກັບຜູ້ໃຊ້ທີ່ມີທັງຄວາມສາມາດ moodle/role:override ຫຼື ຄວາມສາມາດ moodle/role:safeoverride ອະນຸຍາດ.';
$string['configallowswitch'] = 'ເລືອກວ່າຈະປ່ຽນໜ້າທີ່ຜູ້ໃຊ້ອັນໃດ, ອີງຕາມໜ້າທີ່ທີ່ເຂົາເຈົ້າມີຢູ່ແລ້ວ. ນອກ ເໜືອໄປຈາກການເຂົ້າໄປຢູ່ໃນຕາຕະລາງນີ້, ຜູ້ໃຊ້ຍັງຕ້ອງມີຄວາມສາມາດ moodle/role:switchroles ເພື່ອສາມາດສະຫຼັບໄດ້.<br />ກະລຸນາຮັບຊາບວ່າ ມັນເປັນໄປໄດ້ທີ່ຈະສະຫຼັບໄປໃຊ້ໜ້າທີ່ມີຄວາມສາມາດ moodle/course:view, ແລະ ນັ້ນກໍ່ບໍ່ມີຄວາມສາມາດ moodle/site:doanything, ສະນັ້ນບາງຖັນຢູ່ໃນຕາຕະລາງນີ້ຖືກປິດໃຊ້ງານ.';
$string['configallowthemechangeonurl'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ສາມາດປ່ຽນຮູບແບບສີສັນໄດ້ໂດຍການເພີ່ມ: <br />?theme=themename ໃສ່ URL Moodle ໃດໜຶ່ງ (ຕົວຢ່າງ: mymoodlesite.com/?theme=afterburner ) ຫຼື <br />&theme=themename ໃສ່ URL Moodle ພາຍໃນໃດໜຶ່ງ ( ຕົວຢ່າງ: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'ທ່ານຕ້ອງການອະນຸຍາດໃຫ້ຜູ້ໃຊ້ສາມາດເຊື່ອງ/ສະແດງບລັອກຂ້າງໃນທົ່ວເວັບໄຊທ໌ນີ້ບໍ? ຄຸນະລັກສະນະນີ້ໃຊ້ Javascript ແລະ ຄຸກກີ້ ເພື່ອຈື່ສະຖານະຂອງແຕ່ລະບລັອກທີ່ສາມາດພັງລົງໄດ້, ແລະ ມີຜົນກະທົບກັບມຸມມອງຂອງຜູ້ໃຊ້ເອງເທົ່ານັ້ນ.';
$string['configallowusermailcharset'] = 'ຖ້າເປີດໃຊ້, ຜູ້ໃຊ້ສາມາດເລືອກຕົວເລກອີເມລຢູ່ໃນການຕັ້ງຄ່າການສົ່ງຂໍ້ຄວາມຂອງເຂົາທ່ານ.';
$string['configallowuserswitchrolestheycantassign'] = 'ໂດຍຄ່າເລີ່ມຕົ້ນ, moodle/role:assign ກຳນົດໃຫ້ຜູ້ໃຊ້ປ່ຽນບົດບາດ. ການເປີດໃຊ້ງານການຕັ້ງຄ່ານີ້ຈະເອົາຄວາມຕ້ອງການນີ້ອອກ, ແລະ ຜົນໄດ້ຮັບຢູ່ໃນໜ້າທີ່ທີ່ມີຢູ່ໃນເມນູແບບເລື່ອນລົງ "ປ່ຽນບົດບາດເປັນ" ຖືກກໍານົດໂດຍການຕັ້ງຄ່າຢູ່ໃນຕາຕະລາງ "ອະນຸຍາດການແຕ່ງຕັ້ງໜ້າທີ່" ເທົ່ານັ້ນ.
ມັນໄດ້ຖືກແນະນໍາວ່າການຕັ້ງຄ່າຢູ່ໃນຕາຕະລາງ "ອະນຸຍາດການແຕ່ງຕັ້ງໜ້າທີ່" ບໍ່ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ປ່ຽນເປັນໜ້າທີ່ທີ່ມີຄວາມສາມາດຫຼາຍກວ່າບົດບາດທີ່ມີຢູ່ຂອງເຂົາເຈົ້າ.';
$string['configallowuserthemes'] = 'ຖ້າເຈົ້າເປີດໃຊ້ສິ່ງນີ້, ຜູ້ໃຊ້ຈະໄດ້ຮັບອະນຸຍາດໃຫ້ຕັ້ງຮູບແບບສີສັນຂອງເຂົາເຈົ້າເອງ. ຮູບແບບສີສັນຂອງຜູ້ໃຊ້ຈະລົບລ້າງຮູບແບບສີສັນຂອງເວັບໄຊທ໌ (ແຕ່ບໍ່ແມ່ນຮູບແບບສີສັນຫຼັກສູດ)';
$string['configallowview'] = 'ເລືອກວ່າຜູ້ໃຊ້ຈະເຫັນບົດບາດອັນໃດ, ສາມາດກັ່ນຕອງໂດຍອັນອື່ນໆ ອີງຕາມໜ້າທີ່ທີ່ພວກເຂົາມີຢູ່ແລ້ວ.';
$string['configallusersaresitestudents'] = 'ສໍາລັບກິດຈະກໍາຢູ່ໃນໜ້າທໍາອິດຂອງເວັບໄຊທ໌, ຜູ້ໃຊ້ທັງໝົດຄວນຖືວ່າເປັນນັກຮຽນບໍ? ຖ້າທ່ານຕອບວ່າ "ແມ່ນ", ຈາກນັ້ນບັນຊີຜູ້ໃຊ້ທີ່ໄດ້ຮັບການຢືນຢັນຈະໄດ້ຮັບອະນຸຍາດໃຫ້ເຂົ້າຮ່ວມເປັນນັກຮຽນໃນກິດຈະກໍາເຫຼົ່ານັ້ນ. ຖ້າທ່ານຕອບວ່າ "ບໍ່", ພຽງແຕ່ຜູ້ໃຊ້ທີ່ເປັນຜູ້ເຂົ້າຮ່ວມຢູ່ໃນວິຊາຢ່າງໜ້ອຍໜຶ່ງຄົນແລ້ວ ຈະສາມາດມີສ່ວນຮ່ວມໃນກິດຈະກໍາໜ້າທໍາອິດເຫຼົ່ານັ້ນໄດ້. ມີພຽງແຕ່ຜູ້ບໍລິຫານ ແລະ ຄູອາຈານທີ່ໄດ້ຮັບມອບໝາຍເປັນພິເສດເທົ່ານັ້ນ ສາມາດເຮັດໜ້າທີ່ເປັນຄູສອນສໍາລັບກິດຈະກໍາໜ້າຫຼັກເຫຼົ່ານີ້.';
$string['configauthenticationplugins'] = 'ກະລຸນາເລືອກປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງທີ່ເຈົ້າຕ້ອງການໃຊ້ ແລະຈັດລຽງມັນຕາມລໍາດັບຂອງຄວາມລົ້ມເຫຼວ.';
$string['configautolang'] = 'ກວດຫາພາສາເລີ່ມຕົ້ນຈາກການຕັ້ງຄ່າໂປຼແກຼມທ່ອງເວັບ, ຖ້າປິດການນຳໃຊ້ຄ່າເລີ່ມຕົ້ນຂອງເວັບໄຊທ໌.';
$string['configautolangusercreation'] = 'ຖ້າເປີດໃຊ້, ເມື່ອບັນຊີຂອງຜູ້ໃຊ້ຖືກສ້າງໂດຍອັດຕະໂນມັດຢູ່ໃນການເຂົ້າສູ່ລະບົບຄັ້ງທໍາອິດ (ຕົວຢ່າງ: ການນໍາໃຊ້ການກວດສອບຄວາມຖືກຕ້ອງ LDAP ຫຼື OAuth 2), ພາສາໂປຼແກຼມທ່ອງເວັບຂອງຜູ້ໃຊ້ຖືກຕັ້ງເປັນພາສາທີ່ເຂົາເຈົ້າຕ້ອງການ. ຖ້າບໍ່ດັ່ງນັ້ນ, ພາສາເລີ່ມຕົ້ນສໍາລັບເວັບໄຊທ໌ຈະຖືກຕັ້ງເປັນພາສາທີ່ຜູ້ໃຊ້ມັກ.';
$string['configautologinguests'] = 'ຜູ້ເຂົ້າຊົມຄວນເຂົ້າສູ່ລະບົບເປັນແຂກໂດຍອັດຕະໂນມັດບໍ ເມື່ອເຂົ້າວິຊາໂດຍການເຂົ້າເຖິງຂອງແຂກ?';
$string['configbloglevel'] = 'ການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ເຈົ້າຈໍາກັດລະດັບທີ່ສາມາດເບິ່ງບລັອກຜູ້ໃຊ້ຢູ່ໃນເວັບໄຊທ໌ນີ້ໄດ້. ກະລຸນາຮັບຊາບວ່າ ພວກເຂົາລະບຸສະພາບການສູງສຸດຂອງ VIEWER ບໍ່ແມ່ນໂປສເຕີ ຫຼື ປະເພດຂອງບົດຄວາມບລ໋ອກ. ບລ໋ອກຍັງສາມາດຖືກປິດການນຳໃຊ້ໄດ້ໝົດຖ້າທ່ານບໍ່ຕ້ອງການພວກມັນເລີຍ.';
$string['configcalendarcustomexport'] = 'ເປີດໃຊ້ງານການສົ່ງອອກປະຕິທິນຊ່ວງວັນທີແບບກຳນົດເອງ';
$string['configcalendarexportsalt'] = 'ຂໍ້ຄວາມແບບສຸ່ມນີ້ຖືກໃຊ້ເພື່ອປັບປຸງຄວາມປອດໄພຂອງໂທເຄັນການກວດສອບຄວາມຖືກຕ້ອງທີ່ໃຊ້ສໍາລັບການສົ່ງອອກປະຕິທິນ. ກະລຸນາຮັບຊາບວ່າ ໂທເຄັນປັດຈຸບັນທັງໝົດບໍ່ຖືກຕ້ອງຖ້າທ່ານປ່ຽນຮາສຊໍ (hash salt) ນີ້.';
$string['configcookiehttponly'] = 'ເປີດໃຊ້ຄຸນສົມບັດໃໝ່ຂອງ PHP 5.2.0 - ຕົວທ່ອງເວັບໄດ້ຖືກແນະນໍາໃຫ້ສົ່ງຄຸກກີ້ດ້ວຍຄໍາຂໍຕົວຈິງຂອງ http ເທົ່ານັ້ນ, ຄຸກກີ້ ບໍ່ຄວນເຂົ້າເຖິງໄດ້ໂດຍພາສາຂຽນ. ສິ່ງນີ້ບໍ່ໄດ້ຖືກຮອງຮັບຢູ່ໃນທຸກຕົວທ່ອງເວັບ ແລະ ມັນອາດຈະເຂົ້າກັນໄດ້ກັບລະຫັດປະຈຸບັນບໍ່ໄດ້ຢ່າງເຕັມສ່ວນ. ມັນຊ່ວຍປ້ອງກັນການໂຈມຕີ XSS ບາງປະເພດ.';
$string['configcookiesecure'] = 'ຖ້າເຊີບເວີຍອມຮັບພຽງແຕ່ການເຊື່ອມຕໍ່ກັບ https ມັນຖືກແນະນໍາໃຫ້ເປີດໃຊ້ການສົ່ງຄຸກກີ້ທີ່ປອດໄພ. ຖ້າເປີດໃຊ້ງານແລ້ວກະລຸນາກວດໃຫ້ແນ່ໃຈວ່າເຊີບເວີເວັບບໍ່ຍອມຮັບ http:// ຫຼື ຕັ້ງການປ່ຽນເສັ້ນທາງຖາວອນໄປຫາທີ່ຢູ່ https:// ແລະໂດຍສະເພາະສົ່ງຫົວເລື່ອງ HSTS. ເມື່ອທີ່ຢູ່ <em>wwwroot</em> ບໍ່ເລີ່ມດ້ວຍ https:// ການຕັ້ງຄ່ານີ້ຈະຖືກລະເລີຍ.';
$string['configcountry'] = 'ຖ້າເຈົ້າຕັ້ງປະເທດຢູ່ບ່ອນນີ້, ຈາກນັ້ນປະເທດນີ້ຈະຖືກເລືອກໂດຍຄ່າເລີ່ມຕົ້ນໃນບັນຊີຜູ້ໃຊ້ໃໝ່. ເພື່ອບັງຄັບໃຫ້ຜູ້ໃຊ້ເລືອກປະເທດ, ພຽງແຕ່ປ່ອຍໃຫ້ສິ່ງນີ້ໄວ້ແບບບໍ່ຕັ້ງຄ່າ.';
$string['configcoursegraceperiodafter'] = 'ຈັດປະເພດລາຍວິຊາທີ່ຜ່ານມາຕາມຄວາມຄືບໜ້າເປັນເວລາຫຼາຍມື້ເຫຼົ່ານີ້ຫຼັງຈາກມື້ສິ້ນສຸດວິຊາ.';
$string['configcoursegraceperiodbefore'] = 'ຈັດປະເພດລາຍວິຊາໃນອະນາຄົດຕາມຄວາມຄືບໜ້າເປັນເວລາຫຼາຍມື້ເຫຼົ່ານີ້ກ່ອນວັນເລີ່ມຕົ້ນລາຍວິຊາ.';
$string['configcourseoverviewfilesext'] = 'ລາຍການສ່ວນຂະຫຍາຍໄຟລ໌ຮູບພາບຫຼັກສູດທີ່ໄດ້ຮັບການອະນຸຍາດດ້ວຍໝາຍຈຸດ.';
$string['configcourseoverviewfileslimit'] = 'ຈຳນວນໄຟລ໌ສູງສຸດທີ່ສາມາດສະແດງໄດ້ຢູ່ຖັດຈາກບົດສະຫຼຸບລາຍວິຊາຢູ່ໃນລາຍຊື່ໜ້າລາຍວິຊາ. ໄຟລ໌ຮູບທໍາອິດທີ່ເພີ່ມເຂົ້າແມ່ນໃຊ້ເປັນຮູບພາບລາຍວິຊາຢູ່ໃນພາບລວມຂອງລາຍວິຊາຢູ່ໃນແຜງໜ້າປັດຂອງຜູ້ໃຊ້; ໄຟລ໌ເພີ່ມເຕີມໃດໜຶ່ງທີ່ໄດ້ສະແດງຢູ່ໃນລາຍການໜ້າລາຍວິຊາເທົ່ານັ້ນ.';
$string['configcourserequestnotify'] = 'ພິມຊື່ຜູ້ໃຊ້ຂອງຜູ້ໃຊ້ ເພື່ອໄດ້ຮັບການແຈ້ງເຕືອນເມື່ອມີການຮ້ອງຂໍລາຍວິຊາໃໝ່.';
$string['configcourserequestnotify2'] = 'ຜູ້ໃຊ້ທີ່ຈະໄດ້ຮັບແຈ້ງເຕືອນເມື່ອມີການຮ້ອງຂໍລາຍວິຊາ. ສະເພາະຜູ້ໃຊ້ທີ່ສາມາດອະນຸມັດການຮ້ອງຂໍລາຍວິຊາແມ່ນໄດ້ລະບຸຢູ່ທີ່ນີ້.';
$string['configcoursesperpage'] = 'ໃສ່ຈຳນວນວິຊາທີ່ຈະສະແດງຕໍ່ໜ້າ ໃນລາຍການລາຍວິຊາ.';
$string['configcourseswithsummarieslimit'] = 'ຈໍານວນວິຊາສູງສຸດທີ່ຈະສະແດງຢູ່ໃນລາຍການລາຍວິຊາລວມທັງບົດສະຫຼຸບກ່ອນກັບຄືນສູ່ລາຍຊື່ທີ່ງ່າຍກວ່າ.';
$string['configcronclionly'] = 'ການແລ່ນ cron ຈາກຕົວທ່ອງເວັບສາມາດເປີດເຜີຍຂໍ້ມູນສິດທິພິເສດໃຫ້ກັບຜູ້ໃຊ້ທີ່ບໍ່ປະສົງອອກນາມ. ດັ່ງນັ້ນ, ມັນຖືກແນະນໍາໃຫ້ໃຊ້ພຽງແຕ່ cron ຈາກເສັ້ນຄໍາສັ່ງ ຫຼື ຕັ້ງລະຫັດຜ່ານ cron ສໍາລັບການເຂົ້າເຖິງຈາກທາງໄກ.';
$string['configcronremotepassword'] = 'ນີ້ໝາຍຄວາມວ່າ ຕົວໜັງສື cron.php ບໍ່ສາມາດເອີ້ນໃຊ້ຈາກໂປຣແກຣມທ່ອງເວັບໄດ້ໂດຍບໍ່ຕ້ອງໃຫ້ລະຫັດຜ່ານໂດຍໃຊ້ຮູບແບບຂອງ URL ຕໍ່ໄປນີ້: URL:<pre> https://site.example.com/admin/cron.php?password=opensesame </pre>ຖ້າສິ່ງນີ້ຖືກປະຫວ່າງໄວ້, ບໍ່ຕ້ອງມີລະຫັດຜ່ານ.';
$string['configcurlcache'] = 'Time-to-live ສໍາລັບແຄດ cURL, ໃນວິນາທີ.';
$string['configcustommenuitems'] = 'ເມນູແບບກຳນົດເອງອາດຈະຖືກກຳນົດຢູ່ທີ່ນີ້. ໃສ່ແຕ່ລະລາຍການເມນູຢູ່ໃນແຖວໃໝ່ທີ່ມີຮູບແບບ: ຂໍ້ຄວາມເມນູ, ລິ້ງ URL (ທາງເລືອກ, ບໍ່ແມ່ນສຳລັບລາຍການເມນູອັນດັບຕົ້ນທີ່ມີລາຍການຍ່ອຍ), ຊື່ຄຳແນະນຳເຄື່ອງມື (ທາງເລືອກ) ແລະ ລະຫັດພາສາຫຼື ລາຍການລະຫັດທີ່ຂັ້ນດ້ວຍໝາຍຈຸດ (ທາງເລືອກ, ສໍາລັບການສະແດງເສັ້ນໃຫ້ກັບຜູ້ໃຊ້ຂອງພາສາທີ່ລະບຸໄວ້ເທົ່ານັ້ນ), ແຍກດ້ວຍຕົວອັກສອນທໍ່. ແຖວເລີ່ມຕົ້ນດ້ວຍຂີດຕໍ່ຈະປະກົດເປັນລາຍການລາຍການຢູ່ໃນເມນູລະດັບສູງສຸດກ່ອນໜ້າ ແລະ ### ເຮັດຕົວຂັ້ນ. ຍົກຕົວຢ່າງ:
<pre>
ວິຊາ
-ວິຊາທັງໝົດ |/course/
-ຄົ້ນຫາວິຊາ | /course/search.php
-###
-ຄຳຖາມທີ່ມັກຖາມເລື້ອຍໆ (FAQ)|https://someurl.xyz/faq
-Preguntas más frecuentes|https://someurl.xyz/pmf||es
ແອັບມືຖື|https://someurl.xyz/app|ດາວໂຫຼດແອັບຂອງພວກເຮົາ
</pre>';
$string['configcustomusermenuitems'] = 'ທ່ານສາມາດກຳນົດເນື້ອໃນຂອງເມນູຜູ້ໃຊ້ (ຍົກເວັ້ນລິ້ງອອກຈາກລະບົບ, ເຊິ່ງເພີ່ມໂດຍອັດຕະໂນມັດ). ແຕ່ລະແຖວແມ່ນແຍກກັນດ້ວຍຕົວອັກສອນທໍ່ ແລະ ປະກອບດ້ວຍ 1) ສະຕຣິງຢູ່ໃນຮູບແບບ "langstringname, componentname" ຫຼືເປັນຕົວໜັງສືທໍາມະດາ, 2) URL. ຕົວແບ່ງສາມາດໃຊ້ໄດ້ໂດຍການເພີ່ມແຖວໜຶ່ງ ຫຼື ຫຼາຍກວ່າ # ຕົວອັກສອນໃສ່ບ່ອນທີ່ຕ້ອງການ.';
$string['configdbsessions'] = 'ຖ້າເປີດໃຊ້ງານ, ການຕັ້ງຄ່ານີ້ຈະໃຊ້ຖານຂໍ້ມູນເພື່ອເກັບຮັກສາຂໍ້ມູນກ່ຽວກັບເຊດຊັນປະຈຸບັນ. ກະລຸນາຮັບຊາບວ່າ ການປ່ຽນການຕັ້ງຄ່ານີ້ດຽວນີ້ຈະເອົາຜູ້ໃຊ້ທັງໝົດໃນປະຈຸບັນອອກໄປ (ລວມທັງຕົວທ່ານ). ຖ້າທ່ານກໍາລັງໃຊ້ MySQL ກະລຸນາກວດໃຫ້ແນ່ໃຈວ່າ \'max_allowed_packet\' ຢູ່ໃນ my.cnf (ຫຼື my.ini) ແມ່ນຢ່າງ ໜ້ອຍ 4M. ໄດຣເວີເຊດຊັນອື່ນສາມາດຖືກກຳນົດໂດຍກົງໃນ config.php, ເບິ່ງ config-dist.php ສຳລັບຂໍ້ມູນເພີ່ມເຕີມ. ຕົວເລືອກນີ້ຈະຫາຍໄປຖ້າເຈົ້າລະບຸຕົວຄວບຄຸມເຊດຊັນໃນແຟ້ມ config.php.';
$string['configdebug'] = 'ຖ້າທ່ານເປີດສິ່ງນີ້, ຫຼັງຈາກນັ້ນການລາຍງານຂໍ້ຜິດພາດ (error_reporting) ຂອງ PHP ຈະເພີ່ມຂຶ້ນເພື່ອໃຫ້ມີການພິມຄໍາເຕືອນຫຼາຍຂຶ້ນ. ອັນນີ້ເປັນປະໂຫຍດສະເພາະຜູ້ພັດທະນາ.';
$string['configdebugdisplay'] = 'ຕັ້ງເປັນເປີດ, ການລາຍງານຄວາມຜິດພາດຈະໄປຫາໜ້າ HTML. ອັນນີ້ແມ່ນໃຊ້ໄດ້ແທ້, ແຕ່ທຳລາຍຫົວຂໍ້ XHTML, JS, ຄຸກກີ້ ແລະ HTTP ໂດຍທົ່ວໄປ. ຕັ້ງເປັນປິດ, ມັນຈະສົ່ງຜົນໄດ້ຮັບໄປຫາບັນທຶກຂອງເຊີບເວີຂອງທ່ານ, ອະນຸຍາດໃຫ້ແກ້ໄຂບັນຫາໄດ້ດີກວ່າ. ການຕັ້ງຄ່າ PHP error_log ຄວບຄຸມວ່າບັນທຶກອັນນີ້ໄປຫາຫຍັງ.';
$string['configdebugpageinfo'] = 'ເປີດນຳໃຊ້ຖ້າເຈົ້າຕ້ອງການພິມຂໍ້ມູນໜ້າຢູ່ໃນສ່ວນທ້າຍໜ້າ.';
$string['configdebugvalidators'] = 'ເປີດນຳໃຊ້ຖ້າເຈົ້າຕ້ອງການມີລິ້ງຫາເຊີບເວີຕົວຮັບຮອງຄວາມຖືກຕ້ອງພາຍນອກຢູ່ໃນສ່ວນທ້າຍໜ້າ. ທ່ານອາດຈະຕ້ອງສ້າງຜູ້ໃຊ້ໃໝ່ດ້ວຍຊື່ຜູ້ໃຊ້ <em>w3cvalidator</em>, ແລະ ເປີດການເຂົ້າຫາແຂກ. ການປ່ຽນແປງເຫຼົ່ານີ້ ອາດຈະອະນຸຍາດໃຫ້ເຂົ້າເຖິງເຊີບເວີທີ່ບໍ່ໄດ້ຮັບອະນຸຍາດ, ຢ່າເປີດໃຊ້ງານຢູ່ໃນບ່ອນຜະລິດ!';
$string['configdefaulthomepage'] = 'ໜ້າໃດທີ່ຜູ້ໃຊ້ຄວນຖືກໂອນໄປຫາຫຼັງຈາກເຂົ້າສູ່ລະບົບເວັບໄຊທ໌? ການຕັ້ງຄ່າຍັງກໍານົດການເຊື່ອມຕໍ່ທໍາອິດໃນການນໍາທາງສໍາລັບຜູ້ໃຊ້ຂອງຮູບແບບຄລາສສິກ.';
$string['configdefaultrequestcategory'] = 'ຫຼັກສູດທີ່ຜູ້ໃຊ້ຮ້ອງຂໍດ້ວຍຄວາມສາມາດໃນການຮ້ອງຂໍລາຍວິຊາໃໝ່ໃນສະພາບການຂອງລະບົບຈະຖືກຈັດໃສ່ໃນປະເພດນີ້ ເວັ້ນເສຍແຕ່ວ່າຜູ້ໃຊ້ສາມາດເລືອກປະເພດອື່ນໄດ້.';
$string['configdefaultrequestedcategory'] = 'ປະເພດເລີ່ມຕົ້ນເພື່ອວາງລາຍວິຊາທີ່ໄດ້ຮ້ອງຂໍເຂົ້າໄປ, ຖ້າພວກເຂົາໄດ້ຮັບການອະນຸມັດ.';
$string['configdefaultuserroleid'] = 'ຜູ້ໃຊ້ທັງໝົດທີ່ເຂົ້າສູ່ລະບົບແລ້ວ ຈະໄດ້ຮັບຄວາມສາມາດຂອງໜ້າທີ່ທີ່ທ່ານລະບຸຢູ່ທີ່ນີ້, ຢູ່ໃນລະດັບເວັບໄຊທ໌, ນອກເໜືອຈາກໜ້າທີ່ອື່ນໆໃດໜຶ່ງ ພວກເຂົາອາດຈະໄດ້ຮັບ. ຄ່າເລີ່ມຕົ້ນແມ່ນໜ້າທີ່ຜູ້ໃຊ້ທີ່ໄດ້ຮັບການກວດສອບຄວາມຖືກຕ້ອງແລ້ວ. ກະລຸນາຮັບຊາບວ່າສິ່ງນີ້ຈະບໍ່ຂັດແຍ້ງກັບບົດບາດອື່ນທີ່ເຂົາເຈົ້າມີເວັ້ນເສຍແຕ່ວ່າເຈົ້າຈະຫ້າມຄວາມສາມາດ, ມັນພຽງແຕ່ຮັບປະກັນວ່າ ຜູ້ໃຊ້ທຸກຄົນມີຄວາມສາມາດທີ່ບໍ່ສາມາດແຕ່ງຕັ້ງໄດ້ໃນລະດັບລາຍວິຊາ (ຕົວຢ່າງ: ໂພສລາຍການບລ໋ອກ, ຈັດການປະຕິທິນຂອງຕົນເອງ, ແລະອື່ນໆ).';
$string['configdeleteincompleteusers'] = 'ຫຼັງຈາກໄລຍະເວລານີ້, ບັນຊີໃດໜຶ່ງທີ່ບໍ່ມີຊື່, ນາມສະກຸນ ຫຼື ອີເມລຕື່ມໃສ່ແມ່ນຈະຖືກລຶບອອກ.';
$string['configdeleteunconfirmed'] = 'ສໍາລັບວິທີການກວດສອບຄວາມຖືກຕ້ອງທີ່ແນ່ນອນ, ເຊັ່ນ: ການລົງທະບຽນດ້ວຍຕົນເອງໂດຍອີງໃສ່ອີເມລຜູ້ໃຊ້ (email-based self-registration), ຜູ້ໃຊ້ຕ້ອງຢືນຢັນບັນຊີຂອງເຂົາເຈົ້າພາຍໃນເວລາທີ່ແນ່ນອນ. ຫຼັງຈາກໄລຍະເວລານີ້, ບັນຊີເກົ່າທີ່ບໍ່ໄດ້ຢືນຢັນຈະຖືກລຶບອອກ.';
$string['configdenyemailaddresses'] = 'ເພື່ອປະຕິເສດທີ່ຢູ່ອີເມລຈາກໂດເມນສະເພາະໃຫ້ເຮັດລາຍຊື່ພວກມັນຢູ່ບ່ອນນີ້ໃນແບບດຽວກັນ. ໂດເມນອື່ນທັງໝົດຈະຖືກຍອມຮັບ. ເພື່ອປະຕິເສດໂດເມນຍ່ອຍເພີ່ມໂດເມນທີ່ມີຕົວອັກສອນກ່ອນໜ້າ \'.\'. ຕົວຢ່າງ: <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'ປິດໃຊ້ງານຄວາມສາມາດຂອງຜູ້ໃຊ້ເພື່ອປ່ຽນຮູບໂປຼໄຟລ໌ຜູ້ໃຊ້.';
$string['configdisplayloginfailures'] = 'ສິ່ງນີ້ຈະສະແດງຂໍ້ມູນໃຫ້ກັບຜູ້ໃຊ້ກ່ຽວກັບການເຂົ້າສູ່ລະບົບກ່ອນໜ້ານີ້ທີ່ບໍ່ສໍາເລັດ.';
$string['configdndallowtextandlinks'] = 'ເປີດໃຊ້ງານ ຫຼື ປິດໃຊ້ງານການລາກ ແລະ ວາງຂໍ້ຄວາມ ແລະ ການເຊື່ອມຕໍ່ໃສ່ໜ້າລາຍວິຊາ, ຄຽງຄູ່ກັບການລາກ ແລະ ວາງໄຟລ໌. ກະລຸນາຮັບຊາບວ່າ ການລາກຕົວ ໜັງສືເຂົ້າໄປໃນ Firefox ຫຼື ລະຫວ່າງໂປຼແກຼມທ່ອງເວັບທີ່ແຕກຕ່າງກັນແມ່ນບໍ່ ໜ້າເຊື່ອຖືໄດ້ ແລະ ອາດຈະສົ່ງຜົນໃຫ້ບໍ່ມີການອັບໂຫຼດຂໍ້ມູນ, ຫຼື ຂໍ້ຄວາມເສຍຫາຍຖືກອັບໂຫຼດ.';
$string['configdoclang'] = 'ພາສານີ້ຈະຖືກໃຊ້ໃນລິ້ງສໍາລັບໜ້າຕ່າງໆຂອງເອກະສານ.';
$string['configdocroot'] = 'ກໍານົດເສັ້ນທາງໄປຫາ Moodle Docs ສໍາລັບການສະໜອງເອກະສານສະເພາະທາງຜ່ານລິ້ງ \'ຊ່ວຍເຫຼືອ ແລະ ເອກະສານ\' ຢູ່ໃນສ່ວນທ້າຍຂອງແຕ່ລະໜ້າ. ຖ້າຊ່ອງຫວ່າງຖືກປ່ອຍໄວ້, ລິ້ງຕ່າງໆຈະບໍ່ຖືກສະແດງ.';
$string['configdoctonewwindow'] = 'ຖ້າເປີດນຳໃຊ້, ຈາກນັ້ນລິ້ງໄປຫາ Moodle Docs ຈະສະແດງຂຶ້ນຢູ່ໃນໜ້າຈໍໃໝ່.';
$string['configeditordictionary'] = 'ຄ່ານີ້ຈະຖືກໃຊ້ຖ້າ aspell ບໍ່ມີວັດຈະນານຸກົມສໍາລັບຜູ້ໃຊ້ພາສາຂອງຕົນເອງ.';
$string['configeditorfontlist'] = 'ເລືອກຕົວອັກສອນທີ່ຄວນຈະປາກົດຢູ່ໃນລາຍການເລື່ອນລົງຂອງຕົວແກ້ໄຂ.';
$string['configemailchangeconfirmation'] = 'ຕ້ອງການຂັ້ນຕອນການຢືນຢັນອີເມລເມື່ອຜູ້ໃຊ້ປ່ຽນທີ່ຢູ່ອີເມລຢູ່ໃນໂປຼໄຟລ໌ຂອງພວກເຂົາ.';
$string['configemaildkimselector'] = 'ຕົວເລືອກ DKIM ແມ່ນເລືອກໄດ້ເອງ ແລະ ບັນທຶກ DNS ຂອງທ່ານຕ້ອງກົງກັບອັນນີ້.';
$string['configemailfromvia'] = 'ຕື່ມຂໍ້ມູນຜ່ານພາກ "ຈາກ" ຂອງອີເມວຂາອອກ. ອັນນີ້ແຈ້ງບອກຜູ້ຮັບຈາກບ່ອນທີ່ອີເມລນີ້ມາຈາກ ແລະ ຍັງຊ່ວຍຕ້ານກັບຜູ້ຮັບທີ່ຕອບກັບໄປຫາທີ່ຢູ່ອີເມລທີ່ບໍ່ມີການຕອບຄືນໂດຍບັງເອີນ.';
$string['configemailheaders'] = 'ສ່ວນຫົວຂອງອີເມລດິບທີ່ຈະຖືກຕື່ມຄໍາໃສ່ກັບທຸກອີເມວຂາອອກ.';
$string['configemailsubjectprefix'] = 'ຂໍ້ຄວາມທີ່ຈະນຳໜ້າໄປແຖວຫົວຂໍ້ຂອງຈົດໝາຍຂາອອກທັງໝົດ.';
$string['configenableactivitychooser'] = 'ຕົວເລືອກກິດຈະກຳແມ່ນກ່ອງໂຕ້ຕອບທີ່ມີຄຳອະທິບາຍສັ້ນຂອງແຕ່ລະກິດຈະກຳ ແລະ ແຫຼ່ງຂໍມູນ. ຖ້າປິດໃຊ້ງານ, ໄດ້ມີການສະໜອງເມນູແບບເລື່ອນລົງຂອງແຫຼ່ງຂໍ້ມູນ ແລະ ກິດຈະກໍາແຍກຕ່າງຫາກ.';
$string['configenableanalytics'] = 'ຮູບແບບການວິເຄາະ, ເຊັ່ນ: \'ນັກຮຽນມີຄວາມສ່ຽງທີ່ຈະອອກໂຮງຮຽນ\' ຫຼື \'ຄົບກຳນົດກິດຈະກໍາທີ່ຈະມາຮອດ\', ສາມາດສ້າງການຄາດຄະເນ, ສົ່ງການແຈ້ງເຕືອນຄວາມເຂົ້າໃຈ ແລະ ສະເໜີ ການດໍາເນີນການຕໍ່ໄປເຊັ່ນ: ຜູ້ໃຊ້ສົ່ງຂໍ້ຄວາມ.';
$string['configenableblogs'] = 'ການສະຫຼັບນີ້ໃຫ້ຜູ້ໃຊ້ເວັບໄຊທ໌ທັງຫມົດທີ່ມີບລ໋ອກຂອງພວກເຂົາເອງ.';
$string['configenablecalendarexport'] = 'ເປີດໃຊ້ງານການສົ່ງອອກ ຫຼື ການສະໝັກໃຊ້ປະຕິທິນ.';
$string['configenablecomments'] = 'ຄຳເຫັນເປີດໃຊ້ງານ';
$string['configenablecourserequests'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ທີ່ມີຄວາມສາມາດຮ້ອງຂໍລາຍວິຊາໃໝ່ (moodle/course:request) ຈະມີທາງເລືອກທີ່ຈະຂໍລາຍວິຊາ. ຄວາມສາມາດນີ້ບໍ່ໄດ້ຮັບອະນຸຍາດສໍາລັບບົດບາດເລີ່ມຕົ້ນໃດໆ. ມັນອາດຈະຖືກນຳໃຊ້ໃນສະພາບການຂອງລະບົບ ຫຼື ປະເພດ.';
$string['configenabledevicedetection'] = 'ເປີດໃຊ້ງານການກວດຫາມືຖື, ສະມາດໂຟນ, ແທັບເລັດ ຫຼືອຸປະກອນເລີ່ມຕົ້ນ (ຄອມພິວເຕີຕັ້ງໂຕະ, ແລັບທັອບ, ແລະອື່ນ) ສຳລັບການນຳໃຊ້ຮູບແບບສີສັນ ແລະ ຄຸນສົມບັດອື່ນໆ.';
$string['configenablemobilewebservice'] = 'ເປີດໃຊ້ງານການບໍລິການມືຖືສໍາລັບແອັບ Moodle ຢ່າງເປັນທາງການ ຫຼື ແອັບອື່ນທີ່ຮ້ອງຂໍມັນ. ສໍາລັບຂໍ້ມູນເພີ່ມເຕີມ, ອ່ານ {$a}';
$string['configenablerssfeeds'] = 'ຖ້າເປີດນຳໃຊ້ແລ້ວ, RSS ຟີດ ຖືກສ້າງຂຶ້ນໂດຍລັກສະນະຕ່າງໆຢູ່ທົ່ວເວັບໄຊທ໌, ເຊັ່ນ: ບລ໋ອກ, ເວທີສົນທະນາ, ກິດຈະກໍາຖານຂໍ້ມູນ ແລະ ຄໍາອະທິບາຍສັບ. ກະລຸນາຮັບຊາບວ່າ RSS ຟີດ ຍັງຈໍາເປັນຕ້ອງເປີດໃຊ້ງານສໍາລັບຊຸດກິດຈະກໍາສະເພາະ.';
$string['configenablerssfeedsdisabled'] = 'ມັນບໍ່ສາມາດໃຊ້ໄດ້ເພາະວ່າ RSS ຟີດ ຖືກປິດການນຳໃຊ້ໃນທຸກເວັບໄຊທ໌. ເພື່ອເປີດໃຊ້ງານພວກມັນ, ໄປຫາການຕັ້ງຄ່າຕົວແປພາຍໃຕ້ການຕັ້ງຄ່າຜູ້ຄວບຄຸມລະບົບ (Admin Configuration).';
$string['configenablerssfeedsdisabled2'] = 'ດຽວນີ້ RSS ຟີດ ຖືກປິດການນຳໃຊ້ຢູ່ໃນລະດັບເວັບໄຊທ໌. ພວກມັນອາດຈະຖືກເປີດນຳໃຊ້ໃນຄຸນສົມບັດຂັ້ນສູງໃນການບໍລິຫານເວັບໄຊທ໌.';
$string['configenablestats'] = 'ຖ້າເຈົ້າເລືອກ \'ແມ່ນ\' ຢູ່ທີ່ນີ້, cronjob ຂອງ Moodle ຈະດໍາເນີນການບັນທຶກຂໍ້ມູນ ແລະ ເກັບກໍາສະຖິຕິບາງອັນ. ແມ່ນຂຶ້ນຢູ່ກັບປະລິມານຂອງການສັນຈອນຢູ່ໃນເວັບໄຊທ໌ຂອງທ່ານ, ສິ່ງນີ້ສາມາດໃຊ້ເວລາຈັກໜ້ອຍ. ຖ້າທ່ານເປີດໃຊ້ງານສິ່ງນີ້, ທ່ານຈະສາມາດເຫັນເສັ້ນສະແດງ ແລະ ສະຖິຕິທີ່ໜ້າສົນໃຈກ່ຽວກັບແຕ່ລະລາຍວິຊາຂອງທ່ານ, ຫຼື ໃນພື້ນທີ່ທົ່ວເວັບໄຊທ໌.';
$string['configenabletrusttext'] = 'ຕາມຄ່າເລີ່ມຕົ້ນ, Moodle ຈະເຮັດຄວາມສະອາດຢ່າງລະອຽດທຸກເທື່ອທີ່ມາຈາກຜູ້ໃຊ້ເພື່ອລຶບສະຄຣິບທີ່ບໍ່ດີ, ສື່ ແລະ ອື່ນໆທີ່ອາດເປັນຄວາມສ່ຽງດ້ານຄວາມປອດໄພ. ລະບົບເນື້ອຫາທີ່ເຊື່ອຖືໄດ້ ແມ່ນວິທີການໃຫ້ຜູ້ໃຊ້ໂດຍສະເພາະທີ່ທ່ານໄວ້ວາງໃຈໃນຄວາມສາມາດທີ່ຈະລວມເອົາຄຸນສົມບັດຂັ້ນສູງເຫຼົ່ານີ້ໃສ່ໃນເນື້ອຫາຂອງພວກເຂົາ ໂດຍບໍ່ມີການແຊກແຊງ. ເພື່ອເປີດໃຊ້ລະບົບນີ້, ທໍາອິດເຈົ້າຕ້ອງເປີດໃຊ້ງານການຕັ້ງຄ່ານີ້, ແລະ ຈາກນັ້ນໃຫ້ການອະນຸຍາດເນື້ອໃນທີ່ເຊື່ອຖືໄດ້ກັບໜ້າທີ່ Moodle ສະເພາະ. ຂໍ້ຄວາມທີ່ສ້າງຂຶ້ນ ຫຼື ອັບໂຫຼດໂດຍຜູ້ໃຊ້ດັ່ງກ່າວຈະຖືກໝາຍວ່າເຊື່ອຖືໄດ້ ແລະ ຈະບໍ່ຖືກອະນາໄມກ່ອນການສະແດງ.';
$string['configenablewebservices'] = 'ການບໍລິການເວັບເປີດໃຊ້ລະບົບອື່ນ, ເຊັ່ນ: ແອັບ Moodle, ເພື່ອເຂົ້າສູ່ລະບົບຫາເວັບໄຊທ໌ ແລະ ປະຕິບັດການດໍາເນີນງານ. ເພື່ອຄວາມປອດໄພພິເສດ, ການຕັ້ງຄ່າຄວນຖືກປິດໃຊ້ງານຖ້າເຈົ້າບໍ່ໄດ້ໃຊ້ແອັບ ຫຼື ເຄື່ອງມື/ການບໍລິການພາຍນອກທີ່ຕ້ອງການການລວມເຂົ້າກັນຜ່ານການບໍລິການເວັບ.';
$string['configenablewsdocumentation'] = 'ເປີດໃຊ້ງານເອກະສານການບໍລິການເວັບສ້າງຂຶ້ນອັດຕະໂນມັດ. ຜູ້ໃຊ້ສາມາດເຂົ້າຫາເອກະສານຂອງລາວເອງຢູ່ໃນໜ້າກະແຈຄວາມປອດໄພ {$a} ຂອງລາວ. ມັນສະແດງເອກະສານສໍາລັບລະບຽບໂປຣໂຕຄໍທີ່ເປີດໃຊ້ງານເທົ່ານັ້ນ.';
$string['configerrorlevel'] = 'ເລືອກປະລິມານການເຕືອນ PHP ທີ່ທ່ານຕ້ອງການສະແດງ. ປົກກະຕິແລ້ວເປັນທາງເລືອກທີ່ດີທີ່ສຸດ.';
$string['configexportlookahead'] = 'ມື້ທີ່ຈະເບິ່ງລ່ວງໜ້າໃນລະຫວ່າງການສົ່ງອອກ';
$string['configexportlookback'] = 'ມື້ທີ່ຈະເບິ່ງຄືນຫຼັງໃນລະຫວ່າງການສົ່ງອອກ';
$string['configextendedusernamechars'] = 'ຖ້າເປີດໃຊ້ແລ້ວ, ຊື່ຜູ້ໃຊ້ອາດຈະລວມມີຕົວອັກສອນໃດໜຶ່ງຍົກເວັ້ນຕົວອັກສອນໃຫຍ່. ບໍ່ດັ່ງນັ້ນ, ອະນຸຍາດໃຫ້ໃຊ້ສະເພາະຕົວອັກສອນທີ່ມີຕົວອັກສອນຕົວພິມນ້ອຍ, ຂີດກ້ອງ (_), ຂີດຕໍ່ (-), ເຄື່ອງໝາຍຈໍ້າ (.) ແລະ ເຄື່ອງໝາຍ (@) ເທົ່ານັ້ນ.';
$string['configextramemorylimit'] = 'ບາງສະຄິບເຊັ່ນ: ການຄົ້ນຫາ, ການສຳຮອງຂໍ້ມູນ/ການກູ້ຄືນ ຫຼື  cron ຈຳເປັນຕ້ອງມີຄວາມຈຳເພີ່ມເຕີມ. ຕັ້ງຄ່າທີ່ສູງກວ່າສຳ ລັບເວັບໄຊທ໌ໃຫຍ່.';
$string['configfilterall'] = 'ຕົວກັ່ນຕອງສະຕຣິງທັງໝົດ, ລວມທັງຫົວຂໍ້, ຊື່ເລື່ອງ, ແຖບນຳ ທາງ ແລະ ອື່ນໆ. ສິ່ງນີ້ສ່ວນໃຫຍ່ຈະເປັນປະໂຫຍດເມື່ອໃຊ້ຕົວກອງຫຼາຍອັນ, ຖ້າບໍ່ດັ່ງນັ້ນມັນພຽງແຕ່ຈະສ້າງການໂຫຼດພິເສດໃສ່ໃນເວັບໄຊທ໌ຂອງທ່ານເພື່ອການເພີ່ມຂື້ນພຽງເລັກນ້ອຍ.';
$string['configfiltermatchoneperpage'] = 'ຕົວກັ່ນຕອງການເຊື່ອມໂຍງອັດຕະໂນມັດຈະສ້າງລິ້ງອັນດຽວສໍາລັບຕົວຢ່າງຂໍ້ຄວາມທີ່ກົງກັນທໍາອິດທີ່ພົບຢູ່ໃນໜ້າທີ່ສົມບູນ. ອັນອື່ນທັງໝົດຈະຖືກລະເລີຍ.';
$string['configfiltermatchonepertext'] = 'ຕົວກັ່ນຕອງການເຊື່ອມໂຍງອັດຕະໂນມັດຈະສ້າງລິ້ງອັນດຽວສໍາລັບຕົວຢ່າງຂໍ້ຄວາມທີ່ກົງກັນທໍາອິດທີ່ພົບຢູ່ໃນແຕ່ລະລາຍການຂອງຂໍ້ຄວາມຢູ່ໃນໜ້າ. ອັນອື່ນທັງໝົດຈະຖືກລະເລີຍ. ການຕັ້ງຄ່ານີ້ບໍ່ມີຜົນຖ້າ \'ຕົວກັ່ນຕອງກົງກັນຄັ້ງດຽວຕໍ່ໜຶ່ງໜ້າ\' ຖືກເປີດໃຊ້ງານ.';
$string['configfilternavigationwithsystemcontext'] = 'ການນໍາໃຊ້ປົກກະຕິຂອງການກັ່ນຕອງ ແມ່ນຜູກມັດກັບສະພາບການທີ່ມັນຖືກນໍາໃຊ້ (ເຊັ່ນ: ບໍລິບົດ), ແຕ່ສໍາລັບການນໍາທາງເວັບໄຊທ໌, ການສ້າງການກັ່ນຕອງທຸກຢ່າງກັບບໍລິບົດຂອງເວັບໄຊທ໌ ສາມາດປັບປຸງປະສິດທິພາບໃນເວລາທີ່ໃຊ້ການກັ່ນຕອງ "ເນື້ອຫາ ແລະ ຫົວຂໍ້".';
$string['configfilteruploadedfiles'] = 'ປະມວນຜົນໄຟລ໌ HTML ແລະ ຂໍ້ຄວາມທີ່ອັບໂຫຼດທັງໝົດດ້ວຍຕົວກັ່ນຕອງກ່ອນທີ່ຈະສະແດງພວກມັນ, ພຽງແຕ່ອັບໂຫຼດໄຟລ໌ HTML ຫຼື ບໍ່ມີເລີຍ.';
$string['configforcelogin'] = 'ໂດຍປົກກະຕິແລ້ວ, ໜ້າຫຼັກຂອງເວັບໄຊທ໌ ແລະ ລາຍຊື່ວິຊາ (ແຕ່ບໍ່ແມ່ນວິຊາ) ສາມາດອ່ານໄດ້ໂດຍບໍ່ຕ້ອງເຂົ້າສູ່ລະບົບເວັບໄຊທ໌. ຖ້າທ່ານຕ້ອງການບັງຄັບໃຫ້ຄົນເຂົ້າສູ່ລະບົບກ່ອນທີ່ເຂົາເຈົ້າຈະເຮັດອັນໃດອັນໜຶ່ງຢູ່ໃນເວັບໄຊທ໌, ທ່ານຄວນເປີດໃຊ້ງານການຕັ້ງຄ່ານີ້.';
$string['configforceloginforprofiles'] = 'ການຕັ້ງຄ່ານີ້ບັງຄັບໃຫ້ຄົນເຂົ້າສູ່ລະບົບເປັນບັນຊີຈິງ (ບໍ່ແມ່ນແຂກ) ກ່ອນທີ່ຈະເບິ່ງໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້ໃດໜຶ່ງ. ຖ້າທ່ານປິດໃຊ້ງານການຕັ້ງຄ່ານີ້, ທ່ານອາດຈະເຫັນວ່າຜູ້ໃຊ້ບາງຄົນປະກາດການໂຄສະນາ (ສະແປມ) ຫຼື ເນື້ອໃນທີ່ບໍ່ເໝາະສົມອື່ນໆຢູ່ໃນໂປຼໄຟລ໌ຂອງເຂົາເຈົ້າ, ເຊິ່ງຕໍ່ມາສາມາດເຫັນໄດ້ທົ່ວໂລກ.';
$string['configfrontpage'] = 'ລາຍການທີ່ເລືອກໄວ້ຂ້າງເທິງຈະຖືກສະແດງຢູ່ໜ້າຫຼັກຂອງເວັບໄຊທ໌.';
$string['configfrontpagecourselimit'] = 'ຈຳນວນລາຍວິຊາສູງສຸດ';
$string['configfrontpagecourselimithelp'] = 'ຈຳນວນວິຊາສູງສຸດທີ່ຈະສະແດງຢູ່ໜ້າຫຼັກຂອງເວັບໄຊທ໌ໃນລາຍການວິຊາ.';
$string['configfrontpageloggedin'] = 'ລາຍການທີ່ເລືອກໄວ້ຂ້າງເທິງຈະຖືກສະແດງຢູ່ໜ້າທໍາອິດຂອງເວັບໄຊທ໌ເມື່ອຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບ.';
$string['configfullnamedisplay'] = 'ສິ່ງນີ້ກຳນົດວ່າຈະສະແດງຊື່ແນວໃດເມື່ອພວກມັນຖືກສະແດງເຕັມ. ຄ່າເລີ່ມຕົ້ນ, "ພາສາ", ປະມັນໄວ້ໃນສະຕຣິງ "fullnamedisplay" ໃນຊຸດພາສາປັດຈຸບັນເພື່ອຕັດສິນໃຈ. ບາງພາສາມີສົນທິສັນຍາສະແດງຊື່ທີ່ແຕກຕ່າງກັນ.

ສໍາລັບເວັບໄຊທ໌ທີ່ໃຊ້ພາສາດຽວສ່ວນໃຫຍ່ການຕັ້ງຄ່າທີ່ມີປະສິດທິພາບທີ່ສຸດແມ່ນ "ຊື່ ນາມສະກຸນ", ແຕ່ທ່ານອາດຈະເລືອກທີ່ຈະເຊື່ອງນາມສະກຸນທັງໝົດ. ຕົວຍຶດບ່ອນທີ່ສາມາດໃຊ້ໄດ້ຄື: ຊື່ແທ້ (firstname), ນາມສະກຸນ (lastname), ການອອກສຽງຊື່ (firstnamephonetic), ນາມສະກຸນການອອກສຽງ (lastnamephonetic), ຊື່ກາງ (middlename), ແລະ (ຊື່ສຳຮອງ) alternatename.';
$string['configgeoipfile'] = 'ທີ່ຕັ້ງຂອງໄຟລ໌ຂໍ້ມູນໄບນາລີຂອງເມືອງ GeoLite2. ໄຟລ໌ນີ້ບໍ່ແມ່ນສ່ວນໜຶ່ງຂອງການແຈກຢາຍ Moodle ແລະ ຕ້ອງໄດ້ຮັບແຍກຕ່າງຫາກຈາກ <a href="https://www.maxmind.com/">MaxMind</a>. ທ່ານສາມາດຊື້ສະບັບພາສາການຄ້າ ຫຼື ໃຊ້ສະບັບຟຣີໄດ້. ທ່ານຈະຕ້ອງລົງທະບຽນເພື່ອດາວໂຫຼດໄຟລ໌ຖານຂໍ້ມູນເມືອງ, ເຊິ່ງທ່ານສາມາດເຮັດໄດ້ຢູ່ທີ່ <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. ເມື່ອທ່ານໄດ້ລົງທະບຽນ ແລະ ດາວໂຫຼດໄຟລ໌ແລ້ວ, ແຍກມັນລົງໃນບັນຊີ "{$a}" ຢູ່ໃນເຊີບເວີຂອງທ່ານ.';
$string['configgetremoteaddrconf'] = 'ຖ້າເຊີບເວີຂອງທ່ານຢູ່ເບື້ອງຫຼັງພຣັອກຊີທີ່ປີ້ນກັບ, ທ່ານສາມາດໃຊ້ການຕັ້ງຄ່ານີ້ ເພື່ອລະບຸວ່າສ່ວນຫົວ HTTP ໃດສາມາດໄວ້ໃຈໄດ້ທີ່ມີທີ່ຢູ່ IP ຫ່າງໄກ. ສ່ວນຫົວຖືກອ່ານຕາມລຳ ດັບ, ໂດຍໃຊ້ອັນທຳອິດທີ່ມີຢູ່.';
$string['configgradebookroles'] = 'ການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ທ່ານຄວບຄຸມວ່າໃຜປະກົດຂຶ້ນຢູ່ໃນປຶ້ມຄະແນນ. ຜູ້ໃຊ້ຈໍາເປັນຕ້ອງມີຢ່າງໜ້ອຍໜຶ່ງໜ້າທີ່ເຫຼົ່ານີ້ຢູ່ໃນຫຼັກສູດເພື່ອສະແດງຢູ່ໃນປຶ້ມຄະແນນສໍາລັບລາຍວິຊານັ້ນ.';
$string['configgradeexport'] = 'ເລືອກວ່າຮູບແບບການສົ່ງອອກປຶ້ມຄະແນນເປັນວິທີຫຼັກຂອງທ່ານໃນການສົ່ງຄະແນນອອກ. ຈາກນັ້ນປລັກອິນທີ່ເລືອກໄວ້ຈະຕັ້ງ ແລະ ໃຊ້ຊ່ອງຂໍ້ມູນ "ສົ່ງອອກສຸດທ້າຍ" ສໍາລັບທຸກຄະແນນ. ຕົວຢ່າງ: ສິ່ງນີ້ອາດຈະສົ່ງຜົນໃຫ້ບັນທຶກການສົ່ງອອກຖືກລະບຸວ່າເປັນ "ໃໝ່" ຫຼື "ອັບເດດແລ້ວ". ຖ້າທ່ານບໍ່ແນ່ໃຈກ່ຽວກັບເລື່ອງນີ້ກໍ່ປ່ອຍໃຫ້ທຸກຢ່າງບໍ່ໃຫ້ຖືກຕິກ.';
$string['confighiddenuserfields'] = 'ເລືອກຊ່ອງຂໍ້ມູນຜູ້ໃຊ້ໃດໜຶ່ງທີ່ທ່ານຕ້ອງການເຊື່ອງຈາກຜູ້ໃຊ້ອື່ນທີ່ບໍ່ແມ່ນຄູສອນ/ຜູ້ເບິ່ງແຍງຫຼັກສູດ. ສິ່ງນີ້ຈະເພີ່ມຄວາມເປັນສ່ວນຕົວຂອງນັກຮຽນ. ກົດປຸ່ມ CTRL ຄ້າງໄວ້ເພື່ອເລືອກຫຼາຍຊ່ອງຂໍ້ມູນ.';
$string['configidnumber'] = 'ຕົວເລືອກນີ້ລະບຸວ່າ (ກ) ຜູ້ໃຊ້ບໍ່ໄດ້ຖືກຖາມຫາໝາຍເລກປະຈໍາຕົວເລີຍ, (ຂ) ຜູ້ໃຊ້ຖືກຖາມຫາໝາຍເລກປະຈໍາຕົວແຕ່ສາມາດປະຫວ່າງໄວ້ ຫຼື (ຄ) ຜູ້ໃຊ້ຖືກຖາມຫາໝາຍເລກປະຈໍາຕົວ ແລະ ບໍ່ສາມາດປ່ອຍໃຫ້ມັນຫວ່າງໄດ້. ຖ້າໃຫ້ໝາຍເລກປະຈຳຕົວຜູ້ໃຊ້ຖືກສະແດງຢູ່ໃນໂປຼໄຟລ໌ຂອງພວກເຂົາ.';
$string['configintro'] = 'ຢູ່ໃນໜ້ານີ້, ທ່ານສາມາດກໍານົດຕົວແປການຕັ້ງຄ່າຈໍານວນ ໜຶ່ງທີ່ຊ່ວຍເຮັດໃຫ້ Moodle ເຮັດວຽກໄດ້ຢ່າງຖືກຕ້ອງຢູ່ໃນເຊີບເວີຂອງທ່ານ. ຢ່າກັງວົນຫຼາຍເກີນໄປກ່ຽວກັບມັນ - ຄ່າເລີ່ມຕົ້ນປົກກະຕິແລ້ວຈະເຮັດວຽກໄດ້ດີ ແລະ ທ່ານສາມາດກັບມາຫາໜ້ານີ້ໄດ້ສະເໝີພາຍຫຼັງ ແລະ ປ່ຽນການຕັ້ງຄ່າເຫຼົ່ານີ້.';
$string['configintroadmin'] = 'ຢູ່ໃນໜ້ານີ້ ທ່ານຄວນຕັ້ງຄ່າບັນຊີຜູ້ຄວບຄຸມລະບົບຫຼັກຂອງທ່ານ ເຊິ່ງຈະມີການຄວບຄຸມທັງໝົດຢູ່ໃນເວັບໄຊທ໌. ໃຫ້ແນ່ໃຈວ່າທ່ານໃຫ້ຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານທີ່ປອດໄພພ້ອມທັງທີ່ຢູ່ອີເມລທີ່ຖືກຕ້ອງ. ທ່ານສາມາດສ້າງບັນຊີຜູ້ຄວບຄຸມລະບົບເພີ່ມເຕີມໄດ້ໃນພາຍຫຼັງ.';
$string['configintrosite'] = 'ໜ້ານີ້ອະນຸຍາດໃຫ້ທ່ານຕັ້ງຄ່າໜ້າຫຼັກ ແລະ ຊື່ຂອງເວັບໄຊທ໌ໃໝ່ນີ້. ທ່ານສາມາດກັບມາບ່ອນນີ້ໄດ້ພາຍຫຼັງ ເພື່ອປ່ຽນການຕັ້ງຄ່າເຫຼົ່ານີ້ໄດ້ທຸກເວລາ ໂດຍໃຊ້ເມນູຜູ້ຄວບຄຸມລະບົບ.';
$string['configiplookup'] = 'ເມື່ອທ່ານຄລິກໃສ່ທີ່ຢູ່ IP (ເຊັ່ນ: 34.12.222.93), ເຊັ່ນ: ຢູ່ໃນບັນທຶກ, ທ່ານສະແດງແຜນທີ່ທີ່ມີການຄາດເດົາໄດ້ດີທີ່ສຸດວ່າ IP ນັ້ນຢູ່ໃສ. ມີປລັກອິນທີ່ແຕກຕ່າງກັນສຳລັບສິ່ງນີ້ທີ່ທ່ານສາມາດເລືອກໄດ້, ແຕ່ລະອັນມີຂໍ້ດີ ແລະ ຂໍ້ເສຍປຽບ.';
$string['configkeeptagnamecase'] = 'ກວດເບິ່ງສິ່ງນີ້ ຖ້າທ່ານຕ້ອງການໃຫ້ແທັກຊື່ເພື່ອຮັກສາຕົວອັກສອນເດີມຕາມທີ່ຜູ້ໃຊ້ສ້າງເຂົ້າໄປ';
$string['configlang'] = 'ເລືອກພາສາເລີ່ມຕົ້ນສຳລັບເວັບໄຊທ໌ທັງໝົດ. ຜູ້ໃຊ້ສາມາດລົບລ້າງການຕັ້ງຄ່ານີ້ໄດ້ໂດຍການໃຊ້ເມນູພາສາ ຫຼື ການຕັ້ງຄ່າໃນໂປຼໄຟລ໌ສ່ວນຕົວຂອງພວກເຂົາ.';
$string['configlanglist'] = 'ຖ້າປະຫວ່າງໄວ້, ທຸກພາສາທີ່ຕິດຕັ້ງຢູ່ໃນເວັບໄຊທ໌ຈະຖືກສະແດງຢູ່ໃນເມນູພາສາ. ອີກທາງເລືອກໜຶ່ງ, ເມນູພາສາອາດຈະສັ້ນລົງໂດຍການປ້ອນລາຍການລະຫັດພາສາທີ່ຂັ້ນດ້ວຍເຄື່ອງໝາຍຈຸດເຊັ່ນ: en, de, fr. ຖ້າຕ້ອງການ, ຊື່ທີ່ແຕກຕ່າງຂອງພາສາຫຼາຍກວ່າຊື່ຊຸດພາສາອາດຈະຖືກລະບຸໂດຍໃຊ້ຮູບແບບ: ລະຫັດພາສາ | ຊື່ພາສາເຊັ່ນ: en_kids | ພາສາອັງກິດ, de_kids | Deutsch.';
$string['configlangmenu'] = 'ເລືອກວ່າທ່ານຕ້ອງການສະແດງເມນູພາສາທີ່ມີຈຸດປະສົງທົ່ວໄປຢູ່ໃນໜ້າຫຼັກ, ໜ້າເຂົ້າສູ່ລະບົບ ແລະ ອື່ນໆຫຼືບໍ່. ອັນນີ້ບໍ່ກະທົບກັບຄວາມສາມາດຂອງຜູ້ໃຊ້ໃນການຕັ້ງພາສາທີ່ມັກຢູ່ໃນໂປຼໄຟລ໌ຂອງເຂົາເຈົ້າເອງ.';
$string['configlangstringcache'] = 'ແຄດສະຕິງພາສາທັງໝົດເຂົ້າໄປໃນໄຟລ໌ທີ່ຖືກລວບລວມໄວ້ໃນລະບົບຂໍ້ມູນ. ຖ້າທ່ານກໍາລັງແປ Moodle ຫຼື ປ່ຽນສະຕຣິງຢູ່ໃນລະຫັດແຫຼ່ງຂໍ້ມູນ Moodle ທ່ານອາດຈະຕ້ອງປິດສິ່ງນີ້. ຖ້າບໍ່ດັ່ງນັ້ນ, ປະມັນໄວ້ເພື່ອເບິ່ງຜົນປະໂຫຍດດ້ານການປະຕິບັດ.';
$string['configlatinexcelexport'] = 'ເລືອກການເຂົ້າລະຫັດສໍາລັບການສົ່ງອອກ Excel.';
$string['configlocale'] = 'ເລືອກທ້ອງຖິ່ນທີ່ມີທົ່ວເວັບໄຊທ໌ - ອັນນີ້ຈະລົບລ້າງຮູບແບບແລະ ພາສາຂອງວັນທີສໍາລັບຊຸດພາສາທັງໝົດ (ເຖິງແມ່ນວ່າຊື່ຂອງມື້ຢູ່ໃນປະຕິທິນບໍ່ໄດ້ຮັບຜົນກະທົບ). ທ່ານຕ້ອງມີຂໍ້ມູນທ້ອງຖິ່ນນີ້ຕິດຕັ້ງໃສ່ລະບົບປະຕິບັດການຂອງທ່ານ (ຕົວຢ່າງ: ສໍາລັບ linux en_US.UTF-8 ຫຼື es_ES.UTF-8). ໃນກໍລະນີສ່ວນໃຫຍ່, ຊ່ອງນີ້ຄວນປ່ອຍໃຫ້ຫວ່າງໄວ້.';
$string['configlockrequestcategory'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ທີ່ມີຄວາມສາມາດທີ່ຈະຮ້ອງຂໍຫຼັກສູດໃໝ່ໃນສະພາບລະບົບ ຈະບໍ່ສາມາດເລືອກປະເພດຢູ່ໃນຄໍາຮ້ອງຂໍແບບຟອມລາຍວິຊາໃໝ່ໄດ້. ວິທີທາງເລືອກໜຶ່ງໃນການຈຳກັດຜູ້ໃຊ້ໃນການຮ້ອງຂໍລາຍວິຊາໃໝ່ ໃນພຽງແຕ່ປະເພດແມ່ນການນຳໃຊ້ຄວາມສາມາດໃນການຮ້ອງຂໍຫຼັກສູດໃໝ່ໃນສະພາບການຂອງປະເພດ.';
$string['configloglifetime'] = 'ສິ່ງນີ້ລະບຸໄລຍະເວລາທີ່ທ່ານຕ້ອງການເກັບບັນທຶກກ່ຽວກັບກິດຈະກໍາຂອງຜູ້ໃຊ້. ບັນທຶກທີ່ເກົ່າກວ່າອາຍຸນີ້ຈະຖືກລຶບອອກໂດຍອັດຕະໂນມັດ. ມັນດີທີ່ສຸດທີ່ຈະເກັບບັນທຶກໄວ້ໃຫ້ດົນເທົ່າທີ່ເປັນໄປໄດ້, ໃນກໍລະນີທີ່ທ່ານຕ້ອງການພວກມັນ, ແຕ່ຖ້າທ່ານມີເຊີບເວີທີ່ຫຍຸ້ງຫຼາຍ ແລະ ປະສົບກັບບັນຫາການປະຕິບັດ, ຈາກນັ້ນທ່ານອາດຈະຕ້ອງການຫຼຸດອາຍຸການບັນທຶກລົງ. ຄ່າຕ່ຳກວ່າ 30 ບໍ່ໄດ້ຖືກແນະນຳ ເພາະວ່າສະຖິຕິອາດຈະເຮັດວຽກບໍ່ຖືກຕ້ອງ.';
$string['configlookahead'] = 'ມື້ທີ່ຈະເບິ່ງໄວ້ລ່ວງໜ້າ';
$string['configmailnewline'] = 'ຕົວອັກສອນແຖວໃໝ່ທີ່ໃຊ້ໃນຂໍ້ຄວາມຈົດໝາຍ. ຕ້ອງການ CRLF ອີງຕາມ RFC 822bis, ບາງເຊີບເວີອີເມລເຮັດການປ່ຽນອັດຕະໂນມັດຈາກ LF ເປັນ CRLF, ເຊີບເວີອີເມລອື່ນເຮັດການປ່ຽນທີ່ບໍ່ຖືກຕ້ອງຈາກ CRLF ເປັນ CRCRLF, ແຕ່ຄົນອື່ນປະຕິເສດຈົດໝາຍດ້ວຍ LF ເປົ່າ (ຕົວຢ່າງ: qmail). ລອງປ່ຽນການຕັ້ງຄ່ານີ້ ຖ້າທ່ານມີບັນຫາກັບອີເມລທີ່ບໍ່ໄດ້ສົ່ງ ຫຼື ສາຍໃໝ່ສອງເທື່ອ.';
$string['configmaxbytes'] = 'ສິ່ງນີ້ລະບຸຂະໜາດສູງສຸດສໍາລັບໄຟລ໌ທີ່ອັບໂຫຼດແລ້ວໃສ່ເວັບໄຊທ໌. ການຕັ້ງຄ່ານີ້ຖືກຈໍາກັດໂດຍການຕັ້ງຄ່າ PHP post_max_size ແລະ upload_max_filesize, ເຊັ່ນດຽວກັບການຕັ້ງຄ່າ Apache LimitRequestBody. ໃນທາງກັບກັນ, maxbytes ຈຳກັດຂອບເຂດຂອງຂະໜາດທີ່ສາມາດເລືອກໄດ້ໃນຫຼັກສູດ ຫຼື ລະດັບກິດຈ ກຳ. ຖ້າເລືອກ \'ຂີດຈໍາກັດການອັບໂຫຼດເວັບໄຊທ໌\', ເລືອກໃຊ້ຂະໜາດສູງສຸດທີ່ເຊີບເວີອະນຸຍາດໃຫ້.';
$string['configmaxconsecutiveidentchars'] = 'ລະຫັດຜ່ານຕ້ອງບໍ່ມີຕົວເລກຕິດຕໍ່ກັນຫຼາຍກ່ວາຕົວເລກນີ້. ໃຊ້ 0 ເພື່ອປິດໃຊ້ງານການກວດນີ້.';
$string['configmaxeditingtime'] = 'ສິ່ງນີ້ລະບຸຈໍານວນເວລາທີ່ຄົນຕ້ອງແກ້ໄຂຄືນໃໝ່ຂອງການໂພສໃນເວທີສົນທະນາ, ຄຳເຫັນອະທິບາຍສັບ, ແລະອື່ນໆ. ໂດຍປົກກະຕິແລ້ວ 30 ນາທີແມ່ນຄຸ້ມຄ່າ.';
$string['configmaxevents'] = 'ເຫດການທີ່ຈະເບິ່ງໄປທາງໜ້າ';
$string['configmaxusersperpage'] = 'ຈຳນວນຜູ້ໃຊ້ສູງສຸດສະແດງຢູ່ພາຍໃນຕົວເລືອກຜູ້ໃຊ້ໃນລາຍວິຊາ, ກຸ່ມ, ກຸ່ມຮ່ວມ, ບໍລິການເວັບ ແລະອື່ນໆ.';
$string['configmessaging'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ສາມາດສົ່ງຂໍ້ຄວາມຫາຜູ້ໃຊ້ອື່ນຢູ່ໃນເວັບໄຊທ໌ໄດ້.';
$string['configmessagingallowemailoverride'] = 'ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ມີການແຈ້ງເຕືອນຂໍ້ຄວາມທາງອີເມລ ສົ່ງໄປຫາທີ່ຢູ່ອີເມລອື່ນ ນອກຈາກທີ່ຢູ່ອີເມລຢູ່ໃນໂປຼໄຟລ໌ຂອງເຂົາເຈົ້າ';
$string['configmessagingallusers'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ສາມາດເບິ່ງລາຍຊື່ຜູ້ໃຊ້ທັງໝົດຢູ່ໃນເວັບໄຊທ໌ ເມື່ອເລືອກຜູ້ໃດຜູ້ໜຶ່ງເພື່ອສົ່ງຂໍ້ຄວາມ, ແລະ ການຕັ້ງຄ່າຄວາມມັກຂໍ້ຄວາມຂອງເຂົາເຈົ້າ ລວມມີທາງເລືອກທີ່ຈະຮັບເອົາຂໍ້ຄວາມຈາກຜູ້ໃດຢູ່ໃນເວັບໄຊທ໌. ຖ້າປິດໃຊ້ງານ, ຜູ້ໃຊ້ສາມາດເບິ່ງລາຍຊື່ຜູ້ໃຊ້ຢູ່ໃນລາຍວິຊາຂອງເຂົາເຈົ້າເທົ່ານັ້ນ, ແລະ ເຂົາເຈົ້າມີພຽງສອງທາງເລືອກຢູ່ໃນການຕັ້ງຄ່າຄວາມມັກຂໍ້ຄວາມ - ເພື່ອຍອມຮັບເອົາຂໍ້ຄວາມຈາກຜູ້ຕິດຕໍ່ຂອງເຂົາເຈົ້າເທົ່ານັ້ນ, ຫຼື ລາຍຊື່ຜູ້ຕິດຕໍ່ຂອງເຂົາເຈົ້າ ແລະ ຜູ້ໃດກໍ່ຕາມຢູ່ໃນລາຍວິຊາຂອງເຂົາເຈົ້າ.';
$string['configmessagingdefaultpressenter'] = 'ບໍ່ວ່າຈະ \'ໃຊ້ການເຂົ້າເພື່ອສົ່ງ\' ຖືກເປີດໃຊ້ຕາມຄ່າມາດຕະຖານຢູ່ໃນການຕັ້ງຄ່າການສົ່ງຂໍ້ຄວາມຂອງຜູ້ໃຊ້.';
$string['configmessagingdeleteallnotificationsdelay'] = 'ການອ່ານ ແລະ ບໍ່ອ່ານການແຈ້ງເຕືອນທີ່ຍັງສາມາດຖືກລຶບເພື່ອປະຢັດພື້ນທີ່ໄດ້. ດົນປານໃດຫຼັງຈາກການແຈ້ງເຕືອນຖືກສ້າງຂຶ້ນສາມາດລຶບມັນອອກໄດ້?';
$string['configmessagingdeletereadnotificationsdelay'] = 'ສາມາດລຶບການແຈ້ງເຕືອນເພື່ອປະຢັດພື້ນທີ່ໄດ້. ດົນປານໃດຫຼັງຈາກການອ່ານການແຈ້ງເຕືອນມັນສາມາດຖືກລຶບໄປໄດ້?';
$string['configminpassworddigits'] = 'ລະຫັດຜ່ານຕ້ອງມີຢ່າງໜ້ອຍຫຼາຍຕົວເລກເຫຼົ່ານີ້.';
$string['configminpasswordlength'] = 'ລະຫັດຜ່ານຕ້ອງມີຢ່າງໜ້ອຍຕົວອັກສອນຍາວຫຼາຍຢ່າງເຫຼົ່ານີ້.';
$string['configminpasswordlower'] = 'ລະຫັດຜ່ານຕ້ອງມີຕົວພິມນ້ອຍຢ່າງໜ້ອຍຫຼາຍຕົວ.';
$string['configminpasswordnonalphanum'] = 'ລະຫັດຜ່ານຕ້ອງມີຕົວອັກສອນທີ່ບໍ່ແມ່ນຕົວເລກຫຼາຍຕົວ.';
$string['configminpasswordupper'] = 'ລະຫັດຜ່ານຕ້ອງມີຕົວພິມໃຫຍ່ໃຫຍ່ຢ່າງໜ້ອຍເຫຼົ່ານີ້.';
$string['configmodchooserdefault'] = 'ຄວນສະເໜີຕົວເລືອກກິດຈະກຳສະແດງໃຫ້ກັບຜູ້ໃຊ້ຕາມຄ່າເລີ່ມຕົ້ນຫຼືບໍ່?';
$string['configmycoursesperpage'] = 'ຈໍານວນວິຊາສູງສຸດທີ່ຈະສະແດງຢູ່ໃນລາຍການຫຼັກສູດຂອງຜູ້ໃຊ້ເອງ';
$string['configmymoodleredirect'] = 'ການຕັ້ງຄ່ານີ້ບັງຄັບໃຫ້ປ່ຽນເສັ້ນທາງໄປຫາ /my ໃນການເຂົ້າສູ່ລະບົບສໍາລັບຜູ້ທີ່ບໍ່ແມ່ນຜູ້ເບິ່ງແຍງລະບົບ ແລະ ປ່ຽນແທນການນໍາທາງເວັບໄຊທ໌ລະດັບສູງສຸດດ້ວຍ /my';
$string['configmypagelocked'] = 'ການຕັ້ງຄ່ານີ້ປ້ອງກັນບໍ່ໃຫ້ໜ້າເວັບເລີ່ມຕົ້ນຖືກແກ້ໄຂໂດຍຜູ້ທີ່ບໍ່ແມ່ນຜູ້ເບິ່ງແຍງລະບົບ';
$string['confignavcourselimit'] = 'ຈໍາກັດຈໍານວນວິຊາທີ່ສະແດງໃຫ້ຜູ້ໃຊ້ເຫັນໃນການນໍາທາງ.';
$string['confignavshowallcourses'] = 'ການຕັ້ງຄ່ານີ້ກຳນົດວ່າຜູ້ໃຊ້ທີ່ລົງທະບຽນເຂົ້າໃນວິຊາສາມາດເຫັນບັນດາວິຊາ (ລາຍການວິຊາທັງໝົດ) ຢູ່ໃນການນຳທາງ, ນອກຈາກວິຊາຂອງຂ້ອຍ (ລາຍການຫຼັກສູດທີ່ເຂົາເຈົ້າລົງທະບຽນຢູ່).';
$string['confignavshowcategories'] = 'ສະແດງບັນດາປະເພດວິຊາຢູ່ໃນແຖບການນຳທາງ ແລະ ບລັອກການນຳທາງ. ສິ່ງນີ້ບໍ່ເກີດຂຶ້ນກັບຫຼັກສູດທີ່ຜູ້ໃຊ້ລົງທະບຽນຢູ່ໃນປະຈຸບັນ; ພວກເຂົາຈະຍັງມີຊື່ຢູ່ພາຍໃຕ້ຫຼັກສູດຂອງຂ້ອຍໂດຍບໍ່ມີບັນດາປະເພດ.';
$string['confignoreplyaddress'] = 'ບາງຄັ້ງອີເມວຖືກສົ່ງອອກໄປໃນນາມຂອງຜູ້ໃຊ້ (ຕົວຢ່າງ: ກະທູ້ໃນເວທີສົນທະນາ). ທີ່ຢູ່ອີເມລທີ່ທ່ານລະບຸຢູ່ນີ້ຈະຖືກໃຊ້ເປັນທີ່ຢູ່ "ຈາກ" ໃນກໍລະນີເຫຼົ່ານັ້ນ ເມື່ອຜູ້ຮັບບໍ່ສາມາດຕອບກັບຫາຜູ້ໃຊ້ໂດຍກົງໄດ້ (ຕົວຢ່າງ: ເມື່ອຜູ້ໃຊ້ເລືອກທີ່ຈະຮັກສາທີ່ຢູ່ຂອງເຂົາເຈົ້າໄວ້ເປັນສ່ວນຕົວ). ການຕັ້ງຄ່ານີ້ຍັງຈະຖືກໃຊ້ເປັນຜູ້ສົ່ງຊອງຈົດໝາຍເມື່ອສົ່ງອີເມລ.';
$string['confignotifyloginfailures'] = 'ສົ່ງຂໍ້ຄວາມແຈ້ງເຕືອນຄວາມລົ້ມເຫຼວການເຂົ້າສູ່ລະບົບຫາຜູ້ໃຊ້ທີ່ເລືອກເຫຼົ່ານີ້. ອັນນີ້ຕ້ອງການໃຫ້ມີ logstore ພາຍໃນ (ຕົວຢ່າງ: Logstore ມາດຕະຖານ) ເພື່ອເປີດໃຊ້ງານ.';
$string['confignotifyloginthreshold'] = 'ຖ້າການແຈ້ງເຕືອນກ່ຽວກັບການເຂົ້າສູ່ລະບົບລົ້ມເຫຼວມີການເຄື່ອນໄຫວ, ມີຄວາມພະຍາຍາມເຂົ້າສູ່ລະບົບລົ້ມເຫຼວຈັກເທື່ອໂດຍຜູ້ໃຊ້ຄົນດຽວ ຫຼື ທີ່ຢູ່ IP ແມ່ນຄຸ້ມຄ່າທີ່ຈະແຈ້ງກ່ຽວກັບເລື່ອງນີ້ຫຼືບໍ່?';
$string['confignotloggedinroleid'] = 'ຜູ້ໃຊ້ທີ່ບໍ່ໄດ້ເຂົ້າສູ່ລະບົບຫາເວັບໄຊທ໌ຈະຖືກປະຕິບັດຄືກັບວ່າເຂົາເຈົ້າມີໜ້າທີ່ອັນນີ້ທີ່ໄດ້ແຕ່ງຕັ້ງໃຫ້ເຂົາເຈົ້າຢູ່ໃນບໍລິບົດຂອງເວັບໄຊທ໌. ແຂກເກືອບແມ່ນສິ່ງທີ່ທ່ານຕ້ອງການເກືອບທັງໝົດຢູ່ສະເໝີ, ແຕ່ທ່ານອາດຈະຕ້ອງການສ້າງໜ້າທີ່ທີ່ມີຂໍ້ຈຳກັດໜ້ອຍລົງ ຫຼື ຫຼາຍກວ່ານັ້ນ. ສິ່ງຕ່າງໆເຊັ່ນ: ການສ້າງໂພສຍັງຕ້ອງການໃຫ້ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບຢ່າງຖືກຕ້ອງ.';
$string['configopentowebcrawlers'] = 'ຖ້າທ່ານເປີດໃຊ້ງານການຕັ້ງຄ່ານີ້, ຈາກນັ້ນເຄື່ອງຈັກຊອກຫາຈະໄດ້ຮັບອະນຸຍາດໃຫ້ເຂົ້າເວັບໄຊທ໌ຂອງທ່ານໃນນາມແຂກ. ນອກຈາກນັ້ນ, ຄົນທີ່ເຂົ້າມາຫາເວັບໄຊທ໌ຂອງທ່ານຜ່ານເຄື່ອງຈັກຊອກຫາຈະຖືກເຂົ້າສູ່ລະບົບໂດຍອັດຕະໂນມັດໃນນາມແຂກ. ກະລຸນາຮັບຊາບວ່າ ສິ່ງນີ້ສະໜອງການເຂົ້າເຖິງວິຊາທີ່ໂປ່ງໃສທີ່ອະນຸຍາດໃຫ້ແຂກເຂົ້າເຖິງໄດ້ແລ້ວ.';
$string['configoverride'] = 'ກໍານົດໄວ້ໃນ config.php';
$string['configpasswordpolicy'] = 'ຖ້າເປີດໃຊ້ງານ, ລະຫັດຜ່ານຂອງຜູ້ໃຊ້ຈະຖືກກວດກາຕໍ່ກັບນະໂຍບາຍລະຫັດຜ່ານຕາມທີ່ກໍານົດໄວ້ຢູ່ໃນການຕັ້ງຄ່າຢູ່ລຸ່ມນີ້. ການເປີດນຳໃຊ້ນະໂຍບາຍລະຫັດຜ່ານຈະບໍ່ມີຜົນກະທົບກັບຜູ້ໃຊ້ທີ່ມີຢູ່ ຈົນກ່ວາເຂົາເຈົ້າຕັດສິນໃຈ ຫຼື ຕ້ອງການປ່ຽນລະຫັດຜ່ານຂອງເຂົາເຈົ້າ, ຫຼື ການຕັ້ງຄ່າ \'ກວດລະຫັດຜ່ານໃນການເຂົ້າສູ່ລະບົບ\' ຖືກເປີດໃຊ້ງານ.';
$string['configpasswordpolicycheckonlogin'] = 'ຖ້າເປີດໃຊ້ງານ, ລະຫັດຜ່ານຂອງຜູ້ໃຊ້ຈະຖືກກວດກາຕໍ່ກັບນະໂຍບາຍລະຫັດຜ່ານແຕ່ລະຄັ້ງທີ່ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບ. ຖ້າການກວດບໍ່ສໍາເລັດ, ຜູ້ໃຊ້ຈະຕ້ອງໄດ້ປ່ຽນລະຫັດຜ່ານຂອງເຂົາເຈົ້າກ່ອນດໍາເນີນການຕໍ່ໄປ.
ມັນເປັນປະໂຫຍດທີ່ຈະເປີດໃຊ້ການຕັ້ງຄ່ານີ້ຫຼັງຈາກອັບເດດນະໂຍບາຍລະຫັດຜ່ານ.';
$string['configpasswordresettime'] = 'ສິ່ງນີ້ລະບຸໄລຍະເວລາທີ່ຜູ້ຄົນຕ້ອງກວດສອບການຮ້ອງຂໍການຕັ້ງລະຫັດໃໝ່ກ່ອນທີ່ມັນຈະໝົດອາຍຸ. ປົກກະຕິແລ້ວ 30 ນາທີແມ່ນຄຸ້ມຄ່າ.';
$string['configpathtodu'] = 'ເສັ້ນທາງໄປຫາ du. ອາດຈະເປັນບາງສິ່ງບາງຢ່າງເຊັ່ນ: /usr/bin/du. ຖ້າທ່ານໃສ່ອັນນີ້, ໜ້າຕ່າງທີ່ສະແດງເນື້ອໃນບັນຊີລາຍການຈະແລ່ນໄວຫຼາຍສໍາລັບບັນຊີລາຍຊື່ທີ່ມີຫຼາຍໄຟລ໌.';
$string['configpathtophp'] = 'ເສັ້ນທາງສູ່ PHP CLI. ອາດຈະເປັນບາງສິ່ງບາງຢ່າງເຊັ່ນ: /usr/bin/php. ຖ້າທ່ານໃສ່ສິ່ງນີ້, ສະຄຣິບ cron ສາມາດຖືກປະຕິບັດໄດ້ຈາກອິນເຕີເຟດເວັບຂອງຜູ້ຄວບຄຸມລະບົບ.';
$string['configperfdebug'] = 'ຖ້າທ່ານເປີດສິ່ງນີ້, ຂໍ້ມູນປະຕິບັດງານຈະຖືກພິມຢູ່ໃນສ່ວນທ້າຍຂອງຊຸດຮູບແບບສິສັນມາດຕະຖານ';
$string['configprofileroles'] = 'ໜ້າທີ່ທີ່ມີລາຍຊື່ໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້ ແລະ ໜ້າການມີສ່ວນຮ່ວມ.';
$string['configprofilesforenrolledusersonly'] = 'ເພື່ອປ້ອງກັນການໃຊ້ spammers ໃນທາງທີ່ຜິດ, ລາຍລະອຽດໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້ທີ່ຍັງບໍ່ໄດ້ລົງທະບຽນເຂົ້າຮຽນໃນລາຍວິຊາໃດ ໜຶ່ງ ແມ່ນຖືກເຊື່ອງໄວ້. ຜູ້ໃຊ້ໃໝ່ຕ້ອງລົງທະບຽນເຂົ້າຮຽນຢ່າງ ໜ້ອຍໜຶ່ງວິຊາກ່ອນທີ່ພວກເຂົາຈະສາມາດເພີ່ມລາຍລະອຽດໂປຼໄຟລ໌ໄດ້.';
$string['configprotectusernames'] = 'ຖ້າເປີດໃຊ້ງານ, ແບບຟອມການລືມລະຫັດຜ່ານຈະບໍ່ສະແດງຄໍາແນະນໍາອັນໃດທີ່ອະນຸຍາດໃຫ້ຄາດເດົາຊື່ຜູ້ໃຊ້ບັນຊີ ຫຼື ທີ່ຢູ່ອີເມລ໌.';
$string['configproxybypass'] = 'ລາຍຊື່ ຊື່ເຈົ້າພາບ (ບາງສ່ວນ)  ຫຼື IPs ທີ່ແຍກກັນດ້ວຍໝາຍຈຸດຄວນຂ້າມຕົວແທນ (ເຊັ່ນ: 192.168., .mydomain.com)';
$string['configproxyfixunsafe_help'] = 'ການພະຍາຍາມນີ້ເພື່ອແກ້ໄຂການໂທພາຍໃນທີ່ບໍ່ໄດ້ດຳເນີນຜ່ານພຣັອກຊີ ໂດຍການເພີ່ມຕົວແທນຜູ້ໃຊ້ MoodleBot ແລະ ການນຳໃຊ້ພຣັອກຊີ.';
$string['configproxyhost'] = 'ຖ້າ <b>ເຊີບເວີ</b> ນີ້ຕ້ອງການໃຊ້ຄອມພິວເຕີຕົວແທນ (ຕົວຢ່າງ: ໄຟວໍ) ເຂົ້າຫາອິນເຕີເນັດ, ຈາກນັ້ນໃຫ້ຊື່ເຈົ້າພາບຕົວແທນຢູ່ທີ່ນີ້. ຖ້າບໍ່ດັ່ງນັ້ນ, ປ່ອຍໃຫ້ມັນຫວ່າງເປົ່າ.';
$string['configproxylogunsafe_help'] = 'ການພະຍາຍາມນີ້ເພື່ອແກ້ໄຂການໂທພາຍໃນທີ່ບໍ່ໄດ້ດຳເນີນຜ່ານພຣັອກຊີ ແລະ ຄວນ.';
$string['configproxypassword'] = 'ຕ້ອງການລະຫັດຜ່ານເພື່ອເຂົ້າຫາອິນເຕີເນັດຜ່ານຕົວແທນຖ້າຈໍາເປັນ, ໃຫ້ຫວ່າງເປົ່າຖ້າບໍ່ມີ (ຕ້ອງການສ່ວນຂະຫຍາຍ PHP cURL).';
$string['configproxyport'] = 'ຖ້າເຊີບເວີນີ້ຕ້ອງການໃຊ້ຄອມພິວຕົວແທນ, ຈາກນັ້ນໃຫ້ພອດຕົວແທນຢູ່ທີ່ນີ້.';
$string['configproxytype'] = 'ປະເພດຂອງຕົວແທນເວັບ (ຕ້ອງການສ່ວນຂະຫຍາຍ PHP5 ແລະ cURL ສໍາລັບການຮອງຮັບ SOCKS5).';
$string['configproxyuser'] = 'ຕ້ອງການຊື່ຜູ້ໃຊ້ເພື່ອເຂົ້າຫາອິນເຕີເນັດຜ່ານຕົວແທນຖ້າຈໍາເປັນ, ປະໃຫ້ຫວ່າງເປົ່າຖ້າບໍ່ມີ (ຕ້ອງການການຂະຫຍາຍ PHP cURL).';
$string['configrecaptchaprivatekey'] = 'ສະຕຣິງຕົວອັກສອນ (ກະແຈລັບ) ໃຊ້ເພື່ອຕິດຕໍ່ສື່ສານລະຫວ່າງເຊີບເວີ Moodle ຂອງທ່ານກັບເຊີບເວີ recaptcha. ລະຫັດ ReCAPTCHA ສາມາດຫາໄດ້ຈາກ <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'ສະຕຣິງຕົວອັກສອນ (ກະແຈເວັບໄຊທ໌) ທີ່ໃຊ້ເພື່ອສະແດງອົງປະກອບ reCAPTCHA ຢູ່ໃນແບບຟອມສະໝັກ ແລະ ແບບຟອມສະໜັບສະໜຸນເວັບໄຊທ໌. ລະຫັດ ReCAPTCHA ສາມາດຫາໄດ້ຈາກ <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'ຄຳສັບສຳລັບນັກຮຽນທີ່ໃຊ້ໃນບັນດາວິຊາທີ່ຮ້ອງຂໍ';
$string['configrequestedstudentsname'] = 'ຄຳສັບສຳລັບນັກຮຽນທີ່ໃຊ້ໃນບັນດາວິຊາທີ່ຮ້ອງຂໍ';
$string['configrequestedteachername'] = 'ຄຳສັບສຳລັບຄູສອນທີ່ໃຊ້ໃນບັນດາວິຊາທີ່ຮ້ອງຂໍ';
$string['configrequestedteachersname'] = 'ຄຳສັບສຳລັບຄູສອນທີ່ໃຊ້ໃນບັນດາວິຊາທີ່ຮ້ອງຂໍ';
$string['configreverseproxyignore'] = 'ຖ້າເຊີບເວີຂອງທ່ານຢູ່ເບື້ອງຫຼັງໂປແກຼມປີ້ນກັບຫຼາຍອັນທີ່ຕິດຢູ່ກັບຫົວຂໍ້ X-Forwarded-For, ຈາກນັ້ນລະບຸລາຍຊື່ທີ່ຢູ່ IP ທີ່ແຍກກັນດ້ວຍໝາຍຈຸດ ຫຼື  subnets ຂອງ ຕົວແທນປີ້ນກັບທີ່ຈະຖືກລະເລີຍເພື່ອຊອກຫາທີ່ຢູ່ IP ທີ່ຖືກຕ້ອງຂອງຜູ້ໃຊ້.';
$string['configsectioninterface'] = 'ແຜງໜ້າ';
$string['configsectionmail'] = 'ຈົດໝາຍ';
$string['configsectionmaintenance'] = 'ການບຳລຸງຮັກສາ';
$string['configsectionmisc'] = 'ອື່ນໆ';
$string['configsectionoperatingsystem'] = 'ລະບົບປະຕິບັດການ';
$string['configsectionpermissions'] = 'ການອະນຸຍາດ';
$string['configsectionrequestedcourse'] = 'ການຮ້ອງຂໍລາຍວິຊາ';
$string['configsectionsecurity'] = 'ຄວາມປອດໄພ';
$string['configsectionstats'] = 'ສະຖິຕິ';
$string['configsectionuser'] = 'ຜູ້ໃຊ້';
$string['configsecureforms'] = 'Moodle ສາມາດໃຊ້ລະດັບຄວາມປອດໄພເພີ່ມເຕີມໄດ້ ເມື່ອຮັບເອົາຂໍ້ມູນຈາກແບບຟອມເວັບ. ຖ້າສິ່ງນີ້ຖືກເປີດໃຊ້, ຕົວແປ HTTP_REFERER ຂອງບຣາວເຊີຖືກກວດສອບກັບທີ່ຢູ່ແບບຟອມປະຈຸບັນ. ໃນບາງກໍລະນີ ສິ່ງນີ້ສາມາດເຮັດໃຫ້ເກີດບັນຫາຖ້າຜູ້ໃຊ້ກໍາລັງໃຊ້ໄຟຣວໍ (ຕົວຢ່າງ: Zonealarm) ທີ່ຖືກກໍານົດໃຫ້ລອກເອົາ HTTP_REFERER ອອກຈາກການເຂົ້າຊົມເວັບຂອງເຂົາທ່ານ. ອາການຕ່າງໆກຳລັງ \'ຕິດ\' ຢູ່ໃນຮູບແບບໃດໜຶ່ງ. ຖ້າຜູ້ໃຊ້ຂອງທ່ານມີບັນຫາກັບໜ້າເຂົ້າສູ່ລະບົບ (ຕົວຢ່າງ) ເຈົ້າອາດຈະຕ້ອງການປິດການຕັ້ງຄ່ານີ້, ເຖິງແມ່ນວ່າມັນອາດຈະເຮັດໃຫ້ເວັບໄຊທ໌ຂອງທ່ານເປີດໃຫ້ມີການໂຈມຕີດ້ວຍລະຫັດຜ່ານແບບບັງຄັບ. ຖ້າມີຂໍ້ສົງໃສ, ປະໃຫ້ການຕັ້ງຄ່ານີ້ເປັນ \'ແມ່ນແລ້ວ\'.';
$string['configsessioncookie'] = 'ການຕັ້ງຄ່ານີ້ປັບແຕ່ງຊື່ຂອງຄຸກກີ້ທີ່ໃຊ້ສໍາລັບເຊດຊັນ Moodle. ສິ່ງນີ້ເປັນທາງເລືອກ, ແລະ ມີປະໂຫຍດພຽງພໍເພື່ອຫຼີກລ່ຽງຄຸກກີ້ສັບສົນເມື່ອມີ Moodle ຫຼາຍກ່ວາ ໜຶ່ງອັນແລ່ນຢູ່ໃນເວັບໄຊທ໌ດຽວກັນ.';
$string['configsessioncookiedomain'] = 'ສິ່ງນີ້ອະນຸຍາດໃຫ້ທ່ານປ່ຽນໂດເມນທີ່ຄຸກກີ້ Moodle ມີໃຫ້ຈາກ. ສິ່ງນີ້ເປັນປະໂຫຍດສໍາລັບການປັບແຕ່ງ Moodle (ຕົວຢ່າງ: ການກວດສອບຄວາມຖືກຕ້ອງ ຫຼື ປລັກອິນການລົງທະບຽນ) ທີ່ຕ້ອງການແບ່ງປັນຂໍ້ມູນເຊດຊັນ Moodle ກັບຄໍາຮ້ອງສະໝັກເວັບຢູ່ໃນໂດເມນຍ່ອຍອື່ນ. <strong>ຄໍາເຕືອນ: ຂໍແນະນໍາໃຫ້ປະໄວ້ການຕັ້ງຄ່ານີ້ເປັນຄ່າເລີ່ມຕົ້ນ (ຫວ່າງເປົ່າ) - ຄ່າທີ່ບໍ່ຖືກຕ້ອງຈະປ້ອງກັນການເຂົ້າສູ່ລະບົບທັງໝົດຫາເວັບໄຊທ໌.</strong>';
$string['configsessioncookiepath'] = 'ຖ້າທ່ານຕ້ອງການປ່ຽນບ່ອນທີ່ຕົວທ່ອງເວັບສົ່ງຄຸກກີ້ Moodle, ທ່ານສາມາດປ່ຽນການຕັ້ງຄ່ານີ້ເພື່ອລະບຸບັນທຶກລາຍຊື່ສະບັບຍ່ອຍຂອງເວັບໄຊທ໌ຂອງທ່ານ. ຖ້າບໍ່ດັ່ງນັ້ນຄ່າເລີ່ມຕົ້ນ \'/\' ຄວນຈະດີແລ້ວ.';
$string['configsessiontimeout'] = 'ຖ້າຄົນເຂົ້າສູ່ລະບົບຫາເວັບໄຊທ໌ນີ້ບໍ່ໄດ້ເຮັດວຽກເປັນເວລາດົນນານ (ໂດຍບໍ່ໄດ້ໂຫຼດ ໜ້າເວັບ) ຈາກນັ້ນເຂົາເຈົ້າຈະຖືກອອກຈາກລະບົບໂດຍອັດຕະໂນມັດ (ເຊດຊັນຂອງເຂົາເຈົ້າຈົບລົງ). ຕົວແປນີ້ລະບຸວ່າເວລານີ້ຄວນຈະດົນປານໃດ.';
$string['configsessiontimeoutwarning'] = 'ຖ້າຄົນເຂົ້າສູ່ລະບົບຫາເວັບໄຊທ໌ນີ້ບໍ່ໄດ້ເຮັດວຽກເປັນເວລາດົນນານ (ໂດຍບໍ່ໄດ້ໂຫຼດ ໜ້າເວັບ) ຈາກນັ້ນເຂົາເຈົ້າຈະຖືກແຈ້ງເຕືອນກ່ຽວກັບໄລຍະເວລາຂອງເຂົາເຈົ້າຈົບລົງ. ຕົວແປນີ້ລະບຸວ່າເວລານີ້ຄວນຈະດົນປານໃດ.';
$string['configsessiontimeoutwarningcheck'] = 'ຄຳເຕືອນໝົດເວລາໄລຍະເວລາຈະຕ້ອງໜ້ອຍກວ່າການໝົດເວລາຂອງໄລຍະເວລາ';
$string['configshowcommentscount'] = 'ສະແດງຈຳນວນຄຳເຫັນ, ມັນຈະຕ້ອງເສຍຄ່າສອບຖາມເພີ່ມເຕີມອີກເມື່ອສະແດງລິ້ງ ຄຳເຫັນ';
$string['configshowicalsource'] = 'ສະແດງຂໍ້ມູນແຫຼ່ງສໍາລັບເຫດການ iCal';
$string['configshowsiteparticipantslist'] = 'ເວັບໄຊທ໌ນັກຮຽນ ແລະ ເວັບໄຊທ໌ຄູສອນເຫຼົ່ານີ້ທັງໝົດຈະຖືກລົງບັນຊີລາຍຊື່ຜູ້ເຂົ້າຮ່ວມເວັບໄຊທ໌. ໃຜຈະໄດ້ຮັບອະນຸຍາດໃຫ້ເບິ່ງລາຍຊື່ຜູ້ເຂົ້າຮ່ວມເວັບໄຊທ໌ນີ້?';
$string['configsitedefaultlicense'] = 'ໃບອະນຸຍາດເວັບໄຊທ໌ເລີ່ມຕົ້ນ';
$string['configsitedefaultlicensehelp'] = 'ໃບອະນຸຍາດເລີ່ມຕົ້ນສໍາລັບການເຜີຍແຜ່ເນື້ອໃນຢູ່ໃນເວັບໄຊທ໌ນີ້';
$string['configsitemailcharset'] = 'ການຕັ້ງຄ່ານີ້ລະບຸຕົວອັກສອນເລີ່ມຕົ້ນສຳລັບອີເມວທັງໝົດທີ່ສົ່ງມາຈາກເວັບໄຊທ໌.';
$string['configsitemaxcategorydepth'] = 'ຄວາມເລິກປະເພດສູງສຸດ';
$string['configsitemaxcategorydepthhelp'] = 'ສິ່ງນີ້ລະບຸຄວາມເລິກສູງສຸດຂອງບັນດາປະເພດຍ່ອຍທີ່ຂະຫຍາຍອອກເມື່ອສະແດງລາຍການປະເພດ ຫຼື ລາຍການຄອມໂບ. ປະເພດລະດັບທີ່ເລິກກວ່າ ຈະປະກົດຂຶ້ນເປັນລິ້ງ ແລະ ຜູ້ໃຊ້ສາມາດຂະຫຍາຍພວກມັນດ້ວຍຄໍາຂໍ AJAX.';
$string['configslasharguments'] = 'ຈຳເປັນຕ້ອງມີ \'Slash ອາກິວເມັ້ນ\' (ການໃຊ້ <em>PATH_INFO</em>) ສໍາລັບແພັກເກດ SCORM ແລະ ແຫຼ່ງຂໍ້ມູນຫຼາຍໄຟລ໌ເພື່ອສະແດງໃຫ້ຖືກຕ້ອງ. ຖ້າເຊີບເວີເວັບຂອງທ່ານບໍ່ສະໜັບສະໜູນ \'slash ອາກິວເມັ້ນ\' ແລະ ເຈົ້າບໍ່ສາມາດຕັ້ງຄ່າມັນໄດ້, ການຕັ້ງຄ່ານີ້ສາມາດຖືກປິດການນຳໃຊ້, ເຖິງແມ່ນວ່າມັນຈະສົ່ງຜົນໃຫ້ສິ່ງຕ່າງໆບໍ່ເຮັດວຽກ.<br />ໝາຍເຫດ: ການໃຊ້ \'slash ອາກິວເມັ້ນ\' ຈະຈຳເປັນ ຕ້ອງການໃນ Moodle ເວີຊັນໃນອະນາຄົດ.';
$string['configsmartpix'] = 'ດ້ວຍສິ່ງນີ້, ຮູບສັນຍາລັກຖືກຮັບໃຊ້ຜ່ານສະຄຣິບ PHP ທີ່ຄົ້ນຫາຫົວຂໍ້ປັດຈຸບັນ, ຈາກນັ້ນຫົວຂໍ້ຫຼັກທັງໝົດ, ຈາກນັ້ນໂຟນເດີ Moodle /pix. ສິ່ງນີ້ຊ່ວຍຫຼຸດຄວາມຕ້ອງການຊໍ້າກັນກັບໄຟລ໌ຮູບພາຍໃນຮູບແບບສີສັນ, ແຕ່ມີຕົ້ນທຶນການປະຕິບັດເລັກນ້ອຍ.';
$string['configsmtpauthtype'] = 'ອັນນີ້ກໍານົດປະເພດການກວດສອບເພື່ອໃຊ້ຢູ່ໃນເຊີບເວີ smtp.';
$string['configsmtphosts'] = 'ໃຫ້ຊື່ເຕັມຂອງເຊີບເວີ SMTP ທ້ອງຖິ່ນໜຶ່ງ ຫຼື ຫຼາຍເຄື່ອງທີ່ Moodle ຄວນໃຊ້ເພື່ອສົ່ງຈົດໝາຍ (ຕົວຢ່າງ: \'mail.a.com\' ຫຼື \'mail.a.com; mail.b.com\'). ເພື່ອລະບຸພອດທີ່ບໍ່ແມ່ນຄ່າເລີ່ມຕົ້ນ (ຕົວຢ່າງ: ອື່ນໆນອກເໜືອຈາກພອດ 25), ທ່ານສາມາດໃຊ້ [server]:[port] syntax (ຕົວຢ່າງ \'mail.a.com:587\'). ສໍາລັບການເຊື່ອມຕໍ່ທີ່ປອດໄພ, ປົກກະຕິແລ້ວພອດ 465 ແມ່ນໃຊ້ກັບ SSL, ປົກກະຕິພອດ 587 ແມ່ນໃຊ້ກັບ TLS, ລະບຸລະບຽບໂປຣໂຕຄໍດ້ານຄວາມປອດໄພດ້ານລຸ່ມຖ້າຈໍາເປັນ. ຖ້າທ່ານປະຊ່ອງນີ້ຫວ່າງໄວ້, Moodle ຈະໃຊ້ວິທີສົ່ງ PHP ຄ່າເລີ່ມຕົ້ນ.';
$string['configsmtpmaxbulk'] = 'ຈຳນວນຂໍ້ຄວາມສູງສຸດສົ່ງຕໍ່ເຊດຊັນ SMTP. ການຈັດກຸ່ມຂໍ້ຄວາມອາດຈະເລັ່ງການສົ່ງອີເມວ. ຄ່າຕ່ຳກວ່າ 2 ການສ້າງເຊດຊັນ SMTP ໃໝ່ສຳລັບແຕ່ລະອີເມວ.';
$string['configsmtpsecure'] = 'ຖ້າເຊີບເວີ SMTP ຕ້ອງການການເຊື່ອມຕໍ່ທີ່ປອດໄພ, ລະບຸປະເພດລະບຽນບການໂປຼໂຕຄໍທີ່ຖືກຕ້ອງ.';
$string['configsmtpuser'] = 'ຖ້າເຈົ້າໄດ້ລະບຸເຊີບເວີ SMTP ຂ້າງເທິງ, ແລະ ເຊີບເວີຕ້ອງການການກວດສອບຄວາມຖືກຕ້ອງ, ຈາກນັ້ນໃສ່ຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານທີ່ນີ້.';
$string['configstartwday'] = 'ເລີ່ມຕົ້ນຂອງອາທິດ';
$string['configstatsfirstrun'] = 'ອັນນີ້ລະບຸວ່າຄວນຈະປະມວນຜົນຂໍ້ມູນບັນທຶກກັບຄືນ <b>ຄັ້ງທໍາອິດ</b> ທີ່ cronjob ຕ້ອງການປະມວນຜົນສະຖິຕິ. ຖ້າທ່ານມີການຈະລາຈອນຫຼາຍ ແລະ ຢູ່ໃນການເປັນເຈົ້າພາບຮ່ວມກັນ, ມັນອາດຈະບໍ່ເປັນຄວາມຄິດທີ່ດີທີ່ຈະກັບໄປໄກເກີນໄປ, ເພາະວ່າມັນອາດຈະໃຊ້ເວລາດົນເພື່ອດໍາເນີນການ ແລະ ມີແຫຼ່ງຂໍ້ມູນຫຼາຍ. (ໃຫ້ສັງເກດວ່າສຳລັບການຕັ້ງຄ່ານີ້, 1 ເດືອນ = 28 ມື້. ໃນເສັ້ນສະແດງ ແລະ ລາຍງານທີ່ສ້າງຂຶ້ນ, 1 ເດືອນ = 1 ເດືອນປະຕິທິນ.)';
$string['configstatsmaxruntime'] = 'ການປະມວນຜົນສະຖິຕິສາມາດຂ້ອນຂ້າງຮຸນແຮງ, ສະນັ້ນຈົ່ງໃຊ້ການປະສົມປະສານຂອງພາກສະໜາມນີ້ ແລະ ອັນຕໍ່ໄປເພື່ອລະບຸເວລາທີ່ມັນຈະແລ່ນ ແລະ ດົນປານໃດ.';
$string['configstatsmaxruntime2'] = 'ການປະມວນຜົນສະຖິຕິສາມາດຂ້ອນຂ້າງຮຸນແຮງ, ລະບຸເວລາສູງສຸດທີ່ອະນຸຍາດໃຫ້ເກັບກໍາສະຖິຕິມື້ໜຶ່ງ. ຈໍານວນມື້ສູງສຸດທີ່ດໍາເນີນຢູ່ໃນການປະຕິບັດ cron ໜຶ່ງອັນ ແມ່ນ 31.';
$string['configstatsmaxruntime3'] = 'ສິ່ງນີ້ລະບຸເວລາສູງສຸດທີ່ອະນຸຍາດໃຫ້ຄິດໄລ່ສະຖິຕິສໍາລັບມື້ໜຶ່ງ, ຄໍານຶງວ່າການປະມວນຜົນສະຖິຕິສາມາດເຮັດໃຫ້ມີການໂຫຼດຫຼາຍຢູ່ໃນເຊີບເວີ. ຈໍານວນມື້ສູງສຸດທີ່ດໍາເນີນຢູ່ໃນ cron ໜຶ່ງອັນ ສາມາດລະບຸໄວ້ຢູ່ລຸ່ມນີ້.';
$string['configstatsruntimedays'] = 'ອັນນີ້ລະບຸຈໍານວນມື້ສູງສຸດທີ່ດໍາເນີນຢູ່ໃນແຕ່ລະການປະຕິບັດສະຖິຕິ. ເມື່ອສະຖິຕິອັບເດດແລ້ວ, ມີພຽງແຕ່ມື້ດຽວເທົ່ານັ້ນທີ່ຈະຖືກປະມວນຜົນ, ສະນັ້ນ ການປັບຄ່ານີ້ຂຶ້ນຢູ່ກັບການໂຫຼດຂອງເຊີບເວີຂອງທ່ານ, ຫຼຸດມັນລົງຖ້າຕ້ອງການການປະຕິບັດ cron ທີ່ສັ້ນກວ່າ.';
$string['configstatsruntimestart'] = 'ຄວນໃຫ້ cronjob ເລີ່ມການປະມວນຜົນສະຖິຕິເວລາຈັກໂມງ? ການລະບຸເວລາທີ່ແຕກຕ່າງກັນແມ່ນແນະນໍາ ຖ້າມີຫຼາຍເວັບໄຊທ໌ Moodle ຢູ່ໃນເຊີບເວີດຽວ.';
$string['configstatsuserthreshold'] = 'ການຕັ້ງຄ່ານີ້ລະບຸຈໍານວນຕ່ຳສຸດທີ່ຂອງຜູ້ໃຊ້ລົງທະບຽນສໍາລັບລາຍວິຊາທີ່ຈະລວມຢູ່ໃນການຄໍານວນສະຖິຕິ.';
$string['configstrictformsrequired'] = 'ຖ້າເປີດນຳໃຊ້, ຜູ້ໃຊ້ຖືກປ້ອງກັນບໍ່ໃຫ້ເຂົ້າໄປໃສ່ຍະຫວ່າງ ຫຼື ລົງແຖວຢູ່ໃນຊ່ອງຂໍ້ມູນທີ່ຕ້ອງການໃນແບບຟອມເທົ່ານັ້ນ.';
$string['configstripalltitletags'] = 'ຍົກເລີກການເລືອກການຕັ້ງຄ່ານີ້ເພື່ອອະນຸຍາດໃຫ້ແທັກ HTML ຢູ່ໃນກິດຈະກໍາ ແລະ ຊື່ແຫຼ່ງຂໍ້ມູນ.';
$string['configsupportemail'] = 'ຖ້າ SMTP ຖືກຕັ້ງຄ່າຢູ່ໃນເວັບໄຊທ໌ນີ້ ແລະ ໜ້າສະໜັບສະໜູນບໍ່ໄດ້ຖືກຕັ້ງຄ່າ, ທີ່ຢູ່ອີເມວນີ້ຈະໄດ້ຮັບຂໍ້ຄວາມທີ່ສົ່ງຜ່ານແບບຟອມການຊ່ວຍເຫຼືອ. ຖ້າການສົ່ງລົ້ມເຫຼວ, ທີ່ຢູ່ອີເມລນີ້ຈະຖືກສະແດງໃຫ້ຜູ້ໃຊ້ທີ່ໄດ້ລົງຊື່ເຂົ້າໃຊ້.';
$string['configsupportname'] = 'ນີ້ແມ່ນຊື່ຂອງບຸກຄົນ ຫຼື ນິຕິບຸກຄົນອື່ນ ທີ່ສະເໜີການຊ່ວຍເຫຼືອຜ່ານທາງແບບຟອມການຊ່ວຍເຫຼືອ ຫຼື ໜ້າການຊ່ວຍເຫຼືອ.';
$string['configsupportpage'] = 'ລິ້ງໄປຫາໜ້ານີ້ຈະຖືກສະໜອງໃຫ້ຜູ້ໃຊ້ຕິດຕໍ່ກັບຝ່າຍຊ່ວຍເຫຼືອ. ຖ້າຊ່ອງຂໍ້ມູນນີ້ຖືກປະໄວ້ຫວ່າງເປົ່າຫຼັງຈາກນັ້ນລິ້ງໄປຫາແບບຟອມຊ່ວຍເຫຼືອຈະຖືກສະໜອງໃຫ້.';
$string['configtempdatafoldercleanup'] = 'ເອົາໄຟລ໌ຂໍ້ມູນຊົ່ວຄາວອອກຈາກໂຟລເດີຂໍ້ມູນທີ່ເກົ່າກວ່າເວລາທີ່ເລືອກໄວ້.';
$string['configthemedesignermode'] = 'ໂດຍປົກກະຕິແລ້ວຮູບພາບຮູບແບບສີສັນ ແລະ ແຜ່ນຮູບແບບທັງໝົດຖືກເກັບໄວ້ໃນໂປຼແກຼມທ່ອງເວັບ ແລະ ໃນເຊີບເວີເປັນເວລາດົນນານ, ເພື່ອປະສິດທິພາບ. ຖ້າທ່ານກໍາລັງອອກແບບຫົວຂໍ້ ຫຼື ພັດທະນາລະຫັດຢູ່ແລ້ວທ່ານອາດຈະຕ້ອງການເປີດໃຊ້ຮູບແບບນີ້ ເພື່ອວ່າທ່ານຈະບໍ່ໄດ້ຮັບໃຊ້ເວີຊັນທີ່ເກັບໄວ້. ຄໍາເຕືອນ: ສິ່ງນີ້ຈະເຮັດໃຫ້ເວັບໄຊທ໌ຂອງທ່ານຊ້າລົງສໍາລັບຜູ້ໃຊ້ທຸກຄົນ! ອີກທາງເລືອກໜຶ່ງ, ທ່ານຍັງສາມາດຣີເຊັດຖານຄວາມຈຳຫົວຂໍ້ດ້ວຍຕົນເອງຈາກໜ້າການເລືອກຫົວຂໍ້.';
$string['configthemelist'] = 'ປ່ອຍໃຫ້ຫວ່າງ ເພື່ອອະນຸຍາດໃຫ້ໃຊ້ຮູບແບບສີສັນທີ່ຖືກຕ້ອງ. ຖ້າທ່ານຕ້ອງການເຮັດໃຫ້ເມນູຊຸດຮູບແບບສີສັນສັ້ນລົງ, ທ່ານສາມາດລະບຸລາຍຊື່ທີ່ຂັ້ນດ້ວຍເຄື່ອງາຍຈຸດຢູ່ທີ່ນີ້ (ຢ່າໃຊ້ຍະຫວ່າງ!). ຕົວຢ່າງ: ມາດຕະຖານ,ຂາວສົ້ມ.';
$string['configtimezone'] = 'ນີ້ແມ່ນເຂດເວລາເລີ່ມຕົ້ນສໍາລັບການສະແດງວັນທີ - ຜູ້ໃຊ້ແຕ່ລະຄົນສາມາດລົບລ້າງການຕັ້ງຄ່ານີ້ໃນໂປຼໄຟລ໌ຂອງເຂົາເຈົ້າໄດ້. ໜ້າວຽກ Cron ແລະ ການຕັ້ງຄ່າເຊີບເວີອື່ນແມ່ນໄດ້ລະບຸໄວ້ໃນເຂດເວລານີ້. ທ່ານຄວນປ່ຽນການຕັ້ງຄ່າຖ້າມັນສະແດງເປັນ "ເຂດເວລາບໍ່ຖືກຕ້ອງ"';
$string['configuseblogassociations'] = 'ຜູ້ໃຊ້ຄວນຈະສາມາດຈັດລະບຽບບລ໋ອກຂອງເຂົາເຈົ້າໄດ້ໂດຍການເຊື່ອມໂຍງລາຍການເຂົ້າກັບວິຊາ ແລະ ຊູດວິຊາຫຼືບໍ່?';
$string['configusesitenameforsitepages'] = 'ຖ້າເປີດໃຊ້ງານຊື່ສັ້ນຂອງເວັບໄຊທ໌ຈະຖືກໃຊ້ສໍາລັບໂໜດໜ້າເວັບໄຊທ໌ຢູ່ໃນການນໍາທາງແທນທີ່ຈະເປັນສະຕຣິງ \'ໜ້າເວັບໄຊທ໌\'.';
$string['configusetags'] = 'ຄວນເປີດໃຊ້ການທໍາງານຂອງແທັກໃນທົ່ວເວັບໄຊທ໌ຫຼືບໍ?';
$string['configvariables'] = 'ຕົວແປ';
$string['configverifychangedemail'] = 'ເປີດໃຊ້ການຢັ້ງຢືນທີ່ຢູ່ອີເມລທີ່ປ່ຽນແປງໂດຍໃຊ້ການຕັ້ງຄ່າໂດເມນອີເມລທີ່ອະນຸຍາດ ແລະ ຖືກປະຕິເສດ. ຖ້າການຕັ້ງຄ່ານີ້ຖືກປິດໃຊ້ງານ ໂດເມນຈະຖືກບັງຄັບໃຊ້ພຽງແຕ່ເມື່ອສ້າງຜູ້ໃຊ້ໃໝ່.';
$string['configvisiblecourses'] = 'ປົກກະຕິສະແດງວິຊາໃນບັນດາປະເພດທີ່ເຊື່ອງໄວ້';
$string['configwarning'] = 'ຈົ່ງລະມັດລະວັງແກ້ໄຂການຕັ້ງຄ່າເຫຼົ່ານີ້ - ຄ່າແປກອາດເຮັດໃຫ້ເກີດບັນຫາ.';
$string['configyuicomboloading'] = 'ຕົວເລືອກນີ້ເປີດໃຊ້ການເພີ່ມປະສິດທິພາບການໂຫຼດໄຟລ໌ທີ່ລວມເຂົ້າກັນສໍາລັບຫ້ອງສະຸດ YUI. ການຕັ້ງຄ່ານີ້ຄວນເປີດໃຊ້ງານຢູ່ໃນບ່ອນຜະລິດສໍາລັບເຫດຜົນການປະຕິບັດ.';
$string['confirmation'] = 'ການຢືນຢັນ';
$string['confirmcontextlock'] = 'ປະຈຸບັນ {$a->contextname} ບໍ່ໄດ້ຖືກຈຶ້ງໄວ້. ການແຊ່ແຂງມັນຈະເຮັດໃຫ້ມັນອ່ານເທົ່ານັ້ນ ແລະ ປ້ອງກັນບໍ່ໃຫ້ຜູ້ໃຊ້ປ່ຽນແປງ. ທ່ານແນ່ໃຈບໍ່ວ່າເຈົ້າຕ້ອງການສືບຕໍ່?';
$string['confirmcontextunlock'] = '{$a->contextname} ຕອນນີ້ຖືກຈຶ້ງໄວ້. ການບໍ່ປ່ອຍມັນໄວ້ຈະເຮັດໃຫ້ຜູ້ໃຊ້ສາມາດປ່ຽນແປງໄດ້. ທ່ານແນ່ໃຈບໍ່ວ່າເຈົ້າຕ້ອງການສືບຕໍ່?';
$string['confirmdeletecomments'] = 'ທ່ານກຳລັງຈະລຶບຄຳເຫັນ, ທ່ານແນ່ໃຈບໍ?';
$string['confirmed'] = 'ຢືນຢັນ';
$string['contactsitesupport'] = 'ຕິດຕໍ່ການສະໜັບສະໜຸນເວັບໄຊທ໌';
$string['contenttypeuninstalling'] = 'ມີ {$a->count} ເນື້ອໃນທີ່ສະໜັບສະໜູນໂດຍ {$a->type}. ພວກມັນຈະຖືກລຶບອອກ. ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການດຳເນີນການຕໍ່?';
$string['contextlockappliestoadmin'] = 'ການລະງັບເນື້ອໃນມີຜົນກັບຜູ້ຄວບຄຸມລະບົບ';
$string['contextlockappliestoadmin_desc'] = 'ຖ້າປິດໃຊ້ງານ, ຜູ້ຄວບຄຸມລະບົບຍັງຄົງມີການເຂົ້າຫາການຂຽນໃສ່ສະພາບການແຊ່ແຂງໃດໜຶ່ງ.';
$string['contextlocking'] = 'ການຈຶ້ງເນື້ອໃນ';
$string['contextlocking_desc'] = 'ການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ເຂົ້າເຖິງແບບອ່ານເທົ່ານັ້ນ ເພື່ອຕັ້ງເປັນບັນດາປະເພດ, ຫຼັກສູດ, ກິດຈະກໍາ ຫຼື ບລັອກທີ່ເລືອກໄວ້.';
$string['cookiehttponly'] = 'ມີແຕ່ຄຸກກີ້ http ເທົ່ານັ້ນ';
$string['cookiesecure'] = 'ຄຸກກີ້ທີ່ປອດໄພເທົ່ານັ້ນ';
$string['country'] = 'ປະເທດຄ່າເລີ່ມຕົ້ນ';
$string['course_customfield'] = 'ຊ່ອງວິຊາປັບແຕ່ງເອງ';
$string['coursecolor'] = 'ສີ {$a}';
$string['coursecolorheading_desc'] = 'ວິຊາໃດໜຶ່ງທີ່ບໍ່ມີຮູບພາບວິຊາຢູ່ໃນການຕັ້ງຄ່າວິຊາແມ່ນສະແດງຢູ່ໃນແຜງໜ້າປັດ ດ້ວຍບັດວິຊາທີ່ມີລວດລາຍ. ສີທີ່ໃຊ້ໃນຮູບແບບອາດຈະໄດ້ລະບຸໄວ້ຢູ່ລຸ່ມນີ້.';
$string['coursecolorsettings'] = 'ສີບັດວິຊາ';
$string['coursecontact'] = 'ຕິດຕໍ່ວິຊາ';
$string['coursecontact_desc'] = 'ການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ທ່ານຄວບຄຸມວ່າໃຜປະກົດຢູ່ໃນລາຍລະອຽດວິຊາ. ຜູ້ໃຊ້ຕ້ອງມີຢ່າງໜ້ອຍໜຶ່ງໃນໜ້າທີ່ເຫຼົ່ານີ້ຢູ່ໃນວິຊາໃດໜຶ່ງເພື່ອສະແດງໃຫ້ເຫັນໃນຄໍາອະທິບາຍວິຊາສໍາລັບລາຍວິຊານັ້ນ.';
$string['coursecontactduplicates'] = 'ສະແດງບົດບາດການຕິດຕໍ່ທັງໝົດຂອງວິຊາ';
$string['coursecontactduplicates_desc'] = 'ຖ້າເປີດໃຊ້, ຜູ້ໃຊ້ທີ່ມີຫຼາຍກ່ວາໜຶ່ງໃນພາລະໜ້າທີ່ການຕິດຕໍ່ວິຊາທີ່ເລືອກ ຈະຖືກສະແດງຢູ່ໃນລາຍລະອຽດວິຊາດ້ວຍແຕ່ລະໜ້າທີ່ຂອງເຂົາເຈົ້າ. ຖ້າບໍ່ດັ່ງນັ້ນ, ພວກມັນຈະຖືກສະແດງດ້ວຍໜ້າທີ່ດຽວເທົ່ານັ້ນ (ອັນໃດກໍ່ໄດ້ທີ່ມີລາຍຊື່ສູງສຸດໃນ \'ກໍານົດໜ້າທີ່\' ໃນການບໍລິຫານເວັບໄຊທ໌).';
$string['coursegraceperiodafter'] = 'ໄລຍະເວລາຜ່ອນຜັນສໍາລັບລາຍວິຊາທີ່ຜ່ານມາ';
$string['coursegraceperiodbefore'] = 'ໄລຍະເວລາຜ່ອນຜັນສໍາລັບລາຍວິຊາອານາຄົດ';
$string['courselistshortnames'] = 'ສະແດງຊື່ວິຊາຂະຫຍາຍ';
$string['courselistshortnames_desc'] = 'ຖ້າເປີດໃຊ້, ຊື່ຫຍໍ້ຂອງວິຊາຈະສະແດງຂຶ້ນມາພ້ອມກັບຊື່ເຕັມຢູ່ໃນລາຍການວິຊາ. ຖ້າຕ້ອງການ, ຊື່ວິຊາຂະຫຍາຍອາດຈະຖືກປັບແຕ່ງໂດຍການແກ້ໄຂສະຕຣິງງພາສາ \'courseextendednamedisplay\' ໂດຍໃຊ້ຄຸນສົມບັດການປັບແຕ່ງພາສາ.';
$string['coursemgmt'] = 'ຈັດການບັນດາວິຊາ ແລະ ປະເພດ';
$string['courseoverview'] = 'ພາບລວມວິຊາ';
$string['coursepage'] = 'ໜ້າວິຊາ';
$string['courserequestnotify'] = 'ແຈ້ງການຮ້ອງຂໍວິຊາ';
$string['courserequestnotifyemail'] = 'ຜູ້ໃຊ້ {$a->user} ຮ້ອງຂໍລາຍວິຊາໃໝ່ຢູ່ທີ່ {$a->link}';
$string['courserequests'] = 'ຮ້ອງຂໍວິຊາ';
$string['courserequestspending'] = 'ຄຳຮ້ອງຂໍວິຊາທີ່ຄ້າງຢູ່';
$string['courses'] = 'ວິຊາ';
$string['coursesperpage'] = 'ວິຊາຕໍ່ໜ້າ';
$string['courseswithsummarieslimit'] = 'ວິຊາທີ່ມີຂໍ້ສະຫຼຸບຈຳກັດ';
$string['creatornewroleid'] = 'ໜ້າທີ່ຂອງຜູ້ສ້າງໃນຫຼັກສູດໃໝ່';
$string['creatornewroleid_help'] = 'ຖ້າຜູ້ໃຊ້ບໍ່ມີສິດອະນຸຍາດໃນການຈັດການວິຊາໃໝ່, ຜູ້ໃຊ້ຈະຖືກລົງທະບຽນໂດຍອັດຕະໂນມັດໂດຍໃຊ້ໜ້າທີ່ນີ້.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'ເປີດໃຊ້ງານ Cron';
$string['cron_enabled_desc'] = 'ໂດຍປົກກະຕິແລ້ວ Cron ຄວນຖືກເປີດນຳໃຊ້, ເຖິງຢ່າງໃດກໍ່ຕາມການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ມັນຖືກປິດການນຳໃຊ້ຊົ່ວຄາວ, ຕົວຢ່າງ: ກ່ອນການເລີ່ມເຊີບເວີຄືນໃໝ່. ຖ້າປິດໃຊ້ງານ, ລະບົບຈະປ້ອງກັນບໍ່ໃຫ້ເລີ່ມໜ້າວຽກພື້ນຫຼັງໃໝ່. ກະລຸນາຮັບຊາບວ່າ cron ບໍ່ຄວນຖືກປິດການນຳໃຊ້ເປັນເວລາດົນ, ເພາະວ່າອັນນີ້ຈະປ້ອງກັນບໍ່ໃຫ້ໜ້າທີ່ ສຳຄັນເຮັດວຽກ.';
$string['cron_help'] = 'ສະຄຣິບ cron.php ເຮັດວຽກຫຼາຍອັນໃນຊ່ວງເວລາທີ່ແຕກຕ່າງກັນເຊັ່ນ: ການສົ່ງອີເມລແຈ້ງເຕືອນໂພສໃນເວທີສົນທະນາ. ສະຄຣິບຄວນຈະຖືກໃຊ້ເປັນປົກກະຕິ - ໂດຍສະເພາະທຸກນາທີ.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'ການປະຕິບັດ Cron ຜ່ານເສັ້ນຄຳສັ່ງເທົ່ານັ້ນ';
$string['cronerrorclionly'] = 'ຂໍອະໄພ, ການເຂົ້າຫາອິນເຕີເນັດຫາໜ້ານີ້ໄດ້ຖືກປິດໂດຍຜູ້ຄວບຄຸມລະບົບ.';
$string['cronerrorpassword'] = 'ຂໍອະໄພ, ທ່ານບໍ່ໄດ້ໃຫ້ລະຫັດຜ່ານທີ່ຖືກຕ້ອງເພື່ອເຂົ້າຫາໜ້ານີ້';
$string['croninfrequent'] = 'ມີ {$a->actual} ລະຫວ່າງສອງການໃຊ້ສຸດທ້າຍຂອງສະຄຣິບການຮັກສາ cron ແລະ ມັນຄວນຈະໃຊ້ທຸກ {$a->expected}. ພວກເຮົາແນະນຳໃຫ້ຕັ້ງຄ່າມັນໃຫ້ໃຊ້ເລື້ອຍໆ.';
$string['cronremotepassword'] = 'ລະຫັດຜ່ານ Cron ສໍາລັບການເຂົ້າເຖິງຫ່າງໄກ';
$string['cronwarning'] = '<a href="{$a->url}">ສະຄຣິບ admin/cron.php</a> ບໍ່ໄດ້ຖືກເອີ້ນໃຊ້ສໍາລັບ {$a->actual} ແລະ ຄວນຈະໃຊ້ທຸກ {$a->expected}.';
$string['cronwarningcli'] = 'ສະຄຣິບ <code>admin/cli/cron.php</code> ບໍ່ໄດ້ຖືກເອີ້ນໃຊ້ສໍາລັບ {$a->actual} ແລະ ຄວນຈະໃຊ້ທຸກ {$a->expected}.';
$string['cronwarningnever'] = 'ສະຄຣິບ <code>admin/cli/cron.php</code> ບໍ່ເຄີຍຖືກໃຊ້ ແລະ ຄວນຈະໃຊ້ທຸກ {$a->expected}.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">ສະຄຣິບ admin/cron.php</a> ບໍ່ເຄີຍຖືກໃຊ້ ແລະ ຄວນຈະໃຊ້ທຸກ {$a->expected}.';
$string['ctyperequired'] = 'ດຽວນີ້ Moodle ຕ້ອງການສ່ວນຂະຫຍາຍ ctype PHP, ເພື່ອປັບປຸງການເຮັດວຽກຂອງເວັບໄຊທ໌ ແລະ ໃຫ້ການເຂົ້າກັນໄດ້ຫຼາຍພາສາ.';
$string['curlcache'] = 'cURL ແຄດ TTL';
$string['curlrequired'] = 'ດຽວນີ້ Moodle ຕ້ອງການສ່ວນຂະຫຍາຍ cURL PHP, ເພື່ອຕິດຕໍ່ສື່ສານກັບບ່ອນເກັບຂໍ້ມູນ Moodle.';
$string['curlsecurityallowedport'] = 'cURL ອະນຸຍາດລາຍຊື່ຜອດ';
$string['curlsecurityallowedportsyntax'] = 'ລາຍການຕົວເລກຜອດທີ່ cURL ສາມາດເຊື່ອມຕໍ່ຫາໄດ້. ລາຍການທີ່ຖືກຕ້ອງແມ່ນຕົວເລກຈຳນວນເຕັມເທົ່ານັ້ນ. ໃສ່ແຕ່ລະຂໍ້ໃນແຖວໃໝ່. ຖ້າປ່ອຍໃຫ້ຫວ່າງເປົ່າ, ຈາກນັ້ນທຸກຜອດໄດ້ຮັບອະນຸຍາດ. ຖ້າຕັ້ງໄວ້, ໃນເກືອບທຸກກໍລະນີ, ທັງ 443 ແລະ 80 ຄວນຖືກລະບຸໄວ້ສໍາລັບ cURL ເພື່ອເຊື່ອມຕໍ່ກັບພອດມາດຕະຖານ HTTPS ແລະ HTTP.';
$string['curlsecurityblockedhosts'] = 'cURL ປິດກັ້ນລາຍຊື່ເຈົ້າພາບ';
$string['curlsecurityblockedhostssyntax'] = 'ໃສ່ແຕ່ລະຂໍ້ໃນແຖວໃໝ່. ລາຍການທີ່ຖືກຕ້ອງແມ່ນທັງທີ່ຢູ່ IPv4 ຫຼື IPv6 ເຕັມ (ເຊັ່ນ: 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) ເຊິ່ງກົງກັບເຈົ້າພາບດຽວ; ຫຼື ສັນຍາລັກ CIDR (ເຊັ່ນ: 231.54.211.0/20 ຫຼື fe80::/64); ຫຼື ລະດັບຂອງທີ່ຢູ່ IP (ເຊັ່ນ: 231.3.56.10-20 ຫຼື fe80::1111-bbbb) ບ່ອນທີ່ຂອບເຂດນໍາໃຊ້ກັບກຸ່ມສຸດທ້າຍຂອງທີ່ຢູ່; ຫຼື ຊື່ໂດເມນ (ເຊັ່ນ: localhost ຫຼື example.com); ຫຼື ຕົວແທນໂດເມນຕົວແທນ (ເຊັ່ນ: *.example.com ຫຼື *.sub.example.com). ບໍ່ອະນຸຍາດໃຫ້ໃຊ້ເສັ້ນຫວ່າງ.';
$string['curlsecurityurlblocked'] = 'URL ຖືກປິດກັ້ນ.';
$string['curltimeoutkbitrate'] = 'Bitrate ທີ່ຈະໃຊ້ເມື່ອຄິດໄລ່ການໝົດເວລາຂອງ CURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'ການຕັ້ງຄ່ານີ້ຖືກໃຊ້ເພື່ອຄິດໄລ່ການໝົດເວລາທີ່ເໝາະສົມໃນລະຫວ່າງການຮ້ອງຂໍ cURL ຂະໜາດໃຫຍ່. ສ່ວນໜຶ່ງຂອງການຄິດໄລ່ນີ້ ການຮ້ອງຂໍ HTTP HEAD ແມ່ນເຮັດເພື່ອກໍານົດຂະໜາດຂອງເນື້ອໃນ. ການຕັ້ງອັນນີ້ເປັນ 0 ປິດໃຊ້ງານການຮ້ອງຂໍນີ້ບໍ່ໃຫ້ເຮັດ.';
$string['currenttheme'] = 'ຮູບແບບສີສັນປະຈຸບັນ';
$string['customcheck'] = 'ການກວດສອບອື່ນໆ';
$string['custommenu'] = 'ເມນູປັບແຕ່ງເອງ';
$string['custommenuitems'] = 'ລາຍການເມນູປັບແຕ່ງເອງ';
$string['customusermenuitems'] = 'ລາຍການເມນູຜູ້ໃຊ້';
$string['datarootsecurityerror'] = '<p><strong>ຄຳເຕືອນຄວາມປອດໄພ!</strong></p><p>ໄດເຣັກທໍຣີຮາກຖານຂໍ້ມູນຂອງທ່ານຢູ່ໃນບ່ອນທີ່ບໍ່ຖືກຕ້ອງ ແລະ ຖືກເປີດເຜີຍຕໍ່ກັບເວັບ. ອັນນີ້ໝາຍຄວາມວ່າທຸກໄຟລ໌ສ່ວນຕົວຂອງທ່ານມີໃຫ້ກັບທຸກຄົນໃນໂລກ, ແລະ ບາງໄຟລ໌ຂອງມັນສາມາດຖືກໃຊ້ໂດຍ cracker ເພື່ອເອົາການເຂົ້າຫາເວັບໄຊທ໌ຂອງເຈົ້າໂດຍບໍ່ໄດ້ຮັບອະນຸຍາດ!</p>
<p>ທ່ານ<em>ຕ້ອງ</em>ຍ້າຍໄດເຣັກທໍຣີຮາກຖານຂໍ້ມູນ ({$a}) ໄປໃສ່ບ່ອນໃໝ່ທີ່ບໍ່ຢູ່ພາຍໃນສາລະບົບເວັບສາທາລະນະຂອງທ່ານ, ແລະ ອັບເດດການຕັ້ງຄ່າ <code>$CFG->ຮາກຖານຂໍ້ມູນ</code>ໃນ config.php ຂອງທ່ານຕາມລຳດັບ.</p>';
$string['datarootsecuritywarning'] = 'ການຕັ້ງຄ່າເວັບໄຊທ໌ຂອງທ່ານອາດຈະບໍ່ປອດໄພ. ກະລຸນາກວດໃຫ້ແນ່ໃຈວ່າໄດເຣັກທໍຣີຮາກຖານຂໍ້ມູນຂອງທ່ານ ({$a}) ບໍ່ສາມາດເຂົ້າເຖິງໄດ້ໂດຍກົງຜ່ານທາງເວັບ.';
$string['dbsessions'] = 'ໃຊ້ຖານຂໍ້ມູນສໍາລັບຂໍ້ມູນກອງປະຊຸມ';
$string['debug'] = 'ຂໍ້ຄວາມດີບັກ';
$string['debugall'] = 'ທັງໝົດ: ສະແດງທຸກຂໍ້ຄວາມດີບັກ PHP ສົມເຫດສົມຜົນ';
$string['debugdeveloper'] = 'ນັກພັດທະນາ: ຂໍ້ຄວາມດີບັກ Moodle ພິເສດສໍາລັບນັກພັດທະນາ';
$string['debugdisplay'] = 'ສະແດງຂໍ້ຄວາມດີບັກ';
$string['debugging'] = 'ດີບັກ';
$string['debugminimal'] = 'ໜ້ອຍທີ່ສຸດ: ສະແດງສະເພາະຂໍ້ຜິດພາດຮ້າຍແຮງ';
$string['debugnone'] = 'ບໍ່ມີ: ຢ່າສະແດງຄວາມຜິດພາດ ຫຼື ການເຕືອນໃດ';
$string['debugnormal'] = 'ປົກກະຕິ: ສະແດງຂໍ້ຜິດພາດ, ຄຳເຕືອນ ແລະ ແຈ້ງການ';
$string['debugpageinfo'] = 'ສະແດງຂໍ້ມູນໜ້າ';
$string['debugsqltrace'] = 'ສະແດງທີ່ມາຂອງການໂທ SQL';
$string['debugsqltrace1'] = 'ສະແດງສະເພາະສາຍໂທດ່ຽວ';
$string['debugsqltrace100'] = 'ສະແດງການຕິດຕາມກອງເຕັມ';
$string['debugsqltrace2'] = 'ສະແດງ 2 ແຖວຂອງການຕິດຕາມກອງ';
$string['debugsqltrace_desc'] = 'ຖ້າເປີດໃຊ້ງານ, ຮ່ອງຮອຍກອງ PHP ບາງສ່ວນ ຫຼື ເຕັມຈະຖືກເພີ່ມເຂົ້າໄປໃນ SQL ເປັນຄໍາເຫັນ.';
$string['debugstringids'] = 'ສະແດງທີ່ມາຂອງສະຕຣິງພາສາ';
$string['debugstringids_desc'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ສ່ວນປະກອບ ແລະ ຕົວລະບຸຕົວອັກສອນຂອງພາສາຈະສະແດງຂຶ້ນເມື່ອ ?strings=1 ຫຼື &strings=1 ມັນໄດ້ຖືກເພີ່ມໃສ່ URL ຂອງໜ້າ.';
$string['debugvalidators'] = 'ສະແດງລິ້ງຕົວກວດສອບ';
$string['defaultcity'] = 'ເມືອງມາດຕະຖານ';
$string['defaultcity_help'] = 'ເມືອງທີ່ເຂົ້າມາທີ່ນີ້ຈະເປັນເມືອງເລີ່ມຕົ້ນເມື່ອສ້າງບັນຊີຜູ້ໃຊ້ໃໝ່.';
$string['defaultformatnotset'] = 'ເກີດຄວາມຜິດພາດໃນການກຳນົດຮູບແບບວິຊາເລີ່ມຕົ້ນ. ກະລຸນາກວດເບິ່ງການຕັ້ງຄ່າເວັບໄຊທ໌.';
$string['defaulthomepage'] = 'ໜ້າເລີ່ມຕົ້ນສຳລັບຜູ້ໃຊ້';
$string['defaultrequestcategory'] = 'ປະເພດເລີ່ມຕົ້ນສໍາລັບການຮ້ອງຂໍລາຍວິຊາ';
$string['defaultsettinginfo'] = 'ຄ່າເລີ່ມຕົ້ນ: {$a}';
$string['defaultuserroleid'] = 'ໜ້າທີ່ເລີ່ມຕົ້ນສໍາລັບຜູ້ໃຊ້ທັງໝົດ';
$string['deleteincompleteusers'] = 'ລຶບຜູ້ໃຊ້ທີ່ບໍ່ສົມບູນພາຍຫຼັງ';
$string['deleteunconfirmed'] = 'ລຶບຜູ້ໃຊ້ທີ່ຕັ້ງບໍ່ຄົບຖ້ວນພາຍຫຼັງ';
$string['deleteuser'] = 'ລຶບຜູ້ໃຊ້';
$string['density'] = 'ຄວາມໜາແໜ້ນ';
$string['denyemailaddresses'] = 'ໂດເມນອີເມລຖືກປະຕິເສດ';
$string['development'] = 'ການພັດທະນາ';
$string['devicedetectregex'] = 'ການກວດຫາອຸປະກອນທີ່ສະແດງອອກເປັນປົກກະຕິ';
$string['devicedetectregex_desc'] = '<p>ໂດຍຄ່າເລີ່ມຕົ້ນ, Moodle ສາມາດກວດຫາອຸປະກອນທີ່ມີຄ່າເລີ່ມຕົ້ນປະເພດ (ຄອມພິວເຕີຕັ້ງໂຕະ, ແລັບທັອບ, ແລະອື່ນໆ), ມືຖື (ໂທລະສັບ ແລະ ອຸປະກອນມືນ້ອຍ), ແທັບເລັດ (iPads, ແທັບເລັດ Android) ແລະ ລຸ້ນເກົ່າ (ຜູ້ໃຊ້ Internet Explorer 6). ຕົວເລືອກຮູບແບບສີສັນສາມາດໃຊ້ເພື່ອນຳໃຊ້ຫົວຂໍ້ແຍກຕ່າງຫາກກັບທັງໝົດນີ້. ການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ມີການສະແດງອອກເປັນປົກກະຕິທີ່ອະນຸຍາດໃຫ້ມີການກວດຫາປະເພດອຸປະກອນພິເສດ (ສິ່ງເຫຼົ່ານີ້ມີຄວາມສໍາຄັນຫຼາຍກວ່າປະເພດເລີ່ມຕົ້ນ).</p>
<p>ຕົວຢ່າງ: ເຈົ້າສາມາດໃສ່ໂຕສະແດງປົກກະຕິ \'/(MIDP-1.0|Maemo|Windows CE)/\' ເພື່ອກວດຫາໂທລະສັບຄຸນສົມບັດບາງອັນທີ່ນໍາໃຊ້ທົ່ວໄປແລ້ວເພີ່ມມູນຄ່າການກັບຄືນ \'featurephone\'. ສິ່ງນີ້ເພີ່ມ \'featurephone\' ໃສ່ຕົວເລືອກຮູບແບບສີສັນທີ່ຈະເຮັດໃຫ້ທ່ານສາມາດເພີ່ມຊຸດຮູບແບບທີ່ຈະໃຊ້ຢູ່ໃນອຸປະກອນເຫຼົ່ານີ້ໄດ້. ໂທລະສັບອື່ນຈະຍັງຄົງໃຊ້ຮູບແບບສີສັນທີ່ເລືອກສຳລັບປະເພດອຸປະກອນມືຖືຢູ່.</p>';
$string['devicedetectregexexpression'] = 'ສະແດງອອກເປັນປົກກະຕິ';
$string['devicedetectregexvalue'] = 'ຄືນມູນຄ່າ';
$string['devicetype'] = 'ປະເພດອຸປະກອນ';
$string['devlibdirpresent'] = 'ບັນຊີລາຍຊື່ທີ່ມີຫ້ອງສະມຸດພັດທະນາ, ໂດຍສະເພາະ <em>/vendor</em> ແລະ <em>/node_modules</em>, ບໍ່ຄວນມີຢູ່ໃນສະຖານທີ່ສາທາລະນະ. ເບິ່ງ <a href="{$a->moreinfourl}">ລາຍງານສະພາບລວມຄວາມປອດໄພ</a> ສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ.';
$string['disabled'] = 'ປິດໃຊ້ງານ';
$string['disableuserimages'] = 'ປິດການນຳໃຊ້ຮູບໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້';
$string['displayerrorswarning'] = 'ການເປີດໃຊ້ງານການຕັ້ງຄ່າ PHP <em>display_errors</em> ແມ່ນບໍ່ແນະນໍາຢູ່ໃນບ່ອນຜະລິດ ເພາະວ່າບາງຂໍ້ຄວາມຜິດພາດອາດຈະເປີດເຜີຍຂໍ້ມູນທີ່ລະອຽດອ່ອນກ່ຽວກັບເຊີບເວີຂອງທ່ານ.';
$string['displayloginfailures'] = 'ສະແດງຄວາມລົ້ມເຫຼວໃນການເຂົ້າສູ່ລະບົບ';
$string['divertallemails'] = 'ການຫັນອີເມລ';
$string['divertallemailsdetail'] = 'ໃຊ້ເປັນເຄື່ອງປ້ອງກັນໃນສະພາບແວດລ້ອມການພັດທະນາເມື່ອທົດສອບອີເມລ ແລະ ບໍ່ຄວນໃຊ້ໃນການຜະລິດ.';
$string['divertallemailsexcept'] = 'ຂໍ້ຍົກເວັ້ນການບຽງແບນອີເມວ';
$string['divertallemailsexcept_desc'] = 'ລາຍຊື່ຂອງກົດລະບຽບການຍົກເວັ້ນອີເມລທີ່ແຍກກັນດ້ວຍໝາຍຈຸດ ຫຼື ແຖວໃໝ່. ກົດລະບຽບແຕ່ລະອັນຖືກຕີຄວາມໝາຍເປັນສໍານວນປົກກະຕິເຊັ່ນ: <pre> <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'ປ່ຽນທິດທາງອີເມວທັງໝົດ';
$string['divertallemailsto_desc'] = 'ຖ້າຕັ້ງແລ້ວອີເມລທັງໝົດຈະຖືກປ່ຽນໄປຫາທີ່ຢູ່ອີເມວແທນ.';
$string['dndallowtextandlinks'] = 'ລາກ ແລະ ວາງການອັບໂຫຼດຂໍ້ຄວາມ/ລິ້ງ';
$string['doclang'] = 'ພາສາສຳລັບເອກະສານ';
$string['docroot'] = 'ຮາກເອກະສານ Moodle Docs';
$string['doctonewwindow'] = 'ເປີດຢູ່ໃນປ່ອງຢ້ຽມໃຫມ່';
$string['doesnotfit'] = 'ການຕັ້ງຄ່າການສະແດງອີເມລ';
$string['doesnotfitdetail'] = 'ສະແດງການຕັ້ງຄ່າສໍາລັບການອອກຈາກອີເມລ Moodle.';
$string['download'] = 'ດາວໂຫຼດ';
$string['downloadcoursecontentallowed'] = 'ມີຄຸນສົມບັດດາວໂຫຼດເນື້ອໃນວິຊາ';
$string['downloadcoursecontentallowed_desc'] = 'ບໍ່ວ່າຄຸນສົມບັດການດາວໂຫຼດເນື້ອໃນວິຊາຈະມີໃຫ້ກັບວິຊາຫຼືບໍ່. ເມື່ອມີໃຫ້, ການດາວໂຫຼດເນື້ອໃນວິຊາສາມາດຖືກເປີດ/ປິດໃຊ້ງານໂດຍໃຊ້ການຕັ້ງຄ່າ "ເປີດໃຊ້ການດາວໂຫຼດເນື້ອໃນວິຊາ" ຢູ່ພາຍໃນເມນູແກ້ໄຂວິຊາ (ມາດຕະຖານສໍາລັບສິ່ງນີ້ສາມາດຕັ້ງຢູ່ໃນ <a href={$a} target="_blank">ການຕັ້ງຄ່າວິຊາມາດຕະຖານ</a>).';
$string['durationunits'] = 'ຫົວໜ່ວຍໄລຍະເວລາ';
$string['edithelpdocs'] = 'ແກ້ໄຂເອກະສານຊ່ວຍເຫຼືອ';
$string['editlang'] = '<b>ແກ້ໄຂ</b>';
$string['editorbackgroundcolor'] = 'ສີພື້ນຫຼັງ';
$string['editordictionary'] = 'ວັດຈະນານຸກົມ';
$string['editorfontfamily'] = 'ຄອບຄົວຕົວອັກສອນ';
$string['editorfontlist'] = 'ລາຍຊື່ຕົວອັກສອນ';
$string['editorfontsize'] = 'ຂະໜາດຕົວອັກສອນ';
$string['editorhidebuttons'] = 'ປຸ່ມທີ່ເຊື່ອງໄວ້';
$string['editorkillword'] = 'ຕົວກັ່ນຕອງຮູບແບບຄຳສັບ';
$string['editorspelling'] = 'ຕົວສະກົດຄຳແກ້ໄຂ';
$string['editorspellinghelp'] = 'ເປີດ ຫຼື ປິດການກວດການສະກົດຄໍາ. ເມື່ອເປີດນຳໃຊ້, <strong>aspell</strong> ຈະຕ້ອງຖືກຕິດຕັ້ງໃສ່ເຊີບເວີ.';
$string['editstrings'] = 'ແກ້ໄຂຄຳສັບ ຫຼື ປະໂຫຍກ';
$string['emailchangeconfirmation'] = 'ການຢືນຢັນການປ່ຽນແປງອີເມລ';
$string['emaildkim'] = 'ການເຊັນອີເມລຂອງ DomainKeys Identified Mail (DKIM)';
$string['emaildkiminfo'] = 'ຖ້າທັງສອງໄດ້ຕັ້ງຕົວເລືອກ DKIM ແລະ ພົບໄຟລ໌ໃບຢັ້ງຢືນສ່ວນຕົວທີ່ກົງກັບໂດເມນທີ່ຢູ່ "ຈາກ" ຂອງອີເມວໃນ $CFG->dataroot/dkim/[domain]/[selector].private ແລ້ວອີເມລຈະຖືກເຊັນ. ໃນກໍລະນີສ່ວນໃຫຍ່ (ຕົວຢ່າງ: ຖ້າອະນຸຍາດໃຫ້ໂດເມນຍ່ອຍຫວ່າງເປົ່າ) ມີພຽງໃບຢັ້ງຢືນອັນດຽວເທົ່ານັ້ນທີ່ຕ້ອງການຢູ່ໃນ <pre>{$a->path}</pre>. ສໍາລັບລາຍລະອຽດການຕັ້ງເພີ່ມເຕີມ, ເບິ່ງເອກະສານ <a href="{$a->docs}">Mail configuration</a>.';
$string['emaildkimselector'] = 'ຕົວເລືອກ DKIM';
$string['emailfromvia'] = 'ອີເມລຜ່ານຂໍ້ມູນຂ່າວສານ';
$string['emailheaders'] = 'ສ່ວນຫົວອີເມວ';
$string['emailsubjectprefix'] = 'ຂໍ້ຄວາມຄຳນຳໜ້າຫົວຂໍ້ອີເມລ';
$string['emoticonalt'] = 'ຂໍ້ຄວາມທາງເລືອກ';
$string['emoticoncomponent'] = 'ອົງປະກອບຂອງຮູບພາບ';
$string['emoticonimagename'] = 'ຊື່ຮູບພາບ';
$string['emoticons'] = 'ອີໂມຕິຄອນ';
$string['emoticons_desc'] = 'ແບບຟອມນີ້ກຳນົດອີໂມຕິຄອນ (ຫຼື ຮອຍຍິ້ມ) ທີ່ໃຊ້ຢູ່ໃນເວັບໄຊທ໌ຂອງທ່ານ. ເພື່ອເອົາແຖວອອກຈາກຕາຕະລາງ, ບັນທຶກແບບຟອມດ້ວຍຄ່າຫວ່າງເປົ່າຢູ່ໃນຊ່ອງຂໍ້ມູນທີ່ຕ້ອງການ. ເພື່ອລົງທະບຽນອີໂມຕິຄອນໃໝ່, ຕື່ມຂໍ້ມູນໃສ່ໃນແຖວຫວ່າງສຸດທ້າຍ. ເພື່ອເປີດຄືນໃໝ່ຊ່ອງຂໍ້ມູນທັງໝົດເປັນຄ່າເລີ່ມຕົ້ນ, ປະຕິບັດຕາມລິ້ງຂ້າງເທິງ.

* ຂໍ້ຄວາມ (ຕ້ອງການ) - ຂໍ້ຄວາມນີ້ຈະຖືກແທນທີ່ດ້ວຍຮູບພາບອີໂມຕິຄອນ. ມັນຕ້ອງມີຄວາມຍາວຢ່າງໜ້ອຍສອງຕົວອັກສອນ.
* ຊື່ຮູບພາບ (ຕ້ອງການ) - ຊື່ໄຟລ໌ຮູບພາບອີໂມຕິຄອນທີ່ບໍ່ມີນາມສະກຸນ, ກ່ຽວຂ້ອງກັບສ່ວນປະກອບຂອງໂຟນເດີ pix.
* ອົງປະກອບຮູບພາບ (ຕ້ອງການ) - ອົງປະກອບທີ່ສະໜອງໄອຄອນ.
* ຂໍ້ຄວາມທາງເລືອກ (ທາງເລືອກ) - ຕົວລະບຸຕົວອັກສອນ ແລະ ສ່ວນປະກອບຂອງຂໍ້ຄວາມທາງເລືອກຂອງອີໂມຕິຄອນ.';
$string['emoticonsreset'] = 'ຣີເຊັດການຕັ້ງຄ່າອີໂມຕິຄອນເປັນຄ່າເລີ່ມຕົ້ນ';
$string['emoticontext'] = 'ຂໍ້ຄວາມ';
$string['emptysettingvalue'] = 'ຫວ່າງເປົ່າ';
$string['enableactivitychooser'] = 'ເປີດໃຊ້ງານຕົວເລືອກກິດຈະກໍາ';
$string['enableanalytics'] = 'ການວິເຄາະ';
$string['enableblogs'] = 'ເປີດໃຊ້ບລ໋ອກ';
$string['enablecalendarexport'] = 'ເປີດໃຊ້ງານການສົ່ງອອກປະຕິທິນ';
$string['enablecomments'] = 'ເປີດໃຊ້ຄຳເຫັນ';
$string['enablecourserelativedates'] = 'ເປີດໃຊ້ວັນທີທີ່ກ່ຽວຂ້ອງຂອງຫຼັກສູດ';
$string['enablecourserelativedates_desc'] = 'ອະນຸຍາດໃຫ້ຕັ້ງວິຊາ ເພື່ອສະແດງວັນທີທີ່ກ່ຽວຂ້ອງກັບວັນທີເລີ່ມຕົ້ນຂອງຜູ້ໃຊ້ໃນວິຊາ.';
$string['enablecourserequests'] = 'ເປີດການຮ້ອງຂໍວິຊາ';
$string['enabled'] = 'ເປີດໃຊ້ງານແລ້ວ';
$string['enabledashboard'] = 'ເປີດໃຊ້ງານແຜງໜ້າປັດ';
$string['enabledashboard_help'] = 'ແຜງໜ້າປັດ ສະແດງເສັ້ນເວລາ, ປະຕິທິນ ແລະ ລາຍການທີ່ເຂົ້າເຖິງຫຼ້າສຸດໂດຍຄ່າເລີ່ມຕົ້ນ. ທ່ານສາມາດຕັ້ງ ແຜງໜ້າປັດ ເລີ່ມຕົ້ນທີ່ແຕກຕ່າງກັນສໍາລັບທຸກຄົນ ແລະ ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ສາມາດປັບແຕ່ງ ແຜງໜ້າປັດ ຂອງຕົນເອງໄດ້. ຖ້າປິດໃຊ້ງານ, ທ່ານຈໍາເປັນຕ້ອງຕັ້ງ \'ໜ້າເລີ່ມຕົ້ນສໍາລັບຜູ້ໃຊ້\' ເປັນຄ່າອື່ນນອກເໜືອຈາກ ແຜງໜ້າປັດ.';
$string['enabledevicedetection'] = 'ເປີດໃຊ້ການກວດຫາອຸປະກອນ';
$string['enableglobalsearch'] = 'ເປີດນຳໃຊ້ການຄົ້ນຫາທົ່ວໂລກ';
$string['enableglobalsearch_desc'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ຂໍ້ມູນຈະຖືກຈັດດັດຊະນີ ແລະ ຊິງຄ໌ໂດຍວຽກທີ່ກໍານົດໄວ້.';
$string['enablegravatar'] = 'ເປີດນຳໃຊ້ Gravatar';
$string['enablegravatar_help'] = 'ເມື່ອເປີດໃຊ້ Moodle ຈະພະຍາຍາມເອົາຮູບໂປຼໄຟລ໌ຜູ້ໃຊ້ຈາກ Gravatar ຖ້າຜູ້ໃຊ້ບໍ່ໄດ້ອັບໂຫຼດຮູບພາບ.';
$string['enablemobilewebservice'] = 'ເປີດໃຊ້ບໍລິການເວັບສຳລັບອຸປະກອນມືຖື';
$string['enablerecordcache'] = 'ເປີດໃຊ້ບັນທຶກ ແຄດ';
$string['enablerssfeeds'] = 'ເປີດນຳໃຊ້ຟີດ RSS';
$string['enablesearchareas'] = 'ເປີດໃຊ້ພື້ນທີ່ຄົ້ນຫາ';
$string['enablestats'] = 'ເປີດໃຊ້ສະຖິຕິ';
$string['enabletrusttext'] = 'ເປີດໃຊ້ເນື້ອຫາທີ່ເຊື່ອຖືໄດ້';
$string['enableuserfeedback'] = 'ເປີດນຳໃຊ້ຄຳຕິຊົມກ່ຽວກັບຊອບແວນີ້';
$string['enableuserfeedback_desc'] = 'ຖ້າເປີດນຳໃຊ້, ລິ້ງ \'ໃຫ້ຄຳຕິຊົມກ່ຽວກັບຊອບແວນີ້\' ສະແດງຂຶ້ນຢູ່ໃນສ່ວນທ້າຍ ເພື່ອໃຫ້ຜູ້ໃຊ້ໃຫ້ຄຳຕິຊົມກ່ຽວກັບຊອບແວ Moodle ຫາ Moodle HQ. ຖ້າຕົວເລືອກ \'ການເຕືອນຄຳຕິຊົມຄັ້ງຕໍ່ໄປ\' ຖືກຕັ້ງ, ຜູ້ໃຊ້ຍັງໄດ້ສະແດງການເຕືອນຢູ່ເທິງແຜງໜ້າປັດໃນຊ່ວງເວລາທີ່ລະບຸ. ການຕັ້ງ \'ການເຕືອນຄຳຕິຊົມຄັ້ງຕໍ່ໄປ\' ເປັນ \'ບໍ່ຕັ້ງຄ່າ\' ຈະປິດການແຈ້ງເຕືອນແຜງໜ້າປັດ, ໃນຂະນະທີ່ອອກຈາກລິ້ງ \'ໃຫ້ຄຳຕິຊົມກ່ຽວກັບຊອບແວນີ້\' ຢູ່ໃນສ່ວນທ້າຍ.';
$string['enablewebservices'] = 'ເປີດໃຊ້ບໍລິການເວັບ';
$string['enablewsdocumentation'] = 'ເອກະສານການບໍລິການເວັບ';
$string['encryptedpassword_edit'] = 'ໃສ່ມູນຄ່າໃໝ່';
$string['encryptedpassword_set'] = '(ຕັ້ງ ແລະ ເຂົ້າລະຫັດ)';
$string['enroladminnewcourse'] = 'ລົງທະບຽນຜູ້ບໍລິຫານອັດຕະໂນມັດໃນຫຼັກສູດໃໝ່';
$string['enroladminnewcourse_help'] = 'ເມື່ອຜູ້ບໍລິຫານເພີ່ມຫຼັກສູດໃໝ່, ເຂົາເຈົ້າຄວນລົງທະບຽນອັດຕະໂນມັດ ແລະແຕ່ງຕັ້ງບົດບາດຂອງຜູ້ສ້າງໃນຫຼັກສູດໃໝ່ຫຼືບໍ?';
$string['enrolinstancedefaults'] = 'ຄ່າເລີ່ມຕົ້ນຕົວຢ່າງການລົງທະບຽນ';
$string['enrolinstancedefaults_desc'] = 'ການຕັ້ງຄ່າການລົງທະບຽນເລີ່ມຕົ້ນຢູ່ໃນຫຼັກສູດໃໝ່.';
$string['enrolmultipleusers'] = 'ລົງທະບຽນຜູ້ໃຊ້';
$string['entitytasklog'] = 'ບັນທຶກໜ້າວຽກ';
$string['environment'] = 'ສະພາບແວດລ້ອມ';
$string['environmenterrortodo'] = 'ເຈົ້າຕ້ອງແກ້ໄຂບັນຫາສິ່ງແວດລ້ອມທັງໝົດ (ຄວາມຜິດພາດ) ທີ່ພົບຢູ່ຂ້າງເທິງກ່ອນດໍາເນີນການຕິດຕັ້ງ Moodle ສະບັບນີ້!';
$string['environmenterrorupgrade'] = 'ຄໍາເຕືອນ: ທ່ານຄວນແກ້ໄຂບັນຫາສິ່ງແວດລ້ອມທັງໝົດ (ຂໍ້ຜິດພາດ) ທີ່ພົບຢູ່ຂ້າງເທິງກ່ອນດໍາເນີນການຍົກລະດັບ Moodle ສະບັບນີ້! ການຍົກລະດັບໂດຍບໍ່ມີການແກ້ໄຂຂໍ້ກຳນົດເຫຼົ່ານີ້ ອາດຈະເຮັດໃຫ້ເກີດບັນຫາເຊັ່ນ: ການສູນເສຍຂໍ້ມູນ. ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການສືບຕໍ່ການຍົກລະດັບ?';
$string['environmentmariadbwrongdbtype'] = '<code>$CFG->dbtype</code> ຜິດ: ທ່ານຕ້ອງການປ່ຽນມັນຢູ່ໃນໄຟລ໌ <code>config.php</code> ຂອງທ່ານ, ຈາກ \'<code>mysql</code>\' ເປັນ \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'ການຕັ້ງຄ່າ PHP ຕ້ອງປ່ຽນແປງ.';
$string['environmentok'] = 'ສະພາບແວດລ້ອມເຊີບເວີຂອງທ່ານຕອບສະໜອງໄດ້ທຸກຄວາມຕ້ອງການຂັ້ນຕໍ່າ.';
$string['environmentrecommendcustomcheck'] = 'ຖ້າການທົດສອບນີ້ລົ້ມເຫຼວ, ມັນບົ່ງບອກເຖິງບັນຫາທີ່ອາດຈະເກີດຂຶ້ນ';
$string['environmentrecommendinstall'] = 'ຄວນຕິດຕັ້ງ ແລະ ເປີດໃຊ້ງານເພື່ອໃຫ້ໄດ້ຜົນດີທີ່ສຸດ';
$string['environmentrecommendversion'] = 'ແນະນຳໃຫ້ໃຊ້ສະບັບ {$a->needed} ແລະ ທ່ານກຳລັງໃຊ້ງານ {$a->current}';
$string['environmentrequirecustomcheck'] = 'ການສອບເສັງນີ້ຕ້ອງຜ່ານ';
$string['environmentrequireinstall'] = 'ຕ້ອງໄດ້ຕິດຕັ້ງ ແລະ ເປີດໃຊ້ງານ';
$string['environmentrequireversion'] = 'ຕ້ອງການສະບັບ {$a->needed} ແລະ ທ່ານກຳລັງໃຊ້ງານ {$a->current}';
$string['environmentsettingok'] = 'ກວດພົບການຕັ້ງຄ່າທີ່ແນະນຳ';
$string['environmentshouldfixsetting'] = 'ການຕັ້ງຄ່າ PHP ຄວນປ່ຽນແປງ.';
$string['environmentxmlerror'] = 'ເກີດຄວາມຜິດພາດໃນການອ່ານຂໍ້ມູນສະພາບແວດລ້ອມ ({$a->error_code})';
$string['errordeletingconfig'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນຂະນະທີ່ລຶບບັນທຶກການຕັ້ງຄ່າສໍາລັບປລັກອິນ \'{$a}\'.';
$string['errorsetting'] = 'ບໍ່ສາມາດບັນທຶກການຕັ້ງຄ່າໄດ້:';
$string['errorwithsettings'] = 'ການຕັ້ງຄ່າບາງອັນບໍ່ໄດ້ຖືກປ່ຽນແປງເນື່ອງຈາກຄວາມຜິດພາດ.';
$string['eventshandlersinuse'] = 'ປລັກອິນຕໍ່ໄປນີ້ຢູ່ໃນລະບົບຂອງທ່ານທີ່ກໍາລັງໃຊ້ຕົວຈັດການ Events 1 API: \'{$a}\'. ກະລຸນາອັບເດດພວກມັນເພື່ອໃຊ້ Events 2 API. ເບິ່ງ https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'ທຸກຄົນທີ່ສາມາດ \'{$a}\'';
$string['exceptions'] = 'ຂໍ້ຍົກເວັ້ນ';
$string['execpathnotallowed'] = 'ການກໍານົດເສັ້ນທາງທີ່ສາມາດປະຕິບັດໄດ້ ແລະ ທາງທ້ອງຖິ່ນປິດໃຊ້ງານຢູ່ໃນ config.php';
$string['experimental'] = 'ການທົດລອງ';
$string['experimentalsettings'] = 'ການຕັ້ງຄ່າທົດລອງ';
$string['extendedusernamechars'] = 'ອະນຸຍາດໃຫ້ມີຕົວອັກສອນຂະຫຍາຍຢູ່ໃນຊື່ຜູ້ໃຊ້';
$string['extramemorylimit'] = 'ຈຳກັດຄວາມຈຳ PHP ພິເສດ';
$string['fatalsessionautostart'] = '<p>ກວດພົບຂໍ້ຜິດພາດການຕັ້ງຄ່າທີ່ຮຸນແຮງ, ກະລຸນາແຈ້ງຜູ້ຄວບຄຸມເຊີບເວີ.</p><p> ເພື່ອປະຕິບັດໄດ້ຢ່າງຖືກຕ້ອງ, Moodle ຕ້ອງການໃຫ້ຜູ້ຄວບຄຸມປ່ຽນການຕັ້ງຄ່າ PHP. </p><p><code>session.auto_start</code> ຕ້ອງຕັ້ງເປັນ <code>ປິດ</code>.</p><p>ການຕັ້ງຄ່ານີ້ຖືກຄວບຄຸມໂດຍການແກ້ໄຂ<code>php.ini</code>, Apache/IIS <br />ການກຳນົດຄ່າຫຼື<code>.htaccess</code> ໄຟລ໌ຢູ່ໃນເຊີບເວີ.</p>';
$string['feedbacksettings'] = 'ການຕັ້ງຄ່າຄຳຕິຊົມ';
$string['fileconversioncleanuptask'] = 'ທຳຄວາມສະອາດບັນທຶກຊົ່ວຄາວສຳລັບການປ່ຽນໄຟລ໌';
$string['filecreated'] = 'ສ້າງໄຟລ໌ໃໝ່ແລ້ວ';
$string['filescleanupperiod'] = 'ເຮັດຄວາມສະອາດໄຟລ໌ພູລ໌ຂີ້ເຫຍື້ອ';
$string['filescleanupperiod_help'] = 'ໄຟລ໌ພູລ໌ຂີ້ເຫຍື້ອຖືກລຶບເລື້ອຍປານໃດ. ສິ່ງເຫຼົ່ານີ້ແມ່ນໄຟລ໌ທີ່ເຊື່ອມໂຍງກັບບໍລິບົດທີ່ບໍ່ມີອີກຕໍ່ໄປ, ຕົວຢ່າງ: ເມື່ອຫຼັກສູດຖືກລຶບ. ກະລຸນາບັນທຶກໄວ້ວ່າ: ການຕັ້ງຄ່ານີ້ສາມາດເຮັດໃຫ້ໄຟລ໌ຫາຍໄປຢູ່ໃນວິຊາທີ່ຖືກສໍາຮອງໄວ້, ລຶບໄປແລ້ວ ແລະ ກູ້ຄືນໄດ້ຖ້າການຕັ້ງຄ່າ \'ລວມເອົາໄຟລ໌\' \'(backup_auto_files) ຢູ່ໃນ \'ການຕັ້ງຄ່າການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດ\' ຖືກປິດໃຊ້ງານ.';
$string['filesizeunits'] = 'ຫົວໜ່ວຍຂະໜາດໄຟລ໌';
$string['filestoredin'] = 'ບັນທຶກໄຟລ໌ເຂົ້າໃນໂຟນເດີ:';
$string['filestoredinhelp'] = 'ບ່ອນທີ່ໄຟລ໌ຈະຖືກຈັດເກັບ';
$string['filterall'] = 'ຕົວກອງສະຕຣິງທັງໝົດ';
$string['filtermatchoneperpage'] = 'ຕົວກອງກົງກັນໜຶ່ງເທື່ອຕໍ່ໜ້າ';
$string['filtermatchonepertext'] = 'ຕົວກອງກົງກັນໜຶ່ງເທື່ອຕໍ່ຂໍ້ຄວາມ';
$string['filternavigationwithsystemcontext'] = 'ການນຳທາງຕົວກັ່ນຕອງກັບບໍລິບົດລະບົບ';
$string['filters'] = 'ຕົວກອງ';
$string['filtersettings'] = 'ຈັດການຕົວກອງ';
$string['filtersettingsgeneral'] = 'ການຕັ້ງຄ່າຕົວກອງທົ່ວໄປ';
$string['filteruploadedfiles'] = 'ຕົວກອງໄຟລ໌ອັບໂຫຼດແລ້ວ';
$string['forceclean'] = 'ການອະນາໄມເນື້ອໃນຢູ່ທົ່ວທຸກແຫ່ງ';
$string['forceclean_desc'] = 'ໂດຍປົກກະຕິແລ້ວເນື້ອຫາທີ່ເພີ່ມໃສ່ເວັບໄຊທ໌ ແມ່ນຖືກອະນາໄມກ່ອນທີ່ຈະຖືກສະແດງອອກ, ເພື່ອເອົາສິ່ງໃດໜຶ່ງທີ່ອາດຈະເປັນໄພຂົ່ມຂູ່ຕໍ່ຄວາມປອດໄພອອກໄປ. ຢ່າງໃດກໍ່ຕາມ, ເນື້ອໃນບໍ່ໄດ້ຖືກອະນາໄມຢູ່ໃນບາງບ່ອນເຊັ່ນ: ຄໍາອະທິບາຍກິດຈະກໍາ, ໜ້າແຫຼ່ງຂໍ້ມູນ ຫຼື ບລັອກ HTML ເພື່ອອະນຸຍາດໃຫ້ເພີ່ມສະຄຣິບ, ສື່, ເຟຣມໃນແຖວ ແລະອື່ນໆ. ຖ້າການຕັ້ງຄ່ານີ້ເປີດໃຊ້ງານ, ທຸກເນື້ອໃນຈະຖືກອະນາໄມ. ສິ່ງນີ້ອາດຈະເຮັດໃຫ້ເນື້ອໃນທີ່ມີຢູ່ແລ້ວບໍ່ສະແດງຢ່າງຖືກຕ້ອງອີກຕໍ່ໄປ.';
$string['forcelogin'] = 'ບັງຄັບໃຫ້ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບ';
$string['forceloginforprofileimage'] = 'ບັງຄັບໃຫ້ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບເພື່ອເບິ່ງຮູບຂອງຜູ້ໃຊ້';
$string['forceloginforprofileimage_help'] = 'ຖ້າເປີດໃຊ້ແລ້ວ, ຜູ້ໃຊ້ຕ້ອງເຂົ້າສູ່ລະບົບເພື່ອເບິ່ງຮູບໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້ ແລະ ຮູບຜູ້ໃຊ້ມາດຕະຖານຈະຖືກໃຊ້ຢູ່ໃນທຸກອີເມວແຈ້ງເຕືອນ.';
$string['forceloginforprofiles'] = 'ບັງຄັບໃຫ້ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບສຳລັບໂປຼໄຟລ໌';
$string['forcetimezone'] = 'ບັງຄັບໃຊ້ເຂດເວລາ';
$string['formatuninstallwithcourses'] = 'ມີວິຊາ {$a->count} ໂດຍໃຊ້ {$a->format}. ຮູບແບບຂອງເຂົາເຈົ້າຈະຖືກປ່ຽນເປັນ {$a->defaultformat} (ຮູບແບບມາດຕະຖານສໍາລັບເວັບໄຊທ໌ນີ້). ບາງຂໍ້ມູນສະເພາະຮູບແບບອາດຈະສູນເສຍໄປ. ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການດຳເນີນການຕໍ່?';
$string['frontpage'] = 'ໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpagebackup'] = 'ການສຳຮອງຂໍ້ມູນໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpagedefaultrole'] = 'ໜ້າທີ່ຫຼັກເວັບໄຊທ໌ເລີ່ມຕົ້ນ';
$string['frontpagefilters'] = 'ຕົວກັ່ນຕອງໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpageloggedin'] = 'ລາຍການໜ້າຫຼັກເວັບໄຊທ໌ເມື່ອເຂົ້າສູ່ລະບົບ';
$string['frontpageoverrides'] = 'ລົບລ້າງການອະນຸຍາດໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpagequestions'] = 'ຄຳຖາມໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpagerestore'] = 'ກູ້ຄືນໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpageroles'] = 'ໜ້າທີ່ໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpagesettings'] = 'ການຕັ້ງຄ່າໜ້າຫຼັກເວັບໄຊທ໌';
$string['fullnamedisplay'] = 'ຮູບແບບຊື່ເຕັມ';
$string['fullnamedisplayprivate'] = 'ຮູບແບບຊື່ເຕັມ - ສ່ວນຕົວ';
$string['gdrequired'] = 'ດຽວນີ້ Moodle ຕ້ອງການສ່ວນຂະຫຍາຍ GD ສຳລັບການປ່ຽນຮູບພາບ.';
$string['generalsettings'] = 'ການຕັ້ງຄ່າທົ່ວໄປ';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'ບັນທຶກແຫຼ່ງທີ່ຢູ່ IP';
$string['globalsearch'] = 'ຄົ້ນຫາທົ່ວໂລກ';
$string['globalsearchmanage'] = 'ຈັດການການຄົ້ນຫາທົ່ວໂລກ';
$string['googlemapkey3'] = 'ປຸ່ມ Google Maps API V3';
$string['googlemapkey3_help'] = 'ທ່ານຕ້ອງໃສ່ລະຫັດພິເສດເພື່ອໃຊ້ Google ແຜນທີ່ ສໍາລັບການຊອກຫາທີ່ຢູ່ IP. ເຈົ້າສາມາດຂໍເອົາລະຫັດໄດ້ໂດຍບໍ່ເສຍຄ່າທີ່ <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'ໄປຫາສະຕຣິງທີ່ຂາດໄປທຳອິດ';
$string['gradebook'] = 'ປື້ມຄະແນນ';
$string['gradebookroles'] = 'ໜ້າທີ່ທີ່ໃຫ້ຄະແນນ';
$string['gradeexport'] = 'ວິທີການສົ່ງອອກຄະແນນຫຼັກ';
$string['gravatardefaulturl'] = 'URL ຮູບພາບເລີ່ມຕົ້ນຂອງ Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar ຕ້ອງການຮູບພາບເລີ່ມຕົ້ນ ເພື່ອສະແດງຖ້າມັນບໍ່ສາມາດຊອກຫາຮູບສໍາລັບຜູ້ໃຊ້ທີ່ກໍານົດໄວ້. ໃຫ້ URL ເຕັມສຳລັບຮູບພາບ. ຖ້າທ່ານປ່ອຍໃຫ້ການຕັ້ງຄ່ານີ້ຫວ່າງເປົ່າ, Moodle ຈະພະຍາຍາມໃຊ້ຮູບມາດຕະຖານທີ່ເໝາະສົມທີ່ສຸດສໍາລັບໜ້າ ທີ່ທ່ານກໍາລັງເບິ່ງ. ກະລຸນາຮັບຊາບວ່າ Gravatar ມີລະຫັດຈໍານວນໜຶ່ງທີ່ສາມາດໃຊ້ເພື່ອ <a href="https://en.gravatar.com/site/implement/images/#default-image">generate default images</a>.';
$string['groupenrolmentkeypolicy'] = 'ນະໂຍບາຍຫຼັກຂອງການລົງທະບຽນເປັນກຸ່ມ';
$string['groupenrolmentkeypolicy_desc'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ກະແຈການລົງທະບຽນເປັນກຸ່ມຈະຖືກກວດກາກັບນະໂຍບາຍລະຫັດຜ່ານຕາມທີ່ກໍານົດໄວ້ຢູ່ໃນການຕັ້ງຄ່າຂ້າງເທິງ.';
$string['guestroleid'] = 'ໜ້າທີ່ສຳລັບແຂກ';
$string['guestroleid_help'] = 'ໜ້າທີ່ນີ້ຖືກແຕ່ງຕັ້ງໂດຍອັດຕະໂນມັດໃຫ້ກັບຜູ້ໃຊ້ແຂກ. ມັນຍັງຖືກແຕ່ງຕັ້ງຊົ່ວຄາວໃຫ້ກັບຜູ້ໃຊ້ທີ່ບໍ່ໄດ້ລົງທະບຽນເຂົ້າລາຍວິຊາ ຜ່ານປລັກອິນການລົງທະບຽນຂອງແຂກ.';
$string['h5pgetcontenttypestask'] = 'ດາວໂຫຼດປະເພດເນື້ອຫາ H5P ທີ່ມີໄດ້ຈາກ h5p.org';
$string['helpadminseesall'] = 'ຢູ່ໃນປະຕິທິນຂອງເວັບໄຊທ໌, ຜູ້ເບິ່ງແຍງລະບົບເຫັນ ແລະ ກັ່ນຕອງເຫດການຈາກປະຕິທິນວິຊາທັງໝົດ ຫຼື ພຽງແຕ່ມາຈາກວິຊາທີ່ເຂົາເຈົ້າລົງທະບຽນຢູ່ບໍ? ໂດຍບໍ່ຄໍານຶງເຖິງຕົວເລືອກທີ່ເລືອກ, ຜູ້ເບິ່ງແຍງລະບົບຈະສາມາດຈັດການເຫດການສໍາລັບແຕ່ລະປະຕິທິນລາຍວິຊາໄດ້ສະເໝີໂດຍການນໍາທາງໄປຫາຫຼັກສູດກ່ອນ, ແລະ ຈາກນັ້ນເຂົ້າເຖິງປະຕິທິນລາຍວິຊາໂດຍກົງ.';
$string['helpcalendarcustomexport'] = 'ເປີດໃຊ້ຕົວເລືອກການສົ່ງອອກຊ່ວງວັນທີແບບກຳນົດເອງຢູ່ໃນການສົ່ງອອກປະຕິທິນ. ການສົ່ງອອກປະຕິທິນຈະຕ້ອງຖືກເປີດນຳໃຊ້ກ່ອນທີ່ສິ່ງນີ້ຈະມີຜົນສັກສິດ.';
$string['helpexportlookahead'] = 'ປະຕິທິນຊອກຫາເຫດການໃນລະຫວ່າງການສົ່ງອອກສໍາລັບທາງເລືອກການສົ່ງອອກແບບກໍານົດເອງຢູ່ໄດ້ໃນອະນາຄົດຈັກມື້?';
$string['helpexportlookback'] = 'ປະຕິທິນຊອກຫາເຫດການໃນລະຫວ່າງການສົ່ງອອກສໍາລັບທາງເລືອກການສົ່ງອອກແບບກຳນົດເອງແມ່ນຈັກມື້?';
$string['helpforcetimezone'] = 'ເຈົ້າສາມາດອະນຸຍາດໃຫ້ຜູ້ໃຊ້ເລືອກເຂດເວລາຂອງເຂົາເຈົ້າເປັນແຕ່ລະອັນ ຫຼື ບັງຄັບເຂດເວລາໃຫ້ກັບທຸກຄົນໄດ້.';
$string['helpshowicalsource'] = 'ຖ້າເປີດໃຊ້ງານ, ຊື່ການສະໝັກໃຊ້ ແລະ ລິ້ງຈະຖືກສະແດງໃຫ້ເຫັນສໍາລັບເຫດການທີ່ນໍາເຂົ້າຈາກ iCal.';
$string['helpsitemaintenance'] = 'ສໍາລັບການຍົກລະດັບ ແລະ ວຽກງານອື່ນ';
$string['helpstartofweek'] = 'ມື້ໃດເລີ່ມຕົ້ນອາທິດຢູ່ໃນປະຕິທິນ?';
$string['helpupcominglookahead'] = 'ປະຕິທິນຊອກຫາເຫດການທີ່ຈະມາເຖິງຕາມຄ່າເລີ່ມຕົ້ນເປັນເວລາຈັກມື້ໃນອະນາຄົດ?';
$string['helpupcomingmaxevents'] = 'ຈໍານວນເຫດການທີ່ຈະມາເຖິງ (ສູງສຸດ) ຖືກສະແດງຕໍ່ກັບຜູ້ໃຊ້ຕາມຄ່າເລີ່ມຕົ້ນຫຼືບໍ?';
$string['helpweekenddays'] = 'ມື້ໃດຂອງອາທິດຖືກຖືວ່າເປັນ "ທ້າຍອາທິດ" ແລະ ສະແດງດ້ວຍສີທີ່ແຕກຕ່າງ?';
$string['hiddenuserfields'] = 'ເຊື່ອງຊ່ອງຂໍ້ມູນຜູ້ໃຊ້';
$string['hidefromall'] = 'ເຊື່ອງຈາກຜູ້ໃຊ້ທັງໝົດ';
$string['hidefromnone'] = 'ເຊື່ອງຈາກບໍ່ມີໃຜ';
$string['hidefromstudents'] = 'ເຊື່ອງຈາກນັກຮຽນ';
$string['hostname'] = 'ຊື່ເຈົ້າພາບ';
$string['htmleditor'] = 'ຕົວແກ້ໄຂ HTML';
$string['htmleditorsettings'] = 'ການຕັ້ງຄ່າຕົວແກ້ໄຂ HTML';
$string['htmlsettings'] = 'ການຕັ້ງຄ່າ HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'ຄວາມປອດໄພ HTTP';
$string['iconvrequired'] = 'ການຕິດຕັ້ງສ່ວນຂະຫຍາຍ ICONV ແມ່ນຕ້ອງການ.';
$string['igbinary322buggyversion'] = 'ສ່ວນຂະຫຍາຍ php-igbinary ຕິດຕັ້ງຢູ່ໃນເວັບໄຊທ໌ສາມາດນໍາໄປສູ່ບັນຫາເມື່ອແລ່ນກັບ PHP 7.2. ທ່ານຖືກແນະນຳໃຫ້ຍົກລະດັບເປັນ php-igbinary 3.2.5 ຫຼືໃໝ່ກວ່າ ຫຼື ທາງເລືອກອື່ນເພື່ອຍົກລະດັບເປັນ PHP 7.3 ຫຼື ໃໝ່ກວ່າ.';
$string['ignore'] = 'ບໍ່ສົນໃຈ';
$string['includemoduleuserdata'] = 'ລວມເອົາຊຸດຂໍ້ມູນຜູ້ໃຊ້';
$string['incompatibleblocks'] = 'ບລັອກທີ່ບໍ່ເຂົ້າກັນໄດ້';
$string['incompleteunicodesupport'] = 'ການຕັ້ງຄ່າປັດຈຸບັນຂອງ MySQL ຫຼື MariaDB ແມ່ນໃຊ້ \'utf8\'. ຊຸດຕົວອັກສອນນີ້ບໍ່ຮອງຮັບສີ່ຕົວອັກສອນໄບຕ໌ ເຊິ່ງປະກອບມີບາງອີໂມຈິ. ການພະຍາຍາມໃຊ້ຕົວອັກສອນເຫຼົ່ານີ້ຈະເຮັດໃຫ້ເກີດຄວາມຜິດພາດເມື່ອອັບເດດບັນທຶກ ແລະ ຂໍ້ມູນໃດ ໜຶ່ງທີ່ຖືກສົ່ງໄປຫາຖານຂໍ້ມູນຈະສູນຫາຍໄປ. ກະລຸນາພິຈາລະນາປ່ຽນການຕັ້ງຄ່າຂອງທ່ານເປັນ \'utf8mb4\'. ເບິ່ງເອກະສານສຳລັບລາຍລະອຽດເຕັມ.';
$string['indexdata'] = 'ຂໍ້ມູນດັດສະນີ';
$string['indexinginfo'] = 'ວິທີທີ່ແນະນໍາໃຫ້ດັດສະນີເນື້ອໃນຂອງເວັບໄຊທ໌ຂອງທ່ານແມ່ນໂດຍການໃຊ້ໜ້າວຽກທີ່ໄດ້ກໍານົດເວລາໄວ້ \'ດັດສະນີຄົ້ນຫາທົ່ວໂລກ.';
$string['installhijacked'] = 'ການຕິດຕັ້ງຕ້ອງສຳເລັດຈາກທີ່ຢູ່ IP ເດີມ, ຂໍອາໄພ.';
$string['installsessionerror'] = 'ບໍ່ສາມາດເລີ່ມຕົ້ນເຊດຊັນ PHP ໄດ້. ກະລຸນາກວດສອບວ່າໂປຼແກຼມທ່ອງເວັບຂອງທ່ານຍອມຮັບຄຸກກີ້.';
$string['intlrecommended'] = 'ສ່ວນຂະຫຍາຍ Intl ແມ່ນໃຊ້ເພື່ອປັບປຸງການສະໜັບສະໜູນການຫັນເປັນສາກົນ, ເຊັ່ນ: ການຈັດຮຽງການຮູ້ຈັກທ້ອງຖິ່ນ.';
$string['intlrequired'] = 'ສ່ວນຂະຫຍາຍ Intl ແມ່ນຕ້ອງການເພື່ອປັບປຸງການສະໜັບສະໜູນການຫັນເປັນສາກົນເຊັ່ນ: ການຈັດຮຽງການຮູ້ຈັກທ້ອງຖິ່ນ ແລະ ຊື່ໂດເມນສາກົນ.';
$string['invalidagedigitalconsent'] = 'ການຍິນຍອມຂອງຍຸກດິຈິຕອນບໍ່ຖືກຕ້ອງ: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL ທີ່ລືມລະຫັດຜ່ານບໍ່ແມ່ນ URL ທີ່ຖືກຕ້ອງ.';
$string['invalidsection'] = 'ພາກທີ່ຖືກຕ້ອງ.';
$string['invalidthemepreset'] = 'ການເລືອກໄຟລ໌ທີ່ຕັ້ງໄວ້ກ່ອນໜ້າບໍ່ເຂົ້າກັນໄດ້ກັບຮູບແບບສີສັນນີ້. ການລວບລວມຄວາມຜິດພາດຂອງ SCSS ແມ່ນ: "{$a}"';
$string['invaliduserchangeme'] = 'ຊື່ຜູ້ໃຊ້ "changeme" ຖືກສະຫງວນໄວ້ - ທ່ານບໍ່ສາມາດສ້າງບັນຊີກັບມັນໄດ້.';
$string['ipblocked'] = 'ເວັບໄຊທ໌ນີ້ບໍ່ສາມາດໃຊ້ໄດ້ໃນເວລານີ້.';
$string['ipblocker'] = 'ຕົວປິດກັ້ນ IP';
$string['ipblockersyntax'] = 'ໃສ່ທຸກ entry ໃນແຖວດຽວ. ລາຍການທີ່ຖືກຕ້ອງແມ່ນທັງທີ່ຢູ່ IP ເຕັມ (ເຊັ່ນ: <b>192.168.10.1</b>) ເຊິ່ງກົງກັບເຈົ້າພາບດຽວ; ຫຼື ທີ່ຢູ່ບາງສ່ວນ (ເຊັ່ນ: <b>192.168</b>) ທີ່ກົງກັບທີ່ຢູ່ໃດກໍ່ຕາມທີ່ເລີ່ມຕົ້ນດ້ວຍຕົວເລກເຫຼົ່ານັ້ນ; ຫຼືສັນຍາລັກ CIDR (ເຊັ່ນ: <b>231.54.211.0/20</b>); ຫຼື ຊ່ວງຂອງທີ່ຢູ່ IP (ເຊັ່ນ: <b>231.3.56.10-20</b>) ບ່ອນທີ່ໄລຍະການນໍາໃຊ້ກັບພາກສ່ວນສຸດທ້າຍຂອງທີ່ຢູ່. ຊື່ໂດເມນຂໍ້ຄວາມ (ເຊັ່ນ: \'example.com\') ບໍ່ຖືກຮອງຮັບ. ແຖວທີ່ຫວ່າງເປົ່າ, ແລະ ຂໍ້ຄວາມຕໍ່ໄປນີ້ມີຕົວອັກສອນ "#" ແມ່ນບໍ່ສົນໃຈ.';
$string['iplookup'] = 'ການຊອກຫາທີ່ຢູ່ IP';
$string['iplookupgeoplugin'] = 'ບໍລິການ <a href="https://www.geoplugin.com">geoPlugin</a> ກຳ ລັງຖືກນຳໃຊ້ເພື່ອຊອກຫາຂໍ້ມູນທາງພູມສາດ. ເພື່ອໃຫ້ໄດ້ຜົນທີ່ຖືກຕ້ອງຫຼາຍຂຶ້ນ, ພວກເຮົາແນະນໍາໃຫ້ຕິດຕັ້ງສໍາເນົາຖານຂໍ້ມູນ MaxMind GeoLite.';
$string['iplookupinfo'] = 'ຕາມຄ່າເລີ່ມຕົ້ນ, Moodle ໃຊ້ເຄື່ອງແມ່ຂ່າຍອອນໄລນ໌ Net NetGeo (ຖານຂໍ້ມູນທາງພູມສາດທາງອິນເຕີເນັດ) ເພື່ອຊອກຫາທີ່ຕັ້ງຂອງທີ່ຢູ່ IP, ແຕ່ໜ້າເສຍດາຍທີ່ຖານຂໍ້ມູນນີ້ບໍ່ໄດ້ຖືກຮັກສາໄວ້ອີກຕໍ່ໄປ ແລະ ອາດຈະກັບຄືນມາເປັນຂໍ້ມູນທີ່ <em>ບໍ່ຖືກຕ້ອງຫຼາຍ</em>.
ຂໍແນະນຳໃຫ້ຕິດຕັ້ງຖານຂໍ້ມູນ GeoLite2 City ຟຣີຈາກ MaxMind. <br />
ສະຖານທີ່ທີ່ຢູ່ IP ແມ່ນສະແດງຢູ່ໃນແຜນທີ່ທີ່ລຽບງ່າຍ ຫຼື ໃຊ້ແຜນທີ່ Google Maps. ກະລຸນາຮັບຊາບວ່າ ທ່ານຕ້ອງມີບັນຊີ Google ແລະ ສະໝັກຂໍກະແຈ Google Maps API ຟຣີເພື່ອເປີດໃຊ້ແຜນທີ່ແບບໂຕ້ຕອບໄດ້.';
$string['iplookupmaxmindnote'] = 'ຜະລິດຕະພັນນີ້ລວມມີຂໍ້ມູນ GeoLite2 ທີ່ສ້າງຂຶ້ນໂດຍ MaxMind, ມີໃຫ້ຈາກ <a href="https://www.maxmind.com">https://www.maxmind.com</a>.';
$string['iscustomadminwarnings'] = 'ມັນໄດ້ຖືກກວດພົບວ່າ ເວັບໄຊທ໌ຂອງທ່ານກໍາລັງໃຊ້ບັນຊີລາຍການຜູ້ເບິ່ງແຍງແບບກໍານົດເອງ. ຄຸນສົມບັດນີ້ບໍ່ຖືກຮອງຮັບອີກຕໍ່ໄປ ແລະຈະຖືກລຶບອອກຫຼັງຈາກ Moodle 4.2.';
$string['ishttpswarning'] = 'ມັນໄດ້ຖືກກວດພົບວ່າເວັບໄຊທ໌ຂອງທ່ານ ບໍ່ໄດ້ຮັບການຮັກສາຄວາມປອດໄພໂດຍໃຊ້ HTTPS. ມັນຖືກແນະນໍາຢ່າງຈິງຈັງເພື່ອຍ້າຍເວັບໄຊທ໌ຂອງທ່ານໄປຫາ HTTPS ເພື່ອຄວາມປອດໄພທີ່ເພີ່ມຂຶ້ນ ແລະ ປັບປຸງການເຊື່ອມໂຍງກັບລະບົບອື່ນ.';
$string['keeptagnamecase'] = 'ຮັກສາການໃສ່ກອບຊື່ປ້າຍ';
$string['lang'] = 'ພາສາເລີ່ມຕົ້ນ';
$string['langcache'] = 'ແຄດ ເມນູພາສາ';
$string['langcache_desc'] = 'ແຄດ ເມນູພາສາ. ຖ້າເປີດໃຊ້ງານ, ລາຍການການແປທີ່ມີຢູ່ຈະຖືກເກັບໄວ້. ແຄດຈະຖືກໂຫຼດຄືນໃໝ່ໂດຍອັດຕະໂນມັດ ເມື່ອທ່ານຕິດຕັ້ງ ຫຼື ລຶບຊຸດພາສາຜ່ານເຄື່ອງມືຈັດການຊຸດພາສາທີ່ມີຢູ່ໃນຕົວ. ຖ້າທ່ານຕິດຕັ້ງຊຸດພາສາໃໝ່ດ້ວຍຕົນເອງ, ທ່ານຕ້ອງໃຊ້ຄຸນສົມບັດການລຶບລ້າງຖານຄວາມຈໍາທັງໝົດຄືນໃໝ່ ເພື່ອເຮັດໃຫ້ລາຍຊື່ທີ່ເກັບໄວ້ໃຫ້ສົດໃໝ່.';
$string['langlist'] = 'ພາສາຢູ່ໃນເມນູພາສາ';
$string['langmenu'] = 'ສະແດງເມນູພາສາ';
$string['langmenuinsecurelayout'] = 'ສະແດງເມນູພາສາຢູ່ໃນໂຄງຮ່າງທີ່ປອດໄພ';
$string['langmenuinsecurelayout_desc'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ຈະສາມາດປ່ຽນພາສາຂອງເຂົາເຈົ້າໄດ້ໃນເວລາພະຍາຍາມຕອບຄໍາຖາມ ຫຼື ກິດຈະກໍາອື່ນໂດຍໃຊ້ໂຄງຮ່າງທີ່ປອດໄພ.';
$string['langpackwillbeupdated'] = 'ໝາຍເຫດ: Moodle ຈະພະຍາຍາມດາວໂຫຼດອັບເດດສຳລັບຊຸດພາສາຂອງທ່ານໃນລະຫວ່າງການຍົກລະດັບ.';
$string['langstringcache'] = 'ແຄດ ສະຕິງພາສາທັງໝົດ';
$string['languagesettings'] = 'ການຕັ້ງຄ່າພາສາ';
$string['latinexcelexport'] = 'ການເຂົ້າລະຫັດ Excel';
$string['legacyfilesaddallowed'] = 'ອະນຸຍາດໃຫ້ເພີ່ມໃສ່ໄຟລ໌ລາຍວິຊາເດີມ';
$string['legacyfilesaddallowed_help'] = 'ຖ້າຫຼັກສູດໃດໜຶ່ງມີໄຟລ໌ລາຍວິຊາເດີມ, ອະນຸຍາດໃຫ້ເພີ່ມໄຟລ໌ ແລະ ໂຟນເດີໃໝ່ໃສ່ມັນໄດ້.';
$string['legacyfilesinnewcourses'] = 'ໄຟລ໌ລາຍວິຊາເດີມຢູ່ໃນຫຼັກສູດໃໝ່';
$string['legacyfilesinnewcourses_help'] = 'ຕາມຄ່າເລີ່ມຕົ້ນ, ພື້ນທີ່ໄຟລ໌ລາຍວິຊາເດີມ ແມ່ນມີຢູ່ໃນວິຊາທີ່ໄດ້ຍົກລະດັບເທົ່ານັ້ນ. ກະລຸນາຮັບຊາບວ່າ ຄຸນສົມບັດບາງຢ່າງເຊັ່ນ: ການສຳຮອງຂໍ້ມູນ ແລະ ການກູ້ຄືນກິດຈະກຳບໍ່ເຂົ້າກັນໄດ້ກັບການຕັ້ງຄ່ານີ້.';
$string['libcurlwarning'] = 'ມັນໄດ້ຖືກກວດພົບວ່າ libcurl ບໍ່ມີ CURLOPT_PROTOCOL ຮອງຮັບ. ການຕິດຕັ້ງ libcurl ທີ່ທັນສະໄໝແມ່ນແນະນຳໃຫ້ສຳລັບເຫດຜົນດ້ານຄວາມປອດໄພ.';
$string['licensesettings'] = 'ການຕັ້ງຄ່າໃບອະນຸຍາດ';
$string['linkadmincategories'] = 'ເຊື່ອມໂຍງບັນດາປະເພດຜູ້ເບິ່ງແຍງລະບົບ';
$string['linkadmincategories_help'] = 'ຖ້າເປີດໃຊ້ແລ້ວ ບັນດາປະເພດການຕັ້ງຄ່າຂອງຜູ້ເບິ່ງແຍງລະບົບຈະຖືກສະແດງເປັນລິ້ງໃນການນໍາທາງ ແລະ ຈະນໍາໄປສູ່ໜ້າປະເພດຂອງຜູ້ເບິ່ງແຍງລະບົບ.';
$string['linkcoursesections'] = 'ເຊື່ອມໂຍງພາກສ່ວນລາຍວິຊາຢູ່ສະເໝີ';
$string['linkcoursesections_help'] = 'ພະຍາຍາມສະໜອງລິ້ງສຳລັບພາກລາຍວິຊາຢູ່ສະເໝີ. ໂດຍປົກກະຕິແລ້ວພາກພາກລາຍວິຊາຈະສະແດງເປັນລິ້ງເທົ່ານັ້ນ ຖ້າຮູບແບບຫຼັກສູດສະແດງພາກດຽວຕໍ່ໜ້າ. ຖ້າການຕັ້ງຄ່ານີ້ເປີດໃຊ້ງານແລ້ວ, ຈະມີການໃຫ້ລິ້ງຢູ່ສະເໝີ.';
$string['loading'] = 'ກຳລັງໂຫຼດ';
$string['localetext'] = 'ທ້ອງຖິ່ນໃນທົ່ວເວັບໄຊທ໌';
$string['localstringcustomization'] = 'ການປັບແຕ່ງສະຕຣິງທ້ອງຖິ່ນ';
$string['location'] = 'ສະຖານທີ່';
$string['locationsettings'] = 'ການຕັ້ງຄ່າສະຖານທີ່';
$string['locked'] = 'ລັອກແລ້ວ';
$string['lockoutduration'] = 'ໄລຍະເວລາການລັອກບັນຊີ';
$string['lockoutduration_desc'] = 'ບັນຊີທີ່ຖືກລັອກແມ່ນຈະຖືກປົດລັອກໂດຍອັດຕະໂນມັດຫຼັງຈາກໄລຍະເວລານີ້.';
$string['lockoutemailbody'] = 'ບັນຊີຂອງທ່ານທີ່ມີຊື່ຜູ້ໃຊ້ {$a->username} ຢູ່ໃນເຊີບເວີ \'{$a->sitename}\'
ຖືກລັອກໄວ້ຫຼັງຈາກການພະຍາຍາມເຂົ້າສູ່ລະບົບທີ່ບໍ່ຖືກຕ້ອງຫຼາຍຄັ້ງ.

ເພື່ອປົດລັອກບັນຊີທັນທີ, ໄປຫາທີ່ຢູ່ຕໍ່ໄປນີ້

{$a->link}

ໃນໂປຣແກມຈົດໝາຍສ່ວນໃຫຍ່, ສິ່ງນີ້ຄວນປະກົດເປັນລິ້ງສີຟ້າ
ທີ່ທ່ານພຽງແຕ່ສາມາດຄລິກໃສ່. ຖ້າມັນບໍ່ໄດ້ຜົນ,
ໃຫ້ຄັດລອກ ແລະ ວາງທີ່ຢູ່ໃສ່ແຖວທີ່ຢູ່
ເທິງສຸດຂອງປ່ອງຢ້ຽມທ່ອງເວັບຂອງທ່ານ.

ຖ້າທ່ານຕ້ອງການຄວາມຊ່ວຍເຫຼືອ, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌,
{$a->admin}';
$string['lockoutemailsubject'] = 'ບັນຊີຂອງທ່ານຢູ່ໃນ {$a} ຖືກລັອກໄວ້';
$string['lockouterrorunlock'] = 'ຂໍ້ມູນການປົດລັອກບັນຊີທີ່ສະໜອງໃຫ້ບໍ່ຖືກຕ້ອງ.';
$string['lockoutthreshold'] = 'ເກນການປິດບັນຊີ';
$string['lockoutthreshold_desc'] = 'ເລືອກຈໍານວນຄວາມພະຍາຍາມເຂົ້າສູ່ລະບົບທີ່ບໍ່ສໍາເລັດຜົນທີ່ເຮັດໃຫ້ບັນຊີຖືກລັອກ. ຄຸນສົມບັດນີ້ອາດຈະຖືກນຳໄປໃຊ້ໃນທາງທີ່ຜິດໃນການປະຕິເສດການໂຈມຕີບໍລິການ.';
$string['lockoutwindow'] = 'ປ່ອງຢ້ຽມສັງເກດການລັອກບັນຊີ';
$string['lockoutwindow_desc'] = 'ເວລາສັງເກດການສໍາລັບການປິດປະຕູ, ຖ້າບໍ່ມີຄວາມພະຍາຍາມທີ່ບໍ່ປະສົບຜົນສໍາເລັດ, ຕົວນັບປະຕູຈະຖືກຕັ້ງຄືນໃໝ່ຫຼັງຈາກເວລານີ້.';
$string['lockrequestcategory'] = 'ປ້ອງກັນການເລືອກປະເພດ';
$string['log'] = 'ບັນທຶກ';
$string['logguests'] = 'ບັນທຶກການເຂົ້າຂອງແຂກ';
$string['logguests_help'] = 'ການຕັ້ງຄ່ານີ້ເປີດໃຊ້ງານບັນທຶກການກະທໍາໂດຍບັນຊີແຂກ ແລະ ບໍ່ໄດ້ເຂົ້າສູ່ລະບົບຂອງຜູ້ໃຊ້. ເວັບໄຊທ໌ໂປຼໄຟລ໌ຂັ້ນສູງອາດຈະຕ້ອງການປິດການນຳໃຊ້ການເຂົ້າສູ່ລະບົບນີ້ດ້ວຍເຫດຜົນດ້ານປະສິດທິພາບ. ມັນໄດ້ຖືກແນະນໍາໃຫ້ຮັກສາການຕັ້ງຄ່ານີ້ໄວ້ຢູ່ໃນບ່ອນທີ່ໃຊ້ງານຈິງ.';
$string['logininfoinsecurelayout'] = 'ສະແດງຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບຢູ່ໃນໂຄງຮ່າງທີ່ປອດໄພ';
$string['logininfoinsecurelayout_desc'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ຊື່ເຕັມຂອງຜູ້ໃຊ້ທີ່ເຂົ້າສູ່ລະບົບແລ້ວຈະຖືກສະແດງຂຶ້ນຢູ່ໃນແຖບນໍາທາງ ເມື່ອພະຍາຍາມຕອບຄໍາຖາມ ຫຼື ກິດຈະກໍາອື່ນໂດຍໃຊ້ໂຄງຮ່າງທີ່ປອດໄພ.';
$string['loginpageautofocus'] = 'ແບບຟອມໜ້າເຂົ້າສູ່ລະບົບອັດຕະໂນມັດ';
$string['loginpageautofocus_help'] = 'ການເປີດໃຊ້ຕົວເລືອກນີ້ປັບປຸງການໃຊ້ງານຂອງໜ້າເຂົ້າສູ່ລະບົບ, ແຕ່ວ່າຊ່ອງທີ່ເນັ້ນໝັກອັດຕະໂນມັດອາດຈະຖືກພິຈາລະນາເປັນບັນຫາການຊ່ວຍການເຂົ້າເຖິງ.';
$string['loglifetime'] = 'ຮັກສາບັນທຶກສຳລັບ';
$string['logo'] = 'ໂລໂກ້';
$string['logo_desc'] = 'ໂລໂກ້ເຕັມຮູບແບບທີ່ໃຊ້ເປັນການຕົບແຕ່ງໂດຍບາງຮູບແບບ (ເຊັ່ນ: ຮູບແບບສີສັນຫຼັກ). ຮູບພາບນີ້ສາມາດມີຄວາມລະອຽດສູງພໍສົມຄວນ ເພາະວ່າມັນຈະຖືກຫຍໍ້ລົງເພື່ອໃຊ້ (ແລະ ເກັບໄວ້ເພື່ອປະສິດທິພາບ). ໂລໂກ້ທີ່ກວ້າງກວ່າຄວາມສູງ ປົກກະຕິແລ້ວໃຫ້ຜົນໄດ້ຮັບທີ່ດີກວ່າ. ຮູບແບບທີ່ຍອມຮັບ: PNG ແລະ JPG.';
$string['logocompact'] = 'ໂລໂກ້ກະທັດຮັດ';
$string['logocompact_desc'] = 'ສະບັບກະທັດຮັດຂອງໂລໂກ້ຄືກັນກັບຂ້າງເທິງ, ເຊັ່ນ: ເຄື່ອງໝາຍ, ໂລ່ ຫຼື ສັນຍາລັກ. ຮູບພາບຄວນຈະແຈ້ງເຖິງແມ່ນວ່າຈະມີຂະໜາດນ້ອຍກໍ່ຕາມ. ຮູບແບບທີ່ຍອມຮັບ: PNG ແລະ JPG.';
$string['logossettings'] = 'ໂລໂກ້';
$string['logstorenotrequired'] = 'ບໍ່ຈຳເປັນຕ້ອງເກັບບັນທຶກ';
$string['logstoressupported'] = 'ການເກັບບັນທຶກທີ່ສະໜັບສະໜູນລາຍງານນີ້';
$string['longtimewarning'] = '<b>ກະລຸນາຮັບຊາບວ່າຂັ້ນຕອນນີ້ສາມາດໃຊ້ເວລາດົນ.</b>';
$string['mailnewline'] = 'ຕົວອັກສອນແຖວໃໝ່ຢູ່ໃນຈົດໝາຍ';
$string['maintenancemode'] = 'ໃນຮູບແບບການບໍາລຸງຮັກສາ';
$string['maintenancemodeisscheduled'] = 'ເວັບໄຊທ໌ນີ້ຈະຖືກປ່ຽນເປັນໂໝດບໍາລຸງຮັກສາໃນ {$a->min} ນາທີ {$a->sec} ວິນາທີ';
$string['maintenancemodeisscheduledlong'] = 'ເວັບໄຊທ໌ນີ້ຈະຖືກປ່ຽນເປັນໂໝດບໍາລຸງຮັກສາໃນ {$a->hour} ຊົ່ວໂມງ {$a->min} ນາທີ {$a->sec} ວິນາທີ';
$string['maintfileopenerror'] = 'ເກີດຄວາມຜິດພາດໃນການເປີດໄຟລ໌ບໍາລຸງຮັກສາ!';
$string['maintinprogress'] = 'ການບຳລຸງຮັກສາກຳລັງດຳເນີນຢູ່...';
$string['managecontextlock'] = 'ຈຶ້ງສະພາບການນີ້';
$string['managecontextlocklocked'] = '{$a->contextname} ແລະ ເນື້ອໃນທີ່ຕ່ຳກວ່ານີ້ຖືກຈຶ້ງໄວ້ດຽວນີ້.';
$string['managecontextlockunlocked'] = '{$a->contextname} ແລະ ເນື້ອໃນທີ່ຕ່ຳກວ່າໄດ້ເຊົາຈຶ້ງໄວ້ດຽວນີ້.';
$string['managecontextunlock'] = 'ເຊົາຈຶ້ງສະພາບການນີ້';
$string['managecustomfields'] = 'ຈັດການປະເພດຊ່ອງຂໍ້ມູນແບບກຳນົດເອງ';
$string['manageformats'] = 'ຈັດການຮູບແບບລາຍວິຊາ';
$string['manageformatsgotosettings'] = 'ຮູບແບບເລີ່ມຕົ້ນສາມາດປ່ຽນແປງໄດ້ໃນ {$a}';
$string['managelang'] = 'ຈັດການ';
$string['manageqbanks'] = 'ຈັດການປລັກອິນທະນາຄານຄຳຖາມ';
$string['manageqbehaviours'] = 'ຈັດການພຶດຕິກໍາຄໍາຖາມ';
$string['manageqtypes'] = 'ຈັດການປະເພດຄຳຖາມ';
$string['maturity100'] = 'ເບຕ້າ';
$string['maturity150'] = 'ປ່ອຍຜູ້ສະໝັກ';
$string['maturity200'] = 'ສະບັບໝັ້ນຄົງ';
$string['maturity50'] = 'ອັນຟາ';
$string['maturityallowunstable'] = 'ຄຳແນະນຳ: ເຈົ້າອາດຈະຕ້ອງການແລ່ນສະຄຣິບນີ້ດ້ວຍຕົວເລືອກ --ອະນຸຍາດ-ບໍ່ສະຖຽນ';
$string['maturitycoreinfo'] = 'ປະຈຸບັນເວັບໄຊທ໌ຂອງທ່ານກໍາລັງໃຊ້ລະຫັດການພັດທະນາ "{$a}" ທີ່ບໍ່ສະຖຽນ.';
$string['maturitycorewarning'] = 'Moodle ສະບັບທີ່ທ່ານກຳລັງຈະຕິດຕັ້ງ ຫຼື ຍົກລະດັບເປັນ
ລະຫັດພັດທະນາ "{$a}" ທີ່ບໍ່ໝັ້ນຄົງທີ່ບໍ່ເສາະສົມກັບການນຳ ໃຊ້ໃນພື້ນທີ່ການຜະລິດສ່ວນໃຫຍ່.
ຖ້າອັນນີ້ບໍ່ແມ່ນສິ່ງທີ່ທ່ານຕ້ອງການແລ້ວທ່ານຄວນແນ່ໃຈວ່າທ່ານກໍາລັງອັບເດດ
ຈາກສາຂາ STABLE ຂອງກົດລະບຽບຂອງ Moodle. ເບິ່ງ Moodle Docs ສຳລັບລາຍລະອຽດເພີ່ມເຕີມ.';
$string['maxbytes'] = 'ຂະໜາດໄຟລ໌ທີ່ອັບໂຫຼດສູງສຸດ';
$string['maxconsecutiveidentchars'] = 'ຕົວອັກສອນທີ່ຄືກັນຕິດຕໍ່ກັນ';
$string['maxeditingtime'] = 'ເວລາສູງສຸດເພື່ອແກ້ໄຂໂພສ';
$string['maxsizeperdownloadcoursefile'] = 'ຂະໜາດສູງສຸດຕໍ່ໄຟລ໌';
$string['maxsizeperdownloadcoursefile_desc'] = 'ຂະໜາດສູງສຸດຂອງແຕ່ລະໄຟລ໌ ເມື່ອດາວໂຫຼດເນື້ອໃນລາຍວິຊາ. ໄຟລ໌ທີ່ມີຂະໜາດເກີນຂະໜາດນີ້ຈະຖືກຕັດອອກຈາກການດາວໂຫຼດ.';
$string['maxtimelimit'] = 'ຂີດຈຳກັດເວລາສູງສຸດ';
$string['maxtimelimit_desc'] = 'ເພື່ອຈໍາກັດເວລາປະຕິບັດ PHP ສູງສຸດທີ່ Moodle ຈະອະນຸຍາດໃຫ້ໂດຍບໍ່ມີການສະແດງຜົນອັນໃດອອກມາ, ໃຫ້ປ້ອນຄ່າເປັນວິນາທີຢູ່ທີ່ນີ້. 0 ໝາຍຄວາມວ່າມີການໃຊ້ຂໍ້ຈໍາກັດເລີ່ມຕົ້ນຂອງ Moodle. ຖ້າທ່ານມີເຊີບເວີດ້ານໜ້າທີ່ມີຂີດຈຳ ກັດເວລາຂອງມັນເອງ, ຕັ້ງຄ່ານີ້ໃຫ້ຕ່ຳກວ່າເພື່ອຮັບຂໍ້ຜິດພາດ PHP ໃນບັນທຶກ. ບໍ່ນຳໃຊ້ກັບສະຄຣິບ CLI.';
$string['maxusersperpage'] = 'ຈຳນວນຜູ້ໃຊ້ສູງສຸດຕໍ່ໜ້າ';
$string['mbstringrecommended'] = 'ການຕິດຕັ້ງຫ້ອງສະມຸດ MBSTRING ທາງເລືອກແມ່ນແນະ ນຳທີ່ສຸດ ເພື່ອປັບປຸງປະສິດທິພາບຂອງເວັບໄຊທ໌, ໂດຍສະເພາະຖ້າເວັບໄຊທ໌ຂອງທ່ານສະໜັບສະໜູນພາສາທີ່ບໍ່ແມ່ນພາສາລາຕິນ.';
$string['mbstringrequired'] = 'ການຕິດຕັ້ງຫ້ອງສະມຸດ MBSTRING ແມ່ນຕ້ອງການເພື່ອປັບປຸງປະສິດທິພາບຂອງເວັບໄຊທ໌, ໂດຍສະເພາະຖ້າເວັບໄຊທ໌ຂອງທ່ານສະໜັບສະໜູນພາສາທີ່ບໍ່ແມ່ນພາສາລາຕິນ.';
$string['mediapluginavi'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .avi';
$string['mediapluginflv'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .flv';
$string['mediapluginimg'] = 'ເປີດໃຊ້ງານການຝັງອັດຕະໂນມັດຂອງຮູບທີ່ເຊື່ອມໂຍງ';
$string['mediapluginmov'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .mov';
$string['mediapluginmp3'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .mp3';
$string['mediapluginmpg'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .mpg';
$string['mediapluginogg'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .ogg';
$string['mediapluginogv'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .ogv';
$string['mediapluginram'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .ram';
$string['mediapluginrm'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .rm';
$string['mediapluginrpm'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .rpm';
$string['mediapluginswf'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .swf';
$string['mediapluginswfnote'] = 'ຕາມມາດຕະການຄວາມປອດໄພເລີ່ມຕົ້ນ, ຜູ້ໃຊ້ປົກກະຕິບໍ່ຄວນໄດ້ຮັບອະນຸຍາດໃຫ້ຝັງໄຟລ໌ sw swf.';
$string['mediapluginwmv'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງ .wmv';
$string['mediapluginyoutube'] = 'ເປີດໃຊ້ຕົວກັ່ນຕອງລິ້ງ YouTube';
$string['messaging'] = 'ເປີດໃຊ້ລະບົບການສົ່ງຂໍ້ຄວາມ';
$string['messagingallowemailoverride'] = 'ລົບລ້າງອີເມລແຈ້ງເຕືອນ';
$string['messagingallusers'] = 'ອະນຸຍາດໃຫ້ມີການສົ່ງຂໍ້ຄວາມທົ່ວເວັບໄຊທ໌';
$string['messagingcategory'] = 'ການສົ່ງຂໍ້ຄວາມ';
$string['messagingdefaultpressenter'] = 'ໃຊ້ enter ເພື່ອສົ່ງການເປີດນຳໃຊ້ຕາມຄ່າເລີ່ມຕົ້ນ';
$string['messagingdeleteallnotificationsdelay'] = 'ລຶບການແຈ້ງເຕືອນທັງໝົດ';
$string['messagingdeletereadnotificationsdelay'] = 'ລຶບການແຈ້ງເຕືອນການອ່ານ';
$string['messagingssettings'] = 'ການຕັ້ງຄ່າຂໍ້ຄວາມ';
$string['minpassworddigits'] = 'ຕົວເລກ';
$string['minpasswordlength'] = 'ຄວາມຍາວລະຫັດຜ່ານ';
$string['minpasswordlower'] = 'ຕົວອັກສອນຕົວນ້ອຍ';
$string['minpasswordnonalphanum'] = 'ຕົວອັກສອນທີ່ບໍ່ແມ່ນຕົວເລກ';
$string['minpasswordupper'] = 'ຕົວອັກສອນໃຫຍ່';
$string['misc'] = 'ອື່ນໆ';
$string['mlbackendsettings'] = 'ການຕັ້ງຄ່າດ້ານຫຼັງຂອງການຮຽນຮູ້ເຄື່ອງຈັກ';
$string['mnetrestore_extusers'] = '<strong>ໝາຍເຫດ:</strong> ໄຟລ໌ສຳຮອງນີ້ມີບັນຊີຜູ້ໃຊ້ເຄືອຂ່າຍ Moodle ຫ່າງໄກ ເຊິ່ງຈະຖືກກູ້ຄືນເປັນສ່ວນໜຶ່ງ ຂອງຂະບວນການ.';
$string['mnetrestore_extusers_admin'] = '<strong>ໝາຍເຫດ:</strong> ໄຟລ໌ສຳຮອງນີ້ເບິ່ງຄືວ່າມາຈາກການຕິດຕັ້ງ Moodle ອັນອື່ນ ແລະ ປະກອບດ້ວຍບັນຊີຜູ້ໃຊ້ເຄືອຂ່າຍ Moodle ຫ່າງໄກ. ຂັ້ນຕອນການກູ້ຄືນຈະພະຍາຍາມຈັບຄູ່ເຈົ້າພາບເຄືອຂ່າຍ Moodle ສຳລັບຜູ້ໃຊ້ທີ່ຖືກສ້າງທັງໝົດ. ສິ່ງທີ່ບໍ່ກົງກັນຈະຖືກປ່ຽນໄປເປັນການກວດສອບຄວາມຖືກຕ້ອງພາຍໃນອັດຕະໂນມັດ (ແທນທີ່ຈະແມ່ນ mnet ອັນໜຶ່ງ). ບັນທຶກການກູ້ຄືນຈະແຈ້ງໃຫ້ທ່ານຮູ້ກ່ຽວກັບເລື່ອງນັ້ນ.';
$string['mnetrestore_extusers_mismatch'] = '<strong>ໝາຍເຫດ:</strong> ໄຟລ໌ສຳຮອງນີ້ປາກົດຂື້ນມາຈາກການຕິດຕັ້ງ Moodle ທີ່ແຕກຕ່າງກັນ ແລະ ມີບັນຊີຜູ້ໃຊ້ເຄືອຂ່າຍ Moodle ທາງໄກ ທີ່ອາດຈະບໍ່ສາມາດກູ້ຄືນມາໄດ້. ບໍ່ຮອງຮັບການປະຕິບັດງານນີ້. ຖ້າທ່ານແນ່ໃຈວ່າມັນຖືກສ້າງຂຶ້ນໃນການຕິດຕັ້ງ Moodle ນີ້, ຫຼື ທ່ານສາມາດຮັບປະກັນໄດ້ວ່າ ເຈົ້າພາບຂອງເຄືອຂ່າຍ Moodle ທັງໝົດທີ່ຕ້ອງການໄດ້ຖືກຕັ້ງຄ່າໄວ້, ທ່ານອາດຈະຍັງຢາກລອງການກູ້ຄືນ.';
$string['mnetrestore_extusers_noadmin'] = '<strong>ໝາຍເຫດ:</strong> ໄຟລ໌ສຳຮອງນີ້ເບິ່ງຄືວ່າມາຈາກການຕິດຕັ້ງ Moodle ອັນອື່ນ ແລະ ປະກອບດ້ວຍບັນຊີຜູ້ໃຊ້ເຄືອຂ່າຍ Moodle ທາງໄກ. ທ່ານຍັງບໍ່ໄດ້ອະນຸຍາດໃຫ້ດໍາເນີນການປະເພດຂອງການຟື້ນຟູນີ້. ຕິດຕໍ່ຫາຜູ້ຄວບຄຸມລະບົບຂອງເວັບໄຊທ໌ ຫຼື ທາງເລືອກອື່ນ, ກູ້ຄືນລາຍວິຊານີ້ໂດຍບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້ໃດໆ (ຊຸດ, ໄຟລ໌... )';
$string['mnetrestore_extusers_switchuserauth'] = 'ຜູ້ໃຊ້ເຄືອຂ່າຍ Moodle ທາງໄກ {$a->username} (ມາຈາກ {$a->mnethosturl}) ປ່ຽນເປັນຜູ້ໃຊ້ທີ່ໄດ້ກວດສອບຄວາມຖືກຕ້ອງ {$a->auth} ທ້ອງຖິ່ນ.';
$string['mobilenotconfiguredwarning'] = 'ແອັບ Moodle ບໍ່ໄດ້ຖືກເປີດນຳໃຊ້.';
$string['modchooserdefault'] = 'ຄ່າເລີ່ມຕົ້ນຂອງຕົວເລືອກກິດຈະກຳ';
$string['modeditdefaults'] = 'ຄ່າເລີ່ມຕົ້ນສໍາລັບການຕັ້ງຄ່າກິດຈະກໍາ';
$string['modsettings'] = 'ຈັດການກິດຈະກໍາ';
$string['modulesecurity'] = 'ຄວາມປອດໄພຂອງຊຸດ';
$string['moodleapp'] = 'ແອັບ Moodle';
$string['moodleapp_help'] = '<p>ແອັບ Moodle ຟຣີຊ່ວຍໃຫ້ຜູ້ໃຊ້ເຂົ້າເຖິງຫຼັກສູດຂອງເຂົາເຈົ້າຢູ່ໃນອຸປະກອນມືຖື. ຄຸນສົມບັດແອັບເພີ່ມເຕີມມີໃຫ້ກັບແພັກເກດແອັບ Pro ຫຼື Premium. </p>
<a href="https://moodle.com/mobile-app">Get the Moodle app</a><br />
<a href="https://apps.moodle.com">Moodle Apps Portal</a>';
$string['moodlebrandedapp'] = 'ຫຍີ່ຫໍ້ແອັບ Moodle';
$string['moodlebrandedapp_help'] = '<p>ແອັບ Moodle ທີ່ມີຍີ່ຫໍ້ມີການເຮັດວຽກທັງໝົດຂອງແອັບມືຖືຟຣີຂອງພວກເຮົາສຳລັບ Moodle ລວມກັບການສ້າງເຄື່ອງໝາຍການຄ້າຂອງທ່ານເອງ.</p>
<a href="https://moodle.com/branded-app">About the Branded Moodle app</a>';
$string['moodlebrandedappreference'] = 'ອີກທາງເລືອກ ໜຶ່ງ, ຮັບເອົາ <a href="https://moodle.com/branded-app/">Branded Moodle app</a> ດ້ວຍການສ້າງຍີ່ຫໍ້ຂອງທ່ານເອງ.';
$string['moodlepartners'] = 'Moodle Partners';
$string['moodlepartners_help'] = '<p>Moodle Partners ແມ່ນຜູ້ໃຫ້ບໍລິການທີ່ໄດ້ຮັບການຢັ້ງຢືນຈາກ Moodle HQ ເພື່ອສະໜອງການບໍລິການ Moodle ທີ່ມີຄຸນນະພາບສູງສໍາລັບສະພາບແວດລ້ອມການຮຽນຮູ້ອອນໄລນ໌ຂອງອົງກອນຂອງທ່ານ.</p>
<a href="https://moodle.com/about-partners/">About our Partners</a><br />
<a href="https://moodle.com/partners">Find a Partner</a>';
$string['moodleservices'] = 'ການບໍລິການ Moodle';
$string['moodleservices_help'] = 'ໃຫ້ແນ່ໃຈວ່າທ່ານໄດ້ຮັບສິ່ງທີ່ດີທີ່ສຸດຈາກສະພາບແວດລ້ອມການຮຽນຮູ້ Moodle ຂອງທ່ານໂດຍການໃຊ້ການບໍລິການ Moodle ເຫຼົ່ານີ້:';
$string['multilangforceold'] = 'ບັງຄັບໄວຍະກອນຫຼາຍພາສາແບບເກົ່າ: &lt;span&gt; ປາສະຈາກປະເພດ="multilang" ແລະ &lt;lang&gt;';
$string['mustenablestats'] = 'ສະຖິຕິຍັງບໍ່ທັນຖືກເປີດໃຊ້ໃນເວັບໄຊທ໌ນີ້.';
$string['mycourses'] = 'ລາຍວິຊາຂອງຂ້ອຍ';
$string['mycoursesperpage'] = 'ຈຳນວນລາຍວິຊາ';
$string['mydashboard'] = 'ແຜງໜ້າປັດມາດຕະຖານຂອງລະບົບ';
$string['mymoodle'] = 'ແຜງໜ້າປັດ';
$string['mymoodleredirect'] = 'ບັງຄັບຜູ້ໃຊ້ໃຊ້ My Moodle';
$string['mypage'] = 'ໜ້າແຜງໜ້າປັດເລີ່ມຕົ້ນ';
$string['mypagelocked'] = 'ລັອກໜ້າເລີ່ມຕົ້ນ';
$string['myprofile'] = 'ໜ້າໂປຼໄຟລ໌ເລີ່ມຕົ້ນ';
$string['navadduserpostslinks'] = 'ເພີ່ມລິ້ງເພື່ອເບິ່ງໂພສຂອງຜູ້ໃຊ້';
$string['navadduserpostslinks_help'] = 'ຖ້າເປີດນຳໃຊ້ສອງລິ້ງຈະຖືກເພີ່ມໃສ່ຜູ້ໃຊ້ແຕ່ລະຄົນໃນການນຳທາງເພື່ອເບິ່ງການສົນທະນາທີ່ຜູ້ໃຊ້ໄດ້ເລີ່ມຕົ້ນ ແລະ ໂພສຜູ້ໃຊ້ໄດ້ເຮັດຢູ່ໃນເວທີສົນທະນາທົ່ວເວັບໄຊທ໌
ຫຼື ໃນວິຊາສະເພາະ.';
$string['navcourselimit'] = 'ຂີດຈຳກັດລາຍວິຊາ';
$string['navigationupgrade'] = 'ການຍົກລະດັບນີ້ແນະນໍາສອງບລັອກນໍາທາງໃຫມ່ທີ່ຈະທົດແທນບລັອກເຫຼົ່ານີ້: ການບໍລິຫານ, ບັນດາວິຊາ, ກິດຈະກໍາ ແລະ ຜູ້ເຂົ້າຮ່ວມ. ຖ້າທ່ານໄດ້ຕັ້ງການອະນຸຍາດພິເສດອັນໃດໜຶ່ງໃສ່ກັບບລັອກເຫຼົ່ານັ້ນ, ທ່ານຄວນກວດເບິ່ງເພື່ອໃຫ້ແນ່ໃຈວ່າທຸກຢ່າງເປັນໄປຕາມທີ່ທ່ານຕ້ອງການ.';
$string['navshowallcourses'] = 'ສະແດງລາຍວິຊາທັງໝົດ';
$string['navshowcategories'] = 'ສະແດງບັນດາປະເພດລາຍວິຊາ';
$string['navshowfrontpagemods'] = 'ສະແດງກິດຈະກຳໜ້າຫຼັກເວັບໄຊທ໌ໃນການນຳທາງ';
$string['navshowfrontpagemods_help'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ກິດຈະກໍາໜ້າຫຼັກເວັບໄຊທ໌ຈະສະແດງຂຶ້ນຢູ່ເທິງການນໍາທາງພາຍໃຕ້ ໜ້າເວັບໄຊທ໌. ການຕັ້ງຄ່ານີ້ພຽວແຕ່ໃຊ້ກັບຮູບແບບສີສັນເທີງແບບຄລາສິກ.';
$string['navshowfullcoursenames'] = 'ສະແດງຊື່ເຕັມຫຼັກສູດ';
$string['navshowfullcoursenames_help'] = 'ຖ້າເປີດໃຊ້ແລ້ວ, ຊື່ເຕັມລາຍວິຊາຈະຖືກໃຊ້ຢູ່ໃນການນໍາທາງແທນທີ່ຈະເປັນຊື່ຫຍໍ້.';
$string['navshowmycoursecategories'] = 'ສະແດງປະເພດລາຍວິຊາຂອງຂ້ອຍ';
$string['navshowmycoursecategories_help'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ວິຊາຢູ່ໃນສາຂາລາຍວິຊາຂອງຂ້ອຍຈະຖືກສະແດງເປັນບັນດາປະເພດຢູ່ໃນແຖບການນໍາທາງ (ຮູບແບບສີສັນຄລາສສິກເທົ່ານັ້ນ).';
$string['navsortmycourseshiddenlast'] = 'ຈັດຮຽງວິຊາທີ່ເຊື່ອງໄວ້ຂອງຂ້ອຍໄປຢູ່ສຸດທ້າຍ';
$string['navsortmycourseshiddenlast_help'] = 'ຖ້າເປີດນຳໃຊ້, ວິຊາທີ່ເຊື່ອງໄວ້ໃດໜຶ່ງຈະຖືກສະແດງເປັນລາຍຊື່ຫຼັງຈາກວິຊາທີ່ເບິ່ງເຫັນໄດ້ (ສຳລັບຜູ້ໃຊ້ທີ່ສາມາດເບິ່ງວິຊາທີ່ເຊື່ອງໄວ້ໄດ້). ຖ້າບໍ່ດັ່ງນັ້ນ, ວິຊາທັງໝົດ, ໂດຍບໍ່ຄໍານຶງເຖິງການເບິ່ງເຫັນຂອງເຂົາທ່ານ, ຈະຖືກເຮັດເປັນລາຍການໄວ້ຕາມການຕັ້ງຄ່າ \'ຈັດຮຽງວິຊາຂອງຂ້ອຍ\'.';
$string['navsortmycoursessort'] = 'ຈັດຮຽງວິຊາຂອງຂ້ອຍ';
$string['navsortmycoursessort_help'] = 'ອັນນີ້ກຳນົດວ່າບັນດາວິຊາໄດ້ລະບຸໄວ້ພາຍໃຕ້ວິຊາຂອງຂ້ອຍຕາມລຳດັບການຈັດລຳ ດັບ (ຕົວຢ່າງ: ຊຸດຄຳສັ່ງໃນການບໍລິຫານເວັບໄຊທ໌ > ວິຊາ > ຈັດການວິຊາ ແລະ ປະເພດ) ຫຼື ຕາມຕົວອັກສອນຕາມການຕັ້ງຫຼັກສູດ.';
$string['never'] = 'ບໍ່ເຄີຍ';
$string['neverdeleteruns'] = 'ຢ່າລຶບການແລ່ນ';
$string['newestdocindexed'] = 'ດັດຊະນີເອກະສານລ້າສຸດ';
$string['nobookmarksforuser'] = 'ທ່ານບໍ່ມີບຸກມາກໃດໆ.';
$string['nodatabase'] = 'ບໍ່ມີຖານຂໍ້ມູນ';
$string['nohttpsformobilewarning'] = 'ມັນຖືກແນະນໍາໃຫ້ເປີດໃຊ້ HTTPS ດ້ວຍໃບຢັ້ງຢືນທີ່ຖືກຕ້ອງ. ແອັບ Moodle ຈະພະຍາຍາມໃຊ້ການເຊື່ອມຕໍ່ທີ່ປອດໄພກ່ອນສະເໝີ.';
$string['nomissingstrings'] = 'ບໍ່ມີສະຕຣິງທີ່ຂາດຫາຍໄປ';
$string['none'] = 'ບໍ່ມີ';
$string['nonewsettings'] = 'ບໍ່ໄດ້ເພີ່ມການຕັ້ງຄ່າໃໝ່ໃນລະຫວ່າງການຍົກລະດັບນີ້.';
$string['nonexistentbookmark'] = 'ບໍ່ມີບຸກມາກທີ່ທ່ານຮ້ອງຂໍ.';
$string['noreplyaddress'] = 'ທີ່ຢູ່ບໍ່ມີການຕອບກັບ';
$string['noreplydomain'] = 'ບໍ່ມີການຕອບກັບ ແລະ ໂດເມນ';
$string['noreplydomaindetail'] = 'ການຕັ້ງຄ່າສຳລັບໂດເມນທີ່ບໍ່ມີການຕອບກັບ ແລະ ກຳນົດຄ່າ';
$string['noresults'] = 'ບໍ່ພົບຜົນການຊອກຫາ.';
$string['noroles'] = 'ບໍ່ມີໜ້າທີ່';
$string['nosupportedlogstore'] = 'ບໍ່ພົບ logstore ທີ່ຮອງຮັບ';
$string['noteunneededblocks'] = 'ໝາຍເຫດ: ບລັອກທີ່ຕັ້ງຄ່າໃຫ້ສະແດງຈະບໍ່ຖືກລະບຸໄວ້ໃນເມນູ \'ເພີ່ມບລັອກ\' ໃນຫຼັກສູດໃດໜຶ່ງ ຖ້າພວກມັນຖືກລະບຸໄວ້ໃນຫົວຂໍ້ \'ບລັອກທີ່ບໍ່ຈຳເປັນ\'.';
$string['notifications'] = 'ການແຈ້ງເຕືອນ';
$string['notifyloginfailures'] = 'ອີເມວເຂົ້າສູ່ລະບົບລົ້ມເຫຼວໃນການ';
$string['notifyloginthreshold'] = 'ຂອບເຂດສໍາລັບການແຈ້ງເຕືອນອີເມລ';
$string['notloggedinroleid'] = 'ບົດບາດສຳລັບບັນດາຜູ້ມາຢ້ຽມ';
$string['numberofmissingstrings'] = 'ຈຳນວນສະຕຣິງທີ່ຂາດໄປ: {$a}';
$string['numberofstrings'] = 'ຈໍານວນສະຕຣິງທັງໝົດ: {$a->strings}<br />ຂາດຫາຍໄປ: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'ໂທເຄັນການໂຫຼດຄືນໃໝ່ສຳລັບໜຶ່ງໃນການບໍລິການ OAuth {$a->issuer} ຢູ່ໃນເວັບໄຊທ໌ຂອງທ່ານ {$a->siteurl} ໝົດອາຍຸແລ້ວ. ອັນນີ້ຈະຈໍາກັດການທໍາງານຂອງປລັກອິນທີ່ໃຊ້ການບໍລິການນີ້. ເພື່ອແກ້ໄຂບັນຫານີ້, ເຂົ້າໄປທີ່ໜ້າການກຳນົດຄ່າການບໍລິການ OAuth 2 ແລະ ຄລິກທີ່ໄອຄອນ "ເຊື່ອມຕໍ່ບັນຊີລະບົບ" ຢູ່ໃນແຖວຕາຕະລາງສໍາລັບການບໍລິການນີ້. ໃຫ້ແນ່ໃຈວ່າໄດ້ເຂົ້າສູ່ລະບົບໂດຍໃຊ້ບັນຊີບໍລິການດຽວກັນສໍາລັບລະບົບ OAuth ແຕ່ລະຄັ້ງ.';
$string['oauthrefreshtokenexpiredshort'] = 'ໂທເຄັນການໂຫຼດຄືນໃໝ່ໝົດອາຍຸສຳລັບ {$a->issuer} ຢູ່ໃນເວັບໄຊຂອງທ່ານ {$a->siteurl}.';
$string['onlynoreply'] = 'ສະເພາະເວລາຈາກທີ່ຢູ່ບໍ່ມີການຕອບກັບເທົ່ານັ້ນ';
$string['opcacherecommended'] = 'ການເກັບຂໍ້ມູນ PHP opcode ຊ່ວຍປັບປຸງປະສິດທິພາບ ແລະ ເຮັດໃຫ້ຄວາມຕ້ອງການໜ່ວຍຄວາມຈຳຫຼຸດລົງ, ສ່ວນຂະຫຍາຍ OPcache ແມ່ນແນະນຳ ແລະ ຮອງຮັບຢ່າງເຕັມທີ່.';
$string['opensslrecommended'] = 'ການຕິດຕັ້ງຫ້ອງສະໝຸດ OpenSSL ທາງເລືອກແມ່ນແນະນຳທີ່ສຸດ - ມັນເປີດໃຊ້ງານການເຮັດວຽກຂອງເຄືອຂ່າຍ Moodle.';
$string['opensslrequired'] = 'ດຽວນີ້ Moodle ຕ້ອງການສ່ວນຂະຫຍາຍ OpenSSL PHP ເພື່ອສະໜອງການບໍລິການການເຂົ້າລະຫັດທີ່ເຂັ້ມແຂງກວ່າ.';
$string['opentowebcrawlers'] = 'ເປີດໃຫ້ກັບເຄື່ອງຈັກຊອກຫາ';
$string['optionalmaintenancemessage'] = 'ຂໍ້ຄວາມການບໍາລຸງຮັກສາທາງເລືອກ';
$string['order1'] = 'ທຳອິດ';
$string['order2'] = 'ທີ່ສອງ';
$string['order3'] = 'ທີ່ສາມ';
$string['order4'] = 'ທີ່ສີ່';
$string['outgoingmailconfig'] = 'ການຕັ້ງຄ່າອີເມວຂາອອກ';
$string['overridetossl'] = 'ຕອນນີ້ຢຸດເຊົາໃຊ້ HTTPS ສໍາລັບການເຂົ້າສູ່ລະບົບ. ດຽວນີ້ຕົວຢ່າງນີ້ຖືກບັງຄັບໃຫ້ SSL. ເພື່ອແກ້ໄຂຄຳເຕືອນນີ້ໃຫ້ປ່ຽນ wwwroot ຂອງທ່ານໃນ config.php ເປັນ https://';
$string['pageinfodebugsummary'] = 'ໜ້ານີ້ແມ່ນ: {$a}';
$string['passwordchangelogout'] = 'ອອກຈາກລະບົບຫຼັງຈາກການປ່ຽນລະຫັດຜ່ານ';
$string['passwordchangelogout_desc'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ເມື່ອມີການປ່ຽນລະຫັດຜ່ານ, ທຸກເຊສຊັນຂອງໂປຼແກຼມທ່ອງເວັບຈະຖືກສິ້ນສຸດ, ນອກຈາກລະຫັດຜ່ານໃໝ່ທີ່ໄດ້ລະບຸໄວ້. (ການຕັ້ງຄ່ານີ້ບໍ່ມີຜົນຕໍ່ກັບການປ່ຽນແປງລະຫັດຜ່ານການອັບໂຫຼດຜູ້ໃຊ້ຊຸດໃຫຍ່.)';
$string['passwordchangetokendeletion'] = 'ເອົາໂທເຄັນການເຂົ້າຫາການບໍລິການເວັບອອກຫຼັງຈາກປ່ຽນລະຫັດຜ່ານ';
$string['passwordchangetokendeletion_desc'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ເມື່ອມີການປ່ຽນລະຫັດຜ່ານ, ໂທເຄັນການເຂົ້າຫາການບໍລິການເວັບຂອງຜູ້ໃຊ້ທັງໝົດຈະຖືກລຶບ.';
$string['passwordpolicy'] = 'ນະໂຍບາຍລະຫັດຜ່ານ';
$string['passwordpolicycheckonlogin'] = 'ກວດລະຫັດຜ່ານໃນການເຂົ້າສູ່ລະບົບ';
$string['passwordresettime'] = 'ເວລາສູງສຸດເພື່ອກວດສອບຄຳຂໍປ່ຽນລະຫັດຜ່ານ';
$string['passwordreuselimit'] = 'ຂີດຈຳກັດການໝູນລະຫັດຜ່ານ';
$string['passwordreuselimit_desc'] = 'ຈຳນວນຄັ້ງທີ່ຜູ້ໃຊ້ຕ້ອງປ່ຽນລະຫັດຜ່ານຂອງເຂົາເຈົ້າກ່ອນທີ່ຈະອະນຸຍາດໃຫ້ໃຊ້ລະຫັດຜ່ານຄືນໃໝ່. Hashes ຂອງລະຫັດຜ່ານທີ່ໃຊ້ຜ່ານມາແມ່ນຖືກເກັບໄວ້ຢູ່ໃນຕາຕະລາງຖານຂໍ້ມູນທ້ອງຖິ່ນ. ຄຸນສົມບັດນີ້ອາດຈະບໍ່ເຂົ້າກັນໄດ້ກັບປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງພາຍນອກບາງອັນ.';
$string['pathtodot'] = 'ເສັ້ນທາງໄປຫາໝາຍຈຸດ';
$string['pathtodot_help'] = 'ເສັ້ນທາງໄປຫາໝາຍຈຸດ. ໃນ Linux ມັນຄ້າຍຄືກັບ /usr/bin/dot. ໃນ Windows ມັນຄ້າຍຄືກັບ C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. ໃນ Mac ມັນຄ້າຍຄືກັບ /opt/local/bin/dot. ເພື່ອຈະສາມາດສ້າງກຣາບຟິກຈາກໄຟລ໌ DOT, ທ່ານຕ້ອງໄດ້ຕິດຕັ້ງ dot ທີ່ສາມາດປະຕິບັດໄດ້ ແລະ ຊີ້ໄປທີ່ນີ້.';
$string['pathtodu'] = 'ເສັ້ນທາງໄປສູ່ du';
$string['pathtogs'] = 'ເສັ້ນທາງໄປສູ່ ghostscript';
$string['pathtogs_help'] = 'ໃນການຕິດຕັ້ງ Linux ເກືອບທັງ,ົດ, ສິ່ງນີ້ສາມາດຖືກປະໄວ້ເປັນ \'/usr/bin/gs\'. ໃນ Windows ມັນຈະຄ້າຍຄືກັບ \'c:\\gs\\bin\\gswin32c.exe\' (ໃຫ້ແນ່ໃຈວ່າບໍ່ມີຍະຫວ່າງຢູ່ໃນເສັ້ນທາງ - ຖ້າຈໍາເປັນໃຫ້ສໍາເນົາເອົາໄຟລ໌ \'gswin32c.exe\' ແລະ \'gsdll32.dll\' ໄປໃສ່ໃນໂຟນເດີໃໝ່. ໂດຍບໍ່ມີຍະຫວ່າງຢູ່ໃນເສັ້ນທາງ)';
$string['pathtopdftoppm'] = 'ເສັ້ນທາງໄປສູ່ pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> ແມ່ນຫ້ອງສະໝຸດການປະມວນຜົນ PDF ເຊິ່ງລວມມີເຄື່ອງມື pdftoppm ສໍາລັບປ່ຽນໄຟລ໌ PDF ເປັນ PNG. ໂດຍທົ່ວໄປແລ້ວປະສິດທິພາບດີກ່ວາເມື່ອໃຊ້ Ghostscript, ໂດຍສະເພາະກັບໄຟລ໌ຂະໜາດ ໃຫຍ່. ຖ້າມີ, pdftoppm ຈະຖືກນໍາໃຊ້ໃນຄວາມມັກຂອງ Ghostscript. ໃນການຕິດຕັ້ງ Linux ສ່ວນໃຫຍ່, ເສັ້ນທາງສາມາດຖືກປະໄວ້ເປັນ /usr/bin/pdftoppm. ຖ້າບໍ່ດັ່ງນັ້ນ, ທ່ານຕ້ອງການຕິດຕັ້ງຊຸດ poppler-utils ຫຼື poppler, ຂື້ນກັບການແຈກຈ່າຍ Linux ຂອງທ່ານ. ໃນ Windows ມັນຖືກສະໜອງໃຫ້ໂດຍການຕິດຕັ້ງ Cygwin.';
$string['pathtopgdump'] = 'ເສັ້ນທາງໄປສູ່ pg_dump';
$string['pathtopgdumpdesc'] = 'This is only necessary to enter if you have more than one pg_dump on your system (for example if you have more than one version of postgresql installed)';
$string['pathtopgdumpinvalid'] = 'ເສັ້ນທາງໄປສູ່ pg_dump ບໍ່ຖືກຕ້ອງ - ບໍ່ວ່າຈະບໍ່ຖືກຕ້ອງ ຫຼື ບໍ່ສາມາດປະຕິບັດໄດ້';
$string['pathtophp'] = 'ເສັ້ນທາງໄປສູ່ PHP CLI';
$string['pathtopsql'] = 'ເສັ້ນທາງໄປສູ່ psql';
$string['pathtopsqldesc'] = 'ອັນນີ້ພຽງແຕ່ມີຄວາມຈໍາເປັນເພື່ອປ້ອນເຂົ້າ ຖ້າທ່ານມີຫຼາຍກວ່າໜຶ່ງ psql ຢູ່ໃນລະບົບຂອງທ່ານ (ຕົວຢ່າງຖ້າທ່ານມີ postgresql ຕິດຕັ້ງຫຼາຍກວ່າໜຶ່ງສະບັບ)';
$string['pathtopsqlinvalid'] = 'ເສັ້ນທາງໄປ psql ບໍ່ຖືກຕ້ອງ - ບໍ່ວ່າຈະບໍ່ຖືກຕ້ອງ ຫຼື ບໍ່ສາມາດກູ້ຄືນໄດ້';
$string['pathtopython'] = 'ເສັ້ນທາງໄປສູ່ Python';
$string['pathtopythondesc'] = 'ເສັ້ນທາງສູ່ Python ໄບນາຣີທີ່ສາມາດປະຕິບັດໄດ້ຂອງທ່ານ (ທັງ Python 2 ແລະ Python 3 ແມ່ນຍອມຮັບໄດ້).';
$string['pathtosassc'] = 'ເສັ້ນທາງໄປສູ່ SassC';
$string['pathtosassc_help'] = 'ການລະບຸສະຖານທີ່ຂອງ SassC ໄບນາຣີຈະປ່ຽນຕົວລວບລວມ SASS ຈາກການຈັດຕັ້ງປະຕິບັດ PHP ຂອງ Moodle ເປັນ SassC. ເບິ່ງ https://github.com/sass/sassc ສໍາລັບຂໍ້ມູນເພີ່ມເຕີມ.';
$string['pcreunicodewarning'] = 'ມັນຖືກແນະນໍາໃຫ້ໃຊ້ສ່ວນຂະຫຍາຍ PCRE PHP ທີ່ເຂົ້າກັນໄດ້ກັບຕົວອັກສອນ Unicode.';
$string['perfdebug'] = 'ຂໍ້ມູນການປະຕິບັດ';
$string['performance'] = 'ການປະຕິບັດ';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'ພາຣາມິເຕີ ສະບັບ/ກຸ່ມ ຂອງ PostgreSQL ສໍາລັບການດໍາເນີນການຄໍາສັ່ງ. ຖ້າທ່ານມີພຽງແຕ່ postgresql ອັນດຽວຢູ່ໃນລະບົບຂອງທ່ານ ຫຼື ທ່ານບໍ່ແນ່ໃຈວ່າສິ່ງນີ້ແມ່ນຫຍັງ, ໃຫ້ປະຫວ່າງໄວ້.';
$string['phpfloatproblem'] = 'ກວດພົບບັນຫາທີ່ບໍ່ຄາດຄິດໃນການຈັດການຕົວເລກລອຍຕົວ PHP - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'ເວັບໄຊທ໌ຂອງທ່ານໄດ້ລົງທະບຽນແລ້ວ. ການລົງທະບຽນອັບເດດຫຼ້າສຸດ {$a}.<br /> ໜ້າວຽກທີ່ກຳນົດ \'ລົງທະບຽນເວັບໄຊທ໌\' ເຮັດໃຫ້ການລົງທະບຽນຂອງທ່ານທັນສະໄໝ. ທ່ານຍັງສາມາດປັບປຸງການລົງທະບຽນດ້ວຍຕົນເອງໄດ້ທຸກເວລາ.';
$string['pleaserefreshregistrationnewdata'] = 'ຂໍ້ມູນການລົງທະບຽນໄດ້ຖືກປ່ຽນແປງ. ກະລຸນາຢືນຢັນມັນໂດຍການໃຊ້ປຸ່ມ \'ອັບເດດການລົງທະບຽນ\'.';
$string['pleaserefreshregistrationunknown'] = 'ເວັບໄຊທ໌ຂອງທ່ານໄດ້ຮັບການລົງທະບຽນແຕ່ບໍ່ຮູ້ວັນທີລົງທະບຽນ. ກະລຸນາປັບປຸງການລົງທະບຽນຂອງທ່ານໂດຍໃຊ້ປຸ່ມ \'ປັບປຸງການລົງທະບຽນ\' ຫຼື ຮັບປະກັນວ່າໜ້າວຽກທີ່ໄດ້ກໍານົດ \'ການລົງທະບຽນເວັບໄຊທ໌\' ໄດ້ຖືກເປີດໃຊ້ງານເພື່ອໃຫ້ການລົງທະບຽນຂອງທ່ານຖືກປັບປຸງໂດຍອັດຕະໂນມັດ.';
$string['plugin'] = 'ປລັກອິນ';
$string['plugins'] = 'ປລັກອິນ';
$string['pluginscheck'] = 'ການກວດສອບການເພິ່ງພາຂອງປລັກອິນ';
$string['pluginscheckfailed'] = 'ການກວດສອບການເພິ່ງພາອາໄສສໍາລັບ {$a->pluginslist} ບໍ່ສໍາເລັດ';
$string['pluginschecktodo'] = 'ທ່ານຕ້ອງແກ້ໄຂທຸກຂໍ້ກໍານົດຂອງປລັກອິນກ່ອນດໍາເນີນການຕິດຕັ້ງ Moodle ສະບັບນີ້!';
$string['pluginsoverview'] = 'ພາບລວມຂອງປລັກອິນ';
$string['pluginsoverviewsee'] = 'ເບິ່ງໜ້າ <a href="{$a->url}">ພາບລວມຂອງປລັກອິນ</a> ສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ.';
$string['policysettings'] = 'ການຕັ້ງຄ່ານະໂຍບາຍ';
$string['privacy:metadata'] = 'ປລັກອິນບໍລິຫານບໍ່ເກັບຂໍ້ມູນສ່ວນຕົວໃດໆ.';
$string['privacyandpolicies'] = 'ຄວາມເປັນສ່ວນຕົວ ແລະ ນະໂຍບາຍ';
$string['privacysettings'] = 'ການຕັ້ງຄ່າຄວາມເປັນສ່ວນຕົວ';
$string['profilecategory'] = 'ປະເພດ';
$string['profilecategoryname'] = 'ຊື່ປະເພດ (ຕ້ອງບໍ່ຊໍ້າກັນ)';
$string['profilecategorynamenotunique'] = 'ຊື່ປະເພດນີ້ຖືກໃຊ້ຢູ່ແລ້ວ';
$string['profilecommonsettings'] = 'ການຕັ້ງຄ່າທົ່ວໄປ';
$string['profileconfirmcategorydeletion'] = 'ມີຊ່ອງຂໍ້ມູນ {$a} ຢູ່ໃນປະເພດນີ້ ເຊິ່ງຈະຖືກຍ້າຍເຂົ້າໄປໃນປະເພດຂ້າງເທິງ (ຫຼື ຢູ່ລຸ່ມນີ້ຖ້າຢູ່ໃນປະເພດຢູ່ເທິງສຸດ). <br /> ທ່ານຍັງຕ້ອງການລຶບປະເພດນີ້ຢູ່ຫຼືບໍ?';
$string['profileconfirmfielddeletion'] = 'ມີ/ບັນທຶກຜູ້ໃຊ້ {$a} ສຳລັບຊ່ອງຂໍ້ມູນນີ້ທີ່ຈະຖືກລຶບອອກ. <br /> ທ່ານຍັງຕ້ອງການທີ່ຈະລຶບຊ່ອງຂໍ້ມູນນີ້ບໍ?';
$string['profilecreatecategory'] = 'ສ້າງປະເພດໂປຼໄຟລ໌ໃໝ່';
$string['profilecreatefield'] = 'ສ້າງຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ໃໝ່';
$string['profilecreatenewcategory'] = 'ສ້າງປະເພດໃໝ່';
$string['profilecreatenewfield'] = 'ການສ້າງຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ \'{$a}\' ໃໝ່';
$string['profiledefaultcategory'] = 'ຊ່ອງຂໍ້ມູນອື່ນໆ';
$string['profiledefaultchecked'] = 'ກວດສອບຕາມຄ່າເລີ່ມຕົ້ນ';
$string['profiledefaultdata'] = 'ຄ່າເລີ່ມຕົ້ນ';
$string['profiledeletecategory'] = 'ກຳລັງລຶບປະເພດ';
$string['profiledeletefield'] = 'ກຳລັງລຶບຊ່ອງຂໍ້ມູນ \'{$a}\'';
$string['profiledescription'] = 'ລາຍລະອຽດຂອງຊ່ອງຂໍ້ມູນ';
$string['profiledscript'] = 'ສະຄຣິບນີ້ໄດ້ມີໂປຼໄຟລ໌';
$string['profiledscriptview'] = 'ເບິ່ງຂໍ້ມູນປະຫວັດສຳລັບສະຄຣິບນີ້';
$string['profileeditcategory'] = 'ກຳລັງແກ້ໄຂປະເພດ: {$a}';
$string['profileeditfield'] = 'ກຳລັງແກ້ໄຂຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌: {$a}';
$string['profilefield'] = 'ຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌';
$string['profilefieldcolumns'] = 'ຖັນຕ່າງໆ';
$string['profilefieldispassword'] = 'ນີ້ແມ່ນບ່ອນໃສ່ລະຫັດຜ່ານບໍ?';
$string['profilefieldlink'] = 'ລິ້ງ';
$string['profilefieldlink_help'] = 'ເພື່ອປ່ຽນຂໍ້ຄວາມໃຫ້ເປັນລິ້ງ, ໃຫ້ໃສ່ URL ທີ່ມີ $$, ບ່ອນທີ່ $$ ຈະຖືກແທນທີ່ດ້ວຍຂໍ້ຄວາມ. ຕົວຢ່າງ: ເພື່ອປ່ຽນລະຫັດ ID ຂອງ Twitter ເປັນ ລິ້ງ, ປ້ອນ https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'ລິ້ງເປົ້າໝາຍ';
$string['profilefieldmaxlength'] = 'ຈຳກັດຄວາມຍາວ';
$string['profilefieldmaxlength_help'] = 'ເພື່ອນຳໃຊ້ຊ່ອງຂ້ມູນນີ້ໃນການຕັ້ງຄ່າ \'ສະແດງການລະບຸຕົວຕົນຜູ້ໃຊ້\', ການຈຳກັດຕ້ອງເປັນ 255 ຕົວອັກສອນ ຫຼື ໜ້ອຍກວ່າ.';
$string['profilefieldrows'] = 'ແຖວຕ່າງໆ';
$string['profilefields'] = 'ຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ຜູ້ໃຊ້';
$string['profilefieldsize'] = 'ຂະໜາດຈໍສະແດງຜົນ';
$string['profileforceunique'] = 'ຂໍ້ມູນຄວນບໍ່ຊ້ຳກັນບໍ?';
$string['profileinvaliddata'] = 'ຄ່າບໍ່ຖືກຕ້ອງ';
$string['profilelocked'] = 'ຊ່ອງຂໍ້ມູນນີ້ຖືກລັອກບໍ?';
$string['profilemenudefaultnotinoptions'] = 'ຄ່າເລີ່ມຕົ້ນບໍ່ແມ່ນໜຶ່ງໃນຕົວເລືອກ';
$string['profilemenunooptions'] = 'ບໍ່ມີຕົວເລືອກເມນູໃຫ້';
$string['profilemenuoptions'] = 'ຕົວເລືອກເມນູ (ໜຶ່ງແຖວຕໍ່ແຖວ)';
$string['profilemenutoofewoptions'] = 'ທ່ານຕ້ອງສະໜອງໃຫ້ຢ່າງໜ້ອຍ 2 ທາງເລືອກ';
$string['profilename'] = 'ຊື່';
$string['profilenofieldsdefined'] = 'ບໍ່ໄດ້ກໍານົດຊ່ອງຂໍ້ມູນ';
$string['profilerequired'] = 'ຕ້ອງການຊ່ອງຂໍ້ມູນນີ້ບໍ?';
$string['profileroles'] = 'ບົດບາດທີ່ເບິ່ງເຫັນໄດ້ໃນໂປຼໄຟລ໌';
$string['profilesforenrolledusersonly'] = 'ໂປຼໄຟລ໌ສໍາລັບຜູ້ໃຊ້ທີ່ລົງທະບຽນເທົ່ານັ້ນ';
$string['profileshortname'] = 'ຊື່ສັ້ນ (ຕ້ອງບໍ່ຊໍ້າກັນ)';
$string['profileshortnameinvalid'] = 'ຊື່ສັ້ນນີ້ສາມາດປະກອບມີຕົວອັກສອນ ແລະ ຕົວເລກເທົ່ານັ້ນ (ຕົວອັກສອນ ແລະ ຕົວເລກ) ຫຼື ຂີດກ້ອງ (_).';
$string['profileshortnamenotunique'] = 'ຊື່ສັ້ນນີ້ຖືກນຳໃຊ້ຢູ່';
$string['profilesignup'] = 'ສະແດງຢູ່ໃນໜ້າສະໝັກບໍ?';
$string['profilespecificsettings'] = 'ການຕັ້ງຄ່າສະເພາະ';
$string['profilevisible'] = 'ຊ່ອງຂໍ້ມູນນີ້ສາມາດເບິ່ງເຫັນໄດ້ກັບໃຜ?';
$string['profilevisible_help'] = '* ບໍ່ສາມາດເບິ່ງເຫັນໄດ້ - ສໍາລັບຂໍ້ມູນສ່ວນຕົວສາມາດເບິ່ງໄດ້ໂດຍຜູ້ຄວບຄຸມລະບົບ ແລະ ຜູ້ຈັດການເທົ່ານັ້ນ
* ສາມາດເບິ່ງເຫັນໄດ້ກັບຜູ້ໃຊ້ - ສຳລັບຂໍ້ມູນສ່ວນຕົວສາມາດເບິ່ງເຫັນໄດ້ໂດຍຜູ້ໃຊ້ ແລະ ຜູ້ຄວບຄຸມລະບົບເທົ່ານັ້ນ
* ສາມາດເບິ່ງເຫັນໄດ້ໂດຍຜູ້ໃຊ້, ອາຈານ ແລະ ຜູ້ຄວບຄຸມລະບົບ - ສຳລັບຂໍ້ມູນສ່ວນຕົວສາມາດເບິ່ງໄດ້ໂດຍຜູ້ໃຊ້, ຜູ້ຄວບຄຸມລະບົບ ແລະ ອາຈານເທົ່ານັ້ນ (ຢູ່ໃນໂປຼໄຟລ໌ລາຍວິຊາ)
* ສາມາດເບິ່ງເຫັນໄດ້ກັບທຸກຄົນ';
$string['profilevisibleall'] = 'ເບິ່ງເຫັນໄດ້ກັບທຸກຄົນ';
$string['profilevisiblenone'] = 'ບໍ່ສາມາດເບິ່ງເຫັນໄດ້';
$string['profilevisibleprivate'] = 'ເບິ່ງເຫັນໄດ້ກັບຜູ້ໃຊ້';
$string['profilevisibleteachers'] = 'ເບິ່ງເຫັນໄດ້ກັບຜູ້ໃຊ້, ອາຈານ ແລະ ຜູ້ຄວບຄຸມລະບົບ';
$string['profiling'] = 'ການຂຽນໂປຼໄຟລ໌';
$string['profilingallowall'] = 'ສືບຕໍ່ການຂຽນໂປຼໄຟລ໌';
$string['profilingallowall_help'] = 'ຖ້າທ່ານເປີດໃຊ້ງານການຕັ້ງຄ່ານີ້, ຈາກນັ້ນ, ໃນເວລາໃດໜຶ່ງ, ທ່ານສາມາດໃຊ້ຕົວກໍານົດ PROFILEALL ໄດ້ທຸກບ່ອນ (PGC) ເພື່ອເປີດໃຊ້ການສ້າງໂປຼໄຟລ໌ ສໍາລັບທຸກສະຄຣິບທີ່ຖືກປະຕິບັດໄປຕາມຊີວິດຂອງຊ່ວງເວລາ Moodle. ການປຽບທຽບ, ທ່ານສາມາດໃຊ້ຕົວກຳນົດ PROFILEALLSTOP ເພື່ອຢຸດມັນ.';
$string['profilingallowme'] = 'ເລືອກການຂຽນໂປຼໄຟລ໌';
$string['profilingallowme_help'] = 'ຖ້າທ່ານເປີດໃຊ້ການຕັ້ງຄ່ານີ້, ຫຼັງຈາກນັ້ນ, ໂດຍການເລືອກ, ທ່ານສາມາດໃຊ້ຕົວກໍານົດ PROFILEME ໄດ້ທຸກບ່ອນ (PGC) ແລະ ການຂຽນໂປຼໄຟລ໌ສໍາລັບສະຄຣິບນັ້ນຈະເກີດຂຶ້ນ. ການປຽບທຽບ, ທ່ານສາມາດໃຊ້ຕົວ DONTPROFILEME ເພື່ອປ້ອງກັນບໍ່ໃຫ້ໂປຼໄຟລ໌ເກີດຂຶ້ນ';
$string['profilingautofrec'] = 'ການຂຽນໂປຼໄຟລ໌ອັດຕະໂນມັດ';
$string['profilingautofrec_help'] = 'ໂດຍການກຳນົດຄ່າການຕັ້ງຄ່ານີ້, ການຮ້ອງຂໍບາງອັນ (ແບບສຸ່ມ, ອີງຕາມຄວາມຖີ່ທີ່ລະບຸໄວ້ - 1 ຂອງ N) ຈະຖືກເກັບ ແລະລວມເຂົ້າໂປຼໄຟລ໌ອັດຕະໂນມັດ, ເກັບຮັກສາຜົນໄດ້ຮັບເພື່ອການວິເຄາະຕື່ມອີກ. ກະລຸນາຮັບຊາບວ່າ ວິທີການຂຽນໂປຼໄຟລ໌ນີ້ສັງເກດເບິ່ງການລວມເອົາ/ຍົກເວັ້ນການຕັ້ງຄ່າ. ຕັ້ງມັນເປັນ 0 ເພື່ອປິດການເຮັດໂປຼໄຟລ໌ອັດຕະໂນມັດ.';
$string['profilingenabled'] = 'ເປີດໃຊ້ການຂຽນໂປຼໄຟລ໌';
$string['profilingenabled_help'] = 'ຖ້າທ່ານເປີດໃຊ້ການຕັ້ງຄ່ານີ້, ຫຼັງຈາກນັ້ນການສ້າງໂປຼໄຟລ໌ຈະມີຢູ່ໃນເວັບໄຊທ໌ນີ້ ແລະ ທ່ານຈະສາມາດກໍານົດພຶດຕິກໍາຂອງມັນໄດ້ໂດຍການຕັ້ງຄ່າຕົວເລືອກຕໍ່ໄປ.';
$string['profilingexcluded'] = 'ບໍ່ລວມການຂຽນໂປຼໄຟລ໌';
$string['profilingexcluded_help'] = 'ລາຍຊື່ຂອງ (ໝາຍຈຸດ ຫຼື ເຄື່ອງໝາຍແຖວໃໝ່ທີ່ແຍກອອກຈາກກັນ, ຂ້າມ wwwroot, ສາມາດໂທຫາໄດ້) URLs ທີ່ຈະບໍ່ຖືກຮວມຈາກການເອົາໂປຼໄຟລ໌ ຈາກອັນທີ່ກໍານົດໂດຍການຕັ້ງຄ່າ \'ໂປຼໄຟລ໌ເຫຼົ່ານີ້\'.';
$string['profilingimportprefix'] = 'ຄຳນຳໜ້ານຳເຂົ້າການຂຽນໂປຼໄຟລ໌';
$string['profilingimportprefix_desc'] = 'ເພື່ອໃຫ້ກວດພົບໄດ້ງ່າຍຂຶ້ນ, ທຸກໂປຼໄຟລ໌ທີ່ນໍາເຂົ້າມາຈະຖືກຄໍານໍາໜ້າດ້ວຍຄ່າທີ່ລະບຸໄວ້ທີ່ນີ້.';
$string['profilingincluded'] = 'ໂປຼໄຟລ໌ເຫຼົ່ານີ້';
$string['profilingincluded_help'] = 'ບັນຊີລາຍຊື່ຂອງ (ໝາຍຈຸດ ຫຼື ແຖວໃໝ່ທີ່ແຍກອອກ, ຂ້າມ wwwroot ຢ່າງແທ້ຈິງ, ສາມາດໂທຫາໄດ້) URLs ທີ່ຈະຖືກປະກອບອັດຕະໂນມັດ. ຕົວຢ່າງ: /index.php, /course/view.php. ຍອມຮັບ * ຕົວແທນຢູ່ໃນຕໍາແໜ່ງໃດກໍ່ໄດ້. ຕົວຢ່າງ: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'ຮັກສາໃຫ້ການຂຽນໂປຼໄຟລ໌ແລ່ນ';
$string['profilinglifetime_help'] = 'ລະບຸເວລາທີ່ທ່ານຕ້ອງການເກັບຮັກສາຂໍ້ມູນກ່ຽວກັບການຂຽນໂປຼໄຟລ໌ເກົ່າ. ຕົວເກົ່າຈະຖືກຕັດອອກເປັນໄລຍະ. ກະລຸນາຮັບຊາບວ່າ ສິ່ງນີ້ບໍ່ລວມເອົາການຂຽນໂປຼໄຟລ໌ໃດໜຶ່ງທີ່ຖືກໝາຍເປັນ \'ການແລ່ນອ້າງອີງ\'.';
$string['profilingslow'] = 'ໂປຼໄຟລ໌ໜ້າຊ້າ';
$string['profilingslow_help'] = 'ໂດຍການຕັ້ງເວລາຂັ້ນຕ່ຳສຸດເປັນວິນາທີ, ທຸກໜ້າທີ່ຊ້າລົງຈະຖືກຂຽນໂປຼໄຟລ໌. ສະເພາະໂປຼໄຟລ໌ ທີ່ຊ້າກວ່າໂປຼໄຟລ໌ທີ່ມີຢູ່ແລ້ວສຳລັບສະຄຣິບດຽວກັນຈະຖືກເກັບຮັກສາໄວ້. ຕັ້ງເປັນ 0 ເພື່ອປິດການນຳໃຊ້. ໃຫ້ສັງເກດວ່າສິ່ງນີ້ສັງເກດການຕັ້ງຄ່າທີ່ບໍ່ລວມເອົາ.';
$string['protectusernames'] = 'ປົກປ້ອງຊື່ຜູ້ໃຊ້';
$string['proxybypass'] = 'ເຈົ້າພາບຂ້າມຕົວແທນ';
$string['proxyfixunsafe'] = 'ແກ້ໄຂການໂທທີ່ບໍ່ມີພຣັອກຊີ';
$string['proxyhost'] = 'ເຈົ້າພາບຕົວແທນ';
$string['proxylogunsafe'] = 'ບັນທຶກການໂທທີ່ບໍ່ມີພຣັອກຊີ';
$string['proxypassword'] = 'ລະຫັດຕົວແທນ';
$string['proxyport'] = 'ພອດຕົວແທນ';
$string['proxytype'] = 'ປະເພດຕົວແທນ';
$string['proxyuser'] = 'ຊື່ຜູ້ໃຊ້ຕົວແທນ';
$string['purgecaches'] = 'ລຶບລ້າງຂໍ້ມູນທັງໝົດ';
$string['purgecachesconfirm'] = 'Moodle ສາມາດເກັບຂໍ້ມູນຫົວຂໍ້, javascript, ສະຕຣິງພາສາ, ຂໍ້ຄວາມທີ່ກັ່ນຕອງແລ້ວ, ຟີດ rss ແລະ ຂໍ້ມູນທີ່ໄດ້ຄຳນວນແລ້ວຫຼາຍອັນ. ການລຶບລ້າງຖານຄວາມຈຳເຫຼົ່ານີ້ຈະລຶບຂໍ້ມູນນັ້ນອອກຈາກເຊີບເວີ ແລະ ບັງຄັບໃຫ້ໂປຼແກຼມທ່ອງເວັບເກັບຂໍ້ມູນຄືນໃໝ່, ເພື່ອໃຫ້ທ່ານໝັ້ນໃຈວ່າ ທ່ານໄດ້ເຫັນຄ່າທີ່ທັນສະໄໝທີ່ສຸດທີ່ຜະລິດໂດຍລະຫັດປັດຈຸບັນ. ບໍ່ມີອັນຕະລາຍໃນການລຶບລ້າງຖານຄວາມຈໍາ, ແຕ່ເວັບໄຊທ໌ຂອງທ່ານອາດປະກົດວ່າຊ້າລົງໄປໄລຍະໜຶ່ງຈົນກ່ວາເຊີບເວີ ແລະ ລູກຄ້າຄິດໄລ່ຂໍ້ມູນໃໝ່ ແລະ ເກັບມັນໄວ້.';
$string['purgecachesfinished'] = 'ຖານຄວາມຈຳທັງໝົດຖືກລຶບລ້າງ.';
$string['purgecachesnoneselected'] = 'ເລືອກໜຶ່ງ ຫຼື ຫຼາຍແຄດເພື່ອລຶບລ້າງ';
$string['purgecachespage'] = 'ລຶບລ້າງຖານຄວາມຈໍາ';
$string['purgefiltercache'] = 'ຕົວກັ່ນຕອງຂໍ້ຄວາມ';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'ສະຕຣິງພາສາ';
$string['purgemuc'] = 'ຖານຄວາມຈໍາ MUC ທັງໝົດ';
$string['purgeothercaches'] = 'ໄຟລ໌ໝົດ ແລະ ຈາກຖານຄວາມຈໍາຕ່າງໆ';
$string['purgeselectedcaches'] = 'ລຶບລ້າງຖານຄວາມຈຳທີ່ເລືອກ';
$string['purgeselectedcachesfinished'] = 'ຖານຄວາມຈໍາທີ່ເລືອກໄດ້ຖືກລຶບລ້າງແລ້ວ.';
$string['purgetemplates'] = 'ແມ່ແບບ';
$string['purgethemecache'] = 'ຮູບແບບສີສັນ';
$string['query'] = 'ການສອບຖາມ';
$string['question'] = 'ຄຳຖາມ';
$string['questionbehaviours'] = 'ພຶດຕິກໍາຄໍາຖາມ';
$string['questioncwqpfscheck'] = 'ໜຶ່ງ ຫຼື ຫຼາຍຄຳຖາມແບບສຸ່ມໃນແບບທົດສອບຖືກຕັ້ງຂຶ້ນເພື່ອເລືອກຄຳຖາມຈາກການປະສົມຂອງປະເພດຄຳຖາມທີ່ແບ່ງປັນ ແລະ ບໍ່ໄດ້ແບ່ງປັນ. ເບິ່ງ <a href="{$a->reporturl}">ລາຍງານຄຳຖາມສຸ່ມ</a> ແລະ <a href="{$a->docsurl}">documentation</a>.';
$string['questioncwqpfsok'] = 'ດີ. ບໍ່ມີຄຳຖາມ \'ແບບສຸ່ມ\' ຢູ່ໃນແບບສອບຖາມຂອງທ່ານທີ່ຖືກຕັ້ງຂຶ້ນເພື່ອເລືອກ ຄຳຖາມຈາກການປະສົມຂອງປະເພດຄຳຖາມທີ່ແບ່ງປັນ ແລະ ບໍ່ໄດ້ແບ່ງປັນ.';
$string['questiontype'] = 'ປະເພດຄໍາຖາມ';
$string['questiontypes'] = 'ບັນດາປະເພດຄໍາຖາມ';
$string['quizattemptsupgradedmessage'] = 'ໃນ Moodle 2.1 ມີການຍົກລະດັບຄຳຖາມທີ່ສຳຄັນ. ມັນເປັນໄປໄດ້ທີ່ຈະຊັກຊ້າບາງສ່ວນຂອງການຍົກລະດັບຖານຂໍ້ມູນທີ່ຈະດໍາເນີນຕໍ່ມາ. ກ່ອນຈະຍົກລະດັບເປັນ Moodle 2.7, ການຍົກລະດັບນີ້ຕ້ອງສຳເລັດ.';
$string['recaptchaprivatekey'] = 'ລະຫັດລັບ ReCAPTCHA';
$string['recaptchapublickey'] = 'ລະຫັດເວັບໄຊທ໌ ReCAPTCHA';
$string['referrernone'] = 'ຄ່າເລີ່ມຕົ້ນຂອງໂປຼແກຼມທ່ອງເວັບ';
$string['referrerpolicy'] = 'ນະໂຍບາຍຜູ້ອ້າງອີງ';
$string['referrerpolicydesc'] = 'ກໍານົດຫົວຂໍ້ນະໂຍບາຍຜູ້ສົ່ງຕໍ່ເພື່ອໃຫ້ລວມເຂົ້າກັບຄໍາຕອບຈາກເວັບໄຊທ໌ຂອງທ່ານ.';
$string['register'] = 'ລົງທະບຽນເວັບໄຊທ໌ຂອງທ່ານ';
$string['registration'] = 'ການລົງທະບຽນ';
$string['registration_help'] = 'ໂດຍການລົງທະບຽນ:

* ທ່ານຈະໄດ້ຮັບການແຈ້ງເຕືອນຄວາມປອດໄພ
* ທ່ານສາມາດເປີດນຳໃຊ້ການແຈ້ງເຕືອນແອັບມືຖືຈາກເວັບໄຊທ໌ຂອງທ່ານ
* ທ່ານກໍາລັງປະກອບສ່ວນໃຫ້ກັບສະຖິຕິ Moodle ຂອງພວກເຮົາໃນຊຸມຊົນທົ່ວໂລກ';
$string['registrationwarning'] = 'ເວັບໄຊທ໌ຂອງທ່ານຍັງບໍ່ໄດ້ລົງທະບຽນເທື່ອ.';
$string['registrationwarningcontactadmin'] = 'ເວັບໄຊທ໌ຂອງທ່ານຍັງບໍ່ໄດ້ລົງທະບຽນເທື່ອ. ກະລຸນາແຈ້ງຜູ້ເບິ່ງແຍງລະບົບຂອງທ່ານ.';
$string['releasenoteslink'] = 'ສໍາລັບຂໍ້ມູນກ່ຽວກັບ Moodle ສະບັບນີ້, ກະລຸນາເບິ່ງ <a target="_blank" href="{$a}">ບັນທຶກການປ່ອຍ</a>';
$string['rememberuserlicensepref'] = 'ຈື່ການຕັ້ງຄ່າໃບອະນຸຍາດຜູ້ໃຊ້';
$string['rememberuserlicensepref_help'] = 'ຖ້າເປີດໃຊ້ງານ, ໃບອະນຸຍາດສຸດທ້າຍທີ່ຜູ້ໃຊ້ເລືອກໄວ້ຈະຖືກເລືອກໄວ້ກ່ອນເມື່ອອັບໂຫຼດໄຟລ໌ຢູ່ໃນຕົວເລືອກໄຟລ໌. ຖ້າບໍ່ດັ່ງນັ້ນ, ໃບອະນຸຍາດເວັບໄຊທ໌ເລີ່ມຕົ້ນແມ່ນຖືກເລືອກໄວ້ລ່ວງໜ້າ.';
$string['rememberusername'] = 'ຈື່ຊື່ຜູ້ໃຊ້';
$string['rememberusername_desc'] = 'ເປີດນຳໃຊ້ຖ້າທ່ານຕ້ອງການເກັບຮັກສາຄຸກກີ້ຖາວອນດ້ວຍຊື່ຜູ້ໃຊ້ໃນລະຫວ່າງການເຂົ້າສູ່ລະບົບຂອງຜູ້ໃຊ້. ຄຸກກີ້ຖາວອນອາດຈະຖືກພິຈາລະນາເປັນບັນຫາດ້ານຄວາມເປັນສ່ວນຕົວຖ້າໃຊ້ໂດຍບໍ່ໄດ້ຮັບການຍິນຍອມ.';
$string['replacefrontsearch'] = 'ນຳໃຊ້ສຳລັບການຄົ້ນຫາລາຍວິຊາໜ້າຫຼັກເວັບໄຊທ໌';
$string['reportsmanage'] = 'ຈັດການລາຍງານ';
$string['required'] = 'ຈຳເປັນ';
$string['requiredentrieschanged'] = 'ໝາຍເຫດ: ຫຼັງຈາກການຍົກລະດັບ, ການຕັ້ງຄ່າ \'ລາຍການທີ່ຕ້ອງການກ່ອນການເບິ່ງ\' ແມ່ນຖືກບັງຄັບໃຊ້ໃນກິດຈະກໍາຖານຂໍ້ມູນຕໍ່ໄປນີ້:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'ຕ້ອງການລາຍລະອຽດກິດຈະກໍາ';
$string['requiremodintro_desc'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ຈະຖືກບັງຄັບໃຫ້ໃສ່ລາຍລະອຽດສໍາລັບແຕ່ລະກິດຈະກໍາ.';
$string['requires'] = 'ຕ້ອງໃຊ້';
$string['restorecourse'] = 'ຟື້ນຟູວິຊາ';
$string['restorernewroleid'] = 'ໜ້າທີ່ຂອງຜູ້ກູ້ໃນວິຊາ';
$string['restorernewroleid_help'] = 'ຖ້າຜູ້ໃຊ້ບໍ່ມີສິດອະນຸຍາດໃນການຈັດການວິຊາທີ່ຖືກຟື້ນຟູໃໝ່, ຜູ້ໃຊ້ຈະຖືກມອບແຕ່ງຕັ້ງທີ່ນີ້ໂດຍອັດຕະໂນມັດ ແລະ ລົງທະບຽນຖ້າຈໍາເປັນ. ເລືອກ "ບໍ່ມີ" ຖ້າທ່ານບໍ່ຕ້ອງການໃຫ້ຜູ້ກູ້ຂໍ້ມູນສາມາດຈັດການທຸກລາຍວິຊາທີ່ໄດ້ກູ້ຄືນມາ.';
$string['resultfilter'] = 'ກັ່ນຕອງຕາມຜົນໄດ້ຮັບ';
$string['reverseproxy'] = 'ປີ້ນຕົວແທນ';
$string['reverseproxyignore'] = 'ບໍ່ສົນໃຈຕົວແທນປີ້ນ';
$string['riskconfig'] = 'ຜູ້ໃຊ້ສາມາດປ່ຽນການຕັ້ງຄ່າ ແລະ ພຶດຕິກໍາຂອງສະຖານທີ່';
$string['riskconfigshort'] = 'ຄວາມສ່ຽງການຕັ້ງຄ່າ';
$string['riskdataloss'] = 'ຜູ້ໃຊ້ສາມາດທຳລາຍເນື້ອຫາ ຫຼື ຂໍ້ມູນຈຳນວນຫຼວງຫຼາຍ';
$string['riskdatalossshort'] = 'ຄວາມສ່ຽງການສູນເສຍຂໍ້ມູນ';
$string['riskmanagetrust'] = 'ຜູ້ໃຊ້ສາມາດປ່ຽນການຕັ້ງຄ່າຄວາມໄວ້ວາງໃຈຂອງຜູ້ໃຊ້ອື່ນ';
$string['riskmanagetrustshort'] = 'ຈັດການຄວາມໄວ້ວາງໃຈ';
$string['riskpersonal'] = 'ຜູ້ໃຊ້ສາມາດເຂົ້າເຖິງຂໍ້ມູນສ່ວນຕົວຂອງຜູ້ໃຊ້ອື່ນ';
$string['riskpersonalshort'] = 'ຄວາມສ່ຽງດ້ານຄວາມເປັນສ່ວນຕົວ';
$string['riskspam'] = 'ຜູ້ໃຊ້ສາມາດສົ່ງຂີ້ເຫຍື້ອໄປຫາຜູ້ໃຊ້ເວັບໄຊທ໌ ຫຼື ຜູ້ອື່ນ';
$string['riskspamshort'] = 'ຄວາມສ່ຽງຂີ້ເຫຍື້ອ';
$string['riskxss'] = 'ຜູ້ໃຊ້ສາມາດເພີ່ມໄຟລ໌ ແລະ ບົດເລື່ອງຕ່າງໆທີ່ອະນຸຍາດໃຫ້ການຂຽນສະຄຣິບຂ້າມເວັບໄຊທ໌ (XSS)';
$string['riskxssshort'] = 'ຄວາມສ່ຽງ XSS';
$string['roleswithexceptions'] = '{$a->roles}, ກັບ {$a->exceptions}';
$string['rssglobaldisabled'] = 'ປິດໃຊ້ງານຢູ່ໃນລະດັບເວັບໄຊທ໌';
$string['save'] = 'ບັນທຶກ';
$string['savechanges'] = 'ບັນທຶກການປ່ຽນແປງ';
$string['scssinvalid'] = 'ລະຫັດ SCSS ບໍ່ຖືກຕ້ອງ, ລົ້ມເຫລວດ້ວຍ: {$ a}';
$string['search'] = 'ຄົ້ນຫາ';
$string['searchablecourses'] = 'ວິຊາສາມາດຄົ້ນຫາ';
$string['searchallavailablecourses'] = 'ວິຊາສາມາດຄົ້ນຫາ';
$string['searchallavailablecourses_desc'] = 'ໃນບາງສະຖານະການເຄື່ອງຈັກຊອກຫາອາດຈະບໍ່ເຮັດວຽກເມື່ອຄົ້ນຫາໃນວິຊາຫຼາຍອັນ. ຕັ້ງເພື່ອຄົ້ນຫາພຽງແຕ່ວິຊາທີ່ລົງທະບຽນເຂົ້າຮຽນຖ້າທ່ານຕ້ອງການຈໍາກັດຈໍານວນວິຊາການຄົ້ນຫາ.';
$string['searchallavailablecourses_off'] = 'ຄົ້ນຫາພາຍໃນວິຊາທີ່ລົງທະບຽນແລ້ວເທົ່ານັ້ນ';
$string['searchallavailablecourses_on'] = 'ຄົ້ນຫາພາຍໃນທຸກວິຊາທີ່ຜູ້ໃຊ້ສາມາດເຂົ້າຫາໄດ້';
$string['searchallavailablecoursesdesc'] = 'ຖ້າກໍານົດໃຫ້ຄົ້ນຫາພາຍໃນວິຊາທີ່ລົງທະບຽນແລ້ວເທົ່ານັ້ນ, ຂໍ້ມູນລາຍວິຊາ (ຊື່ ແລະ ບົດສະຫຼຸບ) ແລະ ເນື້ອໃນຫຼັກສູດຈະຖືກຄົ້ນຫາໃນຫຼັກສູດທີ່ຜູ້ໃຊ້ລົງທະບຽນຢູ່ເທົ່ານັ້ນ. ຖ້າບໍ່ດັ່ງນັ້ນ, ຂໍ້ມູນວິຊາ ແລະ ເນື້ອໃນວິຊາຈະຖືກຄົ້ນຫາໃນວິຊາທັງໝົດທີ່ຜູ້ໃຊ້ສາມາດເຂົ້າເຖິງໄດ້, ເຊັ່ນ: ວິຊາທີ່ເປີດໃຫ້ແຂກເຂົ້າເຖິງ.';
$string['searchalldeleted'] = 'ເນື້ອໃນດັດຊະນີທັງໝົດຖືກລຶບອອກແລ້ວ';
$string['searchalternatesettings'] = 'ການຕັ້ງຄ່າສຳຮອງເທົ່ານັ້ນ';
$string['searchalternatesettings_desc'] = 'ຖ້າທ່ານເຮັດການຕັ້ງຄ່າເຫຼົ່ານີ້ໃຫ້ສໍາເລັດ, ທ່ານສາມາດເລືອກ \'ການຕັ້ງຄ່າສຳຮອງ\' ສໍາລັບເຄື່ອງຈັກຊອກຫານີ້ຢູ່ໃນຕົວເລືອກເຄື່ອງຈັກຊອກຫາເທົ່ານັ້ນຢູ່ໃນໜ້າ \'ຈັດການການຄົ້ນຫາທົ່ວໂລກ\'. ສິ່ງນີ້ມີປະໂຫຍດພຽງແຕ່ເມື່ອເຄື່ອນຍ້າຍລະຫວ່າງສອງເຄື່ອງຈັກຊອກຫາປະເພດດຽວກັນ.';
$string['searchareadisabled'] = 'ປິດການນຳໃຊ້ພື້ນທີ່ຄົ້ນຫາແລ້ວ';
$string['searchareaenabled'] = 'ເປີດການນຳໃຊ້ພື້ນທີ່ຄົ້ນຫາແລ້ວ';
$string['searchareas'] = 'ພື້ນທີ່ຄົ້ນຫາ';
$string['searchbanner'] = 'ຄົ້ນຫາຂໍ້ມູນ';
$string['searchbannerenable'] = 'ສະແດງຂໍ້ມູນຄົ້ນຫາ';
$string['searchbannerenable_desc'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ຂໍ້ຄວາມຢູ່ລຸ່ມນີ້ຈະສະແດງຂຶ້ນຢູ່ເທິງສຸດຂອງໜ້າຈໍຊອກຫາສໍາລັບຜູ້ໃຊ້ທຸກຄົນ. ສິ່ງນີ້ສາມາດໃຊ້ເພື່ອແຈ້ງໃຫ້ຜູ້ໃຊ້ຮູ້ເມື່ອການບຳລຸງຮັກສາເຄື່ອງຈັກຊອກຫາກໍາລັງດໍາເນີນຢູ່.';
$string['searchdefaultcategory'] = 'ປະເພດການຊອກຫາເລີ່ມຕົ້ນ';
$string['searchdefaultcategory_desc'] = 'ຜົນໄດ້ຮັບຈາກປະເພດການຄົ້ນຫາທີ່ເລືອກຈະຖືກສະແດງຕາມຄ່າເລີ່ມຕົ້ນ.';
$string['searchdeleteindex'] = 'ລຶບເນື້ອໃນດັດຊະນີທັງຫມົດ';
$string['searchdisplay'] = 'ຕົວເລືອກການສະແດງຜົນການຊອກຫາ';
$string['searchenablecategories'] = 'ສະແດງຜົນການຄົ້ນຫາໃນປະເພດແຍກຕ່າງຫາກ';
$string['searchenablecategories_desc'] = 'ຖ້າເປີດໃຊ້ແລ້ວ, ຜົນການຄົ້ນຫາຈະຖືກສະແດງຢູ່ໃນປະເພດແຍກຕ່າງຫາກ.';
$string['searchengine'] = 'ເຄື່ອງຈັກຊອກຫາ';
$string['searchenginealternatesettings'] = '{$ a} (ການຕັ້ງຄ່າ ສຳ ຮອງ)';
$string['searchenginequeryonly'] = 'ເຄື່ອງຈັກຊອກຫາ ການສອບຖາມ-ເທົ່ານັ້ນ';
$string['searchenginequeryonly_desc'] = 'ເຄື່ອງຈັກຊອກຫານີ້ ຈະຖືກໃຊ້ເພື່ອເຮັດການສອບຖາມ, ບໍ່ແມ່ນການສ້າງດັດຊະນີ. ໂດຍການນໍາໃຊ້ຄຸນສົມບັດນີ້ທ່ານສາມາດຈັດດັດສະນີຄືນໃໝ່ຢູ່ໃນເຄື່ອງຈັກຊອກຫາທີ່ແຕກຕ່າງກັນ, ໃນຂະນະທີ່ຄໍາຖາມຂອງຜູ້ໃຊ້ສືບຕໍ່ເຮັດວຽກຈາກສິ່ງນີ້.';
$string['searchenginequeryonly_none'] = 'ບໍ່ມີ (ໃຊ້ເຄື່ອງຈັກຊອກຫາຫຼັກສໍາລັບການສອບຖາມ)';
$string['searchenginequeryonlysame'] = 'ເຄື່ອງຈັກຊອກຫາການສອບຖາມ-ເທົ່ານັ້ນ ແລະ ເຄື່ອງຈັກຊອກຫາຫຼັກບໍ່ສາມາດຕັ້ງເປັນຄ່າດຽວກັນໄດ້.';
$string['searchhideallcategory'] = 'ເຊື່ອງປະເພດຜົນໄດ້ຮັບທັງໝົດ';
$string['searchhideallcategory_desc'] = 'ຖ້າໝາຍຖືກ, ປະເພດທີ່ມີຜົນໄດ້ຮັບທັງໝົດຈະຖືກເຊື່ອງໄວ້ຢູ່ໃນໜ້າຈໍຜົນການຄົ້ນຫາ.';
$string['searchincludeallcourses'] = 'ລວມເອົາຫຼັກສູດທີ່ເບິ່ງເຫັນທັງໝົດ';
$string['searchincludeallcourses_desc'] = 'ຖ້າເປີດນຳໃຊ້, ຜົນການຄົ້ນຫາຈະລວມມີຂໍ້ມູນລາຍວິຊາ (ຊື່ ແລະ ສະຫຼຸບ) ຫຼັກສູດທີ່ຜູ້ໃຊ້ສາມາດເບິ່ງເຫັນໄດ້, ເຖິງແມ່ນວ່າເຂົາເຈົ້າບໍ່ສາມາດເຂົ້າເຖິງເນື້ອຫາລາຍວິຊາໄດ້.';
$string['searchindexactions'] = 'ຄຳສັ່ງດັດຊະນີ';
$string['searchindexdeleted'] = 'ລຶບດັດຊະນີແລ້ວ';
$string['searchindextime'] = 'ກຳນົດເວລາດັດຊະນີ';
$string['searchindextime_desc'] = 'ເມື່ອຈັດດັດຊະນີເນື້ອຫາໃໝ່ເປັນຈໍານວນຫຼາຍ, ໜ້າວຽກທີ່ກໍານົດເວລາໄວ້ຈະຢຸດຫຼັງຈາກຮອດຂີດຈໍາກັດເວລານີ້. ມັນຈະສືບຕໍ່ໃນຄັ້ງຕໍ່ໄປທີ່ ໜ້າ ວຽກແລ່ນ.';
$string['searchindexupdated'] = 'ເນື້ອຫາຂອງເຄື່ອງຈັກຊອກຫາໄດ້ຖືກອັບເດດແລ້ວປັບປຸງແລ້ວ';
$string['searchindexwhendisabled'] = 'ດັດຊະນີເມື່ອປິດການນຳໃຊ້';
$string['searchindexwhendisabled_desc'] = 'ອະນຸຍາດໃຫ້ໜ້າວຽກທີ່ກຳນົດເວລາໄວ້ເພື່ອສ້າງດັດສະນີຄົ້ນຫາເຖິງແມ່ນວ່າຈະປິດການຊອກຫາ. ສິ່ງນີ້ເປັນປະໂຫຍດຖ້າທ່ານຕ້ອງການສ້າງດັດຊະນີກ່ອນທີ່ບ່ອນຄົ້ນຫາຈະປະກົດຕໍ່ກັບນັກຮຽນ.';
$string['searchinsettings'] = 'ຄົ້ນຫາໃນການຕັ້ງຄ່າ';
$string['searchlastrun'] = 'ແລ່ນຄັ້ງສຸດທ້າຍ (ເວລາ, # ເອກະສານ, # ບັນທຶກ, # ບໍ່ສົນໃຈ)';
$string['searchmanagement'] = 'ການຈັດການຄົ້ນຫາ';
$string['searchmanagement_desc'] = 'ຕົວເລືອກເຫຼົ່ານີ້ມີປະໂຫຍດເມື່ອເຮັດການປ່ຽນແປງຢູ່ໃນເວັບໄຊທ໌ທີ່ມີດັດສະນີການຊອກຫາຈຳນວນຫຼາຍເຊິ່ງໃຊ້ເວລາດົນເພື່ອສ້າງຄືນໃໝ່.';
$string['searchmaxtopresults'] = 'ຜົນໄດ້ຮັບເທິງສຸດສູງສຸດ';
$string['searchmaxtopresults_desc'] = 'ຈໍານວນສູງສຸດຂອງຜົນໄດ້ຮັບອັນດັບສູງສຸດທີ່ຈະສະແດງຢູ່ຂ້າງເທິງຜົນການຄົ້ນຫາສໍາລັບເນື້ອຫາລາຍວິຊາ, ວິຊາ ແລະ ຜູ້ໃຊ້.';
$string['searchnotavailable'] = 'ບໍ່ສາມາດຄົ້ນຫາໄດ້';
$string['searchoptions'] = 'ຕົວເລືອກການຄົ້ນຫາ';
$string['searchpartial'] = '(ຍັງບໍ່ໄດ້ດັດສະນີຢ່າງເຕັມທີ່)';
$string['searchreindexed'] = 'ເນື້ອໃນເວັບໄຊທ໌ທັງໝົດໄດ້ຖືກຈັດດັດສະນີຄືນໃໝ່.';
$string['searchreindexindex'] = 'ຈັດດັດສະນີຄືນໃໝ່ເນື້ອໃນເວັບໄຊທ໌ທັງຫມົດ';
$string['searchresults'] = 'ຜົນການຄົ້ນຫາ';
$string['searchsetupinfo'] = 'ຕັ້ງຄ່າການຄົ້ນຫາ';
$string['searchteacherroles'] = 'ໜ້າທີ່ຄູສອນ';
$string['searchteacherroles_desc'] = 'ເລືອກທຸກໜ້າທີ່ທີ່ເຮັດໃຫ້ຜູ້ໃຊ້ທີ່ມີອັນດັບໜ້າທີ່ສູງຂຶ້ນໃນຜົນການຄົ້ນຫາ.';
$string['searchtopresults'] = 'ຜົນໄດ້ຮັບເທິງ';
$string['searchupdateindex'] = 'ປັບປຸງເນື້ອໃນດັດຊະນີ';
$string['sectionerror'] = 'ພາກຜິດພາດ!';
$string['secureforms'] = 'ໃຊ້ຮູບແບບຄວາມປອດໄພເພີ່ມເຕີມ';
$string['security'] = 'ຄວາມປອດໄພ';
$string['selectdevice'] = 'ເລືອກອຸປະກອນ';
$string['selectsearchengine'] = 'ເລືອກເຄື່ອງຈັກການຄົ້ນຫາ';
$string['selecttheme'] = 'ເລືອກຮູບແບບສີສັນສຳລັບອຸປະກອນ {$a}';
$string['server'] = 'ເຊີບເວີ';
$string['serverchecks'] = 'ກວດສອບເຊີບເວີ';
$string['serverlimit'] = 'ຈຳກັດເຊີບເວີ';
$string['sessionautostartwarning'] = '<p>ກວດພົບຂໍ້ຜິດພາດການຕັ້ງຄ່າທີ່ຮຸນແຮງ, ກະລຸນາແຈ້ງຜູ້ຄວບຄຸມເຊີບເວີ. </p><p> ເພື່ອປະຕິບັດໄດ້ຢ່າງຖືກຕ້ອງ, Moodle ຕ້ອງການໃຫ້ຜູ້ຄວບຄຸມປ່ຽນການຕັ້ງຄ່າ PHP.</p><p><code>session.auto_start</code> ຕ້ອງຕັ້ງເປັນ <code>ປິດ</code>.</p><p> ການຕັ້ງຄ່ານີ້ຖືກຄວບຄຸມໂດຍການແກ້ໄຂ <code>php.ini</code>, Apache/IIS <br /> ການຕັ້ງຄ່າ ຫຼື <code>.htaccess</code> ໄຟລ໌ຢູ່ໃນເຊີບເວີ. </p>';
$string['sessioncookie'] = 'ຄຳນຳໜ້າຄຸກກີ້';
$string['sessioncookiedomain'] = 'ໂດເມນຄຸກກີ້';
$string['sessioncookiepath'] = 'ເສັ້ນທາງຄຸກກີ້';
$string['sessionhandling'] = 'ການຈັດການຊ່ວງເວລາ';
$string['sessiontimeout'] = 'ໝົດເວລາ';
$string['sessiontimeoutwarning'] = 'ຄຳເຕືອນໝົດເວລາ';
$string['settingdependenton'] = 'ການຕັ້ງຄ່ານີ້ອາດຈະຖືກເຊື່ອງໄວ້, ໂດຍອ້າງອີງຈາກຄ່າຂອງ <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'ການອັບໂຫຼດໄຟລ໌ແມ່ນຕ້ອງການສໍາລັບການດໍາເນີນງານປົກກະຕິ, ກະລຸນາເປີດໃຊ້ມັນໃນການຕັ້ງຄ່າ PHP.';
$string['settingmaxinputvars'] = 'ການຕັ້ງຄ່າ PHP max_input_vars ແມ່ນແນະນຳໃຫ້ມີຢ່າງໜ້ອຍ 5000.';
$string['settingmaxinputvarsrequired'] = 'ການຕັ້ງຄ່າ PHP max_input_vars ຕ້ອງມີຢ່າງໜ້ອຍ 5000.';
$string['settingmemorylimit'] = 'ກວດພົບໜ່ວຍຄວາມຈຳບໍ່ພຽງພໍ, ກະລຸນາຕັ້ງຂີດຈຳກັດຄວາມຈຳສູງຂຶ້ນໃນການຕັ້ງຄ່າ PHP.';
$string['settingsafemode'] = 'Moodle ບໍ່ເຂົ້າກັນໄດ້ຢ່າງເຕັມທີ່ກັບໂໝດປອດໄພ, ກະລຸນາຖາມຜູ້ຄວບຄຸມເຊີບເວີເພື່ອປິດມັນ. ບໍ່ຮອງຮັບການແລ່ນ Moodle ພາຍໃຕ້ໂໝດປອດໄພ, ກະລຸນາຄາດຫວັງກັບບັນຫາຕ່າງໆ ຖ້າທ່ານເຮັດແນວນັ້ນ.';
$string['setupsearchengine'] = 'ຕັ້ງເຄື່ອງຈັກຊອກຫາ';
$string['showcommentscount'] = 'ສະແດງຈຳນວນຄຳເຫັນ';
$string['showdetails'] = 'ສະແດງລາຍລະອຽດ';
$string['showuseridentity'] = 'ສະແດງຕົວຕົນຂອງຜູ້ໃຊ້';
$string['showuseridentity_desc'] = 'ເມື່ອເລືອກ ຫຼື ຄົ້ນຫາຜູ້ໃຊ້, ແລະ ເມື່ອສະແດງລາຍການຜູ້ໃຊ້, ຊ່ອງຂໍ້ມູນເຫຼົ່ານີ້ອາດຈະຖືກສະແດງໃຫ້ເຫັນນອກຈາກຊື່ເຕັມຂອງເຂົາທ່ານ. ຊ່ອງຂໍ້ມູນແມ່ນສະແດງໃຫ້ເຫັນສະເພາະກັບຜູ້ໃຊ້ທີ່ມີຄວາມສາມາດ moodle/site:viewuseridentity; ໂດຍຄ່າເລີ່ມຕົ້ນ, ອາຈານ ແລະ ຜູ້ຈັດການ. (ຕົວເລືອກນີ້ມີຄວາມໝາຍທີ່ສຸດຖ້າທ່ານເລືອກໜຶ່ງ ຫຼື ສອງຊ່ອງຂໍ້ມູນທີ່ບັງຄັບຢູ່ສະຖາບັນຂອງທ່ານ.)

ຊ່ອງຂໍ້ມູນທີ່ໝາຍໄວ້ * ແມ່ນຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ຜູ້ໃຊ້ແບບກຳນົດເອງ. ທ່ານສາມາດເລືອກຊ່ອງຂໍ້ມູນເຫຼົ່ານີ້ໄດ້, ແຕ່ປະຈຸບັນມີບາງໜ້າຈໍທີ່ພວກມັນຈະບໍ່ປາກົດ.';
$string['simplexmlrequired'] = 'ດຽວນີ້ Moodle ຕ້ອງການສ່ວນຂະຫຍາຍ PHP ຂອງ SimpleXML.';
$string['sitemailcharset'] = 'ຊຸດຕົວອັກສອນ';
$string['sitemaintenance'] = 'ສະຖານທີ່ດັ່ງກ່າວກຳລັງຢູ່ໃນການບໍາລຸງຮັກສາ ແລະ ບໍ່ສາມາດໃຊ້ໄດ້ໃນເວລານີ້';
$string['sitemaintenancemode'] = 'ໂໝດການບໍາລຸງຮັກສາ';
$string['sitemaintenanceoff'] = 'ໂໝດການບຳລຸງຮັກສາໄດ້ຖືກປິດການນຳໃຊ້ ແລະ ສະຖານທີ່ເຮັດວຽກປົກກະຕິອີກຄັ້ງ';
$string['sitemaintenanceon'] = 'ປະຈຸບັນເວັບໄຊທ໌ຂອງທ່ານຢູ່ໃນຮູບແບບການບໍາລຸງຮັກສາ (ມີພຽງແຕ່ຜູ້ຄວບຄຸມລະບົບເທົ່ານັ້ນສາມາດເຂົ້າສູ່ລະບົບ ຫຼື ໃຊ້ເວັບໄຊທ໌ໄດ້).';
$string['sitemaintenanceoncli'] = 'ປະຈຸບັນເວັບໄຊທ໌ຂອງທ່ານຢູ່ໃນຮູບແບບການບໍາລຸງຮັກສາ CLI, ບໍ່ອະນຸຍາດໃຫ້ເຂົ້າເຖິງເວັບທ໌ໄດ້.';
$string['sitemaintenancetitle'] = '{$a} ຢູ່ພາຍໃຕ້ການບໍາລຸງຮັກສາ';
$string['sitemaintenancewarning'] = 'ປະຈຸບັນເວັບໄຊທ໌ຂອງທ່ານຢູ່ໃນໂໝດການບໍາລຸງຮັກສາ (ມີພຽງແຕ່ຜູ້ດູແລເທົ່ານັ້ນສາມາດເຂົ້າສູ່ລະບົບໄດ້). ເພື່ອກັບຄືນເວັບໄຊທ໌ນີ້ກັບຄືນສູ່ການເຮັດວຽກປົກກະຕິ, <a href="maintenance.php">ປິດໃຊ້ງານໂໝດບໍາລຸງຮັກສາ</a>.';
$string['sitemaintenancewarning2'] = 'ປະຈຸບັນເວັບໄຊທ໌ຂອງທ່ານຢູ່ໃນຮູບແບບການບໍາລຸງຮັກສາ (ມີພຽງແຕ່ຜູ້ດູແລເທົ່ານັ້ນສາມາດເຂົ້າສູ່ລະບົບໄດ້). ເພື່ອເອົາເວັບໄຊທ໌ນີ້ກັບຄືນສູ່ການເຮັດວຽກປົກກະຕິ, <a href="{$a}">ປິດໃຊ້ງານໂໝດບໍາລຸງຮັກສາ</a>.';
$string['sitemenubar'] = 'ການນຳທາງເວັບໄຊທ໌';
$string['sitepolicies'] = 'ການຕັ້ງຄ່າຄວາມປອດໄພຂອງເວັບໄຊທ໌';
$string['sitepolicy'] = 'URL ນະໂຍບາຍຂອງເວັບໄຊທ໌';
$string['sitepolicy_help'] = 'URL ຂອງນະໂຍບາຍຂອງເວັບໄຊທ໌ ທີ່ຜູ້ໃຊ້ທີ່ລົງທະບຽນທັງໝົດຕ້ອງໄດ້ເຫັນ ແລະ ຕົກລົງເຫັນດີກ່ອນເຂົ້າຫາເວັບໄຊທ໌. ຈື່ໄວ້ວ່າການຕັ້ງຄ່ານີ້ຈະມີຜົນພຽງແຕ່ຖ້າຕົວຈັດການນະໂຍບາຍຂອງເວັບໄຊທ໌ ຖືກຕັ້ງເປັນຄ່າເລີ່ມຕົ້ນ (ຫຼັກ).';
$string['sitepolicyguest'] = 'URL ນະໂຍບາຍເວັບໄຊທ໌ສຳລັບແຂກ';
$string['sitepolicyguest_help'] = 'URL ຂອງນະໂຍບາຍຂອງເວັບໄຊທ໌ ທີ່ແຂກທຸກຄົນຕ້ອງໄດ້ເຫັນ ແລະ ຕົກລົງເຫັນດີກ່ອນເຂົ້າຫາເວັບໄຊທ໌. ກະລຸນາຮັບຊາບວ່າການຕັ້ງຄ່ານີ້ຈະມີຜົນພຽງແຕ່ຖ້າຕົວຈັດການນະໂຍບາຍຂອງເວັບໄຊທ໌ຖືກຕັ້ງເປັນຄ່າເລີ່ມຕົ້ນ (ຫຼັກ).';
$string['sitepolicyhandler'] = 'ຕົວຈັດການນະໂຍບາຍຂອງເວັບໄຊທ໌';
$string['sitepolicyhandler_desc'] = 'ອັນນີ້ກຳນົດວິທີການຈັດການນະໂຍບາຍ ແລະ ການຍິນຍອມຂອງຜູ້ໃຊ້. ຕົວຈັດການມາດຕະຖານ (ຫຼັກ) ເປີດໃຊ້ URL ນະໂຍບາຍເວັບໄຊທ໌ ແລະ URL ນະໂຍບາຍເວັບໄຊທ໌ ສໍາລັບແຂກທີ່ຈະຖືກລະບຸ. ຕົວຈັດການນະໂຍບາຍເຮັດໃຫ້ມີການຕັ້ງຄ່າເວັບໄຊທ໌, ຄວາມເປັນສ່ວນຕົວ ແລະ ນະໂຍບາຍອື່ນ. ມັນຍັງເຮັດໃຫ້ສາມາດເບິ່ງການຍິນຍອມເຫັນດີຂອງຜູ້ໃຊ້ ແລະ ຖ້າຈໍາເປັນ, ການຍິນຍອມເຫັນດີໃນນາມຂອງຜູ້ເຍົາໄວທີ່ຈະໄດ້ຮັບ.';
$string['sitepolicyhandlercore'] = 'ຄ່າເລີ່ມຕົ້ນ (ຫຼັກ)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'ຖ້າຖືກເລືອກ, ພາກສ່ວນຫົວຂໍ້ຈະຖືກສະແດງຢູ່ໜ້າຫຼັກເວັບໄຊທ໌.';
$string['sixtyfourbitswarning'] = 'ມັນໄດ້ຖືກກວດພົບວ່າເວັບໄຊຂອງເຈົ້າບໍ່ໄດ້ໃຊ້ເວີຊັນ PHP 64-bit. ແນະນໍາໃຫ້ເຈົ້າຍົກລະດັບເວັບໄຊຂອງເຈົ້າເພື່ອຮັບປະກັນຄວາມເຂົ້າກັນໄດ້ໃນອະນາຄົດ.';
$string['slasharguments'] = 'ໃຊ້ອາກິວເມັ້ນທັບ';
$string['slashargumentswarning'] = 'ມັນໄດ້ຖືກແນະນໍາໃຫ້ໃຊ້ການອາກິວເມັ້ນທັບຖືກເປີດໃຊ້ງານ. ໃນອະນາຄົດມັນຈະຕ້ອງມີ. ສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ, ເບິ່ງເອກະສານ <a href="https://docs.moodle.org/en/admin/environment/slasharguments">ການນຳໃຊ້ອາກິວເມັ້ນທັບ</a>.';
$string['smartpix'] = 'ການຄົ້ນຫາ Pix ສະຫຼາດ';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'ປະເພດ SMTP Auth';
$string['smtpdetail'] = 'ການຕັ້ງຄ່າການໂອນອີເມລແບບງ່າຍ (Simple Mail Transfer Protocol (SMTP)) ສໍາລັບການສົ່ງອີເມລ.';
$string['smtphosts'] = 'ເຈົ້າພາບ SMTP';
$string['smtpmaxbulk'] = 'ຂີດຈຳກັດຊ່ວງເວລາ SMTP';
$string['smtppass'] = 'ລະຫັດຜ່ານ SMTP';
$string['smtpsecure'] = 'ຄວາມປອດໄພ SMTP';
$string['smtpuser'] = 'ຊື່ຜູ້ໃຊ້ SMTP';
$string['soaprecommended'] = 'ການຕິດຕັ້ງສ່ວນຂະຫຍາຍ SOAP ທາງເລືອກເປັນປະໂຫຍດສໍາລັບການບໍລິການເວັບ ແລະ ບາງປລັກອິນ.';
$string['sort_fullname'] = 'ຊື່ເຕັມລາຍວິຊາ';
$string['sort_idnumber'] = 'ລະຫັດ ID ລາຍວິຊາ';
$string['sort_shortname'] = 'ຊື່ຫຍໍ້ລາຍວິຊາ';
$string['sort_sortorder'] = 'ຮຽງລຳດັບ';
$string['spellengine'] = 'ເຄື່ອງຈັກສະກົດຄໍາ';
$string['spelllanguagelist'] = 'ລາຍການພາສາການສະກົດຄໍາ';
$string['splrequired'] = 'ດຽວນີ້ Moodle ຕ້ອງການສ່ວນຂະຫຍາຍ SPL PHP.';
$string['stats'] = 'ສະຖິຕິ';
$string['statsfirstrun'] = 'ໄລຍະຫ່າງການປະມວນຜົນສູງສຸດ';
$string['statsmaxruntime'] = 'ເວລາແລ່ນສູງສຸດ';
$string['statsmoodleorg'] = 'ສະຖິຕິ';
$string['statsruntimedays'] = 'ວັນທີ່ຕ້ອງດຳເນີນການ';
$string['statsruntimestart'] = 'ແລ່ນຢູ່ທີ່';
$string['statsuserthreshold'] = 'ເກນຜູ້ໃຊ້';
$string['stickyblocks'] = 'ບລັອກໜຽວ';
$string['stickyblockscourseview'] = 'ໜ້າລາຍວິຊາ';
$string['stickyblocksduplicatenotice'] = 'ຖ້າບລັອກໃດທີ່ທ່ານເພີ່ມເຂົ້າມາຢູ່ທີ່ນີ້ມີຢູ່ແລ້ວຢູ່ໃນໜ້າສະເພາະ, ມັນຈະສົ່ງຜົນໃຫ້ຊໍ້າກັນ.<br />ມີພຽງແຕ່ບລັອກທີ່ປັກໝຸດແລ້ວ ຈະບໍ່ສາມາດແກ້ໄຂໄດ້, ຕົວທີ່ຊ້ຳກັນຈະຍັງສາມາດແກ້ໄຂໄດ້.';
$string['stickyblocksmymoodle'] = 'Moodle ຂອງຂ້ອຍ';
$string['stickyblockspagetype'] = 'ປະເພດໜ້າເພື່ອກຳນົດຄ່າ';
$string['strictformsrequired'] = 'ການກວດສອບຢ່າງເຂັ້ມງວດຂອງຊ່ອງຂໍ້ມູນທີ່ຕ້ອງການ';
$string['stripalltitletags'] = 'ເອົາແທັກ HTML ອອກຈາກຊື່ກິດຈະກໍາທັງໝົດ';
$string['supportcontact'] = 'ການຕິດຕໍ່ຝ່າຍສະໜັບສະໜູນ';
$string['supportemail'] = 'ອີເມລຝ່າຍສະໜັບສະໜູນ';
$string['supportemailsubject'] = 'ຮ້ອງຂໍການສະໜັບສະໜູນເວັບໄຊທ໌ - {$a}';
$string['supportname'] = 'ຊື່ຝ່າຍສະໜັບສະໜູນ';
$string['supportpage'] = 'ໜ້າຝ່າຍສະໜັບສະໜູນ';
$string['suspenduser'] = 'ຢຸດຊົ່ວຄາວບັນຊີຜູ້ໃຊ້';
$string['switchlang'] = 'ປ່ຽນລະບົບພາສາ';
$string['systempaths'] = 'ເສັ້ນທາງຂອງລະບົບ';
$string['tablenosave'] = 'ການປ່ຽນແປງໃນຕາຕະລາງຂ້າງເທິງແມ່ນບັນທຶກໂດຍອັດຕະໂນມັດ.';
$string['tablesnosave'] = 'ການປ່ຽນແປງໃນບັນດາຕາຕະລາງຂ້າງເທິງແມ່ນບັນທຶກໂດຍອັດຕະໂນມັດ.';
$string['tabselectedtofront'] = 'ຢູ່ໃນບັນດາຕາຕະລາງທີ່ມີແຖບ, ຖ້າແຖວທີ່ມີແຖບທີ່ເລືອກຢູ່ໃນປະຈຸບັນຖືກວາງຢູ່ທາງໜ້າ';
$string['tabselectedtofronttext'] = 'ນຳແຖວແຖບທີ່ເລືອກມາດ້ານໜ້າ';
$string['task_adhoc_concurrency_limit'] = 'ໜ້າວຽກສະເພາະກິດຈຳກັດສະກຸນເງິນພ້ອມກັນ';
$string['task_adhoc_concurrency_limit_desc'] = 'ຈຳນວນຜູ້ແລ່ນວຽກງານສະເພາະກິດໄດ້ອະນຸຍາດໃຫ້ແລ່ນພ້ອມກັນ. ຖ້າຂອບເຂດຈໍາກັດສູງ, ວຽກງານທີ່ໄດ້ກໍານົດໄວ້ອາດຈະບໍ່ດໍາເນີນປົກກະຕິ ເມື່ອມີວຽກສະເພາະກິດຫຼາຍ. ການຕັ້ງຄ່າ 0 ຈະປິດການປະມວນຜົນໜ້າວຽກສະເພາະທັງໝົດ.';
$string['task_adhoc_max_runtime'] = 'ຕະຫຼອດຊີວິດຂອງຜູ້ແລ່ນວຽກງານພິເສດ';
$string['task_adhoc_max_runtime_desc'] = 'ອາຍຸຂອງຜູ້ແລ່ນວຽກງານສະເພາະກິດກ່ອນທີ່ມັນຈະຖືກປົດປ່ອຍ. ແນະນຳໃຫ້ມີໄລຍະເວລາຕ່ຳເນື່ອງຈາກວ່າບໍ່ມີການຈຳກັດຈຳນວນໜ້າວຽກສະເພາະ. ຖ້າຕົວເລກນີ້ສູງເກີນໄປ ແລະ ທ່ານມີຄິວວຽກສະເພາະກິດອັນໃຫຍ່ຢູ່ສະນັ້ນວຽກທີ່ກໍານົດໄວ້ແລ້ວອາດຈະບໍ່ໄດ້ດໍາເນີນເປັນປົກກະຕິ.';
$string['task_dbstats'] = 'ຖານຂໍ້ມູນ';
$string['task_duration'] = 'ໄລຍະເວລາ';
$string['task_logmode'] = 'ບັນທຶກເວລາໃດ';
$string['task_logmode_all'] = 'ເກັບຮັກສາຜົນການບັນທຶກຂອງທຸກວຽກ';
$string['task_logmode_desc'] = 'ທ່ານສາມາດເລືອກເວລາທີ່ທ່ານຕ້ອງການບັນທຶກໜ້າວຽກໃຫ້ເກີດຂຶ້ນ. ໂດຍບັນທຶກເລີ່ມຕົ້ນແມ່ນຖືກບັນທຶກໄວ້ສະເໝີ. ທ່ານສາມາດປິດການບັນທຶກທັງໝົດ, ຫຼື ປ່ຽນເປັນພຽງແຕ່ການບັນທຶກໜ້າວຽກທີ່ຫຼົ້ມເຫຼວ.';
$string['task_logmode_failonly'] = 'ເກັບບັນທຶກສະເພາະສຳລັບວຽກທີ່ບໍ່ປະສົບຜົນສໍາເລັດ';
$string['task_logmode_none'] = 'ບໍ່ໄດ້ບັນທຶກຫຍັງໄວ້';
$string['task_logoutput'] = 'ຜົນໄດ້ຮັບຂອງໜ້າວຽກ';
$string['task_logretainruns'] = 'ຮັກສາການແລ່ນ';
$string['task_logretainruns_desc'] = 'ຈຳນວນຂອງການແລ່ນແຕ່ລະໜ້າວຽກເພື່ອຮັກສາ. ການຕັ້ງຄ່ານີ້ໂຕ້ຕອບກັບການຕັ້ງຄ່າ \'ໄລຍະການເກັບຮັກສາ\': ອັນໃດກໍ່ຕາມທີ່ຮອດກ່ອນຈະໄດ້ນໍາໃຊ້.';
$string['task_logretention'] = 'ໄລຍະເວລາການຮັກສາ';
$string['task_logretention_desc'] = 'ໄລຍະເວລາສູງສຸດທີ່ບັນທຶກຄວນຮັກສາໄວ້. ການຕັ້ງຄ່ານີ້ໂຕ້ຕອບກັບການຕັ້ງຄ່າ \'ຮັກສາການແລ່ນ\': ອັນໃດກໍ່ຕາມທີ່ຮອດກ່ອນຈະໄດ້ນໍາໃຊ້';
$string['task_logtostdout'] = 'ສະແດງຜົນການບັນທຶກ';
$string['task_logtostdout_desc'] = 'ໃນເວລາທີ່ວຽກກໍາລັງດໍາເນີນການ ແລະ ຜົນໄດ້ຮັບຖືກຈັບ, ບໍ່ວ່າຈະເປັນຜົນຜະລິດທີ່ຖືກຈັບກໍ່ຄວນຈະຖືກສະແດງຄືກັນໃນຂະນະທີ່ໜ້າວຽກແລ່ນ.';
$string['task_result'] = 'ຜົນໄດ້ຮັບ';
$string['task_result:failed'] = 'ລົ້ມເຫຼວ';
$string['task_scheduled_concurrency_limit'] = 'ກຳນົດເວລາພ້ອມກັນຂອງໜ້າວຽກທີ່ກຳນົດໄວ້';
$string['task_scheduled_concurrency_limit_desc'] = 'ຈຳນວນຜູ້ແລ່ນໜ້າວຽກທີ່ໄດ້ກຳນົດເວລາໄວ້ໄດ້ອະນຸຍາດໃຫ້ແລ່ນພ້ອມກັນ. ຖ້າຂີດຈໍາກັດສູງ, ເຊີບເວີອາດຈະປະສົບກັບການໂຫຼດສູງເຊິ່ງກະທົບກັບການປະຕິບັດ. ການຕັ້ງຄ່າ 0 ຈະປິດການປະມວນຜົນໜ້າວຽກທີ່ໄດ້ກຳນົດໄວ້ໝົດ.';
$string['task_scheduled_max_runtime'] = 'ກຳນົດເວລາຜູ້ແລ່ນໜ້າວຽກຕະຫຼອດຊີວິດ';
$string['task_scheduled_max_runtime_desc'] = 'ອາຍຸຂອງຜູ້ແລ່ນວຽກທີ່ໄດ້ກຳນົດໄວ້ກ່ອນທີ່ມັນຈະຖືກປ່ອຍ.';
$string['task_starttime'] = 'ເວລາເລີ່ມຕົ້ນ';
$string['task_stats:dbreads'] = '{$a} ອ່ານ';
$string['task_stats:dbwrites'] = '{$a} ຂຽນ';
$string['task_status'] = 'ສະຖານະໜ້າວຽກ';
$string['task_status_desc'] = 'ໜ້າວຽກ \'{$a->name}\' ແມ່ນ {$a->status}. ສຳລັບລາຍລະອຽດ, ເບິ່ງ {$a->class}{$a->extradescription} ໃນ <a href="{$a->gotourl}">ໜ້າວຽກທີ່ໄດ້ກຳນົດ</a>.';
$string['task_type:adhoc'] = 'ພິເສດ';
$string['task_type:scheduled'] = 'ກຳນົດເວລາແລ້ວ';
$string['taskadmintitle'] = 'ບັນດາໜ້າວຽກ';
$string['taskanalyticscleanup'] = 'ລົບລ້າງການວິເຄາະ';
$string['taskautomatedbackup'] = 'ການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['taskbackupcleanup'] = 'ລ້າງຕາຕະລາງສຳຮອງ, ບັນທຶກ ແລະ ໄຟລ໌';
$string['taskbadgescron'] = 'ປ້າຍລາງວັນ';
$string['taskbadgesmessagecron'] = 'ການປະມວນຜົນພື້ນຫຼັງສຳລັບການສົ່ງການແຈ້ງເຕືອນປ້າຍ';
$string['taskblogcron'] = 'ຊິ້ງຂໍ້ມູນບລັອກພາຍນອກ';
$string['taskcachecleanup'] = 'ລຶບລາຍການຖານຄວາມຈໍາທີ່ໝົດອາຍຸອອກ';
$string['taskcachecron'] = 'ການປະມວນຜົນພື້ນຫຼັງສໍາລັບຖານຄວາມຈໍາ';
$string['taskcalendarcron'] = 'ສົ່ງການແຈ້ງເຕືອນປະຕິທິນ';
$string['taskcheckforupdates'] = 'ກວດເບິ່ງການປັບປຸງ';
$string['taskcompletiondaily'] = 'ເຄື່ອງໝາຍສຳເລັດການເລີ່ມຕົ້ນ';
$string['taskcompletionregular'] = 'ຄິດໄລ່ຂໍ້ມູນການສໍາເລັດປົກກະຕິ';
$string['taskcontextcleanup'] = 'ລົບລ້າງບໍລິບົດ';
$string['taskcreatecontexts'] = 'ສ້າງບໍລິບົດທີ່ເສຍໄປ';
$string['taskdeletecachetext'] = 'ລຶບບັນທຶກຖານຄວາມຈຳຂໍ້ຄວາມເກົ່າ';
$string['taskdeleteincompleteusers'] = 'ລຶບຜູ້ໃຊ້ທີ່ບໍ່ສົມບູນ';
$string['taskdeleteunconfirmedusers'] = 'ລຶບຜູ້ໃຊ້ທີ່ຍັງບໍ່ໄດ້ຢືນຢັນ';
$string['taskeventscron'] = 'ການປະມວນຜົນພື້ນຫຼັງສໍາລັບບັນດາເຫດການ';
$string['taskfiletrashcleanup'] = 'ລົບລ້າງໄຟລ໌ໃນຖັງຂີ້ເຫຍື້ອ';
$string['taskglobalsearchindex'] = 'ສ້າງດັດສະນີຄົ້ນຫາທົ່ວໂລກ';
$string['taskglobalsearchoptimize'] = 'ການເພີ່ມປະສິດທິພາບດັດສະນີຄົ້ນຫາທົ່ວໂລກ';
$string['taskgradecron'] = 'ການປະມວນຜົນພື້ນຫຼັງສໍາລັບປຶ້ມຄະແນນ';
$string['taskgradehistorycleanup'] = 'ການປະມວນຜົນພື້ນຫຼັງສໍາລັບການລົບລ້າງບັນດາຕາຕະລາງປະຫວັດ';
$string['taskh5pcleanup'] = 'ລົບລ້າງໄຟລ໌ H5P ທີ່ບໍ່ໄດ້ໃຊ້';
$string['tasklegacycron'] = 'ການປະມວນຜົນ cron ເກົ່າສຳລັບປລັກອິນ';
$string['tasklockcleanuptask'] = 'ອະນາໄມເມຕາເດຕາຂອງໜ້າວຽກສະເພາະ';
$string['tasklogcleanup'] = 'ລົບລ້າງບັນທຶກໜ້າວຽກ';
$string['tasklogging'] = 'ການກຳນົດຄ່າບັນທຶກໜ້າວຽກ';
$string['tasklogs'] = 'ທຶກໜ້າວຽກ';
$string['taskmessagingcleanup'] = 'ການປະມວນຜົນພື້ນຫຼັງສຳລັບການສົ່ງຂໍ້ຄວາມ';
$string['taskpasswordresetcleanup'] = 'ລົບລ້າງຄວາມພະຍາຍາມຕັ້ງຄ່າລະຫັດຜ່ານຄືນໃໝ່';
$string['taskplagiarismcron'] = 'ການປະມວນຜົນພື້ນຫຼັງສໍາລັບ cron ເກົ່າໃນປລັກອິນການລອກຮຽນແບບ';
$string['taskportfoliocron'] = 'ການປະມວນຜົນພື້ນຫຼັງສຳລັບປລັກອິນຜົນງານ';
$string['taskprocessing'] = 'ການປະມວນຜົນໜ້າວຽກ';
$string['taskquestioncron'] = 'ການປະມວນຜົນເບື້ອງຫຼັງເພື່ອລົບລ້າງຕົວຢ່າງຄໍາຖາມ';
$string['taskquestionstatscleanupcron'] = 'ການປະມວນຜົນພື້ນຫຼັງເພື່ອລົບລ້າງຖານຄວາມຈໍາສະຖິຕິຄໍາຖາມ';
$string['taskrefreshsystemtokens'] = 'ໂຫຼດໂທເຄັນ OAuth ຄືນໃໝ່ສຳລັບບັນຊີການບໍລິການ';
$string['taskregistrationcron'] = 'ການລົງທະບຽນເວັບໄຊທ໌';
$string['tasksendfailedloginnotifications'] = 'ສົ່ງການແຈ້ງເຕືອນການເຂົ້າສູ່ລະບົບບໍ່ສຳເລັດ';
$string['tasksendnewuserpasswords'] = 'ສົ່ງລະຫັດຜ່ານຜູ້ໃຊ້ໃໝ່';
$string['tasksessioncleanup'] = 'ລົບລ້າງຊ່ວງເວລາເກົ່າ';
$string['taskstatscron'] = 'ການປະມວນຜົນເບື້ອງຫຼັງສຳລັບສະຖິຕິ';
$string['tasktagcron'] = 'ການປະມວນຜົນພື້ນຫຼັງສຳລັບແທັກ';
$string['tasktempfilecleanup'] = 'ລຶບໄຟລ໌ຊົ່ວຄາວທີ່ເກົ່າອອກ';
$string['tasktype'] = 'ປະເພດ';
$string['tempdatafoldercleanup'] = 'ລົບລ້າງໄຟລ໌ຂໍ້ມູນຊົ່ວຄາວທີ່ເກົ່າກວ່າ';
$string['templates'] = 'ແມ່ແບບ';
$string['testoutgoingmailconf'] = 'ທົດສອບການຕັ້ງຄ່າອີເມວຂາອອກ';
$string['testoutgoingmailconf_errorcommunications'] = 'ເວັບໄຊທ໌ຂອງທ່ານບໍ່ສາມາດສື່ສານກັບເຊີບເວີອີເມລຂອງທ່ານໄດ້. ກະລຸນາກວດເບິ່ງການກຳນົດຄ່າອີເມລຂາອອກຂອງທ່ານ.';
$string['testoutgoingmailconf_fromemail'] = 'ຈາກຊື່ຜູ້ໃຊ້ ຫຼື ທີ່ຢູ່ອີເມລ';
$string['testoutgoingmailconf_fromemail_help'] = 'ຊ່ອງຂໍ້ມູນນີ້ເຮັດຕາມຕົວຢ່າງການສົ່ງຂໍ້ຄວາມຈາກຜູ້ໃຊ້ນັ້ນ, ແຕ່ສ່ວນຫົວຈາກທີ່ໃຊ້ໃນອີເມລຕົວຈິງທີ່ສົ່ງໄປນັ້ນຈະຂຶ້ນກັບການຕັ້ງຄ່າອື່ນເຊັ່ນ: ໂດເມນທີ່ໄດ້ຮັບອະນຸຍາດ.';
$string['testoutgoingmailconf_fromemail_invalid'] = 'ບໍ່ຖືກຕ້ອງຈາກຊື່ຜູ້ໃຊ້ ຫຼື ອີເມລ. ຕ້ອງເປັນຮູບແບບອີເມວທີ່ຖືກຕ້ອງ ຫຼື ຊື່ຜູ້ໃຊ້ທີ່ມີຢູ່ແລ້ວໃນ Moodle.';
$string['testoutgoingmailconf_message'] = 'ນີ້ແມ່ນຂໍ້ຄວາມທົດສອບເພື່ອຢືນຢັນວ່າ ທ່ານໄດ້ຕັ້ງຄ່າອີເມລຂາອອກຂອງເວັບໄຊທ໌ຂອງທ່ານສຳເລັດແລ້ວ. ສົ່ງແລ້ວ: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'ສົ່ງຂໍ້ຄວາມທົດສອບ';
$string['testoutgoingmailconf_sentmail'] = 'ເວັບໄຊທ໌ນີ້ໄດ້ສົ່ງຂໍ້ຄວາມທົດສອບໄປຫາເຊີບເວີອີເມລສຳເລັດແລ້ວ.<br />ຈາກ: {$a->fromemail}<br />ເຖິງ: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: ຂໍ້ຄວາມທົດສອບ. {$a->additional} ສົ່ງແລ້ວ: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'ຫົວຂໍ້ເພີ່ມເຕີມ';
$string['testoutgoingmailconf_toemail'] = 'ໄປຫາທີ່ຢູ່ອີເມລ';
$string['testoutgoingmaildetail'] = 'ໝາຍເຫດ: ກ່ອນການທົດສອບ, ກະລຸນາບັນທຶກການຕັ້ງຄ່າຂອງທ່ານໄວ້. <br />{$a}';
$string['testsiteupgradewarning'] = 'ປະຈຸບັນນີ້ທ່ານກໍາລັງໃຊ້ບ່ອນທົດສອບ {$a}, ເພື່ອຍົກລະດັບມັນໃຊ້ຢ່າງຖືກຕ້ອງໃນເຄື່ອງມືການໂຕ້ຕອບບັນທັດຄໍາສັ່ງ';
$string['themedesignermode'] = 'ໂໝດຜູ້ອອກແບບຮູບແບບສີສັນ';
$string['themedesignermodewarning'] = 'ເປີດໃຊ້ໂໝດຜູ້ອອກແບບຮູບແບບສີສັນແລ້ວ. ສິ່ງນີ້ບໍ່ຄວນເປີດໃຊ້ງານຢູ່ໃນບ່ອນຜະລິດເພາະມັນສາມາດຫຼຸດປະສິດທິພາບໄດ້ຢ່າງຫຼວງຫຼາຍ.';
$string['themelist'] = 'ລາຍຊື່ຮູບແບບສີສັນ';
$string['themenoselected'] = 'ບໍ່ໄດ້ເລືອກຮູບແບບສີສັນ';
$string['themeresetcaches'] = 'ລ້າງຖານຄວາມຈຳຮູບແບບສີສັນ';
$string['themeselect'] = 'ປ່ຽນແປງຮູບແບບສີສັນ';
$string['themeselector'] = 'ຕົວເລຶອກຮູບແບບສີສັນ';
$string['themesettings'] = 'ການຕັ້ງຄ່າຮູບແບບສີສັນ';
$string['therewereerrors'] = 'ມີຂໍ້ຜິດພາດຢູ່ໃນຂໍ້ມູນຂອງເຈົ້າ';
$string['thirdpartylibrary'] = 'ຫ້ອງສະໝຸດ';
$string['thirdpartylibrarylocation'] = 'ສະຖານທີ່ຕັ້ງ';
$string['thirdpartylibs'] = 'ຫ້ອງສະໝຸດພາກສ່ວນທີ່ສາມ';
$string['timezone'] = 'ເຂດເວລາເລີ່ມຕົ້ນ';
$string['timezoneforced'] = 'ສິ່ງນີ້ຖືກບັງຄັບໂດຍຜູ້ຄວບຄຸມເວັບໄຊທ໌';
$string['timezoneinvalid'] = 'ເຂດເວລາ "{$a}" ບໍ່ຖືກຕ້ອງ';
$string['timezoneisforcedto'] = 'ບັງຄັບໃຫ້ຜູ້ໃຊ້ທັງໝົດໃຊ້';
$string['timezonenotforced'] = 'ຜູ້ໃຊ້ສາມາດເລືອກເຂດເວລາຂອງຕົນເອງ';
$string['timezonephpdefault'] = 'ເຂດເວລາ PHP ເລີ່ມຕົ້ນ ({$a})';
$string['timezoneserver'] = 'ເຂດເວລາຂອງເຊີບເວີ ({$a})';
$string['tlswarning'] = 'ບໍ່ພົບສ່ວນຂະຫຍາຍ PHP/cURL ທີ່ມີການຮອງຮັບ TLSv1.2 ຖືກລຶບແລ້ວ. ບາງການບໍລິການອາດຈະບໍ່ເຮັດວຽກ. ມັນໄດ້ຖືກແນະນໍາໃຫ້ປັບປຸງຫ້ອງສະຫມຸດ TLS ຂອງທ່ານ.';
$string['tokenduration'] = 'ຜູ້ໃຊ້ສ້າງໄລຍະເວລາໂທເຄັນ';
$string['tokenduration_desc'] = 'ໄລຍະເວລາທີ່ໂທເຄັນການບໍລິການເວັບສ້າງໂດຍຜູ້ໃຊ້ (ຕົວຢ່າງຜ່ານແອັບມືຖື) ແມ່ນຖືກຕ້ອງ.';
$string['tokenizerrecommended'] = 'ແນະນຳໃຫ້ຕິດຕັ້ງສ່ວນຂະຫຍາຍ PHP Tokenizer ທາງເລືອກ -- ມັນປັບປຸງການເຮັດວຽກຂອງເຄືອຂ່າຍ Moodle.';
$string['tools'] = 'ເຄື່ອງມືຜູ້ຄວບຄຸມລະບົບ';
$string['toolsmanage'] = 'ຈັດການກັບເຄື່ອງມືຜູ້ຄວບຄຸມລະບົບ';
$string['unattendedoperation'] = 'ການດໍາເນີນງານທີ່ບໍ່ມີຄົນດູແລ';
$string['unbookmarkthispage'] = 'ເຊົາບັນທຶກບຸກມາກໜ້ານີ້';
$string['unicoderequired'] = 'ມັນຕ້ອງການໃຫ້ທ່ານເກັບຮັກສາຂໍ້ມູນທັງໝົດຂອງທ່ານໃນຮູບແບບ Unicode (UTF-8). ການຕິດຕັ້ງໃໝ່ຕ້ອງໄດ້ປະຕິບັດເຂົ້າໄປໃນຖານຂໍ້ມູນທີ່ມີຕົວອັກສອນເລີ່ມຕົ້ນເປັນ Unicode. ຖ້າທ່ານກໍາລັງຍົກລະດັບ, ເຈົ້າຄວນປະຕິບັດຂະບວນການເຄື່ອນຍ້າຍ UTF-8 (ເບິ່ງໜ້າ ຜູ້ຄວບຄຸມລະບົບ).';
$string['uninstallplugin'] = 'ຖອນການຕິດຕັ້ງ';
$string['unlockaccount'] = 'ປົດລັອກບັນຊີ';
$string['unoconvwarning'] = 'ບໍ່ຮອງຮັບເວີຊັນຂອງ unoconv ທີ່ທ່ານໄດ້ຕິດຕັ້ງໄວ້.';
$string['unsettheme'] = 'ບໍ່ໄດ້ຕັ້ງຮູບແບບສີສັນ';
$string['unsupported'] = 'ບໍ່ຮອງຮັບ';
$string['unsupporteddbfileformat'] = 'ຖານຂໍ້ມູນຂອງທ່ານໃຊ້ Antelope ເປັນຮູບແບບໄຟລ໌. ການຮອງຮັບ UTF-8 ຢ່າງເຕັມທີ່ໃນ MySQL ແລະ MariaDB ຕ້ອງການຮູບແບບໄຟລ໌ Barracuda. ກະລຸນາສະຫຼັບໄປໃຊ້ຮູບແບບໄຟລ໌ Barracuda. ເບິ່ງເອກະສານ <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a> ສຳລັບລາຍລະອຽດ.';
$string['unsupporteddbfilepertable'] = 'ສໍາລັບການຮອງຮັບຢ່າງເຕັມທີ່ຂອງ UTF-8 ທັງ MySQL ແລະ MariaDB ຕ້ອງການໃຫ້ທ່ານປ່ຽນການຕັ້ງຄ່າ MySQL ຂອງທ່ານ \'innodb_file_per_table\' ເປັນ \'ON\'. ເບິ່ງເອກະສານສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ.';
$string['unsupporteddblargeprefix'] = 'ສໍາລັບການຮອງຮັບຢ່າງເຕັມທີ່ຂອງ UTF-8 ທັງ MySQL ແລະ MariaDB ຕ້ອງການໃຫ້ທ່ານປ່ຽນການຕັ້ງຄ່າ MySQL ຂອງທ່ານ \'innodb_large_prefix\' ເປັນ \'ON\'. ເບິ່ງເອກະສານສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ.';
$string['unsupporteddbstorageengine'] = 'ລະບົບການເກັບຮັກສາຖານຂໍ້ມູນທີ່ຖືກນໍາໃຊ້ແມ່ນບໍ່ມີການຮອງຮັບອີກຕໍ່ໄປແລ້ວ.';
$string['unsupporteddbtablerowformat'] = 'ຖານຂໍ້ມູນຂອງທ່ານມີຕາຕະລາງໂດຍໃຊ້ Antelope ເປັນຮູບແບບໄຟລ໌. ທ່ານຖືກແນະນຳໃຫ້ປ່ຽນຕາຕະລາງເປັນຮູບແບບໄຟລ໌ Barracuda. ເບິ່ງເອກະສານ <a href="https://docs.moodle.org/en/cli">ການບໍລິຫານຜ່ານເສັ້ນຄໍາສັ່ງ </a> ສໍາລັບລາຍລະອຽດຂອງເຄື່ອງມືສໍາລັບການປ່ຽນຕາຕະລາງ InnoDB ເປັນ Barracuda.';
$string['unsupportedphpversion7'] = 'ບໍ່ຮອງຮັບ PHP ສະບັບ 7.';
$string['unsupportedphpversion71'] = 'ບໍ່ຮອງຮັບ PHP ສະບັບ 7.1.';
$string['unsupportedphpversion72'] = 'ບໍ່ຮອງຮັບ PHP ສະບັບ 7.2.';
$string['unsupportedphpversion73'] = 'ບໍ່ຮອງຮັບ PHP ສະບັບ 7.3.';
$string['unsupportedphpversion74'] = 'ບໍ່ຮອງຮັບ PHP ສະບັບ 7.4.';
$string['unsupportedphpversion80'] = 'ບໍ່ຮອງຮັບ PHP ສະບັບ 8.0.';
$string['unsuspenduser'] = 'ເປີດໃຊ້ບັນຊີຜູ້ໃຊ້';
$string['updateaccounts'] = 'ປັບປຸງບັນຊີທີ່ມີຢູ່';
$string['updateautocheck'] = 'ກວດເບິ່ງການປັບປຸງທີ່ມີຢູ່ໂດຍອັດຕະໂນມັດ';
$string['updateautocheck_desc'] = 'ຖ້າເປີດໃຊ້, ເວັບໄຊທ໌ຂອງທ່ານຈະກວດຫາການອັບເດດທີ່ມີຢູ່ໂດຍອັດຕະໂນມັດສໍາລັບທັງລະຫັດ Moodle ແລະ ປລັກອິນເພີ່ມເຕີມທັງໝົດ. ຖ້າມີການອັບເດດໃໝ່, ການແຈ້ງເຕືອນຈະຖືກສົ່ງຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌.';
$string['updateavailable'] = 'ມີ Moodle ເວີຊັນໃໝ່ກວ່າ!';
$string['updateavailable_moreinfo'] = 'ຂໍ້ມູນເພີ່ມເຕີມ...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'ສະບັບ {$a}';
$string['updateavailabledetailslink'] = 'ເບິ່ງ {$a->url} ສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ';
$string['updateavailableforplugin'] = 'ມີສະບັບໃໝ່ກວ່າສຳລັບບາງປຣັກອິນຂອງທ່ານທີ່ມີໃຫ້!';
$string['updateavailableinstall'] = 'ຕິດຕັ້ງອັບເດດນີ້';
$string['updateavailableinstallall'] = 'ຕິດຕັ້ງການອັບເດດທີ່ມີຢູ່ ({$a})';
$string['updateavailableinstallallhead'] = 'ກຳລັງຕິດຕັ້ງການອັບເດດທີ່ມີຢູ່';
$string['updateavailablenot'] = 'ລະຫັດ Moodle ຂອງທ່ານໃໝ່ຫຼ້າສຸດແລ້ວ!';
$string['updateavailablerecommendation'] = 'ມັນໄດ້ຖືກແນະນໍາຢ່າງໜັກແໜ້ນໃຫ້ທ່ານປັບປຸງເວັບໄຊທ໌ຂອງທ່ານໃຫ້ເປັນລຸ້ນລ້າສຸດ ເພື່ອເອົາຄວາມປອດໄພ ແລະ ການແກ້ໄຂບັນຫາຫຼ້າສຸດທັງໝົດ.';
$string['updatecomponent'] = 'ປັບປຸງອົງປະກອບ';
$string['updateminmaturity'] = 'ລະຫັດທີ່ຕ້ອງການຄົບກຳນົດ';
$string['updateminmaturity_desc'] = 'ແຈ້ງເຕືອນກ່ຽວກັບການປັບປຸງທີ່ມີຢູ່ພຽງແຕ່ຖ້າລະຫັດທີ່ມີຢູ່ມີລະດັບການເຕີບໂຕທີ່ເລືອກໄວ້ຢ່າງໜ້ອຍ. ການປັບປຸງສຳລັບປລັກອິນທີ່ບໍ່ປະກາດລະດັບການຄົບກຳນົດຂອງລະຫັດຂອງເຂົາເຈົ້າແມ່ນຖືກລາຍງານຢູ່ສະເໝີໂດຍບໍ່ຄໍານຶງເຖິງການຕັ້ງຄ່ານີ້.';
$string['updatenotificationfooter'] = 'ເວັບໄຊທ໌ Moodle ຂອງທ່ານ {$a->siteurl} ໄດ້ຖືກຕັ້ງຄ່າເພື່ອກວດເບິ່ງການອັບເດດທີ່ມີຢູ່ໂດຍອັດຕະໂນມັດ. ທ່ານໄດ້ຮັບຂໍ້ຄວາມນີ້ໃນຖານະເປັນຜູ້ບໍລິຫານເວັບໄຊທ໌. ທ່ານສາມາດປິດການກວດສອບອັດຕະໂນມັດ ສຳລັບການປັບປຸງທີ່ມີຢູ່ໃນການບໍລິຫານເວັບໄຊທ / ເຊີບເວີ / ແຈ້ງການປັບປຸງ ຫຼື ປັບແຕ່ງການຈັດສົ່ງຂໍ້ຄວາມນີ້ຜ່ານໜ້າຄວາມມັກຂອງທ່ານ.';
$string['updatenotifications'] = 'ອັບເດດການແຈ້ງເຕືອນ';
$string['updatenotificationsubject'] = 'ມີການອັບເດດ Moodle ({$a->siteurl})';
$string['updatenotifybuilds'] = 'ແຈ້ງເຕືອນກ່ຽວກັບການສ້າງໃໝ່';
$string['updatenotifybuilds_desc'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ການປັບປຸງທີ່ມີຢູ່ສໍາລັບລະຫັດ Moodle ຈະຖືກລາຍງານເມື່ອມີການສ້າງອັນໃໝ່ສໍາລັບລຸ້ນປະຈຸບັນ. ການສ້າງແມ່ນການປັບປຸງຢ່າງຕໍ່ເນື່ອງຂອງສະບັບ Moodle. ໂດຍທົ່ວໄປແລ້ວ ພວກມັນຖືກປ່ອຍອອກທຸກອາທິດ. ຖ້າປິດໃຊ້ງານ, ການອັບເດດທີ່ມີຢູ່ຈະຖືກລາຍງານພຽງແຕ່ເມື່ອມີ Moodle ລຸ້ນທີ່ສູງກວ່າຖືກປ່ອຍອອກມາ. ການກວດຫາປລັກອິນບໍ່ໄດ້ຮັບຜົນກະທົບຈາກການຕັ້ງຄ່ານີ້.';
$string['upgradeerror'] = 'ເກີດຄວາມຜິດພາດທີ່ບໍ່ຮູ້ສາເຫດໃນການຍົກລະດັບ {$a->plugin} ເປັນສະບັບ {$ a->version}. ບໍ່ສາມາດສືບຕໍ່.';
$string['upgradeforumread'] = 'ຄຸນສົມບັດໃໝ່ໄດ້ຖືກເພີ່ມເຂົ້າໃນ Moodle 1.5 ເພື່ອຕິດຕາມໂພສຂອງກະດານຂ່າວທີ່ອ່ານ/ຍັງບໍ່ໄດ້ອ່ານ.<br />ເພື່ອໃຊ້ການທຳງານນີ້, ທ່ານຈະຕ້ອງ <a href="{$a}"> ອັບເດດຕາຕະລາງຂອງທ່ານ</a>.';
$string['upgradeforumreadinfo'] = 'ຄຸນສົມບັດໃໝ່ໄດ້ຖືກເພີ່ມເຂົ້າໃນ Moodle 1.5 ເພື່ອຕິດຕາມໂພສຂອງກະດານຂ່າວທີ່ອ່ານ/ຍັງບໍ່ໄດ້ອ່ານ. ເພື່ອໃຊ້ການທຳງານນີ້, ທ່ານຕ້ອງປັບປຸງຕາຕະລາງຂອງທ່ານດ້ວຍຂໍ້ມູນຕິດຕາມທັງໝົດສໍາລັບຂໍ້ຄວາມທີ່ມີຢູ່. ແມ່ນຂຶ້ນຢູ່ກັບຂະໜາດຂອງເວັບໄຊທ໌ຂອງທ່ານອັນນີ້ສາມາດໃຊ້ເວລາດົນ (ຊົ່ວໂມງ) ແລະ ສາມາດເກັບພາສີໄດ້ດີຢູ່ໃນຖານຂໍ້ມູນ, ສະນັ້ນມັນດີທີ່ສຸດທີ່ຈະເຮັດໃນໄລຍະທີ່ງຽບສະຫງົບ. ແນວໃດກໍ່ຕາມ, ເວັບໄຊທ໌ຂອງທ່ານຈະສືບຕໍ່ເຮັດວຽກໃນລະຫວ່າງການປັບປຸງນີ້ ແລະ ຜູ້ໃຊ້ຈະບໍ່ໄດ້ຮັບຜົນກະທົບ. ເມື່ອທ່ານເລີ່ມຂະບວນການນີ້, ທ່ານຄວນປ່ອຍໃຫ້ມັນສໍາເລັດ (ເປີດປ່ອງຢ້ຽມໂປຼແກຼມທ່ອງເວັບຂອງທ່ານໄວ້). ຢ່າງໃດກໍ່ຕາມ, ຖ້າທ່ານຢຸດຂະບວນການໂດຍການປິດປ່ອງຢ້ຽມ: ຢ່າກັງວົນ, ທ່ານສາມາດເລີ່ມຄືນໃ່ໝ່ໄດ້.<br /><br />ທ່ານຕ້ອງການເລີ່ມຂັ້ນຕອນການຍົກລະດັບດຽວນີ້ບໍ?';
$string['upgradekeyreq'] = 'ຕ້ອງການລະຫັດຍົກລະດັບ';
$string['upgradekeyset'] = 'ຍົກລະດັບລະຫັດ (ປ່ອຍໃຫ້ເປົ່າຫວ່າງເພື່ອບໍ່ຕັ້ງມັນ)';
$string['upgradelogs'] = 'ສໍາລັບການທໍາງານຢ່າງເຕັມທີ່, ບັນທຶກເກົ່າຂອງທ່ານຈໍາເປັນຕ້ອງໄດ້ຍົກລະດັບ. <a href="{$a}">ຂໍ້ມູນເພີ່ມເຕີມ</a>';
$string['upgradelogsinfo'] = 'ເມື່ອບໍ່ດົນມານີ້ໄດ້ມີການປ່ຽນແປງບາງຢ່າງຢູ່ໃນວິທີເກັບຮັກສາບັນທຶກ. ເພື່ອຈະສາມາດເບິ່ງບັນທຶກເກົ່າຂອງທ່ານທັງໝົດຕາມແຕ່ລະກິດຈະກໍາ, ບັນທຶກເກົ່າຂອງທ່ານຈໍາເປັນຕ້ອງໄດ້ຍົກລະດັບ. ແມ່ນຂຶ້ນຢູ່ກັບເວັບໄຊທ໌ຂອງທ່ານ, ສິ່ງນີ້ສາມາດໃຊ້ເວລາດົນ (ຕົວຢ່າງ: ຫຼາຍຊົ່ວໂມງ) ແລະ ສາມາດເກັບພາສີຂ້ອນຂ້າງຢູ່ໃນຖານຂໍ້ມູນສໍາລັບເວັບໄຊທ໌ໃຫຍ່. ເມື່ອທ່ານເລີ່ມຂະບວນການນີ້, ທ່ານຄວນປ່ອຍໃຫ້ມັນສໍາເລັດ (ໂດຍການເປີດປ່ອງຢ້ຽມຂອງຕົວທ່ອງເວັບໄວ້). ບໍ່ຕ້ອງເປັນຫ່ວງ - ເວັບໄຊທ໌ຂອງທ່ານຈະໃຊ້ໄດ້ດີສໍາລັບຄົນອື່ນໃນຂະນະທີ່ບັນທຶກກໍາລັງຖືກຍົກລະດັບ.<br /><br />ທ່ານຕ້ອງການຍົກລະດັບບັນທຶກຂອງທ່ານດຽວນີ້ບໍ?';
$string['upgradepluginsfirst'] = 'ມັນໄດ້ຖືກແນະນໍາໃຫ້ຕິດຕັ້ງການປັບປຸງທີ່ມີຢູ່ທັງຫມົດກ່ອນ';
$string['upgradepluginsinfo'] = 'ກຳລັງປັບປຸງປຣັກອິນ';
$string['upgradepluginsinfo_help'] = 'ມີການປັບປຸງສຳລັບບາງປລັກອິນຂອງທ່ານ. ທ່ານຄວນຕິດຕັ້ງພວກມັນທັງໝົດກ່ອນທີ່ຈະຍົກລະດັບຖານຂໍ້ມູນ Moodle. ຖ້າເວັບໄຊທ໌ຂອງທ່ານບໍ່ສະໜັບສະໜູນ ການປັບປຸງອັດຕະໂນມັດ, ທ່ານຕ້ອງໄດ້ດາວໂຫຼດ ແລະ ຕິດຕັ້ງສະບັບປລັກອິນໃໝ່ຢູ່ທີ່ເຊີບເວີຂອງທ່ານດ້ວຍຕົນເອງ.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'ການຕັ້ງຄ່າຄັ້ງໃໝ່';
$string['upgradesettingsintro'] = 'ການຕັ້ງຄ່າທີ່ສະແດງຢູ່ລຸ່ມນີ້ໄດ້ຖືກເພີ່ມເຂົ້າໃນລະຫວ່າງການຍົກລະດັບ Moodle ຄັ້ງສຸດທ້າຍຂອງທ່ານ. ເຮັດການປ່ຽນແປງໃດໜຶ່ງທີ່ຈຳເປັນຕໍ່ຄ່າເລີ່ມຕົ້ນ ແລະ ຈາກນັ້ນຄລິກປຸ່ມ \'ບັນທຶກການປ່ຽນແປງ\' ຢູ່ລຸ່ມສຸດຂອງໜ້ານີ້.';
$string['upgradestalefiles'] = 'ກວດພົບສະບັບ Moodle ປະສົມ, ການຍົກລະດັບບໍ່ສາມາດສືບຕໍ່ໄດ້';
$string['upgradestalefilesinfo'] = 'ຂັ້ນຕອນການປັບປຸງ Moodle ໄດ້ຖືກຢຸດໄວ້ຊົ່ວຄາວເພາະວ່າສະຄຣິບ PHP ຈາກຢ່າງນ້ອຍສອງສະບັບຂອງ Moodle ໄດ້ຖືກກວດພົບຢູ່ໃນລາຍການ Moodle.

ສິ່ງນີ້ສາມາດເຮັດໃຫ້ເກີດບັນຫາທີ່ສຳຄັນໄດ້ໃນພາຍຫຼັງ, ສະນັ້ນເພື່ອສືບຕໍ່ທ່ານຕ້ອງຮັບປະກັນວ່າລາຍການ Moodle ປະກອບມີພຽງແຕ່ໄຟລ໌ສໍາລັບ Moodle ສະບັບດ່ຽວ.

ວິທີທີ່ແນະນໍາໃຫ້ເຮັດການລ້າງລາຍການ Moodle ຂອງທ່ານມີດັ່ງນີ້:

* ປ່ຽນຊື່ລາຍການ Moodle ປັດຈຸບັນເປັນ "moodle_old"
* ສ້າງບັນຊີລາຍການ Moodle ໃໝ່ປະກອບດ້ວຍໄຟລ໌ຈາກການດາວໂຫຼດແພັກເກດ Moodle ມາດຕະຖານ, ຫຼື ຈາກບ່ອນເກັບຂໍ້ມູນ Moodle Git
* ຍ້າຍໄຟລ໌ config.php ເດີມ ແລະ ປລັກອິນທີ່ບໍ່ໄດ້ມາດຕະຖານຈາກລາຍການ "moodle_old" ໄປໃສ່ບັນຊີລາຍຊື່ Moodle ໃໝ່

ເມື່ອເຈົ້າລ້າງລາຍການ Moodle, ໂຫຼດໜ້ານີ້ຄືນໃໝ່ ເພື່ອສືບຕໍ່ຂະບວນການປັບປຸງ Moodle.

ຄຳເຕືອນນີ້ມັກຈະເກີດຂຶ້ນຈາກການຮວບຮວມຊຸດ Moodle ມາດຕະຖານທັບໃສ່ Moodle ເວີຊັນທີ່ຜ່ານມາ. ໃນຂະນະທີ່ອັນນີ້ບໍ່ເປັນຫຍັງສໍາລັບການຍົກລະດັບເລັກນ້ອຍ, ມັນບໍ່ຂໍແນະນຳສໍາລັບການຍົກລະດັບ Moodle ທີ່ສໍາຄັນ.

ຄຳເຕືອນນີ້ຍັງສາມາດເກີດມາຈາກການກວດກາບໍ່ຄົບຖ້ວນ ຫຼື ການປັບປຸງການດຳເນີນການຈາກບ່ອນເກັບຂໍ້ມູນ Git, ໃນກໍລະນີນີ້ ທ່ານອາດຈະຕ້ອງລໍຖ້າໃຫ້ການປະຕິບັດສຳເລັດ, ຫຼື ບາງທີອາດຈະດຳເນີນການຄຳສັ່ງລົບລ້າງທີ່ເໝາະສົມ ແລະ ລອງໃໝ່ອີກຄັ້ງ.

ທ່ານສາມາດຊອກຫາຂໍ້ມູນເພີ່ມເຕີມຢູ່ໃນເອກະສານການຍົກລະດັບໄດ້ທີ່ <a href="{$a}">{$ a}</a>.';
$string['upgradestart'] = 'ຍົກລະດັບຖານຂໍ້ມູນ Moodle ດຽວນີ້';
$string['upgradesure'] = '<p>ໄຟລ໌ Moodle ຂອງທ່ານຖືກປ່ຽນແປງ, ແລະ ທ່ານກໍາລັງຈະຍົກລະດັບເຊີບເວີ ຂອງທ່ານເປັນສະບັບນີ້ໂດຍອັດຕະໂນມັດ:</p>
<p><strong>{$a}</strong></p>
<p>ເມື່ອທ່ານເຮັດສິ່ງນີ້ ທ່ານບໍ່ສາມາດກັບຄືນມາໄດ້ອີກ. ກະລຸນາຮັບຊາບວ່າຂະບວນການນີ້ສາມາດໃຊ້ເວລາດົນ.</p>
<p>ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການຍົກລະດັບສະບັບນີ້ເປັນສະບັບນີ້?</p>';
$string['upgradetimedout'] = 'ການຍົກລະດັບໝົດເວລາ, ກະລຸນາເລີ່ມການຍົກລະດັບຄືນໃໝ່.';
$string['upgradingdata'] = 'ກຳລັງຍົກລະດັບຂໍ້ມູນ';
$string['upgradinglogs'] = 'ກຳລັງຍົກລະດັບບັນທຶກ';
$string['upgradingversion'] = 'ກຳລັງຍົກລະດັບສະບັບໃໝ່';
$string['upwards'] = 'ຂຶ້ນໄປ';
$string['useblogassociations'] = 'ເປີດໃຊ້ສະມາຄົມ';
$string['user'] = 'ຜູ້ໃຊ້';
$string['userbulk'] = 'ຄຳສັ່ງຜູ້ໃຊ້ຈຳນວນຫຼາຍ';
$string['userbulkdownload'] = 'ສົ່ງອອກຜູ້ໃຊ້ເປັນ';
$string['userdefaultpreferences'] = 'ການຕັ້ງຄ່າເລີ່ມຕົ້ນຂອງຜູ້ໃຊ້';
$string['userfeedbackafterupgrade'] = 'ຫຼັງຈາກການຍົກລະດັບທີ່ສໍາຄັນທຸກ';
$string['userfeedbackencouragement'] = '<p>ໃນ Moodle 3.9 ເປັນຕົ້ນໄປ, ຄຸນສົມບັດໃໝ່ໄດ້ຖືກລວມເຂົ້າເຊິ່ງເຮັດໃຫ້ຜູ້ໃຊ້ມີທາງເລືອກທີ່ຈະໃຫ້ຄຳຕິຊົມກ່ຽວກັບຊອບແວ Moodle ຫາ Moodle HQ ຜ່ານບ່ອນສຳຫຼວດພາຍນອກທີ່ເປັນເຈົ້າພາບໂດຍ Moodle HQ. ບໍ່ມີການສົ່ງຕໍ່ຂໍ້ມູນລະບຸຜູ້ໃຊ້ໄປຫາບ່ອນສໍາຫຼວດ.</p>
<p>Moodle HQ ພະຍາຍາມທີ່ຈະເປີດເຜີຍ ແລະ ໂປ່ງໃສກ່ຽວກັບວິທີການເກັບກໍາຂໍ້ມູນຂອງຕົນ. ດັ່ງນັ້ນ, ພວກເຮົາຕ້ອງການໃຫ້ແນ່ໃຈວ່າທ່ານຮູ້ ແລະ ຄວບຄຸມການທໍາງານນີ້.</p>
<p>ຄຳຕິຊົມຈາກຜູ້ໃຊ້ຈະຊ່ວຍ Moodle HQ ໄດ້ດີຫຼາຍໃນການປັບປຸງຊອບແວ Moodle. ເພື່ອເປີດໃຊ້ຄຸນສົມບັດນີ້, ກະລຸນາໄປທີ່ <a href="{$a}">ການຕັ້ງຄ່າຄຳຕິຊົມ</a>.</p>';
$string['userfeedbacknextreminder'] = 'ການເຕືອນຄຳຕິຊົມຕໍ່ໄປ';
$string['userfeedbacknextreminder_desc'] = 'ເມື່ອໃດທີ່ພວກເຮົາຄວນຖາມຜູ້ໃຊ້ໃຫ້ຄໍາຕິຊົມອີກຄັ້ງ?';
$string['userfeedbackperiodically'] = 'ແຕ່ລະໄລຍະ';
$string['userfeedbackremindafter'] = 'ສະແດງການເຕືອນຫຼັງຈາກ';
$string['userfeedbackremindafter_desc'] = 'ເຕືອນຜູ້ໃຊ້ອີກເທື່ອໜຶ່ງເພື່ອໃຫ້ຄຳຕິຊົມຫຼັງຈາກຈຳນວນມື້ທີ່ໃຫ້ໄວ້.';
$string['userfiltersdefault'] = 'ຕົວກັ່ນຕອງຜູ້ໃຊ້ເລີ່ມຕົ້ນ';
$string['userfiltersdefault_desc'] = 'ເລືອກຕົວກັ່ນຕອງທີ່ຄວນສະແດງຢູ່ໃນໜ້າ \'ຄົ້ນຫາລາຍຊື່ຂອງຜູ້ໃຊ້\' ແລະ ຢູ່ໃນໜ້າ \'ການກະທຳ ຂອງຜູ້ໃຊ້ຈຳນວນຫຼາຍ\'. ກົດປຸ່ມ Ctrl ຄ້າງໄວ້ເພື່ອເລືອກຫຼາຍລາຍການ. ຕົວກັ່ນຕອງໃດກໍ່ຕາມທີ່ບໍ່ໄດ້ເລືອກຈະສາມາດໃຊ້ໄດ້ໂດຍການຄລິກທີ່ລິ້ງ \'ສະແດງເພີ່ມເຕີມ\'.';
$string['userimagesdisabled'] = 'ຮູບຜູ້ໃຊ້ໂປຼໄຟລ໌ ຖືກປິດການນຳໃຊ້';
$string['userlist'] = 'ເບິ່ງລາຍຊື່ຜູ້ໃຊ້';
$string['usermanagement'] = 'ການຄຸ້ມຄອງຜູ້ໃຊ້';
$string['userpolicies'] = 'ນະໂຍບາຍຜູ້ໃຊ້';
$string['userpreference'] = 'ການຕັ້ງຄ່າຄວາມມັກຂອງຜູ້ໃຊ້';
$string['userquota'] = 'ພື້ນທີ່ໄຟລ໌ສ່ວນຕົວ';
$string['userquota_desc'] = 'ຈໍານວນຂໍ້ມູນສູງສຸດທີ່ຜູ້ໃຊ້ແຕ່ລະຄົນສາມາດເກັບໄວ້ຢູ່ໃນພື້ນທີ່ໄຟລ໌ສ່ວນຕົວຂອງເຂົາເຈົ້າ.';
$string['users'] = 'ບັນດາຜູ້ໃຊ້';
$string['usesitenameforsitepages'] = 'ໃຊ້ຊື່ເວັບໄຊທ໌ສໍາລັບຫນ້າເວັບໄຊທ໌';
$string['usetags'] = 'ເປີດໃຊ້ການທຳງານແທັກຕ່າງໆ';
$string['validateemptylineerror'] = 'ແຖວຫວ່າງບໍ່ຖືກຕ້ອງ';
$string['validateerror'] = 'ມູນຄ່ານີ້ບໍ່ຖືກຕ້ອງ';
$string['validateerrorlist'] = 'ລາຍການປ້ອນເຂົ້າເຫຼົ່ານີ້ບໍ່ຖືກຕ້ອງ: {$a}';
$string['validateiperror'] = 'ທີ່ຢູ່ IP ເຫຼົ່ານີ້ບໍ່ຖືກຕ້ອງ: {$a}';
$string['verifychangedemail'] = 'ຈໍາກັດໂດເມນເມື່ອປ່ຽນອີເມລ';
$string['warningcurrentsetting'] = 'ຄ່າປັດຈຸບັນບໍ່ຖືກຕ້ອງ: {$a}';
$string['warningiconvbuggy'] = 'ຫ້ອງສະໝຸດ iconv ສະບັບຂອງທ່ານບໍ່ຮອງຮັບຕົວແກ້ໄຂ //IGNORE. ທ່ານຄວນຕິດຕັ້ງສ່ວນຂະຫຍາຍ mbstring ເຊິ່ງສາມາດໃຊ້ແທນການລົບລ້າງສະຕຣິງທີ່ມີຕົວອັກສອນ UTF-8 ບໍ່ຖືກຕ້ອງ.';
$string['webproxy'] = 'ເວັບຕົວແທນ';
$string['webproxyinfo'] = 'ຕື່ມຂໍ້ມູນໃສ່ໃນຕົວເລືອກຕໍ່ໄປນີ້ ຖ້າເຊີບເວີ Moodle ຂອງທ່ານບໍ່ສາມາດເຂົ້າຫາອິນເຕີເນັດໄດ້ໂດຍກົງ. ຕ້ອງການການເຂົ້າເຖິງອິນເຕີເນັດສໍາລັບການດາວໂຫຼດຂໍ້ມູນສະພາບແວດລ້ອມ, ຊຸດພາສາ, ຟີດ RSS, ເຂດເວລາ, ແລະອື່ນໆ.<br /> <em>ສ່ວນຂະຫຍາຍ PHP cURL ແມ່ນແນະນໍາໃຫ້ຢ່າງສູງ.</em>';
$string['xmlrpcwebserviceenabled'] = 'ມັນໄດ້ຖືກກວດພົບວ່າລະບຽບການບໍລິການເວັບ XML-RPC ຖືກເປີດໃຊ້ຢູ່ໃນເວັບໄຊທ໌ຂອງທ່ານ. ຄຸນສົມບັດນີ້ອາໄສສ່ວນຂະຫຍາຍ PHP XML-RPC ເຊິ່ງບໍ່ໄດ້ຮັກສາໄວ້ໂດຍ PHP ອີກຕໍ່ໄປ.';
$string['yuicomboloading'] = 'ກຳລັງໂຫຼດຄອມໂບ YUI';
$string['ziprequired'] = 'ດຽວນີ້ Moodle ຕ້ອງການສ່ວນຂະຫຍາຍ Zip PHP, M-info, ZIP ໄບນາຣີ ຫຼື ຫ້ອງສະໝຸດ PclZip ບໍ່ໄດ້ໃຊ້ອີກຕໍ່ໄປ.';
