<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_aardvark', language 'af', version '4.2'.
 *
 * @package     theme_aardvark
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['android'] = 'Google Play Store-URL';
$string['androiddesc'] = 'Voer die URL van jou Google Play Store-bladsy in (d.w.s. https://play.google.com/store/apps/developer?id=mycollege)';
$string['apple'] = 'Apple App Store-URL';
$string['appledesc'] = 'Voer die URL van jou Apple App Store-bladsy in (d.w.s. https://itunes.apple.com/gb/artist/my-college/id123456789)';
$string['basicheading'] = 'Basiese Verstellings';
$string['basicheadingdesc'] = 'Doelmaak basiese elemente van die tema';
$string['ceop'] = 'CEOP';
$string['ceopaus'] = 'Ontsper Australië';
$string['ceopdesc'] = 'Ontsper CEOP-verslaggewing';
$string['ceopnone'] = 'Versper';
$string['ceopuk'] = 'Ontsper Verenigde Koninkryk';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Aardvark</h2>
<p><img class=img-polaroid src="aardvark/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Inligting oor</h3>
<p>Aardvark is die oorspronklike \'kieslysstafie\'-gebaseerde tema vir Moodle.</p>
<p>Aardvark het mettertyd ontwikkel soos wat die Moodle-kern die talle funksies wat Aardvark so populêr maak, geïntegreer het, ook die doelgemaakte kieslys en gebruikerskieslys.</p>
<p>Hierdie tema bied \'n eenvoudige "plat" voorkoms, met inspirasie vanaf Flat UI en Google se materiaalontwerp.</p>
<h3>Voorsate</h3>
<p>Baie van die kernelemente van hierdie tema word op die Bootstrap- en Clean-temas gebaseer.</p>
<h3>Temakrediete</h3>
<p>Outeur: Shaun Daubney (Newbury Kollege)<br>
Met bydraes en voorsaatkode van Bas Brands, David Scotson, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.<br>
Webwerf: <a href="www.newbury-college.ac.uk">Newbury College</a>
</p>
<h3>Rapporteer \'n fout:</h3>
<p><a href="https://moodle.org/plugins/view.php?plugin=theme_aardvark">https://moodle.org/plugins/view.php?plugin=theme_aardvark</a></p>
<h3>Meer inligting</h3>
<p><a href="aardvark/README.txt">Change log, licenses and version info</a></p>
</div></div>';
$string['configtitle'] = 'Aardvark';
$string['copyright'] = 'Kopiereg';
$string['copyrightdesc'] = 'Die naam van jou organisasie.';
$string['copyrightlink'] = 'Kopieregskakel';
$string['copyrightlinkdesc'] = 'Die URL van jou organisasie se hoofwebwerf (d.w.s. http://www.mycollege.ac.uk).';
$string['credit'] = 'Gebaseer op die oorspronklike tema wat deur Shaun Daubney geskep is';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcssdesc'] = 'Watter CSS-reëls jy ook al by hierdie teksarea wil voeg, sal in elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['customfooter'] = 'Doelgemaakte onderskrif';
$string['customfooterdesc'] = 'Die inhoud uit hierdie teksarea sal in eerste area/sone van die onderskrif van elke bladsy vertoon word.';
$string['disclaimer'] = 'Vrywaring';
$string['disclaimerdesc'] = 'Die inhoud uit hierdie teksarea sal in die tweede area/sone van die onderskrif van elke bladsy vertoon word.';
$string['facebook'] = 'Facebook-URL';
$string['facebookdesc'] = 'Voer die URL van jou Facebook-blad in (d.w.s. http://www.facebook.com/mycollege)';
$string['flickr'] = 'Flickr-URL';
$string['flickrdesc'] = 'Voer die URL van jou Flickr-blad (d.w.s http://www.flickr.com/mycollege)';
$string['footeroptdesc'] = 'Doelmaak basiese elemente van die tema se onderskrif.';
$string['footeroptheading'] = 'Onderskrif';
$string['frontpageheading'] = 'Voorblad';
$string['frontpageheadingdesc'] = 'Doelmaak voorbladelemente van die tema, soos gebruikerwaarskuwings en datum.';
$string['generalalert'] = 'Algemene waarskuwing';
$string['generalalertdesc'] = 'Dit sal \'n waarskuwing op jou voorblad vertoon om gebruikers van \'n spesifieke gebeurtenis/situasie in te lig.';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Voer die URL van jou Google+ profiel in (d.w.s. http://plus.google.com/107817105228930159735)';
$string['instagram'] = 'Instagram-URL';
$string['instagramdesc'] = 'Voer die URL van jou Instagram-blad in (via web.instagram). (D.w.s. https://www.instagram.com/mycollege/)';
$string['linkedin'] = 'LinkedIn-URL';
$string['linkedindesc'] = 'Voer die URL van jou LinkedIn-profiel in (d.w.s. http://www.linkedin.com/company/mycollege)';
$string['maincolor'] = 'Hoofkleur';
$string['maincolordesc'] = 'Verander die tema se hoofkleur. Dit sluit in die kieslys-sweef, url-sweef en knoppies.';
$string['pinterest'] = 'Pinterest-URL';
$string['pinterestdesc'] = 'Voer die URL van jou Pinterest-blad in (d.w.s. http://pinterest.com/mycollege)';
$string['pluginname'] = 'Aardvark';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['sitelogo'] = 'Werflogo';
$string['sitename'] = 'Vertoon werfnaam saam met klein logo';
$string['sitenamedesc'] = 'As daar nie \'n klein logo is nie, word die werfnaam altyd in die navigasiestafie vertoon. As \'n klein logo gestel is, kan dit met of sonder die werfnaam vertoon word.';
$string['snapchat'] = 'Snapchat-URL';
$string['snapchatdesc'] = 'Voer die URL van jou Snapchat-profiel in (d.w.s. https://www.snapchat.com/add/mycollege)';
$string['socialiconsheading'] = 'Sosiale Ikone';
$string['socialiconsheadingdesc'] = 'Doelmaak sosiale netwerkikone.';
$string['twitter'] = 'Twitter-URL';
$string['twitterdesc'] = 'Voer die URL van jou Twitter-voer in (d.w.s. http://www.twitter.com/mycollege)';
$string['website'] = 'Webwerf-URL';
$string['websitedesc'] = 'Voer die URL van jou hoofwebwerf in (d.w.s. http://www.mycollege.ac.uk)';
$string['wikipedia'] = 'Wikipedia-URL';
$string['wikipediadesc'] = 'Voer die URL van Wikipedia-blad in (d.w.s. http://en.wikipedia.org/wiki/mycollege)';
$string['youtube'] = 'YouTube-URL';
$string['youtubedesc'] = 'Voer die URL van jou YouTube-kanaal in (d.w.s. http://www.youtube.com/mycollege)';
