<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_training', language 'af', version '4.2'.
 *
 * @package     theme_training
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['banner'] = 'Banier';
$string['bannerdesc'] = 'Merk hierdie boks as logo\'s wat volg volbreedte banierprente is. Dit behoort \'n minimum van 1920 px breed te wees.<br>Wenk: As jy jou logo en die banier wil hê, inkorporeer jou logo in die banierprent in. Soek jy teks op die banier? Sluit dit op die banier in en maak seker dat jy dieselfde teks vir die volle werfnaam toe te pas, aangesien dit gebruik word vir die ALT-teks van die prent.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Training</h2>
<p><img class=img-polaroid src="training/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Inligting oor</h3>
<p>Training is \'n eenvoudige en maklike tema met \'n moderne voorkoms sonder \'n oormaat opsies, wat fantasties vir beginners is, of wanneer jy net iets nodig het wat jou vinnig aan die gang kan kry.</p>
<h3>Mensgemaak</h3>
<p>Training \'n gebaseer op die Bootstrap- en Clean-temas, HTML5/Bootstrap 2.3-gebaseerde responsiewe temas, wat aanvanklik vir Moodle 2.5 geskep is met behulp van:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans, Bas Brands en David Scotson.</p>
<h3>Temakrediete</h3>
<p>Outeurs: TNG Consulting Inc. - Michael Milette<br>
Webwerf: <a href="http://www.tngconsulting.ca">www.tngconsulting.ca</a>
</p>
<h3>Rapporteer \'n fout:</h3>
<p><a href="https://www.github.com/michael-milette/moodle-theme_training/issues">https://www.github.com/michael-milette/moodle-theme_training/issues</a></p>
</div></div>';
$string['configtitle'] = 'Training';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcssdesc'] = 'CSS-reëls sal op elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Die favicon verskyn in die oortjies van sommige webblaaiers en kan ook op die werkskerm verskyn as jy \'n kortpadikoon skep. Favicons behoort 16 px X 16 px in PNG- of ICO-dokumentformaat te wees.<br>Verstek: Moodle-ikoon.';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Wat jy ook al by hierdie teksarea voeg, sal regdeur jou Moodle-werf in die onderskrif vertoon word.<br>Wenk: Jy kan kolomme in jou onderskrif skep deur <a href="https://getbootstrap.com/2.3.2/scaffolding.html"</a>Bootstrap Scaffolding</a> te gebruik.';
$string['gridview'] = 'Masonry (roosterstyl)';
$string['gridviewdesc'] = 'Vertoon kursuslyste in \'n masonry-styl. Indien nie gemerk nie, is die verstek volbreedte waar die kursus se hoofprent links van die kursusopsomming is. Let daarop dat hierdie opsie nie die <strong>Kombinasielysverstellings</strong> affekteer nie.';
$string['hidefrontsitepages'] = 'Versteek werfbladsye op voorblad';
$string['hidefrontsitepagesdesc'] = 'Versteek die wefbladsye op die voorblad. Dit laat toe dat jy bladsye met openbare toegang kan skep, sonder om besoekergebruikertoegang te ontsper.';
$string['invert'] = 'Keer navstafie om';
$string['invertdesc'] = 'Ruil die teks en agtergrond van die navstafie boaan die bladsy tussen swart en wit.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Die standaard logo word slegs in die hofie van die voorblad en intekenblad vertoon.<br>Wenk: Logo\'s kan tot 700 px breed wees. Daar is geen beperking op die hoogte nie, alhoewel dit vreemd kan voorkom as dit te hoog is. <br>As \'n logo nie hier bygevoeg is nie, sal enige logo in Voorkoms > Logo\'s gebruik word. As dit nie bestaan nie, sal die Werfnaam verskyn.';
$string['navbarabove'] = 'Navstafie bo';
$string['navbarabovedesc'] = 'Plaas navstafie bokant logo/banier.';
$string['pluginname'] = 'Training';
$string['privacy:metadata'] = 'Die Training-tema berg geen persoonlike data van enige gebruiker nie.';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['sitelogo'] = 'Werflogo';
$string['smalllogo'] = 'Klein logo';
$string['smalllogodesc'] = 'Die klein logo word in die hofie van alle bladsye vertoon, behalwe op die voorblad en intekenblad.<br>Wenk: As jy wil hê dat die logo op al die bladsye dieselfde moet wees, laai dieselfde grootte logo op vir beide die <strong>Logo</strong> en <strong>Klein logo</strong>.<br>Verstek: As \'n logo nie hier bygevoeg word nie, sal die kompakte logo in Voorkoms > Logo\'s gebruik word. As dit nie bestaan nie, sal die Werfnaam verskyn.';
