<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'videotime', language 'sv', version '4.2'.
 *
 * @package     videotime
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity_name'] = 'Aktivitetsnamn';
$string['activity_name_help'] = 'Namn som visas i kursen för denna Video Time-aktivitetsmodul.';
$string['albums'] = 'Album';
$string['api_not_authenticated'] = 'Vimeo-API:t har inte autentiserats.';
$string['api_not_configured'] = 'Vimeo-API:t är inte konfigurerat.';
$string['apply'] = 'Tillämpa';
$string['authenticate_vimeo'] = 'Autentisera med Vimeo';
$string['authenticate_vimeo_success'] = 'Vimeo-autentiseringen lyckades. Du kan nu använda funktioner som förlitar sig på Vimeo-API:t.';
$string['authenticated'] = 'Autentiserad';
$string['autopause'] = 'Autopausa';
$string['averageviewtime'] = 'Genomsnittlig visningstid';
$string['background'] = 'Bakgrund';
$string['browsevideos'] = 'Bläddra bland videor';
$string['choose_video'] = 'Välj video';
$string['choose_video_confirm'] = 'Är du säker på att du vill välja den här videon?';
$string['cleanupalbumsandtags'] = 'Städa upp bland album och etiketter';
$string['client_id'] = 'Vimeo klient-ID';
$string['client_id_help'] = 'Klient-ID genereras när du skapar en "App" under ditt Vimeo-konto. Gå till https://developer.vimeo.com/apps/new för att starta den här processen.';
$string['client_secret'] = 'Vimeo klienthemlighet';
$string['client_secret_help'] = 'Klienthemligheten genereras när du skapar en "App" under ditt Vimeo-konto. Gå till https://developer.vimeo.com/apps/new för att starta den här processen.';
$string['columns'] = 'Kolumner';
$string['columns_help'] = 'Välj bredden för den här videon när den visas i förhandsgranskningsläget. Antalet kolumner är hur många videor som kan visas i rad.';
$string['completion_hide_detail'] = 'Dölj slutförandedetaljer';
$string['completion_on_finish'] = 'Slutförande vid videoslut';
$string['completion_on_percent'] = 'Slutförande vid visningsprocent';
$string['completion_on_percent_value'] = 'Slutförande vid visningsprocentvärde';
$string['completion_on_view'] = 'Slutförande vid visningstid';
$string['completion_on_view_seconds'] = 'Slutförande vid visningstid i sekunder';
$string['completiondetail:_on_finish'] = 'Slutför video';
$string['completiondetail:_on_percent'] = 'Visad minst {$a}%';
$string['completiondetail:_on_view_time'] = 'Visad i {$a}';
$string['configure_vimeo_first'] = 'Du måste konfigurera en Vimeo-applikation innan du kan logga in.';
$string['configure_vimeo_help'] = '<ol><li>Gå till <a href="https://developer.vimeo.com/apps/new">https://developer.vimeo.com/apps/new</a> och logga in med ditt Vimeo-konto</li>
<li>Ange ett namn och en beskrivning för din app. Exempel: Video Time Repository API</li>
<li>Kontrollera att kryssrutan "No. The only Vimeo accounts that will have access to the app are my own" är ikryssad</li>
<li>Godkänn Vimeo\'s användningsvillkor och klicka på "Create App"</li>
<li>Du tas nu till din nya app</li>
<li>Klicka på "Edit settings"</li>
<li>Ange en beskrivning. Denna visas för administratörer när de loggar in på Vimeo</li>
<li>Ange URL till appen. Denna måste anges till <b>{$a->redirect_url}</b></li>
<li>Klicka på "Update"</li>
<li>Ange en svars-URL. Denna måste anges till <b>{$a->redirect_url}</b></li>
<li>Kopiera "Client Identifier" (i början av sidan) och "Client secret" (Manage App Secrets)</li>
<li>Ange sedan dessa uppgifter <a href="{$a->configure_url}">här</a></li></ol>';
$string['confirmation'] = 'Bekräftelse';
$string['controls'] = 'Kontroller';
$string['create_vimeo_app'] = 'Skapa Vimeo-applikation';
$string['currentwatchtime'] = 'Nuvarande visningstid';
$string['datasource:videotime_sessions_data_source'] = 'Video Time-sessioner';
$string['datasource:videotime_stats_data_source'] = 'Statistik för Video Time';
$string['default'] = 'Standard';
$string['defaulttabsize'] = 'Standardstorlek för flik';
$string['defaulttabsize_help'] = 'Ange storleken som ska användas för att bestämma den ursprungliga relativa bredden på flikavsnitten';
$string['deletesessiondata'] = 'Ta bort sessionsdata';
$string['discover_videos'] = 'Upptäck Vimeo-videor';
$string['discovering_videos'] = 'Hittade {$a->count} videor';
$string['display_options'] = 'Visningsalternativ';
$string['dnt'] = 'Spåra inte';
$string['done'] = 'Klart';
$string['duration'] = 'Varaktighet';
$string['embed_options'] = 'Inbäddningsalternativ';
$string['embed_options_defaults'] = 'Standardalternativ för inbäddning';
$string['embeds'] = 'Inbäddningar';
$string['enabletabs'] = 'Aktivera flikar';
$string['estimated_request_time'] = 'Uppskatta återstående tid';
$string['firstsession'] = 'Första sessionen';
$string['force'] = 'Tvinga inställning';
$string['force_help'] = 'Om markerad åsidosätter den här standardinställningen instansinställningarna.';
$string['goback'] = 'Tillbaka';
$string['gradeitemnotcreatedyet'] = 'Det finns inget betygsobjekt för den här aktiviteten. Kontrollera <b>Ange resultat lika med visningsprocent</b> ovan, spara och redigera den här aktiviteten igen för att ange betygskategori och betygsgräns för godkänt.';
$string['hideshow'] = 'Dölj/visa';
$string['insert_video_metadata'] = 'Infoga metadata från video (kan åsidosätta aktivitetsinställningar)';
$string['invalid_session_state'] = 'Ogiltigt sessionstillstånd.';
$string['label_mode'] = 'Ettikettläge';
$string['lastsession'] = 'Senaste sessionen';
$string['managevideotimetabplugins'] = 'Hantera pluginmoduler för Video Time';
$string['mode'] = 'Läge';
$string['mode_help'] = '<b>Normalt</b>: Visar aktivitetslänken utan ytterligare tillägg.<br>
<b>Etikett</b>: Bädda in videon i kursen, liknande som för <em>Etikett-</em>aktiviteten.<br>
<b>Förhandsgranskning</b>: Visar en miniatyr som länkar till aktiviteten (gäller endast Video Time).';
$string['modulename'] = 'Video Time';
$string['modulename_help'] = 'Video Time Pro-aktiviteten gör det möjligt för lärare att
<ul>
    <li>enkelt bädda in videor från Vimeo genom att lägga till URL:en</li>
    <li>lägga till innehåll ovan- och nedanför videouppspelaren</li>
    <li>spåra tittartiden hos användaren via aktivitetsslutförande</li>
    <li>få insikter om varje användares tittartid</li>
    <li>ange standardalternativen för inbäddning</li>
    <li>åsidosätta inbäddningsalternativen hos en instans av pluginmodulen.</li>
</ul>

Vi förbättrar ständigt pluginmodulen, så håll dig uppdaterad om kommande versioner. Du kan se vad vi arbetar med och lägga till funktionalitetsförfrågningar i vår offentliga roadmap på <a href="https://bdecent.de/products/videotimepro/roadmap">https://bdecent.de/products/videotimepro/roadmap</a>.

Hör av dig till oss om du har någon feedback du vill dela med oss.';
$string['modulenameplural'] = 'Video Time-instanser';
$string['more'] = 'Mer';
$string['needs_authentication'] = 'Behöver autentiseras på nytt';
$string['next_activity'] = 'Nästa aktivitet';
$string['next_activity_auto'] = 'Gå automatiskt till nästa aktivitet';
$string['next_activity_auto_help'] = 'Ladda nästa aktivitet automatiskt när studenten slutför videon.';
$string['next_activity_button'] = 'Visa knappen "Nästa aktivitet"';
$string['next_activity_button_help'] = 'Visa en knapp ovanför videon som leder till nästa aktivitet studenten ska slutföra.';
$string['next_activity_in_course'] = 'Standard: Nästa kursaktivitet';
$string['nocompletioncriteriaset'] = 'Inga slutförandevillkor har valts. Vänligen välj ett villkor nedan.';
$string['normal_mode'] = 'Normalt läge';
$string['not_authenticated'] = 'Ej inloggad';
$string['of'] = 'av';
$string['option_autopause'] = 'Autopausa';
$string['option_autopause_help'] = 'Om du vill pausa den aktuella videon när en annan Vimeo-video på samma sida börjar spelas upp. Ange det här värdet till falskt för att tillåta samtidig uppspelning av alla videor på sidan. Det här alternativet har ingen effekt om du har inaktiverat cookies i din webbläsare, antingen via webbläsarinställningar eller med ett tillägg eller en pluginmodul.';
$string['option_autoplay'] = 'Spela upp automatiskt';
$string['option_autoplay_help'] = 'Starta uppspelning av videon automatiskt. Observera att detta inte fungerar på de enheter eller webbläsare där det blockerats.';
$string['option_background'] = 'Bakgrund';
$string['option_background_help'] = 'Om spelaren är i bakgrundsläge, vilket döljer uppspelningskontrollerna, aktiverar automatisk uppspelning och loopar videon.';
$string['option_byline'] = 'Byline';
$string['option_byline_help'] = 'Visa byline för videon.';
$string['option_color'] = 'Färg';
$string['option_color_help'] = 'Ange färgen på uppspelningskontrollerna. Färgerna kan åsidosättas av videons inbäddningsinställningar.';
$string['option_controls'] = 'Kontroller';
$string['option_controls_help'] = 'Den här parametern döljer alla element i spelaren (spelfältet, delningsknappar osv.) för en renodlad upplevelse. <strong>Varningar:</strong> När du använder den här parametern döljs uppspelnings-/pausknappen. Om du vill starta uppspelningen för tittarna måste du antingen aktivera automatisk uppspelning, använda tangentbordskontroller eller implementera vårt SDK för att starta och styra uppspelningen. Observera att om du ställer in den här parametern inaktiveras inte tangentbordskontroller.';
$string['option_dnt'] = 'Spåra inte';
$string['option_dnt_help'] = 'Om spelaren ska hindras från att spåra sessionsdata, inklusive cookies. Tänk på att om du ställer in det här argumentet till <code>true</code> blockeras även videostatistik.';
$string['option_forced'] = '{$a->option} är globalt tvingat till: {$a->value}';
$string['option_height'] = 'Höjd';
$string['option_height_help'] = 'Den exakta höjden på videon. Sätts som standard till samma höjd som den största tillgängliga versionen av videon.';
$string['option_maxheight'] = 'Maxhöjd';
$string['option_maxheight_help'] = 'Samma som <em>Höjd</em>, men höjden kommer inte överskrida videons originalhöjd.';
$string['option_maxwidth'] = 'Maxbredd';
$string['option_maxwidth_help'] = 'Samma som <em>Bredd</em>, men bredden kommer inte överskrida videons originalbredd.';
$string['option_muted'] = 'Tystad';
$string['option_muted_help'] = 'Starta videon i tyst läge. Vissa webbläsare kräver detta för att tillåta att videon spelas upp automatiskt.';
$string['option_pip'] = 'Bild-i-bild';
$string['option_pip_help'] = 'Om du vill inkludera bild-i-bild-knappen bland spelarkontrollerna och aktivera API:et för bild-i-bild.';
$string['option_playsinline'] = 'Spelas upp inbäddad';
$string['option_playsinline_help'] = 'Spela upp videon inbäddad på mobila enheter. För att automatiskt visa dem i helskärmsläge vid uppspelning, sätt denna parametern till falskt.';
$string['option_portrait'] = 'Porträtt';
$string['option_portrait_help'] = 'Visa miniatyr för video.';
$string['option_preventfastforwarding'] = 'Förhindra snabbspolning framåt';
$string['option_responsive'] = 'Responsiv';
$string['option_responsive_help'] = 'Om markerad är videospelaren responsiv och anpassar sig till sidans eller skärmens storlek.';
$string['option_speed'] = 'Hastighet';
$string['option_speed_help'] = 'Visa hastighetskontrollerna på inställningsmenyn och aktivera API för uppspelningsfrekvens (tillgängligt för PRO- och Business-konton).';
$string['option_title'] = 'Titel';
$string['option_title_help'] = 'Visa titeln';
$string['option_transparent'] = 'Transparent';
$string['option_transparent_help'] = 'Den responsiva spelaren och den transparenta bakgrunden är aktiverade som standard. För att inaktivera, ställ in den här parametern på falskt.';
$string['option_width'] = 'Bredd';
$string['option_width_help'] = 'Videons exakta bredd. Standardvärdet är bredden på den största tillgängliga versionen av videon.';
$string['panelwidthlarge'] = 'Bredd för stor panel';
$string['panelwidthmedium'] = 'Bredd för mediumstor panel';
$string['panelwidthsmall'] = 'Bredd för liten panel';
$string['percentageofvideofinished'] = 'Procent av videon som slutförts';
$string['pip'] = 'Bild-i-bild';
$string['pluginadministration'] = 'Administrera Video Time';
$string['pluginname'] = 'Video Time';
$string['preventfastforwarding'] = 'Förhindra snabbspolning framåt';
$string['preventfastforwarding_help'] = 'Förhindra användaren från att snabbspola bortom vad hen hittills sett.';
$string['preventfastforwardingmessage'] = 'Du har bara tittat på {$a->percent}% av den här videon, och du får inte hoppa framåt utan att titta.';
$string['preview_mode'] = 'Läge för förhandsgranskningsbild';
$string['preview_picture'] = 'Förhandsgranskningsbild';
$string['preview_picture_help'] = 'Bild som visas för användaren.';
$string['preview_picture_linked'] = 'Förhandsgranskningsbild länkad';
$string['preview_picture_url'] = 'URL till förhandsgranskningsbild';
$string['privacy:metadata'] = 'Modulen Video Time lagrar ingen personinformation.';
$string['process_videos'] = 'Bearbeta videor';
$string['process_videos_help'] = 'Videor bearbetas av en schemalagd uppgift. För konton med många videor kan detta ta tid att slutföra.';
$string['pull_from_vimeo'] = 'Hämta metadata från Vimeo';
$string['pull_from_vimeo_invalid_videoid'] = 'Det gick inte att avgöra video-ID. Kontrollera att du har angett en Vimeo-URL (t.ex https://vimeo.com/635473456).';
$string['pull_from_vimeo_loading'] = 'Hämtar metadata från Vimeo…';
$string['pull_from_vimeo_success'] = 'Metadatan hämtades från Vimeo. Vissa aktivitetsinställningar har åsidosatts.';
$string['rate_limit'] = 'Gräns för API-anrop';
$string['refreshpage'] = 'Vänligen uppdatera sidan för att visa den duplicerade aktiviteten';
$string['results'] = 'resultat';
$string['resume_playback'] = 'Återuppta uppspelning';
$string['resume_playback_help'] = 'Återuppta uppspelningen automatiskt när användaren återkommer till aktiviteten. Uppspelningen återupptas från samma position som när användaren lämnade aktiviteten.';
$string['run_discovery_task'] = 'Kör denna "Upptäck Vimeo-videor"-uppgift för att börja hämta dina videodata. Annars kan du vänta tills den körs automatiskt.';
$string['search:activity'] = 'VideoTime - aktivitetsinformation';
$string['search:texttrack'] = 'VideoTime - information om textspår';
$string['search_help'] = 'Sök via namn, beskrivning, album, etiketter..,';
$string['seconds'] = 'Sekunder';
$string['session_not_found'] = 'Användarsessionen hittades inte.';
$string['set_client_id_and_secret'] = 'Ställ in klient-ID och -hemlighet';
$string['settings'] = 'Video Time-inställningar';
$string['setup_repository'] = 'Ställ in lagring';
$string['show_description'] = 'Visa beskrivning';
$string['show_description_in_player'] = 'Visa beskrivning ovanför spelaren';
$string['show_duration'] = 'Visa längd';
$string['show_tags'] = 'Visa etiketter';
$string['show_title'] = 'Visa titel';
$string['show_viewed_duration'] = 'Visa hur länge visningen pågick';
$string['showdescription'] = 'Visa beskrivning';
$string['showdescription_help'] = 'Beskrivningen visas ovanför videon och kan visas på kurssidan.';
$string['showing'] = 'Visar';
$string['showtab'] = 'Visa flik';
$string['state'] = 'Tillstånd';
$string['state_finished'] = 'Avslutad';
$string['state_help'] = 'Har användaren avslutat videon?';
$string['state_incomplete'] = 'Ofullständig';
$string['status'] = 'Status';
$string['store_pictures'] = 'Lagra tumnaglar';
$string['store_pictures_help'] = 'Om det här alternativet är aktiverat lagras Vimeo-miniatyrerna lokalt. Annars kommer bilderna att levereras från Vimeo externt.';
$string['subplugintype_videotimeplugin'] = 'Video Time-plugin';
$string['subplugintype_videotimeplugin_plural'] = 'Video Time-pluginmoduler';
$string['subplugintype_videotimetab'] = 'Video Time-flik';
$string['subplugintype_videotimetab_plural'] = 'Video Time-flikar';
$string['tabinformation'] = 'Information';
$string['tablealias_vt'] = 'Video Time';
$string['tabs'] = 'Flikar';
$string['tabtranscript'] = 'Översättning';
$string['taskscheduled'] = 'Aktivitet schemalagd vid nästa cron-körning';
$string['timestarted'] = 'Startdatum';
$string['todo'] = 'ATT GÖRA';
$string['totaluniquevisitors'] = 'Antal unika besökare';
$string['totalvideotime'] = 'Total visningstid: {$a->time}';
$string['totalviews'] = 'Totalt antal visningar';
$string['totara_video_discovery_help'] = '<p>Du kan utföra denna aktivitet manuellt genom att köra ett CLI-kommando:</p>
<p><b>/usr/bin/php admin/tool/task/cli/schedule_task.php --execute=\\\\videotimeplugin_repository\\\\task\\\\discover_videos</b></p>
<p>Annars kan du behöva vänta till den schemalagda aktiviteten körs.</p>
<p>Du kan också köra kommandot för att hämta albuminformation manuellt (i stället för att vänta):</p>
<p><b>/usr/bin/php admin/tool/task/cli/schedule_task.php --execute=\\\\videotimeplugin_repository\\\\task\\\\update_albums</b></p>';
$string['update_albums'] = 'Uppdatera videoalbum';
$string['upgrade_vimeo_account'] = 'OBS! Överväg att uppgradera ditt Vimeo-konto. API-anropsgränsen är för låg.';
$string['use'] = 'Använd';
$string['video_description'] = 'Anteckningar';
$string['video_description_help'] = 'Anteckningar visas nedanför videon';
$string['videocreated'] = 'Video skapad';
$string['videos_discovered'] = 'Upptäckta videor';
$string['videos_processed'] = 'Bearbetade videor';
$string['videotime:addinstance'] = 'Ny Video Time-modul';
$string['videotime:view'] = 'Visa Video Time-video';
$string['videotime:view_report'] = 'Visa rapport (Endast Pro)';
$string['videotimelink'] = 'Länk';
$string['videotimetabpluginname'] = 'Video Time fliknamn';
$string['videotimetabplugins'] = 'Video Time pluginmoduler';
$string['videotimeurl'] = 'URL';
$string['view_report'] = 'Visa rapport';
$string['viewpercentgrade'] = 'Ange betyget som lika med visningsprocenten.';
$string['viewpercentgrade_help'] = 'Skapa betygsobjekt för den här videon. Deltagaren får ett betyg som motsvarar deras visningsprocent av videon.';
$string['views'] = 'Visningar';
$string['views_help'] = 'Antal gånger som aktiviteten visats';
$string['vimeo_overview'] = 'Översikt och inställningar';
$string['vimeo_url'] = 'Vimeo-URL';
$string['vimeo_url_help'] = 'Fullständig webbadress till Vimeo-video.';
$string['vimeo_url_invalid'] = 'Vimeo-URL:en är ogiltig. Kopiera direkt från webbläsaren.';
$string['vimeo_url_missing'] = 'Vimeo-URL är inte inställd.';
$string['vimeo_video_not_found'] = 'Videon finns inte i databasen.';
$string['vimeo_video_not_processed'] = 'Videon är inte färdigbearbetad ännu. Återkom lite senare och kontrollera igen.';
$string['watch'] = 'Titta';
$string['watch_percent'] = 'Visningsprocent';
$string['watch_percent_help'] = 'Det längsta ögonblicket i videon som studenten har tittat på.';
$string['watch_time'] = 'Visningstid';
$string['watch_time_help'] = 'Hur länge eleven har tittat på videon totalt (i 5s steg).';
$string['with_play_button'] = 'med spela upp-knapp';
