<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reader', language 'es', version '4.2'.
 *
 * @package     reader
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acción';
$string['actionblockquizzestext'] = 'Usted estará impedido para tomar más exámenes hasta que el profesor quite este bloqueo';
$string['actiondelayquizzestext'] = 'Usted será retrasado para tomar más exámenes hasta que haya pasado el tiempo de espera.';
$string['actionemailstudenttext'] = 'Se le enviará un Email a Usted.';
$string['actionemailteachertext'] = 'Se le enviará un Email al profesor(es) del curso.';
$string['activemessages'] = 'Mensajes activos';
$string['activityoverview'] = 'Haga clic aquí para ver información acerca de su actividad extensiva de lectura';
$string['add'] = 'Añadir';
$string['add_phpdoc'] = 'Añadir comentarios a documentos PHP';
$string['add_phpdoc_desc'] = 'Añadir comentarios PHP doc a archivos php, js y css.';
$string['addbookinstance'] = '<Añadir más libros a este curso';
$string['addmoregoals'] = 'Añadir {no} más metas';
$string['addmorerates'] = 'Añadir {no} valoraciones más';
$string['addonemorerate'] = 'Añadir {no} valoración más';
$string['addquiztoreader'] = 'Añadir exámenes de curso a los exámenes del lector';
$string['adjoiningcomputers'] = 'En computadoras vecinas';
$string['adjustscores'] = 'Ajustar puntajes';
$string['adminarea'] = 'Área administrativa';
$string['all'] = 'Todos';
$string['allbooks'] = 'Descargar/arreglar cubiertas para TODOS los libros disponibles al módulo Lector (Reader)';
$string['allcourses'] = 'Todos los cursos';
$string['alldone'] = 'Todo hecho';
$string['allgroups'] = 'Todos los Grupos';
$string['alllevels'] = 'Todos los niveles';
$string['allowpromotion'] = 'Permitir promocion';
$string['allparticipants'] = 'Todos los participantes';
$string['allterms'] = 'Todos los períodos';
$string['anytime'] = 'En cualquier momento';
$string['anywhere'] = 'En cualquier parte';
$string['arrange'] = 'Arreglar';
$string['assignpointsbookshavenoquizzes'] = 'Otorgar puntos para libros que no tengan exámenes';
$string['atlevel'] = 'en el Nivel';
$string['attemptedbooks'] = 'Descargar/arreglar solamente las cubiertas de libros que hayan sido INTENTADOS en este sitio';
$string['attempts'] = 'Intentos';
$string['attemptsallowedn'] = 'Intentos permitidos: {$a}';
$string['attemptscoremanagement'] = 'Gestión de intento y puntaje';
$string['attemptsupdated'] = '{$a} intentos fueron actualizados';
$string['atttemptsgroupedbybook'] = 'Intentos agrupados por libro';
$string['atttemptsgroupedbyuser'] = 'Intentos agrupados por usuario';
$string['available'] = 'Disponible';
$string['availablefrom'] = 'Disponible desde';
$string['availablefrom_help'] = 'Los estudiantes solamente pueden acceder a esta actividad hasta después de la fecha y hora aquí especificadas. Antes de esta fecha y hora, no estará disponible.';
$string['availableitems'] = 'Ítems disponibles';
$string['availablenolonger'] = 'Lo siento, esta actividad ya no está más disponible.Se cerró en {$a}.';
$string['availablenotyet'] = 'Lo siento, esta actividad todavía no está disponible. Se abrirá en {$a}.';
$string['availableuntil'] = 'Disponible hasta';
$string['availableuntil_help'] = 'Los estudiantes solamente pueden acceder hasta la fecha y hora especificada aquí. Después de esta fecha y hora, ya no estará disponible.';
$string['averageduration'] = 'Duración promedio';
$string['averageduration_help'] = 'La duración promedia de intentos de exámenes en Reader';
$string['averagefailed'] = 'Promedio reprobado';
$string['averagefailed_help'] = 'El número promedio de exámenes de Reader reprobados por estudiante';
$string['averagegrade'] = 'Calificación promedio';
$string['averagegrade_help'] = 'La calificación promedio lograda en exámenes de Reader';
$string['averagepassed'] = 'Promedio aprobatorio';
$string['averagepassed_help'] = 'El número promedio de exámenes de Reader pasados (aprobados) por estudiante';
$string['averagepoints'] = 'Puntos promedio';
$string['averagepointsallterms'] = 'Promedio de puntos (de todos los períodos)';
$string['averagepointsallterms_help'] = 'El número promedio de puntos ganados por cada estudiante en este grupo considerando todos los puntos que cualquiera de ellos ha ganado alguna vez en cualquier actividad de Reader en este sitio Moodle.';
$string['averagepointsthisterm'] = 'Promedio de puntos (de este período)';
$string['averagepointsthisterm_help'] = 'El número promedio de puntos ganados por cada estudiante en este grupo considerando solamente puntos ganados en esta actividad de Reader durante el período actual.';
$string['averagerating'] = 'Valoración (rating) promedio';
$string['averagetaken'] = 'Promedio tomado';
$string['averagetaken_help'] = 'El número promedio de exámenes de Reader tomados por estudiante';
$string['averagewords'] = 'Promedio de palabras';
$string['averagewordsallterms'] = 'Promedio de palabras (de todos los períodos)';
$string['averagewordsallterms_help'] = 'El número promedio de palabras ganados por cada estudiante en este grupo considerando todas las palabras que cualquiera de ellos ha ganado alguna vez en cualquier actividad de Reader en este sitio Moodle.';
$string['averagewordsthisterm'] = 'Promedio de palabras (de este período)';
$string['averagewordsthisterm_help'] = 'El número promedio de palabras ganados por cada estudiante en este grupo considerando solamente palabras ganadas en esta actividad de Reader durante el período actual.';
$string['awardbookpoints'] = 'Dar créditos por libros a estudiantes seleccionados';
$string['awardextrapoints'] = 'Otorgar créditos extra a alumnos seleccionados';
$string['awardpointsmanually'] = 'No hay examen para este libro. En su lugar, por favor pídale a su profesorque otorgue los puntos/palabras manualmente.';
$string['best'] = 'El mejor';
$string['blockquizattempts'] = 'Bloquear sguientes intentos de examen';
$string['book'] = 'Libro';
$string['bookadded'] = 'Libro añadido: {$a}';
$string['bookcovers'] = 'Mostrar portadas de los libros';
$string['bookdifficulty'] = 'Dificultad del libro';
$string['bookeditdetails'] = 'Editar detalles del libro';
$string['bookhasnoquiz'] = 'Este libro no tiene examen';
$string['bookinstances'] = 'Usar subconjunto de exámenes';
$string['bookinstancesdisabled'] = 'Esta actividad de Lector (Reader) no está usando un sub-conjunto de exámenes, por lo que no requiere entradas en la tabla de book_instances';
$string['booklevelmanagement'] = 'Gestión del Libro y Nivel';
$string['booknotadded'] = 'Libro NO añadido: {$a}';
$string['booknotfound'] = 'Libro no encontrado {$a}';
$string['booknotupdated'] = 'Libro no actualizado {$a}';
$string['bookquiznumber'] = 'Número de examen de libro';
$string['bookrating'] = 'Valoración (rating) de libro';
$string['bookrating0'] = 'No me gustó nadita';
$string['bookrating1'] = 'Estuvo más o menos';
$string['bookrating2'] = 'Estuvo bueno';
$string['bookrating3'] = 'Estuvo muy bueno';
$string['bookratingslevel'] = 'Mostrar valuaciones (ratings) de libro por estudiantes para cada nivel de libro';
$string['books'] = 'Libros';
$string['booksaddbook'] = 'Añadir libro nuevo';
$string['booksallwith'] = 'cualquier libro que haya sido leído al menos una vez';
$string['booksavailable'] = '{$a}libro(s) disponible(s)';
$string['booksavailableall'] = 'todos los libros disponibles';
$string['booksavailablewith'] = 'libros disponibles que hayan sido leídos al menos una vez';
$string['booksavailablewithout'] = 'libros disponibles que todavía no hayan sido leídos';
$string['bookseditcourse'] = 'Editar ibros (Curso)';
$string['bookseditcourse_help'] = 'En esta página, Usted puede espeecificar cuales libros de Reader van a hacerse disponibles en este curso. Adicionalmente Usted especifica el nivel y el número de palabras para esos libros. Si un nivel o un número de palabras no es especificado aquí, entonces será usado el valor por defecto para ese libro en este sitio Moodle.';
$string['bookseditsite'] = 'Editar libros (Sitio)';
$string['bookseditsite_help'] = 'En esta página Usted puede configurar añadir, editar y eliminar información acerca de libros Reader en este sitio Moodle. Tenga en cuenta que los valores aquí configurados para cualquier libro serán remplazados si se vuelven a descargar los datos para ese libro desde el sitio web principal de Moodle Reader. También, los valores pueden ser anulados localente en cursos individuales.';
$string['booksreadinpreviousterms'] = 'Libros leidos en períodos anteriores';
$string['booksreadsincedate'] = 'Libros leídos desde {$a}';
$string['booksreadsincepromotion'] = 'Libros leídos desde su promoción en {$a}';
$string['booksreadthisterm'] = 'Libros leidos en este período';
$string['booksviaapi'] = 'Datos del libro (vía API)';
$string['bookswithoutquizzes'] = 'Libros sin exámenes';
$string['bookswithquizzes'] = 'Libros con exámenes';
$string['booktitle'] = 'Título del libro';
$string['booktype'] = 'Libros a incluir';
$string['bookupdated'] = 'Libro actualizado: {$a}';
$string['cannotaccesscourse'] = 'Lo sentimos, Usted no tiene permiso para gestionar actividades en el "{$a}" curso.';
$string['cannotcreatecourse'] = 'Lo siento, no puede realizarse la descarga porque Usted no tiene los permisos para crear un nuevo curso o para editar el curso actual.';
$string['cannotdownloadata'] = 'Lo siento, hubo un problema al descargar datos desde el módulo de Lector';
$string['changeallstoplevelto'] = 'Cambiar todos los niveles máximos a';
$string['changeallto'] = 'Cambiar todo a';
$string['changecurrentlevel'] = 'Cambiar todos losniveles actuales a';
$string['changedifficultyfrom'] = 'Cambiar los niveles de dificultad de';
$string['changelevelfrom'] = 'Cambiar nombre del nivel de';
$string['changenumberofsectionsinquiz'] = 'Reiniciar número de secciones en el curso de repositorio de libros';
$string['changepointsfrom'] = 'Cambiar puntos de';
$string['changepublisherfrom'] = 'Cambiar el nombre de la editorial de';
$string['changequiz'] = 'Cambiar examen';
$string['changereaderlevel'] = 'Cambiar Nivel de Lectura, Longitud o Número de Palabras';
$string['changestartlevel'] = 'Cambiar todos los niveles de inicio a';
$string['cheated'] = 'Hizo trampa';
$string['cheatedmessage'] = 'Mensaje de trampa';
$string['cheatedmessage_help'] = 'Este mensaje se les enviará a los estudiantes que el módulo Lector juzgue que han hecho trampa.';
$string['cheatedshort'] = 'Tra';
$string['cheatsheet'] = 'Hoja de trampa';
$string['check_email'] = 'Revisar Email';
$string['check_email_desc'] = 'Enviar dos Emails de prueba al usuario gueststudent, uno vía Moodle mail y otro vía PHP mail.';
$string['checkbox'] = 'Mostrar casillas de selección';
$string['checkcheating'] = 'Revisar si hizo trampa';
$string['checkonlythiscourse'] = 'Revisar solamente este curso';
$string['checksuspiciousactivity'] = 'Revisar bitácoras para buscar actividad sospechosa';
$string['chooseaction'] = 'Elegir una acción y hacer clic en "Ir"';
$string['choosedifficulty'] = 'Por favor elija el nivel de lectura';
$string['chooselevel'] = 'Por favor elija nivel';
$string['choosepublisher'] = 'Por favor elija editorial';
$string['clearedmessage'] = 'Mensaje exonerado';
$string['clearedmessage_help'] = 'Este mensaje es enviado a los estudiantes que fueron juzgados por el módulo Lector como que hicieron trampa, pero después fueron exonerados por el profesor.';
$string['clicktocontinue'] = 'Elija aquí para continuar';
$string['complete'] = 'Completo';
$string['completequizattempt'] = 'Antes de que Usted pueda tomar más exámenes nuevos, Usted debe terminar este examen para "{$a}". Haga clic en el enlace inferior para continuar su intento anterior de este examen.';
$string['completionpass'] = 'Requerir calificación aprobatoria';
$string['completiontotalwords'] = 'Requerir total de lectura';
$string['completiontotalwords_help'] = 'El total de lectura que un estudiante debe lograr dentro de esta actividad para que sea marcada como completa.';
$string['configmreaderenable'] = 'Habilitar o deshabilitar las configuraciones para mReader.org';
$string['configmreadersiteid'] = 'La ID numérica debajo de la cual está registrado este sitio Moodle en mReader.org';
$string['configmreadersitekey'] = 'La clave secreta que le permite a los estudiantes de este sitio Moodle acceder a exámenes en mReader.org';
$string['configmreaderurl'] = 'La URL en donde los estudiantes pueden acceder a los exámenes en mReader.org';
$string['configserverpassword'] = 'La contraseña necesaria para descargar exámenes de Moodle Reader para este sitio Moodle.';
$string['configserverurl'] = 'La URL desde donde Usted puede descargar exámenes Moodle Reader para este sitio Moodle.';
$string['configserverusername'] = 'El nombre_de_usuario necesario para descargar exámenes Moodle Reader para este sitio Moodle.';
$string['confirmdeleteattempts'] = '¿Desea realmente borrar estos intentos?';
$string['confirmstartattemptlimit'] = 'Número de intentos permitidos: {$a}. Está a punto de comenzar un nuevo intento. ¿Desea continuar?';
$string['confirmstartattempttimelimit'] = 'Este cuestionario tiene un límite de tiempo y está restringido a {$a} intento(s). Está a punto de comenzar un nuevo intento. ¿Desea continuar?';
$string['confirmstarttimelimit'] = 'Este cuestionario tiene un límite de tiempo. ¿Está seguro de querer empezar?';
$string['countactive'] = 'Alumnos activos';
$string['countactive_help'] = 'El número de alumnos que han realizado al menos un cuestionario de lectura.';
$string['countfailed'] = 'Cuestionarios fallidos';
$string['countinactive'] = 'Alumnos inactivos';
$string['countinactive_help'] = 'Número de alumnos que no han realizado ningún cuestionario de lectura.';
$string['countpassed'] = 'Cuestionarios superados';
$string['countrating'] = 'Número de valoraciones';
$string['courseid'] = 'ID del Curso';
$string['coursespecificquizselection'] = 'Selección de examen específica-del-curso a "Si" en la pantalla de configuración del módulo.';
$string['createcoversets_l'] = 'Crear Conjuntos de Forros por  Nivel y Editorial';
$string['createcoversets_t'] = 'Crear Conjuntos de Forros por Editorial &amp; Nivel';
$string['credit'] = 'Crédito extra';
$string['creditshort'] = 'X';
$string['curlerror'] = 'Error CURL: {$a}';
$string['current'] = 'Actual';
$string['currentcourse'] = 'Curso actual';
$string['currentlevel'] = 'Nivel actual';
$string['dataallavailable'] = 'la información para el/los {$a} libro(s) está disponible';
$string['dataalldownloaded'] = 'la información para el/los {$a} libro(s) se ha descargado';
$string['datasomeavailable'] = 'la información para {$a->new} del total de {$a->all} libro(s) está disponible';
$string['defaultcategoryname'] = 'Cuestionarios de lectura';
$string['defaultcoursename'] = 'Cuestionarios de lectura';
$string['defaultgoal'] = 'Objetivo por defecto';
$string['defaultgoals'] = 'Objetivos por defecto';
$string['defaultquestioncategoryinfo'] = '{$a->category} preguntas para el {$a->quiz}';
$string['defaultrates'] = 'Calificaciones por defecto';
$string['definelogindetails'] = 'Por favor defina los detalles de inicio de sesión: {$a}';
$string['delayineffect'] = 'El aplazamiento de cuestionario está activo';
$string['delayquizattempts'] = 'Aplazar futuros intentos de cuestionario';
$string['delete'] = 'Eliminar';
$string['deleteallattempts'] = 'Eliminar todos los intentos de los cuestionarios de lectura';
$string['deleteallattempts_help'] = 'Por norma general, NO debería borrar intentos de cuestionarios de lectura.

Sólo debería eliminar intentos si está completamente seguro de que los alumnos de este curso no volverán a realizar cuestionarios de lectura en este sitio Moodle jamás.

Esto se debe a que eliminando los intentos de los cuestionarios de lectura, permite a los alumnos volver a hacer cualquier cuestionario de lectura que ya hubieran realizado antes. Esta NO es la forma en la que se desea que funcione el módulo Lector. Los alumnos deberían tener sólo UNA oportunidad de hacer cada cuestionario de lectura.

Eliminar intentos de los cuestionarios de lectura también reseteará las puntuaciones de lecturas de todos los alumnos a cero, lo que probablemente no quiera ni usted ni los alumnos.';
$string['deleteattempts'] = 'Eliminar los intentos seleccionados';
$string['deletecategories'] = 'Eliminar categorías';
$string['deletecourses'] = 'Eliminar cursos';
$string['deleted'] = 'Eliminado';
$string['deletedshort'] = 'Eli';
$string['deletegoals'] = 'Eliminar los objetivos para grupos y niveles';
$string['deletegoals_help'] = 'Los objetivos de lectura por defecto para grupos o los niveles de lectura serán eliminados.';
$string['deletemessages'] = 'Eliminar los mensajes del módulo Lector';
$string['deletemessages_help'] = 'Todos los mensajes que aparecen en la página principal de los alumnos de este curso sobre actividades de lectura serán eliminados.';
$string['deleterates'] = 'Eliminar calificaciones para grupos y niveles';
$string['deleterates_help'] = 'Las calificaciones de los cuestionarios de lectura para grupos o niveles de lectura serán eliminados.';
$string['detect_cheating'] = 'Se detectó trampa';
$string['detect_cheating_desc'] = 'Revisar las bitácoras de intentos y reportar actividad sospechosa que podría indicar que hicieron trampa.';
$string['difficulty'] = 'Dificultad';
$string['difficultyshort'] = 'RL';
$string['disallowpromotion'] = 'NO permitir ascensos';
$string['displayoptions'] = 'Mostrar opciones';
$string['downloadbooksviaapi'] = 'Descargar datos del libro (vía API)';
$string['downloadbookswithoutquizzes'] = 'Descargar información del libro (sin cuestionarios)';
$string['downloadbookswithquizzes'] = 'Descargar información del libro y cuestionarios';
$string['downloadedbooks'] = 'Se descargó la información de los siguiente libros:';
$string['downloadexcel'] = 'Descargar Excel';
$string['downloadextrapoints'] = 'Por favor descargue los cuestionarios "Puntos Extra"';
$string['downloadmode'] = 'Modo';
$string['downloadmode_help'] = 'Esta página puede presentarse de dos modos:

**Normal**
: En el modo normal, sólo estarán disponibles los libros cuya información aún no se haya descargado o los libros cuya información se haya actualizado. Los libros para los que se haya descargado información más reciente no estarán disponibles.

**Reparar**
: En el modo reparar, todos los libros están disponibles para descargar. Si alguna información se ha descargado anteriormente será sobre escrita por la nueva información descargada. Utilice este modo si quiere reparar cuestionarios defectuosos o información incorrecta. Tenga en cuenta que aunque los cuestionarios también serán sobre escritos, la información de los intentos de los alumnos en esos cuestionarios se mantendrá.';
$string['downloads'] = 'Descargar';
$string['downloadsettings'] = 'Descargar ajustes';
$string['duration'] = 'Duración';
$string['edit'] = 'Editar';
$string['editquiztoreader'] = 'Eliminar cuestionarios';
$string['err_regex_float'] = 'Este valor debe ser un número decimal entre 0,0 y 10,0';
$string['err_regex_integer'] = 'Este valor debe ser un número entero entre 0 y 100.000';
$string['error'] = 'Error: {$a}';
$string['errorsfound'] = 'Errores encontrados';
$string['event_attempt_added'] = 'Intento de examen de Reader añadido';
$string['event_attempt_added_description'] = 'El usuario con id "{$a->userid}" inició un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_added_explanation'] = 'Un usuario recientemente empezó un intento de examen de Reader';
$string['event_attempt_deleted'] = 'Intento de examen de Lector eliminado';
$string['event_attempt_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_deleted_explanation'] = 'Un usuario recientemente eliminó un intento de un examen de Lector';
$string['event_attempt_edited'] = 'Intento de examen de Lector eliminado';
$string['event_attempt_edited_description'] = 'El usuario con id "{$a->userid}" editó un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_edited_explanation'] = 'Un usuario recientemente ha editado un intento de un examen de Lector';
$string['event_attempt_submitted'] = 'Intento de examen de Lector enviado';
$string['event_attempt_submitted_description'] = 'El usuario con id "{$a->userid}" envió un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'Un usuario recientemente envió un intento de un examen de Lector';
$string['event_base'] = 'Evento de Lector detectado';
$string['event_base_description'] = 'El usuario con id "{$a->userid}" inició un evento en la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_base_explanation'] = 'Un evento fue detectadopor el módulo de Lector';
$string['event_book_added'] = 'Libro de Lector añadido';
$string['event_book_added_description'] = 'El usuario con id "{$a->userid}" añadió un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_added_explanation'] = 'Un usuario recientemente añadió datos acerca de un libro de Reader';
$string['event_book_deleted'] = 'Libro de Lector eliminado';
$string['event_book_deleted_description'] = 'El usuario con id "{$a->userid}" eleminó un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_deleted_explanation'] = 'Un usuario recientemente eliminó datos de un libro de Reader';
$string['event_book_edited'] = 'Libro de lector editado';
$string['event_book_edited_description'] = 'El usuario con id "{$a->userid}" editó un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_edited_explanation'] = 'Un usuario recientemente editó datos de un libro de Reader';
$string['event_books_downloaded'] = 'Libros de Lector descargados';
$string['event_books_downloaded_description'] = 'El usuario con id "{$a->userid}" descargó libros para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_books_downloaded_explanation'] = 'Un usuario recientemente descargó datos de libros de Reader';
$string['event_cron_run'] = 'Cron de Lector ejecutado';
$string['event_cron_run_description'] = 'El trabajo del CRON del Lector ha corrido';
$string['event_cron_run_explanation'] = 'El trabajo del CRON del Lector recientemente ha sido corrido';
$string['event_downloads_viewed'] = 'Descargas de Lector vistas';
$string['event_downloads_viewed_description'] = 'El usuario con id "{$a->userid}" avió datos acerca de las descargas para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_downloads_viewed_explanation'] = 'Un usuario recientemente vió datos de descargas de Reader';
$string['event_message_added'] = 'Mensaje de Reader añadido';
$string['event_message_added_description'] = 'El usuario con id "{$a->userid}" añadió un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_added_explanation'] = 'Un usuario recientemente añadió un mensaje a una actividad de Reader';
$string['event_message_deleted'] = 'Mensaje de Reader eliminado';
$string['event_message_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_deleted_explanation'] = 'Un usuario recientemente eliminó un mensaje de una actividad de Reader';
$string['event_message_edited'] = 'Mensaje de Reader editado';
$string['event_message_edited_description'] = 'El usuario con id "{$a->userid}" editó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_edited_explanation'] = 'Un usuario recientemente editó un mensaje de una actividad de Reader';
$string['event_quiz_added'] = 'Examen de Reader añadido';
$string['event_quiz_added_description'] = 'El usuario con id "{$a->userid}" añadió un examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_added_explanation'] = 'Un usuario recientemente añadió un examen a una actividad de Reader';
$string['event_quiz_delay_set'] = 'Retraso de examen de Reader configurado';
$string['event_quiz_delay_set_description'] = 'El usuario con id "{$a->userid}" configuró un retraso de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_delay_set_explanation'] = 'Un usuario recientemente configuró un retraso en un examen de Reader';
$string['event_quiz_deleted'] = 'Examen de Reader eliminado';
$string['event_quiz_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_deleted_explanation'] = 'Un usuario recientemente eliminó un examen de Reader';
$string['event_quiz_edited'] = 'Examen de Reader editado';
$string['event_quiz_edited_description'] = 'El usuario con id "{$a->userid}" editó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_edited_explanation'] = 'Un usuario recientemente editó un examen de Reader';
$string['event_quiz_finished'] = 'Examen de lector terminado';
$string['event_quiz_finished_description'] = 'El usuario con id "{$a->userid}" terminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_finished_explanation'] = 'Un usuario recientemente terminó un examen de Reader';
$string['event_quiz_selected'] = 'Examen de lector seleccionado';
$string['event_quiz_selected_description'] = 'El usuario con id "{$a->userid}" seleccionó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_selected_explanation'] = 'Un usuario recientemente seleccionó un examen de Reader';
$string['event_quiz_started'] = 'Examen de Lector iniciado';
$string['event_quiz_started_description'] = 'El usuario con id "{$a->userid}" inició un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_started_explanation'] = 'Un usuario recientemente inició un examen de Reader';
$string['event_report_bookdetailed_viewed'] = 'Reporte de Reader visto: Libros (detallado)';
$string['event_report_bookdetailed_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Libros" (detallado) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_bookdetailed_viewed_explanation'] = 'Un usuario recientemente vió un Reporte de Reader: Libros (detallado)';
$string['event_report_booksummary_viewed'] = 'Reporte de Reader visto: Libros (resumen)';
$string['event_report_booksummary_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Libros" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_booksummary_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Libros (resumen)';
$string['event_report_groups_viewed'] = 'Reporte de Reader visto: Grupos (resumen)';
$string['event_report_groups_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Grupos" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_groups_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Grupos (resumen)';
$string['event_report_userdetailed_viewed'] = 'Reporte de Reader visto: Usuarios (detallado)';
$string['event_report_userdetailed_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Usuarios" (detallado) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_userdetailed_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Usuarios (detallado)';
$string['event_report_usersummary_viewed'] = 'Reporte de Reader visto: Usuarios (resumen)';
$string['event_report_usersummary_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Usuarios" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_usersummary_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Usuarios (resumen)';
$string['event_tool_run'] = 'Herramienta administrativa del Lector corrida';
$string['event_tool_run_description'] = 'El usuario con id "{$a->userid}" corrió una herramienta administrativa para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_tool_run_explanation'] = 'Un usuario recientemente corrió una herramienta de Reader: {$a}';
$string['event_user_goal_set'] = 'Meta de usuario Lector configurada';
$string['event_user_goal_set_description'] = 'El usuario con id "{$a->userid}" configuró una meta de lectura de estudiante para la actividad de "Lector" con la ID del módulo de curso "{$a->cmid}"';
$string['event_user_goal_set_explanation'] = 'Un usuario acaba de configurar una meta de lectura en una actividad de Lector';
$string['event_user_level_set'] = 'Nivel de usuario Lector configurado';
$string['event_user_level_set_description'] = 'El usuario con id "{$a->userid}" configuró un nivel de lectura de estudiante para la actividad "reader" con ID de módulo de curso  "{$a->cmid}"';
$string['event_user_level_set_explanation'] = 'Un usuario recientemente configuró el nivel de lectura para un estudiante en una actividad de Reader';
$string['event_users_exported'] = 'Usuarios de Reader exportados';
$string['event_users_exported_description'] = 'El usuario con id "{$a->userid}" exportó datos de estudiante para la actividad "reader" con ID del módulo de curso  "{$a->cmid}"';
$string['event_users_exported_explanation'] = 'Un usuario recientemente exportó datos de estudiantes desde una actividad de Reader';
$string['event_users_imported'] = 'Usuarios de Reader importados';
$string['event_users_imported_description'] = 'El usuario con id "{$a->userid}" importó datos de estudiante para la actividad "reader" con ID del módulo de curso  "{$a->cmid}"';
$string['event_users_imported_explanation'] = 'Un usuario recientemente importó datos de estudiantes hacia una actividad de Reader';
$string['export'] = 'Exportar';
$string['export_reader_tables'] = 'Exportar tablas de Lector';
$string['export_reader_tables_desc'] = 'Exportar tablas de base de datos de Reader. Tenga en cuenta que los datos exportados no contienen nombres de usuario ni de curso, solamente IDs.';
$string['exportstudentrecords'] = 'Exportar registros de estudiante';
$string['extrapoints'] = 'Puntos Extra';
$string['extrapoints0'] = '0.5 Puntos';
$string['extrapoints1'] = '1 Punto';
$string['extrapoints2'] = '2 Puntos';
$string['extrapoints3'] = '3 Puntos';
$string['extrapoints4'] = '4 Puntos';
$string['extrapoints5'] = '5 Puntos';
$string['extrapoints6'] = '6 Puntos';
$string['extrawords'] = '{$a} palabras';
$string['failed'] = 'Reprobó';
$string['failedshort'] = 'NA';
$string['filename'] = 'Nombre del archivo';
$string['fileuploaded'] = 'El archivo fue subido';
$string['find_faultyquizzes'] = 'Encontrar exámenes defectuosos';
$string['find_faultyquizzes_desc'] = 'Encontrar exámenes que tengan preguntas que no tengan respuesta correcta, o preguntas que se hayan vuelto huérfanas.';
$string['finishreview'] = 'Terminar Revisión';
$string['fix_bookcovers'] = 'Reparar Portadas de libros';
$string['fix_bookcovers_desc'] = 'Detectar libros a los que les falta una imagen de cubierta-de-libro, e intentar descargar la imagen de cubierta del libro.';
$string['fix_bookinstances'] = 'Reparar instancias de libros';
$string['fix_bookinstances_desc'] = 'Asegurarse de que todos los libros tengan un registro asociado en la tabla reader_book_instances.';
$string['fix_coursesections'] = 'Reparar secciones de curso';
$string['fix_installxml'] = 'Reparar db/install.xml';
$string['fix_missingquizzes'] = 'Reparar exámenes faltantes';
$string['fix_questioncategories'] = 'Reparar categorías de preguntas';
$string['fix_slashesinnames'] = 'Reparar diagonales en nombres';
$string['fix_slashesinnames_desc'] = 'Quitar las diagonales en los nombres de libros Reader y categorías de preguntas.';
$string['fix_wrongattempts'] = 'Reparar intentos equivocados';
$string['fix_wrongattempts_desc'] = 'Detectar y corregir cualquier intento en exámenes Reader en donde el nombre del examen no coincida con el nombre del libro en la bitácora de Reader.';
$string['fixattempts'] = 'Corrigiendo intentos de lectura duplicados';
$string['fixcontexts'] = 'Corrigiendo los contextos defectuosos en categorías de pregunta del Examen';
$string['fixingsumgrades'] = 'Reparando calificaciones en intentos de exámenes de Reader...';
$string['fixinstances'] = 'Revisando instancias de preguntas de Lectura';
$string['fixmissingquizzes'] = 'Reparar exámenes faltantes';
$string['fixmultichoice'] = 'Corrigiendo preguntas de opción múltple de Lectura';
$string['fixordering'] = 'Actualizando ordenamiento de preguntas para módulo Lectura';
$string['fixquestiontext'] = 'Corregir marcas en preguntas de Lector';
$string['fixquizslots'] = 'Corrigiendo casos de pregunta defectuosa en intentos de Examen';
$string['fixslashesinnames'] = 'Remover diagonales en títulos de libros';
$string['fixwrongquizid'] = '"{$a->name}" (book id={$a->id}) tiene una ID de examen inesperada';
$string['forcedownload'] = 'Forzar descarga';
$string['forcedtimedelay'] = 'Configurar retraso de hora forzada';
$string['forcedtimerate'] = 'Configurar tasa forzada de lectura';
$string['fromthistime'] = 'Desde esta hora';
$string['fullreportbybooktitle'] = 'Reporte completo por Título del Libro';
$string['fullreportquiztoreader'] = 'Reporte completo por Estudiante';
$string['genre'] = 'Género';
$string['goal'] = 'Objetivo';
$string['groupgoals'] = 'Metas para grupos específicos';
$string['grouprates'] = 'Valoraciones para grupos espeíficos';
$string['hidden'] = 'Oculto';
$string['ifimagealreadyexists'] = 'Ya existe una imagen en la carpeta de imágenes (nombre)';
$string['ignoredate'] = 'Fecha de inicio del período (semestre)';
$string['image'] = 'Imagen';
$string['imageadded'] = 'Imagen añadida: {$a}';
$string['import'] = 'Importar';
$string['import_reader_tables'] = 'Importar tablas de reader';
$string['import_reader_tables_desc'] = 'Recrear un sitio Moodle completo solamente a partir de la base de datos Reader. Esta herramienta creará cursos, usuarios, grupos, actividades Reader y exámenes.';
$string['importreadertables'] = 'Importar tablas de Reader';
$string['importstudentrecord'] = 'Importar registro de estudiante';
$string['in1000sofwords'] = 'en 1000s de palabras';
$string['includepublishers'] = '¿Buscar también nombres de casas editoriales?';
$string['incorrect'] = '- incorrecto';
$string['incorrect2'] = '- Lo sentimos, por favor obtenga la contraseña correcta del/los editor(es). Haga clic en "Instalar Exámenes" para descargar sus otras selecciones.';
$string['incorrectbooksreadinpreviousterms'] = 'Ver examenes reprobados';
$string['induration'] = 'en';
$string['install_quizzes'] = 'Instala Exámenes';
$string['installedbooks'] = 'Descargar/corregir solamente cubiertas para libros que ya están INSTALADOS en este sitio';
$string['ipaddress'] = 'Dirección IP';
$string['isgreaterthan'] = 'es mayor que';
$string['islessthan'] = 'es menor que';
$string['itemsdownloaded'] = '{$a} items descargados';
$string['keeplocalbookdifficulty'] = 'Conservar configuracines de dificultad de libro local';
$string['keepoldquizzes'] = 'Conservar exámenes antiguos';
$string['lastupdatedtime'] = 'Los exámenes en este sitio fueron actualizadas por última ocasión en {$a}. ¿Desea Usted actualizar este sitio ahora?';
$string['level'] = 'Nivel';
$string['levelcheck'] = 'Restringir Nivel de lectura';
$string['levelgoal'] = 'Meta del Nivel {$a}';
$string['levelgoals'] = 'Metas para niveles específicos';
$string['leveli'] = 'Nivel {$a}';
$string['levelrate'] = 'Nivel {$a} tasa';
$string['levelrates'] = 'Valoraciones para niveles específicos';
$string['levels'] = 'Niveles';
$string['likebook'] = '¿Que tanto te gustó este libro?';
$string['mainpagesettings'] = 'Configuraciones de la página principal';
$string['makebookavailable'] = 'Hacer disponibles los libros';
$string['makebookavailableproblem'] = 'Ups, no se pudo hacer libro disponible en este curso: {$a}';
$string['makebookavailablesuccess'] = 'Libro está ahora disponible en este curso: {$a}';
$string['makenewquizzesavailable'] = 'Hacer los nuevos exámenes disponibles solamente en este curso';
$string['makenewquizzesavailable2'] = 'Hacer los nuevos exámenes disponibles en todos los cursos en este sitio [configuración por defecto]';
$string['massrename'] = 'Cambios en masa';
$string['max'] = 'Menor que o igual a';
$string['maxgrade'] = 'Calificación máxima';
$string['maxquizattemptrate'] = 'Tasa máxima de intento de examen';
$string['maxquizattemptrate_help'] = 'La tasa máxima a la que los estudiantes pueden intentar exámenes Reader. Si un estudiante intenta más que el número de examenes dentro de la duración especificada, entonces se tomará la acción especificada.';
$string['maxquizattemptratetext'] = 'Por favor no tome más de {$a}. Si Usted excede esta tasa, se tomará a siguiente acción:';
$string['maxquizfailurerate'] = 'Tasa de falla máxima de examen';
$string['maxquizfailurerate_help'] = 'La tasa máxima a la que los estudiantes pueden reprobar exámenes Reader. Si un estudiante reprueba más que el número de examenes dentro de la duración especificada, entonces se tomará la acción especificada.';
$string['maxquizfailureratetext'] = 'Si Usted falla en más de {$a}, se tomará la siguiente acción:';
$string['maxtimebetweenquizzes'] = 'Tiempo máximo entre exámenes';
$string['menu'] = 'Menú';
$string['mergingtables'] = 'Uniendo tablas: {$a->old} dentro de {$a->new}';
$string['messagefromyourteacher'] = 'Mensaje de su profesor';
$string['migratinglogs'] = 'Migrando bitácoras de Reader';
$string['min'] = 'Mayor que o igual a';
$string['minimumdelay'] = 'Retraso máximo';
$string['minpassgrade'] = 'Calificación mínima aprobatoria del examen';
$string['minquizattemptrate'] = 'Tasa mínima d intento de examen';
$string['minquizattemptrate_help'] = 'La tasa mínima a la que los estudiantes pueden intentar exámenes Reader. Si un estudiante no continúa intentando al menos el número especificado de exámenes dentro de la duración especificada, entonces se tomará la acción especificada.';
$string['minquizattemptratetext'] = 'Por favor tome al menos {$a}. Si Usted baja de esta tasa, se tomará la siguiente acción:';
$string['modulename'] = 'Lector';
$string['modulename_help'] = 'El módulo de Lector le permite a los profesores configurar objetivos de lectura para estudiantes, y les permite a los estudiantes demostrar que han cubierto los objetivos de lectura especificados.';
$string['modulename_link'] = 'mod/reader/view';
$string['modulenameplural'] = 'Lector';
$string['morenewattempts'] = '{$a} intentos nuevos más ...';
$string['move_quizzes'] = 'Mover exámenes';
$string['move_quizzes_desc'] = 'Mover exámenes de Reader del curso actual hacia el curso principal para exámenes Reader.';
$string['movedquizzes'] = '{$a} exámenes movidos exitosamente';
$string['mreaderenable'] = 'Habilitar configuraciones mReader';
$string['mreadersettings'] = 'Acceder a exámenes mReader';
$string['mreadersiteid'] = 'ID del sitio para exámenes mReader';
$string['mreadersitekey'] = 'Clave para exámenes mReader';
$string['mreaderurl'] = 'URL para exámenes mReader';
$string['needdeletethisattemptstoo'] = 'Necesita eliminar también estos Intentos';
$string['needtocheckupdates'] = 'Este sitio no ha sido revisado para actualizaciones de exámenes en ({$a} días. ¿Revisar ahorita?';
$string['newdate'] = 'Nueva fecha';
$string['newreaderattempts'] = 'Nuevos intentos de Reader';
$string['newreadinggoal'] = 'Nuevo objetivo';
$string['newreadinglevel'] = '¡Nuevo nivel!';
$string['newsetting'] = 'Nuevo valor para esta configuración';
$string['newtime'] = 'Nueva hora';
$string['nextlevel'] = 'Exámenes al nivel siguiente';
$string['nextlevel_help'] = 'El número de exámenes que un estudiante puede tomar del siguiente nivel de lectura. Por ejemplo, el nivel de lectura que está justamente arriba del nivel de lectura actual. Tenga en cuenta que estos exámenes NO CUENTAN hacia la promoción.';
$string['no_password'] = 'No se requiere contraseña';
$string['noaction'] = 'No tomar ninguna acción';
$string['nobooksfound'] = 'No se encontraron libros';
$string['nobooksinlist'] = 'No se encontraron libros para su ivel de lectura';
$string['nodownloaditems'] = 'No hay ítems disponibles para descargar';
$string['noemailever'] = 'El enviar Email está deshabilitado debido a una configuración de  $CFG->noemailever.';
$string['noincorrectquizzes'] = 'Usted no ha reprobado ningún examen';
$string['nomoreattempts'] = 'No están permitidos más intentos';
$string['noquizzesfound'] = 'No se encontraron exámenes';
$string['noreaders'] = 'No se encontraron actividades de lectura en este curso';
$string['norecordsmatch'] = 'No fueron seleccionados registros usando los filtros actuales y opciones de visualización.';
$string['noreview'] = 'Usted no tiene permitido revisar este examen';
$string['noreviewshort'] = 'No permitido';
$string['normalmode'] = 'Normal';
$string['noscript'] = '¡JavaScript debe de estar habilitado para continuar!';
$string['nosearchresults'] = 'No están disponibles libros que coincidan con su búsqueda';
$string['notavailable'] = 'Este cuestionario no está disponible actualmente';
$string['nothavepermissioncreateinstance'] = 'Lo siento, no tiene permiso para realizar esta acción';
$string['notifycheating'] = 'Notificar trampas';
$string['notifycheating_help'] = 'Si se habilita esta configuración, entonces a los estudiantes que sean juzgados como  que hubieran hecho trampa en intentos en exámenes de Reader se les enviará el "Mensaje de Trampa" inferior.';
$string['numattempts'] = '{$a} intentos';
$string['numberofextrapoints'] = 'Número de puntos extra';
$string['off'] = 'Desactivado';
$string['oneattempt'] = '1 intento';
$string['onlybookswithmorethan'] = 'Solo libros con más de';
$string['outputformat'] = 'Formato de salida';
$string['pagesettings'] = 'Configuraciones de página';
$string['passed'] = 'Pasado';
$string['passedshort'] = 'P';
$string['passworderror'] = 'La contraseña introducida es incorrecta';
$string['passwords_list'] = 'Lista de contraseñas';
$string['percentactive'] = 'Porcentaje activo';
$string['percentactive_help'] = 'El número de estudiantes que han tomado al menos un examen de Reader';
$string['percentinactive'] = 'Porcentaje inactivo';
$string['percentinactive_help'] = 'El porcentaje de estudiantes que no han tomado ningún examen de Reader';
$string['pleaseaskyourinstructor'] = 'Por favor pida a su instructor que le suba de nivel si es demasiado fácil para usted.';
$string['pleaseclose'] = 'Su petición ha sido procesada. Puede cerrar ya esta ventana';
$string['pleaseselectpublisher'] = 'Por favor seleccione Casa editorial';
$string['pleasespecifyyourclassgroup'] = 'Por favor especifique su grupo de clase o busque a un estudiante específico.';
$string['pleasewait'] = 'Por favor espere';
$string['pluginadministration'] = 'Administración de Lector';
$string['pluginname'] = 'Lector';
$string['points'] = 'Puntos';
$string['pointsex11'] = 'Extensión(Ex. 1.1)';
$string['popup'] = 'Usar ventana "segura"';
$string['prevlevel'] = 'Exámenes al nivel previo';
$string['prevlevel_help'] = 'El número de exámenes que un estudiante puede tomar del nivel de lectura anterior. Por ejemplo, el nivel de lectura que está justamente abajo del nivel de lectura actual. Tenga en cuenta que estos exámenes NO CUENTAN hacia la promoción.';
$string['print_cheatsheet'] = 'Imprimir hoja de respuestas';
$string['print_cheatsheet_desc'] = 'Mostrar las respuestas para cualquier examen Reader';
$string['process_addquestion'] = '<b>Añadirle preguntas al examen {$a}.</b><br />';
$string['process_courseadded'] = '<b>Curso añadido.</b><br />';
$string['promotionnotallowed'] = 'Su profesor ha suspendido la promoción automática para Usted.';
$string['promotionsettings'] = 'Configuraciones para promoción';
$string['publisher'] = 'Casa Editorial';
$string['publishers'] = 'Casas Editoriales';
$string['questionscores'] = 'Mostrar puntajes de pregunta';
$string['quizadd'] = 'Añadir exámenes de Reader';
$string['quizadded'] = 'Examen añadido: {$a}';
$string['quizarrange'] = 'Arreglar exámenes de Reader';
$string['quizattemptinprogress'] = 'Intento de examen de Reader en progreso ...';
$string['quizclosed'] = 'Este examen cerró en {$a}';
$string['quizcloseson'] = 'Este examen cerrará en {$a}';
$string['quizdelete'] = 'Eliminar exámenes de Reader';
$string['quizfordays'] = 'Restricción de frecencia (días)';
$string['quizhasnoquestions'] = 'El examen no tiene preguntas';
$string['quizmanagement'] = 'Gestión del examen';
$string['quizname'] = 'Nombre del examen';
$string['quiznotavailable'] = 'Lo sentimos, este cuestionario actualmente no está disponible para usted';
$string['quiznotavailableuntil'] = 'El examen no estará disponible hasta después de {$a}';
$string['quizopenedon'] = 'El examen abrió en {$a}';
$string['quizsetrate'] = 'Configurar tasa de exámenes de Lectura';
$string['quizshowhide'] = 'Mostrar / Ocultar exámenes de Reader';
$string['quiztimelimit'] = 'Límite de tiempo: {$a}';
$string['quizupdate'] = 'Actualizar exámenes de Reader';
$string['quizupdated'] = 'Examen actualizado: {$a}';
$string['quizupdateswillbeapplied'] = 'Las actualizaciones del examen serán aplicadas a todos los cursos que actualmente usan en examen.';
$string['quizzes'] = 'Exámenes';
$string['quizzesadd'] = 'Añadir exámenes';
$string['quizzesadded'] = 'Exámenes añadidos';
$string['quizzesarrange'] = 'Arreglar exámenes';
$string['quizzesdelete'] = 'Eliminar exámenes';
$string['quizzesmustbeinstalled'] = 'Los exámenes deben de ser instalados en un curso que está separado del curso en el cual los estudiantes ingresarán cuando tomen exámenes. El curso está oculto de los estudiantes y solamente es usado como área de almacenaje para los exámenes; y normalmente es llamado "All Quizzes"" (Todos Exámenes). El curso que Usted ha establecido para este propósito debería de estar mostrado debajo. Si Usted aun no ha establecido un curso, por favor haga clic en "Crear nuevo curso".';
$string['quizzespassedtable'] = 'Exámenes pasados en  Derecha_a_Izquierda-{$a}';
$string['quizzessetrate'] = 'Configurar tasa de lectura';
$string['quizzesshowhide'] = 'Mostrar/Ocultar exámenes';
$string['quizzesupdate'] = 'Actualizar exámenes';
$string['rate'] = 'Tasa';
$string['rate_help'] = 'La tasa de lectura es especificada como el máximo número de intentos permitidos en exámenes Reader, o el m´´inimo requerido de intentos, dentro de una duración especificada.';
$string['rateaction'] = 'Acción';
$string['rategroup'] = 'Grupo';
$string['rategroup_help'] = 'el grupo al cual aplica esta restricción de tasa';
$string['ratelevel'] = 'Nivel';
$string['ratelevel_help'] = 'el nivel de lectura al cual aplica esta restricción de tasa';
$string['ratemanyconsecutively'] = '{$a->attempts} exámenes consecutivamente';
$string['ratemanyinduration'] = '{$a->attempts} exámenes en {$a->duration}';
$string['rateoneinduration'] = '{$a->attempts} examen en {$a->duration}';
$string['ratetype'] = 'Tipo';
$string['ratings'] = 'valuaciones (ratings)';
$string['reader:addinstance'] = 'Añadir una nueva actividad de Lector';
$string['reader:manageattempts'] = 'Gestionar intentos';
$string['reader:managebooks'] = 'Gestionar libros';
$string['reader:manageremotesites'] = 'Gestionar sitios remotos';
$string['reader:managetools'] = 'Gestionar herramientas';
$string['reader:manageusers'] = 'Gestionar usuarios';
$string['reader:viewallbooks'] = 'Ver todos los libros';
$string['reader:viewbooks'] = 'Ver libros';
$string['reader:viewreports'] = 'Ver reportes';
$string['reader:viewversion'] = 'Ver versión';
$string['readerdownload'] = 'Descargar libros (y exámenes) de Lector';
$string['readerid'] = 'ID Reader';
$string['readerquizsettings'] = 'Configuraciones del examen de Lector';
$string['readerreports'] = 'Reportes del módulo Lector (\'\'Reader\'\')';
$string['readinglevel'] = 'Nivel de Lectura';
$string['readinglevelshort'] = 'Derecha_a_Izquierda {$a}';
$string['readingreportfor'] = 'Reporte de Lectura para {$a}';
$string['readonlyfrom'] = 'Solamente-lectura desde';
$string['readonlyfrom_help'] = 'Deespués de esta fecha y hora, los estudiantes pueden ver su página principal de Reader, pero no pueden tomar más exámenes vía esta actividad Reader.';
$string['readonlymode'] = 'Modo lectura-solamente';
$string['readonlymode_desc'] = 'Esta actividad actualmente está en modo de solo-lectura. Usted puede ver la información en la primera página de esta actividad Reader, pero actualmente Usted no puede tomar ningún examen Reader.';
$string['readonlysincedate'] = 'Esta actividad ha estado en modo solamente-lectura desde {$a}.';
$string['readonlyuntil'] = 'Solamente-lectura hasta';
$string['readonlyuntil_help'] = 'Antes de esta fecha y hora, los estudiantes pueden ver sus páginas principales de Reader, pero no pueden tomar ningún examen vía esta actividad reader.';
$string['readonlyuntildate'] = 'Esta actividad permanecerá en modo solamente-lectura hasta {$a}.';
$string['recommendedreadingrates'] = 'Tasas de lectura recomendadas';
$string['redo_upgrade'] = 'Rehacer actualización';
$string['redo_upgrade_desc'] = 'Rehacer una actualización al módulo Reader.';
$string['remotesitenotaccessible'] = 'El sitio de descarga remota no es accesible';
$string['removebook'] = 'Quitar libros';
$string['removebook_help'] = 'Los libros que tienen intentos "vivos" no pueden ser eliminados. Para eeliminar esos libros, Usted primeramente necesita eliminarles sus intentos "vivos".';
$string['removebookerror'] = 'Libro NO fue quitado: {$a}';
$string['removebookinstance'] = 'Quitar libros seleccionados de este curso';
$string['removebooksuccess'] = 'Libro fue quitado: {$a}';
$string['repairmode'] = 'Reparar';
$string['reportbookdetailed'] = 'Libros (completo)';
$string['reportbookratings'] = 'Valuaciones (ratings) de libro';
$string['reportbooksummary'] = 'Libros (resumen)';
$string['reporteditsite'] = 'Libros (todos los datos del libro)';
$string['reportgroupsummary'] = 'Grupos';
$string['reportquiztoreader'] = 'Reporte de Resumen por Estudiante';
$string['reports'] = 'Reportes';
$string['reportsettings'] = 'Configuraciones de Reporte';
$string['reportuserdetailed'] = 'Estudiantes (completo)';
$string['reportusersummary'] = 'Estudiantes (resumen)';
$string['requirepasswordmessage'] = 'Para intentar este examen Usted necesita conocer la contraseña del examen';
$string['requireqtypeordering'] = 'El módulo de actividad Reader no puede ser instalado o actualizado porque falta el tipo de pregunta Ordering (Ordenar). Por favor descargue el tipo de pregunta Ordering, póngalo en {$a}/question/type/ordering, y recargue la página';
$string['restoreattempts'] = 'Restaurar intentos seleccionados';
$string['restoredeletedattempt'] = 'Restaurar intento seleccionado';
$string['restrictlocalhost'] = 'Lo sentimos,; Usted no puede tomar exámenes en mreader.org desde su URL de localhost actual. Por favor cámbiese s una L. Please switch to a <a href="{$a}">URL accesible globalmente</a>.';
$string['returntocoursepage'] = 'Regresar a Página del Curso';
$string['returntoreports'] = 'Regresar a Reportes';
$string['returntostudentlist'] = 'Regresar a Lista de Estudiantes';
$string['review'] = 'Revisar';
$string['reviewthisattempt'] = 'Revisar sus respuestas para este intento';
$string['rowsperpage'] = 'Filas por página';
$string['run_readercron'] = 'Correr cron del Reader';
$string['run_readercron_desc'] = 'Correr el trabajo del cron para el módulo Reader.';
$string['safebrowsererror'] = 'Este examen ha sido configurado de forma tal que los estudiantes solamente pueden intentarlo usando el Navegador de Examen Seguro. Usted no puede intentarlo desde este navegador de Internet.';
$string['safebrowsernotice'] = 'Este examen ha sido configurado de forma tal que los estudiantes solamente pueden intentarlo usando el Navegador de Examen Seguro.';
$string['scanningattempts'] = 'Revisando intentos de exámenes Reader';
$string['search'] = 'Buscar';
$string['search_help'] = 'Para buscar un libro en particular, escriba un poco de texto contenido dentro del título del libro y elija el botón para \'Ir\'';
$string['searchforabook'] = 'Buscar un libro';
$string['sectionname'] = 'Nombre de sección';
$string['sectiontoseparate'] = 'añadir exámenes a secciones separadas por editor y nivel, añadiendo exámenes a las secciones existentes cuando estén disponibles';
$string['sectiontothebottom'] = 'añadir todos los exámenes al final del curso oculto en una nueva sección';
$string['sectiontothissection'] = 'añadir exámenes seleccionados a esta sección';
$string['sectiontypedefault'] = 'La sección(es) por defecto';
$string['sectiontypehidden'] = 'Una sección oculta';
$string['sectiontypelast'] = 'La última sección';
$string['sectiontypenew'] = 'Una nueva sección';
$string['sectiontypevisible'] = 'Una sección visible';
$string['seedetailsbelow'] = 'ver detalles debajo';
$string['select'] = 'Seleccionar';
$string['select_course'] = 'Seleccionar Curso';
$string['select_help'] = 'Elija los tipos de ítems que desea que sean seleccionados en la lista inferior';
$string['selectabook'] = 'Seleccionar un libro';
$string['selectalreadyexist'] = 'Seleccionado ya existe';
$string['selectedbookname'] = 'Nombre del libro seleccionado';
$string['selectipmask'] = 'Seleccionar máscara IP';
$string['selectlevel'] = 'Seleccionar nivel';
$string['selectpublisher'] = 'Seleccionar Casa Editorial';
$string['selectseries'] = 'Seleccionar Series';
$string['selectsomeattempts'] = 'Seleccionar uno o más intentos';
$string['selectsomebooks'] = 'Seleccionar uno o más libros';
$string['selectsomerows'] = 'Por favor revise algunas de las cajas en la columna seleccionada.';
$string['selectsomeusers'] = 'Seleccionar uno o más usuarios';
$string['selectthisquiz'] = 'Seleccionar este examen';
$string['sendemailtostudent'] = 'Mandar Email al estudiante';
$string['sendemailtoteacher'] = 'Mandar Email al profesor';
$string['sendmessage'] = 'Enviar mensaje a estudiantes afectados';
$string['sentemailmoodle'] = 'Se ha enviado un Email via Moodle a: {$a->email}';
$string['sentemailphp'] = 'Se ha enviado un Email via PHP mail a: {$a->email}';
$string['sentmessage'] = 'El mensaje se envió exitosamente a {$a} usuario(s)';
$string['separategroups'] = 'Grupos separados';
$string['separatelevels'] = 'Niveles separados';
$string['servererror'] = 'Mensaje del servidor: {$a}';
$string['serverpassword'] = 'Contraseña para exámenes Reader';
$string['serversettings'] = 'Descargar exámenes de Moodle Reader';
$string['serverurl'] = 'URL para exámenes de reader';
$string['serverusername'] = 'Nombre_de_usuario para exámenes Reader';
$string['setallowpromotion'] = 'Cambiar la configuración de la promoción para estudiantes seleccionados';
$string['setbookinstances'] = 'Seleccionar exámenes para hacerlos accesibles a estudiantes';
$string['setcurrentlevel'] = 'Cambiar nivel actual para estudiantes seleccionados';
$string['setdifficulty'] = 'Configurar dificultad del libro';
$string['setgenre'] = 'Configurar género';
$string['setgoal'] = 'Configurar objetivo';
$string['setgoals'] = 'Configurar objetivos';
$string['setgoals_description'] = 'En esta página Usted puede configurar las metas de lectura para estudiantes en niveles específicos de lectura, o en grupos específicos. Tenga en cuenta que las configuraciones para estudiantes individuales en las páginas de reporte anularán las configuraciones de esta página.';
$string['setlevel'] = 'Configurar nivel';
$string['setlevels'] = 'Configurar niveles';
$string['setlevels_description'] = 'En esta página Usted puede configurar los niveles de lectura para grupos de estudiantes. Tenga en cuenta que estas configuraciones sobrescribirán las configuraciones para estudiantes individuales en las páginas de reportes.';
$string['setmessage'] = 'Configurar Mensaje';
$string['setmessagetext'] = 'Texto del mensaje';
$string['setmessagetime'] = 'Mostrar hasta';
$string['setname'] = 'Configurar título de libro';
$string['setpoints'] = 'Configurar valor en puntos';
$string['setpromotiontime'] = 'Cambiar fecha y hora d promoción';
$string['setpublisher'] = 'Configurar casa editorial';
$string['setrates'] = 'Configurar tasas';
$string['setrates_description'] = 'En esta página Usted puede configurar las tasas de lectura para estudiantes en niveles de lectura específicos, o en grupos específicos.';
$string['setreadinggoal'] = 'Configurar objetivo de lectura';
$string['setreadinglevel'] = 'Configurar el nivel de lectura';
$string['setstartlevel'] = 'Cambiar el nivel inicial para estudiantes seleccionados';
$string['setstoplevel'] = 'Cambiar nivel máximo para los estudiantes seleccionados';
$string['settings'] = 'Configuraciones';
$string['setuniformgoalinpoints'] = 'Configurar meta uniforme en puntos';
$string['setuniformgoalinwords'] = 'Configurar meta uniforme en palabras';
$string['setwords'] = 'Configurar número de palabras';
$string['show'] = 'Mostrar';
$string['show_help'] = 'Elija los tipos de ítems que desea que sean mostrados en la lista inferior';
$string['showall'] = 'Mostrar Todo';
$string['showattempts'] = 'Mostrar intentos que coincidan con estas condiciones';
$string['showdeleted'] = 'Mostrar intentos borrados';
$string['showhidden'] = 'Mostrar libros ocultos';
$string['showhide'] = 'Mostrar/Ocultar';
$string['showhidebook'] = 'Mostrar u ocultar';
$string['showhidebooks'] = 'Actualizar la configuración mostrar/ocultar para libros seleccionados';
$string['showlevel'] = 'Mostrar Nivel';
$string['showpercentgrades'] = 'Mostrar calificaciones en porcentaje';
$string['showpoints'] = 'Mostrar solamente puntos';
$string['showpointsandwordcount'] = 'Mostrar tanto puntaje como número de palabras';
$string['showprogressbar'] = 'Mostrar barra de progreso';
$string['showreviewlinks'] = 'Mostrar enlaces para revisión';
$string['showwordcount'] = 'Mostrar solo el contador de palabras';
$string['skipline'] = 'Saltar línea: {$a}';
$string['skipped'] = 'Saltada';
$string['skipquizdownload'] = 'El examen "{$a->quizname}" ya existe en la sección {$a->sectionnum}, "{$a->sectionname}", de "{$a->coursename}", y ha sido saltado';
$string['sofar'] = 'hasta aquí';
$string['sort_strings'] = 'Ordenar cadenas de caracteres';
$string['sort_strings_desc'] = 'Ordenar las cadenas de texto usadas por el módulo Reader.';
$string['sortfields'] = 'Ordenar campos';
$string['startbookdetailed'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['startbooksummary'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['startdate'] = 'Fecha de inicio';
$string['startgroupsummary'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['startlevel'] = 'Iniciar nivel';
$string['startscan'] = 'Iniciar revisión';
$string['startuserdetailed'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['startusersummary'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['stoplevel'] = 'Nivel máximo';
$string['stoplevel_help'] = 'Los estudiantes no pueden ser promovidos automáticamente más allá de este nivel.';
$string['stoplevelforce'] = 'Aplicar este valor a TODOS los usuarios actuales';
$string['strfattempttime'] = '%Y %b %d (%a) %H:%M';
$string['strfattempttimeshort'] = '%Y/%m/%d %H:%M';
$string['strfdateshort'] = '%Y %b %d (%a)';
$string['strfdatetimeshort'] = '%Y %b %d (%a) %H:%M';
$string['strftimeshort'] = '%H:%M';
$string['studentmanagement'] = 'Gestión de Estudiantes';
$string['studentslevels'] = 'Cambiar niveles de Estudiante, Política para Promoción y Metas';
$string['studentuserid'] = 'ID del usuario estudiante';
$string['studentusername'] = 'Nombre_de_usuario del Estudiante';
$string['studentview'] = 'Vista del estudiante';
$string['subnetlength'] = 'Máscara IP';
$string['subnetwrong'] = 'Este examen solamente es accesible desde ciertos lugares, y esta computadora no está en la lista permitida.';
$string['summaryreportbybooktitle'] = 'Reporte Resumido por Título del Libro';
$string['summaryreportbyclassgroup'] = 'Reporte Resumido por Grupo de Clase';
$string['takequizfor'] = 'Tomar el examen para "{$a}"';
$string['takethisquiz'] = 'Tomar este examen';
$string['targetcategory'] = 'Categoría destino';
$string['targetcategory_help'] = 'La categoría del curso que contiene el curso dentro del cual Usted desea descargar los exámenes para los libros seleccionados.';
$string['targetcourse'] = 'Curso destino';
$string['targetsection'] = 'Sección destino';
$string['termtype'] = 'Período/Semestre';
$string['therehavebeennonewquizzesorupdates'] = 'No se han añadido exámenes nuevos ni actualizaciones al banco de preguntas de MoodleReader desde la vez anterior que lo revisó.';
$string['thisattempt'] = 'este intento';
$string['thisblockunavailable'] = 'Este bloque actualmente no está disponible para este estudiante';
$string['thislevel'] = 'Exámenes al nivel actual';
$string['thislevel_help'] = 'El número de exámenes al nivel de lectura actual que un estudiante debe de pasar para que sea promovido al siguiente nivel de lectura. Tenga en cuenta que solamente los exámenes pasados desde la promoción más reciente cuentan para la siguiente promoción.';
$string['thisterm'] = 'este período (semestre)';
$string['timefinish'] = 'Tiempo terminado';
$string['timeleft'] = 'Tiempo restante';
$string['timestart'] = 'Tiempo iniciado';
$string['to'] = 'hasta';
$string['tools'] = 'Herramientas';
$string['totalpoints'] = 'Total de puntos';
$string['totalpointsallterms'] = 'Puntaje total (todos los períodos)';
$string['totalpointsgoal'] = 'Meta de palabras/puntos';
$string['totalpointsgoal_help'] = 'El número total de palabras/puntos que se espera que acumulen los estudiantes en el período actual.';
$string['totalpointsthisterm'] = 'Puntaje total (este período)';
$string['totalwords'] = 'Total de palabras';
$string['totalwordsallterms'] = 'Total de palabras (todos los períodos)';
$string['totalwordsthisterm'] = 'Total de palabras (este período)';
$string['wordsorpoints'] = 'Mostrar palabras o puntos';
