<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'ar', version '4.2'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'إنني أفهم اتفاقية معالجة البيانات وأقبل بها';
$string['activityoverview'] = 'لديك جلسات قادمة لغرف اجتماعات BBB';
$string['bbbduetimeoverstartingtime'] = 'وقت إغلاق هذا النشاط ينبغي أن يكون بعد تاريخ بدئه.';
$string['bbbdurationwarning'] = 'أقصى مدة لهذه الجلسة هي %duration% دقيقة.';
$string['bbbrecordallfromstartwarning'] = 'يتم تسجيل هذه الجلسة من البداية.';
$string['bbbrecordwarning'] = 'قد يتم تسجيل هذه الجلسة.';
$string['bigbluebuttonbn'] = 'غرف اجتماعات BBB';
$string['bigbluebuttonbn:addinstance'] = 'إضافة غرفة جديدة من BBB';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'إنشاء مثيلات من الجلسات المباشرة';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'إنشاء مثيلات ذات إمكانيات التسجيل';
$string['bigbluebuttonbn:deleterecordings'] = 'حذف التسجيلات';
$string['bigbluebuttonbn:importrecordings'] = 'استيراد التسجيلات';
$string['bigbluebuttonbn:join'] = 'الانضمام إلى غرفة اجتماعات BBB';
$string['bigbluebuttonbn:managerecordings'] = 'إدارة التسجيلات';
$string['bigbluebuttonbn:protectrecordings'] = 'حماية التسجيلات';
$string['bigbluebuttonbn:publishrecordings'] = 'نشر التسجيلات';
$string['bigbluebuttonbn:unprotectrecordings'] = 'إلغاء حماية التسجيلات';
$string['bigbluebuttonbn:unpublishrecordings'] = 'إلغاء نشر التسجيلات';
$string['bigbluebuttonbn:view'] = 'معاينة غرفة BBB';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'معاينة كل صيغ التسجيل';
$string['bigbluebuttondisablednotification'] = 'لقد تم تعطيل وحدة نشاط BigBlueButton ونشاطات المقررات المتعلقة به لم تعد متاحة. قبل إعادة تمكين هذه الإضافة، يرجى التأكد من أنك قد قرأت  ووافقت على <a href="{$a}" target="_blank">اتفاقية معالجة البيانات</a> مع شركة Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'وحدة نشاط BBB معطلة.';
$string['cachedef_currentfetch'] = 'بيانات لاستعراض أي تسجيلات تم جلبها مؤخرًا.';
$string['cachedef_recordings'] = 'البيانات الوصفية للتسجيل';
$string['cachedef_serverinfo'] = 'معلومات المخدم البعيد';
$string['cachedef_validatedurls'] = 'خبء عمليات التحقق من عناوين الروابط';
$string['calendarstarts'] = '{$a} مجدول لغرض';
$string['cannotperformaction'] = 'يتعذر القيام بإجراء {$a} لهذا التسجيل';
$string['completionattendance'] = 'ينبغي على الطالب حضور الاجتماع من أجل:';
$string['completionattendance_desc'] = 'أدخل وابقَ في الغرفة لمدة {$a} من الدقائق على الأقل.';
$string['completionattendance_event_desc'] = 'قام الطالب بدخول الغرفة والبقاء في جلستها لمدة {$a} من الدقائق على الأقل';
$string['completionattendancegroup'] = 'تتطلب الحضور';
$string['completionattendancegroup_help'] = 'حضور الاجتماع لمدة (س) من الدقائق مطلوب للإكمال.';
$string['completionengagement_desc'] = 'الانخراط في النشاطات خلال الاجتماع.';
$string['completionengagementchats'] = 'المحادثات';
$string['completionengagementchats_desc'] = 'شارك في {$a} من المحادثات.';
$string['completionengagementchats_event_desc'] = 'قد أثار {$a} من المحادثات';
$string['completionengagementemojis'] = 'الرموز التعبيرية';
$string['completionengagementemojis_desc'] = 'تغيير رمزه التعبيري {$a} من المرات.';
$string['completionengagementemojis_event_desc'] = 'قد غير رموزه التعبيرية {$a} مرات';
$string['completionengagementgroup'] = 'تتطلب المشاركة';
$string['completionengagementgroup_help'] = 'المشاركة النشطة خلال الجلسة مطلوبة للإكمال.';
$string['completionengagementpollvotes'] = 'أصوات الاستبيان';
$string['completionengagementpollvotes_desc'] = 'التصويت في الاستطلاعات {$a} من المرات.';
$string['completionengagementpollvotes_event_desc'] = 'قد أجاب على {$a} من تصويتات الاستطلاعات';
$string['completionengagementraisehand'] = 'يتطلب رفع اليد';
$string['completionengagementraisehand_desc'] = 'قد رفع يده {$a} من المرات.';
$string['completionengagementraisehand_event_desc'] = 'قد رفع اليد {$a} من المرات';
$string['completionengagementtalks'] = 'الحديث';
$string['completionengagementtalks_desc'] = 'تحدث {$a} مرات';
$string['completionengagementtalks_event_desc'] = 'قد أثار {$a} من الأحاديث';
$string['completionupdatestate'] = 'حالة تحديث الإكمال';
$string['completionvalidatestate'] = 'تحقق من الإكمال';
$string['completionvalidatestatetriggered'] = 'تم تشغيل التحقق من الإكمال.';
$string['completionview'] = 'يتطلب المعاينة';
$string['completionview_desc'] = 'على الطالب معاينة الغرفة لإكماله.';
$string['completionview_event_desc'] = 'قد عاين صفحة الغرفة.';
$string['config_checksum_algorithm'] = 'خوارزمية اختبار صحة BigBlueButton';
$string['config_checksum_algorithm_description'] = 'إن SHA1 تتوافق مع المخدمات الأقدم. إن SHA256 و SHA512 أكثر أمانًا. إن SHA512 متوافقة مع FIPS 140-2).';
$string['config_default_messages'] = 'الرسائل الافتراضية';
$string['config_default_messages_description'] = 'ضبط إفتراضيات الرسائل للنشاطات';
$string['config_disablecam_default'] = 'تعطيل كامرة الويب مُمَكَّن إفتراضيًا';
$string['config_disablecam_default_description'] = 'عند تمكينه، سيتم تعطيل كامرات الويب.';
$string['config_disablecam_editable'] = 'تعطيل كامرة الويب يمكن تحريره';
$string['config_disablecam_editable_description'] = 'تعطيل كامرة الويب إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_disablemic_default'] = 'تعطيل اللاقطة مُمَكَّن إفتراضيًا';
$string['config_disablemic_default_description'] = 'عند تمكينه، سيتم تعطيل اللاقطات.';
$string['config_disablemic_editable'] = 'تعطيل اللاقطة يمكن تحريره';
$string['config_disablemic_editable_description'] = 'تعطيل اللاقطة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_disablenote_default'] = 'تعطيل الملاحظات المشتركة مُمَكَّن إفتراضيًا';
$string['config_disablenote_default_description'] = 'عند تمكينه، سيتم تعطيل الملاحظات المشتركة.';
$string['config_disablenote_editable'] = 'تعطيل الملاحظات المشتركة يمكن تحريره';
$string['config_disablenote_editable_description'] = 'تعطيل الملاحظات المشتركة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_disableprivatechat_default'] = 'تعطيل المحادثة الخاصة مُمَكَّن إفتراضيًا';
$string['config_disableprivatechat_default_description'] = 'عند تمكينه، سيتم تعطيل المحادثة الخاصة.';
$string['config_disableprivatechat_editable'] = 'تعطيل المحادثة الخاصة يمكن تحريره';
$string['config_disableprivatechat_editable_description'] = 'تعطيل المحادثة الخاصة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_disablepublicchat_default'] = 'تعطيل المحادثة العامة مُمَكَّن إفتراضيًا';
$string['config_disablepublicchat_default_description'] = 'عند تمكينه، سيتم تعطيل المحادثة العامة.';
$string['config_disablepublicchat_editable'] = 'تعطيل المحادثة العامة يمكن تحريره';
$string['config_disablepublicchat_editable_description'] = 'تعطيل المحادثة العامة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_dpa_note'] = 'ملاحظة: من أجل تلبية مستلزمات حماية بياناتك، تأكد من قراءة اتفاقية معالجة البيانات التي يعمل بها مزود الخدمة قبل التعامل معه لتشغيل هذا الملحق. بالنسبة إلى خدمة BigBlueButton الافتراضية المجانية، يرجى قراءة <a href="{$a}" target="_blank">اتفاقية معالجة البيانات عند Blindside Networks</a>. يرجى التشاور مع خبراء الحفاظ على الخصوصية الذين تتعامل معهم لأخذ النصح.';
$string['config_experimental_features'] = 'المزايا التجريبية';
$string['config_experimental_features_description'] = 'التهيئة للمزايا التجريبية.';
$string['config_extended_capabilities'] = 'الإمكانات الموسعة';
$string['config_extended_capabilities_description'] = 'التهيئة للإمكانات الموسعة عندما يقدمها مخدم غرف اجتماعات BBB.';
$string['config_general'] = 'الإعدادات العامة';
$string['config_general_description'] = 'هذه الإعدادات مستعملة دائماً.';
$string['config_guestaccess_enabled'] = 'وصول الضيوف الخارجيين.';
$string['config_guestaccess_enabled_description'] = 'السماح للمستخدمين الذين لا يمتلكون حسابات في مودل بالوصول إلى غرفة الاجتماع.';
$string['config_hideuserlist_default'] = 'إخفاء قائمة المستخدمين مُمَكَّن إفتراضيًا';
$string['config_hideuserlist_default_description'] = 'عند تمكينه، ستكون قائمة المستخدمين في الجلسة مخفية.';
$string['config_hideuserlist_editable'] = 'إخفاء قائمة المستخدمين يمكن تحريره';
$string['config_hideuserlist_editable_description'] = 'إخفاء قائمة المستخدمين إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_importrecordings'] = 'استيراد التسجيلات';
$string['config_importrecordings_description'] = 'هذه الإعدادات متخصصة بالميزة.';
$string['config_importrecordings_enabled'] = 'استيراد التسجيلات مُمَكَّن';
$string['config_importrecordings_enabled_description'] = 'عند تمكينه مع تمكين ميزة التسجيل، سيكون ممكنًا استيراد التسجيلات من مقررات دراسية مختلفة إلى النشاط.';
$string['config_importrecordings_from_deleted_enabled'] = 'استيراد التسجيلات من نشاطات محذوفة مُمَكَّن';
$string['config_importrecordings_from_deleted_enabled_description'] = 'عند تمكين ميزة التسجيل والاستيراد ، فمن الممكن استيراد التسجيلات من الأنشطة التي لم تعد موجودة في المقرر.';
$string['config_locksettings'] = 'التهيئة لإعدادات التأمين';
$string['config_locksettings_description'] = 'هذه الإعدادات تُمكن أو تُعطل الخيارات في واجهة المستخدم لإعدادات التأمين، وكذلك تعرِّف القيم الافتراضية لتلك الخيارات.';
$string['config_meetingevents_enabled'] = 'تسجيل الجلسات المباشرة';
$string['config_meetingevents_enabled_description'] = 'عند تمكينه، الجلسات المباشرة ستتم معالجتها بعد انتهاء الجلسة. هذه الميزة مطلوبة من أجل إكمال النشاط وهي عاملة فقط عندما تكون لمخدم غرف اجتماعات BBB إمكانية معالجة نصوص post_events.';
$string['config_muteonstart'] = 'الكتم عند البدء';
$string['config_muteonstart_default'] = 'الكتم عند البدء مُمَكَّن إفتراضيًا';
$string['config_muteonstart_default_description'] = 'عند تمكينه، الجلسة ستكون مكتومة عند بدئها.';
$string['config_muteonstart_description'] = 'هذه الإعدادات تُمكن أو تُعطل الخيارات في واجهة المستخدم، وكذلك تعريف القيم الافتراضية لتلك الخيارات.';
$string['config_muteonstart_editable'] = 'الكتم عند البدء يمكن تحريره';
$string['config_muteonstart_editable_description'] = 'يمكن تحرير كتم الصوت عند البدء إفتراضيًا عند إضافة المثيل أو تحديثه.';
$string['config_participant'] = 'المشاركون';
$string['config_participant_description'] = 'هذه الإعدادات تُعرِّف الدور الافتراضي للمشاركين.';
$string['config_participant_moderator_default'] = 'مشرف';
$string['config_participant_moderator_default_description'] = 'تسعمل هذه القاعدة إفتراضيًا عند إضافة غرفة جديدة.';
$string['config_poll_interval'] = 'مدة الاستطلاع (بالثواني) لتحديث حالة الغرفة';
$string['config_poll_interval_description'] = 'مدة الاستطلاع ينبغي أن تكون ثانيتين على الأقل. عند الضرورة، يمكنك تخفيف الحمل على المخدم البعيد عبر زيادة المدة.';
$string['config_presentation_default'] = 'الملف الافتراضي للعرض التقديمي';
$string['config_presentation_default_description'] = 'يمكن توفير الملف المستعمل في كل الغرف.';
$string['config_preuploadpresentation'] = 'الرفع المسبق للعرض التقديمي';
$string['config_preuploadpresentation_description'] = 'تعمل هذه الإعدادات على تمكين أو تعطيل الخيارات في واجهة المستخدم وكذلك تحديد القيم الافتراضية لهذه الخيارات. تعمل الميزة فقط إذا كان BBB قادرًا على الوصول إلى مخدم مودل.';
$string['config_preuploadpresentation_editable'] = 'التحميل المسبق للعرض قابل للتحرير';
$string['config_preuploadpresentation_editable_description'] = 'ميزة التحميل المسبق للعرض قابلة للتعديل في واجهة المستخدم عند إضافة أو تحديث الغرفة أو المؤتمر.';
$string['config_profile_picture_enabled'] = 'إظهار صور الملفات الشخصية';
$string['config_profile_picture_enabled_description'] = 'هل ينبغي إظهار الملفات الشخصية للمشاركين في جلسات BigBlueButton؟';
$string['config_recording'] = 'التسجيل';
$string['config_recording_all_from_start_default'] = 'بدء التسجيل منذ بدء الجلسة';
$string['config_recording_all_from_start_default_description'] = 'هل ينبغي تمكين الإعداد \'بدء التسجيل منذ بدء الجلسة\' إفتراضيًا عند إضافة غرفة BBB جديدة؟';
$string['config_recording_all_from_start_editable'] = 'التسجيل عند البدء يمكن تحريره';
$string['config_recording_all_from_start_editable_description'] = 'هل ينبغي للإعداد \'التسجيل عند البدء\' أن يكون قابلاً للتحرير في إعدادات نشاط BBB؟';
$string['config_recording_default'] = 'ميزة التسجيل مُمَكَّنة إفتراضيًا';
$string['config_recording_default_description'] = 'هل ينبغي للإعداد \'يمكن تسجيل الجلسة \' أن يكون مُمَكَّنًا عند إضافة غرفة BBB جديدة؟';
$string['config_recording_description'] = 'هذه الإعدادات متخصصة بالميزة';
$string['config_recording_editable'] = 'تسجيل الجلسة يمكن تحريره';
$string['config_recording_editable_description'] = 'هل ينبغي للإعداد \'تسجيل الجلسة\' أن يكون قابلاً للتحرير في إعدادات نشاط BBB؟';
$string['config_recording_hide_button_default'] = 'زر إخفاء التسجيل';
$string['config_recording_hide_button_default_description'] = 'عند تأشيره، زر التسجيل سيتم إخفاؤه.';
$string['config_recording_hide_button_editable'] = 'إخفاء زر التسجيل يمكن تحريره';
$string['config_recording_hide_button_editable_description'] = 'هل ينبغي للإعداد \'إخفاء زر التسجيل\' أن يكون قابلاً للتحرير في إعدادات نشاط BBB؟';
$string['config_recording_protect_editable'] = 'حالة التسجيلات المحمية يمكن تحريرها';
$string['config_recording_protect_editable_description'] = 'عند تأشيره، ستتضمن الواجهة خيارًا لحماية/إلغاء حماية التسجيلات.';
$string['config_recording_refresh_period'] = 'مهلة تنشيط التسجيل (بالثواني)';
$string['config_recording_refresh_period_description'] = 'ما هو تواتر استقدام البيانات من مخدم Bigbluebutton لتحديث المعلومات لدى المستخدمين بالنسبة إلى التسجيل؟';
$string['config_recording_safe_formats'] = 'يمكن معاينة كل صيغ التسجيل من قبل الجميع';
$string['config_recording_safe_formats_description'] = 'إختر الصيغ التي يمكن للجميع معاينتها.
كل الصيغ الأخرى قابلة للمعاينة حصرًا من قبل المعلمين وغيرهم من المستخدمين الذين لهم الإمكانية mod/bigbluebuttonbn:viewallrecordingformats والإمكانية
 mod/bigbluebuttonbn:managerecordings.';
$string['config_recordingready_enabled'] = 'إرسال إشعار جهوزية التسجيل';
$string['config_recordingready_enabled_description'] = 'عند تمكينه، سيتم إرسال إشعار عندما يصير التسجيل جاهزاً. هذه الميزة تتطلب تمكين النص البرمجي post_publish_recording_ready_callback في مخدم BBB.';
$string['config_recordings'] = 'إظهار التسجيلات';
$string['config_recordings_asc_sort'] = 'ترتيب التسجيلات ترتيباً تصاعدياً';
$string['config_recordings_asc_sort_description'] = 'التسجيلات مرتبة حسب تواريخها، إما تصاعدياً أو تنازلياً (التسجيلات الأحدث أولاً).';
$string['config_recordings_deleted_default'] = 'تضمين التسجيلات من النشاطات المحذوفة مُمَكَّن إفتراضيًا';
$string['config_recordings_deleted_default_description'] = 'عند تمكينه، سيضم جدول التسجيل تسجيلات عائدة إلى أي نشاطات قد تكون محذوفة في حينها.';
$string['config_recordings_deleted_editable'] = 'تضمين التسجيلات من النشاطات المحذوفة يمكن تحريره';
$string['config_recordings_deleted_editable_description'] = 'تضمين التسجيلات من النشاطات المحذوفة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحريره.';
$string['config_recordings_description'] = 'هذه الإعدادات متخصصة بالميزة';
$string['config_recordings_general'] = 'إظهار إعدادات التسجيل';
$string['config_recordings_general_description'] = 'تستعمل هذه الإعدادات فقط عند إظهار التسجيلات';
$string['config_recordings_imported_default'] = 'إظهار الروابط المستوردة فقط مُمَكَّن إفتراضيًا';
$string['config_recordings_imported_default_description'] = 'عند تمكينه، جدول التسجيل سيتضمن الروابط المستوردة للتسجيلات فقط.';
$string['config_recordings_imported_editable'] = 'إظهار الروابط المستوردة فقط يمكن تحريره';
$string['config_recordings_imported_editable_description'] = 'إظهار الروابط المستوردة فقط إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_recordings_preview_default'] = 'المعاينة مُمَكَّنة إفتراضيًا';
$string['config_recordings_preview_default_description'] = 'عند تمكينه، سيتضمن الجدول معاينة للعرض التقديمي.';
$string['config_recordings_preview_editable'] = 'يمكن تحرير ميزة المعاينة';
$string['config_recordings_preview_editable_description'] = 'يمكن تحرير ميزة المعاينة عند إضافة النشاط أو تحديثه.';
$string['config_scheduled'] = 'الجلسات المجدولة';
$string['config_scheduled_description'] = 'تحدد هذه الإعدادات السلوك الافتراضي للجلسات المجدولة.';
$string['config_scheduled_pre_opening'] = 'متاح قبل وقت الفتح';
$string['config_scheduled_pre_opening_description'] = 'الوقت بالدقائق الذي تكون فيه الجلسة متاحة للوصول إليها قبل موعد فتحها.';
$string['config_server_url'] = 'عنوان الرابط لمخدم غرف اجتماعات BBB';
$string['config_server_url_description'] = 'معطيات الدخول الافتراضية لميزة <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">خدمة BigBlueButton مجانية لمودل (يُفتح بنافذة جديدة)</a> مقدم من قبل Blindside Networks مع التقييدات الآتية:
<ol>
<li>أقصى مدة لكل جلسة هي 60 دقيقة</li>
<li>أقصى عدد من المستخدمين المتزامنين لكل جلسة هو 25</li>
<li>تنتهي صلاحية التسجيلات بعد (7) سبعة أيام ولا يمكن تنزيلها</li>
<li>كامرات الويب للطلاب مرئية فقط من جانب المشرف.</li>
</ol>';
$string['config_shared_secret'] = 'السر المشارك لـ BigBlueButton';
$string['config_shared_secret_description'] = 'سر الأمان لمخدم غرف اجتماعات BBB. هذا السر الافتراضي هو لمخدم غرف اجتماعات BBB المجاني الذي توفره Blindside Networks.';
$string['config_uidelegation_enabled'] = 'تفويض واجهة المستخدم مُمَكَّن';
$string['config_uidelegation_enabled_description'] = 'تعمل هذه الإعدادات على تمكين أو تعطيل تفويض واجهة المستخدم لمخدم غرف اجتماعات BBB.';
$string['config_userlimit'] = 'تحديد المستخدمين';
$string['config_userlimit_default'] = 'تحديد المستخدمين مُمَكَّن إفتراضيًا';
$string['config_userlimit_default_description'] = 'عدد المستخدمين المسموح لهم في الجلسة إفتراضيًا عند إضافة الغرفة الجديدة. إذا تم جعله 0، لن يكون هناك تحديد لعددهم.';
$string['config_userlimit_description'] = 'هذه الإعدادات تقوم بتمكين الخيارات أو تعطيلها في واجهة المستخدم كما تُعرِّف القيم الافتراضية لتلك الخيارات.';
$string['config_userlimit_editable'] = 'ميزة تحديد المستخدمين يمكن تحريرها';
$string['config_userlimit_editable_description'] = 'تحديد عدد المستخدمين إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحريره.';
$string['config_voicebridge'] = 'الجسر الصوتي';
$string['config_voicebridge_description'] = 'هذه الإعدادات تقوم بتمكين الخيارات أو تعطيلها في واجهة المستخدم كما تُعرِّف القيم الافتراضية لتلك الخيارات.';
$string['config_voicebridge_editable'] = 'الجسر الصوتي للمؤتمر يمكن تحريره';
$string['config_voicebridge_editable_description'] = 'يمكن تعيين رقم الجسر الصوتي الثابت الخاص بالمؤتمر بشكل دائم إلى غرفة معينة. عند تعيينه، لا يمكن استعمال هذا الرقم مع أي غرفة أخرى.';
$string['config_waitformoderator'] = 'إنتظار المشرف';
$string['config_waitformoderator_cache_ttl'] = 'مدة استبقاء الخبء لميزة انتظار المشرف (بالثواني)';
$string['config_waitformoderator_cache_ttl_description'] = 'لدعم عدد كبير من العملاء، يستعمل هذه الإضافة الخبء. يحدد هذا العامل الوقت الذي سيتم فيه الاحتفاظ بالخبء قبل إرسال الطلب التالي إلى مخدم غرف اجتماعات BBB.';
$string['config_waitformoderator_default'] = 'إنتظار المشرف مُمَكَّن إفتراضيًا';
$string['config_waitformoderator_default_description'] = 'هل ينبغي تمكين الإعداد \'انتظار المشرف\' إفتراضيًا عند إضافة غرفة BBB جديدة؟';
$string['config_waitformoderator_description'] = 'هذه الإعدادات متخصصة بالميزة';
$string['config_waitformoderator_editable'] = 'ميزة انتظار المشرف يمكن تحريرها';
$string['config_waitformoderator_editable_description'] = 'هل ينبغي للإعداد \'انتظار المشرف\' أن يكون قابلاً للتحرير في إعدادات نشاط BBB؟';
$string['config_waitformoderator_ping_interval'] = 'مدة استغراق إرسال ping لميزة انتظار المشرف (بالثواني)';
$string['config_waitformoderator_ping_interval_description'] = 'ما هو تواتر التحقق من المخدم بأن مشرف الجلسة قد دخل إلى غرفتها؟';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'يستعمل BBB الملف config.php مع متغير عام تم إهماله. يرجى تحويل الملف لأنه لن يتم دعمه في الإصدارات المستقبلية.';
$string['config_warning_curl_not_installed'] = 'هذه الميزة تتطلب تنصيب الامتداد CURL في php وتمكينه. يمكن الوصول إلى الإعدادات فقط عند تلبية هذا الشرط.';
$string['config_welcome_default'] = 'رسالة الترحيب الافتراضية';
$string['config_welcome_default_description'] = 'يتم عرض رسالة ترحيبية عند دخول المشاركين إلى الغرفة. إذا تُرك الحقل فارغًا، ستُعرض الرسالة الترحيبية المعدة مسبقًا في مخدم BBB.';
$string['config_welcome_editable'] = 'يمكن للمعلمين تعديل رسالة الترحيب الافتراضية';
$string['config_welcome_editable_description'] = 'يمكن تحرير رسالة الترحيب عند إضافة المثيل أو تحديثه';
$string['dpainfonotsigned'] = 'قبل تمكين هذا الملحق، ينبغي عليك تأكيد قراءتك وقبولك لـ <a href="{$a}">اتفاقية معالجة البيانات لـ Blindside Networks</a>.';
$string['enablingbigbluebutton'] = 'تمكين وحدة نشاط BBB';
$string['enablingbigbluebuttondpainfo'] = 'من أجل تلبية مستلزمات حماية بياناتك، فقبل تمكين هذا الملحق، تأكد من قراءة <a href="{$a}" target="_blank">اتفاقية معالجة البيانات من Blindside Networks Inc.</a> والموافقة عليها.<br/>
يرجى التشاور مع خبراء الحفاظ على الخصوصية الذين تتعامل معهم لأخذ النصح.';
$string['end_session_confirm'] = 'هل أنت متأكد من رغبتك في إنهاء الجلسة؟';
$string['end_session_confirm_title'] = 'أحقًا تنهي الجلسة؟';
$string['end_session_notification'] = 'لقد تم إنهاء الجلسة.';
$string['ends_at'] = 'ينتهي';
$string['event_activity_created'] = 'نشاط تم إنشاؤه';
$string['event_activity_deleted'] = 'نشاط تم حذفه';
$string['event_activity_updated'] = 'نشاط تم تحديثه';
$string['event_live_session'] = 'حدث الجلسة المباشرة';
$string['event_meeting_created'] = 'اجتماع تم إنشاؤه';
$string['event_meeting_ended'] = 'اجتماع  تم إنهاؤه قسرًا';
$string['event_meeting_joined'] = 'اجتماع تم الانضمام إليه';
$string['event_meeting_left'] = 'اجتماع تمت مغادرته';
$string['event_recording_deleted'] = 'تسجيل تم حذفه';
$string['event_recording_edited'] = 'تسجيل تم تعديله';
$string['event_recording_imported'] = 'تسجيل تم استيراده';
$string['event_recording_protected'] = 'تسجيل تمت حمايته';
$string['event_recording_published'] = 'تسجيل تم نشره';
$string['event_recording_unprotected'] = 'تسجيل تم إلغاء حمايته';
$string['event_recording_unpublished'] = 'تسجيل تم إلغاء نشره';
$string['event_recording_viewed'] = 'تسجيل تمت معاينته';
$string['event_unknown'] = 'حدث غير معلوم';
$string['general_error_cannot_create_meeting'] = 'يتعذرإنشاء الجلسة.';
$string['general_error_cannot_get_recordings'] = 'يتعذرإحضار التسجيلات.';
$string['general_error_no_answer'] = 'استجابة فارغة. لطفًا تحقق من عنوان رابط مخدم BigBlueButton وتأكد من كونه شغال فعلاً.';
$string['general_error_not_allowed_to_create_instances'] = 'لا يسمح للمستخدم بإنشاء أي نوع من المثيلات.';
$string['general_error_not_found'] = 'نشاط BigBlueButton ذي المُعرَّف {$a} غير موجود.';
$string['general_error_unable_connect'] = 'غير قادر على الاتصال. يرجى التحقق من عنوان رابط مخدم غرف اجتماعات BBB والتحقق لمعرفة ما إذا كان المخدم قيد التشغيل.
التفاصيل: {$a}';
$string['guest_invitation_full_message'] = 'مرحبًا،
<p>لقد تمت دعوتك إلى جلسة BigblueButton التي بعنوان <strong>{$a->name}</strong> ضمن المساق {$a->course_fullname}.</p>
<p>الرابط: {$a->guestjoinurl}<br/>
<p>كلمة المرور: {$a->guestpassword}</p>
<p>إن كنت بحاجة إلى مساعدة، يرجى التواصل مع {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'مرحبًا،

لقد تمت دعوتك إلى جلسة BigblueButton التي بعنوان {$a->name} ضمن المساق {$a->course_fullname}.

الرابط: {$a->guestjoinurl}
كلمة المرور: {$a->guestpassword}

إن كنت بحاجة إلى مساعدة، يرجى التواصل مع {$a->sender}.';
$string['guest_invitation_subject'] = 'الدعوة: {$a->name} وهي جلسة ضمن المقرر {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'تعذر العثور على النشاط.';
$string['guestaccess_add'] = 'إضافة الضيوف';
$string['guestaccess_add_no_id'] = 'لم يتم تقديم مُعرَّف مثيل BigblueButton.';
$string['guestaccess_copy_link'] = 'نسخ الرابط';
$string['guestaccess_copy_password'] = 'نسخ كلمة المرور';
$string['guestaccess_emails'] = 'عناوين البريد الالكتروني للضيوف';
$string['guestaccess_emails_help'] = 'قائمة عناوين البريد الالكتروني، مفصولة بفوارز';
$string['guestaccess_emails_invalidemail'] = 'عنوان البريد الالكتروني {$a} غير صالح.';
$string['guestaccess_feature_disabled'] = 'وصول الضيوف معطل.';
$string['guestaccess_invite_failure'] = 'وقع الخطأ {$a->errors} عند دعوة {$a->emails}.';
$string['guestaccess_invite_success'] = 'سيتم إرسال دعوة إلى {$a->emails}.';
$string['guestaccess_join_meeting'] = 'الانضمام إلى الاجتماع';
$string['guestaccess_meeting_invalid_password'] = 'كلمة المرور غير صحيحة.';
$string['guestaccess_meeting_link'] = 'رابط الاجتماع';
$string['guestaccess_meeting_not_started'] = 'الاجتماع لم يبدأ بعد. ترجى المعاودة في وقت لاحق.';
$string['guestaccess_meeting_password'] = 'كلمة مرور الاجتماع';
$string['guestaccess_password'] = 'كلمة المرور';
$string['guestaccess_title'] = 'إضافة ضيوف إلى هذا الاجتماع';
$string['guestaccess_username'] = 'اسم المستخدم للضيف';
$string['index_confirm_end'] = 'هل ترغب في إنهاء الجلسة؟';
$string['index_disabled'] = 'معطلة';
$string['index_enabled'] = 'مُمَكَّنة';
$string['index_ending'] = 'إنهاء الجلسة ... من فضلك إنتظر';
$string['index_error_bbtn'] = 'مُعرَّف غرف اجتماعات BBB {$a} غير صحيح';
$string['index_error_checksum'] = 'وقع خطأ عند فحص السلامة. يرجى التحقق من أنك قد أدخلت السر الصحيح.';
$string['index_error_forciblyended'] = 'لا يمكن الانضمام إلى الجلسة لأنها قد تم إنهاؤها يدويًا.';
$string['index_error_noinstances'] = 'لا توجد مثيلات من غرف BBB';
$string['index_error_unable_display'] = 'يتعذر عرض الجلسات. يرجى التحقق من عنوان الرابط لمخدم BBB والتحقق لمعرفة ما إذا كان المخدم قيد التشغيل.';
$string['index_heading'] = 'غرف BBB';
$string['index_heading_actions'] = 'الإجراءات';
$string['index_heading_group'] = 'المجموعة';
$string['index_heading_moderator'] = 'مشرفون';
$string['index_heading_name'] = 'الغرفة';
$string['index_heading_recording'] = 'التسجيل';
$string['index_heading_users'] = 'المستخدمون';
$string['index_heading_viewer'] = 'مشاهدون';
$string['indicator:cognitivedepth'] = 'BBB معرفيًا';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصل إليها الطالب في نشاط BBB.';
$string['indicator:socialbreadth'] = 'BBB إجتماعيًا';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصل إليه الطالب في نشاط BBB.';
$string['instance_type_default'] = 'الغرفة مع التسجيلات';
$string['instance_type_recording_only'] = 'التسجيلات فقط';
$string['instance_type_room_only'] = 'الغرفة فقط';
$string['instanceprofilewithoutrecordings'] = 'نسخة المثيل هذه لا يمكنها عرض التسجيلات';
$string['messageprovider:instance_updated'] = 'تم تحديث جلسة BBB';
$string['messageprovider:recording_ready'] = 'تسجيل BBB جاهز للمعاينة';
$string['minute'] = 'دقيقة';
$string['minutes'] = 'دقائق';
$string['mod_form_block_general'] = 'العامة';
$string['mod_form_block_guestaccess'] = 'وصول الضيوف';
$string['mod_form_block_participants'] = 'الدور المعين في أثناء الجلسة الحية';
$string['mod_form_block_presentation'] = 'محتوى العرض';
$string['mod_form_block_presentation_default'] = 'المحتوى الافتراضي للعرض التقديمي';
$string['mod_form_block_record'] = 'إعدادات التسجيل';
$string['mod_form_block_recordings'] = 'معاينة التسجيل';
$string['mod_form_block_room'] = 'إعدادات الغرفة';
$string['mod_form_block_schedule'] = 'توقيت الجلسة';
$string['mod_form_field_closingtime'] = 'إغلاق';
$string['mod_form_field_conference_name'] = 'اسم الجلسة';
$string['mod_form_field_disablecam'] = 'تعطيل كاميرات الويب';
$string['mod_form_field_disablemic'] = 'تعطيل اللاقطات';
$string['mod_form_field_disablenote'] = 'تعطيل الملاحظات المشتركة';
$string['mod_form_field_disableprivatechat'] = 'تعطيل المحادثة الخاصة';
$string['mod_form_field_disablepublicchat'] = 'تعطيل المحادثة العامة';
$string['mod_form_field_duration'] = 'المدة الزمنية';
$string['mod_form_field_duration_help'] = 'سيؤدي تعيين مدة الاجتماع إلى تحديد أطول وقت يبقى فيه الاجتماع حياً قبل انتهاء التسجيل';
$string['mod_form_field_guestallowed'] = 'السماح بوصول الضيوف';
$string['mod_form_field_hideuserlist'] = 'إخفاء قائمة المستخدمين';
$string['mod_form_field_instanceprofiles'] = 'نوع المثيل';
$string['mod_form_field_instanceprofiles_help'] = 'إذا كان من المفترض تسجيل الجلسة، حدد \'الغرفة مع التسجيل\'، بخلافه \'الغرفة فقط\'. بعد تسجيل الجلسة، إذا لم يكن هناك المزيد من الجلسات، حدد \'التسجيلات فقط\'.';
$string['mod_form_field_intro'] = 'الوصف';
$string['mod_form_field_intro_help'] = 'وصف موجز للغرفة.';
$string['mod_form_field_mustapproveuser'] = 'انضمام الضيوف ينبغي قبوله من قبل المشرف';
$string['mod_form_field_muteonstart'] = 'إكتم الصوت عند البدء';
$string['mod_form_field_name'] = 'اسم الغرفة';
$string['mod_form_field_nosettings'] = 'لا يمكن تعديل أي إعدادات';
$string['mod_form_field_openingtime'] = 'فتح';
$string['mod_form_field_participant_add'] = 'إضافة المتكفل';
$string['mod_form_field_participant_bbb_role_moderator'] = 'مشرف';
$string['mod_form_field_participant_bbb_role_viewer'] = 'مشاهد';
$string['mod_form_field_participant_list'] = 'المتكفل';
$string['mod_form_field_participant_list_action_add'] = 'أضف';
$string['mod_form_field_participant_list_action_remove'] = 'إزالة';
$string['mod_form_field_participant_list_text_as'] = 'ينضم إلى الجلسة بمثابة';
$string['mod_form_field_participant_list_type_all'] = 'كل المستخدمين منضمون';
$string['mod_form_field_participant_list_type_owner'] = 'المالك';
$string['mod_form_field_participant_list_type_role'] = 'الدور';
$string['mod_form_field_participant_list_type_user'] = 'المستخدم';
$string['mod_form_field_record'] = 'الجلسة قد تُسجَّل';
$string['mod_form_field_recordallfromstart'] = 'سجِّل كل شيء من البداية';
$string['mod_form_field_recordhidebutton'] = 'إخفاء زر التسجيل';
$string['mod_form_field_recordings_deleted'] = 'تضمين التسجيلات من الأنشطة المحذوفة';
$string['mod_form_field_recordings_html'] = 'إظهار الجدول بصيغة html العادية';
$string['mod_form_field_recordings_imported'] = 'إظهار الروابط المستوردة فقط';
$string['mod_form_field_recordings_preview'] = 'إظهار استعراض التسجيل';
$string['mod_form_field_room_name'] = 'اسم الغرفة';
$string['mod_form_field_userlimit'] = 'محدد المستخدمين';
$string['mod_form_field_userlimit_help'] = 'الحد الأقصى لعدد المستخدمين المسموح به في الجلسة. إذا تم تعيين الحد على 0، فسيكون عدد المستخدمين غير محدود.';
$string['mod_form_field_voicebridge'] = 'الجسرالصوتي [####]';
$string['mod_form_field_voicebridge_format_error'] = 'خطأ في التنسيق. ينبغي أن تدخل رقماً من 1 حتى 9999.';
$string['mod_form_field_voicebridge_help'] = 'رقم بين 1 و 9999 على المشاركين إدخاله للانضمام إلى الجلسة الصوتية عند استعمال الاتصال الهاتفي. إذا كانت القيمة تساوي 0، فسيتم تجاهل رقم جسر الصوت الثابت وسيتم إنشاء رقم عشوائي من قبل BBB. سيسبق الرقم 7 الأرقام الأربعة المكتوبة.';
$string['mod_form_field_voicebridge_notunique_error'] = 'ليست قيمة فريدة. هذا الرقم مستعمل من قبل غرفة أخرى.';
$string['mod_form_field_wait'] = 'انتظر المشرف';
$string['mod_form_field_wait_help'] = 'هل ينبغي على المشاركين الانتظار حتى يدخل المشرف الجلسة قبل أن يتمكنوا من القيام بذلك؟';
$string['mod_form_field_welcome'] = 'رسالة الترحيب';
$string['mod_form_field_welcome_default'] = 'مرحبًا بك في%%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'تُعرض الرسالة الترحيبية عندما يدخل المشاركون الغرفة. عند ترك الحقل فارغًا، ستُعرض الرسالة الافتراضية المهيأة في مخدم BBB.';
$string['mod_form_locksettings'] = 'تأمين الإعدادات';
$string['modulename'] = 'BBB';
$string['modulename_help'] = 'إن BigBlueButton هو نظام اجتماعات ومؤتمرات عبر الويب مفتوح المصدر يدعم المشاركة المباشرة للصوت، الفيديو، المحادثة، الشرائح، مشاركة الشاشة، السبورة المتعددة المستخدمين، غرف الاستراحة، الاستطلاعات، والرسوم التعبيرية.

باستعمال BigBlueButton، يمكنك إنشاء غرفة لجلسات مثل الصفوف على الإنترنت، المكاتب الافتراضية أو المجموعات المتعاونة مع الطلاب البعيدين. يمكن تسجيل الجلسات لتشغيلها لاحقًا.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BBB';
$string['new_bigblubuttonbn_activities'] = 'نشاط BBB';
$string['nosuchinstance'] = 'ليس هناك مثيل كـ {$a->entity} بالمُعرَّف: {$a->id}';
$string['notification_instance_created_intro'] = 'لقد تم إنشاء غرفة BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_instance_created_small'] = 'لقد تم إنشاء غرفة BigBlueButton جديدة بالتسمية {$a->name}';
$string['notification_instance_created_subject'] = 'لقد تم إنشاء غرفة BigBlueButton جديدة';
$string['notification_instance_description'] = 'الوصف';
$string['notification_instance_end_date'] = 'تاريخ الإنهاء';
$string['notification_instance_name'] = 'العنوان';
$string['notification_instance_start_date'] = 'تاريخ البدء';
$string['notification_instance_updated_intro'] = 'تم تحديث غرفة BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_instance_updated_small'] = 'تم تحديث جلسة BigBlueButton {$a->name}.';
$string['notification_instance_updated_subject'] = 'تم تحديث غرفتك في BigBlueButton.';
$string['notification_recording_ready_html'] = 'هناك تسجيل متاح للجلسة في غرفة BBB <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'هناك تسجيل متاح للجلسة التي في غرفة BBB {$a->name}. إذهب إلى {$a->link} للوصول إلى رابط التسجيل.';
$string['notification_recording_ready_small'] = 'هناك تسجيل جديد متاح لغرفة BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'التسجيل متاح';
$string['pluginadministration'] = 'إدارة غرف اجتماعات BBB';
$string['pluginname'] = 'BBB';
$string['privacy:metadata:bigbluebutton'] = 'من أجل إنشاء جلسات غرف اجتماعات BBB والانضمام إليها، يجب تبادل بيانات المستخدم مع المخدم.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'الاسم الكامل للمستخدم الذي يصل إلى مخدم BBB.';
$string['privacy:metadata:bigbluebutton:userid'] = 'مُعرَّف المستخدم الذي يقوم بالوصول إلى مخدم BBB';
$string['privacy:metadata:bigbluebuttonbn'] = 'إعدادات جلسة BBB';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'قائمة القواعد التي تحدد أدوار المستخدمين في جلسة BBB. يمكن خزن مُعرَّف المستخدم نظرًا لكون الصلاحيات يمكن منحها للدور أو للمستخدم';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'يخزن الأحداث الناتجة عن استعمال الإضافة';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'نوع الحدث الذي أطلقه المستخدم';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'مُعرَّف الجلسة التي وصل إليها المستخدم';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'معلومات إضافية عن الجلسة أو التسجيل.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'الوقت الذي تم فيه إنشاء سجل الوقوعات';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'مُعرَّف المستخدم الذي أثار الحدث';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'يخزن البيانات الوصفية للتسجيلات';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'مُعرَّف المستخدم الذي أجرى آخر تغيير في التسجيل';
$string['progress_createbigbluebuttonbn'] = 'يجري إنشاء نشاط BigBlueButton ({$a})';
$string['recordings_from_deleted_activities'] = 'التسجيلات من النشاطات المحذوفة';
$string['recordingurlnotfound'] = 'عنوان رابط الاجتماع غير صالح.';
$string['removedevents'] = 'الأحداث المحذوفة';
$string['removedlogs'] = 'سجلات الوقوعات المخصصة المحذوفة';
$string['removedrecordings'] = 'التسجيلات المحذوفة';
$string['removedtags'] = 'الوسوم المحذوفة';
$string['report_join_info'] = '{$a} من الاجتماعات';
$string['report_play_recording_info'] = '{$a} من التسجيلات المشغلة';
$string['report_room_view'] = 'قد عاين';
$string['resetevents'] = 'حذف الأحداث';
$string['resetlogs'] = 'حذف سجلات الوقوعات المخصصة';
$string['resetlogs_help'] = 'سيؤدي حذف سجلات الوقوعات إلى فقدان المراجع إلى التسجيلات';
$string['resetrecordings'] = 'حذف التسجيلات';
$string['resetrecordings_help'] = 'سيؤدي حذف التسجيلات إلى عدم إمكانية الوصول إليها من أي مكان. لا يمكن التراجع عن هذا الإجراء!';
$string['resettags'] = 'حذف الوسوم';
$string['search:activity'] = 'BBB - معلومات النشاط';
$string['search:tags'] = 'BBB - معلومات الوسوم';
$string['sendnotification'] = 'إرسال الإشعار';
$string['settings'] = 'إعدادات BigBlueButton';
$string['started_at'] = 'بدأت';
$string['starts_at'] = 'تبدأ';
$string['taskname:check_dismissed_recordings'] = 'تحقق من وجود تسجيلات لم يُعثر عليها بعد';
$string['taskname:check_pending_recordings'] = 'إحضار التسجيلات التي قيد الانتظار';
$string['userlimitreached'] = 'وصلنا إلى العدد الأقصى للمستخدمين المسموح بهم في الجلسة.';
$string['view_conference_action_end'] = 'إنهاء الجلسة';
$string['view_conference_action_join'] = 'انضم إلى الجلسة';
$string['view_error_action_not_completed'] = 'تعذر إكمال الإجراء';
$string['view_error_bigbluebutton'] = 'استجاب BigBlueButton مع وجود أخطاء. {$a}';
$string['view_error_create'] = 'استجاب مخدم BBB برسالة خطأ، وتعذر إنشاء الاجتماع. تعذر إنشاء الغرفة.';
$string['view_error_current_state_not_found'] = 'لم يتم العثور على الحالة الحالية. ربما تم حذف التسجيل أو أن مخدم غرف اجتماعات BBB غير متوافق مع الإجراء المنفذ.';
$string['view_error_import_no_courses'] = 'لا توجد مقررات دراسية للبحث فيها عن التسجيلات.';
$string['view_error_import_no_recordings'] = 'لا توجد تسجيلات في هذا المقرر لاستيرادها.';
$string['view_error_invalid_session'] = 'انتهت الجلسة. إرجع إلى صفحة النشاط.';
$string['view_error_max_concurrent'] = 'تم الوصول إلى أقصى عدد مسموح به من الجلسات المتزامنة.';
$string['view_error_meeting_not_running'] = 'هناك خطأ ما، الجلسة ليست شغالة.';
$string['view_error_no_group'] = 'ليست هناك مجموعات. أنت بحاجة إلى إنشاء بعض المجموعات قبل محاولة الانضمام إلى الجلسة.';
$string['view_error_no_group_student'] = 'لم تتم إضافتك إلى أي مجموعة. يرجى التواصل مع معلمك.';
$string['view_error_no_group_teacher'] = 'ليست هناك مجموعات. أنت بحاجة إلى إنشاء بعض المجموعات';
$string['view_error_unable_join'] = 'تعذر دخول الغرفة. يرجى التحقق من عنوان الرابط لمخدم غرف اجتماعات BBB والتحقق لمعرفة ما إذا كان المخدم قيد التشغيل.';
$string['view_error_unable_join_student'] = 'تعذر الاتصال بمخدم BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'تعذر الاتصال بمخدم BigBlueButton. يرجى الاتصال بالمشرف.';
$string['view_error_url_missing_parameters'] = 'هناك معاملات مفقودة في عنوان الرابط هذا';
$string['view_error_userlimit_reached'] = 'لقد تم الوصول إلى العدد المسموح به من المستخدمين في الجلسة.';
$string['view_groups_nogroups_warning'] = 'لقد تمت تهيئة الغرفة لاستعمال المجموعات ولكن لم يتم تعريف أي منها في المقرر.';
$string['view_groups_notenrolled_warning'] = 'لقد تمت تهيئة الغرفة لاستعمال المجموعات ولكنك لست عضوًا في أي منها.';
$string['view_groups_selection'] = 'حدد المجموعة التي تريد الانضمام إليها وقم بتأكيد الإجراء';
$string['view_groups_selection_join'] = 'إنضم';
$string['view_groups_selection_warning'] = 'توجد غرفة لكل مجموعة، ويمكنك الوصول إلى أكثر من غرفة. تأكد من اختيارك للغرفة الصحيحة.';
$string['view_login_moderator'] = 'الدخول بصفة مشرف ...';
$string['view_login_viewer'] = 'تسجيل الدخول كمشاهد ...';
$string['view_message_and'] = 'و';
$string['view_message_conference_has_ended'] = 'الجلسة انتهت.';
$string['view_message_conference_in_progress'] = 'الجلسة جارية.';
$string['view_message_conference_not_started'] = 'الجلسة لم تبدأ بعد.';
$string['view_message_conference_room_ready'] = 'هذه الغرفة جاهزة. يمكنك الانضمام إليها الآن.';
$string['view_message_conference_user_limit_reached'] = 'لقد تم الوصول إلى العدد المسموح به من المستخدمين في الجلسة.';
$string['view_message_conference_wait_for_moderator'] = 'بانتظار انضمام مشرف الجلسة';
$string['view_message_cron_disabled'] = 'قائمة التسجيلات قد لا تكون حديثة. يرجى التواصل مع مشرف الموقع في ضوء المعلومات الآتية: {$a}';
$string['view_message_finished'] = 'هذا النشاط قد انتهى.';
$string['view_message_has_joined'] = 'قد انضم';
$string['view_message_have_joined'] = 'قد انضموا';
$string['view_message_hour'] = 'ساعة';
$string['view_message_hours'] = 'ساعات';
$string['view_message_importrecordings_disabled'] = 'تم تعطيل ميزة استيراد روابط التسجيل في المخدم.';
$string['view_message_minute'] = 'دقيقة';
$string['view_message_minutes'] = 'دقائق';
$string['view_message_moderator'] = 'المشرف';
$string['view_message_moderators'] = 'المشرفون';
$string['view_message_norecordings'] = 'ليست هناك تسجيلات متاحة.';
$string['view_message_notavailableyet'] = 'هذه الجلسة غير متاحة بعد.';
$string['view_message_recordings_disabled'] = 'تم تعطيل التسجيلات في المخدم. لا يمكن استعمال نشاطات BBB من نوع \'التسجيلات فقط\'.';
$string['view_message_room_closed'] = 'هذه الغرفة مغلقة.';
$string['view_message_room_open'] = 'هذه الغرفة مفتوحة.';
$string['view_message_room_ready'] = 'هذه الغرفة جاهزة.';
$string['view_message_session_for'] = 'الجلسة من';
$string['view_message_session_has_user'] = 'يوجد';
$string['view_message_session_has_users'] = 'يوجد';
$string['view_message_session_no_users'] = 'لا يوجد مستخدمون في هذه الجلسة';
$string['view_message_session_running_for'] = 'هذه الجلسة مستمرة لمدة';
$string['view_message_session_started_at'] = 'هذه الجلسة بدأت في';
$string['view_message_tab_close'] = 'ينبغي إغلاق هذا التبويب/النافذة يدويًا';
$string['view_message_times'] = 'الأوقات';
$string['view_message_user'] = 'المستخدم';
$string['view_message_users'] = 'المستخدمون';
$string['view_message_viewer'] = 'المشاهد';
$string['view_message_viewers'] = 'المشاهدون';
$string['view_mobile_message_groups_not_supported'] = 'تم تمكين هذا المثيل للعمل مع المجموعات، ولكن لا يدعم تطبيق الجوال ذلك بعد. يرجى فتحه من إصدار الويب لسطح المكتب.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'لقد تجاوزت 45 ثانية في هذه الصفحة، يرجى إعادة تحميلها للانضمام إلى الجلسة.';
$string['view_noguests'] = 'غرفة BBB غير مفتوحة للضيوف.';
$string['view_nojoin'] = 'لا تمتلك دورًا يسمح لك بالانضمام إلى الجلسة.';
$string['view_recording'] = 'التسجيل';
$string['view_recording_actionbar'] = 'شريط الأدوات';
$string['view_recording_activity'] = 'النشاط';
$string['view_recording_button_import'] = 'استيراد روابط التسجيلات';
$string['view_recording_button_return'] = 'عودة';
$string['view_recording_course'] = 'المقرر';
$string['view_recording_date'] = 'التاريخ';
$string['view_recording_delete_confirmation'] = 'هل أنت متأكد من رغبتك في حذف {$a}؟';
$string['view_recording_delete_confirmation_warning_p'] = 'لدى هذا التسجيل {$a} من الروابط التي تم استيرادها إلى مقررات دراسية أو نشاطات مختلفة. إذا تم حذف التسجيل، ستتم إزالة تلك الروابط أيضًا.';
$string['view_recording_delete_confirmation_warning_s'] = 'لدى هذا التسجيل {$a} رابط تم استيراده إلى مساق أو نشاط مختلف. إذا تم حذف التسجيل، ستتم إزالة ذلك الرابط أيضًا.';
$string['view_recording_description'] = 'الوصف';
$string['view_recording_description_edithint'] = 'بالإمكان إضافة وصف للمساعدة في التعرف على التسجيل.';
$string['view_recording_description_editlabel'] = 'تحرير الوصف';
$string['view_recording_duration'] = 'المدة';
$string['view_recording_duration_min'] = 'دقيقة';
$string['view_recording_format_errror_unreachable'] = 'يتعذر الوصول إلى عنوان الرابط لتنسيق التسجيل هذا.';
$string['view_recording_format_notes'] = 'الملاحظات';
$string['view_recording_format_podcast'] = 'التسجيل الصوتي';
$string['view_recording_format_presentation'] = 'العرض';
$string['view_recording_format_screenshare'] = 'مشاركة الشاشة';
$string['view_recording_format_statistics'] = 'الإحصائيات';
$string['view_recording_format_video'] = 'الفيديو';
$string['view_recording_import_confirmation'] = 'هل أنت متأكد من رغبتك في استيراد هذا التسجيل؟';
$string['view_recording_length'] = 'الطول';
$string['view_recording_link'] = 'الرابط المستورد';
$string['view_recording_link_warning'] = 'هذا رابط يشير إلى تسجيل تم إنشاؤه في مساق أو نشاط مختلف.';
$string['view_recording_list_action_delete'] = 'الحذف';
$string['view_recording_list_action_edit'] = 'التحديث';
$string['view_recording_list_action_play'] = 'التشغيل';
$string['view_recording_list_action_process'] = 'تجري المعالجة';
$string['view_recording_list_action_protect'] = 'الحماية';
$string['view_recording_list_action_publish'] = 'النشر';
$string['view_recording_list_action_unprotect'] = 'إلغاء الحماية';
$string['view_recording_list_action_unpublish'] = 'إلغاء النشر';
$string['view_recording_list_action_update'] = 'التحديث';
$string['view_recording_list_actionbar'] = 'شريط الأدوات';
$string['view_recording_list_actionbar_delete'] = 'إحذف';
$string['view_recording_list_actionbar_edit'] = 'تحرير';
$string['view_recording_list_actionbar_hide'] = 'إخفاء';
$string['view_recording_list_actionbar_import'] = 'استيراد';
$string['view_recording_list_actionbar_protect'] = 'إجعلها خاصة';
$string['view_recording_list_actionbar_publish'] = 'النشر';
$string['view_recording_list_actionbar_show'] = 'إظهار';
$string['view_recording_list_actionbar_unprotect'] = 'إجعلها عامة';
$string['view_recording_list_actionbar_unpublish'] = 'إلغاء النشر';
$string['view_recording_list_activity'] = 'النشاط';
$string['view_recording_list_course'] = 'المقرر';
$string['view_recording_list_date'] = 'التاريخ';
$string['view_recording_list_description'] = 'الوصف';
$string['view_recording_list_duration'] = 'المدة';
$string['view_recording_list_recording'] = 'التسجيل';
$string['view_recording_meeting'] = 'الاجتماع';
$string['view_recording_modal_button'] = 'تطبيق';
$string['view_recording_modal_title'] = 'تعيين القيم للتسجيل';
$string['view_recording_name'] = 'الاسم';
$string['view_recording_name_edithint'] = 'يمكن إضافة اسم للمساعدة في التعرف على التسجيل.';
$string['view_recording_name_editlabel'] = 'تحرير الاسم';
$string['view_recording_playback'] = 'تشغيل';
$string['view_recording_preview'] = 'معاينة';
$string['view_recording_preview_help'] = 'قم بالمرور فوق الصورة لمشاهدتها بالحجم الكامل';
$string['view_recording_protect_confirmation'] = 'هل أنت متأكد من رغبتك في حماية {$a} هذا ؟';
$string['view_recording_protect_confirmation_warning_p'] = 'يحتوي هذا التسجيل على روابط {$a} متعلقة به سبق وأن تم استيرادها إلى مقررات دراسية أو نشاطات مختلفة. إذا كان التسجيل محميًا فسيؤثر هذا أيضًا على الروابط المستوردة.';
$string['view_recording_protect_confirmation_warning_s'] = 'يحتوي هذا التسجيل على رابط {$a} متعلق به سبق وأن تم استيراده إلى مساق أو نشاط مختلف. إذا كان التسجيل محميًا فسيؤثر هذا أيضًا على الروابط المستوردة.';
$string['view_recording_publish_confirmation'] = 'هل أنت متأكد من رغبتك في نشر {$a} هذا؟';
$string['view_recording_publish_confirmation_warning_p'] = 'يحتوي هذا التسجيل على روابط {$a} متعلقة به سبق وأن تم استيرادها إلى مقررات دراسية أو نشاطات مختلفة. إذا كان التسجيل منشورًا فستصير تلك الروابط منشورة أيضًا.';
$string['view_recording_publish_confirmation_warning_s'] = 'يحتوي هذا التسجيل على رابط {$a} متعلق به سبق وأن تم استيراده إلى مساق أو نشاط مختلف. إذا كان التسجيل منشورًا فسيصير ذلك الرابط منشورًا أيضًا';
$string['view_recording_publish_link_deleted'] = 'لا يمكن إعادة نشر هذا الرابط لأن التسجيل الفعلي غير موجود في مخدم BBB. يجب إزالة الرابط.';
$string['view_recording_publish_link_not_published'] = 'لا يمكن إعادة نشر الرابط لأن التسجيل الفعلي ليس منشورًا.';
$string['view_recording_recording'] = 'التسجيل';
$string['view_recording_select_course'] = 'إختر المقرر أولاً في الائمة المنسدلة';
$string['view_recording_tags'] = 'الوسوم';
$string['view_recording_unprotect_confirmation'] = 'هل أنت متأكد من رغبتك في إلغاء حماية {$a} هذا؟';
$string['view_recording_unprotect_confirmation_warning_p'] = 'يحتوي هذا التسجيل على روابط {$a} متعلقة به سبق وأن تم استيرادها إلى مساقات أو نشاطات مختلفة. إذا كان التسجيل غير محمي فسيؤثر هذا أيضًا على الروابط المستوردة.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'يحتوي هذا التسجيل على رابط {$a} متعلق به سبق وأن تم استيراده إلى مساق أو نشاط مختلف. إذا كان التسجيل غير محمي فسيؤثر هذا أيضًا على الروابط المستوردة.';
$string['view_recording_unprotect_link_deleted'] = 'لا يمكن إلغاء حماية هذا الرابط لأن التسجيل الفعلي غير موجود في مخدم BBB. يجب إزالة الرابط.';
$string['view_recording_unprotect_link_not_unprotected'] = 'لا يمكن إلغاء الحماية عن هذا الرابط لأن التسجيل الفعلي محمي.';
$string['view_recording_unpublish_confirmation'] = 'هل أنت متأكد من رغبتك في إلغاء نشر {$a}؟';
$string['view_recording_unpublish_confirmation_warning_p'] = 'لدى هذا التسجيل {$a} من الروابط التي تم استيرادها إلى مساقات أو نشاطات مختلفة. إذا تم إلغاء نشر التسجيل، سيتم إلغاء نشر تلك الروابط أيضًا.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'لدى هذا التسجيل {$a} رابط تم استيراده إلى مساق أو نشاط مختلف. إذا تم إلغاء نشر التسجيل، سيتم إلغاء نشر ذلك الرابط أيضًا.';
$string['view_recording_yui_first'] = 'الأول';
$string['view_recording_yui_go'] = 'إذهب';
$string['view_recording_yui_last'] = 'الأخير';
$string['view_recording_yui_next'] = 'التالي';
$string['view_recording_yui_page'] = 'الصفحة';
$string['view_recording_yui_prev'] = 'السابق';
$string['view_recording_yui_rows'] = 'الصفوف';
$string['view_recording_yui_show_all'] = 'إظهار الكل';
$string['view_room'] = 'معاينة الغرفة';
$string['view_section_title_presentation'] = 'ملف العرض';
$string['view_section_title_recordings'] = 'التسجيلات';
$string['view_warning_default_server'] = 'يستعمل هذا الموقع <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">خدمة BigBlueButton مجانية لمودل (يُفتح بنافذة جديدة)</a> مقدم من قبل Blindside Networks مع التقييدات الآتية:
<ol>
<li>أقصى مدة لكل جلسة هي 60 دقيقة</li>
<li>أقصى عدد من المستخدمين المتزامنين لكل جلسة هو 25</li>
<li>تنتهي صلاحية التسجيلات بعد (7) سبعة أيام ولا يمكن تنزيلها</li>
<li>كامرات الويب للطلاب مرئية فقط من جانب المشرف.</li>
</ol>';
$string['waitformoderator'] = 'بانتظار المشرف لينضم.';
